# Contributing
Contributions are **welcome**!

We accept contributions via Pull Requests on [Github](https://github.com/axlon/laravel-postal-code-validation).

## Guidelines
- **Create an issue first** - This will make sure you don't waste your time building something that won't be merged
- **[PSR-2 Coding Standard](https://www.php-fig.org/psr/psr-2/)** - The easiest way to apply the conventions is to install [PHP Code Sniffer](http://pear.php.net/package/PHP_CodeSniffer)
- **Document any change in behaviour** - Make sure the `README.md` and any other relevant documentation are kept up to date
- **Add tests** - Any significant change in the codebase should include tests
- **Create feature branches** - Pull requests from your master branch won't be accepted
- **Consider our release cycle** - We try to follow [SemVer v2.0.0](http://semver.org/), randomly breaking public APIs is not an option
- **One pull request per feature** - If you want to do more than one thing, create multiple pull requests
- **Send coherent history** - Make sure each individual commit in your pull request is meaningful. If you had to make multiple intermediate commits while developing, please [squash them](http://www.git-scm.com/book/en/v2/Git-Tools-Rewriting-History#Changing-Multiple-Commit-Messages) before submitting
