<!doctype html>
<html class="no-js" lang="en">
<head>
  <title><?php echo e($title); ?> - <?php echo e($set->site_name); ?></title>
  <meta charset="utf-8" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />
  <meta name="robots" content="index, follow">
  <meta name="apple-mobile-web-app-title" content="<?php echo e($set->site_name); ?>" />
  <meta name="application-name" content="<?php echo e($set->site_name); ?>" />
  <meta name="description" content="<?php echo e($set->site_desc); ?>" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
  <link rel="shortcut icon" href="<?php echo e(asset('asset/images/favicon.png')); ?>" />
  <link href="<?php echo e(asset('asset/fonts/fontawesome/css/all.css')); ?>" rel="stylesheet" type="text/css">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet"> 
  <link href="<?php echo e(asset('dashboard/plugins/global/plugins.bundle.css')); ?>" rel="stylesheet" type="text/css" />
  <link href="<?php echo e(asset('dashboard/css/style.bundle.css')); ?>" rel="stylesheet" type="text/css" />
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/gh/lipis/flag-icons@6.6.6/css/flag-icons.min.css" />
  <?php echo \Livewire\Livewire::styles(); ?>

  <?php echo $__env->yieldContent('css'); ?>
  <?php echo $__env->make('partials.font', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</head>

<body id="kt_body" class="bg-white header-fixed header-tablet-and-mobile-fixed toolbar-enabled aside-fixed aside-default-enabled">
  <div class="page-loading active text-indigo">
    <div class="page-loading-inner">
      <div class="page-spinner"></div><span></span>
    </div>
  </div>

  <div class="row">
    <div class="col-md-6 offset-md-3">
      <?php echo $__env->yieldContent('content'); ?>
    </div>
  </div>

  <div class="d-flex flex-column flex-root">
    <div class="d-flex flex-column flex-lg-row flex-column-fluid"></div>
  </div>

  <?php echo $set->livechat; ?>

  <?php echo $set->analytic_snippet; ?>


  <script src="<?php echo e(asset('dashboard/plugins/global/plugins.bundle.js')); ?>"></script>
  <script src="<?php echo e(asset('dashboard/js/scripts.bundle.js')); ?>"></script>
  <script src="<?php echo e(asset('asset/fonts/fontawesome/js/all.js')); ?>"></script>
  <script src="<?php echo e(asset('dashboard/js/custom/general.js')); ?>"></script>
  <?php echo \Livewire\Livewire::scripts(); ?>

  <?php echo $__env->yieldContent('script'); ?>

  <?php if(session('success')): ?>
  <script>
    toastr.options = { positionClass: 'toast-bottom-right', closeButton: true };
    toastr.success("<?php echo session('success'); ?>");
  </script>
  <?php endif; ?>

  <?php if(session('alert')): ?>
  <script>
    toastr.options = { positionClass: 'toast-bottom-right', closeButton: true };
    toastr.warning("<?php echo session('alert'); ?>");
  </script>
  <?php endif; ?>

  <?php if($set->recaptcha): ?>
    <?php echo RecaptchaV3::initJs(); ?>

  <?php endif; ?>

  <script>
    window.onload = function () {
      const preloader = document.querySelector('.page-loading');
      preloader.classList.remove('active');
      setTimeout(() => preloader.remove(), 1000);
    };
  </script>
</body>
</html><?php /**PATH /home/nexvestg/app.cenfibull.com/resources/views/auth/menu.blade.php ENDPATH**/ ?>