<?php $__env->startSection('content'); ?>
<div class="toolbar" id="kt_toolbar">
    <div class="container-fluid d-flex flex-stack flex-wrap flex-sm-nowrap">
        <div class="d-flex flex-column align-items-start justify-content-center flex-wrap me-2">
            <h1 class="text-dark fw-bolder my-1 fs-2 mb-6"><?php echo e(__('Email')); ?></h1>
            <ul class="nav nav-tabs nav-line-tabs nav-line-tabs-2x mb-5 fs-6 border-gray-300" id="tabs-icons-text" role="tablist">
                <li class="nav-item">
                    <a class="nav-link text-dark <?php if(route('email.settings', ['type' => 'settings'])==url()->current()): ?> active <?php endif; ?>" id="tabs-icons-text-1-tab" href="<?php echo e(route('email.settings', ['type' => 'settings'])); ?>" role="tab" aria-controls="tabs-icons-text-1" aria-selected="true"><?php echo e(__('Configuration')); ?></a>
                </li>
                <li class="nav-item">
                    <a class="nav-link text-dark <?php if(route('email.settings', ['type' => 'template'])==url()->current()): ?> active <?php endif; ?>" id="tabs-icons-text-2-tab" href="<?php echo e(route('email.settings', ['type' => 'template'])); ?>" role="tab" aria-controls="tabs-icons-text-2" aria-selected="false"><?php echo e(__('Template')); ?></a>
                </li>
            </ul>
        </div>
    </div>
    <div class="post fs-6 d-flex flex-column-fluid min-vh-100" id="kt_post">
        <div class="container">
            <div class="tab-content" id="myTabContent">
                <div class="tab-pane fade <?php if(route('email.settings', ['type' => 'settings'])==url()->current()): ?>show active <?php endif; ?>" id="tabs-icons-text-1" role="tabpanel" aria-labelledby="tabs-icons-text-1-tab">
                    <div class="card mb-10">
                        <div class="card-body">
                            <h5><?php echo e(__('SMTP Credentials')); ?></h5>
                            <p class="mb-1">Table shows value of your env email configuration, ensure what is dispalyed here matches your email service smtp configuration, if it doesn't, navigate to .env file to edit this</p>
                            <div class="table-responsive mb-5">
                                <table class="table table-bordered">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>PARAMETER</th>
                                            <th>VALUE</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td> 1 </td>
                                            <td> MAIL_HOST</td>
                                            <td> <?php echo e(env('MAIL_HOST')); ?></td>
                                        </tr>
                                        <tr>
                                            <td> 2 </td>
                                            <td> MAIL_PORT </td>
                                            <td> <?php echo e(env('MAIL_PORT')); ?></td>
                                        </tr>
                                        <tr>
                                            <td> 3 </td>
                                            <td> MAIL_USERNAME </td>
                                            <td> <?php echo e(env('MAIL_FROM_ADDRESS')); ?></td>
                                        </tr>
                                        <tr>
                                            <td> 4 </td>
                                            <td> MAIL_PASSWORD </td>
                                            <td> <?php echo e(env('MAIL_PASSWORD')); ?></td>
                                        </tr>
                                        <tr>
                                            <td> 5 </td>
                                            <td> MAIL_ENCRYPTION </td>
                                            <td> <?php echo e(env('MAIL_ENCRYPTION')); ?></td>
                                        </tr>
                                        <tr>
                                            <td> 6 </td>
                                            <td> MAIL_FROM_ADDRESS </td>
                                            <td> <?php echo e(env('MAIL_FROM_ADDRESS')); ?></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="card mb-10">
                        <div class="card-body">
                            <form action="<?php echo e(route('admin.settings.update', ['type' => 'system'])); ?>" method="post">
                                <?php echo csrf_field(); ?>
                                <h5>Template Configuration</h5>
                                <div class="table-responsive mb-5">
                                    <table class="table table-bordered">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>CODE</th>
                                                <th>DESCRIPTION</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td> 1 </td>
                                                <td> &#123;&#123;message&#125;&#125;</td>
                                                <td> Details Text From the Script</td>
                                            </tr>
                                            <tr>
                                                <td> 2 </td>
                                                <td> &#123;&#123;logo&#125;&#125; </td>
                                                <td> Platform logo. Will be Pulled From Database</td>
                                            </tr>
                                            <tr>
                                                <td> 3 </td>
                                                <td> &#123;&#123;site_name&#125;&#125; </td>
                                                <td> Website Name. Will be Pulled From Database</td>
                                            </tr>
                                            <tr>
                                                <td> 4 </td>
                                                <td> &#123;&#123;unsubscribe&#125;&#125; </td>
                                                <td> Unsubscribe link for promotional emails. Will be Pulled From Database</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="fv-row mb-6 mb-6">
                                    <div class="col-lg-12">
                                        <textarea type="text" name="email_template" rows="4" class="form-control tinymce"><?php echo e($set->email_template); ?></textarea>
                                    </div>
                                </div>
                                <div class="text-end">
                                    <button type="submit" class="btn btn-primary"><?php echo e(__('Save')); ?></button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="tab-pane fade <?php if(route('email.settings', ['type' => 'template'])==url()->current()): ?>show active <?php endif; ?>" id="tabs-icons-text-2" role="tabpanel" aria-labelledby="tabs-icons-text-2-tab">
                    <div class="card mb-10">
                        <div class="card-body">
                            <?php $__currentLoopData = $admin->emailTemplate(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <form action="<?php echo e(route('email.template.settings', ['type' => $val->type])); ?>" method="post">
                                <?php echo csrf_field(); ?>
                                <p class="fs-5 text-dark fw-bold"><?php echo e($val->type); ?></p>
                                <div class="fv-row mb-6">
                                    <label class="form-label fs-6 fw-bolder text-dark"><?php echo e(__('Subject')); ?></label>
                                    <input type="text" name="subject" class="form-control form-control-lg form-control-solid" value="<?php echo e($val->subject); ?>">
                                </div>
                                <div class="fv-row mb-6">
                                    <label class="form-label fs-6 fw-bolder text-dark"><?php echo e(__('Body')); ?></label>
                                    <textarea type="text" name="body" rows="10" class="form-control form-control-lg form-control-solid tinymce"><?php echo e($val->body); ?></textarea>
                                </div>
                                <div class="text-end">
                                    <button type="submit" class="btn btn-lg btn-primary fw-bolder me-3 my-2"><?php echo e(__('Update')); ?></a>
                                </div>
                            </form>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script src="<?php echo e(asset('asset/tinymce/init-tinymce.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nexvestg/app.cenfibulls.com/resources/views/admin/settings/email.blade.php ENDPATH**/ ?>