<div>
    <div wire:ignore.self class="modal fade" id="filter" tabindex="-1" role="dialog" aria-labelledby="modal-form" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title"><?php echo e(__('Filter')); ?></h3>
                    <div class="btn btn-icon btn-sm btn-active-light-primary ms-2" data-bs-dismiss="modal" aria-label="Close">
                        <span class="svg-icon svg-icon-1">
                            <i class="fal fa-times"></i>
                        </span>
                    </div>
                </div>
                <div class="modal-body">
                    <div class="fv-row mb-6">
                        <label class="form-label fs-6 fw-bolder text-dark"><?php echo e(__('Sort by')); ?></label>
                        <select class="form-select form-select-solid" wire:model="sortBy">
                            <option value="asc"><?php echo e(__('ASC')); ?></option>
                            <option value="desc"><?php echo e(__('DESC')); ?></option>
                        </select>
                    </div>
                    <div class="fv-row mb-6">
                        <label class="form-label fs-6 fw-bolder text-dark"><?php echo e(__('Order by')); ?></label>
                        <select class="form-select form-select-solid" wire:model="orderBy">
                            <option value="interest"><?php echo e(__('Interest')); ?></option>
                            <option value="start_date"><?php echo e(__('Start Date')); ?></option>
                            <option value="close_date"><?php echo e(__('Close Date')); ?></option>
                            <option value="original"><?php echo e(__('Units')); ?></option>
                            <option value="duration"><?php echo e(__('Duration')); ?></option>
                            <option value="created_at"><?php echo e(__('Date')); ?></option>
                        </select>
                    </div>
                    <div class="fv-row mb-6">
                        <label class="form-label fs-6 fw-bolder text-dark"><?php echo e(__('Per page')); ?></label>
                        <select class="form-select form-select-solid" wire:model="perPage">
                            <option value="10"><?php echo e(__('10')); ?></option>
                            <option value="25"><?php echo e(__('25')); ?></option>
                            <option value="50"><?php echo e(__('50')); ?></option>
                            <option value="100"><?php echo e(__('100')); ?></option>
                        </select>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row g-xl-8 mb-6">
        <div class="col-md-8">
            <div class="d-flex flex-column align-items-start justify-content-center flex-wrap me-2">
                <div class="input-group input-group-solid mb-5 rounded-4">
                    <span class="input-group-text" id="basic-addon1"><i class="fal fa-search"></i></span>
                    <input type="search" class="form-control form-control-solid text-dark" wire:model="search" placeholder="<?php echo e(__('Search plans')); ?>" />
                </div>
            </div>
        </div>
        <div class="col-md-4 text-end">
            <button data-bs-toggle="modal" data-bs-target="#filter" class="btn btn-dark me-4"><i class="fal fa-filter-list"></i> <?php echo e(__('Filter')); ?></button>
        </div>
    </div>
  
    <?php if($plans->count() > 0): ?>
    <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="card mb-9 cursor-pointer rounded-5" data-href="<?php echo e(route('view.plan', ['plan' => $val->id, 'type' => 'details'])); ?>">
        <div class="card-body pt-9 pb-0 dd-bg">
            <div class="d-flex flex-wrap flex-sm-nowrap mb-6">
                <div class="symbol symbol-150px me-7 mb-4 symbol-circle">
                    <span class="symbol-label" style="background-image:url(<?php echo e(url('/').'/storage/app/'.$val->image); ?>);"></span>
                </div>
                <div class="flex-grow-1">
                   
                    <div class="d-flex justify-content-between align-items-start flex-wrap mb-2">
                        <div class="d-flex flex-column">
                            <p class="text-dark fs-1 fw-boldest me-3 mb-0"><?php echo e(substr($val->name, 0, 30)); ?><?php echo e((Str::length($val->name) > 30) ? '...' : ''); ?></p>
                            
                            <p class="text-gray-800 fs-5 me-3 mb-3"><?php echo e($val->location); ?></p>
                            <p>
                                <span class="badge badge-light-primary"><?php echo e($val->category->name); ?></span>
                                <span class="badge badge-light-primary"><?php echo e($val->duration.' Months'); ?></span>
                                <span class="badge badge-light-primary"><?php echo e(($val->status == 1) ? 'Published' : 'Disabled'); ?></span>
                                <span class="badge badge-light-primary"><?php echo e(($val->insurance == 1) ? 'Insured' : 'No Insurance'); ?></span>
                            </p>
                            

                        </div>
                        
                    </div>
                   
                    
                    
                    
                    <div class="d-flex flex-wrap justify-content-start">
                        <div class="border border-gray-600 border-dashed rounded min-w-125px py-3 px-4 me-6 mb-3">
                            <div class="fs-6 fw-boldest text-gray-700"><?php echo e(\Carbon\Carbon::create($val->start_date)->format('M j, Y')); ?> - <?php echo e(\Carbon\Carbon::create($val->close_date)->format('M j, Y')); ?></div>
                            <div class="fw-bold text-gray-400">Investment Closure</div>
                        </div>
                        <div class="border border-gray-600 border-dashed rounded min-w-125px py-3 px-4 me-6 mb-3">
                            <div class="fs-6 fw-boldest text-gray-700"><?php echo e(\Carbon\Carbon::create($val->expiring_date)->format('M j, Y')); ?></div>
                            <div class="fw-bold text-gray-400">Matures</div>
                        </div>
                        <div class="border border-gray-600 border-dashed rounded min-w-125px py-3 px-4 me-6 mb-3">
                            <div class="fs-6 fw-boldest text-gray-700"><?php echo e(currencyFormat(number_format($val->original - $val->units).'/'.number_format($val->original))); ?> units</div>
                            <div class="fw-bold text-gray-400"><?php echo e($currency->currency_symbol.$val->price); ?> per unit</div>
                        </div>
                        <div class="border border-gray-600 border-dashed rounded min-w-125px py-3 px-4 me-6 mb-3">
                            <div class="fs-6 fw-boldest text-gray-700"><?php echo e($val->interest); ?>%</div>
                            <div class="fw-bold text-gray-400">Interest</div>
                        </div>
                        <div class="border border-gray-600 border-dashed rounded min-w-125px py-3 px-4 me-6 mb-3">
                            <div class="fs-6 fw-boldest text-gray-700">
                                <?php if($val->fee_type == "both"): ?>
                                <?php echo e($val->percent_pc); ?>% + <?php echo e($val->fiat_pc.' '.$currency->currency); ?>

                                <?php elseif($val->fee_type == "fiat"): ?>
                                <?php echo e($val->fiat_pc.' '.$currency->currency); ?>

                                <?php elseif($val->fee_type == "percent"): ?>
                                <?php echo e($val->percent_pc); ?>%
                                <?php elseif($val->fee_type == "max"): ?>
                                > <?php echo e($val->fiat_pc.' '.$currency->currency); ?> - <?php echo e($val->percent_pc); ?>%
                                <?php elseif($val->fee_type == "min"): ?>
                                < <?php echo e($val->fiat_pc.' '.$currency->currency); ?> - <?php echo e($val->percent_pc); ?>% <?php endif; ?> 
                            </div>
                            <div class="fw-bold text-gray-400">Mtg Fee</div>
                        </div>
                    </div>
               
                </div>
                    
            </div>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php if($plans->total() > 0 && $plans->count() < $plans->total()): ?><button wire:click="loadMore" wire:loading.remove class="btn btn-secondary btn-block"><?php echo e(__('See more')); ?></button><?php endif; ?>
            <?php else: ?>
            <div class="text-center mt-20">
                <img src="<?php echo e(asset('asset/images/beneficiary.png')); ?>" style="height:auto; max-width:250px;" class="mb-6">
                <h3 class="text-dark"><?php echo e(__('No Investment Plan Found')); ?></h3>
                <p class="text-dark"><?php echo e(__('We couldn\'t find any investment plan ')); ?></p>
            </div>
            <?php endif; ?>
    </div>
</div><?php /**PATH /home/nexvestg/app.cenfibulls.com/resources/views/livewire/plans/project.blade.php ENDPATH**/ ?>