<div>

    <div class="toolbar pb-0" id="kt_toolbar" wire:ignore>
        <div class="container-fluid d-flex flex-stack flex-wrap flex-sm-nowrap">
            <div class="d-flex flex-column align-items-start justify-content-center flex-wrap me-2">
                <h1 class="text-dark fw-bolder my-1 fs-2"><?php echo e(__('Invest')); ?></h1>
                <ul class="breadcrumb fw-semibold fs-base my-1 mb-6">
                    <li class="breadcrumb-item text-muted">
                        <a href="<?php echo e(route('user.dashboard')); ?>" class="text-muted text-hover-primary"><?php echo e(__('Dashboard')); ?></a>
                    </li>
                    <li class="breadcrumb-item text-muted">
                        <a href="<?php echo e(route('user.plan')); ?>" class="text-muted text-hover-primary"><?php echo e(__('Invest')); ?></a>
                    </li>
                    <li class="breadcrumb-item text-muted">
                        <a href="<?php echo e(route('user.project', ['type' => 'active'])); ?>" class="text-muted text-hover-primary"><?php echo e(__('Plans')); ?></a>
                    </li>
                    <li class="breadcrumb-item text-dark"><?php echo e(ucwords($plan->name)); ?></li>
                </ul>
            </div>
            <div class="d-flex align-items-center flex-nowrap text-nowrap py-1">
                <?php if($plan->units>0 && $plan->start_date <= Carbon\Carbon::now()->toDateTimeLocalString() && $plan->expiring_date > Carbon\Carbon::now()->toDateTimeLocalString()): ?>
                    <?php if($plan->close_date >= Carbon\Carbon::now()->toDateTimeLocalString()): ?>
                    <button id="kt_send_money_button" class="btn btn-dark me-4"><i class="fal fa-fire"></i> <?php echo e(__('Invest Now')); ?></button>
                    <div wire:ignore.self id="kt_send_money" class="bg-white" data-kt-drawer="true" data-kt-drawer-activate="true" data-kt-drawer-toggle="#kt_send_money_button" data-kt-drawer-close="#kt_send_money_close" data-kt-drawer-width="{'md': '500px'}">
                        <div class="card w-100">
                            <div class="card-header pe-5 border-0">
                                <div class="card-title">
                                    <div class="d-flex justify-content-center flex-column me-3">
                                        <div class="fs-4 fw-bolder text-gray-900 text-hover-primary me-1 lh-1"><?php echo e(__('Purchase Units')); ?></div>
                                    </div>
                                </div>
                                <div class="card-toolbar">
                                    <div class="btn btn-sm btn-icon btn-icon-dark btn-active-light-primary" data-kt-drawer-dismiss="true" id="kt_send_money_close">
                                        <span class="svg-icon svg-icon-2">
                                            <i class="fal fa-times"></i>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="card-body text-wrap">
                                <div class="btn-wrapper text-center mb-3">
                                    <div class="symbol symbol-150px symbol-circle me-5 mb-10">
                                        <div class="symbol-label fs-1 text-dark" style="background-image:url(<?php echo e(url('/').'/storage/app/'.$plan->image); ?>);"></div>
                                    </div>
                                    <p class="text-dark fs-5 fw-bold"><?php echo e($plan->name); ?></p>
                                </div>
                                <div class="card bg-warning">
                                    <div class="d-flex align-items-center p-3">
                                        <div class="symbol symbol-40px me-4">
                                            <div class="symbol-label fs-6 text-dark bg-white rounded-5">
                                                <i class="fal fa-gift text-dark"></i>
                                            </div>
                                        </div>
                                        <div class="ps-1">
                                            <p class="fs-6 text-dark fw-bolder mb-0"><?php echo e(__('You have ').$user->getFirstBalance()->waivers.__(' Investment Waivers')); ?></p>
                                        </div>
                                    </div>
                                </div>
                                <div class="pb-5 mt-10 position-relative zindex-1">
                                    <form class="form w-100 mb-10" wire:submit.prevent="purchase" method="post">
                                        <?php $__errorArgs = ['added'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="alert alert-danger">
                                            <div class="d-flex flex-column">
                                                <span><?php echo e($message); ?></span>
                                            </div>
                                        </div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        <div class="fv-row mb-6">
                                            <div class="input-group mb-3">
                                                <span class="input-group-text border-0 fs-2">#</span>
                                                <input class="form-control form-control-lg form-control-solid fs-2 fw-bold <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" type="text" wire:model.defer="amount" autocomplete="transaction-amount" id="unit-amount" min="1" max="<?php echo e($plan->original); ?>" value="<?php echo e(old('amount')); ?>" required placeholder="<?php echo e(__('Number of units')); ?>" />
                                            </div>
                                            <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="form-text text-danger"><?php echo e($message); ?></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                        <div class="fv-row mb-6">
                                            <div class="input-group mb-3">
                                                <span class="input-group-text border-0 fs-2"></span>
                                                <input class="form-control form-control-lg form-control-solid fs-2 fw-bold" type="text" wire:model.defer="signal" placeholder="<?php echo e(__('Signal(optional)')); ?>" />
                                            </div>
                                            <?php $__errorArgs = ['signal'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="form-text text-danger"><?php echo e($message); ?></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                        <div class="bg-light-primary px-6 py-5 mb-10 rounded" wire:ignore>
                                            <p class="text-dark fw-bold fs-6 mb-0"><?php echo e(__('Balance after transaction')); ?>: <span id="balanceAfter"><?php echo e($currency->currency_symbol.currencyFormat(number_format($user->getFirstBalance()->amount, 2)).' '.$currency->currency); ?></span></p>
                                            <p class="text-dark fw-bold fs-6 mb-0"><?php echo e(__('Amount')); ?>: <span id="amount"><?php echo e($currency->currency_symbol.'0.00 '.$currency->currency); ?></span></p>
                                            <p class="text-dark fw-bold fs-6 mb-0"><?php echo e(__('Fee')); ?>: <span id="fee"><?php echo e($currency->currency_symbol.'0.00 '.$currency->currency); ?></span></p>
                                        </div>
                                        <div class="form-check form-check-custom form-check-solid mb-6">
                                            <input class="form-check-input" type="checkbox" id="flexCheckDefault" wire:model.defer="terms" required />
                                            <label class="form-check-label" for="flexCheckDefault"><?php echo e(__('I agree to our')); ?> <a target="_blank" href="<?php echo e(route('terms')); ?>"><?php echo e(__('terms & conditions')); ?></a></label>
                                        </div>
                                        <?php $__errorArgs = ['terms'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="form-text text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        <div class="text-center mt-10">
                                            <button type="submit" class="btn btn-lg btn-primary btn-block fw-bolder me-3 my-2">
                                                <span wire:loading.remove wire:target="purchase"><?php echo e(__('Purchase Units')); ?></span>
                                                <span wire:loading wire:target="purchase"><?php echo e(__('Processing Request...')); ?></span>
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                    <?php endif; ?>
            </div>
        </div>
    </div>
    <div class="post fs-6 d-flex flex-column-fluid min-vh-100" id="kt_post">
        <div class="container">
            <div class="card mb-9 rounded-5">
                <div class="card-body pt-9 pb-0 dd-bg">
                    <div class="d-flex flex-wrap flex-sm-nowrap mb-6">
                        <div class="symbol symbol-150px me-7 mb-4 symbol-circle">
                            <span class="symbol-label" style="background-image:url(<?php echo e(url('/').'/storage/app/'.$plan->image); ?>);"></span>
                        </div>
                        <div class="flex-grow-1">
                            <div class="d-flex justify-content-between align-items-start flex-wrap mb-2">
                                <div class="d-flex flex-column">
                                    <p class="text-dark text-hover-primary fs-1 fw-boldest me-3 mb-0"><?php echo e($plan->name); ?></p>
                                    <p class="text-gray-800 text-hover-primary fs-5 me-3 mb-3"><?php echo e($plan->location); ?></p>
                                    <p>
                                        <span class="badge badge-light-primary"><?php echo e($plan->category->name); ?></span>
                                        <span class="badge badge-light-primary"><?php echo e($plan->duration.' Months'); ?></span>
                                        <span class="badge badge-light-primary"><?php echo e(($plan->status == 1) ? 'Published' : 'Disabled'); ?></span>
                                        <span class="badge badge-light-primary"><?php echo e(($plan->insurance == 1) ? 'Insured' : 'No Insurance'); ?></span>
                                    </p>
                               
                                </div>
                                <div class="d-flex mb-4">
                                    
                                    <a data-bs-toggle="modal" data-bs-target="#share" data-bs-original-title="Share Plan" title="Share Plan" class="cursor-pointer text-dark"><i class="fa-thin fa-arrow-up-from-bracket fa-2x"></i></a>
                                    <div class="modal fade" id="share" tabindex="-1" role="dialog" aria-labelledby="modal-form" aria-hidden="true">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header border-0">
                                                    <div class="btn btn-icon btn-sm btn-active-light-primary ms-2" data-bs-dismiss="modal" aria-label="Close">
                                                        <span class="svg-icon svg-icon-1">
                                                            <i class="fal fa-times"></i>
                                                        </span>
                                                    </div>
                                                </div>
                                                <div class="modal-body">
                                                    <div class="btn-wrapper text-center mb-3">
                                                        <div class="symbol symbol-200px symbol-circle me-5 mb-10">
                                                            <div class="symbol-label fs-1 text-dark" style="background-image:url(<?php echo e(url('/').'/storage/app/'.$plan->image); ?>);"></div>
                                                        </div>
                                                        <p class="text-dark fs-1 fw-bolder mb-3"><?php echo e($plan->name); ?></p>
                                                        <div class="d-flex">
                                                            <input id="kt_referral_link_input" type="text" class="form-control form-control-solid me-3 flex-grow-1" name="search" value="<?php echo e(route('view.plan', ['plan' => $plan->id, 'type' => 'details'])); ?>">
                                                            <button class="btn btn-light fw-boldest flex-shrink-0 castro-copy text-dark" data-clipboard-text="<?php echo e(route('view.plan', ['plan' => $plan->id, 'type' => 'details'])); ?>">Copy Link</button>
                                                        </div>
                                                        <div class="row mt-6 mb-6">
                                                            <div class="col-md-12">
                                                                <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo e(route('view.plan', ['plan' => $plan->id, 'type' => 'details'])); ?>" class="btn btn-icon btn-secondary mx-2" target="_blank">
                                                                    <i class="fab fa-facebook"></i>
                                                                </a>
                                                                <a href="https://twitter.com/intent/tweet?text=<?php echo e(route('view.plan', ['plan' => $plan->id, 'type' => 'details'])); ?>" class="btn btn-icon btn-secondary mx-2" target="_blank">
                                                                    <i class="fab fa-twitter"></i>
                                                                </a>
                                                                <a href="https://wa.me/?text=<?php echo e(route('view.plan', ['plan' => $plan->id, 'type' => 'details'])); ?>" class="btn btn-icon btn-secondary mx-2" target="_blank">
                                                                    <i class="fab fa-whatsapp"></i>
                                                                </a>
                                                                <a href="mailto:body=<?php echo e(route('view.plan', ['plan' => $plan->id, 'type' => 'details'])); ?>" class="btn btn-icon btn-secondary mx-2" target="_blank">
                                                                    <i class="fal fa-envelope"></i>
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                          <div class="mb-5 pt-5">
  
  <div class="border border-gray-600 border-dashed rounded" 
       style="position: relative; width: 99.9%; height: 200px;" wire:ignore>
    <canvas id="myChart"></canvas>
  </div> 
</div>
                            <div class="d-flex flex-wrap justify-content-start">
                                <div class="border border-gray-600 border-dashed rounded min-w-125px py-3 px-4 me-6 mb-3">
                                    <div class="fs-6 fw-boldest text-gray-700"><?php echo e(\Carbon\Carbon::create($plan->start_date)->format('M j, Y')); ?> - <?php echo e(\Carbon\Carbon::create($plan->close_date)->format('M j, Y')); ?></div>
                                    <div class="fw-bold text-gray-400">Investment Closure</div>
                                </div>
                                <div class="border border-gray-600 border-dashed rounded min-w-125px py-3 px-4 me-6 mb-3">
                                    <div class="fs-6 fw-boldest text-gray-700"><?php echo e(\Carbon\Carbon::create($plan->expiring_date)->format('M j, Y')); ?></div>
                                    <div class="fw-bold text-gray-400">Matures</div>
                                </div>
                                <div class="border border-gray-600 border-dashed rounded min-w-125px py-3 px-4 me-6 mb-3">
                                    <div class="fs-6 fw-boldest text-gray-700"><?php echo e(currencyFormat(number_format($plan->original - $plan->units).'/'.number_format($plan->original))); ?> units</div>
                                    <div class="fw-bold text-gray-400"><?php echo e($currency->currency_symbol.$plan->price); ?> per unit</div>
                                </div>
                                <div class="border border-gray-600 border-dashed rounded min-w-125px py-3 px-4 me-6 mb-3">
                                    <div class="fs-6 fw-boldest text-gray-700"><?php echo e($plan->interest); ?>%</div>
                                    <div class="fw-bold text-gray-400">Interest</div>
                                </div>
                                <div class="border border-gray-600 border-dashed rounded min-w-125px py-3 px-4 me-6 mb-3">
                                    <div class="fs-6 fw-boldest text-gray-700">
                                        <?php if($plan->fee_type == "both"): ?>
                                        <?php echo e($plan->percent_pc); ?>% + <?php echo e($plan->fiat_pc.' '.$currency->currency); ?>

                                        <?php elseif($plan->fee_type == "fiat"): ?>
                                        <?php echo e($plan->fiat_pc.' '.$currency->currency); ?>

                                        <?php elseif($plan->fee_type == "percent"): ?>
                                        <?php echo e($plan->percent_pc); ?>%
                                        <?php elseif($plan->fee_type == "max"): ?>
                                        > <?php echo e($plan->fiat_pc.' '.$currency->currency); ?> - <?php echo e($plan->percent_pc); ?>%
                                        <?php elseif($plan->fee_type == "min"): ?>
                                        < <?php echo e($plan->fiat_pc.' '.$currency->currency); ?> - <?php echo e($plan->percent_pc); ?>% <?php endif; ?> </div>
                                            <div class="fw-bold text-gray-400">Mtg Fee</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="separator"></div>
                        <div class="d-flex overflow-auto">
                            <ul class="nav nav-stretch nav-line-tabs nav-line-tabs-2x border-transparent fs-5 fw-bold flex-wrap h-100px">
                                <li class="nav-item">
                                    <a class="nav-link text-active-primary me-6 <?php if($type == 'details'): ?> active <?php endif; ?>" href="<?php echo e(route('view.plan', ['plan' => $plan->id, 'type' => 'details'])); ?>"><?php echo e(__('Description')); ?></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link text-active-primary me-6 <?php if($type == 'updates'): ?> active <?php endif; ?>" href="<?php echo e(route('view.plan', ['plan' => $plan->id, 'type' => 'updates'])); ?>"><?php echo e(__('Investment updates')); ?> (<?php echo e($plan->updates->count()); ?>)</a>
                                </li>
                                
                                <li class="nav-item">
                                    <a class="nav-link text-active-primary me-6 <?php if($type == 'portfolio'): ?> active <?php endif; ?>" href="<?php echo e(route('view.plan', ['plan' => $plan->id, 'type' => 'portfolio'])); ?>"><?php echo e(__('My Portfolio')); ?> (<?php echo e($user->planUnits($plan->id)->count()); ?>)</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link text-active-primary me-6 <?php if($type == 'transactions'): ?> active <?php endif; ?>" href="<?php echo e(route('view.plan', ['plan' => $plan->id, 'type' => 'transactions'])); ?>"><?php echo e(__('Transactions')); ?> (<?php echo e($plan->transactions->count()); ?>)</a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
                <?php if($type == 'details'): ?>
                <div class="card mb-10 rounded-5">
                    <div class="card-body">
                        <p class="preserveLines"><?php echo e($plan->details); ?></p>
                    </div>
                </div>
                <?php endif; ?>

                <?php if($type == 'updates'): ?>
                <?php $__empty_1 = true; $__currentLoopData = $plan->updates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="card mb-9 rounded-5">
                    <div class="card-body pt-9 pb-0">
                        <div class="d-flex flex-wrap flex-sm-nowrap mb-6">
                            <div class="flex-grow-1">
                                <div class="d-flex justify-content-between align-items-start flex-wrap mb-2">
                                    <div class="d-flex flex-column">
                                        <p class="text-dark text-hover-primary fs-1 fw-boldest me-3 mb-0"><?php echo e($cat->title); ?></p>
                                        <p class="text-gray-800 text-hover-primary fs-5 me-3 mb-3"><?php echo e($cat->stage); ?></p>
                                        <p>
                                            <span class="badge badge-light-primary"><?php echo e($cat->weeks.' weeks'); ?></span>
                                        </p>
                                        <p class="text-gray-800 preserveLines"><?php echo e($cat->report); ?></p>
                                        <?php if($cat->images->count()): ?>
                                        <div class="symbol-group symbol-hover mb-3">
                                            <!--begin::User-->
                                            <?php $__currentLoopData = $cat->images->take(10); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $images): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="symbol symbol-35px symbol-circle" data-bs-toggle="modal" data-bs-target="#updateimage<?php echo e($images->id); ?>" data-bs-toggle="tooltip" title="">
                                                <div class="symbol-label" style="background-image:url(<?php echo e(url('/').'/storage/app/'.$images->image); ?>)"></div>
                                            </div>
                                            <div class="modal fade" id="updateimage<?php echo e($images->id); ?>" wire:ignore.self tabindex="-1" role="dialog" aria-labelledby="modal-form" aria-hidden="true">
                                                <div class="modal-dialog" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header border-0">
                                                            <div class="btn btn-icon btn-sm btn-active-light-primary ms-2" data-bs-dismiss="modal" aria-label="Close">
                                                                <span class="svg-icon svg-icon-1">
                                                                    <i class="fal fa-times"></i>
                                                                </span>
                                                            </div>
                                                        </div>
                                                        <div class="modal-body">
                                                            <div class="text-center">
                                                                <img src="<?php echo e(url('/').'/storage/app/'.$images->image); ?>" style="max-width:100%; height:auto;" class="rounded-5">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="text-center mt-20">
                    <img src="<?php echo e(asset('asset/images/beneficiary.png')); ?>" style="height:auto; max-width:250px;" class="mb-6">
                    <h3 class="text-dark"><?php echo e(__('No Investment Update Found')); ?></h3>
                    <p class="text-dark"><?php echo e(__('We couldn\'t find any investment update')); ?></p>
                </div>
                <?php endif; ?>
                <?php endif; ?>

                <?php if($type == 'portfolio'): ?>
                <div class="row">
                    <div class="col-md-12">
                        <?php if($user->planUnitsProject($plan->id)->count()): ?>
                        <?php $__currentLoopData = $user->planUnitsProject($plan->id); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $buy): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('plans.units', ['buy' => $buy,'user' => $user])->html();
} elseif ($_instance->childHasBeenRendered('kt_category_'. $buy->id)) {
    $componentId = $_instance->getRenderedChildComponentId('kt_category_'. $buy->id);
    $componentTag = $_instance->getRenderedChildComponentTagName('kt_category_'. $buy->id);
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('kt_category_'. $buy->id);
} else {
    $response = \Livewire\Livewire::mount('plans.units', ['buy' => $buy,'user' => $user]);
    $html = $response->html();
    $_instance->logRenderedChild('kt_category_'. $buy->id, $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
                            <?php if(!$loop->last): ?>
                            <hr class="bg-light-border">
                            <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                            <div class="text-center mt-10 text-muted"><?php echo e(__('No Data')); ?></div>
                            <?php endif; ?>
                    </div>
                </div>
                <?php endif; ?>
                <?php if($type == 'transactions'): ?>
    <div class="card-body pt-0">
    <?php if($tranShow->count() > 0): ?>
        <?php $__currentLoopData = $plan->transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="d-flex flex-stack cursor-pointer"
           wire:click="$emit('openTransaction', <?php echo e($val->id); ?>)"
                 data-kt-drawer-toggle="true"
                 data-kt-drawer-target="#kt_mass_email"
                 role="button" >
                <div class="d-flex align-items-center">
                    

                    <div class="ps-1">
                        <p class="fs-6 text-dark text-hover-primary fw-bolder mb-0"><?php echo e($val->name); ?></p>
                        <p class="fs-6 text-gray-800 text-hover-primary mb-0"><?php echo e($val->created_at->format('F jS Y')); ?></p>
                    </div>
                </div>

                <div class="ps-1 text-end">
                <?php if($val->remark == 'loss'): ?>
                               <p class="fs-6 text-danger mb-0">
                        - <?php echo e($currency->currency_symbol . currencyFormat(number_format($val->limit_price, 2)) . ' ' . $currency->currency); ?>

                    </p>
                            <?php else: ?>
                                <p class="fs-6 text-success mb-0">
                        + <?php echo e($currency->currency_symbol . currencyFormat(number_format($val->limit_price, 2)) . ' ' . $currency->currency); ?>

                    </p>
                            <?php endif; ?>
                    
                </div>
            </div>

            <?php if(!$loop->last): ?>
                <hr class="bg-light-border">
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php else: ?>
        <div>
          <span>You must purchase a unit to see transactions</span>
        </div>
        <?php endif; ?>
    </div>

    
    <?php if($selectedTransaction): ?>
        <div wire:ignore.self id="kt_mass_email"
             class="bg-white"
             data-kt-drawer="true"
             data-kt-drawer-activate="true"
             data-kt-drawer-overlay="true"
             data-kt-drawer-width="{'md': '500px'}"
             data-kt-drawer-direction="end"
             data-kt-drawer-close="#kt_mass_email_close">

            <div class="card w-100">
                <div class="card-header pe-5 border-0">
                    <div class="card-title">
                        <div class="d-flex justify-content-center flex-column me-3">
                            <div class="fs-4 fw-bolder text-gray-900 text-hover-primary me-1 lh-1">
                                <?php echo e($selectedTransaction->name); ?>

                            </div>
                        </div>
                    </div>
                    <div class="card-toolbar">
                        <div class="btn btn-sm btn-icon btn-icon-dark btn-active-light-primary"
                             data-kt-drawer-dismiss="true"
                             id="kt_mass_email_close">
                            <span class="svg-icon svg-icon-2">
                                <i class="fal fa-times"></i>
                            </span>
                        </div>
                    </div>
                </div>

                <div class="card-body text-wrap">
                  
                      
                            
                                <div class="row mb-2">
                                <?php if($selectedTransaction->signals): ?>
                                <div class="col-6"><strong>Signal</strong><br><?php echo e($selectedTransaction->signals); ?></div> <?php endif; ?>
                                    <div class="col-6"><strong>Type</strong><br><?php echo e($selectedTransaction->type); ?></div>
                                    
                                </div>
                                <div class="row mb-2">
                                    <div class="col-6"><strong>Time in force</strong><br><?php echo e($selectedTransaction->time_in_force); ?></div>
                                    <div class="col-6"><strong>Submitted</strong><br><?php echo e($selectedTransaction->created_at->format('F j, g:i A')); ?></div>
                                </div>
                                <div class="row mb-2">
                                    <div class="col-6"><strong>Quantity</strong><br><?php echo e($selectedTransaction->quantity); ?></div>
                                    <div class="col-6"><strong>Filled Quantity</strong><br><?php echo e($selectedTransaction->filled_quantity); ?></div>
                                </div>
                                <div class="row mb-2">
                                    <div class="col-6"><strong>Filled</strong><br><?php echo e($selectedTransaction->created_at->format('F j, g:i A')); ?></div>
                                    <div class="col-6"><strong>Limit Price</strong><br><?php echo e($currency->currency_symbol.currencyFormat(number_format($selectedTransaction->limit_price, 2)).' '.$currency->currency); ?></div>
                                </div>
                                <div class="row mb-4">
                                    <div class="col-6"><strong>Total cost</strong><br><?php echo e($currency->currency_symbol.currencyFormat(number_format($selectedTransaction->total_cost, 2)).' '.$currency->currency); ?></div>
                                    <div class="col-6"><strong>Est. Regulatory fee</strong><br><?php echo e($currency->currency_symbol.currencyFormat(number_format($selectedTransaction->fee, 2)).' '.$currency->currency); ?></div>
                                    
                                    <div class="col-6"><strong>Position Effect</strong><br><?php echo e($selectedTransaction->position_effect); ?></div>
                                </div>

                                
                   
                </div>

            </div>
        </div>
    <?php endif; ?>
<?php endif; ?>
            </div>
        </div>
    </div>
</div><?php /**PATH /home/nexvestg/app.cenfibulls.com/resources/views/livewire/plans/project-details.blade.php ENDPATH**/ ?>