<?php $__env->startSection('content'); ?>
<div class="toolbar" id="kt_toolbar">
    <div class="container-fluid d-flex flex-stack flex-wrap flex-sm-nowrap">
        <div class="d-flex flex-column align-items-start justify-content-center flex-wrap me-2">
            <h1 class="text-dark fw-bolder my-1 fs-2"><?php echo e(__('Compliance')); ?></h1>
            <p class="text-dark"><?php echo e(__('Complete KYC to have access to card program')); ?></p>
        </div>
    </div>
    <div class="post fs-6 d-flex flex-column-fluid min-vh-100" id="kt_post">
        <div class="container">
            <div class="modal fade" id="sample" tabindex="-1" role="dialog" aria-labelledby="modal-form" aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h3 class="mb-0 font-weight-bolder"><?php echo e(__('Sample')); ?></h3>
                            <div class="btn btn-icon btn-sm btn-active-light-primary ms-2" data-bs-dismiss="modal" aria-label="Close">
                                <span class="svg-icon svg-icon-1">
                                    <i class="fal fa-times"></i>
                                </span>
                            </div>
                        </div>
                        <div class="modal-body">
                            <div class="text-center">
                                <img src="<?php echo e(asset('asset/images/selfie.jpg')); ?>" style="max-width:100%; height:auto;">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <form id="msform" class="mt-3">
                <div class="row justify-content-center">
                    <div class="col-md-12">
                        <ul id="progressbar" class="text-center">
                            <li class="" style="width:33%;"><?php echo e(__('Personal Information')); ?></li>
                            <li class="" style="width:33%;"><?php echo e(__('Physical Documents')); ?></li>
                            <li class="active" style="width:33%;"><?php echo e(__('Selfie')); ?></li>
                        </ul>
                    </div>
                </div>
            </form>
            <form action="<?php echo e(route('compliance.setup', ['type' => 'selfie'])); ?>" method="post" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="card">
                    <div class="card-body">
                        <p class="text-dark fs-5"><?php echo e(__('Take a photo of yourself while holding your ID')); ?>, <a href="" data-bs-toggle="modal" data-bs-target="#sample"><?php echo e(__('Click here')); ?></a> <?php echo e(__('to see example')); ?></p>
                        <div class="row justify-content-center align-items-center">
                            <div class="col-md-6">
                                <div id="my_camera" class="py-3 mb-6" style="position: relative;"></div>
                                <input type="hidden" name="image" class="image-tag">
                                <div class="text-center mt-6">
                                    <a href="javascript:void" class="btn btn-danger btn-block my-5" onClick="take_snapshot()"><i class="fad fa-camera fs-1"></i></a>
                                </div>
                            </div>
                            <div class="col-md-6 text-center">
                                <div id="results"><?php echo e(__('Your captured image will appear here...')); ?></div>
                                <div id="submit"></div>
                                <div class="my-5"></div>
                            </div>
                        </div>
                        <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('individual-compliance', ['user' => $user, 'type' => 'selfie'])->html();
} elseif ($_instance->childHasBeenRendered('tDYjxDL')) {
    $componentId = $_instance->getRenderedChildComponentId('tDYjxDL');
    $componentTag = $_instance->getRenderedChildComponentTagName('tDYjxDL');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('tDYjxDL');
} else {
    $response = \Livewire\Livewire::mount('individual-compliance', ['user' => $user, 'type' => 'selfie']);
    $html = $response->html();
    $_instance->logRenderedChild('tDYjxDL', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/webcamjs/1.0.25/webcam.min.js"></script>

<script>
    Webcam.set({
        height: 350,
        image_format: 'jpeg',
        jpeg_quality: 100
    });
    Webcam.attach('#my_camera');
    Webcam.on('error', function(err) {
        let message = err.message;
        if (message == "Could not access webcam") {
            message = "We recommend using a laptop or mobile device that has a webcam";
        }
        toastr.warning(message);
    });
</script>
<script>
    function take_snapshot() {
        Webcam.snap(function(data_uri) {
            $(".image-tag").val(data_uri);
            document.getElementById('results').innerHTML = '<img src="' + data_uri + '" style="max-widht:100%; height:auto; border-radius:.675rem;"/><p class="my-3 text-xs text-uppercase">Image Captured</p><button type="submit" class="btn btn-primary btn-block" id="filepond-upload">Submit</button></div>';
        });
    }
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('user.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nexvestg/app.cenfibull.com/resources/views/user/compliance/selfie.blade.php ENDPATH**/ ?>