<div>
    <div class="toolbar pb-0" id="kt_toolbar">
        <div class="container-fluid d-flex flex-stack flex-wrap">
            <div class="d-flex flex-column align-items-start justify-content-center flex-wrap me-2">
                <h1 class="text-dark fw-bolder my-1 fs-2"><?php echo e(__('Payout')); ?></h1>
                <ul class="breadcrumb fw-semibold fs-base my-1 mb-6">
                    <li class="breadcrumb-item text-muted">
                        <a href="<?php echo e(route('admin.dashboard')); ?>" class="text-muted text-hover-primary"><?php echo e(__('Dashboard')); ?></a>
                    </li>
                    <li class="breadcrumb-item text-dark"><?php echo e(__('Payout')); ?></li>
                    <li class="breadcrumb-item text-dark"><?php echo e(ucwords($type)); ?></li>
                </ul>

                <?php if($investW->count() > 0): ?>
                    <div wire:loading.class.delay="opacity-50" wire:target="perPage loadMore">
                        <div class="card-body pt-0">
                         <div class="text-center">
                         <h5>Investment Withdrawals</h5>
                         </div>
                            <div class="w-100 table-responsive" wire:ignore>
                                <table class="table align-middle table-row-bordered table-row-gray-300 gy-5 gs-7" id="kt_datatable_example_5">
                                    <thead>
                                        <tr class="text-start text-dark fw-bolder fs-7 text-uppercase px-7">
                                            <th><?php echo e(__('Name')); ?></th>
                                            <th><?php echo e(__('Amount')); ?></th>
                                            <th><?php echo e(__('Manage')); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody class="fw-semibold text-dark fs-6">
                                        <?php $__currentLoopData = $investW; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr class="cursor-pointer">
                                                <td><?php echo e($val->user->business->name); ?></td>
                                                <td>
                                                    <?php echo e($val->user->getFirstBalance()->getCurrency->real->currency_symbol); ?>

                                                    <?php echo e(currencyFormat(number_format($val->amount, 2))); ?>

                                                    <?php echo e($val->user->getFirstBalance()->getCurrency->real->currency); ?>

                                                </td>
                                                <td>
                                                    <a class="btn btn-sm btn-success" wire:click="approve(<?php echo e($val->id); ?>)">Approve</a>
                                                    <a class="btn btn-sm btn-danger" wire:click="reject(<?php echo e($val->id); ?>)">Reject</a>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>

                                <?php if($investW->total() > 0 && $investW->count() < $investW->total()): ?>
                                    <button wire:click="loadMore" wire:loading.remove class="btn btn-secondary btn-block">See more</button>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <ul class="nav nav-tabs nav-line-tabs nav-line-tabs-2x mb-5 fs-6 border-gray-300" id="tabs-icons-text" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link text-dark <?php if(route('admin.payout', ['type' => 'pending']) == url()->current()): ?> active <?php endif; ?>"
                           href="<?php echo e(route('admin.payout', ['type' => 'pending'])); ?>"><?php echo e(__('Pending')); ?> (<?php echo e(number_format_short_nc($pending)); ?>)</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link text-dark <?php if(route('admin.payout', ['type' => 'success']) == url()->current()): ?> active <?php endif; ?>"
                           href="<?php echo e(route('admin.payout', ['type' => 'success'])); ?>"><?php echo e(__('Success')); ?> (<?php echo e(number_format_short_nc($success)); ?>)</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link text-dark <?php if(route('admin.payout', ['type' => 'declined']) == url()->current()): ?> active <?php endif; ?>"
                           href="<?php echo e(route('admin.payout', ['type' => 'declined'])); ?>"><?php echo e(__('Declined')); ?> (<?php echo e(number_format_short_nc($declined)); ?>)</a>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    window.livewire.on('closeDrawer', function () {
        if (typeof KTDrawer !== 'undefined') {
            KTDrawer.hideAll();
            KTDrawer.createInstances();
        }
    });
</script>
<?php $__env->stopPush(); ?><?php /**PATH /home/nexvestg/app.cenfibull.com/resources/views/livewire/admin/payout/header.blade.php ENDPATH**/ ?>