<div>
    <div class="post fs-6 d-flex flex-column-fluid min-vh-100" id="kt_post">
        <div class="container">
            <div class="row g-xl-8 mb-6">
                <div wire:ignore.self class="modal fade" id="filter" tabindex="-1" role="dialog" aria-labelledby="modal-form" aria-hidden="true">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h3 class="modal-title"><?php echo e(__('Filter')); ?></h3>
                                <div class="btn btn-icon btn-sm btn-active-light-primary ms-2" data-bs-dismiss="modal" aria-label="Close">
                                    <span class="svg-icon svg-icon-1">
                                        <i class="fal fa-times"></i>
                                    </span>
                                </div>
                            </div>
                            <div class="modal-body">
                                <div class="fv-row mb-6">
                                    <label class="form-label fs-6 fw-bolder text-dark"><?php echo e(__('Sort by')); ?></label>
                                    <select class="form-select form-select-solid" wire:model="sortBy">
                                        <option value="asc"><?php echo e(__('ASC')); ?></option>
                                        <option value="desc"><?php echo e(__('DESC')); ?></option>
                                    </select>
                                </div>
                                <div class="fv-row mb-6">
                                    <label class="form-label fs-6 fw-bolder text-dark"><?php echo e(__('Per page')); ?></label>
                                    <select class="form-select form-select-solid" wire:model="perPage">
                                        <option value="10"><?php echo e(__('10')); ?></option>
                                        <option value="25"><?php echo e(__('25')); ?></option>
                                        <option value="50"><?php echo e(__('50')); ?></option>
                                        <option value="100"><?php echo e(__('100')); ?></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="d-flex justify-content-center flex-column me-3">
                        <div class="input-group input-group-solid mb-5 rounded-4">
                            <span class="input-group-text" id="basic-addon1"><i class="fal fa-search"></i></span>
                            <input type="search" class="form-control form-control-solid text-dark" wire:model="search" placeholder="<?php echo e(__('Search')); ?>" />
                        </div>
                    </div>
                </div>
                <div class="col-md-6 text-md-end">
                    <button data-bs-toggle="modal" data-bs-target="#filter" class="btn btn-white text-dark me-4"><i class="fal fa-filter-list"></i> <?php echo e(__('Filter')); ?></button>
                </div>
            </div>
            <?php if($followers->count() > 0): ?>
            <div class="" wire:loading.class.delay="opacity-50" wire:target="search, status, orderBy, perPage, date">
                <?php $__currentLoopData = $followers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($val->plan->type == 'project'): ?>
                <div class="d-flex flex-stack">
                    <div class="d-flex align-items-center">
                        <div class="symbol symbol-40px symbol-circle" data-bs-toggle="tooltip" title="" data-bs-original-title="<?php echo e($val->user->business->name); ?>">
                            <div class="symbol-label" style="background-image:url(<?php echo e(url('/').'/storage/app/'.$val->plan->image); ?>)"></div>
                        </div>
                        <div class="ps-3">
                            <p class="fs-6 text-dark text-hover-primary fw-bolder mb-0"><a href="<?php echo e(route('admin.invest.plan', ['plan' => $val->plan->id, 'type' => 'edit'])); ?>"><?php echo e($val->plan->name); ?></a></p>
                            <p class="fs-6 text-gray-800 mb-0"><?php echo e($val->units.__(' units')); ?> => <?php echo e($currency->currency_symbol.currencyFormat(number_format($val->amount, 2))); ?></p>
                        </div>
                    </div>
                    <p class="fs-6 text-gray-800 mb-0"><?php echo e(__('Return')); ?> <?php echo e($currency->currency_symbol.currencyFormat(number_format($val->amount + ($val->amount * $val->plan->interest / 100), 2))); ?></p>
                </div>
                <?php else: ?>
                <div class="d-flex flex-stack">
                    <div class="d-flex align-items-center">
                        <div class="symbol symbol-40px symbol-circle" data-bs-toggle="tooltip" title="" data-bs-original-title="<?php echo e($val->user->business->name); ?>">
                            <div class="symbol-label" style="background-image:url(<?php echo e(url('/').'/storage/app/'.$val->plan->image); ?>)"></div>
                        </div>
                        <div class="ps-3">
                            <p class="fs-6 text-dark text-hover-primary fw-bolder mb-0"><a href="<?php echo e(route('admin.invest.plan', ['plan' => $val->plan->id, 'type' => 'edit'])); ?>"><?php echo e($val->plan->name); ?></a></p>
                            <p class="fs-6 text-gray-800 mb-0"><?php echo e($val->units.__(' units')); ?> </p>
                        </div>
                    </div>
                    <p class="fs-6 text-gray-800 mb-0">
                        <?php echo e(__('Value')); ?> <?php echo e($currency->currency_symbol.currencyFormat(number_format($val->units * $val->plan->first()->amount, 2))); ?>

                        <?php if($val->plan->yesterdayHistory()): ?>
                        <span class="fw-bolder text-dark">[<?php echo e(($val->plan->first()->amount == $val->plan->yesterdayHistory()->amount) ? '--' : (($val->plan->first()->amount > $val->plan->yesterdayHistory()->amount) ? '+'.$val->plan->upBy('today').'%' : '-'.$val->plan->upBy('yesterday').'%')); ?> 24h]</span>
                        <?php else: ?>
                        <span class="fw-bolder text-dark">[-- 24h]</span>
                        <?php endif; ?>
                    </p>
                </div>
                <?php endif; ?>
                <?php if(!$loop->last): ?>
                <hr class="bg-light-border">
                <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php if($followers->total() > 0 && $followers->count() < $followers->total()): ?><button wire:click="loadMore" wire:loading.remove class="btn btn-secondary btn-block"><?php echo e(__('See more')); ?></button><?php endif; ?>
            </div>
            <?php else: ?>
            <div class="text-center mt-20">
                <img src="<?php echo e(asset('asset/images/beneficiary.png')); ?>" style="height:auto; max-width:200px;" class="mb-6">
                <h3 class="text-dark"><?php echo e(__('No Followers Found')); ?></h3>
                <p class="text-dark"><?php echo e(__('We couldn\'t find any followers to this investment')); ?></p>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div><?php /**PATH /home/nexvestg/app.cenfibull.com/resources/views/livewire/admin/users/portfolio.blade.php ENDPATH**/ ?>