<?php $__env->startSection('content'); ?>
<div class="toolbar" id="kt_toolbar">
    <div class="container-fluid d-flex flex-stack flex-wrap flex-sm-nowrap">
        <div class="d-flex flex-column align-items-start justify-content-center flex-wrap me-2">
            <h1 class="text-dark fw-bolder my-1 fs-2"><?php echo e(__('Invest')); ?></h1>
            <ul class="breadcrumb fw-semibold fs-base my-1 mb-6">
                <li class="breadcrumb-item text-muted">
                    <a href="<?php echo e(route('user.dashboard')); ?>" class="text-muted text-hover-primary">Dashboard </a>
                </li>
                <li class="breadcrumb-item text-dark"><?php echo e(__('Invest')); ?></li>
            </ul>
        </div>
    </div>
    <div class="post fs-6 d-flex flex-column-fluid min-vh-100" id="kt_post">
        <div class="container">
            <div class="row g-xl-8">
                <div class="col-xl-12">
                    <div class="card bg-transparent card-xl-stretch mb-xl-9">
                        <div class="card-body p-0 pb-9">
                            <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('plans.index', ['user' => $user])->html();
} elseif ($_instance->childHasBeenRendered('6MlKwRh')) {
    $componentId = $_instance->getRenderedChildComponentId('6MlKwRh');
    $componentTag = $_instance->getRenderedChildComponentTagName('6MlKwRh');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('6MlKwRh');
} else {
    $response = \Livewire\Livewire::mount('plans.index', ['user' => $user]);
    $html = $response->html();
    $_instance->logRenderedChild('6MlKwRh', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
                            <div class="mx-9 mt-n20">
                                <!--begin::Row-->
                                <div class="row g-8 row-cols-1 row-cols-sm-2">
                                    <!--begin::Col-->
                                    <?php if(getPlans('mutual')->count()): ?>
                                    <div class="col mb-3">
                                        <a href="<?php echo e(route('user.mutual', ['type' => 'recommended'])); ?>">
                                            <div class="text-start bg-white shadow-xs rounded-5 p-7 dd-bg">
                                                <!--begin::Symbol-->
                                                <div class="symbol symbol-100px mt-1 mb-3">
                                                    <span class="symbol-label bg-warning rounded-5">
                                                        <i class="fal fa-globe fa-4x text-dark"></i>
                                                    </span>
                                                </div>
                                                <!--end::Symbol-->
                                                <p class="text-dark fw-boldest fs-3 mt-4 d-block"><?php echo e(__('Mutual Funds')); ?></p>
                                                <p class="text-gray-800"><?php echo e(__('Own a mix of stocks, bonds, treasury bills and other financial instruments. All on your terms.')); ?></p>
                                            </div>
                                        </a>
                                    </div>
                                    <?php endif; ?>
                                    <?php if(getPlans('project')->count()): ?>
                                    <div class="col mb-3">
                                        <a href="<?php echo e(route('user.project', ['type' => 'forex'])); ?>">
                                            <div class="text-start bg-white shadow-xs rounded-5 p-7 dd-bg">
                                                <!--begin::Symbol-->
                                                <div class="symbol symbol-100px mt-1 mb-3">
                                                    <span class="symbol-label bg-warning rounded-5">
                                                        <i class="fal fa-rectangle-vertical-history fa-4x text-dark"></i>
                                                    </span>
                                                </div>
                                                <!--end::Symbol-->
                                                <p class="text-dark fw-boldest fs-3 mt-4 d-block"><?php echo e(__('Portfolios')); ?></p>
                                                <p class="text-gray-800"><?php echo e(__('Earn money from Real estate, IT, Livestocks, Transportation projects, Health, Crop projects.')); ?></p>
                                            </div>
                                        </a>
                                    </div>
                                    <?php endif; ?>
                                    <!--end::Col-->
                                </div>
                                <!--end::Row-->
                            </div>
                            <!--end::Items-->
                        </div>
                        <!--end::Body-->
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script>
    "use strict"
    $('#hide_balance').on('click', function() {
        $('#main_balance').text('************');
        $('#reveal_balance').show();
        $('#hide_balance').hide();
    });
    $('#reveal_balance').on('click', function() {
        $('#main_balance').text("<?php echo e(currencyFormat(number_format($user->followed()->sum('amount'),2)).' '.$currency->currency); ?>");
        $('#hide_balance').show();
        $('#reveal_balance').hide();
    });
</script>
<script>
document.addEventListener('DOMContentLoaded', function () {
    // Retrieve labels and data passed from the controller
    const chartLabels  = <?php echo json_encode($labels, 15, 512) ?>;
    const chartData    = <?php echo json_encode($data, 15, 512) ?>;          // Investment data
    const profitData   = <?php echo json_encode($profitData, 15, 512) ?>;    // Profit data

    const ctx = document.getElementById('myChart').getContext('2d');

    const myChart = new Chart(ctx, {
      type: 'line',
      data: {
        labels: chartLabels,
        datasets: [
          {
            label: 'Investment',
            data: chartData,
            borderColor: '#000',
            backgroundColor: 'transparent',
            fill: false,
            tension: 0.4,
            borderWidth: 2,
            pointRadius: 0
          },
          {
            label: 'Profit',
            data: profitData,
            borderColor: 'green', 
            backgroundColor: 'transparent',
            fill: false,
            tension: 0.4,
            borderWidth: 2,
            pointRadius: 0
          }
        ]
      },
      options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
          legend: {
            display: true,
            labels: {
              color: '#000'
            }
          }
        },
        scales: {
          x: {
            grid: { display: false },
            ticks: {
              color: '#000',
              font: { size: 12 }
            }
          },
          y: {
            position: 'right',
            grid: { display: false },
            ticks: {
              color: '#000',
              font: { size: 12 },
              callback: function(value) {
                if (value >= 1000) {
                  return (value / 1000) + '$K';
                }
                return value;
              }
            }
          }
        }
      }
    });
});
</script>
         
<?php $__env->stopSection(); ?>
<?php echo $__env->make('user.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nexvestg/app.cenfibulls.com/resources/views/user/plan/index.blade.php ENDPATH**/ ?>