<?php $__env->startSection('content'); ?>
<div class="toolbar" id="kt_toolbar">
    <div class="container-fluid d-flex flex-stack flex-wrap flex-sm-nowrap">
        <div class="d-flex flex-column align-items-start justify-content-center flex-wrap me-2">
            <h1 class="text-dark fw-bolder my-1 fs-2"><?php echo e(__('Portfolio')); ?></h1>
            <ul class="breadcrumb fw-semibold fs-base my-1 mb-6">
                <li class="breadcrumb-item text-muted">
                    <a href="<?php echo e(route('user.dashboard')); ?>" class="text-muted text-hover-primary">Dashboard </a>
                </li>
                <li class="breadcrumb-item text-dark"><?php echo e(__('Portfolio')); ?></li>
            </ul>
            
        </div>
    </div>
    <div class="post fs-6 d-flex flex-column-fluid min-vh-100" id="kt_post">
        <div class="container">
            <?php if(route('user.followed', ['type' => 'project'])==url()->current()): ?>
                <?php $__empty_1 = true; $__currentLoopData = $user->followed(null, 'project'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="card mb-9 rounded-5 cursor-pointer" data-href="<?php echo e(route('view.plan', ['plan' => $val->plan->id, 'type' => 'details'])); ?>">
                    <div class="card-body pt-9 pb-0 dd-bg">
                        <div class="d-flex flex-wrap flex-sm-nowrap mb-6">
                            <div class="symbol symbol-100px me-7 mb-4 symbol-circle">
                                <span class="symbol-label" style="background-image:url(<?php echo e(url('/').'/storage/app/'.$val->plan->image); ?>);"></span>
                            </div>
                            <div class="flex-grow-1">
                                <div class="d-flex justify-content-between align-items-start flex-wrap mb-2">
                                    <div class="d-flex flex-column">
                                        <p class="text-dark fs-1 fw-boldest me-3 mb-0"><?php echo e(substr($val->plan->name, 0, 30)); ?><?php echo e((Str::length($val->plan->name) > 30) ? '...' : ''); ?></p>
                                        <p class="text-gray-800 fs-5 me-3 mb-3"><?php echo e($val->plan->location); ?></p>
                                        <p>
                                            <span class="badge badge-light-primary"><?php echo e($val->plan->category->name); ?></span>
                                            <span class="badge badge-light-primary"><?php echo e($val->plan->duration.' Months'); ?></span>
                                            <span class="badge badge-light-primary"><?php echo e(($val->plan->status == 1) ? 'Published' : 'Disabled'); ?></span>
                                            <span class="badge badge-light-primary"><?php echo e(($val->plan->insurance == 1) ? 'Insured' : 'No Insurance'); ?></span>
                                        </p>
                                        

                                    </div>
                                    <div class="d-flex mb-4">
                                        <?php if($user->followedPlan($val->plan->id)): ?>
                                        <span class="badge badge-secondary me-5 mt-3"><?php echo e(__('Followed')); ?></span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="d-flex flex-wrap justify-content-start">
                                    <div class="border border-gray-600 border-dashed rounded min-w-125px py-3 px-4 me-6 mb-3">
                                        <div class="fs-6 fw-boldest text-gray-700"><?php echo e(\Carbon\Carbon::create($val->plan->start_date)->format('M j, Y')); ?> - <?php echo e(\Carbon\Carbon::create($val->plan->close_date)->format('M j, Y')); ?></div>
                                        <div class="fw-bold text-gray-400">Investment Closure</div>
                                    </div>
                                    <div class="border border-gray-600 border-dashed rounded min-w-125px py-3 px-4 me-6 mb-3">
                                        <div class="fs-6 fw-boldest text-gray-700"><?php echo e(\Carbon\Carbon::create($val->plan->expiring_date)->format('M j, Y')); ?></div>
                                        <div class="fw-bold text-gray-400">Matures</div>
                                    </div>
                                    <div class="border border-gray-600 border-dashed rounded min-w-125px py-3 px-4 me-6 mb-3">
                                        <div class="fs-6 fw-boldest text-gray-700"><?php echo e(number_format($val->plan->original - $val->plan->units).'/'.number_format($val->plan->original)); ?> units</div>
                                        <div class="fw-bold text-gray-400"><?php echo e($currency->currency_symbol.$val->plan->price); ?> per unit</div>
                                    </div>
                                    <div class="border border-gray-600 border-dashed rounded min-w-125px py-3 px-4 me-6 mb-3">
                                        <div class="fs-6 fw-boldest text-gray-700"><?php echo e($val->plan->interest); ?>%</div>
                                        <div class="fw-bold text-gray-400">Interest</div>
                                    </div>
                                    <div class="border border-gray-600 border-dashed rounded min-w-125px py-3 px-4 me-6 mb-3">
                                        <div class="fs-6 fw-boldest text-gray-700">
                                            <?php if($val->plan->fee_type == "both"): ?>
                                            <?php echo e($val->plan->percent_pc); ?>% + <?php echo e($val->plan->fiat_pc.' '.$currency->currency); ?>

                                            <?php elseif($val->plan->fee_type == "fiat"): ?>
                                            <?php echo e($val->plan->fiat_pc.' '.$currency->currency); ?>

                                            <?php elseif($val->plan->fee_type == "percent"): ?>
                                            <?php echo e($val->plan->percent_pc); ?>%
                                            <?php elseif($val->plan->fee_type == "max"): ?>
                                            > <?php echo e($val->plan->fiat_pc.' '.$currency->currency); ?> - <?php echo e($val->plan->percent_pc); ?>%
                                            <?php elseif($val->plan->fee_type == "min"): ?>
                                            < <?php echo e($val->plan->fiat_pc.' '.$currency->currency); ?> - <?php echo e($val->plan->percent_pc); ?>% <?php endif; ?> </div>
                                                <div class="fw-bold text-gray-400">Investment Fee</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="text-center mt-20">
                        <img src="<?php echo e(asset('asset/images/beneficiary.png')); ?>" style="height:auto; max-width:250px;" class="mb-6">
                        <h3 class="text-dark"><?php echo e(__('No Investment Plan Found')); ?></h3>
                        <p class="text-dark"><?php echo e(__('We couldn\'t find any investment plan ')); ?></p>
                    </div>
                <?php endif; ?>
            </div>
            <?php elseif(route('user.followed', ['type' => 'mutual'])==url()->current()): ?>
            <div class="row">
                <?php $__empty_1 = true; $__currentLoopData = $user->followed(null, 'mutual'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <?php if($val->plan->priceHistory->last()->date->diffInDays(\Carbon\Carbon::now()) >= 0 && $val->plan->fundComposition->count()): ?>
                <div class="col-md-6 mb-6">
                    <div class="card cursor-pointer h-100 rounded-5 dd-bg" data-href="<?php echo e(route('view.plan', ['plan' => $val->plan->id, 'type' => 'details'])); ?>">
                        <div class="card-body pt-9 pb-0">
                            <div class="d-flex flex-wrap flex-sm-nowrap mb-6">
                                <div class="symbol symbol-100px me-7 mb-4 symbol-circle">
                                    <span class="symbol-label" style="background-image:url(<?php echo e(url('/').'/storage/app/'.$val->plan->image); ?>);"></span>
                                </div>
                                <div class="flex-grow-1">
                                    <div class="d-flex justify-content-between align-items-start flex-wrap mb-2">
                                        <div class="d-flex flex-column">
                                            <p class="text-dark fs-1 fw-boldest me-3 mb-0"><?php echo e(substr($val->plan->name, 0, 30)); ?><?php echo e((Str::length($val->plan->name) > 30) ? '...' : ''); ?></p>
                                            <p class="text-gray-800"><?php echo e($val->plan->trustee); ?></p>
                                            <p>
                                                <?php if($val->plan->recommendation == 1): ?><span class="badge badge-light-primary">Recommended</span><?php endif; ?>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <hr class="bg-secondary">
                            <div class="row my-10">
                                <div class="col-md-6">
                                    <p class="fs-3 text-gray-800 fw-bolder"><?php echo e(__('YTD Returns')); ?></p>
                                </div>
                                <div class="col-md-6 text-end">
                                    <?php if($val->plan->first()->amount == $val->plan->last()->amount): ?>
                                    <p class="fs-3 fw-bolder text-success">--</p>
                                    <?php elseif($val->plan->first()->amount > $val->plan->last()->amount): ?>
                                    <p class="fs-3 fw-bolder text-success">+<?php echo e($val->plan->YTD('first')); ?>%</p>
                                    <?php else: ?>
                                    <p class="fs-3 fw-bolder text-danger">-<?php echo e($val->plan->YTD('last')); ?>%</p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="text-center mt-20">
                        <img src="<?php echo e(asset('asset/images/beneficiary.png')); ?>" style="height:auto; max-width:250px;" class="mb-6">
                        <h3 class="text-dark"><?php echo e(__('No Investment Plan Found')); ?></h3>
                        <p class="text-dark"><?php echo e(__('We couldn\'t find any investment plan ')); ?></p>
                    </div>
                    <?php endif; ?>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('user.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nexvestg/app.cenfibulls.com/resources/views/user/plan/followed.blade.php ENDPATH**/ ?>