@extends('user.menu')

@section('content')
<div class="toolbar" id="kt_toolbar">
    <div class="container-fluid d-flex flex-stack flex-wrap flex-sm-nowrap">
        <div class="d-flex flex-column align-items-start justify-content-center flex-wrap me-2">
            <h1 class="text-dark fw-bolder my-1 fs-2">{{__('Invest')}}</h1>
            <ul class="breadcrumb fw-semibold fs-base my-1 mb-6">
                <li class="breadcrumb-item text-muted">
                    <a href="{{route('user.dashboard')}}" class="text-muted text-hover-primary">{{__('Dashboard')}} </a>
                </li>
                <li class="breadcrumb-item text-muted">
                    <a href="{{route('user.plan')}}" class="text-muted text-hover-primary">{{__('Invest')}} </a>
                </li>
                <li class="breadcrumb-item text-dark">{{__('Portfolio')}}</li>
            </ul>
            @php
                $cat = App\Models\Plancategory::all();
            @endphp
            <ul class="nav nav-tabs nav-line-tabs nav-line-tabs-2x mb-5 fs-5 border-gray-300" id="tabs-icons-text" role="tablist">
                @foreach($cat as $v)
                <li class="nav-item">
                    <a class="nav-link text-dark @if(route('user.project', ['type' => $v->slug])==url()->current()) active @endif" id="tabs-icons-text-1-tab" href="{{route('user.project', ['type' => $v->slug])}}" role="tab" aria-controls="tabs-icons-text-1" aria-selected="true"> {{$v->name}} ({{count(getProjects($v->slug))}})</a>
                </li>
                @endforeach
            </ul>
        </div>
    </div>
    <div class="post fs-6 d-flex flex-column-fluid min-vh-100" id="kt_post">
        <div class="container">
            @foreach($cat as $w)
                @if(route('user.project', ['type' => $w->slug]) == url()->current())
                    @livewire('plans.project', ['type' => $w->id, 'user' => $user, 'settings' => $set])
                @endif
            @endforeach
        </div>
    </div>
</div>
@stop