@extends('user.menu')

@section('content')
<div class="toolbar" id="kt_toolbar">
    <div class="container-fluid d-flex flex-stack flex-wrap flex-sm-nowrap">
        <div class="d-flex flex-column align-items-start justify-content-center flex-wrap me-2">
            <h1 class="text-dark fw-bolder my-1 fs-2">{{__('Portfolio')}}</h1>
            <ul class="breadcrumb fw-semibold fs-base my-1 mb-6">
                <li class="breadcrumb-item text-muted">
                    <a href="{{route('user.dashboard')}}" class="text-muted text-hover-primary">Dashboard </a>
                </li>
                <li class="breadcrumb-item text-dark">{{__('Portfolio')}}</li>
            </ul>
            
        </div>
    </div>
    <div class="post fs-6 d-flex flex-column-fluid min-vh-100" id="kt_post">
        <div class="container">
            @if(route('user.followed', ['type' => 'project'])==url()->current())
                @forelse($user->followed(null, 'project') as $val)
                <div class="card mb-9 rounded-5 cursor-pointer" data-href="{{route('view.plan', ['plan' => $val->plan->id, 'type' => 'details'])}}">
                    <div class="card-body pt-9 pb-0 dd-bg">
                        <div class="d-flex flex-wrap flex-sm-nowrap mb-6">
                            <div class="symbol symbol-100px me-7 mb-4 symbol-circle">
                                <span class="symbol-label" style="background-image:url({{url('/').'/storage/app/'.$val->plan->image}});"></span>
                            </div>
                            <div class="flex-grow-1">
                                <div class="d-flex justify-content-between align-items-start flex-wrap mb-2">
                                    <div class="d-flex flex-column">
                                        <p class="text-dark fs-1 fw-boldest me-3 mb-0">{{substr($val->plan->name, 0, 30)}}{{(Str::length($val->plan->name) > 30) ? '...' : ''}}</p>
                                        <p class="text-gray-800 fs-5 me-3 mb-3">{{$val->plan->location}}</p>
                                        <p>
                                            <span class="badge badge-light-primary">{{$val->plan->category->name}}</span>
                                            <span class="badge badge-light-primary">{{$val->plan->duration.' Months'}}</span>
                                            <span class="badge badge-light-primary">{{($val->plan->status == 1) ? 'Published' : 'Disabled'}}</span>
                                            <span class="badge badge-light-primary">{{($val->plan->insurance == 1) ? 'Insured' : 'No Insurance'}}</span>
                                        </p>
                                        

                                    </div>
                                    <div class="d-flex mb-4">
                                        @if($user->followedPlan($val->plan->id))
                                        <span class="badge badge-secondary me-5 mt-3">{{__('Followed')}}</span>
                                        @endif
                                    </div>
                                </div>
                                <div class="d-flex flex-wrap justify-content-start">
                                    <div class="border border-gray-600 border-dashed rounded min-w-125px py-3 px-4 me-6 mb-3">
                                        <div class="fs-6 fw-boldest text-gray-700">{{\Carbon\Carbon::create($val->plan->start_date)->format('M j, Y')}} - {{\Carbon\Carbon::create($val->plan->close_date)->format('M j, Y')}}</div>
                                        <div class="fw-bold text-gray-400">Investment Closure</div>
                                    </div>
                                    <div class="border border-gray-600 border-dashed rounded min-w-125px py-3 px-4 me-6 mb-3">
                                        <div class="fs-6 fw-boldest text-gray-700">{{\Carbon\Carbon::create($val->plan->expiring_date)->format('M j, Y')}}</div>
                                        <div class="fw-bold text-gray-400">Matures</div>
                                    </div>
                                    <div class="border border-gray-600 border-dashed rounded min-w-125px py-3 px-4 me-6 mb-3">
                                        <div class="fs-6 fw-boldest text-gray-700">{{number_format($val->plan->original - $val->plan->units).'/'.number_format($val->plan->original)}} units</div>
                                        <div class="fw-bold text-gray-400">{{$currency->currency_symbol.$val->plan->price}} per unit</div>
                                    </div>
                                    <div class="border border-gray-600 border-dashed rounded min-w-125px py-3 px-4 me-6 mb-3">
                                        <div class="fs-6 fw-boldest text-gray-700">{{$val->plan->interest}}%</div>
                                        <div class="fw-bold text-gray-400">Interest</div>
                                    </div>
                                    <div class="border border-gray-600 border-dashed rounded min-w-125px py-3 px-4 me-6 mb-3">
                                        <div class="fs-6 fw-boldest text-gray-700">
                                            @if($val->plan->fee_type == "both")
                                            {{$val->plan->percent_pc}}% + {{$val->plan->fiat_pc.' '.$currency->currency}}
                                            @elseif($val->plan->fee_type == "fiat")
                                            {{$val->plan->fiat_pc.' '.$currency->currency}}
                                            @elseif($val->plan->fee_type == "percent")
                                            {{$val->plan->percent_pc}}%
                                            @elseif($val->plan->fee_type == "max")
                                            > {{$val->plan->fiat_pc.' '.$currency->currency}} - {{$val->plan->percent_pc}}%
                                            @elseif($val->plan->fee_type == "min")
                                            < {{$val->plan->fiat_pc.' '.$currency->currency}} - {{$val->plan->percent_pc}}% @endif </div>
                                                <div class="fw-bold text-gray-400">Investment Fee</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @empty
                    <div class="text-center mt-20">
                        <img src="{{asset('asset/images/beneficiary.png')}}" style="height:auto; max-width:250px;" class="mb-6">
                        <h3 class="text-dark">{{__('No Investment Plan Found')}}</h3>
                        <p class="text-dark">{{__('We couldn\'t find any investment plan ')}}</p>
                    </div>
                @endforelse
            </div>
            @elseif(route('user.followed', ['type' => 'mutual'])==url()->current())
            <div class="row">
                @forelse($user->followed(null, 'mutual') as $val)
                @if($val->plan->priceHistory->last()->date->diffInDays(\Carbon\Carbon::now()) >= 0 && $val->plan->fundComposition->count())
                <div class="col-md-6 mb-6">
                    <div class="card cursor-pointer h-100 rounded-5 dd-bg" data-href="{{route('view.plan', ['plan' => $val->plan->id, 'type' => 'details'])}}">
                        <div class="card-body pt-9 pb-0">
                            <div class="d-flex flex-wrap flex-sm-nowrap mb-6">
                                <div class="symbol symbol-100px me-7 mb-4 symbol-circle">
                                    <span class="symbol-label" style="background-image:url({{url('/').'/storage/app/'.$val->plan->image}});"></span>
                                </div>
                                <div class="flex-grow-1">
                                    <div class="d-flex justify-content-between align-items-start flex-wrap mb-2">
                                        <div class="d-flex flex-column">
                                            <p class="text-dark fs-1 fw-boldest me-3 mb-0">{{substr($val->plan->name, 0, 30)}}{{(Str::length($val->plan->name) > 30) ? '...' : ''}}</p>
                                            <p class="text-gray-800">{{$val->plan->trustee}}</p>
                                            <p>
                                                @if($val->plan->recommendation == 1)<span class="badge badge-light-primary">Recommended</span>@endif
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <hr class="bg-secondary">
                            <div class="row my-10">
                                <div class="col-md-6">
                                    <p class="fs-3 text-gray-800 fw-bolder">{{__('YTD Returns')}}</p>
                                </div>
                                <div class="col-md-6 text-end">
                                    @if($val->plan->first()->amount == $val->plan->last()->amount)
                                    <p class="fs-3 fw-bolder text-success">--</p>
                                    @elseif($val->plan->first()->amount > $val->plan->last()->amount)
                                    <p class="fs-3 fw-bolder text-success">+{{$val->plan->YTD('first')}}%</p>
                                    @else
                                    <p class="fs-3 fw-bolder text-danger">-{{$val->plan->YTD('last')}}%</p>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                @endif
                @empty
                    <div class="text-center mt-20">
                        <img src="{{asset('asset/images/beneficiary.png')}}" style="height:auto; max-width:250px;" class="mb-6">
                        <h3 class="text-dark">{{__('No Investment Plan Found')}}</h3>
                        <p class="text-dark">{{__('We couldn\'t find any investment plan ')}}</p>
                    </div>
                    @endforelse
            </div>
            @endif
        </div>
    </div>
</div>
@stop