<div>

    @error('added')
    <div class="alert alert-danger">
        <div class="d-flex flex-column">
            <span>{{ $message }}</span>
        </div>
    </div>
    @enderror

    <form class="form w-100" wire:submit.prevent="submitLogin">
        @csrf
        <div class="text-center mb-10">
            <h1 class="text-dark mb-3">{{ __('Jump right back in') }}</h1>
            <div class="text-gray-600 fw-bold fs-4">{{ __('New Here?') }}
                <a href="{{ route('register') }}" class="link-primary fw-bolder">{{ __('Create an Account') }}</a>
            </div>
        </div>

        <div class="fv-row mb-10">
            <label class="form-label fs-6 fw-bolder text-dark">{{ __('Email') }}</label>
            <input class="form-control form-control-lg form-control-solid" type="email" wire:model.defer="email" required autocomplete="email" placeholder="name@email.com" />
            @error('email') <span class="form-text">{{ $message }}</span> @enderror
        </div>

        <div class="fv-row mb-10" wire:ignore>
            <div class="d-flex flex-stack mb-2">
                <label class="form-label fw-bolder text-dark fs-6 mb-0">{{ __('Password') }}</label>
                <a href="{{ route('user.password.request') }}" class="link-primary fs-6 fw-bolder">{{ __('Forgot Password ?') }}</a>
            </div>
            <div class="position-relative">
                <input class="form-control form-control-lg form-control-solid" type="password" required wire:model.defer="password" data-toggle="password" placeholder="XXXXXXXXX" />
                <span class="btn btn-sm btn-icon position-absolute translate-middle top-50 end-0 me-n2 input-password" style="z-index:10;">
                    <i class="bi bi-eye fs-2 text-dark"></i>
                </span>
            </div>
            @error('password') <span class="form-text">{{ $message }}</span> @enderror
        </div>

        <div class="form-check form-check-custom form-check-solid mb-6">
            <input class="form-check-input" type="checkbox" id="flexCheckDefault" wire:model.defer="remember_me" />
            <label class="form-check-label" for="flexCheckDefault">{{ __('Stayed signed in for 30 days') }}</label>
        </div>

        <div class="text-center">
            <button type="submit" class="btn btn-lg btn-primary btn-block fw-bolder me-3 my-2">
                <span wire:loading.remove wire:target="submitLogin">{{ __('Sign In') }}</span>
                <span wire:loading wire:target="submitLogin">{{ __('Signing In...') }}</span>
            </button>

            @if($set->google_sl)
            <a href="{{ route('redirect.login', ['type' => 'google']) }}" class="btn btn-secondary btn-block btn-lg fw-bolder my-2">
                <img alt="Google" src="{{ asset('dashboard/media/svg/brand-logos/google-icon.svg') }}" class="h-20px me-3">Sign in with Google
            </a>
            @endif

            @if($set->facebook_sl)
            <a href="{{ route('redirect.login', ['type' => 'facebook']) }}" class="btn btn-secondary btn-block btn-lg fw-bolder my-2">
                <img alt="Facebook" src="{{ asset('dashboard/media/svg/brand-logos/facebook-icon.svg') }}" class="h-20px me-3">Sign in with Facebook
            </a>
            @endif
        </div>
    </form>
    
</div>