<div>
    <div class="toolbar pb-0" id="kt_toolbar">
        <div class="container-fluid d-flex flex-stack flex-wrap">
            <div class="d-flex flex-column align-items-start justify-content-center flex-wrap me-2">
                <h1 class="text-dark fw-bolder my-1 fs-2">{{ __('Payout') }}</h1>
                <ul class="breadcrumb fw-semibold fs-base my-1 mb-6">
                    <li class="breadcrumb-item text-muted">
                        <a href="{{ route('admin.dashboard') }}" class="text-muted text-hover-primary">{{ __('Dashboard') }}</a>
                    </li>
                    <li class="breadcrumb-item text-dark">{{ __('Payout') }}</li>
                    <li class="breadcrumb-item text-dark">{{ ucwords($type) }}</li>
                </ul>

                @if($investW->count() > 0)
                    <div wire:loading.class.delay="opacity-50" wire:target="perPage loadMore">
                        <div class="card-body pt-0">
                         <div class="text-center">
                         <h5>Investment Withdrawals</h5>
                         </div>
                            <div class="w-100 table-responsive" wire:ignore>
                                <table class="table align-middle table-row-bordered table-row-gray-300 gy-5 gs-7" id="kt_datatable_example_5">
                                    <thead>
                                        <tr class="text-start text-dark fw-bolder fs-7 text-uppercase px-7">
                                            <th>{{ __('Name') }}</th>
                                            <th>{{ __('Amount') }}</th>
                                            <th>{{ __('Manage') }}</th>
                                        </tr>
                                    </thead>
                                    <tbody class="fw-semibold text-dark fs-6">
                                        @foreach($investW as $val)
                                            <tr class="cursor-pointer">
                                                <td>{{ $val->user->business->name }}</td>
                                                <td>
                                                    {{ $val->user->getFirstBalance()->getCurrency->real->currency_symbol }}
                                                    {{ currencyFormat(number_format($val->amount, 2)) }}
                                                    {{ $val->user->getFirstBalance()->getCurrency->real->currency }}
                                                </td>
                                                <td>
                                                    <a class="btn btn-sm btn-success" wire:click="approve({{ $val->id }})">Approve</a>
                                                    <a class="btn btn-sm btn-danger" wire:click="reject({{ $val->id }})">Reject</a>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>

                                @if($investW->total() > 0 && $investW->count() < $investW->total())
                                    <button wire:click="loadMore" wire:loading.remove class="btn btn-secondary btn-block">See more</button>
                                @endif
                            </div>
                        </div>
                    </div>
                @endif

                <ul class="nav nav-tabs nav-line-tabs nav-line-tabs-2x mb-5 fs-6 border-gray-300" id="tabs-icons-text" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link text-dark @if(route('admin.payout', ['type' => 'pending']) == url()->current()) active @endif"
                           href="{{ route('admin.payout', ['type' => 'pending']) }}">{{ __('Pending') }} ({{ number_format_short_nc($pending) }})</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link text-dark @if(route('admin.payout', ['type' => 'success']) == url()->current()) active @endif"
                           href="{{ route('admin.payout', ['type' => 'success']) }}">{{ __('Success') }} ({{ number_format_short_nc($success) }})</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link text-dark @if(route('admin.payout', ['type' => 'declined']) == url()->current()) active @endif"
                           href="{{ route('admin.payout', ['type' => 'declined']) }}">{{ __('Declined') }} ({{ number_format_short_nc($declined) }})</a>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    window.livewire.on('closeDrawer', function () {
        if (typeof KTDrawer !== 'undefined') {
            KTDrawer.hideAll();
            KTDrawer.createInstances();
        }
    });
</script>
@endpush