<div>
    <div wire:ignore.self class="modal fade" id="filter" tabindex="-1" role="dialog" aria-labelledby="modal-form" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title">{{__('Filter Messages')}}</h3>
                    <div class="btn btn-icon btn-sm btn-active-light-primary ms-2" data-bs-dismiss="modal" aria-label="Close">
                        <span class="svg-icon svg-icon-1">
                            <i class="fal fa-times"></i>
                        </span>
                    </div>
                </div>
                <div class="modal-body">
                    <div class="fv-row mb-6">
                        <label class="form-label fs-6 fw-bolder text-dark">{{__('Sort by')}}</label>
                        <select class="form-select form-select-solid" wire:model="sortBy">
                            <option value="asc">{{__('ASC')}}</option>
                            <option value="desc">{{__('DESC')}}</option>
                        </select>
                    </div>
                    <div class="fv-row mb-6">
                        <label class="form-label fs-6 fw-bolder text-dark">{{__('Order by')}}</label>
                        <select class="form-select form-select-solid" wire:model="orderBy">
                            <option value="created_at">{{__('Date')}}</option>
                        </select>
                    </div>
                    <div class="fv-row mb-6">
                        <label class="form-label fs-6 fw-bolder text-dark">{{__('Per page')}}</label>
                        <select class="form-select form-select-solid" wire:model="perPage">
                            <option value="10">{{__('10')}}</option>
                            <option value="25">{{__('25')}}</option>
                            <option value="50">{{__('50')}}</option>
                            <option value="100">{{__('100')}}</option>
                        </select>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="post fs-6 d-flex flex-column-fluid min-vh-100" id="kt_post">
        <div class="container">
            <div class="row g-xl-8">
                <div class="col-md-6">
                    <div class="d-flex flex-column align-items-start justify-content-center flex-wrap me-2">
                        <div class="input-group input-group-solid mb-5 rounded-4">
                            <span class="input-group-text" id="basic-addon1"><i class="fal fa-search"></i></span>
                            <input type="search" class="form-control form-control-solid text-dark" wire:model="search" placeholder="{{__('Search messages')}}" />
                        </div>
                    </div>
                </div>
                <div class="col-md-6 text-end">
                    <button data-bs-toggle="modal" data-bs-target="#deleteall" disabled id="deleteAll" class="btn btn-danger me-4"><i class="fal fa-trash"></i> {{__('Delete')}}</button>
                    <button data-bs-toggle="modal" data-bs-target="#filter" class="btn btn-dark me-4"><i class="fal fa-filter-list"></i> {{__('Filter')}}</button>
                </div>
            </div>
            <div wire:ignore.self class="modal fade" id="deleteall" tabindex="-1" role="dialog" aria-labelledby="modal-form" aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h3 class="modal-title">{{__('Delete Message')}}</h3>
                            <div class="btn btn-icon btn-sm btn-active-light-primary ms-2" data-bs-dismiss="modal" aria-label="Close">
                                <span class="svg-icon svg-icon-1">
                                    <i class="fal fa-times"></i>
                                </span>
                            </div>
                        </div>
                        <div class="modal-body">
                            <p>Are you sure you want to delete this?</p>
                            <div class="text-center">
                                <a wire:click="deleteAll" class="btn btn-danger btn-block">{{__('Delete')}}</span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @if($message->count() > 0)
            <div class="table-responsive">
                <table id="kt_datatable_zero_configuration" class="table table-row-bordered gy-5" wire:loading.class.delay="opacity-50" wire:target="search, status, sortBy, orderBy, perPage, loadMore">
                    <thead>
                        <tr class="fw-semibold fs-6 text-muted">
                            <th>
                                <div class="form-check form-check-sm form-check-custom form-check-solid">
                                    <input class="form-check-input" type="checkbox" id="all" wire:model="all" wire:click="setAll" />
                                </div>
                            </th>
                            <th class="min-w-20px">{{__('S/N')}}</th>
                            <th class="min-w-100px">{{__('Name')}}</th>
                            <th class="min-w-250px">{{__('Subject')}}</th>
                            <th class="min-w-150px">{{__('Created')}}</th>
                            <th class="scope"></th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($message as $val)
                        <tr>
                            <td>
                                <div class="form-check form-check-sm form-check-custom form-check-solid">
                                    <input class="form-check-input" type="checkbox" id="check{{$val->id}}" wire:model="archive.{{$val->id}}" wire:click="checked" />
                                </div>
                            </td>
                            <td>{{$loop->iteration}}.</td>
                            <td>{{$val->contact->first_name.' '.$val->contact->last_name}}</td>
                            <td>{{substr($val->subject, 0, 60)}}...</td>
                            <td>{{date("Y/m/d h:i:A", strtotime($val->created_at))}}</td>
                            <td class="text-center">
                                <button id="kt_message_{{$val->id}}_button" class="btn btn-sm btn-light-primary">Details</button>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                @if($message->total() > 0 && $message->count() < $message->total())<button wire:click="loadMore" wire:loading.remove class="btn btn-secondary btn-block">{{__('See more')}}</button>@endif
            </div>
            @else
            <div class="text-center mt-20">
                <img src="{{asset('asset/images/beneficiary.png')}}" style="height:auto; max-width:250px;" class="mb-6">
                <h3 class="text-dark">{{__('No Message Found')}}</h3>
                <p class="text-dark">{{__('We couldn\'t find any message in your inbox')}}</p>
            </div>
            @endif
        </div>
    </div>
    @foreach($message as $val)
    <livewire:admin.message.sent-message :val=$val :type=$type :admin=$admin :wire:key="'kt_message_'. $val->id">
        @endforeach
</div>
@push('scripts')
<script>
    window.livewire.on('closeDrawer', function() {
        KTDrawer.hideAll();
        KTDrawer.createInstances();
    });
    window.livewire.on('closeModal', function() {
        $('#deleteall').modal('hide');
    });
    window.livewire.on('clearMarkAll', function() {
        $('#add').val(0);
    });
    window.livewire.on('updatemarked', function(data) {
        $('#deleteAll').attr('disabled', (data == 1) ? false : true);
    });
    window.livewire.on('drawer', data => {
        KTDrawer.hideAll();
        KTDrawer.createInstances();
    });
</script>
@foreach($message as $val)
<script>
    $(document).on('click', '#readMore{{$val->id}}', function(e) {
        e.preventDefault();
        $('#main-data{{$val->id}}').hide();
        $('#main-data-hide{{$val->id}}').show();
    });
    $(document).on('click', '#readLess{{$val->id}}', function(e) {
        e.preventDefault();
        $('#main-data{{$val->id}}').show();
        $('#main-data-hide{{$val->id}}').hide();
    });
</script>
@endforeach
@endpush