<div>
    @if($val->type == 'project')
    @include('admin.invest.header', ['plan' => $val, 'type' => $type])
    @else
    @include('admin.invest.header-mutual', ['plan' => $val, 'type' => $type])
    @endif
    
    <div class="row g-xl-8">
        <div class="col-md-6">
            
        </div>
        <div class="col-md-6 text-end">
            <button id="create_trans_btn" class="btn btn-dark me-4 mb-3"><i class="fal fa-plus"></i> {{__('Create Transaction')}}</button>
        </div>
    </div>
    
    <div wire:ignore.self id="kt_mass_email" class="bg-white" data-kt-drawer="true" data-kt-drawer-activate="true" data-kt-drawer-toggle="#create_trans_btn" data-kt-drawer-close="#kt_mass_email_close" data-kt-drawer-width="{'md': '500px'}">
        <div class="card w-100">
            <div class="card-header pe-5 border-0">
                <div class="card-title">
                    <div class="d-flex justify-content-center flex-column me-3">
                        <div class="fs-4 fw-bolder text-gray-900 text-hover-primary me-1 lh-1">{{__('Create Transaction')}}</div>
                    </div>
                </div>
                <div class="card-toolbar">
                    <div class="btn btn-sm btn-icon btn-icon-dark btn-active-light-primary" data-kt-drawer-dismiss="true" id="kt_mass_email_close">
                        <span class="svg-icon svg-icon-2">
                            <i class="fal fa-times"></i>
                        </span>
                    </div>
                </div>
            </div>
            <div class="card-body text-wrap">
               
                <div class="pb-5 mt-10 position-relative zindex-1">
                    <form class="form w-100 mb-10" wire:submit.prevent="createTrans" method="post">
                    <div class="fv-row mb-6">
                            <input class="form-control form-control-lg form-control-solid" type="text" wire:model.defer="name" required placeholder="Name" />
                            @error('name')
                            <span class="form-text">{{$message}}</span>
                            @enderror
                        </div>
                        <div class="fv-row mb-6">
                            <input class="form-control form-control-lg form-control-solid" type="number" wire:model.defer="limitprice" required placeholder="Limit Price" step="0.01" />
                            @error('limitprice')
                            <span class="form-text">{{$message}}</span>
                            @enderror
                        </div>
                        
                         <div class="fv-row mb-6">
                            <input class="form-control form-control-lg form-control-solid" type="text" wire:model.defer="ttype" placeholder="Type" />
                            @error('ttype')
                            <span class="form-text">{{$message}}</span>
                            @enderror
                        </div>
                         <div class="fv-row mb-6">
                            <input class="form-control form-control-lg form-control-solid" type="text" wire:model.defer="positioneffect" placeholder="Position Effect" />
                            @error('positioneffect')
                            <span class="form-text">{{$message}}</span>
                            @enderror
                        </div>
                         <div class="fv-row mb-6">
                            <input class="form-control form-control-lg form-control-solid" type="text" wire:model.defer="timeinforce" placeholder="Time in force" />
                            @error('timeinforce')
                            <span class="form-text">{{$message}}</span>
                            @enderror
                        </div>
                         <div class="fv-row mb-6">
                            <input class="form-control form-control-lg form-control-solid" type="text" wire:model.defer="filledquantity" placeholder="Filled Quantity" />
                            @error('filledquantity')
                            <span class="form-text">{{$message}}</span>
                            @enderror
                        </div>
                         <div class="fv-row mb-6">
                            <input class="form-control form-control-lg form-control-solid" step="0.01" type="number" wire:model.defer="totalcost" placeholder="Total cost" />
                            @error('totalcost')
                            <span class="form-text">{{$message}}</span>
                            @enderror
                        </div>
                         <div class="fv-row mb-6">
                            <input class="form-control form-control-lg form-control-solid" step="0.01" type="number" wire:model.defer="fee" placeholder="Est. Regulatory fee" />
                            @error('fee')
                            <span class="form-text">{{$message}}</span>
                            @enderror
                        </div>
                         
                         <div class="fv-row mb-6">
                            <input class="form-control form-control-lg form-control-solid" type="number" wire:model.defer="quantity" placeholder="quantity" />
                            @error('quantity')
                            <span class="form-text">{{$message}}</span>
                            @enderror
                        </div>
                        <div class="fv-row mb-6">
                            <select class="form-select form-select-lg form-select-solid" required wire:model.defer="remark">
                            <option value="" selected>Select Remark</option>
                            <option value="profit">Profit</option>
                            <option value="loss">Loss</option>
                            </select>
                            @error('remark')
                            <span class="form-text">{{$message}}</span>
                            @enderror
                        </div>
                        <div class="fv-row mb-6">
                            <select class="form-select form-select-lg form-select-solid" wire:model.defer="signal">
                            <option value="" selected>Select Signal</option>
                            @foreach ($val->signals as $si)
                            <option value="{{$si->name}}">{{$si->name}} | {{$si->user->first_name}}</option>
                            @endforeach
                            </select>
                            @error('signal')
                            <span class="form-text">{{$message}}</span>
                            @enderror
                        </div>
                        <div class="text-center mt-10">
                            <button type="submit" class="btn btn-lg btn-primary btn-block fw-bolder me-3 my-2" id="filepond-upload">
                                <span wire:loading.remove wire:target="createTrans">{{__('Create')}}</span>
                                <span wire:loading wire:target="createTrans">{{__('Processing Request...')}}</span>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    
    <div class="card-body pt-0">
                                <div class="table-responsive">
                          
                                    <table class="table align-middle table-row-bordered table-row-gray-300 gy-5 gs-7" id="kt_datatable_example_5">
                                        <thead>
                                            <tr class="text-start text-dark fw-bolder fs-7 text-uppercase px-7">
                                                <th></th>
                                                <th class="min-w-150px">{{__('Name')}}</th>
                                             
                                                <th class="min-w-50px">{{__('Limit Price')}}</th>
                                                
                                                <th class="min-w-200px">{{__('Created')}}</th>
                                                <th class="">{{__('Action')}}</th>
                                            </tr>
                                            <!--end::Table row-->
                                        </thead>
                                        <tbody class="fw-semibold text-dark fs-6">
                                            @foreach($val->transactions as $vael)
<tr class="cursor-pointer">
    <td>
        <div class="symbol symbol-40px symbol-circle me-5">
            <div class="symbol-label fs-3 fw-bolder text-dark">
                @if($vael->remark == 'loss')
                <i class="fal fa-minus"></i>
                @else
                <i class="fal fa-plus"></i>
                @endif
            </div>
        </div>
    </td>
    <td>{{$vael->name}}</td>
    <td>{{$currency->currency_symbol.currencyFormat(number_format($vael->limit_price, 2)).' '.$currency->currency}}</td>
    
    <td>{{$vael->created_at->toDayDateTimeString()}}</td>
    <td><button wire:click="deleteTrans({{$vael->id}})" class="btn btn-danger">Delete</button></td>
</tr>
@endforeach
                                        </tbody>
                                    </table>
                              
                                </div>
                            </div>
    
</div>
