@extends('front.menu')
<meta name="description" content="{{__('Send & Receive money at the lowest cost')}}" />
@section('css')

@stop
@section('content')
<section class="bg-light py-lg-5 pt-5" style="background-image: url({{asset('asset/images/hero-bg.svg')}});" data-jarallax data-img-position="0% 100%" data-speed="0.5">
    <div class="container py-6">
        <div class="row">
            <div class="col-md-12 mb-3">
                <div class="text-center">
                    <h1 class="display-4 mb-md-5 mb-3 pb-3">
                        <span class="">{{__('Send & Receive money at the lowest cost')}}</span>
                    </h1>
                    <p class="mb-1 text-dark">{{__('Instantly transfer money to anyone with minimal fees. Our commitment to transparency ensures a clear process for sending funds.')}}</p>
                </div>
            </div>
        </div>
    </div>
</section>
<section class="container position-relative mt-5" id="pricing">
    <div class="table-responsive-lg">
        <!-- Pricing plan -->
        <div class="card bg-dark position-relative rounded-3  p-3 p-lg-5 border mb-5">
            <div class="bg-transparent">
                <div class="card-body text-light">
                    <div class="row">
                        <div class="col-md-6">
                            <h3 class="text-light mb-2">{{__('Account fees')}}</h3>
                            <div class="display-5 mb-1">
                            @if($country->sepa_deposit_type == "both")
                                {{$country->sepa_deposit_percent}}% + {{$country->sepa_deposit_fiat.' '.$country->real->currency}}
                                @elseif($country->sepa_deposit_type == "fiat")
                                {{$country->sepa_deposit_fiat.' '.$country->real->currency}}
                                @elseif($country->sepa_deposit_type == "percent")
                                {{$country->sepa_deposit_percent}}%
                                @elseif($country->sepa_deposit_type == "max")
                                > {{$country->sepa_deposit_fiat.' '.$country->real->currency}} - {{$country->sepa_deposit_percent}}%
                                @elseif($country->sepa_deposit_type == "min")
                                < {{$country->sepa_deposit_fiat.' '.$country->real->currency}} - {{$country->sepa_deposit_percent}}% @endif 
                            </div>
                            <div class="mb-3 fs-sm">{{__('Sepa Deposit fee')}}</div>
                            <div class="display-5 mb-1">
                            @if($country->faster_deposit_type == "both")
                                {{$country->faster_deposit_percent}}% + {{$country->faster_deposit_fiat.' '.$country->real->currency}}
                                @elseif($country->faster_deposit_type == "fiat")
                                {{$country->faster_deposit_fiat.' '.$country->real->currency}}
                                @elseif($country->faster_deposit_type == "percent")
                                {{$country->faster_deposit_percent}}%
                                @elseif($country->faster_deposit_type == "max")
                                > {{$country->faster_deposit_fiat.' '.$country->real->currency}} - {{$country->faster_deposit_percent}}%
                                @elseif($country->faster_deposit_type == "min")
                                < {{$country->faster_deposit_fiat.' '.$country->real->currency}} - {{$country->faster_deposit_percent}}% @endif 
                            </div>
                            <div class="mb-0 fs-sm">{{__('Faster Deposit fee')}}</div>
                            <div class="display-5 mb-1">
                            @if($country->swift_deposit_type == "both")
                                {{$country->swift_deposit_percent}}% + {{$country->swift_deposit_fiat.' '.$country->real->currency}}
                                @elseif($country->swift_deposit_type == "fiat")
                                {{$country->swift_deposit_fiat.' '.$country->real->currency}}
                                @elseif($country->swift_deposit_type == "percent")
                                {{$country->swift_deposit_percent}}%
                                @elseif($country->swift_deposit_type == "max")
                                > {{$country->swift_deposit_fiat.' '.$country->real->currency}} - {{$country->swift_deposit_percent}}%
                                @elseif($country->swift_deposit_type == "min")
                                < {{$country->swift_deposit_fiat.' '.$country->real->currency}} - {{$country->swift_deposit_percent}}% @endif 
                            </div>
                            <div class="mb-0 fs-sm">{{__('Swift Deposit fee')}}</div>
                        </div>
                        <div class="col-md-6">
                            <div class="fw-medium fs-lg mb-1">{{__('Transfer to a '.$set->site_name.' account')}}</div>
                            <p class="mb-0 fs-sm">
                            @if($country->daa_transfer_type == "both")
                                {{$country->daa_percent}}% + {{$country->daa_fiat.' '.$country->real->currency}}
                                @elseif($country->daa_transfer_type == "fiat")
                                {{$country->daa_fiat.' '.$country->real->currency}}
                                @elseif($country->daa_transfer_type == "percent")
                                {{$country->daa_percent}}%
                                @elseif($country->daa_transfer_type == "max")
                                > {{$country->daa_fiat.' '.$country->real->currency}} - {{$country->daa_percent}}%
                                @elseif($country->daa_transfer_type == "min")
                                < {{$country->daa_fiat.' '.$country->real->currency}} - {{$country->daa_percent}}% @endif 
                            </p>

                            <div class="fw-medium fs-lg mb-1">{{__('Transfer to a '.$set->site_name.' card')}}</div>
                            <p class="mb-0 fs-sm">
                            @if($country->dac_transfer_type == "both")
                                {{$country->dac_percent}}% + {{$country->dac_fiat.' '.$country->real->currency}}
                                @elseif($country->dac_transfer_type == "fiat")
                                {{$country->dac_fiat.' '.$country->real->currency}}
                                @elseif($country->dac_transfer_type == "percent")
                                {{$country->dac_percent}}%
                                @elseif($country->dac_transfer_type == "max")
                                > {{$country->dac_fiat.' '.$country->real->currency}} - {{$country->dac_percent}}%
                                @elseif($country->dac_transfer_type == "min")
                                < {{$country->dac_fiat.' '.$country->real->currency}} - {{$country->dac_percent}}% @endif 
                            </p>
                            <div class="fw-medium fs-lg mb-1">{{__('Sepa Transfer')}}</div>
                            <p class="mb-0 fs-sm">
                                @if($country->sepa_transfer_type == "both")
                                {{$country->sepa_percent}}% + {{$country->sepa_fiat.' '.$country->real->currency}}
                                @elseif($country->sepa_transfer_type == "fiat")
                                {{$country->sepa_fiat.' '.$country->real->currency}}
                                @elseif($country->sepa_transfer_type == "percent")
                                {{$country->sepa_percent}}%
                                @elseif($country->sepa_transfer_type == "max")
                                > {{$country->sepa_fiat.' '.$country->real->currency}} - {{$country->sepa_percent}}%
                                @elseif($country->sepa_transfer_type == "min")
                                < {{$country->sepa_fiat.' '.$country->real->currency}} - {{$country->sepa_percent}}% @endif
                            </p>
                            <div class="fw-medium fs-lg mb-1">{{__('Faster Payment Transfer')}}</div>
                            <p class="mb-0 fs-sm">
                                @if($country->faster_transfer_type == "both")
                                {{$country->faster_percent}}% + {{$country->faster_fiat.' '.$country->real->currency}}
                                @elseif($country->faster_transfer_type == "fiat")
                                {{$country->faster_fiat.' '.$country->real->currency}}
                                @elseif($country->faster_transfer_type == "percent")
                                {{$country->faster_percent}}%
                                @elseif($country->faster_transfer_type == "max")
                                > {{$country->faster_fiat.' '.$country->real->currency}} - {{$country->faster_percent}}%
                                @elseif($country->faster_transfer_type == "min")
                                < {{$country->faster_fiat.' '.$country->real->currency}} - {{$country->faster_percent}}% @endif
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
</section>
<section class="container position-relative mt-5" id="pricing">
    <div class="table-responsive-lg">
        <!-- Pricing plan -->
        <div class="card bg-dark position-relative rounded-3  p-3 p-lg-5 border mb-5">
            <div class="bg-transparent">
                <div class="card-body text-light">
                    <div class="row">
                        <div class="col-md-6">
                            <h3 class="text-light mb-2">{{__('Card fees')}}</h3>
                            <div class="display-5 mb-1">
                            @if($country->sac_transfer_type == "both")
                                {{$country->sac_percent}}% + {{$country->sac_fiat.' '.$country->real->currency}}
                                @elseif($country->sac_transfer_type == "fiat")
                                {{$country->sac_fiat.' '.$country->real->currency}}
                                @elseif($country->sac_transfer_type == "percent")
                                {{$country->sac_percent}}%
                                @elseif($country->sac_transfer_type == "max")
                                > {{$country->sac_fiat.' '.$country->real->currency}} - {{$country->sac_percent}}%
                                @elseif($country->sac_transfer_type == "min")
                                < {{$country->sac_fiat.' '.$country->real->currency}} - {{$country->sac_percent}}% @endif 
                            </div>
                            <div class="mb-3 fs-sm">{{__('Funding fee')}}</div>
                            <div class="display-5 mb-1">@if($country->sca_transfer_type == "both")
                                {{$country->sca_percent}}% + {{$country->sca_fiat.' '.$country->real->currency}}
                                @elseif($country->sca_transfer_type == "fiat")
                                {{$country->sca_fiat.' '.$country->real->currency}}
                                @elseif($country->sca_transfer_type == "percent")
                                {{$country->sca_percent}}%
                                @elseif($country->sca_transfer_type == "max")
                                > {{$country->sca_fiat.' '.$country->real->currency}} - {{$country->sca_percent}}%
                                @elseif($country->sca_transfer_type == "min")
                                < {{$country->sca_fiat.' '.$country->real->currency}} - {{$country->sca_percent}}% @endif </div>
                            <div class="mb-0 fs-sm">{{__('Withdrawal fee')}}</div>
                        </div>
                        <div class="col-md-6">
                            <div class="fw-medium fs-lg mb-1">{{__('ATM')}}</div>
                            <p class="mb-0 fs-sm">
                                @if($country->card_atm_type == "both")
                                {{$country->card_atm_percent}}% + {{$country->card_atm_fiat.' '.$country->real->currency}}
                                @elseif($country->card_atm_type == "fiat")
                                {{$country->card_atm_fiat.' '.$country->real->currency}}
                                @elseif($country->card_atm_type == "percent")
                                {{$country->card_atm_percent}}%
                                @elseif($country->card_atm_type == "max")
                                > {{$country->card_atm_fiat.' '.$country->real->currency}} - {{$country->card_atm_percent}}%
                                @elseif($country->card_atm_type == "min")
                                < {{$country->card_atm_fiat.' '.$country->real->currency}} - {{$country->card_atm_percent}}% @endif
                            </p>

                            <div class="fw-medium fs-lg mb-1">{{__('Card Refund')}}</div>
                            <p class="mb-0 fs-sm">
                                @if($country->card_refund_type == "both")
                                {{$country->card_refund_percent}}% + {{$country->card_refund_fiat.' '.$country->real->currency}}
                                @elseif($country->card_refund_type == "fiat")
                                {{$country->card_refund_fiat.' '.$country->real->currency}}
                                @elseif($country->card_refund_type == "percent")
                                {{$country->card_refund_percent}}%
                                @elseif($country->card_refund_type == "max")
                                > {{$country->card_refund_fiat.' '.$country->real->currency}} - {{$country->card_refund_percent}}%
                                @elseif($country->card_refund_type == "min")
                                < {{$country->card_refund_fiat.' '.$country->real->currency}} - {{$country->card_refund_percent}}% @endif
                            </p>

                            <div class="fw-medium fs-lg mb-1">{{__('Online Transaction')}}</div>
                            <p class="mb-0 fs-sm">
                                @if($country->card_trx_type == "both")
                                {{$country->card_trx_percent}}% + {{$country->card_trx_fiat.' '.$country->real->currency}}
                                @elseif($country->card_trx_type == "fiat")
                                {{$country->card_trx_fiat.' '.$country->real->currency}}
                                @elseif($country->card_trx_type == "percent")
                                {{$country->card_trx_percent}}%
                                @elseif($country->card_trx_type == "max")
                                > {{$country->card_trx_fiat.' '.$country->real->currency}} - {{$country->card_trx_percent}}%
                                @elseif($country->card_trx_type == "min")
                                < {{$country->card_trx_fiat.' '.$country->real->currency}} - {{$country->card_trx_percent}}% @endif
                            </p>

                            <div class="fw-medium fs-lg mb-1">{{__('Transfer to a '.$set->site_name.' account')}}</div>
                            <p class="mb-0 fs-sm">
                                @if($country->dca_transfer_type == "both")
                                {{$country->dca_percent}}% + {{$country->dca_fiat.' '.$country->real->currency}}
                                @elseif($country->dca_transfer_type == "fiat")
                                {{$country->dca_fiat.' '.$country->real->currency}}
                                @elseif($country->dca_transfer_type == "percent")
                                {{$country->dca_percent}}%
                                @elseif($country->dca_transfer_type == "max")
                                > {{$country->dca_fiat.' '.$country->real->currency}} - {{$country->dca_percent}}%
                                @elseif($country->dca_transfer_type == "min")
                                < {{$country->dca_fiat.' '.$country->real->currency}} - {{$country->dca_percent}}% @endif 
                            </p>

                            <div class="fw-medium fs-lg mb-1">{{__('Transfer to a '.$set->site_name.' card')}}</div>
                            <p class="mb-0 fs-sm">
                                @if($country->dcc_transfer_type == "both")
                                {{$country->dcc_percent}}% + {{$country->dcc_fiat.' '.$country->real->currency}}
                                @elseif($country->dcc_transfer_type == "fiat")
                                {{$country->dcc_fiat.' '.$country->real->currency}}
                                @elseif($country->dcc_transfer_type == "percent")
                                {{$country->dcc_percent}}%
                                @elseif($country->dcc_transfer_type == "max")
                                > {{$country->dcc_fiat.' '.$country->real->currency}} - {{$country->dcc_percent}}%
                                @elseif($country->dcc_transfer_type == "min")
                                < {{$country->dcc_fiat.' '.$country->real->currency}} - {{$country->dcc_percent}}% @endif 
                            </p>
                            <div class="fw-medium fs-lg mb-1">{{__('Sepa Transfer')}}</div>
                            <p class="mb-0 fs-sm">
                                @if($country->sepa_transfer_type == "both")
                                {{$country->sepa_percent}}% + {{$country->sepa_fiat.' '.$country->real->currency}}
                                @elseif($country->sepa_transfer_type == "fiat")
                                {{$country->sepa_fiat.' '.$country->real->currency}}
                                @elseif($country->sepa_transfer_type == "percent")
                                {{$country->sepa_percent}}%
                                @elseif($country->sepa_transfer_type == "max")
                                > {{$country->sepa_fiat.' '.$country->real->currency}} - {{$country->sepa_percent}}%
                                @elseif($country->sepa_transfer_type == "min")
                                < {{$country->sepa_fiat.' '.$country->real->currency}} - {{$country->sepa_percent}}% @endif
                            </p>
                            <div class="fw-medium fs-lg mb-1">{{__('Faster Payment Transfer')}}</div>
                            <p class="mb-0 fs-sm">
                                @if($country->faster_transfer_type == "both")
                                {{$country->faster_percent}}% + {{$country->faster_fiat.' '.$country->real->currency}}
                                @elseif($country->faster_transfer_type == "fiat")
                                {{$country->faster_fiat.' '.$country->real->currency}}
                                @elseif($country->faster_transfer_type == "percent")
                                {{$country->faster_percent}}%
                                @elseif($country->faster_transfer_type == "max")
                                > {{$country->faster_fiat.' '.$country->real->currency}} - {{$country->faster_percent}}%
                                @elseif($country->faster_transfer_type == "min")
                                < {{$country->faster_fiat.' '.$country->real->currency}} - {{$country->faster_percent}}% @endif
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
</section>

@include('partials.livechat')
@stop