
<?php
header("Location: https://dashboard.sigmond-advisory.com/login");
exit;
?>

@extends('front.menu')
@section('css')

@stop
@section('content')
<section class="position-relative py-lg-5 pt-5" style="background-image: url({{asset('asset/images/hero-bg.svg')}});" data-jarallax data-img-position="0% 100%" data-speed="0.5">
    <div class="container position-relative zindex-2 pt-5 pb-2 pb-md-0 py-6">
        <div class="row justify-content-center pt-3 mt-3">
            <div class="col-xl-6 col-lg-7 col-md-8 col-sm-10 text-center">
                <h1 class="mb-4">{{__('About Us')}}</h1>
            </div>
        </div>
    </div>
</section>
<section class="container mb-5 pt-4 pb-2 py-mg-4">
    <div class="row gy-4">
        <div class="col-lg-12">
            <p class="text-start">{!!$set->about!!}</p>
        </div>
    </div>
</section>
<section class="container py-5 my-md-3 my-lg-5">
    <h2 class="h1 text-center pt-1 pb-3 mb-3 mb-lg-4">{{__('The Team')}}</h2>
    <div class="row row-cols-1 row-cols-sm-2 row-cols-md-6 g-4">

        <!-- Item -->
        @foreach(getTeam() as $val)
        <div class="col">
            <div class="card card-hover border-0 bg-transparent">
                <div class="position-relative">
                    <img src="{{url('/').'/storage/app/'.$val->image}}" class="rounded-3" alt="{{$val->name}}">
                    <div class="card-img-overlay d-flex flex-column align-items-center justify-content-center rounded-3">
                        <span class="position-absolute top-0 start-0 w-100 h-100 bg-dark opacity-25 rounded-3"></span>
                        <div class="position-relative d-flex zindex-2">
                            @if($val->linkedin != null)
                            <a href="{{$val->linkedin}}" target="_blank" class="btn btn-icon btn-secondary btn-linkedin btn-sm bg-white me-2">
                                <i class="bx bxl-linkedin"></i>
                            </a>
                            @endif
                            @if($val->twitter != null)
                            <a href="{{$val->twitter}}" target="_blank" class="btn btn-icon btn-secondary btn-twitter btn-sm bg-white">
                                <i class="bx bxl-twitter"></i>
                            </a>
                            @endif
                        </div>
                    </div>
                </div>
                <div class="card-body text-center p-3">
                    <h3 class="fs-lg fw-semibold pt-1 mb-2">{{$val->name}}</h3>
                    <p class="fs-sm mb-0">{{$val->position}}</p>
                </div>
            </div>
        </div>
        @endforeach
    </div>
</section>
@if(count(getReview()))
<section class="container mb-5 pt-2 pb-3 py-md-4 py-lg-5">
    <h2 class="h1 pb-2 pb-lg-0 mb-4 mb-lg-5 text-center">{{getUi()->h4_b}}</h2>
    <div class="row">
        <div class="col-md-8">
            <div class="card border-0 shadow-sm p-4 p-xxl-5 mb-4 me-xxl-4 rounded-5 bg-dark">

                <!-- Quotation mark -->
                <div class="pb-4 mb-2">
                    <span class="btn btn-icon btn-secondary btn-lg pe-none">
                        <i class="fad fa-quote-left"></i>
                    </span>
                </div>

                <!-- Slider -->
                <div class="swiper mx-0 mb-md-n2 mb-xxl-n3" data-swiper-options='{
                "spaceBetween": 24,
                "pager": true,
                "loop": true,
                "tabs": true,
                "navigation": {
                  "prevEl": ".page-prev",
                  "nextEl": ".page-next"
                }
              }'>
                    <div class="swiper-wrapper">
                        @foreach(getReview() as $val)
                        <div class="swiper-slide h-auto" data-swiper-tab="#author-{{$loop->iteration}}">
                            <figure class="card h-100 position-relative border-0 bg-dark">
                                <blockquote class="card-body p-0 mb-0">
                                    <p class="fs-6 mb-0 text-white">{{$val->review}}</p>
                                </blockquote>
                                <figcaption class="card-footer border-0 d-sm-flex d-md-none w-100 pb-2">
                                    <div class="d-flex align-items-center border-end-sm pe-sm-4 me-sm-2">
                                        <img src="{{url('/').'/storage/app/'.$val->image}}" width="48" class="rounded-3" alt="Ralph Edwards">
                                        <div class="ps-3">
                                            <h5 class="fw-semibold lh-base mb-0 text-white">{{$val->name}}</h5>
                                            <span class="fs-sm text-white">{{$val->occupation}}</span>
                                        </div>
                                    </div>
                                </figcaption>
                            </figure>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>

            <!-- Pagination (Pager) -->
            <nav class="pagination d-flex justify-content-center justify-content-md-start">
                <div class="page-item me-2">
                    <a class="page-link page-prev btn-icon btn-sm" href="#">
                        <i class="bx bx-chevron-left"></i>
                    </a>
                </div>
                <ul class="list-unstyled d-flex justify-content-center w-auto mb-0"></ul>
                <div class="page-item ms-2">
                    <a class="page-link page-next btn-icon btn-sm" href="#">
                        <i class="bx bx-chevron-right"></i>
                    </a>
                </div>
            </nav>
        </div>
        <div class="col-md-4 d-none d-md-block">

            <!-- Swiper tabs (Author images) -->
            <div class="swiper-tabs">
                @foreach(getReview() as $val)
                <div id="author-{{$loop->iteration}}" class="card bg-transparent border-0 swiper-tab @if($loop->first)active @endif">
                    <div class="card-body p-0 rounded-5 bg-size-cover bg-repeat-0 bg-position-top-center" style="background-image: url('{{url('/').'/storage/app/'.$val->image}}');"></div>
                    <div class="card-footer d-flex w-100 border-0 pb-0">
                        <div class="ps-xl-4 ms-xl-2">
                            <h5 class="fw-semibold lh-base mb-0">{{$val->name}}</h5>
                            <span class="fs-sm text-muted">{{$val->occupation}}</span>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
</section>
@endif
@include('partials.livechat')
@stop