@extends('auth.menu')

@section('content')
<div class="d-flex flex-column flex-lg-row-fluid py-10">
  <div class="d-flex flex-center flex-column flex-column-fluid">
    <div class="w-lg-500px w-100 p-10 p-lg-15 mx-auto">
      <form class="form w-100" action="{{route('create.pin')}}" method="post">
        @csrf
        <div class="text-center mb-10">
          <h1 class="text-dark mb-3">{{__('Setup Pin')}}</h1>
          <div class="text-gray-600 fw-bold fs-4">{{__('This is required to transfer investment units to any ').$set->site_name.__(' account be it friends or family')}}</div>
        </div>
        <div class="fv-row mb-10">
          <label class="form-label fs-6 fw-bolder text-dark">{{__('Code')}}</label>
          <input class="form-control form-control-lg form-control-solid" name="pin" type="tel" minlength="4" maxlength="6" pattern="[0-9]+" autocomplete="one-time-code" value="{{old('code')}}" required placeholder="XXXX" autofocus onkeyup="this.value=removeSpacesPin(this.value);" onmouseout="this.value=removeSpacesPin(this.value);" />
          @error('pin')
          <span class="form-text">{{ $message}}</span>
          @enderror
        </div>
        @if($set->recaptcha==1)
        {!! RecaptchaV3::field('pin') !!}
        @error('g-recaptcha-response')
        <span class="form-text">{{$message}}</span>
        @enderror
        @endif
        <div class="text-center">
          <button type="submit" class="btn btn-lg btn-primary btn-block fw-bolder me-3 my-2">
            <span class="indicator-label">{{__('Create Pin')}}</span>
          </button>
        </div>
      </form>
    </div>
  </div>
  @include('partials.external')
</div>
@stop