@extends('auth.menu')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/css/intlTelInput.css" />
@section('content')
<div class="d-flex flex-column flex-lg-row-fluid py-10">
  <div class="d-flex flex-center flex-column flex-column-fluid">
    <div class="w-lg-600px w-100 p-10 p-lg-15 mx-auto">
      <form class="form w-100" action="{{route('user.create-phone')}}" method="post" id="kt_sign_up_form" novalidate="novalidate">
        @csrf
        <div class="text-center mb-10">
          <h1 class="text-dark mb-3">{{__('Add Mobile')}}</h1>
        </div>
        <div class="fv-row mb-6">
          <label class="form-label fs-6 fw-bolder text-dark">{{__('Phone')}}</label>
          <input type="hidden" name="code" id="code" class="text-uppercase">
          <input type="tel" name="phone" id="phone" value="{{old('phone')}}" class="form-control form-control-lg form-control-solid" required>
          @error('phone')
          <span class="form-text">{{$message}}</span>
          @enderror
        </div>
        <div class="text-center">
          <button type="submit" class="btn btn-lg btn-primary btn-block fw-bolder me-3 my-2" id="kt_sign_up_submit">
            <span class="indicator-label">{{__('Submit')}}</span>
          </button>
        </div>
      </form>
    </div>
  </div>
  @include('partials.external')
</div>
@stop
@section('script')
<script src="{{asset('front/vendor/jquery/dist/jquery.min.js')}}"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/intlTelInput.min.js"></script>
<script>
  const phoneInputField = document.querySelector("#phone");
  const phoneInput = window.intlTelInput(phoneInputField, {
    onlyCountries: ['{{$currency->iso2}}'],
    utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/utils.js",
  });
  var old = "{{old('code')}}";
  if (old.trim() != '') {
    phoneInput.setCountry(old)
  }
  $('#code').val(phoneInput.getSelectedCountryData().iso2);
  phoneInputField.addEventListener("countrychange", function() {
    $('#code').val(phoneInput.getSelectedCountryData().iso2);
  });
</script>
@endsection