@extends('auth.menu')

@section('content')
<div class="d-flex flex-column flex-lg-row-fluid py-10">
  <div class="d-flex flex-center flex-column flex-column-fluid">
    <div class="w-lg-500px w-100 p-10 p-lg-15 mx-auto">
      <form class="form w-100" action="{{route('user.password.email')}}" method="post">
        @csrf
        <div class="text-center mb-10">
          <h1 class="text-dark mb-3">{{__('Reset Password')}}</h1>
          <div class="text-gray-600 fw-bold fs-4">{{__('Insert the email you created the account with and we\'ll send you a reset link.')}}</div>
          <div class="text-gray-600 fw-bold fs-4">{{__('Already have an account?')}}
            <a href="{{route('login')}}" class="link-primary fw-bolder">{{__('Sign in here')}}</a>
          </div>
        </div>
        <div class="fv-row mb-10">
          <label class="form-label fs-6 fw-bolder text-dark">{{__('Email')}}</label>
          <input class="form-control form-control-lg form-control-solid" type="email" name="email" autocomplete="email" value="{{old('email')}}" required placeholder="name@email.com"/>
          @error('email')
          <span class="form-text">{{$message}}</span>
          @enderror
        </div>
        @if($set->recaptcha==1)
        {!! RecaptchaV3::field('reset') !!}
        @error('g-recaptcha-response')
        <span class="form-text">{{$message}}</span>
        @enderror
        @endif
        <div class="text-center">
          <button type="submit" class="btn btn-lg btn-primary btn-block fw-bolder me-3 my-2">
            <span class="indicator-label">{{__('Send reset link')}}</span>
          </button>
        </div>
      </form>
    </div>
  </div>
  @include('partials.external')
</div>
@stop