@extends('auth.menu')

@section('content')
<div class="d-flex flex-column flex-lg-row-fluid py-10">
  <div class="d-flex flex-center flex-column flex-column-fluid">
    <div class="w-lg-500px w-100 p-10 p-lg-15 mx-auto">
      <livewire:auth.login :set="$set" />
    </div>
  </div>
  @include('partials.external')
</div>
@endsection

@section('script')
<script>
  function setupPasswordToggle() {
    $('[data-toggle="password"]').each(function () {
      var input = $(this);
      var eye_btn = input.parent().find('.input-password');
      eye_btn.css('cursor', 'pointer').addClass('input-password-hide');

      eye_btn.off('click').on('click', function () {
        if (eye_btn.hasClass('input-password-hide')) {
          eye_btn.removeClass('input-password-hide').addClass('input-password-show');
          eye_btn.find('.bi').removeClass('bi-eye').addClass('bi-eye-slash');
          input.attr('type', 'text');
        } else {
          eye_btn.removeClass('input-password-show').addClass('input-password-hide');
          eye_btn.find('.bi').removeClass('bi-eye-slash').addClass('bi-eye');
          input.attr('type', 'password');
        }
      });
    });
  }

  document.addEventListener('livewire:load', setupPasswordToggle);
  window.livewire.on('added', setupPasswordToggle);
</script>
@endsection