/*!
 * Font Awesome Pro 6.1.1 by @fontawesome - https://fontawesome.com
 * License - https://fontawesome.com/license (Commercial License)
 * Copyright 2022 Fonticons, Inc.
 */
(function () {
  'use strict';

  var _WINDOW = {};
  var _DOCUMENT = {};

  try {
    if (typeof window !== 'undefined') _WINDOW = window;
    if (typeof document !== 'undefined') _DOCUMENT = document;
  } catch (e) {}

  var _ref = _WINDOW.navigator || {},
      _ref$userAgent = _ref.userAgent,
      userAgent = _ref$userAgent === void 0 ? '' : _ref$userAgent;
  var WINDOW = _WINDOW;
  var DOCUMENT = _DOCUMENT;
  var IS_BROWSER = !!WINDOW.document;
  var IS_DOM = !!DOCUMENT.documentElement && !!DOCUMENT.head && typeof DOCUMENT.addEventListener === 'function' && typeof DOCUMENT.createElement === 'function';
  var IS_IE = ~userAgent.indexOf('MSIE') || ~userAgent.indexOf('Trident/');

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);

    if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);
      enumerableOnly && (symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      })), keys.push.apply(keys, symbols);
    }

    return keys;
  }

  function _objectSpread2(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = null != arguments[i] ? arguments[i] : {};
      i % 2 ? ownKeys(Object(source), !0).forEach(function (key) {
        _defineProperty(target, key, source[key]);
      }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) {
        Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
      });
    }

    return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) return _arrayLikeToArray(arr);
  }

  function _iterableToArray(iter) {
    if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter);
  }

  function _unsupportedIterableToArray(o, minLen) {
    if (!o) return;
    if (typeof o === "string") return _arrayLikeToArray(o, minLen);
    var n = Object.prototype.toString.call(o).slice(8, -1);
    if (n === "Object" && o.constructor) n = o.constructor.name;
    if (n === "Map" || n === "Set") return Array.from(o);
    if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
  }

  function _arrayLikeToArray(arr, len) {
    if (len == null || len > arr.length) len = arr.length;

    for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];

    return arr2;
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }

  var NAMESPACE_IDENTIFIER = '___FONT_AWESOME___';
  var PRODUCTION = function () {
    try {
      return "production" === 'production';
    } catch (e) {
      return false;
    }
  }();
  var STYLE_TO_PREFIX = {
    'solid': 'fas',
    'regular': 'far',
    'light': 'fal',
    'thin': 'fat',
    'duotone': 'fad',
    'brands': 'fab',
    'kit': 'fak'
  };
  var oneToTen = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10];
  var oneToTwenty = oneToTen.concat([11, 12, 13, 14, 15, 16, 17, 18, 19, 20]);
  var DUOTONE_CLASSES = {
    GROUP: 'duotone-group',
    SWAP_OPACITY: 'swap-opacity',
    PRIMARY: 'primary',
    SECONDARY: 'secondary'
  };
  var RESERVED_CLASSES = [].concat(_toConsumableArray(Object.keys(STYLE_TO_PREFIX)), ['2xs', 'xs', 'sm', 'lg', 'xl', '2xl', 'beat', 'border', 'fade', 'beat-fade', 'bounce', 'flip-both', 'flip-horizontal', 'flip-vertical', 'flip', 'fw', 'inverse', 'layers-counter', 'layers-text', 'layers', 'li', 'pull-left', 'pull-right', 'pulse', 'rotate-180', 'rotate-270', 'rotate-90', 'rotate-by', 'shake', 'spin-pulse', 'spin-reverse', 'spin', 'stack-1x', 'stack-2x', 'stack', 'ul', DUOTONE_CLASSES.GROUP, DUOTONE_CLASSES.SWAP_OPACITY, DUOTONE_CLASSES.PRIMARY, DUOTONE_CLASSES.SECONDARY]).concat(oneToTen.map(function (n) {
    return "".concat(n, "x");
  })).concat(oneToTwenty.map(function (n) {
    return "w-".concat(n);
  }));

  function bunker(fn) {
    try {
      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }

      fn.apply(void 0, args);
    } catch (e) {
      if (!PRODUCTION) {
        throw e;
      }
    }
  }

  var w = WINDOW || {};
  if (!w[NAMESPACE_IDENTIFIER]) w[NAMESPACE_IDENTIFIER] = {};
  if (!w[NAMESPACE_IDENTIFIER].styles) w[NAMESPACE_IDENTIFIER].styles = {};
  if (!w[NAMESPACE_IDENTIFIER].hooks) w[NAMESPACE_IDENTIFIER].hooks = {};
  if (!w[NAMESPACE_IDENTIFIER].shims) w[NAMESPACE_IDENTIFIER].shims = [];
  var namespace = w[NAMESPACE_IDENTIFIER];

  function normalizeIcons(icons) {
    return Object.keys(icons).reduce(function (acc, iconName) {
      var icon = icons[iconName];
      var expanded = !!icon.icon;

      if (expanded) {
        acc[icon.iconName] = icon.icon;
      } else {
        acc[iconName] = icon;
      }

      return acc;
    }, {});
  }

  function defineIcons(prefix, icons) {
    var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    var _params$skipHooks = params.skipHooks,
        skipHooks = _params$skipHooks === void 0 ? false : _params$skipHooks;
    var normalized = normalizeIcons(icons);

    if (typeof namespace.hooks.addPack === 'function' && !skipHooks) {
      namespace.hooks.addPack(prefix, normalizeIcons(icons));
    } else {
      namespace.styles[prefix] = _objectSpread2(_objectSpread2({}, namespace.styles[prefix] || {}), normalized);
    }
    /**
     * Font Awesome 4 used the prefix of `fa` for all icons. With the introduction
     * of new styles we needed to differentiate between them. Prefix `fa` is now an alias
     * for `fas` so we'll ease the upgrade process for our users by automatically defining
     * this as well.
     */


    if (prefix === 'fas') {
      defineIcons('fa', icons);
    }
  }

  var icons = {
    "0": [320, 512, [], "30", "M160 32.01c-88.37 0-160 71.63-160 160v127.1c0 88.37 71.63 160 160 160s160-71.63 160-160V192C320 103.6 248.4 32.01 160 32.01zM304 320c0 79.4-64.6 144-144 144S16 399.4 16 320V192c0-79.4 64.6-144 144-144s144 64.6 144 144V320z"],
    "1": [256, 512, [], "31", "M256 472c0 4.406-3.578 8-8 8h-240C3.578 480 0 476.4 0 472s3.578-8 8-8h112V53.94L36.03 102.9C32.2 105.1 27.33 103.8 25.09 100S24.16 91.31 27.97 89.09l96-56c2.484-1.438 5.531-1.469 8.016-.0313S136 37.13 136 40V464h112C252.4 464 256 467.6 256 472z"],
    "2": [320, 512, [], "32", "M320 472C320 476.4 316.4 480 311.1 480H7.996c-3.328 0-6.297-2.062-7.469-5.156c-1.188-3.094-.3281-6.625 2.156-8.812l226.5-201.6c51.69-44.59 57.69-120.1 13.77-171.9c-21.8-25.75-52.53-41.41-86.5-44.06C122.3 45.73 89.33 56.42 63.54 78.61L29.7 107.7C26.36 110.6 21.31 110.3 18.42 106.9C15.53 103.5 15.92 98.48 19.26 95.6l33.84-29.12C82.14 41.51 119.5 29.45 157.7 32.45c38.27 3.031 72.88 20.69 97.47 49.72c49.66 58.62 42.88 143.1-15.45 194.3l-210.7 187.6h282.1C316.4 464 320 467.6 320 472z"],
    "3": [320, 512, [], "33", "M320 355.7C320 424.2 264.2 480 195.7 480H88.06c-39.83 0-75.06-25.41-87.66-63.19c-1.391-4.188 .875-8.719 5.062-10.12c4.219-1.375 8.719 .875 10.12 5.062C26 443 55.13 464 88.06 464h107.6c59.72 0 108.3-48.59 108.3-108.3s-48.59-108.3-108.3-108.3H72c-3.297 0-6.25-2.031-7.453-5.094S64.16 235.7 66.58 233.5L267.5 48H8.003c-4.422 0-7.1-3.594-7.1-8S3.581 32 8.003 32h279.1c3.297 0 6.25 2.031 7.453 5.094c1.203 3.062 .3906 6.562-2.031 8.781l-200.1 185.5h103.2C264.2 231.4 320 287.2 320 355.7z"],
    "4": [384, 512, [], "34", "M383.1 343.1c0 4.406-3.578 8-8 8l-55.1 .004l-.0003 119.1c0 4.406-3.578 8-8 8s-8-3.594-8-8v-120h-296c-2.75 0-5.297-1.406-6.766-3.719c-1.453-2.313-1.641-5.219-.4687-7.719l144-304c1.922-4 6.688-5.656 10.66-3.781c4 1.875 5.703 6.656 3.812 10.66l-138.6 292.6h283.4V135.1c0-4.406 3.578-8 8-8s8 3.594 8 8v200h56C380.4 335.1 383.1 339.6 383.1 343.1z"],
    "5": [320, 512, [], "35", "M320 355.7C320 424.2 264.2 480 195.7 480H89.74c-40.59 0-76.48-25.88-89.33-64.38c-1.391-4.188 .875-8.719 5.062-10.12c4.219-1.375 8.719 .875 10.12 5.062C26.25 442.5 56.05 464 89.74 464h105.1c59.72 0 108.3-48.59 108.3-108.3s-48.59-108.3-108.3-108.3H8.003c-2.453 0-4.766-1.125-6.281-3.062C.2063 242.4-.3405 239.9 .222 237.5l47.1-199.4C49.1 34.53 52.3 32 56 32h223.1c4.422 0 7.1 3.594 7.1 8S284.4 48 280 48H62.3L18.16 231.4h177.5C264.2 231.4 320 287.2 320 355.7z"],
    "6": [320, 512, [], "36", "M0 320c0 88.22 71.78 160 160 160s160-71.78 160-160S248.2 160 160 160C139 160 119.1 164.3 100.7 171.7l121.1-126.2c3.062-3.188 2.938-8.25-.25-11.31C220 32.75 217.1 32 216 32c-2.094 0-4.188 .8125-5.781 2.469C39.84 211.1 0 238.1 0 320zM304 320c0 79.41-64.59 144-144 144S16 399.4 16 320S80.59 176 160 176S304 240.6 304 320z"],
    "7": [320, 512, [], "37", "M318.8 44.25l-272 432C45.25 478.7 42.66 480 40 480c-1.469 0-2.938-.4062-4.25-1.219c-3.75-2.375-4.875-7.312-2.531-11.03L297.5 48H8C3.594 48 0 44.41 0 40S3.594 32 8 32h304c2.906 0 5.594 1.594 7 4.125C320.4 38.69 320.3 41.81 318.8 44.25z"],
    "8": [320, 512, [], "38", "M231.2 251.6C269.4 232.6 296 193.5 296 148C296 84.03 243.1 32 180 32h-40C76.03 32 24 84.03 24 148c0 45.5 26.57 84.57 64.79 103.6C37.97 263.9 0 309.4 0 364C0 427.1 52.03 480 116 480h88C267.1 480 320 427.1 320 364C320 309.4 282 263.9 231.2 251.6zM40 148C40 92.88 84.88 48 140 48h40c55.13 0 100 44.88 100 100S235.1 248 180 248h-40C84.88 248 40 203.1 40 148zM204 464h-88c-55.13 0-100-44.88-100-100S60.88 264 116 264h88c55.13 0 100 44.88 100 100S259.1 464 204 464z"],
    "9": [320, 512, [], "39", "M320 192c0-88.22-71.78-160-160-160s-160 71.78-160 160S71.78 352 160 352c20.99 0 40.94-4.311 59.33-11.7l-121.1 126.2c-3.062 3.188-2.938 8.25 .25 11.31C100 479.3 101.1 480 104 480c2.094 0 4.188-.8125 5.781-2.469C280.2 300 320 273.9 320 192zM16 192c0-79.41 64.59-144 144-144s144 64.59 144 144s-64.59 144-144 144S16 271.4 16 192z"],
    "00": [640, 512, [], "e467", "M288 176V336C288 415.5 223.5 480 144 480C64.47 480 0 415.5 0 336V176C0 96.47 64.47 32 144 32C223.5 32 288 96.47 288 176zM16 336C16 406.7 73.31 464 144 464C214.7 464 272 406.7 272 336V176C272 105.3 214.7 48 144 48C73.31 48 16 105.3 16 176V336zM640 176V336C640 415.5 575.5 480 496 480C416.5 480 352 415.5 352 336V176C352 96.47 416.5 32 496 32C575.5 32 640 96.47 640 176zM368 336C368 406.7 425.3 464 496 464C566.7 464 624 406.7 624 336V176C624 105.3 566.7 48 496 48C425.3 48 368 105.3 368 176V336z"],
    "360-degrees": [640, 512, [], "e2dc", "M79.19 208H57.09l109.1-130.9c1.969-2.391 2.406-5.703 1.094-8.516S163.1 64 160 64H8C3.594 64 0 67.58 0 72S3.594 80 8 80h134.9L33.84 210.9C31.88 213.3 31.44 216.6 32.75 219.4S36.91 224 40 224h39.19C132.6 224 176 267.4 176 320.8v14.38C176 388.6 132.6 432 79.19 432c-27.12 0-52.38-12.91-64.31-32.91c-2.281-3.797-7.25-5.047-10.97-2.766c-3.812 2.266-5.031 7.188-2.781 10.98C16.12 432.4 46.03 448 79.19 448C141.4 448 192 397.4 192 335.2v-14.38C192 258.6 141.4 208 79.19 208zM496 64c-44.13 0-79.1 35.89-79.1 80v224c0 44.11 35.87 80 79.1 80s79.1-35.89 79.1-80v-224C576 99.89 540.1 64 496 64zM560 368c0 35.3-28.72 64-64 64s-64-28.7-64-64v-224c0-35.3 28.72-64 64-64s64 28.7 64 64V368zM304 208c-26.27 0-49.41 12.89-64 32.49V201.5c0-51.97 33.16-97.78 82.53-114l23.97-7.875c4.188-1.375 6.469-5.891 5.094-10.09c-1.344-4.172-5.75-6.5-10.09-5.094L317.5 72.28C261.6 90.64 224 142.6 224 201.5L224 368c0 44.11 35.87 80 79.1 80s79.1-35.89 79.1-80L384 288C384 243.9 348.1 208 304 208zM368 368c0 35.3-28.72 64-64 64s-64-28.7-64-64V288c0-35.3 28.72-64 64-64S368 252.7 368 288V368zM608 0c-17.67 0-31.1 14.33-31.1 32c0 17.67 14.33 32 31.1 32C625.7 64 640 49.67 640 32C640 14.33 625.7 0 608 0zM608 48c-8.822 0-16-7.178-16-16s7.178-16 16-16s16 7.178 16 16S616.8 48 608 48z"],
    "a": [384, 512, [97], "41", "M383.4 468.9L199.4 36.46c-2.5-5.943-12.22-5.943-14.72 0L.6438 468.9c-1.734 4.066 .1562 8.758 4.219 10.51c4.125 1.595 8.765-.1564 10.5-4.254l45.63-107.2h262l45.63 107.2C369.9 478.2 372.9 480 375.1 480c1.047 0 2.109-.219 3.141-.6256C383.2 477.6 385.1 472.9 383.4 468.9zM67.8 351.9L192 60.01l124.2 291.9H67.8z"],
    "abacus": [576, 512, [129518], "f640", "M512 32H64c-35.35 0-64 28.65-64 64v320c0 35.35 28.65 64 64 64h448c35.35 0 64-28.65 64-64v-320C576 60.65 547.3 32 512 32zM424 48v48L416 96c-17.67 0-32 14.33-32 32s14.33 31.1 31.1 31.1L424 160v40h-144v-40l8-.0004C305.7 160 320 145.7 320 128s-14.33-32-32-32L280 96v-48H424zM464 128c0 8.837-7.163 16-15.1 16H415.1c-8.837 0-15.1-7.164-15.1-16s7.163-15.1 15.1-15.1h32C456.8 112 464 119.2 464 128zM240 128c0-8.837 7.163-15.1 15.1-15.1h32c8.837 0 15.1 7.163 15.1 15.1s-7.163 16-15.1 16H255.1C247.2 144 240 136.8 240 128zM264 48v48L256 96c-17.67 0-32 14.33-32 32s14.33 31.1 31.1 31.1L264 160v40h-112v-40l8-.0004C177.7 160 192 145.7 192 128S177.7 96 160 96L152 96v-48H264zM112 128c0-8.837 7.163-15.1 15.1-15.1h32C168.8 112 176 119.2 176 128S168.8 144 160 144h-32C119.2 144 112 136.8 112 128zM16 96c0-26.51 21.49-48 48-48h72v48L127.1 96C110.3 96 96 110.3 96 128s14.33 31.1 31.1 31.1L136 160v40H16V96zM64 464c-26.51 0-48-21.49-48-48v-200h120v40H127.1C110.3 256 96 270.3 96 288s14.33 31.1 31.1 31.1L136 320v32l-8-.0004C110.3 352 96 366.3 96 384s14.33 31.1 31.1 31.1L136 416v48H64zM176 288c0 8.837-7.163 16-15.1 16h-32C119.2 304 112 296.8 112 288s7.163-15.1 15.1-15.1h32C168.8 272 176 279.2 176 288zM176 384c0 8.837-7.163 16-15.1 16h-32C119.2 400 112 392.8 112 384s7.163-15.1 15.1-15.1h32C168.8 368 176 375.2 176 384zM152 464v-48l8-.0005C177.7 416 192 401.7 192 384s-14.33-32-31.1-32L152 352v-32l8-.0004C177.7 320 192 305.7 192 288s-14.33-32-31.1-32H152v-40h112v40H255.1C238.3 256 224 270.3 224 288s14.33 31.1 31.1 31.1L264 320v32l-8-.0004C238.3 352 224 366.3 224 384s14.33 31.1 32 31.1l8 .0005v48H152zM304 288c0 8.837-7.163 16-15.1 16H255.1C247.2 304 240 296.8 240 288s7.163-15.1 15.1-15.1h32C296.8 272 304 279.2 304 288zM304 384c0 8.837-7.163 16-15.1 16H255.1c-8.837 0-15.1-7.164-15.1-16s7.163-15.1 15.1-15.1h32C296.8 368 304 375.2 304 384zM280 464v-48L288 416c17.67 0 32-14.33 32-31.1s-14.33-32-31.1-32L280 352v-32l8-.0004C305.7 320 320 305.7 320 288s-14.33-32-31.1-32H280v-40h144v136l-8-.0004C398.3 352 384 366.3 384 384s14.33 31.1 32 31.1l8 .0005v48H280zM464 384c0 8.837-7.163 16-15.1 16H415.1c-8.837 0-15.1-7.164-15.1-16s7.163-15.1 15.1-15.1h32C456.8 368 464 375.2 464 384zM560 416c0 26.51-21.49 48-48 48h-72v-48L448 416c17.67 0 32-14.33 32-31.1s-14.33-32-31.1-32L440 352v-136h120V416zM440 200v-40l8-.0004C465.7 160 480 145.7 480 128s-14.33-32-32-32l-8 .0005v-48H512c26.51 0 48 21.49 48 48v104H440z"],
    "accent-grave": [192, 512, [], "60", "M94.64 16c7.518 .0017 14.7 1.865 20.78 5.387c11.56 6.684 19.47 18.02 21.71 31.1l22.57 131.7c1.672 9.707-3.869 19.19-13.18 22.57C144.3 207.6 141.9 208 139.5 208c-7.268 0-14.05-3.875-17.7-10.11L54.1 82.51c-6.697-11.44-7.945-25.17-3.412-37.66C56.74 28.13 75.22 16 94.64 16zM94.65 .0016c-25.06 0-50.23 15.13-58.1 39.39C29.5 56.36 31.18 75.03 40.3 90.61l67.69 115.4c6.688 11.43 18.84 18.03 31.51 18.03c4.164 0 8.381-.7113 12.48-2.2c16.59-6.017 26.48-22.99 23.49-40.31l-22.57-131.7c-3.045-17.81-13.79-33.2-29.45-42.25C114.6 2.391 104.6 .0035 94.65 .0016C94.65 .0016 94.65 .0016 94.65 .0016z"],
    "acorn": [448, 512, [], "f6ae", "M.0014 160C.0014 160 .0014 160 .0014 160C.0014 160 .0014 160 .0014 160zM447.1 160C447.1 160 447.1 160 447.1 160C447.1 160 447.1 160 447.1 160zM352 64.04l-120 .0015c.0156-1.191 .6582-28.52 28.8-49.63c3.531-2.656 4.25-7.672 1.609-11.2c-2.656-3.531-7.672-4.266-11.2-1.609c-34.8 26.11-35.2 60.96-35.2 62.43c0 .0156 0-.0156 0 0L96 64.04c-52.99 0-95.99 42.98-95.1 95.97C.0053 177.6 14.38 192 32 192l16 .0001v35.64c0 82.61 48.53 191.5 129.7 230.8l42.77 20.78C221.6 479.7 222.8 480 224 480s2.391-.2656 3.5-.7969l42.75-20.78C351.5 419.2 400 310.3 400 227.6V192L416 192c17.62 0 31.1-14.37 31.1-31.98C447.1 107 404.1 64.04 352 64.04zM384 227.6c0 77.67-45.16 179.8-120.7 216.4L224 463.1l-39.28-19.09C109.2 407.5 64 305.3 64 227.6V192h320V227.6zM416 176H32c-8.818 0-15.1-7.189-15.1-16C16.01 115.9 51.9 80.04 96 80.04h256c44.1 0 79.99 35.88 79.1 79.97C431.1 168.8 424.8 176 416 176z"],
    "address-book": [512, 512, [62138, "contact-book"], "f2b9", "M400 0h-320C53.49 0 32 21.49 32 48v416C32 490.5 53.49 512 80 512h320c26.51 0 48-21.49 48-48v-416C448 21.49 426.5 0 400 0zM432 464c0 17.64-14.36 32-32 32h-320c-17.64 0-32-14.36-32-32v-416c0-17.64 14.36-32 32-32h320c17.64 0 32 14.36 32 32V464zM240 256c35.35 0 64-28.65 64-64s-28.65-64-64-64c-35.34 0-64 28.65-64 64S204.7 256 240 256zM240 144C266.5 144 288 165.5 288 192s-21.53 48-48 48S192 218.5 192 192S213.5 144 240 144zM496 64h-8C483.6 64 480 67.58 480 72s3.582 8 8 8h8v64h-8C483.6 144 480 147.6 480 152S483.6 160 488 160h8C504.8 160 512 152.8 512 144v-64C512 71.16 504.8 64 496 64zM496 320h-8C483.6 320 480 323.6 480 328s3.582 8 8 8h8v64h-8c-4.418 0-8 3.582-8 8S483.6 416 488 416h8c8.836 0 16-7.164 16-16v-64C512 327.2 504.8 320 496 320zM496 192h-8C483.6 192 480 195.6 480 200s3.582 8 8 8h8v64h-8C483.6 272 480 275.6 480 280S483.6 288 488 288h8C504.8 288 512 280.8 512 272v-64C512 199.2 504.8 192 496 192zM272 288h-64C163.9 288 128 323.9 128 368v8C128 380.4 131.6 384 136 384s8-3.578 8-8V368c0-35.3 28.7-64 64-64h64c35.3 0 64 28.7 64 64v8c0 4.422 3.578 8 8 8S352 380.4 352 376V368C352 323.9 316.1 288 272 288z"],
    "address-card": [576, 512, [62140, "contact-card", "vcard"], "f2bb", "M504 312h-144C355.6 312 352 315.6 352 320s3.578 8 8 8h144c4.422 0 8-3.578 8-8S508.4 312 504 312zM176 256c35.35 0 64-28.65 64-64s-28.65-64-64-64c-35.34 0-64 28.65-64 64S140.7 256 176 256zM176 144C202.5 144 224 165.5 224 192S202.5 240 176 240S128 218.5 128 192S149.5 144 176 144zM512 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h448c35.35 0 64-28.65 64-64V96C576 60.65 547.3 32 512 32zM560 416c0 26.51-21.49 48-48 48H64c-26.51 0-48-21.49-48-48V96c0-26.51 21.49-48 48-48h448c26.51 0 48 21.49 48 48V416zM504 248h-144C355.6 248 352 251.6 352 256s3.578 8 8 8h144C508.4 264 512 260.4 512 256S508.4 248 504 248zM504 184h-144C355.6 184 352 187.6 352 192s3.578 8 8 8h144C508.4 200 512 196.4 512 192S508.4 184 504 184zM208 288h-64C99.89 288 64 323.9 64 368v8C64 380.4 67.58 384 72 384s8-3.578 8-8V368c0-35.3 28.7-64 64-64h64c35.3 0 64 28.7 64 64v8C272 380.4 275.6 384 280 384S288 380.4 288 376V368C288 323.9 252.1 288 208 288z"],
    "air-conditioner": [576, 512, [], "f8f4", "M512 .0002H64c-35.35 0-64 28.65-64 64v96c0 35.35 28.65 63.1 64 63.1h448c35.35 0 64-28.65 64-63.1V64C576 28.65 547.3 .0002 512 .0002zM560 160c0 26.51-21.49 47.1-48 47.1H64c-26.51 0-48-21.49-48-47.1v-96c0-26.51 21.49-48 48-48h448c26.51 0 48 21.49 48 48V160zM504 128H72c-4.422 0-8 3.578-8 8s3.578 8 8 8h432c4.422 0 8-3.578 8-8S508.4 128 504 128zM248 256c-4.422 0-8 3.578-8 8v160c0 39.7-32.3 72-72 72s-72-32.3-72-72v-8c0-35.3 28.7-64 64-64c4.422 0 8-3.578 8-7.1s-3.578-8-8-8c-44.11 0-80 35.89-80 80v7.999c0 48.53 39.47 88 88 88s88-39.47 88-88V264C256 259.6 252.4 256 248 256zM416 304c-4.422 0-8 3.578-8 8s3.578 7.1 8 7.1c35.3 0 64 28.7 64 64v8c0 39.7-32.3 72-72 72s-72-32.3-72-72v-128c0-4.422-3.578-8-8-8s-8 3.578-8 8v127.1c0 48.53 39.47 88 88 88s88-39.47 88-88v-7.999C496 339.9 460.1 304 416 304z"],
    "airplay": [576, 512, [], "e089", "M504 32H72C32.31 32 0 64.31 0 104v240C0 383.7 32.31 416 72 416H96c4.406 0 8-3.594 8-8S100.4 400 96 400H72c-30.88 0-56-25.12-56-56v-240c0-30.88 25.12-56 56-56h432c30.88 0 56 25.12 56 56v240c0 30.88-25.12 56-56 56H480c-4.406 0-8 3.594-8 8S475.6 416 480 416h24c39.69 0 72-32.31 72-72v-240C576 64.31 543.7 32 504 32zM307.6 296.1C302.1 290.7 295.1 288 288 288c-7.055 0-14.09 2.703-19.45 8.109l-132.5 136.8C118.8 450.2 131.1 480 155.7 480h264.7c24.6 0 36.89-29.77 19.54-47.13L307.6 296.1zM431.1 456.8C430.2 458.1 427.3 464 420.3 464H155.7c-6.99 0-9.822-5.016-10.71-7.172c-.8945-2.156-2.441-7.707 2.668-12.82l132.3-136.6C282.1 305.2 284.1 304 288 304c3.09 0 6.006 1.215 8.027 3.234l132.5 136.1C433.5 449.1 431.1 454.7 431.1 456.8z"],
    "alarm-clock": [512, 512, [9200], "f34e", "M93.72 .0006C118.3 .0006 140.7 9.492 157.4 24.1C160.7 28 160.9 33.06 157.9 36.3C154.9 39.54 149.8 39.73 146.6 36.73C132.7 23.86 114.1 16 93.72 16C50.8 16 16 50.8 16 93.72C16 109.1 20.45 123.4 28.12 135.4C30.5 139.1 29.4 144.1 25.67 146.5C21.95 148.8 17 147.7 14.63 144C5.365 129.5 0 112.2 0 93.72C0 41.96 41.96 0 93.72 0V.0006zM264 300.2L340.1 361.8C344.4 364.5 345 369.5 342.2 372.1C339.5 376.4 334.5 377 331 374.2L251 310.2C249.1 308.7 247.1 306.4 247.1 304V168C247.1 163.6 251.6 160 255.1 160C260.4 160 264 163.6 264 168L264 300.2zM34.34 509.7C31.22 506.5 31.22 501.5 34.34 498.3L92.05 440.6C54.79 400.6 32 346.1 32 288C32 164.3 132.3 64 256 64C379.7 64 480 164.3 480 288C480 346.1 457.2 400.6 419.9 440.6L477.7 498.3C480.8 501.5 480.8 506.5 477.7 509.7C474.5 512.8 469.5 512.8 466.3 509.7L408.6 451.9C368.6 489.2 314.1 512 256 512C197 512 143.4 489.2 103.4 451.9L45.66 509.7C42.53 512.8 37.47 512.8 34.34 509.7H34.34zM256 496C370.9 496 464 402.9 464 288C464 173.1 370.9 80 256 80C141.1 80 48 173.1 48 288C48 402.9 141.1 496 256 496zM354.6 24.1C371.3 9.492 393.7 .0006 418.3 .0006C470 .0006 512 41.96 512 93.72C512 112.2 506.6 129.5 497.4 144C494.1 147.7 490.1 148.8 486.3 146.5C482.6 144.1 481.5 139.1 483.9 135.4C491.6 123.4 496 109.1 496 93.72C496 50.8 461.2 16 418.3 16C397.9 16 379.3 23.86 365.4 36.73C362.2 39.73 357.1 39.54 354.1 36.3C351.1 33.07 351.3 28 354.6 24.1V24.1z"],
    "alarm-exclamation": [512, 512, [], "f843", "M93.72 .0006C118.3 .0006 140.7 9.492 157.4 24.1C160.7 28 160.9 33.06 157.9 36.3C154.9 39.54 149.8 39.73 146.6 36.73C132.7 23.86 114.1 16 93.72 16C50.8 16 16 50.8 16 93.72C16 109.1 20.45 123.4 28.12 135.4C30.5 139.1 29.4 144.1 25.67 146.5C21.95 148.8 17 147.7 14.63 144C5.365 129.5 0 112.2 0 93.72C0 41.96 41.96 0 93.72 0V.0006zM272 384C272 392.8 264.8 400 256 400C247.2 400 240 392.8 240 384C240 375.2 247.2 368 256 368C264.8 368 272 375.2 272 384zM264 328C264 332.4 260.4 336 256 336C251.6 336 248 332.4 248 328V168C248 163.6 251.6 160 256 160C260.4 160 264 163.6 264 168V328zM34.34 509.7C31.22 506.5 31.22 501.5 34.34 498.3L92.05 440.6C54.79 400.6 32 346.1 32 288C32 164.3 132.3 64 256 64C379.7 64 480 164.3 480 288C480 346.1 457.2 400.6 419.9 440.6L477.7 498.3C480.8 501.5 480.8 506.5 477.7 509.7C474.5 512.8 469.5 512.8 466.3 509.7L408.6 451.9C368.6 489.2 314.1 512 256 512C197 512 143.4 489.2 103.4 451.9L45.66 509.7C42.53 512.8 37.47 512.8 34.34 509.7H34.34zM256 496C370.9 496 464 402.9 464 288C464 173.1 370.9 80 256 80C141.1 80 48 173.1 48 288C48 402.9 141.1 496 256 496zM512 93.72C512 112.2 506.6 129.5 497.4 144C494.1 147.7 490.1 148.8 486.3 146.5C482.6 144.1 481.5 139.1 483.9 135.4C491.6 123.4 496 109.1 496 93.72C496 50.8 461.2 16 418.3 16C397.9 16 379.3 23.86 365.4 36.73C362.2 39.73 357.1 39.54 354.1 36.3C351.1 33.07 351.3 28 354.6 24.1C371.3 9.493 393.7 .0013 418.3 .0013C470 .0013 512 41.96 512 93.72V93.72z"],
    "alarm-plus": [512, 512, [], "f844", "M93.72 .0006C118.3 .0006 140.7 9.492 157.4 24.1C160.7 28 160.9 33.06 157.9 36.3C154.9 39.54 149.8 39.73 146.6 36.73C132.7 23.86 114.1 16 93.72 16C50.8 16 16 50.8 16 93.72C16 109.1 20.45 123.4 28.12 135.4C30.5 139.1 29.4 144.1 25.67 146.5C21.95 148.8 17 147.7 14.63 144C5.365 129.5 0 112.2 0 93.72C0 41.96 41.96 0 93.72 0V.0006zM256 184C260.4 184 264 187.6 264 192V280H352C356.4 280 360 283.6 360 288C360 292.4 356.4 296 352 296H264V384C264 388.4 260.4 392 256 392C251.6 392 248 388.4 248 384V296H160C155.6 296 152 292.4 152 288C152 283.6 155.6 280 160 280H248V192C248 187.6 251.6 184 256 184zM34.34 509.7C31.22 506.5 31.22 501.5 34.34 498.3L92.05 440.6C54.79 400.6 32 346.1 32 288C32 164.3 132.3 64 256 64C379.7 64 480 164.3 480 288C480 346.1 457.2 400.6 419.9 440.6L477.7 498.3C480.8 501.5 480.8 506.5 477.7 509.7C474.5 512.8 469.5 512.8 466.3 509.7L408.6 451.9C368.6 489.2 314.1 512 256 512C197 512 143.4 489.2 103.4 451.9L45.66 509.7C42.53 512.8 37.47 512.8 34.34 509.7H34.34zM256 496C370.9 496 464 402.9 464 288C464 173.1 370.9 80 256 80C141.1 80 48 173.1 48 288C48 402.9 141.1 496 256 496zM512 93.72C512 112.2 506.6 129.5 497.4 144C494.1 147.7 490.1 148.8 486.3 146.5C482.6 144.1 481.5 139.1 483.9 135.4C491.6 123.4 496 109.1 496 93.72C496 50.8 461.2 16 418.3 16C397.9 16 379.3 23.86 365.4 36.73C362.2 39.73 357.1 39.54 354.1 36.3C351.1 33.07 351.3 28 354.6 24.1C371.3 9.493 393.7 .0013 418.3 .0013C470 .0013 512 41.96 512 93.72V93.72z"],
    "alarm-snooze": [512, 512, [], "f845", "M157.9 36.3C154.9 39.54 149.8 39.73 146.6 36.73C132.7 23.86 114.1 16 93.72 16C50.8 16 16 50.8 16 93.72C16 109.1 20.45 123.4 28.12 135.4C30.5 139.1 29.4 144.1 25.67 146.5C21.95 148.8 17 147.7 14.63 144C5.365 129.5 0 112.2 0 93.72C0 41.96 41.96 0 93.72 0C118.3 0 140.7 9.492 157.4 24.1C160.7 28 160.9 33.06 157.9 36.3V36.3zM320 192C323 192 325.8 193.7 327.1 196.4C328.5 199.1 328.2 202.3 326.5 204.7L207.7 368H320C324.4 368 328 371.6 328 376C328 380.4 324.4 384 320 384H192C188.1 384 186.2 382.3 184.9 379.6C183.5 376.1 183.8 373.7 185.5 371.3L304.3 208H192C187.6 208 184 204.4 184 200C184 195.6 187.6 192 192 192H320zM103.4 451.9L45.66 509.7C42.53 512.8 37.47 512.8 34.34 509.7C31.22 506.5 31.22 501.5 34.34 498.3L92.05 440.6C54.79 400.6 32 346.1 32 288C32 164.3 132.3 64 256 64C379.7 64 480 164.3 480 288C480 346.1 457.2 400.6 419.9 440.6L477.7 498.3C480.8 501.5 480.8 506.5 477.7 509.7C474.5 512.8 469.5 512.8 466.3 509.7L408.6 451.9C368.6 489.2 314.1 512 256 512C197 512 143.4 489.2 103.4 451.9H103.4zM256 80C141.1 80 48 173.1 48 288C48 402.9 141.1 496 256 496C370.9 496 464 402.9 464 288C464 173.1 370.9 80 256 80zM354.6 24.1C371.3 9.492 393.7 .0003 418.3 .0003C470 .0003 512 41.96 512 93.72C512 112.2 506.6 129.5 497.4 144C494.1 147.7 490.1 148.8 486.3 146.5C482.6 144.1 481.5 139.1 483.9 135.4C491.6 123.4 496 109.1 496 93.72C496 50.8 461.2 16 418.3 16C397.9 16 379.3 23.86 365.4 36.73C362.2 39.73 357.1 39.54 354.1 36.3C351.1 33.07 351.3 28 354.6 24.1V24.1z"],
    "album": [448, 512, [128189], "f89f", "M256 256C256 273.7 241.7 288 224 288C206.3 288 192 273.7 192 256C192 238.3 206.3 224 224 224C241.7 224 256 238.3 256 256zM224 240C215.2 240 208 247.2 208 256C208 264.8 215.2 272 224 272C232.8 272 240 264.8 240 256C240 247.2 232.8 240 224 240zM64 256C64 167.6 135.6 96 224 96C312.4 96 384 167.6 384 256C384 344.4 312.4 416 224 416C135.6 416 64 344.4 64 256zM224 400C303.5 400 368 335.5 368 256C368 176.5 303.5 112 224 112C144.5 112 80 176.5 80 256C80 335.5 144.5 400 224 400zM384 32C419.3 32 448 60.65 448 96V416C448 451.3 419.3 480 384 480H64C28.65 480 0 451.3 0 416V96C0 60.65 28.65 32 64 32H384zM384 48H64C37.49 48 16 69.49 16 96V416C16 442.5 37.49 464 64 464H384C410.5 464 432 442.5 432 416V96C432 69.49 410.5 48 384 48z"],
    "album-circle-plus": [576, 512, [], "e48c", "M384 48H63.1C37.49 48 15.1 69.49 15.1 96V416C15.1 442.5 37.49 464 63.1 464H284.5C288.1 469.6 292 474.9 296.2 480H64C28.65 480 0 451.3 0 416V96C0 60.65 28.65 32 64 32H384C419.3 32 448 60.65 448 96V192.7C442.7 192.2 437.4 192 432 192V96C432 69.49 410.5 48 384 48H384zM223.1 96C293.3 96 352.3 140 374.5 201.6C369.4 203.4 364.5 205.3 359.6 207.5C339.7 151.8 286.5 112 223.1 112C144.5 112 79.1 176.5 79.1 256C79.1 335.5 144.5 400 223.1 400C235.8 400 247.2 398.6 258.2 395.9C259 401.2 260.1 406.5 261.4 411.6C249.4 414.5 236.9 416 223.1 416C135.6 416 63.1 344.4 63.1 256C63.1 167.6 135.6 96 223.1 96V96zM255.1 256C255.1 273.7 241.7 288 223.1 288C206.3 288 191.1 273.7 191.1 256C191.1 238.3 206.3 224 223.1 224C241.7 224 255.1 238.3 255.1 256zM223.1 240C215.2 240 207.1 247.2 207.1 256C207.1 264.8 215.2 272 223.1 272C232.8 272 239.1 264.8 239.1 256C239.1 247.2 232.8 240 223.1 240zM440 359.1H504C508.4 359.1 512 363.6 512 367.1C512 372.4 508.4 375.1 504 375.1H440V439.1C440 444.4 436.4 447.1 432 447.1C427.6 447.1 424 444.4 424 439.1V375.1H360C355.6 375.1 352 372.4 352 367.1C352 363.6 355.6 359.1 360 359.1H424V295.1C424 291.6 427.6 287.1 432 287.1C436.4 287.1 440 291.6 440 295.1V359.1zM576 368C576 447.5 511.5 512 432 512C352.5 512 287.1 447.5 287.1 368C287.1 288.5 352.5 224 432 224C511.5 224 576 288.5 576 368zM432 240C361.3 240 304 297.3 304 368C304 438.7 361.3 496 432 496C502.7 496 560 438.7 560 368C560 297.3 502.7 240 432 240z"],
    "album-circle-user": [576, 512, [], "e48d", "M384 48H63.1C37.49 48 15.1 69.49 15.1 96V416C15.1 442.5 37.49 464 63.1 464H284.5C288.1 469.6 292 474.9 296.2 480H64C28.65 480 0 451.3 0 416V96C0 60.65 28.65 32 64 32H384C419.3 32 448 60.65 448 96V192.7C442.7 192.2 437.4 192 432 192V96C432 69.49 410.5 48 384 48H384zM223.1 96C293.3 96 352.3 140 374.5 201.6C369.4 203.4 364.5 205.3 359.6 207.5C339.7 151.8 286.5 112 223.1 112C144.5 112 79.1 176.5 79.1 256C79.1 335.5 144.5 400 223.1 400C235.8 400 247.2 398.6 258.2 395.9C259 401.2 260.1 406.5 261.4 411.6C249.4 414.5 236.9 416 223.1 416C135.6 416 63.1 344.4 63.1 256C63.1 167.6 135.6 96 223.1 96V96zM255.1 256C255.1 273.7 241.7 288 223.1 288C206.3 288 191.1 273.7 191.1 256C191.1 238.3 206.3 224 223.1 224C241.7 224 255.1 238.3 255.1 256zM223.1 240C215.2 240 207.1 247.2 207.1 256C207.1 264.8 215.2 272 223.1 272C232.8 272 239.1 264.8 239.1 256C239.1 247.2 232.8 240 223.1 240zM384 336C384 309.5 405.5 288 432 288C458.5 288 480 309.5 480 336C480 362.5 458.5 384 432 384C405.5 384 384 362.5 384 336zM432 368C449.7 368 464 353.7 464 336C464 318.3 449.7 304 432 304C414.3 304 400 318.3 400 336C400 353.7 414.3 368 432 368zM576 368C576 447.5 511.5 512 432 512C352.5 512 287.1 447.5 287.1 368C287.1 288.5 352.5 224 432 224C511.5 224 576 288.5 576 368zM506.5 462.1C497 443.1 477.7 432 456.4 432H407.6C386.3 432 366.1 443.1 357.5 462.1L354.1 469.6C375.7 486.2 402.7 496 432 496C461.3 496 488.3 486.2 509.9 469.6L506.5 462.1zM560 368C560 297.3 502.7 240 432 240C361.3 240 304 297.3 304 368C304 403.5 318.4 435.5 341.7 458.7L343.2 455.8C355.4 431.4 380.3 416 407.6 416H456.4C483.7 416 508.6 431.4 520.8 455.8L522.3 458.7C545.6 435.5 560 403.5 560 368z"],
    "album-collection": [512, 512, [], "f8a0", "M448 0C465.7 0 480 14.33 480 32V40C480 44.42 476.4 48 472 48C467.6 48 464 44.42 464 40V32C464 23.16 456.8 16 448 16H64C55.16 16 48 23.16 48 32V40C48 44.42 44.42 48 40 48C35.58 48 32 44.42 32 40V32C32 14.33 46.33 0 64 0H448zM16 112C16 94.33 30.33 80 48 80H464C481.7 80 496 94.33 496 112V120C496 124.4 492.4 128 488 128C483.6 128 480 124.4 480 120V112C480 103.2 472.8 96 464 96H48C39.16 96 32 103.2 32 112V120C32 124.4 28.42 128 24 128C19.58 128 16 124.4 16 120V112zM281.8 368.6C274.5 373.5 265.3 376 256 376C246.7 376 237.5 373.5 230.2 368.6C222.1 363.8 216 355.4 216 344C216 332.6 222.1 324.2 230.2 319.4C237.5 314.5 246.7 312 256 312C265.3 312 274.5 314.5 281.8 319.4C289 324.2 296 332.6 296 344C296 355.4 289 363.8 281.8 368.6zM256 360C269.3 360 280 352.8 280 344C280 335.2 269.3 328 256 328C242.7 328 232 335.2 232 344C232 352.8 242.7 360 256 360zM432 340C432 412.9 353.2 472 256 472C158.8 472 80 412.9 80 340C80 267.1 158.8 208 256 208C353.2 208 432 267.1 432 340zM370.9 259.5C342 237.8 301.5 224 256 224C210.5 224 169.1 237.8 141.1 259.5C112.3 281.1 96 309.7 96 340C96 370.3 112.3 398.9 141.1 420.5C169.1 442.2 210.5 456 256 456C301.5 456 342 442.2 370.9 420.5C399.7 398.9 416 370.3 416 340C416 309.7 399.7 281.1 370.9 259.5zM4.207 212.6C1.523 184.4 23.68 160 51.99 160H460C488.3 160 510.5 184.4 507.8 212.6L483.4 468.6C481.1 493.2 460.4 512 435.6 512H76.37C51.62 512 30.93 493.2 28.59 468.6L4.207 212.6zM51.99 176C33.12 176 18.35 192.2 20.13 211L44.52 467C46.08 483.5 59.87 496 76.37 496H435.6C452.1 496 465.9 483.5 467.5 467L491.9 211C493.7 192.2 478.9 176 460 176H51.99z"],
    "album-collection-circle-plus": [640, 512, [], "e48e", "M448 0C465.7 0 480 14.33 480 32V40C480 44.42 476.4 48 472 48C467.6 48 464 44.42 464 40V32C464 23.16 456.8 16 448 16H64C55.16 16 48 23.16 48 32V40C48 44.42 44.42 48 40 48C35.58 48 32 44.42 32 40V32C32 14.33 46.33 0 64 0H448zM16 112C16 94.33 30.33 80 48 80H464C481.7 80 496 94.33 496 112V120C496 124.4 492.4 128 488 128C483.6 128 480 124.4 480 120V112C480 103.2 472.8 96 464 96H48C39.16 96 32 103.2 32 112V120C32 124.4 28.42 128 24 128C19.58 128 16 124.4 16 120V112zM4.207 212.6C1.523 184.4 23.68 160 51.99 160H460C481.2 160 498.9 173.6 505.4 192.2C502.3 192.1 499.1 192 496 192C493.3 192 490.5 192.1 487.8 192.2C482.4 182.6 472 176 460 176H51.99C33.12 176 18.35 192.2 20.13 211L44.52 467C46.08 483.5 59.87 496 76.37 496H375.2C381.3 501.8 387.9 507.1 394.8 512H76.37C51.62 512 30.93 493.2 28.59 468.6L4.207 212.6zM256 208C301.1 208 342.3 220.7 373.4 241.7C369.6 245.5 365.8 249.4 362.3 253.5C334.3 235.3 297.2 224 256 224C210.5 224 169.1 237.8 141.1 259.5C112.3 281.1 96 309.7 96 340C96 370.3 112.3 398.9 141.1 420.5C169.1 442.2 210.5 456 256 456C285.2 456 312.3 450.3 335.6 440.5C337.8 445.4 340.2 450.2 342.9 454.8C317.2 465.8 287.6 472 256 472C158.8 472 80 412.9 80 340C80 267.1 158.8 207.1 256 207.1V208zM281.8 368.6C274.5 373.5 265.3 376 256 376C246.7 376 237.5 373.5 230.2 368.6C222.1 363.8 216 355.4 216 344C216 332.6 222.1 324.2 230.2 319.4C237.5 314.5 246.7 312 256 312C265.3 312 274.5 314.5 281.8 319.4C289 324.2 296 332.6 296 344C296 355.4 289 363.8 281.8 368.6zM256 360C269.3 360 280 352.8 280 344C280 335.2 269.3 328 256 328C242.7 328 232 335.2 232 344C232 352.8 242.7 360 256 360zM504 359.1H568C572.4 359.1 576 363.6 576 367.1C576 372.4 572.4 375.1 568 375.1H504V439.1C504 444.4 500.4 447.1 496 447.1C491.6 447.1 488 444.4 488 439.1V375.1H424C419.6 375.1 416 372.4 416 367.1C416 363.6 419.6 359.1 424 359.1H488V295.1C488 291.6 491.6 287.1 496 287.1C500.4 287.1 504 291.6 504 295.1V359.1zM640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368zM496 240C425.3 240 368 297.3 368 368C368 438.7 425.3 496 496 496C566.7 496 624 438.7 624 368C624 297.3 566.7 240 496 240z"],
    "album-collection-circle-user": [640, 512, [], "e48f", "M448 0C465.7 0 480 14.33 480 32V40C480 44.42 476.4 48 472 48C467.6 48 464 44.42 464 40V32C464 23.16 456.8 16 448 16H64C55.16 16 48 23.16 48 32V40C48 44.42 44.42 48 40 48C35.58 48 32 44.42 32 40V32C32 14.33 46.33 0 64 0H448zM16 112C16 94.33 30.33 80 48 80H464C481.7 80 496 94.33 496 112V120C496 124.4 492.4 128 488 128C483.6 128 480 124.4 480 120V112C480 103.2 472.8 96 464 96H48C39.16 96 32 103.2 32 112V120C32 124.4 28.42 128 24 128C19.58 128 16 124.4 16 120V112zM4.207 212.6C1.523 184.4 23.68 160 51.99 160H460C481.2 160 498.9 173.6 505.4 192.2C502.3 192.1 499.1 192 496 192C493.3 192 490.5 192.1 487.8 192.2C482.4 182.6 472 176 460 176H51.99C33.12 176 18.35 192.2 20.13 211L44.52 467C46.08 483.5 59.87 496 76.37 496H375.2C381.3 501.8 387.9 507.1 394.8 512H76.37C51.62 512 30.93 493.2 28.59 468.6L4.207 212.6zM256 208C301.1 208 342.3 220.7 373.4 241.7C369.6 245.5 365.8 249.4 362.3 253.5C334.3 235.3 297.2 224 256 224C210.5 224 169.1 237.8 141.1 259.5C112.3 281.1 96 309.7 96 340C96 370.3 112.3 398.9 141.1 420.5C169.1 442.2 210.5 456 256 456C285.2 456 312.3 450.3 335.6 440.5C337.8 445.4 340.2 450.2 342.9 454.8C317.2 465.8 287.6 472 256 472C158.8 472 80 412.9 80 340C80 267.1 158.8 207.1 256 207.1V208zM281.8 368.6C274.5 373.5 265.3 376 256 376C246.7 376 237.5 373.5 230.2 368.6C222.1 363.8 216 355.4 216 344C216 332.6 222.1 324.2 230.2 319.4C237.5 314.5 246.7 312 256 312C265.3 312 274.5 314.5 281.8 319.4C289 324.2 296 332.6 296 344C296 355.4 289 363.8 281.8 368.6zM256 360C269.3 360 280 352.8 280 344C280 335.2 269.3 328 256 328C242.7 328 232 335.2 232 344C232 352.8 242.7 360 256 360zM448 336C448 309.5 469.5 288 496 288C522.5 288 544 309.5 544 336C544 362.5 522.5 384 496 384C469.5 384 448 362.5 448 336zM496 368C513.7 368 528 353.7 528 336C528 318.3 513.7 304 496 304C478.3 304 464 318.3 464 336C464 353.7 478.3 368 496 368zM640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368zM570.5 462.1C561 443.1 541.7 432 520.4 432H471.6C450.3 432 430.1 443.1 421.5 462.1L418.1 469.6C439.7 486.2 466.7 496 496 496C525.3 496 552.3 486.2 573.9 469.6L570.5 462.1zM624 368C624 297.3 566.7 240 496 240C425.3 240 368 297.3 368 368C368 403.5 382.4 435.5 405.7 458.7L407.2 455.8C419.4 431.4 444.3 416 471.6 416H520.4C547.7 416 572.6 431.4 584.8 455.8L586.3 458.7C609.6 435.5 624 403.5 624 368z"],
    "alicorn": [640, 512, [], "f6b0", "M464 64.69c-8.836 0-16 7.164-16 16s7.164 16 16 16s16-7.164 16-16S472.8 64.69 464 64.69zM632 32l-93.39 .0005c2.158-4.162 4.121-8.436 5.061-13.08c.9375-4.625-.25-9.406-3.281-13.09c-3.031-3.703-7.5-5.828-12.25-5.828h-124.4c-68.88 0-127.5 57.73-131.7 127.8C183.2 125.9 164.8 42.04 164.1 38.41C163.4 35.05 160.6 32.49 157.2 32.06C153.9 31.78 150.5 33.47 149 36.55C147.8 39.14 126.9 84.06 128.1 134.1c-15.09 5.418-28.56 14.22-39.12 25.93H72c-39.69 0-72 32.3-72 72v80c0 4.422 3.594 8 8 8s8-3.578 8-8v-80c0-30.88 25.12-56 56-56h5.312C69.07 190.2 64 206.4 64 224c0 29.42 13.52 55.43 34.36 73.04L87.25 318.8C67.56 357.2 64 364.2 64 380.9c0 4.906 .9062 12.38 2.094 16.98l23.97 95.95c2.562 10.17 12.81 18.16 23.28 18.16H176c7.438 0 14.34-3.359 18.91-9.234c4.562-5.859 6.156-13.36 4.219-21.05l-30.53-97.03l27.69-55.38L280 358.3v129.8c0 13.23 10.79 23.1 24 23.1L360 512c13.22 0 24-10.77 24-24v-160.9c19.51-17.57 31.1-42.82 31.1-71.14c0-.0352 0 .0352 0 0L416 151.9l5.688 2.031l16.88 33.61c6.797 13.51 20.69 21.52 35.07 21.52c4.801 0 9.648-.8906 14.31-2.766l31.53-12.61c13.75-5.484 24.5-21.41 24.5-36.23l-.0605-72.11l91.15-37.98c3.531-1.469 5.531-5.219 4.781-8.953C639.1 34.69 635.8 32 632 32zM513.5 178.9l-31.57 12.62c-11.07 4.461-23.87-.6836-29.1-11.09l-16.88-33.61c-3.328-6.625-18.72-15.31-29.2-7.93C402.5 141.9 400 146.7 400 151.9c0 0-.0078 104.3 0 104.5c-.1172 22.5-9.59 43.37-26.71 58.79C369.9 318.2 368 322.6 368 327.1v160.9c0 4.41-3.59 8-8 8H304c-4.414 0-8-3.59-8-8v-129.8c0-7.344-4.996-13.74-12.12-15.52L200.2 313.8c-6.375-1.594-14.45 .8672-18.2 8.367l-27.69 55.38c-1.852 3.711-2.195 8-.9492 11.96l30.28 96.14C185.2 491.8 180.7 496 176 496H113.3c-3.148 0-6.992-3.004-7.758-6.035l-24-96.07C80.74 390.6 80 384.5 80 380.9c0-12.5 1.816-16.4 21.5-54.82l11.12-21.77c3.379-6.625 1.75-14.7-3.926-19.5C90.46 269.4 80 247.2 80 224c0-33.2 20.46-61.46 49.34-73.5C131.2 164.8 135.1 179.2 142.2 192.8c19.56 37.59 58.47 61.52 115.7 71.11c.4375 .0781 .875 .1094 1.312 .1094c3.844 0 7.219-2.766 7.875-6.672c.75-4.359-2.188-8.484-6.562-9.219C208.5 239.4 173.5 218.3 156.4 185.5C134.6 143.6 146.4 91.47 155.8 63.47C168.4 93.12 200.3 142.3 272 143.7L288 144l.0032-16c4.164-61.83 55.91-111.1 115.7-111.1h124.2c-1.602 7.621-5.773 14.54-12.07 20.02c-7.695 6.688-6.594 17.27-1.152 23.05c7.094 7.531 13.18 12.34 13.18 23.16l.0625 75.27C527.1 165.8 521.2 175.8 513.5 178.9zM541.4 69.07c-1.768-4.934-4.336-9.555-7.988-13.48l-7.023-7.547c.0313-.0273-.0313 .0273 0 0L592 48L541.4 69.07z"],
    "alien": [448, 512, [128125], "f8f5", "M117.1 211.1h-36C72.02 211.1 64 220 64 229.1c0 49.64 40.36 89.99 89.1 89.99h36C199.1 319.1 208 311.1 208 301.1C208 252.3 167.6 211.1 117.1 211.1zM189.1 303.1h-36C113.2 303.1 80 270.8 80 229.1c0-1.141 .8594-2 1.999-2h36C158.8 227.1 192 261.2 192 301.1C192 303.1 191.1 303.1 189.1 303.1zM365.1 211.1h-36C280.4 211.1 240 252.3 240 301.1c0 9.984 7.891 17.1 17.87 17.1l36.12 .0004C343.6 319.1 384 279.6 384 229.1C384 220 375.1 211.1 365.1 211.1zM293.1 303.1h-36C256.9 303.1 256 303.1 256 301.1c0-40.8 33.2-73.99 73.1-73.99h36c1.141 0 2.001 .8594 2.001 2C368 270.8 334.8 303.1 293.1 303.1zM224 .0001c-123.8 0-224 87.1-224 232.5c0 111.7 134.3 224.5 194.9 269.9C203.5 508.8 213.8 512 224 512s20.5-3.219 29.12-9.656C313.8 456.1 448 344.2 448 232.5C448 87.1 347.8 .0001 224 .0001zM243.6 489.5C237.9 493.8 231.1 496 224 496s-13.88-2.24-19.54-6.465C147.8 447.1 16 337.2 16 232.5c0-127.5 85.53-216.5 208-216.5s208 89.02 208 216.5C432 337.2 300.2 447.1 243.6 489.5z"],
    "alien-8bit": [576, 512, [128126, "alien-monster"], "f8f6", "M560 128l-32 .0001c-8.875 0-16 7.125-16 15.1v80h-32V176c0-8.875-7.125-16-16-16H416v-64l32 .0002c8.875 0 16-7.125 16-15.1v-32c0-8.875-7.125-16-16-16l-48 .0005c-8.875 0-16 7.125-16 16v15.1l-16-.0001c-8.875 0-16 7.125-16 16v48H224v-48c0-8.875-7.125-16-16-16L192 64V48c0-8.875-7.125-16-16-16L128 32c-8.875 0-16 7.125-16 16v32c0 8.875 7.125 15.1 16 15.1l32-.0002v64H112c-8.875 0-16 7.125-16 16v48H64V144C64 135.1 56.88 128 48 128l-32-.0001c-8.875 0-16 7.125-16 15.1v128c0 8.875 7.125 16 16 16H64v80c0 8.875 7.125 16 16 16l48 0v80c0 8.875 7.125 16 16 16l96 0c8.875 0 16-7.125 16-15.1v-31.1c0-8.875-7.125-16-16-16H192v-32h192v32h-48c-8.875 0-16 7.125-16 16v31.1c0 8.875 7.125 15.1 16 15.1l96 0c8.875 0 16-7.125 16-16v-80l48 0c8.875 0 16-7.125 16-16v-80h48c8.875 0 16-7.125 16-16v-128C576 135.1 568.9 128 560 128zM240 432v32h-96v-80l32-.0004v48H240zM432 464h-96v-32h64v-48l32 .0004V464zM560 272h-64v96h-416v-96h-64v-128l32-.0004v96l64 .0004v-64h64v-96H128v-32h48v32h32v64h160v-64h32v-32H448v32h-48v96h64v64l64-.0004v-96l32 .0004V272zM208 224l-32 .0004c-8.836 0-16 7.162-16 16v64c0 8.836 7.164 16 16 16h32c8.836 0 16-7.164 16-16v-64C224 231.2 216.8 224 208 224zM208 304l-32 .0004v-64h32V304zM400 224l-32-.0004c-8.836 0-16 7.162-16 16v64c0 8.836 7.164 16 16 16h32c8.836 0 16-7.164 16-16v-64C416 231.2 408.8 224 400 224zM400 304l-32-.0004V240h32V304z"],
    "align-center": [448, 512, [], "f037", "M344 56C348.4 56 352 59.58 352 64C352 68.42 348.4 72 344 72H104C99.58 72 96 68.42 96 64C96 59.58 99.58 56 104 56H344zM440 184C444.4 184 448 187.6 448 192C448 196.4 444.4 200 440 200H8C3.582 200 0 196.4 0 192C0 187.6 3.582 184 8 184H440zM96 320C96 315.6 99.58 312 104 312H344C348.4 312 352 315.6 352 320C352 324.4 348.4 328 344 328H104C99.58 328 96 324.4 96 320zM440 440C444.4 440 448 443.6 448 448C448 452.4 444.4 456 440 456H8C3.582 456 0 452.4 0 448C0 443.6 3.582 440 8 440H440z"],
    "align-justify": [448, 512, [], "f039", "M440 56C444.4 56 448 59.58 448 64C448 68.42 444.4 72 440 72H8C3.582 72 0 68.42 0 64C0 59.58 3.582 56 8 56H440zM0 192C0 187.6 3.582 184 8 184H440C444.4 184 448 187.6 448 192C448 196.4 444.4 200 440 200H8C3.582 200 0 196.4 0 192zM440 312C444.4 312 448 315.6 448 320C448 324.4 444.4 328 440 328H8C3.582 328 0 324.4 0 320C0 315.6 3.582 312 8 312H440zM440 440C444.4 440 448 443.6 448 448C448 452.4 444.4 456 440 456H8C3.582 456 0 452.4 0 448C0 443.6 3.582 440 8 440H440z"],
    "align-left": [448, 512, [], "f036", "M280 56C284.4 56 288 59.58 288 64C288 68.42 284.4 72 280 72H8C3.582 72 0 68.42 0 64C0 59.58 3.582 56 8 56H280zM440 184C444.4 184 448 187.6 448 192C448 196.4 444.4 200 440 200H8C3.582 200 0 196.4 0 192C0 187.6 3.582 184 8 184H440zM0 320C0 315.6 3.582 312 8 312H280C284.4 312 288 315.6 288 320C288 324.4 284.4 328 280 328H8C3.582 328 0 324.4 0 320zM440 440C444.4 440 448 443.6 448 448C448 452.4 444.4 456 440 456H8C3.582 456 0 452.4 0 448C0 443.6 3.582 440 8 440H440z"],
    "align-right": [448, 512, [], "f038", "M440 56C444.4 56 448 59.58 448 64C448 68.42 444.4 72 440 72H168C163.6 72 160 68.42 160 64C160 59.58 163.6 56 168 56H440zM440 184C444.4 184 448 187.6 448 192C448 196.4 444.4 200 440 200H8C3.582 200 0 196.4 0 192C0 187.6 3.582 184 8 184H440zM440 328H168C163.6 328 160 324.4 160 320C160 315.6 163.6 312 168 312H440C444.4 312 448 315.6 448 320C448 324.4 444.4 328 440 328zM440 440C444.4 440 448 443.6 448 448C448 452.4 444.4 456 440 456H8C3.582 456 0 452.4 0 448C0 443.6 3.582 440 8 440H440z"],
    "align-slash": [640, 512, [], "f846", "M636.1 497.7C640.4 500.5 641 505.5 638.3 508.1C635.5 512.4 630.5 513 627 510.3L3.022 14.26C-.4365 11.51-1.012 6.481 1.738 3.022C4.487-.4365 9.52-1.012 12.98 1.738L636.1 497.7zM274.7 311.1L295 328H103.1C99.58 328 95.1 324.4 95.1 319.1C95.1 315.6 99.58 311.1 103.1 311.1H274.7zM527.4 328L507.1 311.1H536C540.4 311.1 544 315.6 544 319.1C544 324.4 540.4 328 536 328H527.4zM536 199.1H365.3L344.1 183.1H536C540.4 183.1 544 187.6 544 191.1C544 196.4 540.4 199.1 536 199.1zM103.1 199.1C99.58 199.1 95.1 196.4 95.1 191.1C95.1 187.6 99.58 183.1 103.1 183.1H112.6L132.9 199.1H103.1zM544 63.1C544 68.42 540.4 71.1 536 71.1H203.1L182.9 55.1H536C540.4 55.1 544 59.58 544 63.1V63.1zM103.1 456C99.58 456 95.1 452.4 95.1 448C95.1 443.6 99.58 440 103.1 440H436.9L457.1 456H103.1z"],
    "alt": [640, 512, [], "e08a", "M416 440c0 4.418 3.582 8 8 8h208c4.418 0 8-3.582 8-8s-3.582-8-8-8h-208C419.6 432 416 435.6 416 440zM640 72C640 67.59 636.4 64 632 64h-136.8c-22.31 0-42.97 10.06-56.72 27.62L188.9 410.5C178.2 424.2 162.2 432 144.8 432H8C3.594 432 0 435.6 0 440S3.594 448 8 448h136.8c22.31 0 42.97-10.06 56.72-27.62l249.6-318.9C461.8 87.84 477.8 80 495.2 80H632C636.4 80 640 76.41 640 72z"],
    "amp-guitar": [512, 512, [], "f8a1", "M448 96h-36.35C397.1 79.5 328.3 0 256 0S114 79.5 100.3 96H64C28.65 96 0 124.7 0 160v288c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V160C512 124.7 483.3 96 448 96zM256 16c54.85 0 111.1 54.49 134.4 80H121.6C144.9 70.49 201.1 16 256 16zM496 448c0 26.47-21.53 48-48 48H64c-26.47 0-48-21.53-48-48V272h480V448zM496 256h-480V160c0-26.47 21.53-48 48-48h384c26.47 0 48 21.53 48 48V256zM352 352c8.836 0 16-7.164 16-16S360.8 320 352 320s-16 7.164-16 16S343.2 352 352 352zM352 416c-8.836 0-16 7.164-16 16S343.2 448 352 448s16-7.164 16-16S360.8 416 352 416zM320 400c8.836 0 16-7.164 16-16s-7.164-16-16-16s-16 7.164-16 16S311.2 400 320 400zM416 352c8.836 0 16-7.164 16-16S424.8 320 416 320s-16 7.164-16 16S407.2 352 416 352zM416 416c-8.836 0-16 7.164-16 16S407.2 448 416 448s16-7.164 16-16S424.8 416 416 416zM384 400c8.836 0 16-7.164 16-16s-7.164-16-16-16s-16 7.164-16 16S375.2 400 384 400zM224 416c-8.836 0-16 7.164-16 16S215.2 448 224 448s16-7.164 16-16S232.8 416 224 416zM160 416c-8.836 0-16 7.164-16 16S151.2 448 160 448s16-7.164 16-16S168.8 416 160 416zM288 352c8.836 0 16-7.164 16-16S296.8 320 288 320s-16 7.164-16 16S279.2 352 288 352zM288 416c-8.836 0-16 7.164-16 16S279.2 448 288 448s16-7.164 16-16S296.8 416 288 416zM256 400c8.836 0 16-7.164 16-16s-7.164-16-16-16S240 375.2 240 384S247.2 400 256 400zM96 448c8.836 0 16-7.164 16-16S104.8 416 96 416s-16 7.164-16 16S87.16 448 96 448zM96 352c8.836 0 16-7.164 16-16S104.8 320 96 320s-16 7.164-16 16S87.16 352 96 352zM160 352c8.836 0 16-7.164 16-16S168.8 320 160 320s-16 7.164-16 16S151.2 352 160 352zM192 400c8.836 0 16-7.164 16-16S200.8 368 192 368S176 375.2 176 384S183.2 400 192 400zM128 400c8.836 0 16-7.164 16-16S136.8 368 128 368S112 375.2 112 384S119.2 400 128 400zM224 352c8.836 0 16-7.164 16-16S232.8 320 224 320s-16 7.164-16 16S215.2 352 224 352zM320 160c-17.67 0-32 14.33-32 32c0 17.67 14.33 32 32 32s32-14.33 32-32C352 174.3 337.7 160 320 160zM320 208c-8.822 0-16-7.178-16-16s7.178-16 16-16s16 7.178 16 16S328.8 208 320 208zM416 160c-17.67 0-32 14.33-32 32c0 17.67 14.33 32 32 32s32-14.33 32-32C448 174.3 433.7 160 416 160zM416 208c-8.822 0-16-7.178-16-16s7.178-16 16-16s16 7.178 16 16S424.8 208 416 208zM96 160C78.33 160 64 174.3 64 192c0 17.67 14.33 32 32 32s32-14.33 32-32C128 174.3 113.7 160 96 160zM96 208C87.18 208 80 200.8 80 192S87.18 176 96 176S112 183.2 112 192S104.8 208 96 208zM192 160C174.3 160 160 174.3 160 192c0 17.67 14.33 32 32 32s32-14.33 32-32C224 174.3 209.7 160 192 160zM192 208C183.2 208 176 200.8 176 192S183.2 176 192 176S208 183.2 208 192S200.8 208 192 208z"],
    "ampersand": [384, 512, [], "26", "M381.8 466.5l-79.12-83.3l79.87-114.6c2.531-3.625 1.625-8.609-2-11.14c-3.562-2.5-8.562-1.656-11.12 1.984l-77.1 111.9L158.3 231.2l75.84-60.58c18.97-14.88 29.84-37 29.84-60.69C263.1 66.95 228.1 32 183.9 32H136.1C91.94 32 55.1 66.95 55.1 109.9c0 23.59 9.031 46.16 25.44 63.56l53.28 56.09L37.16 307.5c-23.62 18.5-37.16 46.02-37.16 75.52C.0002 436.5 44.75 480 99.75 480h69.56c41.06 0 79.41-19.66 102.6-52.63l21.44-30.78l76.84 80.92C371.8 479.2 373.9 480 375.1 480c1.969 0 3.969-.7344 5.5-2.203C384.7 474.8 384.8 469.7 381.8 466.5zM93.06 162.5C79.47 148.1 71.1 129.4 71.1 109.9C71.1 75.77 100.7 48 136.1 48h47.81c35.34 0 64.09 27.77 64.09 61.91c0 18.75-8.656 36.28-23.78 48.14L147.3 219.5L93.06 162.5zM258.8 418.2C238.6 446.9 205.2 464 169.3 464h-69.56c-46.19 0-83.75-36.33-83.75-80.97c0-24.55 11.31-47.47 31.09-62.97l98.69-78.86l136.3 143.5L258.8 418.2z"],
    "anchor": [576, 512, [9875], "f13d", "M368 80C368 121.5 336.4 155.6 295.1 159.6C295.1 159.7 296 159.9 296 160V208H376C380.4 208 384 211.6 384 216C384 220.4 380.4 224 376 224H296V496H304C405.6 496 488 413.6 488 312V284.8L429.9 349.4C426.1 352.6 421.9 352.9 418.6 349.9C415.4 346.1 415.1 341.9 418.1 338.6L490.1 258.6C491.6 256.1 493.7 256 496 256C498.3 256 500.4 256.1 501.9 258.6L573.9 338.6C576.9 341.9 576.6 346.1 573.4 349.9C570.1 352.9 565 352.6 562.1 349.4L504 284.8V312C504 422.5 414.5 512 304 512H272C161.5 512 72 422.5 72 312V284.8L13.95 349.4C10.99 352.6 5.932 352.9 2.648 349.9C-.6357 346.1-.902 341.9 2.054 338.6L74.05 258.6C75.57 256.1 77.73 256 80 256C82.27 256 84.43 256.1 85.95 258.6L157.9 338.6C160.9 341.9 160.6 346.1 157.4 349.9C154.1 352.9 149 352.6 146.1 349.4L88 284.8V312C88 413.6 170.4 496 272 496H280V224H200C195.6 224 192 220.4 192 216C192 211.6 195.6 208 200 208H280V160C280 159.9 280 159.7 280 159.6C239.6 155.6 208 121.5 208 80C208 35.82 243.8 0 288 0C332.2 0 368 35.82 368 80H368zM288 144C323.3 144 352 115.3 352 80C352 44.65 323.3 16 288 16C252.7 16 224 44.65 224 80C224 115.3 252.7 144 288 144z"],
    "anchor-circle-check": [640, 512, [], "e4aa", "M368 80C368 121.5 336.4 155.6 295.1 159.6C295.1 159.7 296 159.9 296 160V208H376C380.4 208 384 211.6 384 216C384 220.4 380.4 224 376 224H296V496H304C325.4 496 345.1 492.3 365.1 485.6C368.1 489.1 373.1 494.1 377.4 498.1C354.7 507.1 329.9 512 304 512H272C161.5 512 72 422.5 72 312V284.8L13.95 349.4C10.99 352.6 5.932 352.9 2.648 349.9C-.6358 346.1-.902 341.9 2.054 338.6L74.05 258.6C75.57 256.1 77.73 256 80 256C82.27 256 84.43 256.1 85.95 258.6L157.9 338.6C160.9 341.9 160.6 346.1 157.4 349.9C154.1 352.9 149 352.6 146.1 349.4L88 284.8V312C88 413.6 170.4 496 272 496H280V224H200C195.6 224 192 220.4 192 216C192 211.6 195.6 208 200 208H280V160C280 159.9 280 159.7 280 159.6C239.6 155.6 208 121.5 208 80C208 35.82 243.8 0 288 0C332.2 0 368 35.82 368 80V80zM288 144C323.3 144 352 115.3 352 80C352 44.65 323.3 16 288 16C252.7 16 224 44.65 224 80C224 115.3 252.7 144 288 144zM565.7 322.3C568.8 325.5 568.8 330.5 565.7 333.7L485.7 413.7C482.5 416.8 477.5 416.8 474.3 413.7L426.3 365.7C423.2 362.5 423.2 357.5 426.3 354.3C429.5 351.2 434.5 351.2 437.7 354.3L480 396.7L554.3 322.3C557.5 319.2 562.5 319.2 565.7 322.3H565.7zM352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368zM496 496C566.7 496 624 438.7 624 368C624 297.3 566.7 240 496 240C425.3 240 368 297.3 368 368C368 438.7 425.3 496 496 496z"],
    "anchor-circle-exclamation": [640, 512, [], "e4ab", "M368 80C368 121.5 336.4 155.6 295.1 159.6C295.1 159.7 296 159.9 296 160V208H376C380.4 208 384 211.6 384 216C384 220.4 380.4 224 376 224H296V496H304C325.4 496 345.1 492.3 365.1 485.6C368.1 489.1 373.1 494.1 377.4 498.1C354.7 507.1 329.9 512 304 512H272C161.5 512 72 422.5 72 312V284.8L13.95 349.4C10.99 352.6 5.932 352.9 2.648 349.9C-.6358 346.1-.902 341.9 2.054 338.6L74.05 258.6C75.57 256.1 77.73 256 80 256C82.27 256 84.43 256.1 85.95 258.6L157.9 338.6C160.9 341.9 160.6 346.1 157.4 349.9C154.1 352.9 149 352.6 146.1 349.4L88 284.8V312C88 413.6 170.4 496 272 496H280V224H200C195.6 224 192 220.4 192 216C192 211.6 195.6 208 200 208H280V160C280 159.9 280 159.7 280 159.6C239.6 155.6 208 121.5 208 80C208 35.82 243.8 0 288 0C332.2 0 368 35.82 368 80V80zM288 144C323.3 144 352 115.3 352 80C352 44.65 323.3 16 288 16C252.7 16 224 44.65 224 80C224 115.3 252.7 144 288 144zM480 432C480 423.2 487.2 416 496 416C504.8 416 512 423.2 512 432C512 440.8 504.8 448 496 448C487.2 448 480 440.8 480 432zM495.1 280C500.4 280 503.1 283.6 503.1 288V384C503.1 388.4 500.4 392 495.1 392C491.6 392 487.1 388.4 487.1 384V288C487.1 283.6 491.6 280 495.1 280zM640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368zM496 240C425.3 240 368 297.3 368 368C368 438.7 425.3 496 496 496C566.7 496 624 438.7 624 368C624 297.3 566.7 240 496 240z"],
    "anchor-circle-xmark": [640, 512, [], "e4ac", "M368 80C368 121.5 336.4 155.6 295.1 159.6C295.1 159.7 296 159.9 296 160V208H376C380.4 208 384 211.6 384 216C384 220.4 380.4 224 376 224H296V496H304C325.4 496 345.1 492.3 365.1 485.6C368.1 489.1 373.1 494.1 377.4 498.1C354.7 507.1 329.9 512 304 512H272C161.5 512 72 422.5 72 312V284.8L13.95 349.4C10.99 352.6 5.932 352.9 2.648 349.9C-.6358 346.1-.902 341.9 2.054 338.6L74.05 258.6C75.57 256.1 77.73 256 80 256C82.27 256 84.43 256.1 85.95 258.6L157.9 338.6C160.9 341.9 160.6 346.1 157.4 349.9C154.1 352.9 149 352.6 146.1 349.4L88 284.8V312C88 413.6 170.4 496 272 496H280V224H200C195.6 224 192 220.4 192 216C192 211.6 195.6 208 200 208H280V160C280 159.9 280 159.7 280 159.6C239.6 155.6 208 121.5 208 80C208 35.82 243.8 0 288 0C332.2 0 368 35.82 368 80V80zM288 144C323.3 144 352 115.3 352 80C352 44.65 323.3 16 288 16C252.7 16 224 44.65 224 80C224 115.3 252.7 144 288 144zM557.7 418.3C560.8 421.5 560.8 426.5 557.7 429.7C554.5 432.8 549.5 432.8 546.3 429.7L496 379.3L445.7 429.7C442.5 432.8 437.5 432.8 434.3 429.7C431.2 426.5 431.2 421.5 434.3 418.3L484.7 368L434.3 317.7C431.2 314.5 431.2 309.5 434.3 306.3C437.5 303.2 442.5 303.2 445.7 306.3L496 356.7L546.3 306.3C549.5 303.2 554.5 303.2 557.7 306.3C560.8 309.5 560.8 314.5 557.7 317.7L507.3 368L557.7 418.3zM640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368zM496 240C425.3 240 368 297.3 368 368C368 438.7 425.3 496 496 496C566.7 496 624 438.7 624 368C624 297.3 566.7 240 496 240z"],
    "anchor-lock": [640, 512, [], "e4ad", "M368 80C368 121.5 336.4 155.6 295.1 159.6C295.1 159.7 296 159.9 296 160V208H376C380.4 208 384 211.6 384 216C384 220.4 380.4 224 376 224H296V496H304C332.7 496 359.8 489.4 384 477.7V480C384 485 384.6 489.9 385.7 494.6C360.7 505.8 333.1 512 304 512H272C161.5 512 72 422.5 72 312V284.8L13.95 349.4C10.99 352.6 5.932 352.9 2.648 349.9C-.6358 346.1-.902 341.9 2.054 338.6L74.05 258.6C75.57 256.1 77.73 256 80 256C82.27 256 84.43 256.1 85.95 258.6L157.9 338.6C160.9 341.9 160.6 346.1 157.4 349.9C154.1 352.9 149 352.6 146.1 349.4L88 284.8V312C88 413.6 170.4 496 272 496H280V224H200C195.6 224 192 220.4 192 216C192 211.6 195.6 208 200 208H280V160C280 159.9 280 159.7 280 159.6C239.6 155.6 208 121.5 208 80C208 35.82 243.8 0 288 0C332.2 0 368 35.82 368 80V80zM288 144C323.3 144 352 115.3 352 80C352 44.65 323.3 16 288 16C252.7 16 224 44.65 224 80C224 115.3 252.7 144 288 144zM528 192C563.3 192 592 220.7 592 256V320H608C625.7 320 640 334.3 640 352V480C640 497.7 625.7 512 608 512H448C430.3 512 416 497.7 416 480V352C416 334.3 430.3 320 448 320H464V256C464 220.7 492.7 192 528 192zM528 208C501.5 208 480 229.5 480 256V320H576V256C576 229.5 554.5 208 528 208zM432 352V480C432 488.8 439.2 496 448 496H608C616.8 496 624 488.8 624 480V352C624 343.2 616.8 336 608 336H448C439.2 336 432 343.2 432 352z"],
    "angel": [640, 512, [], "f779", "M213.1 90.3c3.406-2.812 3.891-7.859 1.062-11.25C210.1 74.09 208 69.03 208 64c0-22.7 45.1-48 112-48c65.1 0 112 25.3 112 48c0 5.031-2.078 10.09-6.156 15.05c-2.828 3.391-2.344 8.438 1.062 11.25C428.4 91.53 430.2 92.14 432 92.14c2.297 0 4.578-.9844 6.156-2.906C444.7 81.36 447.1 72.86 447.1 64c0-35.89-56.22-64-127.1-64S192 28.11 192 64c0 8.859 3.31 17.36 9.841 25.23C204.6 92.64 209.7 93.08 213.1 90.3zM603.7 453.1l-38.16-78.63c-6.625-13.5-6.625-29.62 0-43.13c4.75-9.75 8.655-16.62 11.9-22.12c9.5-16.5 14.47-26.47 14.47-53.22c0-51.13-46.87-96-100.4-96c-24.87 0-48.97 10.25-66.34 28.12L352.6 261.5c-12.67-4.221-24.28-5.453-32.58-5.453c-8.285 0-19.85 1.255-32.43 5.417L214.1 188.3c-17.5-18-41.69-28.19-66.44-28.19c-53.5 0-100.5 44.81-100.5 95.94c0 26.75 4.1 36.75 14.5 53.25c3.25 5.5 7.125 12.25 11.87 22c6.625 13.5 6.625 29.62 0 43.13l-38.09 78.75c-6.373 12.88-5.53 27.75 1.968 39.88C45.76 504.9 58.57 512 72.57 512h494.1c13.88 0 26.69-7.125 34.19-19C609.2 480.9 610.1 465.9 603.7 453.1zM72.51 496c-8.41 0-16.16-4.316-20.64-11.42c-4.637-7.494-5.109-16.6-1.207-24.49l38.09-78.67c8.793-17.92 8.793-39.31 .0195-57.18C83.77 313.1 79.7 306.9 76.37 301.3C67.58 285.1 64.01 278.9 64.01 256c0-42.62 39.48-80 84.5-80c20.51 0 40.57 8.529 55.13 23.51l68.1 68.69C252.1 278.1 237.2 293.5 227.4 313.2L135.1 496H72.51zM153.9 496l87.8-175.6C261.7 280.3 302 272 319.1 272c17.91 0 58.27 8.324 78.31 48.4L486.1 496H153.9zM588.2 484.5C583.6 491.7 575.9 496 567.6 496h-63.63L412.6 313.2c-9.824-19.65-25.52-35.04-44.21-44.96l68.31-69.01C451.1 184.5 471.1 176 491.6 176c44.95 0 84.37 37.38 84.37 80c0 22.88-3.57 29.99-12.28 45.11c-3.416 5.781-7.49 13.01-12.46 23.22c-8.793 17.91-8.793 39.31-.0332 57.15l38.21 78.8C593.3 467.1 592.8 477.1 588.2 484.5zM240 144c0 44.25 35.75 80 79.1 80s79.1-35.75 79.1-80S364.2 64 320 64S240 99.75 240 144zM383.1 144c0 35.29-28.71 64-63.1 64s-63.1-28.71-63.1-64c0-35.29 28.71-64 63.1-64S383.1 108.7 383.1 144z"],
    "angle": [448, 512, [], "e08c", "M20.94 464H440C444.4 464 448 467.6 448 472C448 476.4 444.4 480 440 480H8C5.228 480 2.652 478.6 1.195 476.2C-.2627 473.8-.3952 470.9 .8448 468.4L216.8 36.42C218.8 32.47 223.6 30.87 227.6 32.84C231.5 34.82 233.1 39.63 231.2 43.58L20.94 464zM294 250.7C296.8 254.3 295.8 259.5 291.9 262C288.3 264.3 283.6 263.4 281 259.1C262.6 235.7 240.8 214.2 216.2 196.1C212.1 193.8 211.9 189.5 213.7 185.9C215.8 181.5 221.4 180.1 225.3 182.1C251.4 202.1 274.6 224.9 294 250.7V250.7zM313.7 313.6C311.9 309.9 313.1 305.4 316.6 303.2C320.6 300.7 325.9 302.1 327.9 306.4C342.9 337.6 353.1 371.5 357.5 407.2C358.1 411.9 354.4 416 349.6 416C345.5 416 342.1 412.9 341.6 408.8C337.3 375.1 327.7 343.1 313.7 313.6V313.6z"],
    "angle-90": [448, 512, [], "e08d", "M440 464H16V40C16 35.58 12.42 32 8 32S0 35.58 0 40v432C0 476.4 3.578 480 8 480h432c4.422 0 8-3.594 8-8S444.4 464 440 464zM348.6 424c.375 0 .7656-.0313 1.141-.0938c4.375-.625 7.422-4.656 6.797-9.031c-3.875-27.09-11-53.69-21.17-79c-1.656-4.125-6.281-6.031-10.41-4.469c-4.094 1.656-6.078 6.312-4.438 10.41c9.688 24.16 16.48 49.5 20.17 75.31C341.3 421.1 344.7 424 348.6 424zM276.9 265.2c1.578 2.062 3.953 3.141 6.359 3.141c1.703 0 3.406-.5313 4.859-1.641c3.5-2.688 4.188-7.703 1.5-11.22c-18.77-24.55-40.7-46.48-65.23-65.17C220.9 187.6 215.9 188.2 213.2 191.8c-2.688 3.516-2 8.531 1.516 11.2C238.1 220.8 259 241.7 276.9 265.2zM62.88 139.3C88.7 143 114 149.8 138.2 159.5c.9844 .3906 1.984 .5781 2.984 .5781c3.172 0 6.172-1.891 7.422-5.016c1.641-4.109-.3438-8.766-4.438-10.41C118.8 134.5 92.23 127.4 65.13 123.5C60.88 122.1 56.7 125.9 56.08 130.3C55.45 134.6 58.5 138.7 62.88 139.3z"],
    "angle-down": [384, 512, [8964], "f107", "M191.1 352c-1.1 0-3.969-.7344-5.531-2.219L34.47 205.8c-3.187-3.047-3.312-8.125-.25-11.31c3.094-3.188 8.156-3.281 11.31-.25l146.5 138.7l146.5-138.7c3.219-3.031 8.281-2.938 11.31 .25c3.062 3.188 2.937 8.266-.25 11.31l-151.1 144C195.1 351.3 193.1 352 191.1 352z"],
    "angle-left": [256, 512, [8249], "f104", "M32 255.1c0-1.1 .7344-3.969 2.219-5.531l144-151.1c3.047-3.187 8.125-3.312 11.31-.25c3.188 3.094 3.281 8.156 .25 11.31L51.08 255.1l138.7 146.5c3.031 3.219 2.938 8.281-.25 11.31c-3.188 3.062-8.266 2.937-11.31-.25L34.22 261.5C32.73 259.1 32 257.1 32 255.1z"],
    "angle-right": [256, 512, [8250], "f105", "M224 256c0 1.1-.7344 3.969-2.219 5.531l-144 151.1c-3.047 3.187-8.125 3.312-11.31 .25c-3.188-3.094-3.281-8.156-.25-11.31l138.7-146.5L66.21 109.5C63.18 106.3 63.27 101.3 66.46 98.22c3.188-3.062 8.266-2.937 11.31 .25l144 151.1C223.3 252 224 254 224 256z"],
    "angle-up": [384, 512, [8963], "f106", "M192 160c1.1 0 3.969 .7344 5.531 2.219l151.1 144c3.187 3.047 3.312 8.125 .25 11.31c-3.094 3.188-8.156 3.281-11.31 .25L192 179.1L45.53 317.8c-3.219 3.031-8.281 2.938-11.31-.25c-3.062-3.188-2.937-8.266 .25-11.31l151.1-144C188 160.7 190 160 192 160z"],
    "angles-down": [384, 512, ["angle-double-down"], "f103", "M338.5 290.2l-146.5 138.7L45.53 290.2C42.38 287.2 37.31 287.3 34.22 290.5C31.16 293.7 31.28 298.7 34.47 301.8l151.1 144c1.562 1.484 3.531 2.219 5.531 2.219s3.969-.7344 5.531-2.219l152-144c3.187-3.047 3.312-8.125 .25-11.31C346.7 287.3 341.7 287.2 338.5 290.2zM186.5 253.8C188 255.3 189.1 255.1 191.1 255.1s3.969-.7344 5.531-2.219l152-144c3.187-3.047 3.312-8.125 .25-11.31c-3.031-3.188-8.093-3.281-11.31-.25L191.1 236.9L45.53 98.21C42.38 95.18 37.31 95.27 34.22 98.46C31.16 101.6 31.28 106.7 34.47 109.8L186.5 253.8z"],
    "angles-left": [448, 512, [171, "angle-double-left"], "f100", "M189.8 402.5L51.08 255.1L189.8 109.5c3.031-3.156 2.938-8.218-.25-11.31C186.3 95.16 181.3 95.28 178.2 98.47L34.22 250.5C32.73 252 32 253.1 32 255.1s.7344 3.969 2.219 5.531l144 152c3.047 3.187 8.125 3.312 11.31 .25C192.7 410.7 192.8 405.7 189.8 402.5zM226.2 250.5c-1.484 1.562-2.219 3.531-2.219 5.531s.7344 3.969 2.219 5.531l144 152c3.047 3.187 8.125 3.312 11.31 .25c3.188-3.031 3.281-8.093 .25-11.31l-138.7-146.5L381.8 109.5c3.031-3.156 2.938-8.218-.25-11.31c-3.188-3.062-8.266-2.937-11.31 .25L226.2 250.5z"],
    "angles-right": [448, 512, [187, "angle-double-right"], "f101", "M258.2 109.5l138.7 146.5l-138.7 146.5c-3.031 3.156-2.938 8.218 .25 11.31c3.188 3.062 8.266 2.937 11.31-.25l144-151.1c1.484-1.562 2.219-3.531 2.219-5.531c0-1.1-.7344-3.969-2.219-5.531L269.8 98.47c-3.047-3.187-8.125-3.312-11.31-.25C255.3 101.3 255.2 106.3 258.2 109.5zM221.8 261.5C223.3 259.1 223.1 258 223.1 256c0-1.1-.7344-3.969-2.219-5.531L77.77 98.47C74.72 95.28 69.65 95.16 66.46 98.22C63.27 101.3 63.18 106.3 66.21 109.5l138.7 146.5l-138.7 146.5c-3.031 3.156-2.938 8.218 .25 11.31c3.188 3.062 8.266 2.937 11.31-.25L221.8 261.5z"],
    "angles-up": [384, 512, ["angle-double-up"], "f102", "M45.53 221.8l146.5-138.7l146.5 138.7c3.156 3.031 8.218 2.938 11.31-.25c3.062-3.188 2.937-8.266-.25-11.31l-151.1-144C195.1 64.73 194 64 192 64S188 64.73 186.5 66.22L34.47 210.2c-3.187 3.047-3.312 8.125-.25 11.31C37.25 224.7 42.31 224.8 45.53 221.8zM197.5 258.2C195.1 256.7 194 256 192 256S188 256.7 186.5 258.2l-152 144c-3.187 3.047-3.312 8.125-.25 11.31c3.031 3.188 8.093 3.281 11.31 .25l146.5-138.7l146.5 138.7c3.156 3.031 8.218 2.938 11.31-.25c3.062-3.188 2.937-8.266-.25-11.31L197.5 258.2z"],
    "ankh": [320, 512, [9765], "f644", "M280 280h-100.7c42.79-44.6 84.2-110 84.2-163.3C263.5 44.72 223.8 0 160 0S56.53 44.72 56.53 116.7c0 53.28 41.41 118.7 84.2 163.3H40C35.59 280 32 283.6 32 288s3.594 8 8 8h112v208C152 508.4 155.6 512 160 512s8-3.578 8-8v-208h112C284.4 296 288 292.4 288 288S284.4 280 280 280zM160 16c54.78 0 87.47 37.64 87.47 100.7c0 55.16-50.41 123.8-87.47 160.2C122.9 240.5 72.53 171.8 72.53 116.7C72.53 53.64 105.2 16 160 16z"],
    "apartment": [576, 512, [], "e468", "M320 344C306.7 344 296 333.3 296 320V288C296 274.7 306.7 264 320 264H352C365.3 264 376 274.7 376 288V320C376 333.3 365.3 344 352 344H320zM360 288C360 283.6 356.4 280 352 280H320C315.6 280 312 283.6 312 288V320C312 324.4 315.6 328 320 328H352C356.4 328 360 324.4 360 320V288zM504 416C504 429.3 493.3 440 480 440H448C434.7 440 424 429.3 424 416V384C424 370.7 434.7 360 448 360H480C493.3 360 504 370.7 504 384V416zM480 424C484.4 424 488 420.4 488 416V384C488 379.6 484.4 376 480 376H448C443.6 376 440 379.6 440 384V416C440 420.4 443.6 424 448 424H480zM96 344C82.75 344 72 333.3 72 320V288C72 274.7 82.75 264 96 264H128C141.3 264 152 274.7 152 288V320C152 333.3 141.3 344 128 344H96zM136 288C136 283.6 132.4 280 128 280H96C91.58 280 88 283.6 88 288V320C88 324.4 91.58 328 96 328H128C132.4 328 136 324.4 136 320V288zM152 416C152 429.3 141.3 440 128 440H96C82.75 440 72 429.3 72 416V384C72 370.7 82.75 360 96 360H128C141.3 360 152 370.7 152 384V416zM128 424C132.4 424 136 420.4 136 416V384C136 379.6 132.4 376 128 376H96C91.58 376 88 379.6 88 384V416C88 420.4 91.58 424 96 424H128zM224 344C210.7 344 200 333.3 200 320V288C200 274.7 210.7 264 224 264H256C269.3 264 280 274.7 280 288V320C280 333.3 269.3 344 256 344H224zM264 288C264 283.6 260.4 280 256 280H224C219.6 280 216 283.6 216 288V320C216 324.4 219.6 328 224 328H256C260.4 328 264 324.4 264 320V288zM376 128C376 141.3 365.3 152 352 152H320C306.7 152 296 141.3 296 128V96C296 82.75 306.7 72 320 72H352C365.3 72 376 82.75 376 96V128zM320 88C315.6 88 312 91.58 312 96V128C312 132.4 315.6 136 320 136H352C356.4 136 360 132.4 360 128V96C360 91.58 356.4 88 352 88H320zM256 72C269.3 72 280 82.75 280 96V128C280 141.3 269.3 152 256 152H224C210.7 152 200 141.3 200 128V96C200 82.75 210.7 72 224 72H256zM264 96C264 91.58 260.4 88 256 88H224C219.6 88 216 91.58 216 96V128C216 132.4 219.6 136 224 136H256C260.4 136 264 132.4 264 128V96zM376 224C376 237.3 365.3 248 352 248H320C306.7 248 296 237.3 296 224V192C296 178.7 306.7 168 320 168H352C365.3 168 376 178.7 376 192V224zM352 232C356.4 232 360 228.4 360 224V192C360 187.6 356.4 184 352 184H320C315.6 184 312 187.6 312 192V224C312 228.4 315.6 232 320 232H352zM448 344C434.7 344 424 333.3 424 320V288C424 274.7 434.7 264 448 264H480C493.3 264 504 274.7 504 288V320C504 333.3 493.3 344 480 344H448zM488 288C488 283.6 484.4 280 480 280H448C443.6 280 440 283.6 440 288V320C440 324.4 443.6 328 448 328H480C484.4 328 488 324.4 488 320V288zM152 224C152 237.3 141.3 248 128 248H96C82.75 248 72 237.3 72 224V192C72 178.7 82.75 168 96 168H128C141.3 168 152 178.7 152 192V224zM128 232C132.4 232 136 228.4 136 224V192C136 187.6 132.4 184 128 184H96C91.58 184 88 187.6 88 192V224C88 228.4 91.58 232 96 232H128zM224 248C210.7 248 200 237.3 200 224V192C200 178.7 210.7 168 224 168H256C269.3 168 280 178.7 280 192V224C280 237.3 269.3 248 256 248H224zM264 192C264 187.6 260.4 184 256 184H224C219.6 184 216 187.6 216 192V224C216 228.4 219.6 232 224 232H256C260.4 232 264 228.4 264 224V192zM80 512C44.65 512 16 483.3 16 448V160C16 124.7 44.65 96 80 96H144V64C144 28.65 172.7 0 208 0H368C403.3 0 432 28.65 432 64V192H496C531.3 192 560 220.7 560 256V448C560 483.3 531.3 512 496 512H80zM160 112H80C53.49 112 32 133.5 32 160V448C32 474.5 53.49 496 80 496H240V432C240 405.5 261.5 384 288 384C314.5 384 336 405.5 336 432V496H496C522.5 496 544 474.5 544 448V256C544 229.5 522.5 208 496 208H416V64C416 37.49 394.5 16 368 16H208C181.5 16 160 37.49 160 64V112zM288 400C270.3 400 256 414.3 256 432V496H320V432C320 414.3 305.7 400 288 400z"],
    "aperture": [512, 512, [], "e2df", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM302.2 336H209.8L163.6 255.1L209.8 176h92.38l46.19 80.01L302.2 336zM320.6 176h161.4C490.9 201.1 496 227.9 496 256c0 53.24-17.64 102.3-47.09 142.2L320.6 176zM475.8 160H219l80.72-139.8C378.8 34.84 444.4 88.24 475.8 160zM256 16c9.07 0 17.99 .6094 26.8 1.594L154.4 240l-80.67-139.7C117.8 48.8 183.1 16 256 16zM63.09 113.8L191.4 336H30C21.1 310.9 16 284.1 16 256C16 202.8 33.64 153.7 63.09 113.8zM36.18 352h256.8l-80.72 139.8C133.2 477.2 67.64 423.8 36.18 352zM256 496c-9.07 0-17.99-.6094-26.8-1.594l128.4-222.4l80.67 139.7C394.2 463.2 328.9 496 256 496z"],
    "apostrophe": [192, 512, [], "27", "M192 112C192 67.82 156.2 32 112 32S32 67.82 32 112C32 156.2 67.82 192 112 192c26.29 0 49.42-12.85 64-32.44V184c0 48.53-39.47 88-88 88h-16C67.59 272 64 275.6 64 280S67.59 288 72 288h16C145.3 288 192 241.3 192 184v-64c0-.6113-.5195-.9941-.6484-1.564C191.5 116.3 192 114.2 192 112zM112 176c-35.29 0-64-28.71-64-64s28.71-64 64-64s64 28.71 64 64S147.3 176 112 176z"],
    "apple-core": [384, 512, [], "e08f", "M192 112c76.9 0 95.88-49.87 95.88-96c-.5684-8.537-7.373-15.43-15.91-15.1c-89.2 0-95.95 65.3-95.95 95.12C176 104.1 183.1 111.4 192 112zM271.4 16c.3496 .0234 .8223 2.748 .8223 7.178c0 19.6-9.24 72.61-79.14 72.86C192.7 96.01 191.1 92.5 191.1 86.97C191.1 66.07 201.6 16.29 271.4 16zM287.1 304c0-62.49 32.6-117.2 81.69-148.4c-27.47-27.16-57.85-27.61-65.58-27.61c-38.44 0-89.71 19.52-112.1 32.06c-21.69-12.17-73.57-32.12-112.3-32.12c-7.689 0-37.87 .4912-65.34 27.67C63.41 186.8 95.1 241.5 95.1 304c0 61.11-31.24 114.9-78.52 146.5c33.2 46.48 68.13 61.42 102.1 61.42c35.08 0 62.98-16.4 72.42-16.4C200.9 495.5 228.8 512 264.1 512c34.42 0 69.4-15.22 102.4-61.5C319.2 418.9 287.1 365.1 287.1 304zM264.1 496c-34.02 0-57.38-16.48-72.07-16.48c-14.82 0-39.03 16.4-72.42 16.4c-29.54 0-55.47-13.58-79.46-42.19C85.42 417.4 112 362.6 112 304c0-58.51-26.27-112.8-71.24-149.1c16.79-10.23 31.72-10.8 36.27-10.8c50.9 0 100.5 26.16 114.9 34.29c14.44-8.087 64.21-34.31 114.9-34.31c4.412 0 19.45 .5391 36.35 10.82C298.3 191.2 272 245.5 272 304c0 58.64 26.61 113.5 71.96 149.8C320.3 482.2 294.1 496 264.1 496z"],
    "apple-whole": [448, 512, [127823, 127822, "apple-alt"], "f5d1", "M444.9 249.1c-5.316-31.35-15.32-57.37-29.96-78.06c-16.67-23.35-37.91-37.27-63.89-41.94c-31.73-5.314-90.99 10.74-127 30.92c-35.85-20.12-95.08-36.33-126.1-31.01C71.06 133.7 49.77 147.7 33.1 171.1c-14.67 20.69-24.67 46.71-29.99 78.06c-12 73.91 12.08 155.9 48.97 205.2c72.71 98.14 154.4 41.25 171.9 41.25c16.51 0 99.12 57.08 171.9-41.25C433.9 403.6 456.7 321.1 444.9 249.1zM383 444.7c-65.97 89.13-132.2 34.76-159 34.76c-27.81 0-93.23 54.09-159.1-34.83c-34.76-46.41-57.1-124.6-46-192.9c7.131-42.05 28.27-97.52 80.79-106.1c16.51-2.762 66.25 1.023 124.3 33.59c57.66-32.29 107.3-36.42 124.1-33.62c52.65 9.477 73.79 64.58 80.97 106.9C440.3 320.1 417.1 398.1 383 444.7zM224 112c76.9 0 95.88-49.87 95.88-96c-.5684-8.537-7.373-15.43-15.91-15.1c-88.02 0-95.7 63.2-95.95 94.99C207.1 103.1 215 111.4 224 112zM303.4 16c1.9 .1289 7.381 79.73-78.32 80.04C223.1 95.9 215.1 16.37 303.4 16z"],
    "archway": [512, 512, [], "f557", "M408 144C412.4 144 416 147.6 416 152C416 156.4 412.4 160 408 160H104C99.58 160 96 156.4 96 152C96 147.6 99.58 144 104 144H408zM0 40C0 35.58 3.582 32 8 32H504C508.4 32 512 35.58 512 40C512 44.42 508.4 48 504 48H480V464H504C508.4 464 512 467.6 512 472C512 476.4 508.4 480 504 480H352V352C352 298.1 309 256 256 256C202.1 256 160 298.1 160 352V480H8C3.582 480 0 476.4 0 472C0 467.6 3.582 464 8 464H32V48H8C3.582 48 0 44.42 0 40zM48 464H144V352C144 290.1 194.1 240 256 240C317.9 240 368 290.1 368 352V464H464V48H48V464z"],
    "arrow-down": [384, 512, [8595], "f063", "M368.2 307.1l-170.5 170.5c-3.14 3.14-8.226 3.14-11.37 0L15.82 307.1c-3.14-3.14-3.14-8.226 0-11.37c3.14-3.14 8.226-3.14 11.37 0l156.8 156.8V40.04c0-4.427 3.596-8.034 8.038-8.034s8.036 3.607 8.036 8.034v412.5l156.8-156.8c3.14-3.14 8.226-3.14 11.37 0C371.3 298.9 371.3 304 368.2 307.1z"],
    "arrow-down-1-9": [512, 512, ["sort-numeric-asc", "sort-numeric-down"], "f162", "M352 208c-4.422 0-8 3.594-8 8s3.579 7.998 8 7.998L416 224c4.422 0 8-3.594 8-8S420.4 208 416 208h-24V40c0-2.781-1.438-5.344-3.797-6.812c-2.359-1.438-5.312-1.594-7.781-.3438l-32 16c-3.953 1.969-5.547 6.781-3.578 10.72c1.984 3.969 6.75 5.531 10.73 3.594L376 52.94V208H352zM376 264c-39.7 0-72 32.31-72 72s32.3 72 72 72c22.73 0 42.79-10.8 56-27.31V408c0 30.88-25.12 56-56 56H352c-4.422 0-8 3.594-8 8S347.6 480 352 480h24c39.7 0 72-32.31 72-72V336C448 296.3 415.7 264 376 264zM376 392c-30.88 0-56-25.12-56-56s25.12-56 56-56s56 25.12 56 56S406.9 392 376 392zM210.1 370.7L136 451.5V40C136 35.59 132.4 32 128 32S120 35.59 120 40v411.5l-74.1-80.85c-1.596-1.719-3.752-2.594-5.908-2.594c-1.938 0-3.875 .6875-5.406 2.094c-3.25 3.002-3.469 8.064-.5 11.32l88 96.02c3.062 3.312 8.75 3.312 11.81 0l88-96.02c2.969-3.252 2.75-8.314-.5-11.32C218.2 367.2 213.1 367.4 210.1 370.7z"],
    "arrow-down-9-1": [512, 512, ["sort-numeric-desc", "sort-numeric-down-alt"], "f886", "M210.1 370.7L136 451.5V40C136 35.59 132.4 32 128 32S120 35.59 120 40v411.5l-74.1-80.85c-1.596-1.719-3.752-2.594-5.908-2.594c-1.938 0-3.875 .6875-5.406 2.094c-3.25 3.002-3.469 8.064-.5 11.32l88 96.02c3.062 3.312 8.75 3.312 11.81 0l88-96.02c2.969-3.252 2.75-8.314-.5-11.32C218.2 367.2 213.1 367.4 210.1 370.7zM416 464h-24V296c0-2.781-1.438-5.344-3.797-6.812c-2.359-1.438-5.312-1.594-7.781-.3438l-32 16c-3.953 1.969-5.547 6.781-3.578 10.72c1.984 3.969 6.75 5.531 10.73 3.594L376 308.9V464H352c-4.422 0-8 3.594-8 8S347.6 480 352 480H416c4.422 0 8-3.594 8-8S420.4 464 416 464zM376 32c-39.7 0-72 32.31-72 72s32.3 72 72 72c22.73 0 42.79-10.8 56-27.31V176c0 30.88-25.12 56-56 56H352c-4.422 0-8 3.594-8 8S347.6 248 352 248h24C415.7 248 448 215.7 448 176V104C448 64.31 415.7 32 376 32zM376 160C345.1 160 320 134.9 320 104s25.12-56 56-56s56 25.12 56 56S406.9 160 376 160z"],
    "arrow-down-a-z": [512, 512, ["sort-alpha-asc", "sort-alpha-down"], "f15d", "M210.1 370.7L136 451.5V40c0-4.408-3.594-8.002-8-8.002S120 35.59 120 40v411.5l-74.1-80.85c-1.594-1.719-3.75-2.594-5.906-2.594c-1.938 0-3.875 .6875-5.406 2.094c-3.25 3.002-3.469 8.064-.5 11.32l88 96.02c3.062 3.312 8.75 3.312 11.81 0l88-96.02c2.969-3.252 2.75-8.314-.5-11.32C218.2 367.2 213.1 367.4 210.1 370.7zM456 464h-127.1l133.3-162.9c1.969-2.375 2.375-5.688 1.031-8.5C461.9 289.8 459.1 288 456 288h-144c-4.406 0-8 3.594-8 8s3.594 8 8 8h127.1l-133.3 162.9c-1.969 2.375-2.375 5.688-1.031 8.5C306.1 478.2 308.9 480 312 480h144c4.406 0 8-3.594 8-8S460.4 464 456 464zM479.2 212.4l-88-176c-2.688-5.438-11.62-5.438-14.31 0l-88 176c-1.969 3.938-.375 8.75 3.594 10.72c3.812 1.906 8.75 .4062 10.72-3.594L328.9 168h110.1l25.78 51.56C466.3 222.4 469.1 224 472 224c1.219 0 2.438-.2813 3.562-.8438C479.5 221.2 481.1 216.4 479.2 212.4zM336.9 152L384 57.88L431.1 152H336.9z"],
    "arrow-down-arrow-up": [448, 512, ["sort-alt"], "f883", "M210.1 370.7L136 451.5V40C136 35.59 132.4 32 128 32S120 35.59 120 40v411.5l-74.1-80.85c-1.594-1.719-3.75-2.594-5.906-2.594c-1.938 0-3.875 .6875-5.406 2.094c-3.25 3.002-3.469 8.064-.5 11.32l88 96.02c3.062 3.312 8.75 3.312 11.81 0l88-96.02c2.969-3.252 2.75-8.314-.5-11.32C218.2 367.2 213.1 367.4 210.1 370.7zM413.9 130.5l-88-96.02c-3.062-3.312-8.75-3.312-11.81 0l-88 96.02c-2.969 3.252-2.75 8.314 .5 11.32c3.25 3 8.312 2.781 11.31-.5L312 60.47V471.1C312 476.4 315.6 480 320 480s8-3.594 8-8.002V60.47l74.1 80.85c1.594 1.719 3.75 2.594 5.906 2.594c1.938 0 3.875-.6875 5.406-2.094C416.7 138.8 416.9 133.8 413.9 130.5z"],
    "arrow-down-big-small": [512, 512, ["sort-size-down"], "f88c", "M480 32h-191.1c-17.67 0-32 14.33-32 32v160c0 17.67 14.33 32 32 32H480c17.67 0 32-14.33 32-32V64C512 46.33 497.7 32 480 32zM496 224c0 8.822-7.178 16-16 16h-191.1c-8.822 0-16-7.178-16-16V64c0-8.822 7.178-16 16-16H480c8.822 0 16 7.178 16 16V224zM416 320h-127.1c-17.6 0-32 14.4-32 32v96c0 17.6 14.4 32 32 32H416c17.6 0 32-14.4 32-32v-96C448 334.4 433.6 320 416 320zM432 448c0 8.822-7.178 16-16 16h-127.1c-8.822 0-16-7.178-16-16v-96c0-8.822 7.178-16 16-16H416c8.822 0 16 7.178 16 16V448zM178.1 370.7L104 451.5V40C104 35.59 100.4 32 96 32S88 35.59 88 40v411.5l-74.1-80.85c-1.594-1.719-3.75-2.594-5.906-2.594c-1.938 0-3.875 .6875-5.406 2.094c-3.25 3.002-3.469 8.064-.5 11.32l88 96.02c3.062 3.312 8.75 3.312 11.81 0l88-96.02c2.969-3.252 2.75-8.314-.5-11.32C186.2 367.2 181.1 367.4 178.1 370.7z"],
    "arrow-down-from-dotted-line": [448, 512, [], "e090", "M320 79.1c8.836 0 16-7.164 16-16s-7.164-16-16-16s-16 7.164-16 16S311.2 79.1 320 79.1zM224 79.1c8.836 0 16-7.164 16-16s-7.164-16-16-16s-16 7.164-16 16S215.2 79.1 224 79.1zM416 79.1c8.836 0 16-7.164 16-16s-7.164-16-16-16s-16 7.164-16 16S407.2 79.1 416 79.1zM128 79.1c8.836 0 16-7.164 16-16s-7.164-16-16-16s-16 7.164-16 16S119.2 79.1 128 79.1zM32 79.1c8.836 0 16-7.164 16-16s-7.164-16-16-16s-16 7.164-16 16S23.16 79.1 32 79.1zM218.3 477.7c3.125 3.125 8.188 3.125 11.31 0l152-152C383.2 324.1 384 322.1 384 319.1s-.7813-4.094-2.344-5.656c-3.125-3.125-8.188-3.125-11.31 0L232 452.7V167.1c0-4.406-3.578-8-8-8s-8 3.594-8 8v284.7L77.66 314.3c-3.125-3.125-8.188-3.125-11.31 0s-3.125 8.188 0 11.31L218.3 477.7z"],
    "arrow-down-from-line": [384, 512, [8615, "arrow-from-top"], "f345", "M186.3 477.7c3.125 3.125 8.188 3.125 11.31 0l152-152C351.2 324.1 352 322.1 352 320s-.7813-4.094-2.344-5.656c-3.125-3.125-8.188-3.125-11.31 0L200 452.7V136c0-4.406-3.578-7.968-8-7.968S184 131.6 184 136v316.7L45.66 314.3c-3.125-3.125-8.188-3.125-11.31 0s-3.125 8.188 0 11.31L186.3 477.7zM8 48h368C380.4 48 384 44.42 384 40S380.4 32 376 32H8C3.582 32 0 35.58 0 40S3.582 48 8 48z"],
    "arrow-down-left": [320, 512, [], "e091", "M7.999 160c4.419 0 7.999 3.58 7.999 7.999v220.7l290.3-290.3c3.116-3.116 8.187-3.127 11.31 0s3.116 8.198 0 11.31l-290.3 290.3h220.7C252.4 400 256 403.6 256 408S252.4 416 248 416H7.999C3.58 416 0 412.4 0 408V167.1C0 163.6 3.577 160 7.999 160z"],
    "arrow-down-left-and-arrow-up-right-to-center": [512, 512, [], "e092", "M45.77 477.5l162.3-162.3v140.7c0 4.42 3.523 8.058 7.941 8.058c4.42 0 8.057-3.632 8.057-8.058V295.9c0-4.416-3.576-7.998-8-7.998h-160c-4.439 0-8.057 3.65-8.057 8.057c0 4.42 3.637 7.941 8.057 7.941h140.7l-162.3 162.3C26.97 473.7 38.29 485 45.77 477.5zM295.9 224.1h160c4.439 0 8.055-3.648 8.055-8.057c0-4.42-3.635-7.941-8.055-7.941H315.2l162.3-162.3c7.469-7.465-3.816-18.81-11.31-11.31l-162.3 162.3V56.12c0-4.42-3.525-8.058-7.943-8.058c-4.42 0-8.055 3.634-8.055 8.058v160C287.9 220.5 291.5 224.1 295.9 224.1z"],
    "arrow-down-long": [320, 512, ["long-arrow-down"], "f175", "M154.3 509.7c3.125 3.125 8.188 3.125 11.31 0l152-152C319.2 356.1 320 354.1 320 352s-.7813-4.094-2.344-5.656c-3.125-3.125-8.188-3.125-11.31 0L168 484.7V8C168 3.594 164.4 0 160 0S152 3.594 152 8v476.7l-138.3-138.3c-3.125-3.125-8.188-3.125-11.31 0s-3.125 8.188 0 11.31L154.3 509.7z"],
    "arrow-down-right": [320, 512, [], "e093", "M320 167.1v240C320 412.4 316.4 416 312 416H71.1C67.58 416 64 412.4 64 408s3.58-7.999 7.999-7.999h220.7L2.341 109.7c-3.116-3.116-3.127-8.187 0-11.31s8.198-3.116 11.31 0l290.3 290.3V167.1C304 163.6 307.6 160 312 160C316.4 160 320 163.6 320 167.1z"],
    "arrow-down-short-wide": [576, 512, ["sort-amount-desc", "sort-amount-down-alt"], "f884", "M210.1 370.7L136 451.5V40C136 35.59 132.4 32 128 32S120 35.59 120 40v411.5l-74.1-80.85c-1.594-1.719-3.75-2.594-5.906-2.594c-1.938 0-3.875 .6875-5.406 2.094c-3.25 3.002-3.469 8.064-.5 11.32l88 96.02c3.062 3.312 8.75 3.312 11.81 0l88-96.02c2.969-3.252 2.75-8.314-.5-11.32C218.2 367.2 213.1 367.4 210.1 370.7zM264 192h144C412.4 192 416 188.4 416 184S412.4 176 408 176h-144C259.6 176 256 179.6 256 184S259.6 192 264 192zM264 64h80C348.4 64 352 60.41 352 56S348.4 48 344 48h-80C259.6 48 256 51.59 256 56S259.6 64 264 64zM264 320h208C476.4 320 480 316.4 480 312S476.4 304 472 304h-208C259.6 304 256 307.6 256 312S259.6 320 264 320zM536 432h-272C259.6 432 256 435.6 256 440S259.6 448 264 448h272c4.406 0 8-3.594 8-8S540.4 432 536 432z"],
    "arrow-down-small-big": [512, 512, ["sort-size-down-alt"], "f88d", "M288 192H416c17.67 0 32-14.33 32-32V64c0-17.6-14.4-32-32-32h-127.1c-17.67 0-32 14.33-32 32v96C256 177.6 270.4 192 288 192zM272 64c0-8.822 7.178-16 16-16H416c8.822 0 16 7.178 16 16v96c0 8.822-7.178 16-16 16h-127.1c-8.822 0-16-7.178-16-16V64zM480 256h-191.1c-17.67 0-32 14.33-32 32v160c0 17.67 14.33 32 32 32H480c17.67 0 32-14.33 32-32V288C512 270.3 497.7 256 480 256zM496 448c0 8.822-7.178 16-16 16h-191.1c-8.822 0-16-7.178-16-16V288c0-8.822 7.178-16 16-16H480c8.822 0 16 7.178 16 16V448zM178.1 370.7L104 451.5V40C104 35.59 100.4 32 96 32S88 35.59 88 40v411.5l-74.1-80.85c-1.594-1.719-3.75-2.594-5.906-2.594c-1.938 0-3.875 .6875-5.406 2.094c-3.25 3.002-3.469 8.064-.5 11.32l88 96.02c3.062 3.312 8.75 3.312 11.81 0l88-96.02c2.969-3.252 2.75-8.314-.5-11.32C186.2 367.2 181.1 367.4 178.1 370.7z"],
    "arrow-down-square-triangle": [512, 512, ["sort-shapes-down-alt"], "f889", "M304 224l128-.0059c17.67 0 32-14.32 32-31.99V64c0-17.67-14.33-32-32-32h-128c-17.67 0-32 14.33-32 32v128C272 209.7 286.3 224 304 224zM288 64c0-8.822 7.178-16 16-16h128c8.822 0 16 7.178 16 16v128c0 8.822-7.178 16-16 16h-128c-8.822 0-16-7.178-16-16V64zM476.1 438.9l-83.13-137.1c-5.562-9.188-15.25-13.78-24.94-13.78s-19.38 4.594-24.94 13.78l-83.25 137.1C248.9 457.1 262.6 480 284.9 480h166.3C473.4 480 487.1 457.1 476.1 438.9zM462.6 457.7C460.4 461.6 456.1 464 451.1 464h-166.3c-4.945 0-9.229-2.359-11.46-6.311c-1.119-1.982-2.588-5.99 .1367-10.51l83.26-137.1c3.316-5.477 8.973-6.068 11.25-6.068c2.279 0 7.936 .5918 11.26 6.076l83.11 137.1C465.2 451.7 463.7 455.7 462.6 457.7zM210.1 370.7L136 451.5V40c0-4.408-3.594-8.002-8-8.002S120 35.59 120 40v411.5l-74.1-80.85c-1.594-1.719-3.75-2.594-5.906-2.594c-1.938 0-3.875 .6875-5.406 2.094c-3.25 3.002-3.469 8.064-.5 11.32l88 96.02c3.062 3.312 8.75 3.312 11.81 0l88-96.02c2.969-3.252 2.75-8.314-.5-11.32C218.2 367.2 213.1 367.4 210.1 370.7z"],
    "arrow-down-to-arc": [512, 512, [], "e4ae", "M256 496C388.5 496 496 388.5 496 256C496 251.6 499.6 248 504 248C508.4 248 512 251.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 251.6 3.582 248 8 248C12.42 248 16 251.6 16 256C16 388.5 123.5 496 256 496zM262.1 349.2C260.6 350.1 258.4 352 256 352C253.6 352 251.4 350.1 249.9 349.2L121.9 197.2C119 193.8 119.5 188.7 122.8 185.9C126.2 183 131.3 183.5 134.1 186.8L247.1 322.1V8C247.1 3.582 251.6 0 255.1 0C260.4 0 264 3.582 264 8V322.1L377.9 186.8C380.7 183.5 385.8 183 389.2 185.9C392.5 188.7 392.1 193.8 390.1 197.2L262.1 349.2z"],
    "arrow-down-to-bracket": [448, 512, [], "e094", "M448 472v-80c0-4.422-3.578-8-8-8s-8 3.578-8 8v80c0 13.23-10.77 24-24 24H40c-13.23 0-24-10.77-24-24v-80C16 387.6 12.42 384 8 384S0 387.6 0 392v80C0 494.1 17.94 512 40 512h368C430.1 512 448 494.1 448 472zM229.7 381.7l184-184C415.2 196.1 416 194.1 416 192s-.7813-4.094-2.344-5.656c-3.125-3.125-8.188-3.125-11.31 0L232 356.7V8C232 3.594 228.4 0 224 0S216 3.594 216 8v348.7L45.66 186.3c-3.125-3.125-8.188-3.125-11.31 0C32.78 187.9 32 189.9 32 192s.7813 4.094 2.344 5.656l184 184C219.9 383.2 221.1 384 224 384S228.1 383.2 229.7 381.7z"],
    "arrow-down-to-dotted-line": [448, 512, [], "e095", "M128 432c-8.836 0-16 7.164-16 16s7.164 16 16 16s16-7.164 16-16S136.8 432 128 432zM224 432c-8.836 0-16 7.164-16 16s7.164 16 16 16s16-7.164 16-16S232.8 432 224 432zM32 432c-8.836 0-16 7.164-16 16s7.164 16 16 16s16-7.164 16-16S40.84 432 32 432zM320 432c-8.836 0-16 7.164-16 16s7.164 16 16 16s16-7.164 16-16S328.8 432 320 432zM416 432c-8.836 0-16 7.164-16 16s7.164 16 16 16s16-7.164 16-16S424.8 432 416 432zM218.3 365.7c3.125 3.125 8.188 3.125 11.31 0l152-152C383.2 212.1 384 210.1 384 207.1s-.7813-4.094-2.344-5.656c-3.125-3.125-8.188-3.125-11.31 0L232 340.7V55.1c0-4.406-3.578-8-8-8s-8 3.594-8 8v284.7L77.66 202.3c-3.125-3.125-8.188-3.125-11.31 0s-3.125 8.188 0 11.31L218.3 365.7z"],
    "arrow-down-to-line": [384, 512, ["arrow-to-bottom"], "f33d", "M186.3 381.7c3.125 3.125 8.188 3.125 11.31 0l152-152C351.2 228.1 352 226.1 352 224s-.7813-4.094-2.344-5.656c-3.125-3.125-8.188-3.125-11.31 0L200 356.7V40C200 35.59 196.4 32 192 32S184 35.59 184 40v316.7L45.66 218.3c-3.125-3.125-8.188-3.125-11.31 0s-3.125 8.188 0 11.31L186.3 381.7zM8 480h368c4.418 0 8-3.582 8-8s-3.582-8-8-8H8C3.582 464 0 467.6 0 472S3.582 480 8 480z"],
    "arrow-down-to-square": [512, 512, [], "e096", "M440 128h-80C355.6 128 352 131.6 352 136s3.594 8 8 8h80c13.22 0 24 10.78 24 24v304c0 13.22-10.78 24-24 24H72c-13.22 0-24-10.78-24-24v-304c0-13.22 10.78-24 24-24h80C156.4 144 160 140.4 160 136S156.4 128 152 128h-80C49.94 128 32 145.9 32 168v304C32 494.1 49.94 512 72 512h368c22.06 0 40-17.94 40-40v-304C480 145.9 462.1 128 440 128zM154.3 274.3c-3.125 3.125-3.125 8.188 0 11.31l96 96C251.9 383.2 253.9 384 256 384s4.094-.7813 5.656-2.344l96-96c3.125-3.125 3.125-8.188 0-11.31s-8.188-3.125-11.31 0L264 356.7V8C264 3.594 260.4 0 256 0S248 3.594 248 8v348.7L165.7 274.3C162.5 271.2 157.5 271.2 154.3 274.3z"],
    "arrow-down-triangle-square": [512, 512, ["sort-shapes-down"], "f888", "M432 288l-128 .0107c-17.67 0-32 14.33-32 32V448c0 17.67 14.33 32 32 32l128-.0098c17.67 0 32-14.32 32-31.99v-127.1C464 302.3 449.7 288 432 288zM448 448c0 8.822-7.178 16-16 16h-128c-8.822 0-16-7.178-16-16v-127.1c0-8.822 7.178-15.1 16-15.1h128c8.822 0 16 7.178 16 16V448zM476.1 182.9L393 45.78C387.4 36.59 377.8 32 368.1 32s-19.38 4.594-24.94 13.78l-83.25 137.1c-11 18.25 2.75 41.12 25 41.12h166.3C473.4 224 487.1 201.1 476.1 182.9zM462.6 201.7c-2.232 3.951-6.518 6.311-11.46 6.311h-166.3c-4.945 0-9.229-2.359-11.46-6.309c-1.119-1.982-2.588-5.99 .1367-10.51l83.26-137.1C360.1 48.59 365.8 48 368.1 48c2.279 0 7.936 .5918 11.26 6.074l83.11 137.1C465.2 195.7 463.7 199.7 462.6 201.7zM210.1 370.7L136 451.5V40c0-4.408-3.594-8.002-8-8.002S120 35.59 120 40v411.5l-74.1-80.85c-1.596-1.719-3.752-2.594-5.908-2.594c-1.938 0-3.875 .6875-5.406 2.094c-3.25 3.002-3.469 8.064-.5 11.32l88 96.02c3.062 3.312 8.75 3.312 11.81 0l88-96.02c2.969-3.252 2.75-8.314-.5-11.32C218.2 367.2 213.1 367.4 210.1 370.7z"],
    "arrow-down-up-across-line": [576, 512, [], "e4af", "M58.34 413.7C55.22 410.5 55.22 405.5 58.34 402.3C61.47 399.2 66.53 399.2 69.66 402.3L152 484.7V263.1H8C3.582 263.1 0 260.4 0 255.1C0 251.6 3.582 247.1 8 247.1H408V27.31L325.7 109.7C322.5 112.8 317.5 112.8 314.3 109.7C311.2 106.5 311.2 101.5 314.3 98.34L410.3 2.343C413.5-.781 418.5-.781 421.7 2.343L517.7 98.34C520.8 101.5 520.8 106.5 517.7 109.7C514.5 112.8 509.5 112.8 506.3 109.7L424 27.31V247.1H568C572.4 247.1 576 251.6 576 255.1C576 260.4 572.4 263.1 568 263.1H168V484.7L250.3 402.3C253.5 399.2 258.5 399.2 261.7 402.3C264.8 405.5 264.8 410.5 261.7 413.7L165.7 509.7C162.5 512.8 157.5 512.8 154.3 509.7L58.34 413.7zM152 39.1C152 35.58 155.6 31.1 160 31.1C164.4 31.1 168 35.58 168 39.1V191.1H152V39.1zM424 319.1V472C424 476.4 420.4 480 416 480C411.6 480 408 476.4 408 472V319.1H424z"],
    "arrow-down-up-lock": [640, 512, [], "e4b0", "M122.3 509.7L26.34 413.7C23.22 410.5 23.22 405.5 26.34 402.3C29.47 399.2 34.53 399.2 37.66 402.3L120 484.7V264H8C3.582 264 0 260.4 0 256C0 251.6 3.582 248 8 248H312V27.31L229.7 109.7C226.5 112.8 221.5 112.8 218.3 109.7C215.2 106.5 215.2 101.5 218.3 98.34L314.3 2.343C317.5-.781 322.5-.781 325.7 2.343L421.7 98.34C424.8 101.5 424.8 106.5 421.7 109.7C418.5 112.8 413.5 112.8 410.3 109.7L328 27.31V248H418.6C417.4 253.2 416.7 258.5 416.3 264H136V484.7L218.3 402.3C221.5 399.2 226.5 399.2 229.7 402.3C232.8 405.5 232.8 410.5 229.7 413.7L133.7 509.7C130.5 512.8 125.5 512.8 122.3 509.7V509.7zM120 192V40C120 35.58 123.6 32 128 32C132.4 32 136 35.58 136 40V192H120zM328 320V472C328 476.4 324.4 480 320 480C315.6 480 312 476.4 312 472V320H328zM528 192C563.3 192 592 220.7 592 256V320H608C625.7 320 640 334.3 640 352V480C640 497.7 625.7 512 608 512H448C430.3 512 416 497.7 416 480V352C416 334.3 430.3 320 448 320H464V256C464 220.7 492.7 192 528 192zM528 208C501.5 208 480 229.5 480 256V320H576V256C576 229.5 554.5 208 528 208zM432 352V480C432 488.8 439.2 496 448 496H608C616.8 496 624 488.8 624 480V352C624 343.2 616.8 336 608 336H448C439.2 336 432 343.2 432 352z"],
    "arrow-down-wide-short": [576, 512, ["sort-amount-asc", "sort-amount-down"], "f160", "M210.1 370.7L136 451.5V40C136 35.59 132.4 32 128 32S120 35.59 120 40v411.5l-74.1-80.85c-1.594-1.719-3.75-2.594-5.906-2.594c-1.938 0-3.875 .6875-5.406 2.094c-3.25 3.002-3.469 8.064-.5 11.32l88 96.02c3.062 3.312 8.75 3.312 11.81 0l88-96.02c2.969-3.252 2.75-8.314-.5-11.32C218.2 367.2 213.1 367.4 210.1 370.7zM536 48h-272C259.6 48 256 51.59 256 56S259.6 64 264 64h272C540.4 64 544 60.41 544 56S540.4 48 536 48zM472 176h-208C259.6 176 256 179.6 256 184S259.6 192 264 192h208C476.4 192 480 188.4 480 184S476.4 176 472 176zM408 304h-144C259.6 304 256 307.6 256 312S259.6 320 264 320h144C412.4 320 416 316.4 416 312S412.4 304 408 304zM344 432h-80C259.6 432 256 435.6 256 440S259.6 448 264 448h80c4.406 0 8-3.594 8-8S348.4 432 344 432z"],
    "arrow-down-z-a": [512, 512, ["sort-alpha-desc", "sort-alpha-down-alt"], "f881", "M210.1 370.7L136 451.5V40c0-4.408-3.594-8.002-8-8.002S120 35.59 120 40v411.5l-74.1-80.85c-1.594-1.719-3.75-2.594-5.906-2.594c-1.938 0-3.875 .6875-5.406 2.094c-3.25 3.002-3.469 8.064-.5 11.32l88 96.02c3.062 3.312 8.75 3.312 11.81 0l88-96.02c2.969-3.252 2.75-8.314-.5-11.32C218.2 367.2 213.1 367.4 210.1 370.7zM455.1 208H328.9l133.3-162.9c1.969-2.375 2.375-5.688 1.031-8.5C461.9 33.78 459.1 32 455.1 32h-144c-4.406 0-8 3.594-8 8s3.594 8 8 8h127.1l-133.3 162.9c-1.969 2.375-2.375 5.688-1.031 8.5C306.1 222.2 308.9 224 311.1 224h144c4.406 0 8-3.594 8-8S460.4 208 455.1 208zM479.2 468.4l-88-176c-2.688-5.438-11.62-5.438-14.31 0l-88 176c-1.969 3.938-.375 8.75 3.594 10.72c3.812 1.906 8.75 .4062 10.72-3.594L328.9 424h110.1l25.78 51.56C466.2 478.4 469.1 480 471.1 480c1.219 0 2.438-.2813 3.562-.8438C479.5 477.2 481.1 472.4 479.2 468.4zM336.9 408l47.06-94.13L431.1 408H336.9z"],
    "arrow-left": [448, 512, [8592], "f060", "M172.9 432.2L2.355 261.7c-3.14-3.14-3.14-8.226 0-11.37l170.5-170.5c3.14-3.14 8.226-3.14 11.37 0s3.14 8.226 0 11.37L27.44 247.1h412.5c4.427 0 8.036 3.597 8.036 8.04s-3.61 8.035-8.036 8.035H27.44l156.8 156.8c3.14 3.14 3.14 8.226 0 11.37C181.1 435.3 175.1 435.3 172.9 432.2z"],
    "arrow-left-from-line": [448, 512, [8612, "arrow-from-right"], "f344", "M2.344 250.3c-3.125 3.125-3.125 8.188 0 11.31l152 152C155.9 415.2 157.9 416 160 416s4.094-.7813 5.656-2.344c3.125-3.125 3.125-8.188 0-11.31L27.31 264H344c4.406 0 7.968-3.578 7.968-8S348.4 248 344 248H27.31l138.3-138.3c3.125-3.125 3.125-8.188 0-11.31s-8.188-3.125-11.31 0L2.344 250.3zM432 72v368c0 4.418 3.582 8 8 8S448 444.4 448 440V72C448 67.58 444.4 64 440 64S432 67.58 432 72z"],
    "arrow-left-long": [512, 512, ["long-arrow-left"], "f177", "M2.344 250.3c-3.125 3.125-3.125 8.188 0 11.31l152 152C155.9 415.2 157.9 415.1 160 415.1s4.094-.7813 5.656-2.344c3.125-3.125 3.125-8.188 0-11.31L27.31 263.1H504C508.4 263.1 512 260.4 512 256s-3.594-8-8-8H27.31l138.3-138.3c3.125-3.125 3.125-8.188 0-11.31s-8.188-3.125-11.31 0L2.344 250.3z"],
    "arrow-left-long-to-line": [640, 512, [], "e3d4", "M0 72C0 67.58 3.582 64 8 64C12.42 64 16 67.58 16 72V440C16 444.4 12.42 448 8 448C3.582 448 0 444.4 0 440V72zM250.3 98.34C251.9 96.78 253.9 96 256 96C258.1 96 260.1 96.78 261.7 98.34C264.8 101.5 264.8 106.5 261.7 109.7L123.3 248H632C636.4 248 640 251.6 640 256C640 260.4 636.4 264 632 264H123.3L261.7 402.3C264.8 405.5 264.8 410.5 261.7 413.7C258.5 416.8 253.5 416.8 250.3 413.7L98.34 261.7C95.22 258.5 95.22 253.5 98.34 250.3L250.3 98.34z"],
    "arrow-left-to-line": [448, 512, [8676, "arrow-to-left"], "f33e", "M98.34 250.3c-3.125 3.125-3.125 8.188 0 11.31l152 152C251.9 415.2 253.9 416 256 416s4.094-.7813 5.656-2.344c3.125-3.125 3.125-8.188 0-11.31L123.3 264H440C444.4 264 448 260.4 448 256s-3.594-8-8-8H123.3l138.3-138.3c3.125-3.125 3.125-8.188 0-11.31s-8.188-3.125-11.31 0L98.34 250.3zM0 72v368C0 444.4 3.582 448 8 448s8-3.582 8-8V72C16 67.58 12.42 64 8 64S0 67.58 0 72z"],
    "arrow-pointer": [320, 512, ["mouse-pointer"], "f245", "M296.7 266.2L51.89 53.38C47.87 49.84 42.78 48 37.61 48c-3.002 0-6.033 .6211-8.896 1.893C20.98 53.38 15.1 61.09 15.1 69.58v331.2c0 9.057 5.654 17.16 14.15 20.28c2.434 .8868 4.951 1.322 7.453 1.322c6.217 0 12.28-2.686 16.45-7.608l84.87-102.8l69.85 147.5C210.1 462.3 213 464 215.1 464c1.156 0 2.312-.25 3.422-.7657c4-1.891 5.703-6.672 3.812-10.66L152.9 303.1h129.5c8.986 0 17.03-5.555 20.21-13.97C305.8 281.6 303.4 272.1 296.7 266.2zM287.6 284.4c-.8184 2.166-2.924 3.621-5.24 3.621H145.5c-4.773 0-9.299 2.133-12.34 5.815l-91.31 110.6c-1.057 1.246-2.607 1.961-4.254 1.961c-.6641 0-1.326-.1192-1.934-.3399c-2.193-.8067-3.666-2.92-3.666-5.26V69.58c0-2.197 1.293-4.201 3.205-5.065c.7715-.3418 1.582-.5157 2.404-.5157c1.371 0 2.686 .4922 3.781 1.457l244.7 212.7C287.8 279.7 288.5 282.2 287.6 284.4z"],
    "arrow-right": [448, 512, [8594], "f061", "M275.1 79.82l170.5 170.5c3.14 3.14 3.14 8.226 0 11.37l-170.5 170.5c-3.14 3.14-8.226 3.14-11.37 0c-3.14-3.14-3.14-8.226 0-11.37l156.8-156.8H8.037c-4.427 0-8.036-3.593-8.036-8.036s3.609-8.039 8.036-8.039h412.5l-156.8-156.8c-3.14-3.14-3.14-8.226 0-11.37C266.9 76.68 272 76.68 275.1 79.82z"],
    "arrow-right-arrow-left": [512, 512, [8644, "exchange"], "f0ec", "M504 376H30.1l127-105.8c3.391-2.844 3.844-7.875 1.016-11.28C155.3 255.4 150.2 255 146.9 257.8l-144 119.1C1.063 379.4 0 381.6 0 384s1.062 4.625 2.875 6.156l144 119.1C148.4 511.4 150.2 512 152 512c2.281 0 4.562-.9687 6.141-2.875c2.828-3.406 2.375-8.437-1.016-11.28l-127-105.8H504c4.422 0 8-3.594 8-7.1C512 379.6 508.4 376 504 376zM8 136h473.9l-127 105.8c-3.391 2.844-3.844 7.875-1.016 11.28C355.4 255 357.7 256 360 256c1.812 0 3.625-.5938 5.125-1.844l144-119.1C510.9 132.6 512 130.4 512 128c0-2.375-1.062-4.625-2.875-6.156l-144-119.1c-3.359-2.812-8.422-2.375-11.27 1.031c-2.828 3.406-2.375 8.437 1.016 11.28l127 105.8H8c-4.422 0-8 3.594-8 7.1C0 132.4 3.578 136 8 136z"],
    "arrow-right-from-arc": [512, 512, [], "e4b1", "M256 496C260.4 496 264 499.6 264 504C264 508.4 260.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C260.4 0 264 3.582 264 8C264 12.42 260.4 16 256 16C123.5 16 16 123.5 16 256C16 388.5 123.5 496 256 496zM509.2 249.9C510.1 251.4 512 253.6 512 256C512 258.4 510.1 260.6 509.2 262.1L357.2 390.1C353.8 392.1 348.7 392.5 345.9 389.2C343 385.8 343.5 380.7 346.8 377.9L482.1 264H167.1C163.6 264 159.1 260.4 159.1 256C159.1 251.6 163.6 248 167.1 248H482.1L346.8 134.1C343.5 131.3 343 126.2 345.9 122.8C348.7 119.5 353.8 119 357.2 121.9L509.2 249.9z"],
    "arrow-right-from-bracket": [512, 512, ["sign-out"], "f08b", "M120 464h-80c-13.23 0-24-10.77-24-24V72c0-13.23 10.77-24 24-24h80C124.4 48 128 44.42 128 40S124.4 32 120 32h-80C17.94 32 0 49.94 0 72v368C0 462.1 17.94 480 40 480h80C124.4 480 128 476.4 128 472S124.4 464 120 464zM509.7 250.3l-184-184C324.1 64.78 322.1 64 320 64s-4.094 .7813-5.656 2.344c-3.125 3.125-3.125 8.188 0 11.31L484.7 248H136C131.6 248 128 251.6 128 256s3.594 8 8 8h348.7l-170.3 170.3c-3.125 3.125-3.125 8.188 0 11.31C315.9 447.2 317.9 448 320 448s4.094-.7813 5.656-2.344l184-184C511.2 260.1 512 258 512 256S511.2 251.9 509.7 250.3z"],
    "arrow-right-from-line": [448, 512, [8614, "arrow-from-left"], "f343", "M445.7 261.7c3.125-3.125 3.125-8.188 0-11.31l-152-152C292.1 96.78 290.1 96 288 96s-4.094 .7813-5.656 2.344c-3.125 3.125-3.125 8.188 0 11.31L420.7 248H104C99.59 248 96.03 251.6 96.03 256S99.59 264 104 264h316.7l-138.3 138.3c-3.125 3.125-3.125 8.188 0 11.31s8.188 3.125 11.31 0L445.7 261.7zM16 440V72C16 67.58 12.42 64 8 64S0 67.58 0 72v368C0 444.4 3.582 448 8 448S16 444.4 16 440z"],
    "arrow-right-long": [512, 512, ["long-arrow-right"], "f178", "M509.7 261.7c3.125-3.125 3.125-8.188 0-11.31l-152-152C356.1 96.78 354.1 95.1 352 95.1s-4.094 .7813-5.656 2.344c-3.125 3.125-3.125 8.188 0 11.31l138.3 138.3H8c-4.406 0-8 3.578-8 8C0 260.4 3.594 263.1 8 263.1h476.7l-138.3 138.3c-3.125 3.125-3.125 8.188 0 11.31s8.188 3.125 11.31 0L509.7 261.7z"],
    "arrow-right-long-to-line": [640, 512, [], "e3d5", "M640 440C640 444.4 636.4 448 632 448C627.6 448 624 444.4 624 440V72C624 67.58 627.6 64 632 64C636.4 64 640 67.58 640 72V440zM541.7 250.3C544.8 253.5 544.8 258.5 541.7 261.7L389.7 413.7C386.5 416.8 381.5 416.8 378.3 413.7C375.2 410.5 375.2 405.5 378.3 402.3L516.7 264H8C3.594 264 0 260.4 0 256C0 251.6 3.594 248 8 248H516.7L378.3 109.7C375.2 106.5 375.2 101.5 378.3 98.34C379.9 96.78 381.9 96 384 96C386.1 96 388.1 96.78 389.7 98.34L541.7 250.3z"],
    "arrow-right-to-arc": [512, 512, [], "e4b2", "M496 256C496 123.5 388.5 16 256 16C251.6 16 248 12.42 248 8C248 3.582 251.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C251.6 512 248 508.4 248 504C248 499.6 251.6 496 256 496C388.5 496 496 388.5 496 256zM349.2 249.9C350.1 251.4 352 253.6 352 256C352 258.4 350.1 260.6 349.2 262.1L197.2 390.1C193.8 392.1 188.7 392.5 185.9 389.2C183 385.8 183.5 380.7 186.8 377.9L322.1 264H8C3.582 264 0 260.4 0 256C0 251.6 3.582 248 8 248H322.1L186.8 134.1C183.5 131.3 183 126.2 185.9 122.8C188.7 119.5 193.8 119 197.2 121.9L349.2 249.9z"],
    "arrow-right-to-bracket": [512, 512, ["sign-in"], "f090", "M472 32h-80C387.6 32 384 35.58 384 40s3.578 8 8 8h80c13.23 0 24 10.77 24 24v368c0 13.23-10.77 24-24 24h-80c-4.422 0-8 3.578-8 8S387.6 480 392 480h80c22.06 0 40-17.94 40-40V72C512 49.94 494.1 32 472 32zM381.7 250.3l-184-184C196.1 64.78 194.1 64 192 64S187.9 64.78 186.3 66.34c-3.125 3.125-3.125 8.188 0 11.31L356.7 248H8C3.594 248 0 251.6 0 256s3.594 8 8 8h348.7l-170.3 170.3c-3.125 3.125-3.125 8.188 0 11.31C187.9 447.2 189.9 448 192 448s4.094-.7813 5.656-2.344l184-184C383.2 260.1 384 258 384 256S383.2 251.9 381.7 250.3z"],
    "arrow-right-to-city": [640, 512, [], "e4b3", "M304 504C304 508.4 300.4 512 296 512C291.6 512 288 508.4 288 504V40C288 17.91 305.9 0 328 0H472C494.1 0 512 17.91 512 40V192H560V104C560 99.58 563.6 96 568 96C572.4 96 576 99.58 576 104V192H600C622.1 192 640 209.9 640 232V504C640 508.4 636.4 512 632 512C627.6 512 624 508.4 624 504V232C624 218.7 613.3 208 600 208H496V40C496 26.75 485.3 16 472 16H328C314.7 16 304 26.75 304 40V504zM360 96C360 82.75 370.7 72 384 72H416C429.3 72 440 82.75 440 96V128C440 141.3 429.3 152 416 152H384C370.7 152 360 141.3 360 128V96zM384 88C379.6 88 376 91.58 376 96V128C376 132.4 379.6 136 384 136H416C420.4 136 424 132.4 424 128V96C424 91.58 420.4 88 416 88H384zM544 264C557.3 264 568 274.7 568 288V320C568 333.3 557.3 344 544 344H512C498.7 344 488 333.3 488 320V288C488 274.7 498.7 264 512 264H544zM504 320C504 324.4 507.6 328 512 328H544C548.4 328 552 324.4 552 320V288C552 283.6 548.4 280 544 280H512C507.6 280 504 283.6 504 288V320zM488 416C488 402.7 498.7 392 512 392H544C557.3 392 568 402.7 568 416V448C568 461.3 557.3 472 544 472H512C498.7 472 488 461.3 488 448V416zM512 408C507.6 408 504 411.6 504 416V448C504 452.4 507.6 456 512 456H544C548.4 456 552 452.4 552 448V416C552 411.6 548.4 408 544 408H512zM416 200C429.3 200 440 210.7 440 224V256C440 269.3 429.3 280 416 280H384C370.7 280 360 269.3 360 256V224C360 210.7 370.7 200 384 200H416zM376 256C376 260.4 379.6 264 384 264H416C420.4 264 424 260.4 424 256V224C424 219.6 420.4 216 416 216H384C379.6 216 376 219.6 376 224V256zM360 352C360 338.7 370.7 328 384 328H416C429.3 328 440 338.7 440 352V384C440 397.3 429.3 408 416 408H384C370.7 408 360 397.3 360 384V352zM384 344C379.6 344 376 347.6 376 352V384C376 388.4 379.6 392 384 392H416C420.4 392 424 388.4 424 384V352C424 347.6 420.4 344 416 344H384zM253.7 250.3C256.8 253.5 256.8 258.5 253.7 261.7L157.7 357.7C154.5 360.8 149.5 360.8 146.3 357.7C143.2 354.5 143.2 349.5 146.3 346.3L228.7 264H8C3.582 264 0 260.4 0 256C0 251.6 3.582 248 8 248H228.7L146.3 165.7C143.2 162.5 143.2 157.5 146.3 154.3C149.5 151.2 154.5 151.2 157.7 154.3L253.7 250.3z"],
    "arrow-right-to-line": [448, 512, [8677, "arrow-to-right"], "f340", "M349.7 261.7c3.125-3.125 3.125-8.188 0-11.31l-152-152C196.1 96.78 194.1 96 192 96S187.9 96.78 186.3 98.34c-3.125 3.125-3.125 8.188 0 11.31L324.7 248H8C3.594 248 0 251.6 0 256s3.594 8 8 8h316.7l-138.3 138.3c-3.125 3.125-3.125 8.188 0 11.31s8.188 3.125 11.31 0L349.7 261.7zM448 440V72C448 67.58 444.4 64 440 64S432 67.58 432 72v368c0 4.418 3.582 8 8 8S448 444.4 448 440z"],
    "arrow-rotate-left": [512, 512, [8634, "arrow-left-rotate", "arrow-rotate-back", "arrow-rotate-backward", "undo"], "f0e2", "M256 24c-95.43 0-181 60.14-215.4 147.9L20.53 71.69C19.66 67.34 15.28 64.63 11.13 65.41C6.781 66.28 3.969 70.5 4.844 74.81l25.11 125.5c.7656 3.812 4.094 6.438 7.828 6.438c.5313 0 1.062-.0625 1.578-.1562L164.9 181.5c4.344-.875 7.141-5.094 6.281-9.406C170.3 167.8 165.8 165 161.8 165.8l-110.3 22.05C80.57 100.6 163.4 40 256 40c119.1 0 216 96.91 216 216s-96.89 216-216 216c-44.44 0-87.13-13.38-123.4-38.72c-3.562-2.5-8.594-1.688-11.14 2c-2.531 3.625-1.641 8.594 1.984 11.12C162.4 473.6 208.3 488 256 488c127.9 0 232-104.1 232-232S383.9 24 256 24z"],
    "arrow-rotate-right": [512, 512, [8635, "arrow-right-rotate", "arrow-rotate-forward", "redo"], "f01e", "M24 256c0 127.9 104.1 232 232 232c47.72 0 93.58-14.38 132.6-41.59c3.625-2.531 4.516-7.5 1.984-11.12c-2.547-3.688-7.578-4.5-11.14-2C343.1 458.6 300.4 472 256 472c-119.1 0-216-96.91-216-216S136.9 40 256 40c92.55 0 175.4 60.59 204.5 147.9l-110.3-22.05c-4.094-.8125-8.531 1.938-9.406 6.281c-.8594 4.312 1.938 8.531 6.281 9.406l125.5 25.09c.5156 .0938 1.047 .1562 1.578 .1562c3.734 0 7.062-2.625 7.828-6.438l25.11-125.5c.875-4.312-1.938-8.531-6.281-9.406c-4.156-.7813-8.531 1.938-9.406 6.281l-20.05 100.2C437 84.14 351.4 24 256 24C128.1 24 24 128.1 24 256z"],
    "arrow-trend-down": [576, 512, [], "e097", "M376 400H548.7L320 171.3L197.7 293.7C194.5 296.8 189.5 296.8 186.3 293.7L2.343 109.7C-.781 106.5-.781 101.5 2.343 98.34C5.467 95.22 10.53 95.22 13.66 98.34L191.1 276.7L314.3 154.3C317.5 151.2 322.5 151.2 325.7 154.3L560 388.7V215.1C560 211.6 563.6 207.1 568 207.1C572.4 207.1 576 211.6 576 215.1V408C576 412.4 572.4 416 568 416H376C371.6 416 368 412.4 368 408C368 403.6 371.6 400 376 400L376 400z"],
    "arrow-trend-up": [576, 512, [], "e098", "M368 104C368 99.58 371.6 96 376 96H568C572.4 96 576 99.58 576 104V296C576 300.4 572.4 304 568 304C563.6 304 560 300.4 560 296V123.3L325.7 357.7C322.5 360.8 317.5 360.8 314.3 357.7L191.1 235.3L13.66 413.7C10.53 416.8 5.467 416.8 2.343 413.7C-.781 410.5-.781 405.5 2.343 402.3L186.3 218.3C189.5 215.2 194.5 215.2 197.7 218.3L320 340.7L548.7 111.1H376C371.6 111.1 368 108.4 368 103.1L368 104z"],
    "arrow-turn-down": [384, 512, ["level-down"], "f149", "M349.5 365.8l-151.1 143.1c-3.062 2.937-7.937 2.937-10.1 0l-151.1-143.1c-3.219-3.031-3.344-8.094-.3125-11.31c3.062-3.187 8.125-3.344 11.31-.3125l138.5 131.2V71.1c0-30.87-25.12-55.1-55.1-55.1H8.001c-4.406 0-7.1-3.594-7.1-7.1S3.595 0 8.001 0l119.1 0c39.69 0 71.1 32.31 71.1 71.1v413.4l138.5-131.2c1.531-1.469 3.531-2.187 5.5-2.187c2.125 0 4.25 .8437 5.812 2.5C352.8 357.7 352.7 362.8 349.5 365.8z"],
    "arrow-turn-down-left": [512, 512, [], "e2e1", "M146.2 445.5L2.203 293.5c-2.937-3.062-2.937-7.937 0-10.1l143.1-151.1C149.2 127.3 154.3 127.2 157.5 130.2C160.7 133.2 160.9 138.3 157.8 141.5L26.62 279.1h413.4c30.87 0 55.1-25.12 55.1-55.1V39.1C496 35.59 499.6 32 504 32S512 35.59 512 39.1v183.1c0 39.69-32.31 71.1-71.1 71.1H26.62l131.2 138.5c1.469 1.531 2.187 3.531 2.187 5.5c0 2.125-.8437 4.25-2.5 5.812C154.3 448.8 149.2 448.7 146.2 445.5z"],
    "arrow-turn-down-right": [512, 512, [], "e3d6", "M354.5 445.8C352.8 444.2 351.1 442.1 351.1 439.1C351.1 438 352.7 436 354.2 434.5L485.4 295.1H71.1C32.31 295.1 0 263.7 0 223.1V40C0 35.59 3.594 32 7.1 32C12.41 32 15.1 35.59 15.1 40V223.1C15.1 254.9 41.12 279.1 71.1 279.1H485.4L354.2 141.5C351.1 138.3 351.3 133.2 354.5 130.2C357.7 127.2 362.8 127.3 365.8 130.5L509.8 282.5C512.7 285.6 512.7 290.4 509.8 293.5L365.8 445.5C362.8 448.7 357.7 448.8 354.5 445.8L354.5 445.8z"],
    "arrow-turn-up": [384, 512, ["level-up"], "f148", "M349.8 157.5c-1.562 1.656-3.687 2.5-5.812 2.5c-1.969 0-3.969-.7187-5.5-2.187l-138.5-131.2v413.4C199.1 479.7 167.7 512 127.1 512H7.1C3.594 512 0 508.4 0 504s3.594-7.1 7.1-7.1h119.1c30.87 0 55.1-25.12 55.1-55.1V26.62L45.5 157.8C42.31 160.9 37.25 160.7 34.19 157.5C31.16 154.3 31.28 149.2 34.5 146.2l151.1-143.1c3.062-2.937 7.937-2.937 10.1 0l151.1 143.1C352.7 149.2 352.8 154.3 349.8 157.5z"],
    "arrow-up": [384, 512, [8593], "f062", "M15.82 204.9l170.5-170.5c3.14-3.14 8.226-3.14 11.37 0l170.5 170.5c3.14 3.14 3.14 8.226 0 11.37c-3.14 3.14-8.226 3.14-11.37 0L200 59.44v412.5c0 4.427-3.595 8.038-8.037 8.038S183.1 476.4 183.1 471.1V59.44L27.19 216.2c-3.14 3.14-8.226 3.14-11.37 0C12.68 213.1 12.68 207.1 15.82 204.9z"],
    "arrow-up-1-9": [512, 512, ["sort-numeric-up"], "f163", "M352 208c-4.422 0-8 3.594-8 8s3.579 7.998 8 7.998L416 224c4.422 0 8-3.594 8-8S420.4 208 416 208h-24V40c0-2.781-1.438-5.344-3.797-6.812c-2.359-1.438-5.312-1.594-7.781-.3438l-32 16c-3.953 1.969-5.547 6.781-3.578 10.72c1.984 3.969 6.75 5.531 10.73 3.594L376 52.94V208H352zM133.9 34.48c-3.062-3.312-8.75-3.312-11.81 0L34.09 130.5c-2.969 3.252-2.75 8.314 .5 11.32c3.25 3 8.312 2.781 11.31-.5L120 60.47V471.1c0 4.408 3.595 8.001 8.001 8.001S136 476.4 136 471.1V60.47l74.1 80.85c1.596 1.719 3.752 2.594 5.908 2.594c1.938 0 3.875-.6875 5.406-2.094c3.25-3.002 3.469-8.064 .5-11.32L133.9 34.48zM376 264c-39.7 0-72 32.31-72 72s32.3 72 72 72c22.73 0 42.79-10.8 56-27.31V408c0 30.88-25.12 56-56 56H352c-4.422 0-8 3.594-8 8S347.6 480 352 480h24c39.7 0 72-32.31 72-72V336C448 296.3 415.7 264 376 264zM376 392c-30.88 0-56-25.12-56-56s25.12-56 56-56s56 25.12 56 56S406.9 392 376 392z"],
    "arrow-up-9-1": [512, 512, ["sort-numeric-up-alt"], "f887", "M416 464h-24V296c0-2.781-1.438-5.344-3.797-6.812c-2.359-1.438-5.312-1.594-7.781-.3438l-32 16c-3.953 1.969-5.547 6.781-3.578 10.72c1.984 3.969 6.75 5.531 10.73 3.594L376 308.9V464H352c-4.422 0-8 3.594-8 8S347.6 480 352 480H416c4.422 0 8-3.594 8-8S420.4 464 416 464zM133.9 34.48c-3.062-3.312-8.75-3.312-11.81 0L34.09 130.5c-2.969 3.252-2.75 8.314 .5 11.32c3.25 3 8.312 2.781 11.31-.5L120 60.47V471.1c0 4.408 3.595 8.001 8.001 8.001S136 476.4 136 471.1V60.47l74.1 80.85c1.596 1.719 3.752 2.594 5.908 2.594c1.938 0 3.875-.6875 5.406-2.094c3.25-3.002 3.469-8.064 .5-11.32L133.9 34.48zM376 32c-39.7 0-72 32.31-72 72s32.3 72 72 72c22.73 0 42.79-10.8 56-27.31V176c0 30.88-25.12 56-56 56H352c-4.422 0-8 3.594-8 8S347.6 248 352 248h24C415.7 248 448 215.7 448 176V104C448 64.31 415.7 32 376 32zM376 160C345.1 160 320 134.9 320 104s25.12-56 56-56s56 25.12 56 56S406.9 160 376 160z"],
    "arrow-up-a-z": [512, 512, ["sort-alpha-up"], "f15e", "M45.9 141.3l74.1-80.85V471.1C120 476.4 123.6 480 128 480s8.001-3.594 8.001-8.002V60.47l74.1 80.85c1.594 1.719 3.75 2.594 5.906 2.594c1.938 0 3.875-.6875 5.406-2.094c3.25-3.002 3.469-8.064 .5-11.32L133.9 34.48c-3.062-3.312-8.75-3.312-11.81 0L34.09 130.5C31.12 133.8 31.34 138.8 34.59 141.8C37.84 144.8 42.9 144.6 45.9 141.3zM456 464h-127.1l133.3-162.9c1.969-2.375 2.375-5.688 1.031-8.5C461.9 289.8 459.1 288 456 288h-144c-4.406 0-8 3.594-8 8s3.594 8 8 8h127.1l-133.3 162.9c-1.969 2.375-2.375 5.688-1.031 8.5C306.1 478.2 308.9 480 312 480h144c4.406 0 8-3.594 8-8S460.4 464 456 464zM479.2 212.4l-88-176c-2.688-5.438-11.62-5.438-14.31 0l-88 176c-1.969 3.938-.375 8.75 3.594 10.72c3.812 1.906 8.75 .4062 10.72-3.594L328.9 168h110.1l25.78 51.56C466.3 222.4 469.1 224 472 224c1.219 0 2.438-.2813 3.562-.8438C479.5 221.2 481.1 216.4 479.2 212.4zM336.9 152l47.06-94.13L431.1 152H336.9z"],
    "arrow-up-arrow-down": [448, 512, ["sort-up-down"], "e099", "M226.6 370.2c-3.25 3.002-3.469 8.064-.5 11.32l88 96.02c3.062 3.312 8.75 3.312 11.81 0l88-96.02c2.969-3.252 2.75-8.314-.5-11.32c-1.531-1.406-3.469-2.094-5.406-2.094c-2.156 0-4.312 .875-5.906 2.594L328 451.5V40C328 35.59 324.4 32 320 32s-8 3.594-8 8.002v411.5l-74.1-80.85C234.9 367.4 229.8 367.2 226.6 370.2zM34.59 141.8c1.531 1.406 3.469 2.094 5.406 2.094c2.156 0 4.312-.875 5.906-2.594L120 60.47V471.1C120 476.4 123.6 480 128 480s8-3.594 8-8.002V60.47l74.1 80.85c3 3.281 8.062 3.5 11.31 .5c3.25-3.002 3.469-8.064 .5-11.32L133.9 34.48c-3.062-3.312-8.75-3.312-11.81 0L34.09 130.5C31.12 133.8 31.34 138.8 34.59 141.8z"],
    "arrow-up-big-small": [512, 512, ["sort-size-up"], "f88e", "M416 320h-127.1c-17.6 0-32 14.4-32 32v96c0 17.6 14.4 32 32 32H416c17.6 0 32-14.4 32-32v-96C448 334.4 433.6 320 416 320zM432 448c0 8.822-7.178 16-16 16h-127.1c-8.822 0-16-7.178-16-16v-96c0-8.822 7.178-16 16-16H416c8.822 0 16 7.178 16 16V448zM480 32h-191.1c-17.67 0-32 14.33-32 32v160c0 17.67 14.33 32 32 32H480c17.67 0 32-14.33 32-32V64C512 46.33 497.7 32 480 32zM496 224c0 8.822-7.178 16-16 16h-191.1c-8.822 0-16-7.178-16-16V64c0-8.822 7.178-16 16-16H480c8.822 0 16 7.178 16 16V224zM101.9 34.48c-3.062-3.312-8.75-3.312-11.81 0L2.09 130.5c-2.969 3.252-2.75 8.314 .5 11.32c3.25 3 8.312 2.781 11.31-.5L88 60.47V471.1C88 476.4 91.59 480 96 480s8-3.594 8-8.002V60.47l74.1 80.85c1.594 1.719 3.75 2.594 5.906 2.594c1.938 0 3.875-.6875 5.406-2.094c3.25-3.002 3.469-8.064 .5-11.32L101.9 34.48z"],
    "arrow-up-from-arc": [512, 512, [], "e4b4", "M496 256C496 251.6 499.6 248 504 248C508.4 248 512 251.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 251.6 3.582 248 8 248C12.42 248 16 251.6 16 256C16 388.5 123.5 496 256 496C388.5 496 496 388.5 496 256zM249.9 2.847C251.4 1.042 253.6 0 256 0C258.4 0 260.6 1.042 262.1 2.847L390.1 154.8C392.1 158.2 392.5 163.3 389.2 166.1C385.8 168.1 380.7 168.5 377.9 165.2L264 29.92V344C264 348.4 260.4 352 256 352C251.6 352 248 348.4 248 344V29.92L134.1 165.2C131.3 168.5 126.2 168.1 122.8 166.1C119.5 163.3 119 158.2 121.9 154.8L249.9 2.847z"],
    "arrow-up-from-bracket": [448, 512, [], "e09a", "M432 392v80c0 13.23-10.77 24-24 24H40c-13.23 0-24-10.77-24-24v-80C16 387.6 12.42 384 8 384S0 387.6 0 392v80C0 494.1 17.94 512 40 512h368c22.06 0 40-17.94 40-40v-80c0-4.422-3.578-8-8-8S432 387.6 432 392zM218.3 2.344l-184 184C32.78 187.9 32 189.9 32 192s.7813 4.094 2.344 5.656c3.125 3.125 8.188 3.125 11.31 0L216 27.31V376C216 380.4 219.6 384 224 384s8-3.594 8-8V27.31l170.3 170.3c3.125 3.125 8.188 3.125 11.31 0C415.2 196.1 416 194.1 416 192s-.7813-4.094-2.344-5.656l-184-184C228.1 .7813 226 0 224 0S219.9 .7813 218.3 2.344z"],
    "arrow-up-from-dotted-line": [448, 512, [], "e09b", "M128 432c-8.836 0-16 7.164-16 16s7.164 16 16 16s16-7.164 16-16S136.8 432 128 432zM224 432c-8.836 0-16 7.164-16 16s7.164 16 16 16s16-7.164 16-16S232.8 432 224 432zM32 432c-8.836 0-16 7.164-16 16s7.164 16 16 16s16-7.164 16-16S40.84 432 32 432zM320 432c-8.836 0-16 7.164-16 16s7.164 16 16 16s16-7.164 16-16S328.8 432 320 432zM416 432c-8.836 0-16 7.164-16 16s7.164 16 16 16s16-7.164 16-16S424.8 432 416 432zM229.7 34.34c-3.125-3.125-8.188-3.125-11.31 0l-152 152C64.78 187.9 64 189.9 64 192s.7813 4.094 2.344 5.656c3.125 3.125 8.188 3.125 11.31 0L216 59.31V344C216 348.4 219.6 352 224 352s8-3.594 8-8V59.31l138.3 138.3c3.125 3.125 8.188 3.125 11.31 0s3.125-8.188 0-11.31L229.7 34.34z"],
    "arrow-up-from-ground-water": [576, 512, [], "e4b5", "M280 344V27.31L197.7 109.7C194.5 112.8 189.5 112.8 186.3 109.7C183.2 106.5 183.2 101.5 186.3 98.34L282.3 2.343C285.5-.781 290.5-.781 293.7 2.343L389.7 98.34C392.8 101.5 392.8 106.5 389.7 109.7C386.5 112.8 381.5 112.8 378.3 109.7L296 27.31V344C296 348.4 292.4 352 288 352C283.6 352 280 348.4 280 344H280zM64 191.1H192V207.1H64C37.49 207.1 16 229.5 16 255.1V418.5C10.26 419.1 4.905 422.2 .0003 425V255.1C.0003 220.7 28.65 191.1 64 191.1zM560 418.5V255.1C560 229.5 538.5 207.1 512 207.1H384V191.1H512C547.3 191.1 576 220.7 576 255.1V424.1C571.1 422.2 565.7 419.1 560 418.5zM294.6 435.4C302.6 446.6 312.1 456.9 322.2 466.1C339.5 481.8 361.5 496 384 496C406.5 496 428.6 481.8 445.8 466.1C455.1 456.9 465.5 446.6 473.5 435.4C474.1 433.3 477.4 432 480 432C482.6 432 485.1 433.3 486.6 435.4C493.9 445.7 502.5 455 511.6 463.7C527.3 478.5 547.7 492.9 569 495.6C573.4 496.1 576.5 500.1 575.9 504.5C575.4 508.9 571.4 511.1 567 511.4C540.5 508.1 516.1 490.7 500.6 475.3C491.8 466.1 484.7 458.9 480 453.1C474.8 459.5 466.8 468.7 456.6 477.9C438.7 494.2 412.7 512 384 512C355.3 512 329.4 494.2 311.4 477.9C301.3 468.7 293.2 459.5 288 453.1L288 453.1L287.1 453.1C282.8 459.5 274.7 468.7 264.6 477.9C246.6 494.2 220.7 512 191.1 512C163.3 512 137.4 494.2 119.4 477.9C109.2 468.7 101.2 459.5 95.98 453.1C91.29 458.9 84.23 466.1 75.4 475.3C59.03 490.7 35.48 508.1 9.001 511.4C4.617 511.1 .616 508.9 .0637 504.5C-.4887 500.1 2.617 496.1 7.001 495.6C28.3 492.9 48.74 478.5 64.42 463.7C73.56 455 82.16 445.7 89.43 435.4C90.93 433.3 93.37 432 95.98 432C98.59 432 101 433.3 102.5 435.4C110.5 446.6 120 456.9 130.2 466.1C147.4 481.8 169.5 496 191.1 496C214.5 496 236.6 481.8 253.8 466.1C263.9 456.9 273.4 446.6 281.4 435.4C284.4 431.1 291.6 431.1 294.6 435.4H294.6z"],
    "arrow-up-from-line": [384, 512, [8613, "arrow-from-bottom"], "f342", "M197.7 34.34c-3.125-3.125-8.188-3.125-11.31 0l-152 152C32.78 187.9 32 189.9 32 192s.7813 4.094 2.344 5.656c3.125 3.125 8.188 3.125 11.31 0L184 59.31V376c0 4.406 3.578 7.968 8 7.968s8-3.562 8-7.968V59.31l138.3 138.3c3.125 3.125 8.188 3.125 11.31 0s3.125-8.188 0-11.31L197.7 34.34zM376 464H8C3.582 464 0 467.6 0 472S3.582 480 8 480h368c4.418 0 8-3.582 8-8S380.4 464 376 464z"],
    "arrow-up-from-square": [512, 512, [], "e09c", "M440 160h-48C387.6 160 384 163.6 384 168s3.594 8 8 8h48c13.22 0 24 10.78 24 24v272c0 13.22-10.78 24-24 24H72c-13.22 0-24-10.78-24-24v-272c0-13.22 10.78-24 24-24h48C124.4 176 128 172.4 128 168S124.4 160 120 160h-48C49.94 160 32 177.9 32 200v272C32 494.1 49.94 512 72 512h368c22.06 0 40-17.94 40-40v-272C480 177.9 462.1 160 440 160zM160 112c2.047 0 4.094-.7813 5.656-2.344L248 27.31V376C248 380.4 251.6 384 256 384s8-3.594 8-8V27.31l82.34 82.34C347.9 111.2 349.9 112 352 112c5.719 0 8-5.094 8-8c0-2.047-.7813-4.094-2.344-5.656l-96-96C260.1 .7813 258-.0002 256-.0002S251.9 .7813 250.3 2.344l-96 96C152.8 99.91 152 101.1 152 104C152 108.6 155.7 112 160 112z"],
    "arrow-up-from-water-pump": [576, 512, [], "e4b6", "M288 48V256H440V27.31L357.7 109.7C354.5 112.8 349.5 112.8 346.3 109.7C343.2 106.5 343.2 101.5 346.3 98.34L442.3 2.344C445.5-.7805 450.5-.7805 453.7 2.344L549.7 98.34C552.8 101.5 552.8 106.5 549.7 109.7C546.5 112.8 541.5 112.8 538.3 109.7L456 27.31V256H512C547.3 256 576 284.7 576 320V425C571.1 422.2 565.7 419.1 560 418.5V320C560 293.5 538.5 272 512 272H64C37.49 272 16 293.5 16 320V418.5C10.26 419.1 4.905 422.2 .0006 425V320C.0006 284.7 28.65 256 64 256V48C64 21.49 85.49 0 112 0H240C266.5 0 288 21.49 288 48H288zM80 48V256H272V48C272 30.33 257.7 16 240 16H112C94.33 16 80 30.33 80 48zM294.6 435.4C302.6 446.6 312.1 456.9 322.2 466.1C339.5 481.8 361.5 496 384 496C406.5 496 428.6 481.8 445.8 466.1C455.1 456.9 465.5 446.6 473.5 435.4C474.1 433.3 477.4 432 480 432C482.6 432 485.1 433.3 486.6 435.4C493.9 445.7 502.5 455 511.6 463.7C527.3 478.5 547.7 492.9 569 495.6C573.4 496.1 576.5 500.1 575.9 504.5C575.4 508.9 571.4 511.1 567 511.4C540.5 508.1 516.1 490.7 500.6 475.3C491.8 466.1 484.7 458.9 480 453.1C474.8 459.5 466.8 468.7 456.6 477.9C438.7 494.2 412.7 512 384 512C355.3 512 329.4 494.2 311.4 477.9C301.3 468.7 293.2 459.5 288 453.1L288 453.1L287.1 453.1C282.8 459.5 274.7 468.7 264.6 477.9C246.6 494.2 220.7 512 191.1 512C163.3 512 137.4 494.2 119.4 477.9C109.2 468.7 101.2 459.5 95.98 453.1C91.29 458.9 84.23 466.1 75.4 475.3C59.03 490.7 35.48 508.1 9.001 511.4C4.617 511.1 .616 508.9 .0637 504.5C-.4887 500.1 2.617 496.1 7.001 495.6C28.3 492.9 48.74 478.5 64.42 463.7C73.56 455 82.16 445.7 89.43 435.4C90.93 433.3 93.37 432 95.98 432C98.59 432 101 433.3 102.5 435.4C110.5 446.6 120 456.9 130.2 466.1C147.4 481.8 169.5 496 191.1 496C214.5 496 236.6 481.8 253.8 466.1C263.9 456.9 273.4 446.6 281.4 435.4C284.4 431.1 291.6 431.1 294.6 435.4H294.6z"],
    "arrow-up-left": [320, 512, [], "e09d", "M0 344V103.1C0 99.58 3.58 96 7.999 96h240C252.4 96 256 99.58 256 103.1s-3.58 7.999-7.999 7.999H27.31l290.3 290.3c3.116 3.116 3.127 8.187 0 11.31s-8.198 3.116-11.31 0L15.1 123.3v220.7C15.1 348.4 12.42 352 7.999 352C3.577 352 0 348.4 0 344z"],
    "arrow-up-left-from-circle": [512, 512, [], "e09e", "M349.7 349.7c3.129-3.125 3.117-8.195 0-11.31L27.31 16H216C220.4 16 224 12.42 224 8c0-2.211-.8828-4.199-2.344-5.656C220.2 .8828 218.2 0 216 0h-208C3.578 0 0 3.578 0 8v208C0 220.4 3.578 224 8 224C12.42 224 16 220.4 16 216V27.31l322.3 322.3C341.5 352.8 346.5 352.8 349.7 349.7zM288 64c-22.59 0-44.94 3.344-66.38 9.969C217.4 75.28 215.1 79.78 216.3 84c1.312 4.219 5.688 6.469 10.03 5.281C246.3 83.13 267 80 288 80c114.7 0 208 93.31 208 208s-93.31 208-208 208S80 402.7 80 288c0-21 3.125-41.75 9.281-61.63C90.56 222.2 88.22 217.7 84 216.3C79.63 215.2 75.28 217.4 73.97 221.6C67.34 243.1 64 265.4 64 288c0 123.5 100.5 224 224 224s224-100.5 224-224S411.5 64 288 64z"],
    "arrow-up-long": [320, 512, ["long-arrow-up"], "f176", "M165.7 2.344c-3.125-3.125-8.188-3.125-11.31 0l-152 152C.7813 155.9 0 157.9 0 159.1S.7813 164.1 2.344 165.7c3.125 3.125 8.188 3.125 11.31 0L152 27.31v476.7C152 508.4 155.6 512 160 512s8-3.594 8-8V27.31l138.3 138.3c3.125 3.125 8.188 3.125 11.31 0s3.125-8.188 0-11.31L165.7 2.344z"],
    "arrow-up-right": [320, 512, [], "e09f", "M312 352c-4.419 0-7.999-3.58-7.999-7.999V123.3l-290.3 290.3c-3.116 3.116-8.187 3.127-11.31 0s-3.116-8.198 0-11.31l290.3-290.3H71.1C67.58 111.1 64 108.4 64 103.1S67.58 96 71.1 96h240C316.4 96 320 99.58 320 103.1v240C320 348.4 316.4 352 312 352z"],
    "arrow-up-right-and-arrow-down-left-from-center": [512, 512, [], "e0a0", "M210.3 290.4l-194.3 194.3v-140.6c0-4.418-3.579-7.996-7.995-7.996C3.579 336.1 0 339.6 0 344v159.1C0 508.4 3.575 512 7.996 512H167.1c4.438 0 7.96-3.59 7.96-7.994c0-4.418-3.579-7.996-7.996-7.996H27.3l194.3-194.3C229 294.3 217.7 282.1 210.3 290.4zM504 0H344c-4.438 0-7.96 3.588-7.96 7.994c0 4.418 3.578 7.996 7.996 7.996h140.6l-194.3 194.3c-7.465 7.461 3.815 18.8 11.31 11.31l194.3-194.3v140.6c0 4.418 3.578 7.996 7.995 7.996C508.4 175.9 512 172.4 512 167.1V7.994C512 3.578 508.4 0 504 0z"],
    "arrow-up-right-dots": [576, 512, [], "e4b7", "M151.1 0H312C316.4 0 320 3.582 320 8V168C320 172.4 316.4 176 312 176C307.6 176 304 172.4 304 168V27.31L29.66 301.7C26.53 304.8 21.47 304.8 18.34 301.7C15.22 298.5 15.22 293.5 18.34 290.3L292.7 16H151.1C147.6 16 143.1 12.42 143.1 8C143.1 3.582 147.6 0 151.1 0zM480 80C480 53.49 501.5 32 528 32C554.5 32 576 53.49 576 80C576 106.5 554.5 128 528 128C501.5 128 480 106.5 480 80zM528 112C545.7 112 560 97.67 560 80C560 62.33 545.7 48 528 48C510.3 48 496 62.33 496 80C496 97.67 510.3 112 528 112zM352 208C352 181.5 373.5 160 400 160C426.5 160 448 181.5 448 208C448 234.5 426.5 256 400 256C373.5 256 352 234.5 352 208zM400 240C417.7 240 432 225.7 432 208C432 190.3 417.7 176 400 176C382.3 176 368 190.3 368 208C368 225.7 382.3 240 400 240zM448 336C448 362.5 426.5 384 400 384C373.5 384 352 362.5 352 336C352 309.5 373.5 288 400 288C426.5 288 448 309.5 448 336zM400 304C382.3 304 368 318.3 368 336C368 353.7 382.3 368 400 368C417.7 368 432 353.7 432 336C432 318.3 417.7 304 400 304zM352 464C352 437.5 373.5 416 400 416C426.5 416 448 437.5 448 464C448 490.5 426.5 512 400 512C373.5 512 352 490.5 352 464zM400 496C417.7 496 432 481.7 432 464C432 446.3 417.7 432 400 432C382.3 432 368 446.3 368 464C368 481.7 382.3 496 400 496zM480 464C480 437.5 501.5 416 528 416C554.5 416 576 437.5 576 464C576 490.5 554.5 512 528 512C501.5 512 480 490.5 480 464zM528 496C545.7 496 560 481.7 560 464C560 446.3 545.7 432 528 432C510.3 432 496 446.3 496 464C496 481.7 510.3 496 528 496zM320 336C320 362.5 298.5 384 271.1 384C245.5 384 223.1 362.5 223.1 336C223.1 309.5 245.5 288 271.1 288C298.5 288 320 309.5 320 336zM271.1 304C254.3 304 239.1 318.3 239.1 336C239.1 353.7 254.3 368 271.1 368C289.7 368 304 353.7 304 336C304 318.3 289.7 304 271.1 304zM223.1 464C223.1 437.5 245.5 416 271.1 416C298.5 416 320 437.5 320 464C320 490.5 298.5 512 271.1 512C245.5 512 223.1 490.5 223.1 464zM271.1 496C289.7 496 304 481.7 304 464C304 446.3 289.7 432 271.1 432C254.3 432 239.1 446.3 239.1 464C239.1 481.7 254.3 496 271.1 496zM191.1 464C191.1 490.5 170.5 512 143.1 512C117.5 512 95.1 490.5 95.1 464C95.1 437.5 117.5 416 143.1 416C170.5 416 191.1 437.5 191.1 464zM143.1 432C126.3 432 111.1 446.3 111.1 464C111.1 481.7 126.3 496 143.1 496C161.7 496 175.1 481.7 175.1 464C175.1 446.3 161.7 432 143.1 432zM480 336C480 309.5 501.5 288 528 288C554.5 288 576 309.5 576 336C576 362.5 554.5 384 528 384C501.5 384 480 362.5 480 336zM528 368C545.7 368 560 353.7 560 336C560 318.3 545.7 304 528 304C510.3 304 496 318.3 496 336C496 353.7 510.3 368 528 368zM576 208C576 234.5 554.5 256 528 256C501.5 256 480 234.5 480 208C480 181.5 501.5 160 528 160C554.5 160 576 181.5 576 208zM528 176C510.3 176 496 190.3 496 208C496 225.7 510.3 240 528 240C545.7 240 560 225.7 560 208C560 190.3 545.7 176 528 176z"],
    "arrow-up-right-from-square": [448, 512, ["external-link"], "f08e", "M272 40C272 35.58 275.6 32 280 32H440C444.4 32 448 35.58 448 40V208C448 212.4 444.4 216 440 216C435.6 216 432 212.4 432 208V59.31L173.7 317.7C170.5 320.8 165.5 320.8 162.3 317.7C159.2 314.5 159.2 309.5 162.3 306.3L420.7 48H280C275.6 48 272 44.42 272 40V40zM0 136C0 113.9 17.91 96 40 96H160C164.4 96 168 99.58 168 104C168 108.4 164.4 112 160 112H40C26.75 112 16 122.7 16 136V440C16 453.3 26.75 464 40 464H344C357.3 464 368 453.3 368 440V320C368 315.6 371.6 312 376 312C380.4 312 384 315.6 384 320V440C384 462.1 366.1 480 344 480H40C17.91 480 0 462.1 0 440V136z"],
    "arrow-up-short-wide": [576, 512, ["sort-amount-up-alt"], "f885", "M45.9 141.3L120 60.47V471.1C120 476.4 123.6 480 128 480S136 476.4 136 471.1V60.47l74.1 80.85c1.594 1.719 3.75 2.594 5.906 2.594c1.938 0 3.875-.6875 5.406-2.094c3.25-3.002 3.469-8.064 .5-11.32L133.9 34.48c-3.062-3.312-8.75-3.312-11.81 0L34.09 130.5c-2.969 3.252-2.75 8.314 .5 11.32C37.84 144.8 42.9 144.6 45.9 141.3zM264 192h144C412.4 192 416 188.4 416 184S412.4 176 408 176h-144C259.6 176 256 179.6 256 184S259.6 192 264 192zM264 64h80C348.4 64 352 60.41 352 56S348.4 48 344 48h-80C259.6 48 256 51.59 256 56S259.6 64 264 64zM264 320h208C476.4 320 480 316.4 480 312S476.4 304 472 304h-208C259.6 304 256 307.6 256 312S259.6 320 264 320zM536 432h-272C259.6 432 256 435.6 256 440S259.6 448 264 448h272c4.406 0 8-3.594 8-8S540.4 432 536 432z"],
    "arrow-up-small-big": [512, 512, ["sort-size-up-alt"], "f88f", "M288 192H416c17.6 0 32-14.4 32-32V64c0-17.6-14.4-32-32-32h-127.1c-17.6 0-32 14.4-32 32v96C256 177.6 270.4 192 288 192zM272 64c0-8.822 7.178-16 16-16H416c8.822 0 16 7.178 16 16v96c0 8.822-7.178 16-16 16h-127.1c-8.822 0-16-7.178-16-16V64zM480 256h-191.1c-17.67 0-32 14.33-32 32v160c0 17.67 14.33 32 32 32H480c17.67 0 32-14.33 32-32V288C512 270.3 497.7 256 480 256zM496 448c0 8.822-7.178 16-16 16h-191.1c-8.822 0-16-7.178-16-16V288c0-8.822 7.178-16 16-16H480c8.822 0 16 7.178 16 16V448zM101.9 34.48c-3.062-3.312-8.75-3.312-11.81 0L2.09 130.5c-2.969 3.252-2.75 8.314 .5 11.32c3.25 3 8.312 2.781 11.31-.5L88 60.47V471.1C88 476.4 91.59 480 96 480s8-3.594 8-8.002V60.47l74.1 80.85c1.594 1.719 3.75 2.594 5.906 2.594c1.938 0 3.875-.6875 5.406-2.094c3.25-3.002 3.469-8.064 .5-11.32L101.9 34.48z"],
    "arrow-up-square-triangle": [512, 512, ["sort-shapes-up-alt"], "f88b", "M476.1 438.9l-83.13-137.1c-5.564-9.188-15.25-13.78-24.94-13.78s-19.38 4.594-24.94 13.78l-83.25 137.1C248.9 457.1 262.6 480 284.9 480h166.3C473.4 480 487.1 457.1 476.1 438.9zM462.6 457.7C460.4 461.6 456.1 464 451.1 464h-166.3c-4.945 0-9.229-2.359-11.46-6.311c-1.119-1.982-2.588-5.99 .1367-10.51l83.26-137.1c3.316-5.477 8.973-6.068 11.25-6.068c2.279 0 7.936 .5918 11.26 6.076l83.11 137.1C465.2 451.7 463.7 455.7 462.6 457.7zM304 224l128-.0059c17.67 0 32-14.32 32-31.99V64c0-17.67-14.33-32-32-32h-128c-17.67 0-32 14.33-32 32v128C272 209.7 286.3 224 304 224zM288 64c0-8.822 7.178-16 16-16h128c8.822 0 16 7.178 16 16v128c0 8.822-7.178 16-16 16h-128c-8.822 0-16-7.178-16-16V64zM133.9 34.48c-3.062-3.312-8.75-3.312-11.81 0L34.09 130.5c-2.969 3.252-2.75 8.314 .5 11.32c3.25 3 8.314 2.781 11.31-.5L120 60.47V471.1C120 476.4 123.6 480 128 480s8-3.594 8-8.002V60.47l74.1 80.85c1.594 1.719 3.75 2.594 5.906 2.594c1.938 0 3.875-.6875 5.406-2.094c3.25-3.002 3.469-8.064 .5-11.32L133.9 34.48z"],
    "arrow-up-to-dotted-line": [448, 512, [], "e0a1", "M320 79.1c8.836 0 16-7.164 16-16s-7.164-16-16-16s-16 7.164-16 16S311.2 79.1 320 79.1zM224 79.1c8.836 0 16-7.164 16-16s-7.164-16-16-16s-16 7.164-16 16S215.2 79.1 224 79.1zM416 79.1c8.836 0 16-7.164 16-16s-7.164-16-16-16s-16 7.164-16 16S407.2 79.1 416 79.1zM128 79.1c8.836 0 16-7.164 16-16s-7.164-16-16-16s-16 7.164-16 16S119.2 79.1 128 79.1zM32 79.1c8.836 0 16-7.164 16-16s-7.164-16-16-16s-16 7.164-16 16S23.16 79.1 32 79.1zM229.7 146.3c-3.125-3.125-8.188-3.125-11.31 0l-152 152C64.78 299.9 64 301.9 64 304s.7813 4.094 2.344 5.656c3.125 3.125 8.188 3.125 11.31 0L216 171.3V456c0 4.406 3.578 8 8 8s8-3.594 8-8V171.3l138.3 138.3c3.125 3.125 8.188 3.125 11.31 0s3.125-8.188 0-11.31L229.7 146.3z"],
    "arrow-up-to-line": [384, 512, ["arrow-to-top"], "f341", "M197.7 130.3c-3.125-3.125-8.188-3.125-11.31 0l-152 152C32.78 283.9 32 285.9 32 288s.7813 4.094 2.344 5.656c3.125 3.125 8.188 3.125 11.31 0L184 155.3V472C184 476.4 187.6 480 192 480s8-3.594 8-8V155.3l138.3 138.3c3.125 3.125 8.188 3.125 11.31 0s3.125-8.188 0-11.31L197.7 130.3zM376 32H8C3.582 32 0 35.58 0 40S3.582 48 8 48h368C380.4 48 384 44.42 384 40S380.4 32 376 32z"],
    "arrow-up-triangle-square": [512, 512, ["sort-shapes-up"], "f88a", "M432 288l-128 .0107c-17.67 0-32 14.33-32 32V448c0 17.67 14.33 32 32 32l128-.0098c17.67 0 32-14.32 32-31.99v-127.1C464 302.3 449.7 288 432 288zM448 448c0 8.822-7.178 16-16 16h-128c-8.822 0-16-7.178-16-16v-127.1c0-8.822 7.178-15.1 16-15.1h128c8.822 0 16 7.178 16 16V448zM476.1 182.9L393 45.78C387.4 36.59 377.8 32 368.1 32s-19.38 4.594-24.94 13.78l-83.25 137.1c-11 18.25 2.75 41.12 25 41.12h166.3C473.4 224 487.1 201.1 476.1 182.9zM462.6 201.7c-2.23 3.951-6.516 6.311-11.46 6.311h-166.3c-4.945 0-9.229-2.359-11.46-6.311c-1.119-1.98-2.588-5.988 .1367-10.51l83.26-137.1C360.1 48.59 365.8 48 368.1 48c2.279 0 7.936 .5918 11.26 6.074l83.11 137.1C465.2 195.7 463.7 199.7 462.6 201.7zM133.9 34.48c-3.062-3.312-8.75-3.312-11.81 0L34.09 130.5c-2.969 3.252-2.75 8.314 .5 11.32c3.25 3 8.312 2.781 11.31-.5L120 60.47V471.1C120 476.4 123.6 480 128 480s8-3.594 8-8.002V60.47l74.1 80.85c1.594 1.719 3.75 2.594 5.906 2.594c1.938 0 3.875-.6875 5.406-2.094c3.25-3.002 3.469-8.064 .5-11.32L133.9 34.48z"],
    "arrow-up-wide-short": [576, 512, ["sort-amount-up"], "f161", "M45.9 141.3L120 60.47V471.1C120 476.4 123.6 480 128 480S136 476.4 136 471.1V60.47l74.1 80.85c1.594 1.719 3.75 2.594 5.906 2.594c1.938 0 3.875-.6875 5.406-2.094c3.25-3.002 3.469-8.064 .5-11.32L133.9 34.48c-3.062-3.312-8.75-3.312-11.81 0L34.09 130.5c-2.969 3.252-2.75 8.314 .5 11.32C37.84 144.8 42.9 144.6 45.9 141.3zM536 48h-272C259.6 48 256 51.59 256 56S259.6 64 264 64h272C540.4 64 544 60.41 544 56S540.4 48 536 48zM472 176h-208C259.6 176 256 179.6 256 184S259.6 192 264 192h208C476.4 192 480 188.4 480 184S476.4 176 472 176zM408 304h-144C259.6 304 256 307.6 256 312S259.6 320 264 320h144C412.4 320 416 316.4 416 312S412.4 304 408 304zM344 432h-80C259.6 432 256 435.6 256 440S259.6 448 264 448h80c4.406 0 8-3.594 8-8S348.4 432 344 432z"],
    "arrow-up-z-a": [512, 512, ["sort-alpha-up-alt"], "f882", "M45.9 141.3l74.1-80.85V471.1C120 476.4 123.6 480 128 480s8.001-3.594 8.001-8.002V60.47l74.1 80.85c1.594 1.719 3.75 2.594 5.906 2.594c1.938 0 3.875-.6875 5.406-2.094c3.25-3.002 3.469-8.064 .5-11.32L133.9 34.48c-3.062-3.312-8.75-3.312-11.81 0L34.09 130.5c-2.969 3.252-2.75 8.314 .5 11.32C37.84 144.8 42.9 144.6 45.9 141.3zM456 208h-127.1l133.3-162.9c1.969-2.375 2.375-5.688 1.031-8.5C461.9 33.78 459.1 32 456 32h-144c-4.406 0-8 3.594-8 8s3.594 8 8 8h127.1l-133.3 162.9c-1.969 2.375-2.375 5.688-1.031 8.5C306.1 222.2 308.9 224 312 224h144c4.406 0 8-3.594 8-8S460.4 208 456 208zM479.2 468.4l-88-176c-2.688-5.438-11.62-5.438-14.31 0l-88 176c-1.969 3.938-.375 8.75 3.594 10.72c3.812 1.906 8.75 .4062 10.72-3.594L328.9 424h110.1l25.78 51.56C466.3 478.4 469.1 480 472 480c1.219 0 2.438-.2813 3.562-.8438C479.5 477.2 481.1 472.4 479.2 468.4zM336.9 408l47.06-94.13L431.1 408H336.9z"],
    "arrows-cross": [448, 512, [], "e0a2", "M440 32h-159.1c-4.438 0-7.959 3.586-7.959 7.992c0 4.422 3.578 8 7.996 8h140.6L2.451 466.2c-7.467 7.461 3.814 18.8 11.31 11.31L432 59.3v140.6c0 4.422 3.578 8 7.994 8C444.4 207.9 448 204.4 448 199.1V39.99C448 35.58 444.4 32 440 32zM167.4 210.8c3.123 3.121 8.185 3.219 11.31 .0977C181.9 207.7 181.9 202.6 178.8 199.4L13.76 34.45C6.303 26.98-5.033 38.27 2.457 45.76L167.4 210.8zM440 304.1c-4.418 0-7.996 3.578-7.996 7.992v140.6L280.6 301.2c-3.123-3.121-8.184-3.02-11.31 .1016c-3.123 3.125-3.125 8.086-.002 11.21l151.5 151.5h-140.6c-4.418 0-7.996 3.578-7.996 7.996S275.6 480 280 480h159.1C444.4 480 448 476.4 448 472V312C448 307.6 444.4 304.1 440 304.1z"],
    "arrows-down-to-line": [576, 512, [], "e4b8", "M568 464C572.4 464 576 467.6 576 472C576 476.4 572.4 480 568 480H8C3.582 480 0 476.4 0 472C0 467.6 3.582 464 8 464H568zM453.7 389.7C450.5 392.8 445.5 392.8 442.3 389.7L322.3 269.7C319.2 266.5 319.2 261.5 322.3 258.3C325.5 255.2 330.5 255.2 333.7 258.3L440 364.7V40C440 35.58 443.6 32 448 32C452.4 32 456 35.58 456 40V364.7L562.3 258.3C565.5 255.2 570.5 255.2 573.7 258.3C576.8 261.5 576.8 266.5 573.7 269.7L453.7 389.7zM253.7 269.7L133.7 389.7C130.5 392.8 125.5 392.8 122.3 389.7L2.343 269.7C-.7808 266.5-.7808 261.5 2.343 258.3C5.468 255.2 10.53 255.2 13.66 258.3L120 364.7V40C120 35.58 123.6 32 128 32C132.4 32 136 35.58 136 40V364.7L242.3 258.3C245.5 255.2 250.5 255.2 253.7 258.3C256.8 261.5 256.8 266.5 253.7 269.7z"],
    "arrows-down-to-people": [640, 512, [], "e4b9", "M136 8C136 3.582 139.6 .0003 144 .0003C148.4 .0003 152 3.582 152 8V164.7L202.3 114.3C205.5 111.2 210.5 111.2 213.7 114.3C216.8 117.5 216.8 122.5 213.7 125.7L149.7 189.7C146.5 192.8 141.5 192.8 138.3 189.7L74.34 125.7C71.22 122.5 71.22 117.5 74.34 114.3C77.47 111.2 82.53 111.2 85.66 114.3L136 164.7L136 8zM437.7 114.3L488 164.7V8C488 3.582 491.6 0 496 0C500.4 0 504 3.582 504 8V164.7L554.3 114.3C557.5 111.2 562.5 111.2 565.7 114.3C568.8 117.5 568.8 122.5 565.7 125.7L501.7 189.7C498.5 192.8 493.5 192.8 490.3 189.7L426.3 125.7C423.2 122.5 423.2 117.5 426.3 114.3C429.5 111.2 434.5 111.2 437.7 114.3L437.7 114.3zM456 296C456 273.9 473.9 256 496 256C518.1 256 536 273.9 536 296C536 318.1 518.1 336 496 336C473.9 336 456 318.1 456 296zM496 320C509.3 320 520 309.3 520 296C520 282.7 509.3 272 496 272C482.7 272 472 282.7 472 296C472 309.3 482.7 320 496 320zM399.1 407.1C417.2 373.2 452.5 352 490.9 352H503.7C542.1 352 577.4 373.2 595.5 407.1L623.5 459.6C630.5 472.7 625.3 488.9 612.1 495.6C599.8 501.7 584.8 497.4 577.7 485.6L553.3 444.9L553.3 480C553.3 497.7 538.1 512 521.3 512H473.3C455.6 512 441.3 497.7 441.3 480V444.9L416.9 485.6C409.8 497.4 394.9 501.7 382.6 495.6C369.3 488.9 364.1 472.7 371.1 459.6L399.1 407.1zM490.9 368C458.4 368 428.6 385.9 413.3 414.6L385.2 467.2C382.5 472.3 384.5 478.7 389.7 481.3C394.5 483.7 400.4 481.1 403.2 477.3L442.5 411.9C444.3 408.8 447.1 407.3 451.4 408.3C454.9 409.3 457.3 412.4 457.3 416V480C457.3 488.8 464.5 496 473.3 496H521.3C530.1 496 537.3 488.8 537.3 480L537.3 416C537.3 412.4 539.7 409.3 543.2 408.3C546.6 407.3 550.3 408.8 552.2 411.9L591.4 477.3C594.2 481.1 600.1 483.7 604.9 481.3C610.1 478.7 612.1 472.3 609.4 467.2L581.4 414.6C566.1 385.9 536.2 368 503.7 368H490.9zM184 296C184 318.1 166.1 336 144 336C121.9 336 104 318.1 104 296C104 273.9 121.9 256 144 256C166.1 256 184 273.9 184 296zM144 272C130.7 272 120 282.7 120 296C120 309.3 130.7 320 144 320C157.3 320 168 309.3 168 296C168 282.7 157.3 272 144 272zM151.7 352C190.1 352 225.4 373.2 243.5 407.1L271.5 459.6C278.5 472.7 273.3 488.9 260.1 495.6C247.8 501.7 232.8 497.4 225.7 485.6L201.3 444.9L201.3 480C201.3 497.7 186.1 512 169.3 512H121.3C103.6 512 89.31 497.7 89.31 480V444.9L64.9 485.6C57.82 497.4 42.86 501.7 30.56 495.6C17.31 488.9 12.13 472.7 19.1 459.6L47.14 407.1C65.22 373.2 100.5 352 138.9 352H151.7zM33.22 467.2C30.49 472.3 32.52 478.7 37.71 481.3C42.54 483.7 48.4 481.1 51.18 477.3L90.45 411.9C92.3 408.8 95.98 407.3 99.45 408.3C102.9 409.3 105.3 412.4 105.3 416V480C105.3 488.8 112.5 496 121.3 496H169.3C178.1 496 185.3 488.8 185.3 480L185.3 416C185.3 412.4 187.7 409.3 191.2 408.3C194.6 407.3 198.3 408.8 200.2 411.9L239.4 477.3C242.2 481.1 248.1 483.7 252.9 481.3C258.1 478.7 260.1 472.3 257.4 467.2L229.4 414.6C214.1 385.9 184.2 368 151.7 368H138.9C106.4 368 76.56 385.9 61.26 414.6L33.22 467.2zM280 184C280 161.9 297.9 144 320 144C342.1 144 360 161.9 360 184C360 206.1 342.1 224 320 224C297.9 224 280 206.1 280 184zM320 208C333.3 208 344 197.3 344 184C344 170.7 333.3 160 320 160C306.7 160 296 170.7 296 184C296 197.3 306.7 208 320 208zM314.9 256C282.4 256 252.6 273.9 237.3 302.6L237.2 302.7L217.2 339.2C215.1 343.1 210.2 344.5 206.3 342.4C202.4 340.3 201 335.4 203.1 331.6L223.2 295C241.2 261.2 276.5 240 314.9 240H327.7C366.1 240 401.4 261.2 419.5 295L439.5 331.6C441.6 335.4 440.2 340.3 436.3 342.4C432.4 344.5 427.6 343.1 425.4 339.2L405.4 302.6C390.1 273.9 360.2 256 327.7 256H314.9zM275.5 296.3C278.1 297.3 281.3 300.4 281.3 304V392C281.3 396.4 277.7 400 273.3 400C268.9 400 265.3 396.4 265.3 392V331.6L248.8 357.7C246.4 361.5 241.5 362.6 237.8 360.2C234 357.9 232.9 352.9 235.3 349.2L266.5 299.7C268.5 296.7 272.1 295.3 275.5 296.3L275.5 296.3zM367.1 296.3C370.5 295.3 374.2 296.7 376.1 299.7L407.3 349.2C409.7 352.9 408.6 357.9 404.9 360.2C401.1 362.6 396.2 361.5 393.8 357.7L377.3 331.6L377.3 392C377.3 396.4 373.7 400 369.3 400C364.9 400 361.3 396.4 361.3 392L361.3 304C361.3 300.4 363.7 297.3 367.1 296.3H367.1z"],
    "arrows-from-dotted-line": [448, 512, [], "e0a3", "M32 240C23.16 240 16 247.2 16 256S23.16 272 32 272S48 264.8 48 256S40.84 240 32 240zM144 256c0-8.836-7.164-16-16-16S112 247.2 112 256S119.2 272 128 272S144 264.8 144 256zM208 256c0 8.836 7.164 16 16 16s16-7.164 16-16S232.8 240 224 240S208 247.2 208 256zM320 240c-8.836 0-16 7.164-16 16s7.164 16 16 16s16-7.164 16-16S328.8 240 320 240zM416 240c-8.836 0-16 7.164-16 16s7.164 16 16 16s16-7.164 16-16S424.8 240 416 240zM136 104c2.047 0 4.094-.7813 5.656-2.344L216 27.31V184c0 4.406 3.594 7.984 8 7.984S232 188.4 232 184V27.31l74.34 74.34C307.9 103.2 309.9 104 312 104c5.719 0 8-5.114 8-8.021c0-2.047-.7813-4.073-2.344-5.635l-88-88C228.1 .7813 226 0 223.1 0S219.9 .7813 218.3 2.344l-88 88C128.8 91.91 128 93.93 128 95.98C128 100.5 131.7 104 136 104zM312 408c-2.047 0-4.094 .7813-5.656 2.344L232 484.7V328c0-4.406-3.594-8.01-8-8.01S216 323.6 216 328v156.7l-74.34-74.34C140.1 408.8 138 408 136 408C131.7 408 128 411.4 128 415.1c0 2.047 .7813 4.099 2.344 5.662l88 88C219.9 511.2 221.9 512 224 512s4.094-.7813 5.656-2.344l88-88C319.2 420.1 320 418 320 415.1C320 411.4 316.3 408 312 408z"],
    "arrows-from-line": [448, 512, [], "e0a4", "M136 104c2.047 0 4.094-.7813 5.656-2.344L216 27.31V184c0 4.406 3.594 7.984 8 7.984S232 188.4 232 184V27.31l74.34 74.34C307.9 103.2 309.9 104 312 104c5.719 0 8-5.114 8-8.021c0-2.047-.7813-4.073-2.344-5.636l-88-88C228.1 .7813 226 0 223.1 0s-4.094 .7813-5.656 2.344l-88 88C128.8 91.91 128 93.93 128 95.98C128 100.5 131.7 104 136 104zM312 408c-2.047 0-4.094 .7813-5.656 2.344L232 484.7V328c0-4.406-3.594-8.01-8-8.01S216 323.6 216 328v156.7l-74.34-74.34C140.1 408.8 138 408 136 408C131.7 408 128 411.4 128 415.1c0 2.047 .7813 4.099 2.344 5.662l88 88C219.9 511.2 221.9 512 224 512s4.094-.7813 5.656-2.344l88-88C319.2 420.1 320 418 320 415.1C320 411.4 316.3 408 312 408zM440 248H8C3.582 248 0 251.6 0 255.1S3.582 264 8 264h432c4.418 0 8-3.591 8-8.009S444.4 248 440 248z"],
    "arrows-left-right": [512, 512, ["arrows-h"], "f07e", "M509.7 261.8l-96 103.8c-3.125 3.192-8.188 3.192-11.31 0c-3.125-3.192-3.125-8.363 0-11.55l82.34-89.88H27.31l82.34 89.88c3.125 3.192 3.125 8.362 0 11.55C108.1 367.2 106.1 368 104 368s-4.094-.7979-5.656-2.394l-96-103.8c-3.125-3.192-3.125-8.362 0-11.55l96-103.8c3.125-3.192 8.188-3.192 11.31 0s3.125 8.363 0 11.55L27.31 247.8h457.4l-82.34-89.88c-3.125-3.192-3.125-8.363 0-11.55C403.9 144.8 405.9 144 408 144s4.094 .7979 5.656 2.394l96 103.8C512.8 253.4 512.8 258.6 509.7 261.8z"],
    "arrows-left-right-to-line": [640, 512, [], "e4ba", "M8 64C12.42 64 16 67.58 16 72V440C16 444.4 12.42 448 8 448C3.582 448 0 444.4 0 440V72C0 67.58 3.582 64 8 64zM205.7 154.3C208.8 157.5 208.8 162.5 205.7 165.7L123.3 248H516.7L434.3 165.7C431.2 162.5 431.2 157.5 434.3 154.3C437.5 151.2 442.5 151.2 445.7 154.3L541.7 250.3C544.8 253.5 544.8 258.5 541.7 261.7L445.7 357.7C442.5 360.8 437.5 360.8 434.3 357.7C431.2 354.5 431.2 349.5 434.3 346.3L516.7 264H123.3L205.7 346.3C208.8 349.5 208.8 354.5 205.7 357.7C202.5 360.8 197.5 360.8 194.3 357.7L98.34 261.7C95.22 258.5 95.22 253.5 98.34 250.3L194.3 154.3C197.5 151.2 202.5 151.2 205.7 154.3H205.7zM640 440C640 444.4 636.4 448 632 448C627.6 448 624 444.4 624 440V72C624 67.58 627.6 64 632 64C636.4 64 640 67.58 640 72V440z"],
    "arrows-maximize": [448, 512, ["expand-arrows"], "f31d", "M432 184V59.31L235.3 256l196.7 196.7V328c0-4.422 3.58-8 7.998-8c4.424 0 8 3.578 8 8v144c0 4.426-3.584 8-8 8h-144C291.6 480 288 476.4 288 472c0-4.418 3.58-8 8-8h124.7L224 267.3L27.31 464H152C156.4 464 160 467.6 160 472C160 476.4 156.4 480 152 480h-144C3.576 480 0 476.4 0 472v-144C0 323.6 3.58 320 8 320c4.418 0 7.998 3.578 7.998 8v124.7L212.7 256L15.1 59.31V184C15.1 188.4 12.42 192 8 192C3.576 192 0 188.4 0 184v-144C0 35.57 3.584 32 8 32h144C156.4 32 160 35.59 160 40C160 44.42 156.4 48 152 48H27.31L224 244.7L420.7 48H296C291.6 48 288 44.42 288 40C288 35.59 291.6 32 296 32h144C444.4 32 448 35.58 448 40v144C448 188.4 444.4 192 440 192C435.6 192 432 188.4 432 184z"],
    "arrows-minimize": [512, 512, ["compress-arrows"], "e0a5", "M45.77 477.5l162.3-162.3v140.7c0 4.42 3.58 8 7.998 8c4.42 0 7.943-3.517 7.943-7.942L224.1 295.9c0-4.416-3.576-7.998-8-7.998L56.06 287.9c-4.439 0-7.942 3.534-7.942 7.94c0 4.42 3.58 8 8 8h140.7l-162.3 162.3C26.97 473.7 38.29 485 45.77 477.5zM216.1 48.12c-4.418 0-7.998 3.58-7.998 8v140.7L45.76 34.46C38.27 26.96 26.98 38.31 34.45 45.77l162.3 162.3H56.11c-4.42 0-8 3.58-8 8c0 4.404 3.504 7.94 7.945 7.94l160.1 .0578c4.416 0 8-3.574 8-7.998L224.1 56.06C224.1 51.64 220.5 48.12 216.1 48.12zM295.9 463.9c4.418 0 7.998-3.58 7.998-8V315.2l162.3 162.3c7.486 7.488 18.79-3.832 11.31-11.31l-162.3-162.3h140.7c4.42 0 8-3.58 8-8c0-4.402-3.502-7.94-7.943-7.94l-160.1-.0585c-4.416 0-8 3.574-8 7.998l.0567 160.1C287.9 460.4 291.5 463.9 295.9 463.9zM295.9 224.1l160.1-.0576c4.439 0 7.945-3.532 7.945-7.94c0-4.42-3.58-8-8-8h-140.7l162.3-162.3c7.469-7.465-3.816-18.81-11.31-11.31l-162.3 162.3V56.12c0-4.42-3.58-8-7.998-8c-4.42 0-7.945 3.519-7.945 7.942l-.0549 160.1C287.9 220.5 291.5 224.1 295.9 224.1z"],
    "arrows-repeat": [512, 512, ["repeat-alt"], "f364", "M419.4 103.1l-80.83 74.09c-3.25 3-3.484 8.063-.4844 11.31C339.7 191.1 341.8 191.1 344 191.1c1.938 0 3.875-.6875 5.406-2.094l96-88C447.1 100.4 448 98.25 448 95.1c0-2.25-.9375-4.377-2.594-5.908l-96-88c-3.219-2.969-8.281-2.75-11.3 .5c-3 3.25-2.766 8.313 .4844 11.31l80.83 74.09H168c-92.64 0-168 75.38-168 168c0 4.406 3.578 7.999 8 7.999S16 260.4 16 255.1c0-83.81 68.19-152 152-152H419.4zM504 247.1c-4.422 0-8 3.594-8 8c0 83.81-68.19 152-152 152H92.57l80.83-74.09c3.25-3 3.484-8.063 .4844-11.31c-2.984-3.25-8.047-3.469-11.3-.5l-96 88C64.94 411.6 64 413.7 64 415.1c0 2.25 .9375 4.375 2.594 5.906l96 88C164.1 511.3 166.1 512 168 512c2.156 0 4.312-.875 5.891-2.594c3-3.25 2.766-8.313-.4844-11.31l-80.83-74.09H344c92.64 0 168-75.37 168-167.1C512 251.6 508.4 247.1 504 247.1z"],
    "arrows-repeat-1": [512, 512, ["repeat-1-alt"], "f366", "M419.4 103.1l-80.83 74.1c-1.718 1.586-2.594 3.749-2.594 5.915c0 4.431 3.618 7.991 7.1 7.991c1.938 0 3.875-.6875 5.406-2.094l96-88C447.1 100.4 448 98.25 448 95.1s-.9375-4.377-2.594-5.908l-96-88c-1.516-1.399-3.442-2.09-5.37-2.09c-4.384 0-8.036 3.518-8.036 7.987c0 2.167 .8753 4.329 2.594 5.915l80.83 74.09H168c-92.64 0-168 75.38-168 168C0 260.4 3.578 263.1 8 263.1s8-3.594 8-8c0-83.81 68.19-152 152-152H419.4zM504 247.1c-4.422 0-8 3.594-8 8c0 83.81-68.19 152-152 152H92.57l80.83-74.1c1.718-1.586 2.594-3.749 2.594-5.915c0-4.408-3.586-7.987-8.013-7.987c-1.929 0-3.862 .6912-5.394 2.09l-96 88C64.94 411.6 64 413.8 64 416s.9375 4.375 2.594 5.906l96 88C164.1 511.3 166.1 512 168 512c4.378 0 7.1-3.557 7.1-7.991c0-2.167-.8753-4.329-2.594-5.915L92.57 424H344c92.64 0 168-75.38 168-168C512 251.6 508.4 247.1 504 247.1zM264 320c4.422 0 8-3.594 8-8v-112c0-4.406-3.583-8.007-8.005-8.007L240 192C235.6 192 232 195.6 232 200S235.6 208 240 208H256v104C256 316.4 259.6 320 264 320z"],
    "arrows-retweet": [640, 512, ["retweet-alt"], "f361", "M352 400H159.1c-13.23 0-24-10.78-24-24V90.4l106.5 99.44C244.1 191.3 246 192 248 192c2.141 0 4.266-.8438 5.844-2.531c3.016-3.25 2.844-8.312-.3906-11.31l-120-112c-3.062-2.875-7.844-2.875-10.91 0l-120 112c-3.234 3-3.406 8.062-.3906 11.31c3.031 3.219 8.078 3.406 11.3 .375L119.1 90.4V376c0 22.06 17.94 40 40 40H352c4.422 0 8-3.594 8-8S356.4 400 352 400zM637.8 322.5c-3-3.219-8.078-3.375-11.3-.375l-106.5 99.44V136c0-22.06-17.94-40-40-40H288C283.6 96 280 99.59 280 104S283.6 112 288 112h192c13.23 0 24 10.78 24 24v285.6l-106.5-99.44c-3.203-3-8.266-2.844-11.3 .375c-3.016 3.25-2.844 8.312 .3906 11.31l120 112C508.1 447.3 510 448 512 448s3.923-.7187 5.455-2.156l120-112C640.7 330.8 640.9 325.8 637.8 322.5z"],
    "arrows-rotate": [512, 512, [128472, "refresh", "sync"], "f021", "M463.5 272.1C463.2 272 462.9 272 462.6 272c-4.031 0-7.469 3-7.938 7.094C443.1 379.9 357.7 456 256 456c-85.8 0-161.6-55.56-188.9-136H184C188.4 320 192 316.4 192 312S188.4 304 184 304H48c-4.406 0-8 3.594-8 8v128C40 444.4 43.59 448 48 448s8-3.594 8-8v-104C88.43 416.9 167.2 472 256 472c109.8 0 202.1-82.16 214.6-191.1C471.1 276.5 467.9 272.6 463.5 272.1zM464 64c-4.406 0-8 3.594-8 8v104C423.6 95.09 344.8 40 256 40c-109.8 0-202.1 82.16-214.6 191.1c-.5 4.375 2.625 8.344 7.031 8.844C48.78 239.1 49.09 240 49.38 240c4.031 0 7.469-3 7.938-7.094C68.91 132.1 154.3 56 256 56c85.8 0 161.6 55.56 188.9 136H328C323.6 192 320 195.6 320 200s3.594 8 8 8h136c4.406 0 8-3.594 8-8v-128C472 67.59 468.4 64 464 64z"],
    "arrows-spin": [512, 512, [], "e4bb", "M107.2 123.2L74.34 90.35C59.22 75.23 69.93 49.38 91.31 49.38H177.4C186.2 49.38 193.4 56.54 193.4 65.38V151.4C193.4 172.8 167.5 183.5 152.4 168.4L118.5 134.5C90.26 166.9 73.14 209.2 73.14 255.5C73.14 266.6 74.11 277.5 75.99 288H59.76C58.03 277.4 57.14 266.6 57.14 255.5C57.14 204.8 76.04 158.4 107.2 123.2L107.2 123.2zM85.66 79.03L118.2 111.6L118.3 111.6L119.1 112.5L163.7 157.1C168.8 162.1 177.4 158.6 177.4 151.4V65.37H91.31C84.18 65.37 80.62 73.99 85.66 79.03H85.66zM257.1 71.53C245.8 71.53 234.7 72.55 223.1 74.51V58.26C234.8 56.47 245.8 55.53 257.1 55.53C308.7 55.53 355.7 75.05 391.2 107.1L423.9 74.35C439 59.23 464.9 69.93 464.9 91.32V177.4C464.9 186.2 457.7 193.4 448.9 193.4H362.8C341.5 193.4 330.8 167.5 345.9 152.4L379.8 118.4C347.3 89.26 304.3 71.53 257.1 71.53V71.53zM435.2 85.66L357.2 163.7C352.1 168.8 355.7 177.4 362.8 177.4H448.9V91.32C448.9 84.19 440.3 80.62 435.2 85.66V85.66zM441.1 255.5C441.1 244.8 440.2 234.2 438.4 224H454.7C456.3 234.3 457.1 244.8 457.1 255.5C457.1 307.1 437.6 354.1 405.6 389.6L439.9 423.9C455 439.1 444.3 464.9 422.1 464.9H336.9C328.1 464.9 320.9 457.7 320.9 448.9V362.8C320.9 341.5 346.8 330.8 361.9 345.9L394.2 378.2C423.4 345.7 441.1 302.7 441.1 255.5V255.5zM394.3 401.1L392.9 399.5L350.6 357.2C345.5 352.2 336.9 355.7 336.9 362.8V448.9H422.1C430.1 448.9 433.7 440.3 428.6 435.2L394.4 401L394.3 401.1zM287.1 453.2C277.9 454.7 267.6 455.5 257.1 455.5C206.4 455.5 160.1 436.6 124.8 405.5L90.34 439.9C75.22 455.1 49.37 444.3 49.37 422.1V336.9C49.37 328.1 56.53 320.9 65.37 320.9H151.4C172.8 320.9 183.5 346.8 168.4 361.9L136.1 394.1C168.5 422.4 210.8 439.5 257.1 439.5C267.7 439.5 277.1 438.6 288 436.1L287.1 453.2zM65.37 336.9V422.1C65.37 430.1 73.99 433.7 79.03 428.6L157.1 350.6C162.1 345.5 158.6 336.9 151.4 336.9H65.37z"],
    "arrows-split-up-and-left": [512, 512, [], "e4bc", "M229.7 109.7C226.5 112.8 221.5 112.8 218.3 109.7C215.2 106.5 215.2 101.5 218.3 98.34L314.3 2.343C317.5-.781 322.5-.781 325.7 2.343L421.7 98.34C424.8 101.5 424.8 106.5 421.7 109.7C418.5 112.8 413.5 112.8 410.3 109.7L328 27.31V408C328 456.6 367.4 496 416 496H504C508.4 496 512 499.6 512 504C512 508.4 508.4 512 504 512H416C358.6 512 312 465.4 312 408V384C312 335.4 272.6 296 224 296H27.31L109.7 378.3C112.8 381.5 112.8 386.5 109.7 389.7C106.5 392.8 101.5 392.8 98.34 389.7L2.343 293.7C.8429 292.2 0 290.1 0 287.1C0 285.9 .8429 283.8 2.343 282.3L98.34 186.3C101.5 183.2 106.5 183.2 109.7 186.3C112.8 189.5 112.8 194.5 109.7 197.7L27.31 279.1H224C261.1 279.1 293.6 299.4 312 328.5V27.31L229.7 109.7z"],
    "arrows-to-circle": [640, 512, [], "e4bd", "M175.1 164.7V72C175.1 67.58 179.6 64 183.1 64C188.4 64 191.1 67.58 191.1 72V184C191.1 188.4 188.4 192 183.1 192H71.1C67.58 192 63.1 188.4 63.1 184C63.1 179.6 67.58 176 71.1 176H164.7L2.343 13.66C-.781 10.53-.781 5.468 2.343 2.343C5.467-.7807 10.53-.7807 13.66 2.343L175.1 164.7zM626.3 2.343C629.5-.781 634.5-.781 637.7 2.343C640.8 5.467 640.8 10.53 637.7 13.66L475.3 175.1H568C572.4 175.1 576 179.6 576 183.1C576 188.4 572.4 191.1 568 191.1H456C451.6 191.1 448 188.4 448 183.1V71.1C448 67.58 451.6 63.1 456 63.1C460.4 63.1 464 67.58 464 71.1V164.7L626.3 2.343zM223.1 256C223.1 202.1 266.1 160 319.1 160C373 160 416 202.1 416 256C416 309 373 352 319.1 352C266.1 352 223.1 309 223.1 256zM319.1 336C364.2 336 400 300.2 400 256C400 211.8 364.2 176 319.1 176C275.8 176 239.1 211.8 239.1 256C239.1 300.2 275.8 336 319.1 336zM456 448C451.6 448 448 444.4 448 440V328C448 323.6 451.6 320 456 320H568C572.4 320 576 323.6 576 328C576 332.4 572.4 336 568 336H475.3L637.7 498.3C640.8 501.5 640.8 506.5 637.7 509.7C634.5 512.8 629.5 512.8 626.3 509.7L464 347.3V440C464 444.4 460.4 448 456 448V448zM175.1 440V347.3L13.66 509.7C10.53 512.8 5.467 512.8 2.343 509.7C-.781 506.5-.781 501.5 2.343 498.3L164.7 336H71.1C67.58 336 63.1 332.4 63.1 328C63.1 323.6 67.58 320 71.1 320H183.1C188.4 320 191.1 323.6 191.1 328V440C191.1 444.4 188.4 448 183.1 448C179.6 448 175.1 444.4 175.1 440z"],
    "arrows-to-dot": [512, 512, [], "e4be", "M264 7.1V164.7L338.3 90.34C341.5 87.22 346.5 87.22 349.7 90.34C352.8 93.47 352.8 98.53 349.7 101.7L261.7 189.7C258.5 192.8 253.5 192.8 250.3 189.7L162.3 101.7C159.2 98.53 159.2 93.47 162.3 90.34C165.5 87.22 170.5 87.22 173.7 90.34L248 164.7V8C248 3.582 251.6 0 256 0C260.4 0 264 3.582 264 8V7.1zM421.7 173.7L347.3 247.1H504C508.4 247.1 512 251.6 512 255.1C512 260.4 508.4 263.1 504 263.1H347.3L421.7 338.3C424.8 341.5 424.8 346.5 421.7 349.7C418.5 352.8 413.5 352.8 410.3 349.7L322.3 261.7C319.2 258.5 319.2 253.5 322.3 250.3L410.3 162.3C413.5 159.2 418.5 159.2 421.7 162.3C424.8 165.5 424.8 170.5 421.7 173.7H421.7zM224 256C224 238.3 238.3 224 256 224C273.7 224 288 238.3 288 256C288 273.7 273.7 288 256 288C238.3 288 224 273.7 224 256zM256 272C264.8 272 272 264.8 272 256C272 247.2 264.8 240 256 240C247.2 240 240 247.2 240 256C240 264.8 247.2 272 256 272zM189.7 250.3C192.8 253.5 192.8 258.5 189.7 261.7L101.7 349.7C98.53 352.8 93.47 352.8 90.35 349.7C87.22 346.5 87.22 341.5 90.35 338.3L164.7 264H8.002C3.584 264 .0019 260.4 .0019 256C.0019 251.6 3.584 248 8.002 248H164.7L90.34 173.7C87.22 170.5 87.22 165.5 90.34 162.3C93.47 159.2 98.53 159.2 101.7 162.3L189.7 250.3zM250.3 322.3C253.5 319.2 258.5 319.2 261.7 322.3L349.7 410.3C352.8 413.5 352.8 418.5 349.7 421.7C346.5 424.8 341.5 424.8 338.3 421.7L264 347.3V504C264 508.4 260.4 512 256 512C251.6 512 248 508.4 248 504V347.3L173.7 421.7C170.5 424.8 165.5 424.8 162.3 421.7C159.2 418.5 159.2 413.5 162.3 410.3L250.3 322.3z"],
    "arrows-to-dotted-line": [448, 512, [], "e0a6", "M208 256c0 8.836 7.164 16 16 16s16-7.164 16-16S232.8 240 224 240S208 247.2 208 256zM144 256c0-8.836-7.164-16-16-16S112 247.2 112 256S119.2 272 128 272S144 264.8 144 256zM32 240C23.16 240 16 247.2 16 256S23.16 272 32 272S48 264.8 48 256S40.84 240 32 240zM416 240c-8.836 0-16 7.164-16 16s7.164 16 16 16s16-7.164 16-16S424.8 240 416 240zM320 240c-8.836 0-16 7.164-16 16s7.164 16 16 16s16-7.164 16-16S328.8 240 320 240zM218.3 189.7C219.9 191.2 221.9 192 224 192s4.094-.7813 5.656-2.344l88-88C319.2 100.1 320 98.05 320 96c0-4.57-3.737-8-8-8c-2.047 0-4.094 .7813-5.656 2.344L232 164.7V8C232 3.594 228.4 0 224 0S216 3.594 216 8v156.7L141.7 90.34C140.1 88.78 138 88 136 88C131.7 88 128 91.43 128 96c0 2.047 .7813 4.094 2.344 5.656L218.3 189.7zM229.7 322.3c-1.562-1.562-3.609-2.334-5.656-2.334s-4.094 .7715-5.656 2.334l-88 88C128.8 411.9 128 413.1 128 416c0 4.57 3.737 8 8 8c2.047 0 4.094-.7813 5.656-2.344L216 347.3V504C216 508.4 219.6 512 224 512s8-3.594 8-8v-156.7l74.34 74.34C307.9 423.2 309.9 424 312 424c5.719 0 8-5.094 8-8c0-2.047-.7813-4.094-2.344-5.656L229.7 322.3z"],
    "arrows-to-eye": [640, 512, [], "e4bf", "M143.1 132.7V56C143.1 51.58 147.6 48 151.1 48C156.4 48 159.1 51.58 159.1 56V152C159.1 156.4 156.4 160 151.1 160H55.1C51.58 160 47.1 156.4 47.1 152C47.1 147.6 51.58 144 55.1 144H132.7L26.34 37.66C23.22 34.53 23.22 29.47 26.34 26.34C29.47 23.22 34.53 23.22 37.65 26.34L143.1 132.7zM602.3 26.34C605.5 23.22 610.5 23.22 613.7 26.34C616.8 29.47 616.8 34.53 613.7 37.66L507.3 143.1H583.1C588.4 143.1 591.1 147.6 591.1 151.1C591.1 156.4 588.4 159.1 583.1 159.1H487.1C483.6 159.1 479.1 156.4 479.1 151.1V55.1C479.1 51.58 483.6 47.1 487.1 47.1C492.4 47.1 495.1 51.58 495.1 55.1V132.7L602.3 26.34zM400 256C400 300.2 364.2 336 319.1 336C275.8 336 239.1 300.2 239.1 256C239.1 211.8 275.8 176 319.1 176C364.2 176 400 211.8 400 256zM319.1 192C284.7 192 255.1 220.7 255.1 256C255.1 291.3 284.7 320 319.1 320C355.3 320 384 291.3 384 256C384 220.7 355.3 192 319.1 192zM506.5 243.9C510.3 251.6 510.3 260.4 506.5 268.1C481.4 318.4 417.3 400 319.1 400C222.7 400 158.6 318.4 133.5 268.1C129.7 260.4 129.7 251.6 133.5 243.9C158.6 193.6 222.7 112 319.1 112C417.3 112 481.4 193.6 506.5 243.9V243.9zM147.9 260.9C172.1 309.7 232.1 384 319.1 384C407.9 384 467.9 309.7 492.1 260.9C493.7 257.8 493.7 254.2 492.1 251.1C467.9 202.3 407.9 128 319.1 128C232.1 128 172.1 202.3 147.9 251.1C146.3 254.2 146.3 257.8 147.9 260.9zM495.1 379.3V456C495.1 460.4 492.4 464 487.1 464C483.6 464 479.1 460.4 479.1 456V360C479.1 355.6 483.6 352 487.1 352H583.1C588.4 352 591.1 355.6 591.1 360C591.1 364.4 588.4 368 583.1 368H507.3L613.7 474.3C616.8 477.5 616.8 482.5 613.7 485.7C610.5 488.8 605.5 488.8 602.3 485.7L495.1 379.3zM37.65 485.7C34.53 488.8 29.47 488.8 26.34 485.7C23.22 482.5 23.22 477.5 26.34 474.3L132.7 368H55.1C51.58 368 47.1 364.4 47.1 360C47.1 355.6 51.58 352 55.1 352H151.1C156.4 352 159.1 355.6 159.1 360V456C159.1 460.4 156.4 464 151.1 464C147.6 464 143.1 460.4 143.1 456V379.3L37.65 485.7z"],
    "arrows-to-line": [448, 512, [], "e0a7", "M229.7 322.3C228.1 320.8 226 320 224 320s-4.094 .7719-5.656 2.334l-88 88C128.8 411.9 128 413.1 128 416c0 4.57 3.736 8 8 8c2.047 0 4.094-.7813 5.656-2.344L216 347.3V504C216 508.4 219.6 512 224 512s8-3.594 8-8v-156.7l74.34 74.34C307.9 423.2 309.9 424 312 424c5.719 0 8-5.094 8-8c0-2.047-.7813-4.094-2.344-5.656L229.7 322.3zM218.3 189.7C219.9 191.2 221.9 192 224 192s4.094-.7813 5.656-2.344l88-88C319.2 100.1 320 98.05 320 96c0-4.57-3.736-8-8-8c-2.047 0-4.094 .7813-5.656 2.344L232 164.7V8C232 3.594 228.4 0 224 0S216 3.594 216 8v156.7L141.7 90.34C140.1 88.78 138 88 136 88C131.7 88 128 91.43 128 96c0 2.047 .7813 4.094 2.344 5.656L218.3 189.7zM440 248H8C3.582 248 0 251.6 0 255.1S3.582 264 8 264h432c4.418 0 8-3.591 8-8.009S444.4 248 440 248z"],
    "arrows-turn-right": [448, 512, [], "e4c0", "M305.1 10.73C308.9 7.407 313.9 7.07 317.3 9.979L445.3 121.1C447 123.5 448 125.7 448 128C448 130.3 447 132.5 445.3 134L317.3 246C313.9 248.9 308.9 248.6 305.1 245.3C303.1 241.9 303.4 236.9 306.7 233.1L418.7 135.1H104C55.4 135.1 16 175.4 16 223.1V279.1C16 284.4 12.42 287.1 8 287.1C3.582 287.1 0 284.4 0 279.1V223.1C0 166.6 46.56 119.1 104 119.1H418.7L306.7 22.02C303.4 19.11 303.1 14.06 305.1 10.73L305.1 10.73zM209.1 266.7C212.9 263.4 217.9 263.1 221.3 265.1L349.3 377.1C351 379.5 352 381.7 352 384C352 386.3 351 388.5 349.3 390L221.3 502C217.9 504.9 212.9 504.6 209.1 501.3C207.1 497.9 207.4 492.9 210.7 489.1L322.7 391.1H72C41.07 391.1 16 417.1 16 447.1V503.1C16 508.4 12.42 511.1 8 511.1C3.582 511.1 0 508.4 0 503.1V447.1C0 408.2 32.24 375.1 72 375.1H322.7L210.7 278C207.4 275.1 207.1 270.1 209.1 266.7L209.1 266.7z"],
    "arrows-turn-to-dots": [512, 512, [], "e4c1", "M274.3 34.34C277.5 31.22 282.5 31.22 285.7 34.34C288.8 37.47 288.8 42.53 285.7 45.66L211.3 119.1H440C479.8 119.1 512 152.2 512 191.1V247.1C512 252.4 508.4 255.1 504 255.1C499.6 255.1 496 252.4 496 247.1V191.1C496 161.1 470.9 135.1 440 135.1H211.3L285.7 210.3C288.8 213.5 288.8 218.5 285.7 221.7C282.5 224.8 277.5 224.8 274.3 221.7L186.3 133.7C183.2 130.5 183.2 125.5 186.3 122.3L274.3 34.34zM325.7 378.3C328.8 381.5 328.8 386.5 325.7 389.7L237.7 477.7C234.5 480.8 229.5 480.8 226.3 477.7C223.2 474.5 223.2 469.5 226.3 466.3L300.7 392H72C41.07 392 16 417.1 16 448V504C16 508.4 12.42 512 8 512C3.582 512 0 508.4 0 504V448C0 408.2 32.24 376 72 376H300.7L226.3 301.7C223.2 298.5 223.2 293.5 226.3 290.3C229.5 287.2 234.5 287.2 237.7 290.3L325.7 378.3zM384 384C384 348.7 412.7 320 448 320C483.3 320 512 348.7 512 384C512 419.3 483.3 448 448 448C412.7 448 384 419.3 384 384zM448 432C474.5 432 496 410.5 496 384C496 357.5 474.5 336 448 336C421.5 336 400 357.5 400 384C400 410.5 421.5 432 448 432zM0 128C0 92.65 28.65 64 64 64C99.35 64 128 92.65 128 128C128 163.3 99.35 192 64 192C28.65 192 0 163.3 0 128zM64 176C90.51 176 112 154.5 112 128C112 101.5 90.51 80 64 80C37.49 80 16 101.5 16 128C16 154.5 37.49 176 64 176z"],
    "arrows-up-down": [256, 512, ["arrows-v"], "f07d", "M122.2 509.7l-103.8-96c-3.192-3.125-3.192-8.188 0-11.31s8.363-3.125 11.55 0l89.88 82.34V27.31L29.95 109.7c-3.192 3.125-8.363 3.125-11.55 0C16.8 108.1 16 106.1 16 104s.7979-4.094 2.394-5.656l103.8-96c3.192-3.125 8.362-3.125 11.55 0l103.8 96c3.192 3.125 3.192 8.188 0 11.31c-3.192 3.125-8.363 3.125-11.55 0l-89.88-82.34v457.4l89.88-82.34c3.192-3.125 8.362-3.125 11.55 0C239.2 403.9 240 405.9 240 408s-.7979 4.094-2.394 5.656l-103.8 96C130.6 512.8 125.4 512.8 122.2 509.7z"],
    "arrows-up-down-left-right": [512, 512, ["arrows"], "f047", "M512 255.1c0 2.047-.7813 4.128-2.344 5.691l-80 88C428.1 351.2 426 352 424 352C419.7 352 416 348.6 416 344c0-2.047 .7813-4.094 2.344-5.656L484.7 264H264v220.7l74.34-66.34C339.9 416.8 341.1 416 344 416c2.906 0 8 2.281 8 8c0 2.062-.7813 4.094-2.344 5.656l-88 80C260.1 511.2 258 512 256 512s-4.094-.7813-5.656-2.344l-88-80C160.8 428.1 160 426 160 424C160 419.4 163.7 416 168 416c2.047 0 4.094 .7813 5.656 2.344L248 484.7V264H27.31l66.34 74.34C95.22 339.9 96 341.1 96 344C96 346.9 93.72 352 88 352c-2.062 0-4.094-.7813-5.656-2.344l-80-88C.7813 260.1 0 258 0 255.1s.7813-4.059 2.344-5.622l80-88C83.91 160.8 85.95 160 88 160C92.26 160 96 163.4 96 168c0 2.047-.7813 4.094-2.344 5.656L27.31 248H248V27.31L173.7 93.66C172.1 95.22 170 96 168 96C165.1 96 160 93.72 160 88c0-2.062 .7813-4.094 2.344-5.656l88-80C251.9 .7813 253.1 0 256 0s4.094 .7813 5.656 2.344l88 80C351.2 83.91 352 85.95 352 88C352 92.57 348.3 96 344 96c-2.047 0-4.094-.7813-5.656-2.344L264 27.31V248h220.7l-66.34-74.34C416.8 172.1 416 170 416 168C416 165.1 418.3 160 424 160c2.062 0 4.094 .7813 5.656 2.344l80 88C511.2 251.9 512 253.9 512 255.1z"],
    "arrows-up-to-line": [576, 512, [], "e4c2", "M8 48C3.582 48 0 44.42 0 40C0 35.58 3.582 32 8 32H568C572.4 32 576 35.58 576 40C576 44.42 572.4 48 568 48H8zM122.3 122.3C125.5 119.2 130.5 119.2 133.7 122.3L253.7 242.3C256.8 245.5 256.8 250.5 253.7 253.7C250.5 256.8 245.5 256.8 242.3 253.7L136 147.3L136 472C136 476.4 132.4 480 128 480C123.6 480 120 476.4 120 472L120 147.3L13.66 253.7C10.53 256.8 5.468 256.8 2.343 253.7C-.7808 250.5-.7808 245.5 2.343 242.3L122.3 122.3zM322.3 242.3L442.3 122.3C445.5 119.2 450.5 119.2 453.7 122.3L573.7 242.3C576.8 245.5 576.8 250.5 573.7 253.7C570.5 256.8 565.5 256.8 562.3 253.7L456 147.3V472C456 476.4 452.4 480 448 480C443.6 480 440 476.4 440 472V147.3L333.7 253.7C330.5 256.8 325.5 256.8 322.3 253.7C319.2 250.5 319.2 245.5 322.3 242.3V242.3z"],
    "asterisk": [448, 512, [10033, 61545], "2a", "M412.1 357.1c3.753 2.203 5.045 7.094 2.891 10.92c-1.476 2.562-4.121 4-6.828 4c-1.353 0-2.707-.3438-3.937-1.078l-172.3-101.1V472c0 4.422-3.538 8-7.875 8c-4.337 0-7.874-3.578-7.874-8V269.8l-172.3 101.1C42.58 371.7 41.22 372 39.87 372c-2.707 0-5.352-1.438-6.829-4c-2.153-3.828-.8607-8.719 2.892-10.92L208.3 256L35.93 154.9C32.18 152.7 30.89 147.8 33.04 144c2.215-3.859 7.045-5.125 10.77-2.922l172.3 101.1V40c0-4.422 3.537-8 7.874-8c4.337 0 7.875 3.578 7.875 8v202.2l172.3-101.1C407.9 138.9 412.7 140.1 414.1 144c2.154 3.828 .8619 8.719-2.891 10.92L239.7 256L412.1 357.1z"],
    "at": [512, 512, [61946], "40", "M263.4 16.12C197.2 14.06 135.8 38.18 88.88 83.78C41.88 129.4 16 190.5 16 256C16 388.3 123.7 496 256 496c4.406 0 8-3.578 8-7.1s-3.62-8.073-8.026-8.073C132.5 479.9 32 379.5 32 256c0-61.11 24.16-118.2 68-160.8c43.88-42.53 102.3-65.17 162.9-63.12C382.6 35.72 480 140.5 480 265.7v10.27c0 37.5-30.5 67.1-68 67.1S344 313.5 344 276V160c0-4.422-3.594-7.1-8-7.1s-8 3.578-8 7.1v41.18c-18.39-29.42-50.83-49.18-88-49.18c-57.34 0-104 46.65-104 103.1s46.66 103.1 104 103.1c40.63 0 75.53-23.65 92.63-57.7c11.11 33.39 42.29 57.7 79.37 57.7c46.31 0 84-37.69 84-83.1V265.7C496 131.9 391.6 19.98 263.4 16.12zM240 344c-48.53 0-88-39.47-88-87.1s39.47-87.1 88-87.1s88 39.47 88 87.1S288.5 344 240 344z"],
    "atom": [512, 512, [9883], "f5d2", "M478.9 128c-16.1-27.74-51.3-41.33-96.43-41.33c-9.305 0-19.16 .793-29.23 1.943C329.6 34.43 294.9 0 256 0S182.4 34.42 158.8 88.61c-10.07-1.15-19.92-1.941-29.23-1.941C84.42 86.67 49.22 100.3 33.12 128C13.69 161.5 26.27 208.6 61.62 255.1C26.27 303.4 13.69 350.5 33.12 384c16.1 27.74 51.3 41.33 96.43 41.33c9.305 0 19.16-.793 29.23-1.943C182.4 477.6 217.1 512 256 512s73.62-34.43 97.22-88.61c10.07 1.15 19.92 1.943 29.23 1.943c45.13 0 80.34-13.6 96.43-41.33c19.42-33.47 6.847-80.6-28.5-128C485.7 208.6 498.3 161.5 478.9 128zM382.5 102.7c40.72 0 70.02 11.84 82.5 33.33c15.67 27 4.718 66.35-24.85 107c-16.54-19.84-36.87-39.48-60.54-58.01c-4.294-29.63-11.22-56.95-20.22-81.11C367.2 103.2 374.1 102.7 382.5 102.7zM382.3 208.1c18.41 15.57 34.56 31.74 47.82 47.93c-13.25 16.19-29.41 32.37-47.82 47.93C383.8 288.4 384.7 272.4 384.7 256C384.7 239.6 383.8 223.6 382.3 208.1zM368.6 256c0 21.48-1.526 42.31-4.147 62.28c-16.08 12.24-33.45 23.97-52.15 34.71C293.8 363.6 274.8 372.8 256 380.6c-18.85-7.809-37.76-16.92-56.3-27.57c-18.7-10.74-36.07-22.47-52.15-34.71C144.9 298.3 143.4 277.5 143.4 256s1.526-42.31 4.147-62.28C163.6 181.5 181 169.7 199.7 159c18.54-10.65 37.45-19.76 56.3-27.57c18.85 7.809 37.75 16.92 56.3 27.57c18.7 10.74 36.07 22.47 52.15 34.71C367.1 213.7 368.6 234.5 368.6 256zM360.9 171.1c-12.79-9.047-26.28-17.78-40.56-25.97c-14.33-8.232-28.73-15.42-43.05-21.94c22.56-8.025 44.74-13.87 65.82-17.18C350.6 125.5 356.6 147.5 360.9 171.1zM256 16c31.32 0 60.09 29.07 80.74 74.84C311.2 95.17 283.9 103 256 114.1C228.1 103 200.8 95.17 175.3 90.84C195.9 45.07 224.7 16 256 16zM168.9 106c21.07 3.312 43.26 9.152 65.82 17.18C220.4 129.7 205.1 136.9 191.7 145.1c-14.28 8.199-27.77 16.93-40.56 25.97C155.4 147.5 161.4 125.5 168.9 106zM47.05 136c12.48-21.49 41.78-33.33 82.52-33.33c7.451 0 15.19 .4844 23.09 1.258c-8.999 24.16-15.93 51.48-20.22 81.11c-23.66 18.53-43.99 38.16-60.54 58.01C42.33 202.3 31.38 163 47.05 136zM129.7 303.9C111.2 288.4 95.09 272.2 81.84 255.1c13.25-16.19 29.41-32.36 47.82-47.93C128.2 223.6 127.3 239.6 127.3 256C127.3 272.4 128.2 288.4 129.7 303.9zM129.6 409.3c-40.73 0-70.03-11.84-82.5-33.33c-15.67-27-4.718-66.35 24.85-107c16.54 19.84 36.87 39.48 60.54 58.01c4.294 29.63 11.22 56.95 20.22 81.11C144.8 408.8 137 409.3 129.6 409.3zM151.1 340.9c12.79 9.047 26.28 17.78 40.56 25.97c14.33 8.232 28.73 15.42 43.05 21.94c-22.56 8.025-44.74 13.87-65.82 17.18C161.4 386.5 155.4 364.5 151.1 340.9zM256 496c-31.32 0-60.09-29.07-80.74-74.84C200.8 416.8 228.1 408.1 256 397.9c27.92 11.11 55.22 18.97 80.74 23.29C316.1 466.9 287.3 496 256 496zM343.1 405.1c-21.07-3.311-43.26-9.156-65.82-17.18c14.33-6.514 28.72-13.7 43.05-21.94c14.28-8.199 27.77-16.93 40.56-25.97C356.6 364.5 350.6 386.5 343.1 405.1zM464.1 376c-12.48 21.49-41.78 33.33-82.5 33.33c-7.455 0-15.2-.4844-23.1-1.26c8.997-24.16 15.92-51.48 20.22-81.11c23.66-18.53 43.99-38.17 60.54-58.01C469.7 309.6 480.6 349 464.1 376zM256 208C229.5 208 208 229.5 208 256S229.5 304 256 304s48-21.53 48-48S282.5 208 256 208zM256 288C238.3 288 223.1 273.7 223.1 256S238.3 224 256 224s32 14.33 32 32S273.7 288 256 288z"],
    "atom-simple": [448, 512, ["atom-alt"], "f5d3", "M224 208C197.5 208 175.1 229.5 175.1 256S197.5 304 224 304s48.02-21.53 48.02-48S250.5 208 224 208zM223.1 287.1c-17.68 0-32-14.33-32-32s14.32-32.03 32-32.03c17.68 0 32 14.36 32 32.03S241.7 287.1 223.1 287.1zM424.4 55.69C408.3 39.62 385.5 32 358.6 32c-38.75 .002-86.15 16.13-134.6 45.14C175.6 48.13 128.2 31.1 89.42 32c-26.93 .002-49.71 7.619-65.79 23.69C-15.59 94.9-4.277 173.9 44.93 256c-49.21 82.08-60.53 161.1-21.31 200.3C39.71 472.4 62.48 480 89.42 480c38.75 0 86.15-16.13 134.6-45.14C272.4 463.9 319.8 480 358.6 480c26.93 0 49.71-7.619 65.79-23.69C463.6 417.1 452.3 338.1 403.1 256C452.3 173.9 463.6 94.9 424.4 55.69zM358.6 48c23.53 0 41.85 6.395 54.47 19.01c32.49 32.48 22.06 100.1-19.54 173.5c-18.77-28.65-42.03-57.4-69.33-84.7c-27.31-27.3-56.07-50.29-84.73-69.06C282.1 62.33 324 48 358.6 48zM34.94 67.01C47.56 54.4 65.89 48 89.43 48c34.58 0 76.46 14.33 119.1 38.78C179.9 105.6 151.1 128.5 123.8 155.8C96.51 183.1 73.26 211.9 54.48 240.5C12.88 167.1 2.45 99.49 34.94 67.01zM89.42 464c-23.53 0-41.86-6.395-54.47-19.01c-32.49-32.48-22.06-100.1 19.54-173.5c18.77 28.65 42.03 57.4 69.33 84.7c27.31 27.3 56.07 50.29 84.73 69.06C165.9 449.7 124 464 89.42 464zM135.1 344.8C106.7 316.4 82.78 286 63.85 256C82.78 225.1 106.7 195.6 135.1 167.2c28.1-28.09 58.49-52.16 88.87-71.3c30.38 19.14 60.77 43.22 88.87 71.3C341.3 195.6 365.2 225.1 384.1 256c-18.93 30.04-42.82 60.39-71.28 88.84C284.8 372.9 254.4 397 224 416.1C193.6 397 163.2 372.9 135.1 344.8zM413.1 444.1C400.4 457.6 382.1 464 358.6 464c-34.59 0-76.47-14.33-119.1-38.78c28.67-18.77 57.43-41.77 84.73-69.06c27.3-27.29 50.56-56.04 69.33-84.7C435.1 344 445.6 412.5 413.1 444.1z"],
    "audio-description": [576, 512, [], "f29e", "M198.1 164.4C197.6 161.7 194.8 160 191.8 160S185.1 161.7 184.6 164.4l-87.8 176c-1.969 3.953-.375 8.766 3.578 10.73C101.6 351.7 102.8 352 104 352c2.938 0 5.766-1.625 7.156-4.422L140.9 288h102.1l29.86 59.58c2 3.969 6.812 5.562 10.73 3.578c3.953-1.984 5.547-6.797 3.578-10.73L198.1 164.4zM148.9 272l42.96-86.11L234.1 272H148.9zM512 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h448c35.35 0 64-28.65 64-64V96C576 60.65 547.3 32 512 32zM560 416c0 26.47-21.53 48-48 48H64c-26.47 0-48-21.53-48-48V96c0-26.47 21.53-48 48-48h448c26.47 0 48 21.53 48 48V416zM392 160h-64C323.6 160 320 163.6 320 168v176c0 4.422 3.594 8 8 8h64c52.94 0 96-43.06 96-96S444.9 160 392 160zM392 336H336v-160h56c44.13 0 80 35.89 80 80S436.1 336 392 336z"],
    "audio-description-slash": [640, 512, [], "e0a8", "M96 464c-26.47 0-48-21.53-48-48V131.8L32 119.1l0 296.9c0 35.35 28.65 64 64 64L486.1 480l-20.13-16H96zM544 48c26.47 0 48 21.53 48 48v284.2l16 12.72l.0001-296.9c0-35.35-28.65-64-64-64L153.9 32l20.13 16H544zM503.4 309.8C513.9 294.5 520 275.9 520 256c0-52.94-43.06-96-96-96l-63.1 .0002C355.6 160 352 163.6 352 168v21.45l16 12.72V176h56c44.13 0 80 35.89 80 80c0 16.17-4.9 31.19-13.19 43.79L503.4 309.8zM180.4 237l-51.58 103.4c-1.969 3.953-.375 8.766 3.578 10.73C133.6 351.7 134.8 352 136 352c2.938 0 5.766-1.625 7.156-4.422L172.9 288h71.66L224.4 272h-43.55L193.2 247.2L180.4 237zM636.1 497.7L12.99 1.73C11.53 .5664 9.771 0 8.025 0C5.674 0 3.336 1.029 1.738 3.012c-2.75 3.469-2.172 8.5 1.281 11.25l623.1 496C628.5 511.4 630.2 512 631.1 512c2.344 0 4.688-1.031 6.266-3.016C641 505.5 640.4 500.5 636.1 497.7z"],
    "austral-sign": [448, 512, [], "e0a9", "M317.9 240H440C444.4 240 448 243.6 448 248C448 252.4 444.4 256 440 256H324.7L358.8 336H440C444.4 336 448 339.6 448 344C448 348.4 444.4 352 440 352H365.6L415.4 468.9C417.1 472.9 415.2 477.6 411.1 479.4C407.1 481.1 402.4 479.2 400.6 475.1L348.2 352H99.81L47.36 475.1C45.63 479.2 40.93 481.1 36.87 479.4C32.8 477.6 30.91 472.9 32.64 468.9L82.42 352H8C3.582 352 .0003 348.4 .0003 344C.0003 339.6 3.582 336 8 336H89.23L123.3 256H8C3.582 256 0 252.4 0 248C0 243.6 3.582 240 8 240H130.1L216.6 36.86C217.9 33.91 220.8 32 224 32C227.2 32 230.1 33.91 231.4 36.86L317.9 240zM300.5 240L224 60.42L147.5 240H300.5zM140.7 256L106.6 336H341.4L307.3 256H140.7z"],
    "avocado": [512, 512, [], "e0aa", "M512 142.3c0-72.05-56.44-142.3-140.5-142.3c-39.21 0-78.71 15.73-108.1 45.17C232.4 76.31 192.1 97.3 150.6 108.9C115.4 118.6 .0005 170.8 .0005 306.7c0 113.8 92.76 205.3 205.1 205.3c40.2 0 160.1-21.1 196.4-148.1C439.8 230.2 512 246.4 512 142.3zM495.1 142.2c0 92.07-71.42 82.92-109.9 217.2C370.6 413.6 313.5 496 205.1 496c-47.77 0-188.1-38.1-188.1-189.3c0-88.62 60.35-160.9 138.8-182.4C281.2 89.72 275 16 371.5 16C449.6 16 495.1 82.39 495.1 142.2zM246.7 184c-64.68 0-126.7 62.16-126.7 127.4c0 39.64 27.32 80.82 79.14 80.82c64.75 0 128.2-61.06 128.2-127.6C327.4 203.1 278.8 184 246.7 184zM311.5 264.7c0 56.41-55.24 111.4-111.2 111.4c-48.77 0-64.4-38.82-64.4-64.68c0-56.32 55.2-111.4 111.3-111.4C296 199.1 311.5 238.9 311.5 264.7z"],
    "award": [384, 512, [], "f559", "M167.3 406.7c-4.188-1.672-8.75 .2969-10.44 4.375l-32.72 79.95C122.3 495.4 118.3 495.9 117.1 496c-1.156 .0469-5.281-.0938-7.5-4.375l-24.16-47.69c-1.625-3.219-5.156-4.969-8.688-4.234l-51.13 10.23c-4.188 .8438-6.812-1.641-7.719-2.719c-.9062-1.109-2.875-4.094-1.281-8.094l31.53-79.36c1.625-4.109-.375-8.75-4.469-10.39c-4-1.531-8.75 .3594-10.41 4.484l-31.53 79.36c-3.25 8.188-1.781 17.48 3.875 24.25c5.656 6.75 14.5 9.914 23.12 8.148l45.19-9.035l21.43 42.27C99.49 507 107.6 512 116.7 512c.3438 0 .6641-.0117 1.008-.0273c9.5-.3906 17.65-6.098 21.24-14.88l32.72-79.95C173.3 413 171.4 408.4 167.3 406.7zM249.9 361.3c6.602 0 13.5 .752 20.06 .752c6.566 0 12.78-.7559 18.01-3.775c13.98-8.088 17.53-30.04 28.88-41.39c11.35-11.35 33.3-14.88 41.39-28.87c7.98-13.79 .1658-34.54 4.373-50.29C366.7 222.5 383.1 208.5 383.1 192c0-16.5-17.27-30.52-21.34-45.73c-4.207-15.75 3.612-36.5-4.365-50.29c-8.086-13.98-30.03-17.52-41.38-28.87c-11.35-11.35-14.89-33.3-28.87-41.39c-5.227-3.025-11.46-3.785-18.03-3.785c-6.547 0-13.43 .748-20.03 .748c-4.258 0-8.391-.3125-12.23-1.338C222.5 17.27 208.5 0 192 0C175.5 0 161.5 17.27 146.3 21.34c-3.832 1.023-7.957 1.336-12.21 1.336c-6.602 0-13.5-.752-20.06-.752c-6.57 0-12.8 .7602-18.01 3.782C82 33.79 78.46 55.74 67.11 67.08C55.77 78.43 33.81 81.97 25.72 95.95C17.74 109.7 25.56 130.5 21.35 146.2C17.27 161.5 .0008 175.5 .0008 192c0 16.5 17.27 30.52 21.34 45.73c4.207 15.75-3.615 36.5 4.361 50.29C33.8 302 55.74 305.5 67.08 316.9c11.35 11.35 14.89 33.3 28.88 41.4c5.227 3.023 11.45 3.777 18.03 3.777c6.543 0 13.43-.7461 20.03-.7461c4.258 0 8.391 .3105 12.23 1.338C161.5 366.7 175.5 384 192 384c16.5 0 30.52-17.27 45.74-21.34C241.6 361.6 245.7 361.3 249.9 361.3zM209.9 359.3C203.4 363.6 196.7 368 192 368c-4.695 0-11.41-4.42-17.9-8.693c-6.914-4.551-14.75-9.707-23.73-12.11c-4.797-1.283-9.996-1.881-16.36-1.881c-3.594 0-7.27 .1953-10.94 .3984c-3.059 .1699-6.113 .3477-9.09 .3477c-4.844 0-8.121-.5313-10.01-1.625c-3.828-2.217-7.387-9.299-10.83-16.15c-3.77-7.504-8.039-16.01-14.75-22.71C71.7 298.9 63.19 294.6 55.69 290.8C48.84 287.4 41.76 283.8 39.54 280C37.41 276.3 37.85 268.5 38.27 260.9C38.74 252.5 39.28 242.9 36.8 233.6c-2.398-8.979-7.555-16.81-12.11-23.72C20.42 203.4 16 196.7 16 192c0-4.697 4.422-11.41 8.695-17.91c4.551-6.91 9.707-14.74 12.11-23.72c2.48-9.277 1.949-18.84 1.48-27.29C37.86 115.5 37.43 107.7 39.57 103.1c2.219-3.83 9.297-7.387 16.14-10.83C63.21 89.37 71.72 85.1 78.43 78.4c6.707-6.705 10.98-15.21 14.75-22.71C96.61 48.84 100.2 41.76 104 39.54c1.891-1.092 5.16-1.623 9.996-1.623c2.98 0 6.039 .1797 9.102 .3496C126.8 38.47 130.5 38.67 134.1 38.67c6.359 0 11.55-.5977 16.34-1.879c8.98-2.398 16.81-7.555 23.72-12.11C180.6 20.42 187.3 16 192 16c4.699 0 11.41 4.42 17.91 8.695c6.91 4.549 14.75 9.705 23.72 12.11c4.797 1.283 9.996 1.881 16.36 1.881c3.594 0 7.266-.1953 10.93-.4004c3.059-.1699 6.113-.3477 9.094-.3477c4.844 0 8.121 .5332 10.01 1.625c3.828 2.219 7.387 9.299 10.83 16.15c3.77 7.504 8.039 16.01 14.75 22.71c6.703 6.707 15.21 10.98 22.71 14.75c6.844 3.441 13.93 6.998 16.14 10.83c2.133 3.689 1.695 11.52 1.273 19.1c-.4687 8.443-1.004 18.01 1.477 27.3c2.398 8.975 7.555 16.8 12.1 23.71C363.6 180.6 368 187.3 368 192c0 4.697-4.422 11.41-8.695 17.91c-4.547 6.91-9.703 14.74-12.11 23.72c-2.48 9.279-1.949 18.85-1.48 27.29c.4219 7.578 .8594 15.42-1.277 19.11c-2.219 3.832-9.301 7.391-16.15 10.83c-7.504 3.768-16.01 8.039-22.72 14.75c-6.699 6.701-10.97 15.2-14.74 22.7c-3.441 6.85-7 13.93-10.83 16.15c-1.891 1.092-5.16 1.625-9.996 1.625c-2.98 0-6.039-.1797-9.102-.3516c-3.676-.2031-7.359-.4004-10.96-.4004c-6.355 0-11.55 .5957-16.34 1.877C224.6 349.6 216.8 354.8 209.9 359.3zM279.1 192c0-48.7-39.39-88-87.1-88S104 143.3 104 192c0 48.58 39.39 88 87.1 88S279.1 240.6 279.1 192zM192 264C152.3 264 120 231.7 120 192S152.3 120 192 120S264 152.3 264 192S231.7 264 192 264zM350.8 353.9c-1.625-4.125-6.375-6.078-10.41-4.484c-4.094 1.641-6.094 6.281-4.469 10.39l31.53 79.34c1.594 4-.375 6.984-1.281 8.094c-.9062 1.078-3.562 3.562-7.719 2.719l-51.13-10.23c-3.438-.7344-7.062 1.016-8.688 4.234l-24.16 47.67C272.2 495.9 268.1 496 266.9 496c-1.188-.0625-5.25-.5625-7.062-4.969l-32.72-79.95c-1.719-4.078-6.344-6.062-10.44-4.375c-4.094 1.672-6.031 6.344-4.375 10.44l32.72 79.95c3.594 8.781 11.74 14.49 21.24 14.88C266.6 511.1 266.1 512 267.3 512c9.094 0 17.2-4.957 21.35-13.14l21.43-42.28l45.19 9.035c8.562 1.688 17.47-1.414 23.12-8.148c5.656-6.766 7.125-16.06 3.875-24.25L350.8 353.9z"],
    "award-simple": [384, 512, [], "e0ab", "M192 104C143.4 104 104 143.3 104 192c0 48.58 39.39 88 87.1 88S279.1 240.6 279.1 192C279.1 143.3 240.6 104 192 104zM192 264C152.3 264 120 231.7 120 192S152.3 120 192 120S264 152.3 264 192S231.7 264 192 264zM384 192c0-16.5-17.27-30.52-21.34-45.73c-4.207-15.75 3.607-36.5-4.369-50.29c-8.086-13.98-30.03-17.52-41.37-28.87c-11.35-11.35-14.89-33.29-28.87-41.39c-5.227-3.025-11.46-3.788-18.04-3.788c-6.547 0-13.43 .748-20.03 .748c-4.258 0-8.39-.3125-12.23-1.338C222.5 17.27 208.5 0 192 0C175.5 0 161.5 17.27 146.3 21.34c-3.832 1.023-7.957 1.336-12.21 1.336c-6.602 0-13.5-.752-20.06-.752c-6.57 0-12.8 .7643-18.02 3.786C81.1 33.79 78.46 55.74 67.11 67.08c-11.35 11.35-33.3 14.88-41.39 28.87C17.74 109.7 25.55 130.5 21.35 146.2C17.27 161.5 0 175.5 0 192c0 16.5 17.27 30.52 21.34 45.73c4.207 15.75-3.611 36.5 4.365 50.29C33.8 302 55.74 305.5 67.08 316.9c11.35 11.35 14.88 33.29 28.86 41.39c5.227 3.023 11.47 3.788 18.04 3.788c6.543 0 13.43-.7461 20.03-.7461c4.258 0 8.39 .3105 12.23 1.338C161.5 366.7 175.5 384 192 384c16.5 0 30.52-17.27 45.74-21.34c3.832-1.025 7.96-1.336 12.21-1.336c6.602 0 13.5 .752 20.06 .752c6.566 0 12.79-.7643 18.02-3.784c13.98-8.088 17.52-30.03 28.87-41.38c11.35-11.35 33.29-14.88 41.39-28.86c7.98-13.79 .1699-34.54 4.377-50.29C366.7 222.5 384 208.5 384 192zM359.3 209.9c-4.547 6.91-9.703 14.74-12.11 23.72c-2.48 9.279-1.949 18.85-1.48 27.29c.4219 7.578 .8594 15.42-1.277 19.11c-2.219 3.832-9.301 7.391-16.15 10.83c-7.504 3.768-16.01 8.039-22.72 14.75c-6.699 6.701-10.97 15.2-14.74 22.7c-3.441 6.85-7 13.93-10.83 16.15c-1.891 1.092-5.16 1.625-9.996 1.625c-2.98 0-6.039-.1797-9.102-.3516c-3.676-.2031-7.359-.4004-10.96-.4004c-6.355 0-11.55 .5957-16.34 1.877c-8.977 2.398-16.81 7.557-23.72 12.11C203.4 363.6 196.7 368 192 368c-4.695 0-11.41-4.42-17.9-8.693c-6.914-4.551-14.75-9.707-23.73-12.11c-4.797-1.283-9.996-1.881-16.36-1.881c-3.594 0-7.27 .1953-10.94 .3984c-3.059 .1699-6.113 .3477-9.09 .3477c-4.844 0-8.121-.5313-10.01-1.625c-3.828-2.217-7.387-9.299-10.83-16.15c-3.77-7.504-8.039-16.01-14.75-22.71C71.7 298.9 63.19 294.6 55.69 290.8C48.84 287.4 41.76 283.8 39.54 280C37.41 276.3 37.85 268.5 38.27 260.9C38.74 252.5 39.28 242.9 36.8 233.6c-2.398-8.979-7.555-16.81-12.11-23.72C20.42 203.4 16 196.7 16 192c0-4.697 4.422-11.41 8.695-17.91c4.551-6.91 9.707-14.74 12.11-23.72c2.48-9.277 1.949-18.84 1.48-27.29C37.86 115.5 37.43 107.7 39.57 103.1c2.219-3.83 9.297-7.387 16.14-10.83C63.21 89.37 71.72 85.1 78.43 78.4c6.707-6.705 10.98-15.21 14.75-22.71C96.61 48.84 100.2 41.76 104 39.54c1.891-1.092 5.16-1.623 9.996-1.623c2.98 0 6.039 .1797 9.102 .3496C126.8 38.47 130.5 38.67 134.1 38.67c6.359 0 11.55-.5977 16.34-1.879c8.98-2.398 16.81-7.555 23.72-12.11C180.6 20.42 187.3 16 192 16c4.699 0 11.41 4.42 17.91 8.695c6.91 4.549 14.75 9.705 23.72 12.11c4.797 1.283 9.996 1.881 16.36 1.881c3.594 0 7.266-.1953 10.93-.4004c3.059-.1699 6.113-.3477 9.094-.3477c4.844 0 8.121 .5332 10.01 1.625c3.828 2.219 7.387 9.299 10.83 16.15c3.77 7.504 8.039 16.01 14.75 22.71c6.703 6.707 15.21 10.98 22.71 14.75c6.844 3.441 13.93 6.998 16.14 10.83c2.133 3.689 1.695 11.52 1.273 19.1c-.4687 8.443-1.004 18.01 1.477 27.3c2.398 8.975 7.555 16.8 12.1 23.71C363.6 180.6 368 187.3 368 192C368 196.7 363.6 203.4 359.3 209.9zM286.4 384.2c-4.312 .875-7.125 5.094-6.25 9.422l21 102.6l-105.4-55.23c-2.312-1.219-5.125-1.219-7.438 0L83.22 495.9l20.62-102.3c.875-4.328-1.938-8.547-6.25-9.422c-4.531-.9375-8.562 1.953-9.438 6.266l-20.59 102.2c-1.281 5.984 .9062 12.08 5.688 15.88c4.719 3.781 11.09 4.516 17.03 1.812L192 457l102 53.45C296.2 511.5 298.5 512 300.8 512c3.531 0 7-1.188 9.906-3.484c4.781-3.797 6.969-9.891 5.719-15.78l-20.62-102.3C294.9 386.1 290.8 383.3 286.4 384.2z"],
    "axe": [640, 512, [129683], "f6b2", "M294.8 273.8l-215.2 215.2C75.04 493.5 69.03 496 62.62 496c0 0 .0313 0 0 0c-6.406 0-12.45-2.5-16.99-7.031l-22.63-22.62c-9.375-9.359-9.375-24.59 0-33.95l215.2-215.2c3.125-3.125 3.125-8.188 0-11.31c-3.125-3.125-8.188-3.125-11.31 0l-215.2 215.2c-15.59 15.59-15.59 40.98 0 56.58l22.63 22.62C41.88 507.8 51.93 512 62.62 512c.0313 0 0 0 0 0c10.69 0 20.74-4.172 28.27-11.72l215.2-215.2c3.125-3.125 3.125-8.188 0-11.31C302.1 270.7 297.9 270.7 294.8 273.8zM525.7 160l-52.94-52.94l29.82-29.82c12.5-12.5 12.5-32.76-.0001-45.26l-22.62-22.62C473.8 3.125 465.6 0 457.4 0c-8.188 0-16.38 3.125-22.63 9.374l-29.82 29.82l-29.81-29.81c-6.25-6.25-14.44-9.375-22.63-9.375s-16.37 3.125-22.63 9.375L233.4 105.9C220.9 118.4 220.9 138.6 233.4 151.1l150.6 150.6L383.1 400c0 8.837 7.164 16 16 16l16.01 .0032C539.7 416 640 315.7 640 192V176C640 167.2 632.8 160 623.1 160L525.7 160zM446.1 20.69C449.1 17.66 453.1 16 457.4 16c4.277 0 8.293 1.664 11.32 4.686l22.62 22.62c6.238 6.238 6.238 16.39 0 22.63l-29.82 29.82L416.2 50.5L446.1 20.69zM623.1 192c0 114.7-93.31 208-208 208h-16V295.1L244.7 139.8C241.7 136.8 239.1 132.8 239.1 128.5s1.664-8.289 4.684-11.31l96.5-96.48C344.2 17.66 348.2 16 352.5 16c4.27 0 8.289 1.664 11.31 4.688L519.1 176h104.9V192zM440.1 350.4c.7813 3.797 4.125 6.406 7.844 6.406c.5313 0 1.063-.0469 1.594-.1562c66.13-13.48 117.6-64.92 131-131c.875-4.328-1.906-8.547-6.25-9.438c-4.25-.9062-8.563 1.922-9.438 6.25c-12.19 59.81-58.72 106.3-118.5 118.5C442.1 341.8 439.3 346.1 440.1 350.4z"],
    "axe-battle": [512, 512, [], "f6b3", "M87.31 16.19C89.34 16.75 91.88 18.78 92.78 22.81c11.44 50.15 45.5 89.59 88.87 102.9c4.219 1.406 8.688-1.047 10-5.297c1.281-4.219-1.094-8.687-5.312-9.984C148.4 98.79 118.6 63.84 108.4 19.23C106.3 10.09 99.81 2.999 91.5 .7493c-7.75-2.109-15.56 .3125-21.25 6.281C25.59 54.23 0 121.6 0 192s25.59 137.8 70.25 184.1c4.312 4.578 9.938 7.031 15.75 7.031c1.813 0 3.657-.2343 5.501-.7343c8.312-2.25 14.78-9.343 16.91-18.5c10.16-44.59 40.03-79.54 77.93-91.2c4.219-1.297 6.594-5.765 5.312-9.984c-1.312-4.234-5.781-6.594-10-5.297c-43.37 13.33-77.43 52.76-88.84 102.9c-.9375 4.047-3.469 6.078-5.5 6.64c-1.875 .4687-3.812-.1094-5.438-1.844C40 321.7 16 258.3 16 192s24-129.7 65.88-173.1C83.5 16.28 85.44 15.73 87.31 16.19zM512 166.8L511.4 161.3c-6.324-59.45-30.79-114.3-68.9-154.3c-5.703-5.1-13.77-8.373-21.47-6.219c-8.32 2.297-14.77 9.359-16.86 18.45c-10.28 44.57-40.36 79.53-78.56 91.2c-4.207 1.297-6.578 5.765-5.297 9.984c1.309 4.25 5.828 6.64 9.969 5.328c43.63-13.34 77.88-52.78 89.41-102.9c.9297-3.1 3.488-6.047 5.547-6.609c1.461-.4219 3.582-.4062 5.734 1.828c34.53 36.33 57.12 85.71 63.91 139.6L428.8 192l66.13 34.39c-6.793 53.86-29.39 103.2-63.91 139.6c-2.121 2.234-4.242 2.25-5.734 1.844c-2.059-.5625-4.617-2.609-5.547-6.607C408.2 311.1 373.9 271.6 330.3 258.3c-4.141-1.281-8.66 1.109-9.969 5.328c-1.281 4.219 1.09 8.685 5.297 9.982c38.21 11.67 68.28 46.62 78.56 91.2c2.09 9.093 8.539 16.16 16.86 18.45c1.871 .5156 3.922 .7637 5.789 .7637c5.828 0 11.35-2.436 15.68-6.998c38.11-40.06 62.58-94.87 68.9-154.3L512 217.3L463.4 192L512 166.8zM256 32c-17.67 0-32 14.33-32 32v431.1C224 504.8 231.2 512 240 512h32c8.836 0 16-7.164 16-15.1V64C288 46.33 273.7 32 256 32zM272 496h-32V64.01c0-8.822 7.176-15.1 16-15.1s16 7.178 16 15.1V496z"],
    "b": [320, 512, [98], "42", "M236.1 246.4C276.4 229.1 304 189.7 304 144C304 82.25 253.8 32 192 32H8C3.578 32 0 35.58 0 40v432C0 476.4 3.578 480 8 480h192c66.17 0 120-53.83 120-120C320 306.8 284.1 262.1 236.1 246.4zM16 48H192c52.94 0 96 43.06 96 96s-43.06 96-96 96H16V48zM200 464H16V256h184c57.34 0 104 46.66 104 104S257.3 464 200 464z"],
    "baby": [448, 512, [], "f77c", "M224 159.1c44.25 0 79.99-35.75 79.99-79.1S268.3 0 224 0C179.8 0 144 35.75 144 79.1S179.8 159.1 224 159.1zM223.1 16c35.29 0 64 28.71 64 64s-28.71 64-64 64c-35.29 0-64.01-28.71-64.01-64S188.7 16 223.1 16zM320 304l.0272-53.71c13.25-5.867 26.22-12.48 38.34-21.04l40.63-28.5C417.1 188 421.4 163.1 408.7 145C400.9 133.9 388.6 128 376 128c-7.953 0-15.98 2.357-23.01 7.25l-40.63 28.5c-26.32 18.5-57.35 27.75-88.38 27.75c-31.04 0-62.07-9.25-88.38-27.75l-40.63-28.5c-7-4.875-15.01-7.215-22.93-7.215c-12.6 0-24.99 5.914-32.82 16.96C26.59 163.1 30.96 188 48.97 200.8l40.63 28.5C101.7 237.7 114.7 244.3 128 250.2L128 295.1c0 .0098 0-.0098 0 0L128 332.4l-51.46 51.27c-15.04 14.92-16.76 38.91-4.031 55.8l41.8 55.48C122.5 505.8 135 512 148.7 512c9.316 0 18.14-2.953 25.61-8.531c9.195-6.828 15.14-16.83 16.76-28.12c1.598-11.3-1.312-22.53-8.16-31.64l-19.14-25.38L194.9 392h58.17l31.18 26.33l-19.1 25.38c-6.875 9.109-9.781 20.34-8.188 31.64c1.625 11.3 7.562 21.3 16.75 28.12C281.2 509 290 512 299.3 512c13.63 0 26.18-6.219 34.37-17.06l41.77-55.48c12.75-16.89 11.03-40.88-3.973-55.8L320 332.4V304zM141.9 415.9l28.23 37.47c4.281 5.703 6.098 12.7 5.098 19.75c-1.004 7.047-4.723 13.3-10.48 17.58c-11.6 8.672-29.02 6.047-37.58-5.344l-41.84-55.48c-7.945-10.55-6.883-25.52 2.531-34.83l46.47-46.26l46.11 34.59L141.9 415.9zM250.7 376H197.3L144 336v-32h160v32L250.7 376zM360.2 395c9.379 9.312 10.44 24.28 2.5 34.83L320.9 485.3c-8.535 11.39-25.98 14.02-37.57 5.328c-5.75-4.266-9.473-10.52-10.47-17.56s.8125-14.05 5.129-19.75l28.2-37.47l-38.55-32.54l46.11-34.59L360.2 395zM313.5 235.7l-9.523 4.217V288H144V239.8L134.5 235.6C119.8 229.1 108.5 222.9 98.78 216.2L58.22 187.7c-10.8-7.646-13.43-22.7-5.945-33.45c4.531-6.395 11.92-10.21 19.77-10.21c4.938 0 9.703 1.502 13.74 4.312l40.62 28.49C154.9 196.9 188.7 207.5 223.1 207.5c35.3 0 69.05-10.6 97.57-30.65l40.59-28.47C366.3 145.5 371 144 376 144c7.816 0 15.16 3.814 19.61 10.14c7.586 10.89 4.973 25.92-5.805 33.51l-40.67 28.53C339.5 222.1 328.2 229.2 313.5 235.7z"],
    "baby-carriage": [512, 512, ["carriage-baby"], "f77d", "M130.1 35.47C123.1 25.37 110.3 22.65 101.4 28.82C51.59 63.19 18.4 119.8 16.14 184.3C15.98 188.7 12.28 192.2 7.86 191.1C3.444 191.8-.0096 188.1 .1453 183.7C2.593 113.1 38.51 52.78 92.28 15.65C109.6 3.671 132 10.2 143.2 26.36L249.3 179.4C251.8 183.1 250.9 188.1 247.2 190.6C243.6 193.1 238.6 192.2 236.1 188.6L130.1 35.47zM128 464C128 490.5 106.5 512 80 512C53.49 512 32 490.5 32 464C32 437.5 53.49 416 80 416C106.5 416 128 437.5 128 464zM80 432C62.33 432 48 446.3 48 464C48 481.7 62.33 496 80 496C97.67 496 112 481.7 112 464C112 446.3 97.67 432 80 432zM416 464C416 490.5 394.5 512 368 512C341.5 512 320 490.5 320 464C320 437.5 341.5 416 368 416C394.5 416 416 437.5 416 464zM368 432C350.3 432 336 446.3 336 464C336 481.7 350.3 496 368 496C385.7 496 400 481.7 400 464C400 446.3 385.7 432 368 432zM448 232C448 232.6 447.9 233.1 447.8 233.7C425.4 337.9 333.8 416 224 416C114.2 416 22.63 337.9 .1795 233.7C-.3296 231.3 .257 228.9 1.776 226.1C3.294 225.1 5.582 224 8 224H432V144C432 126.3 446.3 112 464 112H504C508.4 112 512 115.6 512 120C512 124.4 508.4 128 504 128H464C455.2 128 448 135.2 448 144V232zM224 400C322.5 400 405.5 332.2 429.9 240H18.14C42.49 332.2 125.5 400 224 400H224z"],
    "backpack": [448, 512, [127890], "f5d4", "M320 80h-16V40C304 17.94 286.1 0 264 0h-80C161.9 0 144 17.94 144 40V80H128c-70.69 0-128 57.31-128 128V448c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V208C448 137.3 390.7 80 320 80zM160 40C160 26.77 170.8 16 184 16h80C277.2 16 288 26.77 288 40V80H160V40zM352 496H96v-104h256V496zM352 376H96V352c0-26.47 21.53-48 48-48h160c26.47 0 48 21.53 48 48V376zM432 448c0 26.47-21.53 48-48 48h-16V352c0-35.35-28.65-64-64-64h-160c-35.35 0-64 28.65-64 64v144H64c-26.47 0-48-21.53-48-48V208C16 146.2 66.24 96 128 96h192c61.76 0 112 50.24 112 112V448zM312 184h-176C131.6 184 128 187.6 128 192s3.578 8 8 8h176C316.4 200 320 196.4 320 192S316.4 184 312 184z"],
    "backward": [512, 512, [9194], "f04a", "M223.8 64c-7.002 0-14.15 2.305-20.29 7.406L11.44 231.4c-15.25 12.87-15.25 36.37 0 49.24l192 159.1C209.6 445.7 216.8 448 223.8 448c16.5 0 32.22-12.81 32.22-32.03v-319.9C255.1 76.81 240.3 64 223.8 64zM239.1 415.1C239.1 426 231.7 432 223.8 432c-3.709 0-7.098-1.25-10.05-3.699l-191.1-159.9C18.05 265.3 16 260.9 16 256c0-4.859 2.045-9.26 5.68-12.33L213.7 83.72c2.971-2.467 6.36-3.717 10.07-3.717c7.973 0 16.22 5.994 16.22 16.03V415.1zM479.8 64c-7.002 0-14.14 2.305-20.29 7.406l-152.6 127.1c-1.824 1.52-2.879 3.771-2.879 6.146c0 6.781 7.911 10.49 13.12 6.148l152.6-127.1c2.971-2.467 6.36-3.717 10.07-3.717c7.973 0 16.22 5.994 16.22 16.03v319.9c0 10.03-8.245 16.03-16.22 16.03c-3.709 0-7.098-1.25-10.05-3.699l-152.6-127.1c-5.211-4.34-13.12-.6348-13.12 6.146c0 2.375 1.055 4.627 2.879 6.146l152.6 127.1c6.145 5.1 13.4 7.398 20.4 7.398C496.4 447.1 512 435.2 512 415.1V96.03C512 76.81 496.3 64 479.8 64z"],
    "backward-fast": [512, 512, [9198, "fast-backward"], "f049", "M8 447.1c4.422 0 8-3.594 8-7.1V71.1C16 67.59 12.42 64 8 64S0 67.59 0 71.1V439.1C0 444.4 3.578 447.1 8 447.1zM241.6 438.1c11.31 9.594 26.69 11.72 40.19 5.437c13.7-6.344 22.22-19.78 22.22-35.12v-306.6c0-15.34-8.516-28.78-22.22-35.12C276.7 65.16 271.2 64 265.9 64C257.2 64 248.6 67.06 241.6 72.1L61.5 226.3c-8.562 7.406-13.48 18.22-13.48 29.66s4.922 22.25 13.53 29.69L241.6 438.1zM71.92 238.5l180-153.3c6.594-5.594 15.2-6.812 23.11-3.125c8.109 3.75 12.94 11.47 12.94 20.62v306.6c0 9.156-4.828 16.87-12.94 20.62c-3.031 1.406-6.172 2.094-9.266 2.094c-4.953 0-9.781-1.781-13.84-5.219l-180-153.3C66.91 269.2 64.02 262.8 64.02 255.1C64.02 249.2 66.91 242.8 71.92 238.5zM483.1 429.9c-7.859 3.656-16.48 2.469-23.11-3.125l-118.8-101.1c-3.344-2.844-8.422-2.437-11.28 .9062c-2.859 3.375-2.453 8.406 .9062 11.28l118.8 101.1c11.31 9.594 26.72 11.72 40.19 5.437C503.5 438.1 512 424.6 512 409.3v-306.6c0-15.34-8.516-28.78-22.22-35.12C484.6 65.16 479.2 64 473.8 64c-8.703 0-17.27 3.062-24.27 8.1l-118.8 101.1c-3.359 2.875-3.766 7.906-.9062 11.28c2.859 3.344 7.938 3.75 11.28 .9062l118.8-101.1c6.594-5.594 15.23-6.812 23.12-3.125C491.2 85.81 496 93.53 496 102.7v306.6C496 418.5 491.2 426.2 483.1 429.9z"],
    "backward-step": [320, 512, ["step-backward"], "f048", "M8 64C3.594 64 0 67.59 0 72v368C0 444.4 3.594 448 8 448s8-3.594 8-8V72C16 67.59 12.41 64 8 64zM287.8 64c-7.002 0-14.16 2.305-20.31 7.406l-192 159.1c-15.25 12.87-15.25 36.37 0 49.24l192 159.1C273.6 445.7 280.8 448 287.8 448c16.5 0 32.2-12.81 32.2-32.03v-319.9C319.1 76.81 304.3 64 287.8 64zM303.1 415.1c0 10.03-8.245 16.01-16.22 16.01c-3.709 0-7.098-1.25-10.05-3.699L85.78 268.4C82.06 265.3 80.02 260.9 80.02 256c0-4.859 2.045-9.26 5.68-12.33l192-159.1C280.7 81.25 284.1 80 287.8 80c7.973 0 16.22 5.98 16.22 16.01V415.1z"],
    "bacon": [576, 512, [129363], "f7e5", "M564.7 99.68l-77.83-86.8c-11.27-12.6-28.83-16.33-43.69-9.518l-92.75 42.99C299.3 70.05 257.1 110.4 228.3 162.1L207.7 200.7C180.6 250.3 140.9 288.2 92.94 310.5l-68.88 31.94c-11.86 5.486-20.28 16.52-23.09 30.23c-2.938 14.35 .9062 29.18 10.31 39.65l77.83 86.8C96.64 507.5 106.1 512 117.5 512c5.188 0 10.41-1.109 15.33-3.375l92.75-42.99c51.13-23.69 93.34-64.03 122.1-116.6l20.66-37.76c27.11-49.56 66.8-87.5 114.8-109.8l68.88-31.94c11.86-5.486 20.28-16.52 23.09-30.23C577.1 124.1 574.1 110.1 564.7 99.68zM16.64 375.9c1.797-8.689 6.938-15.6 14.14-18.94l68.88-31.93c51.09-23.71 93.31-64.01 122.1-116.6l20.66-37.76c27.11-49.57 66.81-87.53 114.8-109.8l92.75-42.99c8.578-3.985 18.41-1.75 25.06 5.673l39.18 43.69l-102.5 47.54c-51.09 23.69-93.3 63.1-122.1 116.6L268.9 269.2c-27.11 49.57-66.8 87.53-114.8 109.8l-106.9 49.53l-24.06-26.84C17.15 394.9 14.72 385.3 16.64 375.9zM545.2 155l-68.88 31.93c-51.09 23.71-93.31 64.01-122.1 116.6l-20.66 37.76c-27.11 49.57-66.81 87.53-114.8 109.8l-92.75 42.99c-8.547 3.985-18.41 1.75-25.06-5.673l-42.59-47.5l102.4-47.46c51.14-23.71 93.36-64.03 122.1-116.6l20.66-37.76c27.11-49.57 66.8-87.52 114.8-109.8l106.1-49.62l27.49 30.66c6.031 6.72 8.469 16.33 6.547 25.74C557.6 144.8 552.4 151.7 545.2 155z"],
    "bacteria": [640, 512, [], "e059", "M128 191.1c-17.67 0-32 14.33-32 32C96 241.7 110.3 256 128 256s32-14.33 32-32C160 206.3 145.7 191.1 128 191.1zM127.1 239.1c-8.822 0-16-7.177-16-15.1S119.2 208 128 208S144 215.2 144 224S136.8 239.1 127.1 239.1zM208 120c-13.22 0-24 10.77-24 24S194.8 168 208 168S232 157.2 232 144S221.2 120 208 120zM208 152c-4.406 0-8-3.594-8-8S203.6 136 208 136S216 139.6 216 144S212.4 152 208 152zM632.7 250.7L607.4 248.5c.0684-.7988 .2266-1.568 .2891-2.369c1.9-24.97-7.984-47.7-24.63-63.64L595.3 166c2.664-3.532 1.912-8.547-1.631-11.19c-3.543-2.594-8.557-1.891-11.22 1.656l-12.07 16.18c-10.73-6.762-23.03-11.38-36.6-12.41c-12.54-.9629-24.49 1.266-35.44 5.578l-8.672-20.55c-1.691-4.078-6.457-5.953-10.5-4.281c-4.107 1.719-6.02 6.406-4.295 10.47l9.174 21.74c-16.34 10.61-28.7 26.84-33.87 46.39L424.4 216.1c-4.578-.7031-8.434 2.484-9.061 6.844c-.5957 4.375 2.477 8.406 6.865 9l25.14 3.408c-2.264 24.31-13.62 45.57-30.61 60.86l-16.14-20.75c-2.727-3.5-7.773-4.109-11.25-1.422c-3.51 2.719-4.137 7.734-1.41 11.23l16.02 20.59c-12.61 7.912-27.13 13.16-42.99 14.38c-5.398 .4121-10.61 1.379-15.63 2.785l-11.31-24.66c-1.848-4.029-6.738-5.764-10.62-3.951C319.4 296.3 317.6 301 319.5 305l10.99 23.95c-21.14 10.88-36.54 30.73-41.61 54.18L264.8 380.7c-4.262-.4062-8.338 2.734-8.807 7.125c-.4395 4.391 2.758 8.328 7.146 8.781l23.81 2.471c-.0039 .2949-.082 .5703-.082 .8652c0 2.076 .0781 4.15 .2363 6.227c1.734 22.48 12.69 41.97 28.81 55.32l-15.16 20.35c-2.633 3.545-1.881 8.561 1.662 11.19c3.523 2.598 8.541 1.949 11.25-1.656l15.62-20.96c13.05 6.986 28.12 10.6 43.99 9.383c7.223-.5527 14.32-1.475 21.35-2.598l5.029 28.23c.2441 1.379 2.496 7.617 9.309 6.484c4.357-.7656 7.273-4.922 6.49-9.281l-5.096-28.61c21.16-4.742 41.23-12.03 59.95-21.56l14.26 25.88c1.01 1.846 5.355 6.189 10.88 3.156c3.889-2.125 5.299-7 3.166-10.88l-14.21-25.78c18.43-10.91 35.36-23.99 50.33-39.04l21.52 19.52c3.5 3.168 8.584 2.494 11.32-.5313c2.979-3.264 2.758-8.326-.5332-11.31l-21.46-19.48c14.02-15.99 25.97-33.79 35.62-53.03l25.69 11.11c4.158 1.758 8.816-.1562 10.56-4.156c1.754-4.062-.0957-8.766-4.17-10.53l-25.37-10.98c8.275-19.5 14.24-40.24 17.48-61.98c0 0 26.33 2.229 26.55 2.229c4.139 0 7.648-3.156 7.994-7.328C640.3 254.9 637.1 251 632.7 250.7zM372.1 463.8c-42.3 3.236-69.12-31.94-69.12-63.89c0-33.19 26.03-61.17 59.28-63.71c54.56-4.207 97.21-46.73 101.4-101.1c1.865-24.12 23.91-62.32 68.94-58.89c35.25 2.688 61.75 33.52 59.08 68.71C582.6 362.7 490.2 454.7 372.1 463.8zM236 206.1c12.61-7.912 27.13-13.16 42.99-14.38c5.398-.4121 10.61-1.379 15.63-2.785l11.31 24.66c1.848 4.029 6.738 5.764 10.62 3.951c4.045-1.844 5.83-6.592 3.982-10.61L309.6 183c21.14-10.88 36.54-30.73 41.61-54.18l23.99 2.488c4.262 .4062 8.338-2.734 8.807-7.125c.4395-4.391-2.758-8.328-7.146-8.781l-23.81-2.471c.0039-.2949 .082-.5703 .082-.8652c0-2.076-.0781-4.15-.2363-6.227c-1.734-22.48-12.69-41.97-28.81-55.32l15.16-20.35c2.633-3.545 1.881-8.561-1.662-11.19c-3.523-2.598-8.541-1.949-11.25 1.656L310.7 41.63C297.6 34.65 282.6 31.03 266.7 32.25C259.5 32.8 252.4 33.72 245.3 34.85L240.3 6.621C240.1 5.242 237.8-.9961 230.1 .1367C226.6 .9023 223.7 5.059 224.5 9.418l5.096 28.61C208.4 42.77 188.4 50.05 169.6 59.59L155.4 33.71C154.4 31.87 150 27.52 144.5 30.56c-3.889 2.125-5.299 7-3.166 10.88l14.21 25.78c-18.43 10.91-35.36 23.99-50.33 39.04L83.69 86.73c-3.5-3.168-8.584-2.494-11.32 .5313C69.4 90.52 69.62 95.59 72.91 98.57l21.46 19.48C80.36 134 68.4 151.8 58.76 171.1l-25.69-11.11C28.91 158.2 24.25 160.1 22.5 164.1C20.75 168.2 22.6 172.9 26.67 174.6l25.37 10.98c-8.275 19.5-14.24 40.24-17.48 61.98c0 0-26.33-2.229-26.55-2.229c-4.139 0-7.648 3.156-7.994 7.328c-.375 4.391 2.885 8.266 7.305 8.641L32.63 263.5C32.56 264.3 32.4 265.1 32.34 265.9c-1.9 24.97 7.984 47.7 24.63 63.64L44.67 346c-2.664 3.531-1.912 8.547 1.631 11.19c3.543 2.594 8.557 1.891 11.22-1.656l12.07-16.18c10.73 6.762 23.03 11.38 36.6 12.41c12.54 .9629 24.49-1.266 35.44-5.578l8.672 20.55c1.691 4.078 6.457 5.953 10.5 4.281c4.107-1.719 6.02-6.406 4.295-10.47l-9.174-21.74c16.34-10.61 28.7-26.84 33.87-46.39L215.6 295.9c4.578 .7031 8.434-2.484 9.061-6.844c.5957-4.375-2.477-8.406-6.865-9L192.6 276.7c2.264-24.31 13.62-45.57 30.61-60.86l16.14 20.75c2.727 3.5 7.773 4.109 11.25 1.422c3.51-2.719 4.137-7.734 1.41-11.23L236 206.1zM176.4 276.9c-1.865 24.12-23.91 62.32-68.94 58.89c-35.25-2.688-61.75-33.52-59.08-68.71c9.084-117.8 101.4-209.8 219.6-218.9c42.3-3.236 69.12 31.94 69.12 63.89c0 33.19-26.03 61.17-59.28 63.71C223.2 180 180.5 222.5 176.4 276.9zM416 352c-17.67 0-32 14.33-32 32c0 17.67 14.33 32 32 32s32-14.33 32-32C448 366.3 433.7 352 416 352zM415.1 400c-8.822 0-16-7.177-16-15.1S407.2 368 416 368s16 7.178 16 16S424.8 400 415.1 400z"],
    "bacterium": [576, 512, [], "e05a", "M537.6 161.4L511.2 156.5c1.404-12.65 .4961-19.99 .4961-21.05c-1.955-25.56-13.09-44.19-13.34-44.59l23.74-14.51c3.701-2.256 4.863-7.088 2.631-10.79c-2.295-3.727-7.158-4.863-10.77-2.623l-23.99 14.66c-16.95-24.14-43.5-35.88-52.85-38.98l8.439-28.5c1.254-4.158-1.133-8.531-5.262-9.773c-4.1-1.182-8.504 1.15-9.729 5.293l-8.596 29.03c-18.18-3.953-33.98-3.223-64.73 2.096l-5.688-29.88c-.7969-4.25-4.895-6.965-9.146-6.244c-4.254 .8145-7.037 4.926-6.211 9.191l5.727 30.09c-21.39 4.664-42.05 11.1-61.75 19.35L267.7 31.21C265.9 27.23 261.3 25.44 257.4 27.22C253.4 28.98 251.6 33.63 253.4 37.59l12.47 28.1C246.2 74.98 227.6 86 210.1 98.59L191.7 74.43C189.1 70.96 184.2 70.29 180.8 72.94c-3.455 2.623-4.098 7.562-1.498 11L197.5 107.9C180.5 121.4 164.9 136.5 150.6 152.8L127.5 133.8C124.2 131.1 119.3 131.6 116.5 134.9C113.7 138.3 114.2 143.2 117.6 145.1l22.87 18.79c-13.49 16.95-25.38 35.22-35.62 54.56L78.93 206.6c-3.887-1.902-8.598-.3066-10.46 3.605c-1.896 3.912-.2754 8.607 3.609 10.51L97.89 233.4C88.63 252.9 80.96 273.4 75.32 294.8L48.37 288.6c-4.16-.9355-8.412 1.674-9.391 5.924C38.03 298.8 40.66 303 44.88 303.1l26.97 6.139c-1.215 5.584-2.594 11.1-3.549 16.79c-1.793 10.68-3.125 21.53-3.971 32.53c-.4355 5.648-.416 11.23-.0234 16.71L38.43 380.8c-4.252 .7813-7.066 4.863-6.303 9.145c.25 1.35 2.336 7.375 9.117 6.32l25.36-4.619c2.422 11.21 6.449 21.88 11.1 31.63c5.893 10.36 13.88 19.19 22.69 27.18l-15.25 19.76c-2.66 3.422-2.049 8.363 1.377 11.02c3.492 2.682 8.4 1.982 10.98-1.412l14.93-19.34c32.38 21.99 62.61 19.28 65.89 19.19l1.832 25.02C181.3 508.9 184.8 512 188.8 512c4.607 0 8.15-3.914 7.801-8.424l-1.857-25.36c23.04-3.914 43.73-14.92 59.83-30.86l20.06 19.31c3.822 3.758 8.893 2.021 11.07-.2305c2.996-3.129 2.875-8.1-.2461-11.09l-20.38-19.61c14.31-18.79 20.76-38.61 22.86-61.09l30.56 3.518c4.484 .459 8.178-2.74 8.656-6.92c.4902-4.311-2.57-8.193-6.883-8.699l-29.73-3.422c4.531-21.3 14.08-40.42 27.41-56.43l20.7 18.9c3.391 3.086 8.348 2.479 11.04-.5215c2.906-3.207 2.691-8.178-.5195-11.11L328.6 291.1c15-14.13 33.29-24.75 53.82-30.57l5.666 27.27c.2793 1.295 2.873 7.586 9.27 6.076c4.252-.875 6.943-5.047 6.088-9.283l-5.637-27.12c3.611-.5781 7.09-1.523 10.8-1.809c19.15-1.475 36.49-8.109 51.59-17.81L477.3 260.2c2.633 3.455 7.586 4.074 10.98 1.441c3.426-2.639 4.068-7.58 1.438-11.02l-16.84-21.97c4.277-3.689 8.506-7.447 12.17-11.73c11-12.84 18.64-28.32 22.96-45.05l26.73 4.967c6.592 1.234 8.902-4.973 9.146-6.291C544.6 166.3 541.9 162.2 537.6 161.4zM407.4 239.7c-72.97 5.607-130 62.65-135.7 135.7C267.9 425.1 225.9 464 176.1 464c-2.506 0-5.012-.0957-7.49-.2813c-25.57-1.969-48.84-13.78-65.53-33.24c-16.68-19.47-24.78-44.27-22.81-69.84c12.92-168.1 144.3-299.4 312.3-312.3c67.96-5.155 100.2 50.67 103.1 88.35C499.8 189.4 460.1 235.7 407.4 239.7zM192 272C165.6 272 144 293.5 144 320s21.55 48 48.01 48s48.01-21.53 48.01-48S218.5 272 192 272zM192 351.1c-17.67 0-31.1-14.33-31.1-31.1c0-17.67 14.33-31.1 31.1-31.1s31.1 14.33 31.1 31.1C223.1 337.7 209.7 351.1 192 351.1zM272 176c-17.64 0-32 14.36-32 32s14.36 32 32 32s32-14.36 32-32S289.6 176 272 176zM272 224C263.2 224 256 216.8 256 208C256 199.2 263.2 192 272 192S288 199.2 288 208C288 216.8 280.8 224 272 224z"],
    "badge": [512, 512, [], "f335", "M169.9 48.16C187.7 19.28 219.6 0 256 0C292.4 0 324.3 19.28 342.1 48.16C375.1 40.3 411.3 49.22 437 74.98C462.8 100.7 471.7 136.9 463.8 169.9C492.7 187.7 512 219.6 512 256C512 292.4 492.7 324.3 463.8 342.1C471.7 375.1 462.8 411.3 437 437C411.3 462.8 375.1 471.7 342.1 463.8C324.3 492.7 292.4 512 256 512C219.6 512 187.7 492.7 169.9 463.8C136.9 471.7 100.7 462.8 74.98 437C49.23 411.3 40.3 375.1 48.16 342.1C19.28 324.3 0 292.4 0 256C0 219.6 19.28 187.7 48.16 169.9C40.3 136.9 49.23 100.7 74.98 74.98C100.7 49.23 136.9 40.3 169.9 48.16H169.9zM256 16C223.4 16 195.1 34.32 180.8 61.25L177.8 67.09L171.4 65.15C142.3 56.2 109.3 63.26 86.29 86.29C63.26 109.3 56.2 142.3 65.15 171.4L67.09 177.8L61.25 180.8C34.32 195.1 16 223.4 16 255.1C16 288.6 34.32 316.9 61.25 331.2L67.09 334.2L65.15 340.6C56.2 369.7 63.26 402.7 86.29 425.7C109.3 448.7 142.3 455.8 171.4 446.9L177.8 444.9L180.8 450.8C195.1 477.7 223.4 496 256 496C288.6 496 316.9 477.7 331.2 450.8L334.2 444.9L340.6 446.9C369.7 455.8 402.7 448.7 425.7 425.7C448.7 402.7 455.8 369.7 446.9 340.6L444.9 334.2L450.8 331.2C477.7 316.9 496 288.6 496 255.1C496 223.4 477.7 195.1 450.8 180.8L444.9 177.8L446.9 171.4C455.8 142.3 448.7 109.3 425.7 86.29C402.7 63.26 369.7 56.2 340.6 65.15L334.2 67.09L331.2 61.25C316.9 34.32 288.6 15.1 255.1 15.1L256 16z"],
    "badge-check": [512, 512, [], "f336", "M229.7 325.7C226.5 328.8 221.5 328.8 218.3 325.7L162.3 269.7C159.2 266.5 159.2 261.5 162.3 258.3C165.5 255.2 170.5 255.2 173.7 258.3L223.1 308.7L338.3 194.3C341.5 191.2 346.5 191.2 349.7 194.3C352.8 197.5 352.8 202.5 349.7 205.7L229.7 325.7zM342.1 48.16C375.1 40.3 411.3 49.22 437 74.98C462.8 100.7 471.7 136.9 463.8 169.9C492.7 187.7 512 219.6 512 256C512 292.4 492.7 324.3 463.8 342.1C471.7 375.1 462.8 411.3 437 437C411.3 462.8 375.1 471.7 342.1 463.8C324.3 492.7 292.4 512 255.1 512C219.6 512 187.7 492.7 169.9 463.8C136.9 471.7 100.7 462.8 74.98 437C49.23 411.3 40.3 375.1 48.16 342.1C19.28 324.3 0 292.4 0 256C0 219.6 19.28 187.7 48.16 169.9C40.3 136.9 49.23 100.7 74.98 74.98C100.7 49.23 136.9 40.3 169.9 48.16C187.7 19.28 219.6 0 256 0C292.4 0 324.3 19.28 342.1 48.16L342.1 48.16zM177.8 67.09L171.4 65.15C142.3 56.2 109.3 63.26 86.29 86.29C63.26 109.3 56.2 142.3 65.15 171.4L67.09 177.8L61.25 180.8C34.32 195.1 16 223.4 16 255.1C16 288.6 34.32 316.9 61.25 331.2L67.09 334.2L65.15 340.6C56.2 369.7 63.26 402.7 86.29 425.7C109.3 448.7 142.3 455.8 171.4 446.9L177.8 444.9L180.8 450.8C195.1 477.7 223.4 496 256 496C288.6 496 316.9 477.7 331.2 450.8L334.2 444.9L340.6 446.9C369.7 455.8 402.7 448.7 425.7 425.7C448.7 402.7 455.8 369.7 446.9 340.6L444.9 334.2L450.8 331.2C477.7 316.9 496 288.6 496 255.1C496 223.4 477.7 195.1 450.8 180.8L444.9 177.7L446.9 171.4C455.8 142.3 448.7 109.3 425.7 86.29C402.7 63.26 369.7 56.2 340.6 65.15L334.2 67.09L331.2 61.25C316.9 34.32 288.6 15.1 256 15.1C223.4 15.1 195.1 34.32 180.8 61.25L177.8 67.09z"],
    "badge-dollar": [512, 512, [], "f645", "M264.9 168.6C267.1 168.8 269.4 169.1 271.7 169.5C277.1 170.3 293.3 173.4 298.9 174.9C303.2 176.1 305.8 180.5 304.6 184.7C303.5 188.1 299.1 191.5 294.8 190.4C289.9 189.1 274.3 186.1 269.3 185.3C253.5 182.8 239.5 184.6 229.4 189.2C219.3 193.8 213.5 200.8 212.1 208.7C211 214.9 211.8 219.4 213.4 222.9C215.1 226.4 218 229.5 222.3 232.4C231.3 238.5 244.2 242.4 259 246.9L259.4 247C273.6 251.3 289.5 256.1 300.1 264.5C306.9 268.8 312 274.2 315.1 281.4C318.2 288.5 319 296.7 317.4 305.1C314.7 321.6 304.5 332.4 290.7 338.4C283 341.6 274.3 343.4 264.9 343.9V362.7C264.9 367.1 261.3 370.7 256.9 370.7C252.5 370.7 248.9 367.1 248.9 362.7V343.4C246.6 343.2 244.3 342.9 242.1 342.5L242 342.5C232.5 340.1 217 335.7 206.6 332.1C204.5 331.4 202.6 330.8 201 330.3C196.8 328.9 194.6 324.3 195.1 320.1C197.4 315.9 201.9 313.7 206.1 315.1C207.1 315.7 210.1 316.4 212.4 317.2C222.1 320.8 236.6 325.4 244.6 326.7C260.5 329.2 274.4 327.9 284.4 323.7C294.1 319.5 300 312.7 301.7 303.3C302.8 296.5 302.1 291.6 300.4 287.7C298.7 283.9 295.8 280.5 291.6 277.4C282.7 270.1 269.7 266.8 254.8 262.3L252.1 261.8C239.4 257.7 224.3 253.1 213.3 245.7C207.4 241.7 202.2 236.5 198.1 229.7C195.7 222.8 194.8 214.9 196.4 206C198.9 191.5 209.2 180.8 222.8 174.7C230.5 171.2 239.3 169.1 248.9 168.4V149.3C248.9 144.9 252.5 141.3 256.9 141.3C261.3 141.3 264.9 144.9 264.9 149.3L264.9 168.6zM342.1 48.16C375.1 40.3 411.3 49.22 437 74.98C462.8 100.7 471.7 136.9 463.8 169.9C492.7 187.7 512 219.6 512 256C512 292.4 492.7 324.3 463.8 342.1C471.7 375.1 462.8 411.3 437 437C411.3 462.8 375.1 471.7 342.1 463.8C324.3 492.7 292.4 512 256 512C219.6 512 187.7 492.7 169.9 463.8C136.9 471.7 100.7 462.8 74.98 437C49.23 411.3 40.3 375.1 48.16 342.1C19.28 324.3 0 292.4 0 256C0 219.6 19.28 187.7 48.16 169.9C40.3 136.9 49.23 100.7 74.98 74.98C100.7 49.23 136.9 40.3 169.9 48.16C187.7 19.28 219.6 0 256 0C292.4 0 324.3 19.28 342.1 48.16H342.1zM177.8 67.09L171.4 65.15C142.3 56.2 109.3 63.26 86.29 86.29C63.26 109.3 56.2 142.3 65.15 171.4L67.09 177.8L61.25 180.8C34.32 195.1 16 223.4 16 255.1C16 288.6 34.32 316.9 61.25 331.2L67.09 334.2L65.15 340.6C56.2 369.7 63.26 402.7 86.29 425.7C109.3 448.7 142.3 455.8 171.4 446.9L177.8 444.9L180.8 450.8C195.1 477.7 223.4 496 256 496C288.6 496 316.9 477.7 331.2 450.8L334.2 444.9L340.6 446.9C369.7 455.8 402.7 448.7 425.7 425.7C448.7 402.7 455.8 369.7 446.9 340.6L444.9 334.2L450.8 331.2C477.7 316.9 496 288.6 496 255.1C496 223.4 477.7 195.1 450.8 180.8L444.9 177.8L446.9 171.4C455.8 142.3 448.7 109.3 425.7 86.29C402.7 63.26 369.7 56.2 340.6 65.15L334.2 67.09L331.2 61.25C316.9 34.32 288.6 15.1 256 15.1C223.4 15.1 195.1 34.32 180.8 61.25L177.8 67.09z"],
    "badge-percent": [512, 512, [], "f646", "M224 192C224 209.7 209.7 224 192 224C174.3 224 160 209.7 160 192C160 174.3 174.3 160 192 160C209.7 160 224 174.3 224 192zM192 176C183.2 176 176 183.2 176 192C176 200.8 183.2 208 192 208C200.8 208 208 200.8 208 192C208 183.2 200.8 176 192 176zM288 320C288 302.3 302.3 288 320 288C337.7 288 352 302.3 352 320C352 337.7 337.7 352 320 352C302.3 352 288 337.7 288 320zM320 336C328.8 336 336 328.8 336 320C336 311.2 328.8 304 320 304C311.2 304 304 311.2 304 320C304 328.8 311.2 336 320 336zM181.7 341.7C178.5 344.8 173.5 344.8 170.3 341.7C167.2 338.5 167.2 333.5 170.3 330.3L330.3 170.3C333.5 167.2 338.5 167.2 341.7 170.3C344.8 173.5 344.8 178.5 341.7 181.7L181.7 341.7zM342.1 48.16C375.1 40.3 411.3 49.22 437 74.98C462.8 100.7 471.7 136.9 463.8 169.9C492.7 187.7 512 219.6 512 256C512 292.4 492.7 324.3 463.8 342.1C471.7 375.1 462.8 411.3 437 437C411.3 462.8 375.1 471.7 342.1 463.8C324.3 492.7 292.4 512 256 512C219.6 512 187.7 492.7 169.9 463.8C136.9 471.7 100.7 462.8 74.98 437C49.23 411.3 40.3 375.1 48.16 342.1C19.28 324.3 0 292.4 0 256C0 219.6 19.28 187.7 48.16 169.9C40.3 136.9 49.23 100.7 74.98 74.98C100.7 49.23 136.9 40.3 169.9 48.16C187.7 19.28 219.6 0 256 0C292.4 0 324.3 19.28 342.1 48.16H342.1zM177.8 67.09L171.4 65.15C142.3 56.2 109.3 63.26 86.29 86.29C63.26 109.3 56.2 142.3 65.15 171.4L67.09 177.8L61.25 180.8C34.32 195.1 16 223.4 16 255.1C16 288.6 34.32 316.9 61.25 331.2L67.09 334.2L65.15 340.6C56.2 369.7 63.26 402.7 86.29 425.7C109.3 448.7 142.3 455.8 171.4 446.9L177.8 444.9L180.8 450.8C195.1 477.7 223.4 496 256 496C288.6 496 316.9 477.7 331.2 450.8L334.2 444.9L340.6 446.9C369.7 455.8 402.7 448.7 425.7 425.7C448.7 402.7 455.8 369.7 446.9 340.6L444.9 334.2L450.8 331.2C477.7 316.9 496 288.6 496 255.1C496 223.4 477.7 195.1 450.8 180.8L444.9 177.8L446.9 171.4C455.8 142.3 448.7 109.3 425.7 86.29C402.7 63.26 369.7 56.2 340.6 65.15L334.2 67.09L331.2 61.25C316.9 34.32 288.6 15.1 256 15.1C223.4 15.1 195.1 34.32 180.8 61.25L177.8 67.09z"],
    "badge-sheriff": [512, 512, [], "f8a2", "M432 304c-4.102 0-8.016 .6699-11.82 1.639L390.4 256l29.78-49.64C423.1 207.3 427.9 208 432 208C458.5 208 480 186.5 480 160s-21.49-48-48-48c-20.87 0-38.45 13.4-45.06 32h-63.74l-35.98-59.81C297.4 75.39 304 62.5 304 48C304 21.49 282.5 0 256 0S208 21.49 208 48c0 14.5 6.679 27.43 16.84 36.23L188.8 144H125.1C118.5 125.4 100.9 112 80 112C53.49 112 32 133.5 32 160s21.49 48 48 48c4.102 0 8.016-.6699 11.82-1.639L121.6 256L91.82 305.6C88.02 304.7 84.1 304 80 304C53.49 304 32 325.5 32 352s21.49 48 48 48c20.87 0 38.45-13.4 45.06-32h63.74l35.98 59.81C214.6 436.6 208 449.5 208 464c0 26.51 21.49 48 48 48s48-21.49 48-48c0-14.5-6.679-27.43-16.84-36.23L323.2 368h63.74c6.611 18.6 24.19 32 45.06 32c26.51 0 48-21.49 48-48S458.5 304 432 304zM432 384c-13.39 0-25.45-8.584-29.99-21.36L398.2 352h-84.09l-47.5 79.16l10.16 8.799C284 446.2 288 454.8 288 464c0 17.64-14.36 32-32 32s-32-14.36-32-32c0-9.25 3.977-17.79 11.2-24.04l10.16-8.799L197.9 352H113.8l-3.783 10.64C105.4 375.4 93.39 384 80 384c-17.64 0-32-14.36-32-32s14.36-32 32-32c2.305 0 4.805 .3633 7.865 1.143l11.54 2.941L140.3 256L99.41 187.9l-11.54 2.943C84.8 191.6 82.3 192 80 192c-17.64 0-32-14.36-32-32s14.36-32 32-32c13.39 0 25.45 8.584 29.99 21.36L113.8 160h84.09l47.5-79.16L235.2 72.04C227.1 65.79 224 57.25 224 48c0-17.64 14.36-32 32-32s32 14.36 32 32c0 9.248-3.977 17.79-11.2 24.04l-10.16 8.801L314.1 160h84.09l3.783-10.64C406.6 136.6 418.6 128 432 128c17.64 0 32 14.36 32 32s-14.36 32-32 32c-2.305 0-4.805-.3633-7.865-1.143l-11.54-2.943L371.7 256l40.85 68.08l11.54-2.941C427.2 320.4 429.7 320 432 320c17.64 0 32 14.36 32 32S449.6 384 432 384zM256 184C216.3 184 184 216.3 184 256s32.3 72 72 72S328 295.7 328 256S295.7 184 256 184zM256 312C225.1 312 200 286.9 200 256S225.1 200 256 200S312 225.1 312 256S286.9 312 256 312z"],
    "badger-honey": [640, 512, [129441], "f6b4", "M622.3 142.5c-66.24-36.15-102.2-78.46-156.8-78.46c-50.6 0-64.74 32-110.5 32H128c-70.69 0-128 57.29-128 128v15.95c0 8.878 7.125 16 16 16h20c2.625 11.25 9.875 46.61 54.13 79.74l-23.75 52.38c-3.125 7.627-3.125 16.13-.125 23.75l21.3 48.91C92.63 472.4 104.2 480 116.9 480h53.86c17.46 0 29.08-18.07 21.84-33.96l-17.34-38.05l33-56.01h73.63l20.55 102.3C305.4 469.2 318.6 480 333.8 480h46.63c20.18 0 35.33-18.46 31.38-38.26l-23.06-115.8c45.01-30.35 92.15-57.28 155.2-74.45v28.46c0 4.423 3.594 8.002 8 8.002s8-3.579 8-8.002V247.9c0-.1876-.1855-.297-.1992-.4806c7.512-1.77 15.04-3.502 23.02-4.989C636.1 238.1 640 178.5 640 175.3C640 161.3 633.1 148.7 622.3 142.5zM111.9 113.6C117.2 112.9 122.5 112 128 112h227c26.17 0 43.92-9.124 59.57-17.17c15.49-7.963 28.86-14.84 50.93-14.84c31.8 0 57.86 17.64 90.86 39.96c11.17 7.559 23.78 15.75 37.12 23.93l-133.5 .0505c-30.19 0-59.07 12.63-89.07 27.11L269.5 232.5C259.4 237.4 248.7 240 237.5 240l-37.55-.0865c-48.53 0-88-39.48-88-88.03V113.6zM581.4 226.5L580.6 226.5l-.8047 .1504c-83.1 15.48-140.1 45.57-200 85.98l-8.828 5.953l25.14 126.2c.9395 4.718-.2715 9.558-3.32 13.28c-3.053 3.72-7.561 5.853-12.37 5.853h-46.63c-7.594 0-14.19-5.406-15.69-12.85l-19.92-99.18h5.723c4.406 0 8-3.579 8-8.002c0-4.423-3.594-8.002-8-8.002h-128c-4.406 0-8 3.579-8 8.002c0 4.423 3.594 8.002 8 8.002h13.76l-32.44 55.07l20.79 45.64c1.576 3.458 .332 6.275-.5508 7.649c-.8828 1.372-2.93 3.673-6.729 3.673H116.9c-6.369 0-12.13-3.775-14.67-9.614l-21.08-48.39c-1.518-3.859-1.502-8.061-.1914-11.29l29.06-64.11l-10.29-7.707c-38.47-28.81-45.34-58.51-48.13-70.6L48.7 239.9H16V224c0-50.55 33.86-92.89 79.92-106.8v34.64c0 57.36 46.66 104 104 104l37.54 .0337c13.66 0 26.8-3.081 39.74-9.443l101.3-61.41c27.59-13.29 54.63-25.16 81.45-25.16l22.41-.0481c-1.418 2.389-2.453 5.023-2.453 8.002c0 8.839 7.219 16.06 16.05 16.06s15.95-7.226 15.95-16.06c0-2.979-1.033-5.613-2.451-8.002h108.2C621.3 163.8 624 168.1 624 175C623.1 175.5 621.9 223.2 581.4 226.5z"],
    "badminton": [640, 512, [], "e33a", "M575.9 149.7c0-34.13-10.2-66.82-31.53-93.61C514.6 18.75 468.9 0 419.5 0c-99.06 0-227.6 87.4-227.6 218.5c0 34.88 10.78 67.13 31.59 93.33l-93.22 75.83l-6.949-8.721c-4.617-5.814-11.47-9.064-18.56-9.064c-5.479 0-10.79 1.711-15.19 5.217l-74.56 59.53C5.158 442.5 0 454.2 0 465.1c0 8.746 2.84 17.55 8.697 24.92l4.812 5.975C14.02 497.5 24.44 512 44.86 512c9.031 0 17.72-3.004 24.88-8.729l74.53-59.53c5.836-4.607 9.061-11.52 9.061-18.84c0-5.416-1.822-10.62-5.248-14.91L140.3 400.2l94.75-77.07c29.45 29.37 69.68 45 113.5 45C441 368.1 575.9 286.9 575.9 149.7zM134.3 431.2l-74.53 59.53c-4.266 3.367-9.498 5.252-14.82 5.252c-.4883 0-11.34 .4648-18.93-9.1l-4.812-5.975c-3.512-4.422-5.217-9.705-5.217-14.95c0-7.078 3.104-14.09 9.061-18.83l74.53-59.53c1.578-1.236 3.277-1.752 4.898-1.752c2.566 0 4.941 1.291 6.352 3.066l24.75 31.03c1.182 1.494 1.74 3.244 1.74 4.973C137.3 427.3 136.3 429.7 134.3 431.2zM348.4 352.2c-47.32 0-140.5-28.49-140.5-133.8c0-148.8 151.1-202.5 211.6-202.5c47.23 0 140.4 28.35 140.4 133.9C559.9 270.3 441.1 352.2 348.4 352.2zM623.6 501.5l-15.59-46.8l.0067-54.69c0-26.54-21.49-48.01-48-48.01c-26.51 0-48 21.48-48 48.01l-.0082 54.69l-15.59 46.8c-.2813 .8398-.416 1.693-.416 2.533C495.1 508.3 499.5 512 503.1 512c3.344 0 6.469-2.127 7.594-5.475l16.85-50.58h23.55v48.05c0 4.41 3.6 8.006 8.007 8.006s7.993-3.596 7.993-8.006V455.9h23.55l16.85 50.58C609.5 509.9 612.6 512 615.1 512C620.5 512 624 508.4 624 503.1C624 503.2 623.9 502.3 623.6 501.5zM591.1 439.9h-64v-16.02h64V439.9zM591.1 407.9h-64v-8.01c0-17.66 14.36-32.03 32-32.03c17.64 0 32 14.37 32 32.03V407.9zM501.6 67.91c-20.06-16.97-47.63-25.94-79.66-25.94c-91.75 0-190 70.91-190 176.4c0 108.5 115.3 109.8 116.5 109.8c76.44 0 187.5-69.5 187.5-178.4C535.9 115.2 524.1 86.88 501.6 67.91zM348.5 312.2c-4.125-.0313-100.5-1.781-100.5-93.78c0-104.7 101.1-160.4 174-160.4c28.22 0 52.19 7.656 69.34 22.16c19 16.06 28.66 39.5 28.66 69.66C519.9 248.9 418.4 312.2 348.5 312.2z"],
    "bag-shopping": [448, 512, ["shopping-bag"], "f290", "M128 128V96C128 42.98 170.1 0 224 0C277 0 320 42.98 320 96V128H400C426.5 128 448 149.5 448 176V416C448 469 405 512 352 512H96C42.98 512 0 469 0 416V176C0 149.5 21.49 128 48 128H128zM144 128H304V96C304 51.82 268.2 16 224 16C179.8 16 144 51.82 144 96V128zM48 144C30.33 144 16 158.3 16 176V416C16 460.2 51.82 496 96 496H352C396.2 496 432 460.2 432 416V176C432 158.3 417.7 144 400 144H320V232C320 236.4 316.4 240 312 240C307.6 240 304 236.4 304 232V144H144V232C144 236.4 140.4 240 136 240C131.6 240 128 236.4 128 232V144H48z"],
    "bagel": [640, 512, [129391], "e3d7", "M208 240c-35.29 0-64 28.71-64 64c0 35.29 28.71 64 64 64s64-28.71 64-64C272 268.7 243.3 240 208 240zM208 352C181.5 352 160 330.5 160 304S181.5 256 208 256S256 277.5 256 304S234.5 352 208 352zM208 96C93.13 96 0 189.1 0 304S93.13 512 208 512S416 418.9 416 304S322.9 96 208 96zM208 496c-105.9 0-192-86.13-192-192s86.13-192 192-192s192 86.13 192 192S313.9 496 208 496zM160 192c0-8.838-7.164-16-16-16S128 183.2 128 192c0 8.836 7.164 16 16 16S160 200.8 160 192zM80 256C71.16 256 64 263.2 64 272C64 280.8 71.16 288 80 288S96 280.8 96 272C96 263.2 88.84 256 80 256zM240 416C231.2 416 224 423.2 224 432C224 440.8 231.2 448 240 448S256 440.8 256 432C256 423.2 248.8 416 240 416zM304 384C295.2 384 288 391.2 288 400C288 408.8 295.2 416 304 416s16-7.164 16-16C320 391.2 312.8 384 304 384zM320 224C311.2 224 304 231.2 304 240C304 248.8 311.2 256 320 256s16-7.164 16-16C336 231.2 328.8 224 320 224zM112 384C103.2 384 96 391.2 96 400C96 408.8 103.2 416 112 416S128 408.8 128 400C128 391.2 120.8 384 112 384zM442.4 254.8c-4.312 .9687-7.031 5.25-6.062 9.562c.8438 3.719 4.156 6.25 7.812 6.25c.5625 0 1.156-.0625 1.75-.1875c29-6.484 50.06-32.72 50.06-62.39c0-35.3-28.72-64-64-64c-12.75 0-25.09 3.766-35.65 10.88c-3.656 2.469-4.625 7.453-2.156 11.11c2.438 3.672 7.375 4.625 11.09 2.172C413.2 162.8 422.4 160 432 160C458.5 160 480 181.5 480 208C480 230.2 464.2 249.9 442.4 254.8zM598.2 155.1c-3.906-11.44-13.34-18.97-22.47-26.25c-5.344-4.281-10.38-8.312-13.72-12.72c-3.375-4.453-5.875-10.34-8.5-16.58c-4.219-10.03-9-21.41-18.94-28.38c-9.812-6.844-21.88-7.672-33.56-8.469c-7.062-.4844-13.78-.9375-19.41-2.703c-5.281-1.641-10.75-4.969-16.56-8.469C455.5 46.58 444.6 40 432 40c-12.62 0-23.5 6.594-33.13 12.41c-5.781 3.5-11.25 6.812-16.5 8.453c-5.625 1.75-12.31 2.219-19.41 2.703c-11.69 .7969-23.75 1.625-33.53 8.469c-6.781 4.703-10.78 11.5-13.84 17.55C313.6 93.52 315.2 98.33 319.2 100.3c3.906 1.969 8.75 .4375 10.75-3.547c2.25-4.453 4.844-8.938 8.688-11.61c6.156-4.312 15.53-4.953 25.47-5.641c7.688-.5313 15.66-1.062 23.09-3.375c7.094-2.234 13.66-6.203 20-10.05C415.8 60.91 423.8 56 432 56c8.125 0 16.22 4.891 24.78 10.08c6.375 3.844 12.94 7.828 20.09 10.06c7.406 2.312 15.38 2.859 23.06 3.391c9.938 .6719 19.31 1.312 25.47 5.609c6.188 4.328 9.688 12.64 13.38 21.47c2.906 6.875 5.906 14 10.5 20.05c4.531 5.984 10.62 10.84 16.5 15.55c7.656 6.125 14.91 11.91 17.28 18.91c2.219 6.562 .0313 15.11-2.312 24.16C578.9 192.6 576.9 200.2 576.9 208c0 7.766 1.969 15.36 3.844 22.7c2.344 9.062 4.531 17.61 2.344 24.16c-2.406 7.047-9.688 12.84-17.38 18.98c-5.844 4.688-11.91 9.516-16.44 15.48c-4.594 6.062-7.594 13.17-10.5 20.06c-3.688 8.812-7.188 17.14-13.38 21.45c-6.125 4.297-15.53 4.938-25.47 5.625c-7.688 .5313-15.66 1.078-23.06 3.391c-7.062 2.203-13.59 6.016-19.94 9.703c-6.688 3.891-13 7.578-19.38 9.156c-4.281 1.062-6.906 5.406-5.812 9.703c.9062 3.641 4.156 6.062 7.75 6.062c.625 0 1.281-.0781 1.938-.2344c8.562-2.141 16.19-6.562 23.56-10.86c5.812-3.391 11.31-6.594 16.66-8.25c5.594-1.766 12.28-2.219 19.38-2.719c11.69-.7969 23.75-1.625 33.56-8.469c9.938-6.953 14.72-18.33 18.94-28.36c2.625-6.25 5.125-12.14 8.5-16.59c3.312-4.375 8.344-8.391 13.69-12.66C584.4 279.4 594.3 271.5 598.3 260c3.719-11.08 .8125-22.38-2-33.3C594.5 220 592.9 213.8 592.9 208c0-5.766 1.625-12.06 3.344-18.73C599.1 178.3 601.1 167.1 598.2 155.1zM432 0c-59.47 0-116.3 25.7-155.8 70.52C273.3 73.83 273.6 78.89 276.9 81.81c3.25 2.922 8.344 2.609 11.28-.7031C324.7 39.73 377.1 16 432 16c105.9 0 192 86.13 192 192s-86.13 192-192 192c-1.375 0-2.719-.0938-4.062-.1875L424.5 399.6c-4.469 .2813-8.125 3.297-8.281 7.719c-.1562 4.406 3.312 8.125 7.719 8.281l2.906 .1719C428.6 415.9 430.3 416 432 416c114.7 0 208-93.31 208-208S546.7 0 432 0z"],
    "bags-shopping": [576, 512, [128717], "f847", "M128 96C128 42.98 170.1 0 224 0C277 0 320 42.98 320 96V160H384C419.3 160 448 188.7 448 224H432C432 197.5 410.5 176 384 176H64C37.49 176 16 197.5 16 224V416C16 442.5 37.49 464 64 464H160V480H64C28.65 480 0 451.3 0 416V224C0 188.7 28.65 160 64 160H128V96zM144 160H304V96C304 51.82 268.2 16 224 16C179.8 16 144 51.82 144 96V160zM320 368C320 403.3 348.7 432 384 432C419.3 432 448 403.3 448 368V328C448 323.6 451.6 320 456 320C460.4 320 464 323.6 464 328V368C464 412.2 428.2 448 384 448C339.8 448 304 412.2 304 368V328C304 323.6 307.6 320 312 320C316.4 320 320 323.6 320 328V368zM192 320C192 284.7 220.7 256 256 256H512C547.3 256 576 284.7 576 320V448C576 483.3 547.3 512 512 512H256C220.7 512 192 483.3 192 448V320zM256 272C229.5 272 208 293.5 208 320V448C208 474.5 229.5 496 256 496H512C538.5 496 560 474.5 560 448V320C560 293.5 538.5 272 512 272H256z"],
    "baguette": [640, 512, [129366], "e3d8", "M622 49.6c-13.4-20.16-33.4-35.27-56.29-42.54C550.8 2.303 534.7 0 518.2 0c-36.6 0-74.87 11.38-105.9 32.65L80.88 259.7c-44.86 30.74-76.46 83.44-80.53 134.3c-1.979 24.08 4.307 48.37 17.61 68.4c13.4 20.16 33.41 35.27 56.29 42.54C89.24 509.7 105.4 512 121.8 512c36.58 0 74.82-11.41 105.9-32.68l331.4-227.1c44.87-30.74 76.46-83.44 80.53-134.3C641.6 93.92 635.3 69.63 622 49.6zM550.1 239.1l-331.4 227.1C190.1 485.1 155.7 496 121.8 496c-15.17 0-29.55-2.131-42.75-6.332c-19.44-6.174-36.42-19.01-47.8-36.14c-11.35-17.1-16.67-37.79-14.99-58.28c3.695-46.21 32.59-94.24 73.62-122.3L115.8 255.2l70.51 70.51C187.9 327.2 189.9 328 191.1 328s4.094-.7813 5.656-2.344c3.125-3.125 3.125-8.188 0-11.31L129.3 245.1l100.5-68.86l68.57 68.57C299.9 247.2 301.9 248 303.1 248s4.094-.7813 5.656-2.344c3.125-3.125 3.125-8.188 0-11.31L243.2 167.9l100.5-68.86l66.63 66.63C411.9 167.2 413.9 168 415.1 168s4.094-.7813 5.656-2.344c3.125-3.125 3.125-8.188 0-11.31l-64.51-64.51l64.2-43.98C449 26.88 484.3 16 518.2 16c15.15 0 29.52 2.121 42.69 6.303c19.44 6.174 36.42 19.01 47.8 36.14c11.35 17.1 16.67 37.79 14.99 58.28C619.1 162.9 591.1 210.1 550.1 239.1z"],
    "bahai": [512, 512, [], "f666", "M496.3 202.5l-110-15.38l41.88-104.4c5.22-13.1-5.032-25.54-16.94-25.54c-3.21 0-6.506 .8691-9.69 2.912L307.5 120l-34.13-107.1C270.6 4.25 263.4 0 255.1 0c-7.376 0-14.63 4.25-17.38 12.88L204.5 120L110.5 60.12c-3.17-2.008-6.454-2.887-9.649-2.887C88.9 57.24 78.65 69.64 83.88 82.75l41.85 104.4L15.71 202.5C-1.792 205-5.917 228.7 9.71 237.2l98.14 52.63l-74.51 83.5c-10.88 12.25-1.782 31 13.35 31c1.25 0 2.657-.25 4.032-.5l108.6-23.63l-4.126 112.5C154.7 504.4 164.1 512 173.6 512c5.126 0 10.38-2.25 14.25-7.25l68.13-88.88l68.23 88.88C327.1 509.8 333.2 512 338.4 512c9.501 0 18.88-7.625 18.38-19.25l-4.032-112.5l108.5 23.63c1.389 .2988 2.799 .4707 4.108 .4707c15.07 0 24.2-18.78 13.27-30.97l-74.51-83.5l98.14-52.72C517.9 228.8 513.8 205 496.3 202.5zM494.7 223l-98.14 52.75c-4.315 2.32-7.331 6.49-8.181 11.31c-.8517 4.826 .5548 9.775 3.817 13.43l74.54 83.53c.3594 .4023 1.108 1.238 .4337 2.748c-.1113 .2461-.7716 1.441-2.416 1.441c-.0488 0 .0508 .0039 0 0l-108.6-23.63c-1.129-.2441-2.27-.3652-3.405-.3652c-3.713 0-7.355 1.295-10.26 3.721c-3.794 3.168-5.909 7.91-5.733 12.85l4.006 112.6c.043 1.006-.2266 1.434-.5255 1.744C339.8 495.7 339 496 338.4 496l-1.436-.9961l-68.26-88.88c-3.028-3.943-7.718-6.254-12.69-6.254c-4.975 .002-9.673 2.318-12.7 6.266l-68.08 88.81C174.4 496 173.8 496 173.6 496c-.6466 0-1.397-.3301-1.866-.8184c-.2989-.3105-.5685-.7383-.5216-1.846l4.126-112.5c.1817-4.939-1.93-9.686-5.724-12.86c-2.907-2.432-6.548-3.729-10.27-3.729c-1.133 0-2.274 .1191-3.401 .3652l-109.2 23.76c-1.1 0-1.703-1.154-1.864-1.508c-.7032-1.566 .0781-2.447 .4278-2.84l74.51-83.5c3.264-3.658 4.671-8.611 3.817-13.44C122.8 282.3 119.7 278.1 115.4 275.8L17.36 223.2C16.91 222.9 15.71 222.3 16.06 220.3c.3184-1.762 1.397-1.916 1.867-1.982l110-15.38c4.874-.6816 9.164-3.566 11.63-7.824C142 190.9 142.4 185.7 140.6 181.2L98.71 76.83C98.33 75.86 98.37 75.17 98.85 74.46c.3672-.543 .9279-.9707 1.936-.9707c.3165 0 .6778 .041 1.09 .1348l94.01 59.88C198.5 135.2 201.5 136 204.5 136c1.836 0 3.68-.3164 5.45-.957c4.669-1.691 8.288-5.455 9.796-10.19l34.13-107.1C254.2 16.64 254.7 16 256 16s1.782 .6367 2.131 1.73l34.13 107.1c1.506 4.732 5.126 8.496 9.795 10.19C303.8 135.7 305.7 136 307.5 136c3.008 0 5.997-.8496 8.597-2.506l95.14-60.32c.5118 0 1.348 .4297 1.885 1.221c.502 .7422 .5489 1.447 .17 2.396L371.4 181.2c-1.832 4.566-1.461 9.723 1.006 13.98c2.467 4.258 6.757 7.143 11.63 7.824l109.1 15.37c.5215 .0762 1.608 .2305 1.92 1.994C496.3 222.2 495.2 222.8 494.7 223z"],
    "baht-sign": [320, 512, [], "e0ac", "M144 8V64H172C227.2 64 272 108.8 272 164C272 200.5 252.5 232.4 223.3 249.9C269.3 258.9 304 299.4 304 348C304 403.2 259.2 448 204 448H144V504C144 508.4 140.4 512 136 512C131.6 512 128 508.4 128 504V448H53.57C32.82 448 16 431.2 16 410.4V97.39C16 78.95 30.95 64 49.39 64H128V8C128 3.582 131.6 0 136 0C140.4 0 144 3.582 144 8V8zM128 80H49.39C39.79 80 32 87.79 32 97.39V248H128V80zM172 248C218.4 248 256 210.4 256 164C256 117.6 218.4 80 172 80H144V248H172zM128 264H32V410.4C32 422.3 41.66 432 53.57 432H128V264zM204 432C250.4 432 288 394.4 288 348C288 301.6 250.4 264 204 264H144V432H204z"],
    "ball-pile": [576, 512, [], "f77e", "M480 320c-10.42 0-20.28 2.108-29.68 5.174C468.5 307.7 480 283.2 480 256c0-53.02-42.98-96-96-96c-10.42 0-20.28 2.108-29.68 5.174C372.5 147.7 384 123.2 384 96c0-53.02-42.98-96-96-96S192 42.98 192 96c0 27.23 11.47 51.71 29.68 69.17C212.3 162.1 202.4 160 192 160C138.1 160 96 202.1 96 256c0 27.23 11.47 51.71 29.68 69.17C116.3 322.1 106.4 320 96 320c-53.02 0-96 42.98-96 96s42.98 96 96 96s96-42.98 96-96c0-27.23-11.47-51.71-29.68-69.17C171.7 349.9 181.6 352 192 352s20.28-2.108 29.68-5.174C203.5 364.3 192 388.8 192 416c0 53.02 42.98 96 96 96s96-42.98 96-96c0-27.23-11.47-51.71-29.68-69.17C363.7 349.9 373.6 352 384 352s20.28-2.108 29.68-5.174C395.5 364.3 384 388.8 384 416c0 53.02 42.98 96 96 96s96-42.98 96-96S533 320 480 320zM176 416c0 44.11-35.89 80-80 80c-44.11 0-80-35.89-80-80s35.89-80 80-80C140.1 336 176 371.9 176 416zM208 96c0-44.11 35.89-80 80-80c44.11 0 80 35.89 80 80S332.1 176 288 176C243.9 176 208 140.1 208 96zM112 256c0-44.11 35.89-80 80-80c44.11 0 80 35.89 80 80S236.1 336 192 336C147.9 336 112 300.1 112 256zM368 416c0 44.11-35.89 80-80 80c-44.11 0-80-35.89-80-80s35.89-80 80-80C332.1 336 368 371.9 368 416zM288 320c-10.42 0-20.28 2.108-29.68 5.174C276.5 307.7 288 283.2 288 256S276.5 204.3 258.3 186.8C267.7 189.9 277.6 192 288 192s20.28-2.108 29.68-5.174C299.5 204.3 288 228.8 288 256s11.47 51.71 29.68 69.17C308.3 322.1 298.4 320 288 320zM304 256c0-44.11 35.89-80 80-80c44.11 0 80 35.89 80 80s-35.89 80-80 80C339.9 336 304 300.1 304 256zM480 496c-44.11 0-80-35.89-80-80s35.89-80 80-80c44.11 0 80 35.89 80 80S524.1 496 480 496z"],
    "balloon": [384, 512, [], "e2e3", "M384 189.7C384 85.09 297.9 0 192 0S0 85.09 0 189.7c0 86.91 105.8 197.1 159.8 235.5l-37.5 62.56c-3.031 5-3.125 11.03-.25 16.12C124.9 508.9 130.3 512 136 512h112c5.75 0 11.09-3.125 13.94-8.125c2.875-5.094 2.781-11.12-.2187-16.12l-37.53-62.56C278.2 387.7 384 276.6 384 189.7zM248 496H136l38.37-64h35.2L248 496zM208.1 416H175C127.4 386.2 16 273.3 16 189.7C16 93.94 94.97 16 192 16s176 77.94 176 173.7C368 273.3 256.6 386.2 208.1 416zM176 72c-57.34 0-104 46.66-104 104c0 4.406 3.594 8 8 8S88 180.4 88 176c0-48.53 39.47-88 88-88c4.406 0 8-3.594 8-8S180.4 72 176 72z"],
    "balloons": [640, 512, [], "e2e4", "M152 64C103.5 64 64 103.5 64 152C64 156.4 67.59 160 72 160S80 156.4 80 152c0-39.69 32.31-72 72-72C156.4 80 160 76.41 160 72S156.4 64 152 64zM320 166.3C320 74.59 248.2 0 160 0S0 74.59 0 166.3c0 73.25 77.47 170.8 124.1 205.5L97.97 425.5c-2.656 4.719-2.625 10.56 .125 15.22C100.8 445.3 105.4 448 110.6 448h98.75c5.188 0 9.875-2.719 12.53-7.281c2.75-4.656 2.781-10.5 .3438-14.78l-26.34-54.16C242.5 337.1 320 239.5 320 166.3zM209.4 432l-97.25 .9375l26.65-54.76c.123 .0059 .1934 .1328 .3184 .1328h41.81c.168 0 .2676-.1699 .4336-.1797L209.4 432zM181.3 362.5c-.1348-.0078-.2148-.1465-.3516-.1465H139.1c-.1367 0-.2168 .1387-.3516 .1465C94.76 333.3 16 234.8 16 166.3C16 83.41 80.59 16 160 16s144 67.41 144 150.3C304 234.8 225.2 333.3 181.3 362.5zM400 216c0-39.69 32.31-72 72-72C476.4 144 480 140.4 480 136S476.4 128 472 128C423.5 128 384 167.5 384 216C384 220.4 387.6 224 392 224S400 220.4 400 216zM515.9 435.8C562.5 401.1 640 303.5 640 230.3C640 138.6 568.2 64 480 64c-36.78 0-72.69 13.31-101.2 37.47c-3.344 2.844-3.781 7.906-.9062 11.28c2.844 3.375 7.969 3.781 11.28 .9062C414.8 91.97 447 80 480 80c79.41 0 144 67.41 144 150.3c0 68.55-78.76 167-122.7 196.2c-.1348-.0078-.2148-.1465-.3516-.1465h-41.81c-.1211 0-.1895 .123-.3086 .1289c-29.71-19.71-84.91-80.08-110.2-141.5c-1.719-4.062-6.469-6.031-10.47-4.344c-4.062 1.688-6.031 6.375-4.344 10.47c25.28 61.28 77.41 120.2 110.3 144.7l-26.12 53.72c-2.656 4.719-2.625 10.56 .125 15.22C420.8 509.3 425.4 512 430.6 512h98.75c5.188 0 9.875-2.719 12.53-7.281c2.75-4.656 2.781-10.5 .3438-14.78L515.9 435.8zM432.1 496.9l26.65-54.76c.123 .0059 .1934 .1328 .3184 .1328h41.81c.168 0 .2676-.1699 .4336-.1797L529.4 496L432.1 496.9z"],
    "ballot": [448, 512, [], "f732", "M384 0H64C28.66 0 0 28.66 0 64v384c0 35.34 28.66 64 64 64h320c35.34 0 64-28.66 64-64V64C448 28.66 419.3 0 384 0zM432 448c0 26.47-21.53 48-48 48H64c-26.47 0-48-21.53-48-48V64c0-26.47 21.53-48 48-48h320c26.47 0 48 21.53 48 48V448zM376 120h-176C195.6 120 192 123.6 192 128s3.594 8 8 8h176C380.4 136 384 132.4 384 128S380.4 120 376 120zM376 248h-176C195.6 248 192 251.6 192 256s3.594 8 8 8h176C380.4 264 384 260.4 384 256S380.4 248 376 248zM376 376h-176C195.6 376 192 379.6 192 384s3.594 8 8 8h176c4.406 0 8-3.578 8-8S380.4 376 376 376zM104 88h-16c-17.67 0-32 14.33-32 32v16c0 17.67 14.33 32 32 32h16c17.67 0 32-14.33 32-32v-16C136 102.3 121.7 88 104 88zM120 136c0 8.822-7.176 16-16 16h-16c-8.824 0-16-7.178-16-16v-16c0-8.822 7.176-16 16-16h16c8.824 0 16 7.178 16 16V136zM104 216h-16c-17.67 0-32 14.33-32 32v16c0 17.67 14.33 32 32 32h16c17.67 0 32-14.33 32-32v-16C136 230.3 121.7 216 104 216zM120 264c0 8.822-7.176 16-16 16h-16c-8.824 0-16-7.178-16-16v-16c0-8.822 7.176-16 16-16h16c8.824 0 16 7.178 16 16V264zM104 344h-16c-17.67 0-32 14.33-32 32v16c0 17.67 14.33 32 32 32h16c17.67 0 32-14.33 32-32v-16C136 358.3 121.7 344 104 344zM120 392c0 8.822-7.176 16-16 16h-16c-8.824 0-16-7.178-16-16v-16c0-8.822 7.176-16 16-16h16c8.824 0 16 7.178 16 16V392z"],
    "ballot-check": [448, 512, [], "f733", "M384 0H64C28.66 0 0 28.66 0 64v384c0 35.34 28.66 64 64 64h320c35.34 0 64-28.66 64-64V64C448 28.66 419.3 0 384 0zM432 448c0 26.47-21.53 48-48 48H64c-26.47 0-48-21.53-48-48V64c0-26.47 21.53-48 48-48h320c26.47 0 48 21.53 48 48V448zM376 120h-176C195.6 120 192 123.6 192 128s3.594 8 8 8h176C380.4 136 384 132.4 384 128S380.4 120 376 120zM376 248h-176C195.6 248 192 251.6 192 256s3.594 8 8 8h176C380.4 264 384 260.4 384 256S380.4 248 376 248zM376 376h-176C195.6 376 192 379.6 192 384s3.594 8 8 8h176c4.406 0 8-3.578 8-8S380.4 376 376 376zM88 168h16c17.67 0 32-14.33 32-32v-16c0-17.67-14.33-32-32-32h-16c-17.67 0-32 14.33-32 32v16C56 153.7 70.33 168 88 168zM72 120c0-8.822 7.176-16 16-16h16c8.824 0 16 7.178 16 16v16c0 8.822-7.176 16-16 16h-16c-8.824 0-16-7.178-16-16V120zM104 344h-16c-17.67 0-32 14.33-32 32v16c0 17.67 14.33 32 32 32h16c17.67 0 32-14.33 32-32v-16C136 358.3 121.7 344 104 344zM120 392c0 8.822-7.176 16-16 16h-16c-8.824 0-16-7.178-16-16v-16c0-8.822 7.176-16 16-16h16c8.824 0 16 7.178 16 16V392zM154.3 210.3L96 268.7L69.66 242.3c-3.125-3.125-8.188-3.125-11.31 0s-3.125 8.188 0 11.31l32 32C91.91 287.2 93.94 288 96 288s4.094-.7813 5.656-2.344l64-64c3.125-3.125 3.125-8.188 0-11.31S157.5 207.2 154.3 210.3z"],
    "ban": [512, 512, [128683, "cancel"], "f05e", "M512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM80.73 92.04C40.58 134.9 16 192.6 16 256C16 388.5 123.5 496 256 496C319.4 496 377.1 471.4 419.1 431.3L80.73 92.04zM496 256C496 123.5 388.5 16 256 16C192.6 16 134.9 40.58 92.04 80.73L431.3 419.1C471.4 377.1 496 319.4 496 255.1L496 256z"],
    "ban-bug": [512, 512, ["debug"], "f7f9", "M296.8 353.3L308.1 364.7C294.1 376.7 275.9 384 256 384C227.9 384 203.2 369.5 188.9 347.7L148.4 374.7C144.8 377.1 139.8 376.1 137.3 372.4C134.9 368.8 135.9 363.8 139.6 361.3L181.6 333.3C177.1 324.3 176 314.4 176 304V297.2L129.1 303.9C124.8 304.5 120.7 301.5 120.1 297.1C119.5 292.8 122.5 288.7 126.9 288.1L176 281.1V238L125.8 223.7C121.6 222.5 119.1 218.1 120.3 213.8C121.5 209.6 125.1 207.1 130.2 208.3L160.4 216.9L192 248.6V304C192 339.3 220.7 368 256 368C271.5 368 285.7 362.5 296.8 353.3V353.3zM323.1 164.3L363.6 137.3C367.2 134.9 372.2 135.9 374.7 139.6C377.1 143.2 376.1 148.2 372.4 150.7L330.4 178.7C334 187.7 336 197.6 336 208V221.4L381.8 208.3C386.1 207.1 390.5 209.6 391.7 213.8C392.9 218.1 390.5 222.5 386.2 223.7L336 238V279.4L320 263.4V208C320 172.7 291.3 144 256 144C240.5 144 226.3 149.5 215.2 158.7L203.9 147.3C217.9 135.3 236.1 128 256 128C284.1 128 308.8 142.5 323.1 164.4V164.3zM391.9 297.1C391.3 301.5 387.2 304.5 382.9 303.9L356.8 300.2L337.9 281.3L385.1 288.1C389.5 288.7 392.5 292.8 391.9 297.1L391.9 297.1zM0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM256 496C319.4 496 377.1 471.4 419.1 431.3L80.73 92.05C40.58 134.9 16 192.6 16 256C16 388.5 123.5 496 256 496L256 496zM92.04 80.73L431.3 419.1C471.4 377.1 496 319.4 496 255.1C496 123.5 388.5 15.1 255.1 15.1C192.6 15.1 134.9 40.58 92.04 80.73L92.04 80.73z"],
    "ban-parking": [512, 512, ["parking-circle-slash"], "f616", "M176 249.9L192 265.9V288H214.1L230.1 304H192V376C192 380.4 188.4 384 184 384C179.6 384 176 380.4 176 376V249.9zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM80.73 92.04C40.58 134.9 16 192.6 16 256C16 388.5 123.5 496 256 496C319.4 496 377.1 471.4 419.1 431.3L80.73 92.04zM496 256C496 123.5 388.5 16 256 16C192.6 16 134.9 40.58 92.04 80.73L176 164.7V144C176 135.2 183.2 128 192 128H288C336.6 128 376 167.4 376 216C376 256.3 348.9 290.2 312 300.7L431.3 419.1C471.4 377.1 496 319.4 496 256zM298.5 287.2C333.3 282.1 360 252.2 360 216C360 176.2 327.8 144 288 144H192V180.7L298.5 287.2z"],
    "ban-smoking": [512, 512, [128685, "smoking-ban"], "f54d", "M437 74.98c-99.97-99.97-262.1-99.97-362 0s-99.97 262.1 0 362s262.1 99.97 362 0S536.1 174.1 437 74.98zM86.29 425.7c-91.67-91.67-93.29-239.5-5.371-333.5L212.7 224H120C106.8 224 96 234.8 96 248v48C96 309.2 106.8 320 120 320h188.7l111.1 111.1C325.8 519 177.1 517.4 86.29 425.7zM228.7 240l64 64H120C115.6 304 112 300.4 112 296v-48c0-4.406 3.594-8 8-8H228.7zM431.1 419.8L331.3 320H344C348.4 320 352 316.4 352 312S348.4 304 344 304h-28.69l-64-64H344C348.4 240 352 236.4 352 232S348.4 224 344 224H235.3L92.24 80.92C186.2-7 334-5.371 425.7 86.29S519 325.8 431.1 419.8zM336 136h-32c-22.06 0-39.96-17.94-39.96-40c0-4.406-3.629-8-8.035-8S248 91.59 248 96c0 30.88 25.12 56 56 56h32c22.06 0 39.92 17.94 39.92 40c0 4.406 3.677 8 8.083 8S392 196.4 392 192C392 161.1 366.9 136 336 136zM408 224c-4.406 0-8 3.594-8 8v80c0 4.406 3.594 8 8 8S416 316.4 416 312v-80C416 227.6 412.4 224 408 224zM376 224c-4.406 0-8 3.594-8 8v80c0 4.406 3.594 8 8 8S384 316.4 384 312v-80C384 227.6 380.4 224 376 224z"],
    "banana": [576, 512, [], "e2e5", "M294.9 258.1c11.82 0 29.87-60.99 29.87-112.4c0-57.88-17.02-88.49-17.02-99.75c0-18.02 17.67-30.06 33.57-30.06c24.98 0 113.7 83.57 113.7 207.1c0 18.09-1.82 29.93-1.82 31.57c0 4.331 3.522 7.938 7.99 7.938c4.031 0 7.469-2.999 7.938-7.055c1.266-10.95 1.891-21.84 1.891-32.64c0-137.3-98.76-222.9-129.5-222.9c-15.78 0-49.7 11.74-49.7 46.03c0 16.36 16.96 42.31 16.96 99.66c0 63.3-21.8 98.74-21.8 104.5C286.9 253.6 289.7 258.1 294.9 258.1zM576 405.7c0-1.287-.3124-2.592-.969-3.8l-26.56-48.27c-18.76-34.04-53.99-53.83-91.04-53.83c-11.52 0-23.22 1.915-34.65 5.911l-100.9 35.23l-52-47.6c-19.51-17.89-44.94-27.23-70.6-27.23c-15.84 0-31.76 3.561-46.43 10.87L100.4 303.2C97.61 304.6 95.1 307.4 95.1 310.3c0 4.591 3.788 7.96 8.006 7.96c1.213 0 2.44-.2772 3.587-.8612l52.44-26.15C172.4 285.1 185.7 282.1 198.1 282.1c19.39 0 38.63 6.36 54.35 18.47c-49.98 61.31-128.6 97.93-212.6 97.93C18.28 398.5 0 416 0 437.6v32.54c0 21.54 18.37 39.07 40.97 39.07c0 0 66.96 .8468 90.85 .8468c105.2 0 259.3-16.42 322.6-193.9c.9981-.0333 1.995-.0499 2.99-.0499c31.36 0 61.12 16.46 76.97 45.25l26.56 48.27c.7695 1.384 3.427 4.196 7.054 4.196C571.9 413.8 576 410.6 576 405.7zM153.5 495c-22.38 0-37.8-1.718-41.66-1.718L40.97 493.3c-13.78 0-24.97-10.38-24.97-23.15v-32.54c0-12.77 11.09-23.15 24.72-23.15c88.59 0 171.7-38.71 224.7-103.5l49.15 44.99c1.493 1.356 3.406 2.093 5.397 2.093c.8834 0 1.782-.1453 2.666-.4463l105.4-36.81c2.631-.9129 5.301-1.34 7.955-1.997C374.9 476.6 226.8 495 153.5 495z"],
    "bandage": [640, 512, [129657, "band-aid"], "f462", "M256 208C256 199.2 263.2 192 272 192C280.8 192 288 199.2 288 208C288 216.8 280.8 224 272 224C263.2 224 256 216.8 256 208zM384 208C384 216.8 376.8 224 368 224C359.2 224 352 216.8 352 208C352 199.2 359.2 192 368 192C376.8 192 384 199.2 384 208zM256 304C256 295.2 263.2 288 272 288C280.8 288 288 295.2 288 304C288 312.8 280.8 320 272 320C263.2 320 256 312.8 256 304zM384 304C384 312.8 376.8 320 368 320C359.2 320 352 312.8 352 304C352 295.2 359.2 288 368 288C376.8 288 384 295.2 384 304zM560 96C604.2 96 640 131.8 640 176V336C640 380.2 604.2 416 560 416H80C35.82 416 0 380.2 0 336V176C0 131.8 35.82 96 80 96H560zM480 400H560C595.3 400 624 371.3 624 336V176C624 140.7 595.3 112 560 112H480V400zM464 112H176V400H464V112zM160 400V112H80C44.65 112 16 140.7 16 176V336C16 371.3 44.65 400 80 400H160z"],
    "bangladeshi-taka-sign": [384, 512, [], "e2e6", "M32 199.1C32 195.6 35.58 191.1 40 191.1H184C188.4 191.1 192 195.6 192 199.1C192 204.4 188.4 207.1 184 207.1H40C35.58 207.1 32 204.4 32 199.1zM32.06 39.01C32.61 34.62 36.61 31.51 40.99 32.06L48.93 33.05C84.96 37.56 112 68.19 112 104.5V408C112 438.9 137.1 464 168 464H184C285.6 464 368 381.6 368 279.1V263.1C368 233.1 342.9 207.1 312 207.1H264C259.6 207.1 256 204.4 256 199.1C256 195.6 259.6 191.1 264 191.1H312C351.8 191.1 384 224.2 384 263.1V279.1C384 390.5 294.5 480 184 480H168C128.2 480 96 447.8 96 408V104.5C96 76.26 74.97 52.43 46.95 48.93L39.01 47.94C34.62 47.39 31.51 43.39 32.06 39.01V39.01z"],
    "banjo": [512, 512, [129685], "f8a3", "M501.3 37.47l-26.71-26.7C467.6 3.832 458.4 0 448.5 0c-.0156 0 .0156 0 0 0c-9.83 0-19.09 3.844-26.23 11L378.1 58.52c-1.016 1.094-1.688 2.438-1.984 3.891l-15.54 77.66l-78.04 78.04C256.2 194.2 222.1 178.7 184 176.8V168c0-4.422-3.578-8-8-8s-8 3.578-8 8v8.807C129.9 178.7 95.56 193.8 69.06 217.8L62.86 211.5c-3.125-3.125-8.188-3.125-11.31 0c-3.125 3.125-3.125 8.188 0 11.31l6.203 6.203C33.77 255.6 18.72 289.9 16.81 328H8C3.578 328 0 331.6 0 336s3.578 8 8 8H16.81c1.914 38.07 16.97 72.44 40.94 98.94l-6.203 6.203c-3.125 3.125-3.125 8.188 0 11.31c1.563 1.562 3.609 2.344 5.656 2.344s4.094-.7813 5.656-2.344l6.203-6.203c26.5 23.98 60.86 39.03 98.94 40.94V504c0 4.422 3.578 8 8 8s8-3.578 8-8v-8.807c38.07-1.914 72.44-16.97 98.94-40.94l6.203 6.203c1.562 1.562 3.609 2.344 5.656 2.344s4.094-.7813 5.656-2.344c3.125-3.125 3.125-8.188 0-11.31l-6.203-6.203c23.98-26.5 39.03-60.86 40.94-98.94h8.807c4.422 0 8-3.578 8-8s-3.578-8-8-8H335.2c-1.914-38.06-17.43-72.19-41.3-98.58l78.09-78.09l77.6-15.52c1.455-.2969 2.799-.9687 3.893-1.984l47.79-44.42C515.6 75.09 515.6 51.78 501.3 37.47zM320 336c0 79.53-64.47 144-144 144S32 415.5 32 336S96.47 192 176 192S320 256.5 320 336zM490.2 77.89l-45.92 42.67l-66.03 13.2l13.21-66.02l42.43-45.64C437.8 18.17 442.1 16 448.5 16c0 0-.0156 0 0 0c5.549 0 10.78 2.156 14.7 6.078l26.71 26.7C498 56.86 498 70.02 490.2 77.89zM117.7 330.3c-3.125-3.125-8.188-3.125-11.31 0c-3.125 3.125-3.125 8.188 0 11.31l64 64C171.9 407.2 173.1 408 176 408s4.094-.7813 5.656-2.344c3.125-3.125 3.125-8.188 0-11.31L117.7 330.3z"],
    "barcode": [512, 512, [], "f02a", "M0 40C0 35.58 3.582 32 8 32C12.42 32 16 35.58 16 40V472C16 476.4 12.42 480 8 480C3.582 480 0 476.4 0 472V40zM256 40C256 35.58 259.6 32 264 32C268.4 32 272 35.58 272 40V472C272 476.4 268.4 480 264 480C259.6 480 256 476.4 256 472V40zM400 40V472C400 476.4 396.4 480 392 480C387.6 480 384 476.4 384 472V40C384 35.58 387.6 32 392 32C396.4 32 400 35.58 400 40zM304 40C304 35.58 307.6 32 312 32C316.4 32 320 35.58 320 40V472C320 476.4 316.4 480 312 480C307.6 480 304 476.4 304 472V40zM64 40V472C64 476.4 60.42 480 56 480C51.58 480 48 476.4 48 472V40C48 35.58 51.58 32 56 32C60.42 32 64 35.58 64 40zM448 40C448 35.58 451.6 32 456 32C460.4 32 464 35.58 464 40V472C464 476.4 460.4 480 456 480C451.6 480 448 476.4 448 472V40zM512 40V472C512 476.4 508.4 480 504 480C499.6 480 496 476.4 496 472V40C496 35.58 499.6 32 504 32C508.4 32 512 35.58 512 40zM112 40C112 35.58 115.6 32 120 32C124.4 32 128 35.58 128 40V472C128 476.4 124.4 480 120 480C115.6 480 112 476.4 112 472V40zM200 40V472C200 476.4 196.4 480 192 480C187.6 480 184 476.4 184 472V40C184 35.58 187.6 32 192 32C196.4 32 200 35.58 200 40z"],
    "barcode-read": [576, 512, [], "f464", "M40 16C26.75 16 16 26.75 16 40V152C16 156.4 12.42 160 8 160C3.582 160 0 156.4 0 152V40C0 17.91 17.91 0 40 0H152C156.4 0 160 3.582 160 8C160 12.42 156.4 16 152 16H40zM144 136V376C144 380.4 140.4 384 136 384C131.6 384 128 380.4 128 376V136C128 131.6 131.6 128 136 128C140.4 128 144 131.6 144 136zM192 136V376C192 380.4 188.4 384 184 384C179.6 384 176 380.4 176 376V136C176 131.6 179.6 128 184 128C188.4 128 192 131.6 192 136zM240 136C240 131.6 243.6 128 248 128C252.4 128 256 131.6 256 136V376C256 380.4 252.4 384 248 384C243.6 384 240 380.4 240 376V136zM336 136V376C336 380.4 332.4 384 328 384C323.6 384 320 380.4 320 376V136C320 131.6 323.6 128 328 128C332.4 128 336 131.6 336 136zM368 136C368 131.6 371.6 128 376 128C380.4 128 384 131.6 384 136V376C384 380.4 380.4 384 376 384C371.6 384 368 380.4 368 376V136zM448 136V376C448 380.4 444.4 384 440 384C435.6 384 432 380.4 432 376V136C432 131.6 435.6 128 440 128C444.4 128 448 131.6 448 136zM560 40C560 26.75 549.3 16 536 16H424C419.6 16 416 12.42 416 8C416 3.582 419.6 0 424 0H536C558.1 0 576 17.91 576 40V152C576 156.4 572.4 160 568 160C563.6 160 560 156.4 560 152V40zM152 496C156.4 496 160 499.6 160 504C160 508.4 156.4 512 152 512H40C17.91 512 0 494.1 0 472V360C0 355.6 3.582 352 8 352C12.42 352 16 355.6 16 360V472C16 485.3 26.75 496 40 496H152zM560 360C560 355.6 563.6 352 568 352C572.4 352 576 355.6 576 360V472C576 494.1 558.1 512 536 512H424C419.6 512 416 508.4 416 504C416 499.6 419.6 496 424 496H536C549.3 496 560 485.3 560 472V360z"],
    "barcode-scan": [640, 512, [], "f465", "M64 40C64 35.58 67.58 32 72 32C76.42 32 80 35.58 80 40V192H64V40zM64 472V320H80V472C80 476.4 76.42 480 72 480C67.58 480 64 476.4 64 472zM120 480C115.6 480 112 476.4 112 472V320H128V472C128 476.4 124.4 480 120 480zM120 32C124.4 32 128 35.58 128 40V192H112V40C112 35.58 115.6 32 120 32zM176 472V320H192V472C192 476.4 188.4 480 184 480C179.6 480 176 476.4 176 472zM184 32C188.4 32 192 35.58 192 40V192H176V40C176 35.58 179.6 32 184 32zM248 472V320H264V472C264 476.4 260.4 480 256 480C251.6 480 248 476.4 248 472zM256 32C260.4 32 264 35.58 264 40V192H248V40C248 35.58 251.6 32 256 32zM320 472V320H336V472C336 476.4 332.4 480 328 480C323.6 480 320 476.4 320 472zM328 32C332.4 32 336 35.58 336 40V192H320V40C320 35.58 323.6 32 328 32zM368 472V320H384V472C384 476.4 380.4 480 376 480C371.6 480 368 476.4 368 472zM376 32C380.4 32 384 35.58 384 40V192H368V40C368 35.58 371.6 32 376 32zM448 472V320H464V472C464 476.4 460.4 480 456 480C451.6 480 448 476.4 448 472zM456 32C460.4 32 464 35.58 464 40V192H448V40C448 35.58 451.6 32 456 32zM512 472V320H528V472C528 476.4 524.4 480 520 480C515.6 480 512 476.4 512 472zM520 32C524.4 32 528 35.58 528 40V192H512V40C512 35.58 515.6 32 520 32zM560 472V320H576V472C576 476.4 572.4 480 568 480C563.6 480 560 476.4 560 472zM568 32C572.4 32 576 35.58 576 40V192H560V40C560 35.58 563.6 32 568 32zM8 248H632C636.4 248 640 251.6 640 256C640 260.4 636.4 264 632 264H8C3.582 264 0 260.4 0 256C0 251.6 3.582 248 8 248z"],
    "bars": [448, 512, ["navicon"], "f0c9", "M0 88C0 83.58 3.582 80 8 80H440C444.4 80 448 83.58 448 88C448 92.42 444.4 96 440 96H8C3.582 96 0 92.42 0 88zM0 248C0 243.6 3.582 240 8 240H440C444.4 240 448 243.6 448 248C448 252.4 444.4 256 440 256H8C3.582 256 0 252.4 0 248zM440 416H8C3.582 416 0 412.4 0 408C0 403.6 3.582 400 8 400H440C444.4 400 448 403.6 448 408C448 412.4 444.4 416 440 416z"],
    "bars-filter": [448, 512, [], "e0ad", "M0 88C0 83.58 3.582 80 8 80H440C444.4 80 448 83.58 448 88C448 92.42 444.4 96 440 96H8C3.582 96 0 92.42 0 88zM64 248C64 243.6 67.58 240 72 240H376C380.4 240 384 243.6 384 248C384 252.4 380.4 256 376 256H72C67.58 256 64 252.4 64 248zM280 416H168C163.6 416 160 412.4 160 408C160 403.6 163.6 400 168 400H280C284.4 400 288 403.6 288 408C288 412.4 284.4 416 280 416z"],
    "bars-progress": [512, 512, ["tasks-alt"], "f828", "M464 64C490.5 64 512 85.49 512 112V176C512 202.5 490.5 224 464 224H48C21.49 224 0 202.5 0 176V112C0 85.49 21.49 64 48 64H464zM464 80H320V208H464C481.7 208 496 193.7 496 176V112C496 94.33 481.7 80 464 80zM16 112V176C16 193.7 30.33 208 48 208H304V80H48C30.33 80 16 94.33 16 112zM464 288C490.5 288 512 309.5 512 336V400C512 426.5 490.5 448 464 448H48C21.49 448 0 426.5 0 400V336C0 309.5 21.49 288 48 288H464zM464 304H192V432H464C481.7 432 496 417.7 496 400V336C496 318.3 481.7 304 464 304zM16 336V400C16 417.7 30.33 432 48 432H176V304H48C30.33 304 16 318.3 16 336z"],
    "bars-sort": [448, 512, [], "e0ae", "M0 88C0 83.58 3.582 80 8 80H440C444.4 80 448 83.58 448 88C448 92.42 444.4 96 440 96H8C3.582 96 0 92.42 0 88zM0 248C0 243.6 3.582 240 8 240H312C316.4 240 320 243.6 320 248C320 252.4 316.4 256 312 256H8C3.582 256 0 252.4 0 248zM184 416H8C3.582 416 0 412.4 0 408C0 403.6 3.582 400 8 400H184C188.4 400 192 403.6 192 408C192 412.4 188.4 416 184 416z"],
    "bars-staggered": [512, 512, ["reorder", "stream"], "f550", "M0 88C0 83.58 3.582 80 8 80H440C444.4 80 448 83.58 448 88C448 92.42 444.4 96 440 96H8C3.582 96 0 92.42 0 88zM64 248C64 243.6 67.58 240 72 240H504C508.4 240 512 243.6 512 248C512 252.4 508.4 256 504 256H72C67.58 256 64 252.4 64 248zM440 416H8C3.582 416 0 412.4 0 408C0 403.6 3.582 400 8 400H440C444.4 400 448 403.6 448 408C448 412.4 444.4 416 440 416z"],
    "baseball": [512, 512, [129358, 9918, "baseball-ball"], "f433", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM446.4 280.8c16.17-1.574 32.19-.2148 47.94 2.539c-12.63 110.6-100.6 198.5-211.2 210.1C281.3 484.4 280 474.4 280 464.2c0-5.031 .2187-10.03 .625-15.03c.375-4.406-2.906-8.25-7.312-8.625c-4.281-.7813-8.25 2.906-8.625 7.312C264.2 453.3 264 458.7 264 464.2c0 10.59 1.314 20.96 3.076 31.25C263.4 495.6 259.7 496 256 496c-132.3 0-240-107.7-240-240c0-3.738 .3906-7.379 .5605-11.08c10.39 1.781 20.88 3.109 31.6 3.109c6.031 0 12.03-.25 18.03-.8125C70.56 246.8 73.81 242.9 73.41 238.5C73 234.1 68.88 230.7 64.69 231.3c-15.85 1.438-31.55 .0391-47-2.664c12.63-110.6 100.6-198.5 211.2-210.1c1.793 9.93 3.135 19.96 3.135 30.2c0 5.344-.25 10.69-.6875 15.97C230.1 68.22 234.3 72.09 238.6 72.47C238.9 72.5 239.1 72.5 239.3 72.5c4.125 0 7.625-3.156 7.969-7.312c.5-5.781 .75-11.56 .75-17.34c0-10.6-1.316-20.99-3.078-31.28C248.6 16.39 252.3 16 256 16c132.3 0 240 107.7 240 240c0 3.852-.3984 7.602-.5781 11.41c-16.66-2.805-33.57-4.211-50.61-2.5c-4.406 .4375-7.625 4.344-7.188 8.75C438.1 278 441.5 281.2 446.4 280.8zM214.1 125.5C201.4 154.8 180.2 180.1 153.5 198.7C144.9 204.8 135.8 210.1 126.3 214.6c-4 1.875-5.719 6.656-3.812 10.62c1.344 2.906 4.219 4.594 7.219 4.594c1.156 0 2.312-.25 3.406-.7813c10.34-4.875 20.31-10.66 29.66-17.19c28.94-20.25 52.03-47.78 66.75-79.66c1.875-4 .125-8.75-3.906-10.59C221.7 119.8 216.8 121.5 214.1 125.5zM378 283.4c-9.938 4.719-19.59 10.38-28.75 16.78c-29.19 20.47-52.41 48.31-67.16 80.56c-1.844 4-.0625 8.75 3.969 10.59c1.062 .5 2.188 .7187 3.312 .7187c3.031 0 5.938-1.719 7.281-4.688c13.56-29.62 34.91-55.25 61.78-74.06c8.438-5.906 17.31-11.12 26.44-15.47c4-1.906 5.688-6.688 3.781-10.66S381.1 281.6 378 283.4z"],
    "baseball-bat-ball": [640, 512, [], "f432", "M627.3 60.18l-23.63-32.5c-13.44-18.49-33.78-27.68-54.12-27.68c-13.89 0-27.79 4.281-39.51 12.8L307.8 159.7C262.2 192.8 220.4 230.9 183.4 273.4c-24.22 27.88-81.2 88.13-125.5 123.8c-10.36-14.26-30.37-17.48-44.7-7.078c-14.3 10.39-17.47 30.41-7.077 44.7l46.52 64C58.89 507.4 68.64 512 78.55 512c6.516 0 13.11-1.984 18.78-6.109c14.3-10.39 17.47-30.41 7.079-44.7c53.79-35.39 130.1-65.92 158.1-77.89c51.87-22 101.3-49.87 146.9-82.1l202.3-146.7C642.3 131.8 648.9 90.05 627.3 60.18zM87.92 492.1c-6.994 5.082-17.03 3.764-22.35-3.545l-46.52-64c-5.187-7.137-3.598-17.17 3.533-22.35c7.047-5.115 17.07-3.748 22.36 3.535l46.52 64C96.67 477.8 95.08 487.7 87.92 492.1zM95.62 447.8l-.623 .4102l-27.68-38.08l.6094-.4902c27.58-22.18 60.25-53.96 87.21-81.96l46.84 64.45C168.3 407.1 128.2 426.4 95.62 447.8zM603.1 140.6l-202.3 146.8c-44.54 32.33-92.89 59.66-143.8 81.23c-20.38 8.582-27.26 11.43-40.14 16.98L166.3 315.9C177.9 303.6 188.1 292.5 195.5 283.9c36.03-41.38 76.97-78.83 121.7-111.3l202.3-146.9c22.05-16.04 54.05-12.34 71.27 11.34l23.61 32.47C630.7 92.23 625.7 124.1 603.1 140.6zM496.1 352c-44.12 0-79.72 35.75-79.72 80s35.59 80 79.72 80s79.91-35.75 79.91-80S540.2 352 496.1 352zM496.1 496c-35.15 0-63.75-28.71-63.75-64s28.6-64 63.75-64c35.22 0 63.87 28.71 63.87 64S531.3 496 496.1 496z"],
    "basket-shopping": [576, 512, ["shopping-basket"], "f291", "M208 408C208 412.4 204.4 416 200 416C195.6 416 192 412.4 192 408V296C192 291.6 195.6 288 200 288C204.4 288 208 291.6 208 296V408zM288 288C292.4 288 296 291.6 296 296V408C296 412.4 292.4 416 288 416C283.6 416 280 412.4 280 408V296C280 291.6 283.6 288 288 288zM384 408C384 412.4 380.4 416 376 416C371.6 416 368 412.4 368 408V296C368 291.6 371.6 288 376 288C380.4 288 384 291.6 384 296V408zM351 4.193L452.8 192H568C572.4 192 576 195.6 576 200C576 204.4 572.4 208 568 208H540L476.1 463.5C468.1 492 443.4 512 414 512H161.1C132.6 512 107 492 99.88 463.5L36 208H8C3.582 208 0 204.4 0 200C0 195.6 3.582 192 8 192H123.2L224.1 4.193C227.1 .3081 231.9-1.135 235.8 .9692C239.7 3.074 241.1 7.929 239 11.81L141.4 192H434.6L336.1 11.81C334.9 7.929 336.3 3.074 340.2 .9692C344.1-1.135 348.9 .3084 351 4.193H351zM115.4 459.6C120.7 481 139.9 496 161.1 496H414C436.1 496 455.3 481 460.6 459.6L523.5 208H52.49L115.4 459.6z"],
    "basket-shopping-simple": [576, 512, ["shopping-basket-alt"], "e0af", "M128 287.1C128 270.3 142.3 255.1 160 255.1C177.7 255.1 192 270.3 192 287.1C192 305.7 177.7 319.1 160 319.1C142.3 319.1 128 305.7 128 287.1zM160 271.1C151.2 271.1 144 279.2 144 287.1C144 296.8 151.2 303.1 160 303.1C168.8 303.1 176 296.8 176 287.1C176 279.2 168.8 271.1 160 271.1zM448 287.1C448 305.7 433.7 319.1 416 319.1C398.3 319.1 384 305.7 384 287.1C384 270.3 398.3 255.1 416 255.1C433.7 255.1 448 270.3 448 287.1zM416 303.1C424.8 303.1 432 296.8 432 287.1C432 279.2 424.8 271.1 416 271.1C407.2 271.1 400 279.2 400 287.1C400 296.8 407.2 303.1 416 303.1zM336.1 11.81C334.9 7.929 336.3 3.074 340.2 .9692C344.1-1.135 348.9 .3084 351 4.193L452.8 192H568C572.4 192 576 195.6 576 200C576 204.4 572.4 208 568 208H540L476.1 463.5C468.1 492 443.4 512 414 512H161.1C132.6 512 107 492 99.88 463.5L36 208H8C3.582 208 0 204.4 0 200C0 195.6 3.582 192 8 192H123.2L224.1 4.193C227.1 .3081 231.9-1.135 235.8 .9692C239.7 3.074 241.1 7.929 239 11.81L141.4 192H434.6L336.1 11.81zM523.5 208H52.49L115.4 459.6C120.7 481 139.9 496 161.1 496H414C436.1 496 455.3 481 460.6 459.6L523.5 208z"],
    "basketball": [512, 512, [127936, "basketball-ball"], "f434", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM495.1 274.3C486.6 273.2 478.1 272 469.5 272c-51.59 0-98.47 20.04-133.7 52.53L267.3 256l163.7-163.7C471.2 135.2 496 192.7 496 256C496 262.2 495.5 268.2 495.1 274.3zM288 469.5c0-47.17 18.24-90.06 47.84-122.4l83.86 83.86c-35.04 32.8-79.82 55.13-129.5 62.27C289.1 485.4 288 477.5 288 469.5zM347.2 335.8C379.5 306.2 422.4 288 469.5 288c7.965 0 15.86 1.123 23.75 2.156c-7.135 49.73-29.47 94.5-62.27 129.5L347.2 335.8zM419.7 80.99L256 244.7L187.5 176.2C219.1 140.9 240 94.05 240 42.47c0-8.559-1.217-17.05-2.312-25.54C243.8 16.47 249.8 16 256 16C319.3 16 376.8 40.81 419.7 80.99zM164.8 176.2C132.5 205.8 89.64 224 42.47 224C34.5 224 26.61 222.9 18.72 221.8c7.135-49.73 29.47-94.5 62.27-129.5L164.8 176.2zM92.3 80.99c35.04-32.8 79.82-55.13 129.5-62.27C222.9 26.61 224 34.5 224 42.47c0 47.17-18.24 90.06-47.84 122.4L92.3 80.99zM16.93 237.7C25.41 238.8 33.91 240 42.47 240c51.59 0 98.47-20.04 133.7-52.53L244.7 256l-163.7 163.7C40.81 376.8 16 319.3 16 256C16 249.8 16.47 243.8 16.93 237.7zM92.3 431L256 267.3l68.53 68.53C292 371.1 272 417.9 272 469.5c0 8.559 1.217 17.05 2.312 25.54C268.2 495.5 262.2 496 256 496C192.7 496 135.2 471.2 92.3 431z"],
    "basketball-hoop": [640, 512, [], "f435", "M480 224V168c0-13.23-10.78-24-24-24h-272C170.8 144 160 154.8 160 168V224h16V168C176 163.6 179.6 160 184 160h272c4.406 0 8 3.594 8 8V224H480zM632.5 177.7C574 72.24 456.2 0 320 0S65.96 72.24 7.455 177.7C2.328 186.1 0 197.5 0 208.1v118c0 25.43 15.05 48.44 38.35 58.63l109.4 47.86L145.7 414.3l-100.9-44.15C27.29 362.5 16 345.2 16 326.1V208.1c0-8.373 1.883-16.19 5.447-22.62C79.43 80.94 193.8 16 320 16s240.6 64.94 298.6 169.5C622.1 191.9 624 199.7 624 208.1v118c0 19.07-11.29 36.33-28.76 43.97l-100.9 44.15l-2.074 18.37l109.4-47.86C624.9 374.6 640 351.6 640 326.1V208.1C640 197.5 637.7 186.1 632.5 177.7zM520 264C520 259.6 516.4 256 512 256H128C123.6 256 120 259.6 120 264S123.6 272 128 272h25.77l26.29 232.9c.3125 2.938 2.25 5.453 5 6.547c2.656 1.047 5.875 .5781 8.125-1.344l60.24-51.16l61.45 51.21C316.4 511.4 318.2 512 320 512s3.625-.625 5.125-1.859l61.45-51.21l60.24 51.16C448.3 511.3 450.1 512 452 512c1 0 1.999-.1875 2.938-.5625c2.75-1.094 4.688-3.609 5-6.547L486.2 272H512C516.4 272 520 268.4 520 264zM448.8 272l-52.85 44.88L342.1 272H448.8zM383.6 327.4L320 381.4l-63.58-53.1L320 274.4L383.6 327.4zM297.9 272L244 316.9L191.2 272H297.9zM180.9 369.5L170.2 275.2l61.36 52.11L180.9 369.5zM194.3 488.2l-9.783-86.72l56.48 47.07L194.3 488.2zM253.3 438L188.5 384l55.45-46.21l63.71 54.1L253.3 438zM320 493.6l-54.2-45.17L320 402.4l54.2 46.03L320 493.6zM332.3 391.9l63.71-54.1L451.5 384l-64.82 54.03L332.3 391.9zM445.8 488.2l-46.7-39.65l56.48-47.07L445.8 488.2zM459.1 369.5l-50.71-42.26l61.36-52.11L459.1 369.5z"],
    "bat": [640, 512, [], "f6b5", "M639.3 314.1l-79.5-182.3c-4.5-10.2-13.19-18.05-23.87-21.49c-10.72-3.484-22.5-2.188-31.94 3.344l-89.81 46.29l-22.47-89.87c-.625-2.594-2.531-4.688-5.062-5.594c-2.531-.875-5.312-.4844-7.438 1.109l-41.06 30.42H301.8L260.8 65.57C258.6 63.97 255.8 63.58 253.3 64.46c-2.531 .9063-4.437 3-5.062 5.594L225.8 159.9l-89.53-46.07C126.5 108.1 114.8 106.8 104.1 110.3C93.41 113.7 84.66 121.5 80.13 131.8L.6572 314.1c-1.25 2.891-.6875 6.25 1.437 8.578c2.125 2.344 5.312 3.188 8.406 2.234l48.37-15.81c23.25-7.656 48.97 1 62.53 20.95l35.97 53.08c1.344 1.969 3.469 3.234 5.844 3.469c2.406 .375 4.719-.5782 6.375-2.25l11.59-11.39c11.19-10.97 26.56-16.77 42.37-15.48c15.72 1.109 30.16 8.86 39.59 21.24l50.5 66.13C315.2 446.8 317.5 448 319.1 448c2.5 0 4.844-1.156 6.344-3.141l50.47-66.13c9.469-12.38 23.91-20.13 39.62-21.24c16.03-1.234 31.22 4.531 42.37 15.48l11.56 11.39c1.687 1.672 4.031 2.625 6.406 2.25c2.375-.2344 4.5-1.5 5.844-3.469l35.94-53.06c13.56-19.95 39.37-28.58 62.56-20.97l48.37 15.81c3.094 .9688 6.281 .125 8.406-2.234C640 320.4 640.6 317 639.3 314.1zM586.1 293.9c-30.12-9.797-63.25 1.375-80.81 27.2l-30.56 45.11l-4.719-4.641c-14.44-14.19-34.47-21.33-54.72-20.05c-20.31 1.453-38.97 11.47-51.19 27.49L320 426.8l-44.12-57.8c-12.22-16.02-30.87-26.03-51.19-27.49c-20.28-1.266-40.28 5.86-54.69 20.05l-4.749 4.656l-30.59-45.13C117.1 295.2 83.94 284.1 53.88 293.9L22.47 304.2l72.31-165.9C97.47 132.2 102.6 127.5 108.1 125.5C115.4 123.4 122.3 124.3 128.5 127.8l91.81 47.25c.5117 .2695 1.072-.0098 1.609 .1367L216.3 198.1C215.2 202.3 217.8 206.7 222.1 207.8C226.5 208.8 230.7 206.2 231.8 201.9l29.09-116.4l33.56 24.86C295.8 111.4 297.4 111.1 299.2 111.1h41.69c1.719 0 3.375-.5469 4.75-1.578l33.56-24.86l29.09 116.4c.9062 3.641 4.156 6.063 7.75 6.063c.625 0 1.281-.0781 1.938-.2344c4.281-1.078 6.906-5.422 5.812-9.703l-5.705-22.82c.5391-.1465 1.098 .1328 1.611-.1367l92.06-47.45c5.875-3.453 12.84-4.25 19.34-2.141c6.406 2.078 11.44 6.594 14.12 12.7l72.34 165.1L586.1 293.9z"],
    "bath": [512, 512, [128705, "bathtub"], "f2cd", "M504 272H48V53.25C48 32.7 64.72 16 85.25 16c9.812 0 19.44 3.969 26.34 10.91l32.4 32.4C133.8 72.01 128 87.48 128 104c0 19.23 7.5 37.31 21.09 50.91l18.34 18.34L162.3 178.3c-3.125 3.125-3.125 8.188 0 11.31C163.9 191.2 165.9 192 168 192s4.094-.7813 5.656-2.344l112-112c3.125-3.125 3.125-8.188 0-11.31s-8.188-3.125-11.31 0l-5.094 5.094L250.9 53.09C224.8 26.97 183.6 25.49 155.3 48.01L122.9 15.59C113 5.688 99.28 0 85.25 0C55.88 0 32 23.89 32 53.25V272H8C3.594 272 0 275.6 0 280S3.594 288 8 288h496C508.4 288 512 284.5 512 280S508.4 272 504 272zM160.4 64.41c21.81-21.84 57.38-21.84 79.19 0l18.34 18.34L178.8 161.9L160.4 143.6C149.8 133 144 118.1 144 104S149.8 74.98 160.4 64.41zM472 320c-4.406 0-8 3.578-8 8v48c0 48.53-39.47 88-88 88h-240c-48.53 0-88-39.47-88-88v-48C48 323.6 44.41 320 40 320S32 323.6 32 328v48c0 36.78 19.32 68.98 48.22 87.48C80.2 463.7 80 463.8 80 464v40C80 508.4 83.59 512 88 512S96 508.4 96 504v-32.05C108.3 477.1 121.8 480 136 480h240c14.17 0 27.68-2.891 40-8.049V504c0 4.422 3.594 8 8 8s8-3.578 8-8V464c0-.2051-.2012-.3223-.2168-.5234C460.7 444.1 480 412.8 480 376v-48C480 323.6 476.4 320 472 320z"],
    "battery-bolt": [576, 512, [], "f376", "M205 248H327C330.3 248 333.3 250.1 334.5 253.2C335.7 256.3 334.8 259.8 332.3 261.1L215.3 365.1C212 368.9 206.1 368.6 204 365.3C201.1 362 201.4 356.1 204.7 354L305.1 264H184C180.7 264 177.7 261.9 176.5 258.8C175.3 255.7 176.2 252.2 178.7 250L295.7 146C298.1 143.1 304 143.4 306.1 146.7C309.9 149.1 309.6 155 306.3 157.1L205 248zM448 416H80C35.82 416 0 380.2 0 336V176C0 131.8 35.82 96 80 96H448C492.2 96 528 131.8 528 176V192H544C561.7 192 576 206.3 576 224V288C576 305.7 561.7 320 544 320H528V336C528 380.2 492.2 416 448 416zM80 112C44.65 112 16 140.7 16 176V336C16 371.3 44.65 400 80 400H448C483.3 400 512 371.3 512 336V176C512 140.7 483.3 112 448 112H80zM544 304C552.8 304 560 296.8 560 288V224C560 215.2 552.8 208 544 208H528V304H544z"],
    "battery-empty": [576, 512, ["battery-0"], "f244", "M528 320V336C528 380.2 492.2 416 448 416H80C35.82 416 0 380.2 0 336V176C0 131.8 35.82 96 80 96H448C492.2 96 528 131.8 528 176V192H544C561.7 192 576 206.3 576 224V288C576 305.7 561.7 320 544 320H528zM16 336C16 371.3 44.65 400 80 400H448C483.3 400 512 371.3 512 336V176C512 140.7 483.3 112 448 112H80C44.65 112 16 140.7 16 176V336zM528 208V304H544C552.8 304 560 296.8 560 288V224C560 215.2 552.8 208 544 208H528z"],
    "battery-exclamation": [576, 512, [], "e0b0", "M272 144C276.4 144 280 147.6 280 152V296C280 300.4 276.4 304 272 304C267.6 304 264 300.4 264 296V152C264 147.6 267.6 144 272 144zM288 352C288 360.8 280.8 368 272 368C263.2 368 256 360.8 256 352C256 343.2 263.2 336 272 336C280.8 336 288 343.2 288 352zM448 416H80C35.82 416 0 380.2 0 336V176C0 131.8 35.82 96 80 96H448C492.2 96 528 131.8 528 176V192H544C561.7 192 576 206.3 576 224V288C576 305.7 561.7 320 544 320H528V336C528 380.2 492.2 416 448 416zM80 112C44.65 112 16 140.7 16 176V336C16 371.3 44.65 400 80 400H448C483.3 400 512 371.3 512 336V176C512 140.7 483.3 112 448 112H80zM544 304C552.8 304 560 296.8 560 288V224C560 215.2 552.8 208 544 208H528V304H544z"],
    "battery-full": [576, 512, [128267, "battery", "battery-5"], "f240", "M64 208C64 181.5 85.49 160 112 160H416C442.5 160 464 181.5 464 208V304C464 330.5 442.5 352 416 352H112C85.49 352 64 330.5 64 304V208zM80 208V304C80 321.7 94.33 336 112 336H416C433.7 336 448 321.7 448 304V208C448 190.3 433.7 176 416 176H112C94.33 176 80 190.3 80 208zM448 416H80C35.82 416 0 380.2 0 336V176C0 131.8 35.82 96 80 96H448C492.2 96 528 131.8 528 176V192H544C561.7 192 576 206.3 576 224V288C576 305.7 561.7 320 544 320H528V336C528 380.2 492.2 416 448 416zM80 112C44.65 112 16 140.7 16 176V336C16 371.3 44.65 400 80 400H448C483.3 400 512 371.3 512 336V176C512 140.7 483.3 112 448 112H80zM544 304C552.8 304 560 296.8 560 288V224C560 215.2 552.8 208 544 208H528V304H544z"],
    "battery-half": [576, 512, ["battery-3"], "f242", "M64 208C64 181.5 85.49 160 112 160H240C266.5 160 288 181.5 288 208V304C288 330.5 266.5 352 240 352H112C85.49 352 64 330.5 64 304V208zM80 208V304C80 321.7 94.33 336 112 336H240C257.7 336 272 321.7 272 304V208C272 190.3 257.7 176 240 176H112C94.33 176 80 190.3 80 208zM448 416H80C35.82 416 0 380.2 0 336V176C0 131.8 35.82 96 80 96H448C492.2 96 528 131.8 528 176V192H544C561.7 192 576 206.3 576 224V288C576 305.7 561.7 320 544 320H528V336C528 380.2 492.2 416 448 416zM80 112C44.65 112 16 140.7 16 176V336C16 371.3 44.65 400 80 400H448C483.3 400 512 371.3 512 336V176C512 140.7 483.3 112 448 112H80zM544 304C552.8 304 560 296.8 560 288V224C560 215.2 552.8 208 544 208H528V304H544z"],
    "battery-low": [576, 512, ["battery-1"], "e0b1", "M64 208C64 181.5 85.49 160 112 160C138.5 160 160 181.5 160 208V304C160 330.5 138.5 352 112 352C85.49 352 64 330.5 64 304V208zM112 176C94.33 176 80 190.3 80 208V304C80 321.7 94.33 336 112 336C129.7 336 144 321.7 144 304V208C144 190.3 129.7 176 112 176zM448 416H80C35.82 416 0 380.2 0 336V176C0 131.8 35.82 96 80 96H448C492.2 96 528 131.8 528 176V192H544C561.7 192 576 206.3 576 224V288C576 305.7 561.7 320 544 320H528V336C528 380.2 492.2 416 448 416zM80 112C44.65 112 16 140.7 16 176V336C16 371.3 44.65 400 80 400H448C483.3 400 512 371.3 512 336V176C512 140.7 483.3 112 448 112H80zM544 304C552.8 304 560 296.8 560 288V224C560 215.2 552.8 208 544 208H528V304H544z"],
    "battery-quarter": [576, 512, ["battery-2"], "f243", "M64 208C64 181.5 85.49 160 112 160H144C170.5 160 192 181.5 192 208V304C192 330.5 170.5 352 144 352H112C85.49 352 64 330.5 64 304V208zM80 208V304C80 321.7 94.33 336 112 336H144C161.7 336 176 321.7 176 304V208C176 190.3 161.7 176 144 176H112C94.33 176 80 190.3 80 208zM448 416H80C35.82 416 0 380.2 0 336V176C0 131.8 35.82 96 80 96H448C492.2 96 528 131.8 528 176V192H544C561.7 192 576 206.3 576 224V288C576 305.7 561.7 320 544 320H528V336C528 380.2 492.2 416 448 416zM80 112C44.65 112 16 140.7 16 176V336C16 371.3 44.65 400 80 400H448C483.3 400 512 371.3 512 336V176C512 140.7 483.3 112 448 112H80zM544 304C552.8 304 560 296.8 560 288V224C560 215.2 552.8 208 544 208H528V304H544z"],
    "battery-slash": [640, 512, [], "f377", "M636.1 497.7C640.4 500.5 641 505.5 638.3 508.1C635.5 512.4 630.5 513 627 510.3L3.022 14.26C-.4365 11.51-1.012 6.481 1.738 3.022C4.487-.4365 9.52-1.012 12.98 1.738L636.1 497.7zM386.2 400L406.5 416H112C67.82 416 32 380.2 32 336V176C32 159.4 37.06 143.1 45.72 131.2L58.32 141.1C51.79 151.2 48 163.1 48 176V336C48 371.3 76.65 400 112 400L386.2 400zM560 176V192H576C593.7 192 608 206.3 608 224V288C608 305.7 593.7 320 576 320H560V336C560 341.6 559.4 347.1 558.3 352.4L543.8 340.1C543.9 339.3 544 337.7 544 336V176C544 140.7 515.3 112 480 112H253.8L233.5 96H480C524.2 96 560 131.8 560 176H560zM560 208V304H576C584.8 304 592 296.8 592 288V224C592 215.2 584.8 208 576 208H560z"],
    "battery-three-quarters": [576, 512, ["battery-4"], "f241", "M64 208C64 181.5 85.49 160 112 160H336C362.5 160 384 181.5 384 208V304C384 330.5 362.5 352 336 352H112C85.49 352 64 330.5 64 304V208zM80 208V304C80 321.7 94.33 336 112 336H336C353.7 336 368 321.7 368 304V208C368 190.3 353.7 176 336 176H112C94.33 176 80 190.3 80 208zM448 416H80C35.82 416 0 380.2 0 336V176C0 131.8 35.82 96 80 96H448C492.2 96 528 131.8 528 176V192H544C561.7 192 576 206.3 576 224V288C576 305.7 561.7 320 544 320H528V336C528 380.2 492.2 416 448 416zM80 112C44.65 112 16 140.7 16 176V336C16 371.3 44.65 400 80 400H448C483.3 400 512 371.3 512 336V176C512 140.7 483.3 112 448 112H80zM544 304C552.8 304 560 296.8 560 288V224C560 215.2 552.8 208 544 208H528V304H544z"],
    "bed": [640, 512, [128716], "f236", "M528 128H288C279.2 128 272 135.2 272 144V320h-256V40C16 35.59 12.42 32 8 32S0 35.59 0 40v432C0 476.4 3.578 480 8 480s8-3.594 8-8V416h608v56c0 4.406 3.578 8 8 8S640 476.4 640 472V240C640 178.1 589.9 128 528 128zM624 400h-608v-64h608V400zM624 320H288V144h240c52.93 0 96 43.06 96 96V320zM144 288C188.1 288 224 252.1 224 208S188.1 128 144 128S64 163.9 64 208S99.88 288 144 288zM144 144c35.29 0 64 28.71 64 64s-28.71 64-64 64s-64-28.71-64-64S108.7 144 144 144z"],
    "bed-bunk": [576, 512, [], "f8f8", "M464 32H224C215.2 32 208 39.16 208 48V192h-192V8C16 3.594 12.42 0 8 0S0 3.594 0 8v496C0 508.4 3.578 512 8 512s8-3.594 8-8V448h544v56c0 4.406 3.578 8 8 8S576 508.4 576 504V144C576 82.13 525.9 32 464 32zM560 432H224V288h240c52.93 0 96 43.06 96 96V432zM560 327.1C540.5 294.3 505 272 464 272H224C215.2 272 208 279.2 208 288v144h-192v-224h544V327.1zM560 192H224V48h240c52.93 0 96 43.06 96 96V192zM112 400c35.35 0 64-28.65 64-64s-28.65-64-64-64c-35.35 0-64 28.65-64 64S76.65 400 112 400zM112 288C138.5 288 160 309.5 160 336S138.5 384 112 384S64 362.5 64 336S85.53 288 112 288zM112 160c35.35 0 64-28.65 64-64s-28.65-64-64-64c-35.35 0-64 28.65-64 64S76.65 160 112 160zM112 48C138.5 48 160 69.53 160 96S138.5 144 112 144S64 122.5 64 96S85.53 48 112 48z"],
    "bed-empty": [640, 512, [128719], "f8f9", "M528 192h-512V40C16 35.59 12.42 32 8 32S0 35.59 0 40v432C0 476.4 3.578 480 8 480s8-3.594 8-8V416h608v56c0 4.406 3.578 8 8 8S640 476.4 640 472V304C640 242.1 589.9 192 528 192zM624 400h-608v-64h608V400zM624 320h-608V208h512c52.93 0 96 43.06 96 96V320z"],
    "bed-front": [512, 512, ["bed-alt"], "f8f7", "M480 236.2V88C480 57.13 454.9 32 424 32H88C57.13 32 32 57.13 32 88v148.2C12.72 249.1 0 271.1 0 296v176C0 476.4 3.578 480 8 480s8-3.578 8-8V416h480v56c0 4.422 3.578 8 8 8S512 476.4 512 472v-176C512 271.1 499.3 249.1 480 236.2zM72 224C63.54 224 55.54 225.7 48 228.4V168c0-13.23 10.77-24 24-24H224c13.23 0 24 10.77 24 24V224H72zM464 228.4C456.5 225.7 448.5 224 440 224h-176V168c0-13.23 10.77-24 24-24h152c13.23 0 24 10.77 24 24V228.4zM88 48h336c22.06 0 40 17.94 40 40v48.84C457.2 131.6 449.2 128 440 128H288c-13.43 0-24.74 7.074-32 17.25C248.7 135.1 237.4 128 224 128H72C62.82 128 54.76 131.6 48 136.8V88C48 65.94 65.94 48 88 48zM16 400V296c0-30.88 25.12-56 56-56h368c30.88 0 56 25.12 56 56v104H16z"],
    "bed-pulse": [640, 512, ["procedures"], "f487", "M223.8 80h123.3l45.78 91.57C394.2 174.3 396.1 176 400 176h.3438c3.125-.1406 5.906-2.109 7.094-5.031l57.38-143.4l24.03 48.06C490.2 78.29 492.1 80 496 80h136c4.406 0 8-3.59 8-8.012s-3.594-7.986-8-7.986h-131.1l-29.78-59.58c-1.406-2.812-3.656-4.562-7.5-4.422c-3.125 .1406-5.906 2.109-7.094 5.031l-57.38 143.4l-40.03-80.06C357.8 65.72 355 64 352 64L238.6 64.01c-22.5 .0156-38.38 .25-38.59 0c-2.125 0-4.156 .8281-5.656 2.328C192.9 67.83 192 69.87 192 71.99C192 79.99 192 80 223.8 80zM144 320C188.1 320 224 284.1 224 240S188.1 160 144 160S64 195.9 64 240S99.88 320 144 320zM144 176c35.29 0 64 28.71 64 64s-28.71 64-64 64s-64-28.71-64-64S108.7 176 144 176zM528 160h-72C451.6 160 448 163.6 448 168s3.582 8 8 8h72c53.02 0 96 42.98 96 96V352L288 352V176L344 176C348.4 176 352 172.4 352 168S348.4 160 344 160H288C279.2 160 272 167.2 272 176V352h-256V72C16 67.59 12.42 64 8 64S0 67.59 0 72v432C0 508.4 3.578 512 8 512s8-3.594 8-8V448h608v56c0 4.406 3.578 8 8 8S640 508.4 640 504V272C640 210.1 589.9 160 528 160zM624 432h-608v-64h608V432z"],
    "bee": [576, 512, [], "e0b2", "M448 95.1c-27.89 0-55.53 9.735-80.95 23.13C367.3 116.7 368 114.5 368 111.1c0-21.94-8.857-41.8-23.16-56.25l37.17-42.48c2.922-3.344 2.578-8.407-.75-11.31c-3.328-2.875-8.344-2.531-11.28 .75l-37.47 42.83C319.8 36.99 304.5 31.1 288 31.1S256.2 36.99 243.5 45.53L206 2.702C203.1-.5795 198.1-.9232 194.7 1.952C191.4 4.858 191.1 9.921 193.1 13.26l37.17 42.48C216.9 70.2 208 90.06 208 111.1c0 2.467 .6816 4.723 .9004 7.133C183.5 105.7 155.9 95.1 128 95.1C57.34 95.1 0 146.1 0 207.1c0 55.42 46.18 101 106.6 109.9c4.965 .7305 9.353-3.385 9.011-8.393c-.002-.0527 .0039 .0547 0 0C115.4 305.8 112.6 302.7 108.9 302.1C56.29 294.3 16 255.3 16 207.9c0-52.91 50.22-95.96 111.1-95.96c29.58 0 59.19 12.36 85.85 28.33c4.496 11.74 11.34 22.13 20.45 30.45c-51.17 21.08-87.08 71.24-87.05 130C147.2 406.4 288 512 288 512s140.8-105.6 140.8-211.2c.0215-58.78-35.94-108.1-87.11-130c9.115-8.326 16.01-18.7 20.51-30.43C388.9 124.3 418.4 111.1 448 111.1c61.72 0 112 43.05 112 96.04c0 47.29-40.27 86.27-92.91 94.07c-3.684 .5469-6.474 3.652-6.724 7.369c-.0039 .0547 .002-.0547 0 0c-.3418 5.008 4.046 9.125 9.011 8.395C529.8 308.1 576 263.5 576 208C576 146.2 518.7 95.99 448 95.1zM288 491.5c-13.06-10.79-37.52-32.26-61.34-59.52h122.7C325.5 459.3 301.1 480.7 288 491.5zM362.7 415.1H213.3c-15.49-19.59-29.52-41.41-38.82-64h227C392.2 374.6 378.2 396.4 362.7 415.1zM412.8 300.8c0 11.73-2.154 23.52-5.623 35.2H168.8c-3.471-11.69-5.623-23.48-5.623-35.21c-.0039-9.86 1.471-19.43 3.678-28.79h242.2C411.3 281.4 412.8 290.9 412.8 300.8zM376.3 212.5c12.54 12.54 21.82 27.38 28 43.45H171.7C177.9 239.9 187.2 225.1 199.7 212.5c23.56-23.57 54.9-36.56 88.23-36.56S352.7 188.1 376.3 212.5zM322.7 164.8c-11.15-2.842-22.66-4.813-34.7-4.813S264.4 161.1 253.3 164.8C235.9 153.4 224 134.3 224 111.1c0-17.1 6.838-32.58 17.8-44.07l8.18 9.35C251.6 79.05 253.8 79.99 256 79.99c1.875 0 3.75-.6563 5.266-1.969C264.6 75.11 264.9 70.05 262 66.7L254.3 57.84C264.1 51.69 275.6 47.98 288 47.98s23.92 3.707 33.74 9.852l-7.76 8.867c-2.922 3.344-2.578 8.407 .75 11.31C316.3 79.33 318.1 79.99 320 79.99c2.219 0 4.438-.9375 6.016-2.719l8.182-9.35C345.2 79.41 352 94.88 352 111.1C352 134.3 340.1 153.4 322.7 164.8z"],
    "beer-mug": [512, 512, ["beer-foam"], "e0b3", "M115.2 133.3C119.8 130.2 125 128.8 130.2 128.8c8.338-.002 16.79 3.602 23.28 9.684C167.8 151.8 186.9 160 207.1 160s40.23-8.188 54.49-21.54c6.494-6.08 14.94-9.684 23.28-9.684c5.225 0 10.4 1.412 15.03 4.52C310.9 140 322.9 144 335.1 144c39.88 0 71.24-36.47 62.54-77.88c-4.861-23.15-23.39-42.46-46.36-48.12C346.7 16.64 341.3 16 335.1 16c-11.1 0-23.17 3.338-32.71 9.117c-5.84 3.537-12.22 5.328-18.49 5.328c-8.049 0-15.93-2.943-22.33-8.926C248.2 8.178 229.1 0 207.1 0S167.8 8.178 153.5 21.52C147.1 27.5 139.2 30.45 131.2 30.45c-6.277 0-12.65-1.791-18.49-5.328C103.2 19.34 91.1 16 80 16c-5.258-.002-10.67 .6406-16.18 1.998c-22.96 5.658-41.5 24.97-46.36 48.12C8.761 107.5 40.12 144 79.1 144C93.06 144 105.1 140 115.2 133.3zM33.12 69.4c3.625-17.26 17.5-31.68 34.53-35.87C71.78 32.52 75.93 31.1 80 32c8.629 0 17.07 2.352 24.42 6.803C112.7 43.8 121.9 46.45 131.2 46.45c12.32 0 24.13-4.703 33.26-13.24C176.3 22.11 191.8 16 207.1 16S239.7 22.11 251.5 33.2c9.125 8.541 20.94 13.24 33.26 13.24c9.264 0 18.53-2.643 26.78-7.643C318.9 34.35 327.4 32 335.1 32c4.068 0 8.225 .5156 12.35 1.533c17.03 4.195 30.9 18.61 34.53 35.87c3.121 14.86-.2832 29.35-9.588 40.82C364.1 121.5 350.5 128 335.1 128c-9.4 0-18.49-2.764-26.28-7.994c-7.053-4.732-15.33-7.232-23.95-7.232c-12.24 0-24.71 5.104-34.22 14.01C239.7 137.9 224.2 144 207.1 144s-31.7-6.117-43.55-17.22C154.9 117.9 142.5 112.8 130.2 112.8c-8.613 0-16.89 2.5-23.95 7.232C98.49 125.2 89.4 128 79.1 128C65.47 128 51.88 121.5 42.71 110.2C33.4 98.76 29.1 84.26 33.12 69.4zM135.1 232v208c0 4.422 3.579 8 8.001 8s7.999-3.578 7.999-8v-208c0-4.422-3.585-8-8.007-8S135.1 227.6 135.1 232zM439.1 160h-64c-4.418 0-8 3.582-8 8V448c0 26.51-21.49 48-48 48H95.1c-26.51 0-48-21.49-48-48V168c0-4.418-3.582-8-8-8s-8 3.582-8 8L31.1 448c0 35.35 28.65 64 64 64h223.1c35.35 0 64-28.65 64-64l-.0006-11.05l56.21-28.1c24.39-12.19 39.79-37.12 39.79-64.39V200C479.1 177.9 462.1 160 439.1 160zM463.1 344.5c0 21.34-11.86 40.53-30.95 50.08l-49.05 24.52V176h56c13.23 0 24 10.77 24 24V344.5zM199.1 232v208c0 4.422 3.579 8 8.001 8s7.999-3.578 7.999-8v-208c0-4.422-3.584-8-8.006-8S199.1 227.6 199.1 232zM263.1 232v208c0 4.422 3.579 8 8.001 8s7.999-3.578 7.999-8v-208c0-4.422-3.582-8-8.004-8S263.1 227.6 263.1 232z"],
    "beer-mug-empty": [512, 512, ["beer"], "f0fc", "M144 128C139.6 128 136 131.6 136 136v240C136 380.4 139.6 384 144 384s8-3.578 8-8v-240C152 131.6 148.4 128 144 128zM208 128C203.6 128 200 131.6 200 136v240C200 380.4 203.6 384 208 384s8-3.578 8-8v-240C216 131.6 212.4 128 208 128zM272 128c-4.422 0-8 3.578-8 8v240c0 4.422 3.578 8 8 8s8-3.578 8-8v-240C280 131.6 276.4 128 272 128zM440 96H384V64c0-17.67-14.33-32-32-32H64C46.33 32 32 46.33 32 64v352c0 35.35 28.65 64 64 64h224c35.35 0 64-28.65 64-64v-43.05l56.2-28.1C464.8 332.6 480 307.9 480 280.5V136C480 113.9 462.1 96 440 96zM368 416c0 26.47-21.53 48-48 48H96c-26.47 0-48-21.53-48-48V64c0-8.822 7.178-16 16-16h288c8.822 0 16 7.178 16 16V416zM464 280.5c0 21.34-11.86 40.53-30.95 50.08L384 355.1V112h56c13.23 0 24 10.77 24 24V280.5z"],
    "bell": [448, 512, [61602, 128276], "f0f3", "M216 8C216 3.582 219.6 0 224 0C228.4 0 232 3.582 232 8V32L231.1 32.2C316.6 36.36 384 106.3 384 192V228.6C384 270.4 398.2 310.1 424.3 343.6L441.1 364.5C445.6 370.1 448 377.1 448 384.3C448 401.8 433.8 416 416.3 416H31.69C14.19 416 0 401.8 0 384.3C0 377.1 2.449 370.1 6.944 364.5L23.68 343.6C49.78 310.1 64 270.4 64 228.6V192C64 106.3 131.4 36.36 216 32.2L216 32V8zM224 48C144.5 48 80 112.5 80 192V228.6C80 274.1 64.54 318.1 36.17 353.6L19.44 374.5C17.21 377.3 16 380.7 16 384.3C16 392.1 23.02 400 31.69 400H416.3C424.1 400 432 392.1 432 384.3C432 380.7 430.8 377.3 428.6 374.5L411.8 353.6C383.5 318.1 368 274.1 368 228.6V192C368 112.5 303.5 48 224 48zM190.1 481.9C199.1 490.9 211.3 496 224 496C236.7 496 248.9 490.9 257.9 481.9C266.9 472.9 272 460.7 272 448C272 443.6 275.6 440 280 440C284.4 440 288 443.6 288 448C288 464.1 281.3 481.3 269.3 493.3C257.3 505.3 240.1 512 224 512C207 512 190.7 505.3 178.7 493.3C166.7 481.3 160 464.1 160 448C160 443.6 163.6 440 168 440C172.4 440 176 443.6 176 448C176 460.7 181.1 472.9 190.1 481.9z"],
    "bell-concierge": [512, 512, [128718, "concierge-bell"], "f562", "M503.1 432h-496c-4.422 0-8 3.578-8 8S3.578 448 7.1 448h496c4.422 0 8-3.578 8-8S508.4 432 503.1 432zM31.1 392c4.422 0 8-3.578 8-8c0-119.1 96.89-216 216-216s216 96.89 216 216c0 4.422 3.578 8 8 8s8-3.578 8-8c0-125.2-99.8-227.3-224-231.6V80h48c4.422 0 8-3.578 8-8S316.4 64 311.1 64h-112c-4.422 0-8 3.578-8 8s3.578 8 8 8h48v72.4c-124.2 4.266-224 106.4-224 231.6C23.1 388.4 27.58 392 31.1 392z"],
    "bell-exclamation": [448, 512, [], "f848", "M240 320C240 328.8 232.8 336 224 336C215.2 336 208 328.8 208 320C208 311.2 215.2 304 224 304C232.8 304 240 311.2 240 320zM232 264C232 268.4 228.4 272 224 272C219.6 272 216 268.4 216 264V136C216 131.6 219.6 128 224 128C228.4 128 232 131.6 232 136V264zM216 8C216 3.582 219.6 0 224 0C228.4 0 232 3.582 232 8V32L231.1 32.2C316.6 36.36 384 106.3 384 192V228.6C384 270.4 398.2 310.1 424.3 343.6L441.1 364.5C445.6 370.1 448 377.1 448 384.3C448 401.8 433.8 416 416.3 416H31.69C14.19 416 0 401.8 0 384.3C0 377.1 2.449 370.1 6.944 364.5L23.68 343.6C49.78 310.1 64 270.4 64 228.6V192C64 106.3 131.4 36.36 216 32.2L216 32V8zM224 48C144.5 48 80 112.5 80 192V228.6C80 274.1 64.54 318.1 36.17 353.6L19.44 374.5C17.21 377.3 16 380.7 16 384.3C16 392.1 23.02 400 31.69 400H416.3C424.1 400 432 392.1 432 384.3C432 380.7 430.8 377.3 428.6 374.5L411.8 353.6C383.5 318.1 368 274.1 368 228.6V192C368 112.5 303.5 48 224 48zM190.1 481.9C199.1 490.9 211.3 496 224 496C236.7 496 248.9 490.9 257.9 481.9C266.9 472.9 272 460.7 272 448C272 443.6 275.6 440 280 440C284.4 440 288 443.6 288 448C288 464.1 281.3 481.3 269.3 493.3C257.3 505.3 240.1 512 224 512C207 512 190.7 505.3 178.7 493.3C166.7 481.3 160 464.1 160 448C160 443.6 163.6 440 168 440C172.4 440 176 443.6 176 448C176 460.7 181.1 472.9 190.1 481.9z"],
    "bell-on": [640, 512, [128365], "f8fa", "M312 8C312 3.582 315.6 0 320 0C324.4 0 328 3.582 328 8V32L327.1 32.2C412.6 36.36 480 106.3 480 192V228.6C480 270.4 494.2 310.1 520.3 343.6L537.1 364.5C541.6 370.1 544 377.1 544 384.3C544 401.8 529.8 416 512.3 416H127.7C110.2 416 96 401.8 96 384.3C96 377.1 98.45 370.1 102.9 364.5L119.7 343.6C145.8 310.1 160 270.4 160 228.6V192C160 106.3 227.4 36.36 312 32.2L312 32L312 8zM320 48C240.5 48 176 112.5 176 192V228.6C176 274.1 160.5 318.1 132.2 353.6L115.4 374.5C113.2 377.3 112 380.7 112 384.3C112 392.1 119 400 127.7 400H512.3C520.1 400 528 392.1 528 384.3C528 380.7 526.8 377.3 524.6 374.5L507.8 353.6C479.5 318.1 464 274.1 464 228.6V192C464 112.5 399.5 48 319.1 48H320zM286.1 481.9C295.1 490.9 307.3 496 320 496C332.7 496 344.9 490.9 353.9 481.9C362.9 472.9 368 460.7 368 448C368 443.6 371.6 440 376 440C380.4 440 384 443.6 384 448C384 464.1 377.3 481.3 365.3 493.3C353.3 505.3 336.1 512 320 512C303 512 286.7 505.3 274.7 493.3C262.7 481.3 256 464.1 256 448C256 443.6 259.6 440 264 440C268.4 440 272 443.6 272 448C272 460.7 277.1 472.9 286.1 481.9zM0 184C0 179.6 3.582 176 8 176H104C108.4 176 112 179.6 112 184C112 188.4 108.4 192 104 192H8C3.582 192 0 188.4 0 184zM632 176C636.4 176 640 179.6 640 184C640 188.4 636.4 192 632 192H536C531.6 192 528 188.4 528 184C528 179.6 531.6 176 536 176H632zM607.2 36.42C609.1 40.37 607.5 45.18 603.6 47.16L523.6 87.16C519.6 89.13 514.8 87.53 512.8 83.58C510.9 79.63 512.5 74.82 516.4 72.84L596.4 32.84C600.4 30.87 605.2 32.47 607.2 36.42V36.42zM36.42 47.16C32.47 45.18 30.87 40.37 32.84 36.42C34.82 32.47 39.63 30.87 43.58 32.84L123.6 72.84C127.5 74.82 129.1 79.63 127.2 83.58C125.2 87.53 120.4 89.13 116.4 87.16L36.42 47.16z"],
    "bell-plus": [448, 512, [], "f849", "M224 160C228.4 160 232 163.6 232 168V232H296C300.4 232 304 235.6 304 240C304 244.4 300.4 248 296 248H232V312C232 316.4 228.4 320 224 320C219.6 320 216 316.4 216 312V248H152C147.6 248 144 244.4 144 240C144 235.6 147.6 232 152 232H216V168C216 163.6 219.6 160 224 160zM216 8C216 3.582 219.6 0 224 0C228.4 0 232 3.582 232 8V32L231.1 32.2C316.6 36.36 384 106.3 384 192V228.6C384 270.4 398.2 310.1 424.3 343.6L441.1 364.5C445.6 370.1 448 377.1 448 384.3C448 401.8 433.8 416 416.3 416H31.69C14.19 416 0 401.8 0 384.3C0 377.1 2.449 370.1 6.944 364.5L23.68 343.6C49.78 310.1 64 270.4 64 228.6V192C64 106.3 131.4 36.36 216 32.2L216 32V8zM224 48C144.5 48 80 112.5 80 192V228.6C80 274.1 64.54 318.1 36.17 353.6L19.44 374.5C17.21 377.3 16 380.7 16 384.3C16 392.1 23.02 400 31.69 400H416.3C424.1 400 432 392.1 432 384.3C432 380.7 430.8 377.3 428.6 374.5L411.8 353.6C383.5 318.1 368 274.1 368 228.6V192C368 112.5 303.5 48 224 48zM190.1 481.9C199.1 490.9 211.3 496 224 496C236.7 496 248.9 490.9 257.9 481.9C266.9 472.9 272 460.7 272 448C272 443.6 275.6 440 280 440C284.4 440 288 443.6 288 448C288 464.1 281.3 481.3 269.3 493.3C257.3 505.3 240.1 512 224 512C207 512 190.7 505.3 178.7 493.3C166.7 481.3 160 464.1 160 448C160 443.6 163.6 440 168 440C172.4 440 176 443.6 176 448C176 460.7 181.1 472.9 190.1 481.9z"],
    "bell-school": [512, 512, [], "f5d5", "M128 208C128 163.8 163.8 128 208 128C252.2 128 288 163.8 288 208C288 252.2 252.2 288 208 288C163.8 288 128 252.2 128 208zM208 272C243.3 272 272 243.3 272 208C272 172.7 243.3 144 208 144C172.7 144 144 172.7 144 208C144 243.3 172.7 272 208 272zM112 512C85.49 512 64 490.5 64 464V358.1C24.55 320.2 0 266.1 0 208C0 93.12 93.12 0 208 0C322.9 0 416 93.12 416 208C416 266.1 391.4 320.2 352 358.1V464C352 476.3 347.4 487.5 339.8 496H432C445.3 496 456 485.3 456 472V447.3C433.3 443.5 416 423.8 416 400C416 373.5 437.5 352 464 352C490.5 352 512 373.5 512 400C512 423.8 494.7 443.5 472 447.3V472C472 494.1 454.1 512 432 512H112zM208 400C314 400 400 314 400 208C400 101.1 314 16 208 16C101.1 16 16 101.1 16 208C16 314 101.1 400 208 400zM80 371.1V464C80 481.7 94.33 496 112 496H304C321.7 496 336 481.7 336 464V371.1C300.7 399.6 256.3 416 208 416C159.7 416 115.3 399.6 80 371.1zM464 368C446.3 368 432 382.3 432 400C432 417.7 446.3 432 464 432C481.7 432 496 417.7 496 400C496 382.3 481.7 368 464 368z"],
    "bell-school-slash": [640, 512, [], "f5d6", "M480 208C480 233.4 475.4 257.8 467.1 280.4L453.8 269.9C460.4 250.5 464 229.7 464 208C464 101.1 378 16 271.1 16C234.4 16 199.3 26.83 169.6 45.54L156.4 35.08C189.4 12.92 229.2 0 271.1 0C386.9 0 479.1 93.12 479.1 208H480zM274.1 128C310.2 128.1 340.4 153.9 349.3 187.4L274.1 128zM219.8 268.7L225.2 272.9C223.3 271.5 221.6 270.1 219.8 268.7zM271.1 400C303.5 400 333.3 392.4 359.5 378.9L373.2 389.8C343.3 406.5 308.7 416 271.1 416C223.7 416 179.3 399.6 143.1 371.1V464C143.1 481.7 158.3 496 175.1 496H368C385.7 496 400 481.7 400 464V410.9L416 423.5V464C416 476.3 411.4 487.5 403.8 496H496C499.3 496 502.5 495.3 505.4 494.1L518.9 504.8C512.4 509.3 504.5 512 496 512H175.1C149.5 512 127.1 490.5 127.1 464V358.1C88.55 320.2 63.1 266.1 63.1 208C63.1 188.5 66.68 169.6 71.7 151.7L85.41 162.5C81.87 177.1 79.1 192.3 79.1 208C79.1 314 165.1 400 271.1 400V400zM636.1 497.7C640.4 500.5 641 505.5 638.3 508.1C635.5 512.4 630.5 513 627 510.3L3.022 14.26C-.4365 11.51-1.012 6.482 1.738 3.023C4.487-.4358 9.52-1.011 12.98 1.739L636.1 497.7z"],
    "bell-slash": [640, 512, [61943, 128277], "f1f6", "M386.2 400L406.5 416H127.7C110.2 416 95.1 401.8 95.1 384.3C95.1 377.1 98.45 370.1 102.9 364.5L119.7 343.6C145.8 310.1 159.1 270.4 159.1 228.7V221.4L175.9 233.1C174.8 277.5 159.4 319.5 132.2 353.6L115.4 374.5C113.2 377.3 111.1 380.7 111.1 384.3C111.1 392.1 119 400 127.7 400L386.2 400zM311.1 32V8C311.1 3.582 315.6 0 319.1 0C324.4 0 328 3.582 328 8V32L327.1 32.2C412.6 36.36 480 106.3 480 192V228.6C480 254.4 485.4 279.7 495.7 302.1L471.9 284.2C466.7 266.2 464 247.6 464 228.7V192C464 112.5 399.5 48 319.1 48C282 48 247.5 62.7 221.8 86.71L209.1 76.69C236 50.74 272.1 34.16 312 32.2L311.1 32zM286.1 481.9C295.1 490.9 307.3 496 319.1 496C332.7 496 344.9 490.9 353.9 481.9C362.9 472.9 368 460.7 368 448C368 443.6 371.6 440 376 440C380.4 440 384 443.6 384 448C384 464.1 377.3 481.3 365.3 493.3C353.3 505.3 336.1 512 319.1 512C303 512 286.7 505.3 274.7 493.3C262.7 481.3 255.1 464.1 255.1 448C255.1 443.6 259.6 440 263.1 440C268.4 440 271.1 443.6 271.1 448C271.1 460.7 277.1 472.9 286.1 481.9zM636.1 497.7C640.4 500.5 641 505.5 638.3 508.1C635.5 512.4 630.5 513 627 510.3L3.022 14.26C-.4365 11.51-1.012 6.482 1.738 3.023C4.487-.4358 9.52-1.011 12.98 1.739L636.1 497.7z"],
    "bells": [640, 512, [], "f77f", "M282.6 40.08C287.4 41.82 292.1 43.82 296.5 46.04C291.4 49.42 286.5 53.05 281.8 56.91C280.3 56.28 278.7 55.68 277.1 55.1C216.8 33.14 149.1 64.21 127.9 124.5L113.2 164.5C97.8 206.5 69.26 242.5 31.81 267L23.63 272.4C18.57 275.7 15.81 281.6 16.5 287.6C17.19 293.6 21.22 298.7 26.9 300.8L255.9 384.1C255.1 388 254.2 391.9 253.1 395.8L251.9 399.7L21.4 315.8C10.03 311.7 1.976 301.5 .5931 289.5C-.7903 277.5 4.729 265.7 14.86 259L23.04 253.7C57.61 230.1 83.95 197.8 98.16 159L112.8 119C137.1 50.44 213.1 15.09 282.6 40.08V40.08zM279.6 285.8L260.8 234.6C234.7 163.3 271.4 84.41 342.8 58.43C414.1 32.46 493.2 69.21 519.3 140.5L538 191.7C552 229.9 577.8 262.7 611.6 285.3L625.4 294.5C635.4 301.2 640.8 312.1 639.4 324.9C637.9 336.9 629.9 346.1 618.6 351.1L321.1 459.4C309.8 463.5 297.1 460.9 288.3 452.7C279.5 444.5 276 432 279.3 420.5L283.9 404.6C295.1 365.6 293.6 323.1 279.6 285.8H279.6zM294.6 280.3C309.8 321.7 311.4 366.8 299.3 409.1L294.7 424.9C293.1 430.7 294.8 436.9 299.2 441C303.6 445.1 309.1 446.4 315.6 444.4L613.1 336.1C618.7 334 622.7 328.1 623.5 322.1C624.2 317 621.5 311.1 616.5 307.8L602.7 298.6C566.1 274.1 538.2 238.5 523 197.2L504.3 145.1C481.2 82.98 411.3 50.5 348.3 73.46C285.2 96.41 252.8 166.1 275.9 229.1L294.6 280.3zM440 443.7C443.4 440.8 448.4 441.1 451.3 444.4C462.1 456.9 480 461.8 496.2 455.4C512.4 449.1 522.1 433.3 521.5 416.8C521.4 412.4 524.8 408.7 529.2 408.5C533.7 408.4 537.4 411.8 537.5 416.2C538.3 439.3 524.8 461.4 502.1 470.3C479.4 479.3 454.4 472.3 439.2 454.9C436.3 451.6 436.7 446.5 440 443.6V443.7zM185.9 411.9C188.8 408.6 193.9 408.2 197.2 411.1C200.5 414 200.9 419.1 198 422.4C182.9 439.8 157.9 446.7 135.2 437.8C112.5 428.9 98.91 406.8 99.73 383.7C99.88 379.3 103.6 375.8 108 376C112.4 376.2 115.9 379.9 115.7 384.3C115.1 400.8 124.9 416.5 141.1 422.9C157.2 429.3 175.1 424.4 185.9 411.9V411.9z"],
    "bench-tree": [640, 512, [], "e2e7", "M352 352H304v-32H320c17.67 0 32-14.33 32-32V224c0-17.67-14.33-32-32-32H64C46.33 192 32 206.3 32 224v64c0 17.67 14.33 32 32 32h16v32H32c-17.67 0-32 14.33-32 32v16c0 17.67 14.33 32 32 32v72C32 508.4 35.59 512 40 512s8-3.594 8-8V432h288v72c0 4.406 3.594 8 8 8S352 508.4 352 504V432c17.67 0 32-14.33 32-32V384C384 366.3 369.7 352 352 352zM64 304C55.18 304 48 296.8 48 288V224c0-8.822 7.178-16 16-16h256c8.822 0 16 7.178 16 16v64c0 8.822-7.178 16-16 16H304V256c0-4.406-3.594-8-8-8S288 251.6 288 256v48H96V256c0-4.406-3.594-8-8-8S80 251.6 80 256v48H64zM288 320v32H96v-32H288zM368 400c0 8.822-7.178 16-16 16H32c-8.822 0-16-7.178-16-16V384c0-8.822 7.178-16 16-16h320c8.822 0 16 7.178 16 16V400zM606.5 111.1C607.3 106.2 608 101.2 608 96c0-53.02-42.98-96-96-96s-96 42.98-96 96c0 5.174 .7363 10.15 1.523 15.11C397.3 125.6 384 149.2 384 176C384 220.2 419.8 256 464 256h40v248c0 4.406 3.594 8 8 8s8-3.594 8-8V256h40C604.2 256 640 220.2 640 176C640 149.2 626.7 125.6 606.5 111.1zM560 240h-40V96c0-4.406-3.594-8-8-8S504 91.59 504 96v144H464c-35.29 0-64-28.71-64-64c0-20.43 10.04-39.83 26.85-51.9c4.918-3.529 7.424-9.531 6.473-15.51C432.6 104 432 99.94 432 96c0-44.11 35.89-80 80-80s80 35.89 80 80c0 3.936-.5996 8.031-1.324 12.59c-.9512 5.979 1.555 11.98 6.473 15.51C613.1 136.2 624 155.6 624 176C624 211.3 595.3 240 560 240z"],
    "bezier-curve": [640, 512, [], "f55b", "M551.8 320H568C590.1 320 608 337.9 608 360V408C608 430.1 590.1 448 568 448H520C497.9 448 480 430.1 480 408V360C480 337.9 497.9 320 520 320H535.8C532.2 231.3 468.3 158 384 140.2V152C384 174.1 366.1 192 344 192H296C273.9 192 256 174.1 256 152V140.2C171.7 158 107.8 231.3 104.2 320H120C142.1 320 160 337.9 160 360V408C160 430.1 142.1 448 120 448H72C49.91 448 32 430.1 32 408V360C32 337.9 49.91 320 72 320H88.15C91.29 236.1 143.1 166.4 215.9 136H112C111.8 136 111.6 135.1 111.4 135.1C107.6 163.1 84.22 184 56 184C25.07 184 0 158.9 0 128C0 97.07 25.07 72 56 72C84.22 72 107.6 92.87 111.4 120C111.6 120 111.8 120 112 120H256V104C256 81.91 273.9 64 296 64H344C366.1 64 384 81.91 384 104V120H528C528.2 120 528.4 120 528.6 120C532.4 92.87 555.8 72 584 72C614.9 72 640 97.07 640 128C640 158.9 614.9 184 584 184C555.8 184 532.4 163.1 528.6 135.1C528.4 135.1 528.2 136 528 136H424.1C496.9 166.4 548.7 236.1 551.8 320zM344 80H296C282.7 80 272 90.75 272 104V152C272 165.3 282.7 176 296 176H344C357.3 176 368 165.3 368 152V104C368 90.75 357.3 80 344 80zM56 88C33.91 88 16 105.9 16 128C16 150.1 33.91 168 56 168C78.09 168 96 150.1 96 128C96 105.9 78.09 88 56 88zM584 88C561.9 88 544 105.9 544 128C544 150.1 561.9 168 584 168C606.1 168 624 150.1 624 128C624 105.9 606.1 88 584 88zM72 336C58.75 336 48 346.7 48 360V408C48 421.3 58.75 432 72 432H120C133.3 432 144 421.3 144 408V360C144 346.7 133.3 336 120 336H72zM496 408C496 421.3 506.7 432 520 432H568C581.3 432 592 421.3 592 408V360C592 346.7 581.3 336 568 336H520C506.7 336 496 346.7 496 360V408z"],
    "bicycle": [640, 512, [128690], "f206", "M347.1 32C353.1 32 358.6 35.36 361.4 40.7L460.8 234.6C476.5 227.8 493.8 224 512 224C582.7 224 640 281.3 640 352C640 422.7 582.7 480 512 480C441.3 480 384 422.7 384 352C384 305.2 409.1 264.3 446.6 241.1L416.8 183.8L327.1 355.7C325.7 358.3 322.1 360 320 360H255.8C251.6 426.1 196 480 128 480C57.31 480 0 422.7 0 352C0 281.3 57.31 224 128 224C140.9 224 153.4 225.9 165.2 229.5L192.1 168.5L155.6 112H104C99.58 112 96 108.4 96 104C96 99.58 99.58 96 104 96H160C162.7 96 165.2 97.38 166.7 99.66L205.6 160H402.8C403.4 160 404 160 404.6 160.1L347.1 48H295.1C291.6 48 287.1 44.42 287.1 40C287.1 35.58 291.6 32 295.1 32L347.1 32zM400 352C400 413.9 450.1 464 512 464C573.9 464 624 413.9 624 352C624 290.1 573.9 240 512 240C496.4 240 481.6 243.2 468.1 248.9L519.1 348.3C521.1 352.3 519.6 357.1 515.7 359.1C511.7 361.1 506.9 359.6 504.9 355.7L453.9 256.2C421.6 275.9 400 311.4 400 352V352zM158.7 244.3C148.9 241.5 138.7 240 127.1 240C66.14 240 15.1 290.1 15.1 352C15.1 413.9 66.14 464 127.1 464C187.2 464 235.6 418.1 239.7 360H124.9C116.8 360 111.4 351.7 114.7 344.3L158.7 244.3zM305.3 344L202.5 184.6L132.3 344H305.3zM215.1 176L319.3 336.1L402.8 176H215.1z"],
    "binary": [384, 512, [], "e33b", "M312 208H376C380.4 208 384 211.6 384 216C384 220.4 380.4 224 376 224H232C227.6 224 224 220.4 224 216C224 211.6 227.6 208 232 208H296V19.54L242.8 39.49C238.7 41.04 234.1 38.95 232.5 34.81C230.1 30.67 233.1 26.06 237.2 24.51L301.2 .5094C303.6-.4118 306.4-.0698 308.6 1.425C310.7 2.919 312 5.376 312 8V208zM88 496H152C156.4 496 160 499.6 160 504C160 508.4 156.4 512 152 512H8C3.582 512 0 508.4 0 504C0 499.6 3.582 496 8 496H72V307.5L18.81 327.5C14.67 329 10.06 326.9 8.509 322.8C6.958 318.7 9.054 314.1 13.19 312.5L77.19 288.5C79.65 287.6 82.4 287.9 84.56 289.4C86.71 290.9 88 293.4 88 296V496zM16 64C16 28.65 44.65 0 80 0H112C147.3 0 176 28.65 176 64V160C176 195.3 147.3 224 112 224H80C44.65 224 16 195.3 16 160V64zM80 16C53.49 16 32 37.49 32 64V160C32 186.5 53.49 208 80 208H112C138.5 208 160 186.5 160 160V64C160 37.49 138.5 16 112 16H80zM304 288C339.3 288 368 316.7 368 352V448C368 483.3 339.3 512 304 512H272C236.7 512 208 483.3 208 448V352C208 316.7 236.7 288 272 288H304zM224 448C224 474.5 245.5 496 272 496H304C330.5 496 352 474.5 352 448V352C352 325.5 330.5 304 304 304H272C245.5 304 224 325.5 224 352V448z"],
    "binary-circle-check": [640, 512, [], "e33c", "M312 208H376C380.4 208 384 211.6 384 216C384 220.4 380.4 224 376 224H232C227.6 224 224 220.4 224 216C224 211.6 227.6 208 232 208H296V19.54L242.8 39.49C238.7 41.04 234.1 38.95 232.5 34.81C230.1 30.67 233.1 26.06 237.2 24.51L301.2 .5094C303.6-.4118 306.4-.0698 308.6 1.425C310.7 2.919 312 5.376 312 8V208zM88 496H152C156.4 496 160 499.6 160 504C160 508.4 156.4 512 152 512H8C3.582 512 0 508.4 0 504C0 499.6 3.582 496 8 496H72V307.5L18.81 327.5C14.67 329 10.06 326.9 8.509 322.8C6.958 318.7 9.054 314.1 13.19 312.5L77.19 288.5C79.65 287.6 82.4 287.9 84.56 289.4C86.71 290.9 88 293.4 88 296V496zM16 64C16 28.65 44.65 0 80 0H112C147.3 0 176 28.65 176 64V160C176 195.3 147.3 224 112 224H80C44.65 224 16 195.3 16 160V64zM80 16C53.49 16 32 37.49 32 64V160C32 186.5 53.49 208 80 208H112C138.5 208 160 186.5 160 160V64C160 37.49 138.5 16 112 16H80zM304 288C312.5 288 320.6 289.7 328.1 292.7C325.9 297.5 323.9 302.5 322.2 307.6C316.6 305.3 310.4 304 304 304H272C245.5 304 224 325.5 224 352V448C224 474.5 245.5 496 272 496H304C321.3 496 336.5 486.8 344.9 473.1C348.1 477.7 351.6 482.1 355.2 486.4C343.5 501.1 324.9 512 304 512H272C236.7 512 208 483.3 208 448V352C208 316.7 236.7 288 272 288H304zM565.7 322.3C568.8 325.5 568.8 330.5 565.7 333.7L485.7 413.7C482.5 416.8 477.5 416.8 474.3 413.7L426.3 365.7C423.2 362.5 423.2 357.5 426.3 354.3C429.5 351.2 434.5 351.2 437.7 354.3L480 396.7L554.3 322.3C557.5 319.2 562.5 319.2 565.7 322.3H565.7zM352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368zM496 496C566.7 496 624 438.7 624 368C624 297.3 566.7 240 496 240C425.3 240 368 297.3 368 368C368 438.7 425.3 496 496 496z"],
    "binary-lock": [640, 512, [], "e33d", "M308.6 1.425C310.7 2.919 312 5.376 312 8V208H376C380.4 208 384 211.6 384 216C384 220.4 380.4 224 376 224H232C227.6 224 224 220.4 224 216C224 211.6 227.6 208 232 208H296V19.54L242.8 39.49C238.7 41.04 234.1 38.95 232.5 34.81C230.1 30.67 233.1 26.06 237.2 24.51L301.2 .5094C303.6-.4118 306.4-.0698 308.6 1.425V1.425zM84.56 289.4C86.71 290.9 88 293.4 88 296V496H152C156.4 496 160 499.6 160 504C160 508.4 156.4 512 152 512H8C3.582 512 0 508.4 0 504C0 499.6 3.582 496 8 496H72V307.5L18.81 327.5C14.67 329 10.06 326.9 8.509 322.8C6.958 318.7 9.054 314.1 13.19 312.5L77.19 288.5C79.65 287.6 82.4 287.9 84.56 289.4zM112 0C147.3 0 176 28.65 176 64V160C176 195.3 147.3 224 112 224H80C44.65 224 16 195.3 16 160V64C16 28.65 44.65 0 80 0H112zM32 160C32 186.5 53.49 208 80 208H112C138.5 208 160 186.5 160 160V64C160 37.49 138.5 16 112 16H80C53.49 16 32 37.49 32 64V160zM208 352C208 316.7 236.7 288 272 288H304C339.3 288 368 316.7 368 352V448C368 483.3 339.3 512 304 512H272C236.7 512 208 483.3 208 448V352zM272 304C245.5 304 224 325.5 224 352V448C224 474.5 245.5 496 272 496H304C330.5 496 352 474.5 352 448V352C352 325.5 330.5 304 304 304H272zM528 192C563.3 192 592 220.7 592 256V320H608C625.7 320 640 334.3 640 352V480C640 497.7 625.7 512 608 512H448C430.3 512 416 497.7 416 480V352C416 334.3 430.3 320 448 320H464V256C464 220.7 492.7 192 528 192zM528 208C501.5 208 480 229.5 480 256V320H576V256C576 229.5 554.5 208 528 208zM432 352V480C432 488.8 439.2 496 448 496H608C616.8 496 624 488.8 624 480V352C624 343.2 616.8 336 608 336H448C439.2 336 432 343.2 432 352z"],
    "binary-slash": [640, 512, [], "e33e", "M636.1 497.7C640.4 500.5 641 505.5 638.3 508.1C635.5 512.4 630.5 513 627 510.3L3.022 14.26C-.4365 11.51-1.012 6.481 1.738 3.022C4.487-.4365 9.52-1.012 12.98 1.738L636.1 497.7zM395.7 224L375.4 208H424V19.54L370.8 39.49C366.7 41.04 362.1 38.95 360.5 34.81C358.1 30.67 361.1 26.06 365.2 24.51L429.2 .5101C431.6-.4112 434.4-.0691 436.6 1.425C438.7 2.92 440 5.377 440 8.001V208H504C508.4 208 512 211.6 512 216C512 220.4 508.4 224 504 224H395.7zM303.1 64V151.6L287.1 139V64C287.1 37.49 266.5 16 239.1 16H207.1C189.4 16 173.2 26.61 165.3 42.11L152.5 32.05C163.6 12.9 184.3 .0006 207.1 .0006H239.1C275.3 .0006 303.1 28.65 303.1 64V64zM336 448V360.4L352 372.1V448C352 474.5 373.5 496 400 496H432C450.6 496 466.8 485.4 474.7 469.9L487.5 479.9C476.4 499.1 455.7 512 432 512H400C364.7 512 336 483.3 336 448zM215.1 496H279.1C284.4 496 287.1 499.6 287.1 504C287.1 508.4 284.4 512 279.1 512H135.1C131.6 512 127.1 508.4 127.1 504C127.1 499.6 131.6 496 135.1 496H199.1V307.5L146.8 327.5C142.7 329 138.1 326.9 136.5 322.8C134.1 318.7 137.1 314.1 141.2 312.5L205.2 288.5C207.6 287.6 210.4 287.9 212.6 289.4C214.7 290.9 215.1 293.4 215.1 296V496z"],
    "binoculars": [512, 512, [], "f1e5", "M432.1 128.1C431.6 110.5 417.7 96 400.1 96L400 64c0-17.67-14.33-32-32-32H320c-17.67 0-32 14.33-32 32v32H224V64c0-17.67-14.33-32-32-32H144c-17.67 0-32 14.33-32 32v32C94.38 96 80.35 110.5 79.88 128.1C77.34 221.9 19.5 242.3 16 372V448c0 17.6 14.4 32 32 32H192c17.6 0 32-14.4 32-32V288h64v160c0 17.6 14.4 32 32 32h144c17.6 0 32-14.4 32-32v-76C492.5 242.3 434.7 221.9 432.1 128.1zM208 448c0 8.822-7.176 16-16 16H48C39.18 464 32 456.8 32 448l-.0039-75.57C33.8 305.6 50.41 269.9 66.49 235.4C80.95 204.3 94.61 174.9 95.87 128.5C96.12 119.3 103.2 112 112 112h96V448zM208 96H128V64c0-8.838 7.164-16 16-16H192c8.836 0 16 7.162 16 16V96zM288 272H224v-160h64V272zM304 64c0-8.838 7.164-16 16-16h48C376.8 48 384 55.16 384 64v32h-80V64zM480 448c0 8.822-7.176 16-16 16H320c-8.824 0-16-7.178-16-16V112h96.13c8.723 0 15.76 7.421 16.01 16.69c1.254 46.41 14.91 75.61 29.38 106.7C461.6 269.9 478.2 305.6 480 372V448z"],
    "biohazard": [576, 512, [9763], "f780", "M575.5 283.5c-13.13-39.11-39.5-71.98-74.13-92.35c-17.5-10.37-36.25-16.62-55.25-19.87c6-17.75 10-36.49 10-56.24c0-40.99-14.5-80.73-41-112.2C413.5 .9473 411.4 0 409.1 0c-1.363 0-2.747 .3516-4.027 1.061c-3.25 1.875-4.75 5.998-3.625 9.748c4.5 13.75 6.625 26.24 6.625 38.49c0 67.73-53.76 122.8-120 122.8s-120-55.11-120-122.8c0-12.12 2.25-24.74 6.625-38.49c1.125-3.75-.375-7.873-3.625-9.748C169.8 .3516 168.4 0 167.1 0C164.8 0 162.6 .9473 161.1 2.811C134.7 34.3 120.1 74.04 120.1 115c0 19.75 3.875 38.49 10 56.24C111.2 174.5 92.32 180.8 74.82 191.1c-34.63 20.49-61.01 53.24-74.38 92.35c-1.25 3.75 .25 7.748 3.5 9.748c1.322 .7832 2.761 1.164 4.171 1.164c2.188 0 4.309-.916 5.829-2.664c9.377-10.87 19-19.12 29.25-25.12c18.84-11.14 39.44-16.44 59.79-16.44c41.48 0 81.88 22.02 104.1 61.43c33.13 58.61 13.38 133.1-43.88 167.8c-10.25 6.123-22 10.37-35.88 13.37c-3.627 .875-6.377 4.25-6.377 8.123c.125 4 2.75 7.248 6.502 7.998C138 510.1 148.7 512 159.2 512c29.25 0 58.04-7.772 83.47-22.82c18-10.5 32.88-24.49 45.25-39.99c12.38 15.5 27.38 29.49 45.38 39.99C358.7 504.2 387.5 512 416.7 512c10.58 0 21.2-1.018 31.73-3.076c3.875-.75 6.375-3.998 6.5-7.998c0-3.873-2.625-7.248-6.375-8.123c-13.88-2.873-25.63-7.248-35.75-13.37c-57.38-33.87-77.01-109.2-44-167.8c22.23-39.4 62.63-61.43 104.1-61.43c20.36 0 40.99 5.296 59.87 16.44c10.12 6.123 19.75 14.25 29.13 25.12c1.52 1.748 3.689 2.664 5.884 2.664c1.416 0 2.844-.3809 4.118-1.164C575.4 291.2 576.9 287.2 575.5 283.5zM540.1 252.8c-20.69-12.21-44.21-18.66-68.01-18.66c-48.63 0-93.87 26.66-118.1 69.58c-37.3 66.24-14.95 151.2 49.67 189.4c1.541 .9316 3.111 1.828 4.709 2.689c-23.95-1.205-47.24-8.199-67.88-20.45c-14.98-8.738-28.75-20.9-40.94-36.15l-12.5-15.65l-12.5 15.65c-12.25 15.34-25.98 27.51-40.9 36.21c-20.62 12.2-43.93 19.19-67.84 20.4c1.576-.8379 3.119-1.707 4.627-2.607C236.1 454.9 258.4 369.9 221 303.7C196.8 260.8 151.6 234.2 102.1 234.2c-23.79 0-47.28 6.457-67.87 18.63c-1.121 .6562-2.236 1.336-3.342 2.035c12.98-20.49 30.47-37.67 51.21-49.94c14.66-8.689 31.42-14.7 49.81-17.87l18.56-3.191L145.2 166C139.1 148.3 136.1 131.6 136.1 115c0-24.04 5.572-47.72 16.06-69.24c-.0371 1.174-.0547 2.344-.0547 3.508c0 76.56 61.01 138.8 136 138.8c74.1 0 136-62.29 136-138.8c0-1.201-.0176-2.406-.0527-3.613c10.48 21.48 16.06 45.21 16.06 69.34c0 16.17-2.994 32.89-9.156 51.11l-5.998 17.74l18.46 3.156c18.33 3.133 35.08 9.143 49.84 17.89c20.78 12.22 38.25 29.4 51.19 50.07C543.3 254.3 542.2 253.5 540.1 252.8zM287.1 224.1c-26.5 0-48 21.49-48 47.99c0 26.49 21.5 47.99 48 47.99c26.5 0 48.01-21.49 48.01-47.99C335.1 245.6 314.5 224.1 287.1 224.1zM287.1 304.1c-17.65 0-32-14.35-32-31.99c0-17.64 14.36-31.99 32-31.99c17.65 0 32.01 14.35 32.01 31.99C319.1 289.8 305.6 304.1 287.1 304.1zM226.5 90.23c40.28-13.62 82.86-13.56 123.1 .0625c.8438 .2813 1.719 .4219 2.562 .4219c3.328 0 6.438-2.094 7.578-5.438c1.422-4.172-.8281-8.719-5.016-10.14C311.2 60.38 265 60.38 221.4 75.08C217.2 76.48 214.1 81.03 216.4 85.22C217.8 89.39 222.3 91.69 226.5 90.23zM477.9 298.8c-6.391 45.61-29.06 87.44-63.88 117.8c-3.328 2.906-3.672 7.969-.7656 11.3c1.578 1.812 3.797 2.734 6.031 2.734c1.875 0 3.75-.6562 5.266-1.969c37.69-32.89 62.27-78.22 69.19-127.6c.6094-4.375-2.438-8.422-6.812-9.031C482.6 291.4 478.5 294.4 477.9 298.8zM156.7 430.6c2.234 0 4.453-.9219 6.031-2.734c2.906-3.328 2.562-8.391-.7656-11.3c-34.8-30.36-57.47-72.19-63.86-117.8c-.625-4.391-4.828-7.328-9.031-6.812C84.69 292.6 81.64 296.6 82.25 301c6.922 49.41 31.48 94.72 69.17 127.6C152.9 429.1 154.8 430.6 156.7 430.6z"],
    "bird": [512, 512, [], "e469", "M320 111.1C320 103.2 327.2 95.1 336 95.1C344.8 95.1 352 103.2 352 111.1C352 120.8 344.8 127.1 336 127.1C327.2 127.1 320 120.8 320 111.1zM284.8 388.4L350.9 499.9C353.1 503.7 351.9 508.6 348.1 510.9C344.3 513.1 339.4 511.9 337.1 508.1L269 393.1C251.6 397.6 233.4 400 214.7 400C209.2 400 203.7 399.8 198.3 399.4L254.1 500.1C257.1 503.9 255.8 508.8 251.9 510.1C248.1 513.1 243.2 511.8 241 507.9L178.6 396.1C77.69 379.8 0 292.2 0 186.7C0 171.9 11.94 160 26.67 160H192C209.7 160 224 145.7 224 128V104C224 46.56 270.6 0 328 0C374.5 0 413.8 30.5 427.2 72.57L508.1 121.1C510.5 122.6 512 125.2 512 127.1C512 130.8 510.5 133.4 508.1 134.9L432 180.5V183.1C432 278.8 370.1 359.3 284.8 388.4V388.4zM240 103.1V127.1C240 154.5 218.5 175.1 192 175.1H26.67C20.78 175.1 16 180.8 16 186.7C16 295.5 105.5 384 214.7 384C325.2 384 416 294.3 416 183.1V103.1C416 96.77 415.1 89.74 413.5 83.02L413 82.74L413.3 82.28C403.6 44.18 369.1 15.1 328 15.1C279.4 15.1 240 55.4 240 103.1zM432 161.9L488.5 127.1L431.5 93.83C431.8 97.18 432 100.6 432 103.1L432 161.9z"],
    "bitcoin-sign": [320, 512, [], "e0b4", "M80 8C80 3.582 83.58 0 88 0C92.42 0 96 3.582 96 8V64H160V8C160 3.582 163.6 0 168 0C172.4 0 176 3.582 176 8V64.08C229.4 66.18 272 110.1 272 164C272 200.5 252.5 232.4 223.3 249.9C269.3 258.9 304 299.4 304 348C304 403.2 259.2 448 204 448H176V504C176 508.4 172.4 512 168 512C163.6 512 160 508.4 160 504V448H96V504C96 508.4 92.42 512 88 512C83.58 512 80 508.4 80 504V448H53.57C32.82 448 16 431.2 16 410.4V97.39C16 78.95 30.95 64 49.39 64H80V8zM32 97.39V248H172C218.4 248 256 210.4 256 164C256 117.6 218.4 80 172 80H49.39C39.79 80 32 87.79 32 97.39V97.39zM32 264V410.4C32 422.3 41.66 432 53.57 432H204C250.4 432 288 394.4 288 348C288 301.6 250.4 264 204 264H32z"],
    "blanket": [448, 512, [], "f498", "M400 384H88c-4.422 0-8 3.578-8 8s3.578 8 8 8h312c26.47 0 48-21.53 48-48V104C448 64.3 415.7 32 376 32h-304C32.3 32 0 64.3 0 104v288C0 440.5 39.47 480 88 480h352c4.422 0 8-3.578 8-8s-3.578-8-8-8h-352c-39.7 0-72-32.3-72-72S48.3 320 88 320h312c17.64 0 32 14.36 32 32S417.6 384 400 384zM400 304H88c-29.79 0-56.07 14.96-72 37.67V104c0-30.88 25.12-56 56-56h304c30.88 0 56 25.12 56 56v212.5C423.5 308.8 412.3 304 400 304z"],
    "blanket-fire": [640, 512, [], "e3da", "M104 352C99.52 352 96 355.6 96 360s3.52 8 8 8h144C252.5 368 256 364.4 256 360S252.5 352 248 352H104zM272 264C272 259.6 268.5 256 264 256H96C62.72 256 33.28 273.1 16 298.9V72c0-30.91 24.96-56 56-56h304c31.04 0 56 25.09 56 56v16C432 92.42 435.5 96 440 96S448 92.42 448 88v-16C448 32.22 415.7 0 376 0h-304C32.32 0 0 32.22 0 72V352c0 53.02 42.88 96 96 96h168c4.48 0 8-3.584 8-8S268.5 432 264 432H96c-44.16 0-80-35.81-80-80S51.84 272 96 272h168C268.5 272 272 268.4 272 264zM614.4 252.2c-16-31.78-38.4-64.99-64.96-89.98c-2.883-2.943-7.68-2.943-10.88-.0313C526.7 173.3 515.8 187.5 506.2 200L504 202.9c-20.48-26.37-42.56-50.56-66.56-72.77c-3.203-2.848-7.68-2.848-10.88-.0332c-36.16 33.28-66.56 71.01-88 107.1C317.1 273 304 308.2 304 336c0 95.74 74.24 176 168 176c92.8 0 168-80.22 168-176C640 314.1 630.1 283.7 614.4 252.2zM472 496c-84.16 0-152-72.26-152-160c0-23.58 11.52-55.68 32.32-90.59C371.8 212.5 399.4 177.1 432 146.1c23.68 22.5 45.44 47.01 65.6 73.82C499.2 222.8 501.4 223.1 504 224c2.238 .0313 4.801-1.088 6.398-3.039c2.883-3.904 6.082-7.969 9.281-12.06C527.4 198.7 535.4 188.3 544 179.2c22.4 22.75 41.92 51.87 56 80.13C615.4 290.2 624 318.7 624 336C624 423.7 555.2 496 472 496zM549.4 319.8c-1.922-4.096-4.16-8.832-7.363-13.63c-1.598-2.016-3.84-3.232-6.398-3.328c-2.559-.0645-4.801 1.023-6.398 2.945l-29.76 36.19l-2.879-4.064l-20.48-27.26c-15.04-20.06-30.72-40.86-32.64-43.52C441.9 265.2 439.7 264 437.1 264c-2.562 0-4.801 1.152-6.402 3.104c-15.04 19.36-26.56 35.04-34.56 49.18C388.5 330.6 384 343.7 384 358.1c0 27.68 9.922 50.3 26.24 66.02C426.6 439.8 448.1 448 473.3 448c19.84 0 37.44-5.793 53.76-17.18v-.1289c33.6-24.64 42.24-73.15 22.72-110.8L549.4 319.8zM517.8 417.7C504 427.3 489.6 432 473.3 432c-20.8 0-39.04-6.977-52.16-19.42C408.3 400.2 400 381.9 400 358.1c0-10.85 3.199-21.31 10.24-34.05c6.082-11.01 15.04-23.39 26.88-38.85c6.398 8.416 16.32 21.82 26.24 35.04l20.48 27.26l6.719 8.865l1.602 2.496l.6406 .6387v.2246c1.598 1.984 3.84 3.137 6.398 3.199c2.562 .0645 4.801-1.023 6.402-2.912l28.8-35.13l.9609 2.016v.2246C551.7 358.8 544.3 398.3 517.8 417.7z"],
    "blender": [512, 512, [], "f517", "M416 384H160c-35.35 0-64 28.65-64 64l-.0001 32c0 17.67 14.33 32 32 32h320c17.67 0 32-14.33 32-32l.0003-32C480 412.7 451.3 384 416 384zM464 480c0 8.822-7.178 16-16 16H128c-8.822 0-16-7.178-16-16v-32c0-26.47 21.53-48 48-48h256c26.47 0 48 21.53 48 48V480zM152 352.7c.4219 4.406 4.313 7.594 8.703 7.234c4.406-.4062 7.641-4.312 7.234-8.703L136.8 16h356.9l-16.37 64h-149.3c-4.422 0-8 3.578-8 8S323.6 96 328 96h145.2l-20.47 80h-124.8c-4.422 0-8 3.578-8 8S323.6 192 328 192h120.7l-20.47 80h-100.2c-4.422 0-8 3.578-8 8S323.6 288 328 288h96.12l-15.87 62.02c-1.094 4.281 1.484 8.641 5.766 9.734C414.7 359.9 415.3 360 416 360c3.578 0 6.828-2.406 7.75-6.016l88-344c.6094-2.391 .0781-4.938-1.438-6.891S506.5 0 504 0H40C17.94 0 0 17.94 0 40v176C0 238.1 17.94 256 40 256h103L152 352.7zM40 240c-13.23 0-24-10.77-24-24v-176c0-13.23 10.77-24 24-24h80.71l20.84 224H40zM288 416c-17.67 0-32 14.33-32 32s14.33 32 32 32c17.67 0 32-14.33 32-32S305.7 416 288 416zM288 464c-8.822 0-16-7.178-16-16s7.178-16 16-16s16 7.178 16 16S296.8 464 288 464z"],
    "blender-phone": [576, 512, [], "f6b6", "M479.1 384H224c-35.34 0-63.1 28.65-63.1 63.1l-.0052 32c0 17.67 14.33 31.1 31.1 31.1L511.1 512c17.67 0 32-14.33 32-31.1l.0019-31.1C543.1 412.7 515.3 384 479.1 384zM528 480c0 8.822-7.178 16-15.1 16H192c-8.822 0-15.1-7.178-15.1-16v-32c0-26.47 21.53-48 47.1-48h255.1c26.47 0 47.1 21.53 47.1 48V480zM224.7 359.1c4.406-.4062 7.64-4.312 7.234-8.703L200.8 16h356.9l-16.37 64h-149.3c-4.422 0-7.1 3.578-7.1 8S387.6 96 392 96h145.2L516.8 176h-124.8c-4.422 0-7.1 3.578-7.1 8S387.6 192 392 192h120.7l-20.47 80h-100.2c-4.422 0-7.1 3.578-7.1 8S387.6 288 392 288h96.11l-15.86 62.02c-1.094 4.281 1.484 8.641 5.765 9.734c4.603 1.178 8.726-1.819 9.734-5.766l87.1-344C577 4.942 573.2 0 567.1 0L191.1 .006c-6.085 0-8.239 5.639-7.958 8.728l31.1 344C216.4 357.1 220.5 360.3 224.7 359.1zM167.4 326L142.8 265.4C138.8 255.6 128.7 249.7 118.1 250.6L81.23 254.2c-13.41-40.33-13.41-84.02 0-124.3l36.83 3.578c10.48 1.203 20.77-5 24.73-14.75l24.61-60.5c4.547-10.7 .5469-23-9.515-29.23L120.3 5.875C103.5-4.391 81.53-.8594 68.12 14.2c-91.58 102.5-90.73 256.5 1.984 358.1C77.18 380 87.1 384.1 98.89 384.1c7.437 0 14.91-1.891 21.27-5.797l37.76-23.14C167.8 349 171.8 336.8 167.4 326zM149.5 341.5l-37.73 23.12c-9.031 5.547-23.27 4.062-29.89-3.125C-5.252 265.1-6.049 121.2 80.07 24.84c8.611-9.687 22.08-11.26 31.84-5.328L149.5 42.61c3.297 2.047 4.641 5.984 3.156 9.484L127.1 112.7C126.7 115.9 123 117.1 119.6 117.6L70.39 112.8c-6.521 17.66-30.47 76.05 0 158.6l49.26-4.797c3.687-.1875 7.015 1.656 8.328 4.891l24.66 60.61C154 335.5 152.7 339.5 149.5 341.5zM352 416c-17.67 0-31.1 14.33-31.1 31.1s14.33 31.1 31.1 31.1c17.67 0 31.1-14.33 31.1-31.1S369.7 416 352 416zM352 464c-8.822 0-15.1-7.178-15.1-16s7.178-16 15.1-16c8.822 0 15.1 7.178 15.1 16S360.8 464 352 464z"],
    "blinds": [512, 512, [], "f8fb", "M479.1 0H32C14.33 0 .0014 14.33 .0014 32v32c0 17.67 14.33 32 31.1 32h103.1v160.8C113.3 260.6 96 280.2 96 304c0 26.51 21.49 48 47.1 48s47.1-21.49 47.1-48c0-23.77-17.32-43.37-39.1-47.19V96h327.1c17.67 0 31.1-14.33 31.1-32V32C511.1 14.33 497.7 0 479.1 0zM176 304c0 17.64-14.36 32-31.1 32s-31.1-14.36-31.1-32s14.36-32 31.1-32S176 286.4 176 304zM495.1 64c0 8.822-7.178 16-16 16H32C23.18 80 16 72.82 16 64L16 32c0-8.822 7.178-16 15.1-16h447.1c8.822 0 15.1 7.178 15.1 16L495.1 64zM184 216c0 4.422 3.579 8 8.001 8h311.1c2.5 0 4.844-1.156 6.359-3.141s2.016-4.562 1.359-6.969l-23.1-88c-1.156-4.25-5.469-6.766-9.828-5.609C473.6 121.4 471.1 125.8 472.3 130.1L493.5 208h-301.5C187.6 208 184 211.6 184 216zM34.11 120.3c-4.25-1.109-8.672 1.391-9.828 5.609l-23.1 88C-.3736 216.3 .1264 218.9 1.642 220.9S5.501 224 8.001 224h87.1c4.422 0 7.1-3.578 7.1-8S100.4 208 96 208H18.47l21.25-77.89C40.88 125.8 38.38 121.4 34.11 120.3zM487.4 252.8c-1.75-4.062-6.516-5.938-10.52-4.203c-4.062 1.75-5.937 6.453-4.203 10.52L491.9 304h-267.9c-4.422 0-7.1 3.578-7.1 8S219.6 320 224 320h279.1c2.688 0 5.203-1.344 6.672-3.594c1.484-2.25 1.734-5.078 .6875-7.562L487.4 252.8zM1.33 316.4C2.798 318.7 5.314 320 8.001 320h55.1c4.422 0 7.1-3.578 7.1-8S68.42 304 64 304H20.13l19.23-44.84c1.734-4.062-.1406-8.766-4.203-10.52C31.09 246.9 26.41 248.8 24.64 252.8l-23.1 56C-.4048 311.3-.1549 314.2 1.33 316.4zM487.4 348.8c-1.75-4.078-6.516-5.922-10.52-4.203c-4.062 1.75-5.937 6.453-4.203 10.52L491.9 400H20.13l19.23-44.84c1.734-4.062-.1406-8.766-4.203-10.52c-4.062-1.734-8.75 .125-10.52 4.203l-23.1 56c-1.047 2.484-.7969 5.312 .6875 7.562C2.798 414.7 5.314 416 8.001 416H503.1c2.688 0 5.203-1.344 6.672-3.594c1.484-2.25 1.734-5.078 .6875-7.562L487.4 348.8zM487.4 444.8c-1.75-4.078-6.516-5.891-10.52-4.203c-4.062 1.75-5.937 6.453-4.203 10.52L491.9 496H20.13l19.23-44.84c1.734-4.062-.1406-8.766-4.203-10.52c-4.062-1.719-8.75 .125-10.52 4.203l-23.1 56c-1.047 2.484-.7969 5.312 .6875 7.562C2.798 510.7 5.314 512 8.001 512H503.1c2.688 0 5.203-1.344 6.672-3.594c1.484-2.25 1.734-5.078 .6875-7.562L487.4 444.8z"],
    "blinds-open": [512, 512, [], "f8fc", "M480 0H32C14.33 0 0 14.33 0 32v32c0 17.67 14.33 32 32 32h104v160.8C113.3 260.6 96 280.2 96 304c0 26.51 21.49 48.12 48 48.12S192 330.5 192 304c0-23.77-17.32-43.37-40-47.19V96H480c17.67 0 32-14.33 32-32V32C512 14.33 497.7 0 480 0zM176 304c0 17.64-14.36 32-32 32s-32-14.36-32-32s14.36-32 32-32S176 286.4 176 304zM496 64c0 8.822-7.178 16-16 16H32C23.18 80 16 72.82 16 64V32c0-8.822 7.178-16 16-16h448c8.822 0 16 7.178 16 16V64zM504 176H192c-4.422 0-8 3.578-8 8S187.6 192 192 192h312C508.4 192 512 188.4 512 184S508.4 176 504 176zM8 192H96c4.422 0 8-3.578 8-8S100.4 176 96 176H8C3.578 176 0 179.6 0 184S3.578 192 8 192zM504 336H224c-4.422 0-8 3.578-8 8S219.6 352 224 352h280c4.422 0 8-3.578 8-8S508.4 336 504 336zM8 352H64c4.422 0 8-3.578 8-8S68.42 336 64 336H8C3.578 336 0 339.6 0 344S3.578 352 8 352zM504 496H8C3.578 496 0 499.6 0 504S3.578 512 8 512h496c4.422 0 8-3.578 8-8S508.4 496 504 496z"],
    "blinds-raised": [512, 512, [], "f8fd", "M480 0H32C14.33 0 0 14.33 0 32v32c0 17.67 14.33 32 32 32h104v320.8C113.3 420.6 96 440.2 96 464C96 490.5 117.5 512 144 512S192 490.5 192 464c0-23.77-17.32-43.37-40-47.19V96H480c17.67 0 32-14.33 32-32V32C512 14.33 497.7 0 480 0zM176 464c0 17.64-14.36 32-32 32s-32-14.36-32-32s14.36-32 32-32S176 446.4 176 464zM496 63.99C496 72.81 488.8 80 480 80H32c-8.822 0-16.01-7.186-16.01-16.01L16 32c0-8.822 7.178-16 16-16h448c8.822 0 16 7.178 16 16L496 63.99zM487.4 220.8c-1.766-4.062-6.484-5.906-10.52-4.203c-4.062 1.75-5.938 6.453-4.203 10.52L491.9 272H192c-4.422 0-8 3.578-8 8s3.579 7.93 8.001 7.93L504 288c2.688 0 5.203-1.344 6.672-3.594c1.484-2.25 1.734-5.078 .6875-7.562L487.4 220.8zM104 280C104 275.6 100.4 272 96 272H20.13l19.23-44.84C41.09 223.1 39.22 218.4 35.16 216.6C31.11 214.9 26.39 216.8 24.64 220.8l-24 56C-.4063 279.3-.1563 282.2 1.328 284.4C2.797 286.7 5.313 288 8 288H96C100.4 288 104 284.4 104 280zM487.4 124.8c-1.766-4.078-6.484-5.922-10.52-4.203c-4.062 1.75-5.938 6.453-4.203 10.52L491.9 176H192c-4.422 0-8 3.578-8 8s3.579 7.953 8.001 7.953L504 192c2.688 0 5.203-1.344 6.672-3.594c1.484-2.25 1.734-5.078 .6875-7.562L487.4 124.8zM35.16 120.6C31.11 118.9 26.39 120.8 24.64 124.8l-24 56C-.4063 183.3-.1563 186.2 1.328 188.4C2.797 190.7 5.313 192 8 192H96c4.422 0 8-3.578 8-8S100.4 176 96 176H20.13l19.23-44.84C41.09 127.1 39.22 122.4 35.16 120.6z"],
    "block": [448, 512, [], "e46a", "M96 112C96 120.8 88.84 128 80 128C71.16 128 64 120.8 64 112C64 103.2 71.16 96 80 96C88.84 96 96 103.2 96 112zM352 112C352 103.2 359.2 96 368 96C376.8 96 384 103.2 384 112C384 120.8 376.8 128 368 128C359.2 128 352 120.8 352 112zM96 400C96 408.8 88.84 416 80 416C71.16 416 64 408.8 64 400C64 391.2 71.16 384 80 384C88.84 384 96 391.2 96 400zM352 400C352 391.2 359.2 384 368 384C376.8 384 384 391.2 384 400C384 408.8 376.8 416 368 416C359.2 416 352 408.8 352 400zM384 32C419.3 32 448 60.65 448 96V416C448 451.3 419.3 480 384 480H64C28.65 480 0 451.3 0 416V96C0 60.65 28.65 32 64 32H384zM384 48H64C37.49 48 16 69.49 16 96V416C16 442.5 37.49 464 64 464H384C410.5 464 432 442.5 432 416V96C432 69.49 410.5 48 384 48z"],
    "block-brick": [448, 512, ["wall-brick"], "e3db", "M0 96C0 60.65 28.65 32 64 32H384C419.3 32 448 60.65 448 96V416C448 451.3 419.3 480 384 480H64C28.65 480 0 451.3 0 416V96zM128 128H320V48H128V128zM112 128V48H64C37.49 48 16 69.49 16 96V128H112zM16 144V248H216V144H16zM112 368V264H16V368H112zM16 384V416C16 442.5 37.49 464 64 464H216V384H16zM128 368H320V264H128V368zM432 368V264H336V368H432zM432 384H232V464H384C410.5 464 432 442.5 432 416V384zM232 144V248H432V144H232zM432 128V96C432 69.49 410.5 48 384 48H336V128H432z"],
    "block-brick-fire": [640, 512, ["firewall"], "e3dc", "M160 368H288.8C289.3 373.4 290 378.7 290.1 384H264V464H324.8C328.8 469.6 333 474.9 337.6 480H96C60.65 480 32 451.3 32 416V96C32 60.65 60.65 32 96 32H416C451.3 32 480 60.65 480 96V144.6C478.3 143 476.7 141.5 474.1 139.1C471.6 136.1 467.9 134.5 464 132.6V96C464 69.49 442.5 48 416 48H368V144H264V248H321.1C318.8 253.2 315.9 258.6 313 264H160L160 368zM160 128H352V48H160V128zM144 128V48H96C69.49 48 48 69.49 48 96V128H144zM48 144V248H248V144H48zM144 368V264H48V368H144zM48 384V416C48 442.5 69.49 464 96 464H248V384H48zM441.7 256C444.1 256 446.4 257.1 447.9 259C450.1 261.8 467.3 283.6 483.8 304.7L510.3 338.5L543.7 299.6C545.3 297.8 547.6 296.7 550 296.8C552.5 296.9 554.7 298.1 556.2 300C559.9 305 562.4 309.1 564.6 314.3L564.6 314.4C586.1 353.9 576.8 404.8 540 430.5L539.9 430.6C522 442.5 502.9 448.5 481.4 448.5C454.8 448.5 430.5 439.1 412.7 423.7C394.8 407.3 384 383.6 384 354.5C384 339.4 388.8 325.6 397.5 310.6C406.1 295.8 418.9 279.3 435.4 258.1C436.1 257.1 439.3 255.1 441.7 255.1V256zM503.8 356.1L471.2 314.6C459.1 300.2 448.5 285.6 441.6 276.8C428.2 293.5 418.2 306.8 411.3 318.6C403.5 332.1 400 343.1 400 354.5C400 379.4 409.1 398.7 423.5 411.9C437.9 425.1 458.2 432.5 481.4 432.5C499.6 432.5 515.7 427.5 530.9 417.4C560.3 396.8 568.6 355.1 550.5 321.9L550.3 321.6C549.8 320.5 549.2 319.4 548.7 318.4L516.1 356.4C514.6 358.2 512.3 359.2 509.9 359.2C507.5 359.1 505.2 357.1 503.8 356.1L503.8 356.1zM498.4 209.1C502 213.2 505.6 217.3 509 221.5C512.3 217.4 515.8 213.1 519.4 208.9C524.4 202.1 529.9 197.1 535.5 191.1C541.1 186.9 549.9 186.9 555.5 192C580.2 214.7 601.1 244.7 615.8 273.2C630.4 301.2 640 329.9 640 350.1C640 437.9 568.7 512 480 512C390.3 512 320 437.8 320 350.1C320 323.7 332.7 291.5 352.4 259.5C372.4 227.2 400.5 193.4 433.8 163.7C439.4 158.7 447.1 158.8 453.5 163.8C469.3 177.1 484.3 193.1 498.4 209.1V209.1zM509.2 237.5C504.4 237.5 499.8 235.4 496.7 231.7C480.2 211.8 462.5 193.4 443.6 176.4C411.8 204.9 384.1 237.2 366 267.9C346.9 298.1 336 328.1 336 350.1C336 429.4 399.5 496 480 496C559.6 496 624 429.4 624 350.1C624 333.8 615.8 307.9 601.6 280.5C587.7 253.6 568.1 225.6 545.5 204.6C537.1 212.3 529.1 221.9 521.6 231.4C518.6 235.2 514 237.4 509.2 237.5H509.2zM510.1 351.2L503.8 356.1z"],
    "block-question": [448, 512, [], "e3dd", "M192 144C169.9 144 152 161.9 152 184V192C152 196.4 148.4 200 144 200C139.6 200 136 196.4 136 192V184C136 153.1 161.1 128 192 128H247.8C283.3 128 312 156.7 312 192.2C312 214.7 300.2 235.6 280.8 247.2L235.9 274.2C233.5 275.6 232 278.2 232 281.1V303.1C232 308.4 228.4 311.1 224 311.1C219.6 311.1 216 308.4 216 303.1V281.1C216 272.6 220.4 264.8 227.7 260.5L272.6 233.5C287.1 224.8 296 209.1 296 192.2C296 165.6 274.4 144 247.8 144H192zM208 368C208 359.2 215.2 352 224 352C232.8 352 240 359.2 240 368C240 376.8 232.8 384 224 384C215.2 384 208 376.8 208 368zM96 112C96 120.8 88.84 128 80 128C71.16 128 64 120.8 64 112C64 103.2 71.16 96 80 96C88.84 96 96 103.2 96 112zM352 112C352 103.2 359.2 96 368 96C376.8 96 384 103.2 384 112C384 120.8 376.8 128 368 128C359.2 128 352 120.8 352 112zM96 400C96 408.8 88.84 416 80 416C71.16 416 64 408.8 64 400C64 391.2 71.16 384 80 384C88.84 384 96 391.2 96 400zM352 400C352 391.2 359.2 384 368 384C376.8 384 384 391.2 384 400C384 408.8 376.8 416 368 416C359.2 416 352 408.8 352 400zM384 32C419.3 32 448 60.65 448 96V416C448 451.3 419.3 480 384 480H64C28.65 480 0 451.3 0 416V96C0 60.65 28.65 32 64 32H384zM384 48H64C37.49 48 16 69.49 16 96V416C16 442.5 37.49 464 64 464H384C410.5 464 432 442.5 432 416V96C432 69.49 410.5 48 384 48z"],
    "block-quote": [448, 512, [], "e0b5", "M440 88C444.4 88 448 91.58 448 96C448 100.4 444.4 104 440 104H8C3.582 104 0 100.4 0 96C0 91.58 3.582 88 8 88H440zM440 248C444.4 248 448 251.6 448 256C448 260.4 444.4 264 440 264H136C131.6 264 128 260.4 128 256C128 251.6 131.6 248 136 248H440zM128 416C128 411.6 131.6 408 136 408H440C444.4 408 448 411.6 448 416C448 420.4 444.4 424 440 424H136C131.6 424 128 420.4 128 416zM0 232C0 227.6 3.582 224 8 224C12.42 224 16 227.6 16 232V440C16 444.4 12.42 448 8 448C3.582 448 0 444.4 0 440V232z"],
    "blog": [512, 512, [], "f781", "M200 32C195.6 32 192 35.58 192 40S195.6 48 200 48c145.6 0 264 118.4 264 264c0 4.422 3.578 8 8 8S480 316.4 480 312C480 157.6 354.4 32 200 32zM200 128C195.6 128 192 131.6 192 136S195.6 144 200 144c92.64 0 168 75.36 168 168c0 4.422 3.578 8 8 8S384 316.4 384 312C384 210.5 301.5 128 200 128zM160 224C155.6 224 152 227.6 152 232S155.6 240 160 240c61.75 0 112 50.25 112 112S221.8 464 160 464S48 413.8 48 352V104C48 99.58 44.42 96 40 96S32 99.58 32 104V352c0 70.58 57.42 128 128 128s128-57.42 128-128S230.6 224 160 224z"],
    "blueberries": [512, 512, [], "e2e8", "M400 96h-32V64c0-4.422-3.594-8-8-8S352 59.58 352 64v32h-32c-4.406 0-8 3.578-8 8S315.6 112 320 112h32v32c0 4.422 3.594 8 8 8S368 148.4 368 144v-32h32c4.406 0 8-3.578 8-8S404.4 96 400 96zM192 272H160v-32c0-4.422-3.594-8-8-8S144 235.6 144 240v32h-32c-4.406 0-8 3.578-8 8S107.6 288 112 288h32v32c0 4.422 3.594 8 8 8S160 324.4 160 320V288h32c4.406 0 8-3.578 8-8S196.4 272 192 272zM176 160C78.8 160 0 238.8 0 336C0 433.2 78.8 512 176 512s176-78.8 176-176C352 238.8 273.2 160 176 160zM176 496c-88.22 0-160-71.78-160-160s71.78-160 160-160s160 71.78 160 160S264.2 496 176 496zM336 0c-64.63 0-123.1 35.33-154.8 92.19C179.1 96.06 180.5 100.9 184.4 103c3.938 2.141 8.75 .6406 10.84-3.219C223.3 48.11 277.3 16 336 16c88.22 0 160 71.78 160 160c0 58.75-32.13 112.7-83.81 140.7c-3.875 2.109-5.312 6.969-3.219 10.84C410.4 330.3 413.2 331.8 416 331.8c1.281 0 2.594-.3125 3.812-.9687C476.7 299.9 512 240.6 512 176C512 78.95 433 0 336 0z"],
    "bluetooth": [320, 512, [], "f293", "M172.7 256l144.4-117.8C318.9 136.7 320 134.4 320 132s-1.094-4.688-2.938-6.188l-152-124c-2.406-1.938-5.688-2.406-8.5-1.031C153.8 2.102 152 4.914 152 8.008v231.2L13.06 125.8C9.592 123 4.592 123.5 1.811 126.9C-1.002 130.4-.4707 135.4 2.936 138.2l144.4 117.8l-144.4 117.8c-3.406 2.781-3.938 7.812-1.125 11.25c2.781 3.406 7.781 3.938 11.25 1.125L152 272.8V504c0 3.094 1.781 5.906 4.562 7.219C157.7 511.8 158.8 512 160 512c1.812 0 3.593-.625 5.062-1.812l152-124C318.9 384.7 320 382.4 320 380s-1.094-4.688-2.938-6.188L172.7 256zM168 24.85l131.3 107.2L168 239.2V24.85zM168 487.2V272.8L299.3 380L168 487.2z"],
    "bold": [384, 512, [], "f032", "M274.8 243.3C310.9 224.7 336 187.4 336 144c0-61.75-50.25-111.1-112-111.1L8 32C3.594 32 0 35.58 0 40S3.594 48 8 48H48v416H8C3.594 464 0 467.6 0 472S3.594 480 8 480h240c66.16 0 120-53.83 120-120C368 303.1 328 255.5 274.8 243.3zM224 48c52.94 0 96 43.06 96 96s-43.06 96-96 96H64v-192H224zM248 464H64V256h184C305.3 256 352 302.7 352 360S305.3 464 248 464z"],
    "bolt": [384, 512, [9889, "zap"], "f0e7", "M277.9 6.309C282.4 2.246 288.3 0 294.4 0C312.3 0 324.3 18.25 317.3 34.66L236.1 224H359.4C373 224 384 234.1 384 248.6C384 255.6 380.1 262.3 375.7 266.9L106.1 505.7C101.5 509.8 95.68 512 89.6 512C71.74 512 59.7 493.7 66.73 477.3L147.9 287.1H23.35C10.45 287.1 0 277.5 0 264.7C0 257.1 2.839 251.7 7.805 247.2L277.9 6.309zM294.4 16C292.3 16 290.2 16.8 288.5 18.25L18.46 259.2C16.89 260.6 16 262.6 16 264.7C16 268.7 19.29 272 23.35 272H160C162.7 272 165.2 273.4 166.7 275.6C168.2 277.8 168.4 280.7 167.4 283.2L81.44 483.6C78.93 489.5 83.22 496 89.6 496C91.77 496 93.86 495.2 95.49 493.8L365.1 254.1C366.1 253.3 368 250.1 368 248.6C368 243.8 364.2 240 359.4 240H224C221.3 240 218.8 238.6 217.3 236.4C215.8 234.2 215.6 231.3 216.6 228.8L302.6 28.35C305.1 22.51 300.8 16 294.4 16V16z"],
    "bolt-auto": [576, 512, [], "e0b6", "M317.3 34.66L236.1 224H359.4C373 224 384 234.1 384 248.6C384 255.6 380.1 262.3 375.7 266.9L106.1 505.7C101.5 509.8 95.68 512 89.6 512C71.74 512 59.7 493.7 66.73 477.3L147.9 288H23.35C10.45 288 0 277.5 0 264.7C0 257.1 2.839 251.7 7.805 247.2L277.9 6.309C282.4 2.246 288.3 0 294.4 0C312.3 0 324.3 18.25 317.3 34.66L317.3 34.66zM18.46 259.2C16.89 260.6 16 262.6 16 264.7C16 268.7 19.29 272 23.35 272H160C162.7 272 165.2 273.4 166.7 275.6C168.2 277.8 168.4 280.7 167.4 283.2L81.44 483.6C78.93 489.5 83.22 496 89.6 496C91.77 496 93.86 495.2 95.49 493.8L365.1 254.1C366.1 253.3 368 250.1 368 248.6C368 243.8 364.2 240 359.4 240H224C221.3 240 218.8 238.6 217.3 236.4C215.8 234.2 215.6 231.3 216.6 228.8L302.6 28.35C305.1 22.51 300.8 16 294.4 16C292.3 16 290.2 16.8 288.5 18.25L18.46 259.2zM464 288C467 288 469.8 289.7 471.2 292.4L575.2 500.4C577.1 504.4 575.5 509.2 571.6 511.2C567.6 513.1 562.8 511.5 560.8 507.6L539.1 464H388.9L367.2 507.6C365.2 511.5 360.4 513.1 356.4 511.2C352.5 509.2 350.9 504.4 352.8 500.4L456.8 292.4C458.2 289.7 460.1 288 464 288H464zM396.9 448H531.1L464 313.9L396.9 448z"],
    "bolt-lightning": [384, 512, [], "e0b7", "M381.2 172.8C377.1 164.9 368.9 160 360 160h-156.6l50.84-127.1c2.969-7.375 2.062-15.78-2.406-22.38S239.1 0 232 0h-176C43.97 0 33.81 8.906 32.22 20.84l-32 240C-.7179 267.7 1.376 274.6 5.938 279.8C10.5 285 17.09 288 24 288h146.3l-41.78 194.1c-2.406 11.22 3.469 22.56 14 27.09C145.6 511.4 148.8 512 152 512c7.719 0 15.22-3.75 19.81-10.44l208-304C384.8 190.2 385.4 180.7 381.2 172.8zM366.6 188.5L158.6 492.5C157.1 494.7 154.6 496 152 496c-1.104 0-2.168-.2168-3.145-.6348c-3.512-1.512-5.48-5.312-4.68-9.045l41.78-194.1C188.1 281.4 180.5 272 170.3 272H24c-2.305 0-4.508-1.004-6.018-2.719C16.46 267.5 15.76 265.3 16.08 262.1l32-239.1C48.61 18.98 52.01 16 56.03 16h175.1c2.664 0 5.141 1.311 6.631 3.508c1.49 2.201 1.793 4.977 .7949 7.455L188.6 154.1C184.4 164.6 192.1 176 203.4 176h156.6c2.967 0 5.676 1.641 7.068 4.281C368.5 182.9 368.3 186.1 366.6 188.5z"],
    "bolt-slash": [640, 512, [], "e0b8", "M356.1 376.3L368.9 386.3L234.1 505.7C229.5 509.8 223.7 512 217.6 512C199.7 512 187.7 493.7 194.7 477.3L267.9 306.6L280.9 316.9L209.4 483.6C206.9 489.5 211.2 496 217.6 496C219.8 496 221.9 495.2 223.5 493.8L356.1 376.3zM224.1 272L244.3 288H151.3C138.5 288 128 277.5 128 264.7C128 257.1 130.8 251.7 135.8 247.2L162.5 223.4L175.3 233.5L146.5 259.2C144.9 260.6 144 262.6 144 264.7C144 268.7 147.3 272 151.3 272H224.1zM284.4 136.1L271.6 126.1L405.9 6.309C410.4 2.246 416.3 0 422.4 0C440.3 0 452.3 18.25 445.3 34.66L372.1 205.4L359.1 195.1L430.6 28.35C433.1 22.51 428.8 16 422.4 16C420.3 16 418.2 16.8 416.5 18.25L284.4 136.1zM512 248.6C512 255.6 508.1 262.3 503.7 266.9L478.4 289.3L465.7 279.3L493.1 254.1C494.1 253.3 496 250.1 496 248.6C496 243.8 492.2 240 487.4 240H415.9L395.7 224H487.4C501 224 512 234.1 512 248.6V248.6zM636.1 497.7C640.4 500.5 641 505.5 638.3 508.1C635.5 512.4 630.5 513 627 510.3L3.022 14.26C-.4365 11.51-1.012 6.482 1.738 3.023C4.487-.4358 9.52-1.011 12.98 1.739L636.1 497.7z"],
    "bomb": [512, 512, [128163], "f1e2", "M448 8C452.4 8 456 11.58 456 16V56H496C500.4 56 504 59.58 504 64C504 68.42 500.4 72 496 72H456V112C456 116.4 452.4 120 448 120C443.6 120 440 116.4 440 112V72H400C395.6 72 392 68.42 392 64C392 59.58 395.6 56 400 56H440V16C440 11.58 443.6 8 448 8zM88 304C88 308.4 84.42 312 80 312C75.58 312 72 308.4 72 304V296C72 225.3 129.3 168 200 168H208C212.4 168 216 171.6 216 176C216 180.4 212.4 184 208 184H200C138.1 184 88 234.1 88 296V304zM278.5 108.3L289.4 97.37C301.9 84.88 322.1 84.88 334.6 97.37L368.1 131.7L386.3 114.3C389.5 111.2 394.5 111.2 397.7 114.3C400.8 117.5 400.8 122.5 397.7 125.7L380.3 143L414.6 177.4C427.1 189.9 427.1 210.1 414.6 222.6L403.8 233.5C411.7 255.5 416 279.3 416 303.1C416 418.9 322.9 512 208 512C93.12 512 0 418.9 0 303.1C0 189.1 93.12 95.1 208 95.1C232.7 95.1 256.5 100.3 278.5 108.2L278.5 108.3zM289.8 119.6C285.4 123.9 278.9 125.4 273.1 123.3C252.8 115.1 230.9 112 208 112C101.1 112 16 197.1 16 304C16 410 101.1 496 208 496C314 496 400 410 400 304C400 281.1 396 259.2 388.7 238.9C386.6 233.1 388.1 226.6 392.4 222.2L403.3 211.3C409.6 205.1 409.6 194.9 403.3 188.7L323.3 108.7C317.1 102.4 306.9 102.4 300.7 108.7L289.8 119.6z"],
    "bone": [576, 512, [129460], "f5d7", "M534.9 244.5C560.1 232 576 206.3 576 178V173.6c0-35.55-23.49-68.35-58.24-75.88C512.3 96.56 506.9 96 501.6 96c-32 0-60.5 20.5-70.63 50.88L430.8 147.4C425.2 164.4 409.5 176 391.6 176H184.4c-17.99 0-33.75-11.94-39.38-29.03C134.9 116.6 106.4 96 74.38 96C69.07 96 63.67 96.56 58.24 97.74C23.49 105.3 0 138.1 0 173.6v4.387C0 206.3 15.88 232 41.13 244.5c9.375 4.75 9.375 18.25 0 23C15.88 280 0 305.8 0 334v4.387c0 35.55 23.49 68.35 58.24 75.88C63.67 415.4 69.07 416 74.38 416c32 0 60.5-20.5 70.63-50.88l.1875-.5664C150.8 347.6 166.5 336 184.4 336h207.2c17.98 0 33.68 11.73 39.31 28.81c.0352 .1055 .0684 .209 .1035 .3125C441.1 395.5 469.6 416 501.6 416c5.305 0 10.71-.5625 16.13-1.738C552.5 406.7 576 373.9 576 338.4v-4.387C576 305.8 560.1 280 534.9 267.5C525.5 262.8 525.5 249.3 534.9 244.5zM527.8 281.8C547.7 291.7 560 311.7 560 334v4.387c0 29.18-19.19 54.51-45.63 60.24C510.2 399.5 505.9 400 501.6 400c-25.2 0-47.48-16.05-55.53-40.19C438.3 335.1 416.4 320 391.6 320H184.4c-24.76 0-46.63 15.89-54.59 40.06C121.9 383.1 99.58 400 74.38 400c-4.24 0-8.529-.4629-12.75-1.377C35.19 392.9 16 367.6 16 338.4v-4.387c0-22.33 12.35-42.32 32.36-52.23C58.1 276.8 64.16 266.1 64.16 256S58.1 235.2 48.22 230.2C28.35 220.3 16 200.3 16 178V173.6c0-29.18 19.19-54.51 45.63-60.24C65.85 112.5 70.13 112 74.38 112c25.2 0 47.48 16.05 55.52 40.17C137.7 175.1 159.7 192 184.4 192h207.2c24.76 0 46.63-15.89 54.59-40.07C454.1 128 476.4 112 501.6 112c4.24 0 8.529 .4629 12.75 1.375C540.8 119.1 560 144.4 560 173.6v4.387c0 22.33-12.35 42.32-32.36 52.23C517.9 235.2 511.8 245 511.8 256S517.9 276.8 527.8 281.8z"],
    "bone-break": [640, 512, [], "f5d8", "M242.3 157.7C243.9 159.2 245.9 160 247.1 160S252.1 159.2 253.7 157.7c3.125-3.125 3.125-8.188 0-11.31l-80-80c-3.125-3.125-8.188-3.125-11.31 0s-3.125 8.188 0 11.31L242.3 157.7zM391.1 160c2.062 0 4.094-.7813 5.656-2.344l80-80c3.125-3.125 3.125-8.188 0-11.31s-8.188-3.125-11.31 0l-80 80c-3.125 3.125-3.125 8.188 0 11.31C387.9 159.2 389.9 160 391.1 160zM319.1 0C315.6 0 311.1 3.578 311.1 8v112c0 4.422 3.592 7.997 7.998 7.997S327.1 124.4 327.1 120v-112C327.1 3.578 324.4 0 319.1 0zM284.9 371.1l-70.73 21.28c-24.16 5.426-42.03 25.83-44.46 50.78c-2.561 25.32-20.79 45.86-45.38 51.38c-4.137 .9297-8.424 1.418-12.74 1.451c-27.05 .209-51.32-20.3-57.71-48.78L52.89 442.9c-4.895-21.79 2.773-44 20.01-57.96c8.541-7.047 12.28-18.01 9.883-28.7c-2.4-10.69-10.47-19-21.06-21.68c-21.69-5.281-38.12-22.08-43.02-43.87L17.74 286.5c-6.395-28.47 6.777-57.39 31.32-68.77c3.92-1.814 8.002-3.207 12.14-4.135C85.79 208 111 218.8 124 240.4c13.07 21.84 37.89 32.55 62.05 27.13l88.22-19.81c4.449-1 7.166-5.512 5.965-9.91C279.2 233.6 274.1 231.1 270.8 232.1L182.9 251.8C165.4 255.7 147.3 248 138.1 232.6L137.7 232.1c-16.54-27.42-48.83-41.17-80.05-34.16c-5.293 1.188-10.56 2.973-15.71 5.391c-31.88 14.96-47.78 51.35-40.06 85.71l1.168 5.201c6.191 27.56 27.32 49.21 54.7 55.87c10.19 2.58 13.15 15.75 5.041 22.44c-21.9 17.73-31.74 46.33-25.55 73.9l1.172 5.217c7.73 34.43 37.78 60.53 73.06 60.33c5.617-.0313 11.07-.666 16.3-1.84c31.22-7.012 54.54-33.26 57.76-65.11l.0313-.3281c1.713-18 14.81-32.86 32.45-36.82l70.32-21.18c4.502-1.012 7.217-5.609 5.93-10.04C293.1 372.6 288.1 370.2 284.9 371.1zM598 203.3c-5.148-2.418-10.41-4.203-15.71-5.391c-31.22-7.012-63.52 6.742-80.05 34.16L501.9 232.6c-9.248 15.39-27.32 23.13-44.85 19.2l-87.91-19.74c-4.174-.9355-8.346 1.576-9.471 5.703C358.5 242.2 361.2 246.7 365.7 247.7l88.22 19.81c24.15 5.424 48.98-5.291 62.05-27.13c13-21.56 38.26-32.34 62.85-26.81c4.139 .9277 8.221 2.32 12.14 4.135c24.54 11.38 37.71 40.3 31.32 68.77L621.3 290.7c-4.895 21.79-21.32 38.59-43.02 43.87c-10.59 2.684-18.66 10.99-21.06 21.68c-2.4 10.69 1.342 21.65 9.883 28.7c17.24 13.96 24.91 36.16 20.01 57.96l-.9609 4.279c-6.395 28.47-30.67 48.98-57.71 48.78c-4.318-.0332-8.605-.5215-12.74-1.451c-24.59-5.521-42.81-26.06-45.38-51.38c-2.432-24.95-20.3-45.36-44.46-50.78l-70.73-21.28c-4.123-.9258-8.254 1.514-9.436 5.572c-1.287 4.432 1.428 9.029 5.93 10.04l70.32 21.18c17.64 3.961 30.73 18.82 32.45 36.82l.0313 .3281c3.223 31.86 26.54 58.1 57.76 65.11c5.23 1.174 10.68 1.809 16.3 1.84c35.29 .1934 65.33-25.9 73.06-60.33l1.172-5.217c6.189-27.56-3.656-56.17-25.55-73.9c-8.105-6.688-5.148-19.86 5.041-22.44c27.38-6.662 48.51-28.31 54.7-55.87l1.168-5.201C645.8 254.7 629.9 218.3 598 203.3z"],
    "bong": [512, 512, [], "f55c", "M477.7 226.3l-64-64c-3.125-3.125-8.188-3.125-11.31 0s-3.125 8.188 0 11.31L428.7 200l-59.44 59.44C347.6 234.3 319.9 214.5 288 203.2V16h24C316.4 16 320 12.42 320 8S316.4 0 312 0h-176C131.6 0 128 3.578 128 8S131.6 16 136 16H160v187.2C85.48 229.5 32 300.4 32 384c0 43.81 14.8 84.07 39.52 116.4C77.34 507.1 86.7 512 96.28 512h255.4c9.582 0 19-4.043 24.83-11.65c24.72-32.28 39.53-72.54 39.53-116.4c0-41.98-13.54-80.73-36.42-112.3L440 211.3l26.34 26.34C467.9 239.2 469.9 240 472 240s4.094-.7813 5.656-2.344C480.8 234.5 480.8 229.5 477.7 226.3zM165.3 218.2C171.7 215.1 176 209.9 176 203.2V16h96v187.2c0 6.777 4.271 12.82 10.66 15.08C331.7 235.6 369 273.5 387.3 320H60.66C79 273.5 116.3 235.6 165.3 218.2zM363.8 490.6C361.2 493.1 356.7 496 351.7 496H96.31c-4.994 0-9.514-2.01-12.09-5.377C60.53 459.7 48 422.8 48 384c0-16.67 2.697-32.83 7.17-48.34C55.48 335.7 55.68 336 56 336h336c.3223 0 .5176-.3066 .8301-.3438C397.3 351.2 400 367.3 400 384C400 422.8 387.5 459.7 363.8 490.6z"],
    "book": [448, 512, [128212], "f02d", "M448 384V32c0-17.67-14.33-32-32-32H64C28.65 0 0 28.65 0 64v391.1c0 30.93 25.07 56 55.1 56l383.1 .0078C444.4 511.1 448 508.4 448 503.1c0-4.422-3.584-8.008-8.006-8.008H416V416C433.7 416 448 401.7 448 384zM16 64c0-26.47 21.53-48 48-48h48v383.1l-56 .0039c-15.68 0-29.82 6.516-40 16.93V64zM400 495.1H56c-23.38 0-42.12-20.14-39.81-43.98c2.02-20.78 20.7-36.02 41.58-36.02L400 416V495.1zM128 399.1V16h288c8.836 0 16 7.164 16 16v352c0 8.824-7.178 16-16 16L128 399.1zM376 127.1h-192c-4.406 0-8 3.578-8 8s3.594 8 8 8h192c4.406 0 8-3.578 8-8S380.4 127.1 376 127.1zM376 207.1h-192c-4.406 0-8 3.578-8 8s3.594 8 8 8h192c4.406 0 8-3.578 8-8S380.4 207.1 376 207.1z"],
    "book-arrow-right": [640, 512, [], "e0b9", "M440 272c-4.418 0-8 3.582-8 8v104c0 8.836-7.164 15.1-16 15.1L56 399.1c-15.68 0-29.82 6.516-40 16.93V64c0-26.51 21.49-48 48-48h352c8.836 0 16 7.162 16 16v104c0 4.418 3.582 8 8 8S448 140.4 448 136V32c0-17.67-14.33-32-32-32H64C28.66 0 0 28.65 0 64v391.1c0 30.93 25.07 56 56 56L439.1 512C444.4 512 448 508.4 448 504c0-4.422-3.586-8.008-8.008-8.008H416v-79.99c17.67 0 32-14.33 32-32V280C448 275.6 444.4 272 440 272zM400 495.1H56c-23.38 0-42.13-20.14-39.8-43.99c2.016-20.78 20.7-36.02 41.57-36.02L400 416V495.1zM637.7 202.9l-108-108C528.1 93.37 526.1 92.59 524 92.59s-4.094 .7813-5.656 2.344c-3.125 3.125-3.125 8.188 0 11.31l94.34 94.34H264c-4.406 0-8 3.578-8 8s3.594 8 8 8h348.7l-93.17 93.17c-3.125 3.125-3.125 8.188 0 11.31s8.188 3.125 11.31 0l106.8-106.8C640.8 211.1 640.8 206.1 637.7 202.9z"],
    "book-arrow-up": [448, 512, [], "e0ba", "M353.1 248.5c3.125-3.125 3.125-8.188 0-11.31l-106.8-106.8c-3.125-3.125-8.188-3.125-11.31 0l-108 108C125.4 239.9 124.6 241.9 124.6 244s.7813 4.094 2.344 5.656c3.125 3.125 8.188 3.125 11.31 0l94.34-94.34V504c0 4.406 3.578 8 8 8s8-3.594 8-8V155.3l93.17 93.17C344.9 251.6 349.9 251.6 353.1 248.5zM448 384V32c0-17.67-14.33-32-32-32H64C28.66 0 0 28.65 0 64v391.1c0 30.93 25.07 56 56 56l128 .002c4.418 0 8-3.582 8-8s-3.582-8.002-8-8.002h-128c-23.38 0-42.13-20.14-39.8-43.99c2.023-20.78 20.7-36.01 41.59-36.01L184 415.1c4.418 0 8-3.582 8-8s-3.582-7.998-8-7.998l-128-.0039c-15.68 0-29.82 6.516-40 16.93V64c0-26.51 21.49-48 48-48h352c8.836 0 16 7.162 16 16v352c0 8.836-7.164 15.1-16 15.1l-120-.001c-4.418 0-8 3.58-8 7.998S291.6 416 296 416l104 .0059v79.99h-104c-4.418 0-8 3.58-8 7.998s3.582 8.006 8 8.006L439.1 512C444.4 512 448 508.4 448 504c0-4.422-3.586-8.008-8.008-8.008H416v-79.99C433.7 416 448 401.7 448 384z"],
    "book-atlas": [448, 512, ["atlas"], "f558", "M240 72c-75 0-136 61.01-136 135.1c0 74.98 61 135.1 136 135.1s136-61.01 136-135.1C376 133 315 72 240 72zM240 87.1c21.83 0 45.78 45.71 47.64 111.1H192.4C194.2 133.7 218.2 87.1 240 87.1zM204.9 93.84C188.4 116.5 177.6 154.1 176.4 199.1H120.8C124.2 149.7 158.4 108.2 204.9 93.84zM120.8 215.1h55.56c1.199 45 12.05 83.5 28.57 106.2C158.4 307.8 124.2 266.3 120.8 215.1zM240 327.1c-21.83 0-45.78-45.72-47.64-112h95.29C285.8 282.3 261.8 327.1 240 327.1zM275.1 322.2c16.52-22.66 27.37-61.16 28.57-106.2h55.56C355.8 266.3 321.6 307.8 275.1 322.2zM303.6 199.1c-1.199-45-12.05-83.5-28.57-106.2c46.5 14.34 80.74 55.85 84.13 106.2H303.6zM448 384V32c0-17.67-14.33-32-32-32H64C28.65 0 0 28.65 0 64v391.1c0 30.93 25.07 56 55.1 56l383.1 .0078C444.4 511.1 448 508.4 448 503.1c0-4.422-3.584-8.008-8.006-8.008H416V416C433.7 416 448 401.7 448 384zM400 495.1H56c-23.38 0-42.12-20.14-39.81-43.98c2.02-20.78 20.7-36.02 41.58-36.02L400 416V495.1zM56 399.1c-15.68 0-29.82 6.516-40 16.93V64c0-26.47 21.53-48 48-48h352c8.836 0 16 7.164 16 16v352c0 8.824-7.178 16-16 16L56 399.1z"],
    "book-bible": [448, 512, ["bible"], "f647", "M320 128l-40 .0078v-40c0-13.23-10.78-24.01-24-24.01l-32-.0009c-13.22 0-24 10.78-24 24.01v40L160 128c-13.22 0-24 10.77-24 24v32c0 13.23 10.78 23.1 24 23.1l40 .0039v104c0 13.23 10.78 23.1 24 23.1h32c13.22 0 24-10.76 24-23.1v-104L320 208c13.22 0 24-10.76 24-23.1v-32C344 138.8 333.2 128 320 128zM328 184c0 4.484-3.5 7.995-8 7.995l-56 .0054v120c0 4.484-3.5 7.994-8 7.994l-32-.0002c-4.5 0-8-3.51-8-7.994v-120L160 192c-4.5 0-8-3.51-8-7.995v-32c0-4.484 3.5-8.004 8-8.004l56 .0039V88.01c0-4.484 3.5-8.006 8-8.006h32c4.5 0 8 3.521 8 8.006v55.1L320 144c4.5 0 8 3.52 8 8.004V184zM448 384V32c0-17.67-14.33-32-32-32H64C28.65 0 0 28.65 0 64v391.1c0 30.93 25.07 56 55.1 56l383.1 .0078C444.4 511.1 448 508.4 448 503.1c0-4.422-3.584-8.008-8.006-8.008H416V416C433.7 416 448 401.7 448 384zM400 495.1H56c-23.38 0-42.12-20.14-39.81-43.98c2.02-20.78 20.7-36.02 41.58-36.02L400 416V495.1zM56 399.1c-15.68 0-29.82 6.516-40 16.93V64c0-26.47 21.53-48 48-48h352c8.836 0 16 7.164 16 16v352c0 8.824-7.178 16-16 16L56 399.1z"],
    "book-blank": [448, 512, [128215, 128216, 128217, 128213, "book-alt"], "f5d9", "M448 384V32c0-17.67-14.33-32-32-32H64C28.65 0 0 28.65 0 64v391.1c0 30.93 25.07 56 55.1 56l383.1 .0078C444.4 511.1 448 508.4 448 503.1c0-4.422-3.584-8.008-8.006-8.008H416V416C433.7 416 448 401.7 448 384zM16 64c0-26.47 21.53-48 48-48h48v383.1l-56 .0039c-15.68 0-29.82 6.516-40 16.93V64zM400 495.1H56c-23.38 0-42.12-20.14-39.81-43.98c2.02-20.78 20.7-36.02 41.58-36.02L400 416V495.1zM128 399.1V16h288c8.836 0 16 7.164 16 16v352c0 8.824-7.178 16-16 16L128 399.1z"],
    "book-bookmark": [448, 512, [], "e0bb", "M448 384V32c0-17.67-14.33-32-32-32H64C28.66 0 0 28.65 0 64v391.1c0 30.93 25.07 56 56 56L439.1 512C444.4 512 448 508.4 448 504c0-4.422-3.586-8.008-8.008-8.008H416v-79.99C433.7 416 448 401.7 448 384zM176 16h160v215.1l-74.94-61.31C259.6 168.6 257.8 168 256 168s-3.594 .6094-5.062 1.812L176 231.1V16zM400 495.1H56c-23.38 0-42.13-20.14-39.8-43.99c2.016-20.78 20.7-36.02 41.57-36.02L400 416V495.1zM56 399.1c-15.68 0-29.82 6.516-40 16.93V64c0-26.47 21.53-48 48-48h96v232c0 3.094 1.781 5.906 4.562 7.234c2.812 1.344 6.094 .9062 8.5-1.047L256 186.3l82.94 67.84C340.4 255.4 342.2 256 344 256c1.156 0 2.344-.25 3.438-.7656C350.2 253.9 352 251.1 352 248V16h64c8.836 0 16 7.164 16 16v352c0 8.824-7.18 15.1-16 15.1L56 399.1z"],
    "book-circle-arrow-right": [640, 512, [], "e0bc", "M360 495.1h-304c-23.38 0-42.13-20.14-39.8-43.99c2.023-20.78 20.7-36.01 41.59-36.01L312 416C316.4 416 320 412.4 320 408s-3.582-7.998-8-8l-256-.0059c-15.68 0-29.82 6.516-40 16.93V64c0-26.51 21.49-48 48-48h352c8.836 0 16 7.162 16 16v152C432 188.4 435.6 192 440 192S448 188.4 448 184V32c0-17.67-14.33-32-32-32H64C28.66 0 0 28.65 0 64v391.1c0 30.93 25.07 56 56 56L360 512c4.418 0 8-3.582 8-8S364.4 495.1 360 495.1zM509.7 298.3c-3.125-3.125-8.188-3.125-11.31 0s-3.125 8.188 0 11.31L548.7 360h-124.7c-4.406 0-8.003 3.578-8.003 8s3.597 8 8.003 8h124.7l-50.34 50.34c-3.125 3.125-3.125 8.188 0 11.31C499.9 439.2 501.9 440 504 440s4.094-.7813 5.656-2.344l64-64c3.125-3.125 3.125-8.188 0-11.31L509.7 298.3zM496 224C416.5 224 352 288.5 352 368s64.46 144 144 144s144-64.46 144-144S575.5 224 496 224zM496 496c-70.58 0-128-57.42-128-128s57.42-128 128-128s128 57.42 128 128S566.6 496 496 496z"],
    "book-circle-arrow-up": [640, 512, [], "e0bd", "M360 495.1h-304c-23.38 0-42.13-20.14-39.8-43.99c2.023-20.78 20.7-36.01 41.59-36.01L312 416C316.4 416 320 412.4 320 408s-3.582-7.998-8-8l-256-.0059c-15.68 0-29.82 6.516-40 16.93V64c0-26.51 21.49-48 48-48h352c8.836 0 16 7.162 16 16v152C432 188.4 435.6 192 440 192S448 188.4 448 184V32c0-17.67-14.33-32-32-32H64C28.66 0 0 28.65 0 64v391.1c0 30.93 25.07 56 56 56L360 512c4.418 0 8-3.582 8-8S364.4 495.1 360 495.1zM496 224C416.5 224 352 288.5 352 367.1C352 447.5 416.5 512 496 512s144-64.46 144-144C640 288.5 575.5 224 496 224zM496 496c-70.58 0-128-57.42-128-128C368 297.4 425.4 240 496 240s128 57.42 128 127.1C624 438.6 566.6 496 496 496zM501.7 290.3c-3.125-3.125-8.188-3.125-11.31 0l-64 64c-3.125 3.125-3.125 8.188 0 11.31s8.188 3.125 11.31 0L488 315.3v124.7c0 4.406 3.578 8.003 8 8.003s8-3.596 8-8.003V315.3l50.34 50.34c3.125 3.125 8.188 3.125 11.31 0C567.2 364.1 568 362.1 568 360s-.7813-4.094-2.344-5.656L501.7 290.3z"],
    "book-copy": [576, 512, [], "e0be", "M375.1 495.1H352V455.1C352 451.6 348.4 448 344 448s-8 3.58-8 7.998v39.99H56c-23.38 0-42.13-20.14-39.8-43.99c2.023-20.78 20.71-36.01 41.59-36.01L152 415.1c4.418 0 8-3.582 8-8s-3.582-7.998-8-7.998l-96-.0039c-15.68 0-29.82 6.516-40 16.93V160c0-26.51 21.49-48 48-48h88c4.418 0 8-3.582 8-8s-3.582-8-8-8H64c-35.34 0-64 28.65-64 64v295.1c0 30.93 25.07 56 56 56L375.1 512C380.4 512 384 508.4 384 504C384 499.6 380.4 495.1 375.1 495.1zM576 288V32c0-17.67-14.33-32-32-32H256C220.7 0 192 28.65 192 64v295.1c0 30.93 25.07 56 56 56l319.1 .0078C572.4 415.1 576 412.4 576 407.1c0-4.422-3.586-8.008-8.008-8.008H544V320C561.7 320 576 305.7 576 288zM528 399.1H248c-23.38 0-42.13-20.14-39.8-43.99c2.016-20.78 20.7-36.02 41.57-36.02L528 320V399.1zM248 303.1c-15.68 0-29.82 6.516-40 16.93V64c0-26.47 21.53-48 48-48h288c8.836 0 16 7.164 16 16v256c0 8.824-7.18 16-16 16L248 303.1z"],
    "book-font": [448, 512, [], "e0bf", "M231.2 100.4c-2.719-5.406-11.59-5.406-14.31 0l-104 208C110.9 312.4 112.5 317.2 116.4 319.2c4.016 2.031 8.75 .3594 10.73-3.578L156.9 256h134.1l29.79 59.58C322.3 318.4 325.1 320 328 320c1.203 0 2.422-.2656 3.578-.8438c3.953-1.984 5.547-6.781 3.578-10.73L231.2 100.4zM164.9 240L224 121.9L283.1 240H164.9zM448 384V32c0-17.67-14.33-32-32-32H64C28.65 0 0 28.65 0 64v391.1c0 30.93 25.07 56 55.1 56l383.1 .0078C444.4 511.1 448 508.4 448 503.1c0-4.422-3.584-8.008-8.006-8.008H416V416C433.7 416 448 401.7 448 384zM400 495.1H56c-23.38 0-42.12-20.14-39.81-43.98c2.02-20.78 20.7-36.02 41.58-36.02L400 416V495.1zM56 399.1c-15.68 0-29.82 6.516-40 16.93V64c0-26.47 21.53-48 48-48h352c8.836 0 16 7.164 16 16v352c0 8.824-7.178 16-16 16L56 399.1z"],
    "book-heart": [448, 512, [], "f499", "M301.4 95.1c-18.74 0-37.67 7.672-51.51 21.96l-9.844 10.16l-9.844-10.16C216.3 103.7 197.4 95.1 178.6 95.1c-15.07 0-30.03 4.965-42.13 15.43c-31.07 26.89-32.62 74.82-4.609 103.8l96.58 99.85c3.16 3.27 7.324 4.906 11.49 4.906s8.332-1.637 11.49-4.906l96.57-99.85c28.06-28.98 26.51-76.91-4.562-103.8C331.4 100.1 316.4 95.1 301.4 95.1zM336.5 204.1l-96.56 99.85L143.4 204.1C124.6 184.6 120.2 146.8 146.1 123.5C174.1 100.1 206.1 116.1 218.7 129.1l21.34 22.03l21.34-22.03c11.45-11.82 44.59-29.01 71.67-5.566C359.7 146.7 355.7 184.3 336.5 204.1zM448 384V32c0-17.67-14.33-32-32-32H64C28.65 0 0 28.65 0 64v391.1c0 30.93 25.07 56 55.1 56l383.1 .0078C444.4 511.1 448 508.4 448 503.1c0-4.422-3.584-8.008-8.006-8.008H416V416C433.7 416 448 401.7 448 384zM400 495.1H56c-23.38 0-42.12-20.14-39.81-43.98c2.02-20.78 20.7-36.02 41.58-36.02L400 416V495.1zM56 399.1c-15.68 0-29.82 6.516-40 16.93V64c0-26.47 21.53-48 48-48h352c8.836 0 16 7.164 16 16v352c0 8.824-7.178 16-16 16L56 399.1z"],
    "book-journal-whills": [448, 512, ["journal-whills"], "f66a", "M314 103.6c-1.885-1.352-4.119-2.117-6.471-2.117c-3.705 .0586-7.234 1.887-9.354 5c-2.059 3.117-2.529 7.059-1.117 10.53c2.766 7 4.178 14.41 4.178 21.94c0 18.52-8.424 35.43-22.94 47.07c10.17 9.957 16.52 23.8 16.52 39.16c0 27.55-20.39 50.15-46.86 54.05V247.2l15.88 7.938C265 255.7 266.2 256 267.4 256c2.938 0 5.75-1.625 7.156-4.438c1.969-3.938 .375-8.75-3.594-10.72l-13.12-6.562L271 227.7c3.969-1.969 5.562-6.781 3.594-10.72s-6.844-5.469-10.72-3.594L248 221.3V104C248 99.59 244.4 96 240 96s-8 3.594-8 8v117.3L216.1 213.4C212.3 211.5 207.4 213 205.4 217C203.4 220.9 205 225.8 209 227.7l13.12 6.562L209 240.8C205 242.8 203.4 247.6 205.4 251.6C206.8 254.4 209.6 256 212.6 256C213.8 256 215 255.7 216.1 255.2L232 247.2v31.98c-26.47-3.898-46.86-26.5-46.86-54.05c0-15.36 6.348-29.21 16.52-39.16C187.1 174.3 178.7 157.4 178.7 138.9c0-7.531 1.412-14.94 4.178-21.94C184.3 113.5 183.8 109.6 181.8 106.4c-2.119-3.113-5.648-4.941-9.354-5c-2.352 0-4.586 .7656-6.471 2.117C130.3 128.8 110.1 169.9 112.1 213.4C115.2 279.7 171.1 334.8 240 334.9c68.88-.0078 124.8-55.18 127.9-121.4C369.9 169.9 349.7 128.8 314 103.6zM330.3 213.7C331.9 215.2 333.9 216 336 216s4.094-.7813 5.656-2.344l9.67-9.672c.0957 2.93 .6895 5.766 .5547 8.723c-2.701 58.52-52.89 106.1-111.9 106.1C181 318.8 130.8 271.2 128.1 212.7c-.1348-2.961 .459-5.797 .5547-8.727l9.67 9.672C139.9 215.2 141.9 216 144 216s4.094-.7813 5.656-2.344c3.125-3.125 3.125-8.188 0-11.31L130.1 183.7c4.857-22.07 15.97-42.34 32.86-57.89C163.1 130.1 162.7 134.5 162.7 138.9c0 17.76 6.23 34.69 17.46 48.27C172.1 198.4 169.1 211.5 169.1 225.1C169.1 264.2 200.9 296 240 296s70.86-31.79 70.86-70.86c0-13.66-3.85-26.71-11.04-37.96c11.23-13.58 17.46-30.51 17.46-48.27c0-4.426-.3828-8.809-1.146-13.14c16.88 15.54 28.01 35.81 32.87 57.9l-18.66 18.66C327.2 205.5 327.2 210.5 330.3 213.7zM448 384V32c0-17.67-14.33-32-32-32H64C28.65 0 0 28.65 0 64v391.1c0 30.93 25.07 56 55.1 56l383.1 .0078C444.4 511.1 448 508.4 448 503.1c0-4.422-3.584-8.008-8.006-8.008H416V416C433.7 416 448 401.7 448 384zM400 495.1H56c-23.38 0-42.12-20.14-39.81-43.98c2.02-20.78 20.7-36.02 41.58-36.02L400 416V495.1zM56 399.1c-15.68 0-29.82 6.516-40 16.93V64c0-26.47 21.53-48 48-48h352c8.836 0 16 7.164 16 16v352c0 8.824-7.178 16-16 16L56 399.1z"],
    "book-medical": [448, 512, [], "f7e6", "M320 159.1h-48V111.1c0-8.828-7.172-16-16-16L208 95.1c-8.828 0-16 7.172-16 16v47.1H144c-8.828 0-16 7.172-16 16v48c0 8.828 7.172 16 16 16H192v48c0 8.828 7.172 16 16 16H256c8.828 0 16-7.172 16-16v-48H320c8.828 0 16-7.172 16-16V175.1C336 167.2 328.8 159.1 320 159.1zM320 223.1l-64-.0039v64L208 287.1V223.1l-64-.0039V175.1l64-.0039V111.1L256 111.1v63.1h64V223.1zM448 384V32c0-17.67-14.33-32-32-32H64C28.65 0 0 28.65 0 64v391.1c0 30.93 25.07 56 55.1 56l383.1 .0078C444.4 511.1 448 508.4 448 503.1c0-4.422-3.584-8.008-8.006-8.008H416V416C433.7 416 448 401.7 448 384zM400 495.1H56c-23.38 0-42.12-20.14-39.81-43.98c2.02-20.78 20.7-36.02 41.58-36.02L400 416V495.1zM56 399.1c-15.68 0-29.82 6.516-40 16.93V64c0-26.47 21.53-48 48-48h352c8.836 0 16 7.164 16 16v352c0 8.824-7.178 16-16 16L56 399.1z"],
    "book-open": [576, 512, [128366, 128214], "f518", "M550.2 57.66c-47.89-17.67-92.44-25.88-131.6-25.66C349.2 33.11 301.7 56.44 288 64.03C274.3 56.44 226.8 33.11 157.5 32c-38.55-.2188-83.72 7.985-131.6 25.66C10.39 63.35 0 78.44 0 95.23v326.2c0 10.22 4.734 19.58 12.97 25.66c8.25 6.063 18.53 7.766 28.28 4.782c138.6-42.96 241.2 26.05 242.2 26.75c.1328 .0918 .3086 .0566 .4453 .1387c.1543 .0938 .2227 .2774 .3828 .3614C285.5 479.7 286.7 480 287.1 480s2.557-.3125 3.729-.9219c.1602-.084 .2285-.2676 .3828-.3614c.1367-.082 .3125-.0469 .4453-.1387c1.031-.6875 103.6-69.72 242.2-26.75c9.688 2.985 20.02 1.281 28.28-4.782C571.3 440.1 576 431.6 576 421.4V95.23C576 78.44 565.6 63.35 550.2 57.66zM280 457.8c-22.88-12.63-75.27-36.36-145.9-36.36c-29.61 0-62.42 4.172-97.61 15.08C26.69 439.6 16 432.3 16 421.4V95.23c0-10.11 6.172-19.17 15.38-22.56c46.03-16.97 88.41-25.08 125.8-24.66C221.6 49.04 267.1 70.9 280 77.9V457.8zM560 421.4c0 11.06-10.82 18.24-20.5 15.16c-119.1-36.92-211 3.344-243.5 21.28V77.9c12.94-7 58.41-28.86 122.8-29.89c37.91-.4688 79.8 7.688 125.8 24.66C553.8 76.05 560 85.12 560 95.23V421.4z"],
    "book-open-cover": [640, 512, ["book-open-alt"], "e0c0", "M632 32c-4.422 0-8 3.578-8 8v370.4c0 10.95-7.469 20.27-18.17 22.64l-280.8 62.39c-3.281 .75-6.734 .75-10.05 0l-280.8-62.39C23.47 430.7 16 421.4 16 410.4V40C16 35.58 12.42 32 8 32S0 35.58 0 40v370.4c0 18.52 12.62 34.25 30.7 38.27l280.8 62.39C314.3 511.7 317.1 512 320 512s5.719-.3125 8.5-.9375l280.8-62.39C627.4 444.7 640 428.9 640 410.4V40C640 35.58 636.4 32 632 32zM89.06 396.7L320 448l230.9-51.32C565.6 393.4 576 380.4 576 365.4V39.47c0-22.07-17.99-39.46-39.31-39.46c-2.008 0-4.047 .1396-6.102 .458L320 33.13L109.4 .4707C107.4 .1523 105.3 .0127 103.3 .0127C81.99 .0107 64 17.4 64 39.47v325.1C64 380.4 74.42 393.4 89.06 396.7zM328 48.02l205-31.73c1.23-.1895 2.451-.2832 3.654-.2832C549.5 15.1 560 26.49 560 39.39v326c0 7.557-5.152 13.98-12.53 15.62L328 429.8V48.02zM80 39.39c0-6.293 2.457-12.19 6.916-16.6C91.34 18.41 97.16 15.1 103.3 15.1c1.203 0 2.426 .0938 3.656 .2832L312 48.02V429.8l-219.5-48.77C85.15 379.4 80 372.1 80 365.4V39.39z"],
    "book-open-reader": [512, 512, ["book-reader"], "f5da", "M256 192c53 0 96-43 96-96s-43-96-96-96S160 43 160 96S203 192 256 192zM256 16c44.11 0 80 35.89 80 80S300.1 176 256 176C211.9 176 176 140.1 176 96S211.9 16 256 16zM482.2 192c-.5781 0-1.337 .0156-1.923 .0449c-53.52 2.879-161.6 16.95-224.1 56.84c-62.52-39.89-170.8-53.96-224.3-56.84C31.18 192 30.42 192 29.84 192C13.33 192 0 203.1 0 219.2v208.7c0 14.44 12.35 26.44 28.23 27.22c48.46 2.426 148.4 19.34 213.6 53.38C246.3 510.8 251.2 512 256 512c4.84 0 9.678-1.17 14.17-3.512c65.24-34.04 165.1-50.95 213.6-53.38C499.6 454.3 512 442.3 512 427.9V219.2C512 203.1 498.7 192 482.2 192zM248 493.7c-68.21-35.16-170.3-52.17-218.1-54.6C21.72 438.8 16 433.8 16 427.9V219.4c0-3.566 1.943-6.078 3.572-7.557c2.691-2.443 6.365-3.797 11.22-3.797c66.2 3.561 162.8 19.93 216.7 54.36L248 262.7V493.7zM496 427.9c0 5.945-5.717 10.88-13.04 11.24c-48.66 2.438-150.8 19.44-218.1 54.6V262.8l.7031-.4492c53.96-34.43 150.3-50.8 216.4-54.35L481.1 208C489.7 208 496 213.1 496 219.4V427.9z"],
    "book-quran": [448, 512, ["quran"], "f687", "M282.2 269.7C275.6 271.3 269.6 272 264 272c-44.13 0-80-35.89-80-80s35.88-80 80-80c5.625 0 11.59 .7656 18.06 2.266c7.625 2.047 15.47-2 18.5-9.109c3.125-7.094 .7187-15.38-5.75-19.72C273.7 71.41 249.3 64 224 64C153.4 64 96 121.4 96 192s57.41 128 128 128c25.25 0 49.72-7.406 70.84-21.45c6.438-4.328 8.844-12.61 5.75-19.66C297.5 271.7 289.6 267.8 282.2 269.7zM224 304C162.3 304 112 253.8 112 192S162.3 80 224 80c22.09 0 43.5 6.484 61.91 18.73C278 96.89 270.9 96 264 96c-52.94 0-96 43.06-96 96s43.06 96 96 96c6.875 0 14.03-.8906 21.91-2.734C267.5 297.5 246.1 304 224 304zM333.1 162.5l-24.5-3.531l-10.75-21.56c-3.375-8.625-18.34-8-21.16-.625l-11.03 22.19l-24.5 3.531c-4.5 .6562-8.125 3.75-9.5 8.078c-1.344 4.297-.1562 8.875 3.031 11.86l17.62 17.27l-4.125 24.31c-.625 3.422 .3125 6.906 2.562 9.578c2.25 2.719 5.562 4.266 9.031 4.266l3.688-.4219L288 224.1l22.19 11.67l3.344 1.188h1.812c3.469 0 6.781-1.547 9.031-4.266c2.25-2.672 3.188-6.156 2.562-9.516l-4.125-24.38l17.5-17.16c3.312-3.094 4.5-7.672 3.156-11.97C342.1 166.2 338.5 163.1 333.1 162.5zM305.6 194.1l4.125 24.22L288 206.9l-21.75 11.42l4.125-24.22l-17.41-17.05l24.12-3.5L288 151.7l10.91 21.91l24.12 3.5L305.6 194.1zM384 0H32C14.33 0 0 14.33 0 32v352c0 17.67 14.33 32 32 32v79.98H8.006C3.584 495.1 0 499.6 0 503.1c0 4.418 3.584 8.004 8.006 8l383.1-.0078c30.93 0 55.1-25.07 55.1-56V64C448 28.65 419.3 0 384 0zM392 495.1H48V416l342.2-.0156c20.88 0 39.56 15.23 41.58 36.02C434.1 475.8 415.4 495.1 392 495.1zM432 416.9c-10.18-10.42-24.32-16.93-40-16.93L32 400c-8.822 0-16-7.176-16-16V32c0-8.836 7.164-16 16-16h352c26.47 0 48 21.53 48 48V416.9z"],
    "book-section": [448, 512, ["book-law"], "e0c1", "M286.4 257.3c17.51-7.25 29.19-19.29 32.46-35.33c8.969-44.43-36.73-55.59-77.02-65.45L232.4 154.2C191.6 143.9 171.8 134.3 176.8 109.8c4.594-22.73 36.86-34.07 80.52-28.3c9.148 1.234 20.08 3.766 34.42 7.982c4.246 1.25 8.684-1.172 9.934-5.404c1.215-4.25-1.188-8.686-5.438-9.936c-15.12-4.451-26.83-7.154-36.79-8.482C206.2 58.5 167.6 74.64 161.1 106.7C155.4 134.7 172.9 149.6 193.6 158.7C176 165.9 164.3 178 161.1 194.1c-8.871 43.88 38.88 55.86 67.39 63.03l9.559 2.359c44.22 10.81 70.68 19.35 65.15 46.74c-4.621 22.74-37.13 34.1-80.54 28.29c-14.27-1.828-30.55-6.842-44.91-11.26L170.3 320.9C165.1 319.7 161.6 322.1 160.4 326.3c-1.281 4.234 1.125 8.686 5.34 9.967l7.34 2.25c14.96 4.607 31.92 9.824 47.5 11.82C228.9 351.5 236.9 352 244.5 352c40.63 0 68.9-15.67 74.36-42.64C324.5 281.6 308.8 266.9 286.4 257.3zM241.8 243.9l-9.492-2.344C191.6 231.3 171.8 221.7 176.8 197.2C180.8 177.3 201.7 171.3 220.8 167.7c2.609 .6816 17.21 4.342 17.21 4.342c44.22 10.81 70.68 19.36 65.15 46.74c-4.098 20.05-25.29 25.97-44.07 29.52C253.4 246.8 247.6 245.3 241.8 243.9zM448 384V32c0-17.67-14.33-32-32-32H64C28.66 0 0 28.65 0 64v391.1c0 30.93 25.07 56 56 56L439.1 512C444.4 512 448 508.4 448 504c0-4.422-3.586-8.008-8.008-8.008H416v-79.99C433.7 416 448 401.7 448 384zM400 495.1H56c-23.38 0-42.13-20.14-39.8-43.99c2.016-20.78 20.7-36.02 41.57-36.02L400 416V495.1zM56 399.1c-15.68 0-29.82 6.516-40 16.93V64c0-26.47 21.53-48 48-48h352c8.836 0 16 7.164 16 16v352c0 8.824-7.18 15.1-16 15.1L56 399.1z"],
    "book-skull": [448, 512, ["book-dead"], "f6b7", "M272 152c8.836 0 16-7.164 16-16s-7.164-16-16-16S256 127.2 256 136S263.2 152 272 152zM184 191.3V216C184 220.4 187.6 224 192 224h96c4.406 0 8-3.578 8-8V191.3c20.41-13.75 32-33.69 32-55.28C328 96.3 288.5 64 240 64S152 96.3 152 136C152 157.6 163.6 177.5 184 191.3zM239.1 80C279.7 80 312 105.1 312 136c0 17.19-10.25 33.25-28.12 44.06C281.5 181.5 280 184.1 280 186.9V208h-80V186.9c0-2.797-1.469-5.391-3.875-6.844C178.3 169.3 168 153.2 168 136C168 105.1 200.3 80 239.1 80zM351 228.2c-2.094-3.906-6.969-5.297-10.81-3.25L240 278.9L139.8 224.1C135.9 222.9 131.1 224.3 128.1 228.2c-2.094 3.891-.6562 8.75 3.25 10.84L223.1 288l-90.91 48.95c-3.906 2.094-5.344 6.953-3.25 10.84C130.4 350.5 133.2 352 136 352c1.281 0 2.594-.3125 3.781-.9531L240 297.1l100.2 53.96C341.4 351.7 342.7 352 344 352c2.844 0 5.594-1.531 7.031-4.203c2.094-3.891 .6562-8.75-3.25-10.84L256.9 288l90.91-48.95C351.7 236.1 353.1 232.1 351 228.2zM208 152c8.836 0 16-7.164 16-16s-7.164-16-16-16S192 127.2 192 136S199.2 152 208 152zM448 384V32c0-17.67-14.33-32-32-32H64C28.65 0 0 28.65 0 64v391.1c0 30.93 25.07 56 55.1 56l383.1 .0078C444.4 511.1 448 508.4 448 503.1c0-4.422-3.584-8.008-8.006-8.008H416V416C433.7 416 448 401.7 448 384zM400 495.1H56c-23.38 0-42.12-20.14-39.81-43.98c2.02-20.78 20.7-36.02 41.58-36.02L400 416V495.1zM56 399.1c-15.68 0-29.82 6.516-40 16.93V64c0-26.47 21.53-48 48-48h352c8.836 0 16 7.164 16 16v352c0 8.824-7.178 16-16 16L56 399.1z"],
    "book-sparkles": [448, 512, ["book-spells"], "f6b8", "M200 119.1h-32v-32C168 83.57 164.4 80 160 80S152 83.57 152 87.1v32h-32c-4.406 0-8 3.578-8 8s3.594 8 8 8h32v31.1c0 4.422 3.594 8 8 8s8-3.578 8-8V135.1h32c4.406 0 8-3.578 8-8S204.4 119.1 200 119.1zM344 247.1h-48v-48c0-4.422-3.594-8-8-8s-8 3.578-8 8v48h-48c-4.406 0-8 3.582-8 8.004s3.594 7.996 8 7.996h48v48c0 4.422 3.592 8.004 7.998 8.004S296 316.4 296 311.1v-48h48c4.406 0 8-3.574 8-7.996S348.4 247.1 344 247.1zM448 384V32c0-17.67-14.33-32-32-32H64C28.65 0 0 28.65 0 64v391.1c0 30.93 25.07 56 55.1 56l383.1 .0078C444.4 511.1 448 508.4 448 503.1c0-4.422-3.584-8.008-8.006-8.008H416V416C433.7 416 448 401.7 448 384zM400 495.1H56c-23.38 0-42.12-20.14-39.81-43.98c2.02-20.78 20.7-36.02 41.58-36.02L400 416V495.1zM56 399.1c-15.68 0-29.82 6.516-40 16.93V64c0-26.47 21.53-48 48-48h352c8.836 0 16 7.164 16 16v352c0 8.824-7.178 16-16 16L56 399.1z"],
    "book-tanakh": [448, 512, ["tanakh"], "f827", "M341.1 144.4C339.1 139.2 333.6 136 327.5 136h-59.71l-29.72-48.22c-6-9.75-22.19-9.734-28.19-.0156L180.2 136H120.5c-6.031 0-11.59 3.203-14.47 8.359C103.2 149.4 103.3 155.3 106.3 160.2l29.46 47.79L106.3 255.8C103.3 260.7 103.2 266.6 105.1 271.6C108.9 276.8 114.4 280 120.5 280h59.71l29.72 48.22C212.9 333.1 218.2 336 224 336s11.09-2.906 14.09-7.766L267.8 280h59.71c6.031 0 11.59-3.203 14.47-8.359c2.814-5.031 2.689-10.95-.3418-15.86l-29.46-47.79l29.46-47.79C344.7 155.3 344.8 149.4 341.1 144.4zM224.5 96.17L249.1 136H199.7L224.5 96.17zM119.1 152.2C119.1 152.2 120.1 152 120.5 152l49.88-.0469L145.1 192.9L119.1 152.2zM119.1 264.2l25.35-40.75l25.09 40.7L119.1 264.2zM223.5 319.8L198.9 280h49.37L223.5 319.8zM258.2 264.1L189.1 264.1L154.7 208.4l35.1-56.44l69.09-.0625l34.44 55.75L258.2 264.1zM328 263.8c0 .0156-.0938 .1719-.5 .1719l-49.88 .0469l25.23-40.93L328 263.8zM302.7 192.6l-25.09-40.7l50.44-.0469L302.7 192.6zM384 0H32C14.33 0 0 14.33 0 32v352c0 17.67 14.33 32 32 32v79.98H8.006C3.584 495.1 0 499.6 0 503.1c0 4.418 3.584 8.004 8.006 8l383.1-.0078c30.93 0 55.1-25.07 55.1-56V64C448 28.65 419.3 0 384 0zM392 495.1H48V416l342.2-.0156c20.88 0 39.56 15.23 41.58 36.02C434.1 475.8 415.4 495.1 392 495.1zM432 416.9c-10.18-10.42-24.32-16.93-40-16.93L32 400c-8.822 0-16-7.176-16-16V32c0-8.836 7.164-16 16-16h352c26.47 0 48 21.53 48 48V416.9z"],
    "book-user": [448, 512, [], "f7e7", "M448 384V32c0-17.67-14.33-32-32-32H64C28.65 0 0 28.65 0 64v391.1c0 30.93 25.07 56 55.1 56l383.1 .0078C444.4 511.1 448 508.4 448 503.1c0-4.422-3.584-8.008-8.006-8.008H416V416C433.7 416 448 401.7 448 384zM400 495.1H56c-23.38 0-42.12-20.14-39.81-43.98c2.02-20.78 20.7-36.02 41.58-36.02L400 416V495.1zM56 399.1c-15.68 0-29.82 6.516-40 16.93V64c0-26.47 21.53-48 48-48h352c8.836 0 16 7.164 16 16v352c0 8.824-7.178 16-16 16L56 399.1zM240 208c35.35 0 64-28.66 64-64s-28.65-64-64-64c-35.34 0-64 28.66-64 64S204.7 208 240 208zM240 96C266.5 96 288 117.5 288 144S266.5 192 240 192S192 170.5 192 144S213.5 96 240 96zM272 240h-64C163.9 240 128 275.9 128 320v8c0 4.422 3.578 8 8 8s8-3.578 8-8V320c0-35.3 28.7-64 64-64h64c35.3 0 64 28.7 64 64v8c0 4.422 3.578 8 8 8S352 332.4 352 328V320C352 275.9 316.1 240 272 240z"],
    "bookmark": [384, 512, [61591, 128278], "f02e", "M320 16c26.47 0 48 21.53 48 48v431.1L192 393.3l-176 102.7V64c0-26.47 21.53-48 48-48H320zM320 0H64C28.65 0 0 28.65 0 64v431.1c0 12.35 13.4 20.03 24.06 13.81L192 411.8l167.9 97.96C370.6 516 384 508.3 384 495.1V64C384 28.65 355.3 0 320 0z"],
    "bookmark-slash": [640, 512, [], "e0c2", "M192 16h256c26.47 0 48 21.53 48 48v239.9L512 316.6V64c0-35.35-28.65-64-64-64H192C172.2 0 154.7 9.184 142.1 23.31l12.49 9.924C164.3 22.79 177.3 16 192 16zM144 495.1V208.1L128 195.4v300.6c0 12.35 13.39 20.03 24.06 13.81L320 411.8l167.9 97.96c8.164 4.76 17.19 .9355 21.21-6.506L320 393.3L144 495.1zM636.1 497.7L12.99 1.73C11.53 .5664 9.771 0 8.025 0C5.674 0 3.336 1.029 1.738 3.012c-2.75 3.469-2.172 8.5 1.281 11.25l623.1 496C628.5 511.4 630.2 512 631.1 512c2.344 0 4.688-1.031 6.266-3.016C641 505.5 640.4 500.5 636.1 497.7z"],
    "books": [512, 512, [128218], "f5db", "M510.6 445.3L397.8 29.55C392.9 11.74 376.6 0 358.8 0c-3.457 0-6.975 .4414-10.47 1.367l-62.39 16.5c-6.514 1.723-11.85 5.246-16.49 9.461C264.1 11.54 249.6 0 232 0h-64c-13.44 0-24.75 7.062-32 17.23C128.7 7.062 117.4 0 104 0h-64C17.91 0 0 17.91 0 40v432C0 494.1 17.91 512 40 512h64c13.44 0 24.75-7.062 32-17.23C143.3 504.9 154.6 512 168 512h64c22.09 0 40-17.91 40-40V120.5l98.23 361.9C375.1 500.3 391.4 512 409.2 512c3.457 0 6.973-.4414 10.47-1.367l62.39-16.5C503.6 488.4 516.4 466.6 510.6 445.3zM366.9 409l-75.22-277.1l109.4-28.95l75.22 277.1L366.9 409zM168 16h64C245.2 16 256 26.77 256 40V96H144V40C144 26.77 154.8 16 168 16zM256 400H144v-288H256V400zM16 112H128v288H16V112zM16 40c0-13.23 10.77-24 24-24h64C117.2 16 128 26.77 128 40l.0011 56L16 96V40zM104 496h-64c-13.23 0-24-10.77-24-24V416l112 0L128 472C128 485.2 117.2 496 104 496zM256 472c0 13.23-10.77 24-24 24h-64c-13.23 0-24-10.77-24-24V416H256V472zM275.2 44.64c3.236-5.605 8.514-9.617 14.86-11.3l62.39-16.5C354.5 16.28 356.7 16 358.8 16c11.02 0 20.69 7.297 23.53 17.74l14.6 53.8l-109.4 28.95l-14.65-53.99C271.2 56.43 272 50.09 275.2 44.64zM492.8 467.4c-3.236 5.605-8.514 9.617-14.86 11.3l-62.39 16.5C413.5 495.7 411.3 496 409.2 496c-11.02 0-20.7-7.297-23.53-17.74l-14.6-53.8l109.4-28.95l14.65 53.99C496.8 455.6 495.1 461.9 492.8 467.4z"],
    "books-medical": [576, 512, [], "f7e8", "M63.1 336c0 13.23 10.77 24 24 24h32c13.23 0 24-10.77 24-24V296h40c13.23 0 24-10.77 24-24v-32c0-13.23-10.77-24-24-24H144V176c0-13.23-10.77-24-24-24h-32c-13.23 0-24 10.77-24 24L64 216H24C10.77 216 0 226.8 0 240v32C0 285.2 10.77 296 24 296H64L63.1 336zM24 280C19.59 280 16 276.4 16 272v-32c0-4.406 3.594-8 8-8H80V176c0-4.406 3.594-8 8-8h32c4.406 0 7.998 3.598 7.998 8.005L128 232h56c4.406 0 7.996 3.596 7.996 8.002v32C191.1 276.4 188.4 280 184 280H128L127.1 336c0 4.406-3.591 8-7.998 8h-32c-4.406 0-8-3.594-8-8V280H24zM574.6 445.3L461.8 29.55C456.9 11.74 440.6 0 422.8 0c-3.457 0-6.975 .4414-10.47 1.367l-62.39 16.5c-6.514 1.723-11.85 5.246-16.49 9.461C328.1 11.54 313.6 0 296 0h-64c-13.44 0-24.75 7.062-32 17.23C192.7 7.062 181.4 0 168 0h-64C81.91 0 64 17.91 64 40v80C64 124.4 67.58 128 72 128S80 124.4 80 120V112H192v72C192 188.4 195.6 192 200 192S208 188.4 208 184V112H320v288H208v-72C208 323.6 204.4 320 200 320S192 323.6 192 328v72H80v-8C80 387.6 76.42 384 72 384S64 387.6 64 392v80C64 494.1 81.91 512 104 512h64c13.44 0 24.75-7.062 32-17.23C207.3 504.9 218.6 512 232 512h64c22.09 0 40-17.91 40-40V120.5l98.23 361.9C439.1 500.3 455.4 512 473.2 512c3.457 0 6.973-.4414 10.47-1.367l62.39-16.5C567.6 488.4 580.4 466.6 574.6 445.3zM192 96H80V40c0-13.23 10.77-24 24-24h64C181.2 16 192 26.77 192 40L192 96zM192 472c0 13.23-10.77 24-24 24h-64c-13.23 0-24-10.77-24-24V416h112L192 472zM320 472c0 13.23-10.77 24-24 24h-64c-13.23 0-24-10.77-24-24V416H320V472zM320 96H208V40c0-13.23 10.77-24 24-24h64C309.2 16 320 26.77 320 40V96zM336.8 62.49c-1.643-6.059-.8145-12.4 2.336-17.86c3.236-5.605 8.514-9.617 14.86-11.3l62.39-16.5C418.5 16.28 420.7 16 422.8 16c11.02 0 20.69 7.297 23.53 17.74l14.6 53.8l-109.4 28.95L336.8 62.49zM430.9 409l-75.22-277.1l109.4-28.95l75.22 277.1L430.9 409zM556.8 467.4c-3.236 5.605-8.514 9.617-14.86 11.3l-62.39 16.5C477.5 495.7 475.3 496 473.2 496c-11.02 0-20.7-7.297-23.53-17.74l-14.6-53.8l109.4-28.95l14.65 53.99C560.8 455.6 559.1 461.9 556.8 467.4z"],
    "boombox": [640, 512, [128254], "f8a5", "M576 160V72C576 32.3 543.7 0 504 0H136C96.3 0 64 32.3 64 72V160C28.65 160 0 188.7 0 224v224c0 35.35 28.65 64 64 64h512c35.35 0 64-28.65 64-64V224C640 188.7 611.3 160 576 160zM80 72c0-30.88 25.12-56 56-56h368c30.88 0 56 25.12 56 56V160h-480V72zM624 448c0 26.47-21.53 48-48 48H64c-26.47 0-48-21.53-48-48V224c0-26.47 21.53-48 48-48h512c26.47 0 48 21.53 48 48V448zM176 224C114.1 224 64 274.1 64 336S114.1 448 176 448S288 397.9 288 336S237.9 224 176 224zM176 432c-52.94 0-96-43.06-96-96s43.06-96 96-96s96 43.06 96 96S228.9 432 176 432zM464 224C402.1 224 352 274.1 352 336s50.14 112 112 112s112-50.14 112-112S525.9 224 464 224zM464 432c-52.94 0-96-43.06-96-96s43.06-96 96-96s96 43.06 96 96S516.9 432 464 432zM248 120h-48C195.6 120 192 123.6 192 128s3.578 8 8 8h48C252.4 136 256 132.4 256 128S252.4 120 248 120zM344 120h-48C291.6 120 288 123.6 288 128s3.578 8 8 8h48C348.4 136 352 132.4 352 128S348.4 120 344 120zM440 120h-48C387.6 120 384 123.6 384 128s3.578 8 8 8h48C444.4 136 448 132.4 448 128S444.4 120 440 120z"],
    "boot": [512, 512, [129406], "f782", "M439.2 285.8L320 256V112c17.67 0 32-14.33 32-32V32c0-17.67-14.33-32-32-32H32C14.33 0 0 14.33 0 32v434.7c0 8.486 3.32 16.49 9.322 22.49L32 512h64l32-32l32 32h64l32-32l32 32h64l32-32l32 32h64l22.63-22.67C508.6 483.3 512 475.2 512 466.7v-87.79C512 334.9 482 296.4 439.2 285.8zM16 32c0-8.822 7.178-16 16-16h288c8.822 0 16 7.178 16 16v48C336 88.82 328.8 96 320 96H16V32zM304 112v32H224c-4.422 0-8 3.578-8 8S219.6 160 224 160h80v40H224c-4.422 0-8 3.578-8 8S219.6 216 224 216h80V256H224C219.6 256 216 259.6 216 264S219.6 272 224 272h94.04l117.3 29.27C471.1 310.2 496 342.1 496 378.9V416h-480V112H304zM491.3 478.1L473.4 496h-50.75l-27.31-27.31C392.2 465.6 388.1 464 384 464s-8.189 1.562-11.31 4.686L345.4 496h-50.75l-27.31-27.31C264.2 465.6 260.1 464 256 464s-8.189 1.562-11.31 4.686L217.4 496H166.6l-27.31-27.31C136.2 465.6 132.1 464 128 464s-8.189 1.562-11.31 4.686L89.37 496H38.63l-17.94-17.94C17.66 475 16 471 16 466.7V432h480v34.75C496 471 494.3 475 491.3 478.1z"],
    "boot-heeled": [512, 512, [], "e33f", "M488 496h-7.996v-48.45c0-24.24-13.7-46.4-35.38-57.24l-121.2-60.62c-21.68-10.84-35.38-33-35.38-57.24V32c0-17.67-14.33-32-32-32h-192C44.76 0 29.87 16.87 32.25 35.97l24.44 161.5c4.816 38.53 .9434 77.66-11.34 114.5c-8.838 26.52-13.35 54.29-13.35 82.24l-.002 37.79c0 .0039 0-.0039 0 0L32 488C32 501.2 42.78 512 56 512h80C149.2 512 160 501.2 160 488v-39.5l110.8 55.78C280.8 509.3 292 512 303.2 512H488c4.406 0 8-3.594 8-8S492.4 496 488 496zM144 488c0 4.406-3.594 8-8 8h-80c-4.406 0-8-3.594-8-8l.0039-48h89.53c2.281 0 4.5 .3125 6.469 .8438V488zM303.2 496c-8.688 0-17.41-2.062-25.16-6l-124.1-62.88C148.1 425.1 142.9 424 137.5 424H48v-29.8c0-26.28 4.215-52.24 12.53-77.18c12.95-38.86 17.12-80.89 11.98-121.1L48.13 33.98C47.55 29.37 48.93 24.9 52.01 21.41C55.09 17.92 59.35 16 64 16H128v232C128 252.4 131.6 256 136 256S144 252.4 144 248V16h112c8.822 0 16 7.178 16 16v240.4c0 30.5 16.95 57.92 44.22 71.55l121.2 60.62c16.37 8.184 26.53 24.63 26.53 42.93V496H303.2z"],
    "booth-curtain": [512, 512, [], "f734", "M472 0H40C17.94 0 0 17.94 0 40v464C0 508.4 3.594 512 8 512s8-3.578 8-8V40c0-13.23 10.78-24 24-24H96v384C96 426.5 117.5 448 144 448c16.72 0 31.41-8.564 40-21.53C192.6 439.4 207.3 448 224 448s31.41-8.564 40-21.53C272.6 439.4 287.3 448 304 448s31.41-8.564 40-21.53C352.6 439.4 367.3 448 384 448s31.41-8.564 40-21.53C432.6 439.4 447.3 448 464 448c12.35 0 23.49-4.795 32-12.46V504c0 4.422 3.594 8 8 8S512 508.4 512 504V40C512 17.94 494.1 0 472 0zM176 400c0 17.64-14.36 32-32 32s-32-14.36-32-32v-384h64V400zM256 400c0 17.64-14.36 32-32 32s-32-14.36-32-32v-384h64V400zM336 400c0 17.64-14.36 32-32 32s-32-14.36-32-32v-384h64V400zM416 400c0 17.64-14.36 32-32 32s-32-14.36-32-32v-384h64V400zM496 400c0 17.64-14.36 32-32 32s-32-14.36-32-32v-384h40c13.22 0 24 10.77 24 24V400z"],
    "border-all": [448, 512, [], "f84c", "M384 32C419.3 32 448 60.65 448 96V416C448 451.3 419.3 480 384 480H64C28.65 480 0 451.3 0 416V96C0 60.65 28.65 32 64 32H384zM384 48H224V240H432V96C432 69.49 410.5 48 384 48zM432 256H224V464H384C410.5 464 432 442.5 432 416V256zM208 240V48H64C37.49 48 16 69.49 16 96V240H208zM16 256V416C16 442.5 37.49 464 64 464H208V256H16z"],
    "border-bottom": [448, 512, [], "f84d", "M8 464H440C444.4 464 448 467.6 448 472C448 476.4 444.4 480 440 480H8C3.582 480 0 476.4 0 472C0 467.6 3.582 464 8 464zM32 336C40.84 336 48 343.2 48 352C48 360.8 40.84 368 32 368C23.16 368 16 360.8 16 352C16 343.2 23.16 336 32 336zM432 352C432 360.8 424.8 368 416 368C407.2 368 400 360.8 400 352C400 343.2 407.2 336 416 336C424.8 336 432 343.2 432 352zM224 336C232.8 336 240 343.2 240 352C240 360.8 232.8 368 224 368C215.2 368 208 360.8 208 352C208 343.2 215.2 336 224 336zM48 160C48 168.8 40.84 176 32 176C23.16 176 16 168.8 16 160C16 151.2 23.16 144 32 144C40.84 144 48 151.2 48 160zM416 144C424.8 144 432 151.2 432 160C432 168.8 424.8 176 416 176C407.2 176 400 168.8 400 160C400 151.2 407.2 144 416 144zM240 160C240 168.8 232.8 176 224 176C215.2 176 208 168.8 208 160C208 151.2 215.2 144 224 144C232.8 144 240 151.2 240 160zM32 240C40.84 240 48 247.2 48 256C48 264.8 40.84 272 32 272C23.16 272 16 264.8 16 256C16 247.2 23.16 240 32 240zM432 256C432 264.8 424.8 272 416 272C407.2 272 400 264.8 400 256C400 247.2 407.2 240 416 240C424.8 240 432 247.2 432 256zM224 240C232.8 240 240 247.2 240 256C240 264.8 232.8 272 224 272C215.2 272 208 264.8 208 256C208 247.2 215.2 240 224 240zM48 64C48 72.84 40.84 80 32 80C23.16 80 16 72.84 16 64C16 55.16 23.16 48 32 48C40.84 48 48 55.16 48 64zM416 48C424.8 48 432 55.16 432 64C432 72.84 424.8 80 416 80C407.2 80 400 72.84 400 64C400 55.16 407.2 48 416 48zM240 64C240 72.84 232.8 80 224 80C215.2 80 208 72.84 208 64C208 55.16 215.2 48 224 48C232.8 48 240 55.16 240 64zM128 240C136.8 240 144 247.2 144 256C144 264.8 136.8 272 128 272C119.2 272 112 264.8 112 256C112 247.2 119.2 240 128 240zM144 64C144 72.84 136.8 80 128 80C119.2 80 112 72.84 112 64C112 55.16 119.2 48 128 48C136.8 48 144 55.16 144 64zM320 48C328.8 48 336 55.16 336 64C336 72.84 328.8 80 320 80C311.2 80 304 72.84 304 64C304 55.16 311.2 48 320 48zM336 256C336 264.8 328.8 272 320 272C311.2 272 304 264.8 304 256C304 247.2 311.2 240 320 240C328.8 240 336 247.2 336 256z"],
    "border-bottom-right": [448, 512, ["border-style-alt"], "f854", "M448 424C448 454.9 422.9 480 392 480H24C19.58 480 16 476.4 16 472C16 467.6 19.58 464 24 464H392C414.1 464 432 446.1 432 424V56C432 51.58 435.6 48 440 48C444.4 48 448 51.58 448 56V424zM304 64C304 55.16 311.2 48 320 48C328.8 48 336 55.16 336 64C336 72.84 328.8 80 320 80C311.2 80 304 72.84 304 64zM112 64C112 55.16 119.2 48 128 48C136.8 48 144 55.16 144 64C144 72.84 136.8 80 128 80C119.2 80 112 72.84 112 64zM224 48C232.8 48 240 55.16 240 64C240 72.84 232.8 80 224 80C215.2 80 208 72.84 208 64C208 55.16 215.2 48 224 48zM16 64C16 55.16 23.16 48 32 48C40.84 48 48 55.16 48 64C48 72.84 40.84 80 32 80C23.16 80 16 72.84 16 64zM32 240C40.84 240 48 247.2 48 256C48 264.8 40.84 272 32 272C23.16 272 16 264.8 16 256C16 247.2 23.16 240 32 240zM16 160C16 151.2 23.16 144 32 144C40.84 144 48 151.2 48 160C48 168.8 40.84 176 32 176C23.16 176 16 168.8 16 160zM32 336C40.84 336 48 343.2 48 352C48 360.8 40.84 368 32 368C23.16 368 16 360.8 16 352C16 343.2 23.16 336 32 336z"],
    "border-center-h": [448, 512, [], "f89c", "M440 248C444.4 248 448 251.6 448 256C448 260.4 444.4 264 440 264H8C3.582 264 0 260.4 0 256C0 251.6 3.582 248 8 248H440zM32 80C23.16 80 16 72.84 16 64C16 55.16 23.16 48 32 48C40.84 48 48 55.16 48 64C48 72.84 40.84 80 32 80zM32 464C23.16 464 16 456.8 16 448C16 439.2 23.16 432 32 432C40.84 432 48 439.2 48 448C48 456.8 40.84 464 32 464zM128 80C119.2 80 112 72.84 112 64C112 55.16 119.2 48 128 48C136.8 48 144 55.16 144 64C144 72.84 136.8 80 128 80zM128 464C119.2 464 112 456.8 112 448C112 439.2 119.2 432 128 432C136.8 432 144 439.2 144 448C144 456.8 136.8 464 128 464zM336 448C336 456.8 328.8 464 320 464C311.2 464 304 456.8 304 448C304 439.2 311.2 432 320 432C328.8 432 336 439.2 336 448zM320 80C311.2 80 304 72.84 304 64C304 55.16 311.2 48 320 48C328.8 48 336 55.16 336 64C336 72.84 328.8 80 320 80zM240 448C240 456.8 232.8 464 224 464C215.2 464 208 456.8 208 448C208 439.2 215.2 432 224 432C232.8 432 240 439.2 240 448zM224 80C215.2 80 208 72.84 208 64C208 55.16 215.2 48 224 48C232.8 48 240 55.16 240 64C240 72.84 232.8 80 224 80zM432 448C432 456.8 424.8 464 416 464C407.2 464 400 456.8 400 448C400 439.2 407.2 432 416 432C424.8 432 432 439.2 432 448zM432 64C432 72.84 424.8 80 416 80C407.2 80 400 72.84 400 64C400 55.16 407.2 48 416 48C424.8 48 432 55.16 432 64zM240 352C240 360.8 232.8 368 224 368C215.2 368 208 360.8 208 352C208 343.2 215.2 336 224 336C232.8 336 240 343.2 240 352zM416 368C407.2 368 400 360.8 400 352C400 343.2 407.2 336 416 336C424.8 336 432 343.2 432 352C432 360.8 424.8 368 416 368zM48 352C48 360.8 40.84 368 32 368C23.16 368 16 360.8 16 352C16 343.2 23.16 336 32 336C40.84 336 48 343.2 48 352zM416 176C407.2 176 400 168.8 400 160C400 151.2 407.2 144 416 144C424.8 144 432 151.2 432 160C432 168.8 424.8 176 416 176zM48 160C48 168.8 40.84 176 32 176C23.16 176 16 168.8 16 160C16 151.2 23.16 144 32 144C40.84 144 48 151.2 48 160zM224 176C215.2 176 208 168.8 208 160C208 151.2 215.2 144 224 144C232.8 144 240 151.2 240 160C240 168.8 232.8 176 224 176z"],
    "border-center-v": [448, 512, [], "f89d", "M216 40C216 35.58 219.6 32 224 32C228.4 32 232 35.58 232 40V472C232 476.4 228.4 480 224 480C219.6 480 216 476.4 216 472V40zM48 448C48 456.8 40.84 464 32 464C23.16 464 16 456.8 16 448C16 439.2 23.16 432 32 432C40.84 432 48 439.2 48 448zM432 448C432 456.8 424.8 464 416 464C407.2 464 400 456.8 400 448C400 439.2 407.2 432 416 432C424.8 432 432 439.2 432 448zM48 352C48 360.8 40.84 368 32 368C23.16 368 16 360.8 16 352C16 343.2 23.16 336 32 336C40.84 336 48 343.2 48 352zM432 352C432 360.8 424.8 368 416 368C407.2 368 400 360.8 400 352C400 343.2 407.2 336 416 336C424.8 336 432 343.2 432 352zM416 144C424.8 144 432 151.2 432 160C432 168.8 424.8 176 416 176C407.2 176 400 168.8 400 160C400 151.2 407.2 144 416 144zM48 160C48 168.8 40.84 176 32 176C23.16 176 16 168.8 16 160C16 151.2 23.16 144 32 144C40.84 144 48 151.2 48 160zM416 240C424.8 240 432 247.2 432 256C432 264.8 424.8 272 416 272C407.2 272 400 264.8 400 256C400 247.2 407.2 240 416 240zM48 256C48 264.8 40.84 272 32 272C23.16 272 16 264.8 16 256C16 247.2 23.16 240 32 240C40.84 240 48 247.2 48 256zM416 48C424.8 48 432 55.16 432 64C432 72.84 424.8 80 416 80C407.2 80 400 72.84 400 64C400 55.16 407.2 48 416 48zM32 48C40.84 48 48 55.16 48 64C48 72.84 40.84 80 32 80C23.16 80 16 72.84 16 64C16 55.16 23.16 48 32 48zM320 240C328.8 240 336 247.2 336 256C336 264.8 328.8 272 320 272C311.2 272 304 264.8 304 256C304 247.2 311.2 240 320 240zM336 64C336 72.84 328.8 80 320 80C311.2 80 304 72.84 304 64C304 55.16 311.2 48 320 48C328.8 48 336 55.16 336 64zM320 432C328.8 432 336 439.2 336 448C336 456.8 328.8 464 320 464C311.2 464 304 456.8 304 448C304 439.2 311.2 432 320 432zM144 64C144 72.84 136.8 80 128 80C119.2 80 112 72.84 112 64C112 55.16 119.2 48 128 48C136.8 48 144 55.16 144 64zM128 432C136.8 432 144 439.2 144 448C144 456.8 136.8 464 128 464C119.2 464 112 456.8 112 448C112 439.2 119.2 432 128 432zM144 256C144 264.8 136.8 272 128 272C119.2 272 112 264.8 112 256C112 247.2 119.2 240 128 240C136.8 240 144 247.2 144 256z"],
    "border-inner": [448, 512, [], "f84e", "M216 264H8C3.582 264 0 260.4 0 256C0 251.6 3.582 248 8 248H216V40C216 35.58 219.6 32 224 32C228.4 32 232 35.58 232 40V248H440C444.4 248 448 251.6 448 256C448 260.4 444.4 264 440 264H232V472C232 476.4 228.4 480 224 480C219.6 480 216 476.4 216 472V264zM16 448C16 439.2 23.16 432 32 432C40.84 432 48 439.2 48 448C48 456.8 40.84 464 32 464C23.16 464 16 456.8 16 448zM400 448C400 439.2 407.2 432 416 432C424.8 432 432 439.2 432 448C432 456.8 424.8 464 416 464C407.2 464 400 456.8 400 448zM16 352C16 343.2 23.16 336 32 336C40.84 336 48 343.2 48 352C48 360.8 40.84 368 32 368C23.16 368 16 360.8 16 352zM400 352C400 343.2 407.2 336 416 336C424.8 336 432 343.2 432 352C432 360.8 424.8 368 416 368C407.2 368 400 360.8 400 352zM432 160C432 168.8 424.8 176 416 176C407.2 176 400 168.8 400 160C400 151.2 407.2 144 416 144C424.8 144 432 151.2 432 160zM16 160C16 151.2 23.16 144 32 144C40.84 144 48 151.2 48 160C48 168.8 40.84 176 32 176C23.16 176 16 168.8 16 160zM432 64C432 72.84 424.8 80 416 80C407.2 80 400 72.84 400 64C400 55.16 407.2 48 416 48C424.8 48 432 55.16 432 64zM48 64C48 72.84 40.84 80 32 80C23.16 80 16 72.84 16 64C16 55.16 23.16 48 32 48C40.84 48 48 55.16 48 64zM336 64C336 72.84 328.8 80 320 80C311.2 80 304 72.84 304 64C304 55.16 311.2 48 320 48C328.8 48 336 55.16 336 64zM304 448C304 439.2 311.2 432 320 432C328.8 432 336 439.2 336 448C336 456.8 328.8 464 320 464C311.2 464 304 456.8 304 448zM144 64C144 72.84 136.8 80 128 80C119.2 80 112 72.84 112 64C112 55.16 119.2 48 128 48C136.8 48 144 55.16 144 64zM112 448C112 439.2 119.2 432 128 432C136.8 432 144 439.2 144 448C144 456.8 136.8 464 128 464C119.2 464 112 456.8 112 448z"],
    "border-left": [448, 512, [], "f84f", "M8 480C3.582 480 0 476.4 0 472V40C0 35.58 3.582 32 8 32C12.42 32 16 35.58 16 40V472C16 476.4 12.42 480 8 480zM128 464C119.2 464 112 456.8 112 448C112 439.2 119.2 432 128 432C136.8 432 144 439.2 144 448C144 456.8 136.8 464 128 464zM144 64C144 72.84 136.8 80 128 80C119.2 80 112 72.84 112 64C112 55.16 119.2 48 128 48C136.8 48 144 55.16 144 64zM128 272C119.2 272 112 264.8 112 256C112 247.2 119.2 240 128 240C136.8 240 144 247.2 144 256C144 264.8 136.8 272 128 272zM336 448C336 456.8 328.8 464 320 464C311.2 464 304 456.8 304 448C304 439.2 311.2 432 320 432C328.8 432 336 439.2 336 448zM320 80C311.2 80 304 72.84 304 64C304 55.16 311.2 48 320 48C328.8 48 336 55.16 336 64C336 72.84 328.8 80 320 80zM336 256C336 264.8 328.8 272 320 272C311.2 272 304 264.8 304 256C304 247.2 311.2 240 320 240C328.8 240 336 247.2 336 256zM224 464C215.2 464 208 456.8 208 448C208 439.2 215.2 432 224 432C232.8 432 240 439.2 240 448C240 456.8 232.8 464 224 464zM240 64C240 72.84 232.8 80 224 80C215.2 80 208 72.84 208 64C208 55.16 215.2 48 224 48C232.8 48 240 55.16 240 64zM224 272C215.2 272 208 264.8 208 256C208 247.2 215.2 240 224 240C232.8 240 240 247.2 240 256C240 264.8 232.8 272 224 272zM432 448C432 456.8 424.8 464 416 464C407.2 464 400 456.8 400 448C400 439.2 407.2 432 416 432C424.8 432 432 439.2 432 448zM416 80C407.2 80 400 72.84 400 64C400 55.16 407.2 48 416 48C424.8 48 432 55.16 432 64C432 72.84 424.8 80 416 80zM432 256C432 264.8 424.8 272 416 272C407.2 272 400 264.8 400 256C400 247.2 407.2 240 416 240C424.8 240 432 247.2 432 256zM224 368C215.2 368 208 360.8 208 352C208 343.2 215.2 336 224 336C232.8 336 240 343.2 240 352C240 360.8 232.8 368 224 368zM432 352C432 360.8 424.8 368 416 368C407.2 368 400 360.8 400 352C400 343.2 407.2 336 416 336C424.8 336 432 343.2 432 352zM416 176C407.2 176 400 168.8 400 160C400 151.2 407.2 144 416 144C424.8 144 432 151.2 432 160C432 168.8 424.8 176 416 176zM240 160C240 168.8 232.8 176 224 176C215.2 176 208 168.8 208 160C208 151.2 215.2 144 224 144C232.8 144 240 151.2 240 160z"],
    "border-none": [448, 512, [], "f850", "M48 448C48 456.8 40.84 464 32 464C23.16 464 16 456.8 16 448C16 439.2 23.16 432 32 432C40.84 432 48 439.2 48 448zM128 80C119.2 80 112 72.84 112 64C112 55.16 119.2 48 128 48C136.8 48 144 55.16 144 64C144 72.84 136.8 80 128 80zM128 464C119.2 464 112 456.8 112 448C112 439.2 119.2 432 128 432C136.8 432 144 439.2 144 448C144 456.8 136.8 464 128 464zM144 256C144 264.8 136.8 272 128 272C119.2 272 112 264.8 112 256C112 247.2 119.2 240 128 240C136.8 240 144 247.2 144 256zM320 464C311.2 464 304 456.8 304 448C304 439.2 311.2 432 320 432C328.8 432 336 439.2 336 448C336 456.8 328.8 464 320 464zM336 64C336 72.84 328.8 80 320 80C311.2 80 304 72.84 304 64C304 55.16 311.2 48 320 48C328.8 48 336 55.16 336 64zM320 272C311.2 272 304 264.8 304 256C304 247.2 311.2 240 320 240C328.8 240 336 247.2 336 256C336 264.8 328.8 272 320 272zM240 448C240 456.8 232.8 464 224 464C215.2 464 208 456.8 208 448C208 439.2 215.2 432 224 432C232.8 432 240 439.2 240 448zM224 80C215.2 80 208 72.84 208 64C208 55.16 215.2 48 224 48C232.8 48 240 55.16 240 64C240 72.84 232.8 80 224 80zM240 256C240 264.8 232.8 272 224 272C215.2 272 208 264.8 208 256C208 247.2 215.2 240 224 240C232.8 240 240 247.2 240 256zM416 464C407.2 464 400 456.8 400 448C400 439.2 407.2 432 416 432C424.8 432 432 439.2 432 448C432 456.8 424.8 464 416 464zM416 80C407.2 80 400 72.84 400 64C400 55.16 407.2 48 416 48C424.8 48 432 55.16 432 64C432 72.84 424.8 80 416 80zM48 64C48 72.84 40.84 80 32 80C23.16 80 16 72.84 16 64C16 55.16 23.16 48 32 48C40.84 48 48 55.16 48 64zM416 272C407.2 272 400 264.8 400 256C400 247.2 407.2 240 416 240C424.8 240 432 247.2 432 256C432 264.8 424.8 272 416 272zM48 256C48 264.8 40.84 272 32 272C23.16 272 16 264.8 16 256C16 247.2 23.16 240 32 240C40.84 240 48 247.2 48 256zM224 368C215.2 368 208 360.8 208 352C208 343.2 215.2 336 224 336C232.8 336 240 343.2 240 352C240 360.8 232.8 368 224 368zM432 352C432 360.8 424.8 368 416 368C407.2 368 400 360.8 400 352C400 343.2 407.2 336 416 336C424.8 336 432 343.2 432 352zM32 368C23.16 368 16 360.8 16 352C16 343.2 23.16 336 32 336C40.84 336 48 343.2 48 352C48 360.8 40.84 368 32 368zM432 160C432 168.8 424.8 176 416 176C407.2 176 400 168.8 400 160C400 151.2 407.2 144 416 144C424.8 144 432 151.2 432 160zM32 176C23.16 176 16 168.8 16 160C16 151.2 23.16 144 32 144C40.84 144 48 151.2 48 160C48 168.8 40.84 176 32 176zM240 160C240 168.8 232.8 176 224 176C215.2 176 208 168.8 208 160C208 151.2 215.2 144 224 144C232.8 144 240 151.2 240 160z"],
    "border-outer": [448, 512, [], "f851", "M240 160C240 168.8 232.8 176 224 176C215.2 176 208 168.8 208 160C208 151.2 215.2 144 224 144C232.8 144 240 151.2 240 160zM112 256C112 247.2 119.2 240 128 240C136.8 240 144 247.2 144 256C144 264.8 136.8 272 128 272C119.2 272 112 264.8 112 256zM240 256C240 264.8 232.8 272 224 272C215.2 272 208 264.8 208 256C208 247.2 215.2 240 224 240C232.8 240 240 247.2 240 256zM304 256C304 247.2 311.2 240 320 240C328.8 240 336 247.2 336 256C336 264.8 328.8 272 320 272C311.2 272 304 264.8 304 256zM240 352C240 360.8 232.8 368 224 368C215.2 368 208 360.8 208 352C208 343.2 215.2 336 224 336C232.8 336 240 343.2 240 352zM0 96C0 60.65 28.65 32 64 32H384C419.3 32 448 60.65 448 96V416C448 451.3 419.3 480 384 480H64C28.65 480 0 451.3 0 416V96zM16 96V416C16 442.5 37.49 464 64 464H384C410.5 464 432 442.5 432 416V96C432 69.49 410.5 48 384 48H64C37.49 48 16 69.49 16 96z"],
    "border-right": [448, 512, [], "f852", "M440 32C444.4 32 448 35.58 448 40V472C448 476.4 444.4 480 440 480C435.6 480 432 476.4 432 472V40C432 35.58 435.6 32 440 32zM320 48C328.8 48 336 55.16 336 64C336 72.84 328.8 80 320 80C311.2 80 304 72.84 304 64C304 55.16 311.2 48 320 48zM304 448C304 439.2 311.2 432 320 432C328.8 432 336 439.2 336 448C336 456.8 328.8 464 320 464C311.2 464 304 456.8 304 448zM320 240C328.8 240 336 247.2 336 256C336 264.8 328.8 272 320 272C311.2 272 304 264.8 304 256C304 247.2 311.2 240 320 240zM112 64C112 55.16 119.2 48 128 48C136.8 48 144 55.16 144 64C144 72.84 136.8 80 128 80C119.2 80 112 72.84 112 64zM128 432C136.8 432 144 439.2 144 448C144 456.8 136.8 464 128 464C119.2 464 112 456.8 112 448C112 439.2 119.2 432 128 432zM112 256C112 247.2 119.2 240 128 240C136.8 240 144 247.2 144 256C144 264.8 136.8 272 128 272C119.2 272 112 264.8 112 256zM224 48C232.8 48 240 55.16 240 64C240 72.84 232.8 80 224 80C215.2 80 208 72.84 208 64C208 55.16 215.2 48 224 48zM208 448C208 439.2 215.2 432 224 432C232.8 432 240 439.2 240 448C240 456.8 232.8 464 224 464C215.2 464 208 456.8 208 448zM224 240C232.8 240 240 247.2 240 256C240 264.8 232.8 272 224 272C215.2 272 208 264.8 208 256C208 247.2 215.2 240 224 240zM16 64C16 55.16 23.16 48 32 48C40.84 48 48 55.16 48 64C48 72.84 40.84 80 32 80C23.16 80 16 72.84 16 64zM32 432C40.84 432 48 439.2 48 448C48 456.8 40.84 464 32 464C23.16 464 16 456.8 16 448C16 439.2 23.16 432 32 432zM16 256C16 247.2 23.16 240 32 240C40.84 240 48 247.2 48 256C48 264.8 40.84 272 32 272C23.16 272 16 264.8 16 256zM224 144C232.8 144 240 151.2 240 160C240 168.8 232.8 176 224 176C215.2 176 208 168.8 208 160C208 151.2 215.2 144 224 144zM16 160C16 151.2 23.16 144 32 144C40.84 144 48 151.2 48 160C48 168.8 40.84 176 32 176C23.16 176 16 168.8 16 160zM32 336C40.84 336 48 343.2 48 352C48 360.8 40.84 368 32 368C23.16 368 16 360.8 16 352C16 343.2 23.16 336 32 336zM208 352C208 343.2 215.2 336 224 336C232.8 336 240 343.2 240 352C240 360.8 232.8 368 224 368C215.2 368 208 360.8 208 352z"],
    "border-top": [448, 512, [], "f855", "M0 40C0 35.58 3.582 32 8 32H440C444.4 32 448 35.58 448 40C448 44.42 444.4 48 440 48H8C3.582 48 0 44.42 0 40zM16 160C16 151.2 23.16 144 32 144C40.84 144 48 151.2 48 160C48 168.8 40.84 176 32 176C23.16 176 16 168.8 16 160zM416 176C407.2 176 400 168.8 400 160C400 151.2 407.2 144 416 144C424.8 144 432 151.2 432 160C432 168.8 424.8 176 416 176zM208 160C208 151.2 215.2 144 224 144C232.8 144 240 151.2 240 160C240 168.8 232.8 176 224 176C215.2 176 208 168.8 208 160zM32 368C23.16 368 16 360.8 16 352C16 343.2 23.16 336 32 336C40.84 336 48 343.2 48 352C48 360.8 40.84 368 32 368zM400 352C400 343.2 407.2 336 416 336C424.8 336 432 343.2 432 352C432 360.8 424.8 368 416 368C407.2 368 400 360.8 400 352zM224 368C215.2 368 208 360.8 208 352C208 343.2 215.2 336 224 336C232.8 336 240 343.2 240 352C240 360.8 232.8 368 224 368zM16 256C16 247.2 23.16 240 32 240C40.84 240 48 247.2 48 256C48 264.8 40.84 272 32 272C23.16 272 16 264.8 16 256zM416 272C407.2 272 400 264.8 400 256C400 247.2 407.2 240 416 240C424.8 240 432 247.2 432 256C432 264.8 424.8 272 416 272zM208 256C208 247.2 215.2 240 224 240C232.8 240 240 247.2 240 256C240 264.8 232.8 272 224 272C215.2 272 208 264.8 208 256zM32 464C23.16 464 16 456.8 16 448C16 439.2 23.16 432 32 432C40.84 432 48 439.2 48 448C48 456.8 40.84 464 32 464zM400 448C400 439.2 407.2 432 416 432C424.8 432 432 439.2 432 448C432 456.8 424.8 464 416 464C407.2 464 400 456.8 400 448zM224 464C215.2 464 208 456.8 208 448C208 439.2 215.2 432 224 432C232.8 432 240 439.2 240 448C240 456.8 232.8 464 224 464zM112 256C112 247.2 119.2 240 128 240C136.8 240 144 247.2 144 256C144 264.8 136.8 272 128 272C119.2 272 112 264.8 112 256zM128 464C119.2 464 112 456.8 112 448C112 439.2 119.2 432 128 432C136.8 432 144 439.2 144 448C144 456.8 136.8 464 128 464zM304 448C304 439.2 311.2 432 320 432C328.8 432 336 439.2 336 448C336 456.8 328.8 464 320 464C311.2 464 304 456.8 304 448zM320 272C311.2 272 304 264.8 304 256C304 247.2 311.2 240 320 240C328.8 240 336 247.2 336 256C336 264.8 328.8 272 320 272z"],
    "border-top-left": [448, 512, ["border-style"], "f853", "M0 88C0 57.07 25.07 32 56 32H424C428.4 32 432 35.58 432 40C432 44.42 428.4 48 424 48H56C33.91 48 16 65.91 16 88V456C16 460.4 12.42 464 8 464C3.582 464 0 460.4 0 456V88zM144 448C144 456.8 136.8 464 128 464C119.2 464 112 456.8 112 448C112 439.2 119.2 432 128 432C136.8 432 144 439.2 144 448zM336 448C336 456.8 328.8 464 320 464C311.2 464 304 456.8 304 448C304 439.2 311.2 432 320 432C328.8 432 336 439.2 336 448zM224 464C215.2 464 208 456.8 208 448C208 439.2 215.2 432 224 432C232.8 432 240 439.2 240 448C240 456.8 232.8 464 224 464zM432 448C432 456.8 424.8 464 416 464C407.2 464 400 456.8 400 448C400 439.2 407.2 432 416 432C424.8 432 432 439.2 432 448zM416 272C407.2 272 400 264.8 400 256C400 247.2 407.2 240 416 240C424.8 240 432 247.2 432 256C432 264.8 424.8 272 416 272zM432 352C432 360.8 424.8 368 416 368C407.2 368 400 360.8 400 352C400 343.2 407.2 336 416 336C424.8 336 432 343.2 432 352zM416 176C407.2 176 400 168.8 400 160C400 151.2 407.2 144 416 144C424.8 144 432 151.2 432 160C432 168.8 424.8 176 416 176z"],
    "bore-hole": [512, 512, [], "e4c3", "M264 272.5C295.6 276.4 320 303.4 320 336C320 371.3 291.3 400 256 400C220.7 400 192 371.3 192 336C192 303.4 216.4 276.4 248 272.5V8C248 3.582 251.6 0 256 0C260.4 0 264 3.582 264 8V272.5zM256 384C282.5 384 304 362.5 304 336C304 309.5 282.5 288 256 288C229.5 288 208 309.5 208 336C208 362.5 229.5 384 256 384zM160 128V336C160 389 202.1 432 256 432C309 432 352 389 352 336V128H448C483.3 128 512 156.7 512 192V448C512 483.3 483.3 512 448 512H64C28.65 512 0 483.3 0 448V192C0 156.7 28.65 128 64 128H160zM448 144H368V336C368 397.9 317.9 448 256 448C194.1 448 144 397.9 144 336V144H64C37.49 144 16 165.5 16 192V448C16 474.5 37.49 496 64 496H448C474.5 496 496 474.5 496 448V192C496 165.5 474.5 144 448 144z"],
    "bottle-droplet": [320, 512, [], "e4c4", "M96 336.1C96 306.1 130.7 263.8 148.1 243.6C152.3 239.1 155 237.1 156.1 235.1C158.9 233.1 159.1 232 159.1 232C159.1 232 161.1 233.1 163 235.1C164.1 237.1 167.7 239.1 171 243.6C189.3 263.8 224 306.1 224 336.1C224 379 195.3 400 159.1 400C124.7 400 95.1 371.8 95.1 336.1H96zM199.7 310.1C194.3 299.5 186.9 288.5 179.3 278.4C172.4 269.4 165.5 261.4 160 255.3C154.5 261.4 147.6 269.4 140.7 278.4C133.1 288.5 125.7 299.5 120.3 310.1C114.7 321 112 330.2 112 336.1C112 362.7 133.3 384 160 384C174.6 384 186.5 379.7 194.5 372.4C202.3 365.3 208 354.1 208 336.1C208 330.2 205.3 321 199.7 310.1V310.1zM88 8.004C88 3.586 91.58 .0042 95.1 .0038L224 0C228.4 0 232 3.581 232 7.1C232 12.42 228.4 15.1 224 16L216 16V140.9C258.6 161.6 288 205.4 288 256V448C288 483.3 259.3 512 224 512H96C60.65 512 32 483.3 32 448V256C32 205.4 61.37 161.6 104 140.9V16L96 16C91.58 16 88 12.42 88 8.004V8.004zM200 16L120 16V150.9L111 155.3C73.67 173.4 48 211.7 48 256V448C48 474.5 69.49 496 96 496H224C250.5 496 272 474.5 272 448V256C272 211.7 246.3 173.4 208.1 155.3L200 150.9V16z"],
    "bottle-water": [320, 512, [], "e4c5", "M96 216C96 211.6 99.58 208 104 208H216C220.4 208 224 211.6 224 216C224 220.4 220.4 224 216 224H104C99.58 224 96 220.4 96 216zM216 368C220.4 368 224 371.6 224 376C224 380.4 220.4 384 216 384H104C99.58 384 96 380.4 96 376C96 371.6 99.58 368 104 368H216zM200 .0003C217.7 .0003 232 14.33 232 32V94.9C233.3 95.42 234.5 95.98 235.8 96.57L248.9 102.7C272.8 113.9 288 137.8 288 164.2C288 182.3 280.9 198.7 269.4 210.9C280.9 222.4 288 238.4 288 256C288 275.1 279.6 292.3 266.3 304C279.6 315.7 288 332.9 288 352C288 371.1 279.6 388.3 266.3 400C279.6 411.7 288 428.9 288 448C288 483.3 259.3 512 224 512H96C60.65 512 32 483.3 32 448C32 428.9 40.39 411.7 53.67 400C40.39 388.3 32 371.1 32 352C32 332.9 40.39 315.7 53.67 304C40.39 292.3 32 275.1 32 256C32 238.4 39.13 222.4 50.63 210.9C39.09 198.7 32 182.3 32 164.2C32 137.8 47.22 113.9 71.05 102.7L84.21 96.57C85.46 95.98 86.72 95.42 88 94.9V32C88 14.33 102.3 0 120 0L200 .0003zM197.3 104H122.7C111.7 104 100.9 106.4 90.99 111.1L77.84 117.2C59.63 125.8 48 144 48 164.2C48 180.6 55.65 195.3 67.61 204.8C69.55 206.3 70.67 208.7 70.63 211.2C70.59 213.6 69.39 215.1 67.4 217.4C55.61 226.2 48 240.2 48 256C48 273.5 57.31 288.7 71.27 297.1C73.67 298.6 75.14 301.2 75.14 304C75.14 306.8 73.67 309.4 71.27 310.9C57.31 319.3 48 334.6 48 352C48 369.5 57.31 384.7 71.27 393.1C73.67 394.6 75.14 397.2 75.14 400C75.14 402.8 73.67 405.4 71.27 406.9C57.31 415.3 48 430.6 48 448C48 474.5 69.49 496 96 496H224C250.5 496 272 474.5 272 448C272 430.6 262.7 415.3 248.7 406.9C246.3 405.4 244.9 402.8 244.9 400C244.9 397.2 246.3 394.6 248.7 393.1C262.7 384.7 272 369.5 272 352C272 334.6 262.7 319.3 248.7 310.9C246.3 309.4 244.9 306.8 244.9 304C244.9 301.2 246.3 298.6 248.7 297.1C262.7 288.7 272 273.5 272 256C272 240.2 264.4 226.2 252.6 217.4C250.6 215.1 249.4 213.6 249.4 211.2C249.3 208.7 250.4 206.3 252.4 204.8C264.4 195.3 272 180.6 272 164.2C272 144 260.4 125.8 242.2 117.2L229 111.1C219.1 106.4 208.3 104 197.3 104V104zM216 88V32C216 23.16 208.8 16 200 16H120C111.2 16 104 23.16 104 32V88H216z"],
    "bow-arrow": [512, 512, [127993], "f6b9", "M404.4 187.8c-2.297-3.765-7.25-4.906-11.02-2.64c-3.766 2.312-4.937 7.234-2.641 11.02c54.86 89.46 41.26 203.9-33.06 278.2c-.0117 .0117 .0117-.0117 0 0l-120.1-120c-3.125-3.125-8.187-3.125-11.31 0c-3.125 3.125-3.125 8.187 0 11.31l143.1 143.1C371.9 511.2 373.1 512 375.1 512c2.047 0 4.094-.7812 5.656-2.344c3.125-3.125 3.125-8.187 0-11.31l-12.65-12.68c.0117-.0117-.0117 .0117 0 0C448.6 406.1 463.1 283.6 404.4 187.8zM146.3 285.7C147.9 287.2 149.1 288 151.1 288s4.094-.7812 5.656-2.344c3.125-3.125 3.125-8.187 0-11.31L37.63 154.3c.0117-.0117-.0117 .0117 0 0c74.31-74.29 188.7-87.93 278.2-33.05c3.734 2.281 8.656 1.109 11.02-2.64c2.297-3.781 1.125-8.703-2.641-11.02c-95.83-58.7-218.3-44.16-297.9 35.41c-.0117 .0117 .0117-.0117 0 0l-12.68-12.65c-3.125-3.125-8.187-3.125-11.31 0c-3.125 3.125-3.125 8.187 0 11.31L146.3 285.7zM509.7 2.37c-1.891-1.891-4.641-2.781-7.219-2.187l-143.1 28.8c-6.162 1.225-8.689 8.939-4.094 13.5l51.94 51.94l-240.1 240.1l-83.87-15.25c-.4687-.0781-.9687-.125-1.437-.125c-2.094 0-4.156 .8281-5.656 2.344l-71.1 71.1c-1.1 1.984-2.781 4.875-2.094 7.609c.6875 2.734 2.75 4.906 5.437 5.703l75.87 22.76l22.78 75.87c.8125 2.703 2.969 4.765 5.687 5.453c2.75 .7031 5.625-.1093 7.625-2.094l71.1-71.1c1.844-1.859 2.687-4.5 2.219-7.093L176.6 346.7l240.1-240.1l51.95 51.94c4.289 4.289 12.19 2.5 13.5-4.094l28.8-143.1C512.4 6.979 511.5 4.26 509.7 2.37zM23.12 396.2l59.56-59.56l68.86 12.51l-65.83 65.83L23.12 396.2zM115.8 488.9l-18.78-62.59l65.83-65.83l12.51 68.86L115.8 488.9zM470.3 135.8L376.2 41.73l117.6-23.5L470.3 135.8z"],
    "bowl-chopsticks": [512, 512, [], "e2e9", "M479.1 223.1H32c-17.62 0-31.1 14.56-31.1 32.19c0 94.75 51.51 176.9 128 221.3l-.0033 2.501C128 497.7 142.3 512 160 512h191.1c17.67 0 31.1-14.33 31.1-32l-.0033-2.501c76.5-44.38 128-126.6 128-221.3C511.1 238.6 497.6 223.1 479.1 223.1zM375.1 463.7c-4.934 2.861-7.971 8.135-7.971 13.84V480c0 8.822-7.178 16-16 16H160c-8.822 0-16-7.178-16-16v-2.5c0-5.705-3.037-10.98-7.971-13.84C62 420.7 16.01 341.1 16.01 256c0-8.822 7.178-16 16-16h447.1c8.822 0 16 7.178 16 16C495.1 341.1 449.1 420.7 375.1 463.7zM8.014 120c.5313 0 1.094-.0469 1.656-.1719l495.1-104c4.312-.9062 7.094-5.143 6.188-9.471c-.9375-4.297-4.969-7.158-9.498-6.188L6.359 104.2C2.047 105.1-.7344 109.3 .1719 113.7C.9844 117.4 4.297 120 8.014 120zM8.014 168c.1562 0 .3438 0 .5-.0156l495.1-32.01c4.436-.2813 7.779-4.096 7.467-8.502c-.2813-4.391-4.031-7.861-8.467-7.471L7.514 152c-4.436 .2813-7.779 4.096-7.467 8.502C.2969 164.7 3.828 168 8.014 168z"],
    "bowl-chopsticks-noodles": [512, 512, [], "e2ea", "M511.1 127.5c-.2813-4.391-4.031-7.861-8.467-7.471L192 140.1v16.04l312.5-20.17C508.9 135.7 512.3 131.9 511.1 127.5zM511.8 6.377c-.9375-4.297-4.969-7.158-9.498-6.188L192 65.27v16.35l313.6-65.78C509.1 14.94 512.7 10.71 511.8 6.377zM479.1 223.1L176 224V32c0-4.422-3.594-8-8-8S160 27.58 160 32v39.98L128 78.7v16.35l32-6.711v53.83L128 144.2v16.04l32-2.064V224H112V64c0-4.422-3.594-8-8-8S96 59.58 96 64v21.41L6.359 104.2C2.047 105.1-.7344 109.3 .1719 113.7C.9844 117.4 4.297 120 8.014 120c.5313 0 1.094-.0469 1.656-.1719L96 101.8v44.54L7.514 152c-4.436 .2813-7.779 4.096-7.467 8.502C.2969 164.7 3.828 168 8.014 168c.1562 0 .3438 0 .5-.0156L96 162.3V224L32 223.1c-17.62 0-31.1 14.56-31.1 32.19c0 94.75 51.51 176.9 128 221.3l-.0035 2.501C128 497.7 142.3 512 160 512h191.1c17.67 0 31.1-14.33 31.1-32l-.0035-2.501c76.5-44.38 128-126.6 128-221.3C511.1 238.6 497.6 223.1 479.1 223.1zM375.1 463.7c-4.934 2.861-7.971 8.135-7.971 13.84V480c0 8.822-7.178 16-16 16H160c-8.822 0-16-7.178-16-16v-2.5c0-5.705-3.037-10.98-7.971-13.84C62 420.7 16.01 341.1 16.01 256c0-8.822 7.178-16 16-16h447.1c8.822 0 16 7.178 16 16C495.1 341.1 449.1 420.7 375.1 463.7z"],
    "bowl-food": [576, 512, [], "e4c6", "M220.1 94.47L212.8 90.12C202.1 83.69 189.5 80 176 80C141.2 80 112.1 104.7 105.4 137.6L104.1 144.2L97.4 144C96.94 144 96.47 143.1 95.1 143.1C65.07 143.1 39.1 169.1 39.1 199.1C39.1 207.4 41.45 214.5 44.07 220.1C45.73 225.1 43.75 229.8 39.65 231.4C35.56 233.1 30.89 231.1 29.24 227C25.86 218.7 23.1 209.5 23.1 200C23.1 161.8 53.71 130.6 91.27 128.2C101.7 91.14 135.7 64 175.1 64C189.5 64 202.4 67.07 213.9 72.55C229.5 48.17 256.9 32 287.1 32C319.1 32 346.5 48.17 362.1 72.55C373.6 67.07 386.5 64 400 64C440.3 64 474.3 91.14 484.7 128.2C522.3 130.6 552 161.8 552 200C552 209.5 550.1 218.7 546.8 227C545.1 231.1 540.4 233.1 536.3 231.4C532.2 229.8 530.3 225.1 531.9 220.1C534.6 214.5 536 207.4 536 199.1C536 169.1 510.9 143.1 480 143.1C479.5 143.1 479.1 144 478.6 144L471.9 144.2L470.6 137.6C463.9 104.7 434.8 80 400 80C386.5 80 373.9 83.69 363.2 90.12L355.9 94.47L351.1 86.93C339.1 63.78 315.8 48 287.1 48C260.2 48 236 63.78 224 86.93L220.1 94.47zM532.6 256C547.7 256 560 268.3 560 283.4C560 356.3 512.6 418.2 446.9 439.8C447.6 442.4 448 445.2 448 448C448 465.7 433.7 480 416 480H160C142.3 480 128 465.7 128 448C128 445.2 128.4 442.4 129.1 439.8C63.4 418.2 16 356.3 16 283.4C16 268.3 28.28 256 43.43 256H532.6zM144 448C144 456.8 151.2 464 160 464H416C424.8 464 432 456.8 432 448C432 446.6 431.8 445.2 431.5 443.9C429.3 435.7 433.9 427.2 441.9 424.6C501.2 405.1 544 349.2 544 283.4C544 277.1 538.9 272 532.6 272H43.43C37.12 272 32 277.1 32 283.4C32 349.2 74.77 405.1 134.1 424.6C142.1 427.2 146.7 435.7 144.5 443.9C144.2 445.2 144 446.6 144 448L144 448z"],
    "bowl-hot": [512, 512, ["soup"], "f823", "M296.2 91.72l8.438 4.219C323.1 105.6 336 125 336 146.7V152C336 156.4 339.6 160 344 160S352 156.4 352 152V146.7c0-27.73-15.41-52.67-40.2-65.05l-8.438-4.219C284 67.73 272 48.3 272 26.67V8c0-4.422-3.578-7.895-8-7.895S256 3.578 256 8v18.67C256 54.39 271.4 79.31 296.2 91.72zM168.2 91.72l8.438 4.219C195.1 105.6 208 125 208 146.7V152c0 4.422 3.578 7.895 8 7.895S224 156.4 224 152V146.7c0-27.73-15.41-52.67-40.2-65.05L175.4 77.41C156 67.73 144 48.3 144 26.67V8C144 3.578 140.4 0 136 0S128 3.578 128 8v18.67C128 54.39 143.4 79.31 168.2 91.72zM480 192H32c-17.62 0-32 14.37-32 31.1c0 94.75 51.5 177.1 128 221.5v34.5c0 17.62 14.38 31.1 32 31.1h192c17.62 0 32-14.37 32-31.1v-34.5c76.5-44.38 128-126.7 128-221.5C512 206.4 497.6 192 480 192zM375.1 431.7L368 436.3V480c0 8.822-7.178 16-16 16H160c-8.822 0-16-7.178-16-16v-43.71l-7.971-4.625C61.99 388.7 16 309.1 16 224c0-8.822 7.178-15.1 16-15.1h448c8.822 0 16 7.176 16 15.1C496 309.1 450 388.7 375.1 431.7z"],
    "bowl-rice": [576, 512, [], "e2eb", "M256 72C269.3 72 280 82.75 280 96C280 109.3 269.3 120 256 120H224C210.7 120 200 109.3 200 96C200 82.75 210.7 72 224 72H256zM256 88H224C219.6 88 216 91.58 216 96C216 100.4 219.6 104 224 104H256C260.4 104 264 100.4 264 96C264 91.58 260.4 88 256 88zM160 144C173.3 144 184 154.7 184 168C184 181.3 173.3 192 160 192H128C114.7 192 104 181.3 104 168C104 154.7 114.7 144 128 144H160zM160 160H128C123.6 160 120 163.6 120 168C120 172.4 123.6 176 128 176H160C164.4 176 168 172.4 168 168C168 163.6 164.4 160 160 160zM64 216C77.25 216 88 226.7 88 240C88 253.3 77.25 264 64 264H32C18.75 264 8 253.3 8 240C8 226.7 18.75 216 32 216H64zM32 232C27.58 232 24 235.6 24 240C24 244.4 27.58 248 32 248H64C68.42 248 72 244.4 72 240C72 235.6 68.42 232 64 232H32zM256 216C269.3 216 280 226.7 280 240C280 253.3 269.3 264 256 264H224C210.7 264 200 253.3 200 240C200 226.7 210.7 216 224 216H256zM224 232C219.6 232 216 235.6 216 240C216 244.4 219.6 248 224 248H256C260.4 248 264 244.4 264 240C264 235.6 260.4 232 256 232H224zM448 216C461.3 216 472 226.7 472 240C472 253.3 461.3 264 448 264H416C402.7 264 392 253.3 392 240C392 226.7 402.7 216 416 216H448zM448 232H416C411.6 232 408 235.6 408 240C408 244.4 411.6 248 416 248H448C452.4 248 456 244.4 456 240C456 235.6 452.4 232 448 232zM544 216C557.3 216 568 226.7 568 240C568 253.3 557.3 264 544 264H512C498.7 264 488 253.3 488 240C488 226.7 498.7 216 512 216H544zM512 232C507.6 232 504 235.6 504 240C504 244.4 507.6 248 512 248H544C548.4 248 552 244.4 552 240C552 235.6 548.4 232 544 232H512zM352 216C365.3 216 376 226.7 376 240C376 253.3 365.3 264 352 264H320C306.7 264 296 253.3 296 240C296 226.7 306.7 216 320 216H352zM352 232H320C315.6 232 312 235.6 312 240C312 244.4 315.6 248 320 248H352C356.4 248 360 244.4 360 240C360 235.6 356.4 232 352 232zM160 216C173.3 216 184 226.7 184 240C184 253.3 173.3 264 160 264H128C114.7 264 104 253.3 104 240C104 226.7 114.7 216 128 216H160zM128 232C123.6 232 120 235.6 120 240C120 244.4 123.6 248 128 248H160C164.4 248 168 244.4 168 240C168 235.6 164.4 232 160 232H128zM352 144C365.3 144 376 154.7 376 168C376 181.3 365.3 192 352 192H320C306.7 192 296 181.3 296 168C296 154.7 306.7 144 320 144H352zM320 160C315.6 160 312 163.6 312 168C312 172.4 315.6 176 320 176H352C356.4 176 360 172.4 360 168C360 163.6 356.4 160 352 160H320zM448 144C461.3 144 472 154.7 472 168C472 181.3 461.3 192 448 192H416C402.7 192 392 181.3 392 168C392 154.7 402.7 144 416 144H448zM448 160H416C411.6 160 408 163.6 408 168C408 172.4 411.6 176 416 176H448C452.4 176 456 172.4 456 168C456 163.6 452.4 160 448 160zM256 144C269.3 144 280 154.7 280 168C280 181.3 269.3 192 256 192H224C210.7 192 200 181.3 200 168C200 154.7 210.7 144 224 144H256zM224 160C219.6 160 216 163.6 216 168C216 172.4 219.6 176 224 176H256C260.4 176 264 172.4 264 168C264 163.6 260.4 160 256 160H224zM352 72C365.3 72 376 82.75 376 96C376 109.3 365.3 120 352 120H320C306.7 120 296 109.3 296 96C296 82.75 306.7 72 320 72H352zM320 88C315.6 88 312 91.58 312 96C312 100.4 315.6 104 320 104H352C356.4 104 360 100.4 360 96C360 91.58 356.4 88 352 88H320zM532.6 288C547.7 288 560 300.3 560 315.4C560 388.3 512.6 450.2 446.9 471.8C447.6 474.4 448 477.2 448 480C448 497.7 433.7 512 416 512H160C142.3 512 128 497.7 128 480C128 477.2 128.4 474.4 129.1 471.8C63.4 450.2 16 388.3 16 315.4C16 300.3 28.28 288 43.43 288H532.6zM144 480C144 488.8 151.2 496 160 496H416C424.8 496 432 488.8 432 480C432 478.6 431.8 477.2 431.5 475.9C429.3 467.7 433.9 459.2 441.9 456.6C501.2 437.1 544 381.2 544 315.4C544 309.1 538.9 304 532.6 304H43.43C37.12 304 32 309.1 32 315.4C32 381.2 74.77 437.1 134.1 456.6C142.1 459.2 146.7 467.7 144.5 475.9C144.2 477.2 144 478.6 144 480L144 480z"],
    "bowl-scoop": [448, 512, [127847, "bowl-shaved-ice"], "e3de", "M34.34 229.7C32.84 228.2 31.1 226.1 31.1 224C31.1 173.1 52.23 124.2 88.23 88.24C124.2 52.23 173.1 32 223.1 32C274.9 32 323.8 52.23 359.8 88.24C395.8 124.2 415.1 173.1 415.1 224C415.1 226.1 415.2 228.2 413.7 229.7C412.2 231.2 410.1 232 407.1 232C405.9 232 403.8 231.2 402.3 229.7C400.8 228.2 399.1 226.1 399.1 224C399.1 177.3 381.5 132.6 348.4 99.55C315.4 66.54 270.7 48 223.1 48C177.3 48 132.6 66.54 99.55 99.55C66.54 132.6 47.1 177.3 47.1 224C47.1 226.1 47.15 228.2 45.65 229.7C44.15 231.2 42.12 232 39.1 232C37.88 232 35.84 231.2 34.34 229.7zM395.1 375.6C365.6 401.7 327.6 416.1 288.3 416L348.4 485.3C350.5 487.6 351.8 490.4 352.3 493.5C352.8 496.6 352.4 499.7 351.1 502.5C349.8 505.4 347.8 507.8 345.2 509.4C342.6 511.1 339.5 512 336.4 512H111.5C108.4 512 105.4 511.1 102.8 509.4C100.2 507.8 98.15 505.4 96.88 502.5C95.62 499.7 95.2 496.6 95.69 493.5C96.17 490.4 97.54 487.6 99.61 485.3L159.7 416C120.4 416.1 82.36 401.7 52.91 375.6C23.45 349.5 4.622 313.5-.0021 274.4C-.3113 272.1-.1292 269.8 .5316 267.6C1.193 265.4 2.318 263.3 3.831 261.6C5.345 259.9 7.213 258.5 9.311 257.5C11.41 256.5 13.69 256 15.1 256H431.1C434.3 256 436.6 256.5 438.7 257.5C440.8 258.5 442.6 259.9 444.2 261.6C445.7 263.3 446.8 265.4 447.5 267.6C448.1 269.8 448.3 272.1 447.1 274.4C443.4 313.5 424.5 349.5 395.1 375.6zM267.1 416H180.9L111.7 496H336.5L267.1 416zM384.4 363.7C410.9 340.2 427.8 307.8 431.1 272.6V272H15.1C20.01 307.3 36.88 339.8 63.38 363.4C89.89 387.1 124.2 400.1 159.7 400H288.3C323.7 400.1 357.9 387.2 384.4 363.7z"],
    "bowl-scoops": [448, 512, [127813], "e3df", "M4.763 223.3C3.753 222.9 2.844 222.2 2.096 221.4C1.347 220.6 .775 219.7 .4147 218.6C.0544 217.6-.0861 216.5 .0022 215.4C1.939 187.8 12.73 161.6 30.77 140.7C48.81 119.7 73.12 105.2 100.1 99.2C106.4 71.04 122.1 45.88 144.6 27.84C167.2 9.811 195.2-.0156 224-.0156C252.9-.0156 280.8 9.811 303.4 27.84C325.9 45.88 341.6 71.04 347.9 99.2C374.9 105.2 399.2 119.7 417.2 140.7C435.3 161.6 446.1 187.8 448 215.4C448.1 216.4 447.9 217.5 447.6 218.5C447.2 219.5 446.7 220.4 445.1 221.2C445.3 221.9 444.5 222.6 443.5 223C442.6 223.5 441.5 223.8 440.5 223.8C439.4 223.9 438.4 223.8 437.4 223.4C436.4 223.1 435.5 222.5 434.7 221.8C433.9 221.1 433.3 220.3 432.8 219.3C432.3 218.4 432.1 217.4 432 216.3C430 187.1 417.4 161.5 396.6 142.1C375.8 122.7 348.5 111.1 320.1 111.1C291.7 111.1 264.4 122.7 243.6 142.1C222.8 161.5 210.2 187.1 208.2 216.3C208.1 218.4 207.2 220.3 205.7 221.7C204.2 223.2 202.3 223.1 200.2 223.1C199.1 223.1 198 223.8 196.1 223.3C195.1 222.9 195.1 222.2 194.3 221.4C193.6 220.6 193 219.6 192.7 218.6C192.3 217.5 192.2 216.4 192.3 215.3C193.8 193.1 201.1 171.6 213.5 153.1C199.4 135.7 180.4 122.1 158.9 116.6C137.4 110.2 114.5 110.5 93.19 117.3C71.86 124.1 53.08 137.2 39.31 154.9C25.54 172.6 17.42 193.1 16 216.3C15.89 218.4 14.1 220.3 13.5 221.7C12.01 223.2 10.03 223.1 7.97 223.1C6.866 223.1 5.774 223.8 4.763 223.3zM156.8 38.64C137.5 53.28 123.4 73.82 116.7 97.15C120.5 96.8 124.2 95.1 128 95.1C146.3 96.07 164.3 100.1 180.8 107.7C197.4 115.4 212.1 126.5 224 140.4C235.9 126.5 250.6 115.4 267.2 107.7C283.7 100.1 301.8 96.09 320 95.1C323.1 95.1 327.6 96.8 331.4 97.15C324.7 73.8 310.7 53.25 291.3 38.6C271.9 23.96 248.3 16.03 224 15.1C199.7 16.06 176.2 24 156.8 38.64zM437.8 257.5C439.9 258.5 441.7 259.9 443.2 261.6C444.7 263.4 445.9 265.4 446.5 267.6C447.2 269.8 447.4 272.2 447 274.4C442.5 313.4 423.8 349.4 394.5 375.5C365.2 401.6 327.3 416 288 416L347.9 485.3C349.1 487.6 351.3 490.4 351.8 493.5C352.3 496.5 351.9 499.7 350.6 502.5C349.4 505.3 347.3 507.7 344.7 509.4C342.1 511.1 339.1 512 336 512H112C108.9 512 105.9 511.1 103.3 509.4C100.7 507.7 98.62 505.3 97.36 502.5C96.1 499.7 95.69 496.5 96.17 493.5C96.66 490.4 98.02 487.6 100.1 485.3L160 416C120.7 416 82.8 401.6 53.46 375.5C24.11 349.4 5.391 313.4 .8665 274.4C.5574 272.1 .7395 269.8 1.4 267.6C2.061 265.4 3.186 263.3 4.7 261.6C6.214 259.9 8.082 258.5 10.18 257.5C12.28 256.5 14.56 256 16.87 255.1H431.1C433.4 256 435.7 256.5 437.8 257.5L437.8 257.5zM266.9 416H181.1L112 496H336L266.9 416zM383.9 363.6C410.4 340.1 427.2 307.7 431.3 272.6V271.1H16.77C20.71 307.2 37.5 339.8 63.92 363.4C90.35 386.1 124.6 400 160 400H288C323.4 400.1 357.5 387.1 383.9 363.6z"],
    "bowl-soft-serve": [512, 512, [], "e46b", "M282 0C347.2 0 400 52.83 400 118C400 130.3 397 141.8 391.7 152H404C445.1 152 480 186 480 228C480 269.1 445.1 304 404 304H108C66.03 304 32 269.1 32 228C32 186 66.03 152 108 152H116.7C113.7 144.6 112 136.5 112 128C112 92.65 140.7 64 176 64H249.3C261.8 64 272 53.84 272 41.3C272 36.81 270.7 32.43 268.2 28.7L257.3 12.44C255.7 9.983 255.6 6.827 256.9 4.225C258.3 1.624 261 0 264 0L282 0zM288 41.3C288 62.67 270.7 80 249.3 80H176C149.5 80 128 101.5 128 128C128 136.8 130.3 144.9 134.4 152H168C172.4 152 176 155.6 176 160C176 164.4 172.4 168 168 168H108C74.86 168 48 194.9 48 228C48 261.1 74.86 288 108 288H404C437.1 288 464 261.1 464 228C464 194.9 437.1 168 404 168H296C291.6 168 288 164.4 288 160C288 155.6 291.6 152 296 152H372.1C379.9 142.4 384 130.7 384 118C384 61.67 338.3 16 282 16H278.9L281.5 19.83C285.7 26.19 288 33.66 288 41.3V41.3zM64 352C64 396.2 99.82 432 144 432H200C202.8 432 205.3 433.4 206.8 435.8C208.3 438.2 208.4 441.1 207.2 443.6L180.9 496H331.1L304.8 443.6C303.6 441.1 303.7 438.2 305.2 435.8C306.7 433.4 309.2 432 312 432H368C412.2 432 448 396.2 448 352V336C448 331.6 451.6 328 456 328C460.4 328 464 331.6 464 336V352C464 405 421 448 368 448H324.9L351.2 500.4C352.4 502.9 352.3 505.8 350.8 508.2C349.3 510.6 346.8 512 344 512H167.1C165.2 512 162.7 510.6 161.2 508.2C159.7 505.8 159.6 502.9 160.8 500.4L187.1 448H144C90.98 448 48 405 48 352V336C48 331.6 51.58 328 56 328C60.42 328 64 331.6 64 336V352z"],
    "bowl-spoon": [512, 512, [129379], "e3e0", "M168 96c0 11.12-2.562 20.31-7.656 27.31C157.8 126.9 158.5 131.9 162.1 134.5c1.406 1.031 3.062 1.531 4.688 1.531c2.469 0 4.906-1.141 6.469-3.297C180.4 122.9 184 110.6 184 96c0-14.59-3.594-26.94-10.72-36.72C170.7 55.7 165.7 54.91 162.1 57.52C158.5 60.11 157.8 65.11 160.3 68.69C165.4 75.67 168 84.86 168 96zM479.1 223.1H32c-17.62 0-32 14.39-32 32.19c0 95.69 51.5 179 127.1 223.8c0 17.67 14.33 32 32 32h191.1c17.67 0 32-14.33 32-32c76.5-44.81 127.1-128.1 127.1-223.8C511.1 238.4 497.6 223.1 479.1 223.1zM375.9 466.2C371 469.1 367.1 474.3 367.1 480c0 8.822-7.178 16-16 16H160c-8.822 0-16-7.178-16-16c0-5.682-3.012-10.94-7.912-13.81c-74.07-43.39-120.1-123.9-120.1-210c0-8.928 7.178-16.19 16-16.19h447.1c8.822 0 16 7.262 16 16.19C495.1 342.3 449.1 422.8 375.9 466.2zM127 192c54.79 0 82.87-28.29 92.67-64H480c17.69 0 32-14.33 32-32s-14.31-32-32-32H219.7c-9.793-35.71-37.88-64-92.67-64C56.88 0 0 44.45 0 96S56.88 192 127 192zM127 16c41.16 0 67.87 18.06 77.24 52.23L207.5 80H480c8.822 0 16 7.178 16 16S488.8 112 480 112H207.5L204.3 123.8C194.9 157.9 168.2 176 127 176C66.85 176 16 139.4 16 96C16 52.63 66.85 16 127 16z"],
    "bowling-ball": [512, 512, [], "f436", "M143.9 136c-22.09 0-40 17.91-40 40s17.91 40 40 40s40-17.91 40-40S166 136 143.9 136zM143.1 200c-13.23 0-24-10.77-24-24s10.77-24 24-24c13.23 0 24 10.77 24 24S157.2 200 143.1 200zM239.9 168c-22.09 0-40 17.91-40 40s17.91 40 40 40s40-17.91 40-40S262 168 239.9 168zM239.1 232c-13.23 0-24-10.77-24-24s10.77-24 24-24c13.23 0 24 10.77 24 24S253.2 232 239.1 232zM239.9 72c-22.09 0-40 17.91-40 40s17.91 40 40 40s40-17.91 40-40S262 72 239.9 72zM239.1 136c-13.23 0-24-10.77-24-24s10.77-24 24-24c13.23 0 24 10.77 24 24S253.2 136 239.1 136zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "bowling-ball-pin": [576, 512, [], "e0c3", "M208 96C93.13 96 0 189.1 0 304S93.13 512 208 512S416 418.9 416 304S322.9 96 208 96zM208 496c-105.9 0-192-86.13-192-192s86.13-192 192-192s192 86.13 192 192S313.9 496 208 496zM520 176C520 144 544 120 544 72.05c0-47.1-32.08-71.99-64.08-72.05C447.1-.0001 416 24.12 416 72.05c0 47.99 24 71.99 24 103.1c0 14.51-3.117 29.02-7.568 43.53c3.105 8.246 5.744 16.7 7.938 25.35c7.525-19.9 13.57-40.16 14.85-60.88h49.56c2.016 32.48 15.23 63.95 28.56 94.4C547.1 309.8 560 339.4 560 368c0 48.6-19.81 86.99-35.72 117.8l-.7969 1.547C520.7 492.7 515.3 496 509.3 496h-58.51c-5.996 0-11.42-3.281-14.8-9.789c-8.348-16.09-17.7-34.3-24.81-54.88c-3.463 5.512-7.153 10.85-11.04 16.04c7.037 17.9 15.21 33.8 22.28 47.43C427.9 505.4 438.8 512 450.8 512h58.51c11.1 0 22.9-6.609 28.4-17.27C553.7 463.6 576 421.4 576 368C576 304 520 240 520 176zM504.6 168h-49.24c-1.4-13.99-5.965-26.66-10.61-38.88C438.5 112.6 432 95.54 432 72.05C432 33.33 456 16 479.9 16C503.8 16.05 528 33.39 528 72.05c0 23.48-6.492 40.57-12.77 57.1C510.6 141.4 506 154 504.6 168zM122.7 184C103.5 184 88 199.5 88 218.7s15.55 34.69 34.67 34.69c19.11 0 34.66-15.56 34.66-34.69S141.8 184 122.7 184zM122.7 237.3C112.4 237.3 104 228.1 104 218.7C104 208.4 112.4 200 122.7 200c10.28 0 18.66 8.375 18.66 18.66C141.3 228.1 132.1 237.3 122.7 237.3zM197.3 226.7c-19.11 0-34.66 15.56-34.66 34.69S178.2 296 197.3 296C216.5 296 232 280.5 232 261.3S216.5 226.7 197.3 226.7zM197.3 280c-10.28 0-18.66-8.375-18.66-18.66c0-10.31 8.375-18.69 18.66-18.69C207.6 242.7 216 251 216 261.3C216 271.6 207.6 280 197.3 280zM197.3 138.7c-19.11 0-34.66 15.56-34.66 34.69S178.2 208 197.3 208C216.5 208 232 192.5 232 173.3S216.5 138.7 197.3 138.7zM197.3 192C187 192 178.7 183.6 178.7 173.3c0-10.31 8.375-18.69 18.66-18.69C207.6 154.7 216 163 216 173.3C216 183.6 207.6 192 197.3 192z"],
    "bowling-pins": [512, 512, [], "f437", "M424 176c0-31.1 24-55.99 24-103.1s-32.06-71.99-64.05-72.05C351.1 0 320 24.12 320 72.05c0 47.99 24 71.99 24 103.1c0 63.99-56 127.1-56 191.1c0 53.4 22.29 95.66 38.42 126.8C331.9 505.4 342.8 512 354.8 512h58.51c11.1 0 22.9-6.611 28.4-17.27C457.7 463.6 480 421.4 480 368C480 304 424 240 424 176zM336 72.05c0-38.72 24.05-56.06 47.88-56.06C407.8 16.04 432 33.39 432 72.05c0 23.49-6.492 40.58-12.77 57.1c-4.645 12.23-9.209 24.89-10.61 38.88h-49.24c-1.4-13.99-5.965-26.66-10.61-38.88C342.5 112.6 336 95.54 336 72.05zM428.3 485.9l-.7969 1.545c-2.736 5.306-8.172 8.604-14.18 8.604h-58.51c-5.996 0-11.42-3.283-14.8-9.79C323.1 455.3 304 416.8 304 368c0-28.65 12.95-58.24 26.66-89.58c13.33-30.46 26.55-61.92 28.56-94.4h49.56c2.016 32.48 15.23 63.94 28.56 94.4C451.1 309.8 464 339.4 464 368C464 416.6 444.2 455 428.3 485.9zM192 72.05c0-47.99-32.06-71.99-64.05-72.05C95.98 0 64 24.12 64 72.05c0 47.99 24 71.99 24 103.1C88 240 32 304 32 368c0 53.4 22.29 95.66 38.42 126.8C75.93 505.4 86.82 512 98.79 512h58.51c11.1 0 22.9-6.611 28.4-17.27C201.7 463.6 224 421.4 224 368c0-63.99-56-127.1-56-191.1C168 144 192 120 192 72.05zM80 72.05c0-38.72 24.05-56.06 47.88-56.06C151.8 16.04 176 33.39 176 72.05c0 23.49-6.492 40.58-12.77 57.1c-4.645 12.23-9.209 24.89-10.61 38.88H103.4c-1.4-13.99-5.965-26.66-10.61-38.88C86.49 112.6 80 95.54 80 72.05zM181.3 278.4C195.1 309.8 208 339.4 208 368c0 48.6-19.81 86.99-35.72 117.8l-.7969 1.545c-2.736 5.306-8.172 8.604-14.18 8.604H98.79c-5.996 0-11.42-3.283-14.8-9.79C67.96 455.3 48 416.8 48 368c0-28.65 12.95-58.24 26.66-89.58C87.99 247.1 101.2 216.5 103.2 184H152.8C154.8 216.5 168 247.1 181.3 278.4z"],
    "box": [448, 512, [128230], "f466", "M342.4 32C367.7 32 390.6 46.9 400.9 70.01L442.5 163.6C446.1 171.8 448 180.6 448 189.6V416C448 451.3 419.3 480 384 480H64C28.65 480 0 451.3 0 416V189.6C0 180.6 1.879 171.8 5.516 163.6L47.11 70.01C57.38 46.89 80.3 32 105.6 32H342.4zM342.4 48H232V176H430C429.4 173.1 428.7 172 427.9 170.1L386.3 76.51C378.6 59.17 361.4 48 342.4 48V48zM432 192H16V416C16 442.5 37.49 464 64 464H384C410.5 464 432 442.5 432 416V192zM17.96 176H216V48H105.6C86.62 48 69.43 59.17 61.73 76.51L20.14 170.1C19.28 172 18.55 173.1 17.96 176V176z"],
    "box-archive": [512, 512, ["archive"], "f187", "M480 32H32C14.31 32 0 46.31 0 64v64c0 8.812 7.188 16 16 16H32v288C32 458.5 53.49 480 80 480h352c26.51 0 48-21.49 48-48v-288h16C504.8 144 512 136.8 512 128V64C512 46.31 497.7 32 480 32zM464 432c0 17.64-14.36 32-32 32h-352c-17.64 0-32-14.36-32-32v-288h416V432zM496 128h-480V64c0-8.82 7.178-16 16-16h448c8.822 0 16 7.18 16 16V128zM168 256h176C348.4 256 352 252.4 352 248S348.4 240 344 240h-176C163.6 240 160 243.6 160 247.1S163.6 256 168 256z"],
    "box-ballot": [576, 512, [128499], "f735", "M128 256h320c8.836 0 16-7.164 16-16V32c0-17.67-14.33-32-32-32h-288c-17.67 0-32 14.33-32 32v208C112 248.8 119.2 256 128 256zM128 32c0-8.822 7.178-16 16-16h288C440.8 16 448 23.18 448 32v208H128V32zM528 160h-24c-4.418 0-8 3.582-8 8s3.582 8 8 8h24c17.67 0 32 14.33 32 32V320h-544V208c0-17.67 14.33-32 32-32h24c4.418 0 8-3.582 8-8S76.42 160 72 160H48C21.49 160 0 181.5 0 208V480c0 17.67 14.33 32 32 32h512c17.67 0 32-14.33 32-32V208C576 181.5 554.5 160 528 160zM560 480c0 8.822-7.178 16-16 16H32c-8.822 0-16-7.178-16-16v-144h544V480z"],
    "box-check": [448, 512, [], "f467", "M197.7 389.7C194.5 392.8 189.5 392.8 186.3 389.7L130.3 333.7C127.2 330.5 127.2 325.5 130.3 322.3C133.5 319.2 138.5 319.2 141.7 322.3L192 372.7L306.3 258.3C309.5 255.2 314.5 255.2 317.7 258.3C320.8 261.5 320.8 266.5 317.7 269.7L197.7 389.7zM442.5 163.6C446.1 171.8 448 180.6 448 189.6V416C448 451.3 419.3 480 384 480H64C28.65 480 0 451.3 0 416V189.6C0 180.6 1.879 171.8 5.516 163.6L47.11 70.01C57.38 46.89 80.3 32 105.6 32H342.4C367.7 32 390.6 46.9 400.9 70.01L442.5 163.6zM232 176H430C429.4 173.1 428.7 172 427.9 170.1L386.3 76.51C378.6 59.17 361.4 48 342.4 48H232V176zM16 416C16 442.5 37.49 464 64 464H384C410.5 464 432 442.5 432 416V192H16V416zM216 48H105.6C86.62 48 69.43 59.17 61.73 76.51L20.14 170.1C19.28 172 18.55 173.1 17.96 176H216V48z"],
    "box-circle-check": [576, 512, [], "e0c4", "M15.1 416C15.1 442.5 37.49 464 63.1 464H284.5C288.1 469.6 292 474.9 296.2 480H64C28.65 480 0 451.3 0 416V189.6C0 180.6 1.879 171.8 5.516 163.6L47.11 70.01C57.38 46.89 80.3 32 105.6 32H342.4C367.7 32 390.6 46.9 400.9 70.01L442.5 163.6C446.1 171.8 448 180.6 448 189.6V192H16L15.1 416zM231.1 176H430C429.4 173.1 428.7 172 427.9 170.1L386.3 76.51C378.6 59.17 361.4 48 342.4 48H231.1V176zM215.1 48H105.6C86.62 48 69.43 59.17 61.73 76.51L20.14 170.1C19.28 172 18.55 173.1 17.96 176H215.1V48zM501.7 322.3C504.8 325.5 504.8 330.5 501.7 333.7L421.7 413.7C418.5 416.8 413.5 416.8 410.3 413.7L362.3 365.7C359.2 362.5 359.2 357.5 362.3 354.3C365.5 351.2 370.5 351.2 373.7 354.3L416 396.7L490.3 322.3C493.5 319.2 498.5 319.2 501.7 322.3H501.7zM287.1 368C287.1 288.5 352.5 224 432 224C511.5 224 576 288.5 576 368C576 447.5 511.5 512 432 512C352.5 512 287.1 447.5 287.1 368zM432 496C502.7 496 560 438.7 560 368C560 297.3 502.7 240 432 240C361.3 240 304 297.3 304 368C304 438.7 361.3 496 432 496z"],
    "box-dollar": [448, 512, ["box-usd"], "f4a0", "M232 248.6C233.8 248.8 235.6 249 237.5 249.3C242.3 250.1 256.9 252.9 262.1 254.3C266.3 255.4 268.9 259.8 267.7 264.1C266.6 268.3 262.2 270.9 257.9 269.7C253.5 268.6 239.5 265.8 235 265.1C220.9 262.9 208.5 264.6 199.6 268.6C190.7 272.7 185.7 278.8 184.5 285.6C183.6 291 184.2 294.9 185.6 297.8C187 300.8 189.5 303.6 193.3 306.1C201.3 311.5 212.9 315 226.3 319.1L226.5 319.1C239.2 322.1 253.7 327.4 264.2 334.1C269.6 338.9 274.3 343.9 277.1 350.5C279.1 357.1 280.7 364.7 279.3 373.1C276.8 387.5 267.4 397.4 254.7 402.9C247.1 405.8 240.3 407.4 232 407.9V424C232 428.4 228.4 432 223.1 432C219.6 432 215.1 428.4 215.1 424V407.4C214.2 407.2 212.4 406.1 210.5 406.7L210.5 406.7C201.9 405.3 187.8 400.5 178.4 397.3C176.6 396.6 174.9 396.1 173.5 395.6C169.3 394.2 167 389.7 168.4 385.5C169.8 381.3 174.3 379 178.5 380.4C180.3 380.1 182.2 381.7 184.3 382.4C193.8 385.6 205.9 389.7 213 390.9C227.3 393.1 239.6 391.9 248.4 388.2C256.1 384.5 262.1 378.5 263.5 370.4C264.5 364.5 263.9 360.2 262.4 356.9C261 353.6 258.5 350.6 254.8 347.9C246.9 342.2 235.3 338.5 221.9 334.5L220.2 333.1C208 330.3 194.4 326.2 184.4 319.4C178.9 315.7 174.1 310.1 171.2 304.7C168.1 298.3 167.3 291 168.7 282.9C171 269.5 180.6 259.7 192.1 254.1C199.8 250.1 207.6 249.1 216 248.4V232C216 227.6 219.6 224 224 224C228.4 224 232 227.6 232 232L232 248.6zM442.5 163.6C446.1 171.8 448 180.6 448 189.6V416C448 451.3 419.3 480 384 480H64C28.65 480 0 451.3 0 416V189.6C0 180.6 1.879 171.8 5.516 163.6L47.11 70.01C57.38 46.89 80.3 32 105.6 32H342.4C367.7 32 390.6 46.9 400.9 70.01L442.5 163.6zM232 176H430C429.4 173.1 428.7 172 427.9 170.1L386.3 76.51C378.6 59.17 361.4 48 342.4 48H232V176zM16 416C16 442.5 37.49 464 64 464H384C410.5 464 432 442.5 432 416V192H16V416zM216 48H105.6C86.62 48 69.43 59.17 61.73 76.51L20.14 170.1C19.28 172 18.55 173.1 17.96 176H216V48z"],
    "box-heart": [448, 512, [], "f49d", "M224 256.1L232.6 247.5C256.3 223.8 294.6 223.8 318.2 247.5C341.9 271.1 341.9 309.4 318.2 333.1L240.1 410.3C231.6 419.7 216.4 419.7 207 410.3L129.8 333.1C106.1 309.4 106.1 271.1 129.8 247.5C153.4 223.8 191.7 223.8 215.4 247.5L224 256.1zM141.1 321.8L218.3 399C221.5 402.2 226.5 402.2 229.7 399L306.9 321.8C324.3 304.4 324.3 276.2 306.9 258.8C289.5 241.4 261.3 241.4 243.9 258.8L224 278.7L204.1 258.8C186.7 241.4 158.5 241.4 141.1 258.8C123.7 276.2 123.7 304.4 141.1 321.8V321.8zM442.5 163.6C446.1 171.8 448 180.6 448 189.6V416C448 451.3 419.3 480 384 480H64C28.65 480 0 451.3 0 416V189.6C0 180.6 1.879 171.8 5.516 163.6L47.11 70.01C57.38 46.89 80.3 32 105.6 32H342.4C367.7 32 390.6 46.9 400.9 70.01L442.5 163.6zM232 176H430C429.4 173.1 428.7 172 427.9 170.1L386.3 76.51C378.6 59.17 361.4 48 342.4 48H232V176zM16 416C16 442.5 37.49 464 64 464H384C410.5 464 432 442.5 432 416V192H16V416zM216 48H105.6C86.62 48 69.43 59.17 61.73 76.51L20.14 170.1C19.28 172 18.55 173.1 17.96 176H216V48z"],
    "box-open": [640, 512, [], "f49e", "M320 69.25L567.8 33.86C578.7 32.29 589.3 38.43 593.4 48.7L626.6 131.7C633.8 149.6 623.6 169.7 604.1 174.6L437.3 218.1C420.8 222.3 403.5 215.7 394 201.7L320 91.66L245.1 201.7C236.5 215.8 219.2 222.3 202.7 218.1L35.04 174.6C16.38 169.7 6.201 149.6 13.36 131.7L46.57 48.7C50.68 38.43 61.29 32.29 72.25 33.86L320 69.25zM28.22 137.7C24.64 146.6 29.73 156.7 39.06 159.1L206.7 202.6C216.6 205.1 226.1 201.2 232.7 192.7L306.2 83.45L69.98 49.7C66.33 49.18 62.79 51.22 61.42 54.65L28.22 137.7zM333.8 83.45L407.3 192.7C413 201.2 423.4 205.1 433.3 202.6L600.9 159.1C610.3 156.7 615.4 146.6 611.8 137.7L578.6 54.65C577.2 51.22 573.7 49.18 570 49.7L333.8 83.45zM560 216.1L576 211.6V378.5C576 400.5 561 419.7 539.6 425.1L331.6 477.1C323.1 479 316 479 308.4 477.1L100.4 425.1C78.99 419.7 63.1 400.5 63.1 378.5V211.6L79.1 216.1V378.5C79.1 393.2 89.99 406 104.2 409.6L311.1 461.5V199.1C311.1 195.6 315.6 191.1 319.1 191.1C324.4 191.1 328 195.6 328 199.1V461.5L535.8 409.6C550 406 560 393.2 560 378.5L560 216.1z"],
    "box-open-full": [640, 512, ["box-full"], "f49c", "M438.9 132.1C436.6 135.9 431.7 137.1 427.9 134.9C424.1 132.6 422.9 127.7 425.1 123.9L497.1 3.884C499.4 .0953 504.3-1.133 508.1 1.14C511.9 3.413 513.1 8.327 510.9 12.12L438.9 132.1zM255.1 16C194.1 16 143.1 66.14 143.1 128C143.1 132.4 140.4 136 135.1 136C131.6 136 127.1 132.4 127.1 128C127.1 57.31 185.3 .0003 255.1 .0003C326.7 .0003 384 57.31 384 128C384 132.4 380.4 136 376 136C371.6 136 368 132.4 368 128C368 66.14 317.9 16 255.1 16zM320 189.3L567.8 153.9C578.7 152.3 589.3 158.4 593.4 168.7L626.6 251.7C633.8 269.6 623.6 289.7 604.1 294.6L437.3 338.1C420.8 342.3 403.5 335.8 394 321.7L320 211.7L245.1 321.7C236.5 335.8 219.2 342.3 202.7 338.1L35.04 294.6C16.38 289.7 6.201 269.6 13.36 251.7L46.57 168.7C50.68 158.4 61.29 152.3 72.25 153.9L320 189.3zM28.22 257.7C24.64 266.6 29.73 276.7 39.06 279.1L206.7 322.6C216.6 325.1 226.1 321.2 232.7 312.7L306.2 203.4L69.98 169.7C66.33 169.2 62.79 171.2 61.42 174.6L28.22 257.7zM333.8 203.4L407.3 312.7C413 321.2 423.4 325.1 433.3 322.6L600.9 279.1C610.3 276.7 615.4 266.6 611.8 257.7L578.6 174.6C577.2 171.2 573.7 169.2 570 169.7L333.8 203.4zM560 336.1L576 331.6V410.5C576 432.5 561 451.7 539.6 457.1L331.6 509.1C323.1 511 316 511 308.4 509.1L100.4 457.1C78.99 451.7 63.1 432.5 63.1 410.5V331.6L79.1 336.1V410.5C79.1 425.2 89.99 438 104.2 441.6L311.1 493.5V296C311.1 291.6 315.6 288 319.1 288C324.4 288 328 291.6 328 296V493.5L535.8 441.6C550 438 560 425.2 560 410.5L560 336.1z"],
    "box-taped": [448, 512, ["box-alt"], "f49a", "M342.4 32C367.7 32 390.6 46.9 400.9 70.01L442.5 163.6C446.1 171.8 448 180.6 448 189.6V416C448 451.3 419.3 480 384 480H64C28.65 480 0 451.3 0 416V189.6C0 180.6 1.879 171.8 5.516 163.6L47.11 70.01C57.38 46.89 80.3 32 105.6 32H342.4zM204.1 48L178 176H269.1L243 48H204.1zM160 192H16V416C16 442.5 37.49 464 64 464H384C410.5 464 432 442.5 432 416V192H288V272C288 289.7 273.7 304 256 304H192C174.3 304 160 289.7 160 272V192zM176 192V272C176 280.8 183.2 288 192 288H256C264.8 288 272 280.8 272 272V192H176zM430 176C429.4 173.1 428.7 172 427.9 170.1L386.3 76.51C378.6 59.17 361.4 48 342.4 48H259.4L286.3 176H430zM161.7 176L188.6 48H105.6C86.62 48 69.43 59.17 61.73 76.51L20.14 170.1C19.28 172 18.55 173.1 17.96 176H161.7z"],
    "box-tissue": [512, 512, [], "e05b", "M464 224H448c-4.418 0-8 3.582-8 8S443.6 240 448 240h16c17.67 0 32 14.33 32 32V384h-480V272c0-17.67 14.33-32 32-32H64c4.418 0 8-3.582 8-8S68.42 224 64 224H48C21.49 224 0 245.5 0 272V480c0 17.67 14.33 32 32 32h448c17.67 0 32-14.33 32-32V272C512 245.5 490.5 224 464 224zM496 480c0 8.822-7.178 16-16 16H32c-8.822 0-16-7.178-16-16v-80h480V480zM128 304h256c3.438 0 6.5-2.203 7.594-5.469l64-192C456.4 104.1 456 101.4 454.5 99.33C453 97.23 450.6 96 448 96h-109.4c-26.81 0-50.53-17.09-59-42.53C268.9 21.48 239.1 0 205.4 0H64C61.56 0 59.28 1.094 57.75 3c-1.5 1.891-2.094 4.359-1.562 6.734l64 288C121 301.4 124.3 304 128 304zM205.4 16c26.81 0 50.53 17.09 59 42.53C275.1 90.52 304.9 112 338.6 112h98.31L378.2 288H134.4L73.97 16H205.4z"],
    "boxes-packing": [640, 512, [], "e4c7", "M592 16H304C286.3 16 272 30.33 272 48V128H256V48C256 21.49 277.5 0 304 0H592C618.5 0 640 21.49 640 48V464C640 490.5 618.5 512 592 512H381.3C383 506.1 384 501.6 384 496H592C609.7 496 624 481.7 624 464V48C624 30.33 609.7 16 592 16zM549.7 322.3C552.8 325.5 552.8 330.5 549.7 333.7C546.5 336.8 541.5 336.8 538.3 333.7L488 283.3V440C488 444.4 484.4 448 480 448C475.6 448 472 444.4 472 440V283.3L421.7 333.7C418.5 336.8 413.5 336.8 410.3 333.7C407.2 330.5 407.2 325.5 410.3 322.3L474.3 258.3C477.5 255.2 482.5 255.2 485.7 258.3L549.7 322.3zM32 288C14.33 288 0 273.7 0 256V192C0 174.3 14.33 160 32 160H352C369.7 160 384 174.3 384 192V256C384 273.7 369.7 288 352 288V480C352 497.7 337.7 512 320 512H64C46.33 512 32 497.7 32 480V288zM16 192V256C16 264.8 23.16 272 32 272H352C360.8 272 368 264.8 368 256V192C368 183.2 360.8 176 352 176H32C23.16 176 16 183.2 16 192zM336 288H272V312C272 325.3 261.3 336 248 336H136C122.7 336 112 325.3 112 312V288H48V480C48 488.8 55.16 496 64 496H320C328.8 496 336 488.8 336 480V288zM128 312C128 316.4 131.6 320 136 320H248C252.4 320 256 316.4 256 312V288H128V312z"],
    "boxes-stacked": [576, 512, [62625, "boxes", "boxes-alt"], "f468", "M416 56V168C416 198.9 390.9 224 360 224H216C185.1 224 160 198.9 160 168V56C160 25.07 185.1 0 216 0H360C390.9 0 416 25.07 416 56zM360 16H336V88C336 101.3 325.3 112 312 112H264C250.7 112 240 101.3 240 88V16H216C193.9 16 176 33.91 176 56V168C176 190.1 193.9 208 216 208H360C382.1 208 400 190.1 400 168V56C400 33.91 382.1 16 360 16zM256 88C256 92.42 259.6 96 264 96H312C316.4 96 320 92.42 320 88V16H256V88zM200 288C230.9 288 256 313.1 256 344V456C256 486.9 230.9 512 200 512H56C25.07 512 0 486.9 0 456V344C0 313.1 25.07 288 56 288H200zM176 376C176 389.3 165.3 400 152 400H104C90.75 400 80 389.3 80 376V304H56C33.91 304 16 321.9 16 344V456C16 478.1 33.91 496 56 496H200C222.1 496 240 478.1 240 456V344C240 321.9 222.1 304 200 304H176V376zM160 304H96V376C96 380.4 99.58 384 104 384H152C156.4 384 160 380.4 160 376V304zM520 288C550.9 288 576 313.1 576 344V456C576 486.9 550.9 512 520 512H376C345.1 512 320 486.9 320 456V344C320 313.1 345.1 288 376 288H520zM496 376C496 389.3 485.3 400 472 400H424C410.7 400 400 389.3 400 376V304H376C353.9 304 336 321.9 336 344V456C336 478.1 353.9 496 376 496H520C542.1 496 560 478.1 560 456V344C560 321.9 542.1 304 520 304H496V376zM480 304H416V376C416 380.4 419.6 384 424 384H472C476.4 384 480 380.4 480 376V304z"],
    "boxing-glove": [512, 512, [129354, "glove-boxing"], "f438", "M286.5 355.3c-2.594-3.594-7.625-4.406-11.16-1.859l-51.35 36.67l-51.35-36.67c-3.594-2.547-8.562-1.734-11.16 1.859c-2.562 3.594-1.75 8.594 1.844 11.17L210.2 400l-46.88 33.48c-3.594 2.578-4.406 7.578-1.844 11.17C163.1 446.8 165.5 448 168 448c1.625 0 3.25-.4844 4.656-1.484l51.35-36.67l51.35 36.67C276.8 447.5 278.4 448 280 448c2.5 0 4.938-1.172 6.5-3.344c2.562-3.594 1.75-8.594-1.844-11.17L237.8 400l46.88-33.48C288.3 363.9 289.1 358.9 286.5 355.3zM432 152.4L431.1 104c0-57.34-46.66-104-104-104H136C78.75 0 32.09 45.75 32 101.1V296c0 27.92 11.62 54.91 32 74.56V456c0 30.88 25.12 56 56 56h223.1c30.88 0 56-25.12 56-56v-68.69l56.16-56.17C465.8 321.5 496.8 291 495.1 224C495.1 187 467.1 156.5 432 152.4zM444.8 319.8l-60.84 60.84V456c0 22.06-17.94 40-40 40H120c-22.06 0-40-17.94-40-40v-92.47C58.22 344.1 48 321.7 48 296V102C48.09 54.58 87.56 16 136 16h191.1c48.5 0 88 39.48 88.03 88v48h-32c-24.81 0-46.46 12.83-59.41 32H188.9c-33.81 0-64.25-20.08-77.6-51.16c-1.719-4.078-6.469-5.906-10.5-4.203C96.78 130.4 94.91 135.1 96.66 139.2C112.5 176.1 148.7 200 188.9 200h127.5C313.7 207.5 312 215.5 312 224c0 39.7 32.31 72 72 72c4.406 0 8-3.578 8-8s-3.594-8-8-8c-30.88 0-56-25.12-56-56s25.12-56 56-56h40C454.9 168 479.1 193.1 479.1 224C480.7 284.6 454.2 310.5 444.8 319.8z"],
    "bracket-curly": [256, 512, ["bracket-curly-left"], "7b", "M80 152.5V104c0-30.88 25.12-56 56-56h48C188.4 48 192 44.42 192 40S188.4 32 184 32h-48C96.3 32 64 64.3 64 104v48.45c0 41.08-22.83 78.02-59.58 96.39C1.719 250.2 0 252.1 0 256s1.719 5.797 4.422 7.156C41.17 281.5 64 318.5 64 359.5V408C64 447.7 96.3 480 136 480h48c4.422 0 8-3.578 8-8s-3.578-8-8-8h-48c-30.88 0-56-25.12-56-56v-48.45C80 317.2 58.89 278.7 24.06 256C58.89 233.3 80 194.8 80 152.5z"],
    "bracket-curly-right": [256, 512, [], "7d", "M231.9 256C197.1 278.7 176 317.2 176 359.5V408c0 30.88-25.12 56-56 56h-48C67.58 464 64 467.6 64 472S67.58 480 72 480h48c39.7 0 72-32.3 72-72v-48.45c0-41.08 22.83-78.02 59.58-96.39C254.3 261.8 256 259 256 256s-1.719-5.797-4.422-7.156C214.8 230.5 192 193.5 192 152.5V104C192 64.3 159.7 32 120 32h-48C67.58 32 64 35.58 64 40S67.58 48 72 48h48c30.88 0 56 25.12 56 56v48.45C176 194.8 197.1 233.3 231.9 256z"],
    "bracket-round": [192, 512, ["parenthesis"], "28", "M140.7 457.5c3.563 2.594 4.375 7.594 1.781 11.16c-1.563 2.156-4 3.313-6.469 3.313c-1.625 0-3.282-.5-4.688-1.5c-4.063-2.938-99.32-73.38-99.32-214.5s95.26-211.6 99.32-214.5c3.532-2.531 8.563-1.781 11.16 1.813c2.594 3.563 1.781 8.563-1.781 11.16c-.9063 .6875-92.7 68.88-92.7 201.5S139.8 456.8 140.7 457.5z"],
    "bracket-round-right": [192, 512, [], "29", "M143.1 255.1c0-132.7-91.79-200.8-92.7-201.5C47.74 51.87 46.93 46.87 49.52 43.3C52.11 39.71 57.15 38.96 60.68 41.49c4.063 2.938 99.32 73.38 99.32 214.5s-95.26 211.6-99.32 214.5c-1.406 1-3.063 1.5-4.688 1.5c-2.469 0-4.907-1.156-6.469-3.313c-2.594-3.563-1.781-8.563 1.781-11.16C52.21 456.8 143.1 388.7 143.1 255.1z"],
    "bracket-square": [192, 512, ["bracket", "bracket-left"], "5b", "M40 48h80C124.4 48 128 44.42 128 40S124.4 32 120 32h-80C17.94 32 0 49.94 0 72v368C0 462.1 17.94 480 40 480h80c4.406 0 8-3.578 8-8s-3.594-8-8-8h-80c-13.22 0-24-10.77-24-24V72C16 58.77 26.78 48 40 48z"],
    "bracket-square-right": [192, 512, [], "5d", "M176 72v368c0 13.23-10.78 24-24 24h-80C67.59 464 64 467.6 64 472S67.59 480 72 480h80c22.06 0 40-17.94 40-40V72C192 49.94 174.1 32 152 32h-80C67.59 32 64 35.58 64 40S67.59 48 72 48h80C165.2 48 176 58.77 176 72z"],
    "brackets-curly": [576, 512, [], "f7ea", "M112 152.5V104c0-30.88 25.12-56 56-56h48C220.4 48 224 44.42 224 40S220.4 32 216 32h-48C128.3 32 96 64.3 96 104v48.45c0 41.08-22.83 78.02-59.58 96.39C33.72 250.2 32 252.1 32 256s1.719 5.797 4.422 7.156C73.17 281.5 96 318.5 96 359.5V408C96 447.7 128.3 480 168 480h48C220.4 480 224 476.4 224 472S220.4 464 216 464h-48c-30.88 0-56-25.12-56-56v-48.45C112 317.2 90.89 278.7 56.06 256C90.89 233.3 112 194.8 112 152.5zM539.6 248.8C502.8 230.5 480 193.5 480 152.5V104C480 64.3 447.7 32 408 32h-48C355.6 32 352 35.58 352 40s3.578 8 8 8h48c30.88 0 56 25.12 56 56v48.45C464 194.8 485.1 233.3 519.9 256C485.1 278.7 464 317.2 464 359.5V408c0 30.88-25.12 56-56 56h-48c-4.422 0-8 3.578-8 8S355.6 480 360 480h48c39.7 0 72-32.3 72-72v-48.45c0-41.08 22.83-78.02 59.58-96.39C542.3 261.8 544 259 544 256S542.3 250.2 539.6 248.8z"],
    "brackets-round": [512, 512, ["parentheses"], "e0c5", "M140.7 54.46c3.562-2.594 4.375-7.594 1.781-11.16C139.9 39.71 134.8 38.96 131.3 41.49C127.3 44.43 32 114.9 32 255.1s95.25 211.6 99.31 214.5c1.406 1 3.062 1.5 4.688 1.5c2.469 0 4.906-1.156 6.469-3.313c2.594-3.563 1.781-8.563-1.781-11.16C139.8 456.8 48 388.7 48 255.1S139.8 55.15 140.7 54.46zM380.7 41.49c-3.562-2.531-8.562-1.75-11.16 1.813c-2.594 3.563-1.781 8.563 1.781 11.16C372.2 55.15 464 123.3 464 255.1s-91.78 200.8-92.69 201.5c-3.562 2.594-4.375 7.594-1.781 11.16c1.562 2.156 4 3.313 6.469 3.313c1.625 0 3.281-.5 4.688-1.5C384.8 467.6 480 397.1 480 255.1S384.8 44.43 380.7 41.49z"],
    "brackets-square": [448, 512, ["brackets"], "f7e9", "M56 48h80c4.406 0 8-3.578 8-8S140.4 32 136 32h-80C33.94 32 16 49.94 16 72v368C16 462.1 33.94 480 56 480h80c4.406 0 8-3.578 8-8S140.4 464 136 464h-80C42.78 464 32 453.2 32 440V72C32 58.77 42.78 48 56 48zM392 32h-80c-4.406 0-8 3.578-8 8s3.594 8 8 8h80C405.2 48 416 58.77 416 72v368c0 13.23-10.78 24-24 24h-80c-4.406 0-8 3.578-8 8S307.6 480 312 480h80c22.06 0 40-17.94 40-40V72C432 49.94 414.1 32 392 32z"],
    "braille": [640, 512, [], "f2a1", "M48 96C48 87.16 55.16 80 64 80C72.84 80 80 87.16 80 96C80 104.8 72.84 112 64 112C55.16 112 48 104.8 48 96zM0 96C0 60.65 28.65 32 64 32C99.35 32 128 60.65 128 96C128 131.3 99.35 160 64 160C28.65 160 0 131.3 0 96zM64 144C90.51 144 112 122.5 112 96C112 69.49 90.51 48 64 48C37.49 48 16 69.49 16 96C16 122.5 37.49 144 64 144zM160 256C160 220.7 188.7 192 224 192C259.3 192 288 220.7 288 256C288 291.3 259.3 320 224 320C188.7 320 160 291.3 160 256zM224 304C250.5 304 272 282.5 272 256C272 229.5 250.5 208 224 208C197.5 208 176 229.5 176 256C176 282.5 197.5 304 224 304zM128 416C128 451.3 99.35 480 64 480C28.65 480 0 451.3 0 416C0 380.7 28.65 352 64 352C99.35 352 128 380.7 128 416zM64 368C37.49 368 16 389.5 16 416C16 442.5 37.49 464 64 464C90.51 464 112 442.5 112 416C112 389.5 90.51 368 64 368zM288 416C288 451.3 259.3 480 224 480C188.7 480 160 451.3 160 416C160 380.7 188.7 352 224 352C259.3 352 288 380.7 288 416zM224 368C197.5 368 176 389.5 176 416C176 442.5 197.5 464 224 464C250.5 464 272 442.5 272 416C272 389.5 250.5 368 224 368zM80 256C80 264.8 72.84 272 64 272C55.16 272 48 264.8 48 256C48 247.2 55.16 240 64 240C72.84 240 80 247.2 80 256zM128 256C128 291.3 99.35 320 64 320C28.65 320 0 291.3 0 256C0 220.7 28.65 192 64 192C99.35 192 128 220.7 128 256zM64 208C37.49 208 16 229.5 16 256C16 282.5 37.49 304 64 304C90.51 304 112 282.5 112 256C112 229.5 90.51 208 64 208zM240 96C240 104.8 232.8 112 224 112C215.2 112 208 104.8 208 96C208 87.16 215.2 80 224 80C232.8 80 240 87.16 240 96zM288 96C288 131.3 259.3 160 224 160C188.7 160 160 131.3 160 96C160 60.65 188.7 32 224 32C259.3 32 288 60.65 288 96zM224 48C197.5 48 176 69.49 176 96C176 122.5 197.5 144 224 144C250.5 144 272 122.5 272 96C272 69.49 250.5 48 224 48zM400 96C400 87.16 407.2 80 416 80C424.8 80 432 87.16 432 96C432 104.8 424.8 112 416 112C407.2 112 400 104.8 400 96zM352 96C352 60.65 380.7 32 416 32C451.3 32 480 60.65 480 96C480 131.3 451.3 160 416 160C380.7 160 352 131.3 352 96zM416 144C442.5 144 464 122.5 464 96C464 69.49 442.5 48 416 48C389.5 48 368 69.49 368 96C368 122.5 389.5 144 416 144zM640 96C640 131.3 611.3 160 576 160C540.7 160 512 131.3 512 96C512 60.65 540.7 32 576 32C611.3 32 640 60.65 640 96zM576 48C549.5 48 528 69.49 528 96C528 122.5 549.5 144 576 144C602.5 144 624 122.5 624 96C624 69.49 602.5 48 576 48zM512 256C512 220.7 540.7 192 576 192C611.3 192 640 220.7 640 256C640 291.3 611.3 320 576 320C540.7 320 512 291.3 512 256zM576 304C602.5 304 624 282.5 624 256C624 229.5 602.5 208 576 208C549.5 208 528 229.5 528 256C528 282.5 549.5 304 576 304zM640 416C640 451.3 611.3 480 576 480C540.7 480 512 451.3 512 416C512 380.7 540.7 352 576 352C611.3 352 640 380.7 640 416zM576 368C549.5 368 528 389.5 528 416C528 442.5 549.5 464 576 464C602.5 464 624 442.5 624 416C624 389.5 602.5 368 576 368zM352 256C352 220.7 380.7 192 416 192C451.3 192 480 220.7 480 256C480 291.3 451.3 320 416 320C380.7 320 352 291.3 352 256zM416 304C442.5 304 464 282.5 464 256C464 229.5 442.5 208 416 208C389.5 208 368 229.5 368 256C368 282.5 389.5 304 416 304zM480 416C480 451.3 451.3 480 416 480C380.7 480 352 451.3 352 416C352 380.7 380.7 352 416 352C451.3 352 480 380.7 480 416zM416 368C389.5 368 368 389.5 368 416C368 442.5 389.5 464 416 464C442.5 464 464 442.5 464 416C464 389.5 442.5 368 416 368z"],
    "brain": [512, 512, [129504], "f5dc", "M256 32.99C266.9 13.32 287.9 0 312 0C341.9 0 367 20.53 374.1 48.28C406.6 51.33 432 78.7 432 112C432 118.7 430.1 125.1 429.1 131.1C458.6 140.2 480 167.6 480 200C480 212.4 476.9 224.1 471.3 234.3C495.6 248 512 274.1 512 304C512 337.3 491.6 365.9 462.6 377.9C463.5 382.5 464 387.2 464 392C464 431.8 431.8 464 392 464C388.3 464 384.8 463.7 381.2 463.2C372.1 491.4 346.9 512 316 512C290 512 267.5 497.4 256 476C244.5 497.4 221.1 512 196 512C165.1 512 139 491.4 130.8 463.2C127.2 463.7 123.7 464 120 464C80.24 464 48 431.8 48 392C48 387.2 48.47 382.5 49.38 377.9C20.39 365.9 0 337.3 0 304C0 274.1 16.41 248 40.69 234.3C35.15 224.1 32 212.4 32 200C32 167.6 53.44 140.2 82.91 131.1C81.02 125.1 80 118.7 80 112C80 78.7 105.4 51.33 137.9 48.28C144.1 20.53 170.1 0 200 0C224.1 0 245.1 13.32 256 32.99V32.99zM248 64C248 37.49 226.5 16 200 16C175.8 16 155.8 33.88 152.5 57.14L151.5 64.04L144 64C117.5 64 96 85.49 96 112C96 119.7 97.78 126.9 100.1 133.3L105.8 142.1L95.05 144.7C68.38 148.1 47.1 172.1 47.1 200C47.1 212.3 51.95 223.6 58.66 232.9L64.59 241L55.28 244.9C32.19 254.6 15.1 277.4 15.1 304C15.1 332.8 35.04 357.2 61.25 365.2L68.95 367.6L66.54 375.3C64.89 380.5 63.1 386.2 63.1 392C63.1 422.9 89.07 448 119.1 448C125.1 448 130 447.3 134.7 446.1L143.3 443.7L144.7 452.5C148.7 477.2 170.2 496 195.1 496C223.6 496 246.1 474.6 247.9 447.5L247.1 445.7L248 64zM264 445.7L264.1 447.5C265.9 474.6 288.4 496 316 496C341.8 496 363.3 477.2 367.3 452.5L368.7 443.7L377.3 446.1C381.1 447.3 386.9 448 392 448C422.9 448 448 422.9 448 392C448 386.2 447.1 380.5 445.5 375.3L443 367.6L450.7 365.2C476.1 357.2 496 332.8 496 304C496 277.4 479.8 254.6 456.7 244.9L447.4 241L453.3 232.9C460 223.6 464 212.3 464 200C464 172.1 443.6 148.1 416.1 144.7L406.2 142.1L411 133.3C414.2 126.9 416 119.7 416 112C416 85.49 394.5 64 368 64L360.5 64.04L359.5 57.14C356.2 33.88 336.2 16 311.1 16C285.5 16 263.1 37.49 263.1 64L264 445.7z"],
    "brain-arrow-curved-right": [640, 512, ["mind-share"], "f677", "M296 320V64c0-26.51 21.38-48 47.91-48c26.12 0 48.33 21.06 47.94 48.81C394.5 64.37 397.2 64 399.9 64c26.52 0 48.03 21.49 48.03 48c0 12.58-4.949 23.93-12.87 32.49c2.213-.1953 4.346-.2891 6.406-.2891c45.68 0 54.49 45.77 54.49 55.8L496 208c0 4.418 3.582 8 8 8S512 212.4 512 208V200c0-19.43-13.27-58.88-50.89-69.25C462.1 124.7 463.1 118.4 463.1 112c0-33.27-25.53-60.69-58.03-63.72c-2.734-10.96-8.326-21-16.41-29.2C377.6 6.953 360.9 0 343.9 0C319.9 0 298.1 13.26 288 32.84C277 13.26 256.1 0 232.1 0c-17.03 0-33.66 6.953-45.61 19.08C178.4 27.27 172.8 37.31 170.1 48.28C137.6 51.31 112 78.73 112 112c0 6.395 .9668 12.69 2.832 18.7C95.47 135.1 83.62 148.6 76.69 159.6C66.69 175.5 64.02 192.5 64.02 200c0 12.05 3.111 23.84 8.859 34.3C48.26 248.2 32 274.7 32 304c0 33.13 19.97 61.77 49.51 73.79c-1.791 8.488-1.973 17.14-.5078 25.89c4.402 26.3 23.5 48.58 48.88 56.77C140.9 464 152 464.9 162.9 463.1c3.014 10.46 8.539 20.07 16.3 28.1C191.9 504.4 209.7 512 228.1 512c16.74 0 32.05-6.027 43.91-16.1c2.848-2.422 3.777-6.594 2.018-9.891c-2.395-4.504-8.365-5.98-12.22-2.641C252.7 491.2 241 496 228.1 496c-28.69 0-52.88-23.45-51.86-53.69c-12.77 6.148-27.93 8.113-44.31 1.852c-14.65-5.602-26.46-17.47-32.07-32.11c-6.418-16.75-4.188-32.14 2.303-45.05C71.52 362.2 48 335.1 48 304c0-30.76 21.73-56.41 50.67-62.55C87.3 231.2 80.02 216.5 80.02 200c0-10.54 9.068-55.8 54.49-55.8c2.057 0 4.191 .0938 6.4 .2891C132.1 135.9 128 124.6 128 112c0-26.51 21.5-48 48.02-48c2.77 0 5.445 .3672 8.086 .8125C183.8 37.05 205.1 16 232.1 16C258.6 16 280 37.49 280 64v256c0 4.418 3.582 8 8 8S296 324.4 296 320zM603.3 340.7l-96-96C504.3 241.6 500.2 240 495.1 240c-2.061 0-4.139 .3984-6.119 1.219C483.9 243.7 480 249.5 480 256l-.0599 47.94c-25 .0273-72.7 .1888-94.76 .5365c-39.32 .6133-74.58 28.39-89.83 70.76c-13.25 36.8-11.84 89.42 31.86 126.7c2.967 2.531 6.668 3.832 10.39 3.832c2.742 0 5.496-.7031 7.984-2.137c5.867-3.379 8.971-10.09 7.75-16.75c-4.684-25.56 .4609-49.62 14.12-66.01c11.4-13.68 28.2-20.88 48.57-20.88h64L480 448c0 6.473 3.898 12.3 9.877 14.78C491.9 463.6 493.9 464 495.1 464c4.164 0 8.116-1.576 11.18-4.639l96.14-96.05C609.6 357.1 609.6 346.9 603.3 340.7zM496 448v-64H416c-59.96 0-88.26 51.97-78.4 105.8c-67.08-57.26-24.5-168.2 47.83-169.3C416 320 496 320 496 320V256l96 96L496 448z"],
    "brain-circuit": [512, 512, [], "e0c6", "M137.9 48.28C144.1 20.53 170.1 0 200 0C224.1 0 245.1 13.32 256 32.99C266.9 13.32 287.9 0 312 0C341.9 0 367 20.53 374.1 48.28C406.6 51.33 432 78.7 432 112C432 118.7 430.1 125.1 429.1 131.1C458.6 140.2 480 167.6 480 200C480 212.4 476.9 224.1 471.3 234.3C495.6 248 512 274.1 512 304C512 337.3 491.6 365.9 462.6 377.9C463.5 382.5 464 387.2 464 392C464 431.8 431.8 464 392 464C388.3 464 384.8 463.7 381.2 463.2C372.1 491.4 346.9 512 316 512C290 512 267.4 497.4 256 476C244.5 497.4 221.1 512 196 512C165.1 512 139 491.4 130.8 463.2C127.2 463.7 123.7 464 120 464C80.24 464 48 431.8 48 392C48 387.2 48.47 382.5 49.38 377.9C20.39 365.9 0 337.3 0 304C0 274.1 16.41 248 40.69 234.3C35.15 224.1 32 212.4 32 200C32 167.6 53.44 140.2 82.91 131.1C81.02 125.1 80 118.7 80 112C80 78.7 105.4 51.33 137.9 48.28V48.28zM152.5 57.14L151.5 64.04L144 64C117.5 64 96 85.49 96 112C96 119.7 97.78 126.9 100.1 133.3L105.8 142.1L95.05 144.7C68.38 148.1 47.1 172.1 47.1 200C47.1 212.3 51.95 223.6 58.66 232.9L64.59 241L55.28 244.9C32.19 254.6 15.1 277.4 15.1 304C15.1 332.8 35.04 357.2 61.25 365.2L68.95 367.6L66.54 375.3C64.89 380.5 63.1 386.2 63.1 392C63.1 422.9 89.07 448 119.1 448C125.1 448 130 447.3 134.7 446.1L143.3 443.7L144.7 452.5C148.7 477.2 170.2 496 195.1 496C223.6 496 246.1 474.6 247.9 447.5L247.1 445.7V288H191.1C178.7 288 167.1 298.7 167.1 312V321C181.8 324.6 191.1 337.1 191.1 352C191.1 369.7 177.7 384 159.1 384C142.3 384 127.1 369.7 127.1 352C127.1 337.1 138.2 324.6 151.1 321V312C151.1 289.9 169.9 272 191.1 272H247.1V152H206.1C203.4 165.8 190.9 176 175.1 176C158.3 176 143.1 161.7 143.1 144C143.1 126.3 158.3 112 175.1 112C190.9 112 203.4 122.2 206.1 136H247.1V64C247.1 37.49 226.5 16 199.1 16C175.8 16 155.8 33.88 152.5 57.14H152.5zM264 152V360H337C340.6 346.2 353.1 336 368 336C385.7 336 400 350.3 400 368C400 385.7 385.7 400 368 400C353.1 400 340.6 389.8 337 376H264V445.7L264.1 447.5C265.9 474.6 288.4 496 316 496C341.8 496 363.3 477.2 367.3 452.5L368.7 443.7L377.3 446.1C381.1 447.3 386.9 448 392 448C422.9 448 448 422.9 448 392C448 386.2 447.1 380.5 445.5 375.3L443 367.6L450.7 365.2C476.1 357.2 496 332.8 496 304C496 277.4 479.8 254.6 456.7 244.9L447.4 241L453.3 232.9C460 223.6 464 212.3 464 200C464 172.1 443.6 148.1 416.1 144.7L406.2 142.1L411 133.3C414.2 126.9 416 119.7 416 112C416 85.49 394.5 64 368 64L360.5 64.04L359.5 57.14C356.2 33.88 336.2 16 312 16C285.5 16 264 37.49 264 64V136H320C342.1 136 360 153.9 360 176V193C373.8 196.6 384 209.1 384 224C384 241.7 369.7 256 352 256C334.3 256 320 241.7 320 224C320 209.1 330.2 196.6 344 193V176C344 162.7 333.3 152 320 152H264zM176 160C184.8 160 192 152.8 192 144C192 135.2 184.8 128 176 128C167.2 128 160 135.2 160 144C160 152.8 167.2 160 176 160zM160 368C168.8 368 176 360.8 176 352C176 343.2 168.8 336 160 336C151.2 336 144 343.2 144 352C144 360.8 151.2 368 160 368zM368 224C368 215.2 360.8 208 352 208C343.2 208 336 215.2 336 224C336 232.8 343.2 240 352 240C360.8 240 368 232.8 368 224zM368 384C376.8 384 384 376.8 384 368C384 359.2 376.8 352 368 352C359.2 352 352 359.2 352 368C352 376.8 359.2 384 368 384z"],
    "brake-warning": [640, 512, [], "e0c7", "M328 296C328 300.4 324.4 304 320 304C315.6 304 312 300.4 312 296V136C312 131.6 315.6 128 320 128C324.4 128 328 131.6 328 136V296zM304 352C304 343.2 311.2 336 320 336C328.8 336 336 343.2 336 352C336 360.8 328.8 368 320 368C311.2 368 304 360.8 304 352zM96 256C96 132.3 196.3 32 320 32C443.7 32 544 132.3 544 256C544 379.7 443.7 480 320 480C196.3 480 96 379.7 96 256zM320 464C434.9 464 528 370.9 528 256C528 141.1 434.9 48 320 48C205.1 48 112 141.1 112 256C112 370.9 205.1 464 320 464zM16 256C16 314.8 33.15 369.6 62.73 415.7C65.12 419.4 64.04 424.4 60.32 426.8C56.6 429.1 51.66 428.1 49.27 424.3C18.08 375.8 0 317.1 0 256C0 194 18.08 136.2 49.27 87.66C51.66 83.94 56.6 82.86 60.32 85.25C64.04 87.63 65.12 92.58 62.73 96.3C33.15 142.4 16 197.2 16 256zM640 256C640 317.1 621.9 375.8 590.7 424.3C588.3 428.1 583.4 429.1 579.7 426.8C575.1 424.4 574.9 419.4 577.3 415.7C606.8 369.6 624 314.8 624 256C624 197.2 606.8 142.4 577.3 96.3C574.9 92.58 575.1 87.63 579.7 85.25C583.4 82.86 588.3 83.94 590.7 87.66C621.9 136.2 640 194 640 256z"],
    "brazilian-real-sign": [512, 512, [], "e46c", "M400 0C404.4 0 408 3.582 408 8V64.08C426.5 64.68 444.7 68.65 461.8 75.81L475.1 81.38C479.2 83.09 481.1 87.78 479.4 91.85C477.7 95.93 472.1 97.85 468.9 96.14L455.6 90.57C438.1 83.59 421.1 80 403 80H383.1C339.4 80 304 115.4 304 159.1C304 193.4 326.1 223.8 358.8 234.3L446.1 262.5C485.4 275.1 512 311.7 512 352.9C512 405.4 469.4 448 416.9 448H408V504C408 508.4 404.4 512 400 512C395.6 512 392 508.4 392 504V447.1C368.6 447.4 345.7 440.7 325.5 428.7L299.9 413.3C296.1 411.1 294.9 406.2 297.1 402.4C299.4 398.6 304.3 397.3 308.1 399.6L333.7 414.1C352.4 426.1 373.7 432 395.4 432H416.9C460.6 432 496 396.6 496 352.9C496 318.6 473.9 288.2 441.2 277.7L353.9 249.5C314.6 236.9 288 200.3 288 159.1C288 106.6 330.6 64 383.1 64H392V8C392 3.582 395.6 .0003 400 .0003V0zM0 72C0 49.91 17.91 32 40 32H120C195.1 32 256 92.89 256 168C256 236.7 205.1 293.5 138.9 302.7L199.5 469.3C201 473.4 198.9 478 194.7 479.5C190.6 481 185.1 478.9 184.5 474.7L122.4 303.1C121.6 303.1 120.8 303.1 120 303.1H16V472C16 476.4 12.42 480 8 480C3.582 480 .0003 476.4 .0003 472L0 72zM16 288H120C186.3 288 240 234.3 240 168C240 101.7 186.3 48 120 48H40C26.75 48 16 58.75 16 72V288z"],
    "bread-loaf": [640, 512, [127838], "f7eb", "M400 32h-160C107.5 32 0 103.6 0 192c0 35.38 26.88 64 60 64H64v192c0 17.62 14.38 32 32 32h448c17.62 0 32-14.38 32-32V256h4C613.1 256 640 227.4 640 192C640 103.6 532.5 32 400 32zM96 464c-8.822 0-16-7.178-16-16V240H60C35.74 240 16 218.5 16 192c0-79.4 100.5-144 224-144s224 64.6 224 144c0 26.47-19.74 48-44 48H400V448c0 8.822-7.178 16-16 16H96zM580 240H560V448c0 8.822-7.178 16-16 16h-132.9C413.9 459.2 416 453.9 416 448V256h4C453.1 256 480 227.4 480 192c0-63.47-55.59-118.1-135.9-144H400c123.5 0 224 64.6 224 144C624 218.5 604.3 240 580 240z"],
    "bread-slice": [512, 512, [], "f7ec", "M256 32C96 32 0 112 0 176.1C0 203 21.56 224 56.89 224H64v224c0 17.67 14.33 32 32 32h320c17.67 0 32-14.33 32-32V224h7.111C490.4 224 512 203 512 176.1C512 112 416 32 256 32zM455.1 208H432V448c0 8.822-7.178 16-16 16H96c-8.822 0-16-7.178-16-16V208H56.89C32.43 208 16 195.5 16 176.1C16 124.3 101.5 48 256 48c154.5 0 240 76.25 240 128.1C496 195.5 479.6 208 455.1 208z"],
    "bread-slice-butter": [512, 512, [], "e3e1", "M512 176.1C511.6 183.9 509.8 190.6 506.7 196.8C503.5 203 499.2 208.5 493.8 212.9C488.5 217.3 482.3 220.6 475.6 222.5C468.1 224.4 461.1 224.9 455.1 224H448V448C448 456.5 444.6 464.6 438.6 470.6C432.6 476.6 424.5 480 416 480H96C87.51 480 79.37 476.6 73.37 470.6C67.37 464.6 64 456.5 64 448V224H56.9C50.03 224.9 43.04 224.4 36.38 222.5C29.71 220.6 23.51 217.3 18.17 212.9C12.83 208.5 8.457 203 5.33 196.8C2.203 190.6 .3885 183.9 0 176.1C0 112 96 32 256 32C416 32 512 112 512 176.1H512zM496 176.1C496 124.3 410.5 48 256 48C101.5 48 16 124.3 16 176.1C16 195.5 32.42 208 56.9 208H80V448C80 452.2 81.69 456.3 84.69 459.3C87.69 462.3 91.76 464 96 464H416C420.2 464 424.3 462.3 427.3 459.3C430.3 456.3 432 452.2 432 448V208H455.1C479.6 208 496 195.5 496 176.1zM329.6 259.7C337.1 267.2 341.3 277.4 341.3 288C341.3 298.6 337.1 308.8 329.6 316.3L284.3 361.6C276.8 369.1 266.6 373.3 256 373.3C245.4 373.3 235.2 369.1 227.7 361.6L182.4 316.3C174.9 308.8 170.7 298.6 170.7 288C170.7 277.4 174.9 267.2 182.4 259.7L227.7 214.4C235.2 206.9 245.4 202.7 256 202.7C266.6 202.7 276.8 206.9 284.3 214.4L329.6 259.7zM318.2 304.1C320.4 302.7 322.2 300.1 323.4 297.2C324.6 294.3 325.2 291.2 325.2 288C325.2 284.8 324.6 281.7 323.4 278.8C322.2 275.9 320.4 273.3 318.2 271L272.1 225.8C270.7 223.6 268.1 221.8 265.2 220.6C262.3 219.4 259.2 218.7 256 218.7C252.8 218.7 249.7 219.4 246.8 220.6C243.9 221.8 241.3 223.6 239 225.8L193.8 271C191.6 273.3 189.8 275.9 188.6 278.8C187.4 281.7 186.8 284.8 186.8 288C186.8 291.2 187.4 294.3 188.6 297.2C189.8 300.1 191.6 302.7 193.8 304.1L239 350.2C241.3 352.4 243.9 354.2 246.8 355.4C249.7 356.6 252.9 357.2 256 357.2C259.2 357.2 262.3 356.6 265.2 355.4C268.1 354.2 270.7 352.4 272.1 350.2L318.2 304.9V304.1z"],
    "bridge": [576, 512, [], "e4c8", "M568 32C572.4 32 576 35.58 576 40C576 44.42 572.4 48 568 48H488V144H568C572.4 144 576 147.6 576 152C576 156.4 572.4 160 568 160H8C3.582 160 0 156.4 0 152C0 147.6 3.582 144 8 144H88V48H8C3.582 48 0 44.42 0 40C0 35.58 3.582 32 8 32H568zM472 48H360V144H472V48zM232 48V144H344V48H232zM216 48H104V144H216V48zM32 256C80.6 256 120 295.4 120 344V440C120 453.3 130.7 464 144 464H176C189.3 464 200 453.3 200 440V344C200 295.4 239.4 256 288 256C336.6 256 376 295.4 376 344V440C376 453.3 386.7 464 400 464H432C445.3 464 456 453.3 456 440V344C456 295.4 495.4 256 544 256H568C572.4 256 576 259.6 576 264C576 268.4 572.4 272 568 272H544C504.2 272 472 304.2 472 344V440C472 462.1 454.1 480 432 480H400C377.9 480 360 462.1 360 440V344C360 304.2 327.8 272 288 272C248.2 272 216 304.2 216 344V440C216 462.1 198.1 480 176 480H144C121.9 480 104 462.1 104 440V344C104 304.2 71.76 272 32 272H8C3.582 272 0 268.4 0 264C0 259.6 3.582 256 8 256H32z"],
    "bridge-circle-check": [640, 512, [], "e4c9", "M600 32C604.4 32 608 35.58 608 40C608 44.42 604.4 48 600 48H520V144H600C604.4 144 608 147.6 608 152C608 156.4 604.4 160 600 160H40C35.58 160 32 156.4 32 152C32 147.6 35.58 144 40 144H120V48H40C35.58 48 32 44.42 32 40C32 35.58 35.58 32 40 32H600zM504 48H392V144H504V48zM264 48V144H376V48H264zM248 48H136V144H248V48zM64 256C112.6 256 152 295.4 152 344V440C152 453.3 162.7 464 176 464H208C221.3 464 232 453.3 232 440V344C232 295.4 271.4 256 320 256C332.3 256 344 258.5 354.7 263.1C351.4 267.5 348.4 271.1 345.5 276.7C337.6 273.6 328.1 272 320 272C280.2 272 248 304.2 248 344V440C248 462.1 230.1 480 208 480H176C153.9 480 136 462.1 136 440V344C136 304.2 103.8 272 64 272H40C35.58 272 32 268.4 32 264C32 259.6 35.58 256 40 256L64 256zM565.7 322.3C568.8 325.5 568.8 330.5 565.7 333.7L485.7 413.7C482.5 416.8 477.5 416.8 474.3 413.7L426.3 365.7C423.2 362.5 423.2 357.5 426.3 354.3C429.5 351.2 434.5 351.2 437.7 354.3L480 396.7L554.3 322.3C557.5 319.2 562.5 319.2 565.7 322.3H565.7zM352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368zM496 496C566.7 496 624 438.7 624 368C624 297.3 566.7 240 496 240C425.3 240 368 297.3 368 368C368 438.7 425.3 496 496 496z"],
    "bridge-circle-exclamation": [640, 512, [], "e4ca", "M600 32C604.4 32 608 35.58 608 40C608 44.42 604.4 48 600 48H520V144H600C604.4 144 608 147.6 608 152C608 156.4 604.4 160 600 160H40C35.58 160 32 156.4 32 152C32 147.6 35.58 144 40 144H120V48H40C35.58 48 32 44.42 32 40C32 35.58 35.58 32 40 32H600zM504 48H392V144H504V48zM264 48V144H376V48H264zM248 48H136V144H248V48zM64 256C112.6 256 152 295.4 152 344V440C152 453.3 162.7 464 176 464H208C221.3 464 232 453.3 232 440V344C232 295.4 271.4 256 320 256C332.3 256 344 258.5 354.7 263.1C351.4 267.5 348.4 271.1 345.5 276.7C337.6 273.6 328.1 272 320 272C280.2 272 248 304.2 248 344V440C248 462.1 230.1 480 208 480H176C153.9 480 136 462.1 136 440V344C136 304.2 103.8 272 64 272H40C35.58 272 32 268.4 32 264C32 259.6 35.58 256 40 256L64 256zM480 432C480 423.2 487.2 416 496 416C504.8 416 512 423.2 512 432C512 440.8 504.8 448 496 448C487.2 448 480 440.8 480 432zM495.1 280C500.4 280 503.1 283.6 503.1 288V384C503.1 388.4 500.4 392 495.1 392C491.6 392 487.1 388.4 487.1 384V288C487.1 283.6 491.6 280 495.1 280zM640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368zM496 240C425.3 240 368 297.3 368 368C368 438.7 425.3 496 496 496C566.7 496 624 438.7 624 368C624 297.3 566.7 240 496 240z"],
    "bridge-circle-xmark": [640, 512, [], "e4cb", "M600 32C604.4 32 608 35.58 608 40C608 44.42 604.4 48 600 48H520V144H600C604.4 144 608 147.6 608 152C608 156.4 604.4 160 600 160H40C35.58 160 32 156.4 32 152C32 147.6 35.58 144 40 144H120V48H40C35.58 48 32 44.42 32 40C32 35.58 35.58 32 40 32H600zM504 48H392V144H504V48zM264 48V144H376V48H264zM248 48H136V144H248V48zM64 256C112.6 256 152 295.4 152 344V440C152 453.3 162.7 464 176 464H208C221.3 464 232 453.3 232 440V344C232 295.4 271.4 256 320 256C332.3 256 344 258.5 354.7 263.1C351.4 267.5 348.4 271.1 345.5 276.7C337.6 273.6 328.1 272 320 272C280.2 272 248 304.2 248 344V440C248 462.1 230.1 480 208 480H176C153.9 480 136 462.1 136 440V344C136 304.2 103.8 272 64 272H40C35.58 272 32 268.4 32 264C32 259.6 35.58 256 40 256L64 256zM507.3 368L557.7 418.3C560.8 421.5 560.8 426.5 557.7 429.7C554.5 432.8 549.5 432.8 546.3 429.7L496 379.3L445.7 429.7C442.5 432.8 437.5 432.8 434.3 429.7C431.2 426.5 431.2 421.5 434.3 418.3L484.7 368L434.3 317.7C431.2 314.5 431.2 309.5 434.3 306.3C437.5 303.2 442.5 303.2 445.7 306.3L496 356.7L546.3 306.3C549.5 303.2 554.5 303.2 557.7 306.3C560.8 309.5 560.8 314.5 557.7 317.7L507.3 368zM640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368zM496 240C425.3 240 368 297.3 368 368C368 438.7 425.3 496 496 496C566.7 496 624 438.7 624 368C624 297.3 566.7 240 496 240z"],
    "bridge-lock": [640, 512, [], "e4cc", "M600 32C604.4 32 608 35.58 608 40C608 44.42 604.4 48 600 48H520V144H600C604.4 144 608 147.6 608 152C608 156.4 604.4 160 600 160H40C35.58 160 32 156.4 32 152C32 147.6 35.58 144 40 144H120V48H40C35.58 48 32 44.42 32 40C32 35.58 35.58 32 40 32H600zM504 48H392V144H504V48zM264 48V144H376V48H264zM248 48H136V144H248V48zM320 272C280.2 272 248 304.2 248 344V440C248 462.1 230.1 480 208 480H176C153.9 480 136 462.1 136 440V344C136 304.2 103.8 272 64 272H40C35.58 272 32 268.4 32 264C32 259.6 35.58 256 40 256H64C112.6 256 152 295.4 152 344V440C152 453.3 162.7 464 176 464H208C221.3 464 232 453.3 232 440V344C232 295.4 271.4 256 320 256C356.1 256 387.1 277.8 400.7 308.9C396.2 313.8 392.4 319.5 389.6 325.7C381.5 294.8 353.4 272 320 272zM528 192C563.3 192 592 220.7 592 256V320H608C625.7 320 640 334.3 640 352V480C640 497.7 625.7 512 608 512H448C430.3 512 416 497.7 416 480V352C416 334.3 430.3 320 448 320H464V256C464 220.7 492.7 192 528 192zM528 208C501.5 208 480 229.5 480 256V320H576V256C576 229.5 554.5 208 528 208zM432 352V480C432 488.8 439.2 496 448 496H608C616.8 496 624 488.8 624 480V352C624 343.2 616.8 336 608 336H448C439.2 336 432 343.2 432 352z"],
    "bridge-suspension": [640, 512, [], "e4cd", "M128 0C131.2 0 133.1 1.871 135.2 4.578L141.9 17.94C175.6 85.39 244.6 128 320 128C395.4 128 464.4 85.39 498.1 17.94L504.8 4.577C506.1 1.871 508.8 0 512 0C515.6 0 518.6 2.373 519.6 5.64C527.2 28.34 542.6 53.35 561.1 75.05C581.4 96.83 604.5 114.7 626.1 123.6C631.1 125.2 633.1 129.9 631.4 134C629.8 138.1 625.2 140.1 621 138.5C595.5 128.4 570.6 108.7 550 85.71C538.6 72.86 528.3 58.79 520 44.47V256H632C636.4 256 640 259.6 640 264C640 268.4 636.4 272 632 272H8C3.582 272 0 268.4 0 264C0 259.6 3.582 256 8 256H120V44.47C111.7 58.79 101.4 72.86 89.97 85.71C69.43 108.7 44.45 128.4 18.95 138.5C14.84 140.1 10.19 138.1 8.564 134C6.935 129.9 8.942 125.2 13.05 123.6C35.55 114.7 58.57 96.83 78.03 75.05C97.43 53.35 112.8 28.34 120.4 5.641C121.4 2.374 124.4 .0003 128 .0003L128 0zM136 256H216V120C216 119.1 216.1 118.2 216.4 117.4C183.7 99.47 155.8 73.08 136 40.32V256zM232 256H312V144L312 143.9C283.9 142.8 256.8 136.3 232 125.2V256zM328 256H408V125.2C383.2 136.3 356.1 142.8 328 143.9L328 144V256zM424 256H504V40.32C484.2 73.08 456.3 99.47 423.6 117.4C423.8 118.2 424 119.1 424 120V256zM32 336C80.6 336 120 375.4 120 424V472C120 485.3 130.7 496 144 496H176C189.3 496 200 485.3 200 472V456C200 389.7 253.7 336 320 336C386.3 336 440 389.7 440 456V472C440 485.3 450.7 496 464 496H496C509.3 496 520 485.3 520 472V424C520 375.4 559.4 336 608 336H632C636.4 336 640 339.6 640 344C640 348.4 636.4 352 632 352H608C568.2 352 536 384.2 536 424V472C536 494.1 518.1 512 496 512H464C441.9 512 424 494.1 424 472V456C424 398.6 377.4 352 320 352C262.6 352 216 398.6 216 456V472C216 494.1 198.1 512 176 512H144C121.9 512 104 494.1 104 472V424C104 384.2 71.76 352 32 352H8C3.582 352 0 348.4 0 344C0 339.6 3.582 336 8 336H32z"],
    "bridge-water": [576, 512, [], "e4ce", "M544 80H32C23.16 80 16 87.16 16 96V163.6C16 170.4 21.57 176 28.44 176C74.59 176 112 213.4 112 259.6V354.5C106.8 353.1 101.4 352.4 96 352.5V259.6C96 222.2 65.75 192 28.44 192C12.74 192 .0003 179.3 .0003 163.6V96C.0003 78.33 14.33 64 32 64H544C561.7 64 576 78.33 576 96V163.6C576 179.3 563.3 192 547.6 192C510.2 192 480 222.2 480 259.6V352.5C474.6 352.5 469.3 353.1 464 354.5V259.6C464 213.4 501.4 176 547.6 176C554.4 176 560 170.4 560 163.6V96C560 87.16 552.8 80 544 80V80zM192 384.5V272C192 218.1 234.1 176 288 176C341 176 384 218.1 384 272V384.5C378.8 384.5 373.4 383.9 368 382.8V272C368 227.8 332.2 192 288 192C243.8 192 208 227.8 208 272V382.9C202.7 383.9 197.4 384.5 192 384.5V384.5zM294.6 403.4C302.6 414.6 312.1 424.9 322.2 434.1C339.5 449.8 361.5 464 384 464C406.5 464 428.6 449.8 445.8 434.1C455.1 424.9 465.5 414.6 473.5 403.4C474.1 401.3 477.4 400 480 400C482.6 400 485.1 401.3 486.6 403.4C493.9 413.7 502.5 423 511.6 431.7C527.3 446.5 547.7 460.9 569 463.6C573.4 464.1 576.5 468.1 575.9 472.5C575.4 476.9 571.4 479.1 567 479.4C540.5 476.1 516.1 458.7 500.6 443.3C491.8 434.1 484.7 426.9 480 421.1C474.8 427.5 466.8 436.7 456.6 445.9C438.7 462.2 412.7 480 384 480C355.3 480 329.4 462.2 311.4 445.9C301.3 436.7 293.2 427.5 288 421.1L288 421.1L287.1 421.1C282.8 427.5 274.7 436.7 264.6 445.9C246.6 462.2 220.7 480 191.1 480C163.3 480 137.4 462.2 119.4 445.9C109.2 436.7 101.2 427.5 95.98 421.1C91.29 426.9 84.23 434.1 75.4 443.3C59.03 458.7 35.48 476.1 9.001 479.4C4.617 479.1 .616 476.9 .0637 472.5C-.4887 468.1 2.617 464.1 7.001 463.6C28.3 460.9 48.74 446.5 64.42 431.7C73.56 423 82.16 413.7 89.43 403.4C90.93 401.3 93.37 400 95.98 400C98.59 400 101 401.3 102.5 403.4C110.5 414.6 120 424.9 130.2 434.1C147.4 449.8 169.5 464 191.1 464C214.5 464 236.6 449.8 253.8 434.1C263.9 424.9 273.4 414.6 281.4 403.4C284.4 399.1 291.6 399.1 294.6 403.4H294.6z"],
    "briefcase": [512, 512, [128188], "f0b1", "M464 96H384V40C384 17.94 366.1 0 344 0h-176C145.9 0 128 17.94 128 40V96H48C21.49 96 0 117.5 0 144v288C0 458.5 21.49 480 48 480h416c26.51 0 48-21.49 48-48v-288C512 117.5 490.5 96 464 96zM144 40c0-13.22 10.78-24 24-24h176c13.22 0 24 10.78 24 24V96h-224V40zM496 432c0 17.64-14.36 32-32 32h-416c-17.64 0-32-14.36-32-32v-160h160v56C176 341.2 186.8 352 200 352h112c13.22 0 24-10.78 24-24V272h160V432zM320 272v56c0 4.406-3.594 8-8 8h-112C195.6 336 192 332.4 192 328V272H320zM16 256V144c0-17.64 14.36-32 32-32h416c17.64 0 32 14.36 32 32V256H16z"],
    "briefcase-arrow-right": [512, 512, [], "e2f2", "M464 96H384V40C384 17.94 366.1 0 344 0h-176C145.9 0 128 17.94 128 40V96H48C21.49 96 0 117.5 0 144v288C0 458.5 21.49 480 48 480h416c26.51 0 48-21.49 48-48v-288C512 117.5 490.5 96 464 96zM144 40c0-13.22 10.78-24 24-24h176c13.22 0 24 10.78 24 24V96h-224V40zM496 432c0 17.64-14.36 32-32 32h-416c-17.64 0-32-14.36-32-32v-288c0-17.64 14.36-32 32-32h416c17.64 0 32 14.36 32 32V432zM279.3 194.3c-3.125-3.125-8.188-3.125-11.31 0s-3.125 8.188 0 11.31L342.3 280H150.4c-4.407 0-8 3.578-8 8s3.593 8 8 8h191.9l-74.34 74.34c-3.125 3.125-3.125 8.188 0 11.31C269.5 383.2 271.5 384 273.6 384s4.094-.7813 5.656-2.344l88-88c3.125-3.125 3.125-8.188 0-11.31L279.3 194.3z"],
    "briefcase-blank": [512, 512, [], "e0c8", "M464 96H384V40C384 17.94 366.1 0 344 0h-176C145.9 0 128 17.94 128 40V96H48C21.49 96 0 117.5 0 144v288C0 458.5 21.49 480 48 480h416c26.51 0 48-21.49 48-48v-288C512 117.5 490.5 96 464 96zM144 40c0-13.22 10.78-24 24-24h176c13.22 0 24 10.78 24 24V96h-224V40zM496 432c0 17.64-14.36 32-32 32h-416c-17.64 0-32-14.36-32-32v-288c0-17.64 14.36-32 32-32h416c17.64 0 32 14.36 32 32V432z"],
    "briefcase-medical": [512, 512, [], "f469", "M464 96H384V40C384 17.94 366.1 0 344 0h-176C145.9 0 128 17.94 128 40V96H48C21.49 96 0 117.5 0 144v288C0 458.5 21.49 480 48 480h416c26.51 0 48-21.49 48-48v-288C512 117.5 490.5 96 464 96zM144 40c0-13.22 10.78-24 24-24h176c13.22 0 24 10.78 24 24V96h-224V40zM496 432c0 17.64-14.36 32-32 32h-416c-17.64 0-32-14.36-32-32v-288c0-17.64 14.36-32 32-32h416c17.64 0 32 14.36 32 32V432zM344 247.1h-48v-48c0-8.836-7.164-16-16-16h-48c-8.836 0-16 7.164-16 16v48h-48c-8.836 0-16 7.164-16 16v48c0 8.836 7.164 16 16 16h48v48c0 8.836 7.164 16 16 16h48c8.836 0 16-7.164 16-16v-48h48c8.836 0 16-7.164 16-16v-48C360 255.1 352.8 247.1 344 247.1zM344 311.1h-64v64h-48v-64h-64v-48h64v-64h48v64h64V311.1z"],
    "brightness": [512, 512, [], "e0c9", "M248 8C248 3.582 251.6 0 256 0C260.4 0 264 3.582 264 8V104C264 108.4 260.4 112 256 112C251.6 112 248 108.4 248 104V8zM160 256C160 202.1 202.1 160 256 160C309 160 352 202.1 352 256C352 309 309 352 256 352C202.1 352 160 309 160 256zM256 336C300.2 336 336 300.2 336 256C336 211.8 300.2 176 256 176C211.8 176 176 211.8 176 256C176 300.2 211.8 336 256 336zM256 512C251.6 512 248 508.4 248 504V408C248 403.6 251.6 400 256 400C260.4 400 264 403.6 264 408V504C264 508.4 260.4 512 256 512zM0 256C0 251.6 3.582 248 8 248H104C108.4 248 112 251.6 112 256C112 260.4 108.4 264 104 264H8C3.582 264 0 260.4 0 256zM504 248C508.4 248 512 251.6 512 256C512 260.4 508.4 264 504 264H408C403.6 264 400 260.4 400 256C400 251.6 403.6 248 408 248H504zM74.98 437C71.86 433.9 71.86 428.8 74.98 425.7L142.9 357.8C145.1 354.7 151.1 354.7 154.2 357.8C157.3 360.9 157.3 366 154.2 369.1L86.29 437C83.17 440.1 78.1 440.1 74.98 437V437zM425.7 74.98C428.8 71.86 433.9 71.86 437 74.98C440.1 78.1 440.1 83.17 437 86.29L369.1 154.2C366 157.3 360.9 157.3 357.8 154.2C354.7 151.1 354.7 145.1 357.8 142.9L425.7 74.98zM74.98 74.98C78.1 71.86 83.17 71.86 86.29 74.98L154.2 142.9C157.3 145.1 157.3 151.1 154.2 154.2C151.1 157.3 145.1 157.3 142.9 154.2L74.98 86.29C71.86 83.17 71.86 78.1 74.98 74.98V74.98zM437 425.7C440.1 428.8 440.1 433.9 437 437C433.9 440.1 428.8 440.1 425.7 437L357.8 369.1C354.7 366 354.7 360.9 357.8 357.8C360.9 354.7 366 354.7 369.1 357.8L437 425.7z"],
    "brightness-low": [448, 512, [], "e0ca", "M240 80C240 88.84 232.8 96 224 96C215.2 96 208 88.84 208 80C208 71.16 215.2 64 224 64C232.8 64 240 71.16 240 80zM128 256C128 202.1 170.1 160 224 160C277 160 320 202.1 320 256C320 309 277 352 224 352C170.1 352 128 309 128 256zM224 336C268.2 336 304 300.2 304 256C304 211.8 268.2 176 224 176C179.8 176 144 211.8 144 256C144 300.2 179.8 336 224 336zM208 432C208 423.2 215.2 416 224 416C232.8 416 240 423.2 240 432C240 440.8 232.8 448 224 448C215.2 448 208 440.8 208 432zM400 272C391.2 272 384 264.8 384 256C384 247.2 391.2 240 400 240C408.8 240 416 247.2 416 256C416 264.8 408.8 272 400 272zM48 240C56.84 240 64 247.2 64 256C64 264.8 56.84 272 48 272C39.16 272 32 264.8 32 256C32 247.2 39.16 240 48 240zM112 128C112 136.8 104.8 144 96 144C87.16 144 80 136.8 80 128C80 119.2 87.16 112 96 112C104.8 112 112 119.2 112 128zM352 400C343.2 400 336 392.8 336 384C336 375.2 343.2 368 352 368C360.8 368 368 375.2 368 384C368 392.8 360.8 400 352 400zM368 128C368 136.8 360.8 144 352 144C343.2 144 336 136.8 336 128C336 119.2 343.2 112 352 112C360.8 112 368 119.2 368 128zM96 368C104.8 368 112 375.2 112 384C112 392.8 104.8 400 96 400C87.16 400 80 392.8 80 384C80 375.2 87.16 368 96 368z"],
    "bring-forward": [512, 512, [], "f856", "M224 496H448C474.5 496 496 474.5 496 448V224C496 197.5 474.5 176 448 176H392C387.6 176 384 172.4 384 168C384 163.6 387.6 160 392 160H448C483.3 160 512 188.7 512 224V448C512 483.3 483.3 512 448 512H224C188.7 512 160 483.3 160 448V392C160 387.6 163.6 384 168 384C172.4 384 176 387.6 176 392V448C176 474.5 197.5 496 224 496zM288 256C288 273.7 273.7 288 256 288H96C78.33 288 64 273.7 64 256V96C64 78.33 78.33 64 96 64H256C273.7 64 288 78.33 288 96V256zM272 96C272 87.16 264.8 80 256 80H96C87.16 80 80 87.16 80 96V256C80 264.8 87.16 272 96 272H256C264.8 272 272 264.8 272 256V96zM64 352C28.65 352 0 323.3 0 288V64C0 28.65 28.65 0 64 0H288C323.3 0 352 28.65 352 64V288C352 323.3 323.3 352 288 352H64zM288 336C314.5 336 336 314.5 336 288V64C336 37.49 314.5 16 288 16H64C37.49 16 16 37.49 16 64V288C16 314.5 37.49 336 64 336H288z"],
    "bring-front": [640, 512, [], "f857", "M16 64V192C16 218.5 37.49 240 64 240H120C124.4 240 128 243.6 128 248C128 252.4 124.4 256 120 256H64C28.65 256 0 227.3 0 192V64C0 28.65 28.65 0 64 0H192C224.6 0 251.6 24.44 255.5 56.02C256.1 60.4 252.4 64 248 64C243.6 64 240.1 60.39 239.3 56.03C235.5 33.32 215.8 16 192 16H64C37.49 16 16 37.49 16 64zM448 512C415.4 512 388.4 487.6 384.5 455.1C383.9 451.6 387.6 448 392 448C396.4 448 399.9 451.6 400.7 455.1C404.5 478.7 424.2 496 448 496H576C602.5 496 624 474.5 624 448V320C624 293.5 602.5 272 576 272H520C515.6 272 512 268.4 512 264C512 259.6 515.6 256 520 256H576C611.3 256 640 284.7 640 320V448C640 483.3 611.3 512 576 512H448zM224 192C224 174.3 238.3 160 256 160H384C401.7 160 416 174.3 416 192V320C416 337.7 401.7 352 384 352H256C238.3 352 224 337.7 224 320V192zM240 192V320C240 328.8 247.2 336 256 336H384C392.8 336 400 328.8 400 320V192C400 183.2 392.8 176 384 176H256C247.2 176 240 183.2 240 192zM416 96C451.3 96 480 124.7 480 160V352C480 387.3 451.3 416 416 416H224C188.7 416 160 387.3 160 352V160C160 124.7 188.7 96 224 96H416zM416 112H224C197.5 112 176 133.5 176 160V352C176 378.5 197.5 400 224 400H416C442.5 400 464 378.5 464 352V160C464 133.5 442.5 112 416 112z"],
    "broccoli": [512, 512, [129382], "e3e2", "M443.9 158.3c4.031-8.844 6.125-18.39 6.125-28.12c0-38.09-31.41-69.09-69.1-69.09c-9.906 0-19.66 2.094-28.66 6.141C337.5 27.17 299.7 0 256 0S174.5 27.17 160.7 67.23C151.7 63.19 141.9 61.09 132 61.09c-38.59 0-70 31-70 69.09c0 9.734 2.094 19.28 6.125 28.12C27.53 171.1 0 209.3 0 252.4C0 307.3 45.31 352 101 352h7.186C179.3 438 177.6 512 192 512c4.837 0 7.992-4.013 7.992-7.988c0-2.662-15.27-77.85-71.49-152h67.88C244 414.7 242.6 448 256 448c13.29 0 12.23-33.61 59.62-96h67.87c-56.12 73.99-71.48 149.4-71.48 152C312 507.1 315.2 512 320 512c14.25 0 11.51-71.27 83.76-160H411C466.7 352 512 307.3 512 252.4C512 209.3 484.5 171.1 443.9 158.3zM256 421.2C240.1 388.4 225.7 365.8 216.1 352h79.76C286.3 365.8 271.9 388.4 256 421.2zM411 336h-310C54.13 336 16 298.5 16 252.4c0-39.02 27.06-72.44 65.78-81.28c3.54-.7987 6.225-3.963 6.225-7.78c0-5.504-10.01-13.08-10.01-33.11c0-29.28 24.22-53.09 54-53.09c20.53 0 27.9 9.867 33.6 9.867c3.596 0 6.908-2.491 7.773-6.18C182.3 42.64 216.3 16 256 16s73.66 26.64 82.63 64.78c.868 3.7 4.192 6.18 7.773 6.18c5.685 0 13.07-9.867 33.6-9.867c29.78 0 53.1 23.81 53.1 53.09c0 19.98-10.01 27.6-10.01 33.11c0 3.818 2.686 6.982 6.225 7.78C468.9 179.9 496 213.3 496 252.4C496 298.5 457.9 336 411 336z"],
    "broom": [640, 512, [129529], "f51a", "M329.9 340c-7.595 30.23-27.08 90.34-67.52 122.7c-48.55 38.68-205.8 33.91-244.1 31.99c1.622-9.029 4.524-24.4 8.642-42.9l90.79-107.7c4.118-4.905 4.43-11.68 .7488-16.9C113.1 322 107.5 319.9 101.6 322.2l-42.68 15.57c14.38-37.79 29.36-63.05 44.65-75.2c40.49-32.26 103.4-37.83 134.5-38.46c6.628-.1347 10.19-7.799 6.07-12.1c-1.54-1.945-3.847-3.081-6.326-3.04C204.7 208.6 138.2 214.5 93.6 250C73.82 265.7 55.13 298.9 38 348.5c-.9984 2.921-.2496 6.155 1.966 8.31c2.153 2.156 5.335 2.874 8.33 1.812l51.11-18.65l-86.83 103C11.76 443.1 11.17 445.1 10.89 446.4c-7.02 31.29-10.76 54.31-10.8 54.53c-.3432 2.234 .2496 4.499 1.654 6.264s3.463 2.843 5.71 2.999C10.39 510.4 36.29 512 71.36 512c65.14 0 161.9-5.655 200.1-36.8c44.55-35.61 65.17-99.12 73.15-131.3c.5987-2.408 .0137-4.913-1.529-6.856C339.8 331.8 331.5 333.6 329.9 340zM638.3 3.101c-2.714-3.515-7.738-4.124-11.2-1.406L380.3 193.9l-44.32-55.92c0-.0313 0 .0156 0 0c-3.994-4.936-9.906-7.357-16.49-6.733C313.2 132 307.8 135.9 305 141.8L281.3 193C280 195.7 280.4 198.1 282.3 201.3L363.8 304.1C365.3 306 367.6 307.1 370 307.1c.5616 0 1.123-.0625 1.654-.1718l55.13-11.75c6.24-1.281 11.26-5.608 13.45-11.59c2.184-6.014 1.154-12.61-2.839-17.67L390.3 206.4l246.7-192.1C640.4 11.61 641 6.585 638.3 3.101zM424.9 275.8c.6864 .8904 .5304 1.781 .3432 2.249c-.1872 .5311-.624 1.203-1.685 1.422l-50.36 10.73L297.9 195.3l21.59-46.71c.5304-1.062 1.435-1.328 1.934-1.39c.624-.1406 1.466 .0469 2.122 .8591L424.9 275.8z"],
    "broom-ball": [640, 512, ["quidditch", "quidditch-broom-ball"], "f458", "M264.3 212.9C262.9 211.2 260.9 210.1 258.6 209.9C254.4 209.6 154 203.6 93.94 251.4c-19.94 15.76-38.72 48.78-55.84 98.09c-.1 2.922-.25 6.156 1.937 8.327c2.187 2.156 5.406 2.875 8.375 1.812l51.12-18.62l-86.9 102.3c-.8437 .9843-1.437 2.156-1.719 3.422c-7.031 31.22-10.75 53.98-10.81 54.2c-.3437 2.234 .25 4.515 1.656 6.281c1.406 1.765 3.469 2.859 5.719 2.1C10.41 510.4 36.19 512 71.16 512c65.34 0 162.6-5.609 201.8-36.54c60.22-47.62 76.97-146.2 77.65-150.4c.3438-2.234-.25-4.515-1.656-6.296L264.3 212.9zM262.1 462.9c-48.53 38.37-206.2 33.68-245.6 31.81c1.625-8.984 4.562-24.17 8.656-42.56l91.03-107.1c4.094-4.859 4.406-11.61 .75-16.81c-3.625-5.187-9.1-7.312-16.09-5.062l-42.72 15.56c14.34-37.48 29.41-62.6 44.81-74.78c0-.0156 0 0 0 0C153.2 224.7 236.2 225.2 254.1 225.8l80.03 100.1C330.7 343.5 312.5 423.8 262.1 462.9zM495.1 351.1c-44.18 0-79.1 35.73-79.1 79.91s35.82 80.09 79.1 80.09c44.18 0 79.1-35.91 79.1-80.09S540.2 351.1 495.1 351.1zM495.1 495.9c-35.29 0-63.1-28.71-63.1-63.99s28.71-63.99 63.1-63.99s63.1 28.71 63.1 63.99S531.3 495.9 495.1 495.9zM638.4 11.18c-2.625-3.531-7.656-4.203-11.22-1.609L380.1 194.9l-46.31-58c-4.094-5.046-10.44-7.484-16.81-6.828c-6.469 .7656-11.1 4.734-14.81 10.64L277.4 193.6c-1.875 3.1-.1562 8.765 3.875 10.64c4.062 1.953 8.75 .1562 10.62-3.859l24.72-52.87c.5937-1.203 1.656-1.5 2.219-1.578c.7187-.0469 1.687 0 2.469 .953l105.2 131.7c.7813 .9843 .6562 1.953 .4375 2.578c-.1875 .5156-.7187 1.437-2.031 1.703l-57.28 11.98c-4.344 .9062-7.125 5.14-6.219 9.468c.8125 3.765 4.125 6.359 7.844 6.359c.5312 0 1.094-.0469 1.625-.1719l57.25-11.97c6.406-1.312 11.59-5.75 13.84-11.89c2.219-6.14 1.125-12.87-2.969-18.01l-48.9-61.24l246.7-185C640.3 19.73 641.1 14.71 638.4 11.18z"],
    "browser": [512, 512, [128468], "f37e", "M0 96C0 60.65 28.65 32 64 32H448C483.3 32 512 60.65 512 96V416C512 451.3 483.3 480 448 480H64C28.65 480 0 451.3 0 416V96zM128 144H496V96C496 69.49 474.5 48 448 48H128V144zM112 48H64C37.49 48 16 69.49 16 96V144H112V48zM16 160V416C16 442.5 37.49 464 64 464H448C474.5 464 496 442.5 496 416V160H16z"],
    "browsers": [576, 512, [], "e0cb", "M512 0C547.3 0 576 28.65 576 64V352C576 387.3 547.3 416 512 416H160C124.7 416 96 387.3 96 352V64C96 28.65 124.7 0 160 0H512zM512 16H200V96H560V64C560 37.49 538.5 16 512 16zM112 64V96H184V16H160C133.5 16 112 37.49 112 64zM160 400H512C538.5 400 560 378.5 560 352V112H112V352C112 378.5 133.5 400 160 400zM16 392C16 449.4 62.56 496 120 496H472C476.4 496 480 499.6 480 504C480 508.4 476.4 512 472 512H120C53.73 512 0 458.3 0 392V104C0 99.58 3.582 96 8 96C12.42 96 16 99.58 16 104V392z"],
    "brush": [384, 512, [], "f55d", "M208 448C208 456.8 200.8 464 192 464C183.2 464 176 456.8 176 448C176 439.2 183.2 432 192 432C200.8 432 208 439.2 208 448zM0 288V64C0 28.65 28.65 0 64 0H320C355.3 0 384 28.65 384 64V288C384 332.2 348.2 368 304 368H256V448C256 483.3 227.3 512 192 512C156.7 512 128 483.3 128 448V368H80C35.82 368 0 332.2 0 288zM304 352C339.3 352 368 323.3 368 288V272H16V288C16 323.3 44.65 352 80 352H144V448C144 474.5 165.5 496 192 496C218.5 496 240 474.5 240 448V352H304zM368 64C368 37.49 346.5 16 320 16H272V104C272 108.4 268.4 112 264 112C259.6 112 256 108.4 256 104V16H192V88C192 92.42 188.4 96 184 96C179.6 96 176 92.42 176 88V16H96V120C96 124.4 92.42 128 88 128C83.58 128 80 124.4 80 120V16H64C37.49 16 16 37.49 16 64V256H368V64z"],
    "bucket": [448, 512, [], "e4cf", "M80 160C80 164.4 76.42 168 72 168C67.58 168 64 164.4 64 160V136C64 60.89 124.9 0 200 0H248C323.1 0 384 60.89 384 136V152C384 156.4 380.4 160 376 160C371.6 160 368 156.4 368 152V136C368 69.73 314.3 16 248 16H200C133.7 16 80 69.73 80 136V160zM.0003 200C.0003 195.6 3.582 192 8 192H440C444.4 192 448 195.6 448 200C448 204.4 444.4 208 440 208H422L389.3 469.1C386.3 493.1 365.8 512 341.6 512H106.4C82.17 512 61.75 493.1 58.74 469.1L26 208H8C3.582 208 0 204.4 0 200H.0003zM74.62 467.1C76.62 483.1 90.24 496 106.4 496H341.6C357.8 496 371.4 483.1 373.4 467.1L405.9 208H42.12L74.62 467.1z"],
    "bug": [512, 512, [], "f188", "M160 96C160 42.98 202.1 0 256 0C309 0 352 42.98 352 96V99.56C352 115.3 339.3 128 323.6 128H188.4C172.7 128 160 115.3 160 99.56V96zM256 16C211.8 16 176 51.82 176 96V99.56C176 106.4 181.6 112 188.4 112H323.6C330.4 112 336 106.4 336 99.56V96C336 51.82 300.2 16 256 16zM34.34 98.34C37.47 95.22 42.53 95.22 45.66 98.34L132.3 185C150.5 169.4 174.2 160 200 160H312C337.8 160 361.5 169.4 379.7 185L466.3 98.34C469.5 95.22 474.5 95.22 477.7 98.34C480.8 101.5 480.8 106.5 477.7 109.7L390.1 196.3C406.6 214.5 416 238.2 416 263.1V279.1H504C508.4 279.1 512 283.6 512 287.1C512 292.4 508.4 295.1 504 295.1H416V319.1C416 353.2 405.9 383.9 388.7 409.5C389 409.7 389.3 410 389.7 410.3L477.7 498.3C480.8 501.5 480.8 506.5 477.7 509.7C474.5 512.8 469.5 512.8 466.3 509.7L379 422.3C349.7 457.6 305.4 480 255.1 480C206.6 480 162.3 457.6 132.1 422.3L45.66 509.7C42.53 512.8 37.47 512.8 34.34 509.7C31.22 506.5 31.22 501.5 34.34 498.3L122.3 410.3C122.7 410 122.1 409.7 123.3 409.5C106.1 383.9 96 353.2 96 319.1V295.1H8C3.582 295.1 0 292.4 0 287.1C0 283.6 3.582 279.1 8 279.1H96V263.1C96 238.2 105.4 214.5 121 196.3L34.34 109.7C31.22 106.5 31.22 101.5 34.34 98.34H34.34zM264 232V463.8C339.8 459.6 400 396.8 400 320V264C400 215.4 360.6 176 312 176H200C151.4 176 112 215.4 112 264V320C112 396.8 172.2 459.6 248 463.8V232C248 227.6 251.6 224 256 224C260.4 224 264 227.6 264 232V232z"],
    "bug-slash": [640, 512, [], "e490", "M636.1 497.7C640.4 500.5 641 505.5 638.3 508.1C635.5 512.4 630.5 513 627 510.3L3.022 14.26C-.4365 11.51-1.012 6.481 1.738 3.022C4.487-.4365 9.52-1.012 12.98 1.738L636.1 497.7zM418.2 425.3L430.9 435.3C402.2 462.1 363.1 480 320 480C270.6 480 226.3 457.6 196.1 422.3L109.7 509.7C106.5 512.8 101.5 512.8 98.34 509.7C95.22 506.5 95.22 501.5 98.34 498.3L186.3 410.3C186.7 410 186.1 409.7 187.3 409.5C170.1 383.9 160 353.2 160 320V296H72C67.58 296 64 292.4 64 288C64 283.6 67.58 280 72 280H160V264C160 250.9 162.4 238.4 166.8 226.8L180.1 237.3C177.4 245.7 176 254.7 176 264V320C176 396.8 236.2 459.6 312 463.8V341.4L328 354.1V463.8C362.8 461.9 394.3 447.6 418.2 425.3zM387.6 128H274.1L253.8 112H387.6C394.4 112 400 106.4 400 99.56V96C400 51.82 364.2 16 320 16C275.8 16 240 51.82 240 96V99.56C240 100.1 240 100.7 240.1 101.2L224.3 88.69C228 39.09 269.4 .0006 320 .0006C373 .0006 416 42.98 416 96V99.56C416 115.3 403.3 128 387.6 128H387.6zM443.7 185L530.3 98.34C533.5 95.22 538.5 95.22 541.7 98.34C544.8 101.5 544.8 106.5 541.7 109.7L454.1 196.3C470.6 214.5 480 238.2 480 264V280H568C572.4 280 576 283.6 576 288C576 292.4 572.4 296 568 296H486.9L464 277.1V264C464 215.4 424.6 176 376 176H334.9L314.6 160H376C401.8 160 425.5 169.4 443.7 185L443.7 185z"],
    "bugs": [576, 512, [], "e4d0", "M189.1 143.1H219.1L240.8 100.4C242.8 96.47 247.6 94.86 251.6 96.84C255.5 98.82 257.1 103.6 255.2 107.6L231.2 155.6C229.8 158.3 227 159.1 224 159.1L192 159.1V219.4L243.1 249.1C246.1 250.3 247.6 252.4 247.9 254.9L255.9 310.9C256.5 315.2 253.5 319.3 249.1 319.9C244.8 320.5 240.7 317.5 240.1 313.1L232.6 261L190.7 237C184.7 266.1 158.9 287.1 128 287.1C97.12 287.1 71.35 266.1 65.33 237L23.37 261L15.92 313.1C15.3 317.5 11.24 320.5 6.871 319.9C2.497 319.3-.5424 315.2 .0826 310.9L8.083 254.9C8.432 252.4 9.89 250.3 12.03 249.1L64 219.4V159.1H32C28.97 159.1 26.2 158.3 24.85 155.6L.8464 107.6C-1.13 103.6 .4723 98.82 4.424 96.84C8.376 94.86 13.18 96.47 15.16 100.4L36.95 143.1H66.02C70.99 124.7 84.76 108.9 102.8 101.2L64.64 11.12C62.91 7.049 64.81 2.353 68.88 .6287C72.95-1.095 77.64 .8044 79.37 4.872L118.3 96.73C121.5 96.25 124.7 95.1 128 95.1C131.3 95.1 134.5 96.25 137.7 96.73L176.6 4.872C178.4 .8044 183.1-1.096 187.1 .6287C191.2 2.353 193.1 7.049 191.4 11.12L153.2 101.2C171.2 108.9 185 124.7 189.1 143.1H189.1zM80 224.1C80.07 250.6 101.5 271.1 128 271.1C154.5 271.1 175.9 250.6 176 224.1L176 159.1C176 133.5 154.5 111.1 128 111.1C101.5 111.1 80 133.5 80 159.1L80 224.1zM343.1 347L294.8 346.8L262.3 388.2C259.6 391.7 254.5 392.3 251.1 389.6C247.6 386.8 246.1 381.8 249.7 378.3L284.6 333.8C286.2 331.9 288.5 330.8 290.1 330.8L350.8 331L380.5 279.6L352.8 263.6C350.2 262.1 348.6 259.2 348.8 256.2L352 202.7C352.3 198.2 356.1 194.9 360.5 195.1C364.9 195.4 368.3 199.2 367.1 203.6L365.1 252.2L390.2 266.8C404.2 252.5 424 245.8 443.5 248.1L455.5 151C456 146.6 460 143.5 464.4 144.1C468.8 144.6 471.9 148.6 471.4 152.1L459.2 251.1C462.1 253.2 465.1 254.6 467.9 256.2C470.8 257.9 473.5 259.7 475.1 261.7L555.6 201.6C559.1 198.9 564.2 199.7 566.8 203.2C569.5 206.7 568.8 211.7 565.2 214.4L487.2 273.3C498.9 288.1 502.1 309.6 497.6 328.8L522.8 343.3L563.4 316.5C567.1 314 572.1 315 574.5 318.7C576.1 322.4 575.9 327.4 572.3 329.8L527.5 359.4C524.9 361 521.7 361.1 519.1 359.6L491.4 343.6L461.7 395L491.8 446.7C493.1 448.9 493.3 451.5 492.3 453.8L471.3 506.2C469.6 510.3 464.1 512.3 460.9 510.7C456.8 509 454.8 504.4 456.4 500.3L476 451.4L451.7 409.7C431.9 431.9 398.7 437.9 371.9 422.5C345.2 407 333.8 375.2 343.1 347H343.1zM477.5 335.6C490.7 312.7 482.9 283.3 459.9 270.1C436.1 256.8 407.6 264.7 394.4 287.6L362.3 343.1C349.1 366.1 356.1 395.4 379.9 408.6C402.8 421.9 432.1 414.1 445.4 391.2L477.5 335.6z"],
    "building": [384, 512, [61687, 127970], "f1ad", "M136 232C149.3 232 160 242.7 160 256V288C160 301.3 149.3 312 136 312H104C90.75 312 80 301.3 80 288V256C80 242.7 90.75 232 104 232H136zM96 288C96 292.4 99.58 296 104 296H136C140.4 296 144 292.4 144 288V256C144 251.6 140.4 248 136 248H104C99.58 248 96 251.6 96 256V288zM224 256C224 242.7 234.7 232 248 232H280C293.3 232 304 242.7 304 256V288C304 301.3 293.3 312 280 312H248C234.7 312 224 301.3 224 288V256zM248 248C243.6 248 240 251.6 240 256V288C240 292.4 243.6 296 248 296H280C284.4 296 288 292.4 288 288V256C288 251.6 284.4 248 280 248H248zM136 104C149.3 104 160 114.7 160 128V160C160 173.3 149.3 184 136 184H104C90.75 184 80 173.3 80 160V128C80 114.7 90.75 104 104 104H136zM96 160C96 164.4 99.58 168 104 168H136C140.4 168 144 164.4 144 160V128C144 123.6 140.4 120 136 120H104C99.58 120 96 123.6 96 128V160zM224 128C224 114.7 234.7 104 248 104H280C293.3 104 304 114.7 304 128V160C304 173.3 293.3 184 280 184H248C234.7 184 224 173.3 224 160V128zM248 120C243.6 120 240 123.6 240 128V160C240 164.4 243.6 168 248 168H280C284.4 168 288 164.4 288 160V128C288 123.6 284.4 120 280 120H248zM48 512C21.49 512 0 490.5 0 464V48C0 21.49 21.49 0 48 0H336C362.5 0 384 21.49 384 48V464C384 490.5 362.5 512 336 512H48zM16 48V464C16 481.7 30.33 496 48 496H144V416C144 389.5 165.5 368 192 368C218.5 368 240 389.5 240 416V496H336C353.7 496 368 481.7 368 464V48C368 30.33 353.7 16 336 16H48C30.33 16 16 30.33 16 48zM160 496H224V416C224 398.3 209.7 384 192 384C174.3 384 160 398.3 160 416V496z"],
    "building-circle-arrow-right": [640, 512, [], "e4d1", "M16 48V464C16 481.7 30.33 496 48 496H144V416C144 389.5 165.5 368 192 368C218.5 368 240 389.5 240 416V496H336C346.8 496 356.4 490.6 362.2 482.4C365.7 486.5 369.4 490.4 373.3 494.2C364.5 505.1 351.1 512 336 512H48C21.49 512 0 490.5 0 464V48C0 21.49 21.49 0 48 0H336C362.5 0 384 21.49 384 48V232.2C378.4 236.9 373 241.9 368 247.2V48C368 30.33 353.7 16 336 16H48C30.33 16 16 30.33 16 48V48zM224 496V416C224 398.3 209.7 384 192 384C174.3 384 160 398.3 160 416V496H224zM136 232C149.3 232 160 242.7 160 256V288C160 301.3 149.3 312 136 312H104C90.75 312 80 301.3 80 288V256C80 242.7 90.75 232 104 232H136zM96 288C96 292.4 99.58 296 104 296H136C140.4 296 144 292.4 144 288V256C144 251.6 140.4 248 136 248H104C99.58 248 96 251.6 96 256V288zM224 256C224 242.7 234.7 232 248 232H280C293.3 232 304 242.7 304 256V288C304 301.3 293.3 312 280 312H248C234.7 312 224 301.3 224 288V256zM248 248C243.6 248 240 251.6 240 256V288C240 292.4 243.6 296 248 296H280C284.4 296 288 292.4 288 288V256C288 251.6 284.4 248 280 248H248zM136 104C149.3 104 160 114.7 160 128V160C160 173.3 149.3 184 136 184H104C90.75 184 80 173.3 80 160V128C80 114.7 90.75 104 104 104H136zM96 160C96 164.4 99.58 168 104 168H136C140.4 168 144 164.4 144 160V128C144 123.6 140.4 120 136 120H104C99.58 120 96 123.6 96 128V160zM224 128C224 114.7 234.7 104 248 104H280C293.3 104 304 114.7 304 128V160C304 173.3 293.3 184 280 184H248C234.7 184 224 173.3 224 160V128zM248 120C243.6 120 240 123.6 240 128V160C240 164.4 243.6 168 248 168H280C284.4 168 288 164.4 288 160V128C288 123.6 284.4 120 280 120H248zM498.3 298.3C501.5 295.2 506.5 295.2 509.7 298.3L573.7 362.3C576.8 365.5 576.8 370.5 573.7 373.7L509.7 437.7C506.5 440.8 501.5 440.8 498.3 437.7C495.2 434.5 495.2 429.5 498.3 426.3L548.7 376H424C419.6 376 416 372.4 416 368C416 363.6 419.6 360 424 360H548.7L498.3 309.7C495.2 306.5 495.2 301.5 498.3 298.3V298.3zM352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368zM496 496C566.7 496 624 438.7 624 368C624 297.3 566.7 240 496 240C425.3 240 368 297.3 368 368C368 438.7 425.3 496 496 496z"],
    "building-circle-check": [640, 512, [], "e4d2", "M16 48V464C16 481.7 30.33 496 48 496H144V416C144 389.5 165.5 368 192 368C218.5 368 240 389.5 240 416V496H336C346.8 496 356.4 490.6 362.2 482.4C365.7 486.5 369.4 490.4 373.3 494.2C364.5 505.1 351.1 512 336 512H48C21.49 512 0 490.5 0 464V48C0 21.49 21.49 0 48 0H336C362.5 0 384 21.49 384 48V232.2C378.4 236.9 373 241.9 368 247.2V48C368 30.33 353.7 16 336 16H48C30.33 16 16 30.33 16 48V48zM224 496V416C224 398.3 209.7 384 192 384C174.3 384 160 398.3 160 416V496H224zM136 232C149.3 232 160 242.7 160 256V288C160 301.3 149.3 312 136 312H104C90.75 312 80 301.3 80 288V256C80 242.7 90.75 232 104 232H136zM96 288C96 292.4 99.58 296 104 296H136C140.4 296 144 292.4 144 288V256C144 251.6 140.4 248 136 248H104C99.58 248 96 251.6 96 256V288zM224 256C224 242.7 234.7 232 248 232H280C293.3 232 304 242.7 304 256V288C304 301.3 293.3 312 280 312H248C234.7 312 224 301.3 224 288V256zM248 248C243.6 248 240 251.6 240 256V288C240 292.4 243.6 296 248 296H280C284.4 296 288 292.4 288 288V256C288 251.6 284.4 248 280 248H248zM136 104C149.3 104 160 114.7 160 128V160C160 173.3 149.3 184 136 184H104C90.75 184 80 173.3 80 160V128C80 114.7 90.75 104 104 104H136zM96 160C96 164.4 99.58 168 104 168H136C140.4 168 144 164.4 144 160V128C144 123.6 140.4 120 136 120H104C99.58 120 96 123.6 96 128V160zM224 128C224 114.7 234.7 104 248 104H280C293.3 104 304 114.7 304 128V160C304 173.3 293.3 184 280 184H248C234.7 184 224 173.3 224 160V128zM248 120C243.6 120 240 123.6 240 128V160C240 164.4 243.6 168 248 168H280C284.4 168 288 164.4 288 160V128C288 123.6 284.4 120 280 120H248zM565.7 322.3C568.8 325.5 568.8 330.5 565.7 333.7L485.7 413.7C482.5 416.8 477.5 416.8 474.3 413.7L426.3 365.7C423.2 362.5 423.2 357.5 426.3 354.3C429.5 351.2 434.5 351.2 437.7 354.3L480 396.7L554.3 322.3C557.5 319.2 562.5 319.2 565.7 322.3H565.7zM352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368zM496 496C566.7 496 624 438.7 624 368C624 297.3 566.7 240 496 240C425.3 240 368 297.3 368 368C368 438.7 425.3 496 496 496z"],
    "building-circle-exclamation": [640, 512, [], "e4d3", "M16 48V464C16 481.7 30.33 496 48 496H144V416C144 389.5 165.5 368 192 368C218.5 368 240 389.5 240 416V496H336C346.8 496 356.4 490.6 362.2 482.4C365.7 486.5 369.4 490.4 373.3 494.2C364.5 505.1 351.1 512 336 512H48C21.49 512 0 490.5 0 464V48C0 21.49 21.49 0 48 0H336C362.5 0 384 21.49 384 48V232.2C378.4 236.9 373 241.9 368 247.2V48C368 30.33 353.7 16 336 16H48C30.33 16 16 30.33 16 48V48zM224 496V416C224 398.3 209.7 384 192 384C174.3 384 160 398.3 160 416V496H224zM136 232C149.3 232 160 242.7 160 256V288C160 301.3 149.3 312 136 312H104C90.75 312 80 301.3 80 288V256C80 242.7 90.75 232 104 232H136zM96 288C96 292.4 99.58 296 104 296H136C140.4 296 144 292.4 144 288V256C144 251.6 140.4 248 136 248H104C99.58 248 96 251.6 96 256V288zM224 256C224 242.7 234.7 232 248 232H280C293.3 232 304 242.7 304 256V288C304 301.3 293.3 312 280 312H248C234.7 312 224 301.3 224 288V256zM248 248C243.6 248 240 251.6 240 256V288C240 292.4 243.6 296 248 296H280C284.4 296 288 292.4 288 288V256C288 251.6 284.4 248 280 248H248zM136 104C149.3 104 160 114.7 160 128V160C160 173.3 149.3 184 136 184H104C90.75 184 80 173.3 80 160V128C80 114.7 90.75 104 104 104H136zM96 160C96 164.4 99.58 168 104 168H136C140.4 168 144 164.4 144 160V128C144 123.6 140.4 120 136 120H104C99.58 120 96 123.6 96 128V160zM224 128C224 114.7 234.7 104 248 104H280C293.3 104 304 114.7 304 128V160C304 173.3 293.3 184 280 184H248C234.7 184 224 173.3 224 160V128zM248 120C243.6 120 240 123.6 240 128V160C240 164.4 243.6 168 248 168H280C284.4 168 288 164.4 288 160V128C288 123.6 284.4 120 280 120H248zM480 432C480 423.2 487.2 416 496 416C504.8 416 512 423.2 512 432C512 440.8 504.8 448 496 448C487.2 448 480 440.8 480 432zM495.1 280C500.4 280 503.1 283.6 503.1 288V384C503.1 388.4 500.4 392 495.1 392C491.6 392 487.1 388.4 487.1 384V288C487.1 283.6 491.6 280 495.1 280zM640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368zM496 240C425.3 240 368 297.3 368 368C368 438.7 425.3 496 496 496C566.7 496 624 438.7 624 368C624 297.3 566.7 240 496 240z"],
    "building-circle-xmark": [640, 512, [], "e4d4", "M16 48V464C16 481.7 30.33 496 48 496H144V416C144 389.5 165.5 368 192 368C218.5 368 240 389.5 240 416V496H336C346.8 496 356.4 490.6 362.2 482.4C365.7 486.5 369.4 490.4 373.3 494.2C364.5 505.1 351.1 512 336 512H48C21.49 512 0 490.5 0 464V48C0 21.49 21.49 0 48 0H336C362.5 0 384 21.49 384 48V232.2C378.4 236.9 373 241.9 368 247.2V48C368 30.33 353.7 16 336 16H48C30.33 16 16 30.33 16 48V48zM224 496V416C224 398.3 209.7 384 192 384C174.3 384 160 398.3 160 416V496H224zM136 232C149.3 232 160 242.7 160 256V288C160 301.3 149.3 312 136 312H104C90.75 312 80 301.3 80 288V256C80 242.7 90.75 232 104 232H136zM96 288C96 292.4 99.58 296 104 296H136C140.4 296 144 292.4 144 288V256C144 251.6 140.4 248 136 248H104C99.58 248 96 251.6 96 256V288zM224 256C224 242.7 234.7 232 248 232H280C293.3 232 304 242.7 304 256V288C304 301.3 293.3 312 280 312H248C234.7 312 224 301.3 224 288V256zM248 248C243.6 248 240 251.6 240 256V288C240 292.4 243.6 296 248 296H280C284.4 296 288 292.4 288 288V256C288 251.6 284.4 248 280 248H248zM136 104C149.3 104 160 114.7 160 128V160C160 173.3 149.3 184 136 184H104C90.75 184 80 173.3 80 160V128C80 114.7 90.75 104 104 104H136zM96 160C96 164.4 99.58 168 104 168H136C140.4 168 144 164.4 144 160V128C144 123.6 140.4 120 136 120H104C99.58 120 96 123.6 96 128V160zM224 128C224 114.7 234.7 104 248 104H280C293.3 104 304 114.7 304 128V160C304 173.3 293.3 184 280 184H248C234.7 184 224 173.3 224 160V128zM248 120C243.6 120 240 123.6 240 128V160C240 164.4 243.6 168 248 168H280C284.4 168 288 164.4 288 160V128C288 123.6 284.4 120 280 120H248zM557.7 418.3C560.8 421.5 560.8 426.5 557.7 429.7C554.5 432.8 549.5 432.8 546.3 429.7L496 379.3L445.7 429.7C442.5 432.8 437.5 432.8 434.3 429.7C431.2 426.5 431.2 421.5 434.3 418.3L484.7 368L434.3 317.7C431.2 314.5 431.2 309.5 434.3 306.3C437.5 303.2 442.5 303.2 445.7 306.3L496 356.7L546.3 306.3C549.5 303.2 554.5 303.2 557.7 306.3C560.8 309.5 560.8 314.5 557.7 317.7L507.3 368L557.7 418.3zM640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368zM496 240C425.3 240 368 297.3 368 368C368 438.7 425.3 496 496 496C566.7 496 624 438.7 624 368C624 297.3 566.7 240 496 240z"],
    "building-columns": [512, 512, ["bank", "institution", "museum", "university"], "f19c", "M252.7 .709C254.8-.2363 257.2-.2363 259.3 .709L497.9 108.5C506.5 112.3 512 120.9 512 130.3V136C512 149.3 501.3 160 488 160H24C10.75 160 0 149.3 0 136V130.3C0 120.9 5.525 112.3 14.12 108.5L252.7 .709zM488 144C492.4 144 496 140.4 496 136V130.3C496 127.2 494.2 124.3 491.3 123L256 16.78L20.71 123C17.84 124.3 16 127.2 16 130.3V136C16 140.4 19.58 144 24 144H223.1C218.1 137.3 216 129 216 119.1C216 97.91 233.9 79.1 256 79.1C278.1 79.1 296 97.91 296 119.1C296 129 293 137.3 288 144H488zM256 144C269.3 144 280 133.3 280 119.1C280 106.7 269.3 95.1 256 95.1C242.7 95.1 232 106.7 232 119.1C232 133.3 242.7 144 256 144zM72 192C76.42 192 80 195.6 80 200V368H184V200C184 195.6 187.6 192 192 192C196.4 192 200 195.6 200 200V368H312V200C312 195.6 315.6 192 320 192C324.4 192 328 195.6 328 200V368H432V200C432 195.6 435.6 192 440 192C444.4 192 448 195.6 448 200V376C448 380.4 444.4 384 440 384H72C67.58 384 64 380.4 64 376V200C64 195.6 67.58 192 72 192zM32 440C32 435.6 35.58 432 40 432H472C476.4 432 480 435.6 480 440C480 444.4 476.4 448 472 448H40C35.58 448 32 444.4 32 440zM.0003 504C.0003 499.6 3.582 496 8 496H504C508.4 496 512 499.6 512 504C512 508.4 508.4 512 504 512H8C3.582 512 .0003 508.4 .0003 504z"],
    "building-flag": [640, 512, [], "e4d5", "M136 232C149.3 232 160 242.7 160 256V288C160 301.3 149.3 312 136 312H104C90.75 312 80 301.3 80 288V256C80 242.7 90.75 232 104 232H136zM96 288C96 292.4 99.58 296 104 296H136C140.4 296 144 292.4 144 288V256C144 251.6 140.4 248 136 248H104C99.58 248 96 251.6 96 256V288zM224 256C224 242.7 234.7 232 248 232H280C293.3 232 304 242.7 304 256V288C304 301.3 293.3 312 280 312H248C234.7 312 224 301.3 224 288V256zM248 248C243.6 248 240 251.6 240 256V288C240 292.4 243.6 296 248 296H280C284.4 296 288 292.4 288 288V256C288 251.6 284.4 248 280 248H248zM136 104C149.3 104 160 114.7 160 128V160C160 173.3 149.3 184 136 184H104C90.75 184 80 173.3 80 160V128C80 114.7 90.75 104 104 104H136zM96 160C96 164.4 99.58 168 104 168H136C140.4 168 144 164.4 144 160V128C144 123.6 140.4 120 136 120H104C99.58 120 96 123.6 96 128V160zM224 128C224 114.7 234.7 104 248 104H280C293.3 104 304 114.7 304 128V160C304 173.3 293.3 184 280 184H248C234.7 184 224 173.3 224 160V128zM248 120C243.6 120 240 123.6 240 128V160C240 164.4 243.6 168 248 168H280C284.4 168 288 164.4 288 160V128C288 123.6 284.4 120 280 120H248zM48 512C21.49 512 0 490.5 0 464V48C0 21.49 21.49 0 48 0H336C362.5 0 384 21.49 384 48V464C384 490.5 362.5 512 336 512H48zM16 48V464C16 481.7 30.33 496 48 496H144V416C144 389.5 165.5 368 192 368C218.5 368 240 389.5 240 416V496H336C353.7 496 368 481.7 368 464V48C368 30.33 353.7 16 336 16H48C30.33 16 16 30.33 16 48zM224 496V416C224 398.3 209.7 384 192 384C174.3 384 160 398.3 160 416V496H224zM424 0C428.4 0 432 3.582 432 8V32H616C629.3 32 640 42.75 640 56V184C640 197.3 629.3 208 616 208H432V504C432 508.4 428.4 512 424 512C419.6 512 416 508.4 416 504V8C416 3.582 419.6 0 424 0zM432 192H616C620.4 192 624 188.4 624 184V56C624 51.58 620.4 48 616 48H432V192z"],
    "building-lock": [576, 512, [], "e4d6", "M15.1 48V464C15.1 481.7 30.33 496 47.1 496H143.1V416C143.1 389.5 165.5 368 191.1 368C218.5 368 239.1 389.5 239.1 416V496H322C323.5 501.7 325.7 507 328.6 512H48C21.49 512 0 490.5 0 464V48C0 21.49 21.49 0 48 0H336C362.5 0 384 21.49 384 48V193.6C377.9 199.8 372.5 206.8 368 214.3V48C368 30.33 353.7 16 336 16H48C30.33 16 16 30.33 16 48H15.1zM223.1 496V416C223.1 398.3 209.7 384 191.1 384C174.3 384 159.1 398.3 159.1 416V496H223.1zM135.1 232C149.3 232 159.1 242.7 159.1 256V288C159.1 301.3 149.3 312 135.1 312H103.1C90.74 312 79.1 301.3 79.1 288V256C79.1 242.7 90.74 232 103.1 232H135.1zM95.1 288C95.1 292.4 99.58 296 103.1 296H135.1C140.4 296 143.1 292.4 143.1 288V256C143.1 251.6 140.4 248 135.1 248H103.1C99.58 248 95.1 251.6 95.1 256V288zM223.1 256C223.1 242.7 234.7 232 247.1 232H279.1C293.3 232 304 242.7 304 256V288C304 301.3 293.3 312 279.1 312H247.1C234.7 312 223.1 301.3 223.1 288V256zM247.1 248C243.6 248 239.1 251.6 239.1 256V288C239.1 292.4 243.6 296 247.1 296H279.1C284.4 296 287.1 292.4 287.1 288V256C287.1 251.6 284.4 248 279.1 248H247.1zM135.1 104C149.3 104 159.1 114.7 159.1 128V160C159.1 173.3 149.3 184 135.1 184H103.1C90.74 184 79.1 173.3 79.1 160V128C79.1 114.7 90.74 104 103.1 104H135.1zM95.1 160C95.1 164.4 99.58 168 103.1 168H135.1C140.4 168 143.1 164.4 143.1 160V128C143.1 123.6 140.4 120 135.1 120H103.1C99.58 120 95.1 123.6 95.1 128V160zM223.1 128C223.1 114.7 234.7 104 247.1 104H279.1C293.3 104 304 114.7 304 128V160C304 173.3 293.3 184 279.1 184H247.1C234.7 184 223.1 173.3 223.1 160V128zM247.1 120C243.6 120 239.1 123.6 239.1 128V160C239.1 164.4 243.6 168 247.1 168H279.1C284.4 168 287.1 164.4 287.1 160V128C287.1 123.6 284.4 120 279.1 120H247.1zM464 192C499.3 192 528 220.7 528 256V320H544C561.7 320 576 334.3 576 352V480C576 497.7 561.7 512 544 512H384C366.3 512 352 497.7 352 480V352C352 334.3 366.3 320 384 320H400V256C400 220.7 428.7 192 464 192zM464 208C437.5 208 416 229.5 416 256V320H512V256C512 229.5 490.5 208 464 208zM368 352V480C368 488.8 375.2 496 384 496H544C552.8 496 560 488.8 560 480V352C560 343.2 552.8 336 544 336H384C375.2 336 368 343.2 368 352z"],
    "building-ngo": [384, 512, [], "e4d7", "M136 232C149.3 232 160 242.7 160 256V288C160 301.3 149.3 312 136 312H104C90.75 312 80 301.3 80 288V256C80 242.7 90.75 232 104 232H136zM96 288C96 292.4 99.58 296 104 296H136C140.4 296 144 292.4 144 288V256C144 251.6 140.4 248 136 248H104C99.58 248 96 251.6 96 256V288zM224 256C224 242.7 234.7 232 248 232H280C293.3 232 304 242.7 304 256V288C304 301.3 293.3 312 280 312H248C234.7 312 224 301.3 224 288V256zM248 248C243.6 248 240 251.6 240 256V288C240 292.4 243.6 296 248 296H280C284.4 296 288 292.4 288 288V256C288 251.6 284.4 248 280 248H248zM216 56C220.4 56 224 59.58 224 64C224 68.42 220.4 72 216 72H176V152H208V128C208 123.6 211.6 120 216 120C220.4 120 224 123.6 224 128V152C224 160.8 216.8 168 208 168H176C167.2 168 160 160.8 160 152V72C160 63.16 167.2 56 176 56H216zM256 96C256 73.91 273.9 56 296 56C318.1 56 336 73.91 336 96V128C336 150.1 318.1 168 296 168C273.9 168 256 150.1 256 128V96zM296 72C282.7 72 272 82.75 272 96V128C272 141.3 282.7 152 296 152C309.3 152 320 141.3 320 128V96C320 82.75 309.3 72 296 72zM112 133.6V64C112 59.58 115.6 56 120 56C124.4 56 128 59.58 128 64V160C128 163.5 125.7 166.6 122.3 167.7C118.9 168.7 115.3 167.4 113.3 164.4L64 90.42V160C64 164.4 60.42 168 56 168C51.58 168 48 164.4 48 160V64C48 60.47 50.31 57.36 53.68 56.34C57.06 55.32 60.7 56.63 62.66 59.56L112 133.6zM48 512C21.49 512 0 490.5 0 464V48C0 21.49 21.49 0 48 0H336C362.5 0 384 21.49 384 48V464C384 490.5 362.5 512 336 512H48zM16 48V464C16 481.7 30.33 496 48 496H144V416C144 389.5 165.5 368 192 368C218.5 368 240 389.5 240 416V496H336C353.7 496 368 481.7 368 464V48C368 30.33 353.7 16 336 16H48C30.33 16 16 30.33 16 48zM224 496V416C224 398.3 209.7 384 192 384C174.3 384 160 398.3 160 416V496H224z"],
    "building-shield": [576, 512, [], "e4d8", "M15.1 48V464C15.1 481.7 30.33 496 47.1 496H143.1V416C143.1 389.5 165.5 368 191.1 368C218.5 368 239.1 389.5 239.1 416V496H336C337.3 496 338.7 495.9 339.1 495.8C344.7 500 349.7 504.1 354.9 508.1C349.1 510.6 342.7 512 336 512H48C21.49 512 0 490.5 0 464V48C0 21.49 21.49 0 48 0H336C362.5 0 384 21.49 384 48V207L368 213.4V48C368 30.33 353.7 16 336 16H48C30.33 16 16 30.33 16 48L15.1 48zM223.1 496V416C223.1 398.3 209.7 384 191.1 384C174.3 384 159.1 398.3 159.1 416V496H223.1zM279.1 232C287.6 232 294.4 235.6 298.8 241.1L291.2 244.2C288.2 245.4 285.3 246.8 282.7 248.5C281.8 248.2 280.9 248 279.1 248H247.1C243.6 248 239.1 251.6 239.1 256V288C239.1 292.4 243.6 296 247.1 296H256L255.1 296.2C255.1 301.2 256.1 306.5 256.5 312H247.1C234.7 312 223.1 301.3 223.1 288V256C223.1 242.7 234.7 232 247.1 232H279.1zM135.1 232C149.3 232 159.1 242.7 159.1 256V288C159.1 301.3 149.3 312 135.1 312H103.1C90.74 312 79.1 301.3 79.1 288V256C79.1 242.7 90.74 232 103.1 232H135.1zM95.1 288C95.1 292.4 99.58 296 103.1 296H135.1C140.4 296 143.1 292.4 143.1 288V256C143.1 251.6 140.4 248 135.1 248H103.1C99.58 248 95.1 251.6 95.1 256V288zM135.1 104C149.3 104 159.1 114.7 159.1 128V160C159.1 173.3 149.3 184 135.1 184H103.1C90.74 184 79.1 173.3 79.1 160V128C79.1 114.7 90.74 104 103.1 104H135.1zM95.1 160C95.1 164.4 99.58 168 103.1 168H135.1C140.4 168 143.1 164.4 143.1 160V128C143.1 123.6 140.4 120 135.1 120H103.1C99.58 120 95.1 123.6 95.1 128V160zM223.1 128C223.1 114.7 234.7 104 247.1 104H279.1C293.3 104 304 114.7 304 128V160C304 173.3 293.3 184 279.1 184H247.1C234.7 184 223.1 173.3 223.1 160V128zM247.1 120C243.6 120 239.1 123.6 239.1 128V160C239.1 164.4 243.6 168 247.1 168H279.1C284.4 168 287.1 164.4 287.1 160V128C287.1 123.6 284.4 120 279.1 120H247.1zM560.9 273.7C570 277.4 576 286.2 576 296C576 359.3 550.1 464.8 441.2 510.2C435.3 512.6 428.7 512.6 422.8 510.2C313.9 464.8 287.1 359.3 287.1 296C287.1 286.2 293.1 277.4 303.1 273.7L423.1 225.7C428.8 223.4 435.2 223.4 440.9 225.7L560.9 273.7zM304 296C304 355.3 327.9 450.4 424 493.3V242.6L309 288.6C305.1 289.8 304 292.7 304 296V296zM554.1 288.6L440 242.6V493.3C536.1 450.4 560 355.3 560 296C560 292.7 558 289.8 554.1 288.6z"],
    "building-un": [384, 512, [], "e4d9", "M136 232C149.3 232 160 242.7 160 256V288C160 301.3 149.3 312 136 312H104C90.75 312 80 301.3 80 288V256C80 242.7 90.75 232 104 232H136zM96 288C96 292.4 99.58 296 104 296H136C140.4 296 144 292.4 144 288V256C144 251.6 140.4 248 136 248H104C99.58 248 96 251.6 96 256V288zM224 256C224 242.7 234.7 232 248 232H280C293.3 232 304 242.7 304 256V288C304 301.3 293.3 312 280 312H248C234.7 312 224 301.3 224 288V256zM248 248C243.6 248 240 251.6 240 256V288C240 292.4 243.6 296 248 296H280C284.4 296 288 292.4 288 288V256C288 251.6 284.4 248 280 248H248zM280 133.6V64C280 59.58 283.6 56 288 56C292.4 56 296 59.58 296 64V160C296 163.5 293.7 166.6 290.3 167.7C286.9 168.7 283.3 167.4 281.3 164.4L232 90.42V160C232 164.4 228.4 168 224 168C219.6 168 216 164.4 216 160V64C216 60.47 218.3 57.36 221.7 56.34C225.1 55.32 228.7 56.63 230.7 59.56L280 133.6zM104 128C104 141.3 114.7 152 128 152C141.3 152 152 141.3 152 128V64C152 59.58 155.6 56 160 56C164.4 56 168 59.58 168 64V128C168 150.1 150.1 168 128 168C105.9 168 88 150.1 88 128V64C88 59.58 91.58 56 96 56C100.4 56 104 59.58 104 64V128zM48 512C21.49 512 0 490.5 0 464V48C0 21.49 21.49 0 48 0H336C362.5 0 384 21.49 384 48V464C384 490.5 362.5 512 336 512H48zM16 48V464C16 481.7 30.33 496 48 496H144V416C144 389.5 165.5 368 192 368C218.5 368 240 389.5 240 416V496H336C353.7 496 368 481.7 368 464V48C368 30.33 353.7 16 336 16H48C30.33 16 16 30.33 16 48zM224 496V416C224 398.3 209.7 384 192 384C174.3 384 160 398.3 160 416V496H224z"],
    "building-user": [640, 512, [], "e4da", "M16 48V464C16 481.7 30.33 496 48 496H144V416C144 389.5 165.5 368 192 368C218.5 368 240 389.5 240 416V496H322.8C324.4 501.7 326.9 507.1 329.9 512H48C21.49 512 0 490.5 0 464V48C0 21.49 21.49 0 48 0H336C362.5 0 384 21.49 384 48V367.8C378.4 370.9 373 374.5 368 378.4V48C368 30.33 353.7 16 336 16H48C30.33 16 16 30.33 16 48V48zM224 496V416C224 398.3 209.7 384 192 384C174.3 384 160 398.3 160 416V496H224zM136 232C149.3 232 160 242.7 160 256V288C160 301.3 149.3 312 136 312H104C90.75 312 80 301.3 80 288V256C80 242.7 90.75 232 104 232H136zM96 288C96 292.4 99.58 296 104 296H136C140.4 296 144 292.4 144 288V256C144 251.6 140.4 248 136 248H104C99.58 248 96 251.6 96 256V288zM224 256C224 242.7 234.7 232 248 232H280C293.3 232 304 242.7 304 256V288C304 301.3 293.3 312 280 312H248C234.7 312 224 301.3 224 288V256zM248 248C243.6 248 240 251.6 240 256V288C240 292.4 243.6 296 248 296H280C284.4 296 288 292.4 288 288V256C288 251.6 284.4 248 280 248H248zM136 104C149.3 104 160 114.7 160 128V160C160 173.3 149.3 184 136 184H104C90.75 184 80 173.3 80 160V128C80 114.7 90.75 104 104 104H136zM96 160C96 164.4 99.58 168 104 168H136C140.4 168 144 164.4 144 160V128C144 123.6 140.4 120 136 120H104C99.58 120 96 123.6 96 128V160zM224 128C224 114.7 234.7 104 248 104H280C293.3 104 304 114.7 304 128V160C304 173.3 293.3 184 280 184H248C234.7 184 224 173.3 224 160V128zM248 120C243.6 120 240 123.6 240 128V160C240 164.4 243.6 168 248 168H280C284.4 168 288 164.4 288 160V128C288 123.6 284.4 120 280 120H248zM416 272C416 227.8 451.8 192 496 192C540.2 192 576 227.8 576 272C576 316.2 540.2 352 496 352C451.8 352 416 316.2 416 272zM496 208C460.7 208 432 236.7 432 272C432 307.3 460.7 336 496 336C531.3 336 560 307.3 560 272C560 236.7 531.3 208 496 208zM546.9 384C598.3 384 640 425.7 640 477.1C640 496.4 624.4 512 605.1 512H386.9C367.6 512 352 496.4 352 477.1C352 425.7 393.7 384 445.1 384H546.9zM386.9 496H605.1C615.5 496 624 487.5 624 477.1C624 434.5 589.5 400 546.9 400H445.1C402.5 400 368 434.5 368 477.1C368 487.5 376.5 496 386.9 496V496z"],
    "building-wheat": [640, 512, [], "e4db", "M80 256C80 242.7 90.75 232 104 232H136C149.3 232 160 242.7 160 256V288C160 301.3 149.3 312 136 312H104C90.75 312 80 301.3 80 288V256zM104 248C99.58 248 96 251.6 96 256V288C96 292.4 99.58 296 104 296H136C140.4 296 144 292.4 144 288V256C144 251.6 140.4 248 136 248H104zM280 232C293.3 232 304 242.7 304 256V288C304 301.3 293.3 312 280 312H248C234.7 312 224 301.3 224 288V256C224 242.7 234.7 232 248 232H280zM240 288C240 292.4 243.6 296 248 296H280C284.4 296 288 292.4 288 288V256C288 251.6 284.4 248 280 248H248C243.6 248 240 251.6 240 256V288zM80 128C80 114.7 90.75 104 104 104H136C149.3 104 160 114.7 160 128V160C160 173.3 149.3 184 136 184H104C90.75 184 80 173.3 80 160V128zM104 120C99.58 120 96 123.6 96 128V160C96 164.4 99.58 168 104 168H136C140.4 168 144 164.4 144 160V128C144 123.6 140.4 120 136 120H104zM280 104C293.3 104 304 114.7 304 128V160C304 173.3 293.3 184 280 184H248C234.7 184 224 173.3 224 160V128C224 114.7 234.7 104 248 104H280zM240 160C240 164.4 243.6 168 248 168H280C284.4 168 288 164.4 288 160V128C288 123.6 284.4 120 280 120H248C243.6 120 240 123.6 240 128V160zM0 464V48C0 21.49 21.49 0 48 0H336C362.5 0 384 21.49 384 48V464C384 490.5 362.5 512 336 512H48C21.49 512 0 490.5 0 464zM336 16H48C30.33 16 16 30.33 16 48V464C16 481.7 30.33 496 48 496H144V416C144 389.5 165.5 368 192 368C218.5 368 240 389.5 240 416V496H336C353.7 496 368 481.7 368 464V48C368 30.33 353.7 16 336 16zM192 384C174.3 384 160 398.3 160 416V496H224V416C224 398.3 209.7 384 192 384zM416 240V224C416 215.2 423.2 208 432 208H456C487.7 208 515 226.4 528 253.1C540.1 226.4 568.3 208 600 208H624C632.8 208 640 215.2 640 224V240C640 266.2 627.4 289.4 608 304H624C632.8 304 640 311.2 640 320V336C640 362.2 627.4 385.4 608 400H624C632.8 400 640 407.2 640 416V432C640 476.2 604.2 512 560 512H536C533.1 512 530.4 511.2 528 509.9C525.6 511.2 522.9 512 520 512H496C451.8 512 416 476.2 416 432V416C416 407.2 423.2 400 432 400H447.1C428.6 385.4 416 362.2 416 336V320C416 311.2 423.2 304 432 304H447.1C428.6 289.4 416 266.2 416 240zM624 240V224H600C564.7 224 536 252.7 536 288V304H560C595.3 304 624 275.3 624 240zM520 320H504C514.1 327.6 522.4 337.6 528 349.1C533.6 337.6 541.9 327.6 551.1 320H536C533.1 320 530.4 319.2 528 317.9C525.6 319.2 522.9 320 520 320zM520 288C520 252.7 491.3 224 456 224H432V240C432 275.3 460.7 304 496 304H520V288zM624 336V320H600C564.7 320 536 348.7 536 384V400H560C595.3 400 624 371.3 624 336zM520 416H504C514.1 423.6 522.4 433.6 528 445.1C533.6 433.6 541.9 423.6 551.1 416H536C533.1 416 530.4 415.2 528 413.9C525.6 415.2 522.9 416 520 416zM520 384C520 348.7 491.3 320 456 320H432V336C432 371.3 460.7 400 496 400H520V384zM600 416C564.7 416 536 444.7 536 480V496H560C595.3 496 624 467.3 624 432V416H600zM520 496V480C520 444.7 491.3 416 456 416H432V432C432 467.3 460.7 496 496 496H520zM528 32C532.4 32 536 35.58 536 40V184C536 188.4 532.4 192 528 192C523.6 192 520 188.4 520 184V40C520 35.58 523.6 32 528 32zM608 152C608 156.4 604.4 160 600 160C595.6 160 592 156.4 592 152V72C592 67.58 595.6 64 600 64C604.4 64 608 67.58 608 72V152zM456 64C460.4 64 464 67.58 464 72V152C464 156.4 460.4 160 456 160C451.6 160 448 156.4 448 152V72C448 67.58 451.6 64 456 64z"],
    "buildings": [512, 512, [], "e0cc", "M368 344C368 330.7 378.7 320 392 320H424C437.3 320 448 330.7 448 344V376C448 389.3 437.3 400 424 400H392C378.7 400 368 389.3 368 376V344zM424 384C428.4 384 432 380.4 432 376V344C432 339.6 428.4 336 424 336H392C387.6 336 384 339.6 384 344V376C384 380.4 387.6 384 392 384H424zM392 272C378.7 272 368 261.3 368 248V216C368 202.7 378.7 192 392 192H424C437.3 192 448 202.7 448 216V248C448 261.3 437.3 272 424 272H392zM384 248C384 252.4 387.6 256 392 256H424C428.4 256 432 252.4 432 248V216C432 211.6 428.4 208 424 208H392C387.6 208 384 211.6 384 216V248zM256 344C256 330.7 266.7 320 280 320H312C325.3 320 336 330.7 336 344V376C336 389.3 325.3 400 312 400H280C266.7 400 256 389.3 256 376V344zM312 384C316.4 384 320 380.4 320 376V344C320 339.6 316.4 336 312 336H280C275.6 336 272 339.6 272 344V376C272 380.4 275.6 384 280 384H312zM312 72C325.3 72 336 82.75 336 96V128C336 141.3 325.3 152 312 152H280C266.7 152 256 141.3 256 128V96C256 82.75 266.7 72 280 72H312zM272 128C272 132.4 275.6 136 280 136H312C316.4 136 320 132.4 320 128V96C320 91.58 316.4 88 312 88H280C275.6 88 272 91.58 272 96V128zM256 216C256 202.7 266.7 192 280 192H312C325.3 192 336 202.7 336 216V248C336 261.3 325.3 272 312 272H280C266.7 272 256 261.3 256 248V216zM312 256C316.4 256 320 252.4 320 248V216C320 211.6 316.4 208 312 208H280C275.6 208 272 211.6 272 216V248C272 252.4 275.6 256 280 256H312zM424 72C437.3 72 448 82.75 448 96V128C448 141.3 437.3 152 424 152H392C378.7 152 368 141.3 368 128V96C368 82.75 378.7 72 392 72H424zM384 128C384 132.4 387.6 136 392 136H424C428.4 136 432 132.4 432 128V96C432 91.58 428.4 88 424 88H392C387.6 88 384 91.58 384 96V128zM192 64C192 28.65 220.7 0 256 0H448C483.3 0 512 28.65 512 64V448C512 483.3 483.3 512 448 512H256C220.7 512 192 483.3 192 448V64zM208 64V448C208 474.5 229.5 496 256 496H448C474.5 496 496 474.5 496 448V64C496 37.49 474.5 16 448 16H256C229.5 16 208 37.49 208 64zM160 128C164.4 128 168 131.6 168 136C168 140.4 164.4 144 160 144H56C33.91 144 16 161.9 16 184V456C16 478.1 33.91 496 56 496H176C180.4 496 184 499.6 184 504C184 508.4 180.4 512 176 512H56C25.07 512 0 486.9 0 456V184C0 153.1 25.07 128 56 128H160zM64 344C64 330.7 74.75 320 88 320H120C133.3 320 144 330.7 144 344V376C144 389.3 133.3 400 120 400H88C74.75 400 64 389.3 64 376V344zM88 336C83.58 336 80 339.6 80 344V376C80 380.4 83.58 384 88 384H120C124.4 384 128 380.4 128 376V344C128 339.6 124.4 336 120 336H88zM120 192C133.3 192 144 202.7 144 216V248C144 261.3 133.3 272 120 272H88C74.75 272 64 261.3 64 248V216C64 202.7 74.75 192 88 192H120zM80 248C80 252.4 83.58 256 88 256H120C124.4 256 128 252.4 128 248V216C128 211.6 124.4 208 120 208H88C83.58 208 80 211.6 80 216V248z"],
    "bullhorn": [512, 512, [128363, 128226], "f0a1", "M464 166.7C492.3 179 512 207.2 512 239.1C512 272.8 492.3 300.1 464 313.3V448C464 476.1 430.3 490.6 409.9 471.2L365.9 429.2C326.4 391.6 276.1 366.6 224 356.7V340.5C281.1 350.5 334.4 377.2 376.9 417.7L420.1 459.6C431.2 469.3 448 462.1 448 448V31.1C448 17.93 431.2 10.71 420.1 20.41L376.9 62.34C334.4 102.8 281.1 129.5 224 139.5V123.3C276.1 113.4 326.4 88.42 365.9 50.76L409.9 8.828C430.3-10.58 464 3.866 464 32V166.7zM464 295.4C483.1 284.4 496 263.7 496 239.1C496 216.3 483.1 195.6 464 184.6V295.4zM192 472C192 494.1 174.1 512 152 512H104C81.91 512 64 494.1 64 472V352C28.65 352 0 323.3 0 287.1V191.1C0 156.7 28.65 127.1 64 127.1H172.8C179.2 127.1 185.6 127.8 192 127.3V472zM176 352C174.9 352 173.9 352 172.8 352H80V472C80 485.3 90.75 496 104 496H152C165.3 496 176 485.3 176 472V352zM172.8 336C173.9 336 174.9 336 176 336V143.1C174.9 143.1 173.9 143.1 172.8 143.1H64C37.49 143.1 16 165.5 16 191.1V287.1C16 314.5 37.49 336 64 336H172.8z"],
    "bullseye": [512, 512, [], "f140", "M328 256C328 295.8 295.8 328 256 328C216.2 328 184 295.8 184 256C184 216.2 216.2 184 256 184C295.8 184 328 216.2 328 256zM256 200C225.1 200 200 225.1 200 256C200 286.9 225.1 312 256 312C286.9 312 312 286.9 312 256C312 225.1 286.9 200 256 200zM88 256C88 163.2 163.2 88 256 88C348.8 88 424 163.2 424 256C424 348.8 348.8 424 256 424C163.2 424 88 348.8 88 256zM256 408C339.9 408 408 339.9 408 256C408 172.1 339.9 104 256 104C172.1 104 104 172.1 104 256C104 339.9 172.1 408 256 408zM0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM256 496C388.5 496 496 388.5 496 256C496 123.5 388.5 16 256 16C123.5 16 16 123.5 16 256C16 388.5 123.5 496 256 496z"],
    "bullseye-arrow": [512, 512, [127919], "f648", "M319.1 24.37C298.1 18.91 277.8 16 256 16C123.5 16 16 123.5 16 256C16 388.5 123.5 496 256 496C388.5 496 496 388.5 496 256C496 234.2 493.1 213 487.6 192.9L500.5 180C507.1 204 512 229.5 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C282.5 0 307.1 4.012 331.1 11.46L319.1 24.37zM421.1 229.7C423.3 238.3 424 247.1 424 256C424 348.8 348.8 424 256 424C163.2 424 88 348.8 88 256C88 163.2 163.2 88 256 88C264.9 88 273.7 88.7 282.3 90.04C282.2 94.29 282.5 98.56 283.3 102.8L283.9 106.6C274.8 104.9 265.5 104 256 104C172.1 104 104 172.1 104 256C104 339.9 172.1 408 256 408C339.9 408 408 339.9 408 256C408 246.5 407.1 237.2 405.4 228.1L409.2 228.7C413.4 229.5 417.7 229.8 421.1 229.7zM256 184C260.8 184 265.5 184.5 270.1 185.4L255.4 200C224.8 200.3 200 225.3 200 255.1C200 286.9 225.1 311.1 256 311.1C286.7 311.1 311.7 287.2 311.1 256.6L326.6 241.9C327.5 246.5 328 251.2 328 256C328 295.8 295.8 328 256 328C216.2 328 184 295.8 184 256C184 216.2 216.2 184 256 184H256zM261.7 261.7C258.5 264.8 253.5 264.8 250.3 261.7C247.2 258.5 247.2 253.5 250.3 250.3L327.4 173.3L314.8 97.56C312.7 84.82 316.9 71.83 325.1 62.7L376.6 12.09C385.3 3.404 400.1 7.343 403.3 19.19L422.5 89.48L492.8 108.7C504.7 111.9 508.6 126.7 499.9 135.4L449.3 186C440.2 195.1 427.2 199.3 414.4 197.2L338.7 184.6L261.7 261.7zM387.9 23.4L337.3 74.01C331.8 79.49 329.3 87.28 330.6 94.93L341.3 159.4L407.1 93.63L387.9 23.4zM417.1 181.4C424.7 182.7 432.5 180.2 437.1 174.7L488.6 124.1L418.4 104.9L352.6 170.7L417.1 181.4z"],
    "bullseye-pointer": [512, 512, [], "f649", "M256 16C123.5 16 16 123.5 16 256C16 265 16.5 273.1 17.47 282.7C11.72 284.1 6.678 288.5 2.631 292.8C.8973 280.8 0 268.5 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C243.5 512 231.2 511.1 219.2 509.4C223.5 505.3 227 500.3 229.3 494.5C238 495.5 246.1 496 256 496C388.5 496 496 388.5 496 256C496 123.5 388.5 16 256 16zM254.2 407.1C254.8 407.1 255.4 408 256 408C339.9 408 408 339.9 408 256C408 172.1 339.9 104 256 104C172.1 104 104 172.1 104 256C104 256.6 104 257.2 104 257.8L88.12 262.4C88.04 260.3 88 258.1 88 256C88 163.2 163.2 88 256 88C348.8 88 424 163.2 424 256C424 348.8 348.8 424 256 424C253.9 424 251.7 423.1 249.6 423.9L254.2 407.1zM283.7 304.7C300.6 295 312 276.9 312 256C312 225.1 286.9 200 256 200C235.1 200 216.1 211.4 207.3 228.3L187.4 233.1C196.7 204.1 223.9 184 256 184C295.8 184 328 216.2 328 256C328 288.1 307 315.3 278 324.6L283.7 304.7zM199.7 482.2C198.7 485.6 195.7 487.9 192.1 488C188.6 488.1 185.5 485.8 184.4 482.4L149.6 373.7L13.66 509.7C10.53 512.8 5.467 512.8 2.343 509.7C-.7811 506.5-.7811 501.5 2.343 498.3L138.3 362.4L29.56 327.6C26.2 326.5 23.95 323.4 24 319.9C24.06 316.3 26.41 313.3 29.8 312.3L253.8 248.3C256.6 247.5 259.6 248.3 261.7 250.3C263.7 252.4 264.5 255.4 263.7 258.2L199.7 482.2zM155.6 351.2C158.1 351.1 160 353.9 160.8 356.4L191.6 452.4L244.4 267.6L59.6 320.4L155.6 351.2z"],
    "burger": [512, 512, ["hamburger"], "f805", "M490.8 341.5C487.4 348.2 482.5 353.1 476.5 358.4C478.7 361.1 479.9 364.5 479.1 368V384C479.1 400.1 473.3 417.3 461.3 429.3C449.3 441.3 432.1 448 415.1 448H95.1C79.02 448 62.75 441.3 50.74 429.3C38.74 417.3 31.1 400.1 31.1 384V368C32.06 364.5 33.3 361.1 35.52 358.4C28.94 353.6 23.71 347.2 20.32 339.7C16.94 332.3 15.51 324.2 16.19 316C16.86 307.9 19.61 300.1 24.17 293.3C28.73 286.6 34.95 281.1 42.24 277.4C37.94 272.5 34.87 266.7 33.26 260.3C31.65 253.1 31.56 247.4 32.99 240.1C44.73 190.7 73.16 145.8 113.6 113.6C154.1 81.5 204.3 64.01 255.1 64.01C307.7 64.01 357.9 81.5 398.3 113.6C438.8 145.8 467.3 190.7 479 240.1C480.4 247.4 480.3 253.1 478.7 260.3C477.1 266.7 474.1 272.5 469.8 277.4C477.6 281.4 484.2 287.5 488.9 295C493.5 302.5 495.1 311.2 495.1 320C495.1 327.5 494.2 334.9 490.8 341.5V341.5zM48.53 255.7C49.33 259.4 50.94 262.1 53.25 265.1C54.57 267.8 56.28 269.3 58.26 270.3C60.24 271.4 62.43 271.9 64.67 272H447.3C449.6 271.9 451.8 271.4 453.7 270.3C455.7 269.3 457.4 267.8 458.7 265.1C461.1 262.1 462.7 259.4 463.5 255.7C464.3 251.1 464.2 248.1 463.4 244.4C452.4 197.6 425.1 155.9 388.3 126.1C350.7 96.22 304 79.97 255.1 79.97C207.1 79.97 161.3 96.22 123.7 126.1C86.03 155.9 59.58 197.6 48.64 244.4C47.77 248.1 47.73 251.1 48.53 255.7zM463.1 368H47.1V384C47.1 396.7 53.06 408.9 62.06 417.9C71.06 426.9 83.27 432 95.1 432H415.1C428.7 432 440.9 426.9 449.9 417.9C458.9 408.9 463.1 396.7 463.1 384V368zM470.6 342.6C476.6 336.6 479.1 328.5 479.1 320C479.1 311.5 476.6 303.4 470.6 297.4C464.6 291.4 456.5 288 447.1 288H63.1C55.51 288 47.37 291.4 41.37 297.4C35.37 303.4 31.1 311.5 31.1 320C31.1 328.5 35.37 336.6 41.37 342.6C47.37 348.6 55.51 352 63.1 352H447.1C456.5 352 464.6 348.6 470.6 342.6zM356.7 187.3C353.7 184.3 351.1 180.2 351.1 176C351.1 172.8 352.9 169.7 354.7 167.1C356.5 164.5 358.1 162.4 361.9 161.2C364.8 160 368 159.7 371.1 160.3C374.2 160.9 377.1 162.4 379.3 164.7C381.5 166.9 383.1 169.8 383.7 172.9C384.3 175.1 383.1 179.2 382.8 182.1C381.6 185 379.5 187.5 376.9 189.3C374.3 191.1 371.2 192 367.1 192C363.8 192 359.7 190.3 356.7 187.3V187.3zM244.7 155.3C241.7 152.3 239.1 148.2 239.1 144C239.1 140.8 240.9 137.7 242.7 135.1C244.5 132.5 246.1 130.4 249.9 129.2C252.8 128 256 127.7 259.1 128.3C262.2 128.9 265.1 130.4 267.3 132.7C269.5 134.9 271.1 137.8 271.7 140.9C272.3 143.1 271.1 147.2 270.8 150.1C269.6 153 267.5 155.5 264.9 157.3C262.3 159.1 259.2 160 255.1 160C251.8 160 247.7 158.3 244.7 155.3V155.3zM132.7 187.3C129.7 184.3 127.1 180.2 127.1 176C127.1 172.8 128.9 169.7 130.7 167.1C132.5 164.5 134.1 162.4 137.9 161.2C140.8 160 144 159.7 147.1 160.3C150.2 160.9 153.1 162.4 155.3 164.7C157.5 166.9 159.1 169.8 159.7 172.9C160.3 175.1 159.1 179.2 158.8 182.1C157.6 185 155.5 187.5 152.9 189.3C150.3 191.1 147.2 192 143.1 192C139.8 192 135.7 190.3 132.7 187.3L132.7 187.3z"],
    "burger-cheese": [512, 512, [127828, "cheeseburger"], "f7f1", "M490.8 341.5C487.4 348.2 482.5 353.1 476.5 358.4C478.7 361.1 479.9 364.5 479.1 368V384C479.1 400.1 473.3 417.3 461.3 429.3C449.3 441.3 432.1 448 415.1 448H95.1C79.02 448 62.75 441.3 50.74 429.3C38.74 417.3 31.1 400.1 31.1 384V368C32.06 364.5 33.3 361.1 35.52 358.4C28.94 353.6 23.71 347.2 20.32 339.7C16.94 332.3 15.51 324.2 16.19 316C16.86 307.9 19.61 300.1 24.17 293.3C28.73 286.6 34.95 281.1 42.24 277.4C37.94 272.5 34.87 266.7 33.26 260.3C31.65 253.1 31.56 247.4 32.99 240.1C44.73 190.7 73.16 145.8 113.6 113.6C154.1 81.5 204.3 64.01 255.1 64.01C307.7 64.01 357.9 81.5 398.3 113.6C438.8 145.8 467.3 190.7 479 240.1C480.4 247.4 480.3 253.1 478.7 260.3C477.1 266.7 474.1 272.5 469.8 277.4C477.6 281.4 484.2 287.5 488.9 295C493.5 302.5 495.1 311.2 495.1 320C495.1 327.5 494.2 334.9 490.8 341.5V341.5zM48.53 255.7C49.33 259.4 50.94 262.1 53.25 265.1C54.57 267.8 56.28 269.3 58.26 270.3C60.24 271.4 62.43 271.9 64.67 272H447.3C449.6 271.9 451.8 271.4 453.7 270.3C455.7 269.3 457.4 267.8 458.7 265.1C461.1 262.1 462.7 259.4 463.5 255.7C464.3 251.1 464.2 248.1 463.4 244.4C452.4 197.6 425.1 155.9 388.3 126.1C350.7 96.22 304 79.97 255.1 79.97C207.1 79.97 161.3 96.22 123.7 126.1C86.03 155.9 59.58 197.6 48.64 244.4C47.77 248.1 47.73 251.1 48.53 255.7zM257.9 288L319.1 319.1L382.1 288H257.9zM463.1 368H47.1V384C47.1 396.7 53.06 408.9 62.06 417.9C71.06 426.9 83.27 432 95.1 432H415.1C428.7 432 440.9 426.9 449.9 417.9C458.9 408.9 463.1 396.7 463.1 384V368zM470.6 342.6C476.6 336.6 479.1 328.5 479.1 320C479.1 311.5 476.6 303.4 470.6 297.4C464.6 291.4 456.5 288 447.1 288H417.9L323.5 335.2C322.4 335.7 321.2 336 319.1 336C318.8 336 317.5 335.7 316.4 335.2L222.1 288H63.1C55.51 288 47.37 291.4 41.37 297.4C35.37 303.4 31.1 311.5 31.1 320C31.1 328.5 35.37 336.6 41.37 342.6C47.37 348.6 55.51 352 63.1 352H447.1C456.5 352 464.6 348.6 470.6 342.6zM356.7 187.3C353.7 184.3 351.1 180.2 351.1 176C351.1 172.8 352.9 169.7 354.7 167.1C356.5 164.5 358.1 162.4 361.9 161.2C364.8 160 368 159.7 371.1 160.3C374.2 160.9 377.1 162.4 379.3 164.7C381.5 166.9 383.1 169.8 383.7 172.9C384.3 175.1 383.1 179.2 382.8 182.1C381.6 185 379.5 187.5 376.9 189.3C374.3 191.1 371.2 192 367.1 192C363.8 192 359.7 190.3 356.7 187.3V187.3zM244.7 155.3C241.7 152.3 239.1 148.2 239.1 144C239.1 140.8 240.9 137.7 242.7 135.1C244.5 132.5 246.1 130.4 249.9 129.2C252.8 128 256 127.7 259.1 128.3C262.2 128.9 265.1 130.4 267.3 132.7C269.5 134.9 271.1 137.8 271.7 140.9C272.3 143.1 271.1 147.2 270.8 150.1C269.6 153 267.5 155.5 264.9 157.3C262.3 159.1 259.2 160 255.1 160C251.8 160 247.7 158.3 244.7 155.3V155.3zM132.7 187.3C129.7 184.3 127.1 180.2 127.1 176C127.1 172.8 128.9 169.7 130.7 167.1C132.5 164.5 134.1 162.4 137.9 161.2C140.8 160 144 159.7 147.1 160.3C150.2 160.9 153.1 162.4 155.3 164.7C157.5 166.9 159.1 169.8 159.7 172.9C160.3 175.1 159.1 179.2 158.8 182.1C157.6 185 155.5 187.5 152.9 189.3C150.3 191.1 147.2 192 143.1 192C139.8 192 135.7 190.3 132.7 187.3L132.7 187.3z"],
    "burger-fries": [640, 512, [], "e0cd", "M263 62.97C262.6 63.96 261.9 64.85 261.1 65.57C260.3 66.3 259.3 66.85 258.3 67.2C257.3 67.55 256.2 67.68 255.1 67.59C254 67.51 252.1 67.2 251.1 66.69C251 66.18 250.2 65.48 249.5 64.63C248.8 63.78 248.3 62.8 248 61.75C247.7 60.71 247.7 59.61 247.8 58.53C247.1 57.45 248.3 56.42 248.9 55.49C250.3 52.61 252.2 50.05 254.6 47.95C256.1 45.85 259.8 44.27 262.8 43.29L297 33.09C300.9 31.91 305.1 31.75 309.1 32.63C313.1 33.51 316.8 35.39 319.8 38.1C322.9 40.82 325.2 44.27 326.6 48.13C327.9 51.99 328.3 56.13 327.6 60.16L305.4 181.3C305.2 182.4 304.8 183.4 304.1 184.3C303.5 185.2 302.7 185.1 301.8 186.6C300.5 187.4 298.1 187.9 297.4 187.9C295.9 187.9 294.3 187.5 293 186.6C291.7 185.8 290.7 184.6 290 183.1C289.4 181.7 289.2 180.1 289.5 178.6L311.9 57.31C312.1 55.97 311.1 54.6 311.5 53.32C311 52.05 310.3 50.91 309.2 50.02C308.2 49.13 306.1 48.51 305.7 48.22C304.3 47.94 302.1 47.99 301.7 48.38L267.4 58.65C266.8 58.81 264.1 59.36 263 62.97L263 62.97zM56.38 50.14C55.56 45.73 55.98 41.18 57.6 36.99C59.23 32.81 61.99 29.16 65.57 26.46L94.05 4.862C97.32 2.409 101.2 .83 105.2 .2748C109.3-.2801 113.4 .2069 117.2 1.69C121 3.173 124.4 5.604 126.1 8.751C129.6 11.9 131.3 15.66 132.1 19.68L136 39.65C136.2 40.68 136.2 41.74 135.1 42.77C135.8 43.8 135.3 44.78 134.7 45.65C134.1 46.51 133.4 47.26 132.5 47.83C131.6 48.4 130.6 48.8 129.6 48.99C127.5 49.35 125.4 48.88 123.6 47.68C121.9 46.49 120.7 44.66 120.3 42.59L116.5 22.59C116.3 21.23 115.7 19.95 114.9 18.87C113.1 17.8 112.8 16.97 111.6 16.47C110.3 15.96 108.9 15.8 107.5 15.99C106.1 16.18 104.8 16.73 103.7 17.57L75.3 39.23C74.07 40.11 73.12 41.32 72.56 42.72C71.99 44.12 71.83 45.65 72.1 47.13L109.1 236.3C109.3 237.4 109.3 238.4 109 239.5C108.8 240.5 108.4 241.5 107.8 242.3C107.2 243.2 106.5 243.1 105.6 244.5C104.7 245.1 103.7 245.5 102.7 245.7C102.1 245.7 101.6 245.7 101.1 245.7C99.25 245.7 97.46 245 96.03 243.9C94.61 242.7 93.62 241.1 93.25 239.3L56.38 50.14zM239.2 505.1C238.1 506.4 238.5 507.6 237.8 508.6C237.1 509.7 236.1 510.5 234.1 511.1C233.8 511.7 232.6 512 231.3 511.1H85.73C78.44 512 71.37 509.6 65.67 505C59.97 500.5 55.1 494.1 54.4 487L.3854 243.5C-.1372 241.1-.1273 238.7 .4142 236.4C.9559 234 2.015 231.9 3.515 229.1C5.014 228.1 6.914 226.6 9.076 225.6C11.24 224.5 13.6 223.1 16 223.1H49.99C53.39 223.8 56.75 224.8 59.52 226.8C62.29 228.8 64.31 231.7 65.25 234.1C73.89 273.1 127.4 303.1 192 303.1C202.4 303.1 212.8 303.1 223.1 301.4C224.3 301.2 225.4 301.3 226.5 301.6C227.6 301.1 228.6 302.6 229.5 303.3C230.3 304.1 231 305 231.5 306.1C231.9 307.1 232.1 308.3 232.1 309.4C232.1 311.3 231.4 313 230.3 314.4C229.1 315.8 227.5 316.7 225.7 317.1C214.6 318.1 203.3 319.9 192 319.1C120.8 319.1 61.47 286.5 50.05 239.1H16L70.08 483.5C70.87 487 72.85 490.2 75.7 492.5C78.54 494.8 82.08 496 85.73 495.1H231.2C232.9 496 234.5 496.6 235.8 497.5C237.1 498.5 238.2 499.8 238.7 501.3C239.2 502.5 239.3 503.8 239.2 505.1zM.5451 115.2C-.4818 109.8-.0937 104.2 1.672 98.98C3.438 93.76 6.522 89.08 10.63 85.41C14.44 82.01 19.04 79.61 24.01 78.41C28.97 77.21 34.16 77.25 39.1 78.53C40.17 78.72 41.18 79.14 42.08 79.74C42.98 80.34 43.75 81.12 44.34 82.03C44.94 82.93 45.34 83.95 45.52 85.02C45.71 86.09 45.67 87.18 45.42 88.23C45.18 89.29 44.71 90.28 44.07 91.15C43.43 92.02 42.61 92.75 41.68 93.3C40.74 93.84 39.71 94.2 38.63 94.33C37.56 94.46 36.47 94.38 35.43 94.08C32.99 93.43 30.43 93.39 27.98 93.95C25.52 94.5 23.23 95.65 21.31 97.28C19.29 99.1 17.76 101.4 16.87 103.1C15.99 106.6 15.78 109.3 16.26 111.1L32 190.5C32.22 191.5 32.23 192.6 32.03 193.6C31.82 194.7 31.41 195.7 30.81 196.6C30.21 197.5 29.43 198.2 28.53 198.8C27.63 199.4 26.63 199.8 25.57 199.1C25.04 200 24.5 200 23.97 199.1C22.13 199.1 20.35 199.3 18.92 198.2C17.5 196.1 16.52 195.4 16.16 193.6L.5451 115.2zM154.4 274.4C152.9 272.9 152 270.9 152 268.8V23.1C152 19.89 153.1 15.85 155.1 12.26C157.1 8.679 159.1 5.668 163.5 3.518C166.9 1.381 170.9 .1736 174.1 .0111C179-.1515 183.1 .7368 186.7 2.59L218.7 18.59C222.7 20.57 226 23.62 228.3 27.41C230.7 31.19 231.9 35.55 231.9 39.1V268.8C231.9 270.9 231 272.1 229.5 274.5C228 275.1 225.1 276.8 223.9 276.8C221.8 276.8 219.7 275.1 218.2 274.5C216.7 272.1 215.9 270.9 215.9 268.8V39.93C215.9 38.47 215.5 37.03 214.7 35.79C213.9 34.54 212.8 33.54 211.5 32.89L179.5 16.89C178.3 16.27 176.1 15.97 175.6 16.01C174.3 16.06 172.1 16.45 171.8 17.15C170.7 17.86 169.7 18.87 169 20.07C168.3 21.27 167.1 22.62 168 23.1V268.8C167.1 270.9 167.1 272.9 165.6 274.4C164.2 275.9 162.1 276.8 160 276.8C157.9 276.8 155.9 275.9 154.4 274.4zM343.7 95.4C341.1 94.17 340.8 92.32 340.4 90.24C340.1 88.14 340.6 86 341.8 84.28C343.1 82.56 344.9 81.4 347 81.05C351.7 80.17 356.5 80.36 361 81.62C365.6 82.87 369.8 85.15 373.3 88.29C377.4 91.88 380.5 96.47 382.3 101.6C384.1 106.7 384.5 112.3 383.5 117.6L377.1 149.1C376.7 150.5 376 151.8 375 152.9C374 153.9 372.7 154.7 371.3 155.1C370 155.5 368.6 155.5 367.3 155.2C365.1 154.9 364.8 154.3 363.8 153.4C362.7 152.5 362 151.3 361.6 149.1C361.2 148.7 361.1 147.3 361.4 145.1L367.8 114.6C368.2 112.1 368.1 109.6 367.3 107.2C366.6 104.8 365.2 102.6 363.4 100.9C361.6 99.13 359.4 97.85 357 97.15C354.6 96.45 352.1 96.35 349.6 96.86C347.5 97.16 345.4 96.64 343.7 95.4zM359.4 287.1C357.9 286.5 356.6 285.6 355.5 284.5C354.4 283.4 353.5 282.1 352.9 280.6C352.3 279.1 351.1 277.6 352 275.1C352 273.6 352.7 271.3 354 269.3C355.3 267.4 357.2 265.8 359.4 264.9C361.6 264 364 263.8 366.3 264.2C368.7 264.7 370.8 265.8 372.5 267.5C374.2 269.2 375.3 271.3 375.8 273.7C376.2 275.1 375.1 278.4 375.1 280.6C374.2 282.8 372.6 284.7 370.7 285.1C368.7 287.3 366.4 287.1 364 287.1C362.4 288 360.9 287.7 359.4 287.1zM633.6 360.1C637.8 367.4 639.1 375.6 639.1 383.1C639.1 392.4 637.8 400.6 633.6 407.9C629.4 415.2 623.3 421.2 616 425.3V467.1C615.1 479.7 611.3 490.8 603.1 499.1C594.8 507.3 583.7 511.1 572 511.1H324C312.3 511.1 301.2 507.3 292.9 499.1C284.7 490.8 280 479.7 280 467.1V425.3C272.7 421.2 266.7 415.2 262.4 407.9C258.2 400.6 256 392.4 256 383.1C256 375.6 258.2 367.4 262.4 360.1C266.7 352.8 272.7 346.8 280 342.7V303.1C280.2 292.6 282.8 281.3 287.5 270.9C292.1 260.5 298.8 251.2 307.2 243.4C346.1 209.6 396.1 191.3 447.6 191.1C447.9 191.1 448.1 191.1 448.4 191.1C499.9 191.3 549.9 209.6 588.8 243.4C597.2 251.2 603.9 260.5 608.6 270.9C613.2 281.3 615.8 292.6 616 303.1V342.7C623.3 346.8 629.4 352.8 633.6 360.1zM295.9 336.8C298.5 336.3 301.2 336 303.9 335.1H591.9C594.6 336 597.2 336.3 599.9 336.8V303.1C599.7 294.7 597.6 285.5 593.7 277.1C589.9 268.6 584.4 260.1 577.5 254.7C541.6 223.9 495.7 207.2 448.4 207.1C448.1 208 447.9 208 447.7 207.1C400.3 207.2 354.3 223.8 318.4 254.7C311.5 260.1 305.1 268.6 302.1 277.1C298.3 285.5 296.2 294.7 296 303.1L295.9 336.8zM600 431.2C597.4 431.7 594.7 431.1 592 431.1H304C301.3 431.1 298.6 431.7 296 431.2V467.1C296 475.4 298.1 482.5 304.2 487.8C309.5 493 316.6 495.1 324 495.1H572C579.4 495.1 586.5 493 591.8 487.8C597 482.5 599.1 475.4 600 467.1V431.2zM614.6 406.6C620.6 400.6 624 392.5 624 383.1C624 375.5 620.6 367.4 614.6 361.4C608.6 355.4 600.5 351.1 592 351.1H304C295.5 351.1 287.4 355.4 281.4 361.4C275.4 367.4 272 375.5 272 383.1C272 392.5 275.4 400.6 281.4 406.6C287.4 412.6 295.5 415.1 304 415.1H592C600.5 415.1 608.6 412.6 614.6 406.6zM443.4 267.1C441.9 266.5 440.6 265.6 439.5 264.5C438.4 263.4 437.5 262.1 436.9 260.6C436.3 259.1 435.1 257.6 436 255.1C436 253.6 436.7 251.3 438 249.3C439.3 247.4 441.2 245.8 443.4 244.9C445.6 244 448 243.8 450.3 244.2C452.7 244.7 454.8 245.8 456.5 247.5C458.2 249.2 459.3 251.3 459.8 253.7C460.2 255.1 459.1 258.4 459.1 260.6C458.2 262.8 456.6 264.7 454.7 265.1C452.7 267.3 450.4 267.1 448 267.1C446.4 268 444.9 267.7 443.4 267.1V267.1zM527.4 287.1C525.9 286.5 524.6 285.6 523.5 284.5C522.4 283.4 521.5 282.1 520.9 280.6C520.3 279.1 519.1 277.6 520 275.1C520 273.6 520.7 271.3 522 269.3C523.3 267.4 525.2 265.8 527.4 264.9C529.6 264 532 263.8 534.3 264.2C536.7 264.7 538.8 265.8 540.5 267.5C542.2 269.2 543.3 271.3 543.8 273.7C544.2 275.1 543.1 278.4 543.1 280.6C542.2 282.8 540.6 284.7 538.7 285.1C536.7 287.3 534.4 287.1 532 287.1C530.4 288 528.9 287.7 527.4 287.1H527.4z"],
    "burger-glass": [640, 512, [], "e0ce", "M633.6 360.1C637.8 367.4 639.1 375.6 639.1 384C639.1 392.4 637.8 400.6 633.6 407.9C629.3 415.2 623.3 421.2 616 425.3V468C615.1 479.7 611.3 490.8 603.1 499.1C594.8 507.3 583.7 511.1 572 512H324C312.3 511.1 301.2 507.3 292.9 499.1C284.7 490.8 280 479.7 279.1 468V425.3C272.7 421.2 266.7 415.2 262.4 407.9C258.2 400.6 256 392.4 256 384C256 375.6 258.2 367.4 262.4 360.1C266.7 352.8 272.7 346.8 279.1 342.7V303.1C280.2 292.6 282.8 281.3 287.4 270.9C292.1 260.5 298.8 251.2 307.2 243.4C346.1 209.6 396.1 191.3 447.6 191.1C447.9 191.1 448.1 191.1 448.4 191.1C499.9 191.3 549.9 209.6 588.8 243.4C597.2 251.2 603.9 260.5 608.5 270.9C613.2 281.3 615.8 292.6 616 303.1V342.7C623.3 346.8 629.3 352.8 633.6 360.1zM295.9 336.8C298.5 336.3 301.2 336 303.9 336H591.9C594.6 336 597.2 336.3 599.9 336.8V303.1C599.7 294.7 597.6 285.5 593.7 277.1C589.9 268.6 584.3 260.1 577.5 254.7C541.6 223.9 495.7 207.2 448.4 207.1C448.1 208 447.9 208 447.7 207.1C400.3 207.2 354.3 223.8 318.4 254.7C311.5 260.1 305.1 268.6 302.1 277.1C298.3 285.5 296.2 294.7 295.1 303.1L295.9 336.8zM600 431.2C597.4 431.7 594.7 431.1 592 432H303.1C301.3 431.1 298.6 431.7 295.1 431.2V468C296 475.4 298.1 482.5 304.2 487.8C309.5 493 316.6 495.1 324 496H572C579.4 495.1 586.5 493 591.8 487.8C597 482.5 599.1 475.4 600 468V431.2zM614.6 406.6C620.6 400.6 624 392.5 624 384C624 375.5 620.6 367.4 614.6 361.4C608.6 355.4 600.5 352 592 352H303.1C295.5 352 287.4 355.4 281.4 361.4C275.4 367.4 271.1 375.5 271.1 384C271.1 392.5 275.4 400.6 281.4 406.6C287.4 412.6 295.5 416 303.1 416H592C600.5 416 608.6 412.6 614.6 406.6zM527.4 287.1C525.9 286.5 524.6 285.6 523.5 284.5C522.4 283.4 521.5 282.1 520.9 280.6C520.3 279.1 519.1 277.6 520 276C520 273.6 520.7 271.3 522 269.3C523.3 267.4 525.2 265.8 527.4 264.9C529.6 264 532 263.8 534.3 264.2C536.7 264.7 538.8 265.8 540.5 267.5C542.2 269.2 543.3 271.3 543.8 273.7C544.2 275.1 543.1 278.4 543.1 280.6C542.2 282.8 540.6 284.7 538.7 285.1C536.7 287.3 534.4 288 532 288C530.4 288 528.9 287.7 527.4 287.1H527.4zM359.4 287.1C357.9 286.5 356.6 285.6 355.5 284.5C354.4 283.4 353.5 282.1 352.9 280.6C352.3 279.1 351.1 277.6 352 276C352 273.6 352.7 271.3 354 269.3C355.3 267.4 357.2 265.8 359.4 264.9C361.6 264 364 263.8 366.3 264.2C368.7 264.7 370.8 265.8 372.5 267.5C374.2 269.2 375.3 271.3 375.8 273.7C376.2 275.1 375.1 278.4 375.1 280.6C374.2 282.8 372.6 284.7 370.7 285.1C368.7 287.3 366.4 288 364 288C362.4 288 360.9 287.7 359.4 287.1zM443.4 267.1C441.9 266.5 440.6 265.6 439.5 264.5C438.4 263.4 437.5 262.1 436.9 260.6C436.3 259.1 435.1 257.6 436 256C436 253.6 436.7 251.3 438 249.3C439.3 247.4 441.2 245.8 443.4 244.9C445.6 244 448 243.8 450.3 244.2C452.7 244.7 454.8 245.8 456.5 247.5C458.2 249.2 459.3 251.3 459.8 253.7C460.2 255.1 459.1 258.4 459.1 260.6C458.2 262.8 456.6 264.7 454.7 265.1C452.7 267.3 450.4 267.1 448 267.1C446.4 268 444.9 267.7 443.4 267.1V267.1zM253.7 498.3C255.2 499.8 255.1 501.9 255.1 504C255.1 506.1 255.2 508.2 253.7 509.7C252.2 511.2 250.1 512 247.1 512H63.1C55.84 512 47.99 508.9 42.05 503.3C36.1 497.8 32.5 490.1 31.1 481.1L-.0009 33.98C-.2722 29.62 .3546 25.24 1.841 21.13C3.327 17.01 5.641 13.25 8.64 10.06C11.64 6.878 15.26 4.342 19.28 2.611C23.29 .8801 27.62-.0086 31.1 .0001H319.1C324.4-.0083 328.7 .8804 332.7 2.611C336.7 4.342 340.4 6.878 343.4 10.06C346.4 13.25 348.7 17.01 350.2 21.13C351.6 25.24 352.3 29.62 352 33.98L341.8 177.2C341.5 181.2 339.7 184.1 336.7 187.7C333.7 190.5 329.8 192 325.8 192H27.39L47.1 480.9C48.27 484.9 50.06 488.8 53.03 491.6C55.1 494.4 59.92 495.1 63.1 496H247.1C250.1 496 252.2 496.8 253.7 498.3H253.7zM26.24 175.1H325.8L336 32.86C336.1 30.69 335.8 28.52 335 26.48C334.3 24.43 333.1 22.57 331.6 20.99C330.1 19.41 328.3 18.15 326.3 17.29C324.3 16.44 322.2 15.1 319.1 15.1H31.1C29.8 15.99 27.63 16.44 25.61 17.31C23.6 18.18 21.78 19.46 20.28 21.06C18.78 22.67 17.63 24.56 16.89 26.63C16.15 28.7 15.85 30.9 15.1 33.09L26.24 175.1z"],
    "burger-lettuce": [512, 512, [], "e3e3", "M495.6 317.4C495.9 318.4 496.1 319.5 495.1 320.5C495.9 321.6 495.6 322.6 495.2 323.5C494.7 324.5 494.1 325.3 493.3 326C479.3 339.4 460.9 347.2 441.6 347.9C422.3 347.2 403.9 339.4 389.9 326C384.7 320.4 378.3 315.9 371.2 312.8C364.1 309.7 356.5 308.1 348.8 308.1C341.1 308.1 333.4 309.7 326.4 312.8C319.3 315.9 312.9 320.4 307.7 326C300.1 332.9 292.9 338.4 284.1 342.2C275.2 345.1 265.6 347.9 255.1 347.9C246.4 347.9 236.8 345.1 227.9 342.2C219.1 338.4 211 332.9 204.3 326C199.1 320.4 192.7 315.8 185.6 312.8C178.6 309.7 170.9 308.1 163.2 308.1C155.5 308.1 147.8 309.7 140.8 312.8C133.7 315.8 127.3 320.4 122.1 326C115.4 332.9 107.3 338.4 98.46 342.2C89.58 345.1 80.04 347.9 70.4 347.9C60.76 347.9 51.21 345.1 42.34 342.2C33.46 338.4 25.43 332.9 18.72 326C17.12 324.6 16.15 322.6 16.01 320.5C15.87 318.4 16.58 316.3 17.98 314.7C19.38 313.1 21.36 312.2 23.48 312C25.59 311.9 27.68 312.6 29.28 313.1C34.53 319.6 40.9 324.1 47.97 327.2C55.05 330.3 62.68 331.9 70.4 331.9C78.11 331.9 85.75 330.3 92.82 327.2C99.9 324.1 106.3 319.6 111.5 313.1C118.2 307.1 126.3 301.6 135.1 297.8C144 294 153.6 292.1 163.2 292.1C172.8 292.1 182.4 294 191.3 297.8C200.1 301.6 208.2 307.1 214.9 313.1C220.1 319.6 226.5 324.1 233.6 327.2C240.6 330.3 248.3 331.9 255.1 331.9C263.7 331.9 271.3 330.3 278.4 327.2C285.5 324.1 291.9 319.6 297.1 313.1C303.8 307.1 311.9 301.6 320.7 297.8C329.6 294 339.2 292.1 348.8 292.1C358.4 292.1 367.1 294 376.9 297.8C385.7 301.6 393.8 307.1 400.5 313.1C405.7 319.6 412.1 324.1 419.2 327.2C426.2 330.3 433.9 331.9 441.6 331.9C449.3 331.9 456.9 330.3 464 327.2C471.1 324.1 477.5 319.6 482.7 313.1C483.5 313.3 484.4 312.8 485.4 312.4C486.4 312.1 487.5 311.9 488.5 312C489.6 312.1 490.6 312.4 491.5 312.8C492.5 313.3 493.3 313.9 494 314.7C494.7 315.5 495.2 316.4 495.6 317.4V317.4zM49.45 282.1C44.8 280.2 40.83 276.4 37.81 271.9C34.78 267.4 32.78 262.3 31.95 256.1C31.12 251.6 31.47 246.2 32.99 240.1C44.73 190.7 73.16 145.8 113.6 113.6C154.1 81.5 204.3 64.01 255.1 64.01C307.7 64.01 357.9 81.5 398.3 113.6C438.8 145.8 467.3 190.7 479 240.1C480.5 246.2 480.9 251.6 480 256.1C479.2 262.3 477.2 267.4 474.2 271.9C471.2 276.4 467.2 280.2 462.5 282.1C457.9 285.7 452.7 287.5 447.3 288H64.67C59.29 287.5 54.09 285.7 49.45 282.1zM48.53 255.7C49.33 259.4 50.94 262.1 53.24 265.1C54.57 267.8 56.28 269.3 58.26 270.3C60.24 271.4 62.43 271.9 64.67 272H447.4C449.6 271.9 451.8 271.4 453.8 270.3C455.7 269.3 457.5 267.8 458.8 265.1C461.1 262.1 462.7 259.4 463.5 255.7C464.3 251.1 464.3 248.1 463.4 244.4C452.4 197.6 426 155.9 388.4 126.1C350.7 96.22 304.1 79.97 256 79.97C207.1 79.97 161.3 96.22 123.7 126.1C86.06 155.9 59.61 197.6 48.67 244.4C47.8 248.1 47.73 251.1 48.53 255.7H48.53zM356.7 187.3C353.7 184.3 351.1 180.2 351.1 176C351.1 172.8 352.9 169.7 354.7 167.1C356.5 164.5 358.1 162.4 361.9 161.2C364.8 160 368 159.7 371.1 160.3C374.2 160.9 377.1 162.4 379.3 164.7C381.5 166.9 383.1 169.8 383.7 172.9C384.3 175.1 383.1 179.2 382.8 182.1C381.6 185 379.5 187.5 376.9 189.3C374.3 191.1 371.2 192 367.1 192C363.8 192 359.7 190.3 356.7 187.3V187.3zM244.7 155.3C241.7 152.3 239.1 148.2 239.1 144C239.1 140.8 240.9 137.7 242.7 135.1C244.5 132.5 246.9 130.4 249.9 129.2C252.8 128 256 127.7 259.1 128.3C262.2 128.9 265.1 130.4 267.3 132.7C269.5 134.9 271.1 137.8 271.7 140.9C272.3 143.1 271.1 147.2 270.8 150.1C269.6 153 267.5 155.5 264.9 157.3C262.3 159.1 259.2 160 255.1 160C251.8 160 247.7 158.3 244.7 155.3V155.3zM132.7 187.3C129.7 184.3 127.1 180.2 127.1 176C127.1 172.8 128.9 169.7 130.7 167.1C132.5 164.5 134.9 162.4 137.9 161.2C140.8 160 144 159.7 147.1 160.3C150.2 160.9 153.1 162.4 155.3 164.7C157.5 166.9 159.1 169.8 159.7 172.9C160.3 175.1 159.1 179.2 158.8 182.1C157.6 185 155.5 187.5 152.9 189.3C150.3 191.1 147.2 192 143.1 192C139.8 192 135.7 190.3 132.7 187.3L132.7 187.3zM475.3 356.7C478.3 359.7 479.1 363.8 479.1 368V384C479.1 400.1 473.3 417.3 461.3 429.3C449.2 441.3 432.1 448 415.1 448H95.1C79.02 448 62.74 441.3 50.74 429.3C38.74 417.3 31.1 400.1 31.1 384V368C31.1 363.8 33.68 359.7 36.68 356.7C39.68 353.7 43.75 352 47.1 352H463.1C468.2 352 472.3 353.7 475.3 356.7zM463.1 368H47.1V384C47.1 396.7 53.05 408.9 62.06 417.9C71.06 426.9 83.27 432 95.1 432H415.1C428.7 432 440.9 426.9 449.9 417.9C458.9 408.9 463.1 396.7 463.1 384V368z"],
    "burger-soda": [640, 512, [], "f858", "M253.7 498.3C255.2 499.8 256 501.9 256 504C256 506.1 255.2 508.2 253.7 509.7C252.2 511.2 250.1 512 248 512H108.8C98.93 512.1 89.38 508.4 82.01 501.9C74.65 495.3 69.97 486.2 68.9 476.4L32.06 144.9C32.03 144.5 32.32 144.3 32.32 144H8C5.878 144 3.844 143.2 2.343 141.7C.8429 140.2 0 138.1 0 136C0 133.9 .8429 131.8 2.343 130.3C3.843 128.8 5.878 128 8 128H169.8L194.2 30.3C196.3 21.64 201.3 13.95 208.4 8.457C215.4 2.965 224.1-.0131 232.1 0H280C282.1 0 284.2 .8429 285.7 2.343C287.2 3.843 288 5.878 288 8C288 10.12 287.2 12.16 285.7 13.66C284.2 15.16 282.1 16 280 16H232.1C227.6 15.1 222.4 17.78 218.2 21.08C213.1 24.37 210.1 28.98 209.7 34.18L186.2 128H344C346.1 128 348.2 128.8 349.7 130.3C351.2 131.8 352 133.9 352 136C352 138.1 351.2 140.2 349.7 141.7C348.2 143.2 346.1 144 344 144H48L84.9 474.7C85.55 480.5 88.35 485.1 92.76 489.9C97.18 493.8 102.9 496 108.8 496H248C250.1 496 252.2 496.8 253.7 498.3zM443.4 267.1C441.9 266.5 440.6 265.6 439.5 264.5C438.4 263.4 437.5 262.1 436.9 260.6C436.3 259.1 435.1 257.6 436 256C436 253.6 436.7 251.3 438 249.3C439.3 247.4 441.2 245.8 443.4 244.9C445.6 244 448 243.8 450.3 244.2C452.7 244.7 454.8 245.8 456.5 247.5C458.2 249.2 459.3 251.3 459.8 253.7C460.2 255.1 459.1 258.4 459.1 260.6C458.2 262.8 456.6 264.7 454.7 265.1C452.7 267.3 450.4 267.1 448 267.1C446.4 268 444.9 267.7 443.4 267.1V267.1zM359.4 287.1C357.9 286.5 356.6 285.6 355.5 284.5C354.4 283.4 353.5 282.1 352.9 280.6C352.3 279.1 351.1 277.6 352 276C352 273.6 352.7 271.3 354 269.3C355.3 267.4 357.2 265.8 359.4 264.9C361.6 264 364 263.8 366.3 264.2C368.7 264.7 370.8 265.8 372.5 267.5C374.2 269.2 375.3 271.3 375.8 273.7C376.2 275.1 375.1 278.4 375.1 280.6C374.2 282.8 372.6 284.7 370.7 285.1C368.7 287.3 366.4 288 364 288C362.4 288 360.9 287.7 359.4 287.1zM527.4 287.1C525.9 286.5 524.6 285.6 523.5 284.5C522.4 283.4 521.5 282.1 520.9 280.6C520.3 279.1 519.1 277.6 520 276C520 273.6 520.7 271.3 522 269.3C523.3 267.4 525.2 265.8 527.4 264.9C529.6 264 532 263.8 534.3 264.2C536.7 264.7 538.8 265.8 540.5 267.5C542.2 269.2 543.3 271.3 543.8 273.7C544.2 275.1 543.1 278.4 543.1 280.6C542.2 282.8 540.6 284.7 538.7 285.1C536.7 287.3 534.4 288 532 288C530.4 288 528.9 287.7 527.4 287.1H527.4zM633.6 360.1C637.8 367.4 639.1 375.6 639.1 384C639.1 392.4 637.8 400.6 633.6 407.9C629.3 415.2 623.3 421.2 616 425.3V468C615.1 479.7 611.3 490.8 603.1 499.1C594.8 507.3 583.7 511.1 572 512H324C312.3 511.1 301.2 507.3 292.9 499.1C284.7 490.8 280 479.7 280 468V425.3C272.7 421.2 266.7 415.2 262.4 407.9C258.2 400.6 256 392.4 256 384C256 375.6 258.2 367.4 262.4 360.1C266.7 352.8 272.7 346.8 280 342.7V304C280.2 292.6 282.8 281.3 287.5 270.9C292.1 260.5 298.8 251.2 307.2 243.4C346.1 209.6 396.1 191.3 447.6 192C447.9 191.1 448.1 191.1 448.4 192C499.9 191.3 549.9 209.6 588.8 243.4C597.2 251.2 603.9 260.5 608.6 270.9C613.2 281.3 615.8 292.6 616 304V342.7C623.3 346.8 629.3 352.8 633.6 360.1zM295.9 336.8C298.5 336.3 301.2 336 303.9 336H591.9C594.6 336 597.2 336.3 599.9 336.8V304C599.7 294.7 597.6 285.5 593.7 277.1C589.9 268.6 584.3 260.1 577.5 254.7C541.6 223.9 495.7 207.2 448.4 208C448.1 208 447.9 208 447.7 208C400.3 207.2 354.3 223.8 318.4 254.7C311.5 260.1 305.1 268.6 302.1 277.1C298.3 285.5 296.2 294.7 296 304L295.9 336.8zM600 431.2C597.4 431.7 594.7 431.1 592 432H304C301.3 431.1 298.6 431.7 296 431.2V468C296 475.4 298.1 482.5 304.2 487.8C309.5 493 316.6 495.1 324 496H572C579.4 495.1 586.5 493 591.8 487.8C597 482.5 599.1 475.4 600 468V431.2zM614.6 406.6C620.6 400.6 624 392.5 624 384C624 375.5 620.6 367.4 614.6 361.4C608.6 355.4 600.5 352 592 352H304C295.5 352 287.4 355.4 281.4 361.4C275.4 367.4 272 375.5 272 384C272 392.5 275.4 400.6 281.4 406.6C287.4 412.6 295.5 416 304 416H592C600.5 416 608.6 412.6 614.6 406.6z"],
    "burrito": [512, 512, [127791], "f7ed", "M505.2 153.9c4.5-9.625 6.75-20.25 6.75-30.88c0-32.5-21.25-61.13-52.25-70.76c-6.25-20.38-21.05-37-40.55-45.75c-9.645-4.328-19.93-6.468-30.24-6.468c-10.54 0-21.09 2.233-30.88 6.718C347.5 2.165 336.6 0 325.8 0c-31.02-.002-60.52 18.06-73.7 48.3L33.94 266.6c-45.25 45.25-45.25 118.8 0 164l47.5 47.5C104.1 500.7 133.8 512 163.4 512c29.69 0 59.29-11.31 81.92-33.94l218.3-218.1C504.5 242.2 523.1 194.7 505.2 153.9zM45.26 277.9l213.6-213.8c27.9 32.26 45.11 74.01 45.11 119.9c0 101.5-82.54 184-184 184c-38.2 0-73.34-12.21-102.8-32.23C19.96 314.6 29.02 294.1 45.26 277.9zM234.1 466.7c-18.86 18.86-43.97 29.25-70.69 29.25c-26.72 0-51.82-10.39-70.69-29.25l-47.5-47.5c-18.02-18.02-27.32-41.28-28.68-64.92c30.25 18.47 65.39 29.69 103.4 29.69c95.79 0 175.8-67.39 195.3-157.3c9.377-1.514 18.88-2.69 28.68-2.69c37.7 0 72.68 11.56 101.9 31.09L234.1 466.7zM491.5 209.7c-6.133 15.66-17.92 27.98-33.17 34.95c-32.47-22.8-71.67-36.66-114.4-36.66c-8.809 0-17.39 .8907-25.89 2.027c1.113-8.539 1.885-17.18 1.885-26.03c0-51.14-19.45-97.56-51.04-132.9c11.01-21.28 32.63-35.1 56.84-35.1c8.905 0 17.59 1.832 25.83 5.446c2.049 .8985 4.238 1.348 6.426 1.348c2.275 0 4.549-.4844 6.664-1.453c7.651-3.504 15.79-5.281 24.19-5.281c8.227 0 16.21 1.709 23.73 5.082c15.3 6.865 26.87 19.93 31.75 35.85c1.551 5.057 5.502 9.02 10.55 10.59c24.52 7.614 40.1 29.91 40.1 55.47c0 8.428-1.813 16.76-5.244 24.1c-1.951 4.172-2.008 8.985-.1583 13.2C497.5 176.1 497.8 193.7 491.5 209.7zM316.1 61.24c-3.844 2.188-5.188 7.063-3 10.91c2.156 3.844 7.063 5.172 10.91 3c9.407-5.391 21.31-3.735 28.99 3.922c8.625 8.641 9.469 22.38 1.922 31.97c-2.719 3.469-2.125 8.5 1.359 11.23c1.453 1.141 3.203 1.703 4.938 1.703c2.359 0 4.719-1.047 6.297-3.063c12.53-15.95 11.16-38.8-3.203-53.16C351.5 55.03 331.7 52.36 316.1 61.24zM404.1 101.2c-3.844 2.188-5.188 7.063-3 10.91c2.156 3.844 7.032 5.172 10.91 3c9.391-5.391 21.33-3.703 28.99 3.922c8.625 8.641 9.469 22.38 1.922 31.97c-2.719 3.469-2.125 8.5 1.359 11.23c1.453 1.141 3.203 1.703 4.938 1.703c2.359 0 4.719-1.047 6.297-3.063c12.53-15.95 11.16-38.8-3.203-53.16C439.5 95.03 419.7 92.36 404.1 101.2z"],
    "burst": [512, 512, [], "e4dc", "M256 8C262.9 8 269.1 12.47 271.2 19.07L308.3 133.5L386.5 104.1C392.4 102.8 398.9 104.3 403.3 108.7C407.7 113.1 409.2 119.6 407 125.5L378.5 203.7L492.9 240.8C499.5 242.9 504 249.1 504 256C504 262.9 499.5 269.1 492.9 271.2L380.8 307.5L438.2 416.6C441.4 422.8 440.3 430.4 435.3 435.3C430.4 440.3 422.8 441.4 416.6 438.2L307.5 380.8L271.2 492.9C269.1 499.5 262.9 504 256 504C249.1 504 242.9 499.5 240.8 492.9L204.5 380.8L95.45 438.2C89.25 441.4 81.64 440.3 76.69 435.3C71.73 430.4 70.58 422.8 73.84 416.6L131.2 307.5L19.07 271.2C12.47 269.1 8 262.9 8 256C8 249.1 12.47 242.9 19.07 240.8L128.9 205.2L10.81 33.05C6.447 26.69 7.238 18.14 12.69 12.69C18.14 7.238 26.69 6.447 33.05 10.8L205.2 128.9L240.8 19.07C242.9 12.47 249.1 8 256 8H256zM256 24L220.4 133.8C217.1 143.1 204.1 148.1 196.2 142.1L24 24L142.1 196.2C148.1 204.1 143.1 217.1 133.8 220.4L24 256L136.1 292.3C145.6 295.4 149.1 306.2 145.3 314.1L88 424L197 366.7C205.8 362 216.6 366.5 219.7 375.9L256 488L292.3 375.9C295.4 366.5 306.2 362 314.1 366.7L424 424L366.7 314.1C362 306.2 366.5 295.4 375.9 292.3L488 256L373.6 218.9C364.1 216.1 360.4 206.8 363.5 198.2L392 120L313.8 148.5C305.2 151.6 295.9 147 293.1 138.4L256 24z"],
    "bus": [576, 512, [128653], "f207", "M352 48C356.4 48 360 51.58 360 56C360 60.42 356.4 64 352 64H224C219.6 64 216 60.42 216 56C216 51.58 219.6 48 224 48H352zM200 352C200 374.1 182.1 392 160 392C137.9 392 120 374.1 120 352C120 329.9 137.9 312 160 312C182.1 312 200 329.9 200 352zM160 376C173.3 376 184 365.3 184 352C184 338.7 173.3 328 160 328C146.7 328 136 338.7 136 352C136 365.3 146.7 376 160 376zM376 352C376 329.9 393.9 312 416 312C438.1 312 456 329.9 456 352C456 374.1 438.1 392 416 392C393.9 392 376 374.1 376 352zM416 328C402.7 328 392 338.7 392 352C392 365.3 402.7 376 416 376C429.3 376 440 365.3 440 352C440 338.7 429.3 328 416 328zM70.47 69.67C93.19 41.38 160.6 0 288 0C424.6 0 484.4 41.27 505.8 69.78C510.5 75.93 512 83.24 512 89.88V392C512 414.3 498.9 433.6 480 442.6V504C480 508.4 476.4 512 472 512C467.6 512 464 508.4 464 504V447.4C461.4 447.8 458.7 448 456 448H120C117.3 448 114.6 447.8 112 447.4V504C112 508.4 108.4 512 104 512C99.58 512 96 508.4 96 504V442.6C77.08 433.6 64 414.3 64 392V89.88C64 83.27 65.53 75.81 70.47 69.67zM288 16C163.5 16 101.6 56.46 82.94 79.69C81.02 82.08 80 85.54 80 89.88V96H496V89.88C496 85.57 494.1 81.98 493 79.38C475.7 56.35 421.7 16 287.1 16H288zM280 256V112H80V256H280zM296 256H496V112H296V256zM120 432H456C478.1 432 496 414.1 496 392V272H80V392C80 414.1 97.91 432 120 432zM0 136C0 122.7 10.75 112 24 112H32C36.42 112 40 115.6 40 120C40 124.4 36.42 128 32 128H24C19.58 128 16 131.6 16 136V248C16 252.4 19.58 256 24 256H32C36.42 256 40 259.6 40 264C40 268.4 36.42 272 32 272H24C10.75 272 0 261.3 0 248V136zM552 112C565.3 112 576 122.7 576 136V248C576 261.3 565.3 272 552 272H544C539.6 272 536 268.4 536 264C536 259.6 539.6 256 544 256H552C556.4 256 560 252.4 560 248V136C560 131.6 556.4 128 552 128H544C539.6 128 536 124.4 536 120C536 115.6 539.6 112 544 112H552z"],
    "bus-school": [512, 512, [], "f5dd", "M320 48C324.4 48 328 51.58 328 56C328 60.42 324.4 64 320 64H192C187.6 64 184 60.42 184 56C184 51.58 187.6 48 192 48H320zM168 344C168 366.1 150.1 384 128 384C105.9 384 88 366.1 88 344C88 321.9 105.9 304 128 304C150.1 304 168 321.9 168 344zM128 368C141.3 368 152 357.3 152 344C152 330.7 141.3 320 128 320C114.7 320 104 330.7 104 344C104 357.3 114.7 368 128 368zM424 344C424 366.1 406.1 384 384 384C361.9 384 344 366.1 344 344C344 321.9 361.9 304 384 304C406.1 304 424 321.9 424 344zM384 368C397.3 368 408 357.3 408 344C408 330.7 397.3 320 384 320C370.7 320 360 330.7 360 344C360 357.3 370.7 368 384 368zM448 78.98V260.1C467.5 276.3 480 300.7 480 328V400C480 426.5 458.5 448 432 448V504C432 508.4 428.4 512 424 512C419.6 512 416 508.4 416 504V448H96V504C96 508.4 92.42 512 88 512C83.58 512 80 508.4 80 504V448C53.49 448 32 426.5 32 400V328C32 300.7 44.46 276.3 64 260.1V78.98C64 72.4 65.52 64.83 70.66 58.7C91.12 34.32 148.8 0 256 0C370.9 0 422.4 34.2 441.7 58.81C446.5 64.97 448 72.37 448 78.98V78.98zM80 78.98V96H432V78.98C432 74.65 430.1 71.13 429.1 68.66C413.9 49.3 367.1 16 256 16C151.7 16 99.35 49.4 82.92 68.98C81.03 71.24 80 74.62 80 78.98zM80 112V249.6C92 243.5 105.6 240 120 240H248V112H80zM432 112H264V240H392C406.4 240 420 243.5 432 249.6V112zM120 256C80.24 256 48 288.2 48 328V400C48 417.7 62.33 432 80 432H432C449.7 432 464 417.7 464 400V328C464 288.2 431.8 256 392 256H120zM0 120C0 106.7 10.75 96 24 96H32C36.42 96 40 99.58 40 104C40 108.4 36.42 112 32 112H24C19.58 112 16 115.6 16 120V232C16 236.4 19.58 240 24 240H32C36.42 240 40 243.6 40 248C40 252.4 36.42 256 32 256H24C10.75 256 0 245.3 0 232V120zM488 96C501.3 96 512 106.7 512 120V232C512 245.3 501.3 256 488 256H480C475.6 256 472 252.4 472 248C472 243.6 475.6 240 480 240H488C492.4 240 496 236.4 496 232V120C496 115.6 492.4 112 488 112H480C475.6 112 472 108.4 472 104C472 99.58 475.6 96 480 96H488z"],
    "bus-simple": [448, 512, ["bus-alt"], "f55e", "M56 352C56 329.9 73.91 312 96 312C118.1 312 136 329.9 136 352C136 374.1 118.1 392 96 392C73.91 392 56 374.1 56 352zM96 328C82.75 328 72 338.7 72 352C72 365.3 82.75 376 96 376C109.3 376 120 365.3 120 352C120 338.7 109.3 328 96 328zM392 352C392 374.1 374.1 392 352 392C329.9 392 312 374.1 312 352C312 329.9 329.9 312 352 312C374.1 312 392 329.9 392 352zM352 376C365.3 376 376 365.3 376 352C376 338.7 365.3 328 352 328C338.7 328 328 338.7 328 352C328 365.3 338.7 376 352 376zM441.8 69.78C446.5 75.93 448 83.24 448 89.88V392C448 414.3 434.9 433.6 416 442.6V504C416 508.4 412.4 512 408 512C403.6 512 400 508.4 400 504V447.4C397.4 447.8 394.7 448 392 448H56C53.28 448 50.61 447.8 48 447.4V504C48 508.4 44.42 512 40 512C35.58 512 32 508.4 32 504V442.6C13.08 433.6 0 414.3 0 392V89.88C0 83.27 1.531 75.81 6.466 69.67C29.19 41.38 96.61 0 224 0C360.6 0 420.4 41.27 441.8 69.78zM16 89.88V96H432V89.88C432 85.57 430.1 81.98 429 79.38C411.7 56.35 357.7 15.1 224 15.1C99.54 15.1 37.6 56.46 18.94 79.69C17.02 82.08 16 85.54 16 89.88V89.88zM16 112V256H432V112H16zM432 272H16V392C16 414.1 33.91 432 56 432H392C414.1 432 432 414.1 432 392V272z"],
    "business-time": [640, 512, ["briefcase-clock"], "f64a", "M16 144c0-17.64 14.36-32 32-32h416c17.64 0 32 14.36 32 32V160H512V144C512 117.5 490.5 96 464 96H384V40C384 17.94 366.1 0 344 0h-176C145.9 0 128 17.94 128 40V96H48C21.49 96 0 117.5 0 144v288C0 458.5 21.49 480 48 480H320v-16H48c-17.64 0-32-14.36-32-32v-160h160v56C176 341.2 186.8 352 200 352H288v-16H200C195.6 336 192 332.4 192 328V272h128V256H16V144zM144 40c0-13.22 10.78-24 24-24h176c13.22 0 24 10.78 24 24V96h-224V40zM552 368H496V296C496 291.6 492.4 288 488 288S480 291.6 480 296v80c0 4.406 3.578 8 8 8h64c4.422 0 8-3.594 8-8S556.4 368 552 368zM496 224C416.5 224 352 288.5 352 368s64.47 144 144 144s144-64.47 144-144S575.5 224 496 224zM496 496c-70.58 0-128-57.42-128-128s57.42-128 128-128c70.58 0 128 57.42 128 128S566.6 496 496 496z"],
    "butter": [640, 512, [129480], "e3e4", "M80 112c0-17.64 14.36-32 32-32H448V288h16V80h64c17.64 0 32 14.36 32 32V288H576V112C576 85.49 554.5 64 528 64h-64H448H112C85.49 64 64 85.49 64 112V288h16V112zM632 320H8C3.594 320 0 323.6 0 328s3.594 8 8 8H32v72C32 430.1 49.94 448 72 448h496c22.06 0 40-17.94 40-40V336h24c4.406 0 8-3.578 8-8S636.4 320 632 320zM592 408c0 13.23-10.78 24-24 24H72c-13.22 0-24-10.77-24-24V336h544V408z"],
    "c": [384, 512, [99], "43", "M223.5 480c-125.2 0-223.4-101.8-223.4-223.1C.096 133.7 98.4 32 223.5 32C325.6 32 384 98.54 384 103.3c0 4.273-3.443 8-8.002 8C366.6 111.3 322.8 48 223.5 48c-116 0-207.5 94.31-207.5 208c0 113.7 91.55 207.1 207.5 207.1c99.37 0 143.2-63.25 152.5-63.25c4.562 0 8.002 3.727 8.002 8C384 413.4 325.7 480 223.5 480z"],
    "cabin": [576, 512, [], "e46d", "M248 143.1C248 121.9 265.9 103.1 288 103.1C310.1 103.1 328 121.9 328 143.1C328 166.1 310.1 183.1 288 183.1C265.9 183.1 248 166.1 248 143.1zM288 119.1C274.7 119.1 264 130.7 264 143.1C264 157.3 274.7 167.1 288 167.1C301.3 167.1 312 157.3 312 143.1C312 130.7 301.3 119.1 288 119.1V119.1zM512 271.1V287.1C512 297.6 507.8 306.1 501.2 311.1C507.8 317.9 512 326.4 512 336V352C512 361.6 507.8 370.1 501.2 376C507.8 381.9 512 390.4 512 400V416C512 425.6 507.8 434.1 501.2 440C507.8 445.9 512 454.4 512 464V480C512 497.7 497.7 512 480 512H384C366.3 512 352 497.7 352 480V464C352 454.4 356.2 445.9 362.8 440C356.2 434.1 352 425.6 352 416V400C352 390.4 356.2 381.9 362.8 376C356.2 370.1 352 361.6 352 352V336C352 326.4 356.2 317.9 362.8 311.1C356.2 306.1 352 297.6 352 287.1V271.1C352 266.2 353.6 260.7 356.3 255.1H219.7C222.4 260.7 224 266.2 224 271.1V287.1C224 297.6 219.8 306.1 213.2 311.1C219.8 317.9 224 326.4 224 336V352C224 361.6 219.8 370.1 213.2 376C219.8 381.9 224 390.4 224 400V416C224 425.6 219.8 434.1 213.2 440C219.8 445.9 224 454.4 224 464V480C224 497.7 209.7 512 192 512H96C78.33 512 64 497.7 64 480V464C64 454.4 68.19 445.9 74.83 440C68.19 434.1 64 425.6 64 416V400C64 390.4 68.19 381.9 74.83 376C68.19 370.1 64 361.6 64 352V336C64 326.4 68.19 317.9 74.83 311.1C68.19 306.1 64 297.6 64 287.1V271.1C64 266.2 65.56 260.7 68.28 255.1H37.58C21.24 255.1 8 242.8 8 226.4C8 217.4 12.12 208.9 19.18 203.3L263.1 9.538C277.7-2.03 298.3-2.03 312.9 9.538L400 78.72V56C400 42.75 410.7 31.1 424 31.1H488C501.3 31.1 512 42.75 512 56V167.7L556.8 203.3C563.9 208.9 568 217.4 568 226.4C568 242.8 554.8 256 538.4 256H507.7C510.4 260.7 512 266.2 512 272V271.1zM302.9 22.07C294.2 15.13 281.8 15.13 273.1 22.07L29.14 215.8C25.89 218.4 24 222.3 24 226.4C24 233.9 30.08 239.1 37.58 239.1H538.4C545.9 239.1 552 233.9 552 226.4C552 222.3 550.1 218.4 546.9 215.8L496.8 175.1H496V175.4L302.9 22.07zM480 432C488.8 432 496 424.8 496 416V400C496 391.2 488.8 384 480 384H384C375.2 384 368 391.2 368 400V416C368 424.8 375.2 432 384 432H480zM384 448C375.2 448 368 455.2 368 464V480C368 488.8 375.2 496 384 496H480C488.8 496 496 488.8 496 480V464C496 455.2 488.8 448 480 448H384zM496 352V336C496 327.2 488.8 319.1 480 319.1H384C375.2 319.1 368 327.2 368 336V352C368 360.8 375.2 368 384 368H480C488.8 368 496 360.8 496 352zM480 255.1H384C375.2 255.1 368 263.2 368 271.1V287.1C368 296.8 375.2 303.1 384 303.1H480C488.8 303.1 496 296.8 496 287.1V271.1C496 263.2 488.8 255.1 480 255.1zM192 432C200.8 432 208 424.8 208 416V400C208 391.2 200.8 384 192 384H96C87.16 384 80 391.2 80 400V416C80 424.8 87.16 432 96 432H192zM96 448C87.16 448 80 455.2 80 464V480C80 488.8 87.16 496 96 496H192C200.8 496 208 488.8 208 480V464C208 455.2 200.8 448 192 448H96zM208 352V336C208 327.2 200.8 319.1 192 319.1H96C87.16 319.1 80 327.2 80 336V352C80 360.8 87.16 368 96 368H192C200.8 368 208 360.8 208 352zM192 255.1H96C87.16 255.1 80 263.2 80 271.1V287.1C80 296.8 87.16 303.1 96 303.1H192C200.8 303.1 208 296.8 208 287.1V271.1C208 263.2 200.8 255.1 192 255.1zM496 154.1V55.1C496 51.58 492.4 47.1 488 47.1H424C419.6 47.1 416 51.58 416 55.1V91.43L496 154.1z"],
    "cabinet-filing": [448, 512, [128452], "f64b", "M136 400c4.422 0 8-3.578 8-8v-16c0-4.406 3.594-8 8-8h144c4.406 0 8 3.594 8 8v16c0 4.422 3.578 8 8 8S320 396.4 320 392v-16c0-13.23-10.77-24-24-24h-144C138.8 352 128 362.8 128 376v16C128 396.4 131.6 400 136 400zM296 96h-144C138.8 96 128 106.8 128 120v16C128 140.4 131.6 144 136 144S144 140.4 144 136v-16c0-4.406 3.594-8 8-8h144c4.406 0 8 3.594 8 8v16c0 4.422 3.578 8 8 8S320 140.4 320 136v-16C320 106.8 309.2 96 296 96zM384 0H64C28.66 0 0 28.66 0 64v384c0 35.34 28.66 64 64 64h320c35.34 0 64-28.66 64-64V64C448 28.66 419.3 0 384 0zM432 448c0 26.47-21.53 48-48 48H64c-26.47 0-48-21.53-48-48V264h416V448zM432 248h-416V64c0-26.47 21.53-48 48-48h320c26.47 0 48 21.53 48 48V248z"],
    "cable-car": [512, 512, [], "e0cf", "M320 32C320 49.67 305.7 64 288 64C270.3 64 256 49.67 256 32C256 14.33 270.3 0 288 0C305.7 0 320 14.33 320 32zM288 16C279.2 16 272 23.16 272 32C272 40.84 279.2 48 288 48C296.8 48 304 40.84 304 32C304 23.16 296.8 16 288 16zM160 64C160 46.33 174.3 32 192 32C209.7 32 224 46.33 224 64C224 81.67 209.7 96 192 96C174.3 96 160 81.67 160 64zM192 80C200.8 80 208 72.84 208 64C208 55.16 200.8 48 192 48C183.2 48 176 55.16 176 64C176 72.84 183.2 80 192 80zM80 304C80 286.3 94.33 272 112 272H400C417.7 272 432 286.3 432 304V368C432 385.7 417.7 400 400 400H112C94.33 400 80 385.7 80 368V304zM96 368C96 376.8 103.2 384 112 384H192V288H112C103.2 288 96 295.2 96 304V368zM304 384V288H208V384H304zM320 384H400C408.8 384 416 376.8 416 368V304C416 295.2 408.8 288 400 288H320V384zM480 288V448C480 483.3 451.3 512 416 512H96C60.65 512 32 483.3 32 448V288C32 252.7 60.65 224 96 224H247.1V130L9.762 183.8C5.452 184.8 1.17 182.1 .1962 177.8C-.777 173.5 1.928 169.2 6.238 168.2L502.2 56.2C506.5 55.22 510.8 57.93 511.8 62.24C512.8 66.55 510.1 70.83 505.8 71.8L264 126.4V223.1H416C451.3 223.1 480 252.7 480 287.1L480 288zM416 240H96C69.49 240 48 261.5 48 288V448C48 474.5 69.49 496 96 496H416C442.5 496 464 474.5 464 448V288C464 261.5 442.5 240 416 240z"],
    "cactus": [512, 512, [127797], "f8a7", "M464 224c-26.5 0-48 21.5-48 47.1v32c0 8.875-7.125 15.1-16 15.1H352V144h24c4.422 0 8-3.578 8-7.1s-3.578-7.1-8-7.1H352V101.4c0-51.1-38.88-98.5-90.88-101.2C259.5 .0418 257.7 0 256.1 0c-24.5-.002-48.15 9.408-66.06 26.38C170.9 44.51 160 69.63 160 96v127.1L112 224c-8.875 0-16-7.125-16-15.1V176c0-26.5-21.5-47.1-48-47.1S0 149.5 0 176v31.1c0 61.87 50.13 111.1 112 111.1H160v63.1H136c-4.422 0-8 3.578-8 7.1s3.578 7.1 8 7.1H160v79.1C160 497.6 174.4 512 192 512h128c17.62 0 32-14.37 32-31.1v-63.1l48-.0004c61.88 0 112-50.12 112-111.1V272C512 245.5 490.5 224 464 224zM160 304L112 304c-52.94 0-96-43.07-96-95.1V176c0-17.64 14.36-31.1 32-31.1s32 14.36 32 31.1v31.1c0 17.64 14.36 31.1 32 31.1H160V304zM336 480c0 8.822-7.178 15.1-16 15.1H192c-8.822 0-16-7.178-16-15.1V96c0-21.81 9.113-42.95 25.01-58.01c14.97-14.18 34.54-21.1 55.12-21.99c1.387 0 2.777 .0352 4.16 .1074C302 18.32 336 56.57 336 101.4V480zM496 304c0 52.93-43.06 95.1-96 95.1H352V336l48 0c17.64 0 32-14.36 32-31.1V272c0-17.64 14.36-31.1 32-31.1s32 14.36 32 31.1V304zM224 144c-8.875 0-16 7.125-16 15.1S215.1 176 224 176s16-7.125 16-15.1C240 151.1 232.9 144 224 144zM288 368c-8.875 0-16 7.125-16 15.1c0 8.875 7.125 15.1 16 15.1s16-7.125 16-15.1C304 375.1 296.9 368 288 368z"],
    "cake-candles": [448, 512, [127874, "birthday-cake", "cake"], "f1fd", "M383.1 223.1L360 223.9V167.9c0-4.423-3.578-7.946-8-7.946s-8 3.523-8 7.946v56.02h-112V167.9c0-4.423-3.578-7.946-8-7.946S216 163.5 216 167.9v56.02h-112V167.9c0-4.423-3.578-7.946-8-7.946S88 163.5 88 167.9v56.02L64 223.1c-35.35 0-64 28.64-64 63.1v192C0 497.7 14.33 512 32 512h384c17.67 0 32-14.32 32-32V287.1C448 252.6 419.3 223.1 383.1 223.1zM432 479.1c0 8.825-7.178 16.01-16 16.01H32c-8.822 0-16-7.18-16-16.01v-90.45c5.236 1.381 10.56 2.417 16 2.417c26.89 0 52.84-19.55 64-29.17c11.16 9.612 37.11 29.17 64 29.17s52.84-19.55 64-29.17c11.16 9.612 37.11 29.17 64 29.17s52.84-19.55 64-29.17c11.16 9.612 37.11 29.17 64 29.17c5.438 0 10.76-1.035 16-2.417V479.1zM432 372.8c-5.262 1.766-10.61 3.11-16 3.11c-28.25 0-58.05-29.37-58.34-29.67c-3.125-3.126-8.188-3.126-11.31 0C346 346.6 316.3 375.1 288 375.1s-58.05-29.37-58.34-29.67c-3.125-3.126-8.188-3.126-11.31 0C218 346.6 188.3 375.1 160 375.1s-58.05-29.37-58.34-29.67c-3.125-3.126-8.188-3.126-11.31 0C90.05 346.6 60.25 375.1 32 375.1c-5.389 0-10.74-1.344-16-3.11V287.9c0-26.48 21.53-48.02 48-48.02h24v40.01c0 4.423 3.578 8.038 8 8.038s8-3.615 8-8.038V239.9h112v40.01c0 4.423 3.578 8.038 8 8.038s8-3.615 8-8.038V239.9h112v40.01c0 4.423 3.578 8.038 8 8.038s8-3.615 8-8.038V239.9H384c26.47 0 48 21.54 48 48.02V372.8zM224 127.9c26.47 0 48-21.54 48-48.02c0-24.21-37.48-71.7-41.75-77.03c-3.062-3.782-9.438-3.782-12.5 0C213.5 8.166 176 55.65 176 79.86C176 106.3 197.5 127.9 224 127.9zM224 20.92c14.33 19.15 32 46.76 32 58.94c0 17.65-14.36 32.11-32 32.11S192 97.51 192 79.86C192 67.69 209.7 40.07 224 20.92zM352 127.9c26.47 0 48-21.54 48-48.02c0-24.21-37.48-71.7-41.75-77.03c-3.062-3.782-9.438-3.782-12.5 0C341.5 8.166 304 55.65 304 79.86C304 106.3 325.5 127.9 352 127.9zM352 20.92c14.33 19.15 32 46.76 32 58.94c0 17.65-14.36 32.11-32 32.11s-32-14.46-32-32.11C320 67.69 337.7 40.07 352 20.92zM96 127.9c26.47 0 48-21.54 48-48.02c0-24.21-37.48-71.7-41.75-77.03c-3.062-3.782-9.438-3.782-12.5 0C85.48 8.166 48 55.65 48 79.86C48 106.3 69.53 127.9 96 127.9zM96 20.92c14.33 19.15 32 46.76 32 58.94c0 17.65-14.36 32.11-32 32.11S64 97.51 64 79.86C64 67.69 81.67 40.07 96 20.92z"],
    "cake-slice": [512, 512, [127856, "shortcake"], "e3e5", "M450.6 101.7C490 143.4 512 198.6 512 256V448C512 456.5 508.6 464.6 502.6 470.6C496.6 476.6 488.5 480 480 480H32C23.51 480 15.37 476.6 9.372 470.6C3.371 464.6 0 456.5 0 448V271.6C.0064 266.8 1.122 261.1 3.262 257.6C5.403 253.2 8.511 249.4 12.35 246.4L278.8 39.01C284.5 34.45 291.5 31.97 298.8 32H299.9C357.2 35.11 411.1 60.07 450.6 101.7zM496 400H16V448C16 452.2 17.69 456.3 20.69 459.3C23.69 462.3 27.76 464 32 464H480C484.2 464 488.3 462.3 491.3 459.3C494.3 456.3 496 452.2 496 448V400zM496 352H16V384H496V352zM496 272H16V336H496V272zM496 256C496 202.7 475.6 151.4 438.9 112.7C402.2 74 352.1 50.84 298.9 48C295.2 47.98 291.7 49.21 288.8 51.49L26.02 256H496z"],
    "calculator": [384, 512, [128425], "f1ec", "M80 256h32C120.8 256 128 248.8 128 240v-32C128 199.2 120.8 192 112 192h-32C71.16 192 64 199.2 64 208v32C64 248.8 71.16 256 80 256zM80 208h32v32h-32V208zM64 336C64 344.8 71.16 352 80 352h32C120.8 352 128 344.8 128 336v-32C128 295.2 120.8 288 112 288h-32C71.16 288 64 295.2 64 304V336zM80 304h32v32h-32V304zM208 384h-128C71.16 384 64 391.2 64 400v32C64 440.8 71.16 448 80 448h128c8.836 0 16-7.164 16-16v-32C224 391.2 216.8 384 208 384zM208 432h-128v-32h128V432zM304 288h-32C263.2 288 256 295.2 256 304v32c0 8.836 7.164 16 16 16h32c8.836 0 16-7.164 16-16v-32C320 295.2 312.8 288 304 288zM304 336h-32v-32h32V336zM288 64H96C78.33 64 64 78.33 64 96v32c0 17.67 14.33 32 32 32h192c17.67 0 32-14.33 32-32V96C320 78.33 305.7 64 288 64zM304 128c0 8.822-7.178 16-16 16H96C87.18 144 80 136.8 80 128V96c0-8.822 7.178-16 16-16h192c8.822 0 16 7.178 16 16V128zM304 192h-32C263.2 192 256 199.2 256 208v32C256 248.8 263.2 256 272 256h32C312.8 256 320 248.8 320 240v-32C320 199.2 312.8 192 304 192zM304 240h-32v-32h32V240zM320 0H64C28.66 0 0 28.66 0 64v384c0 35.34 28.66 64 64 64h256c35.34 0 64-28.66 64-64V64C384 28.66 355.3 0 320 0zM368 448c0 26.47-21.53 48-48 48H64c-26.47 0-48-21.53-48-48V64c0-26.47 21.53-48 48-48h256c26.47 0 48 21.53 48 48V448zM208 192h-32C167.2 192 160 199.2 160 208v32C160 248.8 167.2 256 176 256h32C216.8 256 224 248.8 224 240v-32C224 199.2 216.8 192 208 192zM208 240h-32v-32h32V240zM208 288h-32C167.2 288 160 295.2 160 304v32C160 344.8 167.2 352 176 352h32c8.836 0 16-7.164 16-16v-32C224 295.2 216.8 288 208 288zM208 336h-32v-32h32V336zM304 384h-32c-8.836 0-16 7.164-16 16v32c0 8.836 7.164 16 16 16h32c8.836 0 16-7.164 16-16v-32C320 391.2 312.8 384 304 384zM304 432h-32v-32h32V432z"],
    "calculator-simple": [512, 512, ["calculator-alt"], "f64c", "M40 120h144C188.4 120 192 116.4 192 112S188.4 104 184 104h-144C35.59 104 32 107.6 32 112S35.59 120 40 120zM328 120h64v64c0 4.406 3.594 8.042 8 8.042S408 188.4 408 184v-64h64c4.406 0 8-3.552 8-7.958S476.4 104 472 104h-64v-64c0-4.406-3.594-7.958-8-7.958S392 35.59 392 40v64h-64C323.6 104 320 107.6 320 112S323.6 120 328 120zM168.6 343.4c-3.115-3.115-8.197-3.115-11.31 0L112 388.7l-45.25-45.25c-3.117-3.115-8.199-3.115-11.31 0s-3.115 8.197 0 11.31L100.7 400l-45.25 45.25c-3.115 3.117-3.115 8.199 0 11.31s8.197 3.115 11.31 0L112 411.3l45.25 45.25c3.117 3.115 8.199 3.115 11.31 0s3.115-8.197 0-11.31L123.3 400l45.25-45.25C171.7 351.6 171.7 346.5 168.6 343.4zM472 360h-144c-4.406 0-8 3.594-8 8s3.594 8 8 8h144c4.406 0 8-3.594 8-8S476.4 360 472 360zM472 424h-144c-4.406 0-8 3.594-8 8s3.594 8 8 8h144c4.406 0 8-3.594 8-8S476.4 424 472 424zM504 248h-240v-240C264 3.578 260.4 0 256 0S248 3.578 248 8v240h-240C3.594 248 0 251.6 0 256s3.594 8 8 8h240v240C248 508.4 251.6 512 256 512s8-3.578 8-8v-240h240C508.4 264 512 260.4 512 256S508.4 248 504 248z"],
    "calendar": [448, 512, [128198, 128197], "f133", "M120 0C124.4 0 128 3.582 128 8V64H320V8C320 3.582 323.6 0 328 0C332.4 0 336 3.582 336 8V64H384C419.3 64 448 92.65 448 128V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H112V8C112 3.582 115.6 0 120 0zM432 192H16V448C16 474.5 37.49 496 64 496H384C410.5 496 432 474.5 432 448V192zM112 120V80H64C37.49 80 16 101.5 16 128V176H432V128C432 101.5 410.5 80 384 80H336V120C336 124.4 332.4 128 328 128C323.6 128 320 124.4 320 120V80H128V120C128 124.4 124.4 128 120 128C115.6 128 112 124.4 112 120z"],
    "calendar-arrow-down": [448, 512, ["calendar-download"], "e0d0", "M232 404.7L306.3 330.3C309.5 327.2 314.5 327.2 317.7 330.3C320.8 333.5 320.8 338.5 317.7 341.7L229.7 429.7C226.5 432.8 221.5 432.8 218.3 429.7L130.3 341.7C127.2 338.5 127.2 333.5 130.3 330.3C133.5 327.2 138.5 327.2 141.7 330.3L215.1 404.7V248C215.1 243.6 219.6 240 223.1 240C228.4 240 232 243.6 232 248L232 404.7zM128 64H320V8C320 3.582 323.6 0 328 0C332.4 0 336 3.582 336 8V64H384C419.3 64 448 92.65 448 128V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H112V8C112 3.582 115.6 0 120 0C124.4 0 128 3.582 128 8V64zM16 448C16 474.5 37.49 496 64 496H384C410.5 496 432 474.5 432 448V192H16V448zM64 80C37.49 80 16 101.5 16 128V176H432V128C432 101.5 410.5 80 384 80H336V120C336 124.4 332.4 128 328 128C323.6 128 320 124.4 320 120V80H128V120C128 124.4 124.4 128 120 128C115.6 128 112 124.4 112 120V80H64z"],
    "calendar-arrow-up": [448, 512, ["calendar-upload"], "e0d1", "M216 267.3L141.7 341.7C138.5 344.8 133.5 344.8 130.3 341.7C127.2 338.5 127.2 333.5 130.3 330.3L218.3 242.3C221.5 239.2 226.5 239.2 229.7 242.3L317.7 330.3C320.8 333.5 320.8 338.5 317.7 341.7C314.5 344.8 309.5 344.8 306.3 341.7L232 267.3V424C232 428.4 228.4 432 224 432C219.6 432 216 428.4 216 424L216 267.3zM128 64H320V8C320 3.582 323.6 0 328 0C332.4 0 336 3.582 336 8V64H384C419.3 64 448 92.65 448 128V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H112V8C112 3.582 115.6 0 120 0C124.4 0 128 3.582 128 8V64zM16 448C16 474.5 37.49 496 64 496H384C410.5 496 432 474.5 432 448V192H16V448zM64 80C37.49 80 16 101.5 16 128V176H432V128C432 101.5 410.5 80 384 80H336V120C336 124.4 332.4 128 328 128C323.6 128 320 124.4 320 120V80H128V120C128 124.4 124.4 128 120 128C115.6 128 112 124.4 112 120V80H64z"],
    "calendar-check": [448, 512, [], "f274", "M213.7 405.7C210.5 408.8 205.5 408.8 202.3 405.7L130.3 333.7C127.2 330.5 127.2 325.5 130.3 322.3C133.5 319.2 138.5 319.2 141.7 322.3L208 388.7L322.3 274.3C325.5 271.2 330.5 271.2 333.7 274.3C336.8 277.5 336.8 282.5 333.7 285.7L213.7 405.7zM128 64H320V8C320 3.582 323.6 0 328 0C332.4 0 336 3.582 336 8V64H384C419.3 64 448 92.65 448 128V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H112V8C112 3.582 115.6 0 120 0C124.4 0 128 3.582 128 8V64zM16 448C16 474.5 37.49 496 64 496H384C410.5 496 432 474.5 432 448V192H16V448zM64 80C37.49 80 16 101.5 16 128V176H432V128C432 101.5 410.5 80 384 80H336V120C336 124.4 332.4 128 328 128C323.6 128 320 124.4 320 120V80H128V120C128 124.4 124.4 128 120 128C115.6 128 112 124.4 112 120V80H64z"],
    "calendar-circle-exclamation": [576, 512, [], "e46e", "M120 0C124.4 0 128 3.582 128 8V64H320V8C320 3.582 323.6 0 328 0C332.4 0 336 3.582 336 8V64H384C419.3 64 448 92.65 448 128V192H16V448C16 474.5 37.49 496 64 496H311.2C317.3 501.8 323.9 507.1 330.8 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H112V8C112 3.582 115.6 0 120 0zM112 120V80H64C37.49 80 16 101.5 16 128V176H432V128C432 101.5 410.5 80 384 80H336V120C336 124.4 332.4 128 328 128C323.6 128 320 124.4 320 120V80H128V120C128 124.4 124.4 128 120 128C115.6 128 112 124.4 112 120zM448 432C448 440.8 440.8 448 432 448C423.2 448 416 440.8 416 432C416 423.2 423.2 416 432 416C440.8 416 448 423.2 448 432zM439.1 384C439.1 388.4 436.4 392 431.1 392C427.6 392 423.1 388.4 423.1 384V288C423.1 283.6 427.6 280 431.1 280C436.4 280 439.1 283.6 439.1 288V384zM288 368C288 288.5 352.5 224 432 224C511.5 224 576 288.5 576 368C576 447.5 511.5 512 432 512C352.5 512 288 447.5 288 368zM432 496C502.7 496 560 438.7 560 368C560 297.3 502.7 240 432 240C361.3 240 304 297.3 304 368C304 438.7 361.3 496 432 496z"],
    "calendar-circle-minus": [576, 512, [], "e46f", "M120 0C124.4 0 128 3.582 128 8V64H320V8C320 3.582 323.6 0 328 0C332.4 0 336 3.582 336 8V64H384C419.3 64 448 92.65 448 128V192H16V448C16 474.5 37.49 496 64 496H311.2C317.3 501.8 323.9 507.1 330.8 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H112V8C112 3.582 115.6 0 120 0zM112 120V80H64C37.49 80 16 101.5 16 128V176H432V128C432 101.5 410.5 80 384 80H336V120C336 124.4 332.4 128 328 128C323.6 128 320 124.4 320 120V80H128V120C128 124.4 124.4 128 120 128C115.6 128 112 124.4 112 120zM360 375.1C355.6 375.1 352 372.4 352 367.1C352 363.6 355.6 359.1 360 359.1H504C508.4 359.1 512 363.6 512 367.1C512 372.4 508.4 375.1 504 375.1H360zM576 368C576 447.5 511.5 512 432 512C352.5 512 288 447.5 288 368C288 288.5 352.5 224 432 224C511.5 224 576 288.5 576 368zM432 240C361.3 240 304 297.3 304 368C304 438.7 361.3 496 432 496C502.7 496 560 438.7 560 368C560 297.3 502.7 240 432 240z"],
    "calendar-circle-plus": [576, 512, [], "e470", "M120 0C124.4 0 128 3.582 128 8V64H320V8C320 3.582 323.6 0 328 0C332.4 0 336 3.582 336 8V64H384C419.3 64 448 92.65 448 128V192H16V448C16 474.5 37.49 496 64 496H311.2C317.3 501.8 323.9 507.1 330.8 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H112V8C112 3.582 115.6 0 120 0zM112 120V80H64C37.49 80 16 101.5 16 128V176H432V128C432 101.5 410.5 80 384 80H336V120C336 124.4 332.4 128 328 128C323.6 128 320 124.4 320 120V80H128V120C128 124.4 124.4 128 120 128C115.6 128 112 124.4 112 120zM432 287.1C436.4 287.1 440 291.6 440 295.1V359.1H504C508.4 359.1 512 363.6 512 367.1C512 372.4 508.4 375.1 504 375.1H440V439.1C440 444.4 436.4 447.1 432 447.1C427.6 447.1 424 444.4 424 439.1V375.1H360C355.6 375.1 352 372.4 352 367.1C352 363.6 355.6 359.1 360 359.1H424V295.1C424 291.6 427.6 287.1 432 287.1zM288 368C288 288.5 352.5 224 432 224C511.5 224 576 288.5 576 368C576 447.5 511.5 512 432 512C352.5 512 288 447.5 288 368zM432 496C502.7 496 560 438.7 560 368C560 297.3 502.7 240 432 240C361.3 240 304 297.3 304 368C304 438.7 361.3 496 432 496z"],
    "calendar-circle-user": [576, 512, [], "e471", "M120 0C124.4 0 128 3.582 128 8V64H320V8C320 3.582 323.6 0 328 0C332.4 0 336 3.582 336 8V64H384C419.3 64 448 92.65 448 128V192H16V448C16 474.5 37.49 496 64 496H311.2C317.3 501.8 323.9 507.1 330.8 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H112V8C112 3.582 115.6 0 120 0zM112 120V80H64C37.49 80 16 101.5 16 128V176H432V128C432 101.5 410.5 80 384 80H336V120C336 124.4 332.4 128 328 128C323.6 128 320 124.4 320 120V80H128V120C128 124.4 124.4 128 120 128C115.6 128 112 124.4 112 120zM480 336C480 362.5 458.5 384 432 384C405.5 384 384 362.5 384 336C384 309.5 405.5 288 432 288C458.5 288 480 309.5 480 336zM432 304C414.3 304 400 318.3 400 336C400 353.7 414.3 368 432 368C449.7 368 464 353.7 464 336C464 318.3 449.7 304 432 304zM288 368C288 288.5 352.5 224 432 224C511.5 224 576 288.5 576 368C576 447.5 511.5 512 432 512C352.5 512 288 447.5 288 368zM432 496C461.3 496 488.3 486.2 509.9 469.6L506.5 462.1C497 443.1 477.7 432 456.4 432H407.6C386.3 432 366.1 443.1 357.5 462.1L354.1 469.6C375.7 486.2 402.7 496 432 496zM520.8 455.8L522.3 458.7C545.6 435.5 560 403.5 560 368C560 297.3 502.7 240 432 240C361.3 240 304 297.3 304 368C304 403.5 318.4 435.5 341.7 458.7L343.2 455.8C355.4 431.4 380.3 416 407.6 416H456.4C483.7 416 508.6 431.4 520.8 455.8z"],
    "calendar-clock": [576, 512, ["calendar-time"], "e0d2", "M120 0C124.4 0 128 3.582 128 8V64H320V8C320 3.582 323.6 0 328 0C332.4 0 336 3.582 336 8V64H384C419.3 64 448 92.65 448 128V192.7C442.7 192.2 437.4 192 432 192H16V448C16 474.5 37.49 496 64 496H311.2C317.3 501.8 323.9 507.1 330.8 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H112V8C112 3.582 115.6 0 120 0zM112 120V80H64C37.49 80 16 101.5 16 128V176H432V128C432 101.5 410.5 80 384 80H336V120C336 124.4 332.4 128 328 128C323.6 128 320 124.4 320 120V80H128V120C128 124.4 124.4 128 120 128C115.6 128 112 124.4 112 120zM431.1 288C436.4 288 439.1 291.6 439.1 296V360H488C492.4 360 496 363.6 496 368C496 372.4 492.4 376 488 376H431.1C427.6 376 423.1 372.4 423.1 368V296C423.1 291.6 427.6 288 431.1 288V288zM288 368C288 288.5 352.5 224 432 224C511.5 224 576 288.5 576 368C576 447.5 511.5 512 432 512C352.5 512 288 447.5 288 368zM432 496C502.7 496 560 438.7 560 368C560 297.3 502.7 240 432 240C361.3 240 304 297.3 304 368C304 438.7 361.3 496 432 496z"],
    "calendar-day": [448, 512, [], "f783", "M64 288C64 270.3 78.33 256 96 256H160C177.7 256 192 270.3 192 288V352C192 369.7 177.7 384 160 384H96C78.33 384 64 369.7 64 352V288zM80 352C80 360.8 87.16 368 96 368H160C168.8 368 176 360.8 176 352V288C176 279.2 168.8 272 160 272H96C87.16 272 80 279.2 80 288V352zM128 64H320V8C320 3.582 323.6 0 328 0C332.4 0 336 3.582 336 8V64H384C419.3 64 448 92.65 448 128V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H112V8C112 3.582 115.6 0 120 0C124.4 0 128 3.582 128 8V64zM16 448C16 474.5 37.49 496 64 496H384C410.5 496 432 474.5 432 448V192H16V448zM64 80C37.49 80 16 101.5 16 128V176H432V128C432 101.5 410.5 80 384 80H336V120C336 124.4 332.4 128 328 128C323.6 128 320 124.4 320 120V80H128V120C128 124.4 124.4 128 120 128C115.6 128 112 124.4 112 120V80H64z"],
    "calendar-days": [448, 512, ["calendar-alt"], "f073", "M128 64H320V8C320 3.582 323.6 0 328 0C332.4 0 336 3.582 336 8V64H384C419.3 64 448 92.65 448 128V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H112V8C112 3.582 115.6 0 120 0C124.4 0 128 3.582 128 8V64zM432 288V192H304V288H432zM288 192H160V288H288V192zM144 192H16V288H144V192zM16 304V400H144V304H16zM16 416V448C16 474.5 37.49 496 64 496H144V416H16zM160 496H288V416H160V496zM304 496H384C410.5 496 432 474.5 432 448V416H304V496zM432 400V304H304V400H432zM64 80C37.49 80 16 101.5 16 128V176H432V128C432 101.5 410.5 80 384 80H336V120C336 124.4 332.4 128 328 128C323.6 128 320 124.4 320 120V80H128V120C128 124.4 124.4 128 120 128C115.6 128 112 124.4 112 120V80H64zM288 304H160V400H288V304z"],
    "calendar-exclamation": [448, 512, [], "f334", "M240 416C240 424.8 232.8 432 224 432C215.2 432 208 424.8 208 416C208 407.2 215.2 400 224 400C232.8 400 240 407.2 240 416zM232 360C232 364.4 228.4 368 224 368C219.6 368 216 364.4 216 360V248C216 243.6 219.6 240 224 240C228.4 240 232 243.6 232 248V360zM120 0C124.4 0 128 3.582 128 8V64H320V8C320 3.582 323.6 0 328 0C332.4 0 336 3.582 336 8V64H384C419.3 64 448 92.65 448 128V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H112V8C112 3.582 115.6 0 120 0zM432 192H16V448C16 474.5 37.49 496 64 496H384C410.5 496 432 474.5 432 448V192zM112 120V80H64C37.49 80 16 101.5 16 128V176H432V128C432 101.5 410.5 80 384 80H336V120C336 124.4 332.4 128 328 128C323.6 128 320 124.4 320 120V80H128V120C128 124.4 124.4 128 120 128C115.6 128 112 124.4 112 120z"],
    "calendar-heart": [448, 512, [], "e0d3", "M224 283.4L237.3 269.7C259.2 247.1 295.4 247.1 317.3 269.7C338.4 291.3 338.4 325.8 317.3 347.5L241.2 425.8C231.8 435.5 216.2 435.5 206.8 425.8L130.7 347.5C109.6 325.8 109.6 291.3 130.7 269.7C152.6 247.1 188.8 247.1 210.7 269.7L224 283.4zM142.1 336.3L218.3 414.6C221.4 417.9 226.6 417.9 229.7 414.6L305.9 336.3C320.9 320.9 320.9 296.3 305.9 280.8C290.2 264.8 264.4 264.8 248.8 280.8L224 306.3L199.2 280.8C183.6 264.8 157.8 264.8 142.1 280.8C127.1 296.3 127.1 320.9 142.1 336.3zM128 64H320V8C320 3.582 323.6 0 328 0C332.4 0 336 3.582 336 8V64H384C419.3 64 448 92.65 448 128V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H112V8C112 3.582 115.6 0 120 0C124.4 0 128 3.582 128 8V64zM16 448C16 474.5 37.49 496 64 496H384C410.5 496 432 474.5 432 448V192H16V448zM64 80C37.49 80 16 101.5 16 128V176H432V128C432 101.5 410.5 80 384 80H336V120C336 124.4 332.4 128 328 128C323.6 128 320 124.4 320 120V80H128V120C128 124.4 124.4 128 120 128C115.6 128 112 124.4 112 120V80H64z"],
    "calendar-image": [448, 512, [], "e0d4", "M236.6 277.1C245.1 264.4 266 264.2 275.7 277.5L371.1 409.9C383.5 425.7 372.2 448 352.6 448H95.09C75.57 448 64.22 425.9 75.56 410.1L126.5 338.7C135.1 326.7 152.5 325.2 163 335.7L182.9 355.6L236.6 277.1zM262.8 286.9C259.5 282.5 252.9 282.6 249.7 287.1L190.6 372.6C189.2 374.5 187.1 375.8 184.7 375.1C182.4 376.2 180 375.3 178.3 373.7L151.7 347C148.2 343.5 142.4 343.1 139.5 348L88.58 419.4C84.8 424.6 88.58 432 95.09 432H352.6C359.1 432 362.9 424.6 359 419.3L262.8 286.9zM144 272C144 289.7 129.7 304 112 304C94.33 304 80 289.7 80 272C80 254.3 94.33 240 112 240C129.7 240 144 254.3 144 272zM112 288C120.8 288 128 280.8 128 272C128 263.2 120.8 256 112 256C103.2 256 96 263.2 96 272C96 280.8 103.2 288 112 288zM120 0C124.4 0 128 3.582 128 8V64H320V8C320 3.582 323.6 0 328 0C332.4 0 336 3.582 336 8V64H384C419.3 64 448 92.65 448 128V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H112V8C112 3.582 115.6 0 120 0zM432 192H16V448C16 474.5 37.49 496 64 496H384C410.5 496 432 474.5 432 448V192zM112 120V80H64C37.49 80 16 101.5 16 128V176H432V128C432 101.5 410.5 80 384 80H336V120C336 124.4 332.4 128 328 128C323.6 128 320 124.4 320 120V80H128V120C128 124.4 124.4 128 120 128C115.6 128 112 124.4 112 120z"],
    "calendar-lines": [448, 512, ["calendar-note"], "e0d5", "M96 392C96 387.6 99.58 384 104 384H248C252.4 384 256 387.6 256 392C256 396.4 252.4 400 248 400H104C99.58 400 96 396.4 96 392zM344 288C348.4 288 352 291.6 352 296C352 300.4 348.4 304 344 304H104C99.58 304 96 300.4 96 296C96 291.6 99.58 288 104 288H344zM120 0C124.4 0 128 3.582 128 8V64H320V8C320 3.582 323.6 0 328 0C332.4 0 336 3.582 336 8V64H384C419.3 64 448 92.65 448 128V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H112V8C112 3.582 115.6 0 120 0zM432 192H16V448C16 474.5 37.49 496 64 496H384C410.5 496 432 474.5 432 448V192zM112 120V80H64C37.49 80 16 101.5 16 128V176H432V128C432 101.5 410.5 80 384 80H336V120C336 124.4 332.4 128 328 128C323.6 128 320 124.4 320 120V80H128V120C128 124.4 124.4 128 120 128C115.6 128 112 124.4 112 120z"],
    "calendar-lines-pen": [576, 512, [], "e472", "M128 64H320V8C320 3.582 323.6 0 328 0C332.4 0 336 3.582 336 8V64H384C419.3 64 448 92.65 448 128V192H16V448C16 474.5 37.49 496 64 496H256C256 501.5 256.1 506.9 258.8 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H112V8C112 3.582 115.6 0 120 0C124.4 0 128 3.582 128 8V64zM64 80C37.49 80 16 101.5 16 128V176H432V128C432 101.5 410.5 80 384 80H336V120C336 124.4 332.4 128 328 128C323.6 128 320 124.4 320 120V80H128V120C128 124.4 124.4 128 120 128C115.6 128 112 124.4 112 120V80H64zM248 384C252.4 384 256 387.6 256 392C256 396.4 252.4 400 248 400H104C99.58 400 96 396.4 96 392C96 387.6 99.58 384 104 384H248zM96 296C96 291.6 99.58 288 104 288H344C348.4 288 352 291.6 352 296C352 300.4 348.4 304 344 304H104C99.58 304 96 300.4 96 296zM292.7 507.2C288.7 503.2 287.1 497.4 288.5 491.1L303.5 431.8C304.9 426.2 307.8 421.1 311.9 416.1L493.2 235.7C508.8 220.1 534.1 220.1 549.8 235.7L564.1 250.1C579.8 265.7 579.8 291 564.1 306.7L382.9 487.9C378.8 492 373.6 494.9 368 496.3L307.9 511.4C302.4 512.7 296.7 511.1 292.7 507.2L292.7 507.2zM304 495.8L364.1 480.8C366.9 480.1 369.5 478.7 371.6 476.6L514.4 333.7L466.1 285.4L323.2 428.3C321.2 430.3 319.7 432.9 319 435.7L304 495.8zM552.8 261.4L538.4 247C529.1 237.7 513.9 237.7 504.5 247L477.4 274.1L525.7 322.4L552.8 295.4C562.2 285.1 562.2 270.8 552.8 261.4L552.8 261.4zM364.6 482.8L368 496.3z"],
    "calendar-minus": [448, 512, [], "f272", "M136 352C131.6 352 128 348.4 128 344C128 339.6 131.6 336 136 336H312C316.4 336 320 339.6 320 344C320 348.4 316.4 352 312 352H136zM128 64H320V8C320 3.582 323.6 0 328 0C332.4 0 336 3.582 336 8V64H384C419.3 64 448 92.65 448 128V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H112V8C112 3.582 115.6 0 120 0C124.4 0 128 3.582 128 8V64zM16 448C16 474.5 37.49 496 64 496H384C410.5 496 432 474.5 432 448V192H16V448zM64 80C37.49 80 16 101.5 16 128V176H432V128C432 101.5 410.5 80 384 80H336V120C336 124.4 332.4 128 328 128C323.6 128 320 124.4 320 120V80H128V120C128 124.4 124.4 128 120 128C115.6 128 112 124.4 112 120V80H64z"],
    "calendar-pen": [448, 512, ["calendar-edit"], "f333", "M256 240.1C271.6 225.3 296.1 225.3 312.6 240.1L319 247.4C334.6 263 334.6 288.4 319 303.1L195.1 427C192.8 430.2 188.8 432.4 184.4 433.4L134.2 444.9C122.7 447.6 112.4 437.3 115.1 425.8L126.6 375.6C127.6 371.2 129.8 367.2 132.1 364L256 240.1zM301.3 252.3C291.9 242.9 276.7 242.9 267.3 252.3L249.5 270.2L289.8 310.5L307.7 292.7C317.1 283.3 317.1 268.1 307.7 258.7L301.3 252.3zM142.2 379.2L130.7 429.4L180.8 417.8C182.3 417.5 183.6 416.8 184.7 415.7L278.5 321.8L238.2 281.5L144.3 375.3C143.2 376.4 142.5 377.7 142.2 379.2L142.2 379.2zM128 64H320V8C320 3.582 323.6 0 328 0C332.4 0 336 3.582 336 8V64H384C419.3 64 448 92.65 448 128V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H112V8C112 3.582 115.6 0 120 0C124.4 0 128 3.582 128 8V64zM16 448C16 474.5 37.49 496 64 496H384C410.5 496 432 474.5 432 448V192H16V448zM64 80C37.49 80 16 101.5 16 128V176H432V128C432 101.5 410.5 80 384 80H336V120C336 124.4 332.4 128 328 128C323.6 128 320 124.4 320 120V80H128V120C128 124.4 124.4 128 120 128C115.6 128 112 124.4 112 120V80H64z"],
    "calendar-plus": [448, 512, [], "f271", "M320 344C320 348.4 316.4 352 312 352H232V432C232 436.4 228.4 440 224 440C219.6 440 216 436.4 216 432V352H136C131.6 352 128 348.4 128 344C128 339.6 131.6 336 136 336H216V256C216 251.6 219.6 248 224 248C228.4 248 232 251.6 232 256V336H312C316.4 336 320 339.6 320 344zM120 0C124.4 0 128 3.582 128 8V64H320V8C320 3.582 323.6 0 328 0C332.4 0 336 3.582 336 8V64H384C419.3 64 448 92.65 448 128V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H112V8C112 3.582 115.6 0 120 0zM432 192H16V448C16 474.5 37.49 496 64 496H384C410.5 496 432 474.5 432 448V192zM112 120V80H64C37.49 80 16 101.5 16 128V176H432V128C432 101.5 410.5 80 384 80H336V120C336 124.4 332.4 128 328 128C323.6 128 320 124.4 320 120V80H128V120C128 124.4 124.4 128 120 128C115.6 128 112 124.4 112 120z"],
    "calendar-range": [448, 512, [], "e0d6", "M376 280C376 284.4 372.4 288 368 288H176C171.6 288 168 284.4 168 280C168 275.6 171.6 272 176 272H368C372.4 272 376 275.6 376 280zM80 416C75.58 416 72 412.4 72 408C72 403.6 75.58 400 80 400H272C276.4 400 280 403.6 280 408C280 412.4 276.4 416 272 416H80zM136 288C136 310.1 118.1 328 96 328C73.91 328 56 310.1 56 288C56 265.9 73.91 248 96 248C118.1 248 136 265.9 136 288zM72 288C72 301.3 82.75 312 96 312C109.3 312 120 301.3 120 288C120 274.7 109.3 264 96 264C82.75 264 72 274.7 72 288zM312 416C312 393.9 329.9 376 352 376C374.1 376 392 393.9 392 416C392 438.1 374.1 456 352 456C329.9 456 312 438.1 312 416zM376 416C376 402.7 365.3 392 352 392C338.7 392 328 402.7 328 416C328 429.3 338.7 440 352 440C365.3 440 376 429.3 376 416zM120 0C124.4 0 128 3.582 128 8V64H320V8C320 3.582 323.6 0 328 0C332.4 0 336 3.582 336 8V64H384C419.3 64 448 92.65 448 128V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H112V8C112 3.582 115.6 0 120 0zM432 192H16V448C16 474.5 37.49 496 64 496H384C410.5 496 432 474.5 432 448V192zM112 120V80H64C37.49 80 16 101.5 16 128V176H432V128C432 101.5 410.5 80 384 80H336V120C336 124.4 332.4 128 328 128C323.6 128 320 124.4 320 120V80H128V120C128 124.4 124.4 128 120 128C115.6 128 112 124.4 112 120z"],
    "calendar-star": [448, 512, [], "f736", "M262.2 299.4L315.6 307.1C328.8 309 333.1 325.2 324.5 334.4L285.9 372.1L294.1 425.3C297.2 438.4 283.5 448.3 271.8 442.1L224 417L176.2 442.1C164.5 448.3 150.8 438.4 153 425.3L162.1 372.1L123.5 334.4C114 325.2 119.2 309 132.4 307.1L185.8 299.4L209.7 250.1C215.5 239.1 232.5 239.1 238.3 250.1L262.2 299.4zM196.4 314L134.7 322.1L179.3 366.5L168.8 427.1L224 398.1L279.2 427.1L268.7 366.5L313.3 322.1L251.6 314L223.1 258.1L196.4 314zM128 64H320V8C320 3.582 323.6 0 328 0C332.4 0 336 3.582 336 8V64H384C419.3 64 448 92.65 448 128V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H112V8C112 3.582 115.6 0 120 0C124.4 0 128 3.582 128 8V64zM16 448C16 474.5 37.49 496 64 496H384C410.5 496 432 474.5 432 448V192H16V448zM64 80C37.49 80 16 101.5 16 128V176H432V128C432 101.5 410.5 80 384 80H336V120C336 124.4 332.4 128 328 128C323.6 128 320 124.4 320 120V80H128V120C128 124.4 124.4 128 120 128C115.6 128 112 124.4 112 120V80H64z"],
    "calendar-week": [448, 512, [], "f784", "M64 288C64 270.3 78.33 256 96 256H352C369.7 256 384 270.3 384 288V352C384 369.7 369.7 384 352 384H96C78.33 384 64 369.7 64 352V288zM80 288V352C80 360.8 87.16 368 96 368H352C360.8 368 368 360.8 368 352V288C368 279.2 360.8 272 352 272H96C87.16 272 80 279.2 80 288zM128 64H320V8C320 3.582 323.6 0 328 0C332.4 0 336 3.582 336 8V64H384C419.3 64 448 92.65 448 128V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H112V8C112 3.582 115.6 0 120 0C124.4 0 128 3.582 128 8V64zM16 448C16 474.5 37.49 496 64 496H384C410.5 496 432 474.5 432 448V192H16V448zM64 80C37.49 80 16 101.5 16 128V176H432V128C432 101.5 410.5 80 384 80H336V120C336 124.4 332.4 128 328 128C323.6 128 320 124.4 320 120V80H128V120C128 124.4 124.4 128 120 128C115.6 128 112 124.4 112 120V80H64z"],
    "calendar-xmark": [448, 512, ["calendar-times"], "f273", "M301.7 413.7C298.5 416.8 293.5 416.8 290.3 413.7L224 347.3L157.7 413.7C154.5 416.8 149.5 416.8 146.3 413.7C143.2 410.5 143.2 405.5 146.3 402.3L212.7 336L146.3 269.7C143.2 266.5 143.2 261.5 146.3 258.3C149.5 255.2 154.5 255.2 157.7 258.3L224 324.7L290.3 258.3C293.5 255.2 298.5 255.2 301.7 258.3C304.8 261.5 304.8 266.5 301.7 269.7L235.3 336L301.7 402.3C304.8 405.5 304.8 410.5 301.7 413.7V413.7zM120 0C124.4 0 128 3.582 128 8V64H320V8C320 3.582 323.6 0 328 0C332.4 0 336 3.582 336 8V64H384C419.3 64 448 92.65 448 128V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H112V8C112 3.582 115.6 0 120 0zM432 192H16V448C16 474.5 37.49 496 64 496H384C410.5 496 432 474.5 432 448V192zM112 120V80H64C37.49 80 16 101.5 16 128V176H432V128C432 101.5 410.5 80 384 80H336V120C336 124.4 332.4 128 328 128C323.6 128 320 124.4 320 120V80H128V120C128 124.4 124.4 128 120 128C115.6 128 112 124.4 112 120z"],
    "calendars": [512, 512, [], "e0d7", "M216 0C220.4 0 224 3.582 224 8V64H384V8C384 3.582 387.6 0 392 0C396.4 0 400 3.582 400 8V64H448C483.3 64 512 92.65 512 128V352C512 387.3 483.3 416 448 416H160C124.7 416 96 387.3 96 352V128C96 92.65 124.7 64 160 64H208V8C208 3.582 211.6 0 216 0zM208 120V80H160C133.5 80 112 101.5 112 128V176H496V128C496 101.5 474.5 80 448 80H400V120C400 124.4 396.4 128 392 128C387.6 128 384 124.4 384 120V80H224V120C224 124.4 220.4 128 216 128C211.6 128 208 124.4 208 120zM112 192V352C112 378.5 133.5 400 160 400H448C474.5 400 496 378.5 496 352V192H112zM0 223.1C0 194.2 20.4 169.1 48 162V178.7C29.36 185.3 16 203.1 16 223.1V448C16 474.5 37.49 496 64 496H352C372.9 496 390.7 482.6 397.3 464H413.1C406.9 491.6 381.8 512 352 512H64C28.65 512 0 483.3 0 448V223.1z"],
    "camcorder": [576, 512, [128249, "video-handheld"], "f8a8", "M320 159.1L64 159.1L64 104c0-30.88 25.12-56 55.1-56h192c4.422 0 8-3.578 8-8s-3.578-8-8-8H120C80.3 32 48 64.3 48 104L48 162.3C20.44 169.4 .0002 194.2 .0002 223.1l-.0001 191.1c0 35.35 28.65 63.1 64 63.1l256-.0016c35.35 0 64-28.65 64-63.1V223.1C384 188.7 355.3 159.1 320 159.1zM368 416c0 26.47-21.53 48-47.1 48h-256c-26.47 0-48-21.53-48-48V224c0-26.47 21.53-48 48-48h256c26.47 0 47.1 21.53 47.1 48V416zM555.7 164.5c-12.75-6.734-28.16-5.859-39.97 2.25l-96.13 63.81c-3.656 2.453-4.656 7.422-2.219 11.09c2.438 3.703 7.406 4.641 11.09 2.25L524.7 180c7.125-4.859 15.88-5.391 23.56-1.359c7.375 3.891 11.78 11.09 11.78 19.28v244.1c0 8.203-4.406 15.42-11.78 19.3c-7.625 4.047-16.5 3.5-23.69-1.453l-96.13-63.73c-3.625-2.406-8.625-1.453-11.06 2.25c-2.438 3.688-1.438 8.641 2.25 11.09l96 63.66c6.594 4.531 14.25 6.844 21.97 6.844c6.188 0 12.41-1.5 18.09-4.5c12.75-6.688 20.34-19.2 20.34-33.45V197.9C576 183.7 568.4 171.2 555.7 164.5zM312 240H72c-4.422 0-8 3.578-8 8S67.58 256 72 256h240c4.422 0 8-3.578 8-8S316.4 240 312 240z"],
    "camera": [512, 512, [62258, "camera-alt"], "f030", "M144 288C144 226.1 194.1 176 256 176C317.9 176 368 226.1 368 288C368 349.9 317.9 400 256 400C194.1 400 144 349.9 144 288zM256 192C202.1 192 160 234.1 160 288C160 341 202.1 384 256 384C309 384 352 341 352 288C352 234.1 309 192 256 192zM362.9 64.82L373.3 96H448C483.3 96 512 124.7 512 160V416C512 451.3 483.3 480 448 480H64C28.65 480 0 451.3 0 416V160C0 124.7 28.65 96 64 96H138.7L149.1 64.82C155.6 45.22 173.9 32 194.6 32H317.4C338.1 32 356.4 45.22 362.9 64.82H362.9zM64 112C37.49 112 16 133.5 16 160V416C16 442.5 37.49 464 64 464H448C474.5 464 496 442.5 496 416V160C496 133.5 474.5 112 448 112H361.8L347.8 69.88C343.4 56.81 331.2 48 317.4 48H194.6C180.8 48 168.6 56.81 164.2 69.88L150.2 112H64z"],
    "camera-cctv": [576, 512, ["cctv"], "f8ac", "M533.9 195.6C532.6 181 523.4 168.6 509.8 163.2L145.1 2.744c-17.94-7.172-38.59 .1563-48.06 16.84l-91.93 160.8C-.5625 190.3-1.562 202.2 2.406 213c3.937 10.8 12.37 19.27 22.87 23.08l175.4 72.59l-46.09 115.3H15.1v-64c0-4.422-3.593-8-7.999-8S0 355.6 0 359.1v144C0 508.4 3.593 512 7.999 512s7.999-3.578 7.999-8v-64h143.1c3.281 0 6.218-1.984 7.437-5.031l48.05-120.1l84.07 34.79c4.406 1.609 8.937 2.391 13.47 2.391c7.124 0 14.19-1.984 20.4-5.891l182.4-114.1C528.3 224.2 535.2 210.3 533.9 195.6zM324.9 332.6c-5.968 3.75-13.19 4.453-19.56 2.156L31.09 221.2C24.72 218.9 19.75 213.9 17.4 207.5C15.09 201.2 15.66 194.2 18.1 188.4l91.96-160.9c4.125-7.313 11.94-11.55 19.9-11.55c2.719 0 5.468 .5 8.093 1.547L503.5 177.9c8.093 3.219 13.69 10.45 14.47 19.16c.7812 8.766-3.219 16.78-10.69 21.44L324.9 332.6zM574.4 282.5c-2.156-5.75-6.562-10.38-12.44-13.05l-32.25-14.13c-4.125-1.781-8.749 .0625-10.53 4.125c-1.781 4.047 .0625 8.766 4.093 10.53l32.15 14.08c1.375 .625 3.156 1.828 4.062 4.234c.6875 1.719 .6562 3.781-.0937 5.547l-37.15 84.42c-.7812 1.781-2.25 3.156-4.093 3.875c-1.875 .7187-3.875 .6562-5.656-.125l-108.9-47.84c-4.062-1.75-8.749 .0313-10.53 4.109c-1.781 4.047 .0625 8.766 4.093 10.55l108.9 47.83c2.1 1.344 6.187 2 9.406 2c2.875 0 5.75-.5313 8.499-1.594c5.812-2.266 10.41-6.656 12.91-12.36l37.22-84.52C576.5 294.4 576.6 288.1 574.4 282.5z"],
    "camera-movie": [576, 512, [127910, 127909], "f8a9", "M555.7 260.5c-12.75-6.734-28.16-5.859-39.97 2.25l-64.11 42.56c-2.232 1.48-3.574 3.982-3.574 6.662c0 6.379 7.105 10.22 12.42 6.695l64.24-42.65c7.125-4.859 15.88-5.391 23.56-1.359c7.375 3.891 11.78 11.09 11.78 19.28v180.1c0 8.203-4.406 15.42-11.78 19.3c-7.625 4.047-16.5 3.5-23.69-1.453l-64.12-42.51c-5.314-3.525-12.41 .2871-12.41 6.664c0 2.68 1.344 5.182 3.578 6.664l64.02 42.45c6.594 4.531 14.25 6.844 21.97 6.844c6.188 0 12.41-1.5 18.09-4.5c12.75-6.688 20.34-19.2 20.34-33.45V293.1C576 279.7 568.4 267.2 555.7 260.5zM352 288h-328c-13.25 0-24 10.74-24 24v16c0 13.25 10.75 24 24 24h39.1v95.99c0 35.35 28.65 63.1 64 63.1L352 512c35.35 0 64-28.65 64-64v-96C416 316.7 387.3 288 352 288zM400 448c0 26.47-21.53 48-47.1 48H128c-26.47 0-47.1-21.53-47.1-48v-112H24c-4.412 0-8-3.59-8-8v-16c0-4.412 3.588-8 8-8h328c26.47 0 48 21.53 48 48L400 448zM128 64c-35.35 0-64 28.65-64 64s28.65 64 64 64s64-28.65 64-64S163.3 64 128 64zM128 176C101.5 176 80 154.5 80 128s21.53-48 47.1-48s48 21.53 48 48S154.5 176 128 176zM352 64c-35.35 0-64 28.65-64 64s28.65 64 64 64s64-28.65 64-64S387.3 64 352 64zM352 176c-26.47 0-48-21.53-48-48s21.53-48 48-48s48 21.53 48 48S378.5 176 352 176zM352 0c-46.77 0-89.8 26.22-111.1 66.77C217.8 26.22 174.8 0 128 0c-70.58 0-128 57.42-128 128s57.4 127.1 127.1 127.1L352 256c70.58 0 128-57.42 128-128S422.6 0 352 0zM352 240H128c-61.75 0-112-50.25-112-112s50.25-112 112-112c46.14 0 88.14 29.22 104.5 72.7c2.344 6.25 12.62 6.25 14.97 0C263.9 45.22 305.9 16 352 16c61.75 0 112 50.25 112 112S413.8 240 352 240z"],
    "camera-polaroid": [576, 512, [], "f8aa", "M568.1 327.3L512 256l.0001-176c0-26.51-21.49-48-48-48h-352c-26.51 0-48 21.49-48 48L64 256L7.01 327.3c-4.535 5.67-7.004 12.56-7.006 19.82L.0002 448c0 17.6 14.4 32 32 32h512c17.6 0 32-14.4 32-32l.0004-100.7C576 340 573.5 332.1 568.1 327.3zM76.5 265.1l3.502-4.383V80c0-17.64 14.36-32 31.1-32h352c17.64 0 32 14.36 32 32v181.6L555.5 336H20.54L76.5 265.1zM560 448c0 8.822-7.178 16-16 16h-512c-8.822 0-16-7.178-16-16l.0039-96h543.1V448zM428 96h-24c-11.03 0-20 8.969-20 20v24c0 11.03 8.969 20 20 20h24c11.03 0 20-8.969 20-20v-24C448 104.1 439 96 428 96zM432 140c0 2.172-1.828 4-4 4h-24c-2.172 0-4-1.828-4-4v-24c0-2.172 1.828-4 4-4h24c2.172 0 4 1.828 4 4V140zM288 112c-44.11 0-80 35.89-80 80s35.89 80 80 80s80-35.89 80-80S332.1 112 288 112zM288 256c-35.3 0-64-28.7-64-64s28.7-64 64-64s64 28.7 64 64S323.3 256 288 256zM104 416h368c4.422 0 8-3.578 8-8s-3.578-8-8-8h-368c-4.422 0-8 3.578-8 8S99.58 416 104 416z"],
    "camera-retro": [512, 512, [128247], "f083", "M0 416V144C0 108.7 28.65 80 64 80H192L238.9 44.8C250 36.49 263.5 32 277.3 32H448C483.3 32 512 60.65 512 96V416C512 451.3 483.3 480 448 480H64C28.65 480 0 451.3 0 416zM64 96C37.49 96 16 117.5 16 144V232H145.1C164.5 189.6 206.8 160 256 160C305.2 160 347.5 189.6 366 232H496V96C496 69.49 474.5 48 448 48H277.3C266.9 48 256.8 51.37 248.5 57.6L201.6 92.8C198.8 94.88 195.5 96 192 96H64zM16 248V416C16 442.5 37.49 464 64 464H448C474.5 464 496 442.5 496 416V248H371.7C374.5 258.2 376 268.9 376 280C376 346.3 322.3 400 256 400C189.7 400 136 346.3 136 280C136 268.9 137.5 258.2 140.3 248H16zM256 176C198.6 176 152 222.6 152 280C152 337.4 198.6 384 256 384C313.4 384 360 337.4 360 280C360 222.6 313.4 176 256 176zM64 40C64 35.58 67.58 32 72 32H152C156.4 32 160 35.58 160 40C160 44.42 156.4 48 152 48H72C67.58 48 64 44.42 64 40z"],
    "camera-rotate": [512, 512, [], "e0d8", "M464 96h-88l-12.38-32.88C356.6 44.38 338.8 32 318.8 32h-125.5c-20 0-38 12.38-45 31.12L136 96H48C21.5 96 0 117.5 0 144v288C0 458.5 21.5 480 48 480h416c26.5 0 48-21.5 48-48v-288C512 117.5 490.5 96 464 96zM496 432c0 17.64-14.36 32-32 32h-416c-17.64 0-32-14.36-32-32v-288c0-17.64 14.36-32 32-32h99.11l16.12-43.28C167.9 56.33 179.9 48 193.3 48h125.5c13.25 0 25.26 8.326 29.9 20.76L364.9 112H464c17.64 0 32 14.36 32 32V432zM352 184c-4.422 0-8 3.578-8 8v38.28C324.1 201.1 291.4 184 256 184c-44.28 0-84.67 27.78-100.5 69.14C153.9 257.3 156 261.9 160.1 263.5c4.125 1.562 8.75-.4844 10.33-4.609C183.9 223.7 218.3 200 256 200c33.65 0 64.54 18.92 80.39 48H288c-4.422 0-8 3.578-8 8S283.6 264 288 264h64c4.422 0 8-3.578 8-8V192C360 187.6 356.4 184 352 184zM351.9 312.5c-4.062-1.531-8.734 .4844-10.33 4.609C328.1 352.3 293.7 376 256 376c-33.65 0-64.54-18.92-80.39-48H224c4.422 0 8-3.578 8-8S228.4 312 224 312H160c-4.422 0-8 3.578-8 8v64c0 4.422 3.578 8 8 8S168 388.4 168 384v-38.28C187.9 374 220.6 392 256 392c44.28 0 84.67-27.78 100.5-69.14C358.1 318.7 356 314.1 351.9 312.5z"],
    "camera-security": [448, 512, ["camera-home"], "f8fe", "M384 0h-320c-35.35 0-64 28.65-64 64v288c0 35.35 28.65 64 64 64H116.8l-47.2 56.63c-6.031 7.234-7.297 17.02-3.297 25.55C70.28 506.7 78.59 512 88.02 512h271.1c9.422 0 17.73-5.297 21.72-13.83c4-8.531 2.734-18.31-3.297-25.55L331.2 416h52.79c35.35 0 64-28.65 64-64V64C448 28.65 419.3 0 384 0zM366.1 482.9c3.016 3.625 1.594 7.438 1.094 8.516S364.7 496 359.1 496H88.03c-4.719 0-6.75-3.531-7.25-4.609s-1.922-4.891 1.094-8.516L137.6 416h172.8L366.1 482.9zM432 352c0 26.47-21.53 48-48 48h-320c-26.47 0-47.1-21.53-47.1-48V64c0-26.47 21.53-48 47.1-48h320c26.47 0 48 21.53 48 48V352zM224 80c-70.69 0-127.1 57.31-127.1 128c0 70.69 57.31 128 127.1 128c70.69 0 128-57.31 128-128C352 137.3 294.7 80 224 80zM224 320c-61.76 0-112-50.24-112-112s50.24-112 112-112c61.76 0 112 50.24 112 112S285.8 320 224 320z"],
    "camera-slash": [640, 512, [], "e0d9", "M636.1 497.7C640.4 500.5 641 505.5 638.3 508.1C635.5 512.4 630.5 513 627 510.3L3.022 14.26C-.4365 11.51-1.012 6.481 1.738 3.022C4.487-.4365 9.52-1.012 12.98 1.738L636.1 497.7zM467.3 464L487.5 480H128C92.65 480 64 451.3 64 416V160C64 155.4 64.48 151 65.38 146.7L80.03 158.3C80.01 158.9 80 159.4 80 160V416C80 442.5 101.5 464 128 464H467.3zM258.6 32H381.4C402.1 32 420.4 45.22 426.9 64.82L437.3 96H512C547.3 96 576 124.7 576 160V366.4L560 353.7V160C560 133.5 538.5 112 512 112H425.8L411.8 69.88C407.4 56.81 395.2 48 381.4 48H258.6C244.8 48 232.6 56.81 228.2 69.88L222.4 87.25L209.1 76.71L213.1 64.82C219.6 45.22 237.9 32 258.6 32V32zM208 288C208 278.1 209.1 270.2 211.1 261.8L225.2 272.9C224.4 277.8 224 282.9 224 288C224 341 266.1 384 320 384C333 384 345.4 381.4 356.7 376.7L370.8 387.8C355.6 395.6 338.3 400 320 400C258.1 400 208 349.9 208 288V288zM424 246.4L336.4 177.2C376.3 183 409.4 209.1 424 246.4V246.4z"],
    "camera-viewfinder": [512, 512, ["screenshot"], "e0da", "M152 0C156.4 0 160 3.582 160 8C160 12.42 156.4 16 152 16H40C26.75 16 16 26.75 16 40V152C16 156.4 12.42 160 8 160C3.582 160 0 156.4 0 152V40C0 17.91 17.91 0 40 0H152zM512 152C512 156.4 508.4 160 504 160C499.6 160 496 156.4 496 152V40C496 26.75 485.3 16 472 16H360C355.6 16 352 12.42 352 8C352 3.582 355.6 0 360 0H472C494.1 0 512 17.91 512 40V152zM320 256C320 291.3 291.3 320 256 320C220.7 320 192 291.3 192 256C192 220.7 220.7 192 256 192C291.3 192 320 220.7 320 256zM256 208C229.5 208 208 229.5 208 256C208 282.5 229.5 304 256 304C282.5 304 304 282.5 304 256C304 229.5 282.5 208 256 208zM325.8 111.6L332 128H368C394.5 128 416 149.5 416 176V336C416 362.5 394.5 384 368 384H144C117.5 384 96 362.5 96 336V176C96 149.5 117.5 128 144 128H180L186.2 111.6C189.7 102.2 198.6 96 208.6 96H303.4C313.4 96 322.3 102.2 325.8 111.6zM144 144C126.3 144 112 158.3 112 176V336C112 353.7 126.3 368 144 368H368C385.7 368 400 353.7 400 336V176C400 158.3 385.7 144 368 144H320.9L310.9 117.2C309.7 114.1 306.7 112 303.4 112H208.6C205.3 112 202.3 114.1 201.1 117.2L191.1 144H144zM0 360C0 355.6 3.582 352 8 352C12.42 352 16 355.6 16 360V472C16 485.3 26.75 496 40 496H152C156.4 496 160 499.6 160 504C160 508.4 156.4 512 152 512H40C17.91 512 0 494.1 0 472V360zM360 512C355.6 512 352 508.4 352 504C352 499.6 355.6 496 360 496H472C485.3 496 496 485.3 496 472V360C496 355.6 499.6 352 504 352C508.4 352 512 355.6 512 360V472C512 494.1 494.1 512 472 512H360z"],
    "camera-web": [448, 512, ["webcam"], "f832", "M160 232c4.406 0 8-3.594 8-8c0-30.88 25.12-56 56-56c4.406 0 8-3.594 8-8S228.4 152 224 152C184.3 152 152 184.3 152 224C152 228.4 155.6 232 160 232zM366.1 442.8c-2.812-3.312-7.875-3.75-11.28-.8438c-3.344 2.875-3.719 7.906-.8438 11.28L390.6 496H57.41l36.66-42.78c2.875-3.375 2.5-8.406-.8438-11.28c-3.375-2.906-8.406-2.469-11.28 .8438l-48 56c-2.031 2.375-2.5 5.719-1.219 8.562C34.03 510.2 36.88 512 40 512h368c3.125 0 5.969-1.812 7.281-4.656c1.281-2.844 .8125-6.188-1.219-8.562L366.1 442.8zM224 368c79.4 0 144-64.6 144-144S303.4 80 224 80S80 144.6 80 224S144.6 368 224 368zM224 96c70.69 0 127.9 57.31 127.9 128s-57.31 128-128 128s-128-57.31-128-128S153.3 96 224 96zM224 448c123.5 0 224-100.5 224-223.1s-100.5-224-224-224s-224 100.5-224 224S100.5 448 224 448zM224 16c114.7 0 208 93.31 208 208s-93.31 208-208 208S16 338.7 16 224S109.3 16 224 16z"],
    "camera-web-slash": [640, 512, ["webcam-slash"], "f833", "M320 16c114.7 0 208 93.31 208 208c0 31.94-7.447 62.09-20.37 89.16l12.82 10.19c14.93-29.99 23.54-63.65 23.54-99.36c0-123.5-100.5-223.1-223.1-223.1c-53.92 0-103.4 19.17-142.1 51.03l12.93 10.28C226.3 33.03 271.2 16 320 16zM101.7 174.5C98.09 190.4 95.1 206.1 95.1 223.1c0 123.5 100.5 224 224 224c34.93 0 67.9-8.273 97.4-22.6l-13.89-11.04C377.9 425.6 349.7 432 320 432c-114.7 0-208-93.31-208-208c0-13.13 1.365-25.94 3.705-38.41L101.7 174.5zM455.3 271.6C460.6 256.6 464 240.8 464 224c0-79.4-64.6-144-144-144c-28.39 0-54.71 8.531-77.04 22.77l13.5 10.73c18.79-10.83 40.29-17.51 63.54-17.51c70.69 0 127.9 57.3 127.9 127.1c0 12.94-2.407 25.18-5.976 36.95L455.3 271.6zM636.1 497.7L12.99 1.73C11.53 .5664 9.771 0 8.025 0C5.674 0 3.336 1.027 1.738 3.012c-2.75 3.469-2.172 8.5 1.281 11.25l623.1 496C628.5 511.4 630.2 512 631.1 512c2.344 0 4.688-1.031 6.266-3.016C641 505.5 640.4 500.5 636.1 497.7zM342.3 365.7l-17.86-14.19C322.1 351.6 321.5 352 320 352c-62.41 0-114.2-44.71-125.6-103.8l-17.39-13.82C182.5 308.8 244.1 368 320 368C327.7 368 335 366.9 342.3 365.7zM504 496H153.4l36.66-42.78c2.875-3.375 2.5-8.406-.8438-11.28c-3.375-2.906-8.406-2.469-11.28 .8438l-48 56c-2.031 2.375-2.5 5.719-1.219 8.562C130 510.2 132.9 512 136 512h368c4.418 0 8-3.582 8-8S508.4 496 504 496z"],
    "campfire": [512, 512, [], "f6ba", "M256 320c79.4 0 143.1-64.95 143.1-144.8c0-34.02-32.11-100.1-78.19-142.7c-3.062-2.75-7.703-2.75-10.73 0c-9.953 8.984-19.47 18.64-28.39 28.81C266.9 41.1 247.1 20.79 227.4 2.086c-3.031-2.781-7.719-2.781-10.75 0C156 57.15 112 129.1 112 175.2C112 255.1 176.6 320 256 320zM299.3 290.5c-40.82 29.66-111.8 9.847-111.8-56.76c0-19.39 10.55-36.95 35.48-68.73c12.56 16.53 40.61 53.89 52.75 70.09c1.469 1.953 3.734 3.125 6.187 3.203c1.594-.3125 4.75-.1 6.344-2.844l27.58-32.78c.3438 .6719 .6719 1.328 1 1.984C332.1 235.1 324.5 271.1 299.3 290.5zM222 18.9c20.41 19.11 38.95 39.7 53.91 59.91c1.453 1.969 3.75 3.172 6.203 3.234c2.453-.1094 4.812-.1 6.375-2.906c8.687-10.48 18.05-20.48 27.89-29.78c38.48 37.67 67.62 97.19 67.62 125.9c0 43.74-21.88 82.33-55.1 105.6c14.31-24.15 15.97-55.94 2.199-83.29c-2.047-4.172-4.437-8.484-6.984-12.94c-1.297-2.266-3.625-3.75-6.219-3.984c-2.609-.2031-5.156 .8125-6.844 2.812l-28.62 34.02c-14.47-19.3-49.84-66.41-53.28-70.55c-1.516-1.828-3.781-2.891-6.156-2.891C220.6 144.5 218.3 145.1 216.7 147c-27.37 34.28-45.31 58.84-45.31 86.7c0 18.71 5.289 35.31 14.31 48.94C151 259.6 128 220.1 128 175.2C128 136 168 69.77 222 18.9zM276.7 400l230.4-96.62c4.078-1.703 5.1-6.391 4.281-10.47c-1.703-4.078-6.359-5.969-10.47-4.281L256 391.3L11.1 288.6C6.989 286.9 2.333 288.8 .6296 292.9c-1.719 4.078 .2031 8.765 4.281 10.47l230.4 96.62l-230.4 96.62c-4.078 1.703-5.1 6.391-4.281 10.47C1.911 510.2 4.88 512 8.005 512c1.031 0 2.078-.2031 3.094-.625L256 408.7l244.9 102.7C501.9 511.8 502.1 512 503.1 512c3.125 0 6.094-1.844 7.375-4.906c1.719-4.078-.2031-8.765-4.281-10.47L276.7 400z"],
    "campground": [576, 512, [9978], "f6bb", "M190.1 2.836L530.8 405.8C539.3 415.9 544 428.7 544 441.9V472C544 494.1 526.1 512 504 512H288C283.6 512 280 508.4 280 504C280 499.6 283.6 496 288 496H504C517.3 496 528 485.3 528 472V441.9C528 432.5 524.7 423.3 518.5 416.1L177.9 13.17C175 9.791 175.5 4.743 178.8 1.891C182.2-.9616 187.3-.5389 190.1 2.835V2.836zM397.2 1.891C400.5 4.744 400.1 9.791 398.1 13.17L57.45 416.1C51.35 423.3 48 432.5 48 441.9V472C48 485.3 58.75 496 72 496H288C292.4 496 296 499.6 296 504C296 508.4 292.4 512 288 512H72C49.91 512 32 494.1 32 472V441.9C32 428.7 36.69 415.9 45.23 405.8L385.9 2.836C388.7-.5382 393.8-.961 397.2 1.892V1.891zM294.3 315.1L438.3 499.1L425.7 508.9L287.1 332.1L150.3 508.9L137.7 499.1L281.7 315.1C283.2 313.1 285.5 312 288 312C290.5 312 292.8 313.1 294.3 315.1H294.3z"],
    "can-food": [384, 512, [129387], "e3e6", "M368 72c0-.4336-.2734-.8262-.291-1.258c-.2441-3.123-.9746-6.189-2.133-9.203c-9.289-28.15-55.16-49.93-119.2-57.94c-2.062-.2773-4.162-.5137-6.258-.7617c-5.652-.6152-11.24-1.24-17.14-1.637C212.9 .457 202.6 0 192 0S171.1 .457 161 1.201C155.1 1.598 149.5 2.223 143.9 2.838C141.8 3.086 139.7 3.322 137.6 3.6C73.58 11.61 27.71 33.38 18.42 61.54c-1.158 3.014-1.889 6.08-2.133 9.203C16.27 71.17 16 71.57 16 72c0 .1348 .0898 .2578 .0918 .3926C16.09 72.64 16 72.89 16 73.14v365.7C16 479.3 94.8 512 192 512s176-32.75 176-73.14V73.14c0-.2539-.0859-.498-.0918-.75C367.9 72.26 368 72.13 368 72zM263 310.4C258.3 275.2 228.4 248 192 248S125.7 275.2 120.1 310.4C82.35 303.1 50.51 290.6 32 275.1v-172.6C59.14 127.4 118.8 144 192 144s132.9-16.57 160-41.41v172.6C333.5 290.6 301.6 303.1 263 310.4zM248 320c0 30.88-25.12 56-56 56S136 350.9 136 320S161.1 264 192 264S248 289.1 248 320zM155.5 17.62c.4395-.0371 .8184-.1172 1.26-.1523C167.9 16.52 179.7 16 192 16s24.08 .5215 35.2 1.471c.4414 .0352 .8203 .1152 1.26 .1523c76.67 6.816 122.6 34.24 123.4 54.95C350.9 98.91 285.6 128 192 128S33.1 98.91 32.17 72.57C32.97 51.86 78.88 24.44 155.5 17.62zM192 496c-99.13 0-160-33.28-160-57.14V294.8c21.46 14.2 51.91 25.28 88.67 31.86C124.1 363.2 154.6 392 192 392s67.93-28.82 71.33-65.38C300.1 320 330.5 308.1 352 294.8v144.1C352 462.7 291.1 496 192 496z"],
    "candle-holder": [448, 512, [128367], "f6bc", "M160 191.1c42.41 0 72-33.16 72-80.64c0-29.08-25.5-70.92-66.53-109.2C162.3-.7227 157.6-.707 154.6 2.137C114.1 39.75 88 82.62 88 111.4C88 158.8 117.6 191.1 160 191.1zM160 19.06c33.72 32.98 56 69.47 56 92.3c0 38.06-23.03 64.64-56 64.64s-56-26.58-56-64.64C104 88.45 126.3 51.95 160 19.06zM384 383.1c-35.35 0-64 28.65-64 64c0 19.22 8.654 36.27 22.07 48H256V263.1c0-22.06-17.94-40-40-40h-112c-22.06 0-40 17.94-40 40v232H8c-4.406 0-8 3.578-8 8S3.594 512 8 512H384c35.35 0 64-28.65 64-64S419.3 383.1 384 383.1zM240 495.1h-160V263.1c0-13.23 10.78-24 24-24H128v48c0 4.422 3.594 8 8 8S144 292.4 144 287.1V239.1h72c13.22 0 24 10.77 24 24V495.1zM384 495.1c-26.47 0-48-21.53-48-48s21.53-48 48-48s48 21.53 48 48S410.5 495.1 384 495.1z"],
    "candy": [640, 512, [127852], "e3e7", "M638.9 251.1C639.6 253.2 640 254.6 640 255.1C640 257.4 639.6 258.8 638.9 260C638.2 261.2 637.2 262.2 635.1 262.9L586.6 291.2L615.2 348.4C615.8 349.7 616.1 351 615.1 352.4C615.9 353.7 615.5 355.1 614.8 356.2C614.1 357.4 613.1 358.3 611.9 358.1C610.7 359.6 609.4 359.1 608 359.1C606.8 359.1 605.7 359.7 604.6 359.3L503.7 311.8C491.7 351.2 467.4 385.7 434.3 410.2C401.3 434.7 361.2 447.1 320 447.1C278.8 447.1 238.7 434.7 205.7 410.2C172.6 385.7 148.3 351.2 136.3 311.8L35.4 359.3C34.33 359.7 33.17 359.1 32 359.1C30.64 359.1 29.3 359.6 28.11 358.1C26.92 358.3 25.92 357.4 25.21 356.2C24.49 355.1 24.08 353.7 24.01 352.4C23.95 351 24.23 349.7 24.84 348.4L53.44 291.2L4.035 262.9C2.812 262.2 1.795 261.2 1.087 260C.3803 258.8 .0078 257.4 .0078 255.1C.0078 254.6 .3803 253.2 1.087 251.1C1.795 250.8 2.812 249.8 4.035 249.1L53.44 220.8L24.84 163.5C24.09 162.1 23.83 160.4 24.09 158.7C24.34 157.1 25.11 155.6 26.27 154.4C27.43 153.2 28.93 152.4 30.57 152.1C32.2 151.8 33.89 152 35.4 152.7L136.3 200.2C148.3 160.8 172.6 126.3 205.7 101.8C238.7 77.26 278.8 64.02 320 64.02C361.2 64.02 401.3 77.26 434.3 101.8C467.4 126.3 491.7 160.8 503.7 200.2L604.6 152.7C606.1 152 607.8 151.8 609.4 152.1C611.1 152.4 612.6 153.2 613.7 154.4C614.9 155.6 615.7 157.1 615.9 158.7C616.2 160.4 615.9 162.1 615.2 163.5L586.6 220.8L635.1 249.1C637.2 249.8 638.2 250.8 638.9 251.1zM132.2 295.1C126.6 269.6 126.6 242.4 132.2 215.1L49.48 177.1L71.17 220.4C72.08 222.3 72.25 224.4 71.65 226.3C71.06 228.3 69.74 229.9 67.97 230.9L24.13 255.1L67.97 281.1C69.74 282.1 71.06 283.7 71.65 285.7C72.25 287.6 72.08 289.7 71.17 291.5L49.48 334.9L132.2 295.1zM185.3 369.1C211.9 400.8 248.8 422 289.6 429.2L163.2 176.4C150.6 201 143.1 228.3 144 255.1C144 297.4 158.7 337.4 185.3 369.1zM320 431.1C344.6 431.1 368.1 426.8 391.4 416.7L234.3 102.4C209.5 116.3 188.4 135.1 172.8 159.8L308.6 431.4C312.4 431.7 316.2 431.1 320 431.1zM405.7 409.6C430.5 395.7 451.6 376 467.2 352.2L331.4 80.57C327.6 80.32 323.8 79.1 320 79.1C295.4 80 271 85.22 248.6 95.29L405.7 409.6V409.6zM496.1 256.5C496.2 229 489.8 201.8 477.5 177.2C465.2 152.6 447.3 131.3 425.2 114.9C403.2 98.46 377.5 87.48 350.4 82.81L476.8 335.6C489.3 311.1 495.9 284 496.1 256.5L496.1 256.5zM615.9 255.1L572 230.9C570.3 229.9 568.9 228.3 568.4 226.3C567.8 224.4 567.9 222.3 568.8 220.4L590.5 177.1L507.8 215.1C513.4 242.4 513.4 269.6 507.8 295.1L590.6 335.1L568.9 291.7C567.1 289.9 567.8 287.8 568.4 285.8C569 283.9 570.3 282.2 572.1 281.2L615.9 255.1z"],
    "candy-bar": [640, 512, [127851, "chocolate-bar"], "e3e8", "M621.3 82.75C633.3 94.75 640 111 640 128V384C640 400.1 633.3 417.3 621.3 429.3C609.3 441.3 592.1 448 576 448H32C23.51 448 15.37 444.6 9.372 438.6C3.371 432.6 0 424.5 0 416V222.4C18.07 218.7 34.31 208.9 45.97 194.6C57.64 180.3 64 162.4 64 144V128H80C98.44 128 116.3 121.6 130.6 109.1C144.9 98.31 154.7 82.07 158.4 64H576C592.1 64 609.3 70.74 621.3 82.75zM125.5 132.3C111.5 139.9 95.89 143.9 80 144C79.93 160.9 75.35 177.5 66.75 192H160V100.5C151.3 113.8 139.4 124.8 125.5 132.3zM16 320H160V208H55.17C44.54 219.1 31.07 229.1 16 234.5V320zM160 432V336H16V416C16 420.2 17.69 424.3 20.69 427.3C23.69 430.3 27.76 432 32 432H160zM304 336H176V432H304V336zM304 208H176V320H304V208zM304 80H176V192H304V80zM624 128C624 115.3 618.9 103.1 609.9 94.06C600.9 85.06 588.7 80 576 80H320V432H576C588.7 432 600.9 426.9 609.9 417.9C618.9 408.9 624 396.7 624 384V128z"],
    "candy-cane": [512, 512, [], "f786", "M497.5 91.1C469.6 33.12 411.8 0 352.4 0c-27.88 0-56.14 7.25-81.77 22.62L243.1 38.1C227.9 48.12 223 67.75 232.1 82.87l32.76 54.87c6.115 10.27 16.69 15.6 27.38 15.6c5.695 0 11.47-1.453 16.51-4.539l27.51-16.37c5.746-3.432 11.37-4.988 16.71-4.988c28.16 0 47.02 41.5 16.13 59.88L15.6 397.6c-15.25 9.125-20.13 28.62-11 43.87l32.76 54.87C43.35 506.4 53.97 512 64.85 512c5.625 0 11.27-1.507 16.39-4.507l347.4-206.5C500.2 258.1 533.2 167.5 497.5 91.1zM328 118.6l-27.67 16.48c-2.402 1.469-5.201 2.246-8.092 2.246c-5.666 0-10.78-2.91-13.69-7.799L245.8 74.61C243.6 70.96 242.1 66.69 243.1 62.58C245 58.44 247.6 54.94 251.3 52.75l27.55-16.4c19.78-11.87 42.18-18.43 65.17-19.78V112.7C338.6 113.8 333.2 115.6 328 118.6zM360 112.7V16.54c53.22 2.76 99.93 33.56 123 82.31C487.5 108.3 490.4 118.1 492.5 128H387.6C380.3 119.8 370.7 114.4 360 112.7zM216.6 296.6l97.21 54l-101.6 60.38l-97.15-53.97L216.6 296.6zM73.14 493.7C70.52 495.2 67.73 496 64.85 496c-5.592 0-10.87-3.012-13.76-7.824l-32.76-54.89c-4.607-7.701-2.199-17.33 5.451-21.91l75.42-44.89l97.14 53.96L73.14 493.7zM329.7 341.1L232.5 287.1l98.42-58.57l96.45 53.58c-2.402 1.627-4.465 3.588-6.981 5.094L329.7 341.1zM441.6 271.8l-94.79-52.66l30.42-18.1c19.34-11.51 27.76-31.7 21.99-52.7C398.8 146.7 397.9 145.5 397.3 144h97.48C499.1 190.9 479.7 239.3 441.6 271.8z"],
    "candy-corn": [640, 512, [], "f6bd", "M479.1 0c-165.8 1.625-164.5 39.5-157.9 72.5c30.38 151.5 94.01 343.5 157.8 343.5c63.75-.125 127.6-191.9 158-343.5C644.5 39.5 645.8 1.625 479.1 0zM479.9 399.1c-23.7 0-54.47-47.82-83.33-122.4c58.04-7.437 108.8-7.439 166.9-.0078C534.5 352.1 503.7 399.1 479.9 399.1zM569.2 262.1c-61.97-8.147-116.4-8.158-178.4 .0078c-13.14-35.92-25.73-77.09-36.94-121.7c100.3-20.05 189.6-12.53 252.3-.0059C594.1 185 582.3 226.2 569.2 262.1zM622.2 69.36c-3.781 18.87-7.912 37.26-12.22 55.28c-102.6-20.46-195.5-12.85-259.9 .0078c-4.314-18.02-8.449-36.42-12.23-55.29c-2.561-12.75-2.924-20.38 2.188-26.68c9.432-11.63 41.38-25.69 140-26.67c98.62 .9825 130.6 15.05 140 26.67C625.1 48.97 624.8 56.6 622.2 69.36zM80.97 213.8c-111.5 118.7-84.06 143.8-56.4 161.7c126.1 82.49 304.9 169.2 348.3 123.1c43.23-45.29-47.93-222.3-133.7-347.9C220.5 124.3 194.7 97.42 80.97 213.8zM361.6 488.6c-16.11 16.81-70.57 5.793-142.5-24.97c34.17-46.2 68.68-82.25 113.4-118.4C365.2 416.1 377.8 471.7 361.6 488.6zM325.5 330.6C277.6 368.1 240.7 407.6 204.3 457.1c-34.13-15.35-71.59-34.69-110.5-57.41c33.8-53.06 89.22-121.6 171.4-178.9C288.9 259.4 309.2 296.6 325.5 330.6zM80.13 391.6c-15.58-9.315-31.3-19.01-47.12-29.29c-10.69-6.94-16.28-11.92-17.23-19.87c-1.752-14.67 10.09-46.99 76.41-117.6C159.9 155.6 191.5 142.6 206 143.9C213.9 144.6 219 150.1 226.3 160.6C236.9 176.3 247 191.8 256.7 207.3C172.6 265.1 114.9 337.1 80.13 391.6z"],
    "cannabis": [576, 512, [], "f55f", "M531.6 349c-.2813-.1408-25.38-13.56-63.66-22.86c57.22-72.06 74.78-150.3 75.53-153.7c1.656-7.65-.7187-15.89-6.375-21.78c-5.719-5.413-13.16-7.775-21.47-6.179c-.75 .1564-74.59 15.68-146.2 68.86c-3.656-107.9-55.44-193.3-61.63-203.1C299.1-3.352 277-3.492 268.1 10.34C262 20.02 210.3 105.4 206.6 213.3C136.8 161.6 63.75 145.2 60.47 144.5C52.41 142.8 44.72 145.2 38.81 150.8C33.19 156.4 31 164.5 32.72 172.5c.75 3.457 18.16 81.64 75.38 153.7c-38.28 9.292-63.34 22.71-63.53 22.81C36.81 353 32 360.1 32 369.8c0 8.776 4.812 16.74 12.38 20.68c.5938 .3442 61.91 33.06 137.2 31.71c-7.562 16.27-10.91 27.14-10.91 27.14c-2.75 8.385-.5625 17.49 5.625 23.68c4.438 4.568 10.47 7.024 16.66 7.024c2.281 0 4.625-.3442 6.875-1.017c.2187-.0626 23.72-7.306 54.53-25.01c3.844-2.206 5.156-7.087 2.969-10.93S250.3 437.9 246.4 440.1c-28.44 16.32-50.78 23.43-51.09 23.53c-2.719 .8135-5.719 .1252-7.656-1.862c-2-2.018-2.656-4.818-1.75-7.665c.0618-.1564 4.75-15.19 15.69-36.5c1.281-2.503 1.156-5.522-.3438-7.916c-1.5-2.378-4.25-3.582-6.969-3.754c-5.25 .1252-10.88 .2346-16.75 .2346c-69.56 0-124.9-29.43-125.6-29.82C49.47 375 48 372.6 48 369.8c0-2.738 1.562-5.319 4.062-6.617c.2813-.1564 29.66-15.64 72.09-24.12c2.781-.5475 5.062-2.55 6-5.241c.9375-2.691 .375-5.663-1.5-7.822C67.34 254.3 48.94 172.5 48.19 169C47.66 166.5 48.38 163.8 49.1 162.3C51.56 160.8 53.5 159.9 57.09 160.2C60.38 160.9 138.9 178.5 209.3 235.7c2.344 1.94 5.688 2.378 8.469 1.017c2.781-1.33 4.562-4.13 4.562-7.227V225.3c0-108.1 53.22-196.8 59.28-206.4c2.812-4.318 9.875-4.318 12.69 0c6.062 9.652 59.28 97.44 59.28 206.4v4.224c0 3.097 1.781 5.898 4.562 7.227c2.812 1.361 6.125 .923 8.469-1.017c71.13-57.83 151.2-75.39 153.8-75.75c2.062 0 3.969 .7822 5.281 2.034c1.781 1.846 2.562 4.537 2.031 7.008c-.75 3.442-19.16 85.29-80.47 156.9c-1.875 2.159-2.438 5.131-1.5 7.822c.9375 2.691 3.219 4.693 6 5.241c42.44 8.479 71.81 23.97 72.22 24.17C526.4 364.4 528 367 528 369.8c0 2.816-1.469 5.272-4.125 6.664c-.5313 .2972-55.88 29.72-125.4 29.72c-5.875 0-11.5-.1095-16.75-.2346c-2.562 .1721-5.469 1.361-6.969 3.754s-1.625 5.397-.3438 7.9c10.81 21.15 15.62 36.37 15.75 36.7c.8438 2.628 .1562 5.522-1.875 7.54c-1.844 1.924-4.719 2.722-7.688 1.768c-.2187-.0626-22.56-7.18-51-23.5c-3.812-2.174-8.719-.8761-10.91 2.957c-2.188 3.848-.875 8.729 2.969 10.93c30.81 17.71 54.31 24.95 54.41 24.97c8.5 2.597 17.59 .3285 23.53-5.804c6.219-6.085 8.5-15.44 5.812-23.62c-.0313-.1252-3.376-10.92-10.97-27.36c1.312 .0157 2.688 .0157 4.031 .0157c73.72 0 132.6-31.4 133-31.63C539.2 386.5 544 378.5 544 369.8C544 360.1 539.2 353 531.6 349zM288 191.6c-4.406 0-8 3.582-8 8.01v304.4C280 508.4 283.6 512 288 512s8-3.582 8-8.01V199.6C296 195.2 292.4 191.6 288 191.6z"],
    "capsules": [576, 512, [], "f46b", "M111.1 48C59.06 48 16 91.06 16 144v224c0 52.94 43.06 96 95.1 96s95.1-43.06 95.1-96v-224C207.1 91.06 164.9 48 111.1 48zM191.1 368c0 44.11-35.88 80-79.1 80s-79.1-35.89-79.1-80L31.1 264h159.1L191.1 368zM191.1 248H31.1L31.1 144c0-44.11 35.88-80 79.1-80s79.1 35.89 79.1 80L191.1 248zM541.2 308l-136.3-187c-32.09-44.05-94.62-54.16-139.2-22.52C243.9 113.9 229.5 136.7 225.3 162.8C221 188.7 227.2 214.7 242.8 235.1l136.3 187c19.47 26.7 50.12 40.94 81.18 40.94c20.16 0 40.5-5.984 58.06-18.42c21.75-15.41 36.09-38.23 40.34-64.31C562.9 355.3 556.7 329.3 541.2 308zM255.7 226.5C242.7 208.7 237.5 187 241.1 165.4C244.6 143.5 256.6 124.4 274.9 111.5c14.78-10.47 31.87-15.5 48.84-15.5c26.12 0 51.87 11.94 68.22 34.39l63.38 86.95l-136.1 96.32L255.7 226.5zM542.9 378.6c-3.562 21.81-15.59 40.92-33.81 53.83c-37.53 26.61-90.12 18.14-117.1-18.89l-63.38-86.95l136.1-96.32l63.53 87.15C541.3 335.3 546.4 356.1 542.9 378.6z"],
    "car": [512, 512, [128664, "automobile"], "f1b9", "M128 288C128 305.7 113.7 320 96 320C78.33 320 64 305.7 64 288C64 270.3 78.33 256 96 256C113.7 256 128 270.3 128 288zM96 272C87.16 272 80 279.2 80 288C80 296.8 87.16 304 96 304C104.8 304 112 296.8 112 288C112 279.2 104.8 272 96 272zM384 288C384 270.3 398.3 256 416 256C433.7 256 448 270.3 448 288C448 305.7 433.7 320 416 320C398.3 320 384 305.7 384 288zM416 304C424.8 304 432 296.8 432 288C432 279.2 424.8 272 416 272C407.2 272 400 279.2 400 288C400 296.8 407.2 304 416 304zM58.02 199.8L91.05 84.22C99.88 53.31 128.1 32 160.3 32H351.7C383.9 32 412.1 53.31 420.1 84.22L453.1 199.8C488.1 214.5 512 248.5 512 288V472C512 476.4 508.4 480 504 480C499.6 480 496 476.4 496 472V400H16V472C16 476.4 12.42 480 8 480C3.582 480 0 476.4 0 472V288C0 248.5 23.89 214.5 58.02 199.8H58.02zM76.31 194C82.67 192.7 89.25 192 96 192H416C422.7 192 429.3 192.7 435.7 194L405.6 88.62C398.7 64.57 376.7 48 351.7 48H160.3C135.3 48 113.3 64.57 106.4 88.62L76.31 194zM416 208H96C51.82 208 16 243.8 16 288V384H496V288C496 243.8 460.2 208 416 208z"],
    "car-battery": [512, 512, ["battery-car"], "f5df", "M368 216C372.4 216 376 219.6 376 224V264H416C420.4 264 424 267.6 424 272C424 276.4 420.4 280 416 280H376V320C376 324.4 372.4 328 368 328C363.6 328 360 324.4 360 320V280H320C315.6 280 312 276.4 312 272C312 267.6 315.6 264 320 264H360V224C360 219.6 363.6 216 368 216zM192 264C196.4 264 200 267.6 200 272C200 276.4 196.4 280 192 280H96C91.58 280 88 276.4 88 272C88 267.6 91.58 264 96 264H192zM320 128V88C320 74.75 330.7 64 344 64H424C437.3 64 448 74.75 448 88V128C483.3 128 512 156.7 512 192V384C512 419.3 483.3 448 448 448H64C28.65 448 0 419.3 0 384V192C0 156.7 28.65 128 64 128V88C64 74.75 74.75 64 88 64H168C181.3 64 192 74.75 192 88V128H320zM168 80H88C83.58 80 80 83.58 80 88V128H176V88C176 83.58 172.4 80 168 80zM336 128H432V88C432 83.58 428.4 80 424 80H344C339.6 80 336 83.58 336 88V128zM64 144C37.49 144 16 165.5 16 192V384C16 410.5 37.49 432 64 432H448C474.5 432 496 410.5 496 384V192C496 165.5 474.5 144 448 144H64z"],
    "car-bolt": [512, 512, [], "e341", "M128 288C128 305.7 113.7 320 96 320C78.33 320 64 305.7 64 288C64 270.3 78.33 256 96 256C113.7 256 128 270.3 128 288zM96 272C87.16 272 80 279.2 80 288C80 296.8 87.16 304 96 304C104.8 304 112 296.8 112 288C112 279.2 104.8 272 96 272zM384 288C384 270.3 398.3 256 416 256C433.7 256 448 270.3 448 288C448 305.7 433.7 320 416 320C398.3 320 384 305.7 384 288zM416 304C424.8 304 432 296.8 432 288C432 279.2 424.8 272 416 272C407.2 272 400 279.2 400 288C400 296.8 407.2 304 416 304zM283.5 175.9H329.1C345.1 175.9 351.2 196.8 337.7 205.4L212.1 285.3C198 294.3 181.4 278.4 189.6 263.9L221.6 207.9H176C160 207.9 153.9 187 167.4 178.4L292.1 98.55C307 89.59 323.7 105.5 315.4 119.1L283.5 175.9zM235.4 191.9C238.3 191.9 240.9 193.5 242.3 195.9C243.8 198.4 243.8 201.4 242.3 203.9L203.5 271.8L329.1 191.9H269.7C266.8 191.9 264.2 190.4 262.8 187.1C261.3 185.5 261.3 182.4 262.7 179.1L301.5 112.1L176 191.9H235.4zM58.02 199.8L91.05 84.22C99.88 53.31 128.1 32 160.3 32H351.7C383.9 32 412.1 53.31 420.1 84.22L453.1 199.8C488.1 214.5 512 248.5 512 288V472C512 476.4 508.4 480 504 480C499.6 480 496 476.4 496 472V400H16V472C16 476.4 12.42 480 8 480C3.582 480 0 476.4 0 472V288C0 248.5 23.89 214.5 58.02 199.8H58.02zM76.31 194C82.67 192.7 89.25 192 96 192H128V208H96C51.82 208 16 243.8 16 288V384H496V288C496 243.8 460.2 208 416 208H384V192H416C422.7 192 429.3 192.7 435.7 194L405.6 88.62C398.7 64.57 376.7 48 351.7 48H160.3C135.3 48 113.3 64.57 106.4 88.62L76.31 194z"],
    "car-building": [640, 512, [], "f859", "M272 16H48C30.33 16 16 30.33 16 48V432C16 449.7 30.33 464 48 464H224V480H48C21.49 480 0 458.5 0 432V48C0 21.49 21.49 0 48 0H272C298.5 0 320 21.49 320 48V165.2C314.1 170 308.7 175.5 304 181.6V48C304 30.33 289.7 16 272 16zM232 288C239.2 288 245.7 291.2 250.1 296.2C246.3 300.7 242.9 305.5 239.9 310.5C239.2 306.8 235.9 304 232 304H200C195.6 304 192 307.6 192 312V344C192 348.4 195.6 352 200 352H225.1C224.4 357.2 224 362.6 224 368H200C186.7 368 176 357.3 176 344V312C176 298.7 186.7 288 200 288H232zM64 200C64 186.7 74.75 176 88 176H120C133.3 176 144 186.7 144 200V232C144 245.3 133.3 256 120 256H88C74.75 256 64 245.3 64 232V200zM88 192C83.58 192 80 195.6 80 200V232C80 236.4 83.58 240 88 240H120C124.4 240 128 236.4 128 232V200C128 195.6 124.4 192 120 192H88zM232 176C245.3 176 256 186.7 256 200V232C256 245.3 245.3 256 232 256H200C186.7 256 176 245.3 176 232V200C176 186.7 186.7 176 200 176H232zM192 232C192 236.4 195.6 240 200 240H232C236.4 240 240 236.4 240 232V200C240 195.6 236.4 192 232 192H200C195.6 192 192 195.6 192 200V232zM64 88C64 74.75 74.75 64 88 64H120C133.3 64 144 74.75 144 88V120C144 133.3 133.3 144 120 144H88C74.75 144 64 133.3 64 120V88zM88 80C83.58 80 80 83.58 80 88V120C80 124.4 83.58 128 88 128H120C124.4 128 128 124.4 128 120V88C128 83.58 124.4 80 120 80H88zM232 64C245.3 64 256 74.75 256 88V120C256 133.3 245.3 144 232 144H200C186.7 144 176 133.3 176 120V88C176 74.75 186.7 64 200 64H232zM192 120C192 124.4 195.6 128 200 128H232C236.4 128 240 124.4 240 120V88C240 83.58 236.4 80 232 80H200C195.6 80 192 83.58 192 88V120zM64 312C64 298.7 74.75 288 88 288H120C133.3 288 144 298.7 144 312V344C144 357.3 133.3 368 120 368H88C74.75 368 64 357.3 64 344V312zM88 304C83.58 304 80 307.6 80 312V344C80 348.4 83.58 352 88 352H120C124.4 352 128 348.4 128 344V312C128 307.6 124.4 304 120 304H88zM368 368C368 385.7 353.7 400 336 400C318.3 400 304 385.7 304 368C304 350.3 318.3 336 336 336C353.7 336 368 350.3 368 368zM336 384C344.8 384 352 376.8 352 368C352 359.2 344.8 352 336 352C327.2 352 320 359.2 320 368C320 376.8 327.2 384 336 384zM528 368C528 350.3 542.3 336 560 336C577.7 336 592 350.3 592 368C592 385.7 577.7 400 560 400C542.3 400 528 385.7 528 368zM560 352C551.2 352 544 359.2 544 368C544 376.8 551.2 384 560 384C568.8 384 576 376.8 576 368C576 359.2 568.8 352 560 352zM326.4 216.6C333.2 192.6 355.2 176 380.2 176H515.8C540.8 176 562.8 192.6 569.6 216.6L591.7 293.8L590.7 294.1C619.6 306.1 640 334.7 640 368V504C640 508.4 636.4 512 632 512C627.6 512 624 508.4 624 504V448H272V504C272 508.4 268.4 512 264 512C259.6 512 256 508.4 256 504V368C256 334.7 276.4 306.1 305.3 294.1L304.3 293.8L326.4 216.6zM380.2 192C362.3 192 346.7 203.8 341.7 221L322.3 289.2C326.7 288.4 331.3 288 336 288H560C564.7 288 569.3 288.4 573.7 289.2L554.3 221C549.3 203.8 533.7 192 515.8 192H380.2zM624 368C624 332.7 595.3 304 560 304H336C300.7 304 272 332.7 272 368V432H624V368z"],
    "car-bump": [640, 512, [], "f5e0", "M101.1 318.7C97.72 302.8 107.1 286.5 123 282.3C138.9 277.1 155.2 287.4 159.5 303.3C163.7 319.2 154.3 335.5 138.4 339.8C122.6 344 106.2 334.6 101.1 318.7V318.7zM134.3 324.3C141.6 322.3 145.1 314.8 144 307.4C142.1 300.1 134.5 295.7 127.2 297.7C119.8 299.7 115.5 307.2 117.4 314.6C119.4 321.9 126.9 326.3 134.3 324.3V324.3zM446.1 226.3C451.3 242.1 441.8 258.5 425.9 262.7C410.1 266.1 393.7 257.5 389.5 241.7C385.2 225.8 394.7 209.5 410.5 205.2C426.4 200.1 442.7 210.4 446.1 226.3V226.3zM414.7 220.7C407.3 222.6 402.1 230.2 404.9 237.5C406.9 244.9 414.5 249.2 421.8 247.3C429.2 245.3 433.5 237.7 431.5 230.4C429.6 223.1 422 218.7 414.7 220.7zM129.1 64.11L295.5 19.76C326.5 11.44 359.3 24.71 375.8 52.28L433.4 148.2C467.6 155.5 496.6 181.2 506.2 217.3L548.8 376.2C549.9 380.1 547.5 384.2 543.5 385.3C539.6 386.4 535.5 383.1 534.4 380L517.1 315.3L85.81 430.9L103.1 495.6C104.2 499.6 101.9 503.6 97.89 504.7C93.92 505.8 89.84 503.4 88.77 499.4L46.21 340.6C36.54 304.5 48.77 267.7 74.76 244.3L76.6 132.5C77.13 100.3 98.91 72.43 129.1 64.11V64.11zM134.1 79.56C109.9 86.03 93.01 107.7 92.6 132.7L90.95 232.6C98.06 228.5 105.8 225.2 114.1 223L388.7 149.4C396.9 147.2 405.3 146.2 413.5 146.2L362.1 60.51C349.3 39.07 323.8 28.74 299.6 35.22L134.1 79.56zM61.66 336.5L82.75 415.2L511.9 300.2L490.8 221.5C479.3 178.8 435.5 153.5 392.8 164.9L118.2 238.5C75.56 249.9 50.23 293.8 61.66 336.4V336.5zM414.9 511.9C410.5 511.3 407.5 507.2 408.1 502.9C415.1 453.8 457.3 416 508.4 416C559.4 416 601.7 453.8 608.7 502.9C609.3 507.2 606.3 511.3 601.9 511.9C597.5 512.5 593.5 509.5 592.9 505.1C586.9 463.8 551.4 432 508.4 432C465.4 432 429.8 463.8 423.9 505.1C423.3 509.5 419.2 512.5 414.9 511.9V511.9z"],
    "car-burst": [640, 512, ["car-crash"], "f5e1", "M221.9 88.7L287.9 72.38L276.3 91.73L219.3 105.8C215.6 106.7 211.7 104.9 210.1 101.4L175.1 27.16L141.9 101.4C140.3 104.9 136.4 106.7 132.7 105.8L53.37 86.21L90.14 159.2C91.8 162.5 90.1 166.5 88.2 168.9L29.7 218.9L103.2 235.7C106.9 236.5 109.5 239.8 109.4 243.6L107.9 325.3L149.3 291.1L144.1 310.5C143.5 312.8 143 315 142.7 317.3L104.7 348.7C102.3 350.7 98.98 351.1 96.16 349.8C93.35 348.4 91.58 345.6 91.64 342.4L93.3 249.8L10.63 230.1C7.685 230.3 5.368 228 4.645 225.1C3.921 222.1 4.914 219.1 7.212 217.1L73.03 160.8L31.25 77.87C29.85 75.08 30.19 71.72 32.14 69.28C34.09 66.83 37.28 65.75 40.32 66.5L130.1 88.7L168.7 4.659C170 1.82 172.9 0 175.1 0C179.1 0 181.1 1.82 183.3 4.659L221.9 88.7zM543.1 354.2C528.6 350.3 520 335.4 523.9 320.9C527.8 306.4 542.7 297.8 557.2 301.7C571.7 305.6 580.3 320.5 576.4 334.1C572.5 349.5 557.6 358.1 543.1 354.2zM560.1 330.8C562.6 324.9 559 318.7 553.1 317.1C547.1 315.5 540.1 319.1 539.4 325.1C537.8 331 541.3 337.2 547.3 338.8C553.2 340.4 559.4 336.8 560.1 330.8zM294.6 231.3C309.1 235.2 317.7 250.1 313.8 264.6C309.9 279.1 295 287.7 280.5 283.8C266 279.1 257.4 265 261.3 250.5C265.2 236 280.1 227.4 294.6 231.3V231.3zM276.7 254.7C275.1 260.7 278.7 266.8 284.6 268.4C290.6 269.1 296.8 266.4 298.3 260.5C299.9 254.5 296.4 248.4 290.4 246.8C284.5 245.2 278.3 248.7 276.7 254.7zM600.4 169L601.8 259.1C627.5 272.8 641.3 302.8 633.5 332.1L588.5 500.1C587.5 503.7 583.8 505.8 580.2 504.9C576.5 503.9 574.4 500.2 575.4 496.5L591.2 437.5L197.3 331.9L181.4 390.1C180.5 394.6 176.7 396.8 173.1 395.8C169.5 394.8 167.3 391.1 168.3 387.5L213.3 219.5C221.2 190.2 248.1 171.1 277.2 172.1L323.5 94.86C340.1 67.29 372.9 54.02 403.9 62.34L547 100.7C578.1 109 599.8 136.9 600.4 169H600.4zM399.8 77.8C375.6 71.32 350.1 81.65 337.2 103.1L294.2 174.9L585.7 253L584.4 169.3C583.9 144.3 567 122.6 542.9 116.1L399.8 77.8zM584.1 269.2L287.5 189.7C261.9 182.8 235.6 198 228.8 223.6L203.7 317.1L592.1 421.4L618 327.1C624.9 302.3 609.7 276 584.1 269.2V269.2z"],
    "car-bus": [640, 512, [], "f85a", "M16 247.1V361.5C16 383.5 33.91 401.5 56 401.5H224V417.5H56C53.28 417.5 50.61 417.3 48 416.9V472C48 476.4 44.42 480 40 480C35.58 480 32 476.4 32 472V412.1C13.08 403.1 0 383.8 0 361.5V105.1C0 84.54 4.403 60.96 22.72 46.11C50.66 23.44 104 0 192 0C279.1 0 333.3 23.44 361.3 46.11C379.6 60.96 384 84.54 384 105.1V144H380.2C376.1 144 372 144.3 368 144.8V120H200V232H282.7L278.1 248L16 247.1zM16 103.1H367.1C367.8 85.29 363.5 68.51 351.2 58.53C326.7 38.69 277.2 15.1 191.1 15.1C106.8 15.1 57.26 38.69 32.79 58.53C20.49 68.51 16.17 85.29 16 103.1H16zM16 119.1V231.1H184V119.1H16zM128 319.1C128 337.7 113.7 352 96 352C78.33 352 64 337.7 64 319.1C64 302.3 78.33 287.1 96 287.1C113.7 287.1 128 302.3 128 319.1zM96 336C104.8 336 112 328.8 112 319.1C112 311.2 104.8 303.1 96 303.1C87.16 303.1 80 311.2 80 319.1C80 328.8 87.16 336 96 336zM368 368C368 385.7 353.7 400 336 400C318.3 400 304 385.7 304 368C304 350.3 318.3 336 336 336C353.7 336 368 350.3 368 368zM336 384C344.8 384 352 376.8 352 368C352 359.2 344.8 352 336 352C327.2 352 320 359.2 320 368C320 376.8 327.2 384 336 384zM528 368C528 350.3 542.3 336 560 336C577.7 336 592 350.3 592 368C592 385.7 577.7 400 560 400C542.3 400 528 385.7 528 368zM560 352C551.2 352 544 359.2 544 368C544 376.8 551.2 384 560 384C568.8 384 576 376.8 576 368C576 359.2 568.8 352 560 352zM326.4 216.6C333.2 192.6 355.2 175.1 380.2 175.1H515.8C540.8 175.1 562.8 192.6 569.6 216.6L591.7 293.8L590.7 294.1C619.6 306.1 640 334.7 640 368V504C640 508.4 636.4 512 632 512C627.6 512 624 508.4 624 504V448H272V504C272 508.4 268.4 512 264 512C259.6 512 256 508.4 256 504V368C256 334.7 276.4 306.1 305.3 294.1L304.3 293.8L326.4 216.6zM380.2 191.1C362.3 191.1 346.7 203.8 341.7 221L322.3 289.2C326.7 288.4 331.3 288 336 288H560C564.7 288 569.3 288.4 573.7 289.2L554.3 221C549.3 203.8 533.7 191.1 515.8 191.1H380.2zM624 368C624 332.7 595.3 303.1 560 303.1H336C300.7 303.1 272 332.7 272 368V432H624V368z"],
    "car-circle-bolt": [640, 512, [], "e342", "M58.02 199.8L91.05 84.22C99.88 53.31 128.1 32 160.3 32H351.7C383.9 32 412.1 53.31 420.1 84.22L453.2 197.2C442.4 199.9 432 203.6 422.1 208.2C420.1 208.1 418 208 416 208H96C51.82 208 16 243.8 16 288V384H320.7C321.2 389.4 321.9 394.7 322.9 400H16V472C16 476.4 12.42 480 8 480C3.582 480 0 476.4 0 472V288C0 248.5 23.89 214.5 58.02 199.8V199.8zM76.31 194C82.67 192.7 89.25 192 96 192H416C422.7 192 429.3 192.7 435.7 194L405.6 88.62C398.7 64.57 376.7 48 351.7 48H160.3C135.3 48 113.3 64.57 106.4 88.62L76.31 194zM128 288C128 305.7 113.7 320 96 320C78.33 320 64 305.7 64 288C64 270.3 78.33 256 96 256C113.7 256 128 270.3 128 288zM96 272C87.16 272 80 279.2 80 288C80 296.8 87.16 304 96 304C104.8 304 112 296.8 112 288C112 279.2 104.8 272 96 272zM532.5 281.4C535.4 283.4 536.7 287.1 535.6 290.5L517.8 344H576C579.3 344 582.3 346.1 583.5 349.2C584.7 352.4 583.7 355.9 581.2 358.1L469.2 454.1C466.5 456.4 462.5 456.6 459.5 454.6C456.6 452.6 455.3 448.9 456.4 445.5L474.2 392H416C412.7 392 409.7 389.9 408.5 386.8C407.3 383.6 408.3 380.1 410.8 377.9L522.8 281.9C525.5 279.6 529.5 279.4 532.5 281.4H532.5zM437.6 376H485.3C487.9 376 490.3 377.2 491.8 379.3C493.3 381.4 493.7 384.1 492.9 386.5L480.7 423.1L554.4 360H506.7C504.1 360 501.7 358.8 500.2 356.7C498.7 354.6 498.3 351.9 499.1 349.5L511.3 312.9L437.6 376zM352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368zM496 496C566.7 496 624 438.7 624 368C624 297.3 566.7 240 496 240C425.3 240 368 297.3 368 368C368 438.7 425.3 496 496 496z"],
    "car-garage": [640, 512, [], "f5e2", "M635.9 177C639.8 179.2 641.1 184.1 638.1 187.9C636.8 191.8 631.9 193.1 628.1 190.1L320 17.19L11.93 190.1C8.084 193.1 3.204 191.8 1.034 187.9C-1.137 184.1 .2227 179.2 4.071 177L316.1 1.032C318.5-.3441 321.5-.3441 323.9 1.032L635.9 177zM240 368C240 385.7 225.7 400 208 400C190.3 400 176 385.7 176 368C176 350.3 190.3 336 208 336C225.7 336 240 350.3 240 368zM208 384C216.8 384 224 376.8 224 368C224 359.2 216.8 352 208 352C199.2 352 192 359.2 192 368C192 376.8 199.2 384 208 384zM400 368C400 350.3 414.3 336 432 336C449.7 336 464 350.3 464 368C464 385.7 449.7 400 432 400C414.3 400 400 385.7 400 368zM432 352C423.2 352 416 359.2 416 368C416 376.8 423.2 384 432 384C440.8 384 448 376.8 448 368C448 359.2 440.8 352 432 352zM198.4 216.6C205.2 192.6 227.2 176 252.2 176H387.8C412.8 176 434.8 192.6 441.6 216.6L463.9 294.6C492.2 306.1 512 335.2 512 368V504C512 508.4 508.4 512 504 512C499.6 512 496 508.4 496 504V448H144V504C144 508.4 140.4 512 136 512C131.6 512 128 508.4 128 504V368C128 335.2 147.8 306.1 176.1 294.6L198.4 216.6zM252.2 192C234.3 192 218.7 203.8 213.7 221L194.3 289.2C198.7 288.4 203.3 288 208 288H432C436.7 288 441.3 288.4 445.7 289.2L426.3 221C421.4 203.8 405.7 192 387.8 192H252.2zM496 368C496 332.7 467.3 304 432 304H208C172.7 304 144 332.7 144 368V432H496V368z"],
    "car-mirrors": [576, 512, [], "e343", "M160 288C160 305.7 145.7 320 128 320C110.3 320 96 305.7 96 288C96 270.3 110.3 256 128 256C145.7 256 160 270.3 160 288zM128 272C119.2 272 112 279.2 112 288C112 296.8 119.2 304 128 304C136.8 304 144 296.8 144 288C144 279.2 136.8 272 128 272zM416 288C416 270.3 430.3 256 448 256C465.7 256 480 270.3 480 288C480 305.7 465.7 320 448 320C430.3 320 416 305.7 416 288zM448 304C456.8 304 464 296.8 464 288C464 279.2 456.8 272 448 272C439.2 272 432 279.2 432 288C432 296.8 439.2 304 448 304zM192.3 32H383.7C415.9 32 444.1 53.31 452.1 84.22L479.4 176.8C486.7 166.6 498.6 160 512 160H552C565.3 160 576 170.7 576 184V200C576 213.3 565.3 224 552 224H519.6C534.8 240.1 544 263.4 544 288V472C544 476.4 540.4 480 536 480C531.6 480 528 476.4 528 472V400H48V472C48 476.4 44.42 480 40 480C35.58 480 32 476.4 32 472V288C32 263.4 41.24 240.1 56.44 224H24C10.75 224 0 213.3 0 200V184C0 170.7 10.75 160 24 160H64C77.44 160 89.34 166.6 96.59 176.8L123 84.22C131.9 53.31 160.1 32 192.3 32H192.3zM108.3 194C114.7 192.7 121.3 192 128 192H448C454.7 192 461.3 192.7 467.7 194L437.6 88.62C430.7 64.57 408.7 48 383.7 48H192.3C167.3 48 145.3 64.57 138.4 88.62L108.3 194zM64 176H24C19.58 176 16 179.6 16 184V200C16 204.4 19.58 208 24 208H74.92C79.06 205.2 83.43 202.8 88 200.7V200C88 186.7 77.25 176 64 176zM488 200.7C492.6 202.8 496.9 205.2 501.1 208H552C556.4 208 560 204.4 560 200V184C560 179.6 556.4 176 552 176H512C498.7 176 488 186.7 488 200V200.7zM496 223.1C482.6 213.1 466 208 448 208H128C109.1 208 93.37 213.1 80 223.1C60.57 238.6 48 261.8 48 288V384H528V288C528 261.8 515.4 238.6 496 223.1z"],
    "car-on": [448, 512, [], "e4dd", "M232 120C232 124.4 228.4 128 224 128C219.6 128 216 124.4 216 120V8C216 3.582 219.6 0 224 0C228.4 0 232 3.582 232 8V120zM144 368C144 385.7 129.7 400 112 400C94.33 400 80 385.7 80 368C80 350.3 94.33 336 112 336C129.7 336 144 350.3 144 368zM112 384C120.8 384 128 376.8 128 368C128 359.2 120.8 352 112 352C103.2 352 96 359.2 96 368C96 376.8 103.2 384 112 384zM304 368C304 350.3 318.3 336 336 336C353.7 336 368 350.3 368 368C368 385.7 353.7 400 336 400C318.3 400 304 385.7 304 368zM336 352C327.2 352 320 359.2 320 368C320 376.8 327.2 384 336 384C344.8 384 352 376.8 352 368C352 359.2 344.8 352 336 352zM102.4 216.6C109.2 192.6 131.2 176 156.2 176H291.8C316.8 176 338.8 192.6 345.6 216.6L367.9 294.6C396.2 306.1 416 335.2 416 368V504C416 508.4 412.4 512 408 512C403.6 512 400 508.4 400 504V448H48V504C48 508.4 44.42 512 40 512C35.58 512 32 508.4 32 504V368C32 335.2 51.78 306.1 80.07 294.6L102.4 216.6zM156.2 192C138.3 192 122.7 203.8 117.7 221L98.27 289.2C102.7 288.4 107.3 288 112 288H336C340.7 288 345.3 288.4 349.7 289.2L330.3 221C325.3 203.8 309.7 191.1 291.8 191.1L156.2 192zM400 368C400 332.7 371.3 304 336 304H112C76.65 304 48 332.7 48 368V432H400V368zM2.343 34.34C5.467 31.22 10.53 31.22 13.66 34.34L93.66 114.3C96.78 117.5 96.78 122.5 93.66 125.7C90.53 128.8 85.47 128.8 82.34 125.7L2.343 45.66C-.7811 42.53-.7811 37.47 2.343 34.34V34.34zM434.3 34.34C437.5 31.22 442.5 31.22 445.7 34.34C448.8 37.47 448.8 42.53 445.7 45.66L365.7 125.7C362.5 128.8 357.5 128.8 354.3 125.7C351.2 122.5 351.2 117.5 354.3 114.3L434.3 34.34z"],
    "car-rear": [512, 512, ["car-alt"], "f5de", "M192 312C192 298.7 202.7 288 216 288H296C309.3 288 320 298.7 320 312V328C320 341.3 309.3 352 296 352H216C202.7 352 192 341.3 192 328V312zM208 312V328C208 332.4 211.6 336 216 336H296C300.4 336 304 332.4 304 328V312C304 307.6 300.4 304 296 304H216C211.6 304 208 307.6 208 312zM167.6 32H344.4C376.2 32 404.2 52.86 413.3 83.31L446.3 193.3C483.7 200 512 232.7 512 272V352C512 372.9 498.6 390.7 480 397.3V472C480 476.4 476.4 480 472 480C467.6 480 464 476.4 464 472V400H48V472C48 476.4 44.42 480 40 480C35.58 480 32 476.4 32 472V397.3C13.36 390.7 0 372.9 0 352V272C0 232.7 28.32 200 65.66 193.3L98.65 83.31C107.8 52.86 135.8 32 167.6 32V32zM167.6 48C142.9 48 121.1 64.22 113.1 87.91L82.75 192H429.2L398 87.91C390.9 64.22 369.1 48 344.4 48H167.6zM18.02 256H72C85.25 256 96 266.7 96 280V312C96 325.3 85.25 336 72 336H16V352C16 369.7 30.33 384 48 384H464C481.7 384 496 369.7 496 352V336H440C426.7 336 416 325.3 416 312V280C416 266.7 426.7 256 440 256H493.1C486.9 228.4 461.8 208 432 208H80C50.18 208 25.12 228.4 18.02 256V256zM496 320V272H440C435.6 272 432 275.6 432 280V312C432 316.4 435.6 320 440 320H496zM80 312V280C80 275.6 76.42 272 72 272H16V320H72C76.42 320 80 316.4 80 312z"],
    "car-side": [640, 512, [128663], "f5e4", "M480 480C432.4 480 392.9 445.4 385.3 400H254.7C247.1 445.4 207.6 480 160 480C112.4 480 72.94 445.4 65.33 400H32C14.33 400 0 385.7 0 368V256C0 222.5 25.72 195 58.49 192.2L104.5 77.26C115.4 49.92 141.9 32 171.3 32H353.2C375.1 32 395.8 41.94 409.5 59.02L515.9 192.1C584.8 194.1 640 250.6 640 320V368C640 385.7 625.7 400 608 400H574.7C567.1 445.4 527.6 480 480 480L480 480zM171.3 48C148.4 48 127.8 61.94 119.3 83.2L75.82 192H240V48H171.3zM64 208C37.49 208 16 229.5 16 256V368C16 376.8 23.16 384 32 384H64C64 330.1 106.1 288 160 288C213 288 256 330.1 256 384H384C384 330.1 426.1 288 480 288C533 288 576 330.1 576 384H608C616.8 384 624 376.8 624 368V320C624 258.1 573.9 208 512 208H64zM396.1 69.02C386.3 55.73 370.3 48 353.2 48H256V192H495.4L396.1 69.02zM160 464C204.2 464 240 428.2 240 384C240 339.8 204.2 304 160 304C115.8 304 80 339.8 80 384C80 428.2 115.8 464 160 464zM480 304C435.8 304 400 339.8 400 384C400 428.2 435.8 464 480 464C524.2 464 560 428.2 560 384C560 339.8 524.2 304 480 304z"],
    "car-side-bolt": [640, 512, [], "e344", "M323.5 167.9H369.1C385.1 167.9 391.2 188.8 377.7 197.4L252.1 277.3C238 286.3 221.4 270.4 229.6 255.9L261.6 199.9H216C200 199.9 193.9 179 207.4 170.4L332.1 90.55C347 81.59 363.7 97.49 355.4 111.1L323.5 167.9zM275.4 183.9C278.3 183.9 280.9 185.5 282.3 187.9C283.8 190.4 283.8 193.4 282.3 195.9L243.5 263.8L369.1 183.9H309.7C306.8 183.9 304.2 182.4 302.8 179.1C301.3 177.5 301.3 174.4 302.7 171.1L341.5 104.1L216 183.9H275.4zM58.49 192.2L104.5 77.26C115.4 49.92 141.9 32 171.3 32H353.2C375.1 32 395.8 41.94 409.5 59.02L515.9 192.1C584.8 194.1 640 250.6 640 320V368C640 385.7 625.7 400 608 400H574.7C567.1 445.4 527.6 480 480 480C432.4 480 392.9 445.4 385.3 400H254.7C247.1 445.4 207.6 480 160 480C112.4 480 72.94 445.4 65.33 400H32C14.33 400 0 385.7 0 368V256C0 222.5 25.72 195 58.49 192.2L58.49 192.2zM75.82 192H128V208H64C37.49 208 16 229.5 16 256V368C16 376.8 23.16 384 32 384H64C64 330.1 106.1 288 160 288C213 288 256 330.1 256 384H384C384 330.1 426.1 288 480 288C533 288 576 330.1 576 384H608C616.8 384 624 376.8 624 368V320C624 258.1 573.9 208 512 208H448V192H495.4L396.1 69.02C386.3 55.73 370.3 48 353.2 48H171.3C148.4 48 127.8 61.94 119.3 83.2L75.82 192zM160 464C204.2 464 240 428.2 240 384C240 339.8 204.2 304 160 304C115.8 304 80 339.8 80 384C80 428.2 115.8 464 160 464zM480 304C435.8 304 400 339.8 400 384C400 428.2 435.8 464 480 464C524.2 464 560 428.2 560 384C560 339.8 524.2 304 480 304z"],
    "car-tilt": [640, 512, [], "f5e5", "M101.1 318.7C97.72 302.8 107.1 286.5 123 282.3C138.9 277.1 155.2 287.4 159.5 303.3C163.7 319.2 154.3 335.5 138.4 339.8C122.6 344 106.2 334.6 101.1 318.7H101.1zM134.3 324.3C141.6 322.3 145.1 314.8 144 307.4C142.1 300.1 134.5 295.7 127.2 297.7C119.8 299.7 115.5 307.2 117.4 314.6C119.4 321.9 126.9 326.3 134.3 324.3V324.3zM446.1 226.3C451.3 242.1 441.8 258.5 425.9 262.7C410.1 266.1 393.7 257.5 389.5 241.7C385.2 225.8 394.7 209.5 410.5 205.2C426.4 200.1 442.7 210.4 446.1 226.3V226.3zM414.7 220.7C407.3 222.6 402.1 230.2 404.9 237.5C406.9 244.9 414.5 249.2 421.8 247.3C429.2 245.3 433.5 237.7 431.5 230.4C429.6 223.1 422 218.7 414.7 220.7zM129.1 64.11L295.5 19.76C326.5 11.44 359.3 24.71 375.8 52.28L433.4 148.2C467.6 155.5 496.6 181.2 506.2 217.3L548.8 376.2C549.9 380.1 547.5 384.2 543.5 385.3C539.6 386.4 535.5 383.1 534.4 380L517.1 315.3L85.81 430.9L103.1 495.6C103.2 495.7 103.2 495.9 103.2 496H632C636.4 496 640 499.6 640 504C640 508.4 636.4 512 632 512H8C3.582 512 0 508.4 0 504C0 499.6 3.582 496 8 496H87.85L46.21 340.6C36.54 304.5 48.77 267.7 74.76 244.3L76.6 132.5C77.13 100.3 98.91 72.43 129.1 64.11V64.11zM134.1 79.56C109.9 86.03 93.01 107.7 92.6 132.7L90.95 232.6C98.06 228.5 105.8 225.2 114.1 223L388.7 149.4C396.9 147.2 405.3 146.2 413.5 146.2L362.1 60.51C349.3 39.07 323.8 28.74 299.6 35.22L134.1 79.56zM61.66 336.5L82.75 415.2L511.9 300.2L490.8 221.5C479.3 178.8 435.5 153.5 392.8 164.9L118.2 238.5C75.56 249.9 50.23 293.8 61.66 336.4V336.5z"],
    "car-tunnel": [512, 512, [], "e4de", "M256 16C123.5 16 16 123.5 16 256V504C16 508.4 12.42 512 8 512C3.582 512 0 508.4 0 504V256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256V504C512 508.4 508.4 512 504 512C499.6 512 496 508.4 496 504V256C496 123.5 388.5 16 256 16zM144 392C144 374.3 158.3 360 176 360C193.7 360 208 374.3 208 392C208 409.7 193.7 424 176 424C158.3 424 144 409.7 144 392zM176 376C167.2 376 160 383.2 160 392C160 400.8 167.2 408 176 408C184.8 408 192 400.8 192 392C192 383.2 184.8 376 176 376zM368 392C368 409.7 353.7 424 336 424C318.3 424 304 409.7 304 392C304 374.3 318.3 360 336 360C353.7 360 368 374.3 368 392zM336 408C344.8 408 352 400.8 352 392C352 383.2 344.8 376 336 376C327.2 376 320 383.2 320 392C320 400.8 327.2 408 336 408zM129.1 322.3L145.4 254.6C149.8 236.7 165.8 223.1 184.3 223.1H327.7C346.2 223.1 362.2 236.7 366.6 254.6L382.9 322.3C402.1 328.6 416 346.7 416 368V504C416 508.4 412.4 512 408 512C403.6 512 400 508.4 400 504V464H112V504C112 508.4 108.4 512 104 512C99.58 512 96 508.4 96 504V368C96 346.7 109.9 328.6 129.1 322.3H129.1zM146.2 320H365.8L351 258.4C348.4 247.6 338.8 240 327.7 240H184.3C173.2 240 163.6 247.6 160.1 258.4L146.2 320zM400 368C400 350.3 385.7 336 368 336H144C126.3 336 112 350.3 112 368V448H400V368z"],
    "car-wash": [448, 512, [], "f5e6", "M64 0C64 0 68.55 4.551 74.85 11.78C89.01 28.04 112 57.85 112 80C112 112 90.51 128 64 128C37.49 128 16 106.5 16 80C16 57.85 38.99 28.04 53.15 11.78C59.45 4.551 64 0 64 0V0zM87.1 104.2C92.02 99.7 96 92.22 96 80C96 75.63 94.24 69.25 90.19 61.16C86.27 53.32 80.87 45.17 75.2 37.6C71.33 32.44 67.44 27.7 64 23.7C60.56 27.7 56.67 32.44 52.8 37.6C47.13 45.17 41.73 53.32 37.81 61.16C33.76 69.25 32 75.63 32 80C32 97.67 46.33 112 64 112C74.13 112 81.96 108.1 87.1 104.2V104.2zM176 80C176 57.85 198.1 28.04 213.1 11.78C219.4 4.551 224 0 224 0C224 0 228.6 4.551 234.9 11.78C249 28.04 272 57.85 272 80C272 112 250.5 128 224 128C197.5 128 176 106.5 176 80zM250.2 61.16C246.3 53.32 240.9 45.17 235.2 37.6C231.3 32.44 227.4 27.7 224 23.7C220.6 27.7 216.7 32.44 212.8 37.6C207.1 45.17 201.7 53.32 197.8 61.16C193.8 69.25 192 75.63 192 80C192 97.67 206.3 112 224 112C234.1 112 241.1 108.1 247.1 104.2C252 99.7 256 92.22 256 80C256 75.63 254.2 69.25 250.2 61.16V61.16zM144 368C144 385.7 129.7 400 112 400C94.33 400 80 385.7 80 368C80 350.3 94.33 336 112 336C129.7 336 144 350.3 144 368zM112 384C120.8 384 128 376.8 128 368C128 359.2 120.8 352 112 352C103.2 352 96 359.2 96 368C96 376.8 103.2 384 112 384zM304 368C304 350.3 318.3 336 336 336C353.7 336 368 350.3 368 368C368 385.7 353.7 400 336 400C318.3 400 304 385.7 304 368zM336 352C327.2 352 320 359.2 320 368C320 376.8 327.2 384 336 384C344.8 384 352 376.8 352 368C352 359.2 344.8 352 336 352zM102.4 216.6C109.2 192.6 131.2 176 156.2 176H291.8C316.8 176 338.8 192.6 345.6 216.6L367.9 294.6C396.2 306.1 416 335.2 416 368V504C416 508.4 412.4 512 408 512C403.6 512 400 508.4 400 504V448H48V504C48 508.4 44.42 512 40 512C35.58 512 32 508.4 32 504V368C32 335.2 51.78 306.1 80.07 294.6L102.4 216.6zM156.2 192C138.3 192 122.7 203.8 117.7 221L98.27 289.2C102.7 288.4 107.3 288 112 288H336C340.7 288 345.3 288.4 349.7 289.2L330.3 221C325.3 203.8 309.7 192 291.8 192H156.2zM400 368C400 332.7 371.3 304 336 304H112C76.65 304 48 332.7 48 368V432H400V368zM336 80C336 57.85 358.1 28.04 373.1 11.78C379.4 4.551 384 0 384 0C384 0 388.6 4.551 394.9 11.78C409 28.04 432 57.85 432 80C432 112 410.5 128 384 128C357.5 128 336 106.5 336 80zM410.2 61.16C406.3 53.32 400.9 45.17 395.2 37.6C391.3 32.44 387.4 27.7 384 23.7C380.6 27.7 376.7 32.44 372.8 37.6C367.1 45.17 361.7 53.32 357.8 61.16C353.8 69.25 352 75.63 352 80C352 97.67 366.3 112 384 112C394.1 112 401.1 108.1 407.1 104.2C412 99.7 416 92.22 416 80C416 75.63 414.2 69.25 410.2 61.16V61.16z"],
    "car-wrench": [576, 512, ["car-mechanic"], "f5e3", "M179.8 111.1C173.5 111.1 167.8 115.8 164.5 121.3C150.5 144.5 125.1 159.1 96 159.1C64.18 159.1 36.69 141.4 23.81 114.5C19.44 105.4 27.06 95.1 37.17 95.1H75.16C78.31 95.1 81.4 95.06 84.03 93.31C93.53 86.98 93.53 73.02 84.03 66.69C81.4 64.93 78.31 64 75.16 64H37.17C27.06 64 19.44 54.61 23.81 45.49C36.69 18.58 64.18 0 96 0C125.1 0 150.5 15.51 164.5 38.71C167.8 44.15 173.5 48 179.8 48H396.2C402.5 48 408.2 44.15 411.5 38.71C425.5 15.51 450.9 0 480 0C511.8 0 539.3 18.58 552.2 45.49C556.6 54.61 548.9 64 538.8 64H500.8C497.7 64 494.6 64.94 491.1 66.69C482.5 73.02 482.5 86.98 491.1 93.31C494.6 95.06 497.7 95.1 500.8 95.1H538.8C548.9 95.1 556.6 105.4 552.2 114.5C539.3 141.4 511.8 159.1 480 159.1C450.9 159.1 425.5 144.5 411.5 121.3C408.2 115.8 402.5 111.1 396.2 111.1H179.8zM179.8 95.1H396.2C409.3 95.1 419.6 103.8 425.2 113C436.4 131.6 456.8 143.1 480 143.1C503.7 143.1 524.4 131.2 535.4 111.1H500.8C494.5 111.1 488.3 110.1 483.1 106.6C464.1 93.96 464.1 66.04 483.1 53.37C488.3 49.87 494.5 47.1 500.8 47.1H535.4C524.4 28.84 503.7 15.1 480 15.1C456.8 15.1 436.4 28.38 425.2 46.98C419.6 56.19 409.3 63.1 396.2 63.1H179.8C166.7 63.1 156.4 56.19 150.8 46.98C139.6 28.38 119.2 15.1 96 15.1C72.33 15.1 51.64 28.84 40.56 47.1H75.16C81.47 47.1 87.65 49.87 92.91 53.37C111.9 66.04 111.9 93.96 92.91 106.6C87.65 110.1 81.47 111.1 75.16 111.1H40.56C51.64 131.2 72.33 143.1 96 143.1C119.2 143.1 139.6 131.6 150.8 113C156.4 103.8 166.7 95.1 179.8 95.1H179.8zM208 368C208 385.7 193.7 400 176 400C158.3 400 144 385.7 144 368C144 350.3 158.3 336 176 336C193.7 336 208 350.3 208 368zM176 384C184.8 384 192 376.8 192 368C192 359.2 184.8 352 176 352C167.2 352 160 359.2 160 368C160 376.8 167.2 384 176 384zM368 368C368 350.3 382.3 336 400 336C417.7 336 432 350.3 432 368C432 385.7 417.7 400 400 400C382.3 400 368 385.7 368 368zM400 352C391.2 352 384 359.2 384 368C384 376.8 391.2 384 400 384C408.8 384 416 376.8 416 368C416 359.2 408.8 352 400 352zM166.4 216.6C173.2 192.6 195.2 175.1 220.2 175.1H355.8C380.8 175.1 402.8 192.6 409.6 216.6L431.9 294.6C460.2 306.1 480 335.2 480 368V504C480 508.4 476.4 512 472 512C467.6 512 464 508.4 464 504V448H112V504C112 508.4 108.4 512 104 512C99.58 512 96 508.4 96 504V368C96 335.2 115.8 306.1 144.1 294.6L166.4 216.6zM220.2 191.1C202.3 191.1 186.7 203.8 181.7 221L162.3 289.2C166.7 288.4 171.3 288 176 288H400C404.7 288 409.3 288.4 413.7 289.2L394.3 221C389.4 203.8 373.7 191.1 355.8 191.1H220.2zM464 368C464 332.7 435.3 303.1 400 303.1H176C140.7 303.1 112 332.7 112 368V432H464V368z"],
    "caravan": [640, 512, [], "f8ff", "M64 160C64 142.3 78.33 128 96 128H224C241.7 128 256 142.3 256 160V224C256 241.7 241.7 256 224 256H96C78.33 256 64 241.7 64 224V160zM80 160V224C80 232.8 87.16 240 96 240H224C232.8 240 240 232.8 240 224V160C240 151.2 232.8 144 224 144H96C87.16 144 80 151.2 80 160zM448 320C448 337.7 433.7 352 416 352H352C334.3 352 320 337.7 320 320V160C320 142.3 334.3 128 352 128H416C433.7 128 448 142.3 448 160V320zM416 144H352C343.2 144 336 151.2 336 160V320C336 328.8 343.2 336 352 336H416C424.8 336 432 328.8 432 320V240H392C387.6 240 384 236.4 384 232C384 227.6 387.6 224 392 224H432V160C432 151.2 424.8 144 416 144zM0 336V112C0 67.82 35.82 32 80 32H416C504.4 32 576 103.6 576 192V400H632C636.4 400 640 403.6 640 408C640 412.4 636.4 416 632 416H288C288 469 245 512 192 512C138.1 512 96 469 96 416H80C35.82 416 0 380.2 0 336zM416 48H80C44.65 48 16 76.65 16 112V336C16 371.3 44.65 400 80 400H97.33C104.9 354.6 144.4 320 192 320C239.6 320 279.1 354.6 286.7 400L288 400H560V192C560 112.5 495.5 48 416 48zM192 496C236.2 496 272 460.2 272 416C272 371.8 236.2 336 192 336C147.8 336 112 371.8 112 416C112 460.2 147.8 496 192 496z"],
    "caravan-simple": [640, 512, ["caravan-alt"], "e000", "M224 128C241.7 128 256 142.3 256 160V224C256 241.7 241.7 256 224 256H96C78.33 256 64 241.7 64 224V160C64 142.3 78.33 128 96 128H224zM224 144H96C87.16 144 80 151.2 80 160V224C80 232.8 87.16 240 96 240H224C232.8 240 240 232.8 240 224V160C240 151.2 232.8 144 224 144zM320 160C320 142.3 334.3 128 352 128H416C433.7 128 448 142.3 448 160V224C448 241.7 433.7 256 416 256H352C334.3 256 320 241.7 320 224V160zM336 160V224C336 232.8 343.2 240 352 240H416C424.8 240 432 232.8 432 224V160C432 151.2 424.8 144 416 144H352C343.2 144 336 151.2 336 160zM96 416H80C35.82 416 0 380.2 0 336V112C0 67.82 35.82 32 80 32H416C504.4 32 576 103.6 576 192V400H632C636.4 400 640 403.6 640 408C640 412.4 636.4 416 632 416H288C288 469 245 512 192 512C138.1 512 96 469 96 416zM16 112V336C16 371.3 44.65 400 80 400H97.33C104.9 354.6 144.4 320 192 320C239.6 320 279.1 354.6 286.7 400H560V192C560 112.5 495.5 48 416 48H80C44.65 48 16 76.65 16 112zM192 336C147.8 336 112 371.8 112 416C112 460.2 147.8 496 192 496C236.2 496 272 460.2 272 416C272 371.8 236.2 336 192 336z"],
    "card-club": [384, 512, [], "e3e9", "M200 368H224C228.4 368 232 371.6 232 376C232 380.4 228.4 384 224 384H160C155.6 384 152 380.4 152 376C152 371.6 155.6 368 160 368H184V326.5C173.8 332.6 161.8 336 149.1 336C110.9 336 80 305.1 80 266.9C80 237.7 98.18 212.7 123.9 202.6C123.7 200.8 123.6 198.9 123.6 197.1C123.6 158.9 154.6 128 192.7 128C230.9 128 261.8 158.9 261.8 197.1C261.8 198.9 261.7 200.8 261.6 202.6C287.3 212.7 305.5 237.7 305.5 266.9C305.5 305.1 274.5 336 236.4 336C223 336 210.6 332.2 199.1 325.7L200 368zM140.5 206.6L141.8 213.8L134.8 215.8C112.4 222 96 242.6 96 266.9C96 296.2 119.8 320 149.1 320C163.9 320 177.4 313.9 187 304.1L192.7 298.2L198.4 304.1C208.1 313.9 221.5 320 236.4 320C265.7 320 289.5 296.2 289.5 266.9C289.5 242.6 273.1 222 250.7 215.8L243.7 213.8L244.1 206.6C245.5 203.5 245.8 200.4 245.8 197.1C245.8 167.8 222 144 192.7 144C163.4 144 139.6 167.8 139.6 197.1C139.6 200.4 139.9 203.5 140.5 206.6H140.5zM320 0C355.3 0 384 28.65 384 64V448C384 483.3 355.3 512 320 512H64C28.65 512 0 483.3 0 448V64C0 28.65 28.65 0 64 0H320zM320 16H64C37.49 16 16 37.49 16 64V448C16 474.5 37.49 496 64 496H320C346.5 496 368 474.5 368 448V64C368 37.49 346.5 16 320 16z"],
    "card-diamond": [384, 512, [], "e3ea", "M299.3 244.7C305.6 250.9 305.6 261.1 299.3 267.3L203.3 363.3C197.1 369.6 186.9 369.6 180.7 363.3L84.69 267.3C78.44 261.1 78.44 250.9 84.69 244.7L180.7 148.7C186.9 142.4 197.1 142.4 203.3 148.7L299.3 244.7zM96 256L192 352L288 256L192 160L96 256zM0 64C0 28.65 28.65 0 64 0H320C355.3 0 384 28.65 384 64V448C384 483.3 355.3 512 320 512H64C28.65 512 0 483.3 0 448V64zM16 64V448C16 474.5 37.49 496 64 496H320C346.5 496 368 474.5 368 448V64C368 37.49 346.5 16 320 16H64C37.49 16 16 37.49 16 64z"],
    "card-heart": [384, 512, [], "e3eb", "M90.61 261.5C64.4 234.9 65.8 190.9 95.3 166.1C119.9 145.1 157.4 148.5 180.1 170.3C181.6 170.8 182.2 171.4 182.8 172.1L192.2 181.7L201.1 172.1C201.8 171.4 202.5 170.7 203.2 170C226.8 148.4 263.7 145.2 289.1 166.1C318.2 190.9 319.6 234.9 293.3 261.5L202.1 353.2C196.9 359.2 187.1 359.2 181.4 353.2L90.61 261.5zM278.8 178.4C259.7 162.7 230.8 165.2 212.6 183.2L192.5 204.9L171.5 183.3C153.1 165 123.7 162.9 105.7 178.3L105.6 178.3C83.33 197 82.28 230.2 102 250.3L192.2 341.4L281.9 250.3C301.7 230.3 300.6 197.1 278.8 178.4H278.8zM0 64C0 28.65 28.65 0 64 0H320C355.3 0 384 28.65 384 64V448C384 483.3 355.3 512 320 512H64C28.65 512 0 483.3 0 448V64zM16 64V448C16 474.5 37.49 496 64 496H320C346.5 496 368 474.5 368 448V64C368 37.49 346.5 16 320 16H64C37.49 16 16 37.49 16 64z"],
    "card-spade": [384, 512, [], "e3ec", "M181 132.6C187.1 126.5 196.9 126.5 202.6 132.6L293.4 226.2C319.6 253.4 318.2 298.3 288.7 323.6C264 345.1 226.5 341.6 202.9 319.3C202.3 318.7 201.7 318.1 201.2 317.5L199.1 316.3V365.1H223.1C228.4 365.1 231.1 369.6 231.1 373.1C231.1 378.4 228.4 381.1 223.1 381.1H159.1C155.6 381.1 151.1 378.4 151.1 373.1C151.1 369.6 155.6 365.1 159.1 365.1H183.1V316.3L182.9 317.5C182.2 318.2 181.6 318.8 180.9 319.5C157.4 341.6 120.4 345 94.88 323.6C65.85 298.3 64.45 253.4 90.66 226.2L181 132.6zM102.2 237.3C82.27 257.1 83.35 292.2 105.3 311.5C124.3 327.3 153 324.9 171.3 306.5L191.5 284.2L212.7 306.4C231 325.1 260.2 327.2 278.2 311.6L278.3 311.5C300.7 292.3 301.8 257.1 281.9 237.3L191.8 144.4L102.2 237.3zM0 64C0 28.65 28.65 0 64 0H320C355.3 0 384 28.65 384 64V448C384 483.3 355.3 512 320 512H64C28.65 512 0 483.3 0 448V64zM16 64V448C16 474.5 37.49 496 64 496H320C346.5 496 368 474.5 368 448V64C368 37.49 346.5 16 320 16H64C37.49 16 16 37.49 16 64z"],
    "cards": [640, 512, [], "e3ed", "M253.3 358.3C251.1 354.5 252.4 349.6 256.2 347.4L274.2 336.1L256.3 308.2C255.9 309.5 255.6 310.8 255.1 312.1C246.3 337.1 220.5 355.6 192.7 350.7C159.9 344.3 139.3 311 147.2 279.2L174.5 169.3C176.5 162.1 183.9 157.8 190.8 159.9L299.9 190.1C331.5 200 349.1 234.5 338.8 266.4C329.7 292.6 301.1 306.3 274.3 300.9C272.9 300.6 271.5 300.3 270.2 299.9L269.9 299.8L288.1 328.1L304.4 319.5C308.3 317.3 313.2 318.6 315.4 322.5C317.6 326.3 316.3 331.2 312.4 333.4L264.2 361.2C260.4 363.4 255.5 362.1 253.3 358.3L253.3 358.3zM162.7 283C156.1 306.1 171.1 330.3 195.7 334.1C215.7 338.4 235.3 324.9 240.8 304.1L246.8 276.3L274.5 284.5C295.6 290.3 317.3 279.6 323.6 261.2L323.7 261.1C331.8 238 318.4 212.9 295.5 206.4L189.3 176.2L162.7 283zM220.4 7.637C247.2-7.827 281.5 1.35 296.9 28.13L463.6 316.9C479.1 343.6 469.9 377.9 443.1 393.4L250.8 504.4C224 519.8 189.8 510.7 174.3 483.9L7.629 195.2C-7.835 168.4 1.342 134.1 28.13 118.7L220.4 7.637zM228.4 21.49L36.13 132.5C16.99 143.6 10.44 168 21.49 187.2L188.2 475.9C199.2 495 223.7 501.6 242.8 490.5L435.1 379.5C454.2 368.5 460.8 343.1 449.8 324.9L283.1 36.13C272 17 247.6 10.45 228.4 21.49V21.49zM339.3 490.2C345.3 493.9 352.4 496 360 496H584C606.1 496 624 478.1 624 456V120C624 97.91 606.1 80 584 80H363.8L354.7 64.25C356.5 64.08 358.2 64 360 64H584C614.9 64 640 89.07 640 120V456C640 486.9 614.9 512 584 512H360C346.4 512 333.8 507.1 324.1 499L339.3 490.2zM562.5 136.6L562.6 136.7C579.6 151.5 580.4 177.8 565 193.7L522.9 237.4L522.8 237.5C516.1 243.3 507.2 243.7 501.3 237.4L458.9 193.7C443.6 177.8 444.4 151.5 461.6 136.7C476.5 123.7 498.4 126 511.1 138.5C525.6 125.1 547.2 123.8 562.5 136.6V136.6zM501.1 151.1C493.6 142.6 480.3 141.7 472.1 148.7L472.1 148.8C461.9 157.5 461.4 173.2 470.4 182.6L512.1 225.6L553.5 182.6C562.6 173.2 562.1 157.6 552.1 148.8C543.5 141.6 530.4 142.7 522.1 151L512.2 161.9L501.1 151.1z"],
    "cards-blank": [640, 512, [], "e4df", "M7.629 195.2C-7.835 168.4 1.342 134.1 28.13 118.7L220.4 7.637C247.2-7.827 281.5 1.35 296.9 28.13L463.6 316.9C479.1 343.6 469.9 377.9 443.1 393.4L250.8 504.4C224 519.8 189.8 510.7 174.3 483.9L7.629 195.2zM21.49 187.2L188.2 475.9C199.2 495 223.7 501.6 242.8 490.5L435.1 379.5C454.2 368.5 460.8 343.1 449.8 324.9L283.1 36.13C272 17 247.6 10.45 228.4 21.49L36.13 132.5C16.99 143.6 10.44 168 21.49 187.2V187.2zM360 512C346.4 512 333.8 507.1 324.1 499L339.3 490.2C345.3 493.9 352.4 496 360 496H584C606.1 496 624 478.1 624 456V119.1C624 97.91 606.1 79.1 584 79.1H363.8L354.7 64.25C356.5 64.08 358.2 63.1 360 63.1H584C614.9 63.1 640 89.07 640 119.1V456C640 486.9 614.9 512 584 512L360 512z"],
    "caret-down": [320, 512, [], "f0d7", "M296 192h-272C10.69 192 0 202.8 0 215.1c0 6.014 2.26 11.94 6.551 16.48l136 144C147.1 381.3 153.4 384 160 384s12.91-2.721 17.45-7.521l136-144C317.7 227.9 320 222 320 215.1C320 202.8 309.3 192 296 192zM301.8 221.5l-135.1 143.1C164.3 367.1 162.2 368 160 368s-4.312-.9141-5.816-2.506l-135.1-144C16.78 220 16 218 16 215.1C16 211.6 19.59 208 24 208h272c4.412 0 8 3.586 8 7.994C304 218 303.2 220 301.8 221.5z"],
    "caret-left": [256, 512, [], "f0d9", "M168 96c-6.012 0-11.94 2.26-16.48 6.551l-144 136C2.721 243.1 0 249.4 0 255.1s2.721 12.91 7.52 17.45l144 136C156.1 413.7 161.1 416 168 416C181.2 416 192 405.3 192 392v-272C192 106.7 181.2 96 168 96zM176 392c0 4.41-3.588 8-7.996 8c-2.053 0-4.008-.7773-5.498-2.184l-143.1-136C16.91 260.3 16 258.2 16 256s.9141-4.312 2.506-5.816l143.1-135.1C163.1 112.8 165.1 112 168 112C172.4 112 176 115.6 176 120V392z"],
    "caret-right": [256, 512, [], "f0da", "M248.5 238.6l-144-136C99.94 98.26 94.01 96 87.1 96C74.84 96 64 106.7 64 120v272C64 405.3 74.82 416 87.1 416c6.012 0 11.94-2.26 16.48-6.553l144-136C253.3 268.9 256 262.6 256 255.1S253.3 243.1 248.5 238.6zM237.5 261.8l-144 136C92 399.2 90.05 400 87.1 400C83.59 400 80 396.4 80 392v-272c0-4.412 3.588-8 7.996-8c2.055 0 4.008 .7754 5.498 2.184l143.1 135.1C239.1 251.7 240 253.8 240 256S239.1 260.3 237.5 261.8z"],
    "caret-up": [320, 512, [], "f0d8", "M313.4 279.5l-136-144C172.9 130.7 166.6 128 160 128s-12.91 2.721-17.45 7.52l-136 144C2.26 284.1 0 289.1 0 296C0 309.2 10.67 320 24 320h272C309.3 320 320 309.2 320 296C320 289.1 317.7 284.1 313.4 279.5zM296 304h-272C19.59 304 16 300.4 16 296c0-2.055 .7754-4.006 2.184-5.498l136-144C155.7 144.9 157.8 144 160 144s4.312 .9141 5.816 2.506l136 144C303.2 291.1 304 293.9 304 296C304 300.4 300.4 304 296 304z"],
    "carrot": [512, 512, [129365], "f787", "M243.2 144.2c-18.08 0-36.43 4.012-53.81 12.51c-25.88 12.63-45.5 33.14-57.13 57.15l-130.1 265.9c-2.875 6.002-2.998 13.25 0 19.63c3.945 7.98 12.01 12.62 20.31 12.62c3.273 0 6.581-.7196 9.693-2.241l266-129.9c24-11.63 44.51-31.25 57.13-57.13c23.89-48.88 12.3-105.5-24.08-141.1C307.8 157.3 275.9 144.2 243.2 144.2zM340.1 315.7c-10.57 21.67-28.23 39.34-49.77 49.78L176.7 421.4l-43.04-43.04c-3.125-3.125-8.188-3.125-11.31 0c-3.125 3.125-3.125 8.188 0 11.31l39.15 39.15l-136.3 66.57c-.8359 .4121-1.734 .6191-2.668 .6191c-1.908 0-4.617-.9727-5.834-3.428c-.8926-1.896-.9102-4.102-.1055-5.785l129.7-265.2l40.07 40.07c1.562 1.562 3.609 2.344 5.656 2.344S196.1 263.2 197.7 261.7c3.125-3.125 3.125-8.188 0-11.31l-43-43c10.49-15.35 24.83-28.02 41.76-36.28c14.77-7.221 30.51-10.88 46.79-10.88c28.45 0 56.44 11.64 76.75 31.9C352.6 224.9 361.1 274.5 340.1 315.7zM510.2 155.2c-30.05-36.29-73.47-50.61-114.3-39.03c11.58-40.91-2.725-84.24-39.04-114.3c-2.945-2.443-7.252-2.459-10.23 .0156c-26.02 21.55-41.12 50.33-42.51 81.01c-1.379 30.36 10.73 59.87 34.07 83.1l7.848 7.848c22.04 22.16 49.73 34.19 78.45 34.19c1.551 0 3.117-.0469 4.668-.1094c30.69-1.395 59.46-16.49 81.02-42.51C512.6 162.4 512.6 158.1 510.2 155.2zM428.4 191.9c-26.07 1.301-51.04-9.256-71.04-29.38l-7.879-7.879c-20.11-20-30.55-45.22-29.37-71.02c1.096-24.06 12.27-46.88 31.61-64.89c31.5 29.31 40.67 70.91 23.18 107.7c-1.457 3.07-.8301 6.719 1.566 9.115c2.412 2.396 6.078 3.039 9.117 1.566c36.83-17.43 78.41-8.301 107.7 23.18C475.3 179.6 452.5 190.8 428.4 191.9z"],
    "cars": [640, 512, [], "f85b", "M49.32 118.1L48.31 117.8L70.36 40.62C77.23 16.57 99.2 0 124.2 0H259.8C284.8 0 306.8 16.57 313.6 40.62L335.7 117.8L334.7 118.1C348.3 123.7 359.9 133 368.5 144.7C362.5 145.4 356.6 146.7 350.1 148.5C339.3 135.9 322.6 128 304 128H80C44.65 128 16 156.7 16 192V256H275.8L271.2 272H16V328C16 332.4 12.42 336 8 336C3.582 336 0 332.4 0 328V192C0 158.7 20.36 130.1 49.32 118.1L49.32 118.1zM66.27 113.2C70.73 112.4 75.32 112 79.1 112H303.1C308.7 112 313.3 112.4 317.7 113.2L298.3 45.01C293.3 27.84 277.7 15.1 259.8 15.1H124.2C106.3 15.1 90.65 27.84 85.74 45.01L66.27 113.2zM47.1 192C47.1 174.3 62.33 160 79.1 160C97.67 160 111.1 174.3 111.1 192C111.1 209.7 97.67 224 79.1 224C62.33 224 47.1 209.7 47.1 192zM79.1 176C71.16 176 63.1 183.2 63.1 192C63.1 200.8 71.16 208 79.1 208C88.84 208 95.1 200.8 95.1 192C95.1 183.2 88.84 176 79.1 176zM303.1 368C303.1 350.3 318.3 336 336 336C353.7 336 368 350.3 368 368C368 385.7 353.7 400 336 400C318.3 400 303.1 385.7 303.1 368zM336 352C327.2 352 319.1 359.2 319.1 368C319.1 376.8 327.2 384 336 384C344.8 384 352 376.8 352 368C352 359.2 344.8 352 336 352zM592 368C592 385.7 577.7 400 560 400C542.3 400 528 385.7 528 368C528 350.3 542.3 336 560 336C577.7 336 592 350.3 592 368zM560 384C568.8 384 576 376.8 576 368C576 359.2 568.8 352 560 352C551.2 352 544 359.2 544 368C544 376.8 551.2 384 560 384zM305.3 294.1L304.3 293.8L326.4 216.6C333.2 192.6 355.2 176 380.2 176H515.8C540.8 176 562.8 192.6 569.6 216.6L591.7 293.8L590.7 294.1C619.6 306.1 640 334.7 640 368V504C640 508.4 636.4 512 632 512C627.6 512 624 508.4 624 504V448H271.1V504C271.1 508.4 268.4 512 263.1 512C259.6 512 255.1 508.4 255.1 504V368C255.1 334.7 276.4 306.1 305.3 294.1H305.3zM322.3 289.2C326.7 288.4 331.3 288 336 288H560C564.7 288 569.3 288.4 573.7 289.2L554.3 221C549.3 203.8 533.7 191.1 515.8 191.1H380.2C362.3 191.1 346.7 203.8 341.7 221L322.3 289.2zM624 432V368C624 332.7 595.3 304 560 304H336C300.7 304 271.1 332.7 271.1 368V432H624z"],
    "cart-arrow-down": [576, 512, [], "f218", "M78.53 32H288V48H82.7L141.1 272H487.8C494.9 272 501.2 267.2 503.2 260.3L557.2 68.33C560 58.13 552.4 48 541.8 48H384V32H541.8C562.1 32 578.3 52.25 572.6 72.66L518.6 264.7C514.7 278.5 502.1 288 487.8 288H145.3L166.2 368H496C500.4 368 504 371.6 504 376C504 380.4 500.4 384 496 384H159.1C156.4 384 153.2 381.5 152.3 378L57.82 16H8C3.582 16 0 12.42 0 8C0 3.582 3.582 0 8 0H64C67.64 0 70.82 2.458 71.74 5.98L78.53 32zM128 464C128 437.5 149.5 416 176 416C202.5 416 224 437.5 224 464C224 490.5 202.5 512 176 512C149.5 512 128 490.5 128 464zM176 496C193.7 496 208 481.7 208 464C208 446.3 193.7 432 176 432C158.3 432 144 446.3 144 464C144 481.7 158.3 496 176 496zM512 464C512 490.5 490.5 512 464 512C437.5 512 416 490.5 416 464C416 437.5 437.5 416 464 416C490.5 416 512 437.5 512 464zM464 432C446.3 432 432 446.3 432 464C432 481.7 446.3 496 464 496C481.7 496 496 481.7 496 464C496 446.3 481.7 432 464 432zM344 180.7L410.3 114.3C413.5 111.2 418.5 111.2 421.7 114.3C424.8 117.5 424.8 122.5 421.7 125.7L341.7 205.7C338.5 208.8 333.5 208.8 330.3 205.7L250.3 125.7C247.2 122.5 247.2 117.5 250.3 114.3C253.5 111.2 258.5 111.2 261.7 114.3L328 180.7V8C328 3.582 331.6 0 336 0C340.4 0 344 3.582 344 8L344 180.7z"],
    "cart-arrow-up": [576, 512, [], "e3ee", "M541.8 48H411.9L395.9 32H541.8C562.1 32 578.3 52.25 572.6 72.66L518.6 264.7C514.7 278.5 502.1 288 487.8 288H145.3L166.2 368H496C500.4 368 504 371.6 504 376C504 380.4 500.4 384 496 384H159.1C156.4 384 153.2 381.5 152.3 378L57.82 16H8C3.582 16 0 12.42 0 8C0 3.582 3.582 0 8 0H64C67.64 0 70.82 2.458 71.74 5.98L78.53 32H276.1L260.1 48H82.7L141.1 272H487.8C494.9 272 501.2 267.2 503.2 260.3L557.2 68.33C560 58.13 552.4 48 541.8 48H541.8zM128 464C128 437.5 149.5 416 176 416C202.5 416 224 437.5 224 464C224 490.5 202.5 512 176 512C149.5 512 128 490.5 128 464zM176 496C193.7 496 208 481.7 208 464C208 446.3 193.7 432 176 432C158.3 432 144 446.3 144 464C144 481.7 158.3 496 176 496zM512 464C512 490.5 490.5 512 464 512C437.5 512 416 490.5 416 464C416 437.5 437.5 416 464 416C490.5 416 512 437.5 512 464zM464 432C446.3 432 432 446.3 432 464C432 481.7 446.3 496 464 496C481.7 496 496 481.7 496 464C496 446.3 481.7 432 464 432zM328 59.31L261.7 125.7C258.5 128.8 253.5 128.8 250.3 125.7C247.2 122.5 247.2 117.5 250.3 114.3L330.3 34.34C333.5 31.22 338.5 31.22 341.7 34.34L421.7 114.3C424.8 117.5 424.8 122.5 421.7 125.7C418.5 128.8 413.5 128.8 410.3 125.7L344 59.31V232C344 236.4 340.4 240 336 240C331.6 240 328 236.4 328 232L328 59.31z"],
    "cart-circle-arrow-down": [640, 512, [], "e3ef", "M64 0C67.64 0 70.82 2.458 71.74 5.98L78.53 32H541.8C562.1 32 578.3 52.25 572.6 72.66L537.6 196.9C532.4 195.7 527.2 194.7 521.8 193.9L557.2 68.33C560 58.13 552.4 48 541.8 48H82.7L141.1 272H348.5C345.1 277.2 342 282.5 339.2 288H145.3L166.2 368H319.1C319.1 373.4 320.2 378.7 320.7 384H159.1C156.4 384 153.2 381.5 152.3 378L57.82 16H8C3.582 16 0 12.42 0 8C0 3.582 3.582 .0003 8 .0003L64 0zM128 464C128 437.5 149.5 416 176 416C202.5 416 224 437.5 224 464C224 490.5 202.5 512 176 512C149.5 512 128 490.5 128 464zM176 496C193.7 496 208 481.7 208 464C208 446.3 193.7 432 176 432C158.3 432 144 446.3 144 464C144 481.7 158.3 496 176 496zM565.7 370.3C568.8 373.5 568.8 378.5 565.7 381.7L501.7 445.7C498.5 448.8 493.5 448.8 490.3 445.7L426.3 381.7C423.2 378.5 423.2 373.5 426.3 370.3C429.5 367.2 434.5 367.2 437.7 370.3L488 420.7V295.1C488 291.6 491.6 287.1 496 287.1C500.4 287.1 504 291.6 504 295.1V420.7L554.3 370.3C557.5 367.2 562.5 367.2 565.7 370.3H565.7zM496 224C575.5 224 640 288.5 640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368C352 288.5 416.5 224 496 224zM368 368C368 438.7 425.3 496 496 496C566.7 496 624 438.7 624 368C624 297.3 566.7 240 496 240C425.3 240 368 297.3 368 368z"],
    "cart-circle-arrow-up": [640, 512, [], "e3f0", "M64 0C67.64 0 70.82 2.458 71.74 5.98L78.53 32H541.8C562.1 32 578.3 52.25 572.6 72.66L537.6 196.9C532.4 195.7 527.2 194.7 521.8 193.9L557.2 68.33C560 58.13 552.4 48 541.8 48H82.7L141.1 272H348.5C345.1 277.2 342 282.5 339.2 288H145.3L166.2 368H319.1C319.1 373.4 320.2 378.7 320.7 384H159.1C156.4 384 153.2 381.5 152.3 378L57.82 16H8C3.582 16 0 12.42 0 8C0 3.582 3.582 .0003 8 .0003L64 0zM128 464C128 437.5 149.5 416 176 416C202.5 416 224 437.5 224 464C224 490.5 202.5 512 176 512C149.5 512 128 490.5 128 464zM176 496C193.7 496 208 481.7 208 464C208 446.3 193.7 432 176 432C158.3 432 144 446.3 144 464C144 481.7 158.3 496 176 496zM426.3 365.7C423.2 362.5 423.2 357.5 426.3 354.3L490.3 290.3C493.5 287.2 498.5 287.2 501.7 290.3L565.7 354.3C568.8 357.5 568.8 362.5 565.7 365.7C562.5 368.8 557.5 368.8 554.3 365.7L504 315.3V440C504 444.4 500.4 448 496 448C491.6 448 488 444.4 488 440V315.3L437.7 365.7C434.5 368.8 429.5 368.8 426.3 365.7H426.3zM496 512C416.5 512 352 447.5 352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368C640 447.5 575.5 512 496 512zM624 368C624 297.3 566.7 240 496 240C425.3 240 368 297.3 368 368C368 438.7 425.3 496 496 496C566.7 496 624 438.7 624 368z"],
    "cart-circle-check": [640, 512, [], "e3f1", "M64 0C67.64 0 70.82 2.458 71.74 5.98L78.53 32H541.8C562.1 32 578.3 52.25 572.6 72.66L537.6 196.9C532.4 195.7 527.2 194.7 521.8 193.9L557.2 68.33C560 58.13 552.4 48 541.8 48H82.7L141.1 272H348.5C345.1 277.2 342 282.5 339.2 288H145.3L166.2 368H319.1C319.1 373.4 320.2 378.7 320.7 384H159.1C156.4 384 153.2 381.5 152.3 378L57.82 16H8C3.582 16 0 12.42 0 8C0 3.582 3.582 .0003 8 .0003L64 0zM128 464C128 437.5 149.5 416 176 416C202.5 416 224 437.5 224 464C224 490.5 202.5 512 176 512C149.5 512 128 490.5 128 464zM176 496C193.7 496 208 481.7 208 464C208 446.3 193.7 432 176 432C158.3 432 144 446.3 144 464C144 481.7 158.3 496 176 496zM565.7 322.3C568.8 325.5 568.8 330.5 565.7 333.7L485.7 413.7C482.5 416.8 477.5 416.8 474.3 413.7L426.3 365.7C423.2 362.5 423.2 357.5 426.3 354.3C429.5 351.2 434.5 351.2 437.7 354.3L480 396.7L554.3 322.3C557.5 319.2 562.5 319.2 565.7 322.3H565.7zM352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368zM496 496C566.7 496 624 438.7 624 368C624 297.3 566.7 240 496 240C425.3 240 368 297.3 368 368C368 438.7 425.3 496 496 496z"],
    "cart-circle-exclamation": [640, 512, [], "e3f2", "M64 0C67.64 0 70.82 2.458 71.74 5.98L78.53 32H541.8C562.1 32 578.3 52.25 572.6 72.66L537.6 196.9C532.4 195.7 527.2 194.7 521.8 193.9L557.2 68.33C560 58.13 552.4 48 541.8 48H82.7L141.1 272H348.5C345.1 277.2 342 282.5 339.2 288H145.3L166.2 368H319.1C319.1 373.4 320.2 378.7 320.7 384H159.1C156.4 384 153.2 381.5 152.3 378L57.82 16H8C3.582 16 0 12.42 0 8C0 3.582 3.582 .0003 8 .0003L64 0zM128 464C128 437.5 149.5 416 176 416C202.5 416 224 437.5 224 464C224 490.5 202.5 512 176 512C149.5 512 128 490.5 128 464zM176 496C193.7 496 208 481.7 208 464C208 446.3 193.7 432 176 432C158.3 432 144 446.3 144 464C144 481.7 158.3 496 176 496zM480 432C480 423.2 487.2 416 496 416C504.8 416 512 423.2 512 432C512 440.8 504.8 448 496 448C487.2 448 480 440.8 480 432zM495.1 280C500.4 280 503.1 283.6 503.1 288V384C503.1 388.4 500.4 392 495.1 392C491.6 392 487.1 388.4 487.1 384V288C487.1 283.6 491.6 280 495.1 280zM640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368zM496 240C425.3 240 368 297.3 368 368C368 438.7 425.3 496 496 496C566.7 496 624 438.7 624 368C624 297.3 566.7 240 496 240z"],
    "cart-circle-plus": [640, 512, [], "e3f3", "M64 0C67.64 0 70.82 2.458 71.74 5.98L78.53 32H541.8C562.1 32 578.3 52.25 572.6 72.66L537.6 196.9C532.4 195.7 527.2 194.7 521.8 193.9L557.2 68.33C560 58.13 552.4 48 541.8 48H82.7L141.1 272H348.5C345.1 277.2 342 282.5 339.2 288H145.3L166.2 368H319.1C319.1 373.4 320.2 378.7 320.7 384H159.1C156.4 384 153.2 381.5 152.3 378L57.82 16H8C3.582 16 0 12.42 0 8C0 3.582 3.582 .0003 8 .0003L64 0zM128 464C128 437.5 149.5 416 176 416C202.5 416 224 437.5 224 464C224 490.5 202.5 512 176 512C149.5 512 128 490.5 128 464zM176 496C193.7 496 208 481.7 208 464C208 446.3 193.7 432 176 432C158.3 432 144 446.3 144 464C144 481.7 158.3 496 176 496zM504 359.1H568C572.4 359.1 576 363.6 576 367.1C576 372.4 572.4 375.1 568 375.1H504V439.1C504 444.4 500.4 447.1 496 447.1C491.6 447.1 488 444.4 488 439.1V375.1H424C419.6 375.1 416 372.4 416 367.1C416 363.6 419.6 359.1 424 359.1H488V295.1C488 291.6 491.6 287.1 496 287.1C500.4 287.1 504 291.6 504 295.1V359.1zM640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368zM496 240C425.3 240 368 297.3 368 368C368 438.7 425.3 496 496 496C566.7 496 624 438.7 624 368C624 297.3 566.7 240 496 240z"],
    "cart-circle-xmark": [640, 512, [], "e3f4", "M64 0C67.64 0 70.82 2.458 71.74 5.98L78.53 32H541.8C562.1 32 578.3 52.25 572.6 72.66L537.6 196.9C532.4 195.7 527.2 194.7 521.8 193.9L557.2 68.33C560 58.13 552.4 48 541.8 48H82.7L141.1 272H348.5C345.1 277.2 342 282.5 339.2 288H145.3L166.2 368H319.1C319.1 373.4 320.2 378.7 320.7 384H159.1C156.4 384 153.2 381.5 152.3 378L57.82 16H8C3.582 16 0 12.42 0 8C0 3.582 3.582 .0003 8 .0003L64 0zM128 464C128 437.5 149.5 416 176 416C202.5 416 224 437.5 224 464C224 490.5 202.5 512 176 512C149.5 512 128 490.5 128 464zM176 496C193.7 496 208 481.7 208 464C208 446.3 193.7 432 176 432C158.3 432 144 446.3 144 464C144 481.7 158.3 496 176 496zM507.3 368L557.7 418.3C560.8 421.5 560.8 426.5 557.7 429.7C554.5 432.8 549.5 432.8 546.3 429.7L496 379.3L445.7 429.7C442.5 432.8 437.5 432.8 434.3 429.7C431.2 426.5 431.2 421.5 434.3 418.3L484.7 368L434.3 317.7C431.2 314.5 431.2 309.5 434.3 306.3C437.5 303.2 442.5 303.2 445.7 306.3L496 356.7L546.3 306.3C549.5 303.2 554.5 303.2 557.7 306.3C560.8 309.5 560.8 314.5 557.7 317.7L507.3 368zM640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368zM496 240C425.3 240 368 297.3 368 368C368 438.7 425.3 496 496 496C566.7 496 624 438.7 624 368C624 297.3 566.7 240 496 240z"],
    "cart-flatbed": [640, 512, ["dolly-flatbed"], "f474", "M632 416H128V72C128 29.59 101.7 0 64 0H8C3.594 0 0 3.594 0 8S3.594 16 8 16H64c33.16 0 48 28.12 48 56v352c0 4.406 3.594 8 8 8h52.46C164.8 440.5 160 451.7 160 464C160 490.5 181.5 512 208 512S256 490.5 256 464C256 451.7 251.2 440.5 243.5 432h216.9c-7.664 8.506-12.43 19.65-12.43 32C448 490.5 469.5 512 496 512c26.51 0 48.01-21.49 48.01-47.1c0-12.35-4.828-23.49-12.49-32H632c4.406 0 8-3.595 8-8.002S636.4 416 632 416zM208 496c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S225.6 496 208 496zM496 496c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S513.6 496 496 496zM224 352h352c17.67 0 32-14.33 32-32V96C608 78.33 593.7 64 576 64H224C206.3 64 192 78.33 192 96V320C192 337.7 206.3 352 224 352zM352 80h96v98.22l-44.03-25.16c-2.438-1.438-5.5-1.438-7.938 0L352 178.2V80zM208 96c0-8.822 7.178-16 16-16l112 .0016v111.1c0 2.844 1.531 5.499 4 6.905c2.438 1.438 5.531 1.469 7.969 .0313L400 169.2l52.03 29.72C453.3 199.7 454.6 200 456 200s2.781-.375 4-1.094C462.5 197.5 464 194.8 464 192V80L576 80c8.822 0 16 7.178 16 16v224c0 8.822-7.178 16-16 16H224c-8.822 0-16-7.178-16-16V96z"],
    "cart-flatbed-boxes": [640, 512, ["dolly-flatbed-alt"], "f475", "M632 416H128V72C128 29.59 101.7 0 64 0H8C3.594 0 0 3.594 0 8S3.594 16 8 16H64c33.16 0 48 28.12 48 56v352c0 4.406 3.594 8 8 8h52.46C164.8 440.5 160 451.7 160 464C160 490.5 181.5 512 208 512S256 490.5 256 464c0-12.35-4.797-23.49-12.46-32h216.9c-7.664 8.506-12.43 19.65-12.43 32c0 26.51 21.49 48 47.99 48c26.51 0 48.01-21.49 48.01-48c0-12.35-4.828-23.49-12.49-32H632c4.406 0 8-3.596 8-8.002S636.4 416 632 416zM208 496c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S225.6 496 208 496zM496 496c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S513.6 496 496 496zM224 352h128c17.67 0 32-14.33 32-32V96c0-17.67-14.33-32-32-32H224C206.3 64 192 78.33 192 96v224C192 337.7 206.3 352 224 352zM208 96c0-8.822 7.178-16 16-16h128c8.822 0 16 7.178 16 16v224c0 8.822-7.178 16-16 16H224c-8.822 0-16-7.178-16-16V96zM448 352h128c17.67 0 32-14.33 32-32V256c0-17.67-14.33-32-32-32h-128c-17.67 0-32 14.33-32 32v64C416 337.7 430.3 352 448 352zM432 256c0-8.822 7.178-16 16-16h128c8.824 0 16 7.178 16 16v64c0 8.822-7.176 16-16 16h-128c-8.822 0-16-7.178-16-16V256zM448 192h64c17.67 0 32-14.33 32-32V96c0-17.67-14.33-32-32-32h-64c-17.67 0-32 14.33-32 32v64C416 177.7 430.3 192 448 192zM432 96c0-8.822 7.178-16 16-16h64c8.822 0 16 7.178 16 16v64c0 8.822-7.178 16-16 16h-64c-8.822 0-16-7.178-16-16V96z"],
    "cart-flatbed-empty": [640, 512, ["dolly-flatbed-empty"], "f476", "M632 416H128V72C128 29.59 101.7 0 64 0H8C3.594 0 0 3.594 0 8S3.594 16 8 16H64c33.16 0 48 28.12 48 56v352c0 4.406 3.594 8 8 8h52.46C164.8 440.5 160 451.7 160 464C160 490.5 181.5 512 208 512S256 490.5 256 464c0-12.35-4.797-23.49-12.46-32h216.9c-7.664 8.506-12.43 19.65-12.43 32c0 26.51 21.49 48 47.99 48c26.51 0 48.01-21.49 48.01-48c0-12.35-4.828-23.49-12.49-32H632c4.406 0 8-3.596 8-8.002S636.4 416 632 416zM240 464c0 17.64-14.36 32-32 32s-32-14.36-32-32s14.36-32 32-32S240 446.4 240 464zM528 464c0 17.64-14.36 32-32 32s-32-14.36-32-32s14.36-32 32-32S528 446.4 528 464z"],
    "cart-flatbed-suitcase": [640, 512, ["luggage-cart"], "f59d", "M632 416H128V72C128 29.59 101.7 0 64 0H8C3.594 0 0 3.594 0 8S3.594 16 8 16H64c33.16 0 48 28.12 48 56v352c0 4.406 3.594 8 8 8h52.46C164.8 440.5 160 451.6 160 464C160 490.5 181.5 512 208 512S256 490.5 256 464c0-12.35-4.797-23.49-12.46-32h216.9c-7.664 8.508-12.41 19.65-12.41 32c0 26.51 21.48 48 47.99 48s48.01-21.49 48.01-48c0-12.35-4.852-23.49-12.51-32H632c4.406 0 8-3.596 8-8.002S636.4 416 632 416zM208 496c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S225.6 496 208 496zM496 496c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S513.6 496 496 496zM240 352h288c26.51 0 48-21.49 48-48v-128C576 149.5 554.5 128 528 128H480V72C480 49.94 462.1 32 440 32h-112C305.9 32 288 49.94 288 72V128H240C213.5 128 192 149.5 192 176v128C192 330.5 213.5 352 240 352zM496 144h32c17.64 0 32 14.36 32 32v128c0 17.64-14.36 32-32 32h-32V144zM304 72c0-13.22 10.78-24 24-24h112c13.22 0 24 10.78 24 24V128h-160V72zM288 144h192v192H288V144zM208 176c0-17.64 14.36-32 32-32h32v192h-32c-17.64 0-32-14.36-32-32V176z"],
    "cart-minus": [576, 512, [], "e0db", "M384 152C388.4 152 392 155.6 392 160C392 164.4 388.4 168 384 168H256C251.6 168 248 164.4 248 160C248 155.6 251.6 152 256 152H384zM.0003 8C.0003 3.582 3.582 0 8 0H64C67.64 0 70.82 2.458 71.74 5.98L78.53 32H541.8C562.1 32 578.3 52.25 572.6 72.66L518.6 264.7C514.7 278.5 502.1 288 487.8 288H145.3L166.2 368H496C500.4 368 504 371.6 504 376C504 380.4 500.4 384 496 384H159.1C156.4 384 153.2 381.5 152.3 378L57.82 16H8C3.582 16 0 12.42 0 8H.0003zM487.8 272C494.9 272 501.2 267.2 503.2 260.3L557.2 68.33C560 58.13 552.4 48 541.8 48H82.7L141.1 272H487.8zM224 464C224 490.5 202.5 512 176 512C149.5 512 128 490.5 128 464C128 437.5 149.5 416 176 416C202.5 416 224 437.5 224 464zM176 432C158.3 432 144 446.3 144 464C144 481.7 158.3 496 176 496C193.7 496 208 481.7 208 464C208 446.3 193.7 432 176 432zM416 464C416 437.5 437.5 416 464 416C490.5 416 512 437.5 512 464C512 490.5 490.5 512 464 512C437.5 512 416 490.5 416 464zM464 496C481.7 496 496 481.7 496 464C496 446.3 481.7 432 464 432C446.3 432 432 446.3 432 464C432 481.7 446.3 496 464 496z"],
    "cart-plus": [576, 512, [], "f217", "M248 160C248 155.6 251.6 152 256 152H312V96C312 91.58 315.6 88 320 88C324.4 88 328 91.58 328 96V152H384C388.4 152 392 155.6 392 160C392 164.4 388.4 168 384 168H328V224C328 228.4 324.4 232 320 232C315.6 232 312 228.4 312 224V168H256C251.6 168 248 164.4 248 160zM64 0C67.64 0 70.82 2.458 71.74 5.98L78.53 32H541.8C562.1 32 578.3 52.25 572.6 72.66L518.6 264.7C514.7 278.5 502.1 288 487.8 288H145.3L166.2 368H496C500.4 368 504 371.6 504 376C504 380.4 500.4 384 496 384H159.1C156.4 384 153.2 381.5 152.3 378L57.82 16H8C3.582 16 0 12.42 0 8C0 3.582 3.582 0 8 0H64zM82.7 48L141.1 272H487.8C494.9 272 501.2 267.2 503.2 260.3L557.2 68.33C560 58.13 552.4 48 541.8 48H82.7zM128 464C128 437.5 149.5 416 176 416C202.5 416 224 437.5 224 464C224 490.5 202.5 512 176 512C149.5 512 128 490.5 128 464zM176 496C193.7 496 208 481.7 208 464C208 446.3 193.7 432 176 432C158.3 432 144 446.3 144 464C144 481.7 158.3 496 176 496zM512 464C512 490.5 490.5 512 464 512C437.5 512 416 490.5 416 464C416 437.5 437.5 416 464 416C490.5 416 512 437.5 512 464zM464 432C446.3 432 432 446.3 432 464C432 481.7 446.3 496 464 496C481.7 496 496 481.7 496 464C496 446.3 481.7 432 464 432z"],
    "cart-shopping": [576, 512, [128722, "shopping-cart"], "f07a", "M64 0C67.64 0 70.82 2.458 71.74 5.98L78.53 32H541.8C562.1 32 578.3 52.25 572.6 72.66L518.6 264.7C514.7 278.5 502.1 288 487.8 288H145.3L166.2 368H496C500.4 368 504 371.6 504 376C504 380.4 500.4 384 496 384H159.1C156.4 384 153.2 381.5 152.3 378L57.82 16H8C3.582 16 0 12.42 0 8C0 3.582 3.582 0 8 0H64zM82.7 48L141.1 272H487.8C494.9 272 501.2 267.2 503.2 260.3L557.2 68.33C560 58.13 552.4 48 541.8 48H82.7zM128 464C128 437.5 149.5 416 176 416C202.5 416 224 437.5 224 464C224 490.5 202.5 512 176 512C149.5 512 128 490.5 128 464zM176 496C193.7 496 208 481.7 208 464C208 446.3 193.7 432 176 432C158.3 432 144 446.3 144 464C144 481.7 158.3 496 176 496zM512 464C512 490.5 490.5 512 464 512C437.5 512 416 490.5 416 464C416 437.5 437.5 416 464 416C490.5 416 512 437.5 512 464zM464 432C446.3 432 432 446.3 432 464C432 481.7 446.3 496 464 496C481.7 496 496 481.7 496 464C496 446.3 481.7 432 464 432z"],
    "cart-shopping-fast": [640, 512, [], "e0dc", "M64 8C64 3.582 67.58 0 72 0H128C131.6 0 134.8 2.458 135.7 5.98L142.5 32H605.8C626.1 32 642.3 52.25 636.6 72.66L582.6 264.7C578.7 278.5 566.1 288 551.8 288H209.3L230.2 368H560C564.4 368 568 371.6 568 376C568 380.4 564.4 384 560 384H223.1C220.4 384 217.2 381.5 216.3 378L121.8 16H71.1C67.58 16 63.1 12.42 63.1 8H64zM551.8 272C558.9 272 565.2 267.2 567.2 260.3L621.2 68.33C624 58.13 616.4 48 605.8 48H146.7L205.1 272H551.8zM288 464C288 490.5 266.5 512 240 512C213.5 512 192 490.5 192 464C192 437.5 213.5 416 240 416C266.5 416 288 437.5 288 464zM240 432C222.3 432 208 446.3 208 464C208 481.7 222.3 496 240 496C257.7 496 272 481.7 272 464C272 446.3 257.7 432 240 432zM480 464C480 437.5 501.5 416 528 416C554.5 416 576 437.5 576 464C576 490.5 554.5 512 528 512C501.5 512 480 490.5 480 464zM528 496C545.7 496 560 481.7 560 464C560 446.3 545.7 432 528 432C510.3 432 496 446.3 496 464C496 481.7 510.3 496 528 496zM120 128C124.4 128 128 131.6 128 136C128 140.4 124.4 144 120 144H8C3.582 144 0 140.4 0 136C0 131.6 3.582 128 8 128H120zM136 192C140.4 192 144 195.6 144 200C144 204.4 140.4 208 136 208H8C3.582 208 0 204.4 0 200C0 195.6 3.582 192 8 192H136zM152 256C156.4 256 160 259.6 160 264C160 268.4 156.4 272 152 272H8C3.582 272 0 268.4 0 264C0 259.6 3.582 256 8 256H152z"],
    "cart-xmark": [576, 512, [], "e0dd", "M269.1 109.1C272.2 105.1 277.3 105.1 280.4 109.1L320 148.7L359.6 109.1C362.7 105.1 367.8 105.1 370.9 109.1C374 112.2 374 117.3 370.9 120.4L331.3 160L370.9 199.6C374 202.7 374 207.8 370.9 210.9C367.8 214 362.7 214 359.6 210.9L320 171.3L280.4 210.9C277.3 214 272.2 214 269.1 210.9C265.1 207.8 265.1 202.7 269.1 199.6L308.7 160L269.1 120.4C265.1 117.3 265.1 112.2 269.1 109.1V109.1zM64 0C67.64 0 70.82 2.458 71.74 5.98L78.53 32H541.8C562.1 32 578.3 52.25 572.6 72.66L518.6 264.7C514.7 278.5 502.1 288 487.8 288H145.3L166.2 368H496C500.4 368 504 371.6 504 376C504 380.4 500.4 384 496 384H159.1C156.4 384 153.2 381.5 152.3 378L57.82 16H8C3.582 16 0 12.42 0 8C0 3.582 3.582 0 8 0H64zM82.7 48L141.1 272H487.8C494.9 272 501.2 267.2 503.2 260.3L557.2 68.33C560 58.13 552.4 48 541.8 48H82.7zM128 464C128 437.5 149.5 416 176 416C202.5 416 224 437.5 224 464C224 490.5 202.5 512 176 512C149.5 512 128 490.5 128 464zM176 496C193.7 496 208 481.7 208 464C208 446.3 193.7 432 176 432C158.3 432 144 446.3 144 464C144 481.7 158.3 496 176 496zM512 464C512 490.5 490.5 512 464 512C437.5 512 416 490.5 416 464C416 437.5 437.5 416 464 416C490.5 416 512 437.5 512 464zM464 432C446.3 432 432 446.3 432 464C432 481.7 446.3 496 464 496C481.7 496 496 481.7 496 464C496 446.3 481.7 432 464 432z"],
    "cash-register": [512, 512, [], "f788", "M256 56C260.4 56 264 59.58 264 64C264 68.42 260.4 72 256 72H96C91.58 72 88 68.42 88 64C88 59.58 91.58 56 96 56H256zM96 240C96 231.2 103.2 224 112 224C120.8 224 128 231.2 128 240C128 248.8 120.8 256 112 256C103.2 256 96 248.8 96 240zM224 240C224 248.8 216.8 256 208 256C199.2 256 192 248.8 192 240C192 231.2 199.2 224 208 224C216.8 224 224 231.2 224 240zM144 320C144 311.2 151.2 304 160 304C168.8 304 176 311.2 176 320C176 328.8 168.8 336 160 336C151.2 336 144 328.8 144 320zM320 240C320 248.8 312.8 256 304 256C295.2 256 288 248.8 288 240C288 231.2 295.2 224 304 224C312.8 224 320 231.2 320 240zM240 320C240 311.2 247.2 304 256 304C264.8 304 272 311.2 272 320C272 328.8 264.8 336 256 336C247.2 336 240 328.8 240 320zM416 240C416 248.8 408.8 256 400 256C391.2 256 384 248.8 384 240C384 231.2 391.2 224 400 224C408.8 224 416 231.2 416 240zM336 320C336 311.2 343.2 304 352 304C360.8 304 368 311.2 368 320C368 328.8 360.8 336 352 336C343.2 336 336 328.8 336 320zM272 128H184V160H424.5C456.3 160 483.3 183.4 487.8 214.9L511.4 379.5C511.8 382.5 512 385.5 512 388.5V448C512 483.3 483.3 512 448 512H64C28.65 512 0 483.3 0 448V388.5C0 385.5 .215 382.5 .6432 379.5L24.15 214.9C28.65 183.4 55.66 160 87.51 160H168V128H80C53.49 128 32 106.5 32 80V48C32 21.49 53.49 0 80 0H272C298.5 0 320 21.49 320 48V80C320 106.5 298.5 128 272 128V128zM48 48V80C48 97.67 62.33 112 80 112H272C289.7 112 304 97.67 304 80V48C304 30.33 289.7 16 272 16H80C62.33 16 48 30.33 48 48zM87.51 176C63.62 176 43.37 193.6 39.99 217.2L16.48 381.8C16.38 382.5 16.29 383.3 16.22 384H495.8C495.7 383.3 495.6 382.5 495.5 381.8L472 217.2C468.6 193.6 448.4 176 424.5 176H87.51zM16 400V448C16 474.5 37.49 496 64 496H448C474.5 496 496 474.5 496 448V400H16z"],
    "cassette-betamax": [576, 512, ["betamax"], "f8a4", "M512 32H64C28.66 32 0 60.65 0 96v320c0 35.35 28.66 64 64 64h448c35.34 0 64-28.65 64-64V96C576 60.65 547.3 32 512 32zM560 416c0 26.47-21.53 48-48 48H64c-26.47 0-48-21.53-48-48V144h544V416zM560 128h-544V96c0-26.47 21.53-48 48-48h448c26.47 0 48 21.53 48 48V128zM160 400c53.02 0 96-42.98 96-96s-42.98-96-96-96s-96 42.98-96 96S106.1 400 160 400zM160 224c44.11 0 80 35.89 80 80S204.1 384 160 384s-80-35.89-80-80S115.9 224 160 224zM160 336c17.67 0 32-14.33 32-32c0-17.67-14.33-32-32-32s-32 14.33-32 32C128 321.7 142.3 336 160 336zM160 288c8.822 0 16 7.178 16 16S168.8 320 160 320S144 312.8 144 304S151.2 288 160 288zM336 400h160c8.836 0 16-7.164 16-16V224c0-8.838-7.164-16-16-16h-160C327.2 208 320 215.2 320 224v160C320 392.8 327.2 400 336 400zM336 224h160v160h-160V224z"],
    "cassette-tape": [576, 512, [128429], "f8ab", "M512 32H64C28.66 32 0 60.65 0 96v320c0 35.35 28.66 64 64 64h448c35.34 0 64-28.65 64-64V96C576 60.65 547.3 32 512 32zM124.6 464l20.87-78.23C148.2 375.3 157.7 368 168.6 368h238.9c10.84 0 20.36 7.312 23.14 17.77L451.4 464H124.6zM560 416c0 26.47-21.53 48-48 48h-43.98l-21.97-82.36C441.4 364.2 425.5 352 407.4 352H168.6c-18.08 0-33.95 12.19-38.61 29.64L107.1 464H64c-26.47 0-48-21.53-48-48V96c0-26.47 21.53-48 48-48h448c26.47 0 48 21.53 48 48V416zM416 160H160C124.7 160 96 188.7 96 224c0 35.35 28.65 64 64 64h256c35.35 0 64-28.65 64-64C480 188.7 451.3 160 416 160zM160 272C133.5 272 112 250.5 112 224S133.5 176 160 176S208 197.5 208 224S186.5 272 160 272zM201.9 272C215.3 260.3 224 243.2 224 224S215.3 187.7 201.9 176h172.1C360.7 187.7 352 204.8 352 224s8.654 36.27 22.07 48H201.9zM416 272c-26.47 0-48-21.53-48-48s21.53-48 48-48s48 21.53 48 48S442.5 272 416 272z"],
    "cassette-vhs": [576, 512, [128252, "vhs"], "f8ec", "M111.1 400h353.8c4.535 0 8.857-1.926 11.89-5.297C499.5 369.5 512 337.2 512 304s-12.51-65.46-35.23-90.7C473.7 209.9 469.4 208 464.9 208H111.1c-4.535 0-8.857 1.926-11.89 5.297C76.51 238.5 64 270.8 64 304s12.51 65.46 35.23 90.7C102.3 398.1 106.6 400 111.1 400zM368 224l96.87 .0002C483.1 245.3 496 273.1 496 304s-12 58.75-31.13 80L368 384V224zM224 224h128v159.1H224V224zM111.1 224L208 224v160l-96.87 .0002C92 362.8 80 334.9 80 304S92 245.3 111.1 224zM400 248c-4.406 0-8 3.594-8 8s3.594 8 8 8c22.06 0 40 17.94 40 40s-17.94 40-40 40c-4.406 0-8 3.594-8 8s3.594 8 8 8c30.88 0 56-25.12 56-56S430.9 248 400 248zM528 32h-480C21.49 32 0 53.49 0 80v352c0 26.51 21.49 48 48 48h480c26.51 0 48-21.49 48-48V80C576 53.49 554.5 32 528 32zM560 432c0 17.64-14.36 32-32 32h-480c-17.64 0-32-14.36-32-32V160h544V432zM560 144h-544v-64c0-17.64 14.36-32 32-32h480c17.64 0 32 14.36 32 32V144zM176 360c4.406 0 8-3.594 8-8s-3.594-8-8-8c-22.06 0-40-17.94-40-40S153.9 264 176 264c4.406 0 8-3.594 8-8S180.4 248 176 248c-30.88 0-56 25.12-56 56S145.1 360 176 360z"],
    "castle": [640, 512, [], "e0de", "M128 24C128 10.75 138.7 0 152 0H184C197.3 0 208 10.75 208 24V72H232V24C232 10.75 242.7 0 256 0H280C293.3 0 304 10.75 304 24V72H336V24C336 10.75 346.7 0 360 0H384C397.3 0 408 10.75 408 24V72H432V24C432 10.75 442.7 0 456 0H488C501.3 0 512 10.75 512 24V224H560V184C560 170.7 570.7 160 584 160H616C629.3 160 640 170.7 640 184V440C640 479.8 607.8 512 568 512H72C32.24 512 0 479.8 0 440V184C0 170.7 10.75 160 24 160H56C69.25 160 80 170.7 80 184V224H128V24zM72 240C67.58 240 64 236.4 64 232V184C64 179.6 60.42 176 56 176H24C19.58 176 16 179.6 16 184V440C16 470.9 41.07 496 72 496H240V392C240 347.8 275.8 312 320 312C364.2 312 400 347.8 400 392V496H568C598.9 496 624 470.9 624 440V184C624 179.6 620.4 176 616 176H584C579.6 176 576 179.6 576 184V232C576 236.4 572.4 240 568 240H72zM496 24C496 19.58 492.4 16 488 16H456C451.6 16 448 19.58 448 24V80C448 84.42 444.4 88 440 88H400C395.6 88 392 84.42 392 80V24C392 19.58 388.4 16 384 16H360C355.6 16 352 19.58 352 24V80C352 84.42 348.4 88 344 88H296C291.6 88 288 84.42 288 80V24C288 19.58 284.4 16 280 16H256C251.6 16 248 19.58 248 24V80C248 84.42 244.4 88 240 88H200C195.6 88 192 84.42 192 80V24C192 19.58 188.4 16 184 16H152C147.6 16 144 19.58 144 24V224H496V24zM320 328C284.7 328 256 356.7 256 392V496H384V392C384 356.7 355.3 328 320 328z"],
    "cat": [576, 512, [128008], "f6be", "M416 128c-8.875 0-16 7.125-16 16s7.125 16 16 16s16-7.125 16-16S424.9 128 416 128zM571.2 .6978c-2.891-1.295-6.297-.7187-8.625 1.453l-67.03 61.87h-63.09l-67.03-61.87c-2.328-2.172-5.734-2.779-8.625-1.453C353.9 1.979 352 4.854 352 8.026v151.1c0 5.475 .8535 10.73 1.617 15.1H296c-82.5 0-153.5 50.22-184 121.7V200c0-57.34-46.66-104-104-104c-4.422 0-8 3.578-8 8s3.578 8 8 8c48.53 0 88 39.47 88 88v224c0 48.53 39.47 87.1 88 87.1h176c4.422 0 8-3.578 8-7.1v-32c0-22.06-17.94-40-40-40h-20.91L408 366.7v113.3c0 17.64 14.36 31.1 32 31.1h32c17.64 0 32-14.36 32-31.1V264.3C545.1 248.1 576 207.6 576 160V8.026C576 4.854 574.1 1.979 571.2 .6978zM488 480c0 8.828-7.172 16-16 16h-32c-8.828 0-16-7.172-16-16v-128c0-6.357-7.033-10.13-12.34-6.719L288 425.3v-9.295c0-52.94-43.06-96-96-96c-4.422 0-8 3.578-8 8s3.578 8 8 8c44.11 0 80 35.89 80 80v24c0 4.418 3.582 8 8 8h48c13.23 0 24 10.77 24 24v23.1l-168 .0004c-39.7 0-72-32.3-72-72v-47.1c0-101.5 82.55-184 184-184l61.24-.0003C371.1 238.1 413.4 272 464 272c8.254 0 16.25-1.029 24-2.732V480zM560 160c0 52.93-43.06 95.99-96 95.99s-96-43.06-96-95.1V26.29l55.91 51.61c1.469 1.373 3.406 2.123 5.422 2.123h69.34c2.016 0 3.953-.75 5.422-2.123L560 26.29V160zM496 144c0 8.875 7.125 16 16 16s16-7.125 16-16s-7.125-16-16-16S496 135.1 496 144z"],
    "cat-space": [640, 512, [], "e001", "M440 144c-8.875 0-16.01 7.125-16.01 15.1s7.12 16 15.1 16S456 168.9 456 160S448.9 144 440 144zM503.1 160c0 8.875 7.12 16 15.1 16S536 168.9 536 160s-7.125-16-16-16S503.1 151.1 503.1 160zM480 .0003c-88.37 0-160 71.63-160 159.1c0 5.48 1.074 10.66 1.613 16H296c-82.5 0-153.5 50.22-184 121.7V200c0-57.34-46.66-104-104-104c-4.422 0-8 3.578-8 8s3.578 8 8 8c48.53 0 88 39.47 88 88v224c0 48.53 39.47 87.1 88 87.1h176c4.422 0 8-3.578 8-7.1v-32c0-22.06-17.94-40-40-40H307.1L408 366.7v113.3c0 17.64 14.36 31.1 32 31.1h32c17.64 0 32-14.36 32-31.1V317.6C580.9 305.9 640 240.1 640 160C640 71.64 568.4 .0003 480 .0003zM480 16c30.54 0 58.77 9.699 82.09 25.97l-55.1 54.03h-52.19l-55.1-54.03C421.2 25.7 449.5 16 480 16zM560 66.22l-.0146 109.8c0 44.11-35.88 79.1-79.99 79.1s-80-35.89-80-79.1V66.22l45.11 43.53c1.5 1.453 3.484 2.25 5.562 2.25h58.66c2.078 0 4.062-.7969 5.562-2.25L560 66.22zM488 480c0 8.828-7.172 16-16 16h-32c-8.828 0-16-7.172-16-16v-128c0-6.357-7.033-10.13-12.34-6.719L288 425.3v-9.295c0-52.94-43.06-96-96-96c-4.422 0-8 3.578-8 8s3.578 8 8 8c44.11 0 80 35.89 80 80v24c0 4.418 3.582 8 8 8h48c13.23 0 24 10.77 24 24l0 24.01L184 496c-39.7 0-72-32.3-72-72v-48c0-101.5 82.55-184 184-184h27.22C338.1 265 402.6 320 480 320c2.74 0 5.293-.6696 8-.8063V480zM480 304c-79.4 0-144-64.6-144-144c0-42.39 18.75-80.17 48-106.5v122.5c0 52.94 43.06 96 96 96s96-43.06 96-96V53.46c29.25 26.38 48 64.15 48 106.5C624 239.4 559.4 304 480 304zM168 72h48v48c0 4.422 3.571 7.1 7.993 7.1S232 124.4 232 120v-48h48c4.422 0 7.993-3.579 7.993-8S284.4 56 280 56h-48v-48c0-4.422-3.585-8-8.007-8S216 3.579 216 8.001v48h-48c-4.422 0-8.007 3.578-8.007 7.1S163.6 72 168 72z"],
    "cauldron": [448, 512, [], "f6bf", "M192 32C192 49.67 177.7 64 160 64C142.3 64 128 49.67 128 32C128 14.33 142.3 0 160 0C177.7 0 192 14.33 192 32zM160 16C151.2 16 144 23.16 144 32C144 40.84 151.2 48 160 48C168.8 48 176 40.84 176 32C176 23.16 168.8 16 160 16zM320 80C320 106.5 298.5 128 272 128C245.5 128 224 106.5 224 80C224 53.49 245.5 32 272 32C298.5 32 320 53.49 320 80zM272 48C254.3 48 240 62.33 240 80C240 97.67 254.3 112 272 112C289.7 112 304 97.67 304 80C304 62.33 289.7 48 272 48zM66.8 176H8C3.582 176 0 172.4 0 168C0 163.6 3.582 160 8 160H440C444.4 160 448 163.6 448 168C448 172.4 444.4 176 440 176H381.2C407.1 209.8 448 275.6 448 334.4C448 371.8 436.1 403.8 416 429.9V504C416 508.4 412.4 512 408 512C403.6 512 400 508.4 400 504V447.9C357.3 489.6 291.3 512 224 512C156.7 512 90.73 489.6 48 447.9V504C48 508.4 44.42 512 40 512C35.58 512 32 508.4 32 504V429.9C11.93 403.8 0 371.8 0 334.4C0 275.6 40.88 209.8 66.8 176V176zM46.06 237.2C29.2 268.2 16 303.2 16 334.4C16 359.1 21.74 381.1 32 400.5V400L34.47 404.9C45.29 423.6 60.42 439.6 78.69 452.8C117.3 480.7 169.9 496 224 496C278.1 496 330.7 480.7 369.3 452.8C407.5 425.2 432 385.3 432 334.4C432 303.2 418.8 268.2 401.9 237.2C387.5 210.7 371.2 188.5 360.7 176H87.28C76.78 188.5 60.47 210.7 46.06 237.2V237.2z"],
    "cedi-sign": [320, 512, [], "e0df", "M192 0C196.4 0 200 3.582 200 8V64.01C243.7 64.43 284.1 78.61 316.7 102.3C320.3 104.9 321.1 109.9 318.5 113.5C315.9 117.1 310.9 117.9 307.3 115.3C277.4 93.5 240.3 80.43 200 80.01V431.1C240.3 431.6 277.4 418.5 307.3 396.7C310.9 394.1 315.9 394.9 318.5 398.5C321.1 402.1 320.3 407.1 316.7 409.7C284.1 433.4 243.7 447.6 200 447.1V504C200 508.4 196.4 512 192 512C187.6 512 184 508.4 184 504V447.5C81.39 440.6 0 357.7 0 256C0 154.3 81.39 71.43 184 64.47V8C184 3.582 187.6 0 192 0V0zM184 431.5V80.51C89.82 87.42 16 163.6 16 256C16 348.4 89.82 424.6 184 431.5z"],
    "cent-sign": [320, 512, [], "e3f5", "M192 0C196.4 0 200 3.582 200 8V64.01C243.7 64.43 284.1 78.61 316.7 102.3C320.3 104.9 321.1 109.9 318.5 113.5C315.9 117.1 310.9 117.9 307.3 115.3C276.9 93.14 239 80 197.1 80C97.24 80 16 159 16 256C16 352.1 97.24 432 197.1 432C239 432 276.9 418.9 307.3 396.7C310.9 394.1 315.9 394.9 318.5 398.5C321.1 402.1 320.3 407.1 316.7 409.7C284.1 433.4 243.7 447.6 200 447.1V504C200 508.4 196.4 512 192 512C187.6 512 184 508.4 184 504V447.5C81.39 440.6 0 357.7 0 256C0 154.3 81.39 71.43 184 64.47V8C184 3.582 187.6 0 192 0V0z"],
    "certificate": [512, 512, [], "f0a3", "M256 53.46L300.1 7.261C307 1.034 315.1-1.431 324.4 .8185C332.8 3.068 339.3 9.679 341.4 18.1L357.3 80.6L419.3 63.07C427.7 60.71 436.7 63.05 442.8 69.19C448.1 75.34 451.3 84.33 448.9 92.69L431.4 154.7L493.9 170.6C502.3 172.7 508.9 179.2 511.2 187.6C513.4 196 510.1 204.1 504.7 211L458.5 256L504.7 300.1C510.1 307 513.4 315.1 511.2 324.4C508.9 332.8 502.3 339.3 493.9 341.4L431.4 357.3L448.9 419.3C451.3 427.7 448.1 436.7 442.8 442.8C436.7 448.1 427.7 451.3 419.3 448.9L357.3 431.4L341.4 493.9C339.3 502.3 332.8 508.9 324.4 511.2C315.1 513.4 307 510.1 300.1 504.7L256 458.5L211 504.7C204.1 510.1 196 513.4 187.6 511.2C179.2 508.9 172.7 502.3 170.6 493.9L154.7 431.4L92.69 448.9C84.33 451.3 75.34 448.1 69.19 442.8C63.05 436.7 60.71 427.7 63.07 419.3L80.6 357.3L18.1 341.4C9.679 339.3 3.068 332.8 .8186 324.4C-1.431 315.1 1.034 307 7.261 300.1L53.46 256L7.261 211C1.034 204.1-1.431 196 .8186 187.6C3.068 179.2 9.679 172.7 18.1 170.6L80.6 154.7L63.07 92.69C60.71 84.33 63.05 75.34 69.19 69.19C75.34 63.05 84.33 60.71 92.69 63.07L154.7 80.6L170.6 18.1C172.7 9.679 179.2 3.068 187.6 .8185C196-1.431 204.1 1.034 211 7.261L256 53.46zM162.7 94.45C158.1 96.61 154.5 97.17 150.4 95.99L88.34 78.47C85.55 77.68 82.56 78.46 80.51 80.51C78.46 82.56 77.68 85.55 78.47 88.34L95.99 150.4C97.17 154.5 96.61 158.1 94.45 162.7C92.29 166.5 88.71 169.2 84.53 170.2L22.04 186.1C19.23 186.8 17.02 188.1 16.27 191.8C15.52 194.6 16.35 197.5 18.42 199.6L64.62 244.5C67.72 247.5 69.46 251.7 69.46 256C69.46 260.3 67.72 264.5 64.62 267.5L18.42 312.4C16.35 314.5 15.52 317.4 16.27 320.2C17.02 323 19.23 325.2 22.04 325.9L84.53 341.8C88.71 342.8 92.29 345.5 94.45 349.3C96.61 353 97.17 357.5 95.99 361.6L78.47 423.7C77.68 426.5 78.46 429.4 80.51 431.5C82.56 433.5 85.55 434.3 88.34 433.5L150.4 416C154.5 414.8 158.1 415.4 162.7 417.5C166.5 419.7 169.2 423.3 170.2 427.5L186.1 489.1C186.8 492.8 188.1 494.1 191.8 495.7C194.6 496.5 197.5 495.7 199.6 493.6L244.5 447.4C247.5 444.3 251.7 442.5 256 442.5C260.3 442.5 264.5 444.3 267.5 447.4L312.4 493.6C314.5 495.7 317.4 496.5 320.2 495.7C323 494.1 325.2 492.8 325.9 489.1L341.8 427.5C342.8 423.3 345.5 419.7 349.3 417.5C353 415.4 357.5 414.8 361.6 416L423.7 433.5C426.5 434.3 429.4 433.5 431.5 431.5C433.5 429.4 434.3 426.5 433.5 423.7L416 361.6C414.8 357.5 415.4 353 417.5 349.3C419.7 345.5 423.3 342.8 427.5 341.8L489.1 325.9C492.8 325.2 494.1 323 495.7 320.2C496.5 317.4 495.7 314.5 493.6 312.4L447.4 267.5C444.3 264.5 442.5 260.3 442.5 256C442.5 251.7 444.3 247.5 447.4 244.5L493.6 199.6C495.7 197.5 496.5 194.6 495.7 191.8C494.1 188.1 492.8 186.8 489.1 186.1L427.5 170.2C423.3 169.2 419.7 166.5 417.5 162.7C415.4 158.1 414.8 154.5 416 150.4L433.5 88.34C434.3 85.55 433.5 82.56 431.5 80.51C429.4 78.46 426.5 77.68 423.7 78.47L361.6 95.99C357.5 97.17 353 96.61 349.3 94.45C345.5 92.29 342.8 88.71 341.8 84.53L325.9 22.03C325.2 19.23 323 17.02 320.2 16.27C317.4 15.52 314.5 16.34 312.4 18.42L267.5 64.62C264.5 67.72 260.3 69.46 256 69.46C251.7 69.46 247.5 67.72 244.5 64.62L199.6 18.42C197.5 16.34 194.6 15.52 191.8 16.27C188.1 17.02 186.8 19.23 186.1 22.03L170.2 84.53C169.2 88.71 166.5 92.29 162.7 94.45L162.7 94.45z"],
    "chair": [448, 512, [129681], "f6c0", "M445.1 338.6l-14.77-32C425.1 295.3 413.7 288 401.2 288h-17.23l-.0032-152c0-74.98-61-136-136-136h-48c-75 0-136 61.02-136 136L63.1 288H46.76C34.28 288 22.94 295.3 17.7 306.6l-14.77 32c-4.562 9.906-3.766 21.47 2.109 30.66S21.09 384 31.1 384h15.1v120c0 4.422 3.57 8 7.977 8s8.023-3.578 8.023-8L63.1 384h320l-.0012 120c0 4.422 3.575 8 7.981 8s8.019-3.578 8.019-8V384h16c10.91 0 21.08-5.562 26.95-14.75S449.6 348.5 445.1 338.6zM367.1 136V288h-71.1l-.0027-261.8C338.3 44.74 367.1 86.91 367.1 136zM247.1 16c11.15 0 21.75 2.023 32 4.885V288h-48V16H247.1zM215.1 16V288h-48V20.88C178.3 18.02 188.8 16 199.1 16H215.1zM79.1 136c0-49.09 29.7-91.26 72-109.8L151.1 288H79.1V136zM429.5 360.6C426.5 365.2 421.5 368 415.1 368h-384c-5.486 0-10.52-2.756-13.47-7.369c-2.957-4.625-3.352-10.36-1.062-15.33l14.77-32C34.84 307.6 40.54 304 46.76 304h354.5c6.223 0 11.93 3.648 14.54 9.297l14.76 31.99C432.8 350.3 432.4 356 429.5 360.6z"],
    "chair-office": [448, 512, [], "f6c1", "M398.3 306.6C393.1 295.3 381.7 288 369.2 288H78.76C66.28 288 54.94 295.3 49.7 306.6l-14.77 32c-4.562 9.906-3.766 21.47 2.109 30.66S53.09 384 63.1 384H216v64.46C166.1 450.8 128 474.2 128 504C128 508.4 131.6 512 136 512s8-3.578 8-8c0-20.32 32.26-37.48 72-39.58V504c0 4.422 3.593 8 7.999 8S232 508.4 232 504v-39.58C271.7 466.5 304 483.7 304 504c0 4.422 3.594 8 8 8S320 508.4 320 504c0-29.8-38.11-53.2-88-55.54V384h152c10.91 0 21.08-5.562 26.95-14.75s6.672-20.75 2.109-30.66L398.3 306.6zM397.5 360.6C394.5 365.2 389.5 368 384 368H63.1c-5.486 0-10.52-2.756-13.47-7.369c-2.957-4.625-3.352-10.36-1.062-15.33l14.77-32C66.84 307.6 72.54 304 78.76 304h290.5c6.223 0 11.93 3.648 14.54 9.297l14.76 31.99C400.8 350.3 400.4 356 397.5 360.6zM104 264C108.4 264 112 260.4 112 256V72c0-30.88 25.12-56 56-56h112c30.88 0 56 25.12 56 56V256c0 4.422 3.594 8 8 8S351.1 260.4 351.1 256L352 72C352 32.3 319.7 0 280 0h-112C128.3 0 96 32.3 96 72L96.01 256C96.01 260.4 99.59 264 104 264zM40 256C44.41 256 48 252.4 48 248v-112C48 131.6 44.41 128 40 128S32 131.6 32 136v112C32 252.4 35.59 256 40 256zM408 128c-4.406 0-8 3.578-8 8v112C400 252.4 403.6 256 408 256S416 252.4 416 248v-112C416 131.6 412.4 128 408 128z"],
    "chalkboard": [576, 512, ["blackboard"], "f51b", "M568 464H544V56C544 42.78 533.2 32 520 32H56C42.78 32 32 42.78 32 56V464H8C3.594 464 0 467.6 0 472S3.594 480 8 480h560c4.406 0 8-3.594 8-8S572.4 464 568 464zM272 464v-64h160v64H272zM432 384h-160C263.2 384 256 391.2 256 400v64H48V56c0-4.406 3.594-8 8-8h464c4.406 0 8 3.594 8 8V464H448v-64C448 391.2 440.8 384 432 384z"],
    "chalkboard-user": [640, 512, ["chalkboard-teacher"], "f51c", "M616 0H184C170.8 0 160 10.77 160 24v64C160 92.42 163.6 96 168 96S176 92.42 176 88v-64c0-4.406 3.594-8 8-8h432c4.406 0 8 3.594 8 8v368c0 4.406-3.594 8-8 8H544v-64c0-8.838-7.164-16-16-16h-128c-8.836 0-16 7.162-16 16v64h-24c-4.406 0-8 3.578-8 8S355.6 416 360 416h256c13.22 0 24-10.77 24-24V24C640 10.77 629.2 0 616 0zM528 400h-128v-64h128V400zM192 352H128c-70.69 0-128 57.31-128 128c0 17.67 14.33 32 32 32h256c17.67 0 32-14.33 32-32C320 409.3 262.7 352 192 352zM288 496H32c-8.822 0-16-7.178-16-16c0-61.76 50.24-112 112-112h64c61.76 0 112 50.24 112 112C304 488.8 296.8 496 288 496zM160 320c53.02 0 96-42.98 96-96S213 128 160 128S64 170.1 64 224S106.1 320 160 320zM160 144c44.11 0 80 35.89 80 80c0 44.11-35.89 80-80 80S80 268.1 80 224C80 179.9 115.9 144 160 144z"],
    "champagne-glass": [256, 512, ["glass-champagne"], "f79e", "M224 496h-88V352c0-.3086-.293-.4922-.3262-.7891C202.6 347.1 256 290.9 256 221.8c0-35.09-13.27-130.1-33.02-215.6C222.1 2.562 218.9 0 215.2 0H40.81C37.09 0 33.86 2.562 33.02 6.188C13.27 91.69 0 186.7 0 221.8c0 69.11 53.38 125.3 120.3 129.4C120.3 351.5 120 351.7 120 352v144H32c-4.422 0-8 3.594-8 8S27.58 512 32 512h192c4.422 0 8-3.594 8-8S228.4 496 224 496zM47.19 16h161.6C217.8 55.59 224.8 94.27 229.9 128H26.07C31.22 94.27 38.22 55.59 47.19 16zM16 221.8c0-14.22 2.633-42.42 7.674-77.95C23.8 143.9 23.87 144 24 144h208c.127 0 .2012-.1289 .3262-.1328C237.4 179.4 240 207.6 240 221.8C240 284.8 189.8 336 128 336S16 284.8 16 221.8z"],
    "champagne-glasses": [640, 512, [129346, "glass-cheers"], "f79f", "M339 55.51L173.7 .4163C170.2-.7595 166.3 .6468 164.4 3.819C118.7 78.61 76.06 164.5 64.97 197.8c-21.84 65.5 11.01 135.6 73.16 160.7c-.125 .2734-.4629 .3516-.5586 .6445L93.93 463.6l-83.41-27.8c-4.189-1.395-8.717 .875-10.11 5.055c-1.391 4.172 .8652 8.711 5.057 10.11l181.1 60.66c4.191 1.398 8.719-.875 10.11-5.055c1.395-4.172-.8613-8.711-5.053-10.11l-83.41-27.8l43.64-104.5c.0977-.2891-.1211-.5625-.0605-.8515c64.76 17.24 133.1-19.12 154.9-84.63c11.09-33.26 28.54-127.5 36.83-214.8C344.8 60.13 342.5 56.68 339 55.51zM292.4 273.6c-19.89 59.68-83.7 92.35-142.2 72.84C91.68 326.9 60.24 262.5 80.13 202.8c4.492-13.48 15.9-39.37 31.9-71.45c.1172 .0391 .1465 .1875 .2676 .2266l197.1 65.71c.1191 .0391 .2305-.0547 .3516-.0234C303.3 232.5 296.9 260.1 292.4 273.6zM312.5 181.5L119.3 117.1c15.54-30.34 34.4-64.79 55.4-99.48l153.2 51.07C323.9 109 318.3 147.9 312.5 181.5zM629.5 435.8l-83.41 27.8l-43.65-104.5c-.0957-.293-.4336-.3711-.5586-.6445c62.15-25.06 94.1-95.16 73.16-160.7c-11.09-33.26-53.69-119.2-99.43-193.1c-1.938-3.168-5.811-4.555-9.334-3.383l-91.79 30.59c-4.787 1.594-6.809 7.258-4.211 11.59c.0293 .0469-.0273-.0469 0 0c1.902 3.199 5.77 4.742 9.301 3.566l85.71-28.57c21 34.69 39.86 69.14 55.4 99.48l-152.1 50.99c-2.785 .9297-4.835 3.461-5.315 6.355c-.0098 .0625 .0098-.0586 0 0c-.9727 5.875 4.64 10.72 10.29 8.84l155-51.67c.1211-.0391 .1504-.1875 .2676-.2266c16 32.07 27.41 57.97 31.9 71.45c19.89 59.68-11.55 124.1-70.08 143.6c-53.5 17.83-111.3-7.969-136.1-58.11c-2.654-5.379-10.02-6.027-13.34-1.035c-1.518 2.273-1.768 5.227-.5586 7.68c27.02 54.84 88.5 84.02 147.5 68.31c.0605 .289-.1582 .5625-.0605 .8515l43.64 104.5l-83.41 27.8c-4.191 1.398-6.447 5.937-5.053 10.11c1.391 4.18 5.918 6.453 10.11 5.055l181.1-60.66c4.191-1.398 6.447-5.937 5.057-10.11C638.2 436.6 633.7 434.4 629.5 435.8z"],
    "charging-station": [576, 512, [], "f5e7", "M196.8 105.6C200.3 108.3 201.1 113.3 198.4 116.8L136 200H232C235 200 237.8 201.7 239.2 204.4C240.5 207.1 240.2 210.4 238.4 212.8L166.4 308.8C163.7 312.3 158.7 313.1 155.2 310.4C151.7 307.7 150.9 302.7 153.6 299.2L216 216H120C116.1 216 114.2 214.3 112.8 211.6C111.5 208.9 111.8 205.6 113.6 203.2L185.6 107.2C188.3 103.7 193.3 102.9 196.8 105.6V105.6zM32 496V64C32 28.65 60.65 0 96 0H256C291.3 0 320 28.65 320 64V272H328C367.8 272 400 304.2 400 344V388C400 412.3 419.7 432 444 432C468.3 432 488 412.3 488 388V255.6C447.6 251.6 416 217.5 416 176V152C416 138.7 426.7 128 440 128H448V72C448 67.58 451.6 64 456 64C460.4 64 464 67.58 464 72V128H528V72C528 67.58 531.6 64 536 64C540.4 64 544 67.58 544 72V128H552C565.3 128 576 138.7 576 152V176C576 217.5 544.4 251.6 504 255.6V388C504 421.1 477.1 448 444 448C410.9 448 384 421.1 384 388V344C384 313.1 358.9 288 328 288H320V496H344C348.4 496 352 499.6 352 504C352 508.4 348.4 512 344 512H8C3.582 512 0 508.4 0 504C0 499.6 3.582 496 8 496H32zM48 64V416H304V64C304 37.49 282.5 16 256 16H96C69.49 16 48 37.49 48 64zM48 432V496H304V432H48zM440 144C435.6 144 432 147.6 432 152V176C432 211.3 460.7 240 496 240C531.3 240 560 211.3 560 176V152C560 147.6 556.4 144 552 144H440z"],
    "chart-area": [512, 512, ["area-chart"], "f1fe", "M16 408C16 438.9 41.07 464 72 464H504C508.4 464 512 467.6 512 472C512 476.4 508.4 480 504 480H72C32.24 480 0 447.8 0 408V40C0 35.58 3.582 32 8 32C12.42 32 16 35.58 16 40V408zM359.6 152.4C372.7 139.3 394.4 140.1 406.5 154.2L468.4 226.5C475.9 235.2 480 246.3 480 257.8V352C480 369.7 465.7 384 448 384H128C110.3 384 96 369.7 96 352V243.9C96 231.2 101.1 218.9 110.1 209.9L201.4 118.6C213.9 106.1 234.1 106.1 246.6 118.6L320 192L359.6 152.4zM235.3 129.9C229.1 123.7 218.9 123.7 212.7 129.9L121.4 221.3C115.4 227.3 112 235.4 112 243.9V352C112 360.8 119.2 368 128 368H448C456.8 368 464 360.8 464 352V257.8C464 250.1 461.3 242.7 456.3 236.9L394.3 164.6C388.3 157.6 377.5 157.2 370.9 163.7L331.3 203.3C328.3 206.3 324.2 208 320 208C315.8 208 311.7 206.3 308.7 203.3L235.3 129.9z"],
    "chart-bar": [512, 512, ["bar-chart"], "f080", "M16 408C16 438.9 41.07 464 72 464H504C508.4 464 512 467.6 512 472C512 476.4 508.4 480 504 480H72C32.24 480 0 447.8 0 408V40C0 35.58 3.582 32 8 32C12.42 32 16 35.58 16 40V408zM320 112C337.7 112 352 126.3 352 144C352 161.7 337.7 176 320 176H128C110.3 176 96 161.7 96 144C96 126.3 110.3 112 128 112H320zM128 160H320C328.8 160 336 152.8 336 144C336 135.2 328.8 128 320 128H128C119.2 128 112 135.2 112 144C112 152.8 119.2 160 128 160zM256 208C273.7 208 288 222.3 288 240C288 257.7 273.7 272 256 272H128C110.3 272 96 257.7 96 240C96 222.3 110.3 208 128 208H256zM128 256H256C264.8 256 272 248.8 272 240C272 231.2 264.8 224 256 224H128C119.2 224 112 231.2 112 240C112 248.8 119.2 256 128 256zM384 304C401.7 304 416 318.3 416 336C416 353.7 401.7 368 384 368H128C110.3 368 96 353.7 96 336C96 318.3 110.3 304 128 304H384zM128 352H384C392.8 352 400 344.8 400 336C400 327.2 392.8 320 384 320H128C119.2 320 112 327.2 112 336C112 344.8 119.2 352 128 352z"],
    "chart-bullet": [512, 512, [], "e0e1", "M280 32C284.4 32 288 35.58 288 40V64H464C490.5 64 512 85.49 512 112V176C512 202.5 490.5 224 464 224H288V248C288 252.4 284.4 256 280 256C275.6 256 272 252.4 272 248V224H48C21.49 224 0 202.5 0 176V112C0 85.49 21.49 64 48 64H272V40C272 35.58 275.6 32 280 32zM160 208H272V80H160V208zM288 80V208H464C481.7 208 496 193.7 496 176V112C496 94.33 481.7 80 464 80H288zM144 80H48C30.33 80 16 94.33 16 112V176C16 193.7 30.33 208 48 208H144V80zM376 256C380.4 256 384 259.6 384 264V288H464C490.5 288 512 309.5 512 336V400C512 426.5 490.5 448 464 448H384V472C384 476.4 380.4 480 376 480C371.6 480 368 476.4 368 472V448H48C21.49 448 0 426.5 0 400V336C0 309.5 21.49 288 48 288H368V264C368 259.6 371.6 256 376 256zM224 432H368V304H224V432zM384 304V432H464C481.7 432 496 417.7 496 400V336C496 318.3 481.7 304 464 304H384zM208 304H48C30.33 304 16 318.3 16 336V400C16 417.7 30.33 432 48 432H208V304z"],
    "chart-candlestick": [512, 512, [], "e0e2", "M8 32C12.42 32 16 35.58 16 40V408C16 438.9 41.07 464 72 464H504C508.4 464 512 467.6 512 472C512 476.4 508.4 480 504 480H72C32.24 480 0 447.8 0 408V40C0 35.58 3.582 32 8 32zM296 312V256H288C270.3 256 256 241.7 256 224V128C256 110.3 270.3 96 288 96H296V40C296 35.58 299.6 32 304 32C308.4 32 312 35.58 312 40V96H320C337.7 96 352 110.3 352 128V224C352 241.7 337.7 256 320 256H312V312C312 316.4 308.4 320 304 320C299.6 320 296 316.4 296 312zM288 112C279.2 112 272 119.2 272 128V224C272 232.8 279.2 240 288 240H320C328.8 240 336 232.8 336 224V128C336 119.2 328.8 112 320 112H288zM416 320C398.3 320 384 305.7 384 288V224C384 206.3 398.3 192 416 192H424V136C424 131.6 427.6 128 432 128C436.4 128 440 131.6 440 136V192H448C465.7 192 480 206.3 480 224V288C480 305.7 465.7 320 448 320H440V376C440 380.4 436.4 384 432 384C427.6 384 424 380.4 424 376V320H416zM400 288C400 296.8 407.2 304 416 304H448C456.8 304 464 296.8 464 288V224C464 215.2 456.8 208 448 208H416C407.2 208 400 215.2 400 224V288zM184 376C184 380.4 180.4 384 176 384C171.6 384 168 380.4 168 376V320H160C142.3 320 128 305.7 128 288V160C128 142.3 142.3 128 160 128H168V72C168 67.58 171.6 64 176 64C180.4 64 184 67.58 184 72V128H192C209.7 128 224 142.3 224 160V288C224 305.7 209.7 320 192 320H184V376zM208 160C208 151.2 200.8 144 192 144H160C151.2 144 144 151.2 144 160V288C144 296.8 151.2 304 160 304H192C200.8 304 208 296.8 208 288V160z"],
    "chart-column": [512, 512, [], "e0e3", "M16 408C16 438.9 41.07 464 72 464H504C508.4 464 512 467.6 512 472C512 476.4 508.4 480 504 480H72C32.24 480 0 447.8 0 408V40C0 35.58 3.582 32 8 32C12.42 32 16 35.58 16 40V408zM464 352C464 369.7 449.7 384 432 384C414.3 384 400 369.7 400 352V128C400 110.3 414.3 96 432 96C449.7 96 464 110.3 464 128V352zM416 128V352C416 360.8 423.2 368 432 368C440.8 368 448 360.8 448 352V128C448 119.2 440.8 112 432 112C423.2 112 416 119.2 416 128zM272 352C272 369.7 257.7 384 240 384C222.3 384 208 369.7 208 352V192C208 174.3 222.3 160 240 160C257.7 160 272 174.3 272 192V352zM224 192V352C224 360.8 231.2 368 240 368C248.8 368 256 360.8 256 352V192C256 183.2 248.8 176 240 176C231.2 176 224 183.2 224 192zM176 352C176 369.7 161.7 384 144 384C126.3 384 112 369.7 112 352V288C112 270.3 126.3 256 144 256C161.7 256 176 270.3 176 288V352zM128 288V352C128 360.8 135.2 368 144 368C152.8 368 160 360.8 160 352V288C160 279.2 152.8 272 144 272C135.2 272 128 279.2 128 288zM336 224C353.7 224 368 238.3 368 256V352C368 369.7 353.7 384 336 384C318.3 384 304 369.7 304 352V256C304 238.3 318.3 224 336 224zM320 256V352C320 360.8 327.2 368 336 368C344.8 368 352 360.8 352 352V256C352 247.2 344.8 240 336 240C327.2 240 320 247.2 320 256z"],
    "chart-gantt": [512, 512, [], "e0e4", "M16 408C16 438.9 41.07 464 72 464H504C508.4 464 512 467.6 512 472C512 476.4 508.4 480 504 480H72C32.24 480 0 447.8 0 408V40C0 35.58 3.582 32 8 32C12.42 32 16 35.58 16 40V408zM256 112C273.7 112 288 126.3 288 144C288 161.7 273.7 176 256 176H160C142.3 176 128 161.7 128 144C128 126.3 142.3 112 160 112H256zM160 160H256C264.8 160 272 152.8 272 144C272 135.2 264.8 128 256 128H160C151.2 128 144 135.2 144 144C144 152.8 151.2 160 160 160zM352 208C369.7 208 384 222.3 384 240C384 257.7 369.7 272 352 272H224C206.3 272 192 257.7 192 240C192 222.3 206.3 208 224 208H352zM224 256H352C360.8 256 368 248.8 368 240C368 231.2 360.8 224 352 224H224C215.2 224 208 231.2 208 240C208 248.8 215.2 256 224 256zM448 304C465.7 304 480 318.3 480 336C480 353.7 465.7 368 448 368H352C334.3 368 320 353.7 320 336C320 318.3 334.3 304 352 304H448zM352 352H448C456.8 352 464 344.8 464 336C464 327.2 456.8 320 448 320H352C343.2 320 336 327.2 336 336C336 344.8 343.2 352 352 352z"],
    "chart-line": [512, 512, ["line-chart"], "f201", "M16 408C16 438.9 41.07 464 72 464H504C508.4 464 512 467.6 512 472C512 476.4 508.4 480 504 480H72C32.24 480 0 447.8 0 408V40C0 35.58 3.582 32 8 32C12.42 32 16 35.58 16 40V408zM325.7 293.7C322.5 296.8 317.5 296.8 314.3 293.7L224 203.3L101.7 325.7C98.53 328.8 93.47 328.8 90.34 325.7C87.22 322.5 87.22 317.5 90.34 314.3L218.3 186.3C221.5 183.2 226.5 183.2 229.7 186.3L320 276.7L466.3 130.3C469.5 127.2 474.5 127.2 477.7 130.3C480.8 133.5 480.8 138.5 477.7 141.7L325.7 293.7z"],
    "chart-line-down": [512, 512, [128201], "f64d", "M16 408C16 438.9 41.07 464 72 464H504C508.4 464 512 467.6 512 472C512 476.4 508.4 480 504 480H72C32.24 480 0 447.8 0 408V40C0 35.58 3.582 32 8 32C12.42 32 16 35.58 16 40V408zM352 352C347.6 352 344 348.4 344 344C344 339.6 347.6 336 352 336H452.7L288 171.3L197.7 261.7C194.5 264.8 189.5 264.8 186.3 261.7L90.34 165.7C87.22 162.5 87.22 157.5 90.34 154.3C93.47 151.2 98.53 151.2 101.7 154.3L192 244.7L282.3 154.3C285.5 151.2 290.5 151.2 293.7 154.3L464 324.7V223.1C464 219.6 467.6 215.1 472 215.1C476.4 215.1 480 219.6 480 223.1V344C480 348.4 476.4 352 472 352L352 352z"],
    "chart-line-up": [512, 512, [], "e0e5", "M16 408C16 438.9 41.07 464 72 464H504C508.4 464 512 467.6 512 472C512 476.4 508.4 480 504 480H72C32.24 480 0 447.8 0 408V40C0 35.58 3.582 32 8 32C12.42 32 16 35.58 16 40V408zM472 128C476.4 128 480 131.6 480 136V256C480 260.4 476.4 264 472 264C467.6 264 464 260.4 464 256V155.3L293.7 325.7C290.5 328.8 285.5 328.8 282.3 325.7L192 235.3L101.7 325.7C98.53 328.8 93.47 328.8 90.34 325.7C87.22 322.5 87.22 317.5 90.34 314.3L186.3 218.3C189.5 215.2 194.5 215.2 197.7 218.3L288 308.7L452.7 143.1H352C347.6 143.1 344 140.4 344 135.1C344 131.6 347.6 127.1 352 127.1L472 128z"],
    "chart-mixed": [512, 512, ["analytics"], "f643", "M510 34.75C512.9 38.08 512.6 43.14 509.2 46.04L325.2 206C322.1 208.8 317.3 208.6 314.3 205.7L191.4 82.67L12.93 222.3C9.451 225 4.423 224.4 1.7 220.9C-1.023 217.5-.4099 212.4 3.069 209.7L187.1 65.7C190.3 63.21 194.8 63.48 197.7 66.34L320.4 189.1L498.7 33.96C502.1 31.06 507.1 31.42 510 34.75L510 34.75zM95.1 352V448C95.1 465.7 81.67 480 63.1 480C46.33 480 31.1 465.7 31.1 448V352C31.1 334.3 46.33 319.1 63.1 319.1C81.67 319.1 95.1 334.3 95.1 352zM79.1 448V352C79.1 343.2 72.84 336 63.1 336C55.16 336 47.1 343.2 47.1 352V448C47.1 456.8 55.16 464 63.1 464C72.84 464 79.1 456.8 79.1 448zM159.1 255.1C159.1 238.3 174.3 223.1 191.1 223.1C209.7 223.1 223.1 238.3 223.1 255.1V448C223.1 465.7 209.7 480 191.1 480C174.3 480 159.1 465.7 159.1 448V255.1zM175.1 255.1V448C175.1 456.8 183.2 464 191.1 464C200.8 464 207.1 456.8 207.1 448V255.1C207.1 247.2 200.8 239.1 191.1 239.1C183.2 239.1 175.1 247.2 175.1 255.1zM352 319.1V448C352 465.7 337.7 480 320 480C302.3 480 288 465.7 288 448V319.1C288 302.3 302.3 287.1 320 287.1C337.7 287.1 352 302.3 352 319.1zM336 448V319.1C336 311.2 328.8 303.1 320 303.1C311.2 303.1 304 311.2 304 319.1V448C304 456.8 311.2 464 320 464C328.8 464 336 456.8 336 448zM416 255.1C416 238.3 430.3 223.1 448 223.1C465.7 223.1 480 238.3 480 255.1V448C480 465.7 465.7 480 448 480C430.3 480 416 465.7 416 448V255.1zM432 255.1V448C432 456.8 439.2 464 448 464C456.8 464 464 456.8 464 448V255.1C464 247.2 456.8 239.1 448 239.1C439.2 239.1 432 247.2 432 255.1z"],
    "chart-network": [640, 512, [], "f78a", "M160 64C160 28.65 188.7 0 224 0C259.3 0 288 28.65 288 64C288 86.31 276.6 105.1 259.3 117.4L296.7 199.1C308.9 194.5 322.2 192 336 192C370.5 192 401.4 207.6 421.1 232.2L521.1 160.9C515.3 151.3 512 140 512 128C512 92.65 540.7 64 576 64C611.3 64 640 92.65 640 128C640 163.3 611.3 192 576 192C558.4 192 542.5 184.9 530.1 173.5L431.3 245.2C441.9 262.3 448 282.4 448 303.1C448 322.2 443.7 339.4 435.9 354.6L525.7 408.5C537.4 393.6 555.6 384 576 384C611.3 384 640 412.7 640 448C640 483.3 611.3 512 576 512C540.7 512 512 483.3 512 448C512 438.8 513.9 430.1 517.4 422.2L427.7 368.3C407.4 397.2 373.9 416 336 416C276.8 416 228.4 370.1 224.3 311.1H127.5C123.6 343.6 96.64 368 64 368C28.65 368 0 339.3 0 303.1C0 268.7 28.65 239.1 64 239.1C96.64 239.1 123.6 264.4 127.5 295.1H224.3C227 257 249.7 223.6 282.2 205.8L244.9 124.5C238.4 126.8 231.3 127.1 224 127.1C188.7 127.1 160 99.35 160 63.1V64zM224 112C250.5 112 272 90.51 272 64C272 37.49 250.5 16 224 16C197.5 16 176 37.49 176 64C176 90.51 197.5 112 224 112zM16 304C16 330.5 37.49 352 64 352C90.51 352 112 330.5 112 304C112 277.5 90.51 256 64 256C37.49 256 16 277.5 16 304zM576 496C602.5 496 624 474.5 624 448C624 421.5 602.5 400 576 400C561.4 400 548.3 406.5 539.5 416.8L540.1 417.1L531.9 430.9L531.3 430.5C529.2 435.9 528 441.8 528 448C528 474.5 549.5 496 576 496H576zM576 176C602.5 176 624 154.5 624 128C624 101.5 602.5 80 576 80C549.5 80 528 101.5 528 128C528 154.5 549.5 176 576 176zM336 400C389 400 432 357 432 304C432 250.1 389 208 336 208C282.1 208 240 250.1 240 304C240 357 282.1 400 336 400z"],
    "chart-pie": [576, 512, ["pie-chart"], "f200", "M320 240C311.2 240 304 232.8 304 224V15.47C304 7.074 310.5 .0432 318.9 .0026L320 0C443.7 0 544 100.3 544 224L543.1 225.1C543.1 233.5 536.9 240 528.5 240H320zM528 224C528 109.1 434.9 16 320 16V224H528zM256 49.61V288L412.5 444.5C419.2 451.2 418.7 462.2 411 467.7C371.8 495.6 323.8 512 272 512C139.5 512 32 404.6 32 272C32 150.7 122.1 50.34 238.1 34.25C248.2 32.99 256 40.36 256 49.61V49.61zM244.7 299.3C241.7 296.3 240 292.2 240 288V50.27C131.5 65.78 48 159.2 48 272C48 395.7 148.3 496 272 496C319.9 496 364.3 480.1 400.7 455.3L244.7 299.3zM499.9 447.3C493.9 452.1 484.5 452.5 478.7 446.7L347.3 315.3C337.2 305.2 344.4 288 358.6 288H558.4C567.6 288 575 295.8 573.8 305C566.1 360.9 539.1 410.6 499.9 447.3V447.3zM489.6 435C525.7 401 550.4 355.3 557.7 304H358.6L489.6 435z"],
    "chart-pie-simple": [512, 512, ["chart-pie-alt"], "f64e", "M259 7.64C262.1 3.051 267.1 0 273.1 0C405 0 512 106.1 512 238.9C512 248.6 503.9 256 494.3 256H272C263.2 256 256 248.8 256 240V17.68C256 13.98 257.1 10.51 259 7.64V7.64zM495.7 239.5C495.9 239.4 495.9 239.3 495.1 239.2C495.1 239.2 496 239.1 496 238.9C496 115.8 396.2 15.1 273.1 15.1C272.9 15.1 272.8 16.05 272.8 16.05C272.7 16.07 272.6 16.13 272.5 16.27C272.2 16.54 272 17.02 272 17.68V239.1H494.3C494.1 239.1 495.5 239.8 495.7 239.5L495.7 239.5zM224 288H445.3C463.8 288 478.6 303.7 474.8 321.8C451.9 430.5 355.5 512 240 512C107.5 512 0 404.5 0 272C0 156.5 81.53 60.12 190.2 37.18C208.3 33.36 224 48.2 224 66.7V288zM208 66.7C208 56.69 200 51.45 193.5 52.84C92.09 74.25 16 164.3 16 272C16 395.7 116.3 496 240 496C347.7 496 437.8 419.9 459.2 318.5C460.6 311.1 455.3 304 445.3 304H224C215.2 304 208 296.8 208 288L208 66.7z"],
    "chart-pyramid": [512, 512, [], "e0e6", "M221.4 59.72C236.9 33.26 275.1 33.26 290.6 59.72L500.6 419.8C516.2 446.5 496.9 480 466.1 480H45.93C15.06 480-4.179 446.5 11.38 419.8L221.4 59.72zM276.7 67.78C267.5 51.91 244.5 51.91 235.3 67.78L162.8 191.1H349.2L276.7 67.78zM423.9 319.1L358.5 207.1H153.5L88.14 319.1H423.9zM78.81 336L25.2 427.9C15.86 443.9 27.4 464 45.93 464H466.1C484.6 464 496.1 443.9 486.8 427.9L433.2 336H78.81z"],
    "chart-radar": [512, 512, [], "e0e7", "M256 112C282.5 112 304 133.5 304 160C304 177.3 294.8 192.5 281 200.1L309.8 273.1C313.1 272.4 316.5 272 320 272C346.5 272 368 293.5 368 320C368 346.5 346.5 368 320 368C293.5 368 272 346.5 272 320C272 319.5 272 319 272 318.6L204.9 305.1C197.1 323.2 180.5 336 160 336C133.5 336 112 314.5 112 288C112 261.5 133.5 240 160 240C167.9 240 175.4 241.9 182 245.3L221.2 193.1C213 184.5 208 172.8 208 160C208 133.5 229.5 112 256 112V112zM243.8 189.6C247.6 191.1 251.7 192 256 192C257.4 192 258.7 191.9 260.1 191.7C265.6 191 270.7 188.9 274.9 185.8C282.9 179.1 288 170.6 288 160C288 142.3 273.7 128 256 128C238.3 128 224 142.3 224 160C224 167.6 226.6 174.5 231 179.1C234.4 184.2 238.8 187.5 243.8 189.6H243.8zM208 288C208 288.5 207.1 288.1 207.1 289.4L275.1 302.9C278.1 292.9 286 284.5 294.1 279L266.2 206.9C262.9 207.6 259.5 208 256 208C248.1 208 240.6 206.1 233.1 202.7L194.8 254.9C202.1 263.5 208 275.2 208 288zM320 288C302.3 288 288 302.3 288 320C288 337.7 302.3 352 320 352C337.7 352 352 337.7 352 320C352 302.3 337.7 288 320 288zM160 320C177.7 320 192 305.7 192 288C192 270.3 177.7 256 160 256C142.3 256 128 270.3 128 288C128 305.7 142.3 320 160 320zM361.5 32C375.8 32 389 39.66 396.2 52.09L501.8 236.1C508.9 248.4 508.9 263.6 501.8 275.9L396.2 459.9C389 472.3 375.8 480 361.5 480H150.5C136.2 480 122.1 472.3 115.8 459.9L10.21 275.9C3.129 263.6 3.128 248.4 10.21 236.1L115.8 52.09C122.1 39.66 136.2 32 150.5 32H361.5zM24.08 244.1C19.84 251.5 19.84 260.5 24.08 267.9L129.7 451.9C133.1 459.4 141.9 464 150.5 464H361.5C370.1 464 378 459.4 382.3 451.9L487.9 267.9C492.2 260.5 492.2 251.5 487.9 244.1L382.3 60.05C378 52.6 370.1 48 361.5 48H150.5C141.9 48 133.1 52.6 129.7 60.05L24.08 244.1z"],
    "chart-scatter": [512, 512, [], "f7ee", "M16 408C16 438.9 41.07 464 72 464H504C508.4 464 512 467.6 512 472C512 476.4 508.4 480 504 480H72C32.24 480 0 447.8 0 408V40C0 35.58 3.582 32 8 32C12.42 32 16 35.58 16 40V408zM232 160C232 182.1 214.1 200 192 200C169.9 200 152 182.1 152 160C152 137.9 169.9 120 192 120C214.1 120 232 137.9 232 160zM192 184C205.3 184 216 173.3 216 160C216 146.7 205.3 136 192 136C178.7 136 168 146.7 168 160C168 173.3 178.7 184 192 184zM248 256C248 233.9 265.9 216 288 216C310.1 216 328 233.9 328 256C328 278.1 310.1 296 288 296C265.9 296 248 278.1 248 256zM288 232C274.7 232 264 242.7 264 256C264 269.3 274.7 280 288 280C301.3 280 312 269.3 312 256C312 242.7 301.3 232 288 232zM424 320C424 342.1 406.1 360 384 360C361.9 360 344 342.1 344 320C344 297.9 361.9 280 384 280C406.1 280 424 297.9 424 320zM384 344C397.3 344 408 333.3 408 320C408 306.7 397.3 296 384 296C370.7 296 360 306.7 360 320C360 333.3 370.7 344 384 344zM376 128C376 105.9 393.9 88 416 88C438.1 88 456 105.9 456 128C456 150.1 438.1 168 416 168C393.9 168 376 150.1 376 128zM416 104C402.7 104 392 114.7 392 128C392 141.3 402.7 152 416 152C429.3 152 440 141.3 440 128C440 114.7 429.3 104 416 104zM200 320C200 342.1 182.1 360 160 360C137.9 360 120 342.1 120 320C120 297.9 137.9 280 160 280C182.1 280 200 297.9 200 320zM160 344C173.3 344 184 333.3 184 320C184 306.7 173.3 296 160 296C146.7 296 136 306.7 136 320C136 333.3 146.7 344 160 344z"],
    "chart-scatter-3d": [512, 512, [], "e0e8", "M64 64C64 81.67 49.67 96 32 96C14.33 96 0 81.67 0 64C0 46.33 14.33 32 32 32C49.67 32 64 46.33 64 64zM32 80C40.84 80 48 72.84 48 64C48 55.16 40.84 48 32 48C23.16 48 16 55.16 16 64C16 72.84 23.16 80 32 80zM264 284.3L477.2 465.9C480.6 468.8 480.1 473.8 478.1 477.2C475.2 480.6 470.2 480.1 466.8 478.1L256 298.5L45.19 478.1C41.82 480.1 36.78 480.6 33.91 477.2C31.05 473.8 31.45 468.8 34.81 465.9L248 284.3V40C248 35.58 251.6 32 256 32C260.4 32 264 35.58 264 40V284.3zM416 64C416 81.67 401.7 96 384 96C366.3 96 352 81.67 352 64C352 46.33 366.3 32 384 32C401.7 32 416 46.33 416 64zM384 80C392.8 80 400 72.84 400 64C400 55.16 392.8 48 384 48C375.2 48 368 55.16 368 64C368 72.84 375.2 80 384 80zM352 256C352 238.3 366.3 224 384 224C401.7 224 416 238.3 416 256C416 273.7 401.7 288 384 288C366.3 288 352 273.7 352 256zM384 240C375.2 240 368 247.2 368 256C368 264.8 375.2 272 384 272C392.8 272 400 264.8 400 256C400 247.2 392.8 240 384 240zM512 160C512 177.7 497.7 192 480 192C462.3 192 448 177.7 448 160C448 142.3 462.3 128 480 128C497.7 128 512 142.3 512 160zM480 176C488.8 176 496 168.8 496 160C496 151.2 488.8 144 480 144C471.2 144 464 151.2 464 160C464 168.8 471.2 176 480 176zM96 160C96 142.3 110.3 128 128 128C145.7 128 160 142.3 160 160C160 177.7 145.7 192 128 192C110.3 192 96 177.7 96 160zM128 144C119.2 144 112 151.2 112 160C112 168.8 119.2 176 128 176C136.8 176 144 168.8 144 160C144 151.2 136.8 144 128 144zM0 256C0 238.3 14.33 224 32 224C49.67 224 64 238.3 64 256C64 273.7 49.67 288 32 288C14.33 288 0 273.7 0 256zM32 240C23.16 240 16 247.2 16 256C16 264.8 23.16 272 32 272C40.84 272 48 264.8 48 256C48 247.2 40.84 240 32 240zM288 448C288 465.7 273.7 480 256 480C238.3 480 224 465.7 224 448C224 430.3 238.3 416 256 416C273.7 416 288 430.3 288 448zM256 464C264.8 464 272 456.8 272 448C272 439.2 264.8 432 256 432C247.2 432 240 439.2 240 448C240 456.8 247.2 464 256 464z"],
    "chart-scatter-bubble": [512, 512, [], "e0e9", "M8 32C12.42 32 16 35.58 16 40V408C16 438.9 41.07 464 72 464H504C508.4 464 512 467.6 512 472C512 476.4 508.4 480 504 480H72C32.24 480 0 447.8 0 408V40C0 35.58 3.582 32 8 32zM128 304C128 277.5 149.5 256 176 256C202.5 256 224 277.5 224 304C224 330.5 202.5 352 176 352C149.5 352 128 330.5 128 304zM176 336C193.7 336 208 321.7 208 304C208 286.3 193.7 272 176 272C158.3 272 144 286.3 144 304C144 321.7 158.3 336 176 336zM416 288C416 323.3 387.3 352 352 352C316.7 352 288 323.3 288 288C288 252.7 316.7 224 352 224C387.3 224 416 252.7 416 288zM352 240C325.5 240 304 261.5 304 288C304 314.5 325.5 336 352 336C378.5 336 400 314.5 400 288C400 261.5 378.5 240 352 240zM192 176C192 149.5 213.5 128 240 128C266.5 128 288 149.5 288 176C288 202.5 266.5 224 240 224C213.5 224 192 202.5 192 176zM240 208C257.7 208 272 193.7 272 176C272 158.3 257.7 144 240 144C222.3 144 208 158.3 208 176C208 193.7 222.3 208 240 208zM448 128C448 163.3 419.3 192 384 192C348.7 192 320 163.3 320 128C320 92.65 348.7 64 384 64C419.3 64 448 92.65 448 128zM384 80C357.5 80 336 101.5 336 128C336 154.5 357.5 176 384 176C410.5 176 432 154.5 432 128C432 101.5 410.5 80 384 80z"],
    "chart-simple": [448, 512, [], "e473", "M240 32C266.5 32 288 53.49 288 80V432C288 458.5 266.5 480 240 480H208C181.5 480 160 458.5 160 432V80C160 53.49 181.5 32 208 32H240zM240 48H208C190.3 48 176 62.33 176 80V432C176 449.7 190.3 464 208 464H240C257.7 464 272 449.7 272 432V80C272 62.33 257.7 48 240 48zM80 224C106.5 224 128 245.5 128 272V432C128 458.5 106.5 480 80 480H48C21.49 480 0 458.5 0 432V272C0 245.5 21.49 224 48 224H80zM80 240H48C30.33 240 16 254.3 16 272V432C16 449.7 30.33 464 48 464H80C97.67 464 112 449.7 112 432V272C112 254.3 97.67 240 80 240zM320 144C320 117.5 341.5 96 368 96H400C426.5 96 448 117.5 448 144V432C448 458.5 426.5 480 400 480H368C341.5 480 320 458.5 320 432V144zM336 144V432C336 449.7 350.3 464 368 464H400C417.7 464 432 449.7 432 432V144C432 126.3 417.7 112 400 112H368C350.3 112 336 126.3 336 144z"],
    "chart-simple-horizontal": [448, 512, [], "e474", "M448 272C448 298.5 426.5 320 400 320H48C21.49 320 0 298.5 0 272V240C0 213.5 21.49 192 48 192H400C426.5 192 448 213.5 448 240V272zM400 208H48C30.33 208 16 222.3 16 240V272C16 289.7 30.33 304 48 304H400C417.7 304 432 289.7 432 272V240C432 222.3 417.7 208 400 208zM256 432C256 458.5 234.5 480 208 480H48C21.49 480 0 458.5 0 432V400C0 373.5 21.49 352 48 352H208C234.5 352 256 373.5 256 400V432zM208 368H48C30.33 368 16 382.3 16 400V432C16 449.7 30.33 464 48 464H208C225.7 464 240 449.7 240 432V400C240 382.3 225.7 368 208 368zM48 160C21.49 160 0 138.5 0 112V80C0 53.49 21.49 32 48 32H336C362.5 32 384 53.49 384 80V112C384 138.5 362.5 160 336 160H48zM368 112V80C368 62.33 353.7 48 336 48H48C30.33 48 16 62.33 16 80V112C16 129.7 30.33 144 48 144H336C353.7 144 368 129.7 368 112z"],
    "chart-tree-map": [512, 512, [], "e0ea", "M176 32C202.5 32 224 53.49 224 80V192C224 218.5 202.5 240 176 240H48C21.49 240 0 218.5 0 192V80C0 53.49 21.49 32 48 32H176zM176 48H48C30.33 48 16 62.33 16 80V192C16 209.7 30.33 224 48 224H176C193.7 224 208 209.7 208 192V80C208 62.33 193.7 48 176 48zM176 272C202.5 272 224 293.5 224 320V432C224 458.5 202.5 480 176 480H48C21.49 480 0 458.5 0 432V320C0 293.5 21.49 272 48 272H176zM176 288H48C30.33 288 16 302.3 16 320V432C16 449.7 30.33 464 48 464H176C193.7 464 208 449.7 208 432V320C208 302.3 193.7 288 176 288zM256 80C256 53.49 277.5 32 304 32H464C490.5 32 512 53.49 512 80V112C512 138.5 490.5 160 464 160H304C277.5 160 256 138.5 256 112V80zM272 80V112C272 129.7 286.3 144 304 144H464C481.7 144 496 129.7 496 112V80C496 62.33 481.7 48 464 48H304C286.3 48 272 62.33 272 80zM464 192C490.5 192 512 213.5 512 240V272C512 298.5 490.5 320 464 320H304C277.5 320 256 298.5 256 272V240C256 213.5 277.5 192 304 192H464zM464 208H304C286.3 208 272 222.3 272 240V272C272 289.7 286.3 304 304 304H464C481.7 304 496 289.7 496 272V240C496 222.3 481.7 208 464 208zM256 400C256 373.5 277.5 352 304 352H464C490.5 352 512 373.5 512 400V432C512 458.5 490.5 480 464 480H304C277.5 480 256 458.5 256 432V400zM272 400V432C272 449.7 286.3 464 304 464H464C481.7 464 496 449.7 496 432V400C496 382.3 481.7 368 464 368H304C286.3 368 272 382.3 272 400z"],
    "chart-user": [640, 512, ["user-chart"], "f6a3", "M160 320c53.02 0 96-42.98 96-96c0-53.02-42.98-96-96-96C106.1 128 64 170.1 64 224C64 277 106.1 320 160 320zM160 144c44.11 0 80 35.89 80 80c0 44.11-35.89 80-80 80S80 268.1 80 224C80 179.9 115.9 144 160 144zM584 0H216C185.1 0 160 25.12 160 56v32C160 92.41 163.6 96 168 96S176 92.41 176 88v-32c0-22.06 17.94-40 40-40h368c22.06 0 40 17.94 40 40v304c0 22.06-17.94 40-40 40h-240c-4.406 0-8 3.594-8 8S339.6 416 344 416h240c30.88 0 56-25.12 56-56v-304C640 25.12 614.9 0 584 0zM192 352H128c-70.69 0-128 57.3-128 128c0 17.67 14.33 32 32 32h256c17.67 0 32-14.33 32-32C320 409.3 262.7 352 192 352zM288 496H32c-8.822 0-16-7.178-16-16c0-61.76 50.24-112 112-112h64c61.76 0 112 50.24 112 112C304 488.8 296.8 496 288 496zM309.7 170.3c-3.125-3.125-8.188-3.125-11.31 0s-3.125 8.188 0 11.31l80 80C379.9 263.2 381.9 264 384 264s4.094-.7813 5.656-2.344L512 139.3V216C512 220.4 515.6 224 520 224s8-3.594 8-8v-96c0-4.406-3.594-8-8-8h-96C419.6 112 416 115.6 416 120S419.6 128 424 128h76.69L384 244.7L309.7 170.3z"],
    "chart-waterfall": [512, 512, [], "e0eb", "M16 408C16 438.9 41.07 464 72 464H504C508.4 464 512 467.6 512 472C512 476.4 508.4 480 504 480H72C32.24 480 0 447.8 0 408V40C0 35.58 3.582 32 8 32C12.42 32 16 35.58 16 40V408zM336 64C353.7 64 368 78.33 368 96V160C368 177.7 353.7 192 336 192C318.3 192 304 177.7 304 160V96C304 78.33 318.3 64 336 64zM320 96V160C320 168.8 327.2 176 336 176C344.8 176 352 168.8 352 160V96C352 87.16 344.8 80 336 80C327.2 80 320 87.16 320 96zM272 224C272 241.7 257.7 256 240 256C222.3 256 208 241.7 208 224V160C208 142.3 222.3 128 240 128C257.7 128 272 142.3 272 160V224zM224 160V224C224 232.8 231.2 240 240 240C248.8 240 256 232.8 256 224V160C256 151.2 248.8 144 240 144C231.2 144 224 151.2 224 160zM176 320C176 337.7 161.7 352 144 352C126.3 352 112 337.7 112 320V256C112 238.3 126.3 224 144 224C161.7 224 176 238.3 176 256V320zM128 256V320C128 328.8 135.2 336 144 336C152.8 336 160 328.8 160 320V256C160 247.2 152.8 240 144 240C135.2 240 128 247.2 128 256zM464 320C464 337.7 449.7 352 432 352C414.3 352 400 337.7 400 320V96C400 78.33 414.3 64 432 64C449.7 64 464 78.33 464 96V320zM416 96V320C416 328.8 423.2 336 432 336C440.8 336 448 328.8 448 320V96C448 87.16 440.8 80 432 80C423.2 80 416 87.16 416 96z"],
    "check": [448, 512, [10004, 10003], "f00c", "M437.7 106.3C440.8 109.5 440.8 114.5 437.7 117.7L165.7 389.7C162.5 392.8 157.5 392.8 154.3 389.7L10.34 245.7C7.219 242.5 7.219 237.5 10.34 234.3C13.47 231.2 18.53 231.2 21.66 234.3L159.1 372.7L426.3 106.3C429.5 103.2 434.5 103.2 437.7 106.3H437.7z"],
    "check-double": [448, 512, [], "f560", "M165.7 229.7C162.5 232.8 157.5 232.8 154.3 229.7L74.34 149.7C71.22 146.5 71.22 141.5 74.34 138.3C77.47 135.2 82.53 135.2 85.66 138.3L159.1 212.7L314.3 58.34C317.5 55.22 322.5 55.22 325.7 58.34C328.8 61.47 328.8 66.53 325.7 69.66L165.7 229.7zM165.7 453.7C162.5 456.8 157.5 456.8 154.3 453.7L10.34 309.7C7.219 306.5 7.219 301.5 10.34 298.3C13.47 295.2 18.53 295.2 21.66 298.3L159.1 436.7L426.3 170.3C429.5 167.2 434.5 167.2 437.7 170.3C440.8 173.5 440.8 178.5 437.7 181.7L165.7 453.7z"],
    "check-to-slot": [576, 512, ["vote-yea"], "f772", "M56 416c0 4.406 3.594 8 8 8h448c4.406 0 8-3.594 8-8s-3.594-8-8-8H64C59.59 408 56 411.6 56 416zM268.4 288c.25 0 .5313 0 .7813-.0313C271.5 287.8 273.5 286.6 274.8 284.8l107.6-144c2.656-3.531 1.906-8.531-1.625-11.19c-3.531-2.594-8.531-1.875-11.19 1.625L267.3 268.2L205.3 212.3C202.1 209.4 197 209.7 194.1 212.9C191.1 216.2 191.4 221.3 194.7 224.2l68.44 61.72C264.6 287.3 266.5 288 268.4 288zM536 352h-16C515.6 352 512 355.6 512 360s3.594 8 8 8h16c13.22 0 24 10.78 24 24v48c0 13.22-10.78 24-24 24H40c-13.22 0-24-10.78-24-24v-48c0-13.22 10.78-24 24-24h16C60.41 368 64 364.4 64 360S60.41 352 56 352h-16C17.94 352 0 369.9 0 392v48C0 462.1 17.94 480 40 480h496c22.06 0 40-17.94 40-40v-48C576 369.9 558.1 352 536 352zM104 368c4.406 0 8-3.594 8-8v-288c0-13.22 10.78-24 24-24h304c13.22 0 24 10.78 24 24v288c0 4.406 3.594 8 8 8S480 364.4 480 360v-288C480 49.94 462.1 32 440 32h-304C113.9 32 96 49.94 96 72v288C96 364.4 99.59 368 104 368z"],
    "cheese": [512, 512, [], "f7ef", "M316.8 32.67C313.7 32.22 310.6 32 307.6 32c-14.17 0-27.98 4.684-39.32 13.51l-255.9 200.8C4.567 252.4 0 261.7 0 271.5V432C0 458.5 21.49 480 48 480h416c26.51 0 48-21.49 48-48V255.1C512 82.26 377.3 41.43 316.8 32.67zM278.1 58.14C286.6 51.51 296.8 48 307.6 48c2.314 0 4.643 .166 6.967 .502C369.1 56.4 496 92.44 496 256H25.93L278.1 58.14zM464 464h-416c-17.64 0-32-14.36-32-32v-160h480v160C496 449.6 481.6 464 464 464z"],
    "cheese-swiss": [512, 512, [129472], "f7f0", "M176 312c-30.88 0-56 25.12-56 56s25.12 56 56 56s56-25.12 56-56S206.9 312 176 312zM176 408c-22.06 0-40-17.94-40-40s17.94-40 40-40s40 17.94 40 40S198.1 408 176 408zM316.8 32.67C313.7 32.22 310.6 32 307.5 32c-14.17 0-27.97 4.684-39.32 13.51L226.3 78.45C220.7 82.77 219.2 90.08 221.5 96.71C224 104.2 224.8 112.6 223.1 121.4c-3.723 19.11-19.53 34.66-38.72 37.93C181.5 159.8 178.7 160 176 160C166.4 160 157.5 157.1 149.1 152.3c-2.758-1.799-5.893-2.721-9.002-2.721c-3.344 0-6.658 1.064-9.443 3.252L12.3 246.3C4.566 252.4 0 261.7 0 271.5V432C0 458.5 21.49 480 48 480h416c26.51 0 48-21.49 48-48V255.1C512 82.26 377.3 41.43 316.8 32.67zM496 432c0 17.64-14.36 32-32 32h-416c-17.64 0-32-14.36-32-32v-160h296c0 30.88 25.12 56 56 56s56-25.12 56-56h72V432zM328 272c0-22.06 17.94-40 40-40s40 17.94 40 40s-17.94 40-40 40S328 294.1 328 272zM421.4 256C414.5 232.1 393.3 216 368 216S321.5 232.1 314.6 256H25.93l115.3-90.34C151.6 172.4 163.6 176 176 176c3.619 0 7.312-.3047 11.06-.9434c25.9-4.412 46.69-24.76 51.73-50.64c2.148-11.04 1.387-22.41-2.66-33.38l41.92-32.89c8.529-6.635 18.73-10.14 29.5-10.14c2.314 0 4.645 .168 6.969 .5039C369.1 56.4 496 92.44 496 256H421.4z"],
    "cherries": [640, 512, [], "e0ec", "M535.9 224.2c-21.83 0-48.63 4.836-81.2 17.76c-33.48-147.3-159.4-241.1-166.8-241.1c-15.72 0-28.1 168.1-101.5 242.4C153.4 229.1 126.2 224.2 104.2 224.2C86.96 224.2 0 229.2 0 331.9c0 26.4 25.2 180.1 191.1 180.1c167.5 0 192-153.1 192-180.1c0-109.6-99.52-107.7-104.1-107.7c-18.92 0-41.56 3.623-68.45 12.98C231.9 209.7 269.9 145.2 293.5 22.36c29.67 24.06 115.8 102.8 144.1 218.3c-17.12-6.562-19.29-7.372-21.52-7.372c-3.445 0-6.648 2.186-7.725 5.635c-.2352 .7773-.3472 1.562-.3472 2.334c0 8.863 6.452 6.107 36.81 19.26l3.187 1.375l3.187-1.375c31.58-13.69 60.01-20.56 84.43-20.56c86.87 0 88.39 81.12 88.39 92c0 23.52-22.41 164.1-176 164.1c-38.55 0-60.5-10.08-64.04-10.08c-4.335 0-7.966 3.582-7.966 8.006c0 3.351 2.129 6.481 5.478 7.593c20.72 6.953 43.07 10.48 66.47 10.48C615.4 511.1 640 358.9 640 331.9C640 315.3 634.3 224.2 535.9 224.2zM279.6 239.9c86.87 0 88.39 81.12 88.39 92c0 23.52-22.41 164.1-176 164.1c-153.3 0-176-139.1-176-164.1c0-94.5 83.96-92 88.38-92c24.44 0 52.84 6.859 84.43 20.55l3.187 1.375l3.187-1.375C226.8 246.8 255.2 239.9 279.6 239.9z"],
    "chess": [512, 512, [], "f439", "M242.7 452.4L224 443.1V432c0-13.23-10.78-24-24-24h-144C42.78 408 32 418.8 32 432v11.06l-18.56 9.344C5.281 456.3 0 464.7 0 473.9V488C0 501.2 10.78 512 24 512h208C245.2 512 256 501.2 256 488v-14.12C256 464.8 250.8 456.3 242.7 452.4zM240 488c0 4.484-3.5 8-8 8h-208c-4.5 0-8-3.516-8-8v-14.12c0-3.016 1.688-5.781 4.469-7.109L48 452.9V432c0-4.484 3.5-8 8-8h144c4.5 0 8 3.516 8 8v20.94l27.53 13.83C238.2 468 240 470.9 240 473.9V488zM498.7 452.4L480 443.1V432c0-13.23-10.78-24-24-24h-112c-13.22 0-24 10.77-24 24v11.06l-18.56 9.344C293.3 456.3 288 464.7 288 473.9V488c0 13.23 10.78 24 24 24h176c13.22 0 24-10.77 24-24v-14.12C512 464.8 506.8 456.3 498.7 452.4zM496 488c0 4.484-3.5 8-8 8h-176c-4.5 0-8-3.516-8-8v-14.12c0-3.016 1.688-5.781 4.469-7.109L336 452.9V432c0-4.484 3.5-8 8-8h112c4.5 0 8 3.516 8 8v20.94l27.53 13.83C494.2 468 496 470.9 496 473.9V488zM75.7 224H64C59.59 224 56 227.6 56 232S59.59 240 64 240h11.75c0 0-11.74 135.8-11.74 136c0 1.407 1.1 8.014 8.142 8.014c3.911 0 7.504-3.229 7.825-7.33L91.79 240h72.41l11.82 136.7C176.4 380.9 179.9 384 184 384c5.749 0 7.998-5.08 7.998-7.996c0-.2287-.0097-.4593-.0294-.6913L180.3 240H192c4.406 0 8-3.578 8-8S196.4 224 192 224H180.3l38.17-96.7c.9966-2.596 1.486-5.322 1.486-8.05C219.1 107.1 210.3 96 196.8 96H136V48h32c4.406 0 8-3.578 8-8S172.4 32 168 32h-32V8C136 3.578 132.4 0 128 0S120 3.578 120 8V32h-32C83.59 32 80 35.58 80 40S83.59 48 88 48h32V96H59.16C46.39 96 36.01 106.3 36.01 119c0 2.8 .5126 5.622 1.556 8.327L75.7 224zM51.97 119C51.97 117.3 53.36 112 59.16 112h137.7c5.52 0 7.14 5.056 7.14 7.28c0 .7691-.1285 1.519-.3896 2.204L163.1 224H92.89L52.47 121.5C52.11 120.6 51.97 119.8 51.97 119zM336 299.3V376c0 4.422 3.594 8 8 8S352 380.4 352 376v-80c0-2.125-.8438-4.156-2.344-5.656L320 260.7V208h24v24c0 4.422 3.594 8 8 8h32c4.406 0 8-3.578 8-8V208h16v24c0 4.422 3.594 8 8 8h32c4.406 0 8-3.578 8-8V208H480v52.69l-29.66 29.66C448.8 291.8 448 293.9 448 296v80c0 4.422 3.594 8 8 8s8-3.578 8-8V299.3l29.66-29.66C495.2 268.2 496 266.1 496 264v-64C496 195.6 492.4 192 488 192H448c-4.406 0-8 3.578-8 8V224h-16V200C424 195.6 420.4 192 416 192h-32c-4.406 0-8 3.578-8 8V224h-16V200C360 195.6 356.4 192 352 192h-40c-4.406 0-8 3.578-8 8v64c0 2.125 .8438 4.156 2.344 5.656L336 299.3zM376 312v32c0 4.422 3.594 8 8 8h32c4.406 0 8-3.578 8-8v-32C424 298.8 413.2 288 400 288S376 298.8 376 312zM408 312v24h-16V312c0-4.406 3.594-8 8-8S408 307.6 408 312z"],
    "chess-bishop": [320, 512, [9821], "f43a", "M264 448h-208C25.13 448 0 473.1 0 504C0 508.4 3.594 512 8 512s8-3.578 8-8c0-22.06 17.94-40 40-40h208c22.06 0 40 17.94 40 40c0 4.422 3.594 8 8 8S320 508.4 320 504C320 473.1 294.9 448 264 448zM56 386.2V408C56 412.4 59.59 416 64 416s8-3.578 8-8v-27.5c0-15.07-56-5.087-56-84.63c0-115.4 112.6-221.8 112.6-225.4c0-3.222-2.089-6.786-6.116-7.771C111.6 60.09 104 50.75 104 40C104 26.77 114.8 16 128 16h64c13.22 0 24 10.77 24 24c0 10.75-7.594 20.09-18.5 22.72c-4.04 .9884-6.116 4.554-6.116 7.771c0 8.85 32.63 22.61 74.32 100.5l-103.3 103.4c-1.568 1.568-2.354 3.618-2.354 5.666C160 282.9 162.3 288 168 288c2.062 0 4.156-.8021 5.719-2.365l99.51-99.55C291.4 223.6 304 263.1 304 295.9c0 79.52-56 69.41-56 84.63V408c0 4.422 3.594 8 8 8s8-3.578 8-8v-21.78C302.2 372.1 320 343.2 320 295.9c0-72.75-54.16-173.5-106-223C225 65.69 232 53.52 232 40C232 17.94 214.1 0 192 0H128C105.9 0 88 17.94 88 40c0 13.52 7 25.69 18.03 32.84C54.16 122.4 0 223.1 0 295.9C0 343.2 17.84 372.1 56 386.2z"],
    "chess-bishop-piece": [256, 512, ["chess-bishop-alt"], "f43b", "M48 240h28.96l-12.93 135.2c-.0232 .2517-.0346 .5018-.0346 .7498C63.1 378.9 66.25 384 72 384c4.094 0 7.562-3.094 7.969-7.234l13-136c.0014-.0143 0 .0139 0 0c0-.2645-.2336-.4754-.2373-.7444h70.54c-.0037 .269-.2373 .48-.2373 .7444c0 .0139-.0014-.0143 0 0l13 136C176.4 380.9 179.9 384 184 384c5.746 0 8.003-5.09 8.003-8.016c0-.2479-.0114-.498-.0346-.7498L179 240H208c4.406 0 8-3.578 8-8S212.4 224 208 224h-15.08c9.045-11.74 14.55-27.81 14.55-47.3c0-37.91-23.21-98.4-51.09-128.7H160c4.406 0 8-3.578 8-8S164.4 32 160 32H96C91.59 32 88 35.58 88 40S91.59 48 96 48h3.617C71.74 78.3 48.53 138.8 48.53 176.7c0 19.49 5.502 35.56 14.55 47.3H48C43.59 224 40 227.6 40 232S43.59 240 48 240zM128 48c20.92 0 48.44 65.52 49.22 67.46l-46.88 46.88C128.8 163.9 128 165.1 128 168c0 2.906 2.281 8 8 8c2.062 0 4.094-.7813 5.656-2.344l41.56-41.56c4.998 15.7 8.25 31.27 8.25 44.61c0 23.05-8.125 40.56-21.81 47.3H86.34C72.66 217.3 64.53 199.8 64.53 176.7C64.53 130.9 105.6 48 128 48zM242.7 452.4L224 443.1V432c0-13.23-10.78-24-24-24h-144C42.78 408 32 418.8 32 432v11.06l-18.56 9.344C5.281 456.3 0 464.7 0 473.9V488C0 501.2 10.78 512 24 512h208c13.22 0 24-10.77 24-24v-14.12C256 464.8 250.8 456.3 242.7 452.4zM240 488c0 4.484-3.5 8-8 8h-208c-4.5 0-8-3.516-8-8v-14.12c0-3.016 1.688-5.781 4.469-7.109L48 452.9V432c0-4.484 3.5-8 8-8h144c4.5 0 8 3.516 8 8v20.94l27.53 13.83C238.2 468 240 470.9 240 473.9V488z"],
    "chess-board": [448, 512, [], "f43c", "M400 32h-352C21.49 32 0 53.49 0 80v352C0 458.5 21.49 480 48 480h352c26.51 0 48-21.49 48-48v-352C448 53.49 426.5 32 400 32zM432 432c0 17.64-14.36 32-32 32h-352c-17.64 0-32-14.36-32-32v-352c0-17.64 14.36-32 32-32h352c17.64 0 32 14.36 32 32V432zM376 88h-304c-8.812 0-16 7.172-16 16v304c0 8.828 7.188 16 16 16h304c8.812 0 16-7.172 16-16v-304C392 95.17 384.8 88 376 88zM120 408h-48v-48h48V408zM120 344h-48v-48h48V344zM120 280h-48v-48h48V280zM120 216h-48v-48h48V216zM120 152h-48v-48h48V152zM184 408h-48v-48h48V408zM184 344h-48v-48h48V344zM184 280h-48v-48h48V280zM184 216h-48v-48h48V216zM184 152h-48v-48h48V152zM248 408h-48v-48h48V408zM248 344h-48v-48h48V344zM248 280h-48v-48h48V280zM248 216h-48v-48h48V216zM248 152h-48v-48h48V152zM312 408h-48v-48h48V408zM312 344h-48v-48h48V344zM312 280h-48v-48h48V280zM312 216h-48v-48h48V216zM312 152h-48v-48h48V152zM376 407.1C376 408 376 407.1 376 407.1L328 408v-48h48V407.1zM376 344h-48v-48h48V344zM376 280h-48v-48h48V280zM376 216h-48v-48h48V216zM376 152h-48v-48h48V152z"],
    "chess-clock": [640, 512, [], "f43d", "M176 192C114.1 192 64 242.1 64 304S114.1 416 176 416S288 365.9 288 304S237.9 192 176 192zM176 400c-52.93 0-96-43.07-96-96c0-52.94 43.07-96 96-96s96 43.06 96 96C272 356.9 228.9 400 176 400zM464 192C402.1 192 352 242.1 352 304s50.14 112 112 112S576 365.9 576 304S525.9 192 464 192zM464 400c-52.93 0-96-43.07-96-96c0-52.94 43.07-96 96-96s96 43.06 96 96C560 356.9 516.9 400 464 400zM576 128H184V48h64C252.4 48 256 44.42 256 40S252.4 32 248 32h-144C99.59 32 96 35.58 96 40S99.59 48 104 48h64V128H64C28.65 128 0 156.7 0 192v224c0 35.35 28.65 64 64 64h512c35.35 0 64-28.65 64-64V192C640 156.7 611.3 128 576 128zM624 416c0 26.47-21.53 48-48 48H64c-26.47 0-48-21.53-48-48V192c0-26.47 21.53-48 48-48h512c26.47 0 48 21.53 48 48V416zM392 96h144C540.4 96 544 92.42 544 88S540.4 80 536 80h-144C387.6 80 384 83.58 384 88S387.6 96 392 96zM176 232c-4.406 0-8 3.578-8 8v64c0 4.422 3.594 8 8 8S184 308.4 184 304v-64C184 235.6 180.4 232 176 232zM509.3 250.8c-2.047 0-4.094 .7813-5.656 2.344l-45.25 45.25C456.8 299.9 456 301.1 456 304c0 2.906 2.281 8 8 8c2.062 0 4.094-.7813 5.656-2.344l45.25-45.25c1.562-1.562 2.344-3.609 2.344-5.656C517.3 254.5 513.8 250.8 509.3 250.8z"],
    "chess-clock-flip": [640, 512, ["chess-clock-alt"], "f43e", "M351.9 304c0 61.86 50.14 111.1 112 111.1s112-50.08 112-111.9S525.8 192 463.9 192S351.9 242.2 351.9 304zM368 304c0-52.94 43.07-96 96-96s96 43.06 96 96c0 52.93-43.07 96-96 96S368 356.9 368 304zM176 192C114.1 192 63.94 242.1 63.94 304s50.14 112 112 112s112-50.12 112-111.1S237.9 192 176 192zM176 400c-52.93 0-96-43.07-96-96c0-52.94 43.07-96 96-96s96 43.06 96 96C272 356.9 228.9 400 176 400zM0 192l0 224c0 35.35 28.65 64 64 64h512c35.35 0 64-28.65 64-64V192c0-35.35-28.65-64-64-64h-104V48h64C540.4 48 544 44.42 544 40S540.4 32 536 32h-144C387.6 32 384 35.58 384 40s3.594 8 8 8h64V128H64C28.65 128 0 156.7 0 192zM16 192c0-26.47 21.53-48 48-48h512c26.47 0 48 21.53 48 48v224c0 26.47-21.53 48-48 48H64c-26.47 0-48-21.53-48-48V192zM256 88C256 83.58 252.4 80 248 80h-144C99.59 80 96 83.58 96 88S99.59 96 104 96h144C252.4 96 256 92.42 256 88zM456 240v64c0 4.422 3.594 8 8 8s8-3.578 8-8v-64c0-4.422-3.594-8-8-8S456 235.6 456 240zM221.3 250.8c-2.047 0-4.094 .7813-5.656 2.344L170.3 298.3C168.8 299.9 168 301.1 168 304c0 2.906 2.281 8 8 8c2.062 0 4.094-.7813 5.656-2.344l45.25-45.25c1.562-1.562 2.344-3.609 2.344-5.656C229.3 254.5 225.8 250.8 221.3 250.8z"],
    "chess-king": [448, 512, [9818], "f43f", "M448 200C448 174.3 426.5 160 408.1 160h-176.1V72h56.01c4.407 0 8.001-3.578 8.001-8s-3.594-8-8.001-8h-56.01v-48c0-4.422-3.591-8-7.998-8C219.6 0 215.1 3.578 215.1 8v48H159.1C155.6 56 151.1 59.58 151.1 64s3.594 8 8.001 8h56.01V160H39.89C21.72 160 0 174.3 0 199.1c0 4.105 .619 8.254 1.884 12.31l73.04 198.5c1.175 3.243 4.266 5.22 7.534 5.22c4.5 0 7.966-3.672 7.966-7.98c0-.9202-.1599-1.856-.4971-2.772l-72.92-198.1c-.7195-2.313-1.072-4.704-1.072-7.088C15.94 184.8 28.61 176 39.89 176h368.2c11.03 0 23.99 8.668 23.99 24.11c0 2.26-.3254 4.498-.9857 6.624l-73.04 198.5c-.3372 .9151-.4971 1.851-.4971 2.772c0 4.364 3.533 7.994 7.998 7.994c3.251 0 6.314-1.1 7.501-5.234l73.17-198.9C447.4 208 448 204 448 200zM360 448H87.96c-30.88 0-56.01 25.12-56.01 56c0 4.422 3.594 8 8.001 8c4.407 0 8.001-3.578 8.001-8c0-22.06 17.94-40 40.01-40h272c22.07 0 40.01 17.94 40.01 40c0 4.422 3.594 8 8.001 8c4.407 0 8.001-3.578 8.001-8C416 473.1 390.9 448 360 448z"],
    "chess-king-piece": [256, 512, ["chess-king-alt"], "f440", "M75.7 224H64C59.59 224 56 227.6 56 232S59.59 240 64 240h11.75c0 0-11.74 135.8-11.74 136c0 1.407 1.1 8.014 8.142 8.014c3.911 0 7.504-3.229 7.825-7.33L91.79 240h72.41l11.82 136.7C176.4 380.9 179.9 384 184 384c5.749 0 7.998-5.08 7.998-7.996c0-.2287-.0097-.4593-.0294-.6913L180.3 240H192c4.406 0 8-3.578 8-8S196.4 224 192 224h-11.7l38.17-96.7c.9966-2.596 1.486-5.322 1.486-8.05C219.1 107.1 210.3 96 196.8 96H136V48h32c4.406 0 8-3.578 8-8S172.4 32 168 32h-32V8c0-4.422-3.587-8-7.994-8S120 3.578 120 8V32h-32C83.59 32 80 35.58 80 40S83.59 48 88 48h32V96H59.16C46.39 96 36.01 106.3 36.01 119c0 2.8 .5125 5.622 1.556 8.327L75.7 224zM51.97 119C51.97 117.3 53.36 112 59.16 112h137.7c5.52 0 7.14 5.056 7.14 7.28c0 .7691-.1285 1.519-.3896 2.204L163.1 224H92.89L52.47 121.5C52.11 120.6 51.97 119.8 51.97 119zM242.7 452.4L224 443.1V432c0-13.23-10.78-24-24-24h-144C42.78 408 32 418.8 32 432v11.06l-18.56 9.344C5.281 456.3 0 464.7 0 473.9V488C0 501.2 10.78 512 24 512h208c13.22 0 24-10.77 24-24v-14.12C256 464.8 250.8 456.3 242.7 452.4zM240 488c0 4.484-3.5 8-8 8h-208c-4.5 0-8-3.516-8-8v-14.12c0-3.016 1.688-5.781 4.469-7.109L48 452.9V432c0-4.484 3.5-8 8-8h144c4.5 0 8 3.516 8 8v20.94l27.53 13.83C238.2 468 240 470.9 240 473.9V488z"],
    "chess-knight": [384, 512, [9822], "f441", "M23.89 274.5l40.61 18c5.189 2.307 10.78 3.471 16.35 3.471c5.034 0 10.05-.9489 14.75-2.862l12.73-5.109c11.47-4.578 20.02-13.94 23.44-25.62l9.344-30.97c1.188-4.641 4.172-8.344 8.469-10.45l10.53-5.281v50.67c0 14.95-8.719 28.97-22.2 35.72l-57.14 28.62C50.31 346 32.13 374.9 32.13 408c0 4.422 3.578 8 8 8s8-3.578 8-8c0-26.91 14.89-50.44 39.83-62.97l57.13-28.62c18.86-9.438 31.05-29.06 31.05-50.03V202.7c0-2.932-2.283-8.004-8.013-8.004c-1.227 0-2.453 .2847-3.581 .863L142.5 206.7c-8.391 4.109-14.53 11.7-16.77 20.5L116.5 257.8C114.4 264.8 109.3 270.4 102.4 273.2L89.63 278.3c-2.795 1.134-5.79 1.702-8.804 1.702c-3.338 0-6.7-.6969-9.837-2.093l-40.61-18C21.72 256 16.13 247.4 16.13 237.1V114c0-4.25 1.703-8.391 4.656-11.34l9-9C31.32 92.12 32.13 90.06 32.13 87.98c0-1.217-.2772-2.442-.8481-3.578L17.11 56.2C16.47 54.84 16.13 53.39 16.13 52c0-2.203 1.797-4 4-4h140C258.8 48 336 128.8 336 232v176c0 4.422 3.578 8 8 8S352 412.4 352 408v-176C352 119.8 267.6 32 160 32H20.13c-11.03 0-20 8.969-20 20c0 3.75 .875 7.562 2.594 11.22L14.39 86.42L9.469 91.34C3.438 97.38 .125 105.4 .125 114v123.1C.125 253.8 9.438 268.1 23.89 274.5zM64 144C64 152.8 71.2 160 80 160S96 152.8 96 144C96 135.2 88.8 128 80 128S64 135.2 64 144zM328 448h-272C25.13 448 0 473.1 0 504C0 508.4 3.578 512 8 512s8-3.578 8-8c0-22.06 17.94-40 40-40h272c22.06 0 40 17.94 40 40c0 4.422 3.578 8 8 8S384 508.4 384 504C384 473.1 358.9 448 328 448z"],
    "chess-knight-piece": [320, 512, ["chess-knight-alt"], "f442", "M306.6 452.4L288 443.1V432c0-13.23-10.77-24-24-24h-208C42.77 408 32 418.8 32 432v11.06l-18.58 9.344C5.266 456.3 0 464.7 0 473.9V488C0 501.2 10.77 512 24 512h272c13.23 0 24-10.77 24-24v-14.12C320 464.8 314.8 456.3 306.6 452.4zM304 488c0 4.484-3.516 8-8 8h-272c-4.484 0-8-3.516-8-8v-14.12c0-3.016 1.703-5.781 4.469-7.109L48 452.9V432c0-4.484 3.516-8 8-8h208c4.484 0 8 3.516 8 8v20.94l27.67 13.91C302.3 468.1 304 470.9 304 473.9V488zM50.25 234.8l28.88 12.88C83.09 249.5 87.37 250.3 91.65 250.3c3.851 0 7.698-.7171 11.3-2.153l9.172-3.641c8.734-3.531 15.31-10.73 18.05-19.77L136.8 202.6c.6875-2.672 2.438-4.906 3.594-5.625l3.781-1.234v34.25c0 15.09-7.457 15.92-67.13 49.87c-42.11 21.44-40.27 53.73-40.27 55.61C36.73 362.2 58.29 384 64 384c4.57 0 8-3.737 8-8c0-7.853-19.28-16.93-19.28-40.34c0-1.505-1.648-24.62 31.86-41.7c59.95-33.96 75.55-38.03 75.55-63.95V184.8c0-4.502-3.679-8.005-7.986-8.005c-.8298 0-1.666 .1302-2.482 .3953L134.2 182.3c-6.422 3.297-11.14 9.266-12.89 16.08L114.8 220.2C113.5 224.5 110.4 228 106.2 229.7L97.03 233.3C95.34 234 93.51 234.4 91.67 234.4c-2.048 0-4.113-.4263-6.03-1.29l-28.92-12.89C51.42 217.8 48 212.5 48 206.6V124.8C48 122.3 48.94 120 50.66 118.3l6.375-6.375c1.538-1.538 2.348-3.586 2.348-5.661c0-1.214-.2772-2.437-.8481-3.573L48.41 82.42L48.5 80h92.38C213.2 80 272 138.8 272 211.1V344c0 17.11-16.01 24.15-16.01 31.1C255.1 380.5 259.6 384 264 384c2.203 0 4.406-.9062 5.984-2.688C277.2 373.2 288 361 288 344V211.1C288 130 221.1 64 140.9 64H48.5C39.41 64 32 71.41 32 80.5c0 3.297 .6875 6.266 2.094 9.078l7.547 15.09L39.34 106.1C34.61 111.7 32 118 32 124.8v81.88C32 218.9 39.17 229.9 50.25 234.8zM80 144C80 152.8 87.16 160 96 160c8.838 0 16-7.164 16-16C112 135.2 104.8 128 96 128C87.16 128 80 135.2 80 144z"],
    "chess-pawn": [320, 512, [9823], "f443", "M264 448h-208C25.13 448 0 473.1 0 504C0 508.4 3.578 512 8 512s8-3.578 8-8c0-22.06 17.94-40 40-40h208c22.06 0 40 17.94 40 40c0 4.422 3.578 8 8 8S320 508.4 320 504C320 473.1 294.9 448 264 448zM56 232C56 236.4 59.58 240 64 240h37.98l-37.78 166.2c-.1367 .5969-.2023 1.194-.2023 1.782C64 412 67.21 416 72 416c3.656 0 6.953-2.516 7.797-6.234L118.4 240h83.24l38.58 169.8C241 413.5 244.3 416 248 416c4.759 0 7.999-3.937 7.999-7.984c0-.588-.0656-1.185-.2023-1.782L218 240H256c4.422 0 8-3.578 8-8S260.4 224 256 224h-41.12C244.3 205.6 264 173.2 264 136C264 78.56 217.4 32 159.1 32S56 78.56 56 136c0 37.22 19.73 69.62 49.12 88H64C59.58 224 56 227.6 56 232zM72 136C72 87.48 111.5 48 160 48s88 39.48 88 88S208.5 223.1 160 223.1S72 184.5 72 136z"],
    "chess-pawn-piece": [256, 512, ["chess-pawn-alt"], "f444", "M242.6 452.4L224 443.1V432c0-13.23-10.77-24-24-24h-144C42.77 408 32 418.8 32 432v11.06l-18.58 9.344C5.266 456.3 0 464.7 0 473.9V488C0 501.2 10.77 512 24 512h208c13.23 0 24-10.77 24-24v-14.11C256 464.8 250.8 456.3 242.6 452.4zM240 488c0 4.484-3.516 8-8 8h-208c-4.484 0-8-3.516-8-8v-14.12c0-3.016 1.703-5.781 4.469-7.109L48 452.9V432c0-4.484 3.516-8 8-8h144c4.484 0 8 3.516 8 8v20.94l27.67 13.91C238.3 468.1 240 470.9 240 473.9V488zM80.48 240.1H64c-4.422 0-8 3.496-8 7.918S59.58 256 64 256h14.94l-14.88 119c-.042 .3368-.0624 .6713-.0624 1.002C64 377.4 65.13 384 72.02 384c3.969 0 7.422-2.953 7.922-7L95.06 256h65.88l15.12 121C176.6 381 180 384 183.1 384c6.887 0 8.016-6.604 8.016-7.998c0-.3308-.0204-.6653-.0624-1.002L177.1 256H192c4.422 0 8-3.578 8-8S196.4 240.1 192 240.1h-16.48c19.58-14.58 32.48-37.82 32.48-64.11C208 131.8 172.2 96 127.1 96C83.79 96 47.1 131.8 47.1 175.1C47.1 202.3 60.9 225.5 80.48 240.1zM128 112c35.29 0 64 28.71 64 64c0 35.29-28.71 64-64 64c-35.29 0-64-28.71-64-64C64 140.7 92.71 112 128 112z"],
    "chess-queen": [512, 512, [9819], "f445", "M392.1 448H120.1c-30.87 0-55.1 25.12-55.1 56c0 4.422 3.578 8 7.1 8s7.1-3.578 7.1-8c0-22.06 17.94-40 39.1-40h271.1c22.06 0 39.1 17.94 39.1 40c0 4.422 3.578 8 7.1 8c4.422 0 7.1-3.578 7.1-8C448.1 473.1 422.9 448 392.1 448zM256 112c30.87 0 56-25.12 56-56S286.9 0 256 0S199.1 25.12 199.1 56S225.1 112 256 112zM256 16c22.06 0 39.1 17.94 39.1 40S278.1 96 256 96S216 78.06 216 56S233.1 16 256 16zM512 203.4c0-7.707-3.837-15.27-10.95-19.98l-27.06-15.05c-3.895-2.594-8.274-3.847-12.65-3.847c-21.84 0-20.65 25.53-50.28 25.53c-33.05 0-38.5-33.72-38.5-41.08C372.6 137.4 363.1 128 351.6 128h-37.55c-9.797 0-18.33 6.688-20.31 15.89c-3.828 18.03-19.34 30.61-37.7 30.61S222.2 161.9 218.3 143.9C216.4 134.7 207.8 128 198 128H160.5C148.9 128 139.5 137.4 139.5 148.1c0 21.98-16.53 41.04-38.37 41.04c-12.13 0-23.43-5.618-30.76-15.37C65.48 167.9 57.99 164.3 50.7 164.3c-4.229 0-8.394 1.201-11.96 3.685L10.56 183.8C3.763 188.2 0 195.6 0 203.2c0 3.579 .828 7.207 2.559 10.6l99.31 197.8c1.395 2.801 4.234 4.402 7.171 4.402c4.683 0 7.985-3.837 7.985-8.014c0-1.204-.2712-2.426-.8437-3.576L16.84 206.6C16.29 205.5 16.04 204.3 16.04 203.2c0-2.335 1.051-4.565 2.789-5.707l28.36-15.89c1.177-.8166 2.427-1.171 3.659-1.171c9.39 0 15.51 25.55 50.69 25.55c29.65 0 53.99-25.67 53.99-57.02C155.5 146.2 157.8 144 160.5 144h37.53c2.266 0 4.266 1.391 4.656 3.234C208.1 172.7 230.1 190.5 256 190.5s47.92-17.8 53.36-43.27C309.8 145.4 311.8 144 314.1 144h37.55c2.734 0 4.953 2.219 4.953 4.953c0 10.19 8.203 57.03 54.29 57.03c34.49 0 40.89-25.41 50.36-25.41c1.418 0 2.927 .4191 4.458 1.41l27.06 15.05c2.144 1.426 3.317 3.736 3.317 6.15c0 1.158-.27 2.34-.8323 3.459l-99.3 197.8c-.5724 1.149-.8437 2.372-.8437 3.576C395.1 412.2 398.4 416 403.1 416c2.922 0 5.75-1.609 7.156-4.406l99.3-197.8C511.2 210.5 512 206.9 512 203.4z"],
    "chess-queen-piece": [256, 512, ["chess-queen-alt"], "f446", "M242.6 452.4L224 443.1V432c0-13.23-10.77-24-24-24h-144C42.77 408 32 418.8 32 432v11.06l-18.58 9.344C5.266 456.3 0 464.7 0 473.9V488C0 501.2 10.77 512 24 512h208c13.23 0 24-10.77 24-24v-14.12C256 464.8 250.8 456.3 242.6 452.4zM240 488c0 4.484-3.516 8-8 8h-208c-4.484 0-8-3.516-8-8v-14.12c0-3.016 1.703-5.781 4.469-7.109L48 452.9V432c0-4.484 3.516-8 8-8h144c4.484 0 8 3.516 8 8v20.94l27.67 13.91C238.3 468.1 240 470.9 240 473.9V488zM73.27 192H64C59.58 192 56 195.6 56 200S59.58 208 64 208h12.38c0 0-12.39 167.8-12.39 167.1C63.1 378.9 66.24 384 72.02 384c4.141 0 7.656-3.203 7.969-7.406L92.44 208h71.13l12.45 168.6C176.3 380.8 179.8 384 183.1 384c5.765 0 8.021-5.079 8.021-8.016c0-.1913-.0068-.3839-.0205-.5776L179.6 208H192c4.422 0 8-3.578 8-8S196.4 192 192 192h-9.266l50.39-79.75c.4723-.9446 .6967-1.964 .6967-2.975c0-2.201-1.063-4.365-2.947-5.65L220.8 97c-1.104-.752-2.318-1.096-3.523-1.096c-7.225 0-7.411 11.1-21.87 11.1c-12.28 0-20.23-10.59-20.23-21.38C175.1 82.5 172.6 80 169.5 80h-16.25c-2.625 0-4.875 1.625-5.5 4.125C145.8 93.5 137.5 100.3 128 100.3S110.3 93.5 108.3 84.13C107.6 81.63 105.4 80 102.8 80H86.5c-3.125 0-5.625 2.5-5.625 5.625c0 7.834-5.757 21.3-20.33 21.3c-6.234 0-12.21-2.949-16.04-8.053C43.23 96.88 41.09 95.86 38.9 95.86c-1.252 0-2.518 .3359-3.654 1.018L25.13 103.6C23.24 104.9 22.18 107.1 22.18 109.3c0 1.011 .2245 2.03 .6968 2.975L73.27 192zM60.54 122.9l2.01-.0527L63.1 122.8C78.56 121.8 91.29 110.7 95.44 96C101.5 108.1 114.1 116.3 128 116.3c14.01 0 26.61-8.27 32.5-20.25c1.372 4.943 9.768 27.01 34.86 27.01c4.775 0 9.465-.9707 13.8-2.779L163.8 192H92.18L46.71 120.1C51.05 121.1 55.75 122.9 60.54 122.9zM128 64c17.64 0 32-14.36 32-32s-14.31-32-31.95-32S96 14.36 96 32S110.4 64 128 64zM128 16c8.828 0 16 7.172 16 16S136.8 48 128 48S112 40.83 112 32S119.2 16 128 16z"],
    "chess-rook": [384, 512, [9820], "f447", "M328 448h-272C25.13 448 0 473.1 0 504C0 508.4 3.578 512 8 512s8-3.578 8-8c0-22.06 17.94-40 40-40h272c22.06 0 40 17.94 40 40c0 4.422 3.578 8 8 8S384 508.4 384 504C384 473.1 358.9 448 328 448zM216 328c8.836 0 16-7.164 16-16V256c0-22.06-17.94-40-40-40S152 233.9 152 256v56c0 8.836 7.164 16 16 16H216zM168 256c0-13.23 10.77-24 24-24S216 242.8 216 256v56h-48V256zM368 32h-64C295.2 32 288 39.17 288 48v32C288 88.83 280.8 96 272 96S256 88.83 256 80v-32C256 39.17 248.8 32 240 32h-96C135.2 32 128 39.17 128 48v32C128 88.83 120.8 96 112 96S96 88.83 96 80v-32C96 39.17 88.83 32 80 32h-64C7.172 32 0 39.17 0 48v155.2c0 15.78 9.328 30.14 23.75 36.56l47.69 21.19l-15.39 146.2c-.0307 .2888-.0457 .5756-.0457 .8595c0 1.391 1.104 7.986 8.058 7.986c4.122 0 7.442-3.062 7.894-7.158l16.61-157.8L30.25 225.1C21.59 221.3 16 212.7 16 203.2V48h64v32c0 17.64 14.36 32 32 32s32-14.36 32-32v-32h96v32c0 17.64 14.36 32 32 32s32-14.36 32-32v-32h64v155.2c0 9.469-5.594 18.09-14.25 21.94l-58.31 25.91l16.61 157.8C312.5 412.1 315.1 416 319.1 416c6.904 0 8.014-6.605 8.014-7.984c0-.2839-.015-.5707-.0457-.8595l-15.39-146.2l47.69-21.19C374.7 233.3 384 218.1 384 203.2V48C384 39.17 376.8 32 368 32z"],
    "chess-rook-piece": [320, 512, ["chess-rook-alt"], "f448", "M306.6 452.4L288 443.1V432c0-13.23-10.77-24-24-24h-208C42.77 408 32 418.8 32 432v11.06l-18.58 9.344C5.266 456.3 0 464.7 0 473.9V488C0 501.2 10.77 512 24 512h272c13.23 0 24-10.77 24-24v-14.12C320 464.8 314.8 456.3 306.6 452.4zM304 488c0 4.484-3.516 8-8 8h-272c-4.484 0-8-3.516-8-8v-14.12c0-3.016 1.703-5.781 4.469-7.109L48 452.9V432c0-4.484 3.516-8 8-8h208c4.484 0 8 3.516 8 8v20.94l27.67 13.91C302.3 468.1 304 470.9 304 473.9V488zM71.86 210.7c0 0-7.854 165.2-7.854 165.3c0 1.447 1.081 7.992 8.316 7.992c4.06 0 7.471-3.444 7.663-7.643c0 0 8.012-168.3 8.012-168.4c0-1.851-.6644-3.64-1.855-5.078L53.56 163.8C49.97 159.5 48 154 48 148.4V80h32v20C80 115.5 92.54 128 107.1 128S136 115.5 136 100V80h48v20C184 115.5 196.5 128 211.1 128S240 115.5 240 100V80h32v68.42c0 5.614-1.968 11.05-5.562 15.36l-32.58 39.09C232.7 204.3 232 206.1 232 207.1c0 .1405 .0038 .2814 .0115 .4225l8 168C240.2 380.7 243.8 384 248 384c4.408 0 7.994-3.576 7.994-7.974c0-.1331-.0033-.2669-.01-.4014l-7.844-164.9l30.6-36.73C284.7 166.8 288 157.8 288 148.4V72C288 67.58 284.4 64 280 64h-48C227.6 64 224 67.58 224 72v28C224 106.6 218.6 112 212 112S200 106.6 200 100V72C200 67.58 196.4 64 192 64H128C123.6 64 120 67.58 120 72v28C120 106.6 114.6 112 108 112S96 106.6 96 100V72C96 67.58 92.42 64 88 64h-48C35.58 64 32 67.58 32 72v76.42C32 157.8 35.28 166.8 41.26 174L71.86 210.7zM160 192C142.4 192 128 206.4 128 224v56C128 284.4 131.6 288 136 288h48C188.4 288 192 284.4 192 280V224C192 206.4 177.6 192 160 192zM176 272h-32V224c0-8.828 7.172-16 16-16s16 7.172 16 16V272z"],
    "chestnut": [448, 512, [127792], "e3f6", "M302.9 99.43c-25.37-20.56-49.36-39.98-66.48-61.41C233.2 34.01 228.6 32 224 32S214.8 34.01 211.5 38.02C194.4 59.45 170.4 78.87 145.1 99.43C80.44 151.7 0 216.8 0 352C0 422.7 57.31 480 128 480h192c70.69 0 128-57.3 128-127.1C448 216.8 367.6 151.7 302.9 99.43zM155.4 111.6c25.93-21.01 50.41-40.86 68.59-63.56c18.14 22.67 42.64 42.54 68.9 63.82C358.1 164.7 432 224.5 432 352c0 5.471-.8516 10.71-1.617 15.98H17.62C16.85 362.7 16 357.5 16 352C16 224.5 89.9 164.7 155.4 111.6zM320 464H128c-50.57 0-92.92-33.9-106.8-80h405.6C412.9 430.1 370.6 464 320 464z"],
    "chevron-down": [448, 512, [], "f078", "M2.652 162.1c1.531-1.376 3.438-2.048 5.344-2.048c2.188 0 4.375 .891 5.938 2.642L224 396.2l210.1-233.5c2.906-3.283 8-3.58 11.28-.594c3.281 2.97 3.563 8.019 .5938 11.32l-216 240.1c-3 3.345-8.875 3.345-11.88 0L2.058 173.4C-.9104 170.1-.6292 165 2.652 162.1z"],
    "chevron-left": [320, 512, [9001], "f053", "M253.9 34.65c1.376 1.531 2.048 3.438 2.048 5.344c0 2.188-.891 4.375-2.642 5.938L19.83 256l233.5 210.1c3.283 2.906 3.58 8 .594 11.28c-2.97 3.281-8.019 3.563-11.32 .5938L2.509 261.9c-3.345-3-3.345-8.875 0-11.88l240.1-216C245.9 31.09 250.1 31.37 253.9 34.65z"],
    "chevron-right": [320, 512, [9002], "f054", "M66.07 477.3c-1.376-1.531-2.048-3.438-2.048-5.344c0-2.188 .891-4.375 2.642-5.938L300.2 256L66.66 45.93c-3.283-2.906-3.58-8-.594-11.28c2.97-3.281 8.019-3.563 11.32-.5938l240.1 216c3.345 3 3.345 8.875 0 11.88L77.38 477.9C74.08 480.9 69.04 480.6 66.07 477.3z"],
    "chevron-up": [448, 512, [], "f077", "M445.3 349.9c-1.531 1.376-3.438 2.048-5.344 2.048c-2.188 0-4.375-.891-5.938-2.642L224 115.8l-210.1 233.5c-2.906 3.283-8 3.58-11.28 .594c-3.281-2.97-3.563-8.019-.5938-11.32l216-240.1c3-3.345 8.875-3.345 11.88 0l216 240.1C448.9 341.9 448.6 346.1 445.3 349.9z"],
    "chevrons-down": [448, 512, ["chevron-double-down"], "f322", "M434.1 226.8l-210.1 233.4L13.93 226.8C12.37 225 10.18 224.1 7.996 224.1c-1.906 0-3.813 .6719-5.344 2.047C-.6291 229.1-.9103 234.2 2.058 237.5l216 239.1c3 3.344 8.875 3.344 11.88 0l216-239.1C448.9 234.2 448.6 229.1 445.3 226.2C442.1 223.2 436.1 223.5 434.1 226.8zM218.1 285.4c3 3.344 8.875 3.344 11.88 0l216-239.1C448.9 42.08 448.6 37.03 445.3 34.06c-3.281-2.984-8.375-2.687-11.28 .5938L224 268.1L13.93 34.66C12.37 32.91 10.18 32.02 7.996 32.02c-1.906 0-3.813 .6719-5.344 2.047C-.6291 37.03-.9103 42.08 2.058 45.38L218.1 285.4z"],
    "chevrons-left": [448, 512, ["chevron-double-left"], "f323", "M253.2 466.1L19.82 256l233.4-210.1c1.75-1.563 2.641-3.75 2.641-5.938c0-1.906-.6719-3.813-2.047-5.344c-2.969-3.281-8.016-3.563-11.31-.5938L2.508 250.1c-3.344 3-3.344 8.875 0 11.88l240 216c3.297 2.969 8.344 2.688 11.31-.5938C256.8 474.1 256.5 468.1 253.2 466.1zM194.6 250.1c-3.344 3-3.344 8.875 0 11.88l240 216c3.297 2.969 8.344 2.688 11.31-.5938c2.984-3.281 2.688-8.375-.5938-11.28L211.9 256l233.4-210.1c1.75-1.563 2.641-3.75 2.641-5.938c0-1.906-.6719-3.813-2.047-5.344c-2.969-3.281-8.016-3.563-11.31-.5938L194.6 250.1z"],
    "chevrons-right": [448, 512, ["chevron-double-right"], "f324", "M194.8 45.93L428.2 256l-233.4 210.1c-1.75 1.563-2.641 3.75-2.641 5.938c0 1.906 .6719 3.813 2.047 5.344c2.969 3.281 8.016 3.563 11.31 .5938l240-216c3.344-3 3.344-8.875 0-11.88l-240-216C202.2 31.09 197.1 31.37 194.2 34.65C191.2 37.93 191.5 43.03 194.8 45.93zM253.4 261.9c3.344-3 3.344-8.875 0-11.88l-239.1-216c-3.297-2.969-8.344-2.688-11.31 .5938c-2.984 3.281-2.688 8.375 .5938 11.28L236.1 256l-233.4 210.1c-1.75 1.563-2.641 3.75-2.641 5.938c0 1.906 .6719 3.813 2.047 5.344c2.969 3.281 8.016 3.563 11.31 .5938L253.4 261.9z"],
    "chevrons-up": [448, 512, ["chevron-double-up"], "f325", "M13.93 285.2L224 51.82l210.1 233.4c1.562 1.75 3.75 2.641 5.938 2.641c1.906 0 3.813-.6719 5.344-2.047c3.281-2.969 3.563-8.016 .5938-11.31l-216-239.1c-3-3.344-8.875-3.344-11.88 0L2.058 274.5c-2.969 3.297-2.688 8.344 .5938 11.31C5.933 288.8 11.03 288.5 13.93 285.2zM229.9 226.6c-3-3.344-8.875-3.344-11.88 0l-216 239.1c-2.969 3.297-2.688 8.344 .5938 11.31c3.281 2.984 8.375 2.688 11.28-.5938L224 243.9l210.1 233.4c1.562 1.75 3.75 2.641 5.938 2.641c1.906 0 3.813-.6719 5.344-2.047c3.281-2.969 3.563-8.016 .5938-11.31L229.9 226.6z"],
    "child": [320, 512, [], "f1ae", "M95.1 64C95.1 28.65 124.7 0 160 0C195.3 0 224 28.65 224 64C224 99.35 195.3 128 160 128C124.7 128 95.1 99.35 95.1 64zM160 112C186.5 112 208 90.51 208 64C208 37.49 186.5 16 160 16C133.5 16 111.1 37.49 111.1 64C111.1 90.51 133.5 112 160 112zM158.5 176C126 176 96.16 193.9 80.86 222.5L31.06 315.8C28.98 319.7 24.13 321.1 20.23 319.1C16.34 316.1 14.86 312.1 16.95 308.2L66.75 214.1C84.83 181.1 120.1 160 158.5 160H161.5C199.9 160 235.2 181.1 253.3 214.1L303.1 308.2C305.1 312.1 303.7 316.1 299.8 319.1C295.9 321.1 291 319.7 288.9 315.8L239.1 222.5C223.8 193.9 194 176 161.5 176H158.5zM96 480C96 488.8 103.2 496 111.1 496C120.8 496 127.1 488.8 127.1 480V400C127.1 382.3 142.3 368 159.1 368C177.7 368 192 382.3 192 400V480C192 488.8 199.2 496 208 496C216.8 496 223.1 488.8 223.1 480V288C223.1 283.6 227.6 280 231.1 280C236.4 280 239.1 283.6 239.1 288V480C239.1 497.7 225.7 512 208 512C190.3 512 176 497.7 176 480V400C176 391.2 168.8 384 159.1 384C151.2 384 143.1 391.2 143.1 400V480C143.1 497.7 129.7 512 111.1 512C94.33 512 80 497.7 80 480V288C80 283.6 83.58 280 88 280C92.42 280 96 283.6 96 288V480z"],
    "child-dress": [320, 512, [], "e59c", "M96 64C96 28.65 124.7 0 160 0C195.3 0 224 28.65 224 64C224 99.35 195.3 128 160 128C124.7 128 96 99.35 96 64zM160 112C186.5 112 208 90.51 208 64C208 37.49 186.5 16 160 16C133.5 16 112 37.49 112 64C112 90.51 133.5 112 160 112zM107.4 248.8C111.4 250.6 113.1 255.4 111.2 259.4L52.61 384H267.4L208.8 259.4C206.9 255.4 208.6 250.6 212.6 248.8C216.6 246.9 221.4 248.6 223.2 252.6L287.2 388.6C288.4 391.1 288.2 393.1 286.8 396.3C285.3 398.6 282.7 400 280 400H239.1V480C239.1 497.7 225.7 512 208 512C190.3 512 176 497.7 176 480V400H143.1V480C143.1 497.7 129.7 512 111.1 512C94.33 512 80 497.7 80 480V400H40C37.26 400 34.71 398.6 33.25 396.3C31.78 393.1 31.6 391.1 32.76 388.6L96.76 252.6C98.64 248.6 103.4 246.9 107.4 248.8H107.4zM96 400V480C96 488.8 103.2 496 111.1 496C120.8 496 127.1 488.8 127.1 480V400H96zM208 496C216.8 496 223.1 488.8 223.1 480V400H192V480C192 488.8 199.2 496 208 496V496zM30.89 316.1C28.65 319.9 23.74 321.1 19.94 318.9C16.13 316.6 14.87 311.7 17.11 307.9L76.5 207.2C93.76 177.1 125.2 160 159.2 160H160.8C194.8 160 226.2 177.1 243.5 207.2L302.9 307.9C305.1 311.7 303.9 316.6 300.1 318.9C296.3 321.1 291.4 319.9 289.1 316.1L229.7 215.4C215.3 190.1 189.1 176 160.8 176H159.2C130.9 176 104.7 190.1 90.28 215.4L30.89 316.1z"],
    "child-reaching": [384, 512, [], "e59d", "M128 64C128 28.65 156.7 0 192 0C227.3 0 256 28.65 256 64C256 99.35 227.3 128 192 128C156.7 128 128 99.35 128 64zM192 112C218.5 112 240 90.51 240 64C240 37.49 218.5 16 192 16C165.5 16 144 37.49 144 64C144 90.51 165.5 112 192 112zM317 111.8L337.5 83.33C340.1 79.75 345.1 78.92 348.7 81.5C352.3 84.08 353.1 89.08 350.5 92.67L330 121.2C298.1 165.6 246.7 192 192 192C137.3 192 85.89 165.6 53.97 121.2L33.5 92.67C30.93 89.08 31.75 84.08 35.34 81.5C38.92 78.92 43.92 79.75 46.5 83.33L66.97 111.8C95.88 152.1 142.4 176 192 176C241.6 176 288.1 152.1 317 111.8zM128 480C128 488.8 135.2 496 143.1 496C152.8 496 159.1 488.8 159.1 480V400C159.1 382.3 174.3 368 191.1 368C209.7 368 224 382.3 224 400V480C224 488.8 231.2 496 239.1 496C248.8 496 255.1 488.8 255.1 480V232C255.1 227.6 259.6 224 263.1 224C268.4 224 271.1 227.6 271.1 232V480C271.1 497.7 257.7 512 239.1 512C222.3 512 208 497.7 208 480V400C208 391.2 200.8 384 191.1 384C183.2 384 175.1 391.2 175.1 400V480C175.1 497.7 161.7 512 143.1 512C126.3 512 112 497.7 112 480V232C112 227.6 115.6 224 120 224C124.4 224 128 227.6 128 232V480z"],
    "child-rifle": [512, 512, [], "e4e0", "M207.1 64C207.1 99.35 179.3 128 143.1 128C108.7 128 79.1 99.35 79.1 64C79.1 28.65 108.7 0 143.1 0C179.3 0 207.1 28.65 207.1 64zM143.1 16C117.5 16 95.1 37.49 95.1 64C95.1 90.51 117.5 112 143.1 112C170.5 112 191.1 90.51 191.1 64C191.1 37.49 170.5 16 143.1 16zM15.06 315.8C12.98 319.7 8.129 321.1 4.232 319.1C.3354 316.1-1.136 312.1 .9453 308.2L50.75 214.1C68.83 181.1 104.1 160 142.5 160H145.5C183.9 160 219.2 181.1 237.3 214.1L287.1 308.2C289.1 312.1 287.7 316.1 283.8 319.1C279.9 321.1 275 319.7 272.9 315.8L223.1 222.5C207.8 193.9 178 175.1 145.5 175.1H142.5C110 175.1 80.16 193.9 64.86 222.5L15.06 315.8zM72 280C76.42 280 80 283.6 80 288V476C80 487 88.95 496 99.1 496C111 496 119.1 487 119.1 476V392C119.1 378.7 130.7 368 143.1 368C157.3 368 168 378.7 168 392V476C168 487 176.1 496 187.1 496C199 496 207.1 487 207.1 476V288C207.1 283.6 211.6 280 215.1 280C220.4 280 223.1 283.6 223.1 288V476C223.1 495.9 207.9 512 187.1 512C168.1 512 152 495.9 152 476V392C152 387.6 148.4 384 143.1 384C139.6 384 135.1 387.6 135.1 392V476C135.1 495.9 119.9 512 99.1 512C80.12 512 64 495.9 64 476V288C64 283.6 67.58 280 72 280V280zM438 400L471.9 490.4C475.8 500.8 468.1 512 456.9 512H384C375.2 512 368 504.8 368 496V400H352C334.3 400 320 385.7 320 368V224C320 206.3 334.3 192 352 192H368V160C368 148.2 374.4 137.8 384 132.3V16H376C371.6 16 368 12.42 368 8C368 3.582 371.6 0 376 0H416C424.8 0 432 7.164 432 16V132.3C441.6 137.8 448 148.2 448 160V269.3L464 264V208C464 199.2 471.2 192 480 192H496C504.8 192 512 199.2 512 208V292.5C512 299.4 507.6 305.5 501.1 307.6L448 325.3V352H496C504.8 352 512 359.2 512 368V384C512 392.8 504.8 400 496 400L438 400zM416 141.5V16H400V141.5L392 146.1C387.2 148.9 384 154.1 384 160V384H496V368H432V160C432 154.1 428.8 148.9 423.1 146.1L416 141.5zM456.9 496L420.9 400H384V496H456.9zM448 308.5L496 292.5V208H480V275.5L448 286.2V308.5zM336 224V368C336 376.8 343.2 384 352 384H368V208H352C343.2 208 336 215.2 336 224z"],
    "children": [640, 512, [], "e4e1", "M224 64C224 99.35 195.3 128 160 128C124.7 128 96 99.35 96 64C96 28.65 124.7 0 160 0C195.3 0 224 28.65 224 64zM160 16C133.5 16 112 37.49 112 64C112 90.51 133.5 112 160 112C186.5 112 208 90.51 208 64C208 37.49 186.5 16 160 16zM52.61 384H267.4L208.8 259.4C206.9 255.4 208.6 250.6 212.6 248.8C216.6 246.9 221.4 248.6 223.2 252.6L287.2 388.6C288.4 391.1 288.2 393.1 286.8 396.3C285.3 398.6 282.7 400 280 400H239.1V480C239.1 497.7 225.7 512 207.1 512C190.3 512 176 497.7 176 480V400H143.1V480C143.1 497.7 129.7 512 111.1 512C94.33 512 80 497.7 80 480V400H40C37.26 400 34.71 398.6 33.25 396.3C31.78 393.1 31.6 391.1 32.76 388.6L96.76 252.6C98.64 248.6 103.4 246.9 107.4 248.8C111.4 250.6 113.1 255.4 111.2 259.4L52.61 384zM111.1 496C120.8 496 127.1 488.8 127.1 480V400H96V480C96 488.8 103.2 496 111.1 496zM192 400V480C192 488.8 199.2 496 207.1 496C216.8 496 223.1 488.8 223.1 480V400H192zM159.2 176C130.9 176 104.7 190.1 90.28 215.4L30.89 316.1C28.65 319.9 23.74 321.1 19.94 318.9C16.13 316.6 14.87 311.7 17.11 307.9L76.5 207.2C93.76 177.1 125.2 160 159.2 160H160.8C194.8 160 226.2 177.1 243.5 207.2L302.9 307.9C305.1 311.7 303.9 316.6 300.1 318.9C296.3 321.1 291.4 319.9 289.1 316.1L229.7 215.4C215.3 190.1 189.1 176 160.8 176H159.2zM544 64C544 99.35 515.3 128 480 128C444.7 128 416 99.35 416 64C416 28.65 444.7 0 480 0C515.3 0 544 28.65 544 64zM480 16C453.5 16 432 37.49 432 64C432 90.51 453.5 112 480 112C506.5 112 528 90.51 528 64C528 37.49 506.5 16 480 16zM351.1 315.8C348.1 319.7 344.1 321.1 340.2 319.1C336.3 316.1 334.9 312.1 336.9 308.2L386.7 214.1C404.8 181.1 440.1 160 478.5 160H481.5C519.9 160 555.2 181.1 573.3 214.1L623.1 308.2C625.1 312.1 623.7 316.1 619.8 319.1C615.9 321.1 611 319.7 608.9 315.8L559.1 222.5C543.8 193.9 514 175.1 481.5 175.1H478.5C446 175.1 416.2 193.9 400.9 222.5L351.1 315.8zM408 280C412.4 280 416 283.6 416 288V480C416 488.8 423.2 496 432 496C440.8 496 447.1 488.8 447.1 480V400C447.1 382.3 462.3 368 480 368C497.7 368 512 382.3 512 400V480C512 488.8 519.2 496 528 496C536.8 496 543.1 488.8 543.1 480V288C543.1 283.6 547.6 280 551.1 280C556.4 280 559.1 283.6 559.1 288V480C559.1 497.7 545.7 512 528 512C510.3 512 496 497.7 496 480V400C496 391.2 488.8 384 480 384C471.2 384 463.1 391.2 463.1 400V480C463.1 497.7 449.7 512 432 512C414.3 512 400 497.7 400 480V288C400 283.6 403.6 280 408 280z"],
    "chimney": [448, 512, [], "f78b", "M416 32H32C14.33 32 0 46.33 0 64v64c0 17.67 14.33 32 32 32v312C32 476.4 35.58 480 40 480s8-3.578 8-8V384h256v88c0 4.422 3.578 8 8 8S320 476.4 320 472V384h80v88c0 4.422 3.578 8 8 8S416 476.4 416 472V160c17.67 0 32-14.33 32-32V64C448 46.33 433.7 32 416 32zM128 256H48V160H128V256zM48 368v-96h160v96H48zM224 368v-96h176v96H224zM400 256h-256V160h256V256zM432 128c0 8.822-7.178 16-16 16H32C23.18 144 16 136.8 16 128V64c0-8.822 7.178-16 16-16h384c8.822 0 16 7.178 16 16V128z"],
    "chopsticks": [640, 512, [], "e3f7", "M638.3 93.55C639.9 98.92 640.4 104.6 639.7 110.1C639.1 115.7 637.3 121.1 634.5 125.9C631.7 130.8 627.1 135.1 623.5 138.4L152.4 508.8C149.8 510.8 146.6 511.1 143.3 512C140.2 512 137.2 511.1 134.7 509.4C132.1 507.6 130.2 505.2 129 502.3C127.9 499.5 127.7 496.3 128.4 493.4C129.1 490.4 130.6 487.6 132.9 485.6L570.6 74.98C574.7 71.17 579.5 68.25 584.8 66.38C590.1 64.5 595.7 63.73 601.3 64.09C606.9 64.46 612.4 65.96 617.4 68.5C622.4 71.04 626.8 74.57 630.4 78.88C633.1 83.19 636.7 88.18 638.3 93.55L638.3 93.55zM620.4 118.2C622.1 115.3 623.2 111.1 623.6 108.6C624 105.2 623.8 101.7 622.8 98.41C621.8 95.11 620.2 92.05 618 89.4C615.9 86.75 613.2 84.57 610.1 82.99C607.1 81.41 603.7 80.47 600.3 80.22C596.9 79.97 593.4 80.42 590.2 81.53C586.9 82.65 583.1 84.42 581.4 86.72L143.1 497.2L613.6 125.9C616.4 123.8 618.7 121.2 620.4 118.2H620.4zM411.3 22.13C413.9 27.09 415.4 32.54 415.9 38.13C416.3 43.72 415.6 49.34 413.8 54.65C412 59.96 409.2 64.85 405.4 69.03L26.59 506.9C23.96 509.8 20.34 511.5 16.48 511.8C12.61 512.1 8.791 510.9 5.784 508.4C2.777 505.1 .8102 502.5 .2828 498.6C-.2445 494.8 .7065 490.9 2.943 487.7L341.2 16.93C344.6 12.41 348.8 8.603 353.6 5.752C358.4 2.9 363.8 1.059 369.3 .341C374.9-.3774 380.5 .0421 385.9 1.574C391.3 3.105 396.3 5.717 400.7 9.25C405.1 12.78 408.6 17.17 411.3 22.13L411.3 22.13zM398.6 49.66C399.7 46.37 400.2 42.87 399.9 39.39C399.5 34.22 397.6 29.3 394.3 25.29C390.1 21.28 386.6 18.37 381.6 16.96C376.6 15.54 371.3 15.69 366.4 17.38C361.5 19.06 357.2 22.21 354.1 26.4L15.1 497.1L393.3 58.56C395.7 55.99 397.5 52.96 398.6 49.66z"],
    "church": [640, 512, [9962], "f51d", "M328 48H376C380.4 48 384 51.58 384 56C384 60.42 380.4 64 376 64H328V123.6L453.9 203.1C470.2 213.4 480 231.2 480 250.5V495.1H584C606.1 495.1 624 478.1 624 455.1V385.7C624 372.3 617.3 359.8 606.2 352.4L507.6 286.7C503.9 284.2 502.9 279.2 505.3 275.6C507.8 271.9 512.8 270.9 516.4 273.3L615.1 339.1C630.6 349.5 640 366.1 640 385.7V455.1C640 486.9 614.9 511.1 584 511.1H472.3C472.2 512 472.1 512 472 512H176.3C176.2 512 176.1 512 176 512H56C25.07 512 0 486.9 0 456V385.7C0 366.1 9.358 349.5 24.94 339.1L123.6 273.3C127.2 270.9 132.2 271.9 134.7 275.6C137.1 279.2 136.1 284.2 132.4 286.7L33.81 352.4C22.68 359.8 16 372.3 16 385.7V456C16 478.1 33.91 496 56 496H160V250.5C160 231.2 169.9 213.4 186.1 203.1L312 123.6V64H264C259.6 64 256 60.42 256 56C256 51.58 259.6 48 264 48H312V8C312 3.582 315.6 0 320 0C324.4 0 328 3.582 328 8L328 48zM464 495.1V250.5C464 236.7 456.1 223.1 445.4 216.6L320 137.5L194.6 216.6C183 223.1 176 236.7 176 250.5V496H256V384C256 348.7 284.7 320 320 320C355.3 320 384 348.7 384 384V496H463.7C463.8 495.1 463.9 495.1 464 495.1zM320 336C293.5 336 272 357.5 272 384V496H368V384C368 357.5 346.5 336 320 336z"],
    "circle": [512, 512, [128308, 128309, 128992, 128993, 128994, 128995, 128996, 9898, 9899, 11044, 61708, 61915, 9679], "f111", "M512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 16C123.5 16 16 123.5 16 256C16 388.5 123.5 496 256 496C388.5 496 496 388.5 496 256C496 123.5 388.5 16 256 16z"],
    "circle-0": [512, 512, [], "e0ed", "M256 128C202.1 128 160 170.1 160 224v64c0 53.02 42.98 96 96 96s96-42.98 96-96V224C352 170.1 309 128 256 128zM336 288c0 44.11-35.89 80-80 80S176 332.1 176 288V224c0-44.11 35.89-80 80-80s80 35.89 80 80V288zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-1": [512, 512, [], "e0ee", "M320 368h-56V136c0-2.844-1.516-5.5-3.984-6.906c-2.438-1.406-5.484-1.469-7.984-.0313l-56 32C192.2 163.3 190.9 168.1 193 171.1c2.219 3.844 7.094 5.125 10.92 2.969L248 149.8V368H192c-4.422 0-8 3.594-8 8S187.6 384 192 384h128c4.422 0 8-3.594 8-8S324.4 368 320 368zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-2": [512, 512, [], "e0ef", "M344 368H189.5l113.1-97.94c33.89-29.28 37.83-78.88 8.969-112.9C297.3 140.3 277.2 130 255 128.3C232.7 126.8 211.1 133.5 194.3 148L175.5 164.2C172.2 167.1 171.8 172.1 174.7 175.5c2.906 3.375 7.938 3.781 11.28 .8438l18.8-16.19c13.59-11.66 31-17.31 49-15.91c17.92 1.406 34.13 9.656 45.61 23.25c23.12 27.28 19.95 67.03-7.219 90.47l-129.4 112c-2.531 2.188-3.422 5.719-2.266 8.844C161.7 381.9 164.7 384 168 384h176c4.422 0 8-3.594 8-8S348.4 368 344 368zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-3": [512, 512, [], "e0f0", "M280 240H221.3l111.1-97.97c2.516-2.219 3.391-5.719 2.219-8.844S331.3 128 328 128h-160C163.6 128 160 131.6 160 136S163.6 144 168 144h138.7L194.7 241.1c-2.516 2.219-3.391 5.719-2.219 8.844S196.7 256 200 256h80c30.88 0 56 25.12 56 56s-25.12 56-56 56H212.5c-16.78 0-31.59-10.69-36.89-26.59c-1.406-4.156-5.906-6.469-10.12-5.062c-4.188 1.406-6.453 5.938-5.062 10.12C167.9 368.9 188.8 384 212.5 384H280C319.7 384 352 351.7 352 312S319.7 240 280 240zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-4": [512, 512, [], "e0f1", "M344 304H320V200C320 195.6 316.4 192 312 192S304 195.6 304 200V304H171.9l67.48-164.1c1.672-4.094-.2813-8.75-4.375-10.44C230.9 126.9 226.3 128.9 224.6 132.1l-72 176c-1 2.469-.7187 5.281 .7656 7.5S157.3 320 160 320h144v56c0 4.406 3.578 8 8 8S320 380.4 320 376V320h24C348.4 320 352 316.4 352 312S348.4 304 344 304zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-5": [512, 512, [], "e0f2", "M280 240H185.8l19.03-96H328c4.422 0 8-3.594 8-8S332.4 128 328 128H198.2C194.4 128 191.1 130.7 190.4 134.4l-22.22 112C167.7 248.8 168.3 251.2 169.8 253.1C171.3 254.9 173.6 256 176 256h104c30.88 0 56 25.12 56 56s-25.12 56-56 56H213.4c-17.19 0-32.38-10.94-37.81-27.25c-1.391-4.188-5.922-6.438-10.12-5.062c-4.188 1.406-6.453 5.938-5.062 10.12C168 368.7 189.3 384 213.4 384H280C319.7 384 352 351.7 352 312S319.7 240 280 240zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-6": [512, 512, [], "e0f3", "M256 192C251.5 192 247.1 192.7 242.7 193.3l58.56-51.31c3.312-2.938 3.656-7.969 .75-11.31C300.4 128.9 298.2 128 296 128c-1.875 0-3.75 .6562-5.281 1.969c0 0-99.16 87.3-99.37 87.54C172.2 235.1 160 260 160 288c0 52.94 43.06 96 96 96s96-43.06 96-96S308.9 192 256 192zM256 368c-44.13 0-80-35.88-80-80S211.9 208 256 208s80 35.88 80 80S300.1 368 256 368zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-7": [512, 512, [], "e0f4", "M344 128h-176C163.6 128 160 131.6 160 136S163.6 144 168 144h161.9l-136.8 227.9c-2.25 3.812-1.031 8.719 2.75 11C197.2 383.6 198.6 384 200 384c2.719 0 5.375-1.375 6.875-3.875l144-240c1.469-2.469 1.5-5.562 .0938-8.062C349.5 129.6 346.9 128 344 128zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-8": [512, 512, [], "e0f5", "M307.1 245.4C324.5 233.9 336 214.3 336 192c0-35.28-28.72-64-64-64h-32c-35.28 0-64 28.72-64 64c0 22.31 11.52 41.94 28.88 53.4C178.6 256.1 160 281.9 160 312C160 351.7 192.3 384 232 384h48C319.7 384 352 351.7 352 312C352 281.9 333.4 256.1 307.1 245.4zM192 192c0-26.47 21.53-48 48-48h32C298.5 144 320 165.5 320 192s-21.53 48-48 48h-32C213.5 240 192 218.5 192 192zM280 368h-48c-30.88 0-56-25.12-56-56S201.1 256 232 256h48c30.88 0 56 25.12 56 56S310.9 368 280 368zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-9": [512, 512, [], "e0f6", "M256 128C203.1 128 160 171.1 160 224s43.06 96 96 96c4.547 0 8.896-.7266 13.28-1.342l-58.56 51.31c-3.312 2.938-3.656 7.969-.75 11.31C211.6 383.1 213.8 384 216 384c1.875 0 3.75-.6562 5.281-1.969c0 0 99.16-87.3 99.37-87.54C339.8 276.9 352 251.1 352 224C352 171.1 308.9 128 256 128zM256 304C211.9 304 176 268.1 176 224S211.9 144 256 144s80 35.88 80 80S300.1 304 256 304zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-a": [512, 512, [], "e0f7", "M263.2 116.4c-2.719-5.406-11.59-5.406-14.31 0l-120 240c-1.969 3.953-.375 8.75 3.578 10.73c4 2 8.75 .375 10.73-3.578L168.9 312h174.1l25.79 51.58C370.3 366.4 373.1 368 376 368c1.203 0 2.422-.2656 3.578-.8438c3.953-1.984 5.547-6.781 3.578-10.73L263.2 116.4zM176.9 296L256 137.9L335.1 296H176.9zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-ampersand": [512, 512, [], "e0f8", "M322.9 325.9l42.51-60.1c2.562-3.609 1.688-8.609-1.906-11.16c-3.625-2.562-8.594-1.719-11.16 1.906l-40.62 57.43L243.3 241.1l36.91-29.75c11.47-8.938 18.06-22.25 18.06-36.52C298.3 149 276.6 128 249.1 128H227.7C201.1 128 179.4 149 179.4 174.8c0 14.03 5.375 27.44 15.12 37.7l25.28 26.94L167.3 281.8c-14.09 10.94-22.16 27.25-22.16 44.77C145.2 358.2 171.8 384 204.4 384h38.88c24.09 0 46.63-11.48 60.22-30.72l9.902-14l39.57 42.19c3.094 3.25 8.125 3.391 11.31 .3594c3.219-3.016 3.375-8.078 .375-11.3L322.9 325.9zM206.2 201.6C199.3 194.3 195.4 184.8 195.4 174.8C195.4 157.8 209.9 144 227.7 144h22.28c17.81 0 32.28 13.84 32.28 30.84c0 9.297-4.344 18.02-12 23.97l-37.97 30.61L206.2 201.6zM290.5 344C279.9 359 262.2 368 243.3 368H204.4c-23.88 0-43.28-18.58-43.28-41.42c0-12.53 5.812-24.25 16.09-32.22l53.56-43.17l71.45 76.18L290.5 344zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-arrow-down": [512, 512, ["arrow-circle-down"], "f0ab", "M370.3 250.3L264 356.7V136C264 131.6 260.4 128 256 128S248 131.6 248 136v220.7L141.7 250.3c-3.125-3.125-8.188-3.125-11.31 0s-3.125 8.188 0 11.31l120 120c3.125 3.125 8.188 3.125 11.31 0l120-120C383.2 260.1 384 258.1 384 256s-.7813-4.094-2.344-5.656C378.5 247.2 373.5 247.2 370.3 250.3zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-arrow-down-left": [512, 512, [], "e0f9", "M338.3 162.3L175.1 324.7V184c0-4.422-3.58-8-7.998-8C163.6 176 160 179.6 160 184v160C160 348.4 163.6 352 168 352h160c4.42 0 8-3.578 8-8s-3.58-8-8-8H187.3l162.3-162.3c3.117-3.117 3.127-8.188 0-11.32C346.5 159.2 341.5 159.2 338.3 162.3zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-arrow-down-right": [512, 512, [], "e0fa", "M344 176c-4.418 0-7.998 3.578-7.998 8v140.7L173.7 162.3c-3.115-3.113-8.188-3.129-11.31 0c-3.127 3.129-3.117 8.199 0 11.32L324.7 336H184c-4.42 0-8 3.578-8 8S179.6 352 184 352h160c4.42 0 8-3.578 8-8v-160C352 179.6 348.4 176 344 176zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-arrow-left": [512, 512, ["arrow-circle-left"], "f0a8", "M376 248H155.3l106.3-106.3c3.125-3.125 3.125-8.188 0-11.31s-8.188-3.125-11.31 0l-120 120c-3.125 3.125-3.125 8.188 0 11.31l120 120C251.9 383.2 253.9 384 256 384s4.094-.7813 5.656-2.344c3.125-3.125 3.125-8.188 0-11.31L155.3 264H376C380.4 264 384 260.4 384 256S380.4 248 376 248zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-arrow-right": [512, 512, ["arrow-circle-right"], "f0a9", "M261.7 130.3C260.1 128.8 258.1 128 256 128S251.9 128.8 250.3 130.3c-3.125 3.125-3.125 8.188 0 11.31L356.7 248H136C131.6 248 128 251.6 128 256s3.594 8 8 8h220.7l-106.3 106.3c-3.125 3.125-3.125 8.188 0 11.31s8.188 3.125 11.31 0l120-120c3.125-3.125 3.125-8.188 0-11.31L261.7 130.3zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-arrow-up": [512, 512, ["arrow-circle-up"], "f0aa", "M261.7 130.3c-3.125-3.125-8.188-3.125-11.31 0l-120 120C128.8 251.9 128 253.9 128 256s.7813 4.094 2.344 5.656c3.125 3.125 8.188 3.125 11.31 0L248 155.3V376C248 380.4 251.6 384 256 384s8-3.594 8-8V155.3l106.3 106.3c3.125 3.125 8.188 3.125 11.31 0s3.125-8.188 0-11.31L261.7 130.3zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-arrow-up-left": [512, 512, [], "e0fb", "M187.3 176H328c4.42 0 8-3.582 8-8C336 163.6 332.4 160 328 160h-160C163.6 160 160 163.6 160 168v160c0 4.422 3.576 8 8 8c4.418 0 7.998-3.578 7.998-8V187.3l162.3 162.3c3.115 3.117 8.188 3.129 11.31 0c3.127-3.125 3.117-8.195 0-11.31L187.3 176zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-arrow-up-right": [512, 512, [], "e0fc", "M344 160h-160C179.6 160 176 163.6 176 168c0 4.418 3.58 8 8 8h140.7l-162.3 162.3c-3.117 3.117-3.127 8.188 0 11.31c3.125 3.129 8.197 3.117 11.31 0l162.3-162.3V328c0 4.422 3.58 8 7.998 8c4.424 0 8-3.578 8-8v-160C352 163.6 348.4 160 344 160zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-b": [512, 512, [], "e0fd", "M308.5 250.3C325.1 237.9 336 218.3 336 196C336 158.5 305.5 128 268 128H168C163.6 128 160 131.6 160 136v240C160 380.4 163.6 384 168 384h124c37.5 0 68-30.5 68-68C360 284.2 338 257.7 308.5 250.3zM176 144h92C296.7 144 320 167.3 320 196S296.7 248 268 248H176V144zM292 368H176V264h116c28.67 0 52 23.33 52 52S320.7 368 292 368zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-bolt": [512, 512, [], "e0fe", "M325.8 112.3L290.9 224H364.9C375.5 224 384 232.5 384 243.1C384 248.5 381.7 253.6 377.8 257.2L206.7 412.7C204.4 414.8 201.4 416 198.2 416C189.7 416 183.7 407.8 186.2 399.7L221.1 288H146.5C136.3 288 128 279.7 128 269.5C128 264.3 130.2 259.4 134 255.9L305.3 99.29C307.6 97.18 310.6 96 313.8 96C322.3 96 328.3 104.2 325.8 112.3V112.3zM144 269.5C144 270.9 145.1 272 146.5 272H232C234.5 272 236.9 273.2 238.4 275.3C239.1 277.3 240.4 279.1 239.6 282.4L205.3 392.4L366.1 245.4C367.6 244.8 368 243.1 368 243.1C368 241.4 366.6 240 364.9 240H280C277.5 240 275.1 238.8 273.6 236.7C272 234.7 271.6 232 272.4 229.6L306.7 119.7L144.8 267.7C144.3 268.1 144 268.8 144 269.5V269.5zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 16C123.5 16 16 123.5 16 256C16 388.5 123.5 496 256 496C388.5 496 496 388.5 496 256C496 123.5 388.5 16 256 16z"],
    "circle-book-open": [512, 512, ["book-circle"], "e0ff", "M387.1 156.8c-5.762-2.125-35.04-13.07-65.8-12.83C286.6 144.6 262.9 156.2 256 160C249.1 156.2 225.4 144.6 190.7 144c-29.83-.4766-60.25 10.78-65.8 12.83C117.2 159.7 112 167.2 112 175.6v163.1c0 10.45 10.1 18.44 20.62 15.22c16.43-5.09 31.84-7.037 45.81-7.037c44.95 0 74.9 20.15 75.29 20.41c1.418 .959 3.172 .9375 4.547 0c.3926-.2676 30.34-20.41 75.29-20.41c13.97 0 29.38 1.947 45.81 7.037C389.1 357.2 400 349.1 400 338.7V175.6C400 167.2 394.8 159.7 387.1 156.8zM248 346.2c-14.43-6.754-38.46-15.33-69.56-15.33c-16.94 0-33.95 2.609-50.44 7.818V175.6c0-1.688 1.006-3.236 2.461-3.771C151.5 164.1 172 160 190.5 160C221.2 160.5 242.1 170.6 248 173.9V346.2zM384 338.7c-16.49-5.209-33.49-7.818-50.44-7.818c-31.11 0-55.14 8.576-69.56 15.33V173.9C269.9 170.6 290.8 160.5 321.5 160c18.44 0 39.02 4.094 60.01 11.84C382.1 172.4 384 173.9 384 175.6V338.7zM256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256s256-114.6 256-256C512 114.6 397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-bookmark": [512, 512, ["bookmark-circle"], "e100", "M312 128h-112C177.9 128 160 145.9 160 168v208c0 3.094 1.781 5.906 4.562 7.234c2.812 1.344 6.094 .9062 8.5-1.047L256 314.3l82.94 67.84C340.4 383.4 342.2 384 344 384c1.156 0 2.344-.25 3.438-.7656C350.2 381.9 352 379.1 352 376v-208C352 145.9 334.1 128 312 128zM336 359.1l-74.94-61.31C259.6 296.6 257.8 296 256 296S252.4 296.6 250.9 297.8L176 359.1V168c0-13.23 10.78-24 24-24h112c13.22 0 24 10.77 24 24V359.1zM256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256s256-114.6 256-256C512 114.6 397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-c": [512, 512, [], "e101", "M338.4 176.8c3.109 3.094 8.203 3.062 11.31-.0938c3.094-3.141 3.062-8.203-.0938-11.31c-50.59-49.84-132.9-49.84-183.5 0C141.5 189.6 128 221.8 128 256s13.48 66.38 38.03 90.56c25.3 24.92 58.53 37.38 91.77 37.38s66.47-12.45 91.77-37.38c3.156-3.109 3.188-8.172 .0938-11.31c-3.109-3.156-8.203-3.188-11.31-.0938c-44.44 43.75-116.7 43.75-161.1 0C155.8 314 144 285.9 144 256s11.83-58 33.3-79.16C221.7 133.1 293.1 133.1 338.4 176.8zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-calendar": [512, 512, ["calendar-circle"], "e102", "M200 96C204.4 96 208 99.58 208 104V128H304V104C304 99.58 307.6 96 312 96C316.4 96 320 99.58 320 104V128H336C362.5 128 384 149.5 384 176V336C384 362.5 362.5 384 336 384H176C149.5 384 128 362.5 128 336V176C128 149.5 149.5 128 176 128H192V104C192 99.58 195.6 96 200 96zM192 168V144H176C158.3 144 144 158.3 144 176V208H368V176C368 158.3 353.7 144 336 144H320V168C320 172.4 316.4 176 312 176C307.6 176 304 172.4 304 168V144H208V168C208 172.4 204.4 176 200 176C195.6 176 192 172.4 192 168zM144 224V336C144 353.7 158.3 368 176 368H336C353.7 368 368 353.7 368 336V224H144zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 16C123.5 16 16 123.5 16 256C16 388.5 123.5 496 256 496C388.5 496 496 388.5 496 256C496 123.5 388.5 16 256 16z"],
    "circle-camera": [512, 512, ["camera-circle"], "e103", "M256 208C229.5 208 208 229.5 208 256S229.5 304 256 304s48-21.5 48-48S282.5 208 256 208zM256 288C238.4 288 224 273.6 224 256s14.36-32 32-32s32 14.36 32 32S273.6 288 256 288zM352 160h-36l-6.188-16.44C306.3 134.2 297.4 128 287.4 128H224.6c-10 0-19 6.188-22.5 15.56L196 160H160C142.3 160 128 174.3 128 192v128c0 17.67 14.33 32 32 32h192c17.67 0 32-14.33 32-32V192C384 174.3 369.7 160 352 160zM368 320c0 8.822-7.178 16-16 16H160c-8.822 0-16-7.178-16-16V192c0-8.822 7.178-16 16-16h47.11l10-26.84C218.3 146.1 221.3 144 224.6 144h62.75c3.355 0 6.277 2.025 7.463 5.199L304.9 176H352c8.822 0 16 7.178 16 16V320zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-caret-down": [512, 512, ["caret-circle-down"], "f32d", "M345.6 192H166.4c-11.28 0-21.57 6.633-26.22 16.89C135.5 219.2 137.3 231.3 144.8 239.8l89.56 102.4C239.8 348.4 247.7 352 256 352s16.2-3.59 21.67-9.844l89.59-102.4c7.426-8.426 9.229-20.55 4.557-30.87C367.2 198.6 356.9 192 345.6 192zM355.2 229.2l-89.6 102.4C263.2 334.4 259.7 336 256 336s-7.199-1.602-9.625-4.375L156.8 229.2C153.4 225.4 152.7 220.1 154.8 215.5C156.8 210.9 161.4 208 166.4 208h179.2c5.025 0 9.576 2.922 11.65 7.5C359.3 220.1 358.6 225.4 355.2 229.2zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-caret-left": [512, 512, ["caret-circle-left"], "f32e", "M303.1 140.2c-3.771-1.711-7.779-2.578-11.91-2.578c-7.002 0-13.75 2.547-18.1 7.164L169.8 234.3C163.6 239.8 160 247.7 160 256s3.59 16.21 9.848 21.67l102.4 89.59c5.209 4.586 11.96 7.133 18.96 7.133c4.135 0 8.145-.8672 11.91-2.578C313.4 367.2 320 356.9 320 345.6V166.4C320 155.1 313.4 144.8 303.1 140.2zM304 345.6c0 5.023-2.926 9.57-7.5 11.65c-1.697 .7695-3.508 1.148-5.303 1.148c-3.043 0-6.049-1.086-8.422-3.172L180.4 265.6C177.6 263.2 176 259.7 176 256c0-3.703 1.6-7.203 4.375-9.625l102.4-89.6c2.373-2.086 5.381-3.172 8.422-3.172c1.797 0 3.604 .375 5.303 1.148C301.1 156.8 304 161.4 304 166.4V345.6zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-caret-right": [512, 512, ["caret-circle-right"], "f330", "M239.8 144.7C234.6 140.1 227.8 137.6 220.8 137.6c-4.135 0-8.145 .8672-11.91 2.578C198.6 144.8 192 155.1 192 166.4v179.2c0 11.27 6.629 21.56 16.89 26.22c3.77 1.711 7.777 2.578 11.91 2.578c7.004 0 13.75-2.547 18.1-7.164l102.4-89.57C348.4 272.2 352 264.3 352 256s-3.59-16.21-9.848-21.67L239.8 144.7zM331.6 265.6L229.2 355.2c-2.373 2.086-5.381 3.172-8.422 3.172c-1.797 0-3.604-.3789-5.303-1.148C210.9 355.2 208 350.6 208 345.6V166.4c0-5.023 2.926-9.574 7.5-11.65c1.699-.7734 3.508-1.148 5.303-1.148c3.043 0 6.049 1.082 8.422 3.172l102.4 89.6C334.4 248.8 336 252.3 336 256C336 259.7 334.4 263.2 331.6 265.6zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-caret-up": [512, 512, ["caret-circle-up"], "f331", "M277.7 169.8C272.2 163.6 264.3 160 256 160S239.8 163.6 234.3 169.8L144.7 272.2C137.3 280.7 135.5 292.8 140.2 303.1C144.8 313.4 155.1 320 166.4 320h179.2c11.28 0 21.57-6.633 26.22-16.89c4.672-10.31 2.871-22.44-4.594-30.91L277.7 169.8zM357.3 296.5C355.2 301.1 350.6 304 345.6 304H166.4c-5.025 0-9.576-2.926-11.65-7.5C152.7 291.9 153.4 286.5 156.8 282.8l89.6-102.4C248.8 177.6 252.3 176 256 176s7.199 1.602 9.625 4.375l89.6 102.4C358.6 286.5 359.3 291.9 357.3 296.5zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-check": [512, 512, [61533, "check-circle"], "f058", "M229.7 325.7C226.5 328.8 221.5 328.8 218.3 325.7L154.3 261.7C151.2 258.5 151.2 253.5 154.3 250.3C157.5 247.2 162.5 247.2 165.7 250.3L224 308.7L346.3 186.3C349.5 183.2 354.5 183.2 357.7 186.3C360.8 189.5 360.8 194.5 357.7 197.7L229.7 325.7zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 16C123.5 16 16 123.5 16 256C16 388.5 123.5 496 256 496C388.5 496 496 388.5 496 256C496 123.5 388.5 16 256 16z"],
    "circle-chevron-down": [512, 512, ["chevron-circle-down"], "f13a", "M362.1 210.5l-106.2 113.7L149.8 210.5C148.3 208.9 146.1 208 143.1 208c-1.969 0-3.906 .7187-5.469 2.156C135.3 213.2 135.1 218.2 138.1 221.5l112 120c3 3.25 8.688 3.25 11.69 0l112-120c3.031-3.219 2.844-8.281-.375-11.3C370.2 207.2 365.2 207.3 362.1 210.5zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-chevron-left": [512, 512, ["chevron-circle-left"], "f137", "M304 143.1c0-1.969-.7187-3.906-2.156-5.469c-3.016-3.219-8.078-3.406-11.3-.375l-120 112c-3.25 3-3.25 8.688 0 11.69l120 112c3.219 3.031 8.281 2.844 11.3-.375c3-3.25 2.859-8.281-.3906-11.31L187.7 255.1l113.7-106.2C303.1 148.3 304 146.1 304 143.1zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-chevron-right": [512, 512, ["chevron-circle-right"], "f138", "M221.5 138.2C218.2 135.1 213.2 135.3 210.2 138.5c-3 3.25-2.859 8.281 .3906 11.31l113.7 106.2l-113.7 106.2C208.9 363.7 208 365.9 208 368c0 1.969 .7187 3.906 2.156 5.469c3.016 3.219 8.078 3.406 11.3 .375l120-112c3.25-3 3.25-8.688 0-11.69L221.5 138.2zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-chevron-up": [512, 512, ["chevron-circle-up"], "f139", "M261.9 170.5c-3-3.25-8.688-3.25-11.69 0l-112 120C135.1 293.8 135.3 298.8 138.5 301.8c3.25 3 8.281 2.859 11.31-.3906l106.2-113.7l106.2 113.7C363.7 303.1 365.9 304 368 304c1.969 0 3.906-.7187 5.469-2.156c3.219-3.016 3.406-8.078 .375-11.3L261.9 170.5zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-d": [512, 512, [], "e104", "M256 128H168C163.6 128 160 131.6 160 136v240C160 380.4 163.6 384 168 384H256c70.58 0 128-57.42 128-128S326.6 128 256 128zM256 368H176v-224H256c61.75 0 112 50.25 112 112S317.8 368 256 368zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-dashed": [512, 512, [], "e105", "M9.916 232C5.19 232 1.476 227.9 2.075 223.2C7.973 177.1 26.18 134.7 53.3 99.62C56.19 95.88 61.69 95.63 65.03 98.97C67.95 101.9 68.17 106.5 65.65 109.8C40.5 142.5 23.59 181.9 18.01 224.8C17.48 228.9 14.04 232 9.916 232H9.916zM109.8 65.65C106.5 68.17 101.9 67.95 98.97 65.03C95.63 61.69 95.88 56.19 99.62 53.3C134.7 26.18 177.1 7.973 223.2 2.075C227.9 1.476 232 5.19 232 9.916C232 14.04 228.9 17.48 224.8 18.01C181.9 23.59 142.5 40.5 109.8 65.65L109.8 65.65zM280 502.1C280 497.1 283.1 494.5 287.2 493.1C330.1 488.4 369.5 471.5 402.2 446.3C405.5 443.8 410.1 444.1 413 446.1C416.4 450.3 416.1 455.8 412.4 458.7C377.3 485.8 334.9 504 288.8 509.9C284.1 510.5 280 506.8 280 502.1V502.1zM493.1 287.2C494.5 283.1 497.1 280 502.1 280C506.8 280 510.5 284.1 509.9 288.8C504 334.9 485.8 377.3 458.7 412.4C455.8 416.1 450.3 416.4 446.1 413C444.1 410.1 443.8 405.5 446.3 402.2C471.5 369.5 488.4 330.1 493.1 287.2L493.1 287.2zM109.8 446.3C142.5 471.5 181.9 488.4 224.8 493.1C228.9 494.5 232 497.1 232 502.1C232 506.8 227.9 510.5 223.2 509.9C177.1 504 134.7 485.8 99.62 458.7C95.88 455.8 95.63 450.3 98.98 446.1C101.9 444.1 106.5 443.8 109.8 446.3V446.3zM2.076 288.8C1.477 284.1 5.19 280 9.916 280C14.04 280 17.48 283.1 18.01 287.2C23.59 330.1 40.5 369.5 65.66 402.2C68.17 405.5 67.95 410.1 65.03 413C61.69 416.4 56.19 416.1 53.3 412.4C26.18 377.3 7.974 334.9 2.076 288.8V288.8zM402.2 65.66C369.5 40.5 330.1 23.59 287.2 18.01C283.1 17.48 280 14.04 280 9.916C280 5.19 284.1 1.477 288.8 2.076C334.9 7.974 377.3 26.18 412.4 53.3C416.1 56.19 416.4 61.69 413 65.03C410.1 67.95 405.5 68.17 402.2 65.66V65.66zM446.3 109.8C443.8 106.5 444.1 101.9 446.1 98.98C450.3 95.63 455.8 95.88 458.7 99.62C485.8 134.7 504 177.1 509.9 223.2C510.5 227.9 506.8 232 502.1 232C497.1 232 494.5 228.9 493.1 224.8C488.4 181.9 471.5 142.5 446.3 109.8V109.8z"],
    "circle-divide": [512, 512, [], "e106", "M288 160C288 177.7 273.7 192 256 192C238.3 192 224 177.7 224 160C224 142.3 238.3 128 256 128C273.7 128 288 142.3 288 160zM256 144C247.2 144 240 151.2 240 160C240 168.8 247.2 176 256 176C264.8 176 272 168.8 272 160C272 151.2 264.8 144 256 144zM360 248C364.4 248 368 251.6 368 256C368 260.4 364.4 264 360 264H152C147.6 264 144 260.4 144 256C144 251.6 147.6 248 152 248H360zM224 352C224 334.3 238.3 320 256 320C273.7 320 288 334.3 288 352C288 369.7 273.7 384 256 384C238.3 384 224 369.7 224 352zM256 368C264.8 368 272 360.8 272 352C272 343.2 264.8 336 256 336C247.2 336 240 343.2 240 352C240 360.8 247.2 368 256 368zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 16C123.5 16 16 123.5 16 256C16 388.5 123.5 496 256 496C388.5 496 496 388.5 496 256C496 123.5 388.5 16 256 16z"],
    "circle-dollar": [512, 512, ["dollar-circle", "usd-circle"], "f2e8", "M255.5 96C259.9 96 263.5 99.58 263.5 104V139.2C270.1 139.3 276.8 139.8 283.5 140.8C293.1 142.2 302.6 144.9 311.9 147.6C314.7 148.4 317.5 149.2 320.2 149.9C324.5 151.1 327 155.5 325.8 159.8C324.6 164 320.2 166.5 315.1 165.4C313.2 164.6 310.4 163.8 307.7 162.1C298.9 160.5 290.1 157.9 281.2 156.6C258.2 153.2 236.8 156.1 220.8 163C204.6 169.1 194.1 180.5 192.8 192.1C190.1 206.9 196.2 218.5 208.7 226.4C221.8 234.8 240.8 240.2 261.5 246.1L266.1 247.4C284.9 252.7 304.5 258.2 320.7 269.3C338.7 281.7 346.9 301 342.9 322.6C339.2 342.7 325.4 356.5 306.7 364C294.2 369 279.5 371.4 263.5 371.3L263.5 408C263.5 412.4 259.9 416 255.5 416C251.1 416 247.5 412.4 247.5 408L247.5 370.4C244.9 370.1 242.2 369.8 239.5 369.4L239.4 369.4C231.2 368.1 216.5 363.9 204.3 360.2C196.7 357.9 189.1 355.5 181.5 353C177.3 351.6 175 347.1 176.4 342.9C177.8 338.7 182.3 336.4 186.5 337.8C193.1 340.3 201.5 342.6 208.1 344.9C221.4 348.7 234.1 352.5 241.8 353.6C265.1 356.1 285.6 355.2 300.7 349.2C315.5 343.2 324.7 333.2 327.2 319.7C329.1 304.2 324.5 291.4 311.6 282.5C297.1 272.6 279.5 267.7 262.6 263C260.3 262.4 258 261.8 255.8 261.1C236.2 255.6 215.2 249.6 200 239.9C182.2 228.5 173.2 210.3 177.1 189.2C180.5 170.5 195.4 156.5 214.4 148.3C224.2 144.1 235.5 141.2 247.5 139.9V103.1C247.5 99.58 251.1 95.1 255.5 95.1L255.5 96zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 16C123.5 16 16 123.5 16 256C16 388.5 123.5 496 256 496C388.5 496 496 388.5 496 256C496 123.5 388.5 16 256 16z"],
    "circle-dollar-to-slot": [512, 512, ["donate"], "f4b9", "M256.9 93.33C261.3 93.33 264.9 96.92 264.9 101.3V120.6C267.1 120.8 269.4 121.1 271.7 121.5C277.1 122.3 293.3 125.4 298.9 126.9C303.2 128.1 305.8 132.5 304.6 136.7C303.5 140.1 299.1 143.5 294.8 142.4C289.9 141.1 274.3 138.1 269.3 137.3C253.5 134.8 239.5 136.6 229.4 141.2C219.3 145.8 213.5 152.8 212.1 160.7C211 166.9 211.8 171.4 213.4 174.9C215.1 178.4 218 181.5 222.3 184.4C231.3 190.5 244.2 194.4 259 198.9L259.4 199C273.6 203.3 289.5 208.1 300.1 216.5C306.9 220.8 312 226.2 315.1 233.4C318.2 240.5 319 248.7 317.4 257.1C314.7 273.6 304.5 284.4 290.7 290.4C283 293.6 274.3 295.4 264.9 295.9V314.7C264.9 319.1 261.3 322.7 256.9 322.7C252.5 322.7 248.9 319.1 248.9 314.7V295.4C246.6 295.2 244.3 294.9 242.1 294.5L242 294.5C232.5 292.1 217 287.7 206.6 284.1C204.5 283.4 202.6 282.8 201 282.3C196.8 280.9 194.6 276.3 195.1 272.1C197.4 267.9 201.9 265.7 206.1 267.1C207.1 267.7 210.1 268.4 212.4 269.2C222.1 272.8 236.6 277.4 244.5 278.7C260.5 281.2 274.4 279.9 284.4 275.7C294.1 271.5 300 264.7 301.7 255.3C302.8 248.5 302.1 243.6 300.4 239.7C298.7 235.9 295.8 232.5 291.6 229.4C282.7 222.1 269.7 218.8 254.8 214.3L252.1 213.8C239.4 209.7 224.3 205.1 213.3 197.7C207.4 193.7 202.2 188.5 198.1 181.7C195.7 174.8 194.8 166.9 196.4 158C198.9 143.5 209.2 132.8 222.8 126.7C230.5 123.2 239.3 121.1 248.9 120.4V101.3C248.9 96.91 252.5 93.33 256.9 93.33L256.9 93.33zM464 208C464 322.9 370.9 416 256 416C141.1 416 48 322.9 48 208C48 93.12 141.1 0 256 0C370.9 0 464 93.12 464 208zM256 16C149.1 16 64 101.1 64 208C64 314 149.1 400 256 400C362 400 448 314 448 208C448 101.1 362 16 256 16zM48 368H77.11C82.1 373.6 87.35 378.9 92.83 384H48C30.33 384 16 398.3 16 416V464C16 481.7 30.33 496 48 496H464C481.7 496 496 481.7 496 464V416C496 398.3 481.7 384 464 384H419.2C424.7 378.9 429.9 373.6 434.9 368H464C490.5 368 512 389.5 512 416V464C512 490.5 490.5 512 464 512H48C21.49 512 0 490.5 0 464V416C0 389.5 21.49 368 48 368zM448 440C452.4 440 456 443.6 456 448C456 452.4 452.4 456 448 456H64C59.58 456 56 452.4 56 448C56 443.6 59.58 440 64 440H448z"],
    "circle-dot": [512, 512, [128280, "dot-circle"], "f192", "M352 256C352 309 309 352 256 352C202.1 352 160 309 160 256C160 202.1 202.1 160 256 160C309 160 352 202.1 352 256zM256 176C211.8 176 176 211.8 176 256C176 300.2 211.8 336 256 336C300.2 336 336 300.2 336 256C336 211.8 300.2 176 256 176zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 16C123.5 16 16 123.5 16 256C16 388.5 123.5 496 256 496C388.5 496 496 388.5 496 256C496 123.5 388.5 16 256 16z"],
    "circle-down": [512, 512, [61466, "arrow-alt-circle-down"], "f358", "M348.7 256H304V152C304 138.7 293.3 128 280 128h-48C218.7 128 208 138.7 208 152V256H163.3C141.9 256 131.2 281.9 146.3 296.1l92.68 92.69C243.7 394.3 249.9 396.7 256 396.7s12.28-2.344 16.97-7.027l92.68-92.69C380.8 281.9 370.1 256 348.7 256zM354.3 285.7l-92.68 92.68C259.6 380.4 257.2 380.7 256 380.7s-3.617-.3047-5.656-2.344L157.7 285.7C154.2 282.2 155.3 278.4 155.9 276.9C156.5 275.5 158.5 272 163.3 272H224L223.1 152c0-4.414 3.589-8 8.001-8h48c4.412 0 7.999 3.586 7.999 8L288 272h60.68c4.824 0 6.777 3.453 7.393 4.938C356.7 278.4 357.8 282.2 354.3 285.7zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-down-left": [512, 512, [], "e107", "M324 154c-9.371-9.371-24.69-9.248-34.06 .123L216.6 227.6L184.1 195.1C169.9 180.8 144 191.5 144 212.9V344c.002 6.629 2.686 12.62 7.029 16.97S161.4 368 168 368h131.1c21.38 0 32.09-25.85 16.97-40.97l-31.6-31.6l73.42-73.42c9.373-9.371 9.494-24.69 .123-34.06L324 154zM346.7 210.6l-84.85 84.86l42.91 42.91c3.41 3.41 2.35 7.234 1.734 8.719C305.8 348.5 303.9 352 299.1 352H168c-2.883 0-4.781-1.469-5.656-2.344C161.5 348.8 160 346.9 160 344V212.9c0-4.824 3.451-6.777 4.936-7.395c1.486-.6133 5.309-1.672 8.719 1.738l42.91 42.91l84.85-84.85c3.119-3.121 8.193-3.121 11.31 0l33.94 33.94C349.8 202.4 349.8 207.5 346.7 210.6zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-down-right": [512, 512, [], "e108", "M327 195.1l-31.6 31.6L222 154.1C212.6 144.8 197.3 144.6 187.1 154L154 187.1C144.6 197.3 144.8 212.6 154.1 222l73.42 73.42l-31.6 31.6C180.8 342.1 191.5 368 212.9 368H344c6.627 0 12.63-2.688 16.97-7.031S367.1 350.6 368 344V212.9C368 191.5 342.1 180.8 327 195.1zM351.1 344c0 2.883-1.465 4.781-2.342 5.656C348.8 350.5 346.9 352 344 352H212.9c-4.826 0-6.775-3.453-7.393-4.938c-.6152-1.484-1.676-5.309 1.734-8.719l42.91-42.91L165.3 210.6c-3.121-3.117-3.121-8.191 0-11.31l33.94-33.94c3.119-3.121 8.193-3.121 11.31 0l84.85 84.85l42.91-42.91c3.41-3.41 7.232-2.352 8.719-1.738c1.484 .6172 4.936 2.57 4.936 7.395V344zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-e": [512, 512, [], "e109", "M344 144C348.4 144 352 140.4 352 136S348.4 128 344 128h-176C163.6 128 160 131.6 160 136v240C160 380.4 163.6 384 168 384h176c4.422 0 8-3.578 8-8s-3.578-8-8-8H176V264h120c4.422 0 8-3.578 8-8s-3.578-8-8-8H176V144H344zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-ellipsis": [512, 512, [], "e10a", "M256 240C264.8 240 272 247.2 272 256C272 264.8 264.8 272 256 272C247.2 272 240 264.8 240 256C240 247.2 247.2 240 256 240zM352 272C343.2 272 336 264.8 336 256C336 247.2 343.2 240 352 240C360.8 240 368 247.2 368 256C368 264.8 360.8 272 352 272zM160 240C168.8 240 176 247.2 176 256C176 264.8 168.8 272 160 272C151.2 272 144 264.8 144 256C144 247.2 151.2 240 160 240zM256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512zM496 256C496 123.5 388.5 16 256 16C123.5 16 16 123.5 16 256C16 388.5 123.5 496 256 496C388.5 496 496 388.5 496 256z"],
    "circle-ellipsis-vertical": [512, 512, [], "e10b", "M240 256C240 247.2 247.2 240 256 240C264.8 240 272 247.2 272 256C272 264.8 264.8 272 256 272C247.2 272 240 264.8 240 256zM272 160C272 168.8 264.8 176 256 176C247.2 176 240 168.8 240 160C240 151.2 247.2 144 256 144C264.8 144 272 151.2 272 160zM240 352C240 343.2 247.2 336 256 336C264.8 336 272 343.2 272 352C272 360.8 264.8 368 256 368C247.2 368 240 360.8 240 352zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 16C123.5 16 16 123.5 16 256C16 388.5 123.5 496 256 496C388.5 496 496 388.5 496 256C496 123.5 388.5 16 256 16z"],
    "circle-envelope": [512, 512, ["envelope-circle"], "e10c", "M352 160H160C142.3 160 128 174.3 128 192v128c0 17.67 14.33 32 32 32h192c17.67 0 32-14.33 32-32V192C384 174.3 369.7 160 352 160zM368 320c0 8.822-7.178 16-16 16H160c-8.822 0-16-7.178-16-16V236.7l94.13 47.06C243.7 286.6 249.8 288 256 288s12.28-1.406 17.88-4.203L368 236.7V320zM368 218.9l-101.3 50.63c-6.75 3.375-14.75 3.375-21.5 0L144 218.9V192c0-8.822 7.178-16 16-16h192c8.822 0 16 7.178 16 16V218.9zM256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256s256-114.6 256-256C512 114.6 397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-exclamation": [512, 512, ["exclamation-circle"], "f06a", "M256 304c4.406 0 8-3.578 8-8v-176c0-4.422-3.594-8-8-8S248 115.6 248 120v176C248 300.4 251.6 304 256 304zM256 352c-8.836 0-16 7.164-16 16S247.2 384 256 384s16-7.164 16-16S264.8 352 256 352zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-exclamation-check": [640, 512, [], "e10d", "M256 496C343.2 496 419.6 449.5 461.6 379.9C463.9 376.1 468.8 374.9 472.6 377.2C476.4 379.4 477.6 384.4 475.3 388.1C430.5 462.3 349 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C362.3 0 453.4 64.74 492.1 156.9C493.8 160.1 491.9 165.7 487.8 167.4C483.8 169.1 479.1 167.2 477.4 163.1C441 76.67 355.6 16 255.1 16C123.5 16 15.1 123.5 15.1 256C15.1 388.5 123.5 496 255.1 496L256 496zM264 296C264 300.4 260.4 304 256 304C251.6 304 248 300.4 248 296V136C248 131.6 251.6 128 256 128C260.4 128 264 131.6 264 136V296zM240 352C240 343.2 247.2 336 256 336C264.8 336 272 343.2 272 352C272 360.8 264.8 368 256 368C247.2 368 240 360.8 240 352zM613.7 186.3C616.8 189.5 616.8 194.5 613.7 197.7L485.7 325.7C482.5 328.8 477.5 328.8 474.3 325.7L410.3 261.7C407.2 258.5 407.2 253.5 410.3 250.3C413.5 247.2 418.5 247.2 421.7 250.3L480 308.7L602.3 186.3C605.5 183.2 610.5 183.2 613.7 186.3H613.7z"],
    "circle-f": [512, 512, [], "e10e", "M344 128h-176C163.6 128 160 131.6 160 136v240C160 380.4 163.6 384 168 384s8-3.578 8-8V272h136C316.4 272 320 268.4 320 264S316.4 256 312 256H176V144h168C348.4 144 352 140.4 352 136S348.4 128 344 128zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-g": [512, 512, [], "e10f", "M376 255.5H288c-4.406 0-8 3.578-8 8s3.594 8 8 8h79.69c-.8125 9.75-3.062 18.75-6.781 26.84C355.2 310.9 346.6 323.1 336 333.9c-41.13 41.67-108 44.89-152.4 7.078C159.4 320.3 145.3 291.6 144.1 260C142.8 228.8 154.8 198.3 176.8 176.3c42.06-42 109.6-43.92 153.8-4.297c3.312 2.984 8.375 2.703 11.31-.6094c2.938-3.297 2.656-8.359-.625-11.3c-50.59-45.3-127.8-43.13-175.8 4.891C140.3 190.2 126.7 225 128.1 260.6c1.469 36.09 17.5 68.95 45.16 92.52c23.75 20.22 53.13 30.2 82.5 30.2c33.34 0 66.69-12.88 91.63-38.25c11.88-12.05 21.59-25.92 28.09-40.11C381.1 292.7 384 278.7 384 263.5C384 259.1 380.4 255.5 376 255.5zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-h": [512, 512, [9405, "hospital-symbol"], "f47e", "M344 128c-4.406 0-8 3.578-8 8v112h-160v-112C176 131.6 172.4 128 168 128S160 131.6 160 136v240C160 380.4 163.6 384 168 384s8-3.578 8-8v-112h160v112c0 4.422 3.594 8 8 8S352 380.4 352 376v-240C352 131.6 348.4 128 344 128zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-half": [512, 512, [], "e110", "M224.1 1.971C241.6-.2109 256 14.33 256 31.1V480C256 497.7 241.6 512.2 224.1 510C97.75 494.3 0 386.6 0 255.1C0 125.4 97.75 17.69 224.1 1.971V1.971zM226 17.85C107.6 32.58 16 133.6 16 255.1C16 378.4 107.6 479.4 226 494.1C232.7 494.1 240 489.4 240 480V31.1C240 22.55 232.7 17.02 226 17.85V17.85z"],
    "circle-half-stroke": [512, 512, [9680, "adjust"], "f042", "M512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM264 495.9C392.8 491.6 496 385.9 496 256C496 126.1 392.8 20.35 264 16.13V495.9zM248 495.9V16.13C119.2 20.35 16 126.1 16 256C16 385.9 119.2 491.6 248 495.9z"],
    "circle-heart": [512, 512, ["heart-circle"], "f4c7", "M238.3 173L256 191L273.7 173C303.1 143.2 350.8 143.2 380.1 173C409.5 202.8 409.5 251.2 380.1 280.1L278.5 384.2C272.3 390.5 264.1 393.6 255.1 393.6C247.9 393.6 239.7 390.5 233.5 384.2L131.9 280.1C102.5 251.2 102.5 202.8 131.9 173C161.2 143.2 208.9 143.2 238.3 173H238.3zM226.9 184.2C203.8 160.8 166.4 160.8 143.3 184.2C120 207.8 120 246.2 143.3 269.8L244.9 372.1C248 376.1 252 377.6 256 377.6C259.1 377.6 263.1 376.1 267.1 372.1L368.7 269.8C391.1 246.2 391.1 207.8 368.7 184.2C345.6 160.8 308.2 160.8 285.1 184.2L256 213.8L226.9 184.2zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 16C123.5 16 16 123.5 16 256C16 388.5 123.5 496 256 496C388.5 496 496 388.5 496 256C496 123.5 388.5 16 256 16z"],
    "circle-i": [512, 512, [], "e111", "M344 144C348.4 144 352 140.4 352 136S348.4 128 344 128h-176C163.6 128 160 131.6 160 136S163.6 144 168 144h80v224h-80C163.6 368 160 371.6 160 376S163.6 384 168 384h176c4.406 0 8-3.578 8-8s-3.594-8-8-8h-80v-224H344zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-info": [512, 512, ["info-circle"], "f05a", "M288 352h-24.02l.0098-135.1c0-.0176 0 .0176 0 0C263.1 211.6 260.4 208 256 208H224c-4.406 0-8 3.594-8 8S219.6 224 224 224h23.98v128H224c-4.406 0-8 3.594-8 8S219.6 368 224 368h64c4.406 0 8-3.594 8-8S292.4 352 288 352zM255.9 176c8.822 0 16-7.178 16-16s-7.178-16-16-16s-16 7.178-16 16S247.1 176 255.9 176zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-j": [512, 512, [], "e112", "M344 128c-4.406 0-8 3.578-8 8v160c0 39.7-35.88 72-80 72s-80-32.3-80-72C176 291.6 172.4 288 168 288S160 291.6 160 296C160 344.5 203.1 384 256 384s96-39.47 96-88v-160C352 131.6 348.4 128 344 128zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-k": [512, 512, [], "e113", "M349.9 130.5c-3-3.203-8.062-3.438-11.31-.4062L176 281.3V136C176 131.6 172.4 128 168 128S160 131.6 160 136v240C160 380.4 163.6 384 168 384s8-3.578 8-8V303.1l59.73-55.54l101.9 133.3C339.2 382.9 341.6 384 344 384c1.703 0 3.406-.5313 4.859-1.641c3.516-2.688 4.172-7.703 1.5-11.22L247.5 236.6l101.9-94.79C352.7 138.8 352.9 133.8 349.9 130.5zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-l": [512, 512, [], "e114", "M344 368H176V136C176 131.6 172.4 128 168 128S160 131.6 160 136v240C160 380.4 163.6 384 168 384h176c4.422 0 8-3.578 8-8S348.4 368 344 368zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-left": [512, 512, [61840, "arrow-alt-circle-left"], "f359", "M360 208H256V163.3c0-21.38-25.85-32.09-40.97-16.97L122.3 239C117.7 243.7 115.3 249.9 115.3 256s2.344 12.28 7.029 16.97l92.68 92.69C230.1 380.8 256 370.1 256 348.7V304h104C373.3 304 384 293.3 384 280v-48C384 218.7 373.3 208 360 208zM368 280C368 284.4 364.4 288 360 288H240v60.68c0 4.824-3.453 6.777-4.938 7.395c-1.486 .6094-5.307 1.672-8.719-1.738L133.7 261.7C131.6 259.6 131.3 257.2 131.3 256s.3047-3.617 2.344-5.656l92.68-92.68c3.412-3.41 7.232-2.348 8.719-1.738C236.5 156.5 240 158.5 240 163.3V224h120c4.412 0 8 3.586 8 8V280zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-location-arrow": [512, 512, ["location-circle"], "f602", "M127.7 283C116 283 105.8 274.7 103.5 263.2C101.1 251.8 107.2 240.1 117.1 235.5L338.5 141C348 137.1 358.7 139.1 365.8 146.3C372.9 153.4 375 164.1 371 173.5L276.5 394C272.6 403.1 263.6 409 253.7 409C252.1 409 250.5 408.9 248.8 408.5C237.3 406.2 229 395.1 229 384.2V283H127.7zM119.2 259.1C119.1 264 123.6 267 127.7 267H244.1V384.2C244.1 388.3 247.9 391.1 251.9 392.9C252.5 392.9 253.1 393 253.7 393C257.2 393 260.4 390.9 261.8 387.7L356.3 167.2C357.8 163.8 356.1 160.1 354.5 157.6L354.4 157.5C352.1 155.2 348.4 154.3 344.7 155.8L124.3 250.2C120.5 251.8 118.3 256 119.2 259.1L119.2 259.1zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 16C123.5 16 16 123.5 16 256C16 388.5 123.5 496 256 496C388.5 496 496 388.5 496 256C496 123.5 388.5 16 256 16z"],
    "circle-m": [512, 512, [], "e115", "M378.4 128.4c-3.312-1.078-7 .2187-8.969 3.109L256 296.4L142.6 131.5c-1.984-2.891-5.625-4.188-8.969-3.109C130.3 129.4 128 132.5 128 136v240C128 380.4 131.6 384 136 384s8-3.578 8-8V161.8l105.4 153.3c3 4.344 10.19 4.344 13.19 0L368 161.8V376c0 4.422 3.578 8 8 8S384 380.4 384 376v-240C384 132.5 381.7 129.4 378.4 128.4zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-microphone": [512, 512, ["microphone-circle"], "e116", "M256 320c35.3 0 64-28.7 64-64V160c0-35.3-28.7-64-64-64S192 124.7 192 160v96C192 291.3 220.7 320 256 320zM208 160c0-26.47 21.53-48 48-48s48 21.53 48 48v96c0 26.47-21.53 48-48 48S208 282.5 208 256V160zM360 216C355.6 216 352 219.6 352 224v32c0 52.94-43.06 96-96 96S160 308.9 160 256V224c0-4.422-3.578-8-8-8S143.1 219.6 143.1 224L144 256c0 59.01 46.04 107 104 111.2V416c0 4.422 3.578 8 8 8s8-3.578 8-8v-48.81C321.1 363 368 315 368 256V224C368 219.6 364.4 216 360 216zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-microphone-lines": [512, 512, ["microphone-circle-alt"], "e117", "M256 320c35.3 0 64-28.7 64-64V160c0-35.3-28.7-64-64-64S192 124.7 192 160v96C192 291.3 220.7 320 256 320zM208 160c0-26.47 21.53-48 48-48s48 21.53 48 48L256 159.1c-4.422 0-8 3.578-8 8S251.6 176 256 176h48V224L256 223.1c-4.422 0-8 3.578-8 8S251.6 240 256 240h48V256c0 26.47-21.53 48-48 48S208 282.5 208 256V160zM360 216C355.6 216 352 219.6 352 224v32c0 52.94-43.06 96-96 96S160 308.9 160 256V224c0-4.422-3.578-8-8-8S144 219.6 144 224v32c0 59.01 46.04 107 104 111.2V416c0 4.422 3.578 8 8 8s8-3.578 8-8v-48.81C321.1 363 368 315 368 256V224C368 219.6 364.4 216 360 216zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-minus": [512, 512, ["minus-circle"], "f056", "M352 248C356.4 248 360 251.6 360 256C360 260.4 356.4 264 352 264H160C155.6 264 152 260.4 152 256C152 251.6 155.6 248 160 248H352zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 16C123.5 16 16 123.5 16 256C16 388.5 123.5 496 256 496C388.5 496 496 388.5 496 256C496 123.5 388.5 16 256 16z"],
    "circle-n": [512, 512, [], "e118", "M360 128C355.6 128 352 131.6 352 136v218.5L158 130.8C155.9 128.3 152.3 127.4 149.2 128.5C146.1 129.7 144 132.7 144 136v240C144 380.4 147.6 384 152 384S160 380.4 160 376V157.5l193.1 223.8C355.5 383 357.7 384 360 384c.9375 0 1.891-.1719 2.797-.5C365.9 382.3 368 379.3 368 376v-240C368 131.6 364.4 128 360 128zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-nodes": [512, 512, [], "e4e2", "M480 79.1C480 124.2 444.2 159.1 400 159.1C397.9 159.1 395.7 159.9 393.6 159.8L358.1 355.1C353.1 353.6 347.8 352.7 342.4 352.2L377.9 156.9C356.7 150.8 339.1 136.2 329 116.1L156.9 185.9C158.9 192.9 160 200.3 160 208C160 225.3 154.5 241.3 145.2 254.4L281.4 373.6C277.5 377.2 273.9 381.2 270.8 385.6L134.6 266.4C120.3 279.8 101.1 288 80 288C35.82 288 0 252.2 0 208C0 163.8 35.82 128 80 128C110.8 128 137.6 145.4 150.9 171L323.1 102.1C321.1 95.11 320 87.68 320 80C320 35.82 355.8 0 400 0C444.2 0 480 35.82 480 80L480 79.1zM400 15.1C364.7 15.1 336 44.65 336 79.1C336 115.3 364.7 143.1 400 143.1C435.3 143.1 464 115.3 464 79.1C464 44.65 435.3 15.1 400 15.1zM80 271.1C115.3 271.1 144 243.3 144 207.1C144 172.7 115.3 143.1 80 143.1C44.65 143.1 16 172.7 16 207.1C16 243.3 44.65 271.1 80 271.1zM416 432C416 476.2 380.2 512 336 512C291.8 512 256 476.2 256 432C256 387.8 291.8 352 336 352C380.2 352 416 387.8 416 432zM336 368C300.7 368 272 396.7 272 432C272 467.3 300.7 496 336 496C371.3 496 400 467.3 400 432C400 396.7 371.3 368 336 368z"],
    "circle-notch": [512, 512, [], "f1ce", "M199.7 14.28C200.9 18.55 198.3 22.93 194.1 24.07C91.53 51.38 16 144.9 16 256C16 388.6 123.5 496 256 496C388.5 496 496 388.6 496 256C496 144.9 420.5 51.38 317.9 24.07C313.7 22.93 311.1 18.55 312.3 14.28C313.4 10.01 317.8 7.47 322.1 8.607C431.4 37.74 512 137.4 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 137.4 80.58 37.74 189.9 8.607C194.2 7.47 198.6 10.01 199.7 14.28H199.7z"],
    "circle-o": [512, 512, [], "e119", "M256 128C185.4 128 128 185.4 128 256s57.42 128 128 128s128-57.42 128-128S326.6 128 256 128zM256 368c-61.75 0-112-50.25-112-112S194.3 144 256 144s112 50.25 112 112S317.8 368 256 368zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-p": [512, 512, [], "e11a", "M280 128h-112C163.6 128 160 131.6 160 136v240C160 380.4 163.6 384 168 384s8-3.578 8-8V304h104c48.53 0 88-39.47 88-88S328.5 128 280 128zM280 288H176V144h104C319.7 144 352 176.3 352 216S319.7 288 280 288zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-parking": [512, 512, ["parking-circle"], "f615", "M288 128C336.6 128 376 167.4 376 216C376 264.6 336.6 304 288 304H192V376C192 380.4 188.4 384 184 384C179.6 384 176 380.4 176 376V144C176 135.2 183.2 128 192 128H288zM360 216C360 176.2 327.8 144 288 144H192V288H288C327.8 288 360 255.8 360 216zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 16C123.5 16 16 123.5 16 256C16 388.5 123.5 496 256 496C388.5 496 496 388.5 496 256C496 123.5 388.5 16 256 16z"],
    "circle-pause": [512, 512, [62092, "pause-circle"], "f28b", "M320 152c-4.422 0-8 3.578-8 8v192c0 4.422 3.578 8 8 8s8-3.578 8-8V160C328 155.6 324.4 152 320 152zM192 152C187.6 152 184 155.6 184 160v192c0 4.422 3.578 8 8 8S200 356.4 200 352V160C200 155.6 196.4 152 192 152zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-phone": [512, 512, ["phone-circle"], "e11b", "M377.7 296.3l-54.22-23.23c-9.594-4.141-21.05-1.406-27.61 6.766l-17.92 21.89C249.4 286.3 225.7 262.6 210.4 234.1l21.89-17.94c8.094-6.625 10.89-17.94 6.797-27.58L215.8 134.3C211.2 123.8 199.8 118.1 188.7 120.6L138.3 132.2C127.5 134.7 120 144.2 120 155.3C120 285.8 226.2 392 356.8 392c11.08 0 20.55-7.531 23.03-18.31l11.62-50.39C393.1 312.2 388.2 300.8 377.7 296.3zM364.2 370.1C363.4 373.6 360.3 376 356.8 376C235 376 136 276.1 136 155.3c0-3.578 2.422-6.625 5.906-7.422l50.39-11.62C192.9 136.1 193.4 136 194 136c3 0 5.812 1.781 7.047 4.625l23.27 54.25c1.312 3.109 .4062 6.766-2.219 8.906L190.3 229.8l2.781 5.703c17.7 36.06 47.33 65.67 83.42 83.41l5.703 2.797l26.08-31.88c2.094-2.609 5.75-3.531 8.859-2.141l54.22 23.23c3.406 1.469 5.266 5.141 4.438 8.734L364.2 370.1zM256 0c-141.4 0-256 114.6-256 256c0 141.4 114.6 256 256 256s256-114.6 256-256C512 114.6 397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-phone-flip": [512, 512, ["phone-circle-alt"], "e11c", "M373.7 132.2L323.3 120.6c-11.09-2.484-22.47 3.172-27.09 13.7l-23.27 54.31c-4.094 9.609-1.297 20.94 6.781 27.53l21.91 17.95c-15.39 28.5-39.08 52.19-67.61 67.58L216.2 279.8C209.5 271.6 198.1 268.8 188.5 273L134.3 296.3c-10.5 4.531-16.28 15.91-13.7 27.03l11.62 50.39C134.7 384.5 144.2 392 155.3 392C285.8 392 392 285.8 392 155.3C392 144.2 384.5 134.7 373.7 132.2zM155.3 376c-3.578 0-6.641-2.422-7.438-5.906l-11.62-50.39C135.4 316.1 137.2 312.5 140.6 310.1l54.25-23.27c3.156-1.359 6.75-.4219 8.891 2.203l26.03 31.83l5.703-2.797c36.08-17.72 65.72-47.34 83.44-83.41l2.797-5.703l-31.84-26.08c-2.609-2.125-3.5-5.781-2.188-8.859l23.23-54.22c1.516-3.453 5.203-5.344 8.797-4.484l50.39 11.62C373.6 148.6 376 151.7 376 155.3C376 276.1 276.1 376 155.3 376zM256 0c-141.4 0-256 114.6-256 256c0 141.4 114.6 256 256 256s256-114.6 256-256C512 114.6 397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-phone-hangup": [512, 512, ["phone-circle-down"], "e11d", "M423.4 231.1c-92.31-92.31-242.5-92.31-334.8 0c-7.844 7.844-9.213 19.87-3.324 29.22l27.39 43.83c6.088 9.602 18.13 13.64 28.85 9.469l54.86-21.95c9.689-3.9 15.72-13.89 14.67-24.26L208.2 239.2c31.04-9.27 64.54-9.27 95.59 .0215l-2.807 28.09c-1.127 10.52 4.949 20.55 14.72 24.37l54.79 21.91c10.63 4.221 22.76 .2656 28.8-9.424l27.41-43.85C432.6 250.9 431.2 238.9 423.4 231.1zM413.2 251.8l-27.41 43.85c-1.957 3.125-5.855 4.396-9.293 3.037l-54.81-21.91c-3.193-1.271-5.072-4.475-4.729-7.846l4.098-40.91l-6.01-2.055C276.1 213 235.1 212.1 197 225.1l-6.01 2.057L195.1 268.1c.3418 3.348-1.613 6.562-4.717 7.811L135.6 298.7C132.1 300.1 128.2 298.8 126.2 295.7L98.82 251.8C96.93 248.8 97.38 244.9 99.91 242.4c86.07-86.07 226.1-86.07 312.2 0C414.6 244.9 415.1 248.8 413.2 251.8zM256 0c-141.4 0-256 114.6-256 256c0 141.4 114.6 256 256 256s256-114.6 256-256C512 114.6 397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-play": [512, 512, [61469, "play-circle"], "f144", "M356.5 235.5C363.6 239.9 368 247.6 368 256C368 264.4 363.6 272.1 356.5 276.5L212.5 364.5C205.1 369 195.8 369.2 188.3 364.9C180.7 360.7 176 352.7 176 344V167.1C176 159.3 180.7 151.3 188.3 147.1C195.8 142.8 205.1 142.1 212.5 147.5L356.5 235.5zM192 168V344C192 346.9 193.6 349.6 196.1 350.1C198.6 352.4 201.7 352.3 204.2 350.8L348.2 262.8C350.6 261.4 352 258.8 352 256C352 253.2 350.6 250.6 348.2 249.2L204.2 161.2C201.7 159.7 198.6 159.6 196.1 161C193.6 162.4 192 165.1 192 168V168zM0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM256 496C388.5 496 496 388.5 496 256C496 123.5 388.5 16 256 16C123.5 16 16 123.5 16 256C16 388.5 123.5 496 256 496z"],
    "circle-plus": [512, 512, ["plus-circle"], "f055", "M248 352V264H160C155.6 264 152 260.4 152 256C152 251.6 155.6 248 160 248H248V160C248 155.6 251.6 152 256 152C260.4 152 264 155.6 264 160V248H352C356.4 248 360 251.6 360 256C360 260.4 356.4 264 352 264H264V352C264 356.4 260.4 360 256 360C251.6 360 248 356.4 248 352zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 16C123.5 16 16 123.5 16 256C16 388.5 123.5 496 256 496C388.5 496 496 388.5 496 256C496 123.5 388.5 16 256 16z"],
    "circle-q": [512, 512, [], "e11e", "M256 128C185.4 128 128 185.4 128 256s57.41 128 128 128c32.41 0 61.7-12.49 84.27-32.41l30.07 30.07C371.9 383.2 373.9 384 376 384s4.094-.7813 5.656-2.344c3.125-3.125 3.125-8.188 0-11.31l-30.07-30.07C371.5 317.7 384 288.4 384 256C384 185.4 326.6 128 256 128zM340.3 328.1l-38.62-38.62c-3.125-3.125-8.188-3.125-11.31 0s-3.125 8.188 0 11.31l38.62 38.62C309.3 357.3 283.1 368 256 368c-61.75 0-112-50.25-112-112S194.3 144 256 144s112 50.25 112 112C368 283.1 357.3 309.3 340.3 328.1zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-quarter": [512, 512, [], "e11f", "M224.1 1.971C241.6-.2109 255.1 14.33 255.1 31.1V223.1C255.1 241.7 241.7 255.1 223.1 255.1H31.1C14.33 255.1-.2112 241.6 1.972 224.1C16.39 108.2 108.2 16.39 224.1 1.971V1.971zM31.1 239.1H223.1C232.8 239.1 239.1 232.8 239.1 223.1V31.1C239.1 22.55 232.7 17.02 226 17.85C117.5 31.36 31.36 117.5 17.85 226C17.02 232.7 22.55 239.1 31.1 239.1V239.1z"],
    "circle-quarters": [512, 512, [], "e3f8", "M256 0c-141.4 0-256 114.6-256 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 16c63.4 0 121.1 24.58 163.1 64.73L256 244.7L92.05 80.73C134.9 40.58 192.6 16 256 16zM16 256c0-63.4 24.58-121.1 64.73-163.1L244.7 256l-163.1 163.1C40.58 377.1 16 319.4 16 256zM256 496c-63.4 0-121.1-24.58-163.1-64.73l163.1-163.1l163.1 163.1C377.1 471.4 319.4 496 256 496zM431.3 419.1L267.3 256l163.1-163.1C471.4 134.9 496 192.6 496 256S471.4 377.1 431.3 419.1z"],
    "circle-question": [512, 512, [62108, "question-circle"], "f059", "M288.6 128H223.4C188.4 128 160 156.4 160 191.4V202c0 4.422 3.594 8 8 8s8-3.578 8-8V191.4C176 165.3 197.3 144 223.4 144h65.19C314.7 144 336 165.3 336 191.4c0 17.2-9.344 33.08-24.06 41.27L245.8 265.7C236.3 270.1 230.4 281 230.4 291.9V312c0 4.422 3.593 8 8 8c4.406 0 8-3.578 8-8V291.9c0-5.078 2.75-9.766 6.875-12.06l66.09-33.05C339.5 235.7 352 214.4 352 191.4C352 156.4 323.6 128 288.6 128zM240 352C231.2 352 224 359.2 224 368S231.2 384 240 384s16-7.164 16-16S248.8 352 240 352zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-r": [512, 512, [], "e120", "M368 208C368 163.9 332.1 128 288 128H168C163.6 128 160 131.6 160 136v240C160 380.4 163.6 384 168 384s8-3.578 8-8V288h100.2l77.6 93.13C355.4 383 357.7 384 360 384c1.812 0 3.625-.6094 5.125-1.859c3.406-2.828 3.844-7.875 1.031-11.27l-69.77-83.72C336.5 282.9 368 249.2 368 208zM288 272H176v-128H288c35.28 0 64 28.7 64 64S323.3 272 288 272zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-radiation": [512, 512, [9762, "radiation-alt"], "f7ba", "M208 256c0-4.422-3.578-8-8-8H121c-2.281 0-4.359-.9375-5.875-2.656C113.5 243.5 112.8 240.1 113.1 238.4C117.6 201.5 136.3 168.1 165.8 144.4c1.906-1.547 4.422-2.219 6.797-1.812c2.281 .3906 4.219 1.672 5.437 3.609l41.64 66.7c2.344 3.766 7.344 4.891 11.02 2.547c3.75-2.328 4.891-7.266 2.547-11.02L191.6 137.7C187.9 131.9 181.1 127.9 175.2 126.8C168.3 125.6 161.2 127.5 155.7 131.9C123 158.3 102.3 195.4 97.2 236.5C96.33 243.5 98.52 250.7 103.2 255.9C107.7 261.1 114.2 264 121 264H200C204.4 264 208 260.4 208 256zM224 256c0 17.64 14.36 32 32 32s32-14.36 32-32s-14.36-32-32-32S224 238.4 224 256zM256 240c8.828 0 16 7.172 16 16S264.8 272 256 272S240 264.8 240 256S247.2 240 256 240zM256 16C123.5 16 16 123.5 16 256s107.5 240 240 240s240-107.5 240-240S388.5 16 256 16zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM356.4 132c-5.484-4.422-12.58-6.297-19.5-5.172c-6.766 1.141-12.72 5.109-16.36 10.91l-41.72 66.67c-2.344 3.75-1.203 8.688 2.531 11.03c3.781 2.359 8.703 1.234 11.03-2.531l41.72-66.67c1.219-1.953 3.156-3.234 5.438-3.625c2.328-.3438 4.859 .2656 6.797 1.828c29.36 23.72 48.03 57.09 52.58 93.97c.3125 2.547-.4531 5.062-2.094 6.922C395.3 247.1 393.2 248 390.1 248H312c-4.422 0-8 3.578-8 8s3.578 8 8 8h78.95c6.828 0 13.33-2.938 17.86-8.062c4.672-5.281 6.859-12.39 5.984-19.48C409.8 195.4 389 158.3 356.4 132zM292.4 299.1c-2.328-3.688-7.25-4.812-11.03-2.531c-3.734 2.344-4.875 7.281-2.531 11.03l41.78 66.75c1.188 1.938 1.5 4.188 .8594 6.344c-.6875 2.375-2.438 4.375-4.781 5.5c-38.67 18.31-82.86 18.31-121.3 .0313c-2.344-1.125-4.094-3.125-4.781-5.5c-.6406-2.156-.3281-4.406 .875-6.312l41.73-66.81c2.344-3.75 1.203-8.688-2.547-11.03C226.1 294.3 221.1 295.4 219.6 299.1l-41.73 66.81c-3.656 5.844-4.609 12.69-2.672 19.31c1.969 6.75 6.812 12.38 13.28 15.44C209.9 410.8 232.6 416 256 416c23.34 0 46.08-5.156 67.56-15.38c6.453-3.062 11.3-8.688 13.27-15.44c1.938-6.594 1-13.47-2.656-19.31L292.4 299.1z"],
    "circle-right": [512, 512, [61838, "arrow-alt-circle-right"], "f35a", "M296.1 146.3C281.9 131.2 256 141.9 256 163.3V208H152C138.7 208 128 218.7 128 232v48C128 293.3 138.7 304 152 304H256v44.69c0 21.38 25.85 32.09 40.97 16.97l92.68-92.69C394.3 268.3 396.7 262.1 396.7 256s-2.344-12.28-7.029-16.97L296.1 146.3zM378.3 261.7l-92.68 92.68c-3.412 3.41-7.232 2.348-8.719 1.738C275.5 355.5 272 353.5 272 348.7V288H152C147.6 288 144 284.4 144 280v-48C144 227.6 147.6 224 152 224h120V163.3c0-4.824 3.453-6.777 4.938-7.395c1.486-.6094 5.307-1.672 8.719 1.738l92.68 92.68C380.4 252.4 380.7 254.8 380.7 256S380.4 259.6 378.3 261.7zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-s": [512, 512, [], "e121", "M258 248.3C202.8 233.9 169.8 222.3 177 184.1c2.156-11.48 8.875-21.16 19.41-27.98c16.31-10.58 50.5-19.58 120.6-2.719c4.281 .9844 8.625-1.609 9.656-5.906S325 138.9 320.7 137.8c-60.66-14.59-105.3-12.95-133 4.844C173.4 151.1 164.3 165.2 161.3 181.1c-10.5 55.64 44.34 70 92.72 82.67c55.25 14.47 88.25 26 81.03 64.23c-2.594 13.73-9.594 23.66-21.44 30.36c-33.53 18.91-95.72 7-142.8-10.42c-4.031-1.531-8.75 .5781-10.28 4.719s.5625 8.75 4.719 10.28c16.78 6.219 61.28 21.06 103.1 21.06c19.25 0 37.94-3.141 53.09-11.7c15.97-9.047 25.81-22.94 29.31-41.33C361.3 275.4 306.4 261 258 248.3zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-small": [320, 512, [], "e122", "M0 256C0 167.6 71.63 96 160 96C248.4 96 320 167.6 320 256C320 344.4 248.4 416 160 416C71.63 416 0 344.4 0 256zM160 400C239.5 400 304 335.5 304 256C304 176.5 239.5 112 160 112C80.47 112 16 176.5 16 256C16 335.5 80.47 400 160 400z"],
    "circle-sort": [512, 512, ["sort-circle"], "e030", "M335.8 288H176.2C166.2 288 157.7 293.7 153.9 302.9c-3.812 9.156-1.844 19.22 5.156 26.22l80.09 80C243.8 413.5 249.8 416 256 416c6.219 0 12.44-2.531 17.12-7.031l79.84-79.88c7-7 8.969-17.06 5.156-26.22C354.3 293.7 345.8 288 335.8 288zM341.7 317.8l-79.72 79.75c-3.219 3.125-8.531 3.062-11.62 .125L170.3 317.8C166.8 314.3 168.2 310.2 168.7 309C169.1 307.8 171.1 304 176.2 304h159.7c5.031 0 7.031 3.812 7.5 5C343.8 310.2 345.2 314.3 341.7 317.8zM273 102.9c-9.156-8.781-24.47-8.969-34 .125L159 182.9c-7 7-8.969 17.06-5.156 26.22C157.7 218.3 166.2 224 176.2 224h159.7c9.938 0 18.47-5.688 22.28-14.88c3.812-9.156 1.844-19.22-5.156-26.22L273 102.9zM343.3 203C342.9 204.2 340.9 208 335.8 208H176.2c-5.031 0-7.031-3.812-7.5-5c-.5-1.188-1.812-5.281 1.688-8.781l79.84-79.75C251.8 112.9 253.9 112 256 112c2.125 0 4.312 .9062 5.812 2.344l79.84 79.88C345.2 197.7 343.8 201.8 343.3 203zM256 0c-141.4 0-256 114.6-256 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-sort-down": [512, 512, ["sort-circle-down"], "e031", "M335.8 288H176.2C166.2 288 157.7 293.7 153.9 302.9c-3.812 9.156-1.844 19.22 5.156 26.22l80.09 80C243.8 413.5 249.8 416 256 416c6.219 0 12.44-2.531 17.12-7.031l79.84-79.88c7-7 8.969-17.06 5.156-26.22C354.3 293.7 345.8 288 335.8 288zM341.7 317.8l-79.72 79.75c-3.219 3.125-8.531 3.062-11.62 .125L170.3 317.8C166.8 314.3 168.2 310.2 168.7 309C169.1 307.8 171.1 304 176.2 304h159.7c5.031 0 7.031 3.812 7.5 5C343.8 310.2 345.2 314.3 341.7 317.8zM273 102.9C263.9 94.13 248.5 93.97 239 103L154.4 186.3C151.3 189.4 151.2 194.5 154.3 197.6c3.094 3.125 8.156 3.188 11.31 .0625l84.56-83.22c3.344-3.219 8.625-3 11.66-.0938l84.53 83.31C347.9 199.2 349.1 200 352 200c2.062 0 4.125-.7813 5.688-2.375c3.125-3.156 3.062-8.219-.0625-11.31L273 102.9zM256 0c-141.4 0-256 114.6-256 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-sort-up": [512, 512, ["sort-circle-up"], "e032", "M346.4 314.3l-84.56 83.22c-3.344 3.219-8.625 3-11.66 .0938L165.6 314.3C164.1 312.8 162 312 160 312c-2.062 0-4.125 .7813-5.688 2.375c-3.125 3.156-3.062 8.219 .0625 11.31L239 409.1c9.125 8.781 24.47 8.938 33.97-.0938l84.66-83.31c3.125-3.094 3.188-8.156 .0625-11.31C354.6 311.3 349.5 311.2 346.4 314.3zM176.2 224h159.7c9.938 0 18.47-5.688 22.28-14.88c3.812-9.156 1.844-19.22-5.156-26.22l-80.09-80C268.2 98.47 262.3 95.1 256 95.1c-6.219 0-12.44 2.531-17.12 7.031L159 182.9c-7 7-8.969 17.06-5.156 26.22C157.7 218.3 166.2 224 176.2 224zM170.3 194.2l79.72-79.75c3.219-3.125 8.531-3.062 11.62-.125l79.97 79.88c3.5 3.5 2.188 7.594 1.688 8.781C342.9 204.2 340.9 208 335.8 208H176.2c-5.031 0-7.031-3.812-7.5-5C168.2 201.8 166.8 197.7 170.3 194.2zM256 0c-141.4 0-256 114.6-256 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-star": [512, 512, ["star-circle"], "e123", "M387.6 198.1C393.7 199 398.7 203.2 400.6 209C402.4 214.8 400.9 221.2 396.5 225.4L337.9 282.6L351.7 363.3C352.7 369.3 350.3 375.4 345.3 378.1C340.4 382.6 333.9 383 328.5 380.2L256 342.1L183.5 380.2C178.1 383 171.6 382.6 166.7 378.1C161.7 375.4 159.3 369.3 160.3 363.3L174.1 282.6L115.5 225.4C111.1 221.2 109.6 214.8 111.4 209C113.3 203.2 118.3 199 124.4 198.1L205.4 186.4L241.7 112.9C244.3 107.5 249.9 103.1 256 103.1C262.1 103.1 267.7 107.5 270.3 112.9L306.6 186.4L387.6 198.1zM126.7 213.1L185.3 271.1C189.1 274.8 190.8 280.1 189.9 285.3L176.1 366L248.6 327.9C253.2 325.5 258.8 325.5 263.4 327.9L335.9 366L322.1 285.3C321.2 280.1 322.9 274.8 326.7 271.1L385.3 213.1L304.3 202.2C299.1 201.4 294.6 198.2 292.2 193.4L256 120L219.8 193.4C217.4 198.2 212.9 201.4 207.7 202.2L126.7 213.1zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 16C123.5 16 16 123.5 16 256C16 388.5 123.5 496 256 496C388.5 496 496 388.5 496 256C496 123.5 388.5 16 256 16z"],
    "circle-stop": [512, 512, [62094, "stop-circle"], "f28d", "M328 160h-144C170.8 160 160 170.8 160 184v144C160 341.2 170.8 352 184 352h144c13.2 0 24-10.8 24-24v-144C352 170.8 341.2 160 328 160zM336 328c0 4.336-3.664 8-8 8h-144c-4.336 0-8-3.664-8-8v-144c0-4.336 3.664-8 8-8h144c4.336 0 8 3.664 8 8V328zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-t": [512, 512, [], "e124", "M376 144h-240C131.6 144 128 147.6 128 152S131.6 160 136 160h112v232c0 4.422 3.594 8 8 8s8-3.578 8-8V160h112C380.4 160 384 156.4 384 152S380.4 144 376 144zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-three-quarters": [512, 512, [], "e125", "M224.1 1.971C241.6-.2109 256 14.33 256 31.1V255.1H480C497.7 255.1 512.2 270.4 510 287.9C494.3 414.2 386.6 512 256 512C114.6 512 0 397.4 0 255.1C0 125.4 97.75 17.69 224.1 1.971V1.971zM240 271.1V31.1C240 22.55 232.7 17.02 226 17.85C107.6 32.58 16 133.6 16 255.1C16 388.5 123.5 496 256 496C378.4 496 479.4 404.4 494.2 285.1C494.1 279.3 489.4 271.1 480 271.1H240z"],
    "circle-trash": [512, 512, ["trash-circle"], "e126", "M196 160L217.6 131.2C219.1 129.2 221.5 128 224 128H288C290.5 128 292.9 129.2 294.4 131.2L316 160H352C356.4 160 360 163.6 360 168C360 172.4 356.4 176 352 176H342.9L330.1 354.3C328.9 371 314.1 384 298.2 384H213.8C197 384 183.1 371 181.9 354.3L169.1 176H160C155.6 176 152 172.4 152 168C152 163.6 155.6 160 160 160H196zM216 160H296L284 144H228L216 160zM326.8 176H185.2L197.8 353.1C198.4 361.5 205.4 368 213.8 368H298.2C306.6 368 313.6 361.5 314.2 353.1L326.8 176zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 16C123.5 16 16 123.5 16 256C16 388.5 123.5 496 256 496C388.5 496 496 388.5 496 256C496 123.5 388.5 16 256 16z"],
    "circle-u": [512, 512, [], "e127", "M360 144C355.6 144 352 147.6 352 152v141.8C352 343.5 308.9 384 256 384s-96-40.45-96-90.19V152C160 147.6 156.4 144 152 144S144 147.6 144 152v141.8C144 352.4 194.3 400 256 400s112-47.64 112-106.2V152C368 147.6 364.4 144 360 144zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-up": [512, 512, [61467, "arrow-alt-circle-up"], "f35b", "M272.1 122.3C268.3 117.7 262.1 115.3 256 115.3S243.7 117.7 239 122.3L146.3 215C131.2 230.1 141.9 256 163.3 256H208v104C208 373.3 218.7 384 232 384h48c13.25 0 24-10.74 24-24V256h44.69c21.38 0 32.09-25.85 16.97-40.97L272.1 122.3zM356.1 235.1C355.5 236.5 353.5 240 348.7 240H288l.0006 120c0 4.414-3.589 8-8.001 8h-48c-4.412 0-7.999-3.586-7.999-8L224 240H163.3c-4.824 0-6.777-3.453-7.393-4.938c-.6133-1.484-1.676-5.305 1.736-8.719l92.68-92.68C252.4 131.6 254.8 131.3 256 131.3s3.617 .3047 5.656 2.344l92.68 92.68C357.8 229.8 356.7 233.6 356.1 235.1zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-up-left": [512, 512, [], "e128", "M284.4 216.6l31.6-31.6C331.2 169.9 320.5 144 299.1 144H168c-6.627 0-12.63 2.688-16.97 7.031S144 161.4 144 168v131.1c0 21.38 25.85 32.09 40.97 16.97l31.6-31.6l73.42 73.41c9.373 9.371 24.69 9.497 34.06 .126l33.94-33.94c9.371-9.375 9.25-24.69-.123-34.06L284.4 216.6zM346.7 312.7l-33.94 33.94c-3.119 3.121-8.193 3.121-11.31 0L216.6 261.8L173.7 304.7C170.2 308.1 166.4 307.1 164.9 306.5C163.5 305.9 160 303.9 160 299.1V168c0-2.883 1.465-4.781 2.342-5.656C163.2 161.5 165.1 160 168 160h131.1c4.826 0 6.775 3.453 7.393 4.938c.6152 1.484 1.676 5.309-1.734 8.719l-42.91 42.91l84.85 84.86C349.8 304.5 349.8 309.6 346.7 312.7zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-up-right": [512, 512, [], "e129", "M344 144H212.9c-21.38 0-32.09 25.85-16.97 40.97l31.6 31.6L154.1 289.1c-9.373 9.371-9.494 24.69-.123 34.06l33.94 33.94c9.371 9.371 24.69 9.245 34.06-.126l73.42-73.41l31.6 31.6C342.1 331.2 368 320.5 368 299.1V168c-.002-6.629-2.686-12.62-7.029-16.97S350.6 144 344 144zM351.1 299.1c0 4.824-3.451 6.777-4.936 7.395c-1.486 .6133-5.309 1.672-8.719-1.738l-42.91-42.91l-84.85 84.85c-3.119 3.121-8.193 3.121-11.31 0L165.3 312.7c-3.121-3.121-3.121-8.195 0-11.31l84.85-84.86L207.3 173.7C203.9 170.2 204.9 166.4 205.5 164.9C206.2 163.5 208.1 160 212.9 160H344c2.883 0 4.781 1.469 5.656 2.344C350.5 163.2 351.1 165.1 351.1 168V299.1zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-user": [512, 512, [62142, "user-circle"], "f2bd", "M256 128C211.8 128 176 163.8 176 208S211.8 288 256 288c44.18 0 80-35.82 80-80S300.2 128 256 128zM256 272c-35.29 0-64-28.71-64-64s28.71-64 64-64s64 28.71 64 64S291.3 272 256 272zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-54.04 0-103.8-18.17-143.1-48.43C112.3 386 162.4 336 224 336h64c61.61 0 111.7 50.02 111.1 111.6C359.8 477.8 310 496 256 496zM414.7 435.5C408.4 370.8 354.4 320 288 320H224c-66.42 0-120.4 50.78-126.7 115.5C47.55 391.5 16 327.4 16 256c0-132.3 107.7-240 240-240s240 107.7 240 240C496 327.4 464.4 391.5 414.7 435.5z"],
    "circle-v": [512, 512, [], "e12a", "M368.8 148.4L256 374.1L143.2 148.4C141.2 144.5 136.4 142.9 132.4 144.8C128.5 146.8 126.9 151.6 128.8 155.6l120 240C250.2 398.3 252.1 400 256 400s5.797-1.719 7.156-4.422l120-240c1.969-3.953 .375-8.75-3.578-10.73C375.6 142.9 370.8 144.5 368.8 148.4zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-video": [512, 512, ["video-circle"], "e12b", "M288 160H160C142.3 160 128 174.3 128 192v128c0 17.67 14.33 32 32 32h128c17.67 0 32-14.33 32-32V192C320 174.3 305.7 160 288 160zM304 320c0 8.822-7.178 16-16 16H160c-8.822 0-16-7.178-16-16V192c0-8.822 7.178-16 16-16h128c8.822 0 16 7.178 16 16V320zM392.9 182.6l-52.44 26.22c-3.969 1.969-5.562 6.781-3.594 10.72c2 4 6.938 5.531 10.72 3.594L400 196.9v118.1l-52.44-26.22c-3.812-1.906-8.719-.375-10.72 3.594c-1.969 3.938-.375 8.75 3.594 10.72l52.44 26.22C395.1 330.5 397.6 331.1 400 331.1c2.938 0 5.812-.7813 8.406-2.375C413.2 325.8 416 320.7 416 315.1V196.9c0-5.594-2.844-10.69-7.594-13.62S397.8 180.1 392.9 182.6zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-w": [512, 512, [], "e12c", "M394.3 144.3c-4.141-1.266-8.688 1.125-9.953 5.359l-63.89 212.1l-56.72-212.7c-1.875-7-13.59-7-15.47 0l-56.72 212.7l-63.89-212.1C126.4 145.5 121.9 143 117.7 144.3C113.5 145.6 111.1 150.1 112.3 154.3l72 240C185.4 397.7 188.7 400.6 192.1 400c3.578-.0625 6.688-2.484 7.609-5.938L256 183l56.27 211c.9219 3.453 4.094 5.875 7.672 5.938c3.531 0 6.703-2.312 7.719-5.703l72-240C400.9 150.1 398.5 145.6 394.3 144.3zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-waveform-lines": [512, 512, ["waveform-circle"], "e12d", "M208 208c-4.418 0-8 3.58-8 8v80c0 4.418 3.582 8 8 8s8-3.582 8-8v-80C216 211.6 212.4 208 208 208zM144 160C139.6 160 136 163.6 136 168v176C136 348.4 139.6 352 144 352s8-3.582 8-8v-176C152 163.6 148.4 160 144 160zM272 128c-4.418 0-8 3.58-8 8v240c0 4.418 3.582 8 8 8s8-3.582 8-8v-240C280 131.6 276.4 128 272 128zM336 176c-4.418 0-8 3.58-8 8v144c0 4.418 3.582 8 8 8s8-3.582 8-8v-144C344 179.6 340.4 176 336 176zM400 216c-4.418 0-8 3.58-8 8v64c0 4.418 3.582 8 8 8S408 292.4 408 288V224C408 219.6 404.4 216 400 216zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-x": [512, 512, [], "e12e", "M365.2 129.1c-3.328-2.906-8.391-2.547-11.28 .8125L256 243.8L158 130.8c-2.891-3.359-7.953-3.719-11.28-.8125c-3.344 2.891-3.703 7.953-.8125 11.28L245.4 256l-99.46 114.8c-2.891 3.328-2.531 8.391 .8125 11.28C148.3 383.4 150.1 384 152 384c2.234 0 4.469-.9375 6.047-2.766L256 268.2l97.95 113C355.5 383.1 357.8 384 360 384c1.859 0 3.719-.6406 5.234-1.953c3.344-2.891 3.703-7.953 .8125-11.28L266.6 256l99.46-114.8C368.9 137.9 368.6 132.8 365.2 129.1zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-xmark": [512, 512, [61532, "times-circle", "xmark-circle"], "f057", "M178.3 178.3C181.5 175.2 186.5 175.2 189.7 178.3L256 244.7L322.3 178.3C325.5 175.2 330.5 175.2 333.7 178.3C336.8 181.5 336.8 186.5 333.7 189.7L267.3 256L333.7 322.3C336.8 325.5 336.8 330.5 333.7 333.7C330.5 336.8 325.5 336.8 322.3 333.7L256 267.3L189.7 333.7C186.5 336.8 181.5 336.8 178.3 333.7C175.2 330.5 175.2 325.5 178.3 322.3L244.7 256L178.3 189.7C175.2 186.5 175.2 181.5 178.3 178.3V178.3zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 16C123.5 16 16 123.5 16 256C16 388.5 123.5 496 256 496C388.5 496 496 388.5 496 256C496 123.5 388.5 16 256 16z"],
    "circle-y": [512, 512, [], "e12f", "M369.9 146.8L256 279.7L142.1 146.8C139.2 143.5 134.2 143.1 130.8 145.9C127.4 148.8 127 153.9 129.9 157.2L248 294.1V392c0 4.422 3.578 8 8 8s8-3.578 8-8V294.1l118.1-137.8c2.875-3.344 2.484-8.406-.875-11.28C377.9 143 372.8 143.5 369.9 146.8zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "circle-z": [512, 512, [], "e130", "M360 368H169.5l196.5-226.8c2.062-2.359 2.562-5.703 1.25-8.562C365.1 129.8 363.1 128 360 128h-208C147.6 128 144 131.6 144 136S147.6 144 152 144h190.5l-196.5 226.8c-2.062 2.359-2.562 5.703-1.25 8.562C146 382.2 148.9 384 152 384h208c4.406 0 8-3.578 8-8S364.4 368 360 368zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "citrus": [512, 512, [], "e2f4", "M453.1 154.9c-2.544 2.544-3.028 6.439-1.288 9.588C470 197.3 480 233.1 480 272c0 131.1-114.7 237.6-249.7 222.6c-102.8-11.49-185.5-94.24-196.9-196.1C18.4 162.7 124.1 47.1 256 47.1c14.47 0 28.68 1.984 42.7 4.812C292.1 65.85 288 80.38 288 96v16C288 120.8 295.2 128 304 128H384c53.02 0 96-42.98 96-96V16C480 7.163 472.8 0 464 0H384c-31.23 0-58.72 15.16-76.25 38.26C290.8 34.48 273.5 31.1 256 31.1c-137.5 0-248.3 116.1-239.5 255.4c7.511 119.4 104.7 216.6 224.1 224.1C379.9 520.3 496 409.5 496 271.1c0-40.84-10.67-80.2-30.22-115.5C463.2 151.9 456.9 151.1 453.1 154.9zM304 95.1c0-44.11 35.89-80 80-80h80v16c0 44.11-35.89 80-80 80h-80V95.1z"],
    "citrus-slice": [512, 512, [], "e2f5", "M424.6 2.344c-3.125-3.125-8.188-3.125-11.31 0L2.344 413.4C.8438 414.9 0 416.9 0 419c0 2.125 .8438 4.156 2.344 5.656C60.53 482.9 137 512 213.4 512c76.47 0 152.9-29.1 211.1-87.32C480.9 368.3 512 293.3 512 213.5S480.9 58.75 424.6 2.344zM373.4 64.85C404.3 98.11 423.7 139.4 429.7 184h-169.1c-.9082-1.213-1.646-2.512-2.666-3.664L373.4 64.85zM431.9 213.5c0 55.73-20.83 108.1-58.48 148.6l-112.5-112.5C271.7 235.1 274.4 216.6 269 200h162.2C431.6 204.5 431.9 208.1 431.9 213.5zM216.8 271.1c11.58 0 23.07-3.814 32.8-11.05l112.5 112.5c-40.56 37.77-92.94 58.69-148.7 58.69c-4.527 0-8.99-.3574-13.47-.6309V268.9C205.5 270.7 211.1 271.1 216.8 271.1zM246.4 191.9c12.87 15.38 12.58 38.17-1.85 52.63C230 258.1 207.3 259.3 191.9 246.4L246.4 191.9zM180.4 257.9C181.5 258.9 182.8 259.3 184 260.1v169.8c-44.54-6.033-85.85-25.43-119.1-56.42L180.4 257.9zM413.3 413.4C304.9 521.7 129.9 523.5 19.41 418.9l34.13-34.15c43.56 40.76 99.94 63.33 159.9 63.33c62.66 0 121.6-24.4 165.8-68.71c44.25-44.25 68.59-103.2 68.59-165.9c0-60.04-22.51-116.4-63.22-159.1l34.13-34.14C523.4 129.1 521.5 305.1 413.3 413.4z"],
    "city": [640, 512, [127961], "f64f", "M80 72H160V8C160 3.582 163.6 0 168 0C172.4 0 176 3.582 176 8V72H216C220.4 72 224 75.58 224 80C224 84.42 220.4 88 216 88H56C33.91 88 16 105.9 16 128V456C16 478.1 33.91 496 56 496H232C236.4 496 240 499.6 240 504C240 508.4 236.4 512 232 512H56C25.07 512 0 486.9 0 456V128C0 97.07 25.07 72 56 72H64V8C64 3.582 67.58 0 72 0C76.42 0 80 3.582 80 8V72zM328 352C328 338.7 338.7 328 352 328H384C397.3 328 408 338.7 408 352V384C408 397.3 397.3 408 384 408H352C338.7 408 328 397.3 328 384V352zM384 392C388.4 392 392 388.4 392 384V352C392 347.6 388.4 344 384 344H352C347.6 344 344 347.6 344 352V384C344 388.4 347.6 392 352 392H384zM384 72C397.3 72 408 82.75 408 96V128C408 141.3 397.3 152 384 152H352C338.7 152 328 141.3 328 128V96C328 82.75 338.7 72 352 72H384zM344 128C344 132.4 347.6 136 352 136H384C388.4 136 392 132.4 392 128V96C392 91.58 388.4 88 384 88H352C347.6 88 344 91.58 344 96V128zM328 224C328 210.7 338.7 200 352 200H384C397.3 200 408 210.7 408 224V256C408 269.3 397.3 280 384 280H352C338.7 280 328 269.3 328 256V224zM384 264C388.4 264 392 260.4 392 256V224C392 219.6 388.4 216 384 216H352C347.6 216 344 219.6 344 224V256C344 260.4 347.6 264 352 264H384zM512 440C498.7 440 488 429.3 488 416V384C488 370.7 498.7 360 512 360H544C557.3 360 568 370.7 568 384V416C568 429.3 557.3 440 544 440H512zM504 416C504 420.4 507.6 424 512 424H544C548.4 424 552 420.4 552 416V384C552 379.6 548.4 376 544 376H512C507.6 376 504 379.6 504 384V416zM488 256C488 242.7 498.7 232 512 232H544C557.3 232 568 242.7 568 256V288C568 301.3 557.3 312 544 312H512C498.7 312 488 301.3 488 288V256zM544 296C548.4 296 552 292.4 552 288V256C552 251.6 548.4 248 544 248H512C507.6 248 504 251.6 504 256V288C504 292.4 507.6 296 512 296H544zM480 64V160H576C611.3 160 640 188.7 640 224V448C640 483.3 611.3 512 576 512H320C284.7 512 256 483.3 256 448V64C256 28.65 284.7 0 320 0H416C451.3 0 480 28.65 480 64zM464 176V64C464 37.49 442.5 16 416 16H320C293.5 16 272 37.49 272 64V448C272 474.5 293.5 496 320 496H576C602.5 496 624 474.5 624 448V224C624 197.5 602.5 176 576 176H464zM96 344C82.75 344 72 333.3 72 320V288C72 274.7 82.75 264 96 264H128C141.3 264 152 274.7 152 288V320C152 333.3 141.3 344 128 344H96zM88 320C88 324.4 91.58 328 96 328H128C132.4 328 136 324.4 136 320V288C136 283.6 132.4 280 128 280H96C91.58 280 88 283.6 88 288V320zM72 160C72 146.7 82.75 136 96 136H128C141.3 136 152 146.7 152 160V192C152 205.3 141.3 216 128 216H96C82.75 216 72 205.3 72 192V160zM128 200C132.4 200 136 196.4 136 192V160C136 155.6 132.4 152 128 152H96C91.58 152 88 155.6 88 160V192C88 196.4 91.58 200 96 200H128z"],
    "clapperboard": [512, 512, [], "e131", "M448 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V96C512 60.65 483.3 32 448 32zM448 48c3.883 0 7.607 .5879 11.22 1.463L332.7 176H203.3l128-128H448zM308.7 48l-128 128H51.31l128-128H308.7zM16 96c0-26.47 21.53-48 48-48h92.69l-128 128H16V96zM496 416c0 26.47-21.53 48-48 48H64c-26.47 0-48-21.53-48-48V192h480V416zM496 176h-140.7l119.7-119.7C487.7 64.99 496 79.53 496 96V176z"],
    "clapperboard-play": [512, 512, [], "e132", "M205.6 412.5C209.6 414.8 214.1 416 218.7 416c5.143 0 10.09-1.462 14.38-4.276l106.6-68.94C347.4 337.8 352 329.3 352 319.1s-4.614-17.81-12.35-22.8L233 228.3C228.8 225.5 223.8 224 218.7 224C214.1 224 209.5 225.2 205.6 227.5C197.2 232.3 192 241.3 192 251v137.9C192 398.7 197.2 407.7 205.6 412.5zM208 251c0-4.01 2.104-7.705 5.5-9.656C215.1 240.5 216.9 240 218.7 240c1.967 0 3.926 .5547 5.629 1.674l106.7 68.97C334.1 312.7 336 316.2 336 319.1s-1.896 7.338-5.021 9.354l-106.7 68.97C222.6 399.4 220.6 400 218.7 400c-1.77 0-3.562-.4629-5.166-1.379C210.1 396.7 208 392.1 208 388.1V251zM448 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V96C512 60.65 483.3 32 448 32zM448 48c3.883 0 7.607 .5879 11.22 1.463L348.7 160H219.3l112-112H448zM308.7 48l-112 112H67.31l112-112H308.7zM16 96c0-26.47 21.53-48 48-48h92.69l-112 112H16V96zM496 416c0 26.47-21.53 48-48 48H64c-26.47 0-48-21.53-48-48V176h480V416zM496 160h-124.7l103.7-103.7C487.7 64.99 496 79.53 496 96V160z"],
    "clarinet": [640, 512, [], "f8ad", "M631.6 129.9c-2.377-1.268-4.984-1.898-7.578-1.898c-3.102 0-6.188 .9004-8.859 2.695L571.2 160L480 159.1V112h24C508.4 112 512 108.4 512 104S508.4 96 504 96h-272C227.6 96 224 99.58 224 104S227.6 112 232 112H272V160L101.3 159.1c-3.5 0-6.875 .4995-10.12 1.625L11 188.4C4.375 190.5 0 196.6 0 203.5v73c0 6.875 4.375 13 11 15.12l80.13 26.75c3.25 1.125 6.625 1.623 10.12 1.623L571.2 320l43.97 29.31C617.8 351.1 620.9 352 624 352c2.594 0 5.188-.625 7.562-1.891C636.8 347.3 640 341.9 640 336v-192C640 138.1 636.8 132.7 631.6 129.9zM384 112h80V160L384 159.1V112zM288 112h80V160L288 159.1V112zM624 335.1L576 304H101.3c-1.844 0-3.443-.2441-5.059-.8027L16 276.5l.0664-72.95l80.29-26.81C97.81 176.2 99.41 176 101.3 176H576l48-32V335.1zM272 224C263.2 224 256 231.2 256 240C256 248.8 263.2 256 272 256S288 248.8 288 240C288 231.2 280.8 224 272 224zM368 224C359.2 224 352 231.2 352 240C352 248.8 359.2 256 368 256S384 248.8 384 240C384 231.2 376.8 224 368 224zM464 224C455.2 224 448 231.2 448 240C448 248.8 455.2 256 464 256S480 248.8 480 240C480 231.2 472.8 224 464 224z"],
    "claw-marks": [512, 512, [], "f6c2", "M248.1 27.31C253.5 31.84 256 37.87 256 44.28l.0026 51.73l51.75 .0149c6.406 0 12.44 2.5 16.97 7.031l52.25 52.25c4.531 4.531 7.031 10.56 7.031 16.97l-.0016 51.74l51.75 .0127c6.406 0 12.44 2.5 16.5 6.5l45.62 54.61c1.562 1.891 3.844 2.875 6.125 2.875c5.331 0 7.1-4.552 7.1-7.985c0-1.814-.6158-3.639-1.875-5.14l-46.09-55.14c-7.562-7.562-17.59-11.72-28.28-11.72l-35.75-.0122l-.0004-35.74c0-10.69-4.156-20.72-11.72-28.28l-52.25-52.25c-7.562-7.562-17.59-11.72-28.28-11.72L271.1 80.01l-.0001-35.73c0-10.69-4.156-20.72-13.25-29.47L236.1 1.171C234.8 .3777 233.4 0 231.1 0C225.4 0 224 6.128 224 8.008c0 2.708 1.379 5.348 3.869 6.85L248.1 27.31zM512 503.1c0-1.988-.7355-3.979-2.221-5.524l-83.25-86.72c-7.562-7.562-17.59-11.72-28.28-11.72l-30.25-.0094l-.0003-30.24c0-10.69-4.156-20.72-11.72-28.28l-89.75-89.75c-7.562-7.562-17.59-11.72-28.28-11.72L208 240L208 209.8c0-10.69-4.156-20.72-11.78-28.34L13.6 2.296C12.03 .7802 10 .0185 7.977 .0185c-5.723 0-7.976 5.08-7.976 7.976c0 2.08 .805 4.161 2.407 5.739l182.6 179.1C189.5 197.3 192 203.4 192 209.8l.0023 46.24l46.25 .0096c6.406 0 12.44 2.5 16.97 7.031l89.75 89.75c4.531 4.531 7.031 10.56 7.031 16.97L351.1 416l46.25 .0066c6.406 0 12.44 2.5 16.84 6.922l83.12 86.61C499.8 511.2 501.9 512 503.1 512C509 512 512 507.7 512 503.1zM176 379.7C168.5 372.2 158.4 368 147.8 368l-35.75-.0099l.0004-35.74c0-10.69-4.156-20.72-12.03-28.58l-86.62-77.64C11.83 224.7 9.926 224 8.018 224c-4.378 0-8.018 3.498-8.018 7.99c0 2.198 .8969 4.385 2.657 5.96l86.31 77.34c4.531 4.531 7.031 10.56 7.031 16.97l.0386 51.74l51.71 .0099c6.406 0 12.44 2.5 16.75 6.812l109.6 118.6C275.7 511.1 277.8 512 279.1 512c4.421 0 8.006-3.57 8.006-7.994c0-1.946-.7058-3.899-2.131-5.443L176 379.7z"],
    "clipboard": [384, 512, [128203], "f328", "M192 96c8.836 0 16-7.164 16-16C208 71.16 200.8 64 192 64S176 71.16 176 80C176 88.84 183.2 96 192 96zM96 160h192c17.67 0 32-14.33 32-32V113.6C320 86.21 297.8 64 270.4 64C262.1 27.48 230.7 0 192 0S121 27.48 113.6 64C86.21 64 64 86.21 64 113.6V128C64 145.7 78.33 160 96 160zM80 113.6C80 95.05 95.05 80 113.6 80h13.08l1.846-9.094c4.986-24.56 22.27-46.17 46.48-52.65c36.93-9.88 72.56 13.83 79.69 48.93L257.3 80h13.08C288.1 80 304 95.05 304 113.6V128c0 8.837-7.163 16-16 16H96C87.16 144 80 136.8 80 128V113.6zM355.2 100c-4.094-1.719-8.75 .0625-10.53 4.156c-1.75 4.031 .0938 8.75 4.156 10.53C360.5 119.8 368 131.3 368 144v320c0 17.66-14.34 32-32 32h-288c-17.66 0-32-14.34-32-32v-320c0-12.69 7.531-24.19 19.22-29.31c4.031-1.75 5.875-6.469 4.094-10.53C37.56 100.1 32.94 98.22 28.78 100.1C11.31 107.7 0 124.1 0 144v320C0 490.5 21.53 512 48 512h288c26.47 0 48-21.53 48-48v-320C384 124.9 372.7 107.6 355.2 100z"],
    "clipboard-check": [384, 512, [], "f46c", "M355.2 100c-4.094-1.719-8.75 .0625-10.53 4.156c-1.75 4.031 .0938 8.75 4.156 10.53C360.5 119.8 368 131.3 368 144v320c0 17.66-14.34 32-32 32h-288c-17.66 0-32-14.34-32-32v-320c0-12.69 7.531-24.19 19.22-29.31c4.031-1.75 5.875-6.469 4.094-10.53C37.56 100.1 32.94 98.22 28.78 100.1C11.31 107.7 0 124.1 0 144v320C0 490.5 21.53 512 48 512h288c26.47 0 48-21.53 48-48v-320C384 124.9 372.7 107.6 355.2 100zM192 96c8.836 0 16-7.164 16-16C208 71.16 200.8 64 192 64S176 71.16 176 80C176 88.84 183.2 96 192 96zM96 160h192c17.67 0 32-14.33 32-32V113.6C320 86.21 297.8 64 270.4 64C262.1 27.48 230.7 0 192 0S121 27.48 113.6 64C86.21 64 64 86.21 64 113.6V128C64 145.7 78.33 160 96 160zM80 113.6C80 95.05 95.05 80 113.6 80h13.08l1.846-9.094c4.986-24.56 22.27-46.17 46.48-52.65c36.93-9.88 72.56 13.83 79.69 48.93L257.3 80h13.08C288.1 80 304 95.05 304 113.6V128c0 8.837-7.163 16-16 16H96C87.16 144 80 136.8 80 128V113.6zM282.3 250.3L160 372.7L101.7 314.3c-3.125-3.125-8.188-3.125-11.31 0s-3.125 8.188 0 11.31l64 64C155.9 391.2 157.9 392 160 392s4.094-.7813 5.656-2.344l128-128c3.125-3.125 3.125-8.188 0-11.31S285.5 247.2 282.3 250.3z"],
    "clipboard-list": [384, 512, [], "f46d", "M192 96c8.836 0 16-7.164 16-16C208 71.16 200.8 64 192 64S176 71.16 176 80C176 88.84 183.2 96 192 96zM96 160h192c17.67 0 32-14.33 32-32V113.6C320 86.21 297.8 64 270.4 64C262.1 27.48 230.7 0 192 0S121 27.48 113.6 64C86.21 64 64 86.21 64 113.6V128C64 145.7 78.33 160 96 160zM80 113.6C80 95.05 95.05 80 113.6 80h13.08l1.846-9.094c4.986-24.56 22.27-46.17 46.48-52.65c36.93-9.88 72.56 13.83 79.69 48.93L257.3 80h13.08C288.1 80 304 95.05 304 113.6V128c0 8.837-7.163 16-16 16H96C87.16 144 80 136.8 80 128V113.6zM355.2 100c-4.094-1.719-8.75 .0625-10.53 4.156c-1.75 4.031 .0938 8.75 4.156 10.53C360.5 119.8 368 131.3 368 144v320c0 17.66-14.34 32-32 32h-288c-17.66 0-32-14.34-32-32v-320c0-12.69 7.531-24.19 19.22-29.31c4.031-1.75 5.875-6.469 4.094-10.53C37.56 100.1 32.94 98.22 28.78 100.1C11.31 107.7 0 124.1 0 144v320C0 490.5 21.53 512 48 512h288c26.47 0 48-21.53 48-48v-320C384 124.9 372.7 107.6 355.2 100zM96 208C87.16 208 80 215.2 80 224c0 8.836 7.164 16 16 16S112 232.8 112 224C112 215.2 104.8 208 96 208zM96 304c-8.836 0-16 7.162-16 16c0 8.836 7.164 16 16 16s16-7.164 16-16C112 311.2 104.8 304 96 304zM96 400c-8.836 0-16 7.162-16 16c0 8.836 7.164 16 16 16s16-7.164 16-16C112 407.2 104.8 400 96 400zM312 408h-144C163.6 408 160 411.6 160 416s3.594 8 8 8h144c4.406 0 8-3.578 8-8S316.4 408 312 408zM312 216h-144C163.6 216 160 219.6 160 224s3.594 8 8 8h144C316.4 232 320 228.4 320 224S316.4 216 312 216zM312 312h-144C163.6 312 160 315.6 160 320s3.594 8 8 8h144c4.406 0 8-3.578 8-8S316.4 312 312 312z"],
    "clipboard-list-check": [384, 512, [], "f737", "M96 160h192c17.67 0 32-14.33 32-32V113.6C320 86.21 297.8 64 270.4 64C262.1 27.48 230.7 0 192 0S121 27.48 113.6 64C86.21 64 64 86.21 64 113.6V128C64 145.7 78.33 160 96 160zM80 113.6C80 95.05 95.05 80 113.6 80h13.08l1.845-9.091c4.986-24.56 22.27-46.17 46.48-52.65c36.93-9.881 72.56 13.83 79.69 48.93L257.3 80h13.08C288.1 80 304 95.05 304 113.6V128c0 8.837-7.163 16-16 16H96C87.16 144 80 136.8 80 128V113.6zM192 96c8.836 0 16-7.164 16-16C208 71.16 200.8 64 192 64S176 71.16 176 80C176 88.84 183.2 96 192 96zM312 248h-112C195.6 248 192 251.6 192 256s3.594 8 8 8h112C316.4 264 320 260.4 320 256S316.4 248 312 248zM80 384c0 8.836 7.164 16 16 16s16-7.164 16-16c0-8.838-7.164-16-16-16S80 375.2 80 384zM355.2 100c-4.094-1.719-8.75 .0625-10.53 4.156c-1.75 4.031 .0938 8.75 4.156 10.53C360.5 119.8 368 131.3 368 144v320c0 17.66-14.34 32-32 32h-288c-17.66 0-32-14.34-32-32v-320c0-12.69 7.531-24.19 19.22-29.31c4.031-1.75 5.875-6.469 4.094-10.53C37.56 100.1 32.94 98.22 28.78 100.1C11.31 107.7 0 124.1 0 144v320C0 490.5 21.53 512 48 512h288c26.47 0 48-21.53 48-48v-320C384 124.9 372.7 107.6 355.2 100zM312 376h-144C163.6 376 160 379.6 160 384s3.594 8 8 8h144c4.406 0 8-3.578 8-8S316.4 376 312 376zM90.34 293.7C91.91 295.2 93.94 296 96 296s4.094-.7813 5.656-2.344l64-64c3.125-3.125 3.125-8.188 0-11.31s-8.188-3.125-11.31 0L96 276.7L69.66 250.3c-3.125-3.125-8.188-3.125-11.31 0s-3.125 8.188 0 11.31L90.34 293.7z"],
    "clipboard-medical": [384, 512, [], "e133", "M192 96c8.836 0 16-7.164 16-16C208 71.16 200.8 64 192 64S176 71.16 176 80C176 88.84 183.2 96 192 96zM355.2 100c-4.094-1.719-8.75 .0625-10.53 4.156c-1.75 4.031 .0938 8.75 4.156 10.53C360.5 119.8 368 131.3 368 144v320c0 17.66-14.34 32-32 32h-288c-17.66 0-32-14.34-32-32v-320c0-12.69 7.531-24.19 19.22-29.31c4.031-1.75 5.875-6.469 4.094-10.53C37.56 100.1 32.94 98.22 28.78 100.1C11.31 107.7 0 124.1 0 144v320C0 490.5 21.53 512 48 512h288c26.47 0 48-21.53 48-48v-320C384 124.9 372.7 107.6 355.2 100zM96 160h192c17.67 0 32-14.33 32-32V113.6C320 86.21 297.8 64 270.4 64C262.1 27.48 230.7 0 192 0S121 27.48 113.6 64C86.21 64 64 86.21 64 113.6V128C64 145.7 78.33 160 96 160zM80 113.6C80 95.05 95.05 80 113.6 80h13.08l1.846-9.094c4.986-24.56 22.27-46.17 46.48-52.65c36.93-9.881 72.56 13.83 79.69 48.93L257.3 80h13.08C288.1 80 304 95.05 304 113.6V128c0 8.836-7.162 16-16 16H96C87.16 144 80 136.8 80 128V113.6zM165.8 448h52.36c8.836 0 16-7.164 16-16v-53.82H288c8.836 0 16-7.164 16-16V309.8c0-8.838-7.164-16-16-16h-53.82V240c0-8.838-7.164-16-16-16H165.8c-8.836 0-16 7.162-16 16v53.82H96c-8.836 0-16 7.162-16 16v52.36c0 8.836 7.164 16 16 16h53.82V432C149.8 440.8 156.1 448 165.8 448zM96 362.2V309.8h69.82V240h52.36v69.82H288v52.36h-69.82V432H165.8v-69.82H96z"],
    "clipboard-prescription": [384, 512, [], "f5e8", "M192 96c8.836 0 16-7.164 16-16C208 71.16 200.8 64 192 64S176 71.16 176 80C176 88.84 183.2 96 192 96zM96 160h192c17.67 0 32-14.33 32-32V113.6C320 86.21 297.8 64 270.4 64C262.1 27.48 230.7 0 192 0S121 27.48 113.6 64C86.21 64 64 86.21 64 113.6V128C64 145.7 78.33 160 96 160zM80 113.6C80 95.05 95.05 80 113.6 80h13.08l1.846-9.094c4.986-24.56 22.27-46.17 46.48-52.65c36.93-9.88 72.56 13.83 79.69 48.93L257.3 80h13.08C288.1 80 304 95.05 304 113.6V128c0 8.837-7.163 16-16 16H96C87.16 144 80 136.8 80 128V113.6zM355.2 100c-4.094-1.719-8.75 .0625-10.53 4.156c-1.75 4.031 .0938 8.75 4.156 10.53C360.5 119.8 368 131.3 368 144v320c0 17.66-14.34 32-32 32h-288c-17.66 0-32-14.34-32-32v-320c0-12.69 7.531-24.19 19.22-29.31c4.031-1.75 5.875-6.469 4.094-10.53C37.56 100.1 32.94 98.22 28.78 100.1C11.31 107.7 0 124.1 0 144v320C0 490.5 21.53 512 48 512h288c26.47 0 48-21.53 48-48v-320C384 124.9 372.7 107.6 355.2 100zM293.7 314.3c-3.125-3.125-8.188-3.125-11.31 0L240 356.7L186.2 302.9C207.8 298.2 224 278.1 224 256c0-26.47-21.53-48-48-48H104C99.59 208 96 211.6 96 216v160C96 380.4 99.59 384 104 384s8-3.578 8-8V304h52.69l64 64l-42.34 42.34c-3.125 3.125-3.125 8.188 0 11.31C187.9 423.2 189.9 424 192 424s4.094-.7813 5.656-2.344L240 379.3l42.34 42.34C283.9 423.2 285.9 424 288 424s4.094-.7813 5.656-2.344c3.125-3.125 3.125-8.188 0-11.31L251.3 368l42.34-42.34C296.8 322.5 296.8 317.5 293.7 314.3zM112 288V224h64c17.66 0 32 14.36 32 32s-14.34 32-32 32H112z"],
    "clipboard-question": [384, 512, [], "e4e3", "M208 80C208 88.84 200.8 96 191.1 96C183.2 96 175.1 88.84 175.1 80C175.1 71.16 183.2 64 191.1 64C200.8 64 208 71.16 208 80zM111.1 64H113.6C121 27.48 153.3 0 191.1 0C230.7 0 262.1 27.48 270.4 64H272C298.5 64 320 85.49 320 112V128C320 145.7 305.7 160 288 160H95.1C78.33 160 63.1 145.7 63.1 128V112C63.1 85.49 85.49 64 111.1 64zM191.1 16C161.1 16 135.2 37.98 129.3 67.18L126.7 80H112C94.33 80 80 94.33 80 112V128C80 136.8 87.16 144 96 144H288C296.8 144 304 136.8 304 128V112C304 94.33 289.7 80 272 80H257.3L254.7 67.18C248.8 37.98 222.9 16 192 16H191.1zM38.11 113.9C24.56 120.7 15.1 134.5 15.1 149.7V456C15.1 478.1 33.91 496 55.1 496H328C350.1 496 368 478.1 368 456V149.7C368 134.5 359.4 120.7 345.9 113.9L340.4 111.2C336.5 109.2 334.9 104.4 336.8 100.4C338.8 96.47 343.6 94.87 347.6 96.84L353 99.58C372 109.1 384 128.5 384 149.7V456C384 486.9 358.9 512 328 512H56C25.07 512 0 486.9 0 456V149.7C0 128.5 11.98 109.1 30.96 99.58L36.42 96.84C40.37 94.87 45.18 96.47 47.16 100.4C49.13 104.4 47.53 109.2 43.58 111.2L38.11 113.9zM103.1 264C103.1 233.1 129.1 208 159.1 208H216.2C251.4 208 279.1 236.6 279.1 271.8C279.1 293.2 269.2 313.2 251.3 325L199.1 358.9V384C199.1 388.4 196.4 392 191.1 392C187.6 392 183.1 388.4 183.1 384V354.5C183.1 351.9 185.3 349.3 187.6 347.9L242.5 311.7C255.9 302.8 263.1 287.8 263.1 271.8C263.1 245.4 242.6 224 216.2 224H159.1C137.9 224 119.1 241.9 119.1 264V270.5C119.1 274.1 116.4 278.5 111.1 278.5C107.6 278.5 103.1 274.1 103.1 270.5V264zM207.1 432C207.1 440.8 200.8 448 191.1 448C183.2 448 175.1 440.8 175.1 432C175.1 423.2 183.2 416 191.1 416C200.8 416 207.1 423.2 207.1 432z"],
    "clipboard-user": [384, 512, [], "f7f3", "M96 160h192c17.67 0 32-14.33 32-32V113.6C320 86.21 297.8 64 270.4 64C262.1 27.48 230.7 0 192 0S121 27.48 113.6 64C86.21 64 64 86.21 64 113.6V128C64 145.7 78.33 160 96 160zM80 113.6C80 95.05 95.05 80 113.6 80h13.08l1.846-9.094c4.986-24.56 22.27-46.17 46.48-52.65c36.93-9.88 72.56 13.83 79.69 48.93L257.3 80h13.08C288.1 80 304 95.05 304 113.6V128c0 8.837-7.163 16-16 16H96C87.16 144 80 136.8 80 128V113.6zM355.2 100c-4.094-1.719-8.75 .0625-10.53 4.156c-1.75 4.031 .0938 8.75 4.156 10.53C360.5 119.8 368 131.3 368 144v320c0 17.66-14.34 32-32 32h-288c-17.66 0-32-14.34-32-32v-320c0-12.69 7.531-24.19 19.22-29.31c4.031-1.75 5.875-6.469 4.094-10.53C37.56 100.1 32.94 98.22 28.78 100.1C11.31 107.7 0 124.1 0 144v320C0 490.5 21.53 512 48 512h288c26.47 0 48-21.53 48-48v-320C384 124.9 372.7 107.6 355.2 100zM192 96c8.836 0 16-7.164 16-16C208 71.16 200.8 64 192 64S176 71.16 176 80C176 88.84 183.2 96 192 96zM192 320c35.35 0 64-28.65 64-64c0-35.35-28.65-64-64-64S128 220.7 128 256C128 291.3 156.7 320 192 320zM192 208c26.47 0 48 21.53 48 48S218.5 304 192 304S144 282.5 144 256S165.5 208 192 208zM80 416c0 17.67 14.33 32 32 32h160c17.67 0 32-14.33 32-32c0-35.35-28.65-64-64-64h-96C108.7 352 80 380.7 80 416zM144 368h96c26.47 0 48 21.53 48 48c0 8.822-7.176 16-16 16h-160C103.2 432 96 424.8 96 416C96 389.5 117.5 368 144 368z"],
    "clock": [512, 512, [128339, "clock-four"], "f017", "M248 104C248 99.58 251.6 96 256 96C260.4 96 264 99.58 264 104V251.7L356.4 313.3C360.1 315.8 361.1 320.8 358.7 324.4C356.2 328.1 351.2 329.1 347.6 326.7L251.6 262.7C249.3 261.2 247.1 258.7 247.1 256L248 104zM256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0zM16 256C16 388.5 123.5 496 256 496C388.5 496 496 388.5 496 256C496 123.5 388.5 16 256 16C123.5 16 16 123.5 16 256z"],
    "clock-desk": [448, 512, [], "e134", "M224 96C228.4 96 232 99.58 232 104V220.7L285.7 274.3C288.8 277.5 288.8 282.5 285.7 285.7C282.5 288.8 277.5 288.8 274.3 285.7L218.3 229.7C216.8 228.2 216 226.1 216 224V104C216 99.58 219.6 96 224 96H224zM224 0C347.7 0 448 100.3 448 224V456C448 486.9 422.9 512 392 512H56C25.07 512 0 486.9 0 456V224C0 100.3 100.3 0 224 0zM224 16C109.1 16 16 109.1 16 224C16 338.9 109.1 432 224 432C338.9 432 432 338.9 432 224C432 109.1 338.9 16 224 16zM432 307.3C398.9 389.8 318.3 448 224 448C129.7 448 49.05 389.8 16 307.3V456C16 478.1 33.91 496 56 496H392C414.1 496 432 478.1 432 456V307.3z"],
    "clock-eight": [512, 512, [], "e345", "M264 256C264 258.7 262.7 261.2 260.4 262.7L164.4 326.7C160.8 329.1 155.8 328.1 153.3 324.4C150.9 320.8 151.9 315.8 155.6 313.3L248 251.7V104C248 99.58 251.6 96 256 96C260.4 96 264 99.58 264 104V256zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 16C123.5 16 16 123.5 16 256C16 388.5 123.5 496 256 496C388.5 496 496 388.5 496 256C496 123.5 388.5 16 256 16z"],
    "clock-eight-thirty": [512, 512, [], "e346", "M248 270.9L164.4 326.7C160.8 329.1 155.8 328.1 153.3 324.4C150.9 320.8 151.9 315.8 155.6 313.3L251.6 249.3C254 247.7 257.2 247.6 259.8 248.9C262.4 250.3 264 253 264 255.1V408C264 412.4 260.4 416 256 416C251.6 416 248 412.4 248 408V270.9zM0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM256 496C388.5 496 496 388.5 496 256C496 123.5 388.5 16 256 16C123.5 16 16 123.5 16 256C16 388.5 123.5 496 256 496z"],
    "clock-eleven": [512, 512, [], "e347", "M248 104C248 99.58 251.6 96 256 96C260.4 96 264 99.58 264 104V256C264 259.5 261.7 262.6 258.3 263.7C254.9 264.7 251.3 263.4 249.3 260.4L185.3 164.4C182.9 160.8 183.9 155.8 187.6 153.3C191.2 150.9 196.2 151.9 198.7 155.6L248 229.6L248 104zM256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0zM16 256C16 388.5 123.5 496 256 496C388.5 496 496 388.5 496 256C496 123.5 388.5 16 256 16C123.5 16 16 123.5 16 256z"],
    "clock-eleven-thirty": [512, 512, [], "e348", "M248 258.4L185.3 164.4C182.9 160.8 183.9 155.8 187.6 153.3C191.2 150.9 196.2 151.9 198.7 155.6L262.7 251.6C263.5 252.9 264 254.4 264 256V408C264 412.4 260.4 416 256 416C251.6 416 248 412.4 248 408L248 258.4zM0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM256 496C388.5 496 496 388.5 496 256C496 123.5 388.5 16 256 16C123.5 16 16 123.5 16 256C16 388.5 123.5 496 256 496z"],
    "clock-five": [512, 512, [], "e349", "M264 253.6L326.7 347.6C329.1 351.2 328.1 356.2 324.4 358.7C320.8 361.1 315.8 360.1 313.3 356.4L249.3 260.4C248.5 259.1 247.1 257.6 247.1 256V104C247.1 99.58 251.6 96 255.1 96C260.4 96 264 99.58 264 104L264 253.6zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 16C123.5 16 16 123.5 16 256C16 388.5 123.5 496 256 496C388.5 496 496 388.5 496 256C496 123.5 388.5 16 256 16z"],
    "clock-five-thirty": [512, 512, [], "e34a", "M264 408C264 412.4 260.4 416 256 416C251.6 416 248 412.4 248 408V256C248 252.5 250.3 249.4 253.7 248.3C257.1 247.3 260.7 248.6 262.7 251.6L326.7 347.6C329.1 351.2 328.1 356.2 324.4 358.7C320.8 361.1 315.8 360.1 313.3 356.4L264 282.4L264 408zM256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512zM496 256C496 123.5 388.5 16 256 16C123.5 16 16 123.5 16 256C16 388.5 123.5 496 256 496C388.5 496 496 388.5 496 256z"],
    "clock-four-thirty": [512, 512, [], "e34b", "M264 408C264 412.4 260.4 416 256 416C251.6 416 248 412.4 248 408V256C248 253 249.6 250.3 252.2 248.9C254.8 247.6 257.1 247.7 260.4 249.3L356.4 313.3C360.1 315.8 361.1 320.8 358.7 324.4C356.2 328.1 351.2 329.1 347.6 326.7L264 270.9V408zM256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512zM496 256C496 123.5 388.5 16 256 16C123.5 16 16 123.5 16 256C16 388.5 123.5 496 256 496C388.5 496 496 388.5 496 256z"],
    "clock-nine": [512, 512, [], "e34c", "M264 256C264 260.4 260.4 264 256 264H136C131.6 264 128 260.4 128 256C128 251.6 131.6 248 136 248H248V104C248 99.58 251.6 96 256 96C260.4 96 264 99.58 264 104V256zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 16C123.5 16 16 123.5 16 256C16 388.5 123.5 496 256 496C388.5 496 496 388.5 496 256C496 123.5 388.5 16 256 16z"],
    "clock-nine-thirty": [512, 512, [], "e34d", "M264 408C264 412.4 260.4 416 256 416C251.6 416 248 412.4 248 408V264H136C131.6 264 128 260.4 128 256C128 251.6 131.6 248 136 248H256C260.4 248 264 251.6 264 256V408zM256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512zM496 256C496 123.5 388.5 16 256 16C123.5 16 16 123.5 16 256C16 388.5 123.5 496 256 496C388.5 496 496 388.5 496 256z"],
    "clock-one": [512, 512, [], "e34e", "M264 229.6L313.3 155.6C315.8 151.9 320.8 150.9 324.4 153.3C328.1 155.8 329.1 160.8 326.7 164.4L262.7 260.4C260.7 263.4 257.1 264.7 253.7 263.7C250.3 262.6 248 259.5 248 256V104C248 99.58 251.6 96 256 96C260.4 96 264 99.58 264 104L264 229.6zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 16C123.5 16 16 123.5 16 256C16 388.5 123.5 496 256 496C388.5 496 496 388.5 496 256C496 123.5 388.5 16 256 16z"],
    "clock-one-thirty": [512, 512, [], "e34f", "M264 408C264 412.4 260.4 416 256 416C251.6 416 248 412.4 248 408V256C248 254.4 248.5 252.9 249.3 251.6L313.3 155.6C315.8 151.9 320.8 150.9 324.4 153.3C328.1 155.8 329.1 160.8 326.7 164.4L264 258.4L264 408zM256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512zM496 256C496 123.5 388.5 16 256 16C123.5 16 16 123.5 16 256C16 388.5 123.5 496 256 496C388.5 496 496 388.5 496 256z"],
    "clock-rotate-left": [512, 512, ["history"], "f1da", "M256 .0003C397.4 .0003 512 114.6 512 256C512 397.4 397.4 512 256 512C177.6 512 107.3 476.7 60.4 421.2C57.55 417.8 57.97 412.7 61.35 409.9C64.72 407 69.77 407.5 72.62 410.8C116.7 462.9 182.5 496 256 496C388.5 496 496 388.5 496 256C496 123.5 388.5 16 256 16C151.5 16 62.6 82.78 29.65 176H136C140.4 176 144 179.6 144 184C144 188.4 140.4 192 136 192H8C3.582 192 0 188.4 0 184V56C0 51.58 3.582 48 8 48C12.42 48 16 51.58 16 56V166.7C52.23 69.37 146 0 256 0V.0003zM256 128C260.4 128 264 131.6 264 136V252.7L349.7 338.3C352.8 341.5 352.8 346.5 349.7 349.7C346.5 352.8 341.5 352.8 338.3 349.7L250.3 261.7C248.8 260.2 248 258.1 248 256V136C248 131.6 251.6 128 256 128H256z"],
    "clock-seven": [512, 512, [], "e350", "M248 104C248 99.58 251.6 96 256 96C260.4 96 264 99.58 264 104V256C264 257.6 263.5 259.1 262.7 260.4L198.7 356.4C196.2 360.1 191.2 361.1 187.6 358.7C183.9 356.2 182.9 351.2 185.3 347.6L247.1 253.6L248 104zM256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0zM16 256C16 388.5 123.5 496 256 496C388.5 496 496 388.5 496 256C496 123.5 388.5 16 256 16C123.5 16 16 123.5 16 256z"],
    "clock-seven-thirty": [512, 512, [], "e351", "M248 282.4L198.7 356.4C196.2 360.1 191.2 361.1 187.6 358.7C183.9 356.2 182.9 351.2 185.3 347.6L249.3 251.6C251.3 248.6 254.9 247.3 258.3 248.3C261.7 249.4 264 252.5 264 255.1V408C264 412.4 260.4 416 255.1 416C251.6 416 247.1 412.4 247.1 408L248 282.4zM0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM256 496C388.5 496 496 388.5 496 256C496 123.5 388.5 16 256 16C123.5 16 16 123.5 16 256C16 388.5 123.5 496 256 496z"],
    "clock-six": [512, 512, [], "e352", "M264 376C264 380.4 260.4 384 256 384C251.6 384 248 380.4 248 376V104C248 99.58 251.6 96 256 96C260.4 96 264 99.58 264 104V376zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 16C123.5 16 16 123.5 16 256C16 388.5 123.5 496 256 496C388.5 496 496 388.5 496 256C496 123.5 388.5 16 256 16z"],
    "clock-six-thirty": [512, 512, [], "e353", "M264 408C264 412.4 260.4 416 256 416C251.6 416 248 412.4 248 408V256C248 251.6 251.6 248 256 248C260.4 248 264 251.6 264 256V408zM256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512zM496 256C496 123.5 388.5 16 256 16C123.5 16 16 123.5 16 256C16 388.5 123.5 496 256 496C388.5 496 496 388.5 496 256z"],
    "clock-ten": [512, 512, [], "e354", "M248 104C248 99.58 251.6 96 256 96C260.4 96 264 99.58 264 104V256C264 258.1 262.4 261.7 259.8 263.1C257.2 264.4 254 264.3 251.6 262.7L155.6 198.7C151.9 196.2 150.9 191.2 153.3 187.6C155.8 183.9 160.8 182.9 164.4 185.3L248 241.1V104zM256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0zM16 256C16 388.5 123.5 496 256 496C388.5 496 496 388.5 496 256C496 123.5 388.5 16 256 16C123.5 16 16 123.5 16 256z"],
    "clock-ten-thirty": [512, 512, [], "e355", "M264 408C264 412.4 260.4 416 256 416C251.6 416 248 412.4 248 408V260.3L155.6 198.7C151.9 196.2 150.9 191.2 153.3 187.6C155.8 183.9 160.8 182.9 164.4 185.3L260.4 249.3C262.7 250.8 264 253.3 264 256V408zM256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512zM496 256C496 123.5 388.5 16 256 16C123.5 16 16 123.5 16 256C16 388.5 123.5 496 256 496C388.5 496 496 388.5 496 256z"],
    "clock-three": [512, 512, [], "e356", "M248 104C248 99.58 251.6 96 256 96C260.4 96 264 99.58 264 104V248H376C380.4 248 384 251.6 384 256C384 260.4 380.4 264 376 264H256C251.6 264 248 260.4 248 256V104zM256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0zM16 256C16 388.5 123.5 496 256 496C388.5 496 496 388.5 496 256C496 123.5 388.5 16 256 16C123.5 16 16 123.5 16 256z"],
    "clock-three-thirty": [512, 512, [], "e357", "M248 256C248 251.6 251.6 248 256 248H376C380.4 248 384 251.6 384 256C384 260.4 380.4 264 376 264H264V408C264 412.4 260.4 416 256 416C251.6 416 248 412.4 248 408V256zM0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM256 496C388.5 496 496 388.5 496 256C496 123.5 388.5 16 256 16C123.5 16 16 123.5 16 256C16 388.5 123.5 496 256 496z"],
    "clock-twelve": [512, 512, [], "e358", "M264 256C264 260.4 260.4 264 256 264C251.6 264 248 260.4 248 256V104C248 99.58 251.6 96 256 96C260.4 96 264 99.58 264 104V256zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 16C123.5 16 16 123.5 16 256C16 388.5 123.5 496 256 496C388.5 496 496 388.5 496 256C496 123.5 388.5 16 256 16z"],
    "clock-twelve-thirty": [512, 512, [], "e359", "M264 408C264 412.4 260.4 416 256 416C251.6 416 248 412.4 248 408V144C248 139.6 251.6 136 256 136C260.4 136 264 139.6 264 144V408zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 16C123.5 16 16 123.5 16 256C16 388.5 123.5 496 256 496C388.5 496 496 388.5 496 256C496 123.5 388.5 16 256 16z"],
    "clock-two": [512, 512, [], "e35a", "M264 241.1L347.6 185.3C351.2 182.9 356.2 183.9 358.7 187.6C361.1 191.2 360.1 196.2 356.4 198.7L260.4 262.7C257.1 264.3 254.8 264.4 252.2 263.1C249.6 261.7 248 258.1 248 256V104C248 99.58 251.6 96 256 96C260.4 96 264 99.58 264 104V241.1zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 16C123.5 16 16 123.5 16 256C16 388.5 123.5 496 256 496C388.5 496 496 388.5 496 256C496 123.5 388.5 16 256 16z"],
    "clock-two-thirty": [512, 512, [], "e35b", "M248 256C248 253.3 249.3 250.8 251.6 249.3L347.6 185.3C351.2 182.9 356.2 183.9 358.7 187.6C361.1 191.2 360.1 196.2 356.4 198.7L264 260.3V408C264 412.4 260.4 416 256 416C251.6 416 248 412.4 248 408L248 256zM0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM256 496C388.5 496 496 388.5 496 256C496 123.5 388.5 16 256 16C123.5 16 16 123.5 16 256C16 388.5 123.5 496 256 496z"],
    "clone": [512, 512, [], "f24d", "M64 496H288C314.5 496 336 474.5 336 448V392C336 387.6 339.6 384 344 384C348.4 384 352 387.6 352 392V448C352 483.3 323.3 512 288 512H64C28.65 512 0 483.3 0 448V224C0 188.7 28.65 160 64 160H120C124.4 160 128 163.6 128 168C128 172.4 124.4 176 120 176H64C37.49 176 16 197.5 16 224V448C16 474.5 37.49 496 64 496zM160 64C160 28.65 188.7 0 224 0H448C483.3 0 512 28.65 512 64V288C512 323.3 483.3 352 448 352H224C188.7 352 160 323.3 160 288V64zM176 288C176 314.5 197.5 336 224 336H448C474.5 336 496 314.5 496 288V64C496 37.49 474.5 16 448 16H224C197.5 16 176 37.49 176 64V288z"],
    "closed-captioning": [576, 512, [], "f20a", "M512 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h448c35.35 0 64-28.65 64-64V96C576 60.65 547.3 32 512 32zM560 416c0 26.47-21.53 48-48 48H64c-26.47 0-48-21.53-48-48V96c0-26.47 21.53-48 48-48h448c26.47 0 48 21.53 48 48V416zM192 176c21.36 0 41.45 8.328 56.56 23.44c3.125 3.125 8.188 3.125 11.31 0s3.125-8.188 0-11.31C241.8 169.1 217.6 160 192 160S142.3 169.1 124.1 188.1C105.1 206.3 96 230.4 96 256s9.984 49.75 28.12 67.88C142.3 342 166.4 352 192 352s49.75-9.984 67.88-28.12c3.125-3.125 3.125-8.188 0-11.31s-8.188-3.125-11.31 0C233.5 327.7 213.4 336 192 336s-41.45-8.328-56.56-23.44S112 277.4 112 256s8.328-41.45 23.44-56.56S170.6 176 192 176zM400 176c21.36 0 41.45 8.328 56.56 23.44c3.125 3.125 8.188 3.125 11.31 0s3.125-8.188 0-11.31C449.8 169.1 425.6 160 400 160s-49.75 9.984-67.88 28.12C313.1 206.3 304 230.4 304 256s9.984 49.75 28.12 67.88C350.3 342 374.4 352 400 352s49.75-9.984 67.88-28.12c3.125-3.125 3.125-8.188 0-11.31s-8.188-3.125-11.31 0C441.5 327.7 421.4 336 400 336s-41.45-8.328-56.56-23.44S320 277.4 320 256s8.328-41.45 23.44-56.56S378.6 176 400 176z"],
    "closed-captioning-slash": [640, 512, [], "e135", "M544 48c26.47 0 48 21.53 48 48v284.2l16 12.72V95.1c0-35.35-28.65-64-64-64L153.9 32l20.13 16H544zM96 464c-26.47 0-48-21.53-48-48V131.8L32 119.1v296.9c0 35.35 28.65 64 64 64L486.1 480l-20.13-16H96zM364.1 188.1c-2.053 2.051-3.611 4.432-5.453 6.629l12.47 9.91c1.461-1.727 2.68-3.609 4.297-5.227C390.5 184.3 410.6 176 432 176s41.45 8.328 56.56 23.44c3.125 3.125 8.188 3.125 11.31 0s3.125-8.188 0-11.31C481.8 169.1 457.6 160 432 160S382.3 169.1 364.1 188.1zM142.1 206.5C133.1 221.4 128 238.2 128 256c0 25.64 9.984 49.75 28.12 67.88C174.3 342 198.4 352 224 352c25.17 0 48.79-9.727 66.79-27.23L278 314.6C263.2 328.3 244.3 336 224 336c-21.36 0-41.45-8.328-56.56-23.44S144 277.4 144 256c0-14.09 3.939-27.46 10.74-39.38L142.1 206.5zM636.1 497.7L12.99 1.73C11.53 .5664 9.771 0 8.025 0C5.674 0 3.336 1.029 1.738 3.012c-2.75 3.469-2.172 8.5 1.281 11.25l623.1 496C628.5 511.4 630.2 512 631.1 512c2.344 0 4.688-1.031 6.266-3.016C641 505.5 640.4 500.5 636.1 497.7z"],
    "clothes-hanger": [640, 512, [], "e136", "M609.3 392.7l-280.4-172.6l42.81-27.38C399.5 174.1 416 144.8 416 111.8V96c0-52.94-43.06-96-96-96S224 43.06 224 96c0 4.406 3.594 8 8 8S240 100.4 240 96c0-44.13 35.88-80 80-80s80 35.88 80 80v15.84c0 27.41-13.78 52.59-36.88 67.38L29.72 392.6C11.12 404.5 0 424.8 0 447.5C0 483.1 28.91 512 64.47 512h511.1C611.1 512 640 483.1 640 447.5C640 424.1 628.5 404.5 609.3 392.7zM575.5 496H64.47C37.75 496 16 474.3 16 446.9c0-16.62 8.344-31.88 22.34-40.81l275.9-176.6C314.7 230 315.2 230.4 315.8 230.8l285.1 175.5C615.4 415.2 624 430.6 624 447.5C624 474.3 602.3 496 575.5 496z"],
    "cloud": [640, 512, [9729], "f0c2", "M394.7 112.2C398.2 109.8 401.9 107.7 405.7 105.8C418.5 99.52 432.8 96 448 96C501 96 544 138.1 544 192C544 198.6 543.3 204.1 542.1 211.2C541 216.5 539.5 221.6 537.6 226.6C542.9 227.6 548.1 229 553.1 230.7C603.6 247.9 640 295.7 640 352C640 422.7 582.7 480 512 480H144C64.47 480 0 415.5 0 336C0 273.2 40.17 219.8 96.2 200.1C96.07 197.4 96 194.7 96 192C96 103.6 167.6 32 256 32C309.6 32 356.1 58.31 386 98.71C389.1 103 392 107.5 394.7 112.2V112.2zM523.6 234.2C521.3 230.1 520.1 225.2 522.7 220.8C526.1 211.9 528 202.2 528 192C528 147.8 492.2 112 448 112C431.5 112 416.3 116.1 403.6 125.5C399.9 127.9 395.4 128.7 391.1 127.7C386.7 126.7 383 123.1 380.8 120.2C355.9 76.99 309.3 48 256 48C176.5 48 112 112.5 112 192C112 194.5 112.1 196.9 112.2 199.3C112.5 206.4 108.2 212.9 101.5 215.2C51.68 232.7 16 280.2 16 336C16 406.7 73.31 464 144 464H512C573.9 464 624 413.9 624 352C624 297.8 585.5 252.6 534.4 242.2C529.8 241.3 525.8 238.4 523.6 234.2V234.2z"],
    "cloud-arrow-down": [640, 512, [62337, "cloud-download", "cloud-download-alt"], "f0ed", "M226.3 325.7C223.2 322.5 223.2 317.5 226.3 314.3C229.5 311.2 234.5 311.2 237.7 314.3L311.1 388.7V192C311.1 187.6 315.6 184 319.1 184C324.4 184 328 187.6 328 192V388.7L402.3 314.3C405.5 311.2 410.5 311.2 413.7 314.3C416.8 317.5 416.8 322.5 413.7 325.7L325.7 413.7C322.5 416.8 317.5 416.8 314.3 413.7L226.3 325.7zM256 32C309.6 32 356.1 58.31 386 98.71C389.1 103 392 107.5 394.7 112.2C398.2 109.8 401.9 107.7 405.7 105.8C418.5 99.52 432.8 96 448 96C501 96 544 138.1 544 192C544 198.6 543.3 204.1 542.1 211.2C541 216.5 539.5 221.6 537.6 226.6C542.9 227.6 548.1 229 553.1 230.7C603.6 247.9 640 295.7 640 352C640 422.7 582.7 480 512 480H144C64.47 480 0 415.5 0 336C0 273.2 40.17 219.8 96.2 200.1C96.07 197.4 96 194.7 96 192C96 103.6 167.6 32 256 32V32zM528 192C528 147.8 492.2 112 448 112C431.5 112 416.3 116.1 403.6 125.5C399.9 127.9 395.4 128.7 391.1 127.7C386.7 126.7 383 123.1 380.8 120.2C355.9 76.99 309.3 48 256 48C176.5 48 112 112.5 112 192C112 194.5 112.1 196.9 112.2 199.3C112.5 206.4 108.2 212.9 101.5 215.2C51.68 232.7 16 280.2 16 336C16 406.7 73.31 464 144 464H512C573.9 464 624 413.9 624 352C624 297.8 585.5 252.6 534.4 242.2C529.8 241.3 525.8 238.4 523.6 234.2C521.3 230.1 520.1 225.2 522.7 220.8C526.1 211.9 528 202.2 528 192V192z"],
    "cloud-arrow-up": [640, 512, [62338, "cloud-upload", "cloud-upload-alt"], "f0ee", "M314.3 186.3C317.5 183.2 322.5 183.2 325.7 186.3L413.7 274.3C416.8 277.5 416.8 282.5 413.7 285.7C410.5 288.8 405.5 288.8 402.3 285.7L328 211.3V408C328 412.4 324.4 416 320 416C315.6 416 312 412.4 312 408V211.3L237.7 285.7C234.5 288.8 229.5 288.8 226.3 285.7C223.2 282.5 223.2 277.5 226.3 274.3L314.3 186.3zM256 32C309.6 32 356.1 58.31 386 98.71C389.1 103 392 107.5 394.7 112.2C398.2 109.8 401.9 107.7 405.7 105.8C418.5 99.52 432.8 96 448 96C501 96 544 138.1 544 192C544 198.6 543.3 204.1 542.1 211.2C541 216.5 539.5 221.6 537.6 226.6C542.9 227.6 548.1 229 553.1 230.7C603.6 247.9 640 295.7 640 352C640 422.7 582.7 480 512 480H144C64.47 480 0 415.5 0 336C0 273.2 40.17 219.8 96.2 200.1C96.07 197.4 96 194.7 96 192C96 103.6 167.6 32 256 32V32zM528 192C528 147.8 492.2 112 448 112C431.5 112 416.3 116.1 403.6 125.5C399.9 127.9 395.4 128.7 391.1 127.7C386.7 126.7 383 123.1 380.8 120.2C355.9 76.99 309.3 48 256 48C176.5 48 112 112.5 112 192C112 194.5 112.1 196.9 112.2 199.3C112.5 206.4 108.2 212.9 101.5 215.2C51.68 232.7 16 280.2 16 336C16 406.7 73.31 464 144 464H512C573.9 464 624 413.9 624 352C624 297.8 585.5 252.6 534.4 242.2C529.8 241.3 525.8 238.4 523.6 234.2C521.3 230.1 520.1 225.2 522.7 220.8C526.1 211.9 528 202.2 528 192V192z"],
    "cloud-bolt": [512, 512, [127785, "thunderstorm"], "f76c", "M418.6 125.4C418.9 122.8 419 120 419 117.2c0-47.42-38.36-86-85.5-86c-21.31 0-41.73 8.188-57.48 22.77C254.7 20.42 218.2 0 178.5 0C114.3 0 61.1 52.58 61.1 117.2c0 5.141 .3597 10.25 1.078 15.48C25.08 148.1 0 184.9 0 226.4C0 282.4 45.31 328 101 328h27.5c4.422 0 8-3.578 8-8s-3.578-8-8-8H101C54.13 312 16 273.6 16 226.4c0-36.89 23.53-69.41 58.56-80.88l6.703-2.203L79.92 136.4C78.63 129.8 77.1 123.5 77.1 117.2C77.1 61.41 123.1 16 178.5 16c37.36 0 71.39 21.03 88.8 54.89l5.5 10.72l7.734-9.234c13.61-16.23 32.42-25.17 52.97-25.17c38.33 0 69.5 31.41 69.5 70c0 5.125-.4531 9.75-1.406 14.17L401.1 140.8h9.891c46.88 0 85 38.41 85 85.61S457.9 312 411 312H352c-4.422 0-8 3.578-8 8s3.578 8 8 8h59C466.7 328 512 282.4 512 226.4C512 173.4 471.5 129.8 418.6 125.4zM324 360H206.9l118.3-122.4c3.062-3.188 3-8.25-.1875-11.31c-3.188-3.031-8.25-2.969-11.31 .1875l-131.5 136c-2.219 2.312-2.875 5.719-1.625 8.688S184.8 376 188 376h117.1l-118.3 122.4c-3.062 3.188-3 8.25 .1875 11.31C188.5 511.3 190.5 512 192.5 512c2.094 0 4.188-.8125 5.75-2.438l131.5-136c2.219-2.312 2.875-5.719 1.625-8.688S327.2 360 324 360z"],
    "cloud-bolt-moon": [576, 512, ["thunderstorm-moon"], "f76d", "M351.9 218.8C342.6 179.8 308.7 152 269.6 152c-10.34 0-20.53 2.031-30.38 6.047C220 133.8 192.2 120 161.9 120c-53.34 0-97.09 43.36-99.95 99.33C25.69 229.8 0 264.4 0 304c0 48.53 38.11 88 84.95 88c4.422 0 8-3.578 8-8s-3.578-8-8-8C46.94 376 16 343.7 16 304c0-34.27 23.3-63.94 55.41-70.55l6.156-2.938V224c0-48.53 37.83-88 84.33-88c32.6 0 54.27 16.57 72.17 42.25C255.2 167.7 263.1 168 269.6 168c11.95 0 57.1 4.785 68.61 64.34l5.422 1.016C376.4 239.5 400.1 269.2 399.1 304c0 39.7-30.94 72-68.95 72h-28.84c-4.422 0-8 3.578-8 8s3.578 8 8 8h28.84c46.84 0 84.96-39.49 84.96-87.99C416.1 263.4 389.5 228.5 351.9 218.8zM574.1 218.6c-3.047-5.375-8.891-8.156-15.27-7.047c-29.33 5.609-59.4-2.094-82.34-21.09c-22.7-18.78-35.72-46.38-35.72-75.69c0-35.38 19.27-68.23 50.28-85.75c5.344-3.031 8.125-8.891 7.094-14.94c-1.031-6.016-5.594-10.61-11.56-11.69C478.3 .7969 469.3 0 460.1 0c-77.58 0-141 60.58-144.4 137.9c-.1875 4.422 3.234 8.156 7.641 8.359c4.703 0 8.141-3.266 8.359-7.641C334.7 69.86 391.1 16 460.1 16c6.672 0 13.12 .4687 19.25 1.375c-33.75 20.83-54.53 57.73-54.53 97.39c0 34.09 15.14 66.17 41.52 88.02c26.11 21.62 60.09 30.55 91.98 24.12c-1.855 2.174-41.09 52.12-111.8 43.72c-4.406-.5625-8.312 2.766-8.75 7.156c-.4531 4.391 2.766 8.312 7.156 8.75C452.2 287.4 455.6 288 460.1 288c43.91 0 84.92-19.41 112.3-53.06C576.5 230.3 577.1 223.9 574.1 218.6zM252 376H150.9l102.9-106.4c3.062-3.188 3-8.25-.1875-11.31C250.4 255.2 245.3 255.3 242.3 258.4l-116 120c-2.219 2.312-2.875 5.719-1.625 8.688S128.8 392 132 392h101.1l-102.9 106.4c-3.062 3.188-3 8.25 .1875 11.31C132 511.3 133.1 512 136 512c2.094 0 4.188-.8125 5.75-2.438l116-120c2.219-2.312 2.875-5.719 1.625-8.688S255.2 376 252 376z"],
    "cloud-bolt-sun": [640, 512, ["thunderstorm-sun"], "f76e", "M157.5 300.1l-52.89 17.7C102 319.5 100.4 318.2 99.75 317.5C99.03 316.8 97.94 315.3 98.7 312.1l26.38-79.16L50.56 196.5C48.25 195.3 48 193.2 48 192.4c0-.8457 .25-2.943 2.531-4.102l74.55-37.36l-26.38-79.11C97.89 69.28 99.19 67.62 99.78 67.02c.5469-.5957 2.109-1.926 4.562-1.049l79.03 26.42l37.27-74.64c1.172-2.316 3.266-2.568 4.109-2.568S227.7 15.44 228.8 17.72l37.3 74.67l78.98-26.42c2.438-.8145 4.156 .4531 4.75 1.08c.5781 .5781 1.844 2.176 1.047 4.586l-7.016 21.16c-1.391 4.195 .875 8.734 5.078 10.13c4.141 1.439 8.734-.9082 10.11-5.086L366.1 76.66c2.453-7.434 .5625-15.45-4.922-20.94c-5.5-5.539-13.61-7.434-21.09-4.961L274.2 72.8L243.1 10.53C236-3.498 213.5-3.529 206.3 10.56L175.3 72.8L109.4 50.76C101.1 48.27 93.94 50.18 88.47 55.69C82.95 61.22 81.05 69.29 83.52 76.82l22 65.97L43.34 173.9C36.34 177.5 32 184.5 32 192.4C32 200.2 36.34 207.2 43.38 210.8l62.14 31.11l-22 66.01c-2.438 7.387-.5781 15.4 4.859 20.91c3.938 3.975 9.188 6.119 14.66 6.119c2.156 0 4.344-.3457 6.5-1.018l53-17.73C166.7 314.8 168.1 310.2 167.6 306.1C166.2 301.9 161.7 299.6 157.5 300.1zM171.2 192.3c0-29.61 23.66-53.7 52.75-53.7c9.688 0 19.28 2.863 27.75 8.264c3.703 2.361 8.672 1.299 11.05-2.459c2.375-3.725 1.281-8.686-2.453-11.06c-11.05-7.043-23.61-10.77-36.34-10.77c-37.91 0-68.75 31.27-68.75 69.72c0 19.58 8.031 37.81 22.61 51.33c1.547 1.426 3.484 2.129 5.438 2.129c2.156 0 4.297-.8613 5.875-2.566c3-3.256 2.797-8.326-.4375-11.33C177.4 221.4 171.2 207.3 171.2 192.3zM543.9 218.3c-9.344-39.08-43.16-66.92-82.3-66.92c-10.34 0-20.53 2.035-30.38 6.057c-19.22-24.3-47.06-38.11-77.34-38.11c-53.34 0-97.09 43.43-99.95 99.49C217.7 229.3 192 264 192 303.7c0 48.61 38.11 88.14 84.95 88.14c4.422 0 8-3.584 8-8.012c0-4.43-3.578-8.014-8-8.014C238.9 375.8 208 343.4 208 303.7c0-34.32 23.3-64.04 55.41-70.66l6.156-2.943V223.5c0-48.61 37.83-88.14 84.33-88.14c27.14 0 52 13.35 68.22 36.64l3.953 5.68l6.188-3.098c9.484-4.758 19.36-7.168 29.36-7.168c33.13 0 61.56 24.8 67.64 59L530.2 231.9l5.422 1.016C568.4 239.1 592.1 268.8 592 303.7c0 39.77-30.94 72.12-68.95 72.12h-28.84c-4.422 0-8 3.584-8 8.014c0 4.428 3.578 8.012 8 8.012h28.84C569.9 391.8 608 352.5 608 303.9C608.1 263.3 581.5 228 543.9 218.3zM444 376h-101.1l102.9-106.4c3.078-3.188 2.984-8.25-.1875-11.31c-3.172-3.031-8.219-2.969-11.31 .1875l-116 120c-2.234 2.312-2.875 5.719-1.609 8.688C317.9 390.1 320.8 392 324 392h101.1l-102.9 106.4c-3.078 3.188-2.984 8.25 .1875 11.31C324 511.3 325.1 512 328 512c2.094 0 4.188-.8125 5.75-2.438l116-120c2.234-2.312 2.875-5.719 1.609-8.688C450.1 377.9 447.2 376 444 376z"],
    "cloud-check": [640, 512, [], "e35c", "M293.7 357.7C290.5 360.8 285.5 360.8 282.3 357.7L218.3 293.7C215.2 290.5 215.2 285.5 218.3 282.3C221.5 279.2 226.5 279.2 229.7 282.3L288 340.7L410.3 218.3C413.5 215.2 418.5 215.2 421.7 218.3C424.8 221.5 424.8 226.5 421.7 229.7L293.7 357.7zM256 32C309.6 32 356.1 58.31 386 98.71C389.1 103 392 107.5 394.7 112.2C398.2 109.8 401.9 107.7 405.7 105.8C418.5 99.52 432.8 96 448 96C501 96 544 138.1 544 192C544 198.6 543.3 204.1 542.1 211.2C541 216.5 539.5 221.6 537.6 226.6C542.9 227.6 548.1 229 553.1 230.7C603.6 247.9 640 295.7 640 352C640 422.7 582.7 480 512 480H144C64.47 480 0 415.5 0 336C0 273.2 40.17 219.8 96.2 200.1C96.07 197.4 96 194.7 96 192C96 103.6 167.6 32 256 32V32zM528 192C528 147.8 492.2 112 448 112C431.5 112 416.3 116.1 403.6 125.5C399.9 127.9 395.4 128.7 391.1 127.7C386.7 126.7 383 123.1 380.8 120.2C355.9 76.99 309.3 48 256 48C176.5 48 112 112.5 112 192C112 194.5 112.1 196.9 112.2 199.3C112.5 206.4 108.2 212.9 101.5 215.2C51.68 232.7 16 280.2 16 336C16 406.7 73.31 464 144 464H512C573.9 464 624 413.9 624 352C624 297.8 585.5 252.6 534.4 242.2C529.8 241.3 525.8 238.4 523.6 234.2C521.3 230.1 520.1 225.2 522.7 220.8C526.1 211.9 528 202.2 528 192V192z"],
    "cloud-drizzle": [512, 512, [], "f738", "M56 360c-4.422 0-8 3.578-8 8v56c0 4.422 3.578 8 8 8S64 428.4 64 424V368C64 363.6 60.42 360 56 360zM248 360c-4.422 0-8 3.578-8 8v56c0 4.422 3.578 8 8 8S256 428.4 256 424V368C256 363.6 252.4 360 248 360zM152 440c-4.422 0-8 3.578-8 8v56C144 508.4 147.6 512 152 512S160 508.4 160 504V448C160 443.6 156.4 440 152 440zM440 360c-4.422 0-8 3.578-8 8v56c0 4.422 3.578 8 8 8S448 428.4 448 424V368C448 363.6 444.4 360 440 360zM344 440c-4.422 0-8 3.578-8 8v56c0 4.422 3.578 8 8 8S352 508.4 352 504V448C352 443.6 348.4 440 344 440zM416 128c-.625 0-1.125 .25-1.625 .25C415.5 123 416 117.6 416 112C416 67.75 380.3 32 336 32c-24.62 0-46.25 11.25-61 28.75C256.4 24.75 219.3 0 176 0C114.1 0 64 50.13 64 112c0 7.25 .75 14.25 2.125 21.25C27.75 145.8 0 181.5 0 224c0 53 43 96 96 96h320c53 0 96-43 96-96S469 128 416 128zM416 304H96C51.89 304 16 268.1 16 224c0-34.45 22.13-64.81 55.08-75.54l13.48-4.391L81.82 130.2C80.6 123.9 80 117.1 80 112c0-52.94 43.06-96 96-96c35.67 0 68.16 19.96 84.79 52.1l11.01 21.28l15.44-18.32C299.8 56.19 317.1 48 336 48c35.29 0 64 28.71 64 64c0 4.691-.416 8.91-1.27 12.9l-4.148 19.35h19.79c1.104 0 2.068-.1035 2.902-.2402C460.8 144.7 496 180.3 496 224C496 268.1 460.1 304 416 304z"],
    "cloud-exclamation": [640, 512, [], "e491", "M320 160C324.4 160 328 163.6 328 168V328C328 332.4 324.4 336 320 336C315.6 336 312 332.4 312 328V168C312 163.6 315.6 160 320 160zM336 384C336 392.8 328.8 400 320 400C311.2 400 304 392.8 304 384C304 375.2 311.2 368 320 368C328.8 368 336 375.2 336 384zM256 32C309.6 32 356.1 58.31 386 98.71C389.1 103 392 107.5 394.7 112.2C398.2 109.8 401.9 107.7 405.7 105.8C418.5 99.52 432.8 96 448 96C501 96 544 138.1 544 192C544 198.6 543.3 204.1 542.1 211.2C541 216.5 539.5 221.6 537.6 226.6C542.9 227.6 548.1 229 553.1 230.7C603.6 247.9 640 295.7 640 352C640 422.7 582.7 480 512 480H144C64.47 480 0 415.5 0 336C0 273.2 40.17 219.8 96.2 200.1C96.07 197.4 96 194.7 96 192C96 103.6 167.6 32 256 32V32zM528 192C528 147.8 492.2 112 448 112C431.5 112 416.3 116.1 403.6 125.5C399.9 127.9 395.4 128.7 391.1 127.7C386.7 126.7 383 123.1 380.8 120.2C355.9 76.99 309.3 48 256 48C176.5 48 112 112.5 112 192C112 194.5 112.1 196.9 112.2 199.3C112.5 206.4 108.2 212.9 101.5 215.2C51.68 232.7 16 280.2 16 336C16 406.7 73.31 464 144 464H512C573.9 464 624 413.9 624 352C624 297.8 585.5 252.6 534.4 242.2C529.8 241.3 525.8 238.4 523.6 234.2C521.3 230.1 520.1 225.2 522.7 220.8C526.1 211.9 528 202.2 528 192V192z"],
    "cloud-fog": [640, 512, [127787, "fog"], "f74e", "M160 320h320c53 0 96-43 96-96s-43-96-96-96c-.625 0-1.125 .25-1.625 .25C479.5 122.1 480 117.6 480 112C480 67.75 444.3 32 400 32c-24.62 0-46.25 11.25-61 28.75C320.4 24.75 283.3 0 240 0C178.1 0 128 50.13 128 112c0 7.25 .75 14.25 2.125 21.25C91.75 145.7 64 181.5 64 224C64 277 107 320 160 320zM135.1 148.5l13.48-4.391L145.8 130.2C144.6 123.9 144 117.1 144 112c0-52.93 43.06-96 96-96c35.67 0 68.16 19.96 84.79 52.1l11.01 21.28l15.44-18.32C363.8 56.19 381.1 48 400 48c35.29 0 64 28.71 64 64c0 4.691-.416 8.91-1.27 12.9l-4.148 19.35h19.79c1.104 0 2.068-.1016 2.902-.2383C524.8 144.7 560 180.3 560 224c0 44.11-35.89 80-80 80H160C115.9 304 80 268.1 80 224C80 189.6 102.1 159.2 135.1 148.5zM576 408c0-4.406-3.578-8-8-8H8C3.578 400 0 403.6 0 408S3.578 416 8 416h560C572.4 416 576 412.4 576 408zM632 496H296C291.6 496 288 499.6 288 504S291.6 512 295.1 512H632c4.422 0 8-3.594 8-8S636.4 496 632 496zM216 496h-144C67.58 496 64 499.6 64 504S67.58 512 72 512h144C220.4 512 224 508.4 224 504S220.4 496 216 496z"],
    "cloud-hail": [512, 512, [], "f739", "M384 352c-17.75 0-32 14.25-32 32s14.25 32 32 32s32-14.25 32-32S401.8 352 384 352zM384 400c-8.973 0-16-7.029-16-16c0-8.973 7.027-16 16-16s16 7.027 16 16C400 392.1 392.1 400 384 400zM192 448c-17.75 0-32 14.25-32 32s14.25 32 32 32s32-14.25 32-32S209.8 448 192 448zM192 496c-8.973 0-16-7.029-16-16c0-8.973 7.027-16 16-16s16 7.027 16 16C208 488.1 200.1 496 192 496zM320 448c-17.75 0-32 14.25-32 32s14.25 32 32 32s32-14.25 32-32S337.8 448 320 448zM320 496c-8.973 0-16-7.029-16-16c0-8.973 7.027-16 16-16s16 7.027 16 16C336 488.1 328.1 496 320 496zM256 352c-17.75 0-32 14.25-32 32s14.25 32 32 32s32-14.25 32-32S273.8 352 256 352zM256 400c-8.973 0-16-7.029-16-16c0-8.973 7.027-16 16-16s16 7.027 16 16C272 392.1 264.1 400 256 400zM64 448c-17.75 0-32 14.25-32 32s14.25 32 32 32s32-14.25 32-32S81.75 448 64 448zM64 496c-8.973 0-16-7.029-16-16c0-8.973 7.027-16 16-16s16 7.027 16 16C80 488.1 72.97 496 64 496zM128 352c-17.75 0-32 14.25-32 32s14.25 32 32 32s32-14.25 32-32S145.8 352 128 352zM128 400c-8.973 0-16-7.029-16-16c0-8.973 7.027-16 16-16s16 7.027 16 16C144 392.1 136.1 400 128 400zM416 128c-.625 0-1.125 .25-1.625 .25C415.5 122.1 416 117.6 416 112C416 67.75 380.3 32 336 32c-24.62 0-46.25 11.25-61 28.75C256.4 24.75 219.3 0 176 0C114.1 0 64 50.13 64 112c0 7.25 .75 14.25 2.125 21.25C27.75 145.7 0 181.5 0 224c0 53 43 96 96 96h320c53 0 96-43 96-96S469 128 416 128zM416 304H96C51.89 304 16 268.1 16 224c0-34.45 22.13-64.81 55.08-75.54l13.48-4.391L81.82 130.2C80.6 123.9 80 117.1 80 112c0-52.94 43.06-96 96-96c35.67 0 68.16 19.96 84.79 52.1l11.01 21.28l15.44-18.32C299.8 56.19 317.1 48 336 48c35.29 0 64 28.71 64 64c0 4.691-.416 8.91-1.27 12.9l-4.148 19.35h19.79c1.104 0 2.068-.1035 2.902-.2402C460.8 144.7 496 180.3 496 224C496 268.1 460.1 304 416 304z"],
    "cloud-hail-mixed": [512, 512, [], "f73a", "M177.2 371.8l-80 128c-2.344 3.734-1.203 8.672 2.547 11.02C101.1 511.6 102.5 512 104 512c2.656 0 5.266-1.328 6.781-3.766l80-128c2.344-3.734 1.203-8.672-2.547-11.02C184.5 366.9 179.6 368 177.2 371.8zM32 448c-17.75 0-32 14.25-32 32s14.25 32 32 32s32-14.25 32-32S49.75 448 32 448zM32 496c-8.973 0-16-7.029-16-16c0-8.973 7.027-16 16-16s16 7.027 16 16C48 488.1 40.97 496 32 496zM81.22 371.8l-25 40c-2.344 3.734-1.203 8.672 2.547 11.02C60.08 423.6 61.55 424 63 424c2.656 0 5.266-1.328 6.781-3.766l25-40c2.344-3.734 1.203-8.672-2.547-11.02C88.55 366.9 83.58 368 81.22 371.8zM369.2 371.8l-80 128c-2.344 3.734-1.203 8.672 2.547 11.02C293.1 511.6 294.5 512 296 512c2.656 0 5.266-1.328 6.781-3.766l80-128c2.344-3.734 1.203-8.672-2.547-11.02C376.6 366.9 371.6 368 369.2 371.8zM465.2 371.8l-24 38.41c-2.344 3.734-1.203 8.672 2.547 11.02C445.1 422 446.5 422.4 448 422.4c2.656 0 5.266-1.328 6.781-3.766l24-38.41c2.344-3.734 1.203-8.672-2.547-11.02C472.5 366.9 467.6 368 465.2 371.8zM224 448c-17.75 0-32 14.25-32 32s14.25 32 32 32s32-14.25 32-32S241.8 448 224 448zM224 496c-8.973 0-16-7.029-16-16c0-8.973 7.027-16 16-16s16 7.027 16 16C240 488.1 232.1 496 224 496zM416 448c-17.75 0-32 14.25-32 32s14.25 32 32 32s32-14.25 32-32S433.8 448 416 448zM416 496c-8.973 0-16-7.029-16-16c0-8.973 7.027-16 16-16s16 7.027 16 16C432 488.1 424.1 496 416 496zM273.2 371.8l-24 38.41c-2.344 3.734-1.203 8.672 2.547 11.02C253.1 422 254.5 422.4 256 422.4c2.656 0 5.266-1.328 6.781-3.766l24-38.41c2.344-3.734 1.203-8.672-2.547-11.02C280.5 366.9 275.6 368 273.2 371.8zM416 128c-.625 0-1.125 .25-1.625 .25C415.5 123 416 117.6 416 112C416 67.75 380.3 32 336 32c-24.62 0-46.25 11.25-61 28.75C256.4 24.75 219.3 0 176 0C114.1 0 64 50.13 64 112c0 7.25 .75 14.25 2.125 21.25C27.75 145.8 0 181.5 0 224c0 53 43 96 96 96h320c53 0 96-43 96-96S469 128 416 128zM416 304H96C51.89 304 16 268.1 16 224c0-34.45 22.13-64.81 55.08-75.54l13.48-4.391L81.82 130.2C80.6 123.9 80 117.1 80 112c0-52.94 43.06-96 96-96c35.67 0 68.16 19.96 84.79 52.1l11.01 21.28l15.44-18.32C299.8 56.19 317.1 48 336 48c35.29 0 64 28.71 64 64c0 4.691-.416 8.91-1.27 12.9l-4.148 19.35h19.79c1.104 0 2.068-.1035 2.902-.2402C460.8 144.7 496 180.3 496 224C496 268.1 460.1 304 416 304z"],
    "cloud-meatball": [576, 512, [], "f73b", "M80 352C53.5 352 32 373.5 32 400S53.5 448 80 448S128 426.5 128 400S106.5 352 80 352zM80 432c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S97.64 432 80 432zM496 352c-26.5 0-48 21.5-48 48s21.5 48 48 48s48-21.5 48-48S522.5 352 496 352zM496 432c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S513.6 432 496 432zM377 363.1c4.625-14.5 1.625-30.87-9.75-42.37c-8.078-8.078-18.56-11.9-29.11-11.9c-4.471 0-8.951 .6855-13.27 2.025c-7-13.5-20.62-23-36.88-23s-29.88 9.5-36.88 23C246.8 309.5 242.3 308.8 237.8 308.8c-10.54 0-21.01 3.883-29.08 11.96c-11.5 11.5-14.38 27.87-9.875 42.37c-13.5 7-23 20.62-23 36.88s9.5 29.88 23 36.88c-4.625 14.5-1.625 30.87 9.875 42.37c8.25 8.125 18.1 12.25 29.75 12.25c4.25 0 8.5-1.125 12.62-2.5C258.1 502.5 271.8 512 288 512s29.88-9.5 36.88-23c4.125 1.25 8.375 2.5 12.62 2.5c10.75 0 21.5-4.125 29.75-12.25c11.5-11.5 14.38-27.87 9.75-42.37C390.5 429.9 400 416.3 400 400S390.5 370.1 377 363.1zM369.6 422.7c-6.92 3.588-10.25 11.64-7.879 19.07c3.086 9.676 .9102 19.47-5.732 26.11c-13.32 13.12-25.16 5.148-31.15 5.148c-5.848 0-11.4 3.221-14.2 8.637C306 490.6 297.5 496 288 496s-18.01-5.371-22.67-14.37c-2.814-5.428-8.367-8.639-14.21-8.639c-5.521 0-17.88 7.92-31.06-5.061c-6.689-6.688-8.967-16.73-5.945-26.2c2.367-7.426-.959-15.48-7.879-19.07C197.2 418 191.9 409.5 191.9 400c0-9.533 5.371-18.01 14.37-22.67c6.877-3.566 10.21-11.55 7.916-18.95c-3.027-9.754-.8184-19.59 5.908-26.32c12.3-12.3 26.64-5.186 31.06-5.186c5.842 0 11.39-3.217 14.21-8.637C269.1 309.2 278.5 303.9 288 303.9s18.01 5.369 22.67 14.37c2.809 5.418 8.357 8.637 14.2 8.637c4.248 0 18.94-6.939 31 5.125c6.65 6.723 8.904 16.79 5.881 26.26c-2.367 7.426 .959 15.48 7.879 19.07C378.6 381.1 384 390.5 384 400C384 409.5 378.6 418 369.6 422.7zM543.1 225.8C544.1 172 501.6 128 448 128c-.625 0-1.125 .25-1.625 .25C447.5 123 448 117.6 448 112c.002-34.1-21.76-66.3-55.3-76.3c-34.62-10.32-66.18 1.891-85.7 25.05C286.1 20.26 241.7-5.1 191.6 1.182c-51.55 7.381-91.5 51.15-95.27 103.1C95.55 114.3 96.27 123.8 98.13 133.3C58.88 146 30.74 183.1 32.04 226.9C33.6 279.3 78.68 320 131.1 320H152C156.4 320 160 316.4 160 312S156.4 304 152 304H130.4c-38.86 0-73.85-26.7-81.01-64.89c-7.572-40.4 15.97-78.37 53.67-90.65l13.48-4.391L113.8 130.2C112.6 123.9 112 117.1 112 112c0-40.36 24.65-76.62 62.67-90.15c47.6-16.94 96.39 4.27 118.1 46.25l11.01 21.28l15.44-18.32c14.73-17.47 36.07-25.72 58.83-22.3c33.42 5.027 56.25 34.76 53.75 68.46c-.1992 2.684-.5586 5.225-1.084 7.676L426.6 144.3h19.79c1.104 0 2.068-.1035 2.902-.2402c45.48 .7187 81.87 39.58 78.51 85.93C524.7 272.2 487.6 304 445.2 304H424C419.6 304 416 307.6 416 312S419.6 320 424 320h20.8C497.6 320 542.1 278.7 543.1 225.8z"],
    "cloud-minus": [640, 512, [], "e35d", "M416 280C420.4 280 424 283.6 424 288C424 292.4 420.4 296 416 296H224C219.6 296 216 292.4 216 288C216 283.6 219.6 280 224 280H416zM256 32C309.6 32 356.1 58.31 386 98.71C389.1 103 392 107.5 394.7 112.2C398.2 109.8 401.9 107.7 405.7 105.8C418.5 99.52 432.8 96 448 96C501 96 544 138.1 544 192C544 198.6 543.3 204.1 542.1 211.2C541 216.5 539.5 221.6 537.6 226.6C542.9 227.6 548.1 229 553.1 230.7C603.6 247.9 640 295.7 640 352C640 422.7 582.7 480 512 480H144C64.47 480 0 415.5 0 336C0 273.2 40.17 219.8 96.2 200.1C96.07 197.4 96 194.7 96 192C96 103.6 167.6 32 256 32V32zM528 192C528 147.8 492.2 112 448 112C431.5 112 416.3 116.1 403.6 125.5C399.9 127.9 395.4 128.7 391.1 127.7C386.7 126.7 383 123.1 380.8 120.2C355.9 76.99 309.3 48 256 48C176.5 48 112 112.5 112 192C112 194.5 112.1 196.9 112.2 199.3C112.5 206.4 108.2 212.9 101.5 215.2C51.68 232.7 16 280.2 16 336C16 406.7 73.31 464 144 464H512C573.9 464 624 413.9 624 352C624 297.8 585.5 252.6 534.4 242.2C529.8 241.3 525.8 238.4 523.6 234.2C521.3 230.1 520.1 225.2 522.7 220.8C526.1 211.9 528 202.2 528 192V192z"],
    "cloud-moon": [576, 512, [], "f6c3", "M573.6 294.4c-3.641-6.078-10.5-9.125-17.42-7.75c-40.06 7.641-81.05-2.844-112.4-28.81c-31.44-26-49.47-64.3-49.47-105.1c0-48.94 26.47-94.42 68.1-118.7c6.172-3.453 9.406-10.19 8.266-17.16c-1.172-7.016-6.406-12.38-13.39-13.66c-122.4-22.08-227.4 71.47-227.4 189.1c0 1.922 .1719 3.797 .3438 5.672l.25 2.984C231.6 205.4 234.1 208.1 239.7 208.6C244.1 208.4 247.5 204.6 247.3 200.2L247 196.5C246.9 195.1 246.7 193.8 246.7 192.4c0-97.25 79.06-176.4 176.2-176.4c10.61 0 21.17 .9844 32.39 4.125c-47.58 27.14-77.12 77.95-77.12 132.6c0 45.56 20.14 88.36 55.26 117.4c35.08 28.98 80.8 40.69 126.3 33.2c-27.67 34.11-67.09 56.45-110.1 62.91c-4.359 .6562-7.391 4.719-6.75 9.094c.5938 3.969 4.016 6.828 7.906 6.828c.3906 0 .7813-.0313 1.188-.0781c47.86-7.047 90.86-31.44 121.1-68.67C576.7 307.1 577.2 300.5 573.6 294.4zM342.7 352.7c5.75-9.625 9.25-20.75 9.25-32.75c0-35.25-28.75-64-63.1-64c-17.25 0-32.75 6.875-44.25 17.87C227.4 244.2 196.2 223.1 159.1 223.1c-52.1 0-96 43.06-96 96.06c0 2 .5029 3.687 .6279 5.687c-37.5 13-64.62 48.37-64.62 90.25C-.0048 469 42.99 512 95.99 512h239.1c44.25 0 79.1-35.75 79.1-80C415.1 390.1 383.7 356.2 342.7 352.7zM335.1 495.1h-239.1c-44.11 0-79.1-35.89-79.1-80c0-33.77 21.65-63.96 53.86-75.13l11.49-3.982l-.7578-12.13c-.084-1.357-.2598-2.645-.5937-4.754c0-44.11 35.89-80 79.1-80c28.83 0 55.56 15.95 69.75 41.62l10.05 18.18L254.8 285.4c9.058-8.666 20.85-13.44 33.19-13.44c26.47 0 47.1 21.53 47.1 48c0 8.527-2.35 16.79-6.986 24.54l-13.12 21.97l25.5 2.176c33.41 2.852 58.61 30.07 58.61 63.31C399.1 467.3 371.3 495.1 335.1 495.1z"],
    "cloud-moon-rain": [576, 512, [], "f73c", "M350.5 225.5c-6.875-37.25-39.26-65.5-78.51-65.5c-12.25 0-23.88 3-34.25 7.1c-17.5-24.12-45.63-39.1-77.76-39.1c-53 0-96.01 43-96.01 95.1c0 .4999 .25 1.125 .25 1.625C27.63 232.9 0 265.3 0 304c0 44.24 35.75 79.1 80.01 79.1h256c44.25 0 80.01-35.75 80.01-79.1C416 264.8 387.8 232.3 350.5 225.5zM336 368H80c-35.29 0-64-28.71-64-63.99c0-30.43 21.6-56.78 51.36-62.67l12.89-2.552V225.7c0-1.129-.1113-2.127-.2402-2.918C80.7 179.2 116.3 144 160 144c25.79 0 49.41 12.17 64.8 33.39l7.852 10.82l12.05-5.806c8.83-4.253 18.02-6.411 27.3-6.411c30.76 0 57.16 22.04 62.77 52.4l2.006 10.87l10.88 1.97c30.34 5.497 52.36 31.89 52.36 62.75C400 339.3 371.3 368 336 368zM65.13 419.9L17.13 499.9c-2.25 3.781-1.031 8.702 2.75 10.97C21.19 511.6 22.59 512 24 512c2.719 0 5.375-1.39 6.875-3.89l48-79.99c2.25-3.781 1.031-8.702-2.75-10.97C72.22 414.9 67.38 416.1 65.13 419.9zM161.1 419.9l-48 79.99c-2.25 3.781-1.031 8.702 2.75 10.97C117.2 511.6 118.6 512 120 512c2.719 0 5.375-1.39 6.875-3.89l48-79.99c2.25-3.781 1.031-8.702-2.75-10.97C168.3 414.9 163.4 416.1 161.1 419.9zM257.1 419.9l-48 79.99c-2.25 3.781-1.031 8.702 2.75 10.97C213.2 511.6 214.6 512 216 512c2.719 0 5.375-1.39 6.875-3.89l48-79.99c2.25-3.781 1.031-8.702-2.75-10.97C264.3 414.9 259.4 416.1 257.1 419.9zM353.1 419.9L305.1 499.9c-2.25 3.781-1.031 8.702 2.75 10.97C309.2 511.6 310.6 512 312 512c2.719 0 5.375-1.39 6.875-3.89l48-79.99c2.25-3.781 1.031-8.702-2.75-10.97C360.3 414.9 355.4 416.1 353.1 419.9zM574.1 218.4c-3.094-5.327-8.875-7.968-15.09-6.921c-28.38 5.515-57.53-1.937-79.91-20.37c-22.78-18.83-35.88-46.67-35.88-76.4c0-35.42 18.91-68.27 49.41-85.79c5.25-3.062 8-8.936 6.938-14.95c-1.062-5.984-5.418-10.56-11.29-11.64C480 .8009 470.9 0 461.8 0c-70.47 0-130.6 53.74-140.1 125c-.5625 4.374 2.5 8.39 6.875 8.983c4.688 .4999 8.407-2.515 9-6.89c8.407-63.35 61.88-111.1 124.3-111.1c6.531 0 12.88 .4687 18.84 1.375c-33.19 20.81-53.63 57.73-53.63 97.38c0 34.53 15.19 66.87 41.69 88.72c24.84 20.51 56.85 29.36 88.5 24.56c-24.03 27.98-58.5 43.93-94.6 43.98c-4.313-.5624-9.094 3.14-9.094 7.937c0 4.406 3.738 7.947 8.144 7.947c43.22 0 83.7-19.37 110.7-53.04C576.5 230.2 577.1 223.7 574.1 218.4zM484.5 15.13C484.5 15.13 484.6 15.13 484.5 15.13L484.5 15.13z"],
    "cloud-music": [640, 512, [], "f8ae", "M277.2 243.6C274.1 244.8 272 247.8 272 251.1V360C272 382.1 250.5 400 224 400C197.5 400 176 382.1 176 360C176 337.9 197.5 320 224 320C236.3 320 247.5 323.9 256 330.2V251.1C256 241.1 262.2 232.1 271.6 228.6L367.6 192.6C383.3 186.7 400 198.3 400 215.1V328C400 350.1 378.5 368 352 368C325.5 368 304 350.1 304 328C304 305.9 325.5 288 352 288C364.3 288 375.5 291.9 384 298.2V215.1C384 209.5 378.4 205.6 373.2 207.6L277.2 243.6zM192 360C192 370.6 203.5 384 224 384C244.5 384 256 370.6 256 360C256 349.4 244.5 336 224 336C203.5 336 192 349.4 192 360zM384 328C384 317.4 372.5 304 352 304C331.5 304 320 317.4 320 328C320 338.6 331.5 352 352 352C372.5 352 384 338.6 384 328zM256 32C309.6 32 356.1 58.31 386 98.71C389.1 103 392 107.5 394.7 112.2C398.2 109.8 401.9 107.7 405.7 105.8C418.5 99.52 432.8 96 448 96C501 96 544 138.1 544 192C544 198.6 543.3 204.1 542.1 211.2C541 216.5 539.5 221.6 537.6 226.6C542.9 227.6 548.1 229 553.1 230.7C603.6 247.9 640 295.7 640 352C640 422.7 582.7 480 512 480H144C64.47 480 0 415.5 0 336C0 273.2 40.17 219.8 96.2 200.1C96.07 197.4 96 194.7 96 192C96 103.6 167.6 32 256 32V32zM528 192C528 147.8 492.2 112 448 112C431.5 112 416.3 116.1 403.6 125.5C399.9 127.9 395.4 128.7 391.1 127.7C386.7 126.7 383 123.1 380.8 120.2C355.9 76.99 309.3 48 256 48C176.5 48 112 112.5 112 192C112 194.5 112.1 196.9 112.2 199.3C112.5 206.4 108.2 212.9 101.5 215.2C51.68 232.7 16 280.2 16 336C16 406.7 73.31 464 144 464H512C573.9 464 624 413.9 624 352C624 297.8 585.5 252.6 534.4 242.2C529.8 241.3 525.8 238.4 523.6 234.2C521.3 230.1 520.1 225.2 522.7 220.8C526.1 211.9 528 202.2 528 192V192z"],
    "cloud-plus": [640, 512, [], "e35e", "M312 384V296H224C219.6 296 216 292.4 216 288C216 283.6 219.6 280 224 280H312V192C312 187.6 315.6 184 320 184C324.4 184 328 187.6 328 192V280H416C420.4 280 424 283.6 424 288C424 292.4 420.4 296 416 296H328V384C328 388.4 324.4 392 320 392C315.6 392 312 388.4 312 384zM256 32C309.6 32 356.1 58.31 386 98.71C389.1 103 392 107.5 394.7 112.2C398.2 109.8 401.9 107.7 405.7 105.8C418.5 99.52 432.8 96 448 96C501 96 544 138.1 544 192C544 198.6 543.3 204.1 542.1 211.2C541 216.5 539.5 221.6 537.6 226.6C542.9 227.6 548.1 229 553.1 230.7C603.6 247.9 640 295.7 640 352C640 422.7 582.7 480 512 480H144C64.47 480 0 415.5 0 336C0 273.2 40.17 219.8 96.2 200.1C96.07 197.4 96 194.7 96 192C96 103.6 167.6 32 256 32V32zM528 192C528 147.8 492.2 112 448 112C431.5 112 416.3 116.1 403.6 125.5C399.9 127.9 395.4 128.7 391.1 127.7C386.7 126.7 383 123.1 380.8 120.2C355.9 76.99 309.3 48 256 48C176.5 48 112 112.5 112 192C112 194.5 112.1 196.9 112.2 199.3C112.5 206.4 108.2 212.9 101.5 215.2C51.68 232.7 16 280.2 16 336C16 406.7 73.31 464 144 464H512C573.9 464 624 413.9 624 352C624 297.8 585.5 252.6 534.4 242.2C529.8 241.3 525.8 238.4 523.6 234.2C521.3 230.1 520.1 225.2 522.7 220.8C526.1 211.9 528 202.2 528 192V192z"],
    "cloud-question": [640, 512, [], "e492", "M231.1 216C231.1 185.1 257.1 160 287.1 160H344.2C379.4 160 407.1 188.6 407.1 223.8C407.1 245.2 397.2 265.2 379.3 277L327.1 310.9V336C327.1 340.4 324.4 344 319.1 344C315.6 344 311.1 340.4 311.1 336V306.5C311.1 303.9 313.3 301.3 315.6 299.9L370.5 263.7C383.9 254.8 391.1 239.8 391.1 223.8C391.1 197.4 370.6 176 344.2 176H287.1C265.9 176 247.1 193.9 247.1 216V222.5C247.1 226.1 244.4 230.5 239.1 230.5C235.6 230.5 231.1 226.1 231.1 222.5V216zM335.1 384C335.1 392.8 328.8 400 319.1 400C311.2 400 303.1 392.8 303.1 384C303.1 375.2 311.2 368 319.1 368C328.8 368 335.1 375.2 335.1 384zM256 32C309.6 32 356.1 58.31 386 98.71C389.1 103 392 107.5 394.7 112.2C398.2 109.8 401.9 107.7 405.7 105.8C418.5 99.52 432.8 96 448 96C501 96 544 138.1 544 192C544 198.6 543.3 204.1 542.1 211.2C541 216.5 539.5 221.6 537.6 226.6C542.9 227.6 548.1 229 553.1 230.7C603.6 247.9 640 295.7 640 352C640 422.7 582.7 480 512 480H144C64.47 480 0 415.5 0 336C0 273.2 40.17 219.8 96.2 200.1C96.07 197.4 96 194.7 96 192C96 103.6 167.6 32 256 32V32zM528 192C528 147.8 492.2 112 448 112C431.5 112 416.3 116.1 403.6 125.5C399.9 127.9 395.4 128.7 391.1 127.7C386.7 126.7 383 123.1 380.8 120.2C355.9 76.99 309.3 48 256 48C176.5 48 112 112.5 112 192C112 194.5 112.1 196.9 112.2 199.3C112.5 206.4 108.2 212.9 101.5 215.2C51.68 232.7 16 280.2 16 336C16 406.7 73.31 464 144 464H512C573.9 464 624 413.9 624 352C624 297.8 585.5 252.6 534.4 242.2C529.8 241.3 525.8 238.4 523.6 234.2C521.3 230.1 520.1 225.2 522.7 220.8C526.1 211.9 528 202.2 528 192V192z"],
    "cloud-rain": [512, 512, [127783, 9926], "f73d", "M95.99 368c-3.369 0-6.758 2.043-7.995 6.247c-12.75 44.38-40 56.38-40 87.63C48 489.6 69.5 512 96 512s48-22.38 48-50.13c0-31.38-27.25-43.13-40-87.63C102.9 370.1 99.44 368 95.99 368zM128 461.9C128 480.7 113.6 496 96 496s-32-15.31-32-34.13c0-10.99 4.715-18.47 13.75-31.82c5.738-8.477 12.43-18.37 18.24-31.23c5.83 12.93 12.54 22.81 18.28 31.28C123.3 443.4 128 450.8 128 461.9zM415.1 368c-3.369 0-6.758 2.043-7.995 6.247c-12.75 44.38-40 56.38-40 87.63C368 489.6 389.5 512 416 512s48-22.38 48-50.13c0-31.38-27.25-43.13-40-87.63C422.9 370.1 419.4 368 415.1 368zM448 461.9C448 480.7 433.6 496 416 496s-32-15.31-32-34.13c0-10.99 4.715-18.47 13.75-31.82c5.738-8.477 12.43-18.37 18.24-31.23c5.83 12.93 12.54 22.81 18.28 31.28C443.3 443.4 448 450.8 448 461.9zM255.1 368c-3.369 0-6.758 2.043-7.995 6.247c-12.75 44.38-40 56.38-40 87.63C208 489.6 229.5 512 256 512s48-22.38 48-50.13c0-31.38-27.25-43.13-40-87.63C262.9 370.1 259.4 368 255.1 368zM288 461.9C288 480.7 273.6 496 256 496s-32-15.31-32-34.13c0-10.99 4.715-18.47 13.75-31.82c5.738-8.477 12.43-18.37 18.24-31.23c5.83 12.93 12.54 22.81 18.28 31.28C283.3 443.4 288 450.8 288 461.9zM416 128c-.625 0-1.125 .25-1.625 .25C415.5 123 416 117.6 416 112C416 67.75 380.3 32 336 32c-24.62 0-46.25 11.25-61 28.75C256.4 24.75 219.3 0 176 0C114.1 0 64 50.13 64 112c0 7.25 .75 14.25 2.125 21.25C27.75 145.8 0 181.5 0 224c0 53 43 96 96 96h320c53 0 96-43 96-96S469 128 416 128zM416 304H96C51.89 304 16 268.1 16 224c0-34.45 22.13-64.81 55.08-75.54l13.48-4.391L81.82 130.2C80.6 123.9 80 117.1 80 112c0-52.94 43.06-96 96-96c35.67 0 68.16 19.96 84.79 52.1l11.01 21.28l15.44-18.32C299.8 56.19 317.1 48 336 48c35.29 0 64 28.71 64 64c0 4.691-.416 8.91-1.27 12.9l-4.148 19.35h19.79c1.104 0 2.068-.1035 2.902-.2402C460.8 144.7 496 180.3 496 224C496 268.1 460.1 304 416 304z"],
    "cloud-rainbow": [576, 512, [], "f73e", "M399.2 325.6C399.4 323.8 400 321.9 400 320c0-35.25-28.75-64-64-64c-12.62 0-24.25 3.75-34.13 10C284.3 227.1 245.4 200 200 200c-61.88 0-112 50.13-112 112c0 3 .75 5.75 .875 8.75C39.25 324.4 0 365.4 0 416c0 53 43 96 96 96h272c53 0 96-43 96-96C464 374 436.7 338.6 399.2 325.6zM368 496H96c-44.11 0-80-35.89-80-80c0-41.43 32.52-76.26 74.04-79.29l15.46-1.129l-.6445-15.49C104.8 318.2 104.5 316.3 104.3 314.5C104.2 313.7 104 312.9 104 312c0-52.94 43.06-96 96-96c37.44 0 71.71 22.22 87.3 56.61l7.592 16.75l15.54-9.832C318.2 274.6 327 272 336 272c26.47 0 48.06 21.43 47.94 48.11c-.2676 1.447-.5576 3.006-.6553 4.453l-.8125 12.18l11.54 4C426.3 351.9 448 382.2 448 416C448 460.1 412.1 496 368 496zM248.4 167.7c2.281 0 4.594-.9844 6.156-2.891C332.9 70.25 447.1 16 568 16C572.4 16 576 12.42 576 8S572.4 0 568 0c-125.7 0-244.4 56.36-325.8 154.6C239.4 158 239.9 163.1 243.3 165.9C244.8 167.1 246.6 167.7 248.4 167.7zM568 96c-91.06 0-178.9 38.92-241.1 106.8c-2.969 3.266-2.75 8.328 .5 11.31c1.531 1.406 3.469 2.094 5.406 2.094c2.156 0 4.312-.875 5.906-2.594C397.8 149 481.4 112 568 112C572.4 112 576 108.4 576 104S572.4 96 568 96zM568 192c-53.94 0-106.7 19.23-148.4 54.14c-3.406 2.828-3.844 7.875-1 11.27c1.562 1.891 3.844 2.875 6.125 2.875c1.812 0 3.625-.6094 5.125-1.859C468.8 225.9 517.8 208 568 208C572.4 208 576 204.4 576 200S572.4 192 568 192z"],
    "cloud-showers": [512, 512, [], "f73f", "M40 368C35.59 368 32 371.6 32 376v96C32 476.4 35.59 480 40 480s8-3.578 8-8v-96C48 371.6 44.41 368 40 368zM136 400C131.6 400 128 403.6 128 408v96C128 508.4 131.6 512 136 512s8-3.578 8-8v-96C144 403.6 140.4 400 136 400zM232 368C227.6 368 224 371.6 224 376v96C224 476.4 227.6 480 232 480s8-3.578 8-8v-96C240 371.6 236.4 368 232 368zM328 400c-4.406 0-8 3.578-8 8v96c0 4.422 3.594 8 8 8s8-3.578 8-8v-96C336 403.6 332.4 400 328 400zM424 368c-4.406 0-8 3.578-8 8v96c0 4.422 3.594 8 8 8s8-3.578 8-8v-96C432 371.6 428.4 368 424 368zM416 128c-.625 0-1.125 .25-1.625 .25C415.5 123 416 117.6 416 112C416 67.75 380.3 32 336 32c-24.62 0-46.25 11.25-61 28.75C256.4 24.75 219.3 0 176 0C114.1 0 64 50.13 64 112c0 7.25 .75 14.25 2.125 21.25C27.75 145.8 0 181.5 0 224c0 53 43 96 96 96h320c53 0 96-43 96-96S469 128 416 128zM416 304H96C51.89 304 16 268.1 16 224c0-34.45 22.13-64.81 55.08-75.54l13.48-4.391L81.82 130.2C80.6 123.9 80 117.1 80 112c0-52.94 43.06-96 96-96c35.67 0 68.16 19.96 84.79 52.1l11.01 21.28l15.44-18.32C299.8 56.19 317.1 48 336 48c35.29 0 64 28.71 64 64c0 4.691-.416 8.91-1.27 12.9l-4.148 19.35h19.79c1.104 0 2.068-.1035 2.902-.2402C460.8 144.7 496 180.3 496 224C496 268.1 460.1 304 416 304z"],
    "cloud-showers-heavy": [512, 512, [], "f740", "M416 128c-.625 0-1.125 .25-1.625 .25C415.5 123 416 117.6 416 112c0-44.25-35.75-80-79.1-80c-24.62 0-46.25 11.25-60.1 28.75C256.4 24.75 219.3 0 176 0C114.1 0 64 50.13 64 112c0 7.25 .7511 14.25 2.126 21.25C27.75 145.8 .0054 181.5 .0054 224c0 53 42.1 96 95.1 96h319.1C469 320 512 277 512 224S469 128 416 128zM416 304H96C51.89 304 16 268.1 16 224c0-34.45 22.13-64.81 55.08-75.54l13.48-4.391L81.82 130.2C80.6 123.9 80 117.1 80 112c0-52.94 43.06-96 96-96c35.67 0 68.16 19.96 84.79 52.1l11.01 21.28l15.44-18.32C299.8 56.19 317.1 48 336 48c35.29 0 64 28.71 64 64c0 4.691-.416 8.91-1.27 12.9l-4.148 19.35h19.79c1.104 0 2.068-.1035 2.902-.2402C460.8 144.7 496 180.3 496 224C496 268.1 460.1 304 416 304zM432.8 356.4l-72 144c-1.969 3.938-.375 8.75 3.578 10.72C365.6 511.7 366.8 512 367.1 512c2.922 0 5.758-1.625 7.164-4.438l72-144c1.969-3.938 .375-8.75-3.578-10.72C439.6 350.9 434.8 352.5 432.8 356.4zM312.8 356.4l-72 144c-1.969 3.938-.375 8.75 3.578 10.72C245.6 511.7 246.8 512 248 512c2.922 0 5.75-1.625 7.156-4.438l72-144c1.969-3.938 .375-8.75-3.578-10.72C319.6 350.9 314.8 352.5 312.8 356.4zM192.8 356.4l-72 144c-1.969 3.938-.375 8.75 3.578 10.72C125.6 511.7 126.8 512 128 512c2.922 0 5.75-1.625 7.156-4.438l72-144c1.969-3.938 .375-8.75-3.578-10.72C199.6 350.9 194.8 352.5 192.8 356.4zM72.84 356.4l-72 144c-1.969 3.938-.375 8.75 3.578 10.72C5.578 511.7 6.797 512 8 512c2.922 0 5.75-1.625 7.156-4.438l72-144c1.969-3.938 .375-8.75-3.578-10.72C79.64 350.9 74.84 352.5 72.84 356.4z"],
    "cloud-showers-water": [576, 512, [], "e4e4", "M224 0C256.7 0 285.6 16.38 302.1 41.39C306.1 45.89 308.8 50.68 311.2 55.7C315 51.81 319.3 48.3 323.9 45.26C336.5 36.88 351.7 32 368 32C406.7 32 438.1 59.48 446.4 96H448C483.3 96 512 124.7 512 160C512 195.3 483.3 224 448 224H128C92.65 224 64 195.3 64 160C64 124.7 92.65 96 128 96C128 42.98 170.1 0 224 0zM224 16C179.8 16 144 51.82 144 96V112H128C101.5 112 80 133.5 80 160C80 186.5 101.5 208 128 208H448C474.5 208 496 186.5 496 160C496 133.5 474.5 112 448 112H433.3L430.7 99.18C424.8 69.98 398.9 48 368 48C350.2 48 334.1 55.24 322.5 66.96L306.3 83.33L296.6 62.43C283.9 34.98 256.2 16 224 16L224 16zM62.51 380.6C59.94 384.2 54.95 385.1 51.35 382.5C47.76 379.9 46.92 374.9 49.49 371.4L129.5 259.4C132.1 255.8 137.1 254.9 140.7 257.5C144.2 260.1 145.1 265.1 142.5 268.6L62.51 380.6zM476.6 257.5C480.2 260.1 481.1 265.1 478.5 268.6L398.5 380.6C395.9 384.2 390.9 385.1 387.4 382.5C383.8 379.9 382.9 374.9 385.5 371.4L465.5 259.4C468.1 255.8 473.1 254.9 476.6 257.5zM174.5 380.6C171.9 384.2 166.9 385.1 163.4 382.5C159.8 379.9 158.9 374.9 161.5 371.4L241.5 259.4C244.1 255.8 249.1 254.9 252.7 257.5C256.2 260.1 257.1 265.1 254.5 268.6L174.5 380.6zM364.6 257.5C368.2 260.1 369.1 265.1 366.5 268.6L286.5 380.6C283.9 384.2 278.9 385.1 275.4 382.5C271.8 379.9 270.9 374.9 273.5 371.4L353.5 259.4C356.1 255.8 361.1 254.9 364.6 257.5zM294.6 435.4C302.6 446.6 312.1 456.9 322.2 466.1C339.5 481.8 361.5 496 384 496C406.5 496 428.6 481.8 445.8 466.1C455.1 456.9 465.5 446.6 473.5 435.4C474.1 433.3 477.4 432 480 432C482.6 432 485.1 433.3 486.6 435.4C493.9 445.7 502.5 455 511.6 463.7C527.3 478.5 547.7 492.9 569 495.6C573.4 496.1 576.5 500.1 575.9 504.5C575.4 508.9 571.4 511.1 567 511.4C540.5 508.1 516.1 490.7 500.6 475.3C491.8 466.1 484.7 458.9 480 453.1C474.8 459.5 466.8 468.7 456.6 477.9C438.7 494.2 412.7 512 384 512C355.3 512 329.4 494.2 311.4 477.9C301.3 468.7 293.2 459.5 288 453.1L288 453.1L287.1 453.1C282.8 459.5 274.7 468.7 264.6 477.9C246.6 494.2 220.7 512 191.1 512C163.3 512 137.4 494.2 119.4 477.9C109.2 468.7 101.2 459.5 95.98 453.1C91.29 458.9 84.23 466.1 75.4 475.3C59.03 490.7 35.48 508.1 9.001 511.4C4.617 511.1 .616 508.9 .0637 504.5C-.4887 500.1 2.617 496.1 7.001 495.6C28.3 492.9 48.74 478.5 64.42 463.7C73.56 455 82.16 445.7 89.43 435.4C90.93 433.3 93.37 432 95.98 432C98.59 432 101 433.3 102.5 435.4C110.5 446.6 120 456.9 130.2 466.1C147.4 481.8 169.5 496 191.1 496C214.5 496 236.6 481.8 253.8 466.1C263.9 456.9 273.4 446.6 281.4 435.4C284.4 431.1 291.6 431.1 294.6 435.4H294.6z"],
    "cloud-slash": [640, 512, [], "e137", "M636.1 497.7C640.4 500.5 641 505.5 638.3 508.1C635.5 512.4 630.5 513 627 510.3L3.023 14.26C-.4358 11.51-1.011 6.481 1.739 3.022C4.488-.4365 9.52-1.012 12.98 1.738L636.1 497.7zM640 352C640 371.7 635.5 390.4 627.6 407.1L614.6 396.9C620.7 383.1 624 367.1 624 352C624 297.8 585.5 252.6 534.4 242.2C529.8 241.3 525.8 238.4 523.6 234.2C521.3 230.1 520.1 225.2 522.7 220.8C526.1 211.9 528 202.2 528 192C528 147.8 492.2 112 448 112C431.5 112 416.3 116.1 403.6 125.5C399.9 127.9 395.4 128.7 391.1 127.7C386.7 126.7 383 123.1 380.8 120.2C355.9 76.99 309.3 48 256 48C232.9 48 211.1 53.42 191.8 63.06L178.1 52.22C201.1 39.34 227.7 32 256 32C309.6 32 356.1 58.31 386 98.71C389.1 103 392 107.5 394.7 112.2C398.2 109.8 401.9 107.7 405.7 105.8C418.5 99.52 432.8 96 448 96C501 96 544 138.1 544 192C544 198.6 543.3 204.1 542.1 211.2C541 216.5 539.5 221.6 537.6 226.6C542.9 227.6 548.1 229 553.1 230.7C603.6 247.9 640 295.7 640 352zM97.25 171.9L112.2 183.7C112.1 186.5 112 189.2 112 192C112 194.5 112.1 196.9 112.2 199.3C112.5 206.4 108.2 212.9 101.5 215.2C51.68 232.7 16 280.2 16 336C16 406.7 73.31 464 144 464H467.3L487.5 480H144C64.47 480 0 415.5 0 336C0 273.2 40.17 219.8 96.2 200.1C96.07 197.4 96 194.7 96 192C96 185.2 96.43 178.5 97.25 171.9H97.25z"],
    "cloud-sleet": [576, 512, [], "f741", "M96.84 372.4l-64 128c-1.969 3.953-.375 8.75 3.594 10.73C37.56 511.7 38.78 512 40 512c2.938 0 5.75-1.625 7.156-4.422l64-128c1.969-3.953 .375-8.75-3.594-10.73C103.7 366.9 98.84 368.5 96.84 372.4zM262.9 384c-2.281-3.844-7.188-5.156-10.94-2.922l-36.5 21.07V360c0-4.422-3.594-8-8-8s-8 3.578-8 8v42.15l-36.5-21.07C159.2 378.8 154.3 380.2 152.1 384c-2.188 3.828-.875 8.719 2.938 10.92L191.5 416l-36.51 21.08C151.2 439.3 149.9 444.2 152.1 448c1.5 2.562 4.188 4 6.938 4c1.375 0 2.75-.3438 4-1.078l36.5-21.07V472c0 4.422 3.594 8 8 8s8-3.578 8-8v-42.15l36.5 21.07C253.3 451.7 254.6 452 256 452c2.75 0 5.438-1.438 6.938-4c2.188-3.828 .875-8.719-2.938-10.92L223.5 416l36.51-21.08C263.8 392.7 265.1 387.8 262.9 384zM352.8 372.4l-64 128c-1.969 3.953-.375 8.75 3.594 10.73C293.6 511.7 294.8 512 296 512c2.938 0 5.75-1.625 7.156-4.422l64-128c1.969-3.953 .375-8.75-3.594-10.73C359.7 366.9 354.8 368.5 352.8 372.4zM518.9 384c-2.281-3.844-7.188-5.156-10.94-2.922l-36.5 21.07V360c0-4.422-3.594-8-8-8s-8 3.578-8 8v42.15l-36.5-21.07C415.2 378.8 410.3 380.2 408.1 384c-2.188 3.828-.875 8.719 2.938 10.92L447.5 416l-36.51 21.08C407.2 439.3 405.9 444.2 408.1 448c1.5 2.562 4.188 4 6.938 4c1.375 0 2.75-.3438 4-1.078l36.5-21.07V472c0 4.422 3.594 8 8 8s8-3.578 8-8v-42.15l36.5 21.07c1.25 .7344 2.625 1.078 4 1.078c2.75 0 5.438-1.438 6.938-4c2.188-3.828 .875-8.719-2.938-10.92L479.5 416l36.51-21.08C519.8 392.7 521.1 387.8 518.9 384zM544 224c0-53-42.1-96-95.1-96c-.625 0-1.125 .25-1.625 .25C447.5 123 448 117.6 448 112c0-44.25-35.75-80-79.1-80c-24.62 0-46.25 11.25-60.1 28.75C288.4 24.75 251.3 0 208 0C146.1 0 96 50.13 96 112c0 7.25 .7511 14.25 2.126 21.25C59.75 145.8 32.01 181.5 32.01 224c0 53 42.1 96 95.1 96h319.1C501 320 544 277 544 224zM48 224c0-34.45 22.14-64.81 55.08-75.54l13.48-4.391L113.8 130.2C112.6 123.9 112 117.1 112 112c0-52.94 43.07-96 96-96c35.67 0 68.16 19.96 84.79 52.1l11.01 21.28l15.44-18.32C331.8 56.19 349.1 48 368 48c35.29 0 64 28.71 64 64c0 4.691-.4141 8.91-1.27 12.9l-4.148 19.35h19.79c1.102 0 2.066-.1035 2.902-.2402C492.8 144.7 528 180.3 528 224c0 44.11-35.89 80-80 80H128C83.89 304 48 268.1 48 224z"],
    "cloud-snow": [512, 512, [127784], "f742", "M311.4 416c-2.281-3.844-7.188-5.156-10.94-2.922L264 434.2V392c0-4.422-3.594-8-8-8s-8 3.578-8 8v42.15l-36.5-21.07C207.7 410.8 202.8 412.2 200.6 416c-2.188 3.828-.875 8.719 2.938 10.92L240 448L203.5 469.1C199.7 471.3 198.4 476.2 200.6 480c1.5 2.562 4.188 4 6.938 4c1.375 0 2.75-.3438 4-1.078L248 461.8V504C248 508.4 251.6 512 256 512s8-3.578 8-8v-42.15l36.5 21.07c1.25 .7344 2.625 1.078 4 1.078c2.75 0 5.438-1.438 6.938-4c2.188-3.828 .875-8.719-2.938-10.92L271.1 448l36.51-21.08C312.3 424.7 313.6 419.8 311.4 416zM502.9 384c-2.281-3.844-7.188-5.156-10.94-2.922l-36.5 21.07V360c0-4.422-3.594-8-8-8s-8 3.578-8 8v42.15l-36.5-21.07C399.2 378.8 394.3 380.2 392.1 384c-2.188 3.828-.875 8.719 2.938 10.92L431.5 416l-36.51 21.08C391.2 439.3 389.9 444.2 392.1 448c1.5 2.562 4.188 4 6.938 4c1.375 0 2.75-.3438 4-1.078l36.5-21.07V472c0 4.422 3.594 8 8 8s8-3.578 8-8v-42.15l36.5 21.07c1.25 .7344 2.625 1.078 4 1.078c2.75 0 5.438-1.438 6.938-4c2.188-3.828 .875-8.719-2.938-10.92L463.5 416l36.51-21.08C503.8 392.7 505.1 387.8 502.9 384zM119.9 384c-2.281-3.844-7.188-5.156-10.94-2.922l-36.5 21.07V360c0-4.422-3.594-8-8-8s-8 3.578-8 8v42.15l-36.5-21.07C16.21 378.8 11.31 380.2 9.059 384c-2.188 3.828-.875 8.719 2.938 10.92L48.5 416l-36.51 21.08C8.184 439.3 6.871 444.2 9.059 448c1.5 2.562 4.188 4 6.938 4c1.375 0 2.75-.3438 4-1.078l36.5-21.07V472c0 4.422 3.594 8 8 8s8-3.578 8-8v-42.15l36.5 21.07C110.2 451.7 111.6 452 112.1 452c2.75 0 5.438-1.438 6.938-4c2.188-3.828 .875-8.719-2.938-10.92L80.49 416l36.51-21.08C120.8 392.7 122.1 387.8 119.9 384zM96 320h320c53 0 96-43 96-96s-43-96-96-96c-.625 0-1.125 .25-1.625 .25C415.5 123 416 117.6 416 112C416 67.75 380.3 32 336 32c-24.62 0-46.25 11.25-61 28.75C256.4 24.75 219.3 0 176 0C114.1 0 64 50.13 64 112c0 7.25 .75 14.25 2.125 21.25C27.75 145.8 0 181.5 0 224C0 277 43 320 96 320zM71.08 148.5l13.48-4.391L81.82 130.2C80.6 123.9 80 117.1 80 112c0-52.94 43.07-96 96-96c35.67 0 68.16 19.96 84.79 52.1l11.01 21.28l15.44-18.32C299.8 56.19 317.1 48 336 48c35.29 0 64 28.71 64 64c0 4.691-.4141 8.91-1.27 12.9l-4.148 19.35c0 0 21.86-.1035 22.7-.2402C460.8 144.7 496 180.3 496 224c0 44.11-35.89 80-80 80H96C51.89 304 16 268.1 16 224C16 189.6 38.14 159.2 71.08 148.5z"],
    "cloud-sun": [640, 512, [9925], "f6c4", "M184.7 303.7c3 0 5.907-1.703 7.25-4.609c1.875-4.016 .125-8.766-3.875-10.64c-26.75-12.48-44.03-39.41-44.03-68.58C144 178 178.1 144 220 144c24.5 0 47.69 12.17 61.97 32.56c2.563 3.609 7.563 4.484 11.16 1.953c3.625-2.531 4.5-7.531 1.969-11.14C277.8 142.7 249.7 128 220 128C169.3 128 128 169.2 128 219.9c0 35.36 20.91 67.97 53.28 83.08C182.4 303.5 183.5 303.7 184.7 303.7zM136.3 355l-52.6 17.44c-3.75 1.188-6.313-.9687-6.969-1.656c-.8438-.8594-2.688-3.203-1.531-6.641l30.53-91.31l-86.1-43C16.34 228.2 16 225.1 16 223.9s.3438-4.266 3.656-5.922l86.1-43.13L75.22 83.73C74.1 80.19 76 77.77 76.88 76.88c.875-.8594 3.344-2.797 6.782-1.641L175 105.8l42.97-86.11C219.7 16.36 222.7 16 224 16c1.281 0 4.344 .3594 6 3.625l43 86.14l91.29-30.52c3.563-1.172 5.969 .7656 6.844 1.625c.875 .8906 2.781 3.312 1.656 6.781l-22.59 67.42c-1.406 4.188 .8751 8.734 5.063 10.12c4.25 1.547 8.719-.8281 10.13-5.031l22.59-67.5c2.656-8.172 .5313-17.03-5.563-23.11c-6.032-6.078-14.94-8.203-23.13-5.516l-78.16 26.12L244.3 12.44C240.4 4.766 232.6 0 224 0c-.0625 0 0 0 0 0C215.4 0 207.6 4.766 203.7 12.47L166.9 86.17L88.66 60.03C80.54 57.39 71.6 59.52 65.6 65.56C59.5 71.64 57.38 80.5 60.03 88.75L86.19 166.8L12.47 203.7C4.781 207.6 0 215.3 0 223.9s4.781 16.34 12.5 20.23L86.19 280.9l-26.16 78.14C57.32 367.2 59.38 376 65.38 382.1c4.375 4.391 10.16 6.75 16.16 6.75c2.375 0 4.813-.375 7.188-1.156l52.66-17.45c4.188-1.391 6.438-5.922 5.063-10.11C145 355.9 140.6 353.7 136.3 355zM575.2 325.6c3.72-59.52-50.1-69.62-63.25-69.62c-12.63 0-24.25 3.749-34.13 9.999c-17.63-38.88-56.5-65.1-101.9-65.1c-22.59 0-115.6 17.38-111.1 120.6c-49.63 3.75-88.88 44.74-88.88 95.37C175.1 469 218.1 512 271.1 512h272c53 0 96-42.99 96-95.99C639.1 373.9 612.7 338.6 575.2 325.6zM543.1 496H271.1c-44.12 0-80-35.89-80-80c0-41.4 32.54-76.28 74.09-79.42l15.45-1.166c0 0-1.531-22.55-1.531-23.41c0-52.94 43.07-96 96-96c37.45 0 71.71 22.22 87.31 56.61l7.594 16.75C498.1 272.1 500.8 272 511.1 272c26.47 0 48 21.53 47.9 48.05c-.2773 1.473-1.379 16.71-1.379 16.71l11.48 3.982C602.3 351.9 623.1 382.2 623.1 416C623.1 460.1 588.1 496 543.1 496z"],
    "cloud-sun-rain": [640, 512, [127782], "f743", "M542.5 225.5c-6.875-37.25-39.25-65.5-78.51-65.5c-12.25 0-23.88 3-34.25 8c-17.5-24.12-45.63-40-77.76-40c-53 0-96.01 43-96.01 96c0 .5 .25 1.125 .25 1.625C219.6 232.1 191.1 265.2 191.1 303.1c0 44.25 35.75 80 80.01 80h256C572.2 383.1 608 348.2 608 303.1C608 264.7 579.7 232.2 542.5 225.5zM527.1 367.1H271.1c-35.29 0-64.01-28.71-64.01-64c0-30.33 21.62-56.69 51.41-62.69L272.2 238.7V225.6c0-1.129-.1133-2.129-.2383-2.918c.6914-43.52 36.31-78.71 79.1-78.71c25.79 0 49.41 12.17 64.81 33.4l7.852 10.82l12.04-5.805c8.832-4.254 18.02-6.412 27.3-6.412c30.77 0 57.17 22.04 62.77 52.4l2.008 10.87l10.88 1.971C569.1 246.7 592 273.1 592 303.1C592 339.3 563.3 367.1 527.1 367.1zM160 301.8c-.8373 0-1.69 .1306-2.532 .405l-52.69 17.61c-.5495 .1628-1.061 .2307-1.531 .2307c-1.695 0-2.855-.882-3.344-1.371C99.36 318.1 98.59 317.1 98.59 315.6c0-.4645 .0742-.9718 .2521-1.521l26.44-79.2L50.59 197.5C48.25 196.3 48 194.2 48 193.3c0-.8438 .25-2.953 2.531-4.109l74.75-37.38L98.84 72.67c-.1854-.5742-.2618-1.104-.2618-1.588c0-1.635 .8732-2.735 1.356-3.193C100.5 67.34 101.5 66.57 102.9 66.57c.4778 0 1.009 .079 1.595 .2694l79.22 26.44l37.31-74.69C222.3 16.25 224.4 16 225.2 16s2.969 .25 4.125 2.547l37.38 74.73l79.19-26.44c.6205-.189 1.176-.2665 1.671-.2665c2.889 0 4.452 2.691 4.452 4.452c0 .421-.0638 .8758-.2167 1.361l-7.375 20.92C344.1 94.19 343.1 95.09 343.1 95.97c0 4.535 3.735 8.035 8.051 8.035c3.29 0 6.315-2.101 7.468-5.379l7.438-21.08c.7051-2.151 1.049-4.353 1.049-6.527c0-12.67-10.63-20.44-20.5-20.44c-2.208 0-4.44 .3525-6.613 1.076L274.8 73.72L243.7 11.36C240.1 4.359 233 0 225.2 0c0 0 .0313 0 0 0c-7.812 0-14.89 4.344-18.45 11.39L175.6 73.72L109.6 51.66C107.4 50.93 105.2 50.57 102.1 50.57c-12.67 0-20.38 10.78-20.38 20.53c0 2.196 .348 4.42 1.062 6.599l22.06 66.06L43.34 174.9C36.38 178.5 32 185.5 32 193.3s4.344 14.88 11.41 18.45l62.31 31.16L83.66 309C82.95 311.2 82.61 313.4 82.61 315.5c0 9.838 7.855 20.52 20.61 20.52c2.156 0 4.344-.3438 6.5-1.016l52.81-17.64c3.348-1.124 5.478-4.247 5.478-7.594C168 305.5 164.5 301.8 160 301.8zM167.1 191.1c0-30.88 25.12-56 56-56c20.38 0 28.22 9.889 33.73 9.889c4.507 0 8.024-3.666 8.024-8.002c0-9.677-24.96-17.89-41.75-17.89c-39.69 0-72 32.3-72 72c0 32.46 22.53 55.13 29.12 55.13c4.48 0 7.996-3.641 7.996-8.015C189.1 230.6 167.1 223.1 167.1 191.1zM264 415.1c-2.722 0-5.376 1.387-6.882 3.893l-48 80c-.7636 1.283-1.128 2.698-1.128 4.095c0 2.721 1.38 5.377 3.878 6.873C213.2 511.6 214.6 512 216 512c2.719 0 5.375-1.391 6.875-3.891l48-80c.7636-1.283 1.128-2.698 1.128-4.095C272 417.4 265.9 415.1 264 415.1zM360 415.1c-2.729 0-5.402 1.387-6.887 3.893l-48 80c-.7636 1.283-1.128 2.698-1.128 4.095c0 2.721 1.38 5.377 3.878 6.873C309.2 511.6 310.6 512 312 512c2.719 0 5.375-1.391 6.875-3.891l48-80c.7636-1.283 1.128-2.698 1.128-4.095c0-2.721-1.38-5.377-3.878-6.873C362.8 416.4 361.4 415.1 360 415.1zM456 415.1c-2.729 0-5.416 1.387-6.901 3.893l-48 80c-.7636 1.283-1.128 2.698-1.128 4.095c0 2.721 1.38 5.377 3.878 6.873C405.2 511.6 406.6 512 408 512c2.719 0 5.375-1.391 6.875-3.891l48-80c.7636-1.283 1.128-2.698 1.128-4.095c0-2.721-1.38-5.377-3.878-6.873C458.8 416.4 457.4 415.1 456 415.1zM552 415.1c-2.73 0-5.414 1.387-6.899 3.893l-48 80c-.7636 1.283-1.128 2.698-1.128 4.095c0 2.721 1.38 5.377 3.878 6.873C501.2 511.6 502.6 512 504 512c2.719 0 5.375-1.391 6.875-3.891l48-80c.7636-1.283 1.128-2.698 1.128-4.095c0-2.721-1.38-5.377-3.878-6.873C554.8 416.4 553.4 415.1 552 415.1z"],
    "cloud-word": [640, 512, [], "e138", "M504 384H296C291.6 384 288 380.4 288 376C288 371.6 291.6 368 296 368H504C508.4 368 512 371.6 512 376C512 380.4 508.4 384 504 384zM248 368C252.4 368 256 371.6 256 376C256 380.4 252.4 384 248 384H136C131.6 384 128 380.4 128 376C128 371.6 131.6 368 136 368H248zM128 312C128 307.6 131.6 304 136 304H344C348.4 304 352 307.6 352 312C352 316.4 348.4 320 344 320H136C131.6 320 128 316.4 128 312zM504 304C508.4 304 512 307.6 512 312C512 316.4 508.4 320 504 320H392C387.6 320 384 316.4 384 312C384 307.6 387.6 304 392 304H504zM394.7 112.2C398.2 109.8 401.9 107.7 405.7 105.8C418.5 99.52 432.8 96 448 96C501 96 544 138.1 544 192C544 198.6 543.3 204.1 542.1 211.2C541 216.5 539.5 221.6 537.6 226.6C542.9 227.6 548.1 229 553.1 230.7C603.6 247.9 640 295.7 640 352C640 422.7 582.7 480 512 480H144C64.47 480 0 415.5 0 336C0 273.2 40.17 219.8 96.2 200.1C96.07 197.4 96 194.7 96 192C96 103.6 167.6 32 256 32C309.6 32 356.1 58.31 386 98.71C389.1 103 392 107.5 394.7 112.2V112.2zM523.6 234.2C521.3 230.1 520.1 225.2 522.7 220.8C526.1 211.9 528 202.2 528 192C528 147.8 492.2 112 448 112C431.5 112 416.3 116.1 403.6 125.5C399.9 127.9 395.4 128.7 391.1 127.7C386.7 126.7 383 123.1 380.8 120.2C355.9 76.99 309.3 48 256 48C176.5 48 112 112.5 112 192C112 194.5 112.1 196.9 112.2 199.3C112.5 206.4 108.2 212.9 101.5 215.2C51.68 232.7 16 280.2 16 336C16 406.7 73.31 464 144 464H512C573.9 464 624 413.9 624 352C624 297.8 585.5 252.6 534.4 242.2C529.8 241.3 525.8 238.4 523.6 234.2V234.2z"],
    "cloud-xmark": [640, 512, [], "e35f", "M242.3 210.3C245.5 207.2 250.5 207.2 253.7 210.3L320 276.7L386.3 210.3C389.5 207.2 394.5 207.2 397.7 210.3C400.8 213.5 400.8 218.5 397.7 221.7L331.3 288L397.7 354.3C400.8 357.5 400.8 362.5 397.7 365.7C394.5 368.8 389.5 368.8 386.3 365.7L320 299.3L253.7 365.7C250.5 368.8 245.5 368.8 242.3 365.7C239.2 362.5 239.2 357.5 242.3 354.3L308.7 288L242.3 221.7C239.2 218.5 239.2 213.5 242.3 210.3V210.3zM256 32C309.6 32 356.1 58.31 386 98.71C389.1 103 392 107.5 394.7 112.2C398.2 109.8 401.9 107.7 405.7 105.8C418.5 99.52 432.8 96 448 96C501 96 544 138.1 544 192C544 198.6 543.3 204.1 542.1 211.2C541 216.5 539.5 221.6 537.6 226.6C542.9 227.6 548.1 229 553.1 230.7C603.6 247.9 640 295.7 640 352C640 422.7 582.7 480 512 480H144C64.47 480 0 415.5 0 336C0 273.2 40.17 219.8 96.2 200.1C96.07 197.4 96 194.7 96 192C96 103.6 167.6 32 256 32V32zM528 192C528 147.8 492.2 112 448 112C431.5 112 416.3 116.1 403.6 125.5C399.9 127.9 395.4 128.7 391.1 127.7C386.7 126.7 383 123.1 380.8 120.2C355.9 76.99 309.3 48 256 48C176.5 48 112 112.5 112 192C112 194.5 112.1 196.9 112.2 199.3C112.5 206.4 108.2 212.9 101.5 215.2C51.68 232.7 16 280.2 16 336C16 406.7 73.31 464 144 464H512C573.9 464 624 413.9 624 352C624 297.8 585.5 252.6 534.4 242.2C529.8 241.3 525.8 238.4 523.6 234.2C521.3 230.1 520.1 225.2 522.7 220.8C526.1 211.9 528 202.2 528 192V192z"],
    "clouds": [640, 512, [], "f744", "M154.6 280c0-4.422-3.578-8-8-8H100.6C53.94 272 16 234.9 16 189.3s37.94-82.66 83.66-82.73l9.422 .3125l.9844-6.875C116.9 52.13 159.3 16 208.6 16c41.3 0 78.8 25.55 93.3 63.55l3 7.891l7.719-3.422c11.33-5.031 23.05-7.578 34.83-7.578C394.1 76.44 432 113.5 432 159.1c0 5.422-.7813 11.09-2.484 17.84c-1.062 4.281 1.531 8.625 5.828 9.703c4.234 .9844 8.609-1.547 9.703-5.828C447.1 172.8 448 165.9 448 159.1c0-54.41-45.13-98.67-100.6-98.67c-11.42 0-22.73 2-33.78 5.938C294.9 26.36 253.7 0 208.6 0C153.8 0 106.4 38.56 95.45 90.8C42.36 93.42 0 136.6 0 189.3C0 243.7 45.13 288 100.6 288h45.98C150.1 288 154.6 284.4 154.6 280zM544 320c-.625 0-1.125 .25-1.625 .25C543.5 314.1 544 309.6 544 304C544 259.8 508.3 224 464 224c-24.62 0-46.25 11.25-61 28.75C384.4 216.9 347.3 192 304 192C242.1 192 192 242.1 192 304c0 7.25 .75 14.25 2.125 21.25C155.7 337.7 128 373.5 128 416c0 53 43 96 96 96h320c53 0 96-43 96-96S597 320 544 320zM544 496H224c-44.11 0-80-35.89-80-80c0-34.45 22.14-64.8 55.08-75.54l13.47-4.389L209.8 322.2C208.6 315.9 208 309.1 208 304c0-52.94 43.07-96 96-96c35.62 0 68.11 19.97 84.8 52.12l11.02 21.23l15.41-18.29C427.8 248.2 445.1 240 464 240c35.29 0 64 28.71 64 64c0 4.691-.4141 8.91-1.27 12.9l-4.146 19.35h19.79c1.104 0 2.068-.1016 2.904-.2402C588.8 336.7 624 372.3 624 416C624 460.1 588.1 496 544 496z"],
    "clouds-moon": [640, 512, [], "f745", "M637.8 242.1c-3.328-5.516-9.5-8.25-15.83-7.016c-32.95 6.172-66.58-2.422-92.27-23.7c-25.38-21.05-39.92-51.92-39.92-84.72c0-39.61 21.56-76.39 56.19-95.95c5.641-3.109 8.609-9.219 7.563-15.59s-5.859-11.25-12.14-12.38C532.1 .9219 522.4 0 512.3 0c-85.05 0-155.2 66.38-159.5 151.1c-.2344 4.406 3.156 8.172 7.578 8.391c4.641 .6562 8.156-3.172 8.391-7.578C372.6 75.7 435.6 16 512.2 16c9.063 0 18.3 .75 26.05 .7344c-39.72 22.42-64.39 64.55-64.39 109.9c0 37.58 16.66 72.95 45.72 97.03c29.33 24.34 67.73 34.25 104.6 25.52c-20.94 25.61-51.02 43.28-84.7 49.75c-4.328 .8438-7.172 5.031-6.344 9.375c.7344 3.828 4.094 6.484 7.844 6.484c.5 0 1.016-.0469 1.531-.1406c37.34-7.188 70.75-26.84 94.05-55.34C640.6 254.3 641.1 247.6 637.8 242.1zM41 310.2c2.531 0 5.047-1.219 6.594-3.469C50.09 303.1 49.17 298.1 45.53 295.6C27.05 282.9 16 262.1 16 240.1c0-37.25 30.36-67.56 67.69-67.56h23.22l1.297-6.422C114.5 134.8 142.4 112 174.5 112c32.08 0 59.97 22.77 66.31 54.13L242.1 172.5h23.22c17.11 0 33.47 6.5 46.09 18.31c3.234 3 8.297 2.859 11.31-.375s2.844-8.297-.375-11.31C306.8 164.6 286.5 156.5 265.3 156.5H254.9C244.8 121.1 211.9 96 174.5 96C137 96 104.2 121.1 94.08 156.5H83.69C37.55 156.5 0 193.1 0 240C0 267.3 13.64 293.1 36.47 308.8C37.86 309.7 39.44 310.2 41 310.2zM478.9 325.6c-5.25-56.88-52.7-101.6-110.1-101.6c-43.25 0-80.3 24.87-98.93 60.74C254.3 267.3 232.6 256 208 256c-38.75 0-71 27.5-78.38 64H128c-53 0-96 43-96 96s43 96 96 96h320c53 0 96-43 96-96C544 373.9 516.8 338.5 478.9 325.6zM448 496H128c-44.11 0-80-35.89-80-80s35.89-80 80-80h14.71l2.594-12.83C151.3 293.5 177.7 272 208 272c18.91 0 36.23 8.189 48.77 23.06l15.41 18.29l11.02-21.23C299.9 259.1 332.4 240 368 240c49.54 0 90.36 37.44 94.94 87.1l.9551 10.34l9.828 3.34c32.46 11.04 54.22 41.31 54.22 75.27C527.1 460.2 492.1 496 448 496z"],
    "clouds-sun": [640, 512, [], "f746", "M127.7 309.1C126.3 304.8 121.8 302.6 117.6 303.1L72.78 319.8c-2.531 .75-4.25-.5156-4.875-1.141C67.19 317.1 66.09 316.4 66.84 314.1l26.44-79.2L18.59 197.5C16.25 196.3 16 194.2 16 193.3c0-.8438 .25-2.953 2.531-4.109l74.75-37.38L66.84 72.67C66.03 70.16 67.31 68.48 67.94 67.89c.7187-.7344 2.188-1.828 4.594-1.047l79.22 26.44l37.31-74.69C190.3 16.25 192.4 16 193.2 16s2.969 .25 4.125 2.547l37.38 74.73l79.19-26.44c2.719-.8281 4.188 .4844 4.781 1.078C319.3 68.5 320.5 70.11 319.8 72.39L302.3 117.3C300.8 121.5 303 126 307.2 127.5c4.219 1.547 8.719-.7187 10.19-4.891l17.57-45.07c2.438-7.438 .5625-15.47-4.938-20.95C324.5 51.06 316.3 49.17 308.9 51.66L242.8 73.72L211.7 11.36C208.1 4.359 201 0 193.2 0c0 0 .0313 0 0 0c-7.812 0-14.89 4.344-18.45 11.39L143.6 73.72L77.56 51.66c-7.469-2.5-15.47-.5938-20.94 4.906c-5.531 5.531-7.438 13.61-4.969 21.14l22.06 66.06L11.34 174.9C4.375 178.5 0 185.5 0 193.3s4.344 14.88 11.41 18.45l62.31 31.16L51.66 309c-2.438 7.391-.5625 15.41 4.875 20.91c3.938 3.984 9.219 6.125 14.69 6.125c2.156 0 4.344-.3438 6.5-1.016l44.9-15.87C126.8 317.8 129.1 313.2 127.7 309.1zM512 319.1h-1.625c-7.375-36.5-39.62-64-78.37-64c-24.62 0-46.25 11.25-60.1 28.75c-18.62-35.88-55.75-60.75-98.1-60.75c-58.25 0-105.6 44.75-110.9 101.6c-37.88 12.88-65.12 48.25-65.12 90.38c0 53 42.1 96 95.1 96h319.1c53 0 95.1-43 95.1-96S565 319.1 512 319.1zM512 496H192c-44.11 0-80-35.89-80-80c0-33.96 21.81-64.19 54.28-75.23l9.828-3.34l.9551-10.34C181.6 277.4 222.5 240 272 240c35.62 0 68.11 19.97 84.8 52.12l11.02 21.23l15.41-18.29C395.8 280.2 413.1 272 432 272c30.34 0 56.7 21.52 62.69 51.17L497.3 336H512c44.11 0 80 35.89 80 80S556.1 496 512 496zM556.3 156.5h-10.39C535.8 121.1 502.1 96 465.5 96c-37.44 0-70.27 25.09-80.44 60.55h-10.39c-21.17 0-41.42 8.031-57.03 22.62c-3.219 3.016-3.391 8.078-.375 11.31s8.078 3.375 11.31 .375c12.62-11.81 28.98-18.31 46.09-18.31h23.22l1.297-6.422C405.5 134.8 433.4 112 465.5 112c32.09 0 59.97 22.77 66.3 54.13l1.297 6.422h23.22C593.6 172.5 624 202.9 624 240.1c0 22.03-11.05 42.78-29.53 55.48c-3.641 2.5-4.562 7.484-2.062 11.12c1.547 2.25 4.062 3.469 6.594 3.469c1.562 0 3.141-.4531 4.531-1.406c22.83-15.7 36.5-41.55 36.5-68.84C640 193.9 602.5 156.5 556.3 156.5zM192 136c26.09 0 48.45 17.8 54.39 43.28C247.4 183.6 251.7 186.3 256 185.3c4.312-1 6.984-5.312 5.984-9.609C254.3 142.9 225.6 120 192 120C152.3 120 120 152.3 120 192c0 19.27 7.531 37.39 21.22 51.02c1.562 1.547 3.594 2.328 5.641 2.328s4.109-.7813 5.672-2.359c3.109-3.125 3.109-8.188-.0313-11.31C141.9 221.1 136 206.1 136 192C136 161.1 161.1 136 192 136z"],
    "clover": [512, 512, [], "e139", "M490.9 255.9c9.375-10.97 20.75-28.44 20.75-48.59c0-41.38-31.75-75.06-70.78-75.06c-25.72 0-71.66 27.41-108.6 49.44c-1.688 1.031-3.375 2.031-5 3c.9687-1.625 1.969-3.312 3-5c22.03-36.91 49.44-82.84 49.44-108.6C379.7 31.91 346 0 304.7 0C284.1 0 268 10.53 255.9 21.12C244.1 11.75 227.5 .375 207.3 .375c-41.38 0-75.06 31.75-75.06 70.78c0 25.72 27.41 71.66 49.44 108.6c1.031 1.688 2.031 3.375 3 5c-1.625-.9687-3.312-1.969-5-3C142.8 159.7 96.88 132.3 71.16 132.3C31.91 132.3 0 165.1 0 207.3C0 227 10.53 244 21.13 256.1C11.75 267 .375 284.5 .375 304.7c0 41.38 31.75 75.06 70.78 75.06c25.72 0 71.66-27.41 108.6-49.44c1.688-1.031 3.375-2.031 5-3c-.9687 1.625-1.969 3.312-3 5c-22.03 36.91-49.44 82.84-49.44 108.6C132.3 480.1 165.1 512 207.3 512c19.69 0 36.66-10.53 48.72-21.12c10.97 9.375 28.44 20.75 48.59 20.75c41.38 0 75.06-31.75 75.06-70.78c0-25.72-27.41-71.66-49.44-108.6c-1.031-1.688-2.031-3.375-3-5c1.625 .9687 3.312 1.969 5 3c36.91 22.03 82.84 49.44 108.6 49.44C480.1 379.7 512 346 512 304.7C512 284.1 501.5 268 490.9 255.9zM440.8 363.7c-21.28 0-68.88-28.41-100.3-47.19c-12.19-7.281-23.06-13.75-31.19-18.03c-3.094-1.5-6.875-1.031-9.375 1.438c-2.469 2.469-3.062 6.281-1.438 9.375c4.281 8.125 10.75 19 18.03 31.19c18.78 31.47 47.19 79.06 47.19 100.3c0 30.22-26.5 54.78-59.06 54.78c-18.41 0-34.88-13.38-43.06-21.34c-3.156-3.094-8.125-3-11.22 .0313C240.4 484.2 224.8 496 207.3 496c-32.56 0-59.06-24.75-59.06-55.16c0-21.28 28.41-68.88 47.19-100.3c7.281-12.19 13.75-23.06 18.03-31.19c1.625-3.094 1.031-6.906-1.438-9.375C210.5 298.4 208.5 297.6 206.4 297.6c-1.281 0-2.531 .3125-3.719 .9062c-8.125 4.281-19 10.75-31.19 18.03c-31.47 18.78-79.06 47.19-100.3 47.19c-30.22 0-54.78-26.5-54.78-59.06c0-18.41 13.38-34.88 21.34-43.06c3.062-3.125 3.031-8.125-.0313-11.22C27.78 240.4 16 224.8 16 207.3c0-32.56 24.75-59.06 55.16-59.06c21.28 0 68.88 28.41 100.3 47.19C183.7 202.8 194.6 209.2 202.7 213.5c3.125 1.562 6.906 1.031 9.375-1.438S215.1 205.8 213.5 202.7c-4.281-8.125-10.75-19-18.03-31.19C176.7 140 148.3 92.44 148.3 71.16c0-30.22 26.5-54.78 59.06-54.78c18.41 0 34.88 13.38 43.06 21.34c3.156 3.062 8.125 3.031 11.22-.0313C271.6 27.78 287.2 16 304.7 16c32.56 0 59.06 24.75 59.06 55.16c0 21.28-28.41 68.88-47.19 100.3c-7.281 12.19-13.75 23.06-18.03 31.19c-1.625 3.094-1.031 6.906 1.438 9.375s6.25 3 9.375 1.438c8.125-4.281 19-10.75 31.19-18.03c31.47-18.78 79.06-47.19 100.3-47.19c30.22 0 54.78 26.5 54.78 59.06c0 18.41-13.38 34.88-21.34 43.06c-3.062 3.125-3.031 8.125 .0313 11.22C484.2 271.6 496 287.2 496 304.7C496 337.2 471.3 363.7 440.8 363.7z"],
    "club": [512, 512, [9827], "f327", "M512 304C512 379.1 451.1 440 376 440C330.5 440 290.3 417.7 265.6 383.4C265.1 382.7 264.5 381.9 264 381.2V496H344C348.4 496 352 499.6 352 504C352 508.4 348.4 512 344 512H168C163.6 512 160 508.4 160 504C160 499.6 163.6 496 168 496H248V381.2C247.5 381.9 246.9 382.7 246.4 383.4C221.7 417.7 181.5 440 136 440C60.89 440 0 379.1 0 304C0 238.5 46.33 183.8 108 170.9C113.2 169.8 118.5 169 123.9 168.5C122.6 163.4 121.7 158.1 121 152.7C120.3 147.2 120 141.7 120 136C120 60.89 180.9 0 256 0C331.1 0 392 60.89 392 136C392 141.7 391.7 147.2 390.1 152.7C390.3 158.1 389.4 163.4 388.1 168.5C393.5 169 398.8 169.8 403.1 170.9C465.7 183.8 512 238.5 512 304V304zM376 136C376 69.73 322.3 16 256 16C189.7 16 136 69.73 136 136C136 145.9 137.2 155.5 139.5 164.7C140.6 169.3 139.6 174 136.9 177.8C134.2 181.6 129.1 184.1 125.3 184.5C64.06 189.9 16 241.3 16 304C16 370.3 69.73 424 136 424C181.8 424 221.7 398.3 241.9 360.5C244.7 355.3 250.1 352.1 256 352.1C261.9 352.1 267.3 355.3 270.1 360.5C290.3 398.3 330.2 424 376 424C442.3 424 496 370.3 496 304C496 241.3 447.9 189.9 386.7 184.5C382 184.1 377.8 181.6 375.1 177.8C372.4 174 371.4 169.3 372.5 164.7C374.8 155.5 376 145.9 376 136L376 136z"],
    "coconut": [512, 512, [], "e2f6", "M161.4 357.9c37.88-14.75 79.19-43.23 116.3-80.23c79.34-79.25 112.9-170 76.44-206.6c-18.28-18.38-50.38-19.83-90.41-4.281C225.8 81.53 184.5 110 147.4 147c-79.37 79.25-112.9 170-76.44 206.6C80.91 363.6 94.88 368.6 112 368.6C126.4 368.6 143.1 365 161.4 357.9zM82.31 342.3C53.16 313.1 88.16 228.8 158.8 158.3c35.53-35.45 74.88-62.67 110.8-76.63c33.28-12.95 59.94-12.7 73.28 .6406c29.16 29.27-5.844 113.5-76.44 184c-35.53 35.45-74.88 62.67-110.8 76.63C122.3 355.9 95.63 355.7 82.31 342.3zM465.6 273.2L425.1 233.1c-3.093-3.125-8.156-3.188-11.31-.0625c-3.125 3.094-3.156 8.172-.0625 11.31l39.62 40.13c1.562 1.578 3.625 2.375 5.688 2.375c2.031 0 4.062-.7656 5.625-2.312C468.7 281.4 468.7 276.3 465.6 273.2zM438 67.58l-39.75-40.03C373.7 2.824 340.7 0 323.3 0c-63.36 0-145.1 38.74-214.4 107.7C64.06 152.3 31.82 202.2 14.54 249c-6.551 17.75-18.46 55.18-13.27 92.64c3.52 25.43 13.84 43.13 25.81 55.18l39.76 40.03C116.5 486.9 181.8 512 247.2 512c64.85 0 129.8-24.66 179.4-74.04l10.39-10.34C536.6 328.5 537.1 167.3 438 67.58zM38.45 385.6c-55.21-55.59-2.047-183.2 81.74-266.5C183.3 56.29 261.1 16 323.3 16c20.1 0 37.5 4.439 51.21 12.96c4.566 2.84 8.725 6.133 12.43 9.867c50.14 50.49 12.71 172.5-81.75 266.5c-63.89 63.57-141.7 103.1-203.1 103.1C75.28 408.4 53.28 400.5 38.45 385.6zM425.7 416.3l-10.39 10.34C370.3 471.4 310.6 496 247.2 496c-63.94 0-123.1-24.1-169.1-70.38l-4.5-4.531c8.994 1.979 18.34 3.328 28.38 3.328c63.36 0 145.1-38.82 214.4-107.8c80.2-79.8 119.8-176.2 105.9-242.1l4.305 4.334C519.3 172.2 518.9 323.5 425.7 416.3zM357.9 346.5c-3.094-3.109-8.156-3.141-11.31 0c-3.125 3.125-3.125 8.188 0 11.31l45.22 45.27c3.158 3.158 8.217 3.096 11.31 0c3.125-3.125 3.125-8.188 0-11.31L357.9 346.5zM244.8 414.4c-3.094-3.141-8.156-3.172-11.31-.0625c-3.125 3.094-3.188 8.156-.0625 11.31l39.63 40.14c1.562 1.578 3.625 2.375 5.688 2.375c2.031 0 4.062-.7656 5.625-2.312c3.125-3.094 3.188-8.156 .0625-11.31L244.8 414.4z"],
    "code": [640, 512, [], "f121", "M415.5 10.68L239.5 506.7C238.1 510.8 233.5 513 229.3 511.5C225.2 510.1 222.1 505.5 224.5 501.3L400.5 5.327C401.9 1.163 406.5-1.015 410.7 .4629C414.8 1.94 417 6.514 415.5 10.68V10.68zM493.5 122.2L629.5 250.2C631.1 251.7 632 253.8 632 256C632 258.2 631.1 260.3 629.5 261.8L493.5 389.8C490.3 392.9 485.2 392.7 482.2 389.5C479.1 386.3 479.3 381.2 482.5 378.2L612.3 256L482.5 133.8C479.3 130.8 479.1 125.7 482.2 122.5C485.2 119.3 490.3 119.1 493.5 122.2V122.2zM157.5 133.8L27.67 256L157.5 378.2C160.7 381.2 160.9 386.3 157.8 389.5C154.8 392.7 149.7 392.9 146.5 389.8L10.52 261.8C8.911 260.3 8 258.2 8 256C8 253.8 8.911 251.7 10.52 250.2L146.5 122.2C149.7 119.1 154.8 119.3 157.8 122.5C160.9 125.7 160.7 130.8 157.5 133.8V133.8z"],
    "code-branch": [448, 512, [], "f126", "M144 64C144 96.64 119.6 123.6 88 127.5V296.5C106.4 267.4 138.9 248 176 248H272C320.6 248 360 208.6 360 160V127.5C328.4 123.6 304 96.64 304 64C304 28.65 332.7 .0003 368 .0003C403.3 .0003 432 28.65 432 64C432 96.64 407.6 123.6 376 127.5V160C376 217.4 329.4 264 272 264H176C127.4 264 88 303.4 88 352V384.5C119.6 388.4 144 415.4 144 448C144 483.3 115.3 512 80 512C44.65 512 16 483.3 16 448C16 415.4 40.43 388.4 72 384.5V127.5C40.43 123.6 16 96.64 16 64C16 28.65 44.65 0 80 0C115.3 0 144 28.65 144 64V64zM80 112C106.5 112 128 90.51 128 64C128 37.49 106.5 16 80 16C53.49 16 32 37.49 32 64C32 90.51 53.49 112 80 112zM368 16C341.5 16 320 37.49 320 64C320 90.51 341.5 112 368 112C394.5 112 416 90.51 416 64C416 37.49 394.5 16 368 16zM80 496C106.5 496 128 474.5 128 448C128 421.5 106.5 400 80 400C53.49 400 32 421.5 32 448C32 474.5 53.49 496 80 496z"],
    "code-commit": [640, 512, [], "f386", "M447.8 264C443.6 330.1 388 384 320 384C251.1 384 196.4 330.1 192.2 264H8C3.582 264 0 260.4 0 256C0 251.6 3.582 248 8 248H192.2C196.4 181 251.1 128 320 128C388 128 443.6 181 447.8 248H632C636.4 248 640 251.6 640 256C640 260.4 636.4 264 632 264H447.8zM320 368C381.9 368 432 317.9 432 256C432 194.1 381.9 144 320 144C258.1 144 208 194.1 208 256C208 317.9 258.1 368 320 368z"],
    "code-compare": [512, 512, [], "e13a", "M205.4 10.08L293.4 90.08C295 91.6 296 93.75 296 96C296 98.25 295 100.4 293.4 101.9L205.4 181.9C202.1 184.9 197.1 184.7 194.1 181.4C191.1 178.1 191.3 173.1 194.6 170.1L267.3 104H176C127.4 104 88 143.4 88 192V384.5C119.6 388.4 144 415.4 144 448C144 483.3 115.3 512 80 512C44.65 512 16 483.3 16 448C16 415.4 40.43 388.4 72 384.5V192C72 134.6 118.6 88 176 88H267.3L194.6 21.92C191.3 18.95 191.1 13.89 194.1 10.62C197.1 7.35 202.1 7.109 205.4 10.08V10.08zM127.1 448C127.1 421.5 106.5 400 79.1 400C53.49 400 31.1 421.5 31.1 448C31.1 474.5 53.49 496 79.1 496C106.5 496 127.1 474.5 127.1 448zM306.6 501.9L218.6 421.9C216.1 420.4 215.1 418.3 215.1 416C215.1 413.7 216.1 411.6 218.6 410.1L306.6 330.1C309.9 327.1 314.9 327.4 317.9 330.6C320.9 333.9 320.6 338.9 317.4 341.9L244.7 408H336C384.6 408 424 368.6 424 320V127.5C392.4 123.6 368 96.64 368 64C368 28.65 396.7 0 432 0C467.3 0 496 28.65 496 64C496 96.64 471.6 123.6 440 127.5V320C440 377.4 393.4 424 336 424H244.7L317.4 490.1C320.6 493.1 320.9 498.1 317.9 501.4C314.9 504.6 309.9 504.9 306.6 501.9V501.9zM384 64C384 90.51 405.5 112 432 112C458.5 112 480 90.51 480 64C480 37.49 458.5 16 432 16C405.5 16 384 37.49 384 64z"],
    "code-fork": [448, 512, [], "e13b", "M128 64C128 96.64 103.6 123.6 72 127.5V192C72 222.9 97.07 248 128 248H320C350.9 248 376 222.9 376 192V127.5C344.4 123.6 320 96.64 320 64C320 28.65 348.7 0 384 0C419.3 0 448 28.65 448 64C448 96.64 423.6 123.6 392 127.5V192C392 231.8 359.8 264 320 264H232V384H224H216V264H128C88.24 264 56 231.8 56 192V127.5C24.43 123.6 0 96.64 0 64C0 28.65 28.65 0 64 0C99.35 0 128 28.65 128 64zM64 112C90.51 112 112 90.51 112 64C112 37.49 90.51 16 64 16C37.49 16 16 37.49 16 64C16 90.51 37.49 112 64 112zM384 112C410.5 112 432 90.51 432 64C432 37.49 410.5 16 384 16C357.5 16 336 37.49 336 64C336 90.51 357.5 112 384 112zM288 448C288 483.3 259.3 512 224 512C188.7 512 160 483.3 160 448C160 412.7 188.7 384 224 384C259.3 384 288 412.7 288 448zM224 400C197.5 400 176 421.5 176 448C176 474.5 197.5 496 224 496C250.5 496 272 474.5 272 448C272 421.5 250.5 400 224 400z"],
    "code-merge": [448, 512, [], "f387", "M88 144C88 210.3 141.7 264 208 264H320.5C324.4 232.4 351.4 208 384 208C419.3 208 448 236.7 448 272C448 307.3 419.3 336 384 336C351.4 336 324.4 311.6 320.5 280H208C156 280 110.9 250.9 88 208.1V384.5C119.6 388.4 144 415.4 144 448C144 483.3 115.3 512 80 512C44.65 512 16 483.3 16 448C16 415.4 40.43 388.4 72 384.5V127.5C40.43 123.6 16 96.64 16 64C16 28.65 44.65 0 80 0C115.3 0 144 28.65 144 64C144 96.64 119.6 123.6 88 127.5V144zM80 112C106.5 112 128 90.51 128 64C128 37.49 106.5 16 80 16C53.49 16 32 37.49 32 64C32 90.51 53.49 112 80 112zM80 496C106.5 496 128 474.5 128 448C128 421.5 106.5 400 80 400C53.49 400 32 421.5 32 448C32 474.5 53.49 496 80 496zM384 224C357.5 224 336 245.5 336 272C336 298.5 357.5 320 384 320C410.5 320 432 298.5 432 272C432 245.5 410.5 224 384 224z"],
    "code-pull-request": [512, 512, [], "e13c", "M88 384.5C119.6 388.4 144 415.4 144 448C144 483.3 115.3 512 80 512C44.65 512 16 483.3 16 448C16 415.4 40.43 388.4 72 384.5V127.5C40.43 123.6 16 96.64 16 64C16 28.65 44.65 0 80 0C115.3 0 144 28.65 144 64C144 96.64 119.6 123.6 88 127.5V384.5zM80 16C53.49 16 32 37.49 32 64C32 90.51 53.49 112 80 112C106.5 112 128 90.51 128 64C128 37.49 106.5 16 80 16zM80 400C53.49 400 32 421.5 32 448C32 474.5 53.49 496 80 496C106.5 496 128 474.5 128 448C128 421.5 106.5 400 80 400zM368 448C368 415.4 392.4 388.4 424 384.5V192C424 143.4 384.6 104 336 104H244.7L317.4 170.1C320.6 173.1 320.9 178.1 317.9 181.4C314.9 184.7 309.9 184.9 306.6 181.9L218.6 101.9C216.1 100.4 216 98.25 216 96C216 93.75 216.1 91.6 218.6 90.08L306.6 10.08C309.9 7.109 314.9 7.35 317.9 10.62C320.9 13.89 320.6 18.95 317.4 21.92L244.7 88H336C393.4 88 440 134.6 440 192V384.5C471.6 388.4 496 415.4 496 448C496 483.3 467.3 512 432 512C396.7 512 368 483.3 368 448zM432 496C458.5 496 480 474.5 480 448C480 421.5 458.5 400 432 400C405.5 400 384 421.5 384 448C384 474.5 405.5 496 432 496z"],
    "code-pull-request-closed": [448, 512, [], "e3f9", "M88 384.5C119.6 388.4 144 415.4 144 448C144 483.3 115.3 512 80 512C44.65 512 16 483.3 16 448C16 415.4 40.43 388.4 72 384.5V127.5C40.43 123.6 16 96.64 16 64C16 28.65 44.65 0 80 0C115.3 0 144 28.65 144 64C144 96.64 119.6 123.6 88 127.5V384.5zM80 112C106.5 112 128 90.51 128 64C128 37.49 106.5 16 80 16C53.49 16 32 37.49 32 64C32 90.51 53.49 112 80 112zM80 400C53.49 400 32 421.5 32 448C32 474.5 53.49 496 80 496C106.5 496 128 474.5 128 448C128 421.5 106.5 400 80 400zM298.3 10.34C301.5 7.219 306.5 7.219 309.7 10.34L368 68.69L426.3 10.34C429.5 7.219 434.5 7.219 437.7 10.34C440.8 13.47 440.8 18.53 437.7 21.66L379.3 80L437.7 138.3C440.8 141.5 440.8 146.5 437.7 149.7C434.5 152.8 429.5 152.8 426.3 149.7L368 91.31L309.7 149.7C306.5 152.8 301.5 152.8 298.3 149.7C295.2 146.5 295.2 141.5 298.3 138.3L356.7 80L298.3 21.66C295.2 18.53 295.2 13.47 298.3 10.34V10.34zM304 448C304 415.4 328.4 388.4 360 384.5V200C360 195.6 363.6 192 368 192C372.4 192 376 195.6 376 200V384.5C407.6 388.4 432 415.4 432 448C432 483.3 403.3 512 368 512C332.7 512 304 483.3 304 448zM368 496C394.5 496 416 474.5 416 448C416 421.5 394.5 400 368 400C341.5 400 320 421.5 320 448C320 474.5 341.5 496 368 496z"],
    "code-pull-request-draft": [448, 512, [], "e3fa", "M88 384.5C119.6 388.4 144 415.4 144 448C144 483.3 115.3 512 80 512C44.65 512 16 483.3 16 448C16 415.4 40.43 388.4 72 384.5V127.5C40.43 123.6 16 96.64 16 64C16 28.65 44.65 0 80 0C115.3 0 144 28.65 144 64C144 96.64 119.6 123.6 88 127.5V384.5zM80 16C53.49 16 32 37.49 32 64C32 90.51 53.49 112 80 112C106.5 112 128 90.51 128 64C128 37.49 106.5 16 80 16zM80 400C53.49 400 32 421.5 32 448C32 474.5 53.49 496 80 496C106.5 496 128 474.5 128 448C128 421.5 106.5 400 80 400zM304 448C304 412.7 332.7 384 368 384C403.3 384 432 412.7 432 448C432 483.3 403.3 512 368 512C332.7 512 304 483.3 304 448zM368 496C394.5 496 416 474.5 416 448C416 421.5 394.5 400 368 400C341.5 400 320 421.5 320 448C320 474.5 341.5 496 368 496zM328 80C328 57.91 345.9 40 368 40C390.1 40 408 57.91 408 80C408 102.1 390.1 120 368 120C345.9 120 328 102.1 328 80zM368 104C381.3 104 392 93.26 392 80C392 66.75 381.3 56 368 56C354.7 56 344 66.75 344 80C344 93.26 354.7 104 368 104zM408 240C408 262.1 390.1 280 368 280C345.9 280 328 262.1 328 240C328 217.9 345.9 200 368 200C390.1 200 408 217.9 408 240zM368 216C354.7 216 344 226.7 344 240C344 253.3 354.7 264 368 264C381.3 264 392 253.3 392 240C392 226.7 381.3 216 368 216z"],
    "code-simple": [576, 512, [], "e13d", "M19.56 256L205.5 434.2C208.7 437.3 208.8 442.3 205.8 445.5C202.7 448.7 197.7 448.8 194.5 445.8L2.465 261.8C.8902 260.3 0 258.2 0 256C0 253.8 .8902 251.7 2.465 250.2L194.5 66.22C197.7 63.17 202.7 63.27 205.8 66.46C208.8 69.65 208.7 74.72 205.5 77.78L19.56 256zM370.5 77.78C367.3 74.72 367.2 69.66 370.2 66.47C373.3 63.28 378.3 63.17 381.5 66.22L573.5 250.2C575.1 251.7 576 253.8 576 256C576 258.2 575.1 260.3 573.5 261.8L381.5 445.8C378.3 448.8 373.3 448.7 370.2 445.5C367.2 442.3 367.3 437.3 370.5 434.2L556.4 256L370.5 77.78z"],
    "coffee-bean": [448, 512, [], "e13e", "M435.8 130.5c-9.9-23.33-65.71-77.27-82.65-84.81C332.1 36.3 309.9 32 287.2 32C219.8 32 148.4 69.66 93.44 124.7c-72.35 72.44-116.1 174.8-81.27 256.8c9.9 23.33 65.7 77.27 82.65 84.81C115.9 475.7 138.1 480 160.9 480c67.34 0 138.7-37.67 193.6-92.7C426.9 314.9 470.6 212.5 435.8 130.5zM104.8 136C159.8 80.9 227.1 48 287.1 48c21.22 0 41.26 4.133 59.57 12.28c5.963 2.656 19.45 14.05 33.38 27.51c-24.43 94.32-80.72 152.6-163.4 168.1c-85.19 16.03-142.4 67.9-166.1 149.6c-10.76-11.76-19.74-23.09-22.79-30.28C-2.273 306.5 28.31 212.6 104.8 136zM343.2 375.1C288.2 431.1 220 464 160.9 464c-21.22 0-41.26-4.133-59.57-12.29c-6.77-3.014-23.2-17.12-39.01-32.95c21.29-80.76 75.45-131.7 157.3-147.1c86.52-16.31 145.9-75.58 173.3-170.1c13.1 13.75 24.7 27.68 28.24 36.04C450.3 205.5 419.7 299.4 343.2 375.1z"],
    "coffee-beans": [512, 512, [], "e13f", "M170.2 196.4C162 193.3 144.4 192 127.3 192c-16.83 0-33.06 1.297-39.01 3.449c-58.92 21.33-88.37 88.34-88.32 156.2c.0449 66.77 28.7 134.1 85.8 155.9C93.97 510.7 111.6 512 128.7 512c16.83 0 33.06-1.297 39.01-3.451c58.92-21.33 88.37-88.34 88.32-156.2C255.1 285.6 227.3 218.2 170.2 196.4zM125.9 495.9c-17.8-.1699-30.3-1.785-34.37-3.336C35.83 471.4 16.04 403.4 16 351.6C15.96 299.5 36.31 231.3 93.75 210.5C96.11 209.7 104.8 208.6 117.2 208.2c-29.02 55.02-28.17 108.2 3.465 154.5C149.7 405.2 151.3 451.2 125.9 495.9zM162.2 493.5c-1.994 .6797-8.686 1.549-18.13 2.062c23.96-47.75 20.71-96.52-10.28-141.9C97.04 299.7 113.6 245.5 135.3 208.2C150.2 208.6 160.8 210 164.5 211.4C220.2 232.6 239.1 300.6 240 352.4C240 404.5 219.7 472.7 162.2 493.5zM455.6 56.93C421.8 23.23 377.1 0 334.4 0c-14.98 0-29.73 2.852-43.69 9.106c-15.31 6.859-51.31 44.04-56.53 55.17C208.5 119 234.1 184.8 280.4 231c33.74 33.7 78.42 56.93 121.2 56.93c14.98 0 29.73-2.852 43.69-9.106c15.31-6.859 51.31-44.04 56.53-55.17C527.5 168.1 501.9 103.2 455.6 56.93zM438.8 264.3c-11.42 5.113-23.91 7.707-37.15 7.707c-36.04 0-77.11-19.53-109.9-52.25c-35.43-35.38-67.98-95.55-43.12-148.6c1.545-3.104 7.02-9.674 13.86-16.97c17.87 56.98 54.72 92.49 107.7 102.5c48.59 9.143 80.92 39.18 94.07 86.67C454.5 252.9 444.2 261.8 438.8 264.3zM487.4 216.9c-1.266 2.543-5.299 7.5-10.42 13.19c-16.36-48.58-51.82-79.46-103.8-89.23c-61.52-11.55-87.14-59.46-97.9-99.55c8.625-8.221 17.17-15.44 21.97-17.59c11.42-5.113 23.91-7.707 37.15-7.707c36.04 0 77.11 19.53 109.9 52.25C479.7 103.6 512.2 163.8 487.4 216.9z"],
    "coffee-pot": [512, 512, [], "e002", "M431.5 177.6L480 32H72C32.31 32 0 64.3 0 104v112C0 220.4 3.594 224 8 224S16 220.4 16 216v-112c0-30.88 25.12-56 56-56h29.34l43.41 130.1C95.38 217.9 64 277.8 64 344.6c0 51.5 18.62 84.74 49.62 117.7C124.5 473.6 139.5 480 155.1 480l265.8 0c15.62 0 30.57-6.192 41.32-17.57C493.2 429.6 512 396.1 512 344.6C512 278.4 481.4 217.9 431.5 177.6zM118.2 48h339.6l-42.63 128H160.9L118.2 48zM153.2 192h270.4c35.23 29.26 58.87 68.62 68.02 112H84.45C93.71 260.7 117.6 221.3 153.2 192zM450.6 451.4C443 459.4 432.2 464 420.9 464H155.1c-11.23 0-22.17-4.645-29.84-12.58C98.1 422.5 80 393.2 80 344.6C80 336.3 80.65 328.1 81.69 320h412.7C495.4 328.1 496 336.3 496 344.6C496 393.3 477.9 422.5 450.6 451.4z"],
    "coffin": [448, 512, [9904], "f6c6", "M406.5 115.2l-107.8-105.9C292.6 3.375 284.3 0 275.6 0H172.4C163.7 0 155.4 3.375 149.2 9.375L41.46 115.2c-8.002 7.875-11.25 19.38-8.502 30.38l87.14 342.1C123.7 502 136.7 512 151.7 512h144.7c14.88 0 27.88-9.1 31.51-24.25l87.14-342.1C417.8 134.6 414.5 123.1 406.5 115.2zM312.4 483.8C310.6 490.1 303.1 496 296.4 496H151.7c-7.668 0-14.3-5.016-16.13-12.2l-87.13-342.1C47.11 136.2 48.68 130.6 52.68 126.7l107.8-105.9C163.5 17.75 167.9 16 172.4 16h103.3c4.465 0 8.814 1.752 11.92 4.789l107.8 105.9c4.008 3.943 5.578 9.586 4.219 15.02L312.4 483.8z"],
    "coffin-cross": [384, 512, [], "e051", "M374.5 115.3l-107.8-105.9C260.6 3.375 252.3 0 243.6 0h-103.3C131.7 0 123.4 3.375 117.2 9.375l-107.8 105.9c-8.002 7.875-11.25 19.38-8.502 30.38l87.14 342.1C91.73 502 104.7 512 119.7 512h144.7c14.88 0 27.88-9.1 31.51-24.25l87.14-342.1C385.8 134.6 382.5 123.1 374.5 115.3zM280.4 483.8C278.6 490.1 271.1 496 264.4 496H119.7c-7.668 0-14.3-5.016-16.13-12.2l-87.13-342.1C15.11 136.2 16.68 130.6 20.68 126.7l107.8-105.9C131.5 17.75 135.9 16 140.4 16h103.3c4.465 0 8.814 1.752 11.92 4.789l107.8 105.9c4.008 3.943 5.578 9.586 4.219 15.02L280.4 483.8zM280 184h-80v-80c0-4.422-3.593-8-7.999-8S184 99.58 184 104v80h-80C99.59 184 96 187.6 96 192s3.594 8 8 8h80v144c0 4.422 3.593 8 7.999 8S200 348.4 200 344v-144h80C284.4 200 288 196.4 288 192S284.4 184 280 184z"],
    "coin": [512, 512, [129689], "f85c", "M389.4 270.7C354.9 286.5 307.7 296 256 296C204.3 296 157.1 286.5 122.6 270.7C88.72 255.2 64 232.2 64 204C64 175.8 88.72 152.8 122.6 137.3C157.1 121.5 204.3 112 256 112C307.7 112 354.9 121.5 389.4 137.3C423.3 152.8 448 175.8 448 204C448 232.2 423.3 255.2 389.4 270.7zM129.2 151.9C96.47 166.8 80 185.9 80 204C80 222.1 96.47 241.2 129.2 256.1C161.2 270.7 206.1 280 256 280C305.9 280 350.7 270.7 382.8 256.1C415.5 241.2 432 222.1 432 204C432 185.9 415.5 166.8 382.8 151.9C350.7 137.3 305.9 128 256 128C206.1 128 161.2 137.3 129.2 151.9V151.9zM0 208C0 128.5 114.6 64 256 64C397.4 64 512 128.5 512 208V320C512 390.7 397.4 448 256 448C114.6 448 0 390.7 0 320V208zM429.2 295.9C473.2 271.1 496 239.4 496 208C496 176.6 473.2 144.9 429.2 120.1C385.7 95.64 324.5 80 256 80C187.5 80 126.3 95.64 82.82 120.1C38.81 144.9 16 176.6 16 208C16 239.4 38.81 271.1 82.82 295.9C126.3 320.4 187.5 336 256 336C324.5 336 385.7 320.4 429.2 295.9V295.9zM168 423.1C192.8 428.7 219.8 431.5 248 431.9V351.9C219.1 351.4 193.1 348.4 168 343.3V423.1zM152 339.6C128.6 333.8 107.1 325.1 88 316.7V399C106.6 407.7 128.2 415.1 152 420.6V339.6zM16 320C16 343.1 34.25 369.5 72 390.8V308.1C47.67 293.1 28.44 277 16 258.2V320zM344 343.3C318.9 348.4 292 351.4 264 351.9V431.9C292.2 431.5 319.2 428.7 344 423.1V343.3zM360 339.6V420.6C383.8 415.1 405.4 407.7 424 399V316.7C404.9 325.1 383.4 333.8 360 339.6V339.6zM496 258.2C483.6 277 464.3 293.1 440 308.1V390.8C477.8 369.5 496 343.1 496 320V258.2z"],
    "coin-blank": [512, 512, [], "e3fb", "M512 208V320C512 390.7 397.4 448 256 448C114.6 448 0 390.7 0 320V208C0 128.5 114.6 64 256 64C397.4 64 512 128.5 512 208zM82.82 295.9C126.3 320.4 187.5 336 256 336C324.5 336 385.7 320.4 429.2 295.9C473.2 271.1 496 239.4 496 208C496 176.6 473.2 144.9 429.2 120.1C385.7 95.64 324.5 80 256 80C187.5 80 126.3 95.64 82.82 120.1C38.81 144.9 16 176.6 16 208C16 239.4 38.81 271.1 82.82 295.9zM248 351.9C219.1 351.4 193.1 348.4 168 343.3V423.1C192.8 428.7 219.8 431.5 248 431.9V351.9zM88 399C106.6 407.7 128.2 415.1 152 420.6V339.6C128.6 333.8 107.1 325.1 88 316.7V399zM72 308.1C47.67 293.1 28.44 277 16 258.2V320C16 343.1 34.25 369.5 72 390.8V308.1zM264 431.9C292.2 431.5 319.2 428.7 344 423.1V343.3C318.9 348.4 292 351.4 264 351.9V431.9zM424 399V316.7C404.9 325.1 383.4 333.8 360 339.6V420.6C383.8 415.1 405.4 407.7 424 399zM440 390.8C477.8 369.5 496 343.1 496 320V258.2C483.6 277 464.3 293.1 440 308.1V390.8z"],
    "coin-front": [512, 512, [], "e3fc", "M264 344C264 348.4 260.4 352 256 352C251.6 352 248 348.4 248 344V168C248 163.6 251.6 160 256 160C260.4 160 264 163.6 264 168V344zM64 256C64 149.1 149.1 64 256 64C362 64 448 149.1 448 256C448 362 362 448 256 448C149.1 448 64 362 64 256zM256 432C353.2 432 432 353.2 432 256C432 158.8 353.2 80 256 80C158.8 80 80 158.8 80 256C80 353.2 158.8 432 256 432zM0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM256 496C388.5 496 496 388.5 496 256C496 123.5 388.5 16 256 16C123.5 16 16 123.5 16 256C16 388.5 123.5 496 256 496z"],
    "coin-vertical": [384, 512, [], "e3fd", "M206.7 122.6C222.5 157.1 232 204.3 232 256C232 307.7 222.5 354.9 206.7 389.4C191.2 423.3 168.2 448 140 448C111.8 448 88.78 423.3 73.33 389.4C57.55 354.9 48 307.7 48 256C48 204.3 57.55 157.1 73.33 122.6C88.78 88.72 111.8 64 140 64C168.2 64 191.2 88.72 206.7 122.6V122.6zM87.88 382.8C102.8 415.5 121.9 432 140 432C158.1 432 177.2 415.5 192.1 382.8C206.7 350.7 216 305.9 216 256C216 206.1 206.7 161.2 192.1 129.2C177.2 96.47 158.1 80 140 80C121.9 80 102.8 96.47 87.88 129.2C73.26 161.2 64 206.1 64 256C64 305.9 73.26 350.7 87.88 382.8zM144 512C64.47 512 0 397.4 0 256C0 114.6 64.47 0 144 0H256C326.7 0 384 114.6 384 256C384 397.4 326.7 512 256 512H144zM231.9 82.82C207.1 38.81 175.4 16 144 16C112.6 16 80.88 38.81 56.12 82.82C31.64 126.3 16 187.5 16 256C16 324.5 31.64 385.7 56.12 429.2C80.88 473.2 112.6 496 144 496C175.4 496 207.1 473.2 231.9 429.2C256.4 385.7 272 324.5 272 256C272 187.5 256.4 126.3 231.9 82.82V82.82zM359.1 344C364.7 319.2 367.5 292.2 367.9 264H287.9C287.4 292 284.4 318.9 279.3 344H359.1zM275.6 360C269.8 383.4 261.1 404.9 252.7 424H335C343.7 405.4 351.1 383.8 356.6 360H275.6zM256 496C279.1 496 305.5 477.8 326.8 440H244.1C229.1 464.3 213 483.6 194.2 496H256zM279.3 168C284.4 193.1 287.4 219.1 287.9 248H367.9C367.5 219.8 364.7 192.8 359.1 168H279.3zM275.6 152H356.6C351.1 128.2 343.7 106.6 335 88H252.7C261.1 107.1 269.8 128.6 275.6 152V152zM194.2 16C213 28.44 229.1 47.67 244.1 72H326.8C305.5 34.25 279.1 16 256 16H194.2z"],
    "coins": [512, 512, [], "f51e", "M155.9 102.2C159.7 105.7 164.4 109.1 169.9 112.4C161.5 112.8 153.2 113.3 145.1 113.1L145 113.9C134.7 104.4 127.1 92.92 127.1 80C127.1 67.08 134.7 55.64 145 46.1C155.3 36.58 169.8 28.37 186.1 21.64C221.4 8.163 268.5 .0015 320 .0015C371.5 .0015 418.6 8.163 453 21.64C470.2 28.37 484.7 36.58 494.1 46.1C505.3 55.64 512 67.08 512 80V289.9C512 302.6 505.2 313.9 494.9 323.1C484.6 332.4 470.1 340.4 452.1 346.9C441.9 351.2 429.4 354.9 416 357.9V341.5C427.4 338.8 437.9 335.6 447.3 331.1C463.4 325.9 475.9 318.7 484.2 311.2C492.5 303.8 496 296.5 496 289.9V216.2C495.6 216.6 495.3 216.9 494.9 217.2C484.6 226.5 470.1 234.5 452.1 241C441.9 245.3 429.4 248.1 416 252V235.6C427.4 232.9 437.9 229.7 447.3 226.1C463.4 219.1 475.9 212.8 484.2 205.3C492.5 197.8 496 190.6 496 184V112.9C495.7 113.3 495.3 113.6 494.1 113.9C484.7 123.4 470.2 131.6 453 138.4C432.9 146.2 408.5 152.3 381.4 155.1C374.3 150.9 366.3 146.4 357.9 142.4C392.6 139.5 423.4 132.8 447.2 123.5C463.3 117.2 475.8 109.9 484.1 102.2C492.4 94.46 496 86.97 496 80C496 73.04 492.4 65.54 484.1 57.85C475.8 50.15 463.3 42.84 447.2 36.54C415 23.96 370.1 16 320 16C269.9 16 224.1 23.96 192.8 36.54C176.7 42.84 164.2 50.15 155.9 57.85C147.6 65.54 144 73.04 144 80C144 86.97 147.6 94.46 155.9 102.2L155.9 102.2zM0 223.1C0 211.1 6.722 199.6 17.03 190.1C27.32 180.6 41.78 172.4 58.98 165.6C93.42 152.2 140.5 143.1 192 143.1C243.5 143.1 290.6 152.2 325 165.6C342.2 172.4 356.7 180.6 366.1 190.1C377.3 199.6 384 211.1 384 223.1V433.9C384 446.6 377.2 457.9 366.9 467.1C356.6 476.4 342.1 484.4 324.1 490.9C290.5 504.1 243.5 512 192 512C140.5 512 93.46 504.1 59.04 490.9C41.86 484.4 27.41 476.4 17.11 467.1C6.807 457.9 .0006 446.6 .0006 433.9L0 223.1zM27.89 246.2C36.22 253.9 48.71 261.2 64.81 267.5C96.96 280 141.9 287.1 192 287.1C242.1 287.1 287 280 319.2 267.5C335.3 261.2 347.8 253.9 356.1 246.2C364.4 238.5 368 230.1 368 223.1C368 217 364.4 209.5 356.1 201.8C347.8 194.1 335.3 186.8 319.2 180.5C287 167.1 242.1 159.1 192 159.1C141.9 159.1 96.96 167.1 64.81 180.5C48.71 186.8 36.22 194.1 27.89 201.8C19.58 209.5 16 217 16 223.1C16 230.1 19.58 238.5 27.89 246.2V246.2zM366.1 257.9C356.7 267.4 342.2 275.6 325 282.4C290.6 295.8 243.5 303.1 192 303.1C140.5 303.1 93.42 295.8 58.98 282.4C41.78 275.6 27.32 267.4 17.03 257.9C16.68 257.6 16.34 257.3 16 256.9V328C16 334.6 19.49 341.8 27.81 349.3C36.13 356.8 48.62 363.9 64.74 370.1C96.92 382.3 141.9 390.1 192 390.1C242.1 390.1 287.1 382.3 319.3 370.1C335.4 363.9 347.9 356.8 356.2 349.3C364.5 341.8 368 334.6 368 328V256.9C367.7 257.3 367.3 257.6 366.1 257.9H366.1zM17.11 361.2C16.73 360.9 16.36 360.6 16 360.2V433.9C16 440.5 19.49 447.7 27.81 455.2C36.13 462.7 48.62 469.9 64.74 475.1C96.92 488.2 141.9 496 192 496C242.1 496 287.1 488.2 319.3 475.1C335.4 469.9 347.9 462.7 356.2 455.2C364.5 447.7 368 440.5 368 433.9V360.2C367.6 360.6 367.3 360.9 366.9 361.2C356.6 370.5 342.1 378.5 324.1 385C290.5 398.2 243.5 406.1 192 406.1C140.5 406.1 93.46 398.2 59.04 385C41.86 378.5 27.41 370.5 17.11 361.2H17.11z"],
    "colon": [128, 512, [], "3a", "M64 320c-35.35 0-64 28.65-64 64c0 35.35 28.65 64 64 64s64-28.65 64-64C128 348.7 99.35 320 64 320zM64 432c-26.47 0-48-21.53-48-48s21.53-48 48-48s48 21.53 48 48S90.47 432 64 432zM64 192c35.35 0 64-28.65 64-64c0-35.35-28.65-64-64-64s-64 28.65-64 64C.0008 163.3 28.66 192 64 192zM64 80c26.47 0 48 21.53 48 48s-21.53 48-48 48s-48-21.53-48-48S37.54 80 64 80z"],
    "colon-sign": [320, 512, [], "e140", "M203.5 64.07C224.9 64.64 245.5 68.5 264.6 75.15L280.2 6.238C281.2 1.928 285.5-.7769 289.8 .1962C294.1 1.169 296.8 5.452 295.8 9.762L279.7 81.07C292.9 86.86 305.3 94.01 316.7 102.3C320.3 104.9 321.1 109.9 318.5 113.5C315.9 117.1 310.9 117.9 307.3 115.3C297.6 108.2 287.2 102.1 276.1 96.99L200.5 431.1C240.6 431.5 277.5 418.4 307.3 396.7C310.9 394.1 315.9 394.9 318.5 398.5C321.1 402.1 320.3 407.1 316.7 409.7C283.6 433.8 242.5 448 197.1 448C197.6 448 197.2 448 196.8 447.1L183.8 505.8C182.8 510.1 178.5 512.8 174.2 511.8C169.9 510.8 167.2 506.5 168.2 502.2L180.6 447.3C159.4 445.5 139.1 440.4 120.3 432.7L103.8 505.8C102.8 510.1 98.55 512.8 94.24 511.8C89.93 510.8 87.22 506.5 88.2 502.2L105.5 425.8C42.8 393.6 0 329.8 0 256C0 153.3 83.03 69.77 187.1 64.29L200.2 6.238C201.2 1.928 205.5-.7769 209.8 .1962C214.1 1.169 216.8 5.452 215.8 9.762L203.5 64.07zM183.4 80.55C89.52 87.74 16 163.8 16 255.1C16 321.9 53.48 379.5 109.1 409.6L183.4 80.55zM184.2 431.5L261.1 90.86C242 84.05 221.4 80.23 199.9 80.01L123.9 416.8C142.5 424.9 162.8 429.1 184.2 431.5z"],
    "columns-3": [640, 512, [], "e361", "M0 96C0 60.65 28.65 32 64 32H576C611.3 32 640 60.65 640 96V416C640 451.3 611.3 480 576 480H64C28.65 480 0 451.3 0 416V96zM448 464H576C602.5 464 624 442.5 624 416V96C624 69.49 602.5 48 576 48H448V464zM432 48H208V464H432V48zM192 464V48H64C37.49 48 16 69.49 16 96V416C16 442.5 37.49 464 64 464H192z"],
    "comet": [512, 512, [], "e003", "M505 6.906c-6.173-6.172-15.18-8.407-23.58-5.891c-20.64 6.141-92.66 27.86-174.3 56.66l-3.047-10.03c-2.047-6.719-6.986-12.13-13.44-14.81c-6.423-2.781-13.77-2.453-20.07 .8438C227.7 56 121.4 114.3 60.19 173.8c-.9377 .7656-1.86 1.531-2.626 2.297c-76.75 76.74-76.75 201.6 0 278.3C94.65 491.5 144 512 196.6 512c52.64 0 102.1-20.5 139.2-57.72c.7658-.7656 1.532-1.688 2.985-3.469c58.09-59.77 116.9-166.5 139.4-209.5c3.298-6.25 3.641-13.58 .9533-20.02c-2.626-6.578-8.08-11.52-14.86-13.52l-10.08-3.047c27.24-77.33 48.67-147.3 56.81-174.4C513.5 21.83 511.2 12.84 505 6.906zM495.7 25.77c-8.377 27.89-30.9 101.4-59.34 181.5l-2.813 7.891l26.13 7.907c2.125 .625 3.86 2.188 4.688 4.25c.8752 2.109 .7814 4.485-.3126 6.516c-22.24 42.49-80.09 147.6-136.1 206.1l-2.579 3.031c-34.15 34.2-79.58 53.03-127.9 53.03c-48.28 0-93.63-18.78-127.7-52.91c-70.51-70.5-70.51-185.2 1.422-256.9l1.891-1.609c60.53-58.92 172.8-119.5 205.9-136.7c1.11-.5938 2.313-.8907 3.516-.8907c.9689 0 1.954 .2031 2.876 .6094c2.141 .875 3.735 2.609 4.407 4.828l7.861 25.97l7.908-2.813C389.1 45.5 464.8 22.64 486 16.36c2.782-.8438 5.673-.1563 7.783 1.953C495.7 20.17 496.5 23.12 495.7 25.77zM300.7 268.8L239.4 259.8L211.9 204.1c-3.688-7.578-11.52-12.47-19.97-12.47c-8.517 0-16.39 4.891-20.07 12.44L144.4 259.8L83.11 268.8C74.64 269.9 67.5 275.9 64.89 284.1c-2.516 8.078-.3595 16.81 5.689 22.89l44.48 43.38l-10.55 61.17c-1.438 8.547 2.047 16.98 9.096 22.02c3.891 2.766 8.392 4.172 12.89 4.172c3.563 0 7.126-.875 10.38-2.656l55.03-28.89l54.84 28.86c7.517 4.016 16.53 3.406 23.61-1.641c6.814-4.953 10.27-13.55 8.83-21.88l-10.44-61.16l44.57-43.47c5.986-6 8.111-15.03 5.47-22.84C316.2 275.9 309.3 270.1 300.7 268.8zM302 295.6l-50.45 49.19l11.86 69.47c.4063 2.344-.5939 4.844-2.407 6.172c-2.016 1.438-4.657 1.609-6.767 .5l-62.34-32.8l-62.58 32.86c-2.985 1.641-5.486 .2657-6.439-.4531c-.9846-.7032-3.204-2.719-2.594-6.297l11.96-69.44L81.83 295.6C80.04 293.8 79.43 291.3 80.16 288.9c.7033-2.219 2.719-3.906 5.142-4.219l69.72-10.25l31.18-63.35C187.2 208.9 189.5 207.6 191.9 207.6c2.329 0 4.579 1.391 5.611 3.516l31.29 63.3l69.58 10.25c2.469 .3594 4.438 1.984 5.204 4.36C304.3 291.2 303.7 293.8 302 295.6z"],
    "comma": [192, 512, [], "2c", "M97.36 304c19.43 0 37.91 12.13 43.96 28.85c4.533 12.49 3.285 26.22-3.412 37.66l-67.69 115.4C66.56 492.1 59.78 496 52.51 496c-2.395 0-4.76-.4172-7.029-1.241c-9.307-3.375-14.85-12.86-13.18-22.57l22.57-131.7C57.11 327.4 65.02 316.1 76.58 309.4C82.66 305.9 89.84 304 97.36 304zM97.35 287.1C97.35 287.1 97.36 287.1 97.35 287.1c-9.959 .002-19.91 2.39-28.8 7.544c-15.66 9.051-26.41 24.44-29.45 42.25l-22.57 131.7c-2.986 17.32 6.9 34.29 23.49 40.31C44.12 511.3 48.34 511.1 52.51 511.1c12.67 0 24.82-6.604 31.51-18.03l67.69-115.4c9.119-15.58 10.81-34.25 4.652-51.21C147.6 303.1 122.4 287.1 97.35 287.1z"],
    "command": [448, 512, [], "e142", "M368 320h-64V192h64C412.2 192 448 156.2 448 112S412.2 32 368 32S288 67.82 288 112v64H160v-64C160 67.82 124.2 32 80 32S0 67.82 0 112S35.82 192 80 192h64v128h-64C35.82 320 0 355.8 0 400S35.82 480 80 480S160 444.2 160 400v-64h128v64c0 44.18 35.82 80 80 80s80-35.82 80-80S412.2 320 368 320zM304 112c0-35.29 28.71-64 64-64s64 28.71 64 64s-28.71 64-64 64h-64V112zM80 176c-35.29 0-64-28.71-64-64s28.71-64 64-64s64 28.71 64 64v64H80zM144 400c0 35.29-28.71 64-64 64s-64-28.71-64-64s28.71-64 64-64h64V400zM160 320V192h128v128H160zM368 464c-35.29 0-64-28.71-64-64v-64h64c35.29 0 64 28.71 64 64S403.3 464 368 464z"],
    "comment": [512, 512, [61669, 128489], "f075", "M256 32C114.6 32 .0272 125.1 .0272 240c0 49.59 21.38 95.03 56.97 130.7c-12.5 50.39-54.27 95.27-54.77 95.77c-2.188 2.297-2.781 5.734-1.5 8.734C2.042 478.2 4.813 480 8 480c66.31 0 116-31.78 140.6-51.39C181.3 440.9 217.6 448 256 448c141.4 0 255.1-93.09 255.1-208S397.4 32 256 32zM256 432c-35.12 0-69.36-6.184-101.8-18.38L145.7 410.4l-7.105 5.666c-20.2 16.11-60.14 42.04-112.7 47.06c14.44-18.29 37.42-51.68 46.57-88.59l2.172-8.758l-6.371-6.391C34.1 325.1 16 283.8 16 240c0-105.9 107.7-192 240-192s240 86.13 240 192S388.3 432 256 432z"],
    "comment-arrow-down": [512, 512, [], "e143", "M256 32C114.6 32 .0273 125.1 .0273 240c0 49.59 21.38 95.03 56.97 130.7c-12.5 50.39-54.27 95.27-54.77 95.77c-2.188 2.297-2.781 5.734-1.5 8.734C2.041 478.2 4.813 480 8 480c66.31 0 116-31.78 140.6-51.39C181.3 440.9 217.6 448 256 448C397.4 448 512 354.9 512 240S397.4 32 256 32zM256 432c-35.12 0-69.36-6.184-101.8-18.38L145.7 410.4l-7.105 5.666c-20.2 16.11-60.14 42.04-112.7 47.06c14.44-18.29 37.42-51.68 46.57-88.59l2.172-8.758l-6.371-6.391C34.1 325.1 16 283.8 16 240c0-105.9 107.7-192 240-192s240 86.13 240 192S388.3 432 256 432zM346.9 232.6c-.875-.3438-1.609-.6562-2.5-.6562c-5.123 0-15.6 10.37-80.44 76.5V152c0-4.406-3.578-8-8-8S248 147.6 248 152v156.7L173.7 234.3c-3.125-3.125-8.188-3.125-11.31 0s-3.125 8.188 0 11.31l88 88C251.8 335.2 253.9 336 256 336s4.219-.875 5.719-2.406c30.45-31.06 80.17-81.41 86.47-86.78c1.422-.875 2.594-2.188 3.25-3.875C353.1 238.8 351 234.2 346.9 232.6z"],
    "comment-arrow-up": [512, 512, [], "e144", "M256 32C114.6 32 .0273 125.1 .0273 240c0 49.59 21.38 95.03 56.97 130.7c-12.5 50.39-54.27 95.27-54.77 95.77c-2.188 2.297-2.781 5.734-1.5 8.734C2.041 478.2 4.813 480 8 480c66.31 0 116-31.78 140.6-51.39C181.3 440.9 217.6 448 256 448C397.4 448 512 354.9 512 240S397.4 32 256 32zM256 432c-35.12 0-69.36-6.184-101.8-18.38L145.7 410.4l-7.105 5.666c-20.2 16.11-60.14 42.04-112.7 47.06c14.44-18.29 37.42-51.68 46.57-88.59l2.172-8.758l-6.371-6.391C34.1 325.1 16 283.8 16 240c0-105.9 107.7-192 240-192s240 86.13 240 192S388.3 432 256 432zM261.7 146.3C260.2 144.8 258.1 144 256 144S251.8 144.9 250.3 146.4C219.8 177.5 170.1 227.8 163.8 233.2C162.4 234.1 161.2 235.4 160.6 237.1c-1.625 4.094 .3906 8.75 4.5 10.38c.875 .3438 1.609 .6562 2.5 .6562c5.123 0 15.6-10.37 80.44-76.5V328c0 4.406 3.578 8 8 8s8-3.594 8-8V171.3l74.34 74.34c3.125 3.125 8.188 3.125 11.31 0s3.125-8.188 0-11.31L261.7 146.3z"],
    "comment-arrow-up-right": [512, 512, [], "e145", "M256 32C114.6 32 .0273 125.1 .0273 240c0 49.59 21.38 95.03 56.97 130.7C44.5 421.1 2.729 466 2.229 466.5c-2.188 2.297-2.781 5.734-1.5 8.734C2.041 478.2 4.813 480 8 480c66.31 0 116-31.78 140.6-51.39C181.3 440.9 217.6 448 256 448c141.4 0 255.1-93.09 255.1-208S397.4 32 256 32zM256 432c-35.12 0-69.36-6.184-101.8-18.38L145.7 410.4l-7.105 5.666c-20.2 16.11-60.14 42.04-112.7 47.06c14.44-18.29 37.42-51.68 46.57-88.59l2.172-8.758l-6.371-6.391C34.1 325.1 16 283.8 16 240c0-105.9 107.7-192 240-192s240 86.13 240 192S388.3 432 256 432zM333.7 146.3C332.2 144.9 330.2 144 328 144H185.8c-4.406 0-8 3.578-8 8S181.4 160 185.8 160h122.9L162.3 306.3c-3.125 3.125-3.125 8.188 0 11.31C163.9 319.2 165.9 320 168 320s4.094-.7813 5.656-2.344L320 171.3v122.9c0 4.422 3.594 8 8 8s8-3.578 8-8V152C336 149.1 335.2 147.9 333.7 146.3C333.7 146.3 333.7 146.3 333.7 146.3z"],
    "comment-captions": [512, 512, [], "e146", "M151.1 303.1h-48c-4.406 0-8 3.594-8 8s3.594 8 8 8h48c4.406 0 8-3.594 8-8S156.4 303.1 151.1 303.1zM223.1 247.1c0-4.406-3.608-7.999-8.014-7.999L71.1 239.1c-4.406 0-8 3.594-8 8s3.594 8 8 8h143.1C220.4 255.1 223.1 252.4 223.1 247.1zM311.1 303.1h-112c-4.406 0-7.1 3.594-7.1 8s3.594 8 7.1 8h112c4.406 0 8-3.594 8-8S316.4 303.1 311.1 303.1zM407.1 303.1h-48c-4.406 0-8 3.594-8 8s3.594 8 8 8h48c4.406 0 8-3.594 8-8S412.4 303.1 407.1 303.1zM439.1 239.1h-176c-4.406 0-8 3.594-8 8s3.594 8 8 8h176c4.406 0 8-3.594 8-8S444.4 239.1 439.1 239.1zM256 31.1c-141.4 0-255.1 93.09-255.1 208c0 49.59 21.38 95.03 56.97 130.7c-12.5 50.39-54.27 95.27-54.77 95.77c-2.188 2.297-2.781 5.734-1.5 8.734c1.312 3 4.083 4.766 7.271 4.766c66.31 0 116-31.78 140.6-51.39c32.72 12.31 68.99 19.39 107.4 19.39c141.4 0 255.1-93.09 255.1-207.1S397.4 31.1 256 31.1zM255.1 431.1c-35.12 0-69.36-6.184-101.8-18.38l-8.508-3.201l-7.105 5.666c-20.2 16.11-60.14 42.04-112.7 47.06c14.44-18.29 37.42-51.68 46.57-88.59l2.172-8.758l-6.371-6.391C34.1 325.1 15.1 283.8 15.1 239.1c0-105.9 107.7-192 240-192s240 86.13 240 192S388.3 431.1 255.1 431.1z"],
    "comment-check": [512, 512, [], "f4ac", "M256 31.1c-141.4 0-255.1 93.09-255.1 208c0 49.59 21.38 95.03 56.97 130.7c-12.5 50.39-54.27 95.27-54.77 95.77c-2.188 2.297-2.781 5.734-1.5 8.734c1.312 3 4.083 4.766 7.271 4.766c66.31 0 116-31.78 140.6-51.39c32.72 12.31 68.99 19.39 107.4 19.39c141.4 0 255.1-93.09 255.1-207.1S397.4 31.1 256 31.1zM255.1 431.1c-35.12 0-69.36-6.184-101.8-18.38l-8.508-3.201l-7.105 5.666c-20.2 16.11-60.14 42.04-112.7 47.06c14.44-18.29 37.42-51.68 46.57-88.59l2.172-8.758l-6.371-6.391C34.1 325.1 15.1 283.8 15.1 239.1c0-105.9 107.7-192 240-192s240 86.13 240 192S388.3 431.1 255.1 431.1zM346.3 170.3L231.1 284.7L173.7 226.3c-3.125-3.125-8.188-3.125-11.31 0s-3.125 8.188 0 11.31L226.3 301.7c1.562 1.562 3.594 2.344 5.656 2.344s4.094-.7813 5.656-2.344l120-119.1c3.125-3.125 3.125-8.188 0-11.31S349.5 167.2 346.3 170.3z"],
    "comment-code": [512, 512, [], "e147", "M256 32C114.6 32 .0273 125.1 .0273 240c0 49.59 21.38 95.03 56.97 130.7C44.5 421.1 2.729 466 2.229 466.5c-2.188 2.297-2.781 5.734-1.5 8.734C2.041 478.2 4.813 480 8 480c66.31 0 116-31.78 140.6-51.39C181.3 440.9 217.6 448 256 448c141.4 0 255.1-93.09 255.1-208S397.4 32 256 32zM256 432c-35.12 0-69.36-6.184-101.8-18.38L145.7 410.4l-7.105 5.666c-20.2 16.11-60.14 42.04-112.7 47.06c14.44-18.29 37.42-51.68 46.57-88.59l2.172-8.758l-6.371-6.391C34.1 325.1 16 283.8 16 240c0-105.9 107.7-192 240-192s240 86.13 240 192S388.3 432 256 432zM310.5 154.3c-3.125-3.125-8.188-3.125-11.31 0s-3.125 8.188 0 11.31L373.6 240l-74.34 74.34c-3.125 3.125-3.125 8.188 0 11.31C300.8 327.2 302.8 328 304.9 328s4.094-.7813 5.656-2.344l80-80c3.125-3.125 3.125-8.188 0-11.31L310.5 154.3zM212.8 154.3c-3.125-3.125-8.188-3.125-11.31 0l-80 80c-3.125 3.125-3.125 8.188 0 11.31l80 80C203 327.2 205.1 328 207.1 328s4.094-.7813 5.656-2.344c3.125-3.125 3.125-8.188 0-11.31L138.4 240l74.34-74.34C215.9 162.5 215.9 157.5 212.8 154.3z"],
    "comment-dollar": [512, 512, [], "f651", "M256 31.1c-141.4 0-255.1 93.09-255.1 208c0 49.59 21.37 94.1 56.97 130.7c-12.5 50.39-54.31 95.3-54.81 95.8C0 468.8-.5938 472.2 .6875 475.2C1.998 478.2 4.813 479.1 8 479.1c66.31 0 116-31.8 140.6-51.41c32.72 12.31 69.02 19.41 107.4 19.41c141.4 0 255.1-93.09 255.1-207.1S397.4 31.1 256 31.1zM256 431.1c-35.12 0-69.36-6.184-101.8-18.38L145.7 410.4l-7.105 5.666c-20.2 16.11-60.14 42.04-112.7 47.06c14.44-18.29 37.42-51.68 46.57-88.59l2.172-8.758l-6.371-6.391C34.1 325.1 16 283.8 16 239.1c0-105.9 107.7-192 240-192s240 86.13 240 192S388.3 431.1 256 431.1zM258 232.2l-7.297-2C219.2 221.4 204.8 213.5 208.6 192.8c4-21.89 33.28-27.55 60.5-23.55c7.078 1.062 15.47 3.234 26.41 6.828c4.156 1.359 8.703-.8906 10.09-5.094c1.391-4.188-.8906-8.719-5.094-10.09c-11.81-3.891-21.05-6.266-29.05-7.453c-2.561-.3828-4.934-.4551-7.406-.6895V136c0-4.422-3.616-8-8.037-8S248 131.6 248 136v16.27c-30.09 1.211-51.03 14.77-55.2 37.67c-7.047 38.72 30.89 49.36 53.56 55.7l7.406 2.031c36.78 10.02 53.66 17.17 49.59 39.52c-3.984 21.91-33.25 27.59-60.55 23.53c-10.92-1.562-23.5-5.875-34.59-9.688L202.5 299.1C198.4 297.7 193.8 299.9 192.4 304.1C191 308.3 193.3 312.8 197.5 314.3l5.625 1.922c11.77 4.031 25.09 8.609 37.47 10.38c2.619 .3906 4.973 .3457 7.5 .582V344c0 4.422 3.541 8 7.963 8s8.037-3.578 8.037-8v-16.46c29.97-1.281 50.95-14.62 55.11-37.49C326.3 250.8 288.4 240.5 258 232.2z"],
    "comment-dots": [512, 512, [62075, 128172, "commenting"], "f4ad", "M256 31.1c-141.4 0-255.1 93.09-255.1 208c0 49.59 21.38 95.03 56.97 130.7c-12.5 50.39-54.27 95.27-54.77 95.77c-2.188 2.297-2.781 5.734-1.5 8.734c1.312 3 4.083 4.766 7.271 4.766c66.31 0 116-31.78 140.6-51.39c32.72 12.31 68.99 19.39 107.4 19.39c141.4 0 255.1-93.09 255.1-207.1S397.4 31.1 256 31.1zM255.1 431.1c-35.12 0-69.36-6.184-101.8-18.38l-8.508-3.201l-7.105 5.666c-20.2 16.11-60.14 42.04-112.7 47.06c14.44-18.29 37.42-51.68 46.57-88.59l2.172-8.758l-6.371-6.391C34.1 325.1 15.1 283.8 15.1 239.1c0-105.9 107.7-192 240-192s240 86.13 240 192S388.3 431.1 255.1 431.1zM256 207.1c-17.67 0-31.1 14.33-31.1 32s14.33 31.1 31.1 31.1s31.1-14.33 31.1-31.1S273.7 207.1 256 207.1zM255.1 255.1c-8.824 0-16-7.178-16-16s7.176-16 16-16s16 7.178 16 16S264.8 255.1 255.1 255.1zM383.1 207.1c-17.67 0-32 14.33-32 32s14.33 31.1 32 31.1s32-14.33 32-31.1S401.7 207.1 383.1 207.1zM383.1 255.1c-8.824 0-16-7.178-16-16s7.176-16 16-16s16.01 7.178 16.01 16S392.8 255.1 383.1 255.1zM127.1 207.1c-17.67 0-32 14.33-32 32s14.33 31.1 32 31.1s32-14.33 32-31.1S145.7 207.1 127.1 207.1zM127.1 255.1c-8.824 0-15.97-7.177-15.97-15.1s7.149-16 15.97-16s16 7.178 16 16S136.8 255.1 127.1 255.1z"],
    "comment-exclamation": [512, 512, [], "f4af", "M256 31.1c-141.4 0-255.1 93.09-255.1 208c0 49.59 21.38 94.1 56.97 130.7c-12.5 50.39-54.31 95.3-54.81 95.8c-2.187 2.297-2.781 5.703-1.5 8.703c1.312 3 4.125 4.797 7.312 4.797c66.31 0 116-31.8 140.6-51.41c32.72 12.31 69.01 19.41 107.4 19.41c141.4 0 255.1-93.09 255.1-207.1S397.4 31.1 256 31.1zM255.1 431.1c-35.12 0-69.36-6.184-101.8-18.38l-8.508-3.201l-7.105 5.666c-20.2 16.11-60.14 42.04-112.7 47.06c14.44-18.29 37.42-51.68 46.57-88.59l2.172-8.758l-6.371-6.391C34.1 325.1 15.1 283.8 15.1 239.1c0-105.9 107.7-192 240-192s240 86.13 240 192S388.3 431.1 255.1 431.1zM255.1 287.1c4.406 0 7.968-3.594 7.968-8.001V135.1c0-4.406-3.594-8-8-8s-8 3.594-8 8v143.1C247.9 284.4 251.6 287.1 255.1 287.1zM255.1 319.1c-8.822 0-16 7.18-16 16s7.178 16 16 16s16-7.18 16-16S264.8 319.1 255.1 319.1z"],
    "comment-image": [512, 512, [], "e148", "M256 32C114.6 32 .0273 125.1 .0273 240c0 49.59 21.38 95.03 56.97 130.7c-12.5 50.39-54.27 95.27-54.77 95.77c-2.188 2.297-2.781 5.734-1.5 8.734C2.041 478.2 4.813 480 8 480c66.31 0 116-31.78 140.6-51.39C181.3 440.9 217.6 448 256 448C397.4 448 512 354.9 512 240S397.4 32 256 32zM256 432c-35.12 0-69.36-6.184-101.8-18.38L145.7 410.4l-7.105 5.666c-20.2 16.11-60.14 42.04-112.7 47.06c14.44-18.29 37.42-51.68 46.57-88.59l2.172-8.758l-6.371-6.391C34.1 325.1 16 283.8 16 240c0-105.9 107.7-192 240-192s240 86.13 240 192S388.3 432 256 432zM160 200c22.06 0 40-17.94 40-40S182.1 120 160 120S120 137.9 120 160S137.9 200 160 200zM160 136c13.22 0 24 10.77 24 24S173.2 184 160 184S136 173.2 136 160S146.8 136 160 136zM312.6 153.7c-9.094-12.16-29.47-12.16-38.56 .0313L202.2 250.7L186.1 232.2c-9.125-10.44-27-10.41-36.13-.0313l-55.97 64c-6.219 7.031-7.719 17.16-3.812 25.75C94.06 330.5 102.6 336 112 336h288c9.125 0 17.31-5.062 21.41-13.19c4.125-8.156 3.312-17.78-2.125-25.09L312.6 153.7zM407.2 315.6c-1.344 2.719-4.125 4.438-7.156 4.438h-288c-3.125 0-5.969-1.844-7.281-4.688C103.4 312.5 103.9 309.1 105.1 306.8l56-64.03C163.5 241 165.7 240 168 240s4.5 1 5.999 2.75l29.28 33.41l83.59-112.9c3.094-4.062 9.844-4.094 12.88-.0313l106.7 144C408.3 309.7 408.5 312.9 407.2 315.6z"],
    "comment-lines": [512, 512, [], "f4b0", "M256 31.1c-141.4 0-255.1 93.09-255.1 208c0 49.59 21.38 95.03 56.97 130.7c-12.5 50.39-54.27 95.27-54.77 95.77c-2.188 2.297-2.781 5.734-1.5 8.734c1.312 3 4.083 4.766 7.271 4.766c66.31 0 116-31.78 140.6-51.39c32.72 12.31 68.99 19.39 107.4 19.39c141.4 0 255.1-93.09 255.1-207.1S397.4 31.1 256 31.1zM255.1 431.1c-35.12 0-69.36-6.184-101.8-18.38l-8.508-3.201l-7.105 5.666c-20.2 16.11-60.14 42.04-112.7 47.06c14.44-18.29 37.42-51.68 46.57-88.59l2.172-8.758l-6.371-6.391C34.1 325.1 15.1 283.8 15.1 239.1c0-105.9 107.7-192 240-192s240 86.13 240 192S388.3 431.1 255.1 431.1zM375.1 183.1H135.1c-4.422 0-7.1 3.579-7.1 8.001s3.578 7.999 7.1 7.999h239.1c4.422 0 8-3.578 8-7.999S380.4 183.1 375.1 183.1zM279.1 279.1H135.1c-4.422 0-7.1 3.579-7.1 8.001s3.578 7.999 7.1 7.999h143.1c4.422 0 8-3.578 8-7.999S284.4 279.1 279.1 279.1z"],
    "comment-medical": [512, 512, [], "f7f5", "M256 31.1c-141.4 0-255.1 93.09-255.1 208c0 49.59 21.38 94.1 56.97 130.7c-12.5 50.39-54.31 95.3-54.81 95.8C0 468.8-.5938 472.2 .6875 475.2c1.312 3 4.125 4.797 7.312 4.797c66.31 0 116-31.8 140.6-51.41c32.72 12.31 69.01 19.41 107.4 19.41C397.4 447.1 512 354.9 512 239.1S397.4 31.1 256 31.1zM256 431.1c-35.12 0-69.36-6.184-101.8-18.38L145.7 410.4l-7.105 5.666c-20.2 16.11-60.14 42.04-112.7 47.06c14.44-18.29 37.42-51.68 46.57-88.59l2.172-8.758l-6.371-6.391C34.1 325.1 16 283.8 16 239.1c0-105.9 107.7-192 240-192s240 86.13 240 192S388.3 431.1 256 431.1zM344 191.1h-48v-48c0-8.836-7.164-16-16-16h-48c-8.836 0-16 7.164-16 16v48h-48c-8.836 0-16 7.164-16 16v48c0 8.836 7.164 15.1 16 15.1h48v48c0 8.836 7.164 16 16 16h48c8.836 0 16-7.164 16-16v-48h48c8.836 0 16-7.164 16-15.1v-48C360 199.2 352.8 191.1 344 191.1zM344 255.1h-64v63.1h-48V255.1h-64v-48h64v-64h48v64h64V255.1z"],
    "comment-middle": [512, 512, [], "e149", "M256 0C114.6 0 0 93.09 0 208c0 95.99 80.08 176.5 188.8 200.5l48.89 93.39C241.2 508.6 248.6 512 256 512s14.76-3.361 18.28-10.08l48.89-93.39C431.9 384.5 512 303.1 512 208C512 93.09 397.4 0 256 0zM312.4 394.5l-52.34 99.99C259.7 495.2 258.1 496 256 496s-3.713-.7637-4.1-1.504l-52.34-99.99C22.6 355.4 16 226.3 16 208c0-105.9 107.7-192 240-192s240 86.13 240 192C496 226.3 489.4 355.4 312.4 394.5z"],
    "comment-middle-top": [512, 512, [], "e14a", "M323.2 103.5l-48.89-93.39C270.8 3.361 263.4 0 256 0S241.2 3.361 237.7 10.08l-48.89 93.39C80.08 127.5 0 208 0 304c0 114.9 114.6 208 256 208s256-93.09 256-208C512 208 431.9 127.5 323.2 103.5zM256 496c-132.3 0-240-86.13-240-192c0-18.27 6.604-147.4 183.6-186.5l52.34-99.99C252.3 16.76 253.9 16 256 16s3.713 .7637 4.1 1.504l52.34 99.99C489.4 156.6 496 285.7 496 304C496 409.9 388.3 496 256 496z"],
    "comment-minus": [512, 512, [], "f4b1", "M256 32C114.6 32 .0281 125.1 .0281 240c0 49.59 21.38 95.03 56.97 130.7C44.5 421.1 2.729 466 2.229 466.5c-2.188 2.297-2.781 5.734-1.5 8.734C2.041 478.2 4.813 480 8 480c66.31 0 116-31.78 140.6-51.39C181.3 440.9 217.6 448 256 448c141.4 0 255.1-93.09 255.1-208S397.4 32 256 32zM256 432c-35.12 0-69.36-6.184-101.8-18.38L145.7 410.4l-7.105 5.666c-20.2 16.11-60.14 42.04-112.7 47.06c14.44-18.29 37.42-51.68 46.57-88.59l2.172-8.758l-6.371-6.391C34.1 325.1 16 283.8 16 240c0-105.9 107.7-192 240-192s240 86.13 240 192S388.3 432 256 432zM344 232h-176C163.6 232 160 235.6 160 240c0 4.422 3.578 8 8 8h176C348.4 248 352 244.4 352 240S348.4 232 344 232z"],
    "comment-music": [512, 512, [], "f8b0", "M256 31.1c-141.4 0-255.1 93.09-255.1 208c0 49.59 21.37 94.1 56.96 130.7c-12.5 50.39-54.31 95.3-54.81 95.8c-2.187 2.297-2.781 5.703-1.5 8.703c1.312 3 4.125 4.797 7.312 4.797c66.31 0 116-31.8 140.6-51.41c32.72 12.31 69.01 19.41 107.4 19.41c141.4 0 255.1-93.09 255.1-207.1S397.4 31.1 256 31.1zM255.1 431.1c-35.12 0-69.36-6.184-101.8-18.38l-8.508-3.201l-7.105 5.666c-20.2 16.11-60.14 42.04-112.7 47.06c14.44-18.29 37.42-51.68 46.57-88.59l2.172-8.758l-6.371-6.391C34.1 325.1 15.1 283.8 15.1 239.1c0-105.9 107.7-192 240-192s240 86.13 240 192S388.3 431.1 255.1 431.1zM340.8 128.6l-128 56C209.9 185.9 207.1 188.8 207.1 191.1v104.3C199.5 291.2 188.3 287.1 175.1 287.1c-26.51 0-48 14.33-48 32s21.49 32 48 32s47.1-14.33 47.1-32L223.1 197.2l112-49v116.1c-8.506-5.109-19.65-8.321-31.1-8.321c-26.51 0-48 14.33-48 32s21.49 32 48 32s48-14.33 48-32l-.0004-151.1c0-2.688-1.359-5.219-3.625-6.688C346.2 127.8 343.2 127.6 340.8 128.6zM175.1 335.1c-19.53 0-32-9.477-32-16s12.47-16 32-16c19.54 0 31.1 9.477 31.1 16S195.5 335.1 175.1 335.1zM303.1 303.1c-19.53 0-32-9.477-32-16s12.47-16 32-16c19.54 0 32 9.477 32 16S323.5 303.1 303.1 303.1z"],
    "comment-pen": [512, 512, ["comment-edit"], "f4ae", "M256 31.1c-141.4 0-255.1 93.09-255.1 208c0 49.59 21.38 94.1 56.97 130.7c-12.5 50.39-54.31 95.3-54.81 95.8c-2.187 2.297-2.781 5.703-1.5 8.703c1.312 3 4.125 4.797 7.312 4.797c66.31 0 116-31.8 140.6-51.41c32.72 12.31 69.01 19.41 107.4 19.41c141.4 0 255.1-93.09 255.1-207.1S397.4 31.1 256 31.1zM255.1 431.1c-35.12 0-69.36-6.184-101.8-18.38l-8.508-3.201l-7.105 5.666c-20.2 16.11-60.14 42.04-112.7 47.06c14.44-18.29 37.42-51.68 46.57-88.59l2.172-8.758l-6.371-6.391C34.1 325.1 15.1 283.8 15.1 239.1c0-105.9 107.7-192 240-192s240 86.13 240 192S388.3 431.1 255.1 431.1zM345.6 139.7c-6.25-6.248-14.44-9.373-22.63-9.373c-8.188 0-16.38 3.123-22.62 9.371L159.9 280.1L157.9 283.7l-11.52 57.63c-.9453 4.734 2.805 8.367 6.898 8.367c.4453 0 .8945-.043 1.344-.1328l57.62-11.52l3.582-1.916l140.5-140.5c12.5-12.5 12.5-32.76 .0039-45.25L345.6 139.7zM206.5 322.9l-41.71 8.342L173.1 289.5l102.8-102.8l33.38 33.38L206.5 322.9zM345 184.4l-24.41 24.41l-33.38-33.38l24.41-24.41c3.023-3.021 7.039-4.684 11.31-4.684s8.297 1.664 11.32 4.686l10.75 10.75C348.1 164.7 349.7 168.8 349.7 173S348.1 181.3 345 184.4z"],
    "comment-plus": [512, 512, [], "f4b2", "M256 32C114.6 32 .0281 125.1 .0281 240c0 49.59 21.38 95.03 56.97 130.7C44.5 421.1 2.729 466 2.229 466.5c-2.188 2.297-2.781 5.734-1.5 8.734C2.042 478.2 4.813 480 8 480c66.31 0 116-31.78 140.6-51.39C181.3 440.9 217.6 448 256 448c141.4 0 255.1-93.09 255.1-208S397.4 32 256 32zM256 432c-35.12 0-69.36-6.184-101.8-18.38L145.7 410.4l-7.105 5.666c-20.2 16.11-60.14 42.04-112.7 47.06c14.44-18.29 37.42-51.68 46.57-88.59l2.172-8.758l-6.371-6.391C34.1 325.1 16 283.8 16 240c0-105.9 107.7-192 240-192s240 86.13 240 192S388.3 432 256 432zM344 232h-80v-80c0-4.42-3.578-8-8-8S248 147.6 248 152v80h-80C163.6 232 160 235.6 160 240c0 4.422 3.578 8 8 8h80v80c0 4.422 3.578 8 8 8s8-3.58 8-8v-80h80C348.4 248 352 244.4 352 240S348.4 232 344 232z"],
    "comment-question": [512, 512, [], "e14b", "M283.7 127.6H223.1C192.7 127.6 168 152.3 168 182.6c0 4.422 3.594 8 8 8s8-3.578 8-8c0-21.53 17.53-39.05 39.06-39.05h60.59c24.44 0 44.34 19.89 44.34 44.34c0 16.89-9.406 32.09-24.62 39.73l-51.06 26.5C249.7 255.5 248 258.3 248 261.2V288c0 4.422 3.594 8 8 8S264 292.4 264 288V266.1l46.66-24.2C331.2 231.6 344 210.9 344 187.9C344 154.6 316.9 127.6 283.7 127.6zM256 328c-8.836 0-16 7.162-16 16c0 8.836 7.164 16 16 16s16-7.164 16-16C272 335.2 264.8 328 256 328zM256 31.1c-141.4 0-255.1 93.09-255.1 208c0 49.59 21.38 95.03 56.97 130.7c-12.5 50.39-54.27 95.27-54.77 95.77c-2.188 2.297-2.781 5.734-1.5 8.734c1.312 3 4.083 4.766 7.271 4.766c66.31 0 116-31.78 140.6-51.39c32.72 12.31 68.99 19.39 107.4 19.39c141.4 0 255.1-93.09 255.1-208S397.4 31.1 256 31.1zM256 431.1c-35.12 0-69.36-6.184-101.8-18.38L145.7 410.4l-7.105 5.666c-20.2 16.11-60.14 42.04-112.7 47.06c14.44-18.29 37.42-51.68 46.57-88.59l2.172-8.758l-6.371-6.391C34.1 325.1 16 283.8 16 239.1c0-105.9 107.7-192 240-192s240 86.13 240 192S388.3 431.1 256 431.1z"],
    "comment-quote": [512, 512, [], "e14c", "M183.1 143.1c-30.88 0-56 25.12-56 56s25.12 56 56 56c15.68 0 29.82-6.517 39.1-16.93v24.93c0 30.88-25.12 56-55.1 56h-8c-4.422 0-8 3.594-8 8s3.578 8.001 8 8.001l8 .0003c39.7 0 71.1-32.31 71.1-72l0-63.1C239.1 169.1 214.9 143.1 183.1 143.1zM183.1 239.1c-22.06 0-40-17.94-40-40s17.94-40 40-40s39.1 17.94 39.1 40S206.1 239.1 183.1 239.1zM327.1 143.1c-30.88 0-56 25.12-56 56s25.12 56 56 56c15.68 0 29.82-6.517 39.1-16.93v24.93c0 30.88-25.12 56-56 56h-8c-4.422 0-8 3.594-8 8s3.578 8.001 8 8.001l8 .0003c39.7 0 72-32.31 72-72l0-63.1C383.1 169.1 358.9 143.1 327.1 143.1zM327.1 239.1c-22.06 0-40-17.94-40-40s17.94-40 40-40s40 17.94 40 40S350.1 239.1 327.1 239.1zM256 31.1c-141.4 0-255.1 93.09-255.1 208c0 49.59 21.38 95.03 56.97 130.7c-12.5 50.39-54.27 95.27-54.77 95.77c-2.188 2.297-2.781 5.734-1.5 8.734c1.312 3 4.083 4.766 7.271 4.766c66.31 0 116-31.78 140.6-51.39c32.72 12.31 68.99 19.39 107.4 19.39c141.4 0 255.1-93.09 255.1-207.1S397.4 31.1 256 31.1zM256 431.1c-35.12 0-69.36-6.184-101.8-18.38l-8.508-3.199l-7.105 5.668c-20.2 16.1-60.14 42.03-112.7 47.05c14.44-18.29 37.42-51.68 46.57-88.59l2.172-8.758l-6.371-6.391C34.1 325.1 16 283.8 16 239.1c0-105.9 107.7-192 240-192s240 86.13 240 192S388.3 431.1 256 431.1z"],
    "comment-slash": [640, 512, [], "f4b3", "M319.1 47.1c132.3 0 240 86.13 240 192c0 33.15-10.56 64.35-29.12 91.59l12.47 9.916C564.1 311.5 576 276.9 576 240c0-114.9-114.6-207.1-255.1-207.1c-47.4 0-91.65 10.64-129.7 28.88L204.2 71.93C238.6 56.72 278 47.1 319.1 47.1zM319.1 431.1c-35.12 0-69.36-6.184-101.8-18.38l-8.508-3.201l-7.105 5.666c-20.2 16.11-60.14 42.04-112.7 47.06c14.44-18.29 37.42-51.68 46.57-88.59l2.172-8.758l-6.371-6.391C98.1 325.1 79.1 283.8 79.1 239.1c0-24.58 6.02-48.02 16.59-69.64l-12.95-10.29c-12.62 24.61-19.62 51.6-19.62 79.93c0 49.59 21.38 94.1 56.97 130.7c-12.5 50.39-54.31 95.3-54.81 95.8c-2.187 2.297-2.781 5.703-1.5 8.703c1.312 3 4.125 4.797 7.312 4.797c66.31 0 116-31.8 140.6-51.41c32.72 12.31 69.02 19.41 107.4 19.41c36.85 0 71.78-6.445 103.4-17.83l-14.94-11.87C381.1 427 351.3 431.1 319.1 431.1zM636.1 497.7L12.99 1.729C11.52 .5652 9.77-.0012 8.024-.0012c-2.352 0-4.689 1.029-6.287 3.012c-2.75 3.469-2.172 8.5 1.281 11.25l623.1 496c1.484 1.172 3.234 1.734 4.984 1.734c2.344 0 4.687-1.031 6.266-3.016C641 505.5 640.4 500.5 636.1 497.7z"],
    "comment-smile": [512, 512, [], "f4b4", "M256 31.1c-141.4 0-255.1 93.09-255.1 208c0 49.59 21.38 95.03 56.97 130.7c-12.5 50.39-54.27 95.27-54.77 95.77c-2.188 2.297-2.781 5.734-1.5 8.734c1.312 3 4.083 4.766 7.271 4.766c66.31 0 116-31.78 140.6-51.39c32.72 12.31 68.99 19.39 107.4 19.39c141.4 0 255.1-93.09 255.1-207.1S397.4 31.1 256 31.1zM255.1 431.1c-35.12 0-69.36-6.184-101.8-18.38l-8.508-3.201l-7.105 5.666c-20.2 16.11-60.14 42.04-112.7 47.06c14.44-18.29 37.42-51.68 46.57-88.59l2.172-8.758l-6.371-6.391C34.1 325.1 15.1 283.8 15.1 239.1c0-105.9 107.7-192 240-192s240 86.13 240 192S388.3 431.1 255.1 431.1zM191.1 207.1c8.822 0 16.01-7.181 16.01-16s-7.178-16-15.1-16c-8.822 0-16 7.18-16 16S183.2 207.1 191.1 207.1zM319.1 207.1c8.822 0 16.03-7.181 16.03-16s-7.178-16-16-16s-16 7.18-16 16S311.1 207.1 319.1 207.1zM345.1 284c-18.34 32.05-52.47 51.97-89.06 51.97S185.3 316.1 166.9 284c-2.203-3.859-7.109-5.156-10.91-2.969C152.2 283.2 150.9 288.1 153.1 291.1c21.17 37.03 60.61 60.03 102.9 60.03s81.78-23 102.1-60.03c2.203-3.828 .875-8.719-2.969-10.91S347.2 280.2 345.1 284z"],
    "comment-sms": [512, 512, ["sms"], "f7cd", "M256 32C114.6 32 .0137 125.1 .0137 240c0 49.59 21.39 95 56.99 130.7c-12.5 50.39-54.31 95.3-54.81 95.8C0 468.8-.5938 472.2 .6875 475.2C1.1 478.2 4.813 480 8 480c66.31 0 116-31.8 140.6-51.41C181.3 440.9 217.6 448 256 448C397.4 448 512 354.9 512 240S397.4 32 256 32zM256 432c-35.12 0-69.36-6.184-101.8-18.38L145.7 410.4l-7.105 5.666c-20.2 16.11-60.14 42.04-112.7 47.06c14.44-18.29 37.42-51.68 46.57-88.59l2.172-8.758l-6.371-6.391C34.1 325.1 16 283.8 16 240c0-105.9 107.7-192 240-192s240 86.13 240 192S388.3 432 256 432zM138.2 232.3L133.1 231.1C115.6 225.7 110.7 221.4 112.3 212.2c1.875-10.94 16.62-13.56 30.66-11.47c3.781 .5938 8.375 1.844 14.44 3.938c4.219 1.5 8.75-.75 10.19-4.938S166.8 190.1 162.6 189.5c-7.031-2.406-12.5-3.875-17.22-4.625C119.4 180.9 99.75 190.7 96.53 209.5c-4.469 26 19.88 33.13 32.97 36.97l4.312 1.219c21.34 6.125 27.72 9.688 25.91 20.12c-1.906 10.97-16.78 13.59-30.66 11.5c-6-.9062-13.12-3.5-19.44-5.75L106.7 272.5c-4.312-1.5-8.781 .6875-10.22 4.844c-1.5 4.156 .6875 8.75 4.844 10.22l2.906 1.031c6.969 2.531 14.88 5.375 22.38 6.531C130.5 295.7 134.3 296 137.8 296c20.28 0 34.88-9.531 37.63-25.47C180 244.3 155.8 237.3 138.2 232.3zM378.2 232.3l-4.188-1.219c-18.44-5.375-23.31-9.625-21.72-18.88c1.906-10.94 16.69-13.56 30.66-11.47c3.781 .5938 8.375 1.844 14.44 3.938c4.188 1.5 8.75-.75 10.19-4.938s-.7813-8.75-4.938-10.19c-7.031-2.406-12.5-3.875-17.22-4.625c-26-3.969-45.66 5.812-48.88 24.56c-4.469 26 19.88 33.13 32.97 36.97l4.312 1.219c21.34 6.125 27.72 9.688 25.91 20.12c-1.906 10.97-16.78 13.59-30.66 11.5c-6-.9062-13.12-3.5-19.44-5.75l-2.938-1.062c-4.281-1.5-8.75 .6875-10.22 4.844c-1.5 4.156 .6875 8.75 4.844 10.22l2.918 1.133c6.969 2.531 14.86 5.273 22.36 6.43C370.5 295.7 374.3 296 377.8 296c20.28 0 34.88-9.531 37.63-25.47C420 244.3 395.8 237.3 378.2 232.3zM306.5 184.4c-3.281-1.094-6.875 .0625-8.938 2.781L256 242.7L214.4 187.2C212.3 184.5 208.8 183.3 205.5 184.4C202.2 185.5 200 188.6 200 192v96c0 4.406 3.594 8 8 8S216 292.4 216 288V216l33.59 44.81c3.062 4 9.75 4 12.81 0L296 216V288c0 4.406 3.594 8 8 8S312 292.4 312 288V192C312 188.6 309.8 185.5 306.5 184.4z"],
    "comment-text": [512, 512, [], "e14d", "M344 175.1h-176c-4.406 0-8 3.595-8 8.001s3.594 7.999 8 7.999h79.1v135.1c0 4.406 3.594 8.001 8 8.001s7.1-3.595 7.1-8.001V191.1H344c4.406 0 8-3.593 8-7.999S348.4 175.1 344 175.1zM256 31.1c-141.4 0-255.1 93.09-255.1 208c0 49.59 21.38 95.03 56.97 130.7c-12.5 50.39-54.27 95.27-54.77 95.77c-2.188 2.297-2.781 5.734-1.5 8.734c1.312 3 4.083 4.766 7.271 4.766c66.31 0 116-31.78 140.6-51.39c32.72 12.31 68.1 19.39 107.4 19.39c141.4 0 255.1-93.09 255.1-207.1S397.4 31.1 256 31.1zM255.1 431.1c-35.12 0-69.36-6.184-101.8-18.38l-8.508-3.199l-7.105 5.668c-20.2 16.1-60.14 42.03-112.7 47.05c14.44-18.29 37.42-51.68 46.57-88.59l2.172-8.758l-6.371-6.391C34.1 325.1 15.1 283.8 15.1 239.1c0-105.9 107.7-192 240-192s240 86.13 240 192S388.3 431.1 255.1 431.1z"],
    "comment-xmark": [512, 512, ["comment-times"], "f4b5", "M256 31.1c-141.4 0-255.1 93.09-255.1 208c0 49.59 21.38 95.03 56.97 130.7c-12.5 50.39-54.27 95.27-54.77 95.77c-2.188 2.297-2.781 5.734-1.5 8.734C2.04 478.2 4.813 479.1 8 479.1c66.31 0 116-31.78 140.6-51.39c32.72 12.31 68.99 19.39 107.4 19.39c141.4 0 255.1-93.09 255.1-208S397.4 31.1 256 31.1zM256 431.1c-35.12 0-69.36-6.184-101.8-18.38L145.7 410.4l-7.105 5.666c-20.2 16.11-60.14 42.04-112.7 47.06c14.44-18.29 37.42-51.68 46.57-88.59l2.172-8.758l-6.371-6.391C34.1 325.1 16 283.8 16 239.1c0-105.9 107.7-192 240-192s240 86.13 240 192S388.3 431.1 256 431.1zM333.7 162.3c-3.125-3.125-8.188-3.125-11.31 0L256 228.7L189.7 162.3c-3.125-3.125-8.188-3.125-11.31 0s-3.125 8.188 0 11.31L244.7 239.1L178.3 306.3c-3.125 3.125-3.125 8.188 0 11.31c3.127 3.127 8.186 3.127 11.31 0L256 251.3l66.34 66.34c3.127 3.127 8.186 3.127 11.31 0c3.125-3.125 3.125-8.188 0-11.31L267.3 239.1l66.34-66.34C336.8 170.5 336.8 165.5 333.7 162.3z"],
    "comments": [640, 512, [61670, 128490], "f086", "M416 176C416 78.8 322.9 0 208 0S0 78.8 0 176c0 39.57 15.62 75.96 41.67 105.4c-16.39 32.76-39.23 57.32-39.59 57.68c-2.1 2.205-2.67 5.475-1.441 8.354C1.9 350.3 4.602 352 7.66 352c38.35 0 70.76-11.12 95.74-24.04C134.2 343.1 169.8 352 208 352C322.9 352 416 273.2 416 176zM208 336c-34.14 0-67.86-7.742-97.51-22.39L103.2 310L96.05 313.7c-22.64 11.71-46.03 18.84-69.75 21.29c8.633-11.07 20.12-27.4 29.69-46.52l4.838-9.674L53.65 270.7C29.02 242.1 16 210.2 16 176c0-88.22 86.13-160 192-160s192 71.78 192 160S313.9 336 208 336zM599.6 443.7C624.8 413.9 640 376.6 640 336c0-89.54-72.1-163.3-167.4-174.4c-4.912-.5762-9.135 3.488-8.83 8.424c.2363 3.832 3.18 6.947 6.994 7.398C557.1 187.6 624 254.8 624 336c0 35.44-12.66 69.12-36.62 97.39l-6.918 8.168l4.91 9.512c9.25 17.92 20.15 33.37 28.38 43.96c-22.29-2.318-44.37-8.807-65.85-19.38l-7.174-3.529l-7.131 3.621C507.5 488.1 477.9 496 448 496c-73.58 0-136.6-41.33-162.8-99.74c-1.537-3.42-5.25-5.295-8.908-4.471l-.3594 .082c-4.859 1.096-7.426 6.369-5.389 10.91C299.2 466.8 367.8 512 448 512c33.69 0 65.32-8.008 92.85-21.98C565.2 502 596.1 512 632.3 512c3.059 0 5.76-1.725 7.02-4.605c1.229-2.879 .6582-6.148-1.441-8.354C637.6 498.7 615.9 475.3 599.6 443.7z"],
    "comments-dollar": [640, 512, [], "f653", "M210.2 168.3l-6.277-1.812C177.4 158.7 165.4 151.8 168.5 133.6c3.545-20.41 29.41-23.83 50.47-20.48C224.1 114.1 232.1 116 241.3 119.2c4.217 1.469 8.729-.7656 10.18-4.938c1.436-4.188-.7656-8.734-4.936-10.19C236.4 100.6 228.4 98.41 221.5 97.31C219.6 97.02 217.9 96.99 216 96.8V80c0-4.422-3.601-8-8.019-8c-4.42 0-7.972 3.578-7.972 8v16.37c-25.56 1.568-43.75 14.08-47.3 34.5C146.6 166.3 179.6 176 199.4 181.8l6.402 1.859C236.7 192.5 250.9 198.8 247.5 218.4C243.9 238.8 218 242.2 196.1 238.9C187.7 237.5 176.1 233.6 167.5 230.2L162.7 228.5C158.6 227 153.1 229.2 152.5 233.3C151 237.5 153.2 242.1 157.3 243.5l4.717 1.688c10.17 3.672 21.69 7.828 32.47 9.453c1.916 .2988 3.648 .248 5.512 .4414V272c0 4.422 3.552 8 7.972 8c4.418 0 8.019-3.578 8.019-8V255.3C241.4 253.7 259.7 241.5 263.2 221.1C269.4 185.2 236.6 175.8 210.2 168.3zM599.6 443.7C624.8 413.9 640 376.6 640 336c0-89.54-72.1-163.3-167.4-174.4c-4.912-.5762-9.135 3.488-8.83 8.424c.2363 3.832 3.18 6.947 6.994 7.398C557.1 187.6 624 254.8 624 336c0 35.44-12.66 69.12-36.62 97.39l-6.918 8.168l4.91 9.512c9.25 17.92 20.15 33.37 28.38 43.96c-22.29-2.318-44.37-8.807-65.85-19.38l-7.174-3.529l-7.131 3.621C507.5 488.1 477.9 496 448 496c-73.58 0-136.6-41.33-162.8-99.74c-1.537-3.42-5.25-5.295-8.908-4.471l-.3594 .082c-4.859 1.096-7.426 6.369-5.389 10.91C299.2 466.8 367.8 512 448 512c33.69 0 65.32-8.008 92.85-21.98C565.2 502 596.1 512 632.3 512c3.059 0 5.76-1.725 7.02-4.605c1.229-2.879 .6582-6.148-1.441-8.354C637.6 498.7 615.9 475.3 599.6 443.7zM416 176C416 78.8 322.9 0 208 0S0 78.8 0 176c0 39.57 15.62 75.96 41.67 105.4c-16.39 32.76-39.23 57.32-39.59 57.68c-2.1 2.205-2.67 5.475-1.441 8.354C1.9 350.3 4.602 352 7.66 352c38.35 0 70.76-11.12 95.74-24.04C134.2 343.1 169.8 352 208 352C322.9 352 416 273.2 416 176zM208 336c-34.14 0-67.86-7.742-97.51-22.39L103.2 310L96.05 313.7c-22.64 11.71-46.03 18.84-69.75 21.29c8.633-11.07 20.12-27.4 29.69-46.52l4.838-9.674L53.65 270.7C29.02 242.1 16 210.2 16 176c0-88.22 86.13-160 192-160s192 71.78 192 160S313.9 336 208 336z"],
    "comments-question": [640, 512, [], "e14e", "M208 244.6C201.7 244.6 196.6 249.7 196.6 256c0 6.299 5.107 11.41 11.41 11.41S219.4 262.3 219.4 256C219.4 249.7 214.3 244.6 208 244.6zM228.7 80H183.3C159.4 80 140 99.38 140 123.2c0 4.422 3.578 8 8 8s8-3.578 8-8C156 108.2 168.3 96 183.3 96h45.44C245.1 96 260 109.1 260 127.2c0 11.88-6.625 22.55-17.38 27.91L204.3 174.9C201.7 176.3 200 179 200 182V208c0 4.422 3.578 8 8 8S216 212.4 216 208V186.9l33.86-17.53C265.1 161.3 276 145.1 276 127.2C276 101.2 254.8 80 228.7 80zM416 176C416 78.8 322.9 0 208 0S0 78.8 0 176c0 39.57 15.62 75.96 41.67 105.4c-16.39 32.76-39.23 57.32-39.59 57.68c-2.1 2.205-2.67 5.475-1.441 8.354C1.9 350.3 4.602 352 7.66 352c38.35 0 70.76-11.12 95.74-24.04C134.2 343.1 169.8 352 208 352C322.9 352 416 273.2 416 176zM208 336c-34.14 0-67.86-7.742-97.51-22.39L103.2 310L96.05 313.7c-22.64 11.71-46.03 18.84-69.75 21.29c8.633-11.07 20.12-27.4 29.69-46.52l4.838-9.674L53.65 270.7C29.02 242.1 16 210.2 16 176c0-88.22 86.13-160 192-160s192 71.78 192 160S313.9 336 208 336zM599.6 443.7C624.8 413.9 640 376.6 640 336c0-89.54-72.1-163.3-167.4-174.4c-4.912-.5762-9.135 3.488-8.83 8.424c.2363 3.832 3.18 6.947 6.994 7.398C557.1 187.6 624 254.8 624 336c0 35.44-12.66 69.12-36.62 97.39l-6.918 8.168l4.91 9.512c9.25 17.92 20.15 33.37 28.38 43.96c-22.29-2.318-44.37-8.807-65.85-19.38l-7.174-3.529l-7.131 3.621C507.5 488.1 477.9 496 448 496c-73.58 0-136.6-41.33-162.8-99.74c-1.537-3.42-5.25-5.295-8.908-4.471l-.3594 .082c-4.859 1.096-7.426 6.369-5.389 10.91C299.2 466.8 367.8 512 448 512c33.69 0 65.32-8.008 92.85-21.98C565.2 502 596.1 512 632.3 512c3.059 0 5.76-1.725 7.02-4.605c1.229-2.879 .6582-6.148-1.441-8.354C637.6 498.7 615.9 475.3 599.6 443.7z"],
    "comments-question-check": [640, 512, [], "e14f", "M228.7 80H183.3C159.4 80 140 99.38 140 123.2c0 4.422 3.578 8 8 8s8-3.578 8-8C156 108.2 168.3 96 183.3 96h45.44C245.1 96 260 109.1 260 127.2c0 11.88-6.625 22.55-17.38 27.91L204.3 174.9C201.7 176.3 200 179 200 182V208c0 4.422 3.578 8 8 8S216 212.4 216 208V186.9l33.86-17.53C265.1 161.3 276 145.1 276 127.2C276 101.2 254.8 80 228.7 80zM208 244.6C201.7 244.6 196.6 249.7 196.6 256c0 6.299 5.107 11.41 11.41 11.41S219.4 262.3 219.4 256C219.4 249.7 214.3 244.6 208 244.6zM416 176C416 78.8 322.9 0 208 0S0 78.8 0 176c0 39.57 15.62 75.96 41.67 105.4c-16.39 32.76-39.23 57.32-39.59 57.68c-2.1 2.205-2.67 5.475-1.441 8.354C1.9 350.3 4.602 352 7.66 352c38.35 0 70.76-11.12 95.74-24.04C134.2 343.1 169.8 352 208 352C322.9 352 416 273.2 416 176zM208 336c-34.14 0-67.86-7.742-97.51-22.39L103.2 310L96.05 313.7c-22.64 11.71-46.03 18.84-69.75 21.29c8.633-11.07 20.12-27.4 29.69-46.52l4.838-9.674L53.65 270.7C29.02 242.1 16 210.2 16 176c0-88.22 86.13-160 192-160s192 71.78 192 160S313.9 336 208 336zM599.6 443.7C624.8 413.9 640 376.6 640 336c0-89.54-72.1-163.3-167.4-174.4c-4.912-.5762-9.135 3.488-8.83 8.424c.2363 3.832 3.18 6.947 6.994 7.398C557.1 187.6 624 254.8 624 336c0 35.44-12.66 69.12-36.62 97.39l-6.918 8.168l4.91 9.512c9.25 17.92 20.15 33.37 28.38 43.96c-22.29-2.318-44.37-8.807-65.85-19.38l-7.174-3.529l-7.131 3.621C507.5 488.1 477.9 496 448 496c-73.58 0-136.6-41.33-162.8-99.74c-1.537-3.42-5.25-5.295-8.908-4.471l-.3594 .082c-4.859 1.096-7.426 6.369-5.389 10.91C299.2 466.8 367.8 512 448 512c33.69 0 65.32-8.008 92.85-21.98C565.2 502 596.1 512 632.3 512c3.059 0 5.76-1.725 7.02-4.605c1.229-2.879 .6582-6.148-1.441-8.354C637.6 498.7 615.9 475.3 599.6 443.7zM392.7 346.7c-3.125 3.125-3.125 8.188 0 11.31l43.64 43.64c1.5 1.5 3.531 2.344 5.656 2.344c1.657-.1875 4.266-.9062 5.782-2.469l91.64-96c3.062-3.203 2.938-8.266-.25-11.31c-3.203-3.031-8.25-2.922-11.31 .25l-85.98 90.08l-37.86-37.84C400.9 343.6 395.8 343.6 392.7 346.7z"],
    "compact-disc": [512, 512, [128192, 128440, 128191], "f51f", "M264 79.1c0-4.422-3.594-8-8-8c-101.5 0-184 82.55-184 184c0 4.422 3.594 8 8 8s8-3.578 8-8c0-92.64 75.38-168 168-168C260.4 87.1 264 84.42 264 79.1zM256 239.1c-8.836 0-16 7.164-16 16s7.164 16 16 16s16-7.164 16-16S264.8 239.1 256 239.1zM256 159.1c-53.02 0-96 42.98-96 96s42.98 95.1 96 95.1s96-42.98 96-95.1S309 159.1 256 159.1zM256 335.1c-44.11 0-80-35.89-80-80s35.89-80 80-80s80 35.89 80 80S300.1 335.1 256 335.1zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "compass": [512, 512, [129517], "f14e", "M288 256C288 273.7 273.7 288 256 288C238.3 288 224 273.7 224 256C224 238.3 238.3 224 256 224C273.7 224 288 238.3 288 256zM256 240C247.2 240 240 247.2 240 256C240 264.8 247.2 272 256 272C264.8 272 272 264.8 272 256C272 247.2 264.8 240 256 240zM351.1 130.5C369.9 124.3 387.7 142.1 381.5 160.9L332.6 307.4C328.7 319.3 319.3 328.7 307.4 332.6L160.9 381.5C142.1 387.7 124.3 369.9 130.5 351.1L179.4 204.6C183.3 192.7 192.7 183.3 204.6 179.4L351.1 130.5zM366.3 155.8C368.4 149.6 362.4 143.6 356.2 145.7L209.7 194.5C202.5 196.9 196.9 202.5 194.5 209.7L145.7 356.2C143.6 362.4 149.6 368.4 155.8 366.3L302.3 317.5C309.5 315.1 315.1 309.5 317.5 302.3L366.3 155.8zM0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM256 496C388.5 496 496 388.5 496 256C496 123.5 388.5 16 256 16C123.5 16 16 123.5 16 256C16 388.5 123.5 496 256 496z"],
    "compass-drafting": [512, 512, ["drafting-compass"], "f568", "M297.3 148.5C285.3 155.8 271.1 160 256 160C240.9 160 226.7 155.8 214.7 148.5L125.8 308.5C163.1 331 206.9 344 253.8 344C345.5 344 425.7 294.1 468.6 219.1C470.8 216.2 475.7 214.9 479.5 217.1C483.3 219.3 484.6 224.2 482.4 228C436.8 306.9 351.5 360 253.8 360C204.1 360 157.7 346.3 118 322.5L14.99 507.9C12.85 511.7 7.977 513.1 4.114 510.1C.2518 508.8-1.14 503.1 1.006 500.1L104.5 313.8C72.06 291.5 44.85 262.2 25.08 228C22.86 224.2 24.17 219.3 27.99 217.1C31.82 214.9 36.71 216.2 38.92 219.1C57.25 251.7 82.39 278.9 112.3 299.7L201.7 138.8C185.9 124.2 176 103.2 176 80C176 35.82 211.8 0 256 0C300.2 0 336 35.82 336 80C336 103.2 326.1 124.2 310.3 138.8L373.2 252.1C375.4 255.1 373.1 260.8 370.1 262.1C366.2 265.1 361.4 263.7 359.2 259.9L297.3 148.5zM256 16C220.7 16 192 44.65 192 80C192 115.3 220.7 144 256 144C291.3 144 320 115.3 320 80C320 44.65 291.3 16 256 16zM421.5 371.9C419.3 368 420.7 363.2 424.6 361C428.4 358.9 433.3 360.3 435.4 364.1L510.1 500.1C513.1 503.1 511.7 508.8 507.9 510.1C504 513.1 499.2 511.7 497 507.9L421.5 371.9z"],
    "compass-slash": [640, 512, [], "f5e9", "M636.1 497.7C640.4 500.5 641 505.5 638.3 508.1C635.5 512.4 630.5 513 627 510.3L3.022 14.26C-.4365 11.51-1.012 6.481 1.738 3.022C4.487-.4365 9.52-1.012 12.98 1.738L636.1 497.7zM455.1 454.4L468.2 464.8C426.4 494.5 375.2 512 319.1 512C178.6 512 63.1 397.4 63.1 256C63.1 222.1 70.57 189.8 82.51 160.2L95.64 170.6C85.53 197.1 79.1 225.9 79.1 256C79.1 388.6 187.5 496 319.1 496C370.1 496 416.6 480.6 455.1 454.4zM576 256C576 289.9 569.4 322.2 557.5 351.8L544.4 341.4C554.5 314.9 560 286.1 560 256C560 123.5 452.5 16 320 16C269.9 16 223.4 31.35 184.9 57.61L171.8 47.25C213.6 17.5 264.8 .0006 320 .0006C461.4 .0006 576 114.6 576 256H576zM194.5 351.1L221.6 270L234.9 280.6L209.7 356.2C207.6 362.4 213.6 368.4 219.8 366.3L306.8 337.3L321.8 349.2L224.9 381.5C206.1 387.7 188.3 369.9 194.5 351.1V351.1zM415.1 130.5C433.9 124.3 451.7 142.1 445.5 160.9L418.4 241.1L405.1 231.4L430.3 155.8C432.4 149.6 426.4 143.6 420.2 145.7L333.2 174.7L318.2 162.8L415.1 130.5z"],
    "compress": [448, 512, [], "f066", "M151.1 31.1c-4.406 0-8 3.578-8 8v136h-136c-4.406 0-8 3.578-8 8s3.594 8 8 8h144c4.406 0 8-3.578 8-8v-144C159.1 35.58 156.4 31.1 151.1 31.1zM295.1 191.1h144c4.406 0 8-3.578 8-8s-3.594-8-8-8h-136v-136c0-4.422-3.594-8-8-8s-8 3.578-8 8v144C287.1 188.4 291.6 191.1 295.1 191.1zM439.1 319.1h-144c-4.406 0-8 3.578-8 8v144c0 4.422 3.594 8 8 8s8-3.578 8-8v-136h136c4.406 0 8-3.578 8-8S444.4 319.1 439.1 319.1zM151.1 319.1h-144c-4.406 0-8 3.578-8 8s3.594 8 8 8h136v136c0 4.422 3.594 8 8 8s8-3.578 8-8v-144C159.1 323.6 156.4 319.1 151.1 319.1z"],
    "compress-wide": [512, 512, [], "f326", "M151.1 64c-4.406 0-8 3.578-8 8V208h-136C3.594 208-.0001 211.6-.0001 216S3.594 224 7.1 224h144c4.406 0 8-3.578 8-8v-144C159.1 67.58 156.4 64 151.1 64zM359.1 224h144c4.406 0 8-3.578 8-8s-3.594-8-8-8h-136V72c0-4.422-3.594-8-8-8s-8 3.578-8 8v144C351.1 220.4 355.6 224 359.1 224zM503.1 288h-144c-4.406 0-8 3.578-8 8v144c0 4.422 3.594 8 8 8s8-3.578 8-8V304h136c4.406 0 8-3.578 8-8S508.4 288 503.1 288zM151.1 288h-144C3.594 288-.0001 291.6-.0001 296S3.594 304 7.1 304h136v136c0 4.422 3.594 8 8 8s8-3.578 8-8v-144C159.1 291.6 156.4 288 151.1 288z"],
    "computer": [640, 512, [], "e4e5", "M48 104C48 90.75 58.75 80 72 80H376C389.3 80 400 90.75 400 104V312C400 325.3 389.3 336 376 336H72C58.75 336 48 325.3 48 312V104zM64 104V312C64 316.4 67.58 320 72 320H376C380.4 320 384 316.4 384 312V104C384 99.58 380.4 96 376 96H72C67.58 96 64 99.58 64 104zM172.9 384H64C28.65 384 0 355.3 0 320V96C0 60.65 28.65 32 64 32H384C419.3 32 448 60.65 448 96V320C448 355.3 419.3 384 384 384H275.1L301.8 464H376C380.4 464 384 467.6 384 472C384 476.4 380.4 480 376 480H72C67.58 480 64 476.4 64 472C64 467.6 67.58 464 72 464H146.2L172.9 384zM16 96V320C16 346.5 37.49 368 64 368H384C410.5 368 432 346.5 432 320V96C432 69.49 410.5 48 384 48H64C37.49 48 16 69.49 16 96zM189.8 384L163.1 464H284.9L258.2 384H189.8zM520 136C520 131.6 523.6 128 528 128H592C596.4 128 600 131.6 600 136C600 140.4 596.4 144 592 144H528C523.6 144 520 140.4 520 136zM592 192C596.4 192 600 195.6 600 200C600 204.4 596.4 208 592 208H528C523.6 208 520 204.4 520 200C520 195.6 523.6 192 528 192H592zM576 336C576 344.8 568.8 352 560 352C551.2 352 544 344.8 544 336C544 327.2 551.2 320 560 320C568.8 320 576 327.2 576 336zM592 32C618.5 32 640 53.49 640 80V432C640 458.5 618.5 480 592 480H528C501.5 480 480 458.5 480 432V80C480 53.49 501.5 32 528 32H592zM592 48H528C510.3 48 496 62.33 496 80V432C496 449.7 510.3 464 528 464H592C609.7 464 624 449.7 624 432V80C624 62.33 609.7 48 592 48z"],
    "computer-classic": [448, 512, [], "f8b1", "M399.1 0h-352c-26.51 0-48 21.49-48 48l0 352c0 17.67 14.33 32 31.1 32v64c0 8.836 7.164 16 16 16h352c8.838 0 16-7.164 16-16v-64C433.7 432 448 417.7 448 400l-.0001-352C447.1 21.49 426.5 0 399.1 0zM399.1 496h-352v-64h352V496zM431.1 400c0 8.822-7.178 16-16 16h-384c-8.822 0-16-7.178-16-16v-352c0-17.64 14.36-32 32-32h352c17.64 0 32 14.36 32 32V400zM319.1 64h-192c-35.35 0-64 28.65-64 64l0 80c0 35.35 28.65 64 64 64h192c35.35 0 64-28.65 64-64L383.1 128C383.1 92.65 355.3 64 319.1 64zM367.1 208c0 26.47-21.53 48-48 48h-192c-26.47 0-48-21.53-48-48L79.1 128c0-26.47 21.53-48 48-48h192c26.47 0 48 21.53 48 48L367.1 208zM375.1 336h-144c-4.422 0-7.1 3.578-7.1 8s3.578 8 8 8h144c4.422 0 8-3.578 8-8S380.4 336 375.1 336zM79.1 336c-8.836 0-16 7.162-16 16c0 8.836 7.164 16 16 16s16-7.164 16-16C95.1 343.2 88.84 336 79.1 336z"],
    "computer-mouse": [384, 512, [128433, "mouse"], "f8cc", "M224 0H160C71.63 0 0 71.63 0 160v192c0 88.38 71.63 160 160 160h64c88.38 0 160-71.63 160-160V160C384 71.63 312.4 0 224 0zM16 160c0-79.4 64.6-144 144-144h24V192H16V160zM368 352c0 79.4-64.6 144-144 144H160c-79.4 0-144-64.6-144-144V208h352V352zM368 192h-168V16H224c79.4 0 144 64.6 144 144V192z"],
    "computer-mouse-scrollwheel": [384, 512, ["mouse-alt"], "f8cd", "M224 0H160c-88.38 0-160 71.63-160 160v192c0 88.38 71.63 160 160 160h64c88.38 0 160-71.63 160-160V160C384 71.62 312.4 0 224 0zM368 352c0 79.4-64.6 144-144 144H160c-79.4 0-144-64.6-144-144V160c0-79.4 64.6-144 144-144h64c79.4 0 144 64.6 144 144V352zM192 95.1c-17.62 0-32 14.38-32 32v31.1C160 177.6 174.4 192 192 192s32-14.38 32-32V127.1C224 110.4 209.6 95.1 192 95.1zM208 160c0 8.822-7.178 16-16 16S176 168.8 176 160V128c0-8.822 7.178-16 16-16s16 7.178 16 16V160z"],
    "computer-speaker": [640, 512, [], "f8b2", "M592 32h-224c-26.5 0-48 21.5-48 48v352c0 26.5 21.5 48 48 48H592c26.5 0 48-21.5 48-48v-352C640 53.5 618.5 32 592 32zM623.1 432c0 17.64-14.36 32-32 32h-224c-17.64 0-32-14.36-32-32v-352c0-17.64 14.36-32 32-32h224c17.64 0 32 14.36 32 32V432zM279.1 32H47.1c-26.51 0-48 21.49-48 48l0 288c0 26.51 21.49 48 48 48h232c4.418 0 8-3.582 8-8s-3.582-8-8-8h-232c-17.67 0-32-14.33-32-32v-288c0-17.67 14.33-32 32-32h232c4.418 0 8-3.582 8-8S284.4 32 279.1 32zM279.1 112c4.418 0 8-3.582 8-8S284.4 96 279.1 96H63.1L63.1 352h216c4.418 0 8-3.582 8-8s-3.582-8-8-8h-200v-224H279.1zM279.1 464h-176c-4.422 0-8 3.578-8 8s3.578 8 8 8h176c4.422 0 8-3.578 8-8S284.4 464 279.1 464zM480 224c-53.02 0-96 42.98-96 96s42.98 96 96 96s96-42.98 96-96S533 224 480 224zM479.1 400c-44.11 0-80-35.89-80-80s35.89-80 80-80c44.11 0 79.1 35.89 79.1 80S524.1 400 479.1 400zM480 160c17.67 0 31.1-14.33 31.1-32S497.7 96 480 96c-17.67 0-32 14.33-32 32S462.3 160 480 160zM479.1 112c8.822 0 15.1 7.178 15.1 16s-7.178 16-16 16s-16-7.178-16-16S471.2 112 479.1 112zM479.1 288c-17.67 0-32 14.33-32 32s14.33 32 32 32c17.67 0 32-14.33 32-32S497.7 288 479.1 288zM479.1 336c-8.822 0-16-7.178-16-16s7.178-16 16-16s16 7.178 16 16S488.8 336 479.1 336z"],
    "container-storage": [640, 512, [], "f4b7", "M415.1 416c4.422 0 8-3.578 8-8v-304c0-4.422-3.578-8-8-8s-8 3.578-8 8v304C407.1 412.4 411.6 416 415.1 416zM511.1 416c4.422 0 8-3.578 8-8v-304c0-4.422-3.578-8-8-8s-8 3.578-8 8v304C503.1 412.4 507.6 416 511.1 416zM319.1 416c4.422 0 8-3.578 8-8v-304c0-4.422-3.578-8-8-8s-8 3.578-8 8v304C311.1 412.4 315.6 416 319.1 416zM127.1 416c4.422 0 8-3.578 8-8v-304c0-4.422-3.578-8-8-8s-8 3.578-8 8v304C119.1 412.4 123.6 416 127.1 416zM223.1 416c4.422 0 8-3.578 8-8v-304c0-4.422-3.578-8-8-8s-8 3.578-8 8v304C215.1 412.4 219.6 416 223.1 416zM631.1 464h-8v-416h8c4.422 0 8-3.578 8-8s-3.578-8-8-8h-624c-4.422 0-8 3.578-8 8s3.578 8 8 8h8v416h-8c-4.422 0-8 3.578-8 8s3.578 8 8 8h624c4.422 0 8-3.578 8-8S636.4 464 631.1 464zM608 464h-576v-416h576V464z"],
    "conveyor-belt": [640, 512, [], "f46e", "M159.1 288h320c17.6 0 32-14.4 32-32l0-224c0-17.6-14.4-32-32-32h-320C142.4 0 127.1 14.4 127.1 32L127.1 256C127.1 273.6 142.4 288 159.1 288zM255.1 16h128V160l-64-32l-64 32V16zM143.1 32c0-8.822 7.178-16 16-16h80V160c0 5.545 2.871 10.7 7.588 13.61C250.2 175.2 253.1 176 255.1 176c2.445 0 4.896-.5605 7.156-1.689L319.1 145.9l56.84 28.42C379.1 175.4 381.6 176 383.1 176c2.926 0 5.842-.8008 8.412-2.389C397.1 170.7 399.1 165.5 399.1 160V16h80c8.822 0 16 7.178 16 16v224c0 8.822-7.178 16-16 16h-320c-8.822 0-16-7.178-16-16V32zM111.1 368c-26.62 0-48 21.38-48 48s21.38 48 48 48s48-21.38 48-48S138.6 368 111.1 368zM111.1 448c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S129.6 448 111.1 448zM319.1 368c-26.62 0-48 21.38-48 48s21.38 48 48 48s48-21.38 48-48S346.6 368 319.1 368zM319.1 448c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S337.6 448 319.1 448zM527.1 368c-26.62 0-47.1 21.38-47.1 48s21.38 48 47.1 48c26.62 0 48-21.38 48-48S554.6 368 527.1 368zM527.1 448c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S545.6 448 527.1 448zM544 320h-448c-53.02 0-96 42.98-96 96s42.98 96 96 96h448c53.02 0 96-42.98 96-96S597 320 544 320zM543.1 496h-448c-44.11 0-80-35.89-80-80s35.89-80 80-80h448c44.11 0 80 35.89 80 80S588.1 496 543.1 496z"],
    "conveyor-belt-boxes": [640, 512, ["conveyor-belt-alt"], "f46f", "M96 288h208c17.6 0 32-14.4 32-32V32c0-17.6-14.4-32-32-32H96C78.4 0 64 14.4 64 32v224C64 273.6 78.4 288 96 288zM80 32c0-8.824 7.178-16 16-16h208C312.8 16 320 23.18 320 32v224c0 8.824-7.178 16-16 16H96C87.18 272 80 264.8 80 256V32zM400 288H544c17.6 0 32-14.4 32-32V96c0-17.6-14.4-32-32-32h-144c-17.6 0-32 14.4-32 32v160C368 273.6 382.4 288 400 288zM384 96c0-8.824 7.178-16 16-16H544c8.822 0 16 7.176 16 16v160c0 8.824-7.178 16-16 16h-144C391.2 272 384 264.8 384 256V96zM528 368c-26.62 0-48 21.38-48 48s21.38 48 48 48S576 442.6 576 416S554.6 368 528 368zM528 448c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S545.6 448 528 448zM320 368c-26.62 0-48 21.38-48 48s21.38 48 48 48s48-21.38 48-48S346.6 368 320 368zM320 448c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S337.6 448 320 448zM544 320H96c-53.02 0-96 42.98-96 96s42.98 96 96 96h448c53.02 0 96-42.98 96-96S597 320 544 320zM544 496H96c-44.11 0-80-35.89-80-80s35.89-80 80-80h448c44.11 0 80 35.89 80 80S588.1 496 544 496zM112 368C85.38 368 64 389.4 64 416s21.38 48 48 48S160 442.6 160 416S138.6 368 112 368zM112 448c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S129.6 448 112 448z"],
    "conveyor-belt-empty": [640, 512, [], "e150", "M528 368c-26.62 0-48 21.38-48 48s21.38 48 48 48S576 442.6 576 416S554.6 368 528 368zM528 448c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S545.6 448 528 448zM320 368c-26.62 0-48 21.38-48 48s21.38 48 48 48s48-21.38 48-48S346.6 368 320 368zM320 448c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S337.6 448 320 448zM544 320H96c-53.02 0-96 42.98-96 96s42.98 96 96 96h448c53.02 0 96-42.98 96-96S597 320 544 320zM544 496H96c-44.11 0-80-35.89-80-80s35.89-80 80-80h448c44.11 0 80 35.89 80 80S588.1 496 544 496zM112 368C85.38 368 64 389.4 64 416s21.38 48 48 48S160 442.6 160 416S138.6 368 112 368zM112 448c-17.64 0-32-14.36-32-32s14.36-32 32-32s32 14.36 32 32S129.6 448 112 448z"],
    "cookie": [512, 512, [127850], "f563", "M494.5 254.8l-11.37-71.48c-4.102-25.9-16.29-49.8-34.8-68.32l-51.33-51.33c-18.52-18.52-42.31-30.7-68.2-34.8L256.9 17.53C250.5 16.5 244 16 237.6 16c-19.44 0-38.71 4.591-56.13 13.48L116.7 62.53c-23.44 11.84-42.3 30.82-54.26 54.14L29.51 181.2c-11.84 23.44-16.08 50.04-11.98 75.94l11.37 71.48c4.102 25.9 16.29 49.77 34.8 68.41l51.33 51.33c18.52 18.4 42.31 30.61 68.2 34.72l71.84 11.37C261.5 495.5 267.1 496 274.4 496c19.44 0 38.71-4.591 56.13-13.48l64.8-33.05c23.32-11.84 42.3-30.82 54.26-54.14l32.81-64.57C494.4 307.3 498.6 280.8 494.5 254.8zM468.1 323.5l-32.79 64.52c-10.51 20.5-26.85 36.81-47.29 47.18l-64.8 33.05c-15.05 7.676-31.95 11.73-48.86 11.73c-5.621 0-11.28-.4473-16.84-1.33l-71.83-11.37c-22.57-3.574-43.12-14.03-59.39-30.2l-51.29-51.29c-16.27-16.37-26.76-36.1-30.35-59.67L33.33 254.7C29.74 231.1 33.34 209.1 43.73 188.5l32.91-64.54c10.54-20.57 26.88-36.87 47.29-47.18l64.8-33.05c15.05-7.676 31.95-11.73 48.86-11.73c5.621 0 11.28 .4473 16.84 1.33l71.83 11.37c22.6 3.58 43.14 14.06 59.39 30.32l51.33 51.33c16.24 16.24 26.72 36.81 30.32 59.52l11.36 71.46C482.3 280.1 478.6 302.1 468.1 323.5zM176 303.1c-17.62 0-31.1 14.37-31.1 31.1c0 17.62 14.38 31.1 31.1 31.1s31.1-14.37 31.1-31.1C208 318.4 193.6 303.1 176 303.1zM176 351.1c-8.822 0-15.1-7.178-15.1-15.1c0-8.822 7.178-15.1 15.1-15.1s15.1 7.178 15.1 15.1C192 344.8 184.8 351.1 176 351.1zM208 144c-17.62 0-31.1 14.37-31.1 31.1s14.38 31.1 31.1 31.1s31.1-14.38 31.1-31.1S225.6 144 208 144zM208 192c-8.822 0-15.1-7.178-15.1-15.1c0-8.822 7.178-15.1 15.1-15.1s15.1 7.178 15.1 15.1C224 184.8 216.8 192 208 192zM368 271.1c-17.62 0-31.1 14.37-31.1 31.1c0 17.62 14.38 31.1 31.1 31.1s31.1-14.37 31.1-31.1C400 286.4 385.6 271.1 368 271.1zM368 319.1c-8.822 0-15.1-7.178-15.1-15.1c0-8.822 7.178-15.1 15.1-15.1s15.1 7.178 15.1 15.1C384 312.8 376.8 319.1 368 319.1z"],
    "cookie-bite": [512, 512, [], "f564", "M487.8 255.6c-59.98-4.093-107.9-52.11-111.6-112.1c-.2591-4.202-3.51-7.453-7.713-7.712c-60.01-3.7-108-51.6-112-111.6c-.2692-4.042-3.323-7.276-7.356-7.653C245.3 16.18 241.4 16 237.5 16c-19.43 0-38.63 4.525-56 13.48L116.7 62.41c-23.32 11.95-42.31 30.94-54.26 54.26L29.6 181.2c-11.96 23.44-16.17 49.92-12.07 75.94l11.37 71.48c4.102 25.9 16.29 49.8 34.81 68.32l51.36 51.39c18.46 18.46 42.39 30.66 68.18 34.75l71.84 11.37C261.5 495.5 268 496 274.5 496c19.46 0 38.65-4.591 56.17-13.48l64.81-33.05c23.32-11.84 42.31-30.82 54.14-54.14l32.93-64.57c10.69-21.06 15.14-44.76 12.9-68.15C495.1 258.7 491.7 255.9 487.8 255.6zM468.3 323.5l-32.94 64.6c-10.23 20.15-26.96 36.88-47.14 47.13l-64.78 33.03c-15.14 7.685-32.07 11.75-48.96 11.75c-5.629 0-11.31-.4472-16.89-1.33L185.7 467.3c-22.6-3.58-43.14-14.06-59.39-30.32l-51.33-51.33c-16.24-16.24-26.72-36.82-30.32-59.52L33.33 254.7C29.74 231.9 33.38 209 43.86 188.5l32.79-64.52C87.14 103.5 103.5 87.14 123.9 76.67l64.89-32.97c14.86-7.656 31.69-11.7 48.66-11.7c1.232 0 2.471 .0195 3.709 .0625c7.371 62.36 57.39 112.1 119.7 119.1c7.02 62.24 56.73 112.3 119.1 119.8C480.5 289.1 476.5 307.3 468.3 323.5zM176 303.1c-17.62 0-32 14.37-32 31.1s14.38 31.1 32 31.1s32-14.37 32-31.1S193.6 303.1 176 303.1zM176 351.1c-8.822 0-16-7.178-16-15.1c0-8.822 7.178-15.1 16-15.1s15.1 7.177 15.1 15.1C192 344.8 184.8 351.1 176 351.1zM208 144c-17.62 0-32 14.37-32 31.1s14.38 31.1 32 31.1s32-14.37 32-31.1S225.6 144 208 144zM208 192c-8.822 0-16-7.178-16-15.1c0-8.822 7.178-15.1 16-15.1s16 7.177 16 15.1C224 184.8 216.8 192 208 192zM368 271.1c-17.62 0-32 14.37-32 31.1c0 17.62 14.38 31.1 32 31.1s32-14.37 32-31.1C400 286.4 385.6 271.1 368 271.1zM368 319.1c-8.822 0-16-7.178-16-15.1c0-8.822 7.178-15.1 16-15.1s16 7.177 16 15.1C384 312.8 376.8 319.1 368 319.1z"],
    "copy": [512, 512, [], "f0c5", "M502.6 102.6l-93.26-93.25C403.4 3.371 395.2 0 386.7 0H271.1c-26.51 0-48 21.49-48 48v288c0 26.51 21.49 48 48 48H464c26.51 0 48-21.49 48-48l-.0001-210.7C511.1 116.8 508.6 108.6 502.6 102.6zM399.1 22.63L489.4 112h-65.38c-13.22 0-24-10.77-24-24V22.63zM495.1 336c0 17.64-14.36 32-32 32h-192c-17.64 0-32-14.36-32-32v-288c0-17.64 14.36-32 32-32h112v72c0 22.06 17.94 40 40 40h72V336zM279.1 448c-4.418 0-8 3.582-8 8v8c0 17.67-14.33 32-32 32h-192c-17.67 0-32-14.33-32-32v-288c0-17.67 14.33-32 32-32h104c4.418 0 8-3.582 8-8S156.4 128 151.1 128H47.1c-26.51 0-48 21.49-48 48v288c0 26.51 21.49 48 48 48h192c26.51 0 48-21.49 48-48l0-8C287.1 451.6 284.4 448 279.1 448z"],
    "copyright": [512, 512, [169], "f1f9", "M316 165.9c3.75 2.156 8.656 .875 10.94-2.938C329.1 159.2 327.8 154.3 324 152c-46.91-27.09-106.5-19.28-144.8 19.12C156.5 193.8 144 223.9 144 256s12.5 62.19 35.16 84.84C202.3 363.1 233 376 264.1 376c20.53 0 41.22-5.25 59.88-16.03c3.812-2.219 5.125-7.125 2.938-10.94c-2.281-3.875-7.188-5.094-10.94-2.938c-40.72 23.5-92.34 16.69-125.5-16.56C170.8 309.9 160 283.8 160 256s10.81-53.91 30.47-73.53C223.7 149.2 275.3 142.4 316 165.9zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 496c-132.3 0-240-107.7-240-240S123.7 16 256 16s240 107.7 240 240S388.3 496 256 496z"],
    "corn": [512, 512, [127805], "f6c7", "M511.9 51.77l-.0313-2.502c1.656-25.33-17.04-46.88-42.42-49.07c-15.54-1.406-30.82 4.877-40.57 16.72c-11.19-7.064-24.91-9.127-37.48-5.312c-12.41 3.484-22.57 11.71-28.54 22.71c-11.32-4.471-24.16-4.346-35.82 .5938c-11.44 5.172-20.22 14.47-24.69 25.79c-11.85-2.939-24.41-1.236-34.98 4.984c-10.44 5.986-18.16 16.02-21.47 27.41C234 91.15 221.6 93.92 211.6 101.2C207.9 103.9 204.6 106.1 201.8 110.7c-2.656 3.516-2 8.549 1.531 11.22c3.502 2.672 8.502 2 11.22-1.5c1.906-2.518 4.031-4.596 6.438-6.361C228.1 108.3 239.9 106.9 249.4 110.5c2.377 .8594 5.002 .6094 7.158-.75c2.125-1.361 3.502-3.658 3.658-6.174c.6875-9.861 6.5-19.05 15.22-24.07c8.721-5.158 19.47-5.627 28.88-1.221c2.189 1.016 4.814 1 7.064-.1406c2.188-1.141 3.75-3.25 4.189-5.688c1.812-10.08 8.562-18.68 17.88-22.88c9.754-4.047 20.57-3.141 29.1 2.471c2.094 1.375 4.719 1.703 7.094 .8281c2.377-.8594 4.221-2.783 4.939-5.205c3.062-10.06 10.97-17.8 21.32-20.71c10.38-3.094 21.32-.375 29.32 7.314c1.877 1.734 4.346 2.641 6.846 2.125c2.469-.3906 4.627-1.938 5.814-4.172c5.781-11 17.85-17.11 30.13-16.1c16.72 1.438 29.01 15.54 27.91 32.62v2.705c-.4375 11.39-6.939 21.64-16.94 26.74c-2.219 1.125-3.781 3.221-4.25 5.674c-.4375 2.438 .25 4.953 1.938 6.814c7.408 8.203 9.971 19.25 6.908 29.47c-3.064 9.986-11.1 18.02-20.94 20.99c-2.406 .7187-4.312 2.516-5.188 4.875c-.875 2.346-.5938 4.971 .75 7.08c5.689 8.939 6.502 19.55 2.25 29.1c-4.281 9.408-12.75 15.86-23.29 17.71c-2.502 .4219-4.627 2.016-5.752 4.266c-1.156 2.25-1.156 4.924-.0313 7.174c4.502 9.064 4.031 19.79-1.406 28.87c-4.846 8.611-14.13 14.38-24.19 15.06c-2.531 .1719-4.844 1.533-6.188 3.658c-1.377 2.141-1.658 4.781-.7813 7.158c3.656 9.611 2.312 19.93-3.471 28.08c-1 1.314-2.125 2.408-3.219 3.471c0 .0156-.7813 .7656-.7813 .7813c-3.127 3.125-2.752 7.799 .3438 10.92c1.5 1.484 3.469 2.188 5.5 2.188c2.252 0 4.533-.875 6.189-2.516c1.594-1.578 3.25-3.234 4.877-5.377c7.062-9.971 9.846-22.19 7.969-34.04c11.63-3.281 21.76-11 27.6-21.36c6.439-10.77 8.221-23.35 5.221-35.07c11.6-4.375 20.82-12.94 26.01-24.41c5.125-11.49 5.344-24.37 .875-35.88c10.91-5.846 19.19-15.85 22.97-28.07c3.814-12.72 1.971-26.16-4.812-37.4C504.7 78.94 511.4 66.04 511.9 51.77zM201.6 310L208.1 288.5c15.78-69.06-2.377-142.1-48.66-195.3C155.5 88.84 149.6 87.06 143.9 88.51c-5.906 1.5-10.38 6.096-11.69 12.13L114 191.8L29.18 276.7c-38.91 38.94-38.91 102.3 0 141.2l64.95 64.95C113.6 502.3 139.2 512 164.7 512c25.56 0 51.13-9.721 70.6-29.19l84.86-84.87l91.14-18.21c5.938-1.25 10.56-5.688 12.13-11.59c1.5-5.736-.3125-11.69-4.721-15.55C357.6 299.4 274.4 285.5 201.6 310zM40.5 406.5c-32.69-32.69-32.69-85.88 0-118.6l86.57-86.59C128.2 200.3 128.9 198.8 129.3 197.3l18.06-93.54c42.91 49.38 59.79 117.1 45.26 180.7L182.8 317.3c-24.41 10.77-47.19 26.08-67.04 45.93l-59.26 59.27L40.5 406.5zM314.7 382.7c-1.562 .3125-2.969 1.062-4.094 2.188l-86.57 86.59c-32.69 32.69-85.89 32.69-118.6 0l-37.63-37.64l59.26-59.27c76.38-76.37 199.8-80.68 281-10.52L314.7 382.7z"],
    "corner": [448, 512, [], "e3fe", "M440 384c-4.406 0-8-3.594-8-8V208H8C3.594 208 0 204.4 0 200S3.594 192 8 192h432C444.4 192 448 195.6 448 200v176C448 380.4 444.4 384 440 384z"],
    "couch": [640, 512, [], "f4b8", "M576 224c-35.35 0-64 28.65-64 64h-384c0-35.35-28.65-64-64-64s-64 28.65-64 64v160c0 17.67 14.33 32 32 32h64c17.67 0 32-14.33 32-32l0-16h384l0 16c0 17.67 14.33 32 32 32h64c17.67 0 32-14.33 32-32V288C640 252.7 611.3 224 576 224zM111.1 448c0 8.822-7.178 16-15.1 16H31.1c-8.822 0-16-7.178-16-16V288c0-26.47 21.53-48 48-48S111.1 261.5 111.1 288V448zM511.1 416h-384l0-112h384L511.1 416zM623.1 448c0 8.822-7.178 16-16 16H544c-8.822 0-16-7.178-16-16V288c0-26.47 21.53-48 48-48s48 21.53 48 48V448zM71.1 192c4.418 0 8-3.582 8-8V160c0-61.86 50.14-112 112-112h256c61.86 0 112 50.14 112 112v24c0 4.418 3.582 8 8 8s8-3.582 8-8L576 160c0-70.69-57.31-128-128-128H191.1c-70.69 0-128 57.31-128 128L63.1 184C63.1 188.4 67.58 192 71.1 192z"],
    "cow": [640, 512, [128004], "f6c8", "M632.5 264.1l-8.5-11.78V177.9c0-8.391-4.281-16.03-11.41-20.42c-7.125-4.359-15.88-4.766-23.25-1c-8.531 4.219-16.28 10.17-23.09 17.77l-59.03-67.17C487.7 80.09 456.2 64 423 64H120C80.31 64 48 96.3 48 136v96.81C20.93 236.7 0 259.9 0 288v24C0 316.4 3.594 320 8 320c30.88 0 56-25.12 56-56v-128c0-28.92 22.12-52.51 50.28-55.42C98.22 93.75 87.74 113.5 87.72 135.8C87.66 237.2 88 424 88 424c0 13.23 10.78 24 23.1 24h56c13.22 0 24-10.77 24-24V336c0-2.695 .5078-5.25 .7969-7.869c11.85 8.822 25.08 15.12 39.2 19.03V376c0 4.422 3.592 8 7.998 8s8.002-3.578 8.002-8v-25.58C253.3 351.1 258.6 352 264 352s10.7-.875 16-1.58V376c0 4.422 3.591 8 7.997 8c4.406 0 8.003-3.578 8.003-8v-28.84c14.12-3.9 27.35-10.2 39.2-19.03c.2891 2.619 .7969 5.174 .7969 7.869v88c0 13.23 10.78 24 24 24h55.1c13.22 0 24.01-10.77 24.01-24V268.9l32 16v36.56c0 14.25 4.156 28.03 11.66 39.23l33.69 62.7C527.6 438.8 544.8 448 563.4 448c26.25 0 49-18.69 54.09-44.42l21.75-108.6C641.4 284.3 638.1 273 632.5 264.1zM48 264c0 19.31-13.75 35.48-32 39.2V288c0-19.31 13.75-35.48 32-39.2V264zM160.9 91.39C163.1 86.14 169.7 80 181 80h166c11.34 0 17.88 6.141 20.06 11.39c2.031 4.984 .8125 10.06-3.438 14.31l-22.88 22.73C320.2 148.8 292.9 160 263.9 160C235.1 160 207.8 148.8 187.3 128.5l-22.91-22.75C160.1 101.5 158.9 96.38 160.9 91.39zM264 336c-25.05 0-48.39-9.191-67.18-25.27C207.1 283.5 233.2 264 264 264s56.9 19.5 67.18 46.73C312.4 326.8 289.1 336 264 336zM601.8 400.5C598.2 418.7 582 432 563.4 432c-13.22 0-25.44-6.516-32.31-16.78l-33.69-62.7c-6.125-9.219-9.375-19.94-9.375-31.02V280c0-3.031-1.719-5.797-4.438-7.156l-48-24C434.4 248.3 433.2 248 432 248c-1.469 0-2.906 .4062-4.219 1.188C425.4 250.7 424 253.2 424 256v168c0 4.406-3.594 8-8 8h-56c-4.406 0-8-3.594-8-8V336c0-6.861-.8799-13.54-2.372-19.96c.0566-.0566-.0566 .0566 0 0l-.2393-.4004C340.2 276.9 305.5 248 264 248S187.9 276.9 178.6 315.6L178.4 316c.0566 .0566-.0566-.0566 0 0C176.9 322.5 176 329.1 176 336l.0026 88c0 4.406-3.594 8-8 8H112c-4.406 0-8-3.594-8-8.016L103.7 135.8c.0273-26.1 19.43-49.55 45.05-54.65c-.8633 1.406-1.975 2.65-2.611 4.193C141.6 96.34 144.2 108.2 153.1 117L176 139.8C199.6 163.2 230.8 176 264.1 176c33.06 0 64.28-12.84 87.91-36.2l22.84-22.75c8.906-8.828 11.53-20.7 6.969-31.75C381 83.35 379.7 81.73 378.6 80h44.46c28.09 0 54.72 13.62 71.75 37.03l65.75 74.88c1.594 1.844 4.125 2.969 6.375 2.703c2.438-.1094 4.688-1.328 6.094-3.297c6.688-9.219 14.56-16.12 23.53-20.55c3.563-1.766 6.563-.375 7.719 .3125c1.125 .7031 3.781 2.766 3.781 6.797v77c0 1.672 .5313 3.312 1.5 4.672l10 13.88c3.844 5.344 5.313 12.03 4.031 18.38L601.8 400.5zM568 320c-8.875 0-16 7.125-16 16s7.125