<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\Uuid;
use Illuminate\Database\Eloquent\SoftDeletes;
use Services\Cachable\ModelCaching\Traits\Cachable;

class Withdraw extends Model
{
    use HasFactory, Uuid, SoftDeletes, Cachable;

    protected $fillable = [
        'name', 
        'status',  
        'min', 
        'max', 
        'fc', 
        'pc', 
        'requirements', 
    ];

    public function withdrawTrx()
	{
		return $this->hasMany(Transactions::class, 'withdraw_id');
	}
}
