<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Traits\Uuid;
use Illuminate\Database\Eloquent\SoftDeletes;

class Plancategory extends Model
{
    use Uuid, SoftDeletes;
    protected $table = "plan_category";
    protected $fillable = ['name', 'slug'];

    public function plans()
    {
        return $this->belongsTo(Plans::class, 'cat_id');
    }
    
    public function assets()
    {
        return $this->hasMany(CategoryAsset::class);
    }
}
