<?php

namespace App\Http\Livewire\Admin\Invest;

use Livewire\Component;
use App\Models\PlanTransaction;

class EditTransactions extends Component
{

    public $val;
    public $admin;
    public $type;
    public $amount;
    public $remark;
    
    public function createTrans()
    {
       $createnow = PlanTransaction::create([
           'plan_id' => $this->val->id,
           'amount' => $this->amount,
           'remark' => $this->remark,
       ]);
       
       if($createnow)
       {
          $this->emit('success', 'Transaction created');
          return redirect()->to(request()->header('Referer'));
       }else{
          $this->emit('alert', 'Something went wrong');
       }
      
    }
    
    public function deleteTrans($id)
    {
      $trans = PlanTransaction::where('id', $id)->first();
      
      if ($trans) {
      $trans->delete();
      $this->emit('success', 'Transaction deleted');
      return redirect()->to(request()->header('Referer'));
      }else{
      $this->emit('alert', 'Something went wrong');
      }
    }
    
    public function render()
    {
        return view('livewire.admin.invest.edit-transactions');
    }
}
