<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\Uuid;

class Dividend extends Model
{
    use HasFactory, Uuid;
    protected $table = 'dividend';
    protected $fillable = [
        'amount',
        'type',
        'plan_id',
    ];

    public function invest()
    {
        return $this->belongsTo(Plans::class, 'cat_id');
    }
}
