<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Traits\Uuid;
use Illuminate\Database\Eloquent\SoftDeletes;
use Services\Cachable\ModelCaching\Traits\Cachable;

class Category extends Model {
    use Uuid, SoftDeletes, Cachable;
    
    protected $table = "trending_cat";
    protected $fillable = ['name', 'slug'];

    public function articles()
    {
        return $this->hasMany(Blog::class, 'cat_id');
    }
}
