<?php

namespace App\Http\Livewire\Plans;

use Livewire\Component;
use App\Models\Followed;
use Carbon\Carbon;
use App\Models\PlanTransaction;
use App\Models\UserWithdraw;

class Index extends Component
{
    public $user, $totalInvestment = 0, $firstBal, $totalprofitBal, $totallossBal, $profitBal, $lossBal, $lastMonthProfit, $percentageChange;
    public $wamount, $invBal;
    
    public function mount()
    {
          $planIds = Followed::where('user_id', $this->user->id)->pluck('plan_id');

          $this->firstBal = $this->user->followed()->sum('amount') - $this->user->followed()->sum('sold');
    
          $now = Carbon::now();

	  $this->profitBal = PlanTransaction::whereIn('plan_id', $planIds)
	    ->where('remark', 'profit')
	    ->whereYear('created_at', $now->year)
	    ->whereMonth('created_at', $now->month)
	    ->sum('limit_price');
	  
	$this->lossBal = PlanTransaction::whereIn('plan_id', $planIds)
	    ->where('remark', 'loss')
	    ->whereYear('created_at', $now->year)
	    ->whereMonth('created_at', $now->month)
	    ->sum('limit_price');
	    
	$lastMonth = Carbon::now()->subMonth();
	
	$this->lastMonthProfit = PlanTransaction::whereIn('plan_id', $planIds)
	    ->where('remark', 'profit')
	    ->whereYear('created_at', $lastMonth->year)
	    ->whereMonth('created_at', $lastMonth->month)
	    ->sum('limit_price');
	    
	  $this->totalprofitBal = PlanTransaction::whereIn('plan_id', $planIds)
	  ->where('remark', 'profit')
	  ->sum('limit_price');
	  
	  $this->totallossBal = PlanTransaction::whereIn('plan_id', $planIds)
	  ->where('remark', 'loss')
	  ->sum('limit_price');
      
          $this->totalInvestment += $this->firstBal + $this->totalprofitBal - $this->totallossBal;
          if ($this->profitBal == 0) {
    $this->percentageChange = $this->lastMonthProfit > 0 ? -100 : 0;
} else {
    $this->percentageChange = (($this->lastMonthProfit - $this->profitBal) / $this->profitBal) * 100;
}
        
        $this->invBal = $this->totalInvestment - $this->user->withdrawBalance();
	         
    }
    
    public function wtmb()
    {
   
        if ($this->invBal < $this->wamount) {
            return $this->addError('wamount', __('Insufficient Investment Balance'));
        } else {
        
          UserWithdraw::create([
             'user_id' => $this->user->id,
             'amount' => $this->wamount,
          ]);
          
          $this->emit('closeDrawer');
          $this->emit('closeModal');
          $this->emit('success', 'Withdrawal request is under review');
          
          return redirect(request()->header('Referer'));
        }
    }

    public function xBalance()
    {
        $business = $this->user->business;
        if ($business->reveal_balance == 1) {
            $business->update(['reveal_balance' => 0]);
        } else {
            $business->update(['reveal_balance' => 1]);
        }
    }

    public function render()
    {
        return view('livewire.plans.index');
    }
}
