<?php

namespace App\Http\Livewire\Admin\Users;

use Livewire\Component;
use App\Jobs\CustomEmail;
use App\Models\Admin;
use App\Models\Settings;
use App\Models\Transactions;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Hash;

class Details extends Component
{
    public $client;
    public $reason;
    public $amount;
    public $password;

    public function mount()
    {
        $this->amount = number_format($this->client->getFirstBalance()->amount, 2);
    }

    public function editBalance()
    {
        $admin = Admin::whereRole('super')->first();
        $set = Settings::find(1);
        $this->amount = removeCommas($this->amount);
        if (Hash::check($this->password, $admin->password)) {
            $balance = $this->client->getFirstBalance();
            if ($this->amount != $balance->amount) {
                if ($this->amount > $balance->amount) {
                    $amount = $this->amount - $balance->amount;
                    $type = 'credit';
                } else {
                    $amount =  $balance->amount - $this->amount;
                    $type = 'debit';
                }
                $balance->update(['amount' => $this->amount]);
                $object = [
                    'user_id' => $this->client->id,
                    'business_id' => $this->client->business_id,
                    'amount' => $amount,
                    'ref_id' => Str::uuid(),
                    'trx_type' => $type,
                    'type' => 'acccount_' . $type . '_by_' . $set->site_name,
                    'status' => 'success',
                ];
                $trx = Transactions::create($object);
                createAudit('acccount_' . $type . '_by_' . $set->site_name . ' ' . $trx->ref_id, $this->client);
                $this->reset(['password']);
                $this->emit('closeDrawer');
                $this->emit('saved');
                $this->emit('success', __('Balance updated'));
            }
        } elseif (!Hash::check($this->password, $admin->password)) {
            $this->addError('password', 'Invalid password');
        }
    }

    public function declineKYC(){
        $this->client->business->update([
            'kyc_status' => 'RESUBMIT',
        ]);
        createAudit('Compliance resubmit, reason:'.$this->reason, $this->client);
        dispatch(new CustomEmail('compliance_resubmit', $this->client->id, $this->reason));
        $this->reset(['reason']);
        $this->emit('success', 'Kyc was successfully rejected');
        $this->emit('closeDeclineModal');
    }

    public function approveKYC()
    {
        $this->client->business->update([
            'kyc_status' => "APPROVED",
        ]);
        dispatch(new CustomEmail('compliance_approval', $this->client->id));
        createAudit('Compliance approved', $this->client);
        $this->emit('success', 'KYC Approved');
    }

    public function render()
    {
        return view('livewire.admin.users.details');
    }
}
