<?php

namespace App\Http\Livewire\Admin\Payout;

use Livewire\Component;
use App\Models\Transactions;
use App\Models\UserWithdraw;

class Header extends Component
{
    private $pending;
    private $success;
    private $declined;
    public $perPage = 200;
    public $type;
    public $admin;

    protected $listeners = ['saved' => '$refresh'];
    
    public function loadMore()
    {
        $this->perPage = $this->perPage + 10;
        $this->emit('drawer');
    }
    
    public function approve($id)
    {
        
        $userW = UserWithdraw::where('id', $id)->where('status', '0')->first();
        $balance = $userW->user->getFirstBalance();
        
        if ($userW) {
             $userW->update([
                'status' => '1',
             ]);
             
             $balance->update(['amount' => $balance->amount + $userW->amount]);
          
             
            $this->emit('success', 'Withdrawal approved');
            
            return redirect(request()->header('Referer'));
            
          } else {
          
             $this->emit('alert', 'Something went wrong');
          }
     }
     
     public function reject($id)
    {
        $userW = UserWithdraw::where('id', $id)->where('status', '0')->first();
        if ($userW) {
        
            $userW->delete();
             
            $this->emit('success', 'Withdrawal rejected');
            
            return redirect(request()->header('Referer'));
            
          } else {
          
             $this->emit('alert', 'Something went wrong');
          }
     }
        

    public function render()
    {
        $this->pending = Transactions::whereStatus('pending')->whereType('payout')->whereStatus('pending')->count();
        $this->success = Transactions::whereStatus('success')->whereType('payout')->whereStatus('success')->count();
        $this->declined = Transactions::whereStatus('declined')->whereType('payout')->whereStatus('declined')->count();
        
        $invest = UserWithdraw::where('status', '0');
        
        return view('livewire.admin.payout.header', [
            'pending' => $this->pending,
            'success' => $this->success,
            'declined' => $this->declined,
            'investW' => $invest->paginate($this->perPage),
        ]);
    }
}
