<?php

namespace App\Http\Livewire\Admin\Invest;

use Livewire\Component;
use App\Models\Plancategory;
use Carbon\Carbon;
use Illuminate\Support\Str;
use Livewire\WithFileUploads;
use App\Models\Plans;
use App\Models\CategoryAsset;
use App\Services\PolygonService;

class ProjectPlans extends Component
{

    use WithFileUploads;

    private $plans;
    private $categoryAll;
    public $search = "";
    public $category = "";
    public $perPage = 100;
    public $orderBy = "created_at";
    public $sortBy = "desc";
    public $admin;
    public $status = 1;
    public $insurance = 0;
    public $fee_type = 'percent';
    public $name;
    public $percent_pc;
    public $fiat_pc;
    public $price;
    public $units;
    public $interest;
    public $duration;
    public $location;
    public $min_buy;
    public $start_date;
    public $close_date;
    public $details = "";
    public $image;
    public $category_id;
    public $assets = [];
    public $asset_id;

    protected $listeners = ['saved' => '$refresh'];
    
    protected $polygon;
    
    protected $alphavantage;

    protected function getPolygon()
    {
       if (!$this->polygon) {
           $this->polygon = app(\App\Services\PolygonService::class);
       }
        return $this->polygon;
    }
    
    protected function getAlpha()
    {
       if (!$this->alphavantage) {
           $this->alphavantage = app(\App\Services\AlphaVantageService::class);
       }
        return $this->alphavantage;
    }
    
    public function updatedAssetId($value)
    {
          $rate = CategoryAsset::where('id', $this->asset_id)->first();
          $av = $this->getAlpha();
          $tprice = $av->getPriceByCategory($rate->ticker, $rate->market);
          
          $this->name = $tprice['ctitle'] ?? $rate->name;
          
          $this->price = $tprice['price'];
    }

    public function updatedCategoryId($value)
    {
    $this->assets = NULL;
    $this->price = NULL;
       $category = Plancategory::find($value);

        if (!$category) {
            $this->assets = [];
            return;
        }
        
        $polygon = $this->getPolygon();

        $fetchedAssets = $polygon->getAssetsByCategorySlug($category->slug);

        foreach ($fetchedAssets as $item) {
            CategoryAsset::updateOrCreate(
                [
                    'ticker'      => $item['ticker'],
                    'category_id' => $category->id,
                ],
                [
                    'name'              => $item['name'] ?? null,
                    'market'            => $item['market'] ?? null,
                    'locale'            => $item['locale'] ?? null,
                    'primary_exchange'  => $item['primary_exchange'] ?? null,
                    'type'              => $item['type'] ?? null,
                    'active'            => $item['active'] ?? false,
                    'currency_name'     => $item['currency_name'] ?? null,
                    'cik'               => $item['cik'] ?? null,
                    'composite_figi'    => $item['composite_figi'] ?? null,
                    'share_class_figi'  => $item['share_class_figi'] ?? null,
                    'last_updated_utc'  => isset($item['last_updated_utc']) ? Carbon::parse($item['last_updated_utc']) : null,
                    'raw'               => json_encode($item),
                ]
            );
        }

        // Load fresh list of assets for dropdown
        $this->assets   = CategoryAsset::where('category_id', $category->id)->get();
        $this->asset_id = null;
    }

    public function addPlan()
    {

        $this->validate([
            'status' => ['required'],
            'insurance' => ['required'],
            'fee_type' => ['required'],
            'fiat_pc' => ['nullable', 'integer'],
            'percent_pc' => ['nullable', 'numeric'],
            'price' => ['required'],
            'interest' => ['nullable', 'numeric'],
            'units' => ['required', 'integer'],
            'min_buy' => ['nullable', 'integer'],
            'duration' => ['nullable', 'integer'],
            'category_id' => ['required'],
            'asset_id' => ['nullable'],
            'name' => ['required', 'string', 'max:255'],
            'details' => ['required', 'string'],
            'location' => ['nullable', 'string'],
            'image' => 'required|file|mimes:jpeg,png,jpg,webp|max:1024',
            'start_date' => 'required|date_format:"Y-m-d"|before:close_date',
            'close_date' => 'required|date_format:"Y-m-d"|after:start_date',
        ]);

        $filePath = $this->image->storePublicly('invest');

        Plans::create([
            'name' =>  $this->name,
            'details' =>  $this->details,
            'slug' =>  Str::slug($this->name, '-'),
            'start_date' => Carbon::createFromFormat('Y-m-d', $this->start_date)->toDateString(),
            'close_date' => Carbon::createFromFormat('Y-m-d', $this->close_date)->toDateString(),
            'price' =>  $this->price,
            'duration' =>  $this->duration,
            'units' =>  $this->units,
            'min_buy' =>  $this->min_buy,
            'original' =>  $this->units,
            'interest' =>  $this->interest,
            'cat_id' =>  $this->category_id,
            'asset_id' => $this->asset_id,
            'location' =>  $this->location,
            'insurance' =>  $this->insurance,
            'fee_type' =>  $this->fee_type,
            'fiat_pc' =>  $this->fiat_pc,
            'percent_pc' =>  $this->percent_pc,
            'status' =>  $this->status,
            'image' => $filePath,
            'created_by' => $this->admin->id,
            'edited_by' => $this->admin->id,
             'expiring_date' => Carbon::createFromFormat('Y-m-d', $this->start_date)
                          ->addMonths(intval($this->duration))
                          ->toDateString(),
        ]);
        $this->reset(['name', 'details', 'category_id', 'asset_id', 'status', 'image', 'insurance', 'fee_type', 'fiat_pc', 'percent_pc', 'price', 'units', 'interest', 'duration', 'location', 'start_date', 'close_date']);
        $this->emit('saved');
        $this->emit('closeDrawer');
        $this->emit('success', 'Plan Created');
    }

    public function render()
    {
        $this->plans = \App\Models\Plans::whereType('project')->when($this->search, function ($query) {
                $this->emit('drawer');
                $query->where(function ($query) {
                    $query->Where('name', 'like', '%' . $this->search . '%')
                        ->orWhereRelation('category', 'name', 'like', '%' . $this->search . '%')
                        ->orWhere('location', 'like', '%' . $this->search . '%')
                        ->orWhere('details', 'like', '%' . $this->search . '%');
                });
            })
            ->when($this->search == null, function ($query) {
                $this->emit('searchdrawer');
            })
            ->when($this->category, function ($query) {
                return $query->whereCatId($this->category);
            })
            ->orderby($this->orderBy, $this->sortBy)
            ->paginate($this->perPage);
            $this->categoryAll = Plancategory::all();

        return view('livewire.admin.invest.project-plans', ['plans' => $this->plans, 'categoryAll' => $this->categoryAll, 'admin' => $this->admin]);
    }
}
