<?php

namespace App\Http\Livewire\Admin\Invest;

use Livewire\Component;
use App\Models\PlanTransaction;

class EditTransactions extends Component
{

    public $val;
    public $admin;
    public $type;
    public $name, $ttype, $positioneffect, $timeinforce, $quantity, $filledquantity, $limitprice, $totalcost, $fee, $remark, $signal;
    
    public function mount()
    {
    
    }
    
    public function createTrans()
    {
       
       $createnow = PlanTransaction::create([
           'plan_id' => $this->val->id,
           'name' => $this->name,
           'type' => $this->ttype,
           'position_effect' => $this->positioneffect,
           'time_in_force' => $this->timeinforce,
           'quantity' => $this->quantity,
           'filled_quantity' => $this->filledquantity,
           'limit_price' => $this->limitprice,
           'remark' => $this->remark,
           'total_cost' => $this->totalcost,
           'fee' => $this->fee,
           'signals' => $this->signal,
       ]);
       
       if($createnow)
       {
          $this->emit('success', 'Transaction created');
          return redirect()->to(request()->header('Referer'));
       }else{
          $this->emit('alert', 'Something went wrong');
       }
      
    }
    
    public function deleteTrans($id)
    {
      $trans = PlanTransaction::where('id', $id)->first();
      
      if ($trans) {
      $trans->delete();
      $this->emit('success', 'Transaction deleted');
      return redirect()->to(request()->header('Referer'));
      }else{
      $this->emit('alert', 'Something went wrong');
      }
    }
    
    public function render()
    {
        return view('livewire.admin.invest.edit-transactions');
    }
}
