<?php

namespace App\Http\Livewire\Admin\Blog;

use Livewire\Component;
use App\Models\Blog;
use App\Models\Category;

class Articles extends Component
{
    private $articles;
    private $categoryAll;
    public $search = "";
    public $category = "";
    public $perPage = 100;
    public $orderBy = "created_at";
    public $sortBy = "desc";
    public $admin;

    protected $listeners = ['saved' => '$refresh'];

    public function render()
    {
        $this->articles = Blog::whereStatus(1)
            ->when($this->search, function ($query) {
                $this->emit('drawer');
                $query->where(function ($query) {
                    $query->Where('title', 'like', '%' . $this->search . '%')
                        ->orWhereRelation('category', 'name', 'like', '%' . $this->search . '%')
                        ->orWhere('details', 'like', '%' . $this->search . '%');
                });
            })
            ->when($this->search == null, function ($query) {
                $this->emit('searchdrawer');
            })
            ->when($this->category, function ($query) {
                return $query->whereCatId($this->category);
            })
            ->orderby($this->orderBy, $this->sortBy)
            ->paginate($this->perPage);
            $this->categoryAll = Category::all();

        return view('livewire.admin.blog.articles', ['articles' => $this->articles, 'categoryAll' => $this->categoryAll, 'admin' => $this->admin]);
    }
}
