<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Carbon\Carbon;
use App\Models\Transactions;
use App\Models\Plans;
use App\Models\Followed;
use App\Models\Settings;
use Illuminate\Support\Str;
use App\Jobs\CustomEmail;
use App\Jobs\SendEmail;

class UpdateTransactions extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'update:transactions';
    protected $settings;

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Update Transaction';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
        $this->settings = Settings::find(1);
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        //Pending Deposit of Payment Gateways
        foreach (Transactions::whereStatus('pending')->whereType('deposit')->get() as $val) {
            if ($val->gateway->type == 0) {
                $diff = Carbon::parse($val->created_at)->diffInHours(Carbon::now());
                if ($diff > 1 || $diff == 1) {
                    $val->status = 'failed';
                    $val->save();
                }
            }
        }
        $this->info('Failed Deposit updated!!!');

        //Investment Returns
        foreach (Followed::whereStatus('pending')->whereRelation('plan', 'type', '=', 'project')->get() as $val) {
            if (Carbon::today() > $val->plan->expiring_date) {
                $val->update(['status' => 'success']);
                $balance = $val->user->getFirstBalance();
                $balance->update(['amount' => $balance->amount + $val->amount + ($val->amount * $val->plan->interest / 100)]);

                $trx = Transactions::create([
                    'user_id' => $val->user->id,
                    'profit_id' => $val->id,
                    'business_id' => $val->user->business_id,
                    'amount' => $val->amount + ($val->amount * $val->plan->interest / 100),
                    'ref_id' => Str::uuid(),
                    'trx_type' => 'credit',
                    'type' => 'investment_returns',
                    'status' => 'success',
                ]);

                dispatch(new CustomEmail('investment_returns', $trx->id));

                $notification = notifyUser('Investment has ended', 'Profit from ' . $val->plan->name . ' has been credited to your account.', null, null, 'general');
                $val->user->notify($notification);
            }
        }
        $this->info('Investment updated!!!');

        //Send Reminder
        foreach (Plans::whereType('mutual')->get() as $val) {
            if ($val->priceHistory->last()->date->diffInDays() <= 3 && $val->priceHistory->last()->date >= Carbon::today() && $val->reminded == 0) {
                $val->update(['reminded' => 1]);
                dispatch(new SendEmail($this->settings->email, $this->settings->site_name, 'Update Price History', $val->name . ' needs more units to be ahead, else it will be hidden from new customers and old customers will be unable to sell units at latest rates', null, null, 0));
            }
        }
        $this->info('Reminder updated!!!');
    }
}
